<?php 

    use Dotenv\Dotenv;
    use Embryo\Application as App;
    use Embryo\Facade;

    /*
    |--------------------------------------------------------------------------
    | DOTENV
    |--------------------------------------------------------------------------
    */

    $dotenv = new Dotenv(root_path());
    $dotenv->load();

    /*
    |--------------------------------------------------------------------------
    | SETTINGS
    |--------------------------------------------------------------------------
    */
    
    $settings = require_once root_path('bootstrap/settings.php');

    /*
    |--------------------------------------------------------------------------
    | APPLICATION
    |--------------------------------------------------------------------------
    */

    $app = new App($settings);

    /*
    |--------------------------------------------------------------------------
    | IMPORT SERVICES, MIDDLEWARES AND ROUTES
    |--------------------------------------------------------------------------
    */

    $app->import([
        root_path('bootstrap/services.php'),
        root_path('bootstrap/middleware.php'),
        root_path('routes/api.php'),
        root_path('routes/app.php')
    ]);

    /*
    |--------------------------------------------------------------------------
    | RUN APPLICATION
    |--------------------------------------------------------------------------
    */

    return $app;