# 4.1 低秩分解

图还没有来得及画

## 4.1.1 低秩分解的基本原理与理念&emsp;&emsp;

​		在训练神经网络中的全连接层（即“稠密”层，Fully Connected Layer）时，权重矩阵通常具有完整秩（full rank）。完整秩是一个技术术语，表示矩阵的行或列之间没有线性相关（即“冗余”）关系。换句话说，每一行或列都是独立的，就像一群独立思考、各自作答的学生，谁也不抄谁的答案。

​		在深度学习中，权重矩阵通常具有完整秩，这意味着每个权重在模型中都有独特的作用，彼此不重叠。这样的权重矩阵能够充分表达模型的复杂性和丰富的特征表示能力。完整秩的权重矩阵就像一支高效的团队，每个人都各司其职，合作无间。在这种情况下，模型可以通过学习到的权重进行准确的预测和分类。每个权重都对模型的输出产生影响，没有冗余信息，就像团队中的每个人都在贡献自己的独特才华。

​		然而，理想与现实之间往往存在差距。在某些情况下，完整秩的权重矩阵可能会引发一些问题。例如，当训练数据量较少或数据噪声较多时，权重矩阵可能会导致过拟合，像是一个聪明过头的学生，考试时把不重要的细节也都记住了，但一旦题目变了就懵了。此外，权重矩阵中的大量参数可能会导致计算和存储的开销猛增，就像搬家时东西太多，搬运费随之上涨。

​		于是，在追求参数效率的研究中，人们开始关注如何利用低秩矩阵来表示权重矩阵。低秩矩阵意味着我们可以去除一些冗余信息，只保留那些最关键的部分。这样一来，我们可以减少参数数量，降低计算和存储的开销，同时保留大部分原始权重矩阵的重要信息。就像搬家时，只带上最必要的物品，不仅轻松，还节省费用。

​		尽管预训练模型的权重在预训练任务中具有完整秩，但当预训练的大型语言模型适应新任务时，其固有维度实际上很低。换句话说，微调后的权重矩阵相比原始模型，实际使用到的权重非常少，就像是一支球队里，真正踢球的只有几名核心球员，其他人都在旁边加油。

​		低秩维度意味着数据可以通过较低维度的空间有效表示或近似，同时保留其大部分重要信息或结构。换句话说，我们可以将适应新任务的权重矩阵分解为较低维度（较小）的矩阵，而不会丢失太多重要信息。这就像是从一大堆文件中挑出几页重要的内容，不仅便于携带，还能快速找到关键信息。

​		总之，通过使用低秩分解，我们可以在保持模型性能的同时，提高计算效率和模型的可解释性。正如生活中一样，有时候，精简和优化比一味地追求全面更能带来高效和成功。

## 4.1.2 低秩分解的意义

​		低秩分解不仅仅是个数学技巧，它在实际应用中有着非常重要的意义。想象一下，你有一张复杂的大拼图，但发现其中很多片其实都长得差不多，这时你就可以把这些类似的拼图片归类，只留下最具代表性的几片，这样不仅能更快地完成拼图，还能节省空间。同样，在大语言模型中，低秩分解让我们可以用较少的参数来表示复杂的模型，大幅提升计算效率。

​		使用低秩分解还能让模型变得更加灵活和易于调整。就像是在厨房里做饭，如果你有一套万能调料组合，那么无论是做中餐还是西餐，都能轻松应对。而通过低秩分解，我们可以将权重矩阵分解成更小的子矩阵，这些子矩阵可以根据不同任务进行调整和优化，从而提高模型的适应能力。

​		此外，低秩分解还可以帮助我们更好地理解和解释模型的行为。正如一部好电影，不仅要有精彩的剧情，还需要有条理的叙述结构。低秩分解通过简化权重矩阵，帮助我们更清晰地看到哪些特征是关键因素，哪些是次要的，从而提升模型的可解释性。

​		通过低秩分解，我们不仅能在保持模型性能的同时大幅度减少计算资源，还能让模型更易于理解和调整。这就像是在科技和艺术之间搭建了一座桥梁，让我们在追求技术创新的同时，也能享受到艺术般的优雅与简洁。

## 4.1.3 低秩分解的分类（变体与原理讲解）

​		低秩分解有多个分类，它们在原理和应用上有所不同，就像是烹饪世界里的各种调味料，每一种都有着自己独特的风味和用途。

 

**LoRA（Low-Rank Adaptation）**

​		LoRA是低秩分解领域的开山鼻祖，就像是祖传秘方一样，是大厨们从头开始摸索出来的。它的原理很简单：将原始的权重矩阵分解成较低维度的子矩阵，从而减少参数数量，提高计算效率。LoRA就像是烹饪中的“万能调料”，能够适应各种不同的场景，是很多后来者的基石。

 

**QLoRA（Quantized Low-Rank Adaptation）**

​		QLoRA在LoRA的基础上进行了进一步的改进，就像是在原本的“万能调料”里添加了一些特别的香料。它的特点是将权重矩阵进行量化，即将连续的数值转化为离散的值，从而减少了存储和计算的开销。这就好比是在调料里添加了“速溶”的成分，既省事又方便。

 

**QA-LoRA（Quantization-Aware Low-Rank Adaptation）**

​		QA-LoRA则是在QLoRA的基础上进行了进一步的探索，就像是在料理中加入了更多的新鲜食材。它考虑到了量化对模型性能的影响，并通过一些特殊的技巧来保证量化后的模型依然能够保持良好的性能。这就好比是在烹饪中同时考虑到了美味和营养，做出了更加完美平衡的菜肴。

 

**Delta-tuning**

​		Delta-tuning是一种特殊的低秩分解方法，它的原理是通过计算权重的变化量来进行模型调整，就像是在烹饪中不断调整火候和调味一样。这种方法能够让模型更加灵活地适应不同的数据和任务，提高了模型的适应性和泛化能力。

 

**DoRA（Weight-Decomposed Low-Rank Adaptation）**

​		DoRA是一种基于权重分解的低秩分解方法，它的原理是将原始的权重矩阵分解成多个子矩阵，每个子矩阵都只包含部分权重信息，从而降低了模型的复杂度和计算开销。这就好比是在烹饪中将复杂的食材分解成简单的组合，更易于加工和处理。

 

**MTLoRA（Matrix-Transformation Based Low-Rank Adaptation）**

​		MTLoRA是一种基于矩阵变换的低秩分解方法，它的原理是通过一些特殊的矩阵变换操作来降低权重矩阵的维度，从而实现模型参数的压缩和优化。这就好比是在烹饪中通过一些巧妙的手法将食材变换成更加美味的菜肴，提升了模型的表现和效率。

 

**AFLoRA（Adaptive Freezing of Low Rank Adaptation）**

​		AFLoRA则是一种自适应冻结的低秩分解方法，它的原理是根据模型的训练过程动态地调整低秩分解的参数，从而提高模型在不同阶段的性能和稳定性。这就好比是在烹饪中根据不同的季节和食材来调整菜单，让每一道菜都能够尽显风味。

 

**MoLE（the Mixture of LoRA Experts）**

​		MoLE则是一种专门混合的低秩分解方法，它的原理是将多个不同维度的低秩模型进行混合，从而提高了模型的表现和鲁棒性。这就好比是在烹饪中将多种不同口味的调料混合在一起，制作出更加丰富多样的美食。

 

​		低秩分解就像是烹饪世界里的各种调味料，每一种都有着自己独特的风味和用途。无论是LoRA、QLoRA还是其他的分解方法，它们都在不同的领域和任务中发挥着重要的作用，为模型的优化和提升带来了无穷的可能性。就像是一场美食盛宴，让我们一起品味低秩分解的美妙之处吧！



## 参考文献

Zhu, Xunyu, et al. "A survey on model compression for large language models." *arXiv preprint arXiv:2308.07633* (2023).

Kaushal, Ayush, Tejas Vaidhya, and Irina Rish. "Lord: Low rank decomposition of monolingual code llms for one-shot compression." *arXiv preprint arXiv:2309.14021* (2023).
