# 3.4 剪枝总结

## 3.4.1 剪枝现状

&emsp;&emsp;剪枝作为神经网络模型压缩的关键技术，剪枝的理想状态是在消除模型中不必要的权重的同时，还保持了几乎相当于原始状态的网络性能。由于LLM参数较多，微调成本较高，更难达到剪枝的全部效果。剪枝方法可大致分为非结构化剪枝和结构化剪枝。非结构化剪枝涉及删除不相关的参数而不考虑模型的结构。本质上，非结构化剪枝将低于特定阈值的参数设置为零，从而有效消除其影响。这会产生稀疏模型，其中零和非零权重随机分布。另一方面，结构化修剪涉及删除模型的整个部分，例如神经元、通道或层。结构化剪枝的优点是简化模型压缩并提高硬件效率。例如，删除整个层可以降低模型的计算复杂性，而不会在模型结构中引入不规则性。

&emsp;&emsp;**迭代/一次性剪枝。** 流行的剪枝流程范例由三个步骤组成：训练、剪枝和微调。由于在微调过程中，有可能将最初的零值权重变为非零，所以一般情况下剪枝和微调两个步骤需要迭代重复，直到达到目标稀疏率。这种迭代设计强调了每个修剪步骤都是由微调步骤完成的，从而有利于保持模型的性能。这些包含迭代剪枝和微调轮次的方法被归类为迭代剪枝。随着LLM参数变得越来越大，迭代剪枝和微调过程操作代价巨大。因此，更多的剪枝方法倾向于仅将网络剪枝一次以达到目标稀疏率，从而放弃迭代剪枝和微调轮次。这些方法被归类为一次性剪枝。

&emsp;&emsp;**全局/局部修剪。** 早期修剪方法会比较所有修剪单元，以识别并消除那些不太重要的修剪单元。鉴于这些方法的比较范围涵盖整个网络，因此它们被归类为全局剪枝方法。然而，全局修剪允许各个局部区域具有不同的稀疏率。它可能会导致特定区域（例如层、列）的过度修剪，并对模型的整体性能产生显着影响。这个问题的解决在于局部剪枝方法的应用。局部剪枝对每个区域的稀疏度施加约束，从而确保每个区域内的稀疏度比率不会达到过低的阈值，从而降低模型崩溃的风险。

&emsp;&emsp;两种开创性的非结构化修剪方法LLMs是[SparseGPT](https://arxiv.org/abs/2301.00774)和[Wanda](https://arxiv.org/abs/2306.11695)，它们成为许多后续方法进行比较的基线。Shao 等人结合了OBS和OBD的显著性标准，定义了一个更全面的显著性标准[ISC](https://arxiv.org/abs/2310.09499)，以更精确地确定剪枝目标。 ISC能够在不进行重训练的情况下有效地识别并剪除那些对模型性能影响较小的权重元素。这种方法允许在保持模型整体性能的同时，实现至少50%的模型稀疏度，从而显著减少模型的存储需求和推理延迟，同时与量化技术兼容，进一步提升模型压缩效果。与[Wanda](https://arxiv.org/abs/2306.11695)类似，Zhang等人提出了一种新的剪枝度量[RIA](https://openreview.net/forum?id=Tr0lPx9woF)，可以有效地考虑 LLMs上的权重和激活。RIA 用相对重要性取代了权重的大小。该相对重要性的计算方法为各个权重的大小除以相应行和列中权重大小的总和。RIA 可以进一步与通道排列相结合，在 N:M 稀疏性下最大限度地保留重要权重，从而在特定硬件上获得实际的加速。除了 Wanda 和 RIA 那样的权重和激活的大小之外，Li等人提出了一种新的剪枝度量[E-Sparse](https://arxiv.org/abs/2310.15929)，引入信息熵以增强参数权重和输入特征规范的重要性，并在不改变剩余权重的情况下进行N：M稀疏性。利用熵作为信息丰富度的度量，值越高表示信息越丰富。并且还设计了全局朴素洗牌和局部块洗牌，以快速优化信息分布。

&emsp;&emsp;与非结构化剪枝相比，结构化剪枝不受硬件限制，可以在剪枝过程之后在传统硬件上实现推理加速。然而，由于网络结构的改变，这些方法可能比非结构化方法导致更多的性能下降，需要微调过程来恢复性能。LLM-Pruner是LLM结构化剪枝的开创性方法。类似于LLM-Pruner，[LoRAShear](https://arxiv.org/abs/2310.18356)首先创建 LoRA 模块上的依赖图，发现最小可移除结构并分析知识分布。然后通过 LoRA 适配器进行逐步结构化剪枝，并启用固有知识转移，以更好地保留冗余结构中的信息。为了恢复剪枝过程中丢失的知识，LoRAShear 提出了动态微调方案和动态数据适配器，通过多阶段微调来恢复剪枝过程中丢失的通用知识和特定领域的专业知识,有效缩小了与完整模型的性能差距。[Sheared LLaMA](https://arxiv.org/abs/2310.06694)使用结构化剪枝手段从预训练的大型模型中开发更小型的LLMs。提出了两种关键技术：(1) 目标化结构化剪枝：将剪枝视为一个受约束的优化问题，通过正则化方法学习剪枝掩码，以找到与目标架构匹配的子网络，同时最大化性能。(2)动态批量加载：根据损失减少率动态调整每个训练批次中不同领域数据的组成，提高数据使用效率并加速整体性能提升。Guo等人提出了一种新的LLM剪枝范式[Compresso](https://arxiv.org/abs/2310.05015)，通过资源高效的剪枝算法与目标LLM的协作学习最优剪枝决策。Compresso通过在指令调整过程中引入低秩适应（LoRA）到L0正则化，并使用指令调整数据集作为替代训练数据，解决了训练成本和数据收集的挑战。通过引入协作提示，增强了LLM与剪枝算法之间的协作，显著提升了整体性能。Compresso的核心在于它将LLM视为剪枝过程中的一个协作伙伴，而非被动对象，通过引入一个专门的协作提示，指导LLM理解并适应剪枝过程，从而在保持模型性能的同时实现模型尺寸的显著缩减。
 

&emsp;&emsp;此外，有些工作还将剪枝技术与其他压缩技术相结合。剪枝算法与量化技术的结合使用是一种常见的做法，例如之前提到的SparseGPT、Wanda等算法。它们可以共同作用以减小模型的大小和提高推理速度，同时尽量保持模型性能。此外，Muralidharan等人提出了一种压缩大型语言模型（LLMs）的[新方法](https://arxiv.org/abs/2407.14679)。通过对现有模型进行剪枝（pruning）和知识蒸馏（knowledge distillation）来生成更小规模的模型，同时保持高效的性能。主要通过两个步骤实现：首先是剪枝，即通过评估模型中各个组件的重要性，有选择地移除一部分神经元、注意力头、嵌入通道甚至是整个层，以此减小模型规模；其次是知识蒸馏，这是一种重训练技术，通过将压缩后的模型（学生模型）去模仿一个未压缩的、性能更优的模型（教师模型）的输出，以此来恢复剪枝过程中可能损失的准确性。

## 3.4.2 未来工作

&emsp;&emsp;大模型剪枝面临的挑战主要包括如何在压缩模型的同时保持或恢复模型性能。剪枝策略的关键在于如何识别有效权重以及如何有效恢复性能。目前，非结构化剪枝通过删除权重或神经元实现简化，但可能导致模型结构不规则，增加后续处理复杂性，并且需要大量重新训练来恢复准确性，这在大型语言模型（LLMs）中尤其昂贵。结构化剪枝则通过删除特定结构组件来精简模型，但剪枝后的模型可能会出现性能下降，尤其是在没有大量计算资源进行再训练的情况下。大模型剪枝的未来工作可能会集中在开发更高效的剪枝算法，例如与其他方法的集成，增强剪枝方法的内在有效性，减少对计算资源的依赖，同时探索新的模型结构和训练方法，解决无法执行全面微调的挑战，以实现更好的性能恢复和模型压缩。

## 参考文献

- [Model Compression and Efficient Inference for Large Language Models: A Survey](https://arxiv.org/abs/2402.09748)