# 知识蒸馏的思想


先训练一个大的网络模型（Teacher Network），再根据该网络模型来训练小的网络模型（Student Network）。教师网络较大且臃肿，可能是多个网络的集成，同时也包含了很多信息。知识蒸馏的具体学习方法是：学生网络将教师网络的输出结果当成正确答案来训练，而网络剪枝主要通过剪掉参数或神经元来压缩网络，这也是网络剪枝与知识蒸馏方法的区别所在。该方法的好处是，教师网络的输出结果对于小网络模型来说更容易学习；一些没有用于学生网络训练而用于教师网络训练的样本依然可以很好地被学生网络识别出来。

![](images/Figure%202.png)

之所以要进行知识蒸馏，因为大部分人工智能算法都很大，教师网络一般是用海量数据与资源训练出来的，而真正落地运用的终端的算力却非常有限，如智能手表、手机、移动端、IoT设备、无人驾驶汽车等，因此需要进行知识蒸馏。

知识蒸馏的技巧：在softmax函数上加入temperature

Softmax函数：
$$
y_i = \frac{exp(y_i)}{\sum_i exp(y_i)}
$$
该函数将网络的最终输出变成一个介于0到1的概率的分布。

加入温度后的softmax函数
$$
y_i' = \frac{exp(y_i / T)}{\sum_i exp(y_i / T)}
$$
其中，$T$ 表示温度（Temperature）。新的函数会使得网络新输出的结果比起原结果更平滑、更接近，学生网络可以学习到更相近的输出值，有利于学生网络的学习。

![图片来自同济子豪兄视频](images/Figure%203.png)


# LLM的知识蒸馏

自2017年起，在自然语言处理领域，预训练大模型的参数规模呈指数级别增长，但终端场景的算力比较有限。目前来说，要想调用大模型的功能，需要先把大模型部署到云端或某个数据中心，再通过API远程访问。这种方法会导致网络延迟、依附网络才能应用模型等问题的存在，因此轻量化神经网络具有必要性。模型压缩可以将大型、资源密集型模型转换为适合存储在受限移动设备上的紧凑版本。此外它可以优化模型，以最小的延迟更快地执行，或实现这些目标之间的平衡。

轻量化神经网络分为四个主要的技术路线：

- 压缩已经训练好的大的模型，如知识蒸馏、权值量化、网络剪枝（包括权重剪枝和通道剪枝）、注意力迁移等；
- 直接训练轻量化网络，如squeezeNet, MobileNet, Mnasnet, ShuffleNet, Xception, EfficientNet等；
- 通过一些数值方法加速卷积运算，常用加速方法包括winograd卷积、低秩分解等；
- 硬件部署。衡量一个轻量化网络是否足够好有以下一些角度：参数量、计算量、内存访问量、耗时、能耗等。因而知识蒸馏属于上述的第一种方法。

![](images/Figure%204.png)

当使用LLM作为教师网络时，根据是否强调将LLM的涌现能力（Emergent Abilities, EA）蒸馏到小型语言模型中来进行分类，可以把知识蒸馏分为两类：标准知识蒸馏（Standard KD）和基于涌现能力的知识蒸馏（EA-based KD）。

    涌现能力是指在较小的模型中不出现，而在较大的模型中出现的能力，则可以称之为“涌现能力“, 这种现象也叫做规模效应；
    比如与 BERT（330M）和 GPT-2（1.5B）等较小模型相比，GPT-3（175B）和 PaLM（540B）等 LLM 展示了独特的行为，这些LLM在处理复杂的任务时表现出令人惊讶的能力。
    (An ability is emergent if it is not present in smaller models but is present in larger models.)。

标准知识蒸馏旨在使学生模型学习LLM所拥有的常见知识，如输出分布和特征信息。这种方法类似于传统的知识蒸馏，但区别在于教师模型是LLM。相比之下，基于涌现能力的知识蒸馏不仅仅是将LLM的常见知识转移到学生模型中，还涵盖了蒸馏它们独特的涌现能力。具体来说，基于涌现能力的知识蒸馏又分为了上下文学习（ICL）、思维链（CoT）和指令跟随（IF）。

![](images/Figure%205.png)

有关分类模型的蒸馏、小模型蒸馏的开源项目可以参考：
https://github.com/datawhalechina/awesome-compression/blob/main/docs/ch06/ch06.md

根据蒸馏方法可以把知识蒸馏分为两类：一种是白盒蒸馏，教师模型一般是内部可见的模型，学生可以学习教师输出时的内部信息（logits等）来学习输出策略；另一种是黑盒知识蒸馏(Black-box KD)，教师模型只有输出内容可见，因此这种蒸馏则会把学习的重点放在教师输出的内容和输出的特殊行为上，比如学习CoT等涌现能力。不论哪一种蒸馏，都是将大模型知识注入小模型的方式。

![](images/Figure%206.png)

# 前置知识
了解以下知识有助于接下来的学习：
1. logits 和 软目标
2. 监督微调（SFT技术）


参考文献： 

[1] Knowledge Distillation [https://arxiv.org/pdf/1503.02531.pdf]

[2] Do Deep Nets Really Need to be Deep? [https://arxiv.org/pdf.1312.6184.pdf]

[3] A Servey on Model Compression for Large Language Models [https://arxiv.org/pdf/2308.07633.pdf] 