

# 计算机网络

## 知识体系

![](https://i.loli.net/2021/03/10/r4kCcHFAiOoDmd3.gif)

## Questions

### 1.计算机网络分层的优点和缺点

* 优点
  * 各层之间是独立的；
  * 灵活性好；
  * 结构上可分割开；
  * 易于实现和维护；
  * 能促进标准化工作。
* 缺点：
  * 降低效率；
  * 有些功能会在不同的层次中重复出现，因而产生了额外开销。

### 2.计算机体系结构

![](https://i.loli.net/2021/03/12/hpfczavIN871dL6.png)

### 3.从输入网址到获得页面的过程

1. 浏览器解析URL，查询 DNS，检查域名是否在缓存中（浏览器自身的DNS缓存、操作系统的DNS缓存、本地的hosts文件和向本地DNS服务器进行查询）。如果 DNS 服务器和主机在同一个子网内，系统会按照 ARP 过程对 DNS 服务器进行 ARP查询，如果在不同的子网，系统会按照 ARP 过程对默认网关进行查询；
2. 浏览器获得域名对应的IP地址以后，向服务器请求建立链接，发起三次握手；
3. TCP/IP链接建立起来后，浏览器向服务器发送HTTP请求；
4. 服务器接收到这个请求，并根据路径参数映射到特定的请求处理器进行处理，并将处理结果及相应的视图返回给浏览器；
5. 浏览器对HTML、CSS、JS进行解析，构建DOM树，渲染视图；
6. 浏览器根据其请求到的资源、数据渲染页面，最终向用户呈现一个完整的页面。

[超详细版本1](https://github.com/skyline75489/what-happens-when-zh_CN)

[超详细版本2](https://segmentfault.com/a/1190000006879700)

### 4.三次握手

* TCP 建立连接的过程叫做**握手**。
* 握手需要在客户和服务器之间交换三个TCP报文段，称之为三报文握手**;**
* 采用三报文握手主要是为了防止已失效的连接请求报文段突然又传送到了，因而产生错误。

#### 为什么需要三次握手

> ​		TCP 建立连接时通过三次握手可以有效地避免历史错误连接的建立，减少通信双方不必要的资源消耗，三次握手能够帮助通信双方获取初始化序列号，它们能够保证数据包传输的不重不丢，还能保证它们的传输顺序，不会因为网络传输的问题发生混乱。
>
> * 两次握手：无法避免历史错误连接的初始化，浪费接收方的资源；
> * 四次握手：TCP 协议的设计可以让我们同时传递 `ACK` 和 `SYN` 两个控制信息，减少了通信次数，所以不需要使用更多的通信次数传输相同的信息。

![image-20210226164259010.png](https://i.loli.net/2021/03/10/ZGXRKOaj7Wxzs2p.png)

![](https://i.loli.net/2021/03/10/Woin6Xqkbj259Pf.png)

* 第一次握手

![](https://i.loli.net/2021/03/10/Ln1E65xVDuwcUHS.png)

* 第二次握手

![](https://i.loli.net/2021/03/10/8xhdkOwJaWEBRUu.png)

* 第三次握手

![](https://i.loli.net/2021/03/10/a7jyZsrhOKPiVL3.png)

![](https://i.loli.net/2021/03/10/s62ZLCtQXVgSPHk.png)

![](https://i.loli.net/2021/03/10/F3iblcJvD8YTPQI.png)

### 5.四次挥手

#### 为什么需要四次挥手

> ​		因为当服务端收到客户端的SYN连接请求报文后，可以直接发送SYN+ACK报文。其中ACK报文是用来应答的，SYN报文是用来同步的。但是关闭连接时，当服务端收到FIN报文时，很可能并不会立即关闭SOCKET，所以只能先回复一个ACK报文，告诉客户端，"你发的FIN报文我收到了"。只有等到我服务端所有的报文都发送完了，我才能发送FIN报文，因此不能一起发送。故需要四次挥手。

* 第一次挥手

![](https://i.loli.net/2021/03/10/dM1rBt5fqblzHcL.png)

* 第二次挥手

![](https://i.loli.net/2021/03/10/WMlSqjukUtpbZzr.png)

* 第三次挥手

![](https://i.loli.net/2021/03/10/nr6Vv3AeJHRNIGX.png)

* 第四次挥手

![](https://i.loli.net/2021/03/10/m7ht9eKsI4ZzWQT.png)

![](https://i.loli.net/2021/03/10/hDAObXlavYiRPC8.png)

![](https://i.loli.net/2021/03/10/62ceNEwKJf1TsGV.png)

### 6.TCP和UDP的区别

**TCP**：

* 面向连接的协议，提供面向连接服务；
* 面向报文，其传送的运输协议数据单元TPDU是 TCP报文；
* 支持点对点单播，不支持多播、广播；
* 可靠传输，使用流量控制和拥塞控制；
* 复杂，用于大多数应用。如：万维网、电子邮件、文件传输等。

**UDP**：

* 无连接的协议，提供无连接服务；
* 面向字节流，其传送的运输协议数据单元TPDU是 UDP报文或用户数据报；
* 支持单播、多播、广播；
* 不可靠传输，不使用流量控制和拥塞控制；
* 简单，适用于很多应用。如：多媒体应用等。

### 7.TCP如何保证可靠传输

* 应用数据被分割成 TCP 认为最适合发送的数据块；
* TCP 给发送的每一个包进行编号，接收方对数据包进行排序，把有序数据传送给应用层；
* **校验和：**TCP 将保持它首部和数据的检验和。这是一个端到端的检验和，目的是检测数据在传输过程中的任何变化。如果收到段的检验和有差错，TCP 将丢弃这个报文段和不确认收到此报文段；
* TCP 的接收端会丢弃重复的数据；
* **流量控制：**TCP 连接的每一方都有固定大小的缓冲空间，TCP的接收端只允许发送端发送接收端缓冲区能接纳的数据。当接收方来不及处理发送方的数据，能提示发送方降低发送的速率，防止包丢失。TCP 使用的流量控制协议是可变大小的滑动窗口协议；（TCP 利用滑动窗口实现流量控制）
* **拥塞控制：**当网络拥塞时，减少数据的发送；
* **ARQ协议：**也是为了实现可靠传输的，它的基本原理就是每发完一个分组就停止发送，等待对方确认。在收到确认后再发下一个分组；
* **超时重传：**当 TCP 发出一个段后，它启动一个定时器，等待目的端确认收到这个报文段。如果不能及时收到一个确认，将重发这个报文段。

### 8.TCP流量控制

​		TCP使用滑动窗口协议（连续ARQ协议）实现流量控制。滑动窗口协议既保证了分组无差错、有序接收，也实现了流量控制。主要的方式就是接收方返回的 ACK 中会包含自己的接收窗口的大小，并且利用大小来控制发送方的数据发送。发送窗口的大小不能超过接受窗口的大小，只有当发送方发送并收到确认之后，才能将发送窗口右移。发送窗口的上限为接受窗口和拥塞窗口中的较小值。接受窗口表明了接收方的接收能力，拥塞窗口表明了网络的传送能力。

### 9.TCP拥塞控制

* 慢开始

  * 刚开始发送数据时，先把拥塞窗口cwnd（congestion window）设置为一个最大报文段MSS的数值，每收到一个新的确认报文之后，可以把拥塞窗口增加最多一个 SMSS 的数值。这样每经过一个传输轮次（或者说是每经过一个往返时间RTT），拥塞窗口的大小就会加倍。

    ![](https://i.loli.net/2021/03/12/lpe2o7CVsbJaNj1.png)

* 拥塞避免

  * 当拥塞窗口的大小达到慢开始门限(slow start threshold)时，开始执行拥塞避免算法，让拥塞窗口cwnd缓慢地增大，避免出现拥塞，每经过一个传输轮次，拥塞窗口加一，使其按线性规律缓慢增大。

  ![](https://i.loli.net/2021/03/12/HgaMwBY7y6vskiZ.png)

* 快重传

  * 发送方只要一连收到三个重复确认，就知道接收方确实没有收到报文段，因而应当立即进行重传（即快重传），这样就不会出现超时，发送方也不就会误认为出现了网络拥塞。使用快重传可以使整个网络的吞吐量提高约20%。

  ![](https://i.loli.net/2021/03/12/iOW3JSVly2BaEQt.png)

* 快恢复

  * 当发送端收到连续三个重复的确认时，由于发送方现在认为网络很可能没有发生拥塞，因此现在不执行慢开始算法，而是执行快恢复算法FR (Fast Recovery)算法：

    1.慢开始门限ssthresh=当前拥塞窗口cwnd / 2 ；

    2.新拥塞窗口cwnd=慢开始门限ssthresh；

    3.开始执行拥塞避免算法，使拥塞窗口缓慢地线性增大。

### 10.Session与Cookie

**Cookie**：

​		Cookie是服务器发送到用户浏览器并保存在本地的一小块数据，它会在浏览器下次向同一服务器再发起请求时被携带并发送到服务器上。通常，它用于告知服务端两个请求是否来自同一浏览器，如保持用户的登录状态。Cookie 使基于无状态的 HTTP 协议记录稳定的状态信息成为了可能。

**Session**：

​		Session 代表着服务器和客户端一次会话的过程。Session 对象存储特定用户会话所需的属性及配置信息。这样，当用户在应用程序的 Web 页之间跳转时，存储在 Session 对象中的变量将不会丢失，而是在整个用户会话中一直存在下去。当客户端关闭会话，或者 Session 超时失效时会话结束。

**区别**：

* 作用范围不同，Cookie 保存在客户端（浏览器），Session 保存在服务器端；
* 存取方式不同，Cookie 只能保存 ASCII，Session 可以存任意数据类型；
* 有效期不同，Cookie 可设置为长时间保持，Session 一般失效时间较短，客户端关闭或者 Session 超时都会失效；
* 隐私策略不同，Cookie 存储在客户端，比较容易遭到不法获取，Session 存储在服务端，安全性相对 Cookie 要好一些；
* 存储大小不同， 单个 Cookie 保存的数据不能超过 4K，Session 可存储数据远高于 Cookie。

### 11.HTTP状态码

* 2xx状态码：操作成功。200 OK；

* 3xx状态码：重定向。301 永久重定向；302暂时重定向；
* 4xx状态码：客户端错误。400 Bad Request；401 Unauthorized；403 Forbidden；404 Not Found；
* 5xx状态码：服务端错误。500服务器内部错误；501服务不可用；

### 12.HTTP报文

HTTP报文有请求报文和响应报文两种，请求报文：从客户向服务器发送请求报文；响应报文：从服务端到客户的回答。HTTP报文都由**开始行、首部行、实体主体**三部分组成。

* **开始行**
  * 请求报文
    * 由 **方法**、**[空格]**、**URL**、**[空格]**、**HTTP版本** 组成。
  * 响应报文
    * 由 **HTTP 版本**、**[空格]**、**状态码**组成。
* **首部行**
  * 是用来说明浏览器、服务器或报文主体的一些信息。
  * 可以有好几行，也可以不使用
  * 每个首部行都是由 **首部字段名**、**[空格]** 和 **值** 组成
  * 每个首部行在结束地方都有 `CRLF`（『回车』和『换行』符）
* **实体主体**
  * 在请求报文中，一般是 post/put 提交的表单信息。与首部行之间有 `CRLF` 即空行。

### 13.HTTP与HTTPS的区别

* HTTP
  * 互联网上应用最为广泛的一种网络协议，是一个客户端和服务器端请求和应答的标准（TCP），用于从WWW服务器传输超文本到本地浏览器的传输协议，它可以使浏览器更加高效，使网络传输减少。
* HTTPS
  * 以安全为目标的HTTP通道，简单讲是HTTP的安全版，即HTTP下加入SSL层，HTTPS的安全基础是SSL，因此加密的详细内容就需要SSL。
  * 工作原理：
    * 客户使用HTTPS的URL访问Web服务器，要求与Web服务器建立SSL连接。
    * Web服务器收到客户端请求后，会将网站的证书信息（证书中包含公钥）传送一份给客户端。
    * 客户端的浏览器与Web服务器开始协商SSL连接的安全等级，也就是信息加密的等级。
    * 客户端的浏览器根据双方同意的安全等级，建立会话密钥，然后利用网站的公钥将会话密钥加密，并传送给网站。
    * Web服务器利用自己的私钥解密出会话密钥。
    * Web服务器利用会话密钥加密与客户端之间的通信。

![](https://i.loli.net/2021/03/12/iDyBOY49orGjt8k.gif)

* 区别：
  * HTTPS协议需要到ca申请证书，一般免费证书较少，因而需要一定费用；
  * HTTP是超文本传输协议，信息是明文传输，HTTPS则是具有安全性的SSL加密传输协议；
  * HTTP和HTTPS使用的是完全不同的连接方式，用的端口也不一样，前者是80，后者是443；
  * HTTP的连接很简单，是无状态的；HTTPS协议是由SSL+HTTP协议构建的可进行加密传输、身份认证的网络协议，比HTTP协议安全。

## 面试真题

### 1.DNS的具体过程

1. 检查浏览器缓存中是否缓存过该域名对应的IP地址；
2. 如果在浏览器缓存中没有找到IP，那么将继续查找本机系统是否缓存过IP；
3. 向本地域名解析服务系统发起域名解析的请求；
4. 向根域名解析服务器发起域名解析请求；
5. 根域名服务器返回gTLD（通用顶级域名）域名解析服务器地址；
6. 向gTLD服务器发起解析请求；
7. gTLD服务器接收请求并返回Name Server服务器；
8. Name Server服务器返回IP地址给本地服务器；
9. 本地域名服务器缓存解析结果；
10. 返回解析结果给用户。

### 2.ARP协议的工作原理和流程，路由器是如何转发的？(路由表的工作原理)

**工作流程**

* 当主机A欲向本局域网上的某个主机 B 发送 IP 数据报时，就先在其 ARP高速缓存中查看有无主机B的IP地址；
  * 如有，就可查出其对应的硬件地址，再将此硬件地址写入MAC帧，然后通过局域网将该MAC帧发往此硬件地址；
  * 如没有，ARP进程在本局域网上广播发送一个ARP请求分组。收到ARP响应分组后，将得到的IP地址到硬件地址的映射写入ARP高速缓存。

**路由器工作原理**

1. 一个帧到达路由器后，首先检查帧中目标MAC地址是否是本接口的MAC，如不是则丢弃，如是则解封装并将IP包移动到路由器内部；
2. 将IP包中目标IP与路由表进行匹配，如匹配路由表不成功，则丢弃，返回ICMP（互联网控制消息协议）错误消息；若成功，则将数据路由到相应的出口，再封装帧头帧尾；
3. 检查ARP缓存中是否有下一跳的MAC，如有则重新封装出去；如没有，则发送ARP请求广播报文获取下一跳的MAC，并记录到ARP缓存表中，再重新封装数据帧发送出去。

### 3.IPv4和IPv6的区别

* IPv4协议具有32位（4字节）地址长度；IPv6协议具有128位（16字节）地址长度；
* IPv4地址是以小数表示的二进制数。 IPv6地址是以十六进制表示的二进制数；
* IPv4协议的数据包需要576个字节，碎片可选 ；IPv6协议的数据包需要1280个字节，不会碎片；
* IPv4根据提供的 IP 选项，有 20-60 个字节的可变长度；IPv6有40 个字节的固定长度。没有 IP 报头选项。通常，IPv6 报头比 IPv4 报头简单。

### 4.对称加密和非对称加密在HTTPS的应用

**对称加密算法**：发送方和接收方需要持有同一把密钥，发送消息和接收消息均使用该密钥。相对于非对称加密，对称加密具有更高的加解密速度，但双方都需要事先知道密钥，密钥在传输过程中可能会被窃取，因此安全性没有非对称加密高。

**非对称加密算法**：接收方在发送消息前需要事先生成公钥和私钥，然后将公钥发送给发送方。发送放收到公钥后，将待发送数据用公钥加密，发送给接收方。接收到收到数据后，用私钥解密。在这个过程中，公钥负责加密，私钥负责解密，数据在传输过程中即使被截获，攻击者由于没有私钥，因此也无法破解。非对称加密算法的加解密速度低于对称加密算法，但是安全性更高。

HTTPS中同时使用了**对称加密算法**和**非对称加密算法**。对于一个完整的HTTPS请求过程：

1.首先，浏览器请求一个URL，找到服务器，向服务器发起一个请求。服务器将自己的证书(包含服务器公钥S_PuKey)、对称加密算法种类及其他相关信息返回客户端；

2.浏览器检查CA证书是不是由可以信赖的CA机构颁发的，确认证书有效和此证书是此网站的。如果不是，给客户端发一个警告，询问是否继续访问；

3.如果是，客户端使用公钥加密了一个随机对称密钥，包括加密的URL一起发送到服务器；

4.服务器用自己的私匙解密你发送的钥匙，然后用这把对称加密的钥匙给你请求的URL链接解密；

5.服务器用你发的对称钥匙给你请求的网页加密，你也有相同的钥匙就可以解密发回来的网页了。

![](https://i.loli.net/2021/05/06/oKemVBJXkITOYGE.png)

## 参考链接

* http://yx.51zhy.cn/net.jsp
* https://github.com/wolverinn/Waking-Up#1-%E8%AE%A1%E7%AE%97%E6%9C%BA%E7%BD%91%E7%BB%9C
* https://draveness.me/whys-the-design-tcp-three-way-handshake/
* https://segmentfault.com/a/1190000020610336
* https://www.cnblogs.com/ityouknow/p/10856177.htmls
* https://www.jianshu.com/p/a2c4ede32d11
* https://zhuanlan.zhihu.com/p/34732244
* https://www.cnblogs.com/panpanwelcome/p/12583965.html
* [双非渣本后端三月逆袭字节](https://www.nowcoder.com/discuss/611627?type=2&channel=1009&source_id=discuss_center_discuss_hot_nctrack)
* [腾讯csig后台开发实习一面](https://www.nowcoder.com/discuss/611429?type=2&channel=1009&source_id=discuss_center_discuss_hot_nctrack)
* [阿里Java实习生一面](https://www.nowcoder.com/discuss/627184?type=post&order=time&pos=&page=0&channel=-1&source_id=search_post_nctrack)
* [字节跳动教育prek客户端日常实习-一二三面面经](https://www.nowcoder.com/discuss/653809?type=2&channel=1009&source_id=discuss_center_discuss_hot_nctrack)













