# 概率题目
现在的面试中,大部分公司都会问道概率相关的问题,我们现在给出几道常见的概率问题.

## 1. 三角形问题
> **题目**: 给你一根铅笔,将铅笔折两次,组成三角形的概率是多大.

> **解析**:

    设: 铅笔长度是1, 折两次之后,得到三条边,对应的长度分别是x,y,1-x-y.
    1. 得到条件:
    0 < x < 1
    0 < y < 1
    0 < 1-x-y < 1
    计算得到面积是: S=1/2
    2. 根据两边之和大于第三边,进行计算:
    x + y > 1-x-y => x + y > 1/2
    x + (1-x-y) > y => y < 1/2
    y + (1-x-y) > x => x < 1/2
    计算得到面积是: A=1/8
    做线性规划求解:
    第一步,根据1中的所有条件,画出中的取值面积S,
    第二步,根据2中的不等式,画出满足条件的面积A.
    最后的概率=A/S=(1/8) / (1/2) = 1/4. 

    方法二: (思路来自网友Summer)
    排除存在的可能性，

    第一次，x+y=1，假设y>x，如果选择y作为一条边肯定不满足，这时就排除了1/2，只能选x作为一个边。

    第二次，从y中折出两条边，一定满足三边只和大于第三边，只能根据两边只差＞第三边进行排除。因为y＞x，一定是从y中的两个边之差＞x。假设从y中折一个a，一个y-a。计算，
    y-a-a＞x，得到y＞x+2a，又因为x＜1/2，y＞1/2，
    根据三个不等式得到排除概率1/4。

    1-1/2-1/4，


## 2. 排列组合
> **题目**: 20个阿里巴巴B2B技术部的员工被安排为4排，每排5个人，我们任意选其中4人送给他们一人一本《effective c++》，那么我们选出的4人都在不同排的概率是多少?

> **解析**: 

    1. 从20个人中,任选4个,是C(20,4).
    2. 4个人在不同排,即从每排中选中一个C(5,1)*C(5,1)*C(5,1)*C(5,1)
    3. 所以四个人在不同的概率是 C(5,1)^4 / C(20,4)    


## 3. 男女比例
> **题目**: 在一个世世代代都重男轻女的村庄里，村长决定颁布一条法律，村子里没有生育出儿子的夫妻可以一直生育直到生出儿子为止，假设现在村子上的男女比例是1:1，这条法律颁布之后的若干年村子的男女比例将会多少?

> **解析**: 

    还是1:1.
    先验性的认为生男生女的自然概率相同，都是0.5；由于生育儿子后就不再生，所以，每个家庭都有且只有一个儿子。假定家庭数目为1，则S(男)=1。
    有0.5的家庭一胎生男就停止生育；剩下的0.5的家庭，有0.25二胎生男则停止生育……，从而，每个家庭的女孩数目为：
$$S(女)=\sum_{i=1}^{m}(\frac{1}{2})^i(i-1)=1$$


## 4. 取球问题
> **题目**: 袋中有红球，黄球，白球各一个，每次任意取一个又放回，如此连续抽取3次，求下列概率值:  
> 1. 颜色不全相同
> 2. 颜色全相同
> 3. 颜色全不同
> 4. 颜色无红色

> **解析**: 

    1. 每次都取红球的概率是1/3, 如果都是3次都是红色概率则是: (1/3)*(1/3)*(1/3)=1/27
    所有颜色全相同的概率是3*(1/3)*(1/3)*(1/3)=1/9.

    2. 颜色不全相同的概率: 1-颜色全相同的概率=8/9.

    3. 颜色全不同:
        假设三次依次是红,黄,白: 概率是(1/3)*(1/3)*(1/3)=1/27
        颜色全排列是A(3,3)=6
        所有颜色全不同的概率是6*1/27 = 2/9
    4. 无红色的概率:
        (2/3)*(2/3)*(2/3)=8/27

## 5. 等概率器
> **题目**: 已知一随机发生器，产生0的概率是p，产生1的概率是1-p，现在要你构造一个发生器，使得它产生0和1的概率均为1/2。(或者是非等概率硬币,也是一样的情况).

> **解析**: 

    找到等概率事件. 考虑连续产生两个随机数，结果只有四种可能：00、01、10、11，其中产生01和产生10的概率是相等的，均为p*(1-p)，于是可以利用这个概率相等的特性等概率地产生01随机数。
    比如把01映射为0,10映射为1。于是整个方案就是：
    产生两个随机数，如果结果是00或11就丢弃重来，如果结果是01则产生0，结果是10则产生1。


## 6. 再谈等概率器
> **题目**: 给你一个不均匀的骰子,1-6出现的概率都不相同,你也不知道每个面出现的概率,现在让你用这个骰子构造一个01发生器,使得01出现的概率都是1/2. 

> **解析**: 

    方法1: 
    找到一个等概率事件,因为每一个面出现的概率都不知道,现在我们假设扔6次骰子,1-6分别出现一次为事件p,那么p这个序列的概率就是(p1*p2*p3*p4*p5*p6), 我们将这样构造
    1. 所有以(1,2,3)开头的这样的序列p对应0; 
    2. 所有以(4,5,6)开头的这样的序列p对应1;
    3. 每6次作为一个事件,不满足p序列的要求,这次实验就作废.

    看起来0和1产生的概率都是1/2,都是有一个问题,我们需要扔很多次才能得到一次0或1.这种方法理论上可行,实际中不好用.

    方法2:
    0101:大于小于.
    我们将扔两次骰子作为一个时间,假设第一是x,第二次是y.
    1. x > y: 对应0
    2. x < y: 对应1
    3. x == y: 当x属于[1,2,3]时对应0, 否则对应1.

    各个面出现的概率不同,这个满足要求吗?
    11 12 13 14 15 16
    21 22 23 24 25 26
    31 32 33 34 35 35
    41 42 43 44 45 46
    51 52 53 54 55 56
    61 62 63 64 65 66

    可以看出,左下对应0,右上对应1. 而且出现的次数相同.


## 7. 吃苹果
> **题目**: 有一苹果两个人抛硬币来决定谁吃这个苹果先抛到正面者吃。问先抛者吃到苹果的概率是多少？

> **解析**: 
    先抛者A吃苹果, 后者是B: 
    A(第一次)吃: 1/2
    A(第二次)吃: 1/2(!A)*1/2(!B)*1/2(A)=1/8
    这是一个等比数列,公比是1/4, 首项是1/2.
    求解的(1/2)*(1-(1/4^n)) / (1-1/4) = (1/2)/(3/4) = 2/3.

## 8. 蚂蚁爬三角形
> **题目**: 一个三角形， 三个端点上有三只蚂蚁，蚂蚁可以绕任意边走，问蚂蚁不相撞的概率是多少?

> **解析**: 

    1.每个蚂蚁在方向的选择上有且只有2种可能，共有3只蚂蚁，所以共有2的3次方种可能
    2.不相撞有有2种可能，即全为顺时针方向或全为逆时针方向。
    不相撞概率=不相撞/全部=2/8


## 9. 正确的概率
> **题目**: 甲乙两个人答对一道题的概率分别为90%和80%，对于一道判断题，他们都选择了“正确”，问这道题正确的概率.

> **解析**: 

    设:
    甲的选择是"正确"的,是事件A.
    乙的选择是"正确"的,是事件B.
    这道题是正确的是事件C.
    则有:
$$P(A|C)=0.9 \tag{1}$$

$$P(B|C)=0.8 \tag{2}$$
    
    目标是求: P(C|AB), 根据贝叶斯公式有:

$$P(C|AB)=\frac{P(AB|C)*P(C)}{P(AB|C)*P(C)+(AB|\bar{C})*P(\bar{C})} \tag{3}$$

    可以认为A和B是独立事件.则有:
$$P(AB|C)=P(A|C)*P(B|C)=0.72$$
$$P(AB|{C})=P(A|{C})*P(B|\bar{C})=(1-0.9)*(1-0.8)=0.02$$

    根据实际情况,一道题对或者错的概率是0.5. 则公式3的结果是: 

$$\frac{0.72*0.5}{0.72*0.5+0.02*0.5}=\frac{36}{37}$$

## 10. 和超过1的个数
> **题目**: 从(0,1)中随机取数,期望情况下取多少个数才能让和超过1. 

> **解析**: 

<img src="../assert/prb10.gif">
    
    

# 参考
1. https://www.julyedu.com/question/selectAnalyze/kp_id/6/cate/%E6%A6%82%E7%8E%87%E7%BB%9F%E8%AE%A1
2. https://blog.csdn.net/huazhongkejidaxuezpp/article/details/73662357
3. https://www.cnblogs.com/sunflower627/p/4839031.html
4. http://www.voidcn.com/article/p-afkjgouj-qm.html
5. https://blog.csdn.net/rudyalwayhere/article/details/7349957