# 面试题目

## 1. 相同URL
> **题目**: 给定a、b两个文件，各存放50亿个url，每个url各占64字节，内存限制是4G，让你找出a、b文件共同的url？ 

> 方案1：估计每个文件的大小为50G×64=320G，远远大于内存限制的4G。所以不可能将其完全加载到内存中处理。考虑采取分而治之的方法。
> <img src="../assert/big-data1.png">
> 遍历文件a，对每个url求取 hash(url)%1000[比如ASCII码值求和], 然后根据所取得的值将url分别存储到1000个小文件(记为a0, a1, … , a999)中。这样每个小文件的大约为300M。
> 
> 遍历文件b，采取和a相同的方式将url分别存储到1000个小文件(记为b0, b1, … , b999)。
> 
> 这样处理后，所有可能相同的url都在对应的小文件(a0 vs b0, a1 vs b1, … , a999 vs b999)中，不对应的小文件不可能有相同的url。然后我们只要求出1000对小文件中相同的url即可。
> 
> 求每对小文件中相同的url时，可以把其中一个小文件的url存储到hash_set中。然后遍历另一个小文件的每个url，看其是否在刚才构建的hash_set中，如果是，那么就是共同的url，存到文件里面就可以了。


> 方案2：如果允许有一定的错误率，可以使用Bloom filter，4G内存大概可以表示340亿bit。将其中一个文件中的url使用Bloom filter映射为这340亿bit，然后挨个读取另外一个文件的url，检查是否与Bloom filter，如果是，那么该url应该是共同的url（注意会有一定的错误率）。

## 2. Query排序
> **题目**: 有10个文件，每个文件1G，每个文件的每一行存放的都是用户的query，每个文件的query都可能重复。要求你按照query的频度排序。
> 
> 方案1：       
> 顺序读取10个文件，按照hash(query)%10的结果将query写入到另外10个文件(r1,r2…r10)中。这样新生成的文件每个的大小大约也1G（假设hash函数是随机的）。
> 
> [2G左右的机器] 对r1,r2…r10用hash_map(query, query_count)来统计每个query出现的次数。利用快速/堆/归并排序按照出现次数进行排序。将排序好的query和对应的query_cout输出到文件中。这样得到了10个排好序的文件(r1,r2…r10).
> 
> 对(r1,r2…r10)这10个文件归并排序(内排序和外排序结合)
> <img src="../assert/bigdata2.png"/>
> 方案2：   
> 一般query的总量是有限的，只是重复的次数比较多而已，可能对于所有的query，一次性就可以加入到内存了。这样，我们就可以采用trie树/hash_map等直接来统计每个query出现的次数，然后按出现次数做快速/堆/归并排序就可以了。
 
## 3. Top k 单词
**题目**: 有一个1G大小的一个文件，里面每一行是一个词，词的大小不超过16字节，内存限制大小是1M。返回频数最高的100个词。

> 1. 顺序读文件，对每个词x，取hash(x)%5000，然后按照该值存到5000个小文件(x0, x1, … x4999)中。这样每个文件大概是200k左右，如果有的文件超过了1M大小，还可以按照类似的方法继续往下分，直到分解得到的小文件的大小都不超过1M。
> 2. 对每个小文件，统计每个文件出现的词及相应的频率（可以采用trie树/hash_map等），并取出现频率最大的100个词（可以用含100个结点的最小堆），并把100词及相应的频率存入文件，这样又得到了5000个文件。
> 3. 下一步就是把这5000个文件进行归并（类似与归并排序）的过程了。

## 4. IP统计 
> **题目**: 海量日志数据，提取出某日访问百度次数最多的那个IP。
> 1. 定位到某日，并把访问百度的日志中的IP取出来，逐个写入到大文件中。注意IP是32位，最多有2^32个IP。-
> 2. 采用映射的方法，比如模1000，把整个大文件映射为1000个小文件
> 3. 找出每个小文件出现频率最大的IP（可以采用hash_map进行频率统计，然后再找出频率最大的几个）及相应的频率。
> 4. 然后再在这1000个最大的IP中，找出那个频率最大的IP，即为所求。
 
## 5. 不重复的整数
> **题目**: 在2.5亿个整数中找出不重复的整数，内存不足以容纳这2.5亿个整数。
> 
> 方案1：   
> 采用2-Bitmap（每个数分配2bit，00表示不存在，01表示出现一次，10表示多次，11无意义）进行，共需内存2^32*2bit = 1G内存，还可以接受。  
> 扫描这2.5亿个整数，查看Bitmap中相对应位，如果是00变01，01变10，10保持不变。所描完事后，查看bitmap，把对应位是01的整数输出即可。   
> 
> 方案2：   
> 
> 采用上题类似的方法，进行划分小文件的方法。然后在小文件中找出不重复的整数，并排序。然后再进行归并，注意去除重复的元素。
> 
## 6. Top K
> **题目**: 海量数据分布在100台电脑中，想个办法高校统计出这批数据的TOP10。

> mapreduce还没有使用,是不是应该使用下mapreduce, 找key,定value.

# 参考
1. https://blog.csdn.net/u012289441/article/details/45192775
2. https://blog.csdn.net/v_july_v/article/details/6685962
