# 树模型集成学习
集成学习主要有两个思想，分别是bagging和boosting。树模型的集成模型都是使用树作为基模型，最常用的cart树，常见的集成模型有RandomForest、GBDT、Xgboost、Lightgbm、Catboost。

# 概要介绍
## RandomForest
随机森林(Random Forest,RF)是Bagging的一个扩展变体。RF在以决策树为基学习器构建Bagging集成的基础上，进一步在决策树的训练过程中引入了随机属性选择。既然模型叫做随机森林，森林我们可以理解为是多棵树的集合就是森林，随机主要有两个点进行有放回的采样，
1. 每次建树特征个数随机选择
2. 每次建树样本个数随机选择

随机森林中基学习器的多样性不仅来自样本扰动，还来自属性扰动，这就使得最终集成得泛化性能可通过个体学习器之间差异度得增加而进一步提升。使得模型更加鲁棒。

## GBDT
GBDT使用的是加法模型和前向分布算法，而AdaBoost算法是前向分布加法算法的特例，前向分布算法是加法模型，当基函数为基本分类器时，该加法模型等价于Adaboost的最终分类器。
GBDT也是迭代，使用了前向分布算法，但是弱学习器限定了只能使用CART回归树模型，同时迭代思路和Adaboost也有所不同。在GBDT的迭代中，假设我们前一轮迭代得到的强学习器是, 损失函数是, 我们本轮迭代的目标是找到一个CART回归树模型的弱学习器，让本轮的损失函数最小。也就是说，本轮迭代找到决策树，要让样本的损失尽量变得更小。GBDT本轮迭代只需拟合当前模型的残差。

## Xgboost
Xgboost是gbdt的改进或者说是梯度提升树的一种，Xgb可以说是工程上的最佳实践模型，简单的说xgb=gbdt+二阶梯度信息+随机特征和样本选择+特征百分位值加速+空值特征自动划分。还有必要的正则项和最优特征选择时的并行计算等。

## Lightgbm
首先，GBDT是一个非常流行的机器学习算法，另外基于GBDT实现的XGBoost也被广泛使用。但是当面对高纬度和大数据量时，其效率和可扩展性很难满足要求。主要的原因是对于每个特征，我们需要浏览所有的数据去计算每个可能分裂点的信息增益，真是非常耗时的。基于此，提出了两大技术：Gradient-based One-Side Sampling (GOSS) and Exclusive Feature Bundling (EFB).

##　catboost
CatBoost = Category + Boosting. 
2017年7月21日，俄罗斯Yandex开源CatBoost，亮点是在模型中可直接使用Categorical特征并减少了tuning的参数。


# 核心公式
1. gbdt的前向分布公式
   $$f_m(x)=f_{m-1}(x)+\beta_m b(x;\gamma_m) \tag{1}$$

2. gbdt的第m轮的扶梯度公式
    $$-\left[
        \frac{\partial L(y,f(x_i))}{\partial f(x_i)}
    \right]_{f(x)=f_{m-1}(x)} \tag{2}$$

3. gbdt格式化损失函数
    $$L(y,f_m(x))=L(y,f_{m-1}(x)+\beta_m b(x;\gamma_m)) \tag{3}$$

4. 泰勒展开式   
若函数f（x）在包含x0的某个闭区间[a,b]上具有n阶导数，且在开区间（a,b）上具有（n+1）阶导数，则对闭区间[a,b]上任意一点x，成立下式：
   $$f(x)=f(x_0)+f'(x_0)(x-x_0)+\frac{f''(x0)}{2!}(x-x_0)^2+ ... + \frac{f^{(n)}(x_0)}{n!}(x-x_0)^n+R_n(x) \tag{4}$$
   $$f(x+\Delta x)=f(x)+f'(x)\Delta x + \frac{1}{2!}f''(x)\Delta x^2+...+\frac{1}{n!}f^{(n)}(x)\Delta x^n+R_n(x) \tag{5}$$
    其中，$R_n(x)$是$(x-x_0)^n的高阶无穷小.$

5. xgboost的目标公式(t轮迭代)
   $$obj^{(t)}=\sum_{i=1}^{n}l(y_i,\hat{y}_i^t)+\sum_{i=1}^{t}\Omega(f_i) \tag{6}$$
   $$=\sum_{i=1}^{n}l(y,\hat y_{i}^{(t-1)}+f_t(x_i))+\Omega(f_t)+constant \tag{7}$$

6. xgboost损失函数的泰勒二阶展开
    $$l^{(t)} \eqsim \sum_{i=1}^{n}[l(y_i,\hat y ^{(t-1)})+g_i f_t(x_i) + \frac{1}{2}h_i f_t^2(x_i)]+\Omega(f_t) \tag{8}$$
    其中，$l(y_i,\hat y ^{(t-1)})$是常数，$g_i=\partial_{\hat{y}^{(t-1)}}l(y_i, \hat{y}^{(t-1)})$, $h_i=\partial_{\hat{y}^{(t-1)}}^2l(y_i, \hat{y}^{(t-1)})$. 常数对目标函数的优化不相关，于是可以将目标函数转化为如下:
    $$l^{(t)} = \sum_{i=1}^{n}[g_i f_t(x_i) + \frac{1}{2}h_i f_t^2(x_i)]+\Omega(f_t) \tag{9}$$
    $$=\sum_{i=1}^{n}[g_i f_t(x_i) + \frac{1}{2}h_i f_t^2(x_i)]+\lambda T+\frac{1}{2}\sum_{j=1}^{T}\omega_j^2  \tag{10}$$
    $$=\sum_{j=1}^{T}[(\sum_{i \in I_j}g_i) \omega_j + \frac{1}{2}(\sum_{i \in I_j}h_i) \omega_j^2] + \lambda T + \frac{1}{2}\sum_{i=1}^{T} \omega_j^2  \tag{11}$$
    $$=\sum_{i=1}^{n}[g_i f_t(x_i) + \frac{1}{2}h_i f_t^2(x_i)]+\lambda T+\frac{1}{2}\sum_{j=1}^{T}\omega_j^2  \tag{12}$$
    $$=\sum_{j=1}^{T}[(\sum_{i \in I_j}g_i) \omega_j + \frac{1}{2}(\sum_{i \in I_j}h_i+\lambda) \omega_j^2] + \lambda T  \tag{13}$$
    求上式最小化的参数，对$\omega$求导数并另其等于0，得到下式:
    $$\frac{\partial l^{(t)}}{\partial \omega_j}=0 \tag{14}$$
    $$\sum_{i \in I_j}+(\sum_{i \in I_j}h_i + \lambda) \omega_j=0 \tag{15}$$
    $$\omega_j^*=-\frac{\sum_{i \in I_j}g_i}{\sum_{i \in I_j}h_i + \lambda} \tag{16}$$
    
    将上式带入损失函数，得到最小损失：
    $$\hat{l}^{(t)}(q)=-\frac{1}{2}\sum_{j=1}^{T}\frac{(\sum_{i \in I_j}g_i)^2}{\sum_{i \in I_j}h_i+ \lambda}+\gamma T \tag{17}$$

    根据公式(17)可以作为特征分裂的指标.计算公式如下(这个值越大越好):

    $$L_{split}=\frac{1}{2}
    \left[
        \frac{（\sum_{i \in I_L}g_i)^2}{\sum_{i \in I_L}h_i+\lambda} + 
        \frac{（\sum_{i \in I_R}g_i)^2}{\sum_{i \in I_R}h_i+\lambda} - 
        \frac{（\sum_{i \in I}g_i)^2}{\sum_{i \in I}h_i+\lambda}
        \right ] - \lambda \tag{18}$$


# 算法十问
1. 随机森林为什么能够更鲁棒？
> 由于随机森林使用了使用了行采样和列采样技术，是的每棵树不容易过拟合；并且是基于树的集成算法，由于使用了采用数据是的每棵树的差别较大，在进行embedding的时候可以更好的降低模型的方差，整体而言是的RF是一个鲁棒的模型。

2. RF分类和回归问题如何预测y值？
> RF是一个加权平均的模型，是进行分类问题的时候，使用的个k个树的投票策略，多数服从少数。在回归的使用是使用的k个树的平均。可以看出来rf的训练和预测过程都可以进行并行处理。

3. 相同数据量，训练RF和gbdt谁可以更快？谁对异常值不敏感？
> gbdt是前向加法模型，由于第i棵树需要用到前i-1树的残差，所有在再整个建立过程是串行处理的，RF整体是bagging算法的一种，是k个树的加权平均，k棵树可以并行处理，因此可能得到更快的速度。需要指出在gbdt的原始算法中没有使用行列的随机采样，相反rf使用了随机采样。
> 由于gbdt当前的误差会延续给下一棵树，而RF每次都是独立的随机采样，随机森林对异常值不敏感，GBDT对异常值非常敏感。

4. 解释一个什么是gb，什么是dt，即为什么叫做gbdt？
> gbdt(Gradient Boosting Decision Tree),dt是指Decision Tree表示使用决策树作为基学习器，使用的cart树，gb表示梯度提升，因为在传统的gbdt中在第i轮的迭代中，使用前i-1的梯度作为当前残差进行拟合。

5. gbdt为什么用负梯度代表残差？
> 上文公式(3)是gbdt的损失函数，对公式(3)进行在$f_{m-1}(x)处进行$泰勒的一阶展开:
> $$L(y,f_m(x))=L(y,f_{m-1}(x)+\beta_m b(x;\gamma_m))$$
> $$=L(y,f_{m-1}(x))+\frac{\partial L(y, f_{m-1}(x))}{\partial f_{m-1}(x)}(f_{m}(x)-f_{m-1}(x))$$
> $$=L(y,f_{m-1}(x))+\frac{\partial L(y, f_{m-1}(x))}{\partial f_{m-1}(x)}(\beta_m b(x;\gamma_m)) \tag{19}$$
> 从我们的目标是损失函数最小化，使公式(19)最小化，由于$L(y,f_{m-1}(x))$是个常数，所以我们的损失函数最小化可以转化为:
> $$argmin_{(\beta_m,\gamma_m)}=min \frac{\partial L(y, f_{m-1}(x))}{\partial f_{m-1}(x)}(\beta_m b(x;\gamma_m)) \tag{20}$$
> 将上述式子的两项都看做是向量，为了是相乘之后最小，一定是向量之间的异号,因此得到:
> $$(\beta_m b(x;\gamma_m)) = - \frac{\partial L(y, f_{m-1}(x))}{\partial f_{m-1}(x)} \tag{21}$$
> 从公式(20)可以看出第m棵树使用前m-1的负梯度作为残差，所有每次都是拟合的负梯度.

6. gbdt是训练过程如何选择特征？
> gbdt使用基学习器是CART树，CART树是二叉树，每次使用yes or no进行特征选择，数值连续特征使用的最小均方误差，离散值使用的gini指数。在每次划分特征的时候会遍历所有可能的划分点找到最有的特征分裂点，这是用为什么gbdt会比rf慢的主要原因之一。

7. gbdt应用在多分类问题？
> + gbdt 每轮的训练是在上一轮的训练的残差基础之上进行训练的。这里的残差就是当前模型的负梯度值 。这个要求每轮迭代的时候，弱分类器的输出的结果相减是有意义的。残差相减是有意义的。
> + 对于多分类任务，GDBT的做法是采用一对多的策略也就是说，对每个类别训练M个分类器。假设有K个类别，那么训练完之后总共有M*K颗树。 
> + 两层循环的顺序不能改变。也就是说，K个类别都拟合完第一颗树之后才开始拟合第二颗树，不允许先把某一个类别的M颗树学习完，再学习另外一个类别。
> <img src='../assert/mult_gbdt.png'/>

8. RF和GBDT的区别？
> GBDT是采用boosing方法，降低偏差；RF采用的是baggging方法，降低方差。其中GBDT中的核心是通过用分类器（如CART、RF）拟合损失函数梯度，而损失函数的定义就决定了在子区域内各个步长，其中就是期望输出与分类器预测输出的查，即bias；而RF的核心就是自采样（样本随机）和属性随机（所有样本中随机选择K个子样本选择最优属性来划分），样本数相同下的不同训练集产生的各个分类器，即数据的扰动导致模型学习性能的变化，即variance。

9. Xgboost相对gbdt做了哪些改进？
> + 传统GBDT以CART作为基分类器，xgboost还支持线性分类器，这个时候xgboost相当于带L1和L2正则化项的逻辑斯蒂回归（分类问题）或者线性回归（回归问题）。
> + 传统GBDT在优化时只用到一阶导数信息，xgboost则对代价函数进行了二阶泰勒展开，同时用到了一阶和二阶导数。顺便提一下，xgboost工具支持自定义代价函数，只要函数可一阶和二阶求导。
> + xgboost在代价函数里加入了正则项，用于控制模型的复杂度。正则项里包含了树的叶子节点个数、每个叶子节点上输出的score的L2模的平方和。从Bias-variance tradeoff角度来讲，正则项降低了模型的variance，使学习出来的模型更加简单，防止过拟合，这也是xgboost优于传统GBDT的一个特性。
> + 列抽样（column subsampling）。xgboost借鉴了随机森林的做法，支持列抽样，不仅能降低过拟合，还能减少计算，这也是xgboost异于传统gbdt的一个特性。
对缺失值的处理。对于特征的值有缺失的样本，xgboost可以自动学习出它的分裂方向。
> + xgboost工具支持并行。boosting不是一种串行的结构吗?怎么并行的？注意xgboost的并行不是tree粒度的并行，xgboost也是一次迭代完才能进行下一次迭代的（第t次迭代的代价函数里包含了前面t-1次迭代的预测值）。xgboost的并行是在特征粒度上的。我们知道，决策树的学习最耗时的一个步骤就是对特征的值进行排序（因为要确定最佳分割点），xgboost在训练之前，预先对数据进行了排序，然后保存为block结构，后面的迭代中重复地使用这个结构，大大减小计算量。这个block结构也使得并行成为了可能，在进行节点的分裂时，需要计算每个特征的增益，最终选增益最大的那个特征去做分裂，那么各个特征的增益计算就可以开多线程进行。
> + 可并行的近似直方图算法。树节点在进行分裂时，我们需要计算每个特征的每个分割点对应的增益，即用贪心法枚举所有可能的分割点。当数据无法一次载入内存或者在分布式情况下，贪心算法效率就会变得很低，所以xgboost还提出了一种可并行的近似直方图算法，用于高效地生成候选的分割点。

10.  xgb如何在计算特征时加速的？
> + xgboost工具支持并行。boosting不是一种串行的结构吗?怎么并行的？注意xgboost的并行不是tree粒度的并行，xgboost也是一次迭代完才能进行下一次迭代的（第t次迭代的代价函数里包含了前面t-1次迭代的预测值）。xgboost的并行是在特征粒度上的。我们知道，决策树的学习最耗时的一个步骤就是对特征的值进行排序（因为要确定最佳分割点），xgboost在训练之前，预先对数据进行了排序，然后保存为block结构，后面的迭代中重复地使用这个结构，大大减小计算量。这个block结构也使得并行成为了可能，在进行节点的分裂时，需要计算每个特征的增益，最终选增益最大的那个特征去做分裂，那么各个特征的增益计算就可以开多线程进行。
> + 可并行的近似直方图算法。树节点在进行分裂时，我们需要计算每个特征的每个分割点对应的增益，即用贪心法枚举所有可能的分割点。当数据无法一次载入内存或者在分布式情况下，贪心算法效率就会变得很低，所以xgboost还提出了一种可并行的近似直方图算法，用于高效地生成候选的分割点。

11.  xgb为什么使用二阶梯度信息，为什么不使用三阶或者更高梯度信息？
> xgb之所以使用二阶梯度信息，是因为从泰勒展开式来看，gbdt使用的一阶梯度的泰勒展开式，丢失了很多的信息，使用二阶可以使损失函数更加准确。从泰勒展开的角度来看展开的次数越多越能更精准的表示损失函数的值，但是如果我们使用二阶梯度就要要求损失函数二阶可导，如果使用n阶展开就要求损失函数n阶可导，但是有很多损失函数不是n阶可导的，比如均方误差，因此使用二阶梯度信息是一个泰勒展开和损失函数选择的折中。

12.  lgb相对xgb做了哪些改进？
> + 直方图算法，LightGBM提供一种数据类型的封装相对Numpy,Pandas,Array等数据对象而言节省了内存的使用，原因在于他只需要保存离散的直方图，LightGBM里默认的训练决策树时使用直方图算法，XGBoost里现在也提供了这一选项，不过默认的方法是对特征预排序，直方图算法是一种牺牲了一定的切分准确性而换取训练速度以及节省内存空间消耗的算法.
> + 在训练决策树计算切分点的增益时，预排序需要对每个样本的切分位置计算，所以时间复杂度是O(#data)而LightGBM则是计算将样本离散化为直方图后的直方图切割位置的增益即可，时间复杂度为O(#bins),时间效率上大大提高了(初始构造直方图是需要一次O(#data)的时间复杂度，不过这里只涉及到加和操作).
> + 直方图做差进一步提高效率，计算某一节点的叶节点的直方图可以通过将该节点的直方图与另一子节点的直方图做差得到，所以每次分裂只需计算分裂后样本数较少的子节点的直方图然后通过做差的方式获得另一个子节点的直方图，进一步提高效率
> + 节省内存,将连续数据离散化为直方图的形式，对于数据量较小的情形可以使用小型的数据类型来保存训练数据
不必像预排序一样保留额外的对特征值进行预排序的信息
减少了并行训练的通信代价.
> + 稀疏特征优化、直接支持类别特征、网络通信优化

13.  比较一下catboost、lgb和xgb？
XGBoost、LightGBM和CatBoost都是目前经典的SOTA（state of the art）Boosting算法，都可以归类到梯度提升决策树算法系列。三个模型都是以决策树为支撑的集成学习框架，其中XGBoost是对原始版本的GBDT算法的改进，而LightGBM和CatBoost则是在XGBoost基础上做了进一步的优化，在精度和速度上都有各自的优点。
> + 三个模型树的构造方式有所不同，XGBoost使用按层生长（level-wise）的决策树构建策略，LightGBM则是使用按叶子生长（leaf-wise）的构建策略，而CatBoost使用了对称树结构，其决策树都是完全二叉树。
> + 对于类别特征的处理。XGBoost本身不具备自动处理类别特征的能力，对于数据中的类别特征，需要我们手动处理变换成数值后才能输入到模型中；LightGBM中则需要指定类别特征名称，算法即可对其自动进行处理；CatBoost以处理类别特征而闻名，通过目标变量统计等特征编码方式也能实现类别特征的高效处理。

14.  如果将所有数据复制一倍放入训练数据集，RF和GBDT分别有什么表现？
> RF可能出现过拟合? GBDT没有任何改变?(请思考)

15. gbdt如何防止过拟合？由于gbdt是前向加法模型，前面的树往往起到决定性的作用，如何改进这个问题？
> 一般使用缩减因子对每棵树进行降权，可以使用带有dropout的GBDT算法，dart树，随机丢弃生成的决策树，然后再从剩下的决策树集中迭代优化提升树。
GBDT与Boosting区别较大，它的每一次计算都是为了减少上一次的残差，而为了消除残差，可以在残差减小的梯度方向上建立模型;
在GradientBoost中，每个新的模型的建立是为了使得之前的模型的残差往梯度下降的方法。

16. RF/GBDT/XGB/lightGBM ?
> <img src='../assert/gbdt-1.png'>
> <img src='../assert/gbdt-2.png'>
> <img src='../assert/gbdt-3.png'>
> <img src='../assert/gbdt-4.png'>

# 面试真题
1. RF和GBDT能够并行吗?
2. 写一个gbdt的损失函数?
3. 为什么要拟合负梯度?
4. xgboost如何进行参数更新的?
5. xgboost为什么使用二阶梯度信息?
6. gbdt对异常值敏感吗?为什么?

# 参考
1. https://www.cnblogs.com/fujian-code/p/9018114.html
2. https://blog.csdn.net/u010398493/article/details/77587749
3. https://www.jianshu.com/p/49ab87122562
4. https://blog.csdn.net/qq_22238533/article/details/79199605 
