

# 随机森林面试题

## 1. 简单介绍随机森林

一种基于树模型的Bagging的优化版本，一棵树的生成肯定还是不如多棵树，因此就有了随机森林，解决决策树泛化能力弱的特点。

**多次随机取样，多次随机取属性，选取最优分割点，构建多个(CART)分类器，投票表决**

**算法流程：**

* 输入为样本集$D=\{(x，y_1)，(x_2，y_2) \dots (x_m，y_m)\}$，弱分类器迭代次数$T$。
* 输出为最终的强分类器$f(x)$

* 对于$t=1，2 \dots T$
  * 对训练集进行第$t$次随机采样，共采集$m$次，得到包含$m$个样本的采样集Dt
  * 用采样集$D_t$训练第$t$个决策树模型$G_t(x)$，在训练决策树模型的节点的时候，在节点上所有的样本特征中选择一部分样本特征，在这些随机选择的部分样本特征中选择一个最优的特征来做决策树的左右子树划分
* 如果是分类算法预测，则$T$个弱学习器投出最多票数的类别或者类别之一为最终类别。如果是回归算法，$T$个弱学习器得到的回归结果进行算术平均得到的值为最终的模型输出。

## 2. 随机森林的随机性体现在哪里？

**多次有放回的随机取样，多次随机选择特征**

## 3. 随机森林为什么不容易过拟合？

* 随机森林中的每一颗树都是过拟合的，拟合到非常小的细节上

* 随机森林通过引入随机性，使每一颗树拟合的细节不同

* 所有树组合在一起，过拟合的部分就会自动被消除掉。

因此随机森林出现过拟合的概率相对低。

## 4. 为什么不用全样本训练？

全样本训练忽视了局部样本的规律（各个决策树趋于相同），对于模型的泛化能力是有害的，使随机森林算法在样本层面失去了随机性。

## 5. 为什么要随机特征？

随机特征保证基分类器的多样性（差异性），最终集成的泛化性能可通过个体学习器之间的差异度而进一步提升，从而提高泛化能力和抗噪能力。

## 6. RF与 GBDT 的区别？

* 随机森林将多棵决策树的结果进行投票后得到最终的结果，对不同的树的训练结果也没有做进一步的优化提升，将其称为**Bagging算法。**
* GBDT用到的是**Boosting算法**，在迭代的每一步构建弱学习器弥补原有模型的不足。GBDT中的Gradient Boost就是通过每次迭代的时候构建一个沿梯度下降最快的方向的学习器。

## 7. RF为什么比Bagging效率高？

因为在个体决策树的构建过程中，Bagging使用的是“确定型”决策树，bagging在选择划分属性时要对每棵树是对所有特征进行考察；而随机森林仅仅考虑一个特征子集。

## 8. 你已经建了一个有10000棵树的随机森林模型。在得到0.00的训练误差后，你非常高兴。但是，验证错误是34.23。到底是怎么回事？你还没有训练好你的模型吗？
- 模型过拟合十分严重
- 新的测试集与训练集的数据分布不一致

## 9. 如何使用随机森林对特征重要性进行评估？

**袋外数据(OOB)**： 大约有1/3的训练实例没有参与第k棵树的生成，它们称为第$k$棵树的袋外数据样本。 

在随机森林中某个特征$X$的重要性的计算方法如下：

* 对于随机森林中的每一颗决策树，使用相应的OOB(袋外数据)来计算它的袋外数据误差，记为$err_{OOB1}$。
* 随机地对袋外数据OOB所有样本的特征$X$加入噪声干扰(就可以随机的改变样本在特征X处的值)，再次计算它的袋外数据误差，记为$err_{OOB2}$。
* 假设随机森林中有$N$棵树，那么对于特征$X$的重要性为$(err_{OOB2}-err_{OOB1}/N)$，之所以可以用这个表达式来作为相应特征的重要性的度量值是因为：若给某个特征随机加入噪声之后，袋外的准确率大幅度降低，则说明这个特征对于样本的分类结果影响很大，也就是说它的重要程度比较高。

## 10. 随机森林算法训练时主要需要调整哪些参数？

* **n_estimators:**随机森林建立子树的数量。
  较多的子树一般可以让模型有更好的性能，但同时让你的代码变慢。需要选择最佳的随机森林子树数量

* **max_features：**随机森林允许单个决策树使用特征的最大数量。
  增加max_features一般能提高模型的性能，因为在每个节点上，我们有更多的选择可以考虑。然而，这未必完全是对的，因为它降低了单个树的多样性，而这正是随机森林独特的优点。但是，可以肯定，你通过增加max_features会降低算法的速度。因此，你需要适当的平衡和选择最佳max_features。

* **max_depth：** 决策树最大深度

  默认决策树在建立子树的时候不会限制子树的深度

* **min_samples_split：**内部节点再划分所需最小样本数
  内部节点再划分所需最小样本数，如果某节点的样本数少于min_samples_split，则不会继续再尝试选择最优特征来进行划分。

* **min_samples_leaf：** 叶子节点最少样本

  这个值限制了叶子节点最少的样本数，如果某叶子节点数目小于样本数，则会和兄弟节点一起被剪枝。

* **max_leaf_nodes：** 最大叶子节点数

  通过限制最大叶子节点数，可以防止过拟合，默认是"None”，即不限制最大的叶子节点数。如果加了限制，算法会建立在最大叶子节点数内最优的决策树。

* **min_impurity_split：** 节点划分最小不纯度
  这个值限制了决策树的增长，如果某节点的不纯度（基于基尼系数，均方差）小于这个阈值，则该节点不再生成子节点。即为叶子节点。一般不推荐改动默认值1e-7。

## 11. 随机森林的优缺点

- 优点
  - 训练可以高度并行化，对于大数据时代的大样本训练速度有优势。个人觉得这是的最主要的优点。
  - 由于可以随机选择决策树节点划分特征，这样在样本特征维度很高的时候，仍然能高效的训练模型。
  - 在训练后，可以给出各个特征对于输出的重要性
  - 由于采用了随机采样，训练出的模型的方差小，泛化能力强。
  - 相对于Boosting系列的Adaboost和GBDT， RF实现比较简单。
  - 对部分特征缺失不敏感，如果有很大一部分的特征遗失，仍可以维持准确度。
- 缺点

  - 在某些噪音比较大的样本集上，RF模型容易陷入过拟合。
  - 取值划分比较多的特征容易对RF的决策产生更大的影响，从而影响拟合的模型的效果。

## 12. 简述一下Adaboost原理

Adaboost算法利用同一种基分类器（弱分类器），基于分类器的错误率分配不同的权重参数，最后累加加权的预测结果作为输出。

* Adaboost算法流程：
  * 样本赋予权重，得到第一个分类器。
  * 计算该分类器的错误率，根据错误率赋予分类器权重（注意这里是**分类器的权重**）。
  * 增加分错样本的权重，减小分对样本的权重（注意这里是**样本的权重**）。
  * 然后再用**新的样本权重**训练数据，得到新的分类器。
  * 多次迭代，直到分类器错误率为0或者整体弱分类器错误为0，或者到达迭代次数。
  * 将所有弱分类器的结果加权求和，得到一个较为准确的分类结果。错误率低的分类器获得更高的决定系数，从而在对数据进行预测时起关键作用。

## 13. AdaBoost的优点和缺点

* 优点
  * Adaboost提供一种框架，在框架内可以使用各种方法构建子分类器。可以使用简单的弱分类器，不用对特征进行筛选，也不存在过拟合的现象。
  * Adaboost算法不需要弱分类器的先验知识，最后得到的强分类器的分类精度依赖于所有弱分类器。无论是应用于人造数据还是真实数据，Adaboost都能显著的提高学习精度。
  * Adaboost算法不需要预先知道弱分类器的错误率上限，且最后得到的强分类器的分类精度依赖于所有弱分类器的分类精度，可以深挖分类器的能力。
  * Adaboost可以根据弱分类器的反馈，自适应地调整假定的错误率，执行的效率高。
  * Adaboost对同一个训练样本集训练不同的弱分类器，按照一定的方法把这些弱分类器集合起来，构造一个分类能力很强的强分类器，即“三个臭皮匠赛过一个诸葛亮"”。
* 缺点
  * 在Adaboost训练过程中，Adaboost会使得难于分类样本的权值呈指数增长，训练将会过于偏向这类困难的样本，导致Adaboost算法易受噪声干扰。
  * Adaboost依赖于弱分类器，而弱分类器的训练时间往往很长。

## 14. Adaboost对噪声敏感吗？

在Adaboost训练过程中，Adaboost会使得难于分类样本的权值呈指数增长，训练将会过于偏向这类困难的样本，导致Adaboost算法易受噪声干扰。

## 15. Adaboost和随机森林算法的异同点

随机森林和Adaboost算法都可以用来分类，它们都是优秀的基于决策树的组合算法。

* 相同之处
  * 二者都是Bootstrap自助法选取样本。
  * 二者都是要训练很多棵决策树。
* 不同之处
  * Adaboost是基于Boosting的算法，随机森林是基于Bagging的算法。
  * Adaboost后面树的训练，其在变量抽样选取的时候，对于上一棵树分错的样本，抽中的概率会加大。
  * 随机森林在训练每一棵树的时候，随机挑选了部分特征作为拆分特征，而不是所有的特征都去作为拆分特征。
  * 在预测新数据时，Adaboost中所有的树加权投票来决定因变量的预测值，每棵树的权重和错误率有关；随机森林按照所有树中少数服从多数树的分类值来决定因变量的预测值（或者求取树预测的平均值）。
