

# 集成学习面试题

## 1. 什么是集成学习算法？

**集成学习算法是一种优化手段或者策略**，将多个较弱的模型集成模型组，一般的弱分类器可以是决策树，SVM，KNN等构成。其中的模型可以单独进行训练，并且它们的预测能以某种方式结合起来去做出一个总体预测。

## 2. 集成学习主要有哪几种框架？

集成学习从集成思想的架构分为Bagging，Boosting，Stacking三种。

## 3. 简单介绍一下bagging，常用bagging算法有哪些？

* Bagging
  * **多次采样，训练多个分类器，集体投票，旨在减小方差**，
* 基于数据**随机重抽样**的分类器构建方法。从训练集中进行子抽样组成每个基模型所需要的子训练集，对所有基模型预测的结果进行综合产生最终的预测结果。
  
* 算法流程：
  * 输入为样本集$D={(x_1，y_1)，(x_2，y_2) \dots (x_m，y_m)}$，弱学习器算法，弱分类器迭代次数$T$。
  * 输出为最终的强分类器$f(x)$

* 对于$t=1，2 \dots T$
  * 对训练集进行第t次随机采样，共采集$T$次，得到包含$T$个样本的采样集$D_t$
  * 用采样集$D_t$训练第$t$个弱学习器$G_t(x)$

* 如果是分类算法预测，则$T$个弱学习器投出最多票数的类别或者类别之一为最终类别。如果是回归算法，$T$个弱学习器得到的回归结果进行算术平均得到的值为最终的模型输出。
* 常用bagging算法：随机森林算法

## 4. 简单介绍一下boosting，常用boosting算法有哪些？

* Boosting
  * **基分类器层层叠加，聚焦分错的样本，旨在减小方差**
* 训练过程为阶梯状，基模型按次序进行训练（实现上可以做到并行），基模型的训练集按照某种策略每次都进行一定的转化，每次都是提高前一次分错了的数据集的权值，最后对所有基模型预测的结果进行线性组合产生最终的预测结果。
  
* 算法流程：

  * 给定初始训练数据，由此训练出第一个基学习器；

  * 根据基学习器的表现对样本进行调整，在之前学习器做错的样本上投入更多关注；
  * 用调整后的样本，训练下一个基学习器；
  * 重复上述过程T次，将T个学习器加权结合。

* 常用boosting算法：
  * Adaboost
  * GBDT
  * XGBoost

## 5. boosting思想的数学表达式是什么？

$$
f(x)=w_{0}+\sum_{m=1}^{M} w_{m} \phi_{m}(x)
$$

其中$w$是权重，$\phi$是弱分类器的集合，可以看出最终就是基函数的线性组合。

## 6. 简单介绍一下stacking

* Stacking
  * **多次采样，训练多个分类器，将输出作为最后的输入特征**
* 将训练好的所有基模型对训练集进行预测，第个$i$基模型对第$i$个训练样本的预测值将作为新的训练集中第$i$个样本的第$i$个特征值，最后基于新的训练集进行训练。同理，预测的过程也要先经过所有基模型的预测形成新的测试集，最后再对测试集进行预测。
  
* stacking常见的使用方式：
  * 由k-NN、随机森林和朴素贝叶斯基础分类器组成，它的预测结果由作为元分类器的逻回归组合。

## 7. 你意识到你的模型受到低偏差和高方差问题的困扰，应该使用哪种算法来解决问题呢？为什么？

低偏差意味着模型的预测值接近实际值。换句话说，该模型有足够的灵活性，以模仿训练数据的分布。貌似很好，但是别忘了，一个灵活的模型没有泛化能力。这意味着，当这个模型用在对一个未曾见过的数据集进行测试的时候，它会令人很失望。
在这种情况下，我们可以使用bagging算法（如随机森林），以解决高方差问题。bagging算法把数据集分成重复随机取样形成的子集。然后，这些样本利用单个学习算法生成一组模型。接着，利用投票（分类）或平均（回归）把模型预测结合在一起。另外，为了应对大方差，我们可以：

* 使用正则化技术，惩罚更高的模型系数，从而降低了模型的复杂性。
* 使用可变重要性图表中的前n个特征。
* 可以用于当一个算法在数据集中的所有变量里很难寻找到有意义信号的时候。

## 8. 常用的基分类器是什么？

最常用的基分类器是决策树,原因:

* 决策树可以较为方便地将样本的权重整合到训练过程中，而不需要使用过采样的方法来调整样本权重。
* 决策树的表达能力和泛化能力，可以通过调节树的层数来做折中。
* 数据样本的扰动对于决策树的影响较大，因此不同子样本集合生成的决策树基分类器随机性较大，这样的“不稳定学习器”更适合作为基分类器。此外，在决策树节点分裂的时候，随机地选择一个特征子集，从中找出最优分裂属性，**很好地引入了随机性。**

## 9. 可否将随机森林中的基分类器，由决策树替换为线性分类器或K-近邻？请解释为什么？
不能：

* Bagging的主要好处是集成后的分类器的方差，比基分类器的方差小。
* 随机森林属于Bagging类的集成学习，对样本分布较为敏感的分类器更适用于Bagging。

* 线性分类器或者K-近邻都是较为稳定的分类器，本身方差就不大。
* 线性分类器或者K-近邻可能会由于Bagging的采样，导致在训练中更难收敛，增大偏差。

## 10. GBDT和RF如何计算特征重要性

* RF有两种方法：
  - 通过计算Gini系数的减少量VIm=GI−(GIL+GIR)判断特征重要性，越大越重要。
  - 对于一颗树，先使用**袋外错误率**(OOB)样本计算测试误差a，再随机打乱OOB样本中第i个特征（上下打乱特征矩阵第i列的顺序）后计算测试误差b，a与b差距越大特征i越重要。

- GBDT计算方法：
  - 所有回归树中通过特征i分裂后平方损失的减少值的和/回归树数量 得到特征重要性。 在sklearn中，GBDT和RF的特征重要性计算方法是相同的，都是基于单棵树计算每个特征的重要性，探究每个特征在每棵树上做了多少的贡献，再取个平均值。

- Xgb主要有三种计算方法：
  - importance_type=weight（默认值），特征重要性使用特征在所有树中作为划分属性的次数。
  - mportance_type=gain，特征重要性使用特征在作为划分属性时loss平均的降低量。
  - importance_type=cover，特征重要性使用特征在作为划分属性时对样本的覆盖度。