

# Catboost面试题

## 1. 简单介绍Catboost？

CatBoost是一种以对称决策树 为基学习器的GBDT框架，主要为例合理地**处理类别型特征**，CatBoost是由Categorical和Boosting组成。CatBoost还解决了**梯度偏差**以及**预测偏移**的问题，从而减少过拟合的发生，进而提高算法的准确性和泛化能力。

## 2. 相比于XGBoost、LightGBM，CatBoost的创新点有哪些？

- 自动将类别型特征处理为数值型特征。 
- Catboost对**类别特征进行组合**，极大的丰富了特征维度。
- 采用**排序提升**的方法对抗训练集中的噪声点，从而避免梯度估计的偏差，进而解决预测偏移的问题。
- 采用了**完全对称树**作为基模型。

## 3. Catboost是如何处理类别特征的？

- 基数比较低的类别型特征

  利用One-hot编码方法将特征转为数值型

- 基数比较高的类别型特征

  - 首先会计算一些数据的statistics。计算某个category出现的频率，加上超参数，生成新的numerical features。这一策略要求同一标签数据不能排列在一起（即先全是之后全是这种方式），训练之前需要打乱数据集。
  - 第二，使用数据的不同排列（实际上是个）。在每一轮建立树之前，先扔一轮骰子，决定使用哪个排列来生成树。
  - 第三，考虑使用categorical features的不同组合。例如颜色和种类组合起来，可以构成类似于blue dog这样的特征。当需要组合的categorical features变多时，CatBoost只考虑一部分combinations。在选择第一个节点时，只考虑选择一个特征，例如A。在生成第二个节点时，考虑A和任意一个categorical feature的组合，选择其中最好的。就这样使用贪心算法生成combinations。
  - 第四，除非向gender这种维数很小的情况，不建议自己生成One-hot编码向量，最好交给算法来处理。

## 4. Catboost如何避免梯度偏差

经典梯度提升算法每个步骤中使用的梯度由当前模型中的相同的数据点(节点)来估计，这导致估计梯度在特征空间的任何域中的分布与该域中梯度的真实分布相比发生了偏移，从而导致过拟合。

对于每一个样本单独训练一个模型，使用模型估计样本的梯度，并用估计的结果对模型进行评分



## 5. Catboost如何避免预测偏移？

预测偏移是由梯度偏差造成的。在GDBT的每一步迭代中, 损失函数使用相同的数据集求得当前模型的梯度, 然后训练得到基学习器, 但这会导致梯度估计偏差, 进而导致模型产生过拟合的问题。CatBoost通过采用**排序提升** 的方式替换传统算法中梯度估计方法，进而减轻梯度估计的偏差。

## 6. 解释一下排序提升

在传统的GBDT框架当中，构建下一棵树分为两个阶段：选择树结构和在树结构固定后计算叶子节点的值。CatBoost主要在第一阶段进行优化。在建树的阶段，CatBoost有两种提升模式，Ordered和Plain。Plain模式是采用内建的ordered TS对类别型特征进行转化后的标准GBDT算法。Ordered则是对Ordered boosting算法的优化。

## 7. Catboost为什么要使用对称树？

- 对称树是平衡的，不容易过拟合

- 统一层使用相同的分割准则

- 每个叶子节点的索引可以被编码为长度等于树深度的二进制向量

  首先将所有浮点特征、统计信息和独热编码特征进行二值化，然后使用二进制特征来计算模型预测值

## 8. CatBoost的优缺点

**优点：**

- **性能卓越：** 在性能方面可以匹敌任何先进的机器学习算法；
- **鲁棒性/强健性：** 它减少了对很多超参数调优的需求，并降低了过度拟合的机会，这也使得模型变得更加具有通用性；
- **实用：** 可以处理类别型、数值型特征；
- **可扩展：** 支持自定义损失函数；

**缺点：**

- 对于类别型特征的处理需要大量的内存和时间；
- 不同随机数的设定对于模型预测结果有一定的影响；



