

# 协同过滤面试题

## 1. 协同过滤推荐有哪些类型

* 基于用户(user-based)的协同过滤

  基于用户(user-based)的协同过滤主要考虑的是用户和用户之间的相似度，只要找出相似用户喜欢的物品，并预测目标用户对对应物品的评分，就可以找到评分最高的若干个物品推荐给用户。 

* 基于项目(item-based)的协同过滤

  基于项目(item-based)的协同过滤和基于用户的协同过滤类似，只不过这时我们转向找到物品和物品之间的相似度，只有找到了目标用户对某些物品的评分，那么我们就可以对相似度高的类似物品进行预测，将评分最高的若干个相似物品推荐给用户 

* 基于模型(model based)的协同过滤 

  用机器学习的思想来建模解决，主流的方法可以分为：用关联算法，聚类算法，分类算法，回归算法，矩阵分解，神经网络,图模型以及隐语义模型来解决。

## 2. 基于模型的协同过滤

* 用关联算法做协同过滤

  做频繁集挖掘，找到满足支持度阈值的关联物品的频繁N项集或者序列。将频繁项集或序列里的其他物品按一定的评分准则推荐给用户，这个评分准则可以包括**支持度**，**置信度**和**提升度**等。 常用的关联推荐算法有**Apriori**，**FP Tree**和**PrefixSpan** 

* 用聚类算法做协同过滤

  - 基于用户聚类，则可以将用户按照一定距离度量方式分成不同的目标人群，将**同样目标人群评分高的物品推荐给目标用户**。

  - 基于物品聚类，则是**将用户评分高物品的相似同类物品推荐给用户**。常用的聚类推荐算法有**K-Means**, **BIRCH**, **DBSCAN**和**谱聚类**

* 用分类算法做协同过滤

  设置一份评分阈值，评分高于阈值的就是推荐，评分低于阈值就是不推荐，我们**将问题变成了一个二分类问题**。虽然分类问题的算法多如牛毛，但是目前使用最广泛的是逻辑回归。因为**逻辑回归的解释性比较强**，每个物品是否推荐我们都有一个明确的概率放在这，同时可以对数据的特征做工程化，得到调优的目的。常见的分类推荐算法有逻辑回归和朴素贝叶斯，两者的特点是解释性很强。

* 用回归算法做协同过滤

  评分可以是一个连续的值而不是离散的值，**通过回归模型**我们可以得到目标用户对某商品的**预测打分**。常用的回归推荐算法有Ridge回归，回归树和支持向量回归。

* 用矩阵分解做协同过滤

  用矩阵分解做协同过滤是目前使用也很广泛的一种方法。由于传统的奇异值分解SVD要求矩阵不能有缺失数据，必须是稠密的，而我们的用户物品评分矩阵是一个很典型的稀疏矩阵，直接使用传统的SVD到协同过滤是比较复杂的。 

* 用神经网络做协同过滤

  用神经网络乃至深度学习做协同过滤应该是以后的一个趋势。目前比较主流的用两层神经网络来做推荐算法的是限制玻尔兹曼机(RBM) 

* 用隐语义模型做协同过滤

  隐语义模型主要是基于NLP的，涉及到**对用户行为的语义分析来做评分推荐**，主要方法有隐性语义分析LSA和隐含狄利克雷分布LDA，

* 用图模型做协同过滤

  用图模型做协同过滤，则将用户之间的相似度放到了一个图模型里面去考虑，常用的算法是SimRank系列算法和马尔科夫模型算法。

## 3. 频繁项集的评估标准

* 支持度: 

  * 支持度就是几个关联的数据在数据集中出现的次数占总数据集的比重。或者说几个数据关联出现的概率。 
    $$
    \text {Support} (X, Y)=P(X Y)=\frac{\text { number }(X Y)}{\text { num (AllSamples) }}
    $$
    

* 置信度:

  *  一个数据出现后，另一个数据出现的概率，或者说数据的条件概率。 
    $$
    \text {Confidence }(X \Leftarrow Y)=P(X | Y)=\frac{P(X Y)}{ P(Y)}
    $$

* 提升度 ：

  *  提升度表示含有Y的条件下，同时含有X的概率，与X总体发生的概率之比 
    $$
    \text {Lift }(X \Leftarrow Y)=\frac{P(X | Y)}{ P(X)} = \frac{\text { Confidence }(X \Leftarrow Y) }{ P(X)}
    $$

* 注意：
  *  支持度高的数据不一定构成频繁项集，但是支持度太低的数据肯定不构成频繁项集。 
  *  提升度体先了$X$和$Y$之间的关联关系, 提升度大于1则$X\Leftarrow Y$是有效的强关联规则， 提升度小于等于1则$X\Leftarrow Y$是无效的强关联规则 。一个特殊的情况，如果$X$和$Y$独立,则$\operatorname{Lift}(X \Leftarrow Y)=1$，因此$P(X | Y)=P(X)$

## 4. 使用Aprior算法找出频繁k项集

输入：数据集合$D$，支持度阈值$\alpha$

输出：最大的频繁$k$项集

* 扫描整个数据集，得到所有出现过的数据，作为候选频繁1项集。$k=1$，频繁0项集为空集。

* 挖掘频繁$k$项集
  * 扫描数据计算候选频繁$k$项集的支持度
  * 去除候选频繁$k$项集中支持度低于阈值的数据集,得到频繁$k$项集。如果得到的频繁$k$项集为空，则直接返回频繁$k-1$项集的集合作为算法结果，算法结束。如果得到的频繁$k$项集只有一项，则直接返回频繁$k$项集的集合作为算法结果，算法结束。
  * 基于频繁$k$项集，连接生成候选频繁$k+1$项集。

* 令$k=k+1$，转入步骤挖掘频繁$k$项集。

从算法的步骤可以看出，Aprior算法每轮迭代都要扫描数据集，因此在数据集很大，数据种类很多的时候，算法效率很低。

具体实现:

<img src="https://images2015.cnblogs.com/blog/1042406/201701/1042406-20170117161036255-1753157633.png" style="zoom:50%;" />

## 5. 使用Aprior算法找出强关联规则

- 强关联规则:

  -  如果规则$R$:$\Rightarrow $满足 :

  $$
  \tag{1} { support }(X \Rightarrow Y) \geq \min {sup}
  $$

  $$
  \tag{2} confidence (X \Rightarrow Y) \geq \min conf
  $$

  称关联规则$X\Rightarrow Y$为强关联规则,否则称关联规则$X\Rightarrow Y$为弱关联规则。在挖掘关联规则时,产生的关联规则要经过$\min sup$和$\min conf$的衡量筛选出来的强关联规则才能用商家的决策 

