# 静态语义表示方法

## 知识体系

主要包括词袋模型 BoW、TFIDF、LDA、Word2vec、Golve、Doc2Vec 等。


## Questions
### 在小数据集中 Skip-Gram 和 CBoW 哪种表现更好？

Skip-Gram 是用一个 Center Word 预测其 Context 里的 Word；而 CBoW 是用 Context 里的所有 Word 去预测一个 Center Word。显然，前者对训练数据的利用更高效（构造的数据集多），因此，对于较小的语料库，Skip-Gram是更好的选择。

### 为什么要使用HS（Hierarchical Softmax ）和负采样（Negative Sampling）？

两个模型的原始做法都是做内积，经过 Softmax 后得到概率，因此复杂度很高。假设我们拥有一个百万量级的词典，每一步训练都需要计算上百万次词向量的内积，显然这是无法容忍的。因此人们提出了两种较为实用的训练技巧，即 HS 和 Negative Sampling。

### 介绍一下HS（Hierarchical Softmax ）

HS 是试图用词频建立一棵哈夫曼树，那么经常出现的词路径会比较短。树的叶子节点表示词，共词典大小多个，而非叶子结点是模型的参数，比词典个数少一个。要预测的词，转化成预测从根节点到该词所在叶子节点的路径，是多个二分类问题。本质是把 N 分类问题变成 log(N) 次二分类

### 介绍一下负采样（Negative Sampling）

把原来的 Softmax 多分类问题，直接转化成一个正例和多个负例的二分类问题。让正例预测 1，负例预测 0，这样子更新局部的参数。.

### 负采样为什么要用词频来做采样概率？

可以让频率高的词先学习，然后带动其他词的学习。

### 负采样有什么作用？

- 可以大大降低计算量，加快模型训练时间
- 保证模型训练效果，因为目标词只跟相近的词有关，没有必要使用全部的单词作为负例来更新它们的权重

### 对比 Skip-Gram 和 CBOW

CBOW 会比 Skip-Gram 训练速度更快，因为前者每次会更新 Context(w) 的词向量，而 Skip-Gram 只更新核心词的词向量。
Skip-Gram 对低频词效果比 CBOW 好，因为 SkipGram 是尝试用当前词去预测上下文，当前词是低频词还是高频词没有区别。但是 CBOW 相当于是完形填空，会选择最常见或者说概率最大的词来补全，因此不太会选择低频词。

### 对比字向量和词向量

字向量可以解决未登录词的问题，以及可以避免分词；词向量包含的语义空间更大，更加丰富，如果语料足够的情况下，词向量是能够学到更多的语义信息。

### 如何衡量 Word2vec 得出的词/字向量的质量？

在实际工程中一般以 Word Embedding 对于实际任务的收益为评价标准，包括词汇类比任务（如 king – queen = man - woman）以及 NLP 中常见的应用任务，比如命名实体识别（NER），关系抽取（RE）等。

### 神经网络框架里的 Embedding 层和 Word Embedding 有什么关系？

Embedding 层就是以 One-Hot 为输入（实际一般输入字或词的 id）、中间层节点为字向量维数的全连接层。而这个全连接层的参数，就是一个 “词向量表”，即 Word Embedding。
### Word2vec 的缺点？
没有考虑词序，因为它假设了词的上下文无关(把概率变为连乘)；没有考虑全局的统计信息。

### LDA 的原理？

LDA 是 pLSA 的贝叶斯版本，pLSA 是使用生成模型建模文章的生成过程，它假定 K 个主题 Z，对于文档集 D 中每个文档 Di 都包含 Ni 个词 W，对每个 Wi，最大化给定文档 Di 生成主题 Zi，再根据 Di 和 Zi 生成 Wi 的概率，最终生成整个文档序列。

LDA 将每篇文章的主题分布和每个主题对应的词分布看成是一种先验分布，即狄利克雷分布。之所以选择该分布，是因为它是多项式分布的共轭先验概率分布，后验分布依然服从狄利克雷分布，方便计算。

具体过程为：首先从超参数为 α 的狄利克雷分布中抽样生成给定文档的主题分布 θ，对于文档中的每一个词，从多项式分布 θ 中抽样生成对应的主题 z，从超参数为 β 的狄利克雷分布中抽样生成给定主题 z 的词分布 φ，从多项式分布 φ 中抽样生成词 w。

LDA 的主题数为超参数，一般使用验证集评估 ppl 或 HDP-LDA。

### Word2vec 和 TF-IDF 在计算相似度时的区别？

- 前者是稠密向量，后者是稀疏向量
- 前者维度低很多，计算更快
- 前者可以表达语义信息，后者不行
- 前者可以通过计算余弦相似度计算两个向量的相似度，后者不行

### 为什么训练得到的字词向量会有如下一些性质，比如向量的夹角余弦、向量的欧氏距离都能在一定程度上反应字词之间的相似性？

因为我们在用语言模型无监督训练时，是开了窗口的，通过前 n 个字预测下一个字的概率，这个 n 就是窗口的大小，同一个窗口内的词语，会有相似的更新，这些更新会累积，而具有相似模式的词语就会把这些相似更新累积到可观的程度。

### Word2vec 与 Glove的异同？

在 Word2vec 中，高频的词共现只是产生了更多的训练数据，并没有携带额外的信息；Glove 加入词的全局共现频率信息。它基于词上下文矩阵的矩阵分解技术，首先构建一个大的单词×上下文共现矩阵，然后学习低维表示，可以视为共现矩阵的重构问题。

- Word2vec 是局部语料训练，特征提取基于滑动窗口；Glove 的滑动窗口是为了构建共现矩阵，统计全部语料在固定窗口内词的共现频次。
- Word2vec 损失函数是带权重的交叉熵；Glove 的损失函数是最小平方损失
- Glove 利用了全局信息，训练时收敛更快

### Word2vec 相比之前的 Word Embedding 方法好在什么地方？

考虑了上下文。

### Doc2vec 原理？

Doc2vec 是训练文档表征的，在输入层增加了一个 Doc 向量。有两种不同的训练方法：Distributed Memory  是给定上下文和段落向量的情况下预测单词的概率。在一个句子或者段落文档训练过程中，段落 ID 保存不变，共享同一个段落向量。Distributed Bag of Words 则在只给定段落向量的情况下预测段落中一组随机单词的概率。使用时固定词向量，随机初始化 Doc 向量，训练几个步骤后得到最终 Doc 向量。

### FastText 相比 Word2vec 有哪些不同？

- FastText 增加了 Ngram 特征，可以更好地解决未登录词及在小数据集上训练的问题
- FastText 是一个工具包，除了可以训练词向量还可以训练有监督的文本分类模型

## 参考链接

1. [https://blog.csdn.net/zhangxb35/article/details/74716245](https://blog.csdn.net/zhangxb35/article/details/74716245)
2. [https://spaces.ac.cn/archives/4122](https://spaces.ac.cn/archives/4122)

