# 基于词角度

## 知识体系

基于词角度的文本结构理解主要包括分词、词性标注和命名实体识别。对于文本未切分的语言，分词一般会作为自然语言处理的第一步。即使到了字粒度的 BERT 时代， WWM 效果也要更好一些。从大的方面看有两种不同的分词方式：基于词典和基于序列标注。后者也可用于词性标注和命名实体识别任务。


## Questions

### 常用的分词方法有哪些？

常用分词方法有两种：基于词典的方法和基于序列标注的方法。前者又包括字符串匹配方法和统计语言模型方法；后者包括统计方法和深度学习方法。

### 字符串匹配分词的优缺点是什么？

优点：方法简单可控、速度快；缺点：难以解决歧义及新词问题。

### 结巴分词原理？

基于词典构造有向无环图，计算最大概率路径。新词发现使用 HMM，弥补了 Ngram 难以发现新词的不足。

### HMM 怎么做分词的？

HMM 使用序列标注法进行分词，以 BEMS 标签为例，此为隐状态取值空间。模型需要估计隐状态初始概率、隐状态之间的转移概率和隐状态到观测序列的发射概率。可以使用有监督或无监督学习算法，有监督学习根据标注数据利用极大似然法进行估计，无监督学习使用 Baum-Welch 算法。实际使用时使用维特比算法进行解码，得到最可能的隐状态序列。

### MEMM 是什么？

HMM 有两个基本假设：齐次一阶马尔科夫和观测独立假设。也就是 t 时刻的状态仅仅与前一个状态有关，同时观测序列仅仅取决于它对应的隐状态。这就和实际不符，因为隐状态往往和上下文信息都有关系。于是在 HMM 的基础上引入了 MEMM，即最大熵马尔科夫模型。它打破了 HMM 的观测独立假设，考虑了整个观测序列。HMM 是一种对隐状态序列和观测状态序列联合概率进行建模的生成式模型；MEMM 是直接对标注后的后验概率进行建模的判别式模型。

### 什么是标注偏置问题？如何解决？

在 MEMM 中需要对局部进行归一化，因此隐状态会倾向于转移到那些后续状态可能更少的状态上（以提高整体的后验概率），这就是标注偏置问题。CRF，条件随机场在 MEMM 的基础上进行了全局归一化，解决了标注偏置问题。这其实已经打破了 HMM 的第一个假设（齐次马尔科夫），将有向变成了无向。

### BILSTM-CRF 原理

BiLSTM 是双向 RNN 模型，每一个 Token 对应一个 Label，可以直接用来做序列标注任务。但是 BiLSTM 在 NER 问题上有个问题，因为 NER 的标签之间往往也有关系，比如形容词后面一半会接名词（中文为例），动词后面会接副词，LSTM 没办法获取这部分特征。这时候我们就需要 CRF 层，简单来说，就是加入 Label 之间的关系特征。也就是说，每一个 Label 在预测时都会考虑全局其他的 Label。

### 如何解决序列标注标签不均衡问题？

在 NER 任务中，标签不均衡一般是指要标注的实体较少，大多数标签为 O 的情况，以及部分实体过多，其他实体过少的情况。一般可以有以下几种处理思路：

- 数据增强，主要是词替换（包括同类实体词替换、同义词替换、代词替换等）、随机增删实体词以外的词构建新样本、继续增加新样本、半监督方法等
- 损失函数，给 loss 增加权重惩罚、Dice Loss 等
- 迁移学习，借助预训练模型已经学到的丰富知识



