---
title: DartPad
description: The tool that lets you interactively play with Dart in a browser.
---

DartPad is an [open source tool]({{site.repo.dart.org}}/dart-pad)
that lets you play with the Dart language in any modern browser.
Many pages in this site—especially [tutorials](/tutorials), have
[embedded DartPads](#embedding).
To open DartPad as a standalone web page, visit 
the [DartPad site (dartpad.dev)][DartPad]{:target="_blank" rel="noopener"}.

:::tip
If you're in China, try [dartpad.cn.](https://dartpad.cn)

If you have issues using DartPad, check out the
[DartPad troubleshooting tips](/tools/dartpad/troubleshoot).
:::

Here's what DartPad looks like when configured to run Dart:

<img 
   src="/assets/img/dartpad-hello.png" 
   alt="Showcases what a Hello World app looks like in DartPad">


## Library support

DartPad supports the `dart:*` [core libraries](/libraries) marked
as [multi-platform][].
When writing Flutter apps, DartPad also supports
the `package:flutter` and `dart:ui` libraries.

DartPad doesn't support [deferred loading][] 
or using packages from the [pub.dev]({{site.pub}}) package repository
besides the [currently supported packages][].

[multi-platform]: /libraries#multi-platform-libraries
[currently supported packages]: {{site.repo.dart.org}}/dart-pad/wiki/Package-and-plugin-support#currently-supported-packages

## Getting started

To get familiar with DartPad,
try running some samples and creating a simple command-line app.


### Open DartPad and run a sample {:#step-1-open-and-run}

1. Go to [DartPad][]{:target="_blank" rel="noopener"}.  
   
   Dart code appears on the left, and 
   a place for the output appears on the right.

2. Choose a Flutter sample such as **Sunflower**, 
   using the **Samples** button in the top menu. 
   
   The rendered output appears to the right.


### Create a command-line app {:#step-2-server}

To create a simple command-line app,
start by creating a new snippet:

1. Click the **New** button,
   and confirm that you want to discard changes to the current pad.

2. Click the entry with the Dart logo.

3. Change the code. For example, change the `main()` function
   to contain this code:  

   ```dart
   for (final char in 'hello'.split('')) {
     print(char);
   }
   ``` 
   
   As you type, DartPad shows hints, documentation,
   and autocomplete suggestions.

4. Click the **Format** button.  
   
   DartPad uses the [Dart formatter](/tools/dart-format)
   to ensure that your code has proper indentation, white space,
   and line wrapping.

5. Run your app.

6. If you didn't happen to have any bugs while you were entering the code,
   try introducing a bug.  

   For example, if you change `split` to `spit`,
   you get warnings at the bottom right of the window.
   If you run the app, a compilation error appears in the console.


## Checking Dart version info

The language features and APIs that DartPad supports depend on the
**Dart SDK** version that DartPad is currently using.
You can find this SDK version at the bottom right of DartPad.

## Embedding DartPad in web pages {:#embedding}

You can embed DartPad inside of web pages,
customizing it to suit your use case.
For example, the [futures tutorial][]
contains multiple embedded DartPads
labeled as _examples_ and _exercises_.

For technical details on embedding DartPads, see the
[DartPad embedding guide.][]

[DartPad]: {{site.dartpad}}
[DartPad embedding guide.]: {{site.repo.dart.org}}/dart-pad/wiki/Embedding-Guide
[deferred loading]: /language/libraries#lazily-loading-a-library
[futures tutorial]: /libraries/async/async-await
