---
title: Dart language specification
short-title: Language specification
description: The formal specification for the Dart language.
---

Use this page to find the formal Dart language specification.
For a gentler introduction to Dart, see the
[language tour](/language).

## Dart 3

The Dart 3 language specification is in progress.
You can find the in-progress specification in PDF format:

* [Latest, in-progress specification][latest draft]
  (produced from a [LaTeX file][])

[latest draft]: https://spec.dart.dev/DartLangSpecDraft.pdf
[LaTeX file]: {{site.repo.dart.lang}}/blob/main/specification/dartLangSpec.tex

New language features are typically described using
informal language feature specifications in the [dart-lang/language][] repo:

* [Accepted informal proposals][]
* [Drafts of potential features][]

[dart-lang/language]: {{site.repo.dart.lang}}
[Accepted informal proposals]: {{site.repo.dart.lang}}/tree/main/accepted
[Drafts of potential features]: {{site.repo.dart.lang}}/tree/main/working

:::version-note
Dart 3 changed the Dart language in a few ways,
primarily requiring [sound null safety](/null-safety).
:::

## Dart 2

The Dart 2 language specification is available in PDF format:

  * [Formal specification (Dart 2.10)][2-10 formal spec]

[2-10 formal spec]: /resources/language/spec/versions/DartLangSpec-v2.10.pdf

For information on Dart versions 2.12 and later, 
which have support for [null safety](/null-safety), 
check out the in-progress [Dart 3 specification](#dart-3).

## Dart 1.x

The formal Dart 1.x language specification is available from
the Ecma International website:

* <a href="https://www.ecma-international.org/publications-and-standards/standards/ecma-408/"
   target="_blank" rel="noopener">Dart Programming Language Specification, 4<sup>th</sup> Edition</a>
