---
title: Deprecated tour of the Dart language
description: The previous destination of the Dart language tour.
short-title: Language tour
js: [{url: '/assets/js/language-tour-redirector.js'}]
sitemap: false
canonical: https://dart.dev/language
noindex: true
skipFreshness: true
show_breadcrumbs: false
---

:::warning
The Dart language tour's content has been split across
several different pages in the left side navigation under **Language**.
To begin your journey learning Dart,
check out [Introduction to the Dart language](/language).
:::

{% comment %}
  !! NOTE:
  
  All new language content should go within the `/language` directory.
  This file exists temporarily for legacy reasons so
  links to the old language tour do not break.
  
  In the short term, if you move content that is referenced here,
  update the text and link in this file, as well as
  the redirection map in `src/assets/js/language-tour-redirector.js`.
{% endcomment -%}

## A basic Dart program

This content has moved to [Introduction to the Dart language](/language).

## Important concepts

This content has moved to [Introduction to the Dart language](/language).

## Keywords

This content has moved to [Keywords](/language/keywords).

## Variables

This content has moved to [Variables](/language/variables).


### Default value

This content has moved to [Variables](/language/variables#default-value).

### Late variables

This content has moved to [Variables](/language/variables#late-variables).

### Final and const


This content has moved to [Variables](/language/variables#final-and-const).

## Built-in types

This content has moved to [Built-in types](/language/built-in-types).

### Numbers

This content has moved to [Built-in types](/language/built-in-types#numbers).

### Strings

This content has moved to [Built-in types](/language/built-in-types#strings).

### Booleans

This content has moved to [Built-in types](/language/built-in-types#booleans).

### Lists

This content has moved to [Collections](/language/collections#lists).

<a id="trailing-comma"></a>
#### Trailing commas

This content has moved to [Collections](/language/collections#trailing-comma).

#### Spread operator

This content has moved to [Collections](/language/collections#spread-operators).

#### Collection operators

This content has moves to [Collections](/language/collections#control-flow-operators).

### Sets

This content has moved to [Collections](/language/collections#sets).

### Maps

This content has moved to [Collections](/language/collections#maps).

<a id="characters"></a>
### Runes and grapheme clusters

This content has moved to [Built-in types](/language/built-in-types#runes-and-grapheme-clusters).

### Symbols

This content has moved to [Built-in types](/language/built-in-types#symbols).

## Functions

This content has moved to [Functions](/language/functions).

### Parameters

This content has moved to [Functions](/language/functions#parameters).

#### Named parameters

This content has moved to [Functions](/language/functions#named-parameters).

#### Default parameters

This content has moved to [Functions](/language/functions#default-parameters).

#### Optional positional parameters

This content has moved to [Functions](/language/functions#optional-positional-parameters).

### The main() function

This content has moved to [Functions](/language/functions#the-main-function).

### Functions as first-class objects

This content has moved to [Functions](/language/functions#functions-as-first-class-objects).

### Anonymous functions

This content has moved to [Functions](/language/functions#anonymous-functions).

### Lexical scope

This content has moved to [Functions](/language/functions#lexical-scope).

### Lexical closures

This content has moved to [Functions](/language/functions#lexical-closures).

### Testing functions for equality

This content has moved to [Functions](/language/functions#testing-functions-for-equality).

### Return values

This content has moved to [Functions](/language/functions#return-values).

## Operators

This content has moved to [Operators](/language/operators).

### Arithmetic operators

This content has moved to [Operators](/language/operators#arithmetic-operators).

### Equality and relational operators

This content has moved to [Operators](/language/operators#equality-and-relational-operators).

### Type test operators

This content has moved to [Operators](/language/operators#type-test-operators).

### Assignment operators

This content has moved to [Operators](/language/operators#assignment-operators).

### Logical operators

This content has moved to [Operators](/language/operators#logical-operators).

### Bitwise and shift operators

This content has moved to [Operators](/language/operators#bitwise-and-shift-operators).

### Conditional expressions

This content has moved to [Operators](/language/operators#conditional-expressions).

<a id="cascade"></a>
### Cascade notation

This content has moved to [Operators](/language/operators#cascade-notation).

### Other operators

This content has moved to [Operators](/language/operators#other-operators).

## Control flow statements

This content has moved to [Control flow](/language/loops).

### If and else

This content has moved to [Control flow](/language/branches#if).

### For loops

This content has moved to [Control flow](/language/loops#for-loops).

### While and do-while

This content has moved to [Control flow](/language/loops#while-and-do-while).

### Break and continue

This content has moved to [Control flow](/language/loops#break-and-continue).

### Switch and case

This content has moved to [Control flow](/language/branches#switch).

### Assert

This content has moved to [Control flow](/language/error-handling#assert).

## Exceptions

This content has moved to [Error handling](/language/error-handling#exceptions).

### Throw

This content has moved to [Error handling](/language/error-handling#throw).

### Catch

This content has moved to [Error handling](/language/error-handling#catch).

### Finally

This content has moved to [Error handling](/language/error-handling#finally).

## Classes

This content has moved to [Classes](/language/classes).


### Using class members

This content has moved to [Classes](/language/classes#using-class-members).


### Using constructors

This content has moved to [Classes](/language/classes#using-constructors).

### Getting an object's type

This content has moved to [Classes](/language/classes#getting-an-objects-type).

### Instance variables

This content has moved to [Classes](/language/classes#instance-variables).

### Constructors

This content has moved to [Constructors](/language/constructors).

#### Initializing formal parameters

This content has moved to [Constructors](/language/constructors#initializing-formal-parameters).

#### Default constructors

This content has moved to [Constructors](/language/constructors#default-constructors).

#### Constructors aren't inherited

This content has moved to [Constructors](/language/constructors#constructors-arent-inherited).

#### Named constructors

This content has moved to [Constructors](/language/constructors#named-constructors).

#### Invoking a non-default superclass constructor

This content has moved to [Constructors](/language/constructors#invoking-a-non-default-superclass-constructor).

### Super parameters

This content has moved to [Constructors](/language/constructors#super-parameters).


#### Initializer list

This content has moved to [Constructors](/language/constructors#initializer-list).


#### Redirecting constructors

This content has moved to [Constructors](/language/constructors#redirecting-constructors).


#### Constant constructors


This content has moved to [Constructors](/language/constructors#constant-constructors).

#### Factory constructors

This content has moved to [Constructors](/language/constructors#factory-constructors).

### Methods

This content has moved to [Methods](/language/methods).

#### Instance methods

This content has moved to [Methods](/language/methods#instance-methods).

#### Operators {:#_operators}

This content has moved to [Methods](/language/methods#operators).


#### Getters and setters

This content has moved to [Methods](/language/methods#getters-and-setters).

#### Abstract methods

This content has moved to [Methods](/language/methods#abstract-methods).

### Abstract classes

This content has moved to [Classes](/language/class-modifiers#abstract).

<a id="interfaces"></a>
### Implicit interfaces

This content has moved to [Classes](/language/classes#implicit-interfaces).

### Extending a class

This content has moved to [Extend a class](/language/extend).

<a id="overridable-operators"></a>
#### Overriding members

This content has moved to [Extend a class](/language/extend#overriding-members).

#### noSuchMethod()

This content has moved to [Extend a class](/language/extend#nosuchmethod).

### Extension methods

This content has moved to [Extension methods](/language/extension-methods).

<a id="enums"></a>
### Enumerated types

This content has moved to [Enumerated types](/language/enums).

#### Declaring simple enums

This content has moved to [Enumerated types](/language/enums#declaring-simple-enums).

#### Declaring enhanced enums

This content has moved to [Enumerated types](/language/enums#declaring-enhanced-enums).

#### Using enums

This content has moved to [Enumerated types](/language/enums#using-enums).

<a id="mixins"></a>
### Adding features to a class: mixins

This content has moved to [Mixins](/language/mixins).

### Class variables and methods

This content has moved to [Classes](/language/classes#class-variables-and-methods).

#### Static variables

This content has moved to [Classes](/language/classes#static-variables).

#### Static methods

This content has moved to [Classes](/language/classes#static-methods).

## Generics

This content has moved to [Generics](/language/generics).

### Why use generics?

This content has moved to [Generics](/language/generics#why-use-generics).

### Using collection literals

This content has moved to [Generics](/language/generics#using-collection-literals).

### Using parameterized types with constructors

This content has moved to [Generics](/language/generics#using-parameterized-types-with-constructors).

### Generic collections and the types they contain

This content has moved to [Generics](/language/generics#generic-collections-and-the-types-they-contain).

### Restricting the parameterized type

This content has moved to [Generics](/language/generics#restricting-the-parameterized-type).

### Using generic methods

This content has moved to [Generics](/language/generics#using-generic-methods).

## Libraries and visibility

This content has moved to [Libraries & visibility](/language/libraries).

### Using libraries

This content has moved to [Libraries & visibility](/language/libraries#using-libraries).

#### Specifying a library prefix

This content has moved to [Libraries & visibility](/language/libraries#specifying-a-library-prefix).

#### Importing only part of a library

This content has moved to [Libraries & visibility](/language/libraries#importing-only-part-of-a-library).

<a id="deferred-loading"></a>
#### Lazily loading a library

This content has moved to [Libraries & visibility](/language/libraries#lazily-loading-a-library).

#### The `library` directive {:#library-directive}

This content has moved to [Libraries & visibility](/language/libraries#library-directive).

### Implementing libraries

This content has moved to [Libraries & visibility](/language/libraries#implementing-libraries).

<a id="asynchrony"></a>
## Asynchrony support

This content has moved to [Asynchrony support](/language/async).

<a id="await"></a>
### Handling Futures

This content has moved to [Asynchrony support](/language/async#handling-futures).

<a id="async"></a>
### Declaring async functions

This content has moved to [Asynchrony support](/language/async#declaring-async-functions).

<a id="await-for"></a>
### Handling Streams

This content has moved to [Asynchrony support](/language/async#handling-streams).

<a id="generator"></a>
## Generators

This content has moved to [Generators](/language/functions#generators).

## Callable classes

This content has moved to [Callable objects](/language/callable-objects).

## Isolates

This content has moved to [Isolates](/language/concurrency).

## Typedefs

This content has moved to [Typedefs](/language/typedefs).


## Metadata

This content has moved to [Metadata](/language/metadata).


## Comments

This content has moved to [Comments](/language/comments).

### Single-line comments

This content has moved to [Comments](/language/comments#single-line-comments).


### Multi-line comments

This content has moved to [Comments](/language/comments#multi-line-comments).

### Documentation comments

This content has moved to [Comments](/language/comments#documentation-comments).
