---
title: Who uses Dart
description: >-
  Mobile and web apps are two of
  the most common uses for the Dart language.
  Learn about and try some examples
  of where Dart is used.
toc: false
---

## Flutter

The popular [Flutter toolkit][] is powered by the
Dart language, runtimes, tooling, and libraries.
Over _one million_ Flutter apps for Android,
iOS, the web, and other targets, are all Dart-based.

The [Flutter showcase][] features popular Flutter apps, including:

* [BMW][]
    > "The BMW Group is establishing itself as a leading automotive app developer
    and provider with a Flutter architecture developed 100% in-house."
* [Sonos][]: 
    > "...If setup is the “grand entryway” to the Sonos ecosystem, Flutter forms
    its elegant façade..."
* [Alibaba][]: 
    > "When the Xianyu team was challenged to improve their user experience by
    developing an app that was consistent across platforms, had beautiful graphics,
    and still loaded fast, they turned to Flutter."
* [PUBG][]: 
    > "When the PUBG MOBILE team wanted to add a community module to allow players
    from all over the world to share gameplay clips and more, they turned to Flutter."

[Flutter toolkit]: {{site.flutter}}
[Flutter showcase]: {{site.flutter}}/showcase
[BMW]: https://www.press.bmwgroup.com/global/article/detail/T0328610EN/the-my-bmw-app:-new-features-and-tech-insights-for-march-2021?language=en
[Sonos]: https://tech-blog.sonos.com/posts/renovating-setup-with-flutter/
[Alibaba]: {{site.flutter}}/showcase/alibaba-group
[PUBG]: {{site.flutter}}/showcase/pubg-mobile

## Google 

Dart is used in almost every product group at Google:

* The [Google Play Console][] lets app publishers market Android apps, and
  is written completely in Dart.
* The [Google Ads][] team continues to grow, with
  hundreds of SWEs primarily writing Dart code.
* The [Google Assistant][] team uses Flutter and Dart to
  drive the overall system UI of their Smart Displays.
* Both the UI and much of the back-end code for the
  [Google Nest Hub][] and Hub Max devices are written in Dart.
* The list goes on, with many more Google applications
  made using Dart and Flutter:

  * [Google Pay][]
  * [Google One][]
  * [Google Fibre][]
  * [Google Elections][]
  * [Google Shopping][]
  * [Cloud Search][]
  * [Family Link][]
  * [Google One][]
  * [Cloud Search][] 

Several other Google teams are currently rewriting their projects in Flutter.
In all, Google has thousands of developers
writing millions of lines of code in Dart.

[Google Play Console]: https://android-developers.googleblog.com/2020/06/introducing-new-google-play-console-beta.html
[Google Ads]: https://ads.google.com/getstarted
[Google Assistant]: https://developers.googleblog.com/2019/05/Flutter-io19.html
[Google Nest Hub]: https://store.google.com/us/product/nest_hub_2nd_gen?hl=en-US
[Google Pay]: https://pay.google.com/intl/en_in/about
[Google Fibre]: https://fiber.google.com
[Google Elections]: https://elections.google
[Google Shopping]: https://shopping.google.com
[Family Link]: https://families.google/familylink
[Google One]: https://one.google.com/about
[Cloud Search]: https://workspace.google.com/intl/en_in/products/cloud-search

## Community

Beyond Google and Flutter, many companies use Dart
for building their applications:

* [Workiva's][] next-generation client applications for
  their productivity suite are built with Dart.
* [Wrike][] uses the [AngularDart][] framework to
  develop project management tools.
* [Blossom][] is an agile project management tool built with Dart.
* And many more!

If you build production software with Dart and want to be included in this list,
please visit [our site's GitHub][] to open an issue or pull request, thanks!

[Workiva's]: https://www.workiva.com/en-in
[Wrike]: https://www.wrike.com
[AngularDart]: https://angulardart.xyz/guide/setup
[Blossom]: https://blossom.co
[our site's GitHub]: {{site.repo.this}}
