---
title: Community and support
description: Communities, mailing lists, and bug databases for the Dart project.
group: https://groups.google.com/a/dartlang.org
---

Track the Dart project, get help, and talk with other Dart developers.

We pledge to maintain an open and welcoming environment.
To learn more about our community standards, check out
our [code of conduct](/community/code-of-conduct).


## Stay informed

[Dart announce]({{group}}/d/forum/announce)
: Low traffic announcements of new releases, breaking changes,
  and other important news. Recommended!

[@dart_lang](https://twitter.com/dart_lang)
: The official X (Twitter) account.

[Dart blog](https://medium.com/dartlang)
: The latest news and insights from a diverse group of Dart users.

## Join the conversation

Get answers and connect with Dart developers.

#### Communities

[StackOverflow](https://stackoverflow.com/tags/dart)
: The best place for how-to questions.

[The dart_community Discord](https://discord.gg/Qt6DgfAWWx)
: Chat with and get help from other Dart developers.

[Dart on Reddit](https://www.reddit.com/r/dartlang)
: The subreddit for all things related to Dart.

[It's All Widgets Flutter Forum](https://forum.itsallwidgets.com/)
: Asynchronously discuss anything Flutter or Dart related.

[Flutter communities]({{site.flutter}}/community#community-grid)
: Discuss and get help with Flutter.

#### Google Groups

[General discussions]({{group}}/d/forum/misc)
: Discuss miscellaneous Dart topics.

[Dart analyzer]({{group}}/d/forum/analyzer-discuss)
: Get help understanding the [Dart analyzer](/tools/dart-analyze).

## Contribute

Dart is open source.
Learn how to
[contribute to the core SDK.]({{site.repo.dart.sdk}}/blob/main/CONTRIBUTING.md)

[Dart GitHub repositories]({{site.repo.dart.org}}/)
: Track new changes and contribute to various Dart projects.
  * [Core SDK]({{site.repo.dart.sdk}}/)
    ([issue tracker]({{site.repo.dart.sdk}}/issues/))
  * [The Dart Language]({{site.repo.dart.lang}})
    ([issue tracker]({{site.repo.dart.lang}}/issues))
  * [This site]({{site.repo.this}}/)
    ([issue tracker]({{site.repo.this}}/issues/))

[Dart reviews]({{group}}/d/forum/reviews)
: High-traffic list of all core SDK code reviews.

## Additional community resources

Our wonderful community has provided these resources:

* [Korean version of this site (한국어)](https://dart-ko.dev/)
* [Simplified Chinese version of this site (简体中文版)](https://dart.cn)
* [Traditional Chinese version of this site (正體中文版)](https://dart.tw.gh.miniasp.com/)
