---
title: Dart brand guidelines
description: >-
  The guidelines governing the usage of the Dart trademarks and assets.
skipFreshness: true
---

The "Dart" name and logo are trademarks owned by Google.
These Brand Guidelines describe the appropriate uses of the Dart
trademarks by members of the developer community who have obtained our
consent to use the trademarks pursuant to the [Dart terms of service](/terms).
These guidelines will ensure that the Dart trademarks are used in a
manner that promotes Google's mission to provide a free and open source
SDK, and are not associated with objectionable
material, as determined by Google.

Use of the Dart trademarks that is not expressly permitted by these
guidelines is prohibited absent written permission from Google.

The official Dart logos can be found in the
[Dart and Flutter logo assets](https://services.google.com/fh/files/misc/dart_brand_guidelines_assets.zip)
archive.

## General rules that govern the use of the Dart trademarks

You are free to use the Dart trademarks: (i) in connection with your
download and use of the Dart SDK to build and develop 
apps, (ii) in training materials (e.g., video tutorials, online publications,
etc.) that provide instructions or tips regarding how to use the Dart
SDK to build and develop apps, and (iii) to show your support for
the use of the Dart SDK by members of the developer community.  

These guidelines do not restrict your right to use the "Dart" name
in connection with descriptions of the Dart SDK that would be
considered "fair use."  For example, you may use the "Dart"
name to make truthful factual statements (e.g., "built with the Dart
SDK") or to accurately describe a feature of the Dart SDK.  

You may use the Dart trademarks on your personal website, personal
blog, or social media account to show your support for the Dart SDK,
provided you do not use the Dart trademarks in a way that
could confuse people into thinking that your site is an official Google
site or that Google has sponsored or endorsed your site. In the case of
websites or personal blogs, this means you should not use the Dart
trademarks as the primary element on the webpage (e.g., in the masthead
of the webpage or the title of the blog). In the case of social media
accounts, this means you should not use the Dart trademarks in the
background, in your profile image or in your social media username.  

## Specific rules for proper usage of the Dart trademarks

In addition to the general rules discussed above, below are specific
rules governing the proper use of the Dart trademarks.  

**DO:**

* Use the "Dart" name as an adjective and never as a verb or in the plural form.
* When using "Dart" as an adjective, follow it with a generic term, 
  for example, "the Dart SDK" or "the Dart platform."
* Distinguish the "Dart" name from the surrounding text in some way.
  Capitalize the first letter, capitalize or italicize the entire mark,
  place the mark in quotes, use a different type style or font for the mark.
* Use the trademark symbol <sup>TM</sup> for the first or most prominent
  time the "Dart" name appears in text on your website or blog.
  Make sure to always use the <sup>TM</sup> symbol,
  not the <sup>&reg;</sup> symbol.
* Include the following text near the first or most prominent use of the
  Dart marks on your website or blog: "Dart and the related logo are
  trademarks of Google LLC. We are not endorsed by or affiliated with
  Google LLC."
* Keep some distance between the Dart trademarks and any other trademarks,
  logos, or icons that are displayed on the webpage.

**DON'T:**

* Don't alter, distort, or modify the Dart trademarks in any way.
  This includes varying the spelling of the "Dart" name, or displaying
  the Dart logo with color variations or unapproved visual elements. 
* Don't combine the Google name with the "Dart" name to form a unitary
  brand (e.g., don't use the phrases "Google Dart" or "Google's Dart").
  You may use the Google name in full text to accurately describe the
  Dart SDK (e.g., "The Dart SDK by Google").
* Don't register the Dart trademarks or any trademarks, logos,
  or domain names that are confusingly similar to them.
* Don't incorporate the Dart trademarks into your own product names,
  service names, trademarks, logos, or company names.   
* Don't display the Dart trademarks in a manner that is misleading,
  unfair, defamatory, infringing, libelous, disparaging, obscene or
  otherwise objectionable to Google.
* Don't use the Dart trademarks on or in connection with the sale of
  any non-software goods or services (e.g., merchandise such as clothing,
  pens, and stickers).

## Community use exceptions

To allow for the use of the Dart trademarks by the Dart community,
below are specific exceptions to the rules described above:  

1. Local Dart user groups may: (i) use the "Dart" name
   as part of their social media username in the following format:
   "Dart + [name of country/city]" (e.g., "Dart France"); and (ii)
   use the Dart logo in the national colors of the country where the
   user group is based (e.g., for a user group based in France,
   the colors blue, white and red), provided the Dart logo is otherwise
   unaltered.  Such social media accounts should include a disclaimer that
   clarifies that it is not an official Google account.

2. You may use the Dart trademarks as part of the name of a newsletter
   or related community content (e.g., Dart training courses,
   Dart community forums) whose purpose is to promote the use of the
   Dart SDK by members of the developer community.
   Where the Dart trademarks are displayed on a website as part of a
   community site name, you should use the trademark symbol <sup>TM</sup>
   after the most prominent appearance of the "Dart" name and include
   the following text: "Dart and the related logo are trademarks of
   Google LLC.  We are not endorsed by or affiliated with Google LLC."
   Where the Dart trademarks are displayed on a social media account
   as part of a community site name, you should include a disclaimer that
   clarifies that it is not an official Google account.
