#region Copyright
////////////////////////////////////////////////////////////////////////////////
// The following FIT Protocol software provided may be used with FIT protocol
// devices only and remains the copyrighted property of Garmin Canada Inc.
// The software is being provided on an "as-is" basis and as an accommodation,
// and therefore all warranties, representations, or guarantees of any kind
// (whether express, implied or statutory) including, without limitation,
// warranties of merchantability, non-infringement, or fitness for a particular
// purpose, are specifically disclaimed.
//
// Copyright 2020 Garmin Canada Inc.
////////////////////////////////////////////////////////////////////////////////
// ****WARNING****  This file is auto-generated!  Do NOT edit this file.
// Profile Version = 21.38Release
// Tag = production/akw/21.38.00-0-g0d69e49
////////////////////////////////////////////////////////////////////////////////

#endregion

using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Text;
using System.IO;
using System.Linq;

namespace Dynastream.Fit
{
    /// <summary>
    /// Implements the ZonesTarget profile message.
    /// </summary>
    public class ZonesTargetMesg : Mesg
    {
        #region Fields
        #endregion

        /// <summary>
        /// Field Numbers for <see cref="ZonesTargetMesg"/>
        /// </summary>
        public sealed class FieldDefNum
        {
            public const byte MaxHeartRate = 1;
            public const byte ThresholdHeartRate = 2;
            public const byte FunctionalThresholdPower = 3;
            public const byte HrCalcType = 5;
            public const byte PwrCalcType = 7;
            public const byte Invalid = Fit.FieldNumInvalid;
        }

        #region Constructors
        public ZonesTargetMesg() : base(Profile.GetMesg(MesgNum.ZonesTarget))
        {
        }

        public ZonesTargetMesg(Mesg mesg) : base(mesg)
        {
        }
        #endregion // Constructors

        #region Methods
        ///<summary>
        /// Retrieves the MaxHeartRate field</summary>
        /// <returns>Returns nullable byte representing the MaxHeartRate field</returns>
        public byte? GetMaxHeartRate()
        {
            Object val = GetFieldValue(1, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToByte(val));
            
        }

        /// <summary>
        /// Set MaxHeartRate field</summary>
        /// <param name="maxHeartRate_">Nullable field value to be set</param>
        public void SetMaxHeartRate(byte? maxHeartRate_)
        {
            SetFieldValue(1, 0, maxHeartRate_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the ThresholdHeartRate field</summary>
        /// <returns>Returns nullable byte representing the ThresholdHeartRate field</returns>
        public byte? GetThresholdHeartRate()
        {
            Object val = GetFieldValue(2, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToByte(val));
            
        }

        /// <summary>
        /// Set ThresholdHeartRate field</summary>
        /// <param name="thresholdHeartRate_">Nullable field value to be set</param>
        public void SetThresholdHeartRate(byte? thresholdHeartRate_)
        {
            SetFieldValue(2, 0, thresholdHeartRate_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the FunctionalThresholdPower field</summary>
        /// <returns>Returns nullable ushort representing the FunctionalThresholdPower field</returns>
        public ushort? GetFunctionalThresholdPower()
        {
            Object val = GetFieldValue(3, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToUInt16(val));
            
        }

        /// <summary>
        /// Set FunctionalThresholdPower field</summary>
        /// <param name="functionalThresholdPower_">Nullable field value to be set</param>
        public void SetFunctionalThresholdPower(ushort? functionalThresholdPower_)
        {
            SetFieldValue(3, 0, functionalThresholdPower_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the HrCalcType field</summary>
        /// <returns>Returns nullable HrZoneCalc enum representing the HrCalcType field</returns>
        public HrZoneCalc? GetHrCalcType()
        {
            object obj = GetFieldValue(5, 0, Fit.SubfieldIndexMainField);
            HrZoneCalc? value = obj == null ? (HrZoneCalc?)null : (HrZoneCalc)obj;
            return value;
        }

        /// <summary>
        /// Set HrCalcType field</summary>
        /// <param name="hrCalcType_">Nullable field value to be set</param>
        public void SetHrCalcType(HrZoneCalc? hrCalcType_)
        {
            SetFieldValue(5, 0, hrCalcType_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the PwrCalcType field</summary>
        /// <returns>Returns nullable PwrZoneCalc enum representing the PwrCalcType field</returns>
        public PwrZoneCalc? GetPwrCalcType()
        {
            object obj = GetFieldValue(7, 0, Fit.SubfieldIndexMainField);
            PwrZoneCalc? value = obj == null ? (PwrZoneCalc?)null : (PwrZoneCalc)obj;
            return value;
        }

        /// <summary>
        /// Set PwrCalcType field</summary>
        /// <param name="pwrCalcType_">Nullable field value to be set</param>
        public void SetPwrCalcType(PwrZoneCalc? pwrCalcType_)
        {
            SetFieldValue(7, 0, pwrCalcType_, Fit.SubfieldIndexMainField);
        }
        
        #endregion // Methods
    } // Class
} // namespace
