#region Copyright
////////////////////////////////////////////////////////////////////////////////
// The following FIT Protocol software provided may be used with FIT protocol
// devices only and remains the copyrighted property of Garmin Canada Inc.
// The software is being provided on an "as-is" basis and as an accommodation,
// and therefore all warranties, representations, or guarantees of any kind
// (whether express, implied or statutory) including, without limitation,
// warranties of merchantability, non-infringement, or fitness for a particular
// purpose, are specifically disclaimed.
//
// Copyright 2020 Garmin Canada Inc.
////////////////////////////////////////////////////////////////////////////////
// ****WARNING****  This file is auto-generated!  Do NOT edit this file.
// Profile Version = 21.38Release
// Tag = production/akw/21.38.00-0-g0d69e49
////////////////////////////////////////////////////////////////////////////////

#endregion

using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Text;
using System.IO;
using System.Linq;

namespace Dynastream.Fit
{
    /// <summary>
    /// Implements the WorkoutStep profile message.
    /// </summary>
    public class WorkoutStepMesg : Mesg
    {
        #region Fields
        static class DurationValueSubfield
        {
            public static ushort DurationTime = 0;
            public static ushort DurationDistance = 1;
            public static ushort DurationHr = 2;
            public static ushort DurationCalories = 3;
            public static ushort DurationStep = 4;
            public static ushort DurationPower = 5;
            public static ushort DurationReps = 6;
            public static ushort Subfields = 7;
            public static ushort Active = Fit.SubfieldIndexActiveSubfield;
            public static ushort MainField = Fit.SubfieldIndexMainField;
        }
        static class TargetValueSubfield
        {
            public static ushort TargetSpeedZone = 0;
            public static ushort TargetHrZone = 1;
            public static ushort TargetCadenceZone = 2;
            public static ushort TargetPowerZone = 3;
            public static ushort RepeatSteps = 4;
            public static ushort RepeatTime = 5;
            public static ushort RepeatDistance = 6;
            public static ushort RepeatCalories = 7;
            public static ushort RepeatHr = 8;
            public static ushort RepeatPower = 9;
            public static ushort TargetStrokeType = 10;
            public static ushort Subfields = 11;
            public static ushort Active = Fit.SubfieldIndexActiveSubfield;
            public static ushort MainField = Fit.SubfieldIndexMainField;
        }
        static class CustomTargetValueLowSubfield
        {
            public static ushort CustomTargetSpeedLow = 0;
            public static ushort CustomTargetHeartRateLow = 1;
            public static ushort CustomTargetCadenceLow = 2;
            public static ushort CustomTargetPowerLow = 3;
            public static ushort Subfields = 4;
            public static ushort Active = Fit.SubfieldIndexActiveSubfield;
            public static ushort MainField = Fit.SubfieldIndexMainField;
        }
        static class CustomTargetValueHighSubfield
        {
            public static ushort CustomTargetSpeedHigh = 0;
            public static ushort CustomTargetHeartRateHigh = 1;
            public static ushort CustomTargetCadenceHigh = 2;
            public static ushort CustomTargetPowerHigh = 3;
            public static ushort Subfields = 4;
            public static ushort Active = Fit.SubfieldIndexActiveSubfield;
            public static ushort MainField = Fit.SubfieldIndexMainField;
        }
        #endregion

        /// <summary>
        /// Field Numbers for <see cref="WorkoutStepMesg"/>
        /// </summary>
        public sealed class FieldDefNum
        {
            public const byte MessageIndex = 254;
            public const byte WktStepName = 0;
            public const byte DurationType = 1;
            public const byte DurationValue = 2;
            public const byte TargetType = 3;
            public const byte TargetValue = 4;
            public const byte CustomTargetValueLow = 5;
            public const byte CustomTargetValueHigh = 6;
            public const byte Intensity = 7;
            public const byte Notes = 8;
            public const byte Equipment = 9;
            public const byte ExerciseCategory = 10;
            public const byte ExerciseName = 11;
            public const byte ExerciseWeight = 12;
            public const byte WeightDisplayUnit = 13;
            public const byte Invalid = Fit.FieldNumInvalid;
        }

        #region Constructors
        public WorkoutStepMesg() : base(Profile.GetMesg(MesgNum.WorkoutStep))
        {
        }

        public WorkoutStepMesg(Mesg mesg) : base(mesg)
        {
        }
        #endregion // Constructors

        #region Methods
        ///<summary>
        /// Retrieves the MessageIndex field</summary>
        /// <returns>Returns nullable ushort representing the MessageIndex field</returns>
        public ushort? GetMessageIndex()
        {
            Object val = GetFieldValue(254, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToUInt16(val));
            
        }

        /// <summary>
        /// Set MessageIndex field</summary>
        /// <param name="messageIndex_">Nullable field value to be set</param>
        public void SetMessageIndex(ushort? messageIndex_)
        {
            SetFieldValue(254, 0, messageIndex_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the WktStepName field</summary>
        /// <returns>Returns byte[] representing the WktStepName field</returns>
        public byte[] GetWktStepName()
        {
            byte[] data = (byte[])GetFieldValue(0, 0, Fit.SubfieldIndexMainField);
            return data.Take(data.Length - 1).ToArray();
        }

        ///<summary>
        /// Retrieves the WktStepName field</summary>
        /// <returns>Returns String representing the WktStepName field</returns>
        public String GetWktStepNameAsString()
        {
            byte[] data = (byte[])GetFieldValue(0, 0, Fit.SubfieldIndexMainField);
            return data != null ? Encoding.UTF8.GetString(data, 0, data.Length - 1) : null;
        }

        ///<summary>
        /// Set WktStepName field</summary>
        /// <param name="wktStepName_"> field value to be set</param>
        public void SetWktStepName(String wktStepName_)
        {
            byte[] data = Encoding.UTF8.GetBytes(wktStepName_);
            byte[] zdata = new byte[data.Length + 1];
            data.CopyTo(zdata, 0);
            SetFieldValue(0, 0, zdata, Fit.SubfieldIndexMainField);
        }

        
        /// <summary>
        /// Set WktStepName field</summary>
        /// <param name="wktStepName_">field value to be set</param>
        public void SetWktStepName(byte[] wktStepName_)
        {
            SetFieldValue(0, 0, wktStepName_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the DurationType field</summary>
        /// <returns>Returns nullable WktStepDuration enum representing the DurationType field</returns>
        public WktStepDuration? GetDurationType()
        {
            object obj = GetFieldValue(1, 0, Fit.SubfieldIndexMainField);
            WktStepDuration? value = obj == null ? (WktStepDuration?)null : (WktStepDuration)obj;
            return value;
        }

        /// <summary>
        /// Set DurationType field</summary>
        /// <param name="durationType_">Nullable field value to be set</param>
        public void SetDurationType(WktStepDuration? durationType_)
        {
            SetFieldValue(1, 0, durationType_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the DurationValue field</summary>
        /// <returns>Returns nullable uint representing the DurationValue field</returns>
        public uint? GetDurationValue()
        {
            Object val = GetFieldValue(2, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToUInt32(val));
            
        }

        /// <summary>
        /// Set DurationValue field</summary>
        /// <param name="durationValue_">Nullable field value to be set</param>
        public void SetDurationValue(uint? durationValue_)
        {
            SetFieldValue(2, 0, durationValue_, Fit.SubfieldIndexMainField);
        }
        

        /// <summary>
        /// Retrieves the DurationTime subfield
        /// Units: s</summary>
        /// <returns>Nullable float representing the DurationTime subfield</returns>
        public float? GetDurationTime()
        {
            Object val = GetFieldValue(2, 0, DurationValueSubfield.DurationTime);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        ///
        /// Set DurationTime subfield
        /// Units: s</summary>
        /// <param name="durationTime">Subfield value to be set</param>
        public void SetDurationTime(float? durationTime)
        {
            SetFieldValue(2, 0, durationTime, DurationValueSubfield.DurationTime);
        }

        /// <summary>
        /// Retrieves the DurationDistance subfield
        /// Units: m</summary>
        /// <returns>Nullable float representing the DurationDistance subfield</returns>
        public float? GetDurationDistance()
        {
            Object val = GetFieldValue(2, 0, DurationValueSubfield.DurationDistance);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        ///
        /// Set DurationDistance subfield
        /// Units: m</summary>
        /// <param name="durationDistance">Subfield value to be set</param>
        public void SetDurationDistance(float? durationDistance)
        {
            SetFieldValue(2, 0, durationDistance, DurationValueSubfield.DurationDistance);
        }

        /// <summary>
        /// Retrieves the DurationHr subfield
        /// Units: % or bpm</summary>
        /// <returns>Nullable uint representing the DurationHr subfield</returns>
        public uint? GetDurationHr()
        {
            Object val = GetFieldValue(2, 0, DurationValueSubfield.DurationHr);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToUInt32(val));
            
        }

        /// <summary>
        ///
        /// Set DurationHr subfield
        /// Units: % or bpm</summary>
        /// <param name="durationHr">Subfield value to be set</param>
        public void SetDurationHr(uint? durationHr)
        {
            SetFieldValue(2, 0, durationHr, DurationValueSubfield.DurationHr);
        }

        /// <summary>
        /// Retrieves the DurationCalories subfield
        /// Units: calories</summary>
        /// <returns>Nullable uint representing the DurationCalories subfield</returns>
        public uint? GetDurationCalories()
        {
            Object val = GetFieldValue(2, 0, DurationValueSubfield.DurationCalories);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToUInt32(val));
            
        }

        /// <summary>
        ///
        /// Set DurationCalories subfield
        /// Units: calories</summary>
        /// <param name="durationCalories">Subfield value to be set</param>
        public void SetDurationCalories(uint? durationCalories)
        {
            SetFieldValue(2, 0, durationCalories, DurationValueSubfield.DurationCalories);
        }

        /// <summary>
        /// Retrieves the DurationStep subfield
        /// Comment: message_index of step to loop back to. Steps are assumed to be in the order by message_index. custom_name and intensity members are undefined for this duration type.</summary>
        /// <returns>Nullable uint representing the DurationStep subfield</returns>
        public uint? GetDurationStep()
        {
            Object val = GetFieldValue(2, 0, DurationValueSubfield.DurationStep);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToUInt32(val));
            
        }

        /// <summary>
        ///
        /// Set DurationStep subfield
        /// Comment: message_index of step to loop back to. Steps are assumed to be in the order by message_index. custom_name and intensity members are undefined for this duration type.</summary>
        /// <param name="durationStep">Subfield value to be set</param>
        public void SetDurationStep(uint? durationStep)
        {
            SetFieldValue(2, 0, durationStep, DurationValueSubfield.DurationStep);
        }

        /// <summary>
        /// Retrieves the DurationPower subfield
        /// Units: % or watts</summary>
        /// <returns>Nullable uint representing the DurationPower subfield</returns>
        public uint? GetDurationPower()
        {
            Object val = GetFieldValue(2, 0, DurationValueSubfield.DurationPower);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToUInt32(val));
            
        }

        /// <summary>
        ///
        /// Set DurationPower subfield
        /// Units: % or watts</summary>
        /// <param name="durationPower">Subfield value to be set</param>
        public void SetDurationPower(uint? durationPower)
        {
            SetFieldValue(2, 0, durationPower, DurationValueSubfield.DurationPower);
        }

        /// <summary>
        /// Retrieves the DurationReps subfield</summary>
        /// <returns>Nullable uint representing the DurationReps subfield</returns>
        public uint? GetDurationReps()
        {
            Object val = GetFieldValue(2, 0, DurationValueSubfield.DurationReps);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToUInt32(val));
            
        }

        /// <summary>
        ///
        /// Set DurationReps subfield</summary>
        /// <param name="durationReps">Subfield value to be set</param>
        public void SetDurationReps(uint? durationReps)
        {
            SetFieldValue(2, 0, durationReps, DurationValueSubfield.DurationReps);
        }
        ///<summary>
        /// Retrieves the TargetType field</summary>
        /// <returns>Returns nullable WktStepTarget enum representing the TargetType field</returns>
        public WktStepTarget? GetTargetType()
        {
            object obj = GetFieldValue(3, 0, Fit.SubfieldIndexMainField);
            WktStepTarget? value = obj == null ? (WktStepTarget?)null : (WktStepTarget)obj;
            return value;
        }

        /// <summary>
        /// Set TargetType field</summary>
        /// <param name="targetType_">Nullable field value to be set</param>
        public void SetTargetType(WktStepTarget? targetType_)
        {
            SetFieldValue(3, 0, targetType_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the TargetValue field</summary>
        /// <returns>Returns nullable uint representing the TargetValue field</returns>
        public uint? GetTargetValue()
        {
            Object val = GetFieldValue(4, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToUInt32(val));
            
        }

        /// <summary>
        /// Set TargetValue field</summary>
        /// <param name="targetValue_">Nullable field value to be set</param>
        public void SetTargetValue(uint? targetValue_)
        {
            SetFieldValue(4, 0, targetValue_, Fit.SubfieldIndexMainField);
        }
        

        /// <summary>
        /// Retrieves the TargetSpeedZone subfield
        /// Comment: speed zone (1-10);Custom =0;</summary>
        /// <returns>Nullable uint representing the TargetSpeedZone subfield</returns>
        public uint? GetTargetSpeedZone()
        {
            Object val = GetFieldValue(4, 0, TargetValueSubfield.TargetSpeedZone);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToUInt32(val));
            
        }

        /// <summary>
        ///
        /// Set TargetSpeedZone subfield
        /// Comment: speed zone (1-10);Custom =0;</summary>
        /// <param name="targetSpeedZone">Subfield value to be set</param>
        public void SetTargetSpeedZone(uint? targetSpeedZone)
        {
            SetFieldValue(4, 0, targetSpeedZone, TargetValueSubfield.TargetSpeedZone);
        }

        /// <summary>
        /// Retrieves the TargetHrZone subfield
        /// Comment: hr zone (1-5);Custom =0;</summary>
        /// <returns>Nullable uint representing the TargetHrZone subfield</returns>
        public uint? GetTargetHrZone()
        {
            Object val = GetFieldValue(4, 0, TargetValueSubfield.TargetHrZone);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToUInt32(val));
            
        }

        /// <summary>
        ///
        /// Set TargetHrZone subfield
        /// Comment: hr zone (1-5);Custom =0;</summary>
        /// <param name="targetHrZone">Subfield value to be set</param>
        public void SetTargetHrZone(uint? targetHrZone)
        {
            SetFieldValue(4, 0, targetHrZone, TargetValueSubfield.TargetHrZone);
        }

        /// <summary>
        /// Retrieves the TargetCadenceZone subfield
        /// Comment: Zone (1-?); Custom = 0;</summary>
        /// <returns>Nullable uint representing the TargetCadenceZone subfield</returns>
        public uint? GetTargetCadenceZone()
        {
            Object val = GetFieldValue(4, 0, TargetValueSubfield.TargetCadenceZone);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToUInt32(val));
            
        }

        /// <summary>
        ///
        /// Set TargetCadenceZone subfield
        /// Comment: Zone (1-?); Custom = 0;</summary>
        /// <param name="targetCadenceZone">Subfield value to be set</param>
        public void SetTargetCadenceZone(uint? targetCadenceZone)
        {
            SetFieldValue(4, 0, targetCadenceZone, TargetValueSubfield.TargetCadenceZone);
        }

        /// <summary>
        /// Retrieves the TargetPowerZone subfield
        /// Comment: Power Zone ( 1-7); Custom = 0;</summary>
        /// <returns>Nullable uint representing the TargetPowerZone subfield</returns>
        public uint? GetTargetPowerZone()
        {
            Object val = GetFieldValue(4, 0, TargetValueSubfield.TargetPowerZone);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToUInt32(val));
            
        }

        /// <summary>
        ///
        /// Set TargetPowerZone subfield
        /// Comment: Power Zone ( 1-7); Custom = 0;</summary>
        /// <param name="targetPowerZone">Subfield value to be set</param>
        public void SetTargetPowerZone(uint? targetPowerZone)
        {
            SetFieldValue(4, 0, targetPowerZone, TargetValueSubfield.TargetPowerZone);
        }

        /// <summary>
        /// Retrieves the RepeatSteps subfield
        /// Comment: # of repetitions</summary>
        /// <returns>Nullable uint representing the RepeatSteps subfield</returns>
        public uint? GetRepeatSteps()
        {
            Object val = GetFieldValue(4, 0, TargetValueSubfield.RepeatSteps);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToUInt32(val));
            
        }

        /// <summary>
        ///
        /// Set RepeatSteps subfield
        /// Comment: # of repetitions</summary>
        /// <param name="repeatSteps">Subfield value to be set</param>
        public void SetRepeatSteps(uint? repeatSteps)
        {
            SetFieldValue(4, 0, repeatSteps, TargetValueSubfield.RepeatSteps);
        }

        /// <summary>
        /// Retrieves the RepeatTime subfield
        /// Units: s</summary>
        /// <returns>Nullable float representing the RepeatTime subfield</returns>
        public float? GetRepeatTime()
        {
            Object val = GetFieldValue(4, 0, TargetValueSubfield.RepeatTime);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        ///
        /// Set RepeatTime subfield
        /// Units: s</summary>
        /// <param name="repeatTime">Subfield value to be set</param>
        public void SetRepeatTime(float? repeatTime)
        {
            SetFieldValue(4, 0, repeatTime, TargetValueSubfield.RepeatTime);
        }

        /// <summary>
        /// Retrieves the RepeatDistance subfield
        /// Units: m</summary>
        /// <returns>Nullable float representing the RepeatDistance subfield</returns>
        public float? GetRepeatDistance()
        {
            Object val = GetFieldValue(4, 0, TargetValueSubfield.RepeatDistance);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        ///
        /// Set RepeatDistance subfield
        /// Units: m</summary>
        /// <param name="repeatDistance">Subfield value to be set</param>
        public void SetRepeatDistance(float? repeatDistance)
        {
            SetFieldValue(4, 0, repeatDistance, TargetValueSubfield.RepeatDistance);
        }

        /// <summary>
        /// Retrieves the RepeatCalories subfield
        /// Units: calories</summary>
        /// <returns>Nullable uint representing the RepeatCalories subfield</returns>
        public uint? GetRepeatCalories()
        {
            Object val = GetFieldValue(4, 0, TargetValueSubfield.RepeatCalories);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToUInt32(val));
            
        }

        /// <summary>
        ///
        /// Set RepeatCalories subfield
        /// Units: calories</summary>
        /// <param name="repeatCalories">Subfield value to be set</param>
        public void SetRepeatCalories(uint? repeatCalories)
        {
            SetFieldValue(4, 0, repeatCalories, TargetValueSubfield.RepeatCalories);
        }

        /// <summary>
        /// Retrieves the RepeatHr subfield
        /// Units: % or bpm</summary>
        /// <returns>Nullable uint representing the RepeatHr subfield</returns>
        public uint? GetRepeatHr()
        {
            Object val = GetFieldValue(4, 0, TargetValueSubfield.RepeatHr);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToUInt32(val));
            
        }

        /// <summary>
        ///
        /// Set RepeatHr subfield
        /// Units: % or bpm</summary>
        /// <param name="repeatHr">Subfield value to be set</param>
        public void SetRepeatHr(uint? repeatHr)
        {
            SetFieldValue(4, 0, repeatHr, TargetValueSubfield.RepeatHr);
        }

        /// <summary>
        /// Retrieves the RepeatPower subfield
        /// Units: % or watts</summary>
        /// <returns>Nullable uint representing the RepeatPower subfield</returns>
        public uint? GetRepeatPower()
        {
            Object val = GetFieldValue(4, 0, TargetValueSubfield.RepeatPower);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToUInt32(val));
            
        }

        /// <summary>
        ///
        /// Set RepeatPower subfield
        /// Units: % or watts</summary>
        /// <param name="repeatPower">Subfield value to be set</param>
        public void SetRepeatPower(uint? repeatPower)
        {
            SetFieldValue(4, 0, repeatPower, TargetValueSubfield.RepeatPower);
        }

        /// <summary>
        /// Retrieves the TargetStrokeType subfield</summary>
        /// <returns>Nullable SwimStroke enum representing the TargetStrokeType subfield</returns>
        public SwimStroke? GetTargetStrokeType()
        {
            return (SwimStroke?)GetFieldValue(4, 0, TargetValueSubfield.TargetStrokeType);
        }

        /// <summary>
        ///
        /// Set TargetStrokeType subfield</summary>
        /// <param name="targetStrokeType">Subfield value to be set</param>
        public void SetTargetStrokeType(byte? targetStrokeType)
        {
            SetFieldValue(4, 0, targetStrokeType, TargetValueSubfield.TargetStrokeType);
        }
        ///<summary>
        /// Retrieves the CustomTargetValueLow field</summary>
        /// <returns>Returns nullable uint representing the CustomTargetValueLow field</returns>
        public uint? GetCustomTargetValueLow()
        {
            Object val = GetFieldValue(5, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToUInt32(val));
            
        }

        /// <summary>
        /// Set CustomTargetValueLow field</summary>
        /// <param name="customTargetValueLow_">Nullable field value to be set</param>
        public void SetCustomTargetValueLow(uint? customTargetValueLow_)
        {
            SetFieldValue(5, 0, customTargetValueLow_, Fit.SubfieldIndexMainField);
        }
        

        /// <summary>
        /// Retrieves the CustomTargetSpeedLow subfield
        /// Units: m/s</summary>
        /// <returns>Nullable float representing the CustomTargetSpeedLow subfield</returns>
        public float? GetCustomTargetSpeedLow()
        {
            Object val = GetFieldValue(5, 0, CustomTargetValueLowSubfield.CustomTargetSpeedLow);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        ///
        /// Set CustomTargetSpeedLow subfield
        /// Units: m/s</summary>
        /// <param name="customTargetSpeedLow">Subfield value to be set</param>
        public void SetCustomTargetSpeedLow(float? customTargetSpeedLow)
        {
            SetFieldValue(5, 0, customTargetSpeedLow, CustomTargetValueLowSubfield.CustomTargetSpeedLow);
        }

        /// <summary>
        /// Retrieves the CustomTargetHeartRateLow subfield
        /// Units: % or bpm</summary>
        /// <returns>Nullable uint representing the CustomTargetHeartRateLow subfield</returns>
        public uint? GetCustomTargetHeartRateLow()
        {
            Object val = GetFieldValue(5, 0, CustomTargetValueLowSubfield.CustomTargetHeartRateLow);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToUInt32(val));
            
        }

        /// <summary>
        ///
        /// Set CustomTargetHeartRateLow subfield
        /// Units: % or bpm</summary>
        /// <param name="customTargetHeartRateLow">Subfield value to be set</param>
        public void SetCustomTargetHeartRateLow(uint? customTargetHeartRateLow)
        {
            SetFieldValue(5, 0, customTargetHeartRateLow, CustomTargetValueLowSubfield.CustomTargetHeartRateLow);
        }

        /// <summary>
        /// Retrieves the CustomTargetCadenceLow subfield
        /// Units: rpm</summary>
        /// <returns>Nullable uint representing the CustomTargetCadenceLow subfield</returns>
        public uint? GetCustomTargetCadenceLow()
        {
            Object val = GetFieldValue(5, 0, CustomTargetValueLowSubfield.CustomTargetCadenceLow);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToUInt32(val));
            
        }

        /// <summary>
        ///
        /// Set CustomTargetCadenceLow subfield
        /// Units: rpm</summary>
        /// <param name="customTargetCadenceLow">Subfield value to be set</param>
        public void SetCustomTargetCadenceLow(uint? customTargetCadenceLow)
        {
            SetFieldValue(5, 0, customTargetCadenceLow, CustomTargetValueLowSubfield.CustomTargetCadenceLow);
        }

        /// <summary>
        /// Retrieves the CustomTargetPowerLow subfield
        /// Units: % or watts</summary>
        /// <returns>Nullable uint representing the CustomTargetPowerLow subfield</returns>
        public uint? GetCustomTargetPowerLow()
        {
            Object val = GetFieldValue(5, 0, CustomTargetValueLowSubfield.CustomTargetPowerLow);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToUInt32(val));
            
        }

        /// <summary>
        ///
        /// Set CustomTargetPowerLow subfield
        /// Units: % or watts</summary>
        /// <param name="customTargetPowerLow">Subfield value to be set</param>
        public void SetCustomTargetPowerLow(uint? customTargetPowerLow)
        {
            SetFieldValue(5, 0, customTargetPowerLow, CustomTargetValueLowSubfield.CustomTargetPowerLow);
        }
        ///<summary>
        /// Retrieves the CustomTargetValueHigh field</summary>
        /// <returns>Returns nullable uint representing the CustomTargetValueHigh field</returns>
        public uint? GetCustomTargetValueHigh()
        {
            Object val = GetFieldValue(6, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToUInt32(val));
            
        }

        /// <summary>
        /// Set CustomTargetValueHigh field</summary>
        /// <param name="customTargetValueHigh_">Nullable field value to be set</param>
        public void SetCustomTargetValueHigh(uint? customTargetValueHigh_)
        {
            SetFieldValue(6, 0, customTargetValueHigh_, Fit.SubfieldIndexMainField);
        }
        

        /// <summary>
        /// Retrieves the CustomTargetSpeedHigh subfield
        /// Units: m/s</summary>
        /// <returns>Nullable float representing the CustomTargetSpeedHigh subfield</returns>
        public float? GetCustomTargetSpeedHigh()
        {
            Object val = GetFieldValue(6, 0, CustomTargetValueHighSubfield.CustomTargetSpeedHigh);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        ///
        /// Set CustomTargetSpeedHigh subfield
        /// Units: m/s</summary>
        /// <param name="customTargetSpeedHigh">Subfield value to be set</param>
        public void SetCustomTargetSpeedHigh(float? customTargetSpeedHigh)
        {
            SetFieldValue(6, 0, customTargetSpeedHigh, CustomTargetValueHighSubfield.CustomTargetSpeedHigh);
        }

        /// <summary>
        /// Retrieves the CustomTargetHeartRateHigh subfield
        /// Units: % or bpm</summary>
        /// <returns>Nullable uint representing the CustomTargetHeartRateHigh subfield</returns>
        public uint? GetCustomTargetHeartRateHigh()
        {
            Object val = GetFieldValue(6, 0, CustomTargetValueHighSubfield.CustomTargetHeartRateHigh);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToUInt32(val));
            
        }

        /// <summary>
        ///
        /// Set CustomTargetHeartRateHigh subfield
        /// Units: % or bpm</summary>
        /// <param name="customTargetHeartRateHigh">Subfield value to be set</param>
        public void SetCustomTargetHeartRateHigh(uint? customTargetHeartRateHigh)
        {
            SetFieldValue(6, 0, customTargetHeartRateHigh, CustomTargetValueHighSubfield.CustomTargetHeartRateHigh);
        }

        /// <summary>
        /// Retrieves the CustomTargetCadenceHigh subfield
        /// Units: rpm</summary>
        /// <returns>Nullable uint representing the CustomTargetCadenceHigh subfield</returns>
        public uint? GetCustomTargetCadenceHigh()
        {
            Object val = GetFieldValue(6, 0, CustomTargetValueHighSubfield.CustomTargetCadenceHigh);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToUInt32(val));
            
        }

        /// <summary>
        ///
        /// Set CustomTargetCadenceHigh subfield
        /// Units: rpm</summary>
        /// <param name="customTargetCadenceHigh">Subfield value to be set</param>
        public void SetCustomTargetCadenceHigh(uint? customTargetCadenceHigh)
        {
            SetFieldValue(6, 0, customTargetCadenceHigh, CustomTargetValueHighSubfield.CustomTargetCadenceHigh);
        }

        /// <summary>
        /// Retrieves the CustomTargetPowerHigh subfield
        /// Units: % or watts</summary>
        /// <returns>Nullable uint representing the CustomTargetPowerHigh subfield</returns>
        public uint? GetCustomTargetPowerHigh()
        {
            Object val = GetFieldValue(6, 0, CustomTargetValueHighSubfield.CustomTargetPowerHigh);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToUInt32(val));
            
        }

        /// <summary>
        ///
        /// Set CustomTargetPowerHigh subfield
        /// Units: % or watts</summary>
        /// <param name="customTargetPowerHigh">Subfield value to be set</param>
        public void SetCustomTargetPowerHigh(uint? customTargetPowerHigh)
        {
            SetFieldValue(6, 0, customTargetPowerHigh, CustomTargetValueHighSubfield.CustomTargetPowerHigh);
        }
        ///<summary>
        /// Retrieves the Intensity field</summary>
        /// <returns>Returns nullable Intensity enum representing the Intensity field</returns>
        public Intensity? GetIntensity()
        {
            object obj = GetFieldValue(7, 0, Fit.SubfieldIndexMainField);
            Intensity? value = obj == null ? (Intensity?)null : (Intensity)obj;
            return value;
        }

        /// <summary>
        /// Set Intensity field</summary>
        /// <param name="intensity_">Nullable field value to be set</param>
        public void SetIntensity(Intensity? intensity_)
        {
            SetFieldValue(7, 0, intensity_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the Notes field</summary>
        /// <returns>Returns byte[] representing the Notes field</returns>
        public byte[] GetNotes()
        {
            byte[] data = (byte[])GetFieldValue(8, 0, Fit.SubfieldIndexMainField);
            return data.Take(data.Length - 1).ToArray();
        }

        ///<summary>
        /// Retrieves the Notes field</summary>
        /// <returns>Returns String representing the Notes field</returns>
        public String GetNotesAsString()
        {
            byte[] data = (byte[])GetFieldValue(8, 0, Fit.SubfieldIndexMainField);
            return data != null ? Encoding.UTF8.GetString(data, 0, data.Length - 1) : null;
        }

        ///<summary>
        /// Set Notes field</summary>
        /// <param name="notes_"> field value to be set</param>
        public void SetNotes(String notes_)
        {
            byte[] data = Encoding.UTF8.GetBytes(notes_);
            byte[] zdata = new byte[data.Length + 1];
            data.CopyTo(zdata, 0);
            SetFieldValue(8, 0, zdata, Fit.SubfieldIndexMainField);
        }

        
        /// <summary>
        /// Set Notes field</summary>
        /// <param name="notes_">field value to be set</param>
        public void SetNotes(byte[] notes_)
        {
            SetFieldValue(8, 0, notes_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the Equipment field</summary>
        /// <returns>Returns nullable WorkoutEquipment enum representing the Equipment field</returns>
        public WorkoutEquipment? GetEquipment()
        {
            object obj = GetFieldValue(9, 0, Fit.SubfieldIndexMainField);
            WorkoutEquipment? value = obj == null ? (WorkoutEquipment?)null : (WorkoutEquipment)obj;
            return value;
        }

        /// <summary>
        /// Set Equipment field</summary>
        /// <param name="equipment_">Nullable field value to be set</param>
        public void SetEquipment(WorkoutEquipment? equipment_)
        {
            SetFieldValue(9, 0, equipment_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the ExerciseCategory field</summary>
        /// <returns>Returns nullable ushort representing the ExerciseCategory field</returns>
        public ushort? GetExerciseCategory()
        {
            Object val = GetFieldValue(10, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToUInt16(val));
            
        }

        /// <summary>
        /// Set ExerciseCategory field</summary>
        /// <param name="exerciseCategory_">Nullable field value to be set</param>
        public void SetExerciseCategory(ushort? exerciseCategory_)
        {
            SetFieldValue(10, 0, exerciseCategory_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the ExerciseName field</summary>
        /// <returns>Returns nullable ushort representing the ExerciseName field</returns>
        public ushort? GetExerciseName()
        {
            Object val = GetFieldValue(11, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToUInt16(val));
            
        }

        /// <summary>
        /// Set ExerciseName field</summary>
        /// <param name="exerciseName_">Nullable field value to be set</param>
        public void SetExerciseName(ushort? exerciseName_)
        {
            SetFieldValue(11, 0, exerciseName_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the ExerciseWeight field
        /// Units: kg</summary>
        /// <returns>Returns nullable float representing the ExerciseWeight field</returns>
        public float? GetExerciseWeight()
        {
            Object val = GetFieldValue(12, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set ExerciseWeight field
        /// Units: kg</summary>
        /// <param name="exerciseWeight_">Nullable field value to be set</param>
        public void SetExerciseWeight(float? exerciseWeight_)
        {
            SetFieldValue(12, 0, exerciseWeight_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the WeightDisplayUnit field</summary>
        /// <returns>Returns nullable ushort representing the WeightDisplayUnit field</returns>
        public ushort? GetWeightDisplayUnit()
        {
            Object val = GetFieldValue(13, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToUInt16(val));
            
        }

        /// <summary>
        /// Set WeightDisplayUnit field</summary>
        /// <param name="weightDisplayUnit_">Nullable field value to be set</param>
        public void SetWeightDisplayUnit(ushort? weightDisplayUnit_)
        {
            SetFieldValue(13, 0, weightDisplayUnit_, Fit.SubfieldIndexMainField);
        }
        
        #endregion // Methods
    } // Class
} // namespace
