#region Copyright
////////////////////////////////////////////////////////////////////////////////
// The following FIT Protocol software provided may be used with FIT protocol
// devices only and remains the copyrighted property of Garmin Canada Inc.
// The software is being provided on an "as-is" basis and as an accommodation,
// and therefore all warranties, representations, or guarantees of any kind
// (whether express, implied or statutory) including, without limitation,
// warranties of merchantability, non-infringement, or fitness for a particular
// purpose, are specifically disclaimed.
//
// Copyright 2020 Garmin Canada Inc.
////////////////////////////////////////////////////////////////////////////////
// ****WARNING****  This file is auto-generated!  Do NOT edit this file.
// Profile Version = 21.38Release
// Tag = production/akw/21.38.00-0-g0d69e49
////////////////////////////////////////////////////////////////////////////////

#endregion

using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Text;
using System.IO;
using System.Linq;

namespace Dynastream.Fit
{
    /// <summary>
    /// Implements the Session profile message.
    /// </summary>
    public class SessionMesg : Mesg
    {
        #region Fields
        static class TotalCyclesSubfield
        {
            public static ushort TotalStrides = 0;
            public static ushort TotalStrokes = 1;
            public static ushort Subfields = 2;
            public static ushort Active = Fit.SubfieldIndexActiveSubfield;
            public static ushort MainField = Fit.SubfieldIndexMainField;
        }
        static class AvgCadenceSubfield
        {
            public static ushort AvgRunningCadence = 0;
            public static ushort Subfields = 1;
            public static ushort Active = Fit.SubfieldIndexActiveSubfield;
            public static ushort MainField = Fit.SubfieldIndexMainField;
        }
        static class MaxCadenceSubfield
        {
            public static ushort MaxRunningCadence = 0;
            public static ushort Subfields = 1;
            public static ushort Active = Fit.SubfieldIndexActiveSubfield;
            public static ushort MainField = Fit.SubfieldIndexMainField;
        }
        #endregion

        /// <summary>
        /// Field Numbers for <see cref="SessionMesg"/>
        /// </summary>
        public sealed class FieldDefNum
        {
            public const byte MessageIndex = 254;
            public const byte Timestamp = 253;
            public const byte Event = 0;
            public const byte EventType = 1;
            public const byte StartTime = 2;
            public const byte StartPositionLat = 3;
            public const byte StartPositionLong = 4;
            public const byte Sport = 5;
            public const byte SubSport = 6;
            public const byte TotalElapsedTime = 7;
            public const byte TotalTimerTime = 8;
            public const byte TotalDistance = 9;
            public const byte TotalCycles = 10;
            public const byte TotalCalories = 11;
            public const byte TotalFatCalories = 13;
            public const byte AvgSpeed = 14;
            public const byte MaxSpeed = 15;
            public const byte AvgHeartRate = 16;
            public const byte MaxHeartRate = 17;
            public const byte AvgCadence = 18;
            public const byte MaxCadence = 19;
            public const byte AvgPower = 20;
            public const byte MaxPower = 21;
            public const byte TotalAscent = 22;
            public const byte TotalDescent = 23;
            public const byte TotalTrainingEffect = 24;
            public const byte FirstLapIndex = 25;
            public const byte NumLaps = 26;
            public const byte EventGroup = 27;
            public const byte Trigger = 28;
            public const byte NecLat = 29;
            public const byte NecLong = 30;
            public const byte SwcLat = 31;
            public const byte SwcLong = 32;
            public const byte NumLengths = 33;
            public const byte NormalizedPower = 34;
            public const byte TrainingStressScore = 35;
            public const byte IntensityFactor = 36;
            public const byte LeftRightBalance = 37;
            public const byte AvgStrokeCount = 41;
            public const byte AvgStrokeDistance = 42;
            public const byte SwimStroke = 43;
            public const byte PoolLength = 44;
            public const byte ThresholdPower = 45;
            public const byte PoolLengthUnit = 46;
            public const byte NumActiveLengths = 47;
            public const byte TotalWork = 48;
            public const byte AvgAltitude = 49;
            public const byte MaxAltitude = 50;
            public const byte GpsAccuracy = 51;
            public const byte AvgGrade = 52;
            public const byte AvgPosGrade = 53;
            public const byte AvgNegGrade = 54;
            public const byte MaxPosGrade = 55;
            public const byte MaxNegGrade = 56;
            public const byte AvgTemperature = 57;
            public const byte MaxTemperature = 58;
            public const byte TotalMovingTime = 59;
            public const byte AvgPosVerticalSpeed = 60;
            public const byte AvgNegVerticalSpeed = 61;
            public const byte MaxPosVerticalSpeed = 62;
            public const byte MaxNegVerticalSpeed = 63;
            public const byte MinHeartRate = 64;
            public const byte TimeInHrZone = 65;
            public const byte TimeInSpeedZone = 66;
            public const byte TimeInCadenceZone = 67;
            public const byte TimeInPowerZone = 68;
            public const byte AvgLapTime = 69;
            public const byte BestLapIndex = 70;
            public const byte MinAltitude = 71;
            public const byte PlayerScore = 82;
            public const byte OpponentScore = 83;
            public const byte OpponentName = 84;
            public const byte StrokeCount = 85;
            public const byte ZoneCount = 86;
            public const byte MaxBallSpeed = 87;
            public const byte AvgBallSpeed = 88;
            public const byte AvgVerticalOscillation = 89;
            public const byte AvgStanceTimePercent = 90;
            public const byte AvgStanceTime = 91;
            public const byte AvgFractionalCadence = 92;
            public const byte MaxFractionalCadence = 93;
            public const byte TotalFractionalCycles = 94;
            public const byte AvgTotalHemoglobinConc = 95;
            public const byte MinTotalHemoglobinConc = 96;
            public const byte MaxTotalHemoglobinConc = 97;
            public const byte AvgSaturatedHemoglobinPercent = 98;
            public const byte MinSaturatedHemoglobinPercent = 99;
            public const byte MaxSaturatedHemoglobinPercent = 100;
            public const byte AvgLeftTorqueEffectiveness = 101;
            public const byte AvgRightTorqueEffectiveness = 102;
            public const byte AvgLeftPedalSmoothness = 103;
            public const byte AvgRightPedalSmoothness = 104;
            public const byte AvgCombinedPedalSmoothness = 105;
            public const byte SportIndex = 111;
            public const byte TimeStanding = 112;
            public const byte StandCount = 113;
            public const byte AvgLeftPco = 114;
            public const byte AvgRightPco = 115;
            public const byte AvgLeftPowerPhase = 116;
            public const byte AvgLeftPowerPhasePeak = 117;
            public const byte AvgRightPowerPhase = 118;
            public const byte AvgRightPowerPhasePeak = 119;
            public const byte AvgPowerPosition = 120;
            public const byte MaxPowerPosition = 121;
            public const byte AvgCadencePosition = 122;
            public const byte MaxCadencePosition = 123;
            public const byte EnhancedAvgSpeed = 124;
            public const byte EnhancedMaxSpeed = 125;
            public const byte EnhancedAvgAltitude = 126;
            public const byte EnhancedMinAltitude = 127;
            public const byte EnhancedMaxAltitude = 128;
            public const byte AvgLevMotorPower = 129;
            public const byte MaxLevMotorPower = 130;
            public const byte LevBatteryConsumption = 131;
            public const byte AvgVerticalRatio = 132;
            public const byte AvgStanceTimeBalance = 133;
            public const byte AvgStepLength = 134;
            public const byte TotalAnaerobicTrainingEffect = 137;
            public const byte AvgVam = 139;
            public const byte TotalGrit = 181;
            public const byte TotalFlow = 182;
            public const byte JumpCount = 183;
            public const byte AvgGrit = 186;
            public const byte AvgFlow = 187;
            public const byte Invalid = Fit.FieldNumInvalid;
        }

        #region Constructors
        public SessionMesg() : base(Profile.GetMesg(MesgNum.Session))
        {
        }

        public SessionMesg(Mesg mesg) : base(mesg)
        {
        }
        #endregion // Constructors

        #region Methods
        ///<summary>
        /// Retrieves the MessageIndex field
        /// Comment: Selected bit is set for the current session.</summary>
        /// <returns>Returns nullable ushort representing the MessageIndex field</returns>
        public ushort? GetMessageIndex()
        {
            Object val = GetFieldValue(254, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToUInt16(val));
            
        }

        /// <summary>
        /// Set MessageIndex field
        /// Comment: Selected bit is set for the current session.</summary>
        /// <param name="messageIndex_">Nullable field value to be set</param>
        public void SetMessageIndex(ushort? messageIndex_)
        {
            SetFieldValue(254, 0, messageIndex_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the Timestamp field
        /// Units: s
        /// Comment: Sesson end time.</summary>
        /// <returns>Returns DateTime representing the Timestamp field</returns>
        public DateTime GetTimestamp()
        {
            Object val = GetFieldValue(253, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return TimestampToDateTime(Convert.ToUInt32(val));
            
        }

        /// <summary>
        /// Set Timestamp field
        /// Units: s
        /// Comment: Sesson end time.</summary>
        /// <param name="timestamp_">Nullable field value to be set</param>
        public void SetTimestamp(DateTime timestamp_)
        {
            SetFieldValue(253, 0, timestamp_.GetTimeStamp(), Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the Event field
        /// Comment: session</summary>
        /// <returns>Returns nullable Event enum representing the Event field</returns>
        public Event? GetEvent()
        {
            object obj = GetFieldValue(0, 0, Fit.SubfieldIndexMainField);
            Event? value = obj == null ? (Event?)null : (Event)obj;
            return value;
        }

        /// <summary>
        /// Set Event field
        /// Comment: session</summary>
        /// <param name="event_">Nullable field value to be set</param>
        public void SetEvent(Event? event_)
        {
            SetFieldValue(0, 0, event_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the EventType field
        /// Comment: stop</summary>
        /// <returns>Returns nullable EventType enum representing the EventType field</returns>
        public EventType? GetEventType()
        {
            object obj = GetFieldValue(1, 0, Fit.SubfieldIndexMainField);
            EventType? value = obj == null ? (EventType?)null : (EventType)obj;
            return value;
        }

        /// <summary>
        /// Set EventType field
        /// Comment: stop</summary>
        /// <param name="eventType_">Nullable field value to be set</param>
        public void SetEventType(EventType? eventType_)
        {
            SetFieldValue(1, 0, eventType_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the StartTime field</summary>
        /// <returns>Returns DateTime representing the StartTime field</returns>
        public DateTime GetStartTime()
        {
            Object val = GetFieldValue(2, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return TimestampToDateTime(Convert.ToUInt32(val));
            
        }

        /// <summary>
        /// Set StartTime field</summary>
        /// <param name="startTime_">Nullable field value to be set</param>
        public void SetStartTime(DateTime startTime_)
        {
            SetFieldValue(2, 0, startTime_.GetTimeStamp(), Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the StartPositionLat field
        /// Units: semicircles</summary>
        /// <returns>Returns nullable int representing the StartPositionLat field</returns>
        public int? GetStartPositionLat()
        {
            Object val = GetFieldValue(3, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToInt32(val));
            
        }

        /// <summary>
        /// Set StartPositionLat field
        /// Units: semicircles</summary>
        /// <param name="startPositionLat_">Nullable field value to be set</param>
        public void SetStartPositionLat(int? startPositionLat_)
        {
            SetFieldValue(3, 0, startPositionLat_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the StartPositionLong field
        /// Units: semicircles</summary>
        /// <returns>Returns nullable int representing the StartPositionLong field</returns>
        public int? GetStartPositionLong()
        {
            Object val = GetFieldValue(4, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToInt32(val));
            
        }

        /// <summary>
        /// Set StartPositionLong field
        /// Units: semicircles</summary>
        /// <param name="startPositionLong_">Nullable field value to be set</param>
        public void SetStartPositionLong(int? startPositionLong_)
        {
            SetFieldValue(4, 0, startPositionLong_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the Sport field</summary>
        /// <returns>Returns nullable Sport enum representing the Sport field</returns>
        public Sport? GetSport()
        {
            object obj = GetFieldValue(5, 0, Fit.SubfieldIndexMainField);
            Sport? value = obj == null ? (Sport?)null : (Sport)obj;
            return value;
        }

        /// <summary>
        /// Set Sport field</summary>
        /// <param name="sport_">Nullable field value to be set</param>
        public void SetSport(Sport? sport_)
        {
            SetFieldValue(5, 0, sport_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the SubSport field</summary>
        /// <returns>Returns nullable SubSport enum representing the SubSport field</returns>
        public SubSport? GetSubSport()
        {
            object obj = GetFieldValue(6, 0, Fit.SubfieldIndexMainField);
            SubSport? value = obj == null ? (SubSport?)null : (SubSport)obj;
            return value;
        }

        /// <summary>
        /// Set SubSport field</summary>
        /// <param name="subSport_">Nullable field value to be set</param>
        public void SetSubSport(SubSport? subSport_)
        {
            SetFieldValue(6, 0, subSport_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the TotalElapsedTime field
        /// Units: s
        /// Comment: Time (includes pauses)</summary>
        /// <returns>Returns nullable float representing the TotalElapsedTime field</returns>
        public float? GetTotalElapsedTime()
        {
            Object val = GetFieldValue(7, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set TotalElapsedTime field
        /// Units: s
        /// Comment: Time (includes pauses)</summary>
        /// <param name="totalElapsedTime_">Nullable field value to be set</param>
        public void SetTotalElapsedTime(float? totalElapsedTime_)
        {
            SetFieldValue(7, 0, totalElapsedTime_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the TotalTimerTime field
        /// Units: s
        /// Comment: Timer Time (excludes pauses)</summary>
        /// <returns>Returns nullable float representing the TotalTimerTime field</returns>
        public float? GetTotalTimerTime()
        {
            Object val = GetFieldValue(8, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set TotalTimerTime field
        /// Units: s
        /// Comment: Timer Time (excludes pauses)</summary>
        /// <param name="totalTimerTime_">Nullable field value to be set</param>
        public void SetTotalTimerTime(float? totalTimerTime_)
        {
            SetFieldValue(8, 0, totalTimerTime_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the TotalDistance field
        /// Units: m</summary>
        /// <returns>Returns nullable float representing the TotalDistance field</returns>
        public float? GetTotalDistance()
        {
            Object val = GetFieldValue(9, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set TotalDistance field
        /// Units: m</summary>
        /// <param name="totalDistance_">Nullable field value to be set</param>
        public void SetTotalDistance(float? totalDistance_)
        {
            SetFieldValue(9, 0, totalDistance_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the TotalCycles field
        /// Units: cycles</summary>
        /// <returns>Returns nullable uint representing the TotalCycles field</returns>
        public uint? GetTotalCycles()
        {
            Object val = GetFieldValue(10, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToUInt32(val));
            
        }

        /// <summary>
        /// Set TotalCycles field
        /// Units: cycles</summary>
        /// <param name="totalCycles_">Nullable field value to be set</param>
        public void SetTotalCycles(uint? totalCycles_)
        {
            SetFieldValue(10, 0, totalCycles_, Fit.SubfieldIndexMainField);
        }
        

        /// <summary>
        /// Retrieves the TotalStrides subfield
        /// Units: strides</summary>
        /// <returns>Nullable uint representing the TotalStrides subfield</returns>
        public uint? GetTotalStrides()
        {
            Object val = GetFieldValue(10, 0, TotalCyclesSubfield.TotalStrides);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToUInt32(val));
            
        }

        /// <summary>
        ///
        /// Set TotalStrides subfield
        /// Units: strides</summary>
        /// <param name="totalStrides">Subfield value to be set</param>
        public void SetTotalStrides(uint? totalStrides)
        {
            SetFieldValue(10, 0, totalStrides, TotalCyclesSubfield.TotalStrides);
        }

        /// <summary>
        /// Retrieves the TotalStrokes subfield
        /// Units: strokes</summary>
        /// <returns>Nullable uint representing the TotalStrokes subfield</returns>
        public uint? GetTotalStrokes()
        {
            Object val = GetFieldValue(10, 0, TotalCyclesSubfield.TotalStrokes);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToUInt32(val));
            
        }

        /// <summary>
        ///
        /// Set TotalStrokes subfield
        /// Units: strokes</summary>
        /// <param name="totalStrokes">Subfield value to be set</param>
        public void SetTotalStrokes(uint? totalStrokes)
        {
            SetFieldValue(10, 0, totalStrokes, TotalCyclesSubfield.TotalStrokes);
        }
        ///<summary>
        /// Retrieves the TotalCalories field
        /// Units: kcal</summary>
        /// <returns>Returns nullable ushort representing the TotalCalories field</returns>
        public ushort? GetTotalCalories()
        {
            Object val = GetFieldValue(11, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToUInt16(val));
            
        }

        /// <summary>
        /// Set TotalCalories field
        /// Units: kcal</summary>
        /// <param name="totalCalories_">Nullable field value to be set</param>
        public void SetTotalCalories(ushort? totalCalories_)
        {
            SetFieldValue(11, 0, totalCalories_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the TotalFatCalories field
        /// Units: kcal</summary>
        /// <returns>Returns nullable ushort representing the TotalFatCalories field</returns>
        public ushort? GetTotalFatCalories()
        {
            Object val = GetFieldValue(13, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToUInt16(val));
            
        }

        /// <summary>
        /// Set TotalFatCalories field
        /// Units: kcal</summary>
        /// <param name="totalFatCalories_">Nullable field value to be set</param>
        public void SetTotalFatCalories(ushort? totalFatCalories_)
        {
            SetFieldValue(13, 0, totalFatCalories_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the AvgSpeed field
        /// Units: m/s
        /// Comment: total_distance / total_timer_time</summary>
        /// <returns>Returns nullable float representing the AvgSpeed field</returns>
        public float? GetAvgSpeed()
        {
            Object val = GetFieldValue(14, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set AvgSpeed field
        /// Units: m/s
        /// Comment: total_distance / total_timer_time</summary>
        /// <param name="avgSpeed_">Nullable field value to be set</param>
        public void SetAvgSpeed(float? avgSpeed_)
        {
            SetFieldValue(14, 0, avgSpeed_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the MaxSpeed field
        /// Units: m/s</summary>
        /// <returns>Returns nullable float representing the MaxSpeed field</returns>
        public float? GetMaxSpeed()
        {
            Object val = GetFieldValue(15, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set MaxSpeed field
        /// Units: m/s</summary>
        /// <param name="maxSpeed_">Nullable field value to be set</param>
        public void SetMaxSpeed(float? maxSpeed_)
        {
            SetFieldValue(15, 0, maxSpeed_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the AvgHeartRate field
        /// Units: bpm
        /// Comment: average heart rate (excludes pause time)</summary>
        /// <returns>Returns nullable byte representing the AvgHeartRate field</returns>
        public byte? GetAvgHeartRate()
        {
            Object val = GetFieldValue(16, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToByte(val));
            
        }

        /// <summary>
        /// Set AvgHeartRate field
        /// Units: bpm
        /// Comment: average heart rate (excludes pause time)</summary>
        /// <param name="avgHeartRate_">Nullable field value to be set</param>
        public void SetAvgHeartRate(byte? avgHeartRate_)
        {
            SetFieldValue(16, 0, avgHeartRate_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the MaxHeartRate field
        /// Units: bpm</summary>
        /// <returns>Returns nullable byte representing the MaxHeartRate field</returns>
        public byte? GetMaxHeartRate()
        {
            Object val = GetFieldValue(17, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToByte(val));
            
        }

        /// <summary>
        /// Set MaxHeartRate field
        /// Units: bpm</summary>
        /// <param name="maxHeartRate_">Nullable field value to be set</param>
        public void SetMaxHeartRate(byte? maxHeartRate_)
        {
            SetFieldValue(17, 0, maxHeartRate_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the AvgCadence field
        /// Units: rpm
        /// Comment: total_cycles / total_timer_time if non_zero_avg_cadence otherwise total_cycles / total_elapsed_time</summary>
        /// <returns>Returns nullable byte representing the AvgCadence field</returns>
        public byte? GetAvgCadence()
        {
            Object val = GetFieldValue(18, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToByte(val));
            
        }

        /// <summary>
        /// Set AvgCadence field
        /// Units: rpm
        /// Comment: total_cycles / total_timer_time if non_zero_avg_cadence otherwise total_cycles / total_elapsed_time</summary>
        /// <param name="avgCadence_">Nullable field value to be set</param>
        public void SetAvgCadence(byte? avgCadence_)
        {
            SetFieldValue(18, 0, avgCadence_, Fit.SubfieldIndexMainField);
        }
        

        /// <summary>
        /// Retrieves the AvgRunningCadence subfield
        /// Units: strides/min</summary>
        /// <returns>Nullable byte representing the AvgRunningCadence subfield</returns>
        public byte? GetAvgRunningCadence()
        {
            Object val = GetFieldValue(18, 0, AvgCadenceSubfield.AvgRunningCadence);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToByte(val));
            
        }

        /// <summary>
        ///
        /// Set AvgRunningCadence subfield
        /// Units: strides/min</summary>
        /// <param name="avgRunningCadence">Subfield value to be set</param>
        public void SetAvgRunningCadence(byte? avgRunningCadence)
        {
            SetFieldValue(18, 0, avgRunningCadence, AvgCadenceSubfield.AvgRunningCadence);
        }
        ///<summary>
        /// Retrieves the MaxCadence field
        /// Units: rpm</summary>
        /// <returns>Returns nullable byte representing the MaxCadence field</returns>
        public byte? GetMaxCadence()
        {
            Object val = GetFieldValue(19, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToByte(val));
            
        }

        /// <summary>
        /// Set MaxCadence field
        /// Units: rpm</summary>
        /// <param name="maxCadence_">Nullable field value to be set</param>
        public void SetMaxCadence(byte? maxCadence_)
        {
            SetFieldValue(19, 0, maxCadence_, Fit.SubfieldIndexMainField);
        }
        

        /// <summary>
        /// Retrieves the MaxRunningCadence subfield
        /// Units: strides/min</summary>
        /// <returns>Nullable byte representing the MaxRunningCadence subfield</returns>
        public byte? GetMaxRunningCadence()
        {
            Object val = GetFieldValue(19, 0, MaxCadenceSubfield.MaxRunningCadence);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToByte(val));
            
        }

        /// <summary>
        ///
        /// Set MaxRunningCadence subfield
        /// Units: strides/min</summary>
        /// <param name="maxRunningCadence">Subfield value to be set</param>
        public void SetMaxRunningCadence(byte? maxRunningCadence)
        {
            SetFieldValue(19, 0, maxRunningCadence, MaxCadenceSubfield.MaxRunningCadence);
        }
        ///<summary>
        /// Retrieves the AvgPower field
        /// Units: watts
        /// Comment: total_power / total_timer_time if non_zero_avg_power otherwise total_power / total_elapsed_time</summary>
        /// <returns>Returns nullable ushort representing the AvgPower field</returns>
        public ushort? GetAvgPower()
        {
            Object val = GetFieldValue(20, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToUInt16(val));
            
        }

        /// <summary>
        /// Set AvgPower field
        /// Units: watts
        /// Comment: total_power / total_timer_time if non_zero_avg_power otherwise total_power / total_elapsed_time</summary>
        /// <param name="avgPower_">Nullable field value to be set</param>
        public void SetAvgPower(ushort? avgPower_)
        {
            SetFieldValue(20, 0, avgPower_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the MaxPower field
        /// Units: watts</summary>
        /// <returns>Returns nullable ushort representing the MaxPower field</returns>
        public ushort? GetMaxPower()
        {
            Object val = GetFieldValue(21, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToUInt16(val));
            
        }

        /// <summary>
        /// Set MaxPower field
        /// Units: watts</summary>
        /// <param name="maxPower_">Nullable field value to be set</param>
        public void SetMaxPower(ushort? maxPower_)
        {
            SetFieldValue(21, 0, maxPower_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the TotalAscent field
        /// Units: m</summary>
        /// <returns>Returns nullable ushort representing the TotalAscent field</returns>
        public ushort? GetTotalAscent()
        {
            Object val = GetFieldValue(22, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToUInt16(val));
            
        }

        /// <summary>
        /// Set TotalAscent field
        /// Units: m</summary>
        /// <param name="totalAscent_">Nullable field value to be set</param>
        public void SetTotalAscent(ushort? totalAscent_)
        {
            SetFieldValue(22, 0, totalAscent_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the TotalDescent field
        /// Units: m</summary>
        /// <returns>Returns nullable ushort representing the TotalDescent field</returns>
        public ushort? GetTotalDescent()
        {
            Object val = GetFieldValue(23, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToUInt16(val));
            
        }

        /// <summary>
        /// Set TotalDescent field
        /// Units: m</summary>
        /// <param name="totalDescent_">Nullable field value to be set</param>
        public void SetTotalDescent(ushort? totalDescent_)
        {
            SetFieldValue(23, 0, totalDescent_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the TotalTrainingEffect field</summary>
        /// <returns>Returns nullable float representing the TotalTrainingEffect field</returns>
        public float? GetTotalTrainingEffect()
        {
            Object val = GetFieldValue(24, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set TotalTrainingEffect field</summary>
        /// <param name="totalTrainingEffect_">Nullable field value to be set</param>
        public void SetTotalTrainingEffect(float? totalTrainingEffect_)
        {
            SetFieldValue(24, 0, totalTrainingEffect_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the FirstLapIndex field</summary>
        /// <returns>Returns nullable ushort representing the FirstLapIndex field</returns>
        public ushort? GetFirstLapIndex()
        {
            Object val = GetFieldValue(25, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToUInt16(val));
            
        }

        /// <summary>
        /// Set FirstLapIndex field</summary>
        /// <param name="firstLapIndex_">Nullable field value to be set</param>
        public void SetFirstLapIndex(ushort? firstLapIndex_)
        {
            SetFieldValue(25, 0, firstLapIndex_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the NumLaps field</summary>
        /// <returns>Returns nullable ushort representing the NumLaps field</returns>
        public ushort? GetNumLaps()
        {
            Object val = GetFieldValue(26, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToUInt16(val));
            
        }

        /// <summary>
        /// Set NumLaps field</summary>
        /// <param name="numLaps_">Nullable field value to be set</param>
        public void SetNumLaps(ushort? numLaps_)
        {
            SetFieldValue(26, 0, numLaps_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the EventGroup field</summary>
        /// <returns>Returns nullable byte representing the EventGroup field</returns>
        public byte? GetEventGroup()
        {
            Object val = GetFieldValue(27, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToByte(val));
            
        }

        /// <summary>
        /// Set EventGroup field</summary>
        /// <param name="eventGroup_">Nullable field value to be set</param>
        public void SetEventGroup(byte? eventGroup_)
        {
            SetFieldValue(27, 0, eventGroup_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the Trigger field</summary>
        /// <returns>Returns nullable SessionTrigger enum representing the Trigger field</returns>
        public SessionTrigger? GetTrigger()
        {
            object obj = GetFieldValue(28, 0, Fit.SubfieldIndexMainField);
            SessionTrigger? value = obj == null ? (SessionTrigger?)null : (SessionTrigger)obj;
            return value;
        }

        /// <summary>
        /// Set Trigger field</summary>
        /// <param name="trigger_">Nullable field value to be set</param>
        public void SetTrigger(SessionTrigger? trigger_)
        {
            SetFieldValue(28, 0, trigger_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the NecLat field
        /// Units: semicircles
        /// Comment: North east corner latitude</summary>
        /// <returns>Returns nullable int representing the NecLat field</returns>
        public int? GetNecLat()
        {
            Object val = GetFieldValue(29, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToInt32(val));
            
        }

        /// <summary>
        /// Set NecLat field
        /// Units: semicircles
        /// Comment: North east corner latitude</summary>
        /// <param name="necLat_">Nullable field value to be set</param>
        public void SetNecLat(int? necLat_)
        {
            SetFieldValue(29, 0, necLat_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the NecLong field
        /// Units: semicircles
        /// Comment: North east corner longitude</summary>
        /// <returns>Returns nullable int representing the NecLong field</returns>
        public int? GetNecLong()
        {
            Object val = GetFieldValue(30, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToInt32(val));
            
        }

        /// <summary>
        /// Set NecLong field
        /// Units: semicircles
        /// Comment: North east corner longitude</summary>
        /// <param name="necLong_">Nullable field value to be set</param>
        public void SetNecLong(int? necLong_)
        {
            SetFieldValue(30, 0, necLong_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the SwcLat field
        /// Units: semicircles
        /// Comment: South west corner latitude</summary>
        /// <returns>Returns nullable int representing the SwcLat field</returns>
        public int? GetSwcLat()
        {
            Object val = GetFieldValue(31, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToInt32(val));
            
        }

        /// <summary>
        /// Set SwcLat field
        /// Units: semicircles
        /// Comment: South west corner latitude</summary>
        /// <param name="swcLat_">Nullable field value to be set</param>
        public void SetSwcLat(int? swcLat_)
        {
            SetFieldValue(31, 0, swcLat_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the SwcLong field
        /// Units: semicircles
        /// Comment: South west corner longitude</summary>
        /// <returns>Returns nullable int representing the SwcLong field</returns>
        public int? GetSwcLong()
        {
            Object val = GetFieldValue(32, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToInt32(val));
            
        }

        /// <summary>
        /// Set SwcLong field
        /// Units: semicircles
        /// Comment: South west corner longitude</summary>
        /// <param name="swcLong_">Nullable field value to be set</param>
        public void SetSwcLong(int? swcLong_)
        {
            SetFieldValue(32, 0, swcLong_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the NumLengths field
        /// Units: lengths
        /// Comment: # of lengths of swim pool</summary>
        /// <returns>Returns nullable ushort representing the NumLengths field</returns>
        public ushort? GetNumLengths()
        {
            Object val = GetFieldValue(33, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToUInt16(val));
            
        }

        /// <summary>
        /// Set NumLengths field
        /// Units: lengths
        /// Comment: # of lengths of swim pool</summary>
        /// <param name="numLengths_">Nullable field value to be set</param>
        public void SetNumLengths(ushort? numLengths_)
        {
            SetFieldValue(33, 0, numLengths_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the NormalizedPower field
        /// Units: watts</summary>
        /// <returns>Returns nullable ushort representing the NormalizedPower field</returns>
        public ushort? GetNormalizedPower()
        {
            Object val = GetFieldValue(34, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToUInt16(val));
            
        }

        /// <summary>
        /// Set NormalizedPower field
        /// Units: watts</summary>
        /// <param name="normalizedPower_">Nullable field value to be set</param>
        public void SetNormalizedPower(ushort? normalizedPower_)
        {
            SetFieldValue(34, 0, normalizedPower_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the TrainingStressScore field
        /// Units: tss</summary>
        /// <returns>Returns nullable float representing the TrainingStressScore field</returns>
        public float? GetTrainingStressScore()
        {
            Object val = GetFieldValue(35, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set TrainingStressScore field
        /// Units: tss</summary>
        /// <param name="trainingStressScore_">Nullable field value to be set</param>
        public void SetTrainingStressScore(float? trainingStressScore_)
        {
            SetFieldValue(35, 0, trainingStressScore_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the IntensityFactor field
        /// Units: if</summary>
        /// <returns>Returns nullable float representing the IntensityFactor field</returns>
        public float? GetIntensityFactor()
        {
            Object val = GetFieldValue(36, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set IntensityFactor field
        /// Units: if</summary>
        /// <param name="intensityFactor_">Nullable field value to be set</param>
        public void SetIntensityFactor(float? intensityFactor_)
        {
            SetFieldValue(36, 0, intensityFactor_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the LeftRightBalance field</summary>
        /// <returns>Returns nullable ushort representing the LeftRightBalance field</returns>
        public ushort? GetLeftRightBalance()
        {
            Object val = GetFieldValue(37, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToUInt16(val));
            
        }

        /// <summary>
        /// Set LeftRightBalance field</summary>
        /// <param name="leftRightBalance_">Nullable field value to be set</param>
        public void SetLeftRightBalance(ushort? leftRightBalance_)
        {
            SetFieldValue(37, 0, leftRightBalance_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the AvgStrokeCount field
        /// Units: strokes/lap</summary>
        /// <returns>Returns nullable float representing the AvgStrokeCount field</returns>
        public float? GetAvgStrokeCount()
        {
            Object val = GetFieldValue(41, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set AvgStrokeCount field
        /// Units: strokes/lap</summary>
        /// <param name="avgStrokeCount_">Nullable field value to be set</param>
        public void SetAvgStrokeCount(float? avgStrokeCount_)
        {
            SetFieldValue(41, 0, avgStrokeCount_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the AvgStrokeDistance field
        /// Units: m</summary>
        /// <returns>Returns nullable float representing the AvgStrokeDistance field</returns>
        public float? GetAvgStrokeDistance()
        {
            Object val = GetFieldValue(42, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set AvgStrokeDistance field
        /// Units: m</summary>
        /// <param name="avgStrokeDistance_">Nullable field value to be set</param>
        public void SetAvgStrokeDistance(float? avgStrokeDistance_)
        {
            SetFieldValue(42, 0, avgStrokeDistance_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the SwimStroke field
        /// Units: swim_stroke</summary>
        /// <returns>Returns nullable SwimStroke enum representing the SwimStroke field</returns>
        public SwimStroke? GetSwimStroke()
        {
            object obj = GetFieldValue(43, 0, Fit.SubfieldIndexMainField);
            SwimStroke? value = obj == null ? (SwimStroke?)null : (SwimStroke)obj;
            return value;
        }

        /// <summary>
        /// Set SwimStroke field
        /// Units: swim_stroke</summary>
        /// <param name="swimStroke_">Nullable field value to be set</param>
        public void SetSwimStroke(SwimStroke? swimStroke_)
        {
            SetFieldValue(43, 0, swimStroke_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the PoolLength field
        /// Units: m</summary>
        /// <returns>Returns nullable float representing the PoolLength field</returns>
        public float? GetPoolLength()
        {
            Object val = GetFieldValue(44, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set PoolLength field
        /// Units: m</summary>
        /// <param name="poolLength_">Nullable field value to be set</param>
        public void SetPoolLength(float? poolLength_)
        {
            SetFieldValue(44, 0, poolLength_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the ThresholdPower field
        /// Units: watts</summary>
        /// <returns>Returns nullable ushort representing the ThresholdPower field</returns>
        public ushort? GetThresholdPower()
        {
            Object val = GetFieldValue(45, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToUInt16(val));
            
        }

        /// <summary>
        /// Set ThresholdPower field
        /// Units: watts</summary>
        /// <param name="thresholdPower_">Nullable field value to be set</param>
        public void SetThresholdPower(ushort? thresholdPower_)
        {
            SetFieldValue(45, 0, thresholdPower_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the PoolLengthUnit field</summary>
        /// <returns>Returns nullable DisplayMeasure enum representing the PoolLengthUnit field</returns>
        public DisplayMeasure? GetPoolLengthUnit()
        {
            object obj = GetFieldValue(46, 0, Fit.SubfieldIndexMainField);
            DisplayMeasure? value = obj == null ? (DisplayMeasure?)null : (DisplayMeasure)obj;
            return value;
        }

        /// <summary>
        /// Set PoolLengthUnit field</summary>
        /// <param name="poolLengthUnit_">Nullable field value to be set</param>
        public void SetPoolLengthUnit(DisplayMeasure? poolLengthUnit_)
        {
            SetFieldValue(46, 0, poolLengthUnit_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the NumActiveLengths field
        /// Units: lengths
        /// Comment: # of active lengths of swim pool</summary>
        /// <returns>Returns nullable ushort representing the NumActiveLengths field</returns>
        public ushort? GetNumActiveLengths()
        {
            Object val = GetFieldValue(47, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToUInt16(val));
            
        }

        /// <summary>
        /// Set NumActiveLengths field
        /// Units: lengths
        /// Comment: # of active lengths of swim pool</summary>
        /// <param name="numActiveLengths_">Nullable field value to be set</param>
        public void SetNumActiveLengths(ushort? numActiveLengths_)
        {
            SetFieldValue(47, 0, numActiveLengths_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the TotalWork field
        /// Units: J</summary>
        /// <returns>Returns nullable uint representing the TotalWork field</returns>
        public uint? GetTotalWork()
        {
            Object val = GetFieldValue(48, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToUInt32(val));
            
        }

        /// <summary>
        /// Set TotalWork field
        /// Units: J</summary>
        /// <param name="totalWork_">Nullable field value to be set</param>
        public void SetTotalWork(uint? totalWork_)
        {
            SetFieldValue(48, 0, totalWork_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the AvgAltitude field
        /// Units: m</summary>
        /// <returns>Returns nullable float representing the AvgAltitude field</returns>
        public float? GetAvgAltitude()
        {
            Object val = GetFieldValue(49, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set AvgAltitude field
        /// Units: m</summary>
        /// <param name="avgAltitude_">Nullable field value to be set</param>
        public void SetAvgAltitude(float? avgAltitude_)
        {
            SetFieldValue(49, 0, avgAltitude_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the MaxAltitude field
        /// Units: m</summary>
        /// <returns>Returns nullable float representing the MaxAltitude field</returns>
        public float? GetMaxAltitude()
        {
            Object val = GetFieldValue(50, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set MaxAltitude field
        /// Units: m</summary>
        /// <param name="maxAltitude_">Nullable field value to be set</param>
        public void SetMaxAltitude(float? maxAltitude_)
        {
            SetFieldValue(50, 0, maxAltitude_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the GpsAccuracy field
        /// Units: m</summary>
        /// <returns>Returns nullable byte representing the GpsAccuracy field</returns>
        public byte? GetGpsAccuracy()
        {
            Object val = GetFieldValue(51, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToByte(val));
            
        }

        /// <summary>
        /// Set GpsAccuracy field
        /// Units: m</summary>
        /// <param name="gpsAccuracy_">Nullable field value to be set</param>
        public void SetGpsAccuracy(byte? gpsAccuracy_)
        {
            SetFieldValue(51, 0, gpsAccuracy_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the AvgGrade field
        /// Units: %</summary>
        /// <returns>Returns nullable float representing the AvgGrade field</returns>
        public float? GetAvgGrade()
        {
            Object val = GetFieldValue(52, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set AvgGrade field
        /// Units: %</summary>
        /// <param name="avgGrade_">Nullable field value to be set</param>
        public void SetAvgGrade(float? avgGrade_)
        {
            SetFieldValue(52, 0, avgGrade_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the AvgPosGrade field
        /// Units: %</summary>
        /// <returns>Returns nullable float representing the AvgPosGrade field</returns>
        public float? GetAvgPosGrade()
        {
            Object val = GetFieldValue(53, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set AvgPosGrade field
        /// Units: %</summary>
        /// <param name="avgPosGrade_">Nullable field value to be set</param>
        public void SetAvgPosGrade(float? avgPosGrade_)
        {
            SetFieldValue(53, 0, avgPosGrade_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the AvgNegGrade field
        /// Units: %</summary>
        /// <returns>Returns nullable float representing the AvgNegGrade field</returns>
        public float? GetAvgNegGrade()
        {
            Object val = GetFieldValue(54, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set AvgNegGrade field
        /// Units: %</summary>
        /// <param name="avgNegGrade_">Nullable field value to be set</param>
        public void SetAvgNegGrade(float? avgNegGrade_)
        {
            SetFieldValue(54, 0, avgNegGrade_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the MaxPosGrade field
        /// Units: %</summary>
        /// <returns>Returns nullable float representing the MaxPosGrade field</returns>
        public float? GetMaxPosGrade()
        {
            Object val = GetFieldValue(55, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set MaxPosGrade field
        /// Units: %</summary>
        /// <param name="maxPosGrade_">Nullable field value to be set</param>
        public void SetMaxPosGrade(float? maxPosGrade_)
        {
            SetFieldValue(55, 0, maxPosGrade_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the MaxNegGrade field
        /// Units: %</summary>
        /// <returns>Returns nullable float representing the MaxNegGrade field</returns>
        public float? GetMaxNegGrade()
        {
            Object val = GetFieldValue(56, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set MaxNegGrade field
        /// Units: %</summary>
        /// <param name="maxNegGrade_">Nullable field value to be set</param>
        public void SetMaxNegGrade(float? maxNegGrade_)
        {
            SetFieldValue(56, 0, maxNegGrade_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the AvgTemperature field
        /// Units: C</summary>
        /// <returns>Returns nullable sbyte representing the AvgTemperature field</returns>
        public sbyte? GetAvgTemperature()
        {
            Object val = GetFieldValue(57, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSByte(val));
            
        }

        /// <summary>
        /// Set AvgTemperature field
        /// Units: C</summary>
        /// <param name="avgTemperature_">Nullable field value to be set</param>
        public void SetAvgTemperature(sbyte? avgTemperature_)
        {
            SetFieldValue(57, 0, avgTemperature_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the MaxTemperature field
        /// Units: C</summary>
        /// <returns>Returns nullable sbyte representing the MaxTemperature field</returns>
        public sbyte? GetMaxTemperature()
        {
            Object val = GetFieldValue(58, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSByte(val));
            
        }

        /// <summary>
        /// Set MaxTemperature field
        /// Units: C</summary>
        /// <param name="maxTemperature_">Nullable field value to be set</param>
        public void SetMaxTemperature(sbyte? maxTemperature_)
        {
            SetFieldValue(58, 0, maxTemperature_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the TotalMovingTime field
        /// Units: s</summary>
        /// <returns>Returns nullable float representing the TotalMovingTime field</returns>
        public float? GetTotalMovingTime()
        {
            Object val = GetFieldValue(59, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set TotalMovingTime field
        /// Units: s</summary>
        /// <param name="totalMovingTime_">Nullable field value to be set</param>
        public void SetTotalMovingTime(float? totalMovingTime_)
        {
            SetFieldValue(59, 0, totalMovingTime_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the AvgPosVerticalSpeed field
        /// Units: m/s</summary>
        /// <returns>Returns nullable float representing the AvgPosVerticalSpeed field</returns>
        public float? GetAvgPosVerticalSpeed()
        {
            Object val = GetFieldValue(60, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set AvgPosVerticalSpeed field
        /// Units: m/s</summary>
        /// <param name="avgPosVerticalSpeed_">Nullable field value to be set</param>
        public void SetAvgPosVerticalSpeed(float? avgPosVerticalSpeed_)
        {
            SetFieldValue(60, 0, avgPosVerticalSpeed_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the AvgNegVerticalSpeed field
        /// Units: m/s</summary>
        /// <returns>Returns nullable float representing the AvgNegVerticalSpeed field</returns>
        public float? GetAvgNegVerticalSpeed()
        {
            Object val = GetFieldValue(61, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set AvgNegVerticalSpeed field
        /// Units: m/s</summary>
        /// <param name="avgNegVerticalSpeed_">Nullable field value to be set</param>
        public void SetAvgNegVerticalSpeed(float? avgNegVerticalSpeed_)
        {
            SetFieldValue(61, 0, avgNegVerticalSpeed_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the MaxPosVerticalSpeed field
        /// Units: m/s</summary>
        /// <returns>Returns nullable float representing the MaxPosVerticalSpeed field</returns>
        public float? GetMaxPosVerticalSpeed()
        {
            Object val = GetFieldValue(62, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set MaxPosVerticalSpeed field
        /// Units: m/s</summary>
        /// <param name="maxPosVerticalSpeed_">Nullable field value to be set</param>
        public void SetMaxPosVerticalSpeed(float? maxPosVerticalSpeed_)
        {
            SetFieldValue(62, 0, maxPosVerticalSpeed_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the MaxNegVerticalSpeed field
        /// Units: m/s</summary>
        /// <returns>Returns nullable float representing the MaxNegVerticalSpeed field</returns>
        public float? GetMaxNegVerticalSpeed()
        {
            Object val = GetFieldValue(63, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set MaxNegVerticalSpeed field
        /// Units: m/s</summary>
        /// <param name="maxNegVerticalSpeed_">Nullable field value to be set</param>
        public void SetMaxNegVerticalSpeed(float? maxNegVerticalSpeed_)
        {
            SetFieldValue(63, 0, maxNegVerticalSpeed_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the MinHeartRate field
        /// Units: bpm</summary>
        /// <returns>Returns nullable byte representing the MinHeartRate field</returns>
        public byte? GetMinHeartRate()
        {
            Object val = GetFieldValue(64, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToByte(val));
            
        }

        /// <summary>
        /// Set MinHeartRate field
        /// Units: bpm</summary>
        /// <param name="minHeartRate_">Nullable field value to be set</param>
        public void SetMinHeartRate(byte? minHeartRate_)
        {
            SetFieldValue(64, 0, minHeartRate_, Fit.SubfieldIndexMainField);
        }
        
        
        /// <summary>
        ///
        /// </summary>
        /// <returns>returns number of elements in field TimeInHrZone</returns>
        public int GetNumTimeInHrZone()
        {
            return GetNumFieldValues(65, Fit.SubfieldIndexMainField);
        }

        ///<summary>
        /// Retrieves the TimeInHrZone field
        /// Units: s</summary>
        /// <param name="index">0 based index of TimeInHrZone element to retrieve</param>
        /// <returns>Returns nullable float representing the TimeInHrZone field</returns>
        public float? GetTimeInHrZone(int index)
        {
            Object val = GetFieldValue(65, index, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set TimeInHrZone field
        /// Units: s</summary>
        /// <param name="index">0 based index of time_in_hr_zone</param>
        /// <param name="timeInHrZone_">Nullable field value to be set</param>
        public void SetTimeInHrZone(int index, float? timeInHrZone_)
        {
            SetFieldValue(65, index, timeInHrZone_, Fit.SubfieldIndexMainField);
        }
        
        
        /// <summary>
        ///
        /// </summary>
        /// <returns>returns number of elements in field TimeInSpeedZone</returns>
        public int GetNumTimeInSpeedZone()
        {
            return GetNumFieldValues(66, Fit.SubfieldIndexMainField);
        }

        ///<summary>
        /// Retrieves the TimeInSpeedZone field
        /// Units: s</summary>
        /// <param name="index">0 based index of TimeInSpeedZone element to retrieve</param>
        /// <returns>Returns nullable float representing the TimeInSpeedZone field</returns>
        public float? GetTimeInSpeedZone(int index)
        {
            Object val = GetFieldValue(66, index, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set TimeInSpeedZone field
        /// Units: s</summary>
        /// <param name="index">0 based index of time_in_speed_zone</param>
        /// <param name="timeInSpeedZone_">Nullable field value to be set</param>
        public void SetTimeInSpeedZone(int index, float? timeInSpeedZone_)
        {
            SetFieldValue(66, index, timeInSpeedZone_, Fit.SubfieldIndexMainField);
        }
        
        
        /// <summary>
        ///
        /// </summary>
        /// <returns>returns number of elements in field TimeInCadenceZone</returns>
        public int GetNumTimeInCadenceZone()
        {
            return GetNumFieldValues(67, Fit.SubfieldIndexMainField);
        }

        ///<summary>
        /// Retrieves the TimeInCadenceZone field
        /// Units: s</summary>
        /// <param name="index">0 based index of TimeInCadenceZone element to retrieve</param>
        /// <returns>Returns nullable float representing the TimeInCadenceZone field</returns>
        public float? GetTimeInCadenceZone(int index)
        {
            Object val = GetFieldValue(67, index, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set TimeInCadenceZone field
        /// Units: s</summary>
        /// <param name="index">0 based index of time_in_cadence_zone</param>
        /// <param name="timeInCadenceZone_">Nullable field value to be set</param>
        public void SetTimeInCadenceZone(int index, float? timeInCadenceZone_)
        {
            SetFieldValue(67, index, timeInCadenceZone_, Fit.SubfieldIndexMainField);
        }
        
        
        /// <summary>
        ///
        /// </summary>
        /// <returns>returns number of elements in field TimeInPowerZone</returns>
        public int GetNumTimeInPowerZone()
        {
            return GetNumFieldValues(68, Fit.SubfieldIndexMainField);
        }

        ///<summary>
        /// Retrieves the TimeInPowerZone field
        /// Units: s</summary>
        /// <param name="index">0 based index of TimeInPowerZone element to retrieve</param>
        /// <returns>Returns nullable float representing the TimeInPowerZone field</returns>
        public float? GetTimeInPowerZone(int index)
        {
            Object val = GetFieldValue(68, index, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set TimeInPowerZone field
        /// Units: s</summary>
        /// <param name="index">0 based index of time_in_power_zone</param>
        /// <param name="timeInPowerZone_">Nullable field value to be set</param>
        public void SetTimeInPowerZone(int index, float? timeInPowerZone_)
        {
            SetFieldValue(68, index, timeInPowerZone_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the AvgLapTime field
        /// Units: s</summary>
        /// <returns>Returns nullable float representing the AvgLapTime field</returns>
        public float? GetAvgLapTime()
        {
            Object val = GetFieldValue(69, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set AvgLapTime field
        /// Units: s</summary>
        /// <param name="avgLapTime_">Nullable field value to be set</param>
        public void SetAvgLapTime(float? avgLapTime_)
        {
            SetFieldValue(69, 0, avgLapTime_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the BestLapIndex field</summary>
        /// <returns>Returns nullable ushort representing the BestLapIndex field</returns>
        public ushort? GetBestLapIndex()
        {
            Object val = GetFieldValue(70, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToUInt16(val));
            
        }

        /// <summary>
        /// Set BestLapIndex field</summary>
        /// <param name="bestLapIndex_">Nullable field value to be set</param>
        public void SetBestLapIndex(ushort? bestLapIndex_)
        {
            SetFieldValue(70, 0, bestLapIndex_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the MinAltitude field
        /// Units: m</summary>
        /// <returns>Returns nullable float representing the MinAltitude field</returns>
        public float? GetMinAltitude()
        {
            Object val = GetFieldValue(71, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set MinAltitude field
        /// Units: m</summary>
        /// <param name="minAltitude_">Nullable field value to be set</param>
        public void SetMinAltitude(float? minAltitude_)
        {
            SetFieldValue(71, 0, minAltitude_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the PlayerScore field</summary>
        /// <returns>Returns nullable ushort representing the PlayerScore field</returns>
        public ushort? GetPlayerScore()
        {
            Object val = GetFieldValue(82, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToUInt16(val));
            
        }

        /// <summary>
        /// Set PlayerScore field</summary>
        /// <param name="playerScore_">Nullable field value to be set</param>
        public void SetPlayerScore(ushort? playerScore_)
        {
            SetFieldValue(82, 0, playerScore_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the OpponentScore field</summary>
        /// <returns>Returns nullable ushort representing the OpponentScore field</returns>
        public ushort? GetOpponentScore()
        {
            Object val = GetFieldValue(83, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToUInt16(val));
            
        }

        /// <summary>
        /// Set OpponentScore field</summary>
        /// <param name="opponentScore_">Nullable field value to be set</param>
        public void SetOpponentScore(ushort? opponentScore_)
        {
            SetFieldValue(83, 0, opponentScore_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the OpponentName field</summary>
        /// <returns>Returns byte[] representing the OpponentName field</returns>
        public byte[] GetOpponentName()
        {
            byte[] data = (byte[])GetFieldValue(84, 0, Fit.SubfieldIndexMainField);
            return data.Take(data.Length - 1).ToArray();
        }

        ///<summary>
        /// Retrieves the OpponentName field</summary>
        /// <returns>Returns String representing the OpponentName field</returns>
        public String GetOpponentNameAsString()
        {
            byte[] data = (byte[])GetFieldValue(84, 0, Fit.SubfieldIndexMainField);
            return data != null ? Encoding.UTF8.GetString(data, 0, data.Length - 1) : null;
        }

        ///<summary>
        /// Set OpponentName field</summary>
        /// <param name="opponentName_"> field value to be set</param>
        public void SetOpponentName(String opponentName_)
        {
            byte[] data = Encoding.UTF8.GetBytes(opponentName_);
            byte[] zdata = new byte[data.Length + 1];
            data.CopyTo(zdata, 0);
            SetFieldValue(84, 0, zdata, Fit.SubfieldIndexMainField);
        }

        
        /// <summary>
        /// Set OpponentName field</summary>
        /// <param name="opponentName_">field value to be set</param>
        public void SetOpponentName(byte[] opponentName_)
        {
            SetFieldValue(84, 0, opponentName_, Fit.SubfieldIndexMainField);
        }
        
        
        /// <summary>
        ///
        /// </summary>
        /// <returns>returns number of elements in field StrokeCount</returns>
        public int GetNumStrokeCount()
        {
            return GetNumFieldValues(85, Fit.SubfieldIndexMainField);
        }

        ///<summary>
        /// Retrieves the StrokeCount field
        /// Units: counts
        /// Comment: stroke_type enum used as the index</summary>
        /// <param name="index">0 based index of StrokeCount element to retrieve</param>
        /// <returns>Returns nullable ushort representing the StrokeCount field</returns>
        public ushort? GetStrokeCount(int index)
        {
            Object val = GetFieldValue(85, index, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToUInt16(val));
            
        }

        /// <summary>
        /// Set StrokeCount field
        /// Units: counts
        /// Comment: stroke_type enum used as the index</summary>
        /// <param name="index">0 based index of stroke_count</param>
        /// <param name="strokeCount_">Nullable field value to be set</param>
        public void SetStrokeCount(int index, ushort? strokeCount_)
        {
            SetFieldValue(85, index, strokeCount_, Fit.SubfieldIndexMainField);
        }
        
        
        /// <summary>
        ///
        /// </summary>
        /// <returns>returns number of elements in field ZoneCount</returns>
        public int GetNumZoneCount()
        {
            return GetNumFieldValues(86, Fit.SubfieldIndexMainField);
        }

        ///<summary>
        /// Retrieves the ZoneCount field
        /// Units: counts
        /// Comment: zone number used as the index</summary>
        /// <param name="index">0 based index of ZoneCount element to retrieve</param>
        /// <returns>Returns nullable ushort representing the ZoneCount field</returns>
        public ushort? GetZoneCount(int index)
        {
            Object val = GetFieldValue(86, index, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToUInt16(val));
            
        }

        /// <summary>
        /// Set ZoneCount field
        /// Units: counts
        /// Comment: zone number used as the index</summary>
        /// <param name="index">0 based index of zone_count</param>
        /// <param name="zoneCount_">Nullable field value to be set</param>
        public void SetZoneCount(int index, ushort? zoneCount_)
        {
            SetFieldValue(86, index, zoneCount_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the MaxBallSpeed field
        /// Units: m/s</summary>
        /// <returns>Returns nullable float representing the MaxBallSpeed field</returns>
        public float? GetMaxBallSpeed()
        {
            Object val = GetFieldValue(87, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set MaxBallSpeed field
        /// Units: m/s</summary>
        /// <param name="maxBallSpeed_">Nullable field value to be set</param>
        public void SetMaxBallSpeed(float? maxBallSpeed_)
        {
            SetFieldValue(87, 0, maxBallSpeed_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the AvgBallSpeed field
        /// Units: m/s</summary>
        /// <returns>Returns nullable float representing the AvgBallSpeed field</returns>
        public float? GetAvgBallSpeed()
        {
            Object val = GetFieldValue(88, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set AvgBallSpeed field
        /// Units: m/s</summary>
        /// <param name="avgBallSpeed_">Nullable field value to be set</param>
        public void SetAvgBallSpeed(float? avgBallSpeed_)
        {
            SetFieldValue(88, 0, avgBallSpeed_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the AvgVerticalOscillation field
        /// Units: mm</summary>
        /// <returns>Returns nullable float representing the AvgVerticalOscillation field</returns>
        public float? GetAvgVerticalOscillation()
        {
            Object val = GetFieldValue(89, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set AvgVerticalOscillation field
        /// Units: mm</summary>
        /// <param name="avgVerticalOscillation_">Nullable field value to be set</param>
        public void SetAvgVerticalOscillation(float? avgVerticalOscillation_)
        {
            SetFieldValue(89, 0, avgVerticalOscillation_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the AvgStanceTimePercent field
        /// Units: percent</summary>
        /// <returns>Returns nullable float representing the AvgStanceTimePercent field</returns>
        public float? GetAvgStanceTimePercent()
        {
            Object val = GetFieldValue(90, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set AvgStanceTimePercent field
        /// Units: percent</summary>
        /// <param name="avgStanceTimePercent_">Nullable field value to be set</param>
        public void SetAvgStanceTimePercent(float? avgStanceTimePercent_)
        {
            SetFieldValue(90, 0, avgStanceTimePercent_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the AvgStanceTime field
        /// Units: ms</summary>
        /// <returns>Returns nullable float representing the AvgStanceTime field</returns>
        public float? GetAvgStanceTime()
        {
            Object val = GetFieldValue(91, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set AvgStanceTime field
        /// Units: ms</summary>
        /// <param name="avgStanceTime_">Nullable field value to be set</param>
        public void SetAvgStanceTime(float? avgStanceTime_)
        {
            SetFieldValue(91, 0, avgStanceTime_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the AvgFractionalCadence field
        /// Units: rpm
        /// Comment: fractional part of the avg_cadence</summary>
        /// <returns>Returns nullable float representing the AvgFractionalCadence field</returns>
        public float? GetAvgFractionalCadence()
        {
            Object val = GetFieldValue(92, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set AvgFractionalCadence field
        /// Units: rpm
        /// Comment: fractional part of the avg_cadence</summary>
        /// <param name="avgFractionalCadence_">Nullable field value to be set</param>
        public void SetAvgFractionalCadence(float? avgFractionalCadence_)
        {
            SetFieldValue(92, 0, avgFractionalCadence_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the MaxFractionalCadence field
        /// Units: rpm
        /// Comment: fractional part of the max_cadence</summary>
        /// <returns>Returns nullable float representing the MaxFractionalCadence field</returns>
        public float? GetMaxFractionalCadence()
        {
            Object val = GetFieldValue(93, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set MaxFractionalCadence field
        /// Units: rpm
        /// Comment: fractional part of the max_cadence</summary>
        /// <param name="maxFractionalCadence_">Nullable field value to be set</param>
        public void SetMaxFractionalCadence(float? maxFractionalCadence_)
        {
            SetFieldValue(93, 0, maxFractionalCadence_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the TotalFractionalCycles field
        /// Units: cycles
        /// Comment: fractional part of the total_cycles</summary>
        /// <returns>Returns nullable float representing the TotalFractionalCycles field</returns>
        public float? GetTotalFractionalCycles()
        {
            Object val = GetFieldValue(94, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set TotalFractionalCycles field
        /// Units: cycles
        /// Comment: fractional part of the total_cycles</summary>
        /// <param name="totalFractionalCycles_">Nullable field value to be set</param>
        public void SetTotalFractionalCycles(float? totalFractionalCycles_)
        {
            SetFieldValue(94, 0, totalFractionalCycles_, Fit.SubfieldIndexMainField);
        }
        
        
        /// <summary>
        ///
        /// </summary>
        /// <returns>returns number of elements in field AvgTotalHemoglobinConc</returns>
        public int GetNumAvgTotalHemoglobinConc()
        {
            return GetNumFieldValues(95, Fit.SubfieldIndexMainField);
        }

        ///<summary>
        /// Retrieves the AvgTotalHemoglobinConc field
        /// Units: g/dL
        /// Comment: Avg saturated and unsaturated hemoglobin</summary>
        /// <param name="index">0 based index of AvgTotalHemoglobinConc element to retrieve</param>
        /// <returns>Returns nullable float representing the AvgTotalHemoglobinConc field</returns>
        public float? GetAvgTotalHemoglobinConc(int index)
        {
            Object val = GetFieldValue(95, index, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set AvgTotalHemoglobinConc field
        /// Units: g/dL
        /// Comment: Avg saturated and unsaturated hemoglobin</summary>
        /// <param name="index">0 based index of avg_total_hemoglobin_conc</param>
        /// <param name="avgTotalHemoglobinConc_">Nullable field value to be set</param>
        public void SetAvgTotalHemoglobinConc(int index, float? avgTotalHemoglobinConc_)
        {
            SetFieldValue(95, index, avgTotalHemoglobinConc_, Fit.SubfieldIndexMainField);
        }
        
        
        /// <summary>
        ///
        /// </summary>
        /// <returns>returns number of elements in field MinTotalHemoglobinConc</returns>
        public int GetNumMinTotalHemoglobinConc()
        {
            return GetNumFieldValues(96, Fit.SubfieldIndexMainField);
        }

        ///<summary>
        /// Retrieves the MinTotalHemoglobinConc field
        /// Units: g/dL
        /// Comment: Min saturated and unsaturated hemoglobin</summary>
        /// <param name="index">0 based index of MinTotalHemoglobinConc element to retrieve</param>
        /// <returns>Returns nullable float representing the MinTotalHemoglobinConc field</returns>
        public float? GetMinTotalHemoglobinConc(int index)
        {
            Object val = GetFieldValue(96, index, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set MinTotalHemoglobinConc field
        /// Units: g/dL
        /// Comment: Min saturated and unsaturated hemoglobin</summary>
        /// <param name="index">0 based index of min_total_hemoglobin_conc</param>
        /// <param name="minTotalHemoglobinConc_">Nullable field value to be set</param>
        public void SetMinTotalHemoglobinConc(int index, float? minTotalHemoglobinConc_)
        {
            SetFieldValue(96, index, minTotalHemoglobinConc_, Fit.SubfieldIndexMainField);
        }
        
        
        /// <summary>
        ///
        /// </summary>
        /// <returns>returns number of elements in field MaxTotalHemoglobinConc</returns>
        public int GetNumMaxTotalHemoglobinConc()
        {
            return GetNumFieldValues(97, Fit.SubfieldIndexMainField);
        }

        ///<summary>
        /// Retrieves the MaxTotalHemoglobinConc field
        /// Units: g/dL
        /// Comment: Max saturated and unsaturated hemoglobin</summary>
        /// <param name="index">0 based index of MaxTotalHemoglobinConc element to retrieve</param>
        /// <returns>Returns nullable float representing the MaxTotalHemoglobinConc field</returns>
        public float? GetMaxTotalHemoglobinConc(int index)
        {
            Object val = GetFieldValue(97, index, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set MaxTotalHemoglobinConc field
        /// Units: g/dL
        /// Comment: Max saturated and unsaturated hemoglobin</summary>
        /// <param name="index">0 based index of max_total_hemoglobin_conc</param>
        /// <param name="maxTotalHemoglobinConc_">Nullable field value to be set</param>
        public void SetMaxTotalHemoglobinConc(int index, float? maxTotalHemoglobinConc_)
        {
            SetFieldValue(97, index, maxTotalHemoglobinConc_, Fit.SubfieldIndexMainField);
        }
        
        
        /// <summary>
        ///
        /// </summary>
        /// <returns>returns number of elements in field AvgSaturatedHemoglobinPercent</returns>
        public int GetNumAvgSaturatedHemoglobinPercent()
        {
            return GetNumFieldValues(98, Fit.SubfieldIndexMainField);
        }

        ///<summary>
        /// Retrieves the AvgSaturatedHemoglobinPercent field
        /// Units: %
        /// Comment: Avg percentage of hemoglobin saturated with oxygen</summary>
        /// <param name="index">0 based index of AvgSaturatedHemoglobinPercent element to retrieve</param>
        /// <returns>Returns nullable float representing the AvgSaturatedHemoglobinPercent field</returns>
        public float? GetAvgSaturatedHemoglobinPercent(int index)
        {
            Object val = GetFieldValue(98, index, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set AvgSaturatedHemoglobinPercent field
        /// Units: %
        /// Comment: Avg percentage of hemoglobin saturated with oxygen</summary>
        /// <param name="index">0 based index of avg_saturated_hemoglobin_percent</param>
        /// <param name="avgSaturatedHemoglobinPercent_">Nullable field value to be set</param>
        public void SetAvgSaturatedHemoglobinPercent(int index, float? avgSaturatedHemoglobinPercent_)
        {
            SetFieldValue(98, index, avgSaturatedHemoglobinPercent_, Fit.SubfieldIndexMainField);
        }
        
        
        /// <summary>
        ///
        /// </summary>
        /// <returns>returns number of elements in field MinSaturatedHemoglobinPercent</returns>
        public int GetNumMinSaturatedHemoglobinPercent()
        {
            return GetNumFieldValues(99, Fit.SubfieldIndexMainField);
        }

        ///<summary>
        /// Retrieves the MinSaturatedHemoglobinPercent field
        /// Units: %
        /// Comment: Min percentage of hemoglobin saturated with oxygen</summary>
        /// <param name="index">0 based index of MinSaturatedHemoglobinPercent element to retrieve</param>
        /// <returns>Returns nullable float representing the MinSaturatedHemoglobinPercent field</returns>
        public float? GetMinSaturatedHemoglobinPercent(int index)
        {
            Object val = GetFieldValue(99, index, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set MinSaturatedHemoglobinPercent field
        /// Units: %
        /// Comment: Min percentage of hemoglobin saturated with oxygen</summary>
        /// <param name="index">0 based index of min_saturated_hemoglobin_percent</param>
        /// <param name="minSaturatedHemoglobinPercent_">Nullable field value to be set</param>
        public void SetMinSaturatedHemoglobinPercent(int index, float? minSaturatedHemoglobinPercent_)
        {
            SetFieldValue(99, index, minSaturatedHemoglobinPercent_, Fit.SubfieldIndexMainField);
        }
        
        
        /// <summary>
        ///
        /// </summary>
        /// <returns>returns number of elements in field MaxSaturatedHemoglobinPercent</returns>
        public int GetNumMaxSaturatedHemoglobinPercent()
        {
            return GetNumFieldValues(100, Fit.SubfieldIndexMainField);
        }

        ///<summary>
        /// Retrieves the MaxSaturatedHemoglobinPercent field
        /// Units: %
        /// Comment: Max percentage of hemoglobin saturated with oxygen</summary>
        /// <param name="index">0 based index of MaxSaturatedHemoglobinPercent element to retrieve</param>
        /// <returns>Returns nullable float representing the MaxSaturatedHemoglobinPercent field</returns>
        public float? GetMaxSaturatedHemoglobinPercent(int index)
        {
            Object val = GetFieldValue(100, index, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set MaxSaturatedHemoglobinPercent field
        /// Units: %
        /// Comment: Max percentage of hemoglobin saturated with oxygen</summary>
        /// <param name="index">0 based index of max_saturated_hemoglobin_percent</param>
        /// <param name="maxSaturatedHemoglobinPercent_">Nullable field value to be set</param>
        public void SetMaxSaturatedHemoglobinPercent(int index, float? maxSaturatedHemoglobinPercent_)
        {
            SetFieldValue(100, index, maxSaturatedHemoglobinPercent_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the AvgLeftTorqueEffectiveness field
        /// Units: percent</summary>
        /// <returns>Returns nullable float representing the AvgLeftTorqueEffectiveness field</returns>
        public float? GetAvgLeftTorqueEffectiveness()
        {
            Object val = GetFieldValue(101, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set AvgLeftTorqueEffectiveness field
        /// Units: percent</summary>
        /// <param name="avgLeftTorqueEffectiveness_">Nullable field value to be set</param>
        public void SetAvgLeftTorqueEffectiveness(float? avgLeftTorqueEffectiveness_)
        {
            SetFieldValue(101, 0, avgLeftTorqueEffectiveness_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the AvgRightTorqueEffectiveness field
        /// Units: percent</summary>
        /// <returns>Returns nullable float representing the AvgRightTorqueEffectiveness field</returns>
        public float? GetAvgRightTorqueEffectiveness()
        {
            Object val = GetFieldValue(102, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set AvgRightTorqueEffectiveness field
        /// Units: percent</summary>
        /// <param name="avgRightTorqueEffectiveness_">Nullable field value to be set</param>
        public void SetAvgRightTorqueEffectiveness(float? avgRightTorqueEffectiveness_)
        {
            SetFieldValue(102, 0, avgRightTorqueEffectiveness_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the AvgLeftPedalSmoothness field
        /// Units: percent</summary>
        /// <returns>Returns nullable float representing the AvgLeftPedalSmoothness field</returns>
        public float? GetAvgLeftPedalSmoothness()
        {
            Object val = GetFieldValue(103, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set AvgLeftPedalSmoothness field
        /// Units: percent</summary>
        /// <param name="avgLeftPedalSmoothness_">Nullable field value to be set</param>
        public void SetAvgLeftPedalSmoothness(float? avgLeftPedalSmoothness_)
        {
            SetFieldValue(103, 0, avgLeftPedalSmoothness_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the AvgRightPedalSmoothness field
        /// Units: percent</summary>
        /// <returns>Returns nullable float representing the AvgRightPedalSmoothness field</returns>
        public float? GetAvgRightPedalSmoothness()
        {
            Object val = GetFieldValue(104, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set AvgRightPedalSmoothness field
        /// Units: percent</summary>
        /// <param name="avgRightPedalSmoothness_">Nullable field value to be set</param>
        public void SetAvgRightPedalSmoothness(float? avgRightPedalSmoothness_)
        {
            SetFieldValue(104, 0, avgRightPedalSmoothness_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the AvgCombinedPedalSmoothness field
        /// Units: percent</summary>
        /// <returns>Returns nullable float representing the AvgCombinedPedalSmoothness field</returns>
        public float? GetAvgCombinedPedalSmoothness()
        {
            Object val = GetFieldValue(105, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set AvgCombinedPedalSmoothness field
        /// Units: percent</summary>
        /// <param name="avgCombinedPedalSmoothness_">Nullable field value to be set</param>
        public void SetAvgCombinedPedalSmoothness(float? avgCombinedPedalSmoothness_)
        {
            SetFieldValue(105, 0, avgCombinedPedalSmoothness_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the SportIndex field</summary>
        /// <returns>Returns nullable byte representing the SportIndex field</returns>
        public byte? GetSportIndex()
        {
            Object val = GetFieldValue(111, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToByte(val));
            
        }

        /// <summary>
        /// Set SportIndex field</summary>
        /// <param name="sportIndex_">Nullable field value to be set</param>
        public void SetSportIndex(byte? sportIndex_)
        {
            SetFieldValue(111, 0, sportIndex_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the TimeStanding field
        /// Units: s
        /// Comment: Total time spend in the standing position</summary>
        /// <returns>Returns nullable float representing the TimeStanding field</returns>
        public float? GetTimeStanding()
        {
            Object val = GetFieldValue(112, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set TimeStanding field
        /// Units: s
        /// Comment: Total time spend in the standing position</summary>
        /// <param name="timeStanding_">Nullable field value to be set</param>
        public void SetTimeStanding(float? timeStanding_)
        {
            SetFieldValue(112, 0, timeStanding_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the StandCount field
        /// Comment: Number of transitions to the standing state</summary>
        /// <returns>Returns nullable ushort representing the StandCount field</returns>
        public ushort? GetStandCount()
        {
            Object val = GetFieldValue(113, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToUInt16(val));
            
        }

        /// <summary>
        /// Set StandCount field
        /// Comment: Number of transitions to the standing state</summary>
        /// <param name="standCount_">Nullable field value to be set</param>
        public void SetStandCount(ushort? standCount_)
        {
            SetFieldValue(113, 0, standCount_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the AvgLeftPco field
        /// Units: mm
        /// Comment: Average platform center offset Left</summary>
        /// <returns>Returns nullable sbyte representing the AvgLeftPco field</returns>
        public sbyte? GetAvgLeftPco()
        {
            Object val = GetFieldValue(114, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSByte(val));
            
        }

        /// <summary>
        /// Set AvgLeftPco field
        /// Units: mm
        /// Comment: Average platform center offset Left</summary>
        /// <param name="avgLeftPco_">Nullable field value to be set</param>
        public void SetAvgLeftPco(sbyte? avgLeftPco_)
        {
            SetFieldValue(114, 0, avgLeftPco_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the AvgRightPco field
        /// Units: mm
        /// Comment: Average platform center offset Right</summary>
        /// <returns>Returns nullable sbyte representing the AvgRightPco field</returns>
        public sbyte? GetAvgRightPco()
        {
            Object val = GetFieldValue(115, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSByte(val));
            
        }

        /// <summary>
        /// Set AvgRightPco field
        /// Units: mm
        /// Comment: Average platform center offset Right</summary>
        /// <param name="avgRightPco_">Nullable field value to be set</param>
        public void SetAvgRightPco(sbyte? avgRightPco_)
        {
            SetFieldValue(115, 0, avgRightPco_, Fit.SubfieldIndexMainField);
        }
        
        
        /// <summary>
        ///
        /// </summary>
        /// <returns>returns number of elements in field AvgLeftPowerPhase</returns>
        public int GetNumAvgLeftPowerPhase()
        {
            return GetNumFieldValues(116, Fit.SubfieldIndexMainField);
        }

        ///<summary>
        /// Retrieves the AvgLeftPowerPhase field
        /// Units: degrees
        /// Comment: Average left power phase angles. Indexes defined by power_phase_type.</summary>
        /// <param name="index">0 based index of AvgLeftPowerPhase element to retrieve</param>
        /// <returns>Returns nullable float representing the AvgLeftPowerPhase field</returns>
        public float? GetAvgLeftPowerPhase(int index)
        {
            Object val = GetFieldValue(116, index, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set AvgLeftPowerPhase field
        /// Units: degrees
        /// Comment: Average left power phase angles. Indexes defined by power_phase_type.</summary>
        /// <param name="index">0 based index of avg_left_power_phase</param>
        /// <param name="avgLeftPowerPhase_">Nullable field value to be set</param>
        public void SetAvgLeftPowerPhase(int index, float? avgLeftPowerPhase_)
        {
            SetFieldValue(116, index, avgLeftPowerPhase_, Fit.SubfieldIndexMainField);
        }
        
        
        /// <summary>
        ///
        /// </summary>
        /// <returns>returns number of elements in field AvgLeftPowerPhasePeak</returns>
        public int GetNumAvgLeftPowerPhasePeak()
        {
            return GetNumFieldValues(117, Fit.SubfieldIndexMainField);
        }

        ///<summary>
        /// Retrieves the AvgLeftPowerPhasePeak field
        /// Units: degrees
        /// Comment: Average left power phase peak angles. Data value indexes defined by power_phase_type.</summary>
        /// <param name="index">0 based index of AvgLeftPowerPhasePeak element to retrieve</param>
        /// <returns>Returns nullable float representing the AvgLeftPowerPhasePeak field</returns>
        public float? GetAvgLeftPowerPhasePeak(int index)
        {
            Object val = GetFieldValue(117, index, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set AvgLeftPowerPhasePeak field
        /// Units: degrees
        /// Comment: Average left power phase peak angles. Data value indexes defined by power_phase_type.</summary>
        /// <param name="index">0 based index of avg_left_power_phase_peak</param>
        /// <param name="avgLeftPowerPhasePeak_">Nullable field value to be set</param>
        public void SetAvgLeftPowerPhasePeak(int index, float? avgLeftPowerPhasePeak_)
        {
            SetFieldValue(117, index, avgLeftPowerPhasePeak_, Fit.SubfieldIndexMainField);
        }
        
        
        /// <summary>
        ///
        /// </summary>
        /// <returns>returns number of elements in field AvgRightPowerPhase</returns>
        public int GetNumAvgRightPowerPhase()
        {
            return GetNumFieldValues(118, Fit.SubfieldIndexMainField);
        }

        ///<summary>
        /// Retrieves the AvgRightPowerPhase field
        /// Units: degrees
        /// Comment: Average right power phase angles. Data value indexes defined by power_phase_type.</summary>
        /// <param name="index">0 based index of AvgRightPowerPhase element to retrieve</param>
        /// <returns>Returns nullable float representing the AvgRightPowerPhase field</returns>
        public float? GetAvgRightPowerPhase(int index)
        {
            Object val = GetFieldValue(118, index, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set AvgRightPowerPhase field
        /// Units: degrees
        /// Comment: Average right power phase angles. Data value indexes defined by power_phase_type.</summary>
        /// <param name="index">0 based index of avg_right_power_phase</param>
        /// <param name="avgRightPowerPhase_">Nullable field value to be set</param>
        public void SetAvgRightPowerPhase(int index, float? avgRightPowerPhase_)
        {
            SetFieldValue(118, index, avgRightPowerPhase_, Fit.SubfieldIndexMainField);
        }
        
        
        /// <summary>
        ///
        /// </summary>
        /// <returns>returns number of elements in field AvgRightPowerPhasePeak</returns>
        public int GetNumAvgRightPowerPhasePeak()
        {
            return GetNumFieldValues(119, Fit.SubfieldIndexMainField);
        }

        ///<summary>
        /// Retrieves the AvgRightPowerPhasePeak field
        /// Units: degrees
        /// Comment: Average right power phase peak angles data value indexes  defined by power_phase_type.</summary>
        /// <param name="index">0 based index of AvgRightPowerPhasePeak element to retrieve</param>
        /// <returns>Returns nullable float representing the AvgRightPowerPhasePeak field</returns>
        public float? GetAvgRightPowerPhasePeak(int index)
        {
            Object val = GetFieldValue(119, index, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set AvgRightPowerPhasePeak field
        /// Units: degrees
        /// Comment: Average right power phase peak angles data value indexes  defined by power_phase_type.</summary>
        /// <param name="index">0 based index of avg_right_power_phase_peak</param>
        /// <param name="avgRightPowerPhasePeak_">Nullable field value to be set</param>
        public void SetAvgRightPowerPhasePeak(int index, float? avgRightPowerPhasePeak_)
        {
            SetFieldValue(119, index, avgRightPowerPhasePeak_, Fit.SubfieldIndexMainField);
        }
        
        
        /// <summary>
        ///
        /// </summary>
        /// <returns>returns number of elements in field AvgPowerPosition</returns>
        public int GetNumAvgPowerPosition()
        {
            return GetNumFieldValues(120, Fit.SubfieldIndexMainField);
        }

        ///<summary>
        /// Retrieves the AvgPowerPosition field
        /// Units: watts
        /// Comment: Average power by position. Data value indexes defined by rider_position_type.</summary>
        /// <param name="index">0 based index of AvgPowerPosition element to retrieve</param>
        /// <returns>Returns nullable ushort representing the AvgPowerPosition field</returns>
        public ushort? GetAvgPowerPosition(int index)
        {
            Object val = GetFieldValue(120, index, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToUInt16(val));
            
        }

        /// <summary>
        /// Set AvgPowerPosition field
        /// Units: watts
        /// Comment: Average power by position. Data value indexes defined by rider_position_type.</summary>
        /// <param name="index">0 based index of avg_power_position</param>
        /// <param name="avgPowerPosition_">Nullable field value to be set</param>
        public void SetAvgPowerPosition(int index, ushort? avgPowerPosition_)
        {
            SetFieldValue(120, index, avgPowerPosition_, Fit.SubfieldIndexMainField);
        }
        
        
        /// <summary>
        ///
        /// </summary>
        /// <returns>returns number of elements in field MaxPowerPosition</returns>
        public int GetNumMaxPowerPosition()
        {
            return GetNumFieldValues(121, Fit.SubfieldIndexMainField);
        }

        ///<summary>
        /// Retrieves the MaxPowerPosition field
        /// Units: watts
        /// Comment: Maximum power by position. Data value indexes defined by rider_position_type.</summary>
        /// <param name="index">0 based index of MaxPowerPosition element to retrieve</param>
        /// <returns>Returns nullable ushort representing the MaxPowerPosition field</returns>
        public ushort? GetMaxPowerPosition(int index)
        {
            Object val = GetFieldValue(121, index, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToUInt16(val));
            
        }

        /// <summary>
        /// Set MaxPowerPosition field
        /// Units: watts
        /// Comment: Maximum power by position. Data value indexes defined by rider_position_type.</summary>
        /// <param name="index">0 based index of max_power_position</param>
        /// <param name="maxPowerPosition_">Nullable field value to be set</param>
        public void SetMaxPowerPosition(int index, ushort? maxPowerPosition_)
        {
            SetFieldValue(121, index, maxPowerPosition_, Fit.SubfieldIndexMainField);
        }
        
        
        /// <summary>
        ///
        /// </summary>
        /// <returns>returns number of elements in field AvgCadencePosition</returns>
        public int GetNumAvgCadencePosition()
        {
            return GetNumFieldValues(122, Fit.SubfieldIndexMainField);
        }

        ///<summary>
        /// Retrieves the AvgCadencePosition field
        /// Units: rpm
        /// Comment: Average cadence by position. Data value indexes defined by rider_position_type.</summary>
        /// <param name="index">0 based index of AvgCadencePosition element to retrieve</param>
        /// <returns>Returns nullable byte representing the AvgCadencePosition field</returns>
        public byte? GetAvgCadencePosition(int index)
        {
            Object val = GetFieldValue(122, index, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToByte(val));
            
        }

        /// <summary>
        /// Set AvgCadencePosition field
        /// Units: rpm
        /// Comment: Average cadence by position. Data value indexes defined by rider_position_type.</summary>
        /// <param name="index">0 based index of avg_cadence_position</param>
        /// <param name="avgCadencePosition_">Nullable field value to be set</param>
        public void SetAvgCadencePosition(int index, byte? avgCadencePosition_)
        {
            SetFieldValue(122, index, avgCadencePosition_, Fit.SubfieldIndexMainField);
        }
        
        
        /// <summary>
        ///
        /// </summary>
        /// <returns>returns number of elements in field MaxCadencePosition</returns>
        public int GetNumMaxCadencePosition()
        {
            return GetNumFieldValues(123, Fit.SubfieldIndexMainField);
        }

        ///<summary>
        /// Retrieves the MaxCadencePosition field
        /// Units: rpm
        /// Comment: Maximum cadence by position. Data value indexes defined by rider_position_type.</summary>
        /// <param name="index">0 based index of MaxCadencePosition element to retrieve</param>
        /// <returns>Returns nullable byte representing the MaxCadencePosition field</returns>
        public byte? GetMaxCadencePosition(int index)
        {
            Object val = GetFieldValue(123, index, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToByte(val));
            
        }

        /// <summary>
        /// Set MaxCadencePosition field
        /// Units: rpm
        /// Comment: Maximum cadence by position. Data value indexes defined by rider_position_type.</summary>
        /// <param name="index">0 based index of max_cadence_position</param>
        /// <param name="maxCadencePosition_">Nullable field value to be set</param>
        public void SetMaxCadencePosition(int index, byte? maxCadencePosition_)
        {
            SetFieldValue(123, index, maxCadencePosition_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the EnhancedAvgSpeed field
        /// Units: m/s
        /// Comment: total_distance / total_timer_time</summary>
        /// <returns>Returns nullable float representing the EnhancedAvgSpeed field</returns>
        public float? GetEnhancedAvgSpeed()
        {
            Object val = GetFieldValue(124, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set EnhancedAvgSpeed field
        /// Units: m/s
        /// Comment: total_distance / total_timer_time</summary>
        /// <param name="enhancedAvgSpeed_">Nullable field value to be set</param>
        public void SetEnhancedAvgSpeed(float? enhancedAvgSpeed_)
        {
            SetFieldValue(124, 0, enhancedAvgSpeed_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the EnhancedMaxSpeed field
        /// Units: m/s</summary>
        /// <returns>Returns nullable float representing the EnhancedMaxSpeed field</returns>
        public float? GetEnhancedMaxSpeed()
        {
            Object val = GetFieldValue(125, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set EnhancedMaxSpeed field
        /// Units: m/s</summary>
        /// <param name="enhancedMaxSpeed_">Nullable field value to be set</param>
        public void SetEnhancedMaxSpeed(float? enhancedMaxSpeed_)
        {
            SetFieldValue(125, 0, enhancedMaxSpeed_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the EnhancedAvgAltitude field
        /// Units: m</summary>
        /// <returns>Returns nullable float representing the EnhancedAvgAltitude field</returns>
        public float? GetEnhancedAvgAltitude()
        {
            Object val = GetFieldValue(126, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set EnhancedAvgAltitude field
        /// Units: m</summary>
        /// <param name="enhancedAvgAltitude_">Nullable field value to be set</param>
        public void SetEnhancedAvgAltitude(float? enhancedAvgAltitude_)
        {
            SetFieldValue(126, 0, enhancedAvgAltitude_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the EnhancedMinAltitude field
        /// Units: m</summary>
        /// <returns>Returns nullable float representing the EnhancedMinAltitude field</returns>
        public float? GetEnhancedMinAltitude()
        {
            Object val = GetFieldValue(127, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set EnhancedMinAltitude field
        /// Units: m</summary>
        /// <param name="enhancedMinAltitude_">Nullable field value to be set</param>
        public void SetEnhancedMinAltitude(float? enhancedMinAltitude_)
        {
            SetFieldValue(127, 0, enhancedMinAltitude_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the EnhancedMaxAltitude field
        /// Units: m</summary>
        /// <returns>Returns nullable float representing the EnhancedMaxAltitude field</returns>
        public float? GetEnhancedMaxAltitude()
        {
            Object val = GetFieldValue(128, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set EnhancedMaxAltitude field
        /// Units: m</summary>
        /// <param name="enhancedMaxAltitude_">Nullable field value to be set</param>
        public void SetEnhancedMaxAltitude(float? enhancedMaxAltitude_)
        {
            SetFieldValue(128, 0, enhancedMaxAltitude_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the AvgLevMotorPower field
        /// Units: watts
        /// Comment: lev average motor power during session</summary>
        /// <returns>Returns nullable ushort representing the AvgLevMotorPower field</returns>
        public ushort? GetAvgLevMotorPower()
        {
            Object val = GetFieldValue(129, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToUInt16(val));
            
        }

        /// <summary>
        /// Set AvgLevMotorPower field
        /// Units: watts
        /// Comment: lev average motor power during session</summary>
        /// <param name="avgLevMotorPower_">Nullable field value to be set</param>
        public void SetAvgLevMotorPower(ushort? avgLevMotorPower_)
        {
            SetFieldValue(129, 0, avgLevMotorPower_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the MaxLevMotorPower field
        /// Units: watts
        /// Comment: lev maximum motor power during session</summary>
        /// <returns>Returns nullable ushort representing the MaxLevMotorPower field</returns>
        public ushort? GetMaxLevMotorPower()
        {
            Object val = GetFieldValue(130, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToUInt16(val));
            
        }

        /// <summary>
        /// Set MaxLevMotorPower field
        /// Units: watts
        /// Comment: lev maximum motor power during session</summary>
        /// <param name="maxLevMotorPower_">Nullable field value to be set</param>
        public void SetMaxLevMotorPower(ushort? maxLevMotorPower_)
        {
            SetFieldValue(130, 0, maxLevMotorPower_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the LevBatteryConsumption field
        /// Units: percent
        /// Comment: lev battery consumption during session</summary>
        /// <returns>Returns nullable float representing the LevBatteryConsumption field</returns>
        public float? GetLevBatteryConsumption()
        {
            Object val = GetFieldValue(131, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set LevBatteryConsumption field
        /// Units: percent
        /// Comment: lev battery consumption during session</summary>
        /// <param name="levBatteryConsumption_">Nullable field value to be set</param>
        public void SetLevBatteryConsumption(float? levBatteryConsumption_)
        {
            SetFieldValue(131, 0, levBatteryConsumption_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the AvgVerticalRatio field
        /// Units: percent</summary>
        /// <returns>Returns nullable float representing the AvgVerticalRatio field</returns>
        public float? GetAvgVerticalRatio()
        {
            Object val = GetFieldValue(132, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set AvgVerticalRatio field
        /// Units: percent</summary>
        /// <param name="avgVerticalRatio_">Nullable field value to be set</param>
        public void SetAvgVerticalRatio(float? avgVerticalRatio_)
        {
            SetFieldValue(132, 0, avgVerticalRatio_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the AvgStanceTimeBalance field
        /// Units: percent</summary>
        /// <returns>Returns nullable float representing the AvgStanceTimeBalance field</returns>
        public float? GetAvgStanceTimeBalance()
        {
            Object val = GetFieldValue(133, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set AvgStanceTimeBalance field
        /// Units: percent</summary>
        /// <param name="avgStanceTimeBalance_">Nullable field value to be set</param>
        public void SetAvgStanceTimeBalance(float? avgStanceTimeBalance_)
        {
            SetFieldValue(133, 0, avgStanceTimeBalance_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the AvgStepLength field
        /// Units: mm</summary>
        /// <returns>Returns nullable float representing the AvgStepLength field</returns>
        public float? GetAvgStepLength()
        {
            Object val = GetFieldValue(134, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set AvgStepLength field
        /// Units: mm</summary>
        /// <param name="avgStepLength_">Nullable field value to be set</param>
        public void SetAvgStepLength(float? avgStepLength_)
        {
            SetFieldValue(134, 0, avgStepLength_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the TotalAnaerobicTrainingEffect field</summary>
        /// <returns>Returns nullable float representing the TotalAnaerobicTrainingEffect field</returns>
        public float? GetTotalAnaerobicTrainingEffect()
        {
            Object val = GetFieldValue(137, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set TotalAnaerobicTrainingEffect field</summary>
        /// <param name="totalAnaerobicTrainingEffect_">Nullable field value to be set</param>
        public void SetTotalAnaerobicTrainingEffect(float? totalAnaerobicTrainingEffect_)
        {
            SetFieldValue(137, 0, totalAnaerobicTrainingEffect_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the AvgVam field
        /// Units: m/s</summary>
        /// <returns>Returns nullable float representing the AvgVam field</returns>
        public float? GetAvgVam()
        {
            Object val = GetFieldValue(139, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set AvgVam field
        /// Units: m/s</summary>
        /// <param name="avgVam_">Nullable field value to be set</param>
        public void SetAvgVam(float? avgVam_)
        {
            SetFieldValue(139, 0, avgVam_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the TotalGrit field
        /// Units: kGrit
        /// Comment: The grit score estimates how challenging a route could be for a cyclist in terms of time spent going over sharp turns or large grade slopes.</summary>
        /// <returns>Returns nullable float representing the TotalGrit field</returns>
        public float? GetTotalGrit()
        {
            Object val = GetFieldValue(181, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set TotalGrit field
        /// Units: kGrit
        /// Comment: The grit score estimates how challenging a route could be for a cyclist in terms of time spent going over sharp turns or large grade slopes.</summary>
        /// <param name="totalGrit_">Nullable field value to be set</param>
        public void SetTotalGrit(float? totalGrit_)
        {
            SetFieldValue(181, 0, totalGrit_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the TotalFlow field
        /// Units: Flow
        /// Comment: The flow score estimates how long distance wise a cyclist deaccelerates over intervals where deacceleration is unnecessary such as smooth turns or small grade angle intervals.</summary>
        /// <returns>Returns nullable float representing the TotalFlow field</returns>
        public float? GetTotalFlow()
        {
            Object val = GetFieldValue(182, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set TotalFlow field
        /// Units: Flow
        /// Comment: The flow score estimates how long distance wise a cyclist deaccelerates over intervals where deacceleration is unnecessary such as smooth turns or small grade angle intervals.</summary>
        /// <param name="totalFlow_">Nullable field value to be set</param>
        public void SetTotalFlow(float? totalFlow_)
        {
            SetFieldValue(182, 0, totalFlow_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the JumpCount field</summary>
        /// <returns>Returns nullable ushort representing the JumpCount field</returns>
        public ushort? GetJumpCount()
        {
            Object val = GetFieldValue(183, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToUInt16(val));
            
        }

        /// <summary>
        /// Set JumpCount field</summary>
        /// <param name="jumpCount_">Nullable field value to be set</param>
        public void SetJumpCount(ushort? jumpCount_)
        {
            SetFieldValue(183, 0, jumpCount_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the AvgGrit field
        /// Units: kGrit
        /// Comment: The grit score estimates how challenging a route could be for a cyclist in terms of time spent going over sharp turns or large grade slopes.</summary>
        /// <returns>Returns nullable float representing the AvgGrit field</returns>
        public float? GetAvgGrit()
        {
            Object val = GetFieldValue(186, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set AvgGrit field
        /// Units: kGrit
        /// Comment: The grit score estimates how challenging a route could be for a cyclist in terms of time spent going over sharp turns or large grade slopes.</summary>
        /// <param name="avgGrit_">Nullable field value to be set</param>
        public void SetAvgGrit(float? avgGrit_)
        {
            SetFieldValue(186, 0, avgGrit_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the AvgFlow field
        /// Units: Flow
        /// Comment: The flow score estimates how long distance wise a cyclist deaccelerates over intervals where deacceleration is unnecessary such as smooth turns or small grade angle intervals.</summary>
        /// <returns>Returns nullable float representing the AvgFlow field</returns>
        public float? GetAvgFlow()
        {
            Object val = GetFieldValue(187, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set AvgFlow field
        /// Units: Flow
        /// Comment: The flow score estimates how long distance wise a cyclist deaccelerates over intervals where deacceleration is unnecessary such as smooth turns or small grade angle intervals.</summary>
        /// <param name="avgFlow_">Nullable field value to be set</param>
        public void SetAvgFlow(float? avgFlow_)
        {
            SetFieldValue(187, 0, avgFlow_, Fit.SubfieldIndexMainField);
        }
        
        #endregion // Methods
    } // Class
} // namespace
