#region Copyright
////////////////////////////////////////////////////////////////////////////////
// The following FIT Protocol software provided may be used with FIT protocol
// devices only and remains the copyrighted property of Garmin Canada Inc.
// The software is being provided on an "as-is" basis and as an accommodation,
// and therefore all warranties, representations, or guarantees of any kind
// (whether express, implied or statutory) including, without limitation,
// warranties of merchantability, non-infringement, or fitness for a particular
// purpose, are specifically disclaimed.
//
// Copyright 2020 Garmin Canada Inc.
////////////////////////////////////////////////////////////////////////////////
// ****WARNING****  This file is auto-generated!  Do NOT edit this file.
// Profile Version = 21.38Release
// Tag = production/akw/21.38.00-0-g0d69e49
////////////////////////////////////////////////////////////////////////////////

#endregion

using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Text;
using System.IO;
using System.Linq;

namespace Dynastream.Fit
{
    /// <summary>
    /// Implements the SegmentLap profile message.
    /// </summary>
    public class SegmentLapMesg : Mesg
    {
        #region Fields
        static class TotalCyclesSubfield
        {
            public static ushort TotalStrokes = 0;
            public static ushort Subfields = 1;
            public static ushort Active = Fit.SubfieldIndexActiveSubfield;
            public static ushort MainField = Fit.SubfieldIndexMainField;
        }
        #endregion

        /// <summary>
        /// Field Numbers for <see cref="SegmentLapMesg"/>
        /// </summary>
        public sealed class FieldDefNum
        {
            public const byte MessageIndex = 254;
            public const byte Timestamp = 253;
            public const byte Event = 0;
            public const byte EventType = 1;
            public const byte StartTime = 2;
            public const byte StartPositionLat = 3;
            public const byte StartPositionLong = 4;
            public const byte EndPositionLat = 5;
            public const byte EndPositionLong = 6;
            public const byte TotalElapsedTime = 7;
            public const byte TotalTimerTime = 8;
            public const byte TotalDistance = 9;
            public const byte TotalCycles = 10;
            public const byte TotalCalories = 11;
            public const byte TotalFatCalories = 12;
            public const byte AvgSpeed = 13;
            public const byte MaxSpeed = 14;
            public const byte AvgHeartRate = 15;
            public const byte MaxHeartRate = 16;
            public const byte AvgCadence = 17;
            public const byte MaxCadence = 18;
            public const byte AvgPower = 19;
            public const byte MaxPower = 20;
            public const byte TotalAscent = 21;
            public const byte TotalDescent = 22;
            public const byte Sport = 23;
            public const byte EventGroup = 24;
            public const byte NecLat = 25;
            public const byte NecLong = 26;
            public const byte SwcLat = 27;
            public const byte SwcLong = 28;
            public const byte Name = 29;
            public const byte NormalizedPower = 30;
            public const byte LeftRightBalance = 31;
            public const byte SubSport = 32;
            public const byte TotalWork = 33;
            public const byte AvgAltitude = 34;
            public const byte MaxAltitude = 35;
            public const byte GpsAccuracy = 36;
            public const byte AvgGrade = 37;
            public const byte AvgPosGrade = 38;
            public const byte AvgNegGrade = 39;
            public const byte MaxPosGrade = 40;
            public const byte MaxNegGrade = 41;
            public const byte AvgTemperature = 42;
            public const byte MaxTemperature = 43;
            public const byte TotalMovingTime = 44;
            public const byte AvgPosVerticalSpeed = 45;
            public const byte AvgNegVerticalSpeed = 46;
            public const byte MaxPosVerticalSpeed = 47;
            public const byte MaxNegVerticalSpeed = 48;
            public const byte TimeInHrZone = 49;
            public const byte TimeInSpeedZone = 50;
            public const byte TimeInCadenceZone = 51;
            public const byte TimeInPowerZone = 52;
            public const byte RepetitionNum = 53;
            public const byte MinAltitude = 54;
            public const byte MinHeartRate = 55;
            public const byte ActiveTime = 56;
            public const byte WktStepIndex = 57;
            public const byte SportEvent = 58;
            public const byte AvgLeftTorqueEffectiveness = 59;
            public const byte AvgRightTorqueEffectiveness = 60;
            public const byte AvgLeftPedalSmoothness = 61;
            public const byte AvgRightPedalSmoothness = 62;
            public const byte AvgCombinedPedalSmoothness = 63;
            public const byte Status = 64;
            public const byte Uuid = 65;
            public const byte AvgFractionalCadence = 66;
            public const byte MaxFractionalCadence = 67;
            public const byte TotalFractionalCycles = 68;
            public const byte FrontGearShiftCount = 69;
            public const byte RearGearShiftCount = 70;
            public const byte TimeStanding = 71;
            public const byte StandCount = 72;
            public const byte AvgLeftPco = 73;
            public const byte AvgRightPco = 74;
            public const byte AvgLeftPowerPhase = 75;
            public const byte AvgLeftPowerPhasePeak = 76;
            public const byte AvgRightPowerPhase = 77;
            public const byte AvgRightPowerPhasePeak = 78;
            public const byte AvgPowerPosition = 79;
            public const byte MaxPowerPosition = 80;
            public const byte AvgCadencePosition = 81;
            public const byte MaxCadencePosition = 82;
            public const byte Manufacturer = 83;
            public const byte TotalGrit = 84;
            public const byte TotalFlow = 85;
            public const byte AvgGrit = 86;
            public const byte AvgFlow = 87;
            public const byte Invalid = Fit.FieldNumInvalid;
        }

        #region Constructors
        public SegmentLapMesg() : base(Profile.GetMesg(MesgNum.SegmentLap))
        {
        }

        public SegmentLapMesg(Mesg mesg) : base(mesg)
        {
        }
        #endregion // Constructors

        #region Methods
        ///<summary>
        /// Retrieves the MessageIndex field</summary>
        /// <returns>Returns nullable ushort representing the MessageIndex field</returns>
        public ushort? GetMessageIndex()
        {
            Object val = GetFieldValue(254, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToUInt16(val));
            
        }

        /// <summary>
        /// Set MessageIndex field</summary>
        /// <param name="messageIndex_">Nullable field value to be set</param>
        public void SetMessageIndex(ushort? messageIndex_)
        {
            SetFieldValue(254, 0, messageIndex_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the Timestamp field
        /// Units: s
        /// Comment: Lap end time.</summary>
        /// <returns>Returns DateTime representing the Timestamp field</returns>
        public DateTime GetTimestamp()
        {
            Object val = GetFieldValue(253, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return TimestampToDateTime(Convert.ToUInt32(val));
            
        }

        /// <summary>
        /// Set Timestamp field
        /// Units: s
        /// Comment: Lap end time.</summary>
        /// <param name="timestamp_">Nullable field value to be set</param>
        public void SetTimestamp(DateTime timestamp_)
        {
            SetFieldValue(253, 0, timestamp_.GetTimeStamp(), Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the Event field</summary>
        /// <returns>Returns nullable Event enum representing the Event field</returns>
        public Event? GetEvent()
        {
            object obj = GetFieldValue(0, 0, Fit.SubfieldIndexMainField);
            Event? value = obj == null ? (Event?)null : (Event)obj;
            return value;
        }

        /// <summary>
        /// Set Event field</summary>
        /// <param name="event_">Nullable field value to be set</param>
        public void SetEvent(Event? event_)
        {
            SetFieldValue(0, 0, event_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the EventType field</summary>
        /// <returns>Returns nullable EventType enum representing the EventType field</returns>
        public EventType? GetEventType()
        {
            object obj = GetFieldValue(1, 0, Fit.SubfieldIndexMainField);
            EventType? value = obj == null ? (EventType?)null : (EventType)obj;
            return value;
        }

        /// <summary>
        /// Set EventType field</summary>
        /// <param name="eventType_">Nullable field value to be set</param>
        public void SetEventType(EventType? eventType_)
        {
            SetFieldValue(1, 0, eventType_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the StartTime field</summary>
        /// <returns>Returns DateTime representing the StartTime field</returns>
        public DateTime GetStartTime()
        {
            Object val = GetFieldValue(2, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return TimestampToDateTime(Convert.ToUInt32(val));
            
        }

        /// <summary>
        /// Set StartTime field</summary>
        /// <param name="startTime_">Nullable field value to be set</param>
        public void SetStartTime(DateTime startTime_)
        {
            SetFieldValue(2, 0, startTime_.GetTimeStamp(), Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the StartPositionLat field
        /// Units: semicircles</summary>
        /// <returns>Returns nullable int representing the StartPositionLat field</returns>
        public int? GetStartPositionLat()
        {
            Object val = GetFieldValue(3, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToInt32(val));
            
        }

        /// <summary>
        /// Set StartPositionLat field
        /// Units: semicircles</summary>
        /// <param name="startPositionLat_">Nullable field value to be set</param>
        public void SetStartPositionLat(int? startPositionLat_)
        {
            SetFieldValue(3, 0, startPositionLat_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the StartPositionLong field
        /// Units: semicircles</summary>
        /// <returns>Returns nullable int representing the StartPositionLong field</returns>
        public int? GetStartPositionLong()
        {
            Object val = GetFieldValue(4, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToInt32(val));
            
        }

        /// <summary>
        /// Set StartPositionLong field
        /// Units: semicircles</summary>
        /// <param name="startPositionLong_">Nullable field value to be set</param>
        public void SetStartPositionLong(int? startPositionLong_)
        {
            SetFieldValue(4, 0, startPositionLong_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the EndPositionLat field
        /// Units: semicircles</summary>
        /// <returns>Returns nullable int representing the EndPositionLat field</returns>
        public int? GetEndPositionLat()
        {
            Object val = GetFieldValue(5, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToInt32(val));
            
        }

        /// <summary>
        /// Set EndPositionLat field
        /// Units: semicircles</summary>
        /// <param name="endPositionLat_">Nullable field value to be set</param>
        public void SetEndPositionLat(int? endPositionLat_)
        {
            SetFieldValue(5, 0, endPositionLat_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the EndPositionLong field
        /// Units: semicircles</summary>
        /// <returns>Returns nullable int representing the EndPositionLong field</returns>
        public int? GetEndPositionLong()
        {
            Object val = GetFieldValue(6, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToInt32(val));
            
        }

        /// <summary>
        /// Set EndPositionLong field
        /// Units: semicircles</summary>
        /// <param name="endPositionLong_">Nullable field value to be set</param>
        public void SetEndPositionLong(int? endPositionLong_)
        {
            SetFieldValue(6, 0, endPositionLong_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the TotalElapsedTime field
        /// Units: s
        /// Comment: Time (includes pauses)</summary>
        /// <returns>Returns nullable float representing the TotalElapsedTime field</returns>
        public float? GetTotalElapsedTime()
        {
            Object val = GetFieldValue(7, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set TotalElapsedTime field
        /// Units: s
        /// Comment: Time (includes pauses)</summary>
        /// <param name="totalElapsedTime_">Nullable field value to be set</param>
        public void SetTotalElapsedTime(float? totalElapsedTime_)
        {
            SetFieldValue(7, 0, totalElapsedTime_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the TotalTimerTime field
        /// Units: s
        /// Comment: Timer Time (excludes pauses)</summary>
        /// <returns>Returns nullable float representing the TotalTimerTime field</returns>
        public float? GetTotalTimerTime()
        {
            Object val = GetFieldValue(8, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set TotalTimerTime field
        /// Units: s
        /// Comment: Timer Time (excludes pauses)</summary>
        /// <param name="totalTimerTime_">Nullable field value to be set</param>
        public void SetTotalTimerTime(float? totalTimerTime_)
        {
            SetFieldValue(8, 0, totalTimerTime_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the TotalDistance field
        /// Units: m</summary>
        /// <returns>Returns nullable float representing the TotalDistance field</returns>
        public float? GetTotalDistance()
        {
            Object val = GetFieldValue(9, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set TotalDistance field
        /// Units: m</summary>
        /// <param name="totalDistance_">Nullable field value to be set</param>
        public void SetTotalDistance(float? totalDistance_)
        {
            SetFieldValue(9, 0, totalDistance_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the TotalCycles field
        /// Units: cycles</summary>
        /// <returns>Returns nullable uint representing the TotalCycles field</returns>
        public uint? GetTotalCycles()
        {
            Object val = GetFieldValue(10, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToUInt32(val));
            
        }

        /// <summary>
        /// Set TotalCycles field
        /// Units: cycles</summary>
        /// <param name="totalCycles_">Nullable field value to be set</param>
        public void SetTotalCycles(uint? totalCycles_)
        {
            SetFieldValue(10, 0, totalCycles_, Fit.SubfieldIndexMainField);
        }
        

        /// <summary>
        /// Retrieves the TotalStrokes subfield
        /// Units: strokes</summary>
        /// <returns>Nullable uint representing the TotalStrokes subfield</returns>
        public uint? GetTotalStrokes()
        {
            Object val = GetFieldValue(10, 0, TotalCyclesSubfield.TotalStrokes);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToUInt32(val));
            
        }

        /// <summary>
        ///
        /// Set TotalStrokes subfield
        /// Units: strokes</summary>
        /// <param name="totalStrokes">Subfield value to be set</param>
        public void SetTotalStrokes(uint? totalStrokes)
        {
            SetFieldValue(10, 0, totalStrokes, TotalCyclesSubfield.TotalStrokes);
        }
        ///<summary>
        /// Retrieves the TotalCalories field
        /// Units: kcal</summary>
        /// <returns>Returns nullable ushort representing the TotalCalories field</returns>
        public ushort? GetTotalCalories()
        {
            Object val = GetFieldValue(11, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToUInt16(val));
            
        }

        /// <summary>
        /// Set TotalCalories field
        /// Units: kcal</summary>
        /// <param name="totalCalories_">Nullable field value to be set</param>
        public void SetTotalCalories(ushort? totalCalories_)
        {
            SetFieldValue(11, 0, totalCalories_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the TotalFatCalories field
        /// Units: kcal
        /// Comment: If New Leaf</summary>
        /// <returns>Returns nullable ushort representing the TotalFatCalories field</returns>
        public ushort? GetTotalFatCalories()
        {
            Object val = GetFieldValue(12, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToUInt16(val));
            
        }

        /// <summary>
        /// Set TotalFatCalories field
        /// Units: kcal
        /// Comment: If New Leaf</summary>
        /// <param name="totalFatCalories_">Nullable field value to be set</param>
        public void SetTotalFatCalories(ushort? totalFatCalories_)
        {
            SetFieldValue(12, 0, totalFatCalories_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the AvgSpeed field
        /// Units: m/s</summary>
        /// <returns>Returns nullable float representing the AvgSpeed field</returns>
        public float? GetAvgSpeed()
        {
            Object val = GetFieldValue(13, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set AvgSpeed field
        /// Units: m/s</summary>
        /// <param name="avgSpeed_">Nullable field value to be set</param>
        public void SetAvgSpeed(float? avgSpeed_)
        {
            SetFieldValue(13, 0, avgSpeed_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the MaxSpeed field
        /// Units: m/s</summary>
        /// <returns>Returns nullable float representing the MaxSpeed field</returns>
        public float? GetMaxSpeed()
        {
            Object val = GetFieldValue(14, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set MaxSpeed field
        /// Units: m/s</summary>
        /// <param name="maxSpeed_">Nullable field value to be set</param>
        public void SetMaxSpeed(float? maxSpeed_)
        {
            SetFieldValue(14, 0, maxSpeed_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the AvgHeartRate field
        /// Units: bpm</summary>
        /// <returns>Returns nullable byte representing the AvgHeartRate field</returns>
        public byte? GetAvgHeartRate()
        {
            Object val = GetFieldValue(15, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToByte(val));
            
        }

        /// <summary>
        /// Set AvgHeartRate field
        /// Units: bpm</summary>
        /// <param name="avgHeartRate_">Nullable field value to be set</param>
        public void SetAvgHeartRate(byte? avgHeartRate_)
        {
            SetFieldValue(15, 0, avgHeartRate_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the MaxHeartRate field
        /// Units: bpm</summary>
        /// <returns>Returns nullable byte representing the MaxHeartRate field</returns>
        public byte? GetMaxHeartRate()
        {
            Object val = GetFieldValue(16, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToByte(val));
            
        }

        /// <summary>
        /// Set MaxHeartRate field
        /// Units: bpm</summary>
        /// <param name="maxHeartRate_">Nullable field value to be set</param>
        public void SetMaxHeartRate(byte? maxHeartRate_)
        {
            SetFieldValue(16, 0, maxHeartRate_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the AvgCadence field
        /// Units: rpm
        /// Comment: total_cycles / total_timer_time if non_zero_avg_cadence otherwise total_cycles / total_elapsed_time</summary>
        /// <returns>Returns nullable byte representing the AvgCadence field</returns>
        public byte? GetAvgCadence()
        {
            Object val = GetFieldValue(17, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToByte(val));
            
        }

        /// <summary>
        /// Set AvgCadence field
        /// Units: rpm
        /// Comment: total_cycles / total_timer_time if non_zero_avg_cadence otherwise total_cycles / total_elapsed_time</summary>
        /// <param name="avgCadence_">Nullable field value to be set</param>
        public void SetAvgCadence(byte? avgCadence_)
        {
            SetFieldValue(17, 0, avgCadence_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the MaxCadence field
        /// Units: rpm</summary>
        /// <returns>Returns nullable byte representing the MaxCadence field</returns>
        public byte? GetMaxCadence()
        {
            Object val = GetFieldValue(18, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToByte(val));
            
        }

        /// <summary>
        /// Set MaxCadence field
        /// Units: rpm</summary>
        /// <param name="maxCadence_">Nullable field value to be set</param>
        public void SetMaxCadence(byte? maxCadence_)
        {
            SetFieldValue(18, 0, maxCadence_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the AvgPower field
        /// Units: watts
        /// Comment: total_power / total_timer_time if non_zero_avg_power otherwise total_power / total_elapsed_time</summary>
        /// <returns>Returns nullable ushort representing the AvgPower field</returns>
        public ushort? GetAvgPower()
        {
            Object val = GetFieldValue(19, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToUInt16(val));
            
        }

        /// <summary>
        /// Set AvgPower field
        /// Units: watts
        /// Comment: total_power / total_timer_time if non_zero_avg_power otherwise total_power / total_elapsed_time</summary>
        /// <param name="avgPower_">Nullable field value to be set</param>
        public void SetAvgPower(ushort? avgPower_)
        {
            SetFieldValue(19, 0, avgPower_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the MaxPower field
        /// Units: watts</summary>
        /// <returns>Returns nullable ushort representing the MaxPower field</returns>
        public ushort? GetMaxPower()
        {
            Object val = GetFieldValue(20, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToUInt16(val));
            
        }

        /// <summary>
        /// Set MaxPower field
        /// Units: watts</summary>
        /// <param name="maxPower_">Nullable field value to be set</param>
        public void SetMaxPower(ushort? maxPower_)
        {
            SetFieldValue(20, 0, maxPower_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the TotalAscent field
        /// Units: m</summary>
        /// <returns>Returns nullable ushort representing the TotalAscent field</returns>
        public ushort? GetTotalAscent()
        {
            Object val = GetFieldValue(21, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToUInt16(val));
            
        }

        /// <summary>
        /// Set TotalAscent field
        /// Units: m</summary>
        /// <param name="totalAscent_">Nullable field value to be set</param>
        public void SetTotalAscent(ushort? totalAscent_)
        {
            SetFieldValue(21, 0, totalAscent_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the TotalDescent field
        /// Units: m</summary>
        /// <returns>Returns nullable ushort representing the TotalDescent field</returns>
        public ushort? GetTotalDescent()
        {
            Object val = GetFieldValue(22, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToUInt16(val));
            
        }

        /// <summary>
        /// Set TotalDescent field
        /// Units: m</summary>
        /// <param name="totalDescent_">Nullable field value to be set</param>
        public void SetTotalDescent(ushort? totalDescent_)
        {
            SetFieldValue(22, 0, totalDescent_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the Sport field</summary>
        /// <returns>Returns nullable Sport enum representing the Sport field</returns>
        public Sport? GetSport()
        {
            object obj = GetFieldValue(23, 0, Fit.SubfieldIndexMainField);
            Sport? value = obj == null ? (Sport?)null : (Sport)obj;
            return value;
        }

        /// <summary>
        /// Set Sport field</summary>
        /// <param name="sport_">Nullable field value to be set</param>
        public void SetSport(Sport? sport_)
        {
            SetFieldValue(23, 0, sport_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the EventGroup field</summary>
        /// <returns>Returns nullable byte representing the EventGroup field</returns>
        public byte? GetEventGroup()
        {
            Object val = GetFieldValue(24, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToByte(val));
            
        }

        /// <summary>
        /// Set EventGroup field</summary>
        /// <param name="eventGroup_">Nullable field value to be set</param>
        public void SetEventGroup(byte? eventGroup_)
        {
            SetFieldValue(24, 0, eventGroup_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the NecLat field
        /// Units: semicircles
        /// Comment: North east corner latitude.</summary>
        /// <returns>Returns nullable int representing the NecLat field</returns>
        public int? GetNecLat()
        {
            Object val = GetFieldValue(25, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToInt32(val));
            
        }

        /// <summary>
        /// Set NecLat field
        /// Units: semicircles
        /// Comment: North east corner latitude.</summary>
        /// <param name="necLat_">Nullable field value to be set</param>
        public void SetNecLat(int? necLat_)
        {
            SetFieldValue(25, 0, necLat_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the NecLong field
        /// Units: semicircles
        /// Comment: North east corner longitude.</summary>
        /// <returns>Returns nullable int representing the NecLong field</returns>
        public int? GetNecLong()
        {
            Object val = GetFieldValue(26, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToInt32(val));
            
        }

        /// <summary>
        /// Set NecLong field
        /// Units: semicircles
        /// Comment: North east corner longitude.</summary>
        /// <param name="necLong_">Nullable field value to be set</param>
        public void SetNecLong(int? necLong_)
        {
            SetFieldValue(26, 0, necLong_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the SwcLat field
        /// Units: semicircles
        /// Comment: South west corner latitude.</summary>
        /// <returns>Returns nullable int representing the SwcLat field</returns>
        public int? GetSwcLat()
        {
            Object val = GetFieldValue(27, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToInt32(val));
            
        }

        /// <summary>
        /// Set SwcLat field
        /// Units: semicircles
        /// Comment: South west corner latitude.</summary>
        /// <param name="swcLat_">Nullable field value to be set</param>
        public void SetSwcLat(int? swcLat_)
        {
            SetFieldValue(27, 0, swcLat_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the SwcLong field
        /// Units: semicircles
        /// Comment: South west corner latitude.</summary>
        /// <returns>Returns nullable int representing the SwcLong field</returns>
        public int? GetSwcLong()
        {
            Object val = GetFieldValue(28, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToInt32(val));
            
        }

        /// <summary>
        /// Set SwcLong field
        /// Units: semicircles
        /// Comment: South west corner latitude.</summary>
        /// <param name="swcLong_">Nullable field value to be set</param>
        public void SetSwcLong(int? swcLong_)
        {
            SetFieldValue(28, 0, swcLong_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the Name field</summary>
        /// <returns>Returns byte[] representing the Name field</returns>
        public byte[] GetName()
        {
            byte[] data = (byte[])GetFieldValue(29, 0, Fit.SubfieldIndexMainField);
            return data.Take(data.Length - 1).ToArray();
        }

        ///<summary>
        /// Retrieves the Name field</summary>
        /// <returns>Returns String representing the Name field</returns>
        public String GetNameAsString()
        {
            byte[] data = (byte[])GetFieldValue(29, 0, Fit.SubfieldIndexMainField);
            return data != null ? Encoding.UTF8.GetString(data, 0, data.Length - 1) : null;
        }

        ///<summary>
        /// Set Name field</summary>
        /// <param name="name_"> field value to be set</param>
        public void SetName(String name_)
        {
            byte[] data = Encoding.UTF8.GetBytes(name_);
            byte[] zdata = new byte[data.Length + 1];
            data.CopyTo(zdata, 0);
            SetFieldValue(29, 0, zdata, Fit.SubfieldIndexMainField);
        }

        
        /// <summary>
        /// Set Name field</summary>
        /// <param name="name_">field value to be set</param>
        public void SetName(byte[] name_)
        {
            SetFieldValue(29, 0, name_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the NormalizedPower field
        /// Units: watts</summary>
        /// <returns>Returns nullable ushort representing the NormalizedPower field</returns>
        public ushort? GetNormalizedPower()
        {
            Object val = GetFieldValue(30, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToUInt16(val));
            
        }

        /// <summary>
        /// Set NormalizedPower field
        /// Units: watts</summary>
        /// <param name="normalizedPower_">Nullable field value to be set</param>
        public void SetNormalizedPower(ushort? normalizedPower_)
        {
            SetFieldValue(30, 0, normalizedPower_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the LeftRightBalance field</summary>
        /// <returns>Returns nullable ushort representing the LeftRightBalance field</returns>
        public ushort? GetLeftRightBalance()
        {
            Object val = GetFieldValue(31, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToUInt16(val));
            
        }

        /// <summary>
        /// Set LeftRightBalance field</summary>
        /// <param name="leftRightBalance_">Nullable field value to be set</param>
        public void SetLeftRightBalance(ushort? leftRightBalance_)
        {
            SetFieldValue(31, 0, leftRightBalance_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the SubSport field</summary>
        /// <returns>Returns nullable SubSport enum representing the SubSport field</returns>
        public SubSport? GetSubSport()
        {
            object obj = GetFieldValue(32, 0, Fit.SubfieldIndexMainField);
            SubSport? value = obj == null ? (SubSport?)null : (SubSport)obj;
            return value;
        }

        /// <summary>
        /// Set SubSport field</summary>
        /// <param name="subSport_">Nullable field value to be set</param>
        public void SetSubSport(SubSport? subSport_)
        {
            SetFieldValue(32, 0, subSport_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the TotalWork field
        /// Units: J</summary>
        /// <returns>Returns nullable uint representing the TotalWork field</returns>
        public uint? GetTotalWork()
        {
            Object val = GetFieldValue(33, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToUInt32(val));
            
        }

        /// <summary>
        /// Set TotalWork field
        /// Units: J</summary>
        /// <param name="totalWork_">Nullable field value to be set</param>
        public void SetTotalWork(uint? totalWork_)
        {
            SetFieldValue(33, 0, totalWork_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the AvgAltitude field
        /// Units: m</summary>
        /// <returns>Returns nullable float representing the AvgAltitude field</returns>
        public float? GetAvgAltitude()
        {
            Object val = GetFieldValue(34, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set AvgAltitude field
        /// Units: m</summary>
        /// <param name="avgAltitude_">Nullable field value to be set</param>
        public void SetAvgAltitude(float? avgAltitude_)
        {
            SetFieldValue(34, 0, avgAltitude_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the MaxAltitude field
        /// Units: m</summary>
        /// <returns>Returns nullable float representing the MaxAltitude field</returns>
        public float? GetMaxAltitude()
        {
            Object val = GetFieldValue(35, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set MaxAltitude field
        /// Units: m</summary>
        /// <param name="maxAltitude_">Nullable field value to be set</param>
        public void SetMaxAltitude(float? maxAltitude_)
        {
            SetFieldValue(35, 0, maxAltitude_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the GpsAccuracy field
        /// Units: m</summary>
        /// <returns>Returns nullable byte representing the GpsAccuracy field</returns>
        public byte? GetGpsAccuracy()
        {
            Object val = GetFieldValue(36, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToByte(val));
            
        }

        /// <summary>
        /// Set GpsAccuracy field
        /// Units: m</summary>
        /// <param name="gpsAccuracy_">Nullable field value to be set</param>
        public void SetGpsAccuracy(byte? gpsAccuracy_)
        {
            SetFieldValue(36, 0, gpsAccuracy_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the AvgGrade field
        /// Units: %</summary>
        /// <returns>Returns nullable float representing the AvgGrade field</returns>
        public float? GetAvgGrade()
        {
            Object val = GetFieldValue(37, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set AvgGrade field
        /// Units: %</summary>
        /// <param name="avgGrade_">Nullable field value to be set</param>
        public void SetAvgGrade(float? avgGrade_)
        {
            SetFieldValue(37, 0, avgGrade_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the AvgPosGrade field
        /// Units: %</summary>
        /// <returns>Returns nullable float representing the AvgPosGrade field</returns>
        public float? GetAvgPosGrade()
        {
            Object val = GetFieldValue(38, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set AvgPosGrade field
        /// Units: %</summary>
        /// <param name="avgPosGrade_">Nullable field value to be set</param>
        public void SetAvgPosGrade(float? avgPosGrade_)
        {
            SetFieldValue(38, 0, avgPosGrade_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the AvgNegGrade field
        /// Units: %</summary>
        /// <returns>Returns nullable float representing the AvgNegGrade field</returns>
        public float? GetAvgNegGrade()
        {
            Object val = GetFieldValue(39, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set AvgNegGrade field
        /// Units: %</summary>
        /// <param name="avgNegGrade_">Nullable field value to be set</param>
        public void SetAvgNegGrade(float? avgNegGrade_)
        {
            SetFieldValue(39, 0, avgNegGrade_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the MaxPosGrade field
        /// Units: %</summary>
        /// <returns>Returns nullable float representing the MaxPosGrade field</returns>
        public float? GetMaxPosGrade()
        {
            Object val = GetFieldValue(40, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set MaxPosGrade field
        /// Units: %</summary>
        /// <param name="maxPosGrade_">Nullable field value to be set</param>
        public void SetMaxPosGrade(float? maxPosGrade_)
        {
            SetFieldValue(40, 0, maxPosGrade_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the MaxNegGrade field
        /// Units: %</summary>
        /// <returns>Returns nullable float representing the MaxNegGrade field</returns>
        public float? GetMaxNegGrade()
        {
            Object val = GetFieldValue(41, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set MaxNegGrade field
        /// Units: %</summary>
        /// <param name="maxNegGrade_">Nullable field value to be set</param>
        public void SetMaxNegGrade(float? maxNegGrade_)
        {
            SetFieldValue(41, 0, maxNegGrade_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the AvgTemperature field
        /// Units: C</summary>
        /// <returns>Returns nullable sbyte representing the AvgTemperature field</returns>
        public sbyte? GetAvgTemperature()
        {
            Object val = GetFieldValue(42, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSByte(val));
            
        }

        /// <summary>
        /// Set AvgTemperature field
        /// Units: C</summary>
        /// <param name="avgTemperature_">Nullable field value to be set</param>
        public void SetAvgTemperature(sbyte? avgTemperature_)
        {
            SetFieldValue(42, 0, avgTemperature_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the MaxTemperature field
        /// Units: C</summary>
        /// <returns>Returns nullable sbyte representing the MaxTemperature field</returns>
        public sbyte? GetMaxTemperature()
        {
            Object val = GetFieldValue(43, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSByte(val));
            
        }

        /// <summary>
        /// Set MaxTemperature field
        /// Units: C</summary>
        /// <param name="maxTemperature_">Nullable field value to be set</param>
        public void SetMaxTemperature(sbyte? maxTemperature_)
        {
            SetFieldValue(43, 0, maxTemperature_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the TotalMovingTime field
        /// Units: s</summary>
        /// <returns>Returns nullable float representing the TotalMovingTime field</returns>
        public float? GetTotalMovingTime()
        {
            Object val = GetFieldValue(44, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set TotalMovingTime field
        /// Units: s</summary>
        /// <param name="totalMovingTime_">Nullable field value to be set</param>
        public void SetTotalMovingTime(float? totalMovingTime_)
        {
            SetFieldValue(44, 0, totalMovingTime_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the AvgPosVerticalSpeed field
        /// Units: m/s</summary>
        /// <returns>Returns nullable float representing the AvgPosVerticalSpeed field</returns>
        public float? GetAvgPosVerticalSpeed()
        {
            Object val = GetFieldValue(45, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set AvgPosVerticalSpeed field
        /// Units: m/s</summary>
        /// <param name="avgPosVerticalSpeed_">Nullable field value to be set</param>
        public void SetAvgPosVerticalSpeed(float? avgPosVerticalSpeed_)
        {
            SetFieldValue(45, 0, avgPosVerticalSpeed_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the AvgNegVerticalSpeed field
        /// Units: m/s</summary>
        /// <returns>Returns nullable float representing the AvgNegVerticalSpeed field</returns>
        public float? GetAvgNegVerticalSpeed()
        {
            Object val = GetFieldValue(46, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set AvgNegVerticalSpeed field
        /// Units: m/s</summary>
        /// <param name="avgNegVerticalSpeed_">Nullable field value to be set</param>
        public void SetAvgNegVerticalSpeed(float? avgNegVerticalSpeed_)
        {
            SetFieldValue(46, 0, avgNegVerticalSpeed_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the MaxPosVerticalSpeed field
        /// Units: m/s</summary>
        /// <returns>Returns nullable float representing the MaxPosVerticalSpeed field</returns>
        public float? GetMaxPosVerticalSpeed()
        {
            Object val = GetFieldValue(47, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set MaxPosVerticalSpeed field
        /// Units: m/s</summary>
        /// <param name="maxPosVerticalSpeed_">Nullable field value to be set</param>
        public void SetMaxPosVerticalSpeed(float? maxPosVerticalSpeed_)
        {
            SetFieldValue(47, 0, maxPosVerticalSpeed_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the MaxNegVerticalSpeed field
        /// Units: m/s</summary>
        /// <returns>Returns nullable float representing the MaxNegVerticalSpeed field</returns>
        public float? GetMaxNegVerticalSpeed()
        {
            Object val = GetFieldValue(48, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set MaxNegVerticalSpeed field
        /// Units: m/s</summary>
        /// <param name="maxNegVerticalSpeed_">Nullable field value to be set</param>
        public void SetMaxNegVerticalSpeed(float? maxNegVerticalSpeed_)
        {
            SetFieldValue(48, 0, maxNegVerticalSpeed_, Fit.SubfieldIndexMainField);
        }
        
        
        /// <summary>
        ///
        /// </summary>
        /// <returns>returns number of elements in field TimeInHrZone</returns>
        public int GetNumTimeInHrZone()
        {
            return GetNumFieldValues(49, Fit.SubfieldIndexMainField);
        }

        ///<summary>
        /// Retrieves the TimeInHrZone field
        /// Units: s</summary>
        /// <param name="index">0 based index of TimeInHrZone element to retrieve</param>
        /// <returns>Returns nullable float representing the TimeInHrZone field</returns>
        public float? GetTimeInHrZone(int index)
        {
            Object val = GetFieldValue(49, index, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set TimeInHrZone field
        /// Units: s</summary>
        /// <param name="index">0 based index of time_in_hr_zone</param>
        /// <param name="timeInHrZone_">Nullable field value to be set</param>
        public void SetTimeInHrZone(int index, float? timeInHrZone_)
        {
            SetFieldValue(49, index, timeInHrZone_, Fit.SubfieldIndexMainField);
        }
        
        
        /// <summary>
        ///
        /// </summary>
        /// <returns>returns number of elements in field TimeInSpeedZone</returns>
        public int GetNumTimeInSpeedZone()
        {
            return GetNumFieldValues(50, Fit.SubfieldIndexMainField);
        }

        ///<summary>
        /// Retrieves the TimeInSpeedZone field
        /// Units: s</summary>
        /// <param name="index">0 based index of TimeInSpeedZone element to retrieve</param>
        /// <returns>Returns nullable float representing the TimeInSpeedZone field</returns>
        public float? GetTimeInSpeedZone(int index)
        {
            Object val = GetFieldValue(50, index, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set TimeInSpeedZone field
        /// Units: s</summary>
        /// <param name="index">0 based index of time_in_speed_zone</param>
        /// <param name="timeInSpeedZone_">Nullable field value to be set</param>
        public void SetTimeInSpeedZone(int index, float? timeInSpeedZone_)
        {
            SetFieldValue(50, index, timeInSpeedZone_, Fit.SubfieldIndexMainField);
        }
        
        
        /// <summary>
        ///
        /// </summary>
        /// <returns>returns number of elements in field TimeInCadenceZone</returns>
        public int GetNumTimeInCadenceZone()
        {
            return GetNumFieldValues(51, Fit.SubfieldIndexMainField);
        }

        ///<summary>
        /// Retrieves the TimeInCadenceZone field
        /// Units: s</summary>
        /// <param name="index">0 based index of TimeInCadenceZone element to retrieve</param>
        /// <returns>Returns nullable float representing the TimeInCadenceZone field</returns>
        public float? GetTimeInCadenceZone(int index)
        {
            Object val = GetFieldValue(51, index, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set TimeInCadenceZone field
        /// Units: s</summary>
        /// <param name="index">0 based index of time_in_cadence_zone</param>
        /// <param name="timeInCadenceZone_">Nullable field value to be set</param>
        public void SetTimeInCadenceZone(int index, float? timeInCadenceZone_)
        {
            SetFieldValue(51, index, timeInCadenceZone_, Fit.SubfieldIndexMainField);
        }
        
        
        /// <summary>
        ///
        /// </summary>
        /// <returns>returns number of elements in field TimeInPowerZone</returns>
        public int GetNumTimeInPowerZone()
        {
            return GetNumFieldValues(52, Fit.SubfieldIndexMainField);
        }

        ///<summary>
        /// Retrieves the TimeInPowerZone field
        /// Units: s</summary>
        /// <param name="index">0 based index of TimeInPowerZone element to retrieve</param>
        /// <returns>Returns nullable float representing the TimeInPowerZone field</returns>
        public float? GetTimeInPowerZone(int index)
        {
            Object val = GetFieldValue(52, index, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set TimeInPowerZone field
        /// Units: s</summary>
        /// <param name="index">0 based index of time_in_power_zone</param>
        /// <param name="timeInPowerZone_">Nullable field value to be set</param>
        public void SetTimeInPowerZone(int index, float? timeInPowerZone_)
        {
            SetFieldValue(52, index, timeInPowerZone_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the RepetitionNum field</summary>
        /// <returns>Returns nullable ushort representing the RepetitionNum field</returns>
        public ushort? GetRepetitionNum()
        {
            Object val = GetFieldValue(53, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToUInt16(val));
            
        }

        /// <summary>
        /// Set RepetitionNum field</summary>
        /// <param name="repetitionNum_">Nullable field value to be set</param>
        public void SetRepetitionNum(ushort? repetitionNum_)
        {
            SetFieldValue(53, 0, repetitionNum_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the MinAltitude field
        /// Units: m</summary>
        /// <returns>Returns nullable float representing the MinAltitude field</returns>
        public float? GetMinAltitude()
        {
            Object val = GetFieldValue(54, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set MinAltitude field
        /// Units: m</summary>
        /// <param name="minAltitude_">Nullable field value to be set</param>
        public void SetMinAltitude(float? minAltitude_)
        {
            SetFieldValue(54, 0, minAltitude_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the MinHeartRate field
        /// Units: bpm</summary>
        /// <returns>Returns nullable byte representing the MinHeartRate field</returns>
        public byte? GetMinHeartRate()
        {
            Object val = GetFieldValue(55, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToByte(val));
            
        }

        /// <summary>
        /// Set MinHeartRate field
        /// Units: bpm</summary>
        /// <param name="minHeartRate_">Nullable field value to be set</param>
        public void SetMinHeartRate(byte? minHeartRate_)
        {
            SetFieldValue(55, 0, minHeartRate_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the ActiveTime field
        /// Units: s</summary>
        /// <returns>Returns nullable float representing the ActiveTime field</returns>
        public float? GetActiveTime()
        {
            Object val = GetFieldValue(56, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set ActiveTime field
        /// Units: s</summary>
        /// <param name="activeTime_">Nullable field value to be set</param>
        public void SetActiveTime(float? activeTime_)
        {
            SetFieldValue(56, 0, activeTime_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the WktStepIndex field</summary>
        /// <returns>Returns nullable ushort representing the WktStepIndex field</returns>
        public ushort? GetWktStepIndex()
        {
            Object val = GetFieldValue(57, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToUInt16(val));
            
        }

        /// <summary>
        /// Set WktStepIndex field</summary>
        /// <param name="wktStepIndex_">Nullable field value to be set</param>
        public void SetWktStepIndex(ushort? wktStepIndex_)
        {
            SetFieldValue(57, 0, wktStepIndex_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the SportEvent field</summary>
        /// <returns>Returns nullable SportEvent enum representing the SportEvent field</returns>
        public SportEvent? GetSportEvent()
        {
            object obj = GetFieldValue(58, 0, Fit.SubfieldIndexMainField);
            SportEvent? value = obj == null ? (SportEvent?)null : (SportEvent)obj;
            return value;
        }

        /// <summary>
        /// Set SportEvent field</summary>
        /// <param name="sportEvent_">Nullable field value to be set</param>
        public void SetSportEvent(SportEvent? sportEvent_)
        {
            SetFieldValue(58, 0, sportEvent_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the AvgLeftTorqueEffectiveness field
        /// Units: percent</summary>
        /// <returns>Returns nullable float representing the AvgLeftTorqueEffectiveness field</returns>
        public float? GetAvgLeftTorqueEffectiveness()
        {
            Object val = GetFieldValue(59, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set AvgLeftTorqueEffectiveness field
        /// Units: percent</summary>
        /// <param name="avgLeftTorqueEffectiveness_">Nullable field value to be set</param>
        public void SetAvgLeftTorqueEffectiveness(float? avgLeftTorqueEffectiveness_)
        {
            SetFieldValue(59, 0, avgLeftTorqueEffectiveness_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the AvgRightTorqueEffectiveness field
        /// Units: percent</summary>
        /// <returns>Returns nullable float representing the AvgRightTorqueEffectiveness field</returns>
        public float? GetAvgRightTorqueEffectiveness()
        {
            Object val = GetFieldValue(60, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set AvgRightTorqueEffectiveness field
        /// Units: percent</summary>
        /// <param name="avgRightTorqueEffectiveness_">Nullable field value to be set</param>
        public void SetAvgRightTorqueEffectiveness(float? avgRightTorqueEffectiveness_)
        {
            SetFieldValue(60, 0, avgRightTorqueEffectiveness_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the AvgLeftPedalSmoothness field
        /// Units: percent</summary>
        /// <returns>Returns nullable float representing the AvgLeftPedalSmoothness field</returns>
        public float? GetAvgLeftPedalSmoothness()
        {
            Object val = GetFieldValue(61, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set AvgLeftPedalSmoothness field
        /// Units: percent</summary>
        /// <param name="avgLeftPedalSmoothness_">Nullable field value to be set</param>
        public void SetAvgLeftPedalSmoothness(float? avgLeftPedalSmoothness_)
        {
            SetFieldValue(61, 0, avgLeftPedalSmoothness_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the AvgRightPedalSmoothness field
        /// Units: percent</summary>
        /// <returns>Returns nullable float representing the AvgRightPedalSmoothness field</returns>
        public float? GetAvgRightPedalSmoothness()
        {
            Object val = GetFieldValue(62, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set AvgRightPedalSmoothness field
        /// Units: percent</summary>
        /// <param name="avgRightPedalSmoothness_">Nullable field value to be set</param>
        public void SetAvgRightPedalSmoothness(float? avgRightPedalSmoothness_)
        {
            SetFieldValue(62, 0, avgRightPedalSmoothness_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the AvgCombinedPedalSmoothness field
        /// Units: percent</summary>
        /// <returns>Returns nullable float representing the AvgCombinedPedalSmoothness field</returns>
        public float? GetAvgCombinedPedalSmoothness()
        {
            Object val = GetFieldValue(63, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set AvgCombinedPedalSmoothness field
        /// Units: percent</summary>
        /// <param name="avgCombinedPedalSmoothness_">Nullable field value to be set</param>
        public void SetAvgCombinedPedalSmoothness(float? avgCombinedPedalSmoothness_)
        {
            SetFieldValue(63, 0, avgCombinedPedalSmoothness_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the Status field</summary>
        /// <returns>Returns nullable SegmentLapStatus enum representing the Status field</returns>
        public SegmentLapStatus? GetStatus()
        {
            object obj = GetFieldValue(64, 0, Fit.SubfieldIndexMainField);
            SegmentLapStatus? value = obj == null ? (SegmentLapStatus?)null : (SegmentLapStatus)obj;
            return value;
        }

        /// <summary>
        /// Set Status field</summary>
        /// <param name="status_">Nullable field value to be set</param>
        public void SetStatus(SegmentLapStatus? status_)
        {
            SetFieldValue(64, 0, status_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the Uuid field</summary>
        /// <returns>Returns byte[] representing the Uuid field</returns>
        public byte[] GetUuid()
        {
            byte[] data = (byte[])GetFieldValue(65, 0, Fit.SubfieldIndexMainField);
            return data.Take(data.Length - 1).ToArray();
        }

        ///<summary>
        /// Retrieves the Uuid field</summary>
        /// <returns>Returns String representing the Uuid field</returns>
        public String GetUuidAsString()
        {
            byte[] data = (byte[])GetFieldValue(65, 0, Fit.SubfieldIndexMainField);
            return data != null ? Encoding.UTF8.GetString(data, 0, data.Length - 1) : null;
        }

        ///<summary>
        /// Set Uuid field</summary>
        /// <param name="uuid_"> field value to be set</param>
        public void SetUuid(String uuid_)
        {
            byte[] data = Encoding.UTF8.GetBytes(uuid_);
            byte[] zdata = new byte[data.Length + 1];
            data.CopyTo(zdata, 0);
            SetFieldValue(65, 0, zdata, Fit.SubfieldIndexMainField);
        }

        
        /// <summary>
        /// Set Uuid field</summary>
        /// <param name="uuid_">field value to be set</param>
        public void SetUuid(byte[] uuid_)
        {
            SetFieldValue(65, 0, uuid_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the AvgFractionalCadence field
        /// Units: rpm
        /// Comment: fractional part of the avg_cadence</summary>
        /// <returns>Returns nullable float representing the AvgFractionalCadence field</returns>
        public float? GetAvgFractionalCadence()
        {
            Object val = GetFieldValue(66, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set AvgFractionalCadence field
        /// Units: rpm
        /// Comment: fractional part of the avg_cadence</summary>
        /// <param name="avgFractionalCadence_">Nullable field value to be set</param>
        public void SetAvgFractionalCadence(float? avgFractionalCadence_)
        {
            SetFieldValue(66, 0, avgFractionalCadence_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the MaxFractionalCadence field
        /// Units: rpm
        /// Comment: fractional part of the max_cadence</summary>
        /// <returns>Returns nullable float representing the MaxFractionalCadence field</returns>
        public float? GetMaxFractionalCadence()
        {
            Object val = GetFieldValue(67, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set MaxFractionalCadence field
        /// Units: rpm
        /// Comment: fractional part of the max_cadence</summary>
        /// <param name="maxFractionalCadence_">Nullable field value to be set</param>
        public void SetMaxFractionalCadence(float? maxFractionalCadence_)
        {
            SetFieldValue(67, 0, maxFractionalCadence_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the TotalFractionalCycles field
        /// Units: cycles
        /// Comment: fractional part of the total_cycles</summary>
        /// <returns>Returns nullable float representing the TotalFractionalCycles field</returns>
        public float? GetTotalFractionalCycles()
        {
            Object val = GetFieldValue(68, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set TotalFractionalCycles field
        /// Units: cycles
        /// Comment: fractional part of the total_cycles</summary>
        /// <param name="totalFractionalCycles_">Nullable field value to be set</param>
        public void SetTotalFractionalCycles(float? totalFractionalCycles_)
        {
            SetFieldValue(68, 0, totalFractionalCycles_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the FrontGearShiftCount field</summary>
        /// <returns>Returns nullable ushort representing the FrontGearShiftCount field</returns>
        public ushort? GetFrontGearShiftCount()
        {
            Object val = GetFieldValue(69, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToUInt16(val));
            
        }

        /// <summary>
        /// Set FrontGearShiftCount field</summary>
        /// <param name="frontGearShiftCount_">Nullable field value to be set</param>
        public void SetFrontGearShiftCount(ushort? frontGearShiftCount_)
        {
            SetFieldValue(69, 0, frontGearShiftCount_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the RearGearShiftCount field</summary>
        /// <returns>Returns nullable ushort representing the RearGearShiftCount field</returns>
        public ushort? GetRearGearShiftCount()
        {
            Object val = GetFieldValue(70, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToUInt16(val));
            
        }

        /// <summary>
        /// Set RearGearShiftCount field</summary>
        /// <param name="rearGearShiftCount_">Nullable field value to be set</param>
        public void SetRearGearShiftCount(ushort? rearGearShiftCount_)
        {
            SetFieldValue(70, 0, rearGearShiftCount_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the TimeStanding field
        /// Units: s
        /// Comment: Total time spent in the standing position</summary>
        /// <returns>Returns nullable float representing the TimeStanding field</returns>
        public float? GetTimeStanding()
        {
            Object val = GetFieldValue(71, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set TimeStanding field
        /// Units: s
        /// Comment: Total time spent in the standing position</summary>
        /// <param name="timeStanding_">Nullable field value to be set</param>
        public void SetTimeStanding(float? timeStanding_)
        {
            SetFieldValue(71, 0, timeStanding_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the StandCount field
        /// Comment: Number of transitions to the standing state</summary>
        /// <returns>Returns nullable ushort representing the StandCount field</returns>
        public ushort? GetStandCount()
        {
            Object val = GetFieldValue(72, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToUInt16(val));
            
        }

        /// <summary>
        /// Set StandCount field
        /// Comment: Number of transitions to the standing state</summary>
        /// <param name="standCount_">Nullable field value to be set</param>
        public void SetStandCount(ushort? standCount_)
        {
            SetFieldValue(72, 0, standCount_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the AvgLeftPco field
        /// Units: mm
        /// Comment: Average left platform center offset</summary>
        /// <returns>Returns nullable sbyte representing the AvgLeftPco field</returns>
        public sbyte? GetAvgLeftPco()
        {
            Object val = GetFieldValue(73, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSByte(val));
            
        }

        /// <summary>
        /// Set AvgLeftPco field
        /// Units: mm
        /// Comment: Average left platform center offset</summary>
        /// <param name="avgLeftPco_">Nullable field value to be set</param>
        public void SetAvgLeftPco(sbyte? avgLeftPco_)
        {
            SetFieldValue(73, 0, avgLeftPco_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the AvgRightPco field
        /// Units: mm
        /// Comment: Average right platform center offset</summary>
        /// <returns>Returns nullable sbyte representing the AvgRightPco field</returns>
        public sbyte? GetAvgRightPco()
        {
            Object val = GetFieldValue(74, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSByte(val));
            
        }

        /// <summary>
        /// Set AvgRightPco field
        /// Units: mm
        /// Comment: Average right platform center offset</summary>
        /// <param name="avgRightPco_">Nullable field value to be set</param>
        public void SetAvgRightPco(sbyte? avgRightPco_)
        {
            SetFieldValue(74, 0, avgRightPco_, Fit.SubfieldIndexMainField);
        }
        
        
        /// <summary>
        ///
        /// </summary>
        /// <returns>returns number of elements in field AvgLeftPowerPhase</returns>
        public int GetNumAvgLeftPowerPhase()
        {
            return GetNumFieldValues(75, Fit.SubfieldIndexMainField);
        }

        ///<summary>
        /// Retrieves the AvgLeftPowerPhase field
        /// Units: degrees
        /// Comment: Average left power phase angles. Data value indexes defined by power_phase_type.</summary>
        /// <param name="index">0 based index of AvgLeftPowerPhase element to retrieve</param>
        /// <returns>Returns nullable float representing the AvgLeftPowerPhase field</returns>
        public float? GetAvgLeftPowerPhase(int index)
        {
            Object val = GetFieldValue(75, index, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set AvgLeftPowerPhase field
        /// Units: degrees
        /// Comment: Average left power phase angles. Data value indexes defined by power_phase_type.</summary>
        /// <param name="index">0 based index of avg_left_power_phase</param>
        /// <param name="avgLeftPowerPhase_">Nullable field value to be set</param>
        public void SetAvgLeftPowerPhase(int index, float? avgLeftPowerPhase_)
        {
            SetFieldValue(75, index, avgLeftPowerPhase_, Fit.SubfieldIndexMainField);
        }
        
        
        /// <summary>
        ///
        /// </summary>
        /// <returns>returns number of elements in field AvgLeftPowerPhasePeak</returns>
        public int GetNumAvgLeftPowerPhasePeak()
        {
            return GetNumFieldValues(76, Fit.SubfieldIndexMainField);
        }

        ///<summary>
        /// Retrieves the AvgLeftPowerPhasePeak field
        /// Units: degrees
        /// Comment: Average left power phase peak angles. Data value indexes defined by power_phase_type.</summary>
        /// <param name="index">0 based index of AvgLeftPowerPhasePeak element to retrieve</param>
        /// <returns>Returns nullable float representing the AvgLeftPowerPhasePeak field</returns>
        public float? GetAvgLeftPowerPhasePeak(int index)
        {
            Object val = GetFieldValue(76, index, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set AvgLeftPowerPhasePeak field
        /// Units: degrees
        /// Comment: Average left power phase peak angles. Data value indexes defined by power_phase_type.</summary>
        /// <param name="index">0 based index of avg_left_power_phase_peak</param>
        /// <param name="avgLeftPowerPhasePeak_">Nullable field value to be set</param>
        public void SetAvgLeftPowerPhasePeak(int index, float? avgLeftPowerPhasePeak_)
        {
            SetFieldValue(76, index, avgLeftPowerPhasePeak_, Fit.SubfieldIndexMainField);
        }
        
        
        /// <summary>
        ///
        /// </summary>
        /// <returns>returns number of elements in field AvgRightPowerPhase</returns>
        public int GetNumAvgRightPowerPhase()
        {
            return GetNumFieldValues(77, Fit.SubfieldIndexMainField);
        }

        ///<summary>
        /// Retrieves the AvgRightPowerPhase field
        /// Units: degrees
        /// Comment: Average right power phase angles. Data value indexes defined by power_phase_type.</summary>
        /// <param name="index">0 based index of AvgRightPowerPhase element to retrieve</param>
        /// <returns>Returns nullable float representing the AvgRightPowerPhase field</returns>
        public float? GetAvgRightPowerPhase(int index)
        {
            Object val = GetFieldValue(77, index, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set AvgRightPowerPhase field
        /// Units: degrees
        /// Comment: Average right power phase angles. Data value indexes defined by power_phase_type.</summary>
        /// <param name="index">0 based index of avg_right_power_phase</param>
        /// <param name="avgRightPowerPhase_">Nullable field value to be set</param>
        public void SetAvgRightPowerPhase(int index, float? avgRightPowerPhase_)
        {
            SetFieldValue(77, index, avgRightPowerPhase_, Fit.SubfieldIndexMainField);
        }
        
        
        /// <summary>
        ///
        /// </summary>
        /// <returns>returns number of elements in field AvgRightPowerPhasePeak</returns>
        public int GetNumAvgRightPowerPhasePeak()
        {
            return GetNumFieldValues(78, Fit.SubfieldIndexMainField);
        }

        ///<summary>
        /// Retrieves the AvgRightPowerPhasePeak field
        /// Units: degrees
        /// Comment: Average right power phase peak angles. Data value indexes defined by power_phase_type.</summary>
        /// <param name="index">0 based index of AvgRightPowerPhasePeak element to retrieve</param>
        /// <returns>Returns nullable float representing the AvgRightPowerPhasePeak field</returns>
        public float? GetAvgRightPowerPhasePeak(int index)
        {
            Object val = GetFieldValue(78, index, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set AvgRightPowerPhasePeak field
        /// Units: degrees
        /// Comment: Average right power phase peak angles. Data value indexes defined by power_phase_type.</summary>
        /// <param name="index">0 based index of avg_right_power_phase_peak</param>
        /// <param name="avgRightPowerPhasePeak_">Nullable field value to be set</param>
        public void SetAvgRightPowerPhasePeak(int index, float? avgRightPowerPhasePeak_)
        {
            SetFieldValue(78, index, avgRightPowerPhasePeak_, Fit.SubfieldIndexMainField);
        }
        
        
        /// <summary>
        ///
        /// </summary>
        /// <returns>returns number of elements in field AvgPowerPosition</returns>
        public int GetNumAvgPowerPosition()
        {
            return GetNumFieldValues(79, Fit.SubfieldIndexMainField);
        }

        ///<summary>
        /// Retrieves the AvgPowerPosition field
        /// Units: watts
        /// Comment: Average power by position. Data value indexes defined by rider_position_type.</summary>
        /// <param name="index">0 based index of AvgPowerPosition element to retrieve</param>
        /// <returns>Returns nullable ushort representing the AvgPowerPosition field</returns>
        public ushort? GetAvgPowerPosition(int index)
        {
            Object val = GetFieldValue(79, index, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToUInt16(val));
            
        }

        /// <summary>
        /// Set AvgPowerPosition field
        /// Units: watts
        /// Comment: Average power by position. Data value indexes defined by rider_position_type.</summary>
        /// <param name="index">0 based index of avg_power_position</param>
        /// <param name="avgPowerPosition_">Nullable field value to be set</param>
        public void SetAvgPowerPosition(int index, ushort? avgPowerPosition_)
        {
            SetFieldValue(79, index, avgPowerPosition_, Fit.SubfieldIndexMainField);
        }
        
        
        /// <summary>
        ///
        /// </summary>
        /// <returns>returns number of elements in field MaxPowerPosition</returns>
        public int GetNumMaxPowerPosition()
        {
            return GetNumFieldValues(80, Fit.SubfieldIndexMainField);
        }

        ///<summary>
        /// Retrieves the MaxPowerPosition field
        /// Units: watts
        /// Comment: Maximum power by position. Data value indexes defined by rider_position_type.</summary>
        /// <param name="index">0 based index of MaxPowerPosition element to retrieve</param>
        /// <returns>Returns nullable ushort representing the MaxPowerPosition field</returns>
        public ushort? GetMaxPowerPosition(int index)
        {
            Object val = GetFieldValue(80, index, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToUInt16(val));
            
        }

        /// <summary>
        /// Set MaxPowerPosition field
        /// Units: watts
        /// Comment: Maximum power by position. Data value indexes defined by rider_position_type.</summary>
        /// <param name="index">0 based index of max_power_position</param>
        /// <param name="maxPowerPosition_">Nullable field value to be set</param>
        public void SetMaxPowerPosition(int index, ushort? maxPowerPosition_)
        {
            SetFieldValue(80, index, maxPowerPosition_, Fit.SubfieldIndexMainField);
        }
        
        
        /// <summary>
        ///
        /// </summary>
        /// <returns>returns number of elements in field AvgCadencePosition</returns>
        public int GetNumAvgCadencePosition()
        {
            return GetNumFieldValues(81, Fit.SubfieldIndexMainField);
        }

        ///<summary>
        /// Retrieves the AvgCadencePosition field
        /// Units: rpm
        /// Comment: Average cadence by position. Data value indexes defined by rider_position_type.</summary>
        /// <param name="index">0 based index of AvgCadencePosition element to retrieve</param>
        /// <returns>Returns nullable byte representing the AvgCadencePosition field</returns>
        public byte? GetAvgCadencePosition(int index)
        {
            Object val = GetFieldValue(81, index, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToByte(val));
            
        }

        /// <summary>
        /// Set AvgCadencePosition field
        /// Units: rpm
        /// Comment: Average cadence by position. Data value indexes defined by rider_position_type.</summary>
        /// <param name="index">0 based index of avg_cadence_position</param>
        /// <param name="avgCadencePosition_">Nullable field value to be set</param>
        public void SetAvgCadencePosition(int index, byte? avgCadencePosition_)
        {
            SetFieldValue(81, index, avgCadencePosition_, Fit.SubfieldIndexMainField);
        }
        
        
        /// <summary>
        ///
        /// </summary>
        /// <returns>returns number of elements in field MaxCadencePosition</returns>
        public int GetNumMaxCadencePosition()
        {
            return GetNumFieldValues(82, Fit.SubfieldIndexMainField);
        }

        ///<summary>
        /// Retrieves the MaxCadencePosition field
        /// Units: rpm
        /// Comment: Maximum cadence by position. Data value indexes defined by rider_position_type.</summary>
        /// <param name="index">0 based index of MaxCadencePosition element to retrieve</param>
        /// <returns>Returns nullable byte representing the MaxCadencePosition field</returns>
        public byte? GetMaxCadencePosition(int index)
        {
            Object val = GetFieldValue(82, index, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToByte(val));
            
        }

        /// <summary>
        /// Set MaxCadencePosition field
        /// Units: rpm
        /// Comment: Maximum cadence by position. Data value indexes defined by rider_position_type.</summary>
        /// <param name="index">0 based index of max_cadence_position</param>
        /// <param name="maxCadencePosition_">Nullable field value to be set</param>
        public void SetMaxCadencePosition(int index, byte? maxCadencePosition_)
        {
            SetFieldValue(82, index, maxCadencePosition_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the Manufacturer field
        /// Comment: Manufacturer that produced the segment</summary>
        /// <returns>Returns nullable ushort representing the Manufacturer field</returns>
        public ushort? GetManufacturer()
        {
            Object val = GetFieldValue(83, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToUInt16(val));
            
        }

        /// <summary>
        /// Set Manufacturer field
        /// Comment: Manufacturer that produced the segment</summary>
        /// <param name="manufacturer_">Nullable field value to be set</param>
        public void SetManufacturer(ushort? manufacturer_)
        {
            SetFieldValue(83, 0, manufacturer_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the TotalGrit field
        /// Units: kGrit
        /// Comment: The grit score estimates how challenging a route could be for a cyclist in terms of time spent going over sharp turns or large grade slopes.</summary>
        /// <returns>Returns nullable float representing the TotalGrit field</returns>
        public float? GetTotalGrit()
        {
            Object val = GetFieldValue(84, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set TotalGrit field
        /// Units: kGrit
        /// Comment: The grit score estimates how challenging a route could be for a cyclist in terms of time spent going over sharp turns or large grade slopes.</summary>
        /// <param name="totalGrit_">Nullable field value to be set</param>
        public void SetTotalGrit(float? totalGrit_)
        {
            SetFieldValue(84, 0, totalGrit_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the TotalFlow field
        /// Units: Flow
        /// Comment: The flow score estimates how long distance wise a cyclist deaccelerates over intervals where deacceleration is unnecessary such as smooth turns or small grade angle intervals.</summary>
        /// <returns>Returns nullable float representing the TotalFlow field</returns>
        public float? GetTotalFlow()
        {
            Object val = GetFieldValue(85, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set TotalFlow field
        /// Units: Flow
        /// Comment: The flow score estimates how long distance wise a cyclist deaccelerates over intervals where deacceleration is unnecessary such as smooth turns or small grade angle intervals.</summary>
        /// <param name="totalFlow_">Nullable field value to be set</param>
        public void SetTotalFlow(float? totalFlow_)
        {
            SetFieldValue(85, 0, totalFlow_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the AvgGrit field
        /// Units: kGrit
        /// Comment: The grit score estimates how challenging a route could be for a cyclist in terms of time spent going over sharp turns or large grade slopes.</summary>
        /// <returns>Returns nullable float representing the AvgGrit field</returns>
        public float? GetAvgGrit()
        {
            Object val = GetFieldValue(86, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set AvgGrit field
        /// Units: kGrit
        /// Comment: The grit score estimates how challenging a route could be for a cyclist in terms of time spent going over sharp turns or large grade slopes.</summary>
        /// <param name="avgGrit_">Nullable field value to be set</param>
        public void SetAvgGrit(float? avgGrit_)
        {
            SetFieldValue(86, 0, avgGrit_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the AvgFlow field
        /// Units: Flow
        /// Comment: The flow score estimates how long distance wise a cyclist deaccelerates over intervals where deacceleration is unnecessary such as smooth turns or small grade angle intervals.</summary>
        /// <returns>Returns nullable float representing the AvgFlow field</returns>
        public float? GetAvgFlow()
        {
            Object val = GetFieldValue(87, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set AvgFlow field
        /// Units: Flow
        /// Comment: The flow score estimates how long distance wise a cyclist deaccelerates over intervals where deacceleration is unnecessary such as smooth turns or small grade angle intervals.</summary>
        /// <param name="avgFlow_">Nullable field value to be set</param>
        public void SetAvgFlow(float? avgFlow_)
        {
            SetFieldValue(87, 0, avgFlow_, Fit.SubfieldIndexMainField);
        }
        
        #endregion // Methods
    } // Class
} // namespace
