#region Copyright
////////////////////////////////////////////////////////////////////////////////
// The following FIT Protocol software provided may be used with FIT protocol
// devices only and remains the copyrighted property of Garmin Canada Inc.
// The software is being provided on an "as-is" basis and as an accommodation,
// and therefore all warranties, representations, or guarantees of any kind
// (whether express, implied or statutory) including, without limitation,
// warranties of merchantability, non-infringement, or fitness for a particular
// purpose, are specifically disclaimed.
//
// Copyright 2020 Garmin Canada Inc.
////////////////////////////////////////////////////////////////////////////////
// ****WARNING****  This file is auto-generated!  Do NOT edit this file.
// Profile Version = 21.38Release
// Tag = production/akw/21.38.00-0-g0d69e49
////////////////////////////////////////////////////////////////////////////////

#endregion

using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Text;
using System.IO;
using System.Linq;

namespace Dynastream.Fit
{
    /// <summary>
    /// Implements the Record profile message.
    /// </summary>
    public class RecordMesg : Mesg
    {
        #region Fields
        #endregion

        /// <summary>
        /// Field Numbers for <see cref="RecordMesg"/>
        /// </summary>
        public sealed class FieldDefNum
        {
            public const byte Timestamp = 253;
            public const byte PositionLat = 0;
            public const byte PositionLong = 1;
            public const byte Altitude = 2;
            public const byte HeartRate = 3;
            public const byte Cadence = 4;
            public const byte Distance = 5;
            public const byte Speed = 6;
            public const byte Power = 7;
            public const byte CompressedSpeedDistance = 8;
            public const byte Grade = 9;
            public const byte Resistance = 10;
            public const byte TimeFromCourse = 11;
            public const byte CycleLength = 12;
            public const byte Temperature = 13;
            public const byte Speed1s = 17;
            public const byte Cycles = 18;
            public const byte TotalCycles = 19;
            public const byte CompressedAccumulatedPower = 28;
            public const byte AccumulatedPower = 29;
            public const byte LeftRightBalance = 30;
            public const byte GpsAccuracy = 31;
            public const byte VerticalSpeed = 32;
            public const byte Calories = 33;
            public const byte VerticalOscillation = 39;
            public const byte StanceTimePercent = 40;
            public const byte StanceTime = 41;
            public const byte ActivityType = 42;
            public const byte LeftTorqueEffectiveness = 43;
            public const byte RightTorqueEffectiveness = 44;
            public const byte LeftPedalSmoothness = 45;
            public const byte RightPedalSmoothness = 46;
            public const byte CombinedPedalSmoothness = 47;
            public const byte Time128 = 48;
            public const byte StrokeType = 49;
            public const byte Zone = 50;
            public const byte BallSpeed = 51;
            public const byte Cadence256 = 52;
            public const byte FractionalCadence = 53;
            public const byte TotalHemoglobinConc = 54;
            public const byte TotalHemoglobinConcMin = 55;
            public const byte TotalHemoglobinConcMax = 56;
            public const byte SaturatedHemoglobinPercent = 57;
            public const byte SaturatedHemoglobinPercentMin = 58;
            public const byte SaturatedHemoglobinPercentMax = 59;
            public const byte DeviceIndex = 62;
            public const byte LeftPco = 67;
            public const byte RightPco = 68;
            public const byte LeftPowerPhase = 69;
            public const byte LeftPowerPhasePeak = 70;
            public const byte RightPowerPhase = 71;
            public const byte RightPowerPhasePeak = 72;
            public const byte EnhancedSpeed = 73;
            public const byte EnhancedAltitude = 78;
            public const byte BatterySoc = 81;
            public const byte MotorPower = 82;
            public const byte VerticalRatio = 83;
            public const byte StanceTimeBalance = 84;
            public const byte StepLength = 85;
            public const byte AbsolutePressure = 91;
            public const byte Depth = 92;
            public const byte NextStopDepth = 93;
            public const byte NextStopTime = 94;
            public const byte TimeToSurface = 95;
            public const byte NdlTime = 96;
            public const byte CnsLoad = 97;
            public const byte N2Load = 98;
            public const byte Grit = 114;
            public const byte Flow = 115;
            public const byte EbikeTravelRange = 117;
            public const byte EbikeBatteryLevel = 118;
            public const byte EbikeAssistMode = 119;
            public const byte EbikeAssistLevelPercent = 120;
            public const byte Invalid = Fit.FieldNumInvalid;
        }

        #region Constructors
        public RecordMesg() : base(Profile.GetMesg(MesgNum.Record))
        {
        }

        public RecordMesg(Mesg mesg) : base(mesg)
        {
        }
        #endregion // Constructors

        #region Methods
        ///<summary>
        /// Retrieves the Timestamp field
        /// Units: s</summary>
        /// <returns>Returns DateTime representing the Timestamp field</returns>
        public DateTime GetTimestamp()
        {
            Object val = GetFieldValue(253, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return TimestampToDateTime(Convert.ToUInt32(val));
            
        }

        /// <summary>
        /// Set Timestamp field
        /// Units: s</summary>
        /// <param name="timestamp_">Nullable field value to be set</param>
        public void SetTimestamp(DateTime timestamp_)
        {
            SetFieldValue(253, 0, timestamp_.GetTimeStamp(), Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the PositionLat field
        /// Units: semicircles</summary>
        /// <returns>Returns nullable int representing the PositionLat field</returns>
        public int? GetPositionLat()
        {
            Object val = GetFieldValue(0, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToInt32(val));
            
        }

        /// <summary>
        /// Set PositionLat field
        /// Units: semicircles</summary>
        /// <param name="positionLat_">Nullable field value to be set</param>
        public void SetPositionLat(int? positionLat_)
        {
            SetFieldValue(0, 0, positionLat_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the PositionLong field
        /// Units: semicircles</summary>
        /// <returns>Returns nullable int representing the PositionLong field</returns>
        public int? GetPositionLong()
        {
            Object val = GetFieldValue(1, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToInt32(val));
            
        }

        /// <summary>
        /// Set PositionLong field
        /// Units: semicircles</summary>
        /// <param name="positionLong_">Nullable field value to be set</param>
        public void SetPositionLong(int? positionLong_)
        {
            SetFieldValue(1, 0, positionLong_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the Altitude field
        /// Units: m</summary>
        /// <returns>Returns nullable float representing the Altitude field</returns>
        public float? GetAltitude()
        {
            Object val = GetFieldValue(2, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set Altitude field
        /// Units: m</summary>
        /// <param name="altitude_">Nullable field value to be set</param>
        public void SetAltitude(float? altitude_)
        {
            SetFieldValue(2, 0, altitude_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the HeartRate field
        /// Units: bpm</summary>
        /// <returns>Returns nullable byte representing the HeartRate field</returns>
        public byte? GetHeartRate()
        {
            Object val = GetFieldValue(3, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToByte(val));
            
        }

        /// <summary>
        /// Set HeartRate field
        /// Units: bpm</summary>
        /// <param name="heartRate_">Nullable field value to be set</param>
        public void SetHeartRate(byte? heartRate_)
        {
            SetFieldValue(3, 0, heartRate_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the Cadence field
        /// Units: rpm</summary>
        /// <returns>Returns nullable byte representing the Cadence field</returns>
        public byte? GetCadence()
        {
            Object val = GetFieldValue(4, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToByte(val));
            
        }

        /// <summary>
        /// Set Cadence field
        /// Units: rpm</summary>
        /// <param name="cadence_">Nullable field value to be set</param>
        public void SetCadence(byte? cadence_)
        {
            SetFieldValue(4, 0, cadence_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the Distance field
        /// Units: m</summary>
        /// <returns>Returns nullable float representing the Distance field</returns>
        public float? GetDistance()
        {
            Object val = GetFieldValue(5, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set Distance field
        /// Units: m</summary>
        /// <param name="distance_">Nullable field value to be set</param>
        public void SetDistance(float? distance_)
        {
            SetFieldValue(5, 0, distance_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the Speed field
        /// Units: m/s</summary>
        /// <returns>Returns nullable float representing the Speed field</returns>
        public float? GetSpeed()
        {
            Object val = GetFieldValue(6, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set Speed field
        /// Units: m/s</summary>
        /// <param name="speed_">Nullable field value to be set</param>
        public void SetSpeed(float? speed_)
        {
            SetFieldValue(6, 0, speed_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the Power field
        /// Units: watts</summary>
        /// <returns>Returns nullable ushort representing the Power field</returns>
        public ushort? GetPower()
        {
            Object val = GetFieldValue(7, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToUInt16(val));
            
        }

        /// <summary>
        /// Set Power field
        /// Units: watts</summary>
        /// <param name="power_">Nullable field value to be set</param>
        public void SetPower(ushort? power_)
        {
            SetFieldValue(7, 0, power_, Fit.SubfieldIndexMainField);
        }
        
        
        /// <summary>
        ///
        /// </summary>
        /// <returns>returns number of elements in field CompressedSpeedDistance</returns>
        public int GetNumCompressedSpeedDistance()
        {
            return GetNumFieldValues(8, Fit.SubfieldIndexMainField);
        }

        ///<summary>
        /// Retrieves the CompressedSpeedDistance field</summary>
        /// <param name="index">0 based index of CompressedSpeedDistance element to retrieve</param>
        /// <returns>Returns nullable byte representing the CompressedSpeedDistance field</returns>
        public byte? GetCompressedSpeedDistance(int index)
        {
            Object val = GetFieldValue(8, index, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToByte(val));
            
        }

        /// <summary>
        /// Set CompressedSpeedDistance field</summary>
        /// <param name="index">0 based index of compressed_speed_distance</param>
        /// <param name="compressedSpeedDistance_">Nullable field value to be set</param>
        public void SetCompressedSpeedDistance(int index, byte? compressedSpeedDistance_)
        {
            SetFieldValue(8, index, compressedSpeedDistance_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the Grade field
        /// Units: %</summary>
        /// <returns>Returns nullable float representing the Grade field</returns>
        public float? GetGrade()
        {
            Object val = GetFieldValue(9, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set Grade field
        /// Units: %</summary>
        /// <param name="grade_">Nullable field value to be set</param>
        public void SetGrade(float? grade_)
        {
            SetFieldValue(9, 0, grade_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the Resistance field
        /// Comment: Relative. 0 is none  254 is Max.</summary>
        /// <returns>Returns nullable byte representing the Resistance field</returns>
        public byte? GetResistance()
        {
            Object val = GetFieldValue(10, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToByte(val));
            
        }

        /// <summary>
        /// Set Resistance field
        /// Comment: Relative. 0 is none  254 is Max.</summary>
        /// <param name="resistance_">Nullable field value to be set</param>
        public void SetResistance(byte? resistance_)
        {
            SetFieldValue(10, 0, resistance_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the TimeFromCourse field
        /// Units: s</summary>
        /// <returns>Returns nullable float representing the TimeFromCourse field</returns>
        public float? GetTimeFromCourse()
        {
            Object val = GetFieldValue(11, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set TimeFromCourse field
        /// Units: s</summary>
        /// <param name="timeFromCourse_">Nullable field value to be set</param>
        public void SetTimeFromCourse(float? timeFromCourse_)
        {
            SetFieldValue(11, 0, timeFromCourse_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the CycleLength field
        /// Units: m</summary>
        /// <returns>Returns nullable float representing the CycleLength field</returns>
        public float? GetCycleLength()
        {
            Object val = GetFieldValue(12, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set CycleLength field
        /// Units: m</summary>
        /// <param name="cycleLength_">Nullable field value to be set</param>
        public void SetCycleLength(float? cycleLength_)
        {
            SetFieldValue(12, 0, cycleLength_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the Temperature field
        /// Units: C</summary>
        /// <returns>Returns nullable sbyte representing the Temperature field</returns>
        public sbyte? GetTemperature()
        {
            Object val = GetFieldValue(13, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSByte(val));
            
        }

        /// <summary>
        /// Set Temperature field
        /// Units: C</summary>
        /// <param name="temperature_">Nullable field value to be set</param>
        public void SetTemperature(sbyte? temperature_)
        {
            SetFieldValue(13, 0, temperature_, Fit.SubfieldIndexMainField);
        }
        
        
        /// <summary>
        ///
        /// </summary>
        /// <returns>returns number of elements in field Speed1s</returns>
        public int GetNumSpeed1s()
        {
            return GetNumFieldValues(17, Fit.SubfieldIndexMainField);
        }

        ///<summary>
        /// Retrieves the Speed1s field
        /// Units: m/s
        /// Comment: Speed at 1s intervals.  Timestamp field indicates time of last array element.</summary>
        /// <param name="index">0 based index of Speed1s element to retrieve</param>
        /// <returns>Returns nullable float representing the Speed1s field</returns>
        public float? GetSpeed1s(int index)
        {
            Object val = GetFieldValue(17, index, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set Speed1s field
        /// Units: m/s
        /// Comment: Speed at 1s intervals.  Timestamp field indicates time of last array element.</summary>
        /// <param name="index">0 based index of speed_1s</param>
        /// <param name="speed1s_">Nullable field value to be set</param>
        public void SetSpeed1s(int index, float? speed1s_)
        {
            SetFieldValue(17, index, speed1s_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the Cycles field
        /// Units: cycles</summary>
        /// <returns>Returns nullable byte representing the Cycles field</returns>
        public byte? GetCycles()
        {
            Object val = GetFieldValue(18, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToByte(val));
            
        }

        /// <summary>
        /// Set Cycles field
        /// Units: cycles</summary>
        /// <param name="cycles_">Nullable field value to be set</param>
        public void SetCycles(byte? cycles_)
        {
            SetFieldValue(18, 0, cycles_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the TotalCycles field
        /// Units: cycles</summary>
        /// <returns>Returns nullable uint representing the TotalCycles field</returns>
        public uint? GetTotalCycles()
        {
            Object val = GetFieldValue(19, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToUInt32(val));
            
        }

        /// <summary>
        /// Set TotalCycles field
        /// Units: cycles</summary>
        /// <param name="totalCycles_">Nullable field value to be set</param>
        public void SetTotalCycles(uint? totalCycles_)
        {
            SetFieldValue(19, 0, totalCycles_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the CompressedAccumulatedPower field
        /// Units: watts</summary>
        /// <returns>Returns nullable ushort representing the CompressedAccumulatedPower field</returns>
        public ushort? GetCompressedAccumulatedPower()
        {
            Object val = GetFieldValue(28, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToUInt16(val));
            
        }

        /// <summary>
        /// Set CompressedAccumulatedPower field
        /// Units: watts</summary>
        /// <param name="compressedAccumulatedPower_">Nullable field value to be set</param>
        public void SetCompressedAccumulatedPower(ushort? compressedAccumulatedPower_)
        {
            SetFieldValue(28, 0, compressedAccumulatedPower_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the AccumulatedPower field
        /// Units: watts</summary>
        /// <returns>Returns nullable uint representing the AccumulatedPower field</returns>
        public uint? GetAccumulatedPower()
        {
            Object val = GetFieldValue(29, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToUInt32(val));
            
        }

        /// <summary>
        /// Set AccumulatedPower field
        /// Units: watts</summary>
        /// <param name="accumulatedPower_">Nullable field value to be set</param>
        public void SetAccumulatedPower(uint? accumulatedPower_)
        {
            SetFieldValue(29, 0, accumulatedPower_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the LeftRightBalance field</summary>
        /// <returns>Returns nullable byte representing the LeftRightBalance field</returns>
        public byte? GetLeftRightBalance()
        {
            Object val = GetFieldValue(30, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToByte(val));
            
        }

        /// <summary>
        /// Set LeftRightBalance field</summary>
        /// <param name="leftRightBalance_">Nullable field value to be set</param>
        public void SetLeftRightBalance(byte? leftRightBalance_)
        {
            SetFieldValue(30, 0, leftRightBalance_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the GpsAccuracy field
        /// Units: m</summary>
        /// <returns>Returns nullable byte representing the GpsAccuracy field</returns>
        public byte? GetGpsAccuracy()
        {
            Object val = GetFieldValue(31, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToByte(val));
            
        }

        /// <summary>
        /// Set GpsAccuracy field
        /// Units: m</summary>
        /// <param name="gpsAccuracy_">Nullable field value to be set</param>
        public void SetGpsAccuracy(byte? gpsAccuracy_)
        {
            SetFieldValue(31, 0, gpsAccuracy_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the VerticalSpeed field
        /// Units: m/s</summary>
        /// <returns>Returns nullable float representing the VerticalSpeed field</returns>
        public float? GetVerticalSpeed()
        {
            Object val = GetFieldValue(32, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set VerticalSpeed field
        /// Units: m/s</summary>
        /// <param name="verticalSpeed_">Nullable field value to be set</param>
        public void SetVerticalSpeed(float? verticalSpeed_)
        {
            SetFieldValue(32, 0, verticalSpeed_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the Calories field
        /// Units: kcal</summary>
        /// <returns>Returns nullable ushort representing the Calories field</returns>
        public ushort? GetCalories()
        {
            Object val = GetFieldValue(33, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToUInt16(val));
            
        }

        /// <summary>
        /// Set Calories field
        /// Units: kcal</summary>
        /// <param name="calories_">Nullable field value to be set</param>
        public void SetCalories(ushort? calories_)
        {
            SetFieldValue(33, 0, calories_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the VerticalOscillation field
        /// Units: mm</summary>
        /// <returns>Returns nullable float representing the VerticalOscillation field</returns>
        public float? GetVerticalOscillation()
        {
            Object val = GetFieldValue(39, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set VerticalOscillation field
        /// Units: mm</summary>
        /// <param name="verticalOscillation_">Nullable field value to be set</param>
        public void SetVerticalOscillation(float? verticalOscillation_)
        {
            SetFieldValue(39, 0, verticalOscillation_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the StanceTimePercent field
        /// Units: percent</summary>
        /// <returns>Returns nullable float representing the StanceTimePercent field</returns>
        public float? GetStanceTimePercent()
        {
            Object val = GetFieldValue(40, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set StanceTimePercent field
        /// Units: percent</summary>
        /// <param name="stanceTimePercent_">Nullable field value to be set</param>
        public void SetStanceTimePercent(float? stanceTimePercent_)
        {
            SetFieldValue(40, 0, stanceTimePercent_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the StanceTime field
        /// Units: ms</summary>
        /// <returns>Returns nullable float representing the StanceTime field</returns>
        public float? GetStanceTime()
        {
            Object val = GetFieldValue(41, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set StanceTime field
        /// Units: ms</summary>
        /// <param name="stanceTime_">Nullable field value to be set</param>
        public void SetStanceTime(float? stanceTime_)
        {
            SetFieldValue(41, 0, stanceTime_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the ActivityType field</summary>
        /// <returns>Returns nullable ActivityType enum representing the ActivityType field</returns>
        public ActivityType? GetActivityType()
        {
            object obj = GetFieldValue(42, 0, Fit.SubfieldIndexMainField);
            ActivityType? value = obj == null ? (ActivityType?)null : (ActivityType)obj;
            return value;
        }

        /// <summary>
        /// Set ActivityType field</summary>
        /// <param name="activityType_">Nullable field value to be set</param>
        public void SetActivityType(ActivityType? activityType_)
        {
            SetFieldValue(42, 0, activityType_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the LeftTorqueEffectiveness field
        /// Units: percent</summary>
        /// <returns>Returns nullable float representing the LeftTorqueEffectiveness field</returns>
        public float? GetLeftTorqueEffectiveness()
        {
            Object val = GetFieldValue(43, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set LeftTorqueEffectiveness field
        /// Units: percent</summary>
        /// <param name="leftTorqueEffectiveness_">Nullable field value to be set</param>
        public void SetLeftTorqueEffectiveness(float? leftTorqueEffectiveness_)
        {
            SetFieldValue(43, 0, leftTorqueEffectiveness_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the RightTorqueEffectiveness field
        /// Units: percent</summary>
        /// <returns>Returns nullable float representing the RightTorqueEffectiveness field</returns>
        public float? GetRightTorqueEffectiveness()
        {
            Object val = GetFieldValue(44, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set RightTorqueEffectiveness field
        /// Units: percent</summary>
        /// <param name="rightTorqueEffectiveness_">Nullable field value to be set</param>
        public void SetRightTorqueEffectiveness(float? rightTorqueEffectiveness_)
        {
            SetFieldValue(44, 0, rightTorqueEffectiveness_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the LeftPedalSmoothness field
        /// Units: percent</summary>
        /// <returns>Returns nullable float representing the LeftPedalSmoothness field</returns>
        public float? GetLeftPedalSmoothness()
        {
            Object val = GetFieldValue(45, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set LeftPedalSmoothness field
        /// Units: percent</summary>
        /// <param name="leftPedalSmoothness_">Nullable field value to be set</param>
        public void SetLeftPedalSmoothness(float? leftPedalSmoothness_)
        {
            SetFieldValue(45, 0, leftPedalSmoothness_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the RightPedalSmoothness field
        /// Units: percent</summary>
        /// <returns>Returns nullable float representing the RightPedalSmoothness field</returns>
        public float? GetRightPedalSmoothness()
        {
            Object val = GetFieldValue(46, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set RightPedalSmoothness field
        /// Units: percent</summary>
        /// <param name="rightPedalSmoothness_">Nullable field value to be set</param>
        public void SetRightPedalSmoothness(float? rightPedalSmoothness_)
        {
            SetFieldValue(46, 0, rightPedalSmoothness_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the CombinedPedalSmoothness field
        /// Units: percent</summary>
        /// <returns>Returns nullable float representing the CombinedPedalSmoothness field</returns>
        public float? GetCombinedPedalSmoothness()
        {
            Object val = GetFieldValue(47, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set CombinedPedalSmoothness field
        /// Units: percent</summary>
        /// <param name="combinedPedalSmoothness_">Nullable field value to be set</param>
        public void SetCombinedPedalSmoothness(float? combinedPedalSmoothness_)
        {
            SetFieldValue(47, 0, combinedPedalSmoothness_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the Time128 field
        /// Units: s</summary>
        /// <returns>Returns nullable float representing the Time128 field</returns>
        public float? GetTime128()
        {
            Object val = GetFieldValue(48, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set Time128 field
        /// Units: s</summary>
        /// <param name="time128_">Nullable field value to be set</param>
        public void SetTime128(float? time128_)
        {
            SetFieldValue(48, 0, time128_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the StrokeType field</summary>
        /// <returns>Returns nullable StrokeType enum representing the StrokeType field</returns>
        public StrokeType? GetStrokeType()
        {
            object obj = GetFieldValue(49, 0, Fit.SubfieldIndexMainField);
            StrokeType? value = obj == null ? (StrokeType?)null : (StrokeType)obj;
            return value;
        }

        /// <summary>
        /// Set StrokeType field</summary>
        /// <param name="strokeType_">Nullable field value to be set</param>
        public void SetStrokeType(StrokeType? strokeType_)
        {
            SetFieldValue(49, 0, strokeType_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the Zone field</summary>
        /// <returns>Returns nullable byte representing the Zone field</returns>
        public byte? GetZone()
        {
            Object val = GetFieldValue(50, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToByte(val));
            
        }

        /// <summary>
        /// Set Zone field</summary>
        /// <param name="zone_">Nullable field value to be set</param>
        public void SetZone(byte? zone_)
        {
            SetFieldValue(50, 0, zone_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the BallSpeed field
        /// Units: m/s</summary>
        /// <returns>Returns nullable float representing the BallSpeed field</returns>
        public float? GetBallSpeed()
        {
            Object val = GetFieldValue(51, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set BallSpeed field
        /// Units: m/s</summary>
        /// <param name="ballSpeed_">Nullable field value to be set</param>
        public void SetBallSpeed(float? ballSpeed_)
        {
            SetFieldValue(51, 0, ballSpeed_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the Cadence256 field
        /// Units: rpm
        /// Comment: Log cadence and fractional cadence for backwards compatability</summary>
        /// <returns>Returns nullable float representing the Cadence256 field</returns>
        public float? GetCadence256()
        {
            Object val = GetFieldValue(52, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set Cadence256 field
        /// Units: rpm
        /// Comment: Log cadence and fractional cadence for backwards compatability</summary>
        /// <param name="cadence256_">Nullable field value to be set</param>
        public void SetCadence256(float? cadence256_)
        {
            SetFieldValue(52, 0, cadence256_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the FractionalCadence field
        /// Units: rpm</summary>
        /// <returns>Returns nullable float representing the FractionalCadence field</returns>
        public float? GetFractionalCadence()
        {
            Object val = GetFieldValue(53, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set FractionalCadence field
        /// Units: rpm</summary>
        /// <param name="fractionalCadence_">Nullable field value to be set</param>
        public void SetFractionalCadence(float? fractionalCadence_)
        {
            SetFieldValue(53, 0, fractionalCadence_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the TotalHemoglobinConc field
        /// Units: g/dL
        /// Comment: Total saturated and unsaturated hemoglobin</summary>
        /// <returns>Returns nullable float representing the TotalHemoglobinConc field</returns>
        public float? GetTotalHemoglobinConc()
        {
            Object val = GetFieldValue(54, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set TotalHemoglobinConc field
        /// Units: g/dL
        /// Comment: Total saturated and unsaturated hemoglobin</summary>
        /// <param name="totalHemoglobinConc_">Nullable field value to be set</param>
        public void SetTotalHemoglobinConc(float? totalHemoglobinConc_)
        {
            SetFieldValue(54, 0, totalHemoglobinConc_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the TotalHemoglobinConcMin field
        /// Units: g/dL
        /// Comment: Min saturated and unsaturated hemoglobin</summary>
        /// <returns>Returns nullable float representing the TotalHemoglobinConcMin field</returns>
        public float? GetTotalHemoglobinConcMin()
        {
            Object val = GetFieldValue(55, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set TotalHemoglobinConcMin field
        /// Units: g/dL
        /// Comment: Min saturated and unsaturated hemoglobin</summary>
        /// <param name="totalHemoglobinConcMin_">Nullable field value to be set</param>
        public void SetTotalHemoglobinConcMin(float? totalHemoglobinConcMin_)
        {
            SetFieldValue(55, 0, totalHemoglobinConcMin_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the TotalHemoglobinConcMax field
        /// Units: g/dL
        /// Comment: Max saturated and unsaturated hemoglobin</summary>
        /// <returns>Returns nullable float representing the TotalHemoglobinConcMax field</returns>
        public float? GetTotalHemoglobinConcMax()
        {
            Object val = GetFieldValue(56, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set TotalHemoglobinConcMax field
        /// Units: g/dL
        /// Comment: Max saturated and unsaturated hemoglobin</summary>
        /// <param name="totalHemoglobinConcMax_">Nullable field value to be set</param>
        public void SetTotalHemoglobinConcMax(float? totalHemoglobinConcMax_)
        {
            SetFieldValue(56, 0, totalHemoglobinConcMax_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the SaturatedHemoglobinPercent field
        /// Units: %
        /// Comment: Percentage of hemoglobin saturated with oxygen</summary>
        /// <returns>Returns nullable float representing the SaturatedHemoglobinPercent field</returns>
        public float? GetSaturatedHemoglobinPercent()
        {
            Object val = GetFieldValue(57, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set SaturatedHemoglobinPercent field
        /// Units: %
        /// Comment: Percentage of hemoglobin saturated with oxygen</summary>
        /// <param name="saturatedHemoglobinPercent_">Nullable field value to be set</param>
        public void SetSaturatedHemoglobinPercent(float? saturatedHemoglobinPercent_)
        {
            SetFieldValue(57, 0, saturatedHemoglobinPercent_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the SaturatedHemoglobinPercentMin field
        /// Units: %
        /// Comment: Min percentage of hemoglobin saturated with oxygen</summary>
        /// <returns>Returns nullable float representing the SaturatedHemoglobinPercentMin field</returns>
        public float? GetSaturatedHemoglobinPercentMin()
        {
            Object val = GetFieldValue(58, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set SaturatedHemoglobinPercentMin field
        /// Units: %
        /// Comment: Min percentage of hemoglobin saturated with oxygen</summary>
        /// <param name="saturatedHemoglobinPercentMin_">Nullable field value to be set</param>
        public void SetSaturatedHemoglobinPercentMin(float? saturatedHemoglobinPercentMin_)
        {
            SetFieldValue(58, 0, saturatedHemoglobinPercentMin_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the SaturatedHemoglobinPercentMax field
        /// Units: %
        /// Comment: Max percentage of hemoglobin saturated with oxygen</summary>
        /// <returns>Returns nullable float representing the SaturatedHemoglobinPercentMax field</returns>
        public float? GetSaturatedHemoglobinPercentMax()
        {
            Object val = GetFieldValue(59, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set SaturatedHemoglobinPercentMax field
        /// Units: %
        /// Comment: Max percentage of hemoglobin saturated with oxygen</summary>
        /// <param name="saturatedHemoglobinPercentMax_">Nullable field value to be set</param>
        public void SetSaturatedHemoglobinPercentMax(float? saturatedHemoglobinPercentMax_)
        {
            SetFieldValue(59, 0, saturatedHemoglobinPercentMax_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the DeviceIndex field</summary>
        /// <returns>Returns nullable byte representing the DeviceIndex field</returns>
        public byte? GetDeviceIndex()
        {
            Object val = GetFieldValue(62, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToByte(val));
            
        }

        /// <summary>
        /// Set DeviceIndex field</summary>
        /// <param name="deviceIndex_">Nullable field value to be set</param>
        public void SetDeviceIndex(byte? deviceIndex_)
        {
            SetFieldValue(62, 0, deviceIndex_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the LeftPco field
        /// Units: mm
        /// Comment: Left platform center offset</summary>
        /// <returns>Returns nullable sbyte representing the LeftPco field</returns>
        public sbyte? GetLeftPco()
        {
            Object val = GetFieldValue(67, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSByte(val));
            
        }

        /// <summary>
        /// Set LeftPco field
        /// Units: mm
        /// Comment: Left platform center offset</summary>
        /// <param name="leftPco_">Nullable field value to be set</param>
        public void SetLeftPco(sbyte? leftPco_)
        {
            SetFieldValue(67, 0, leftPco_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the RightPco field
        /// Units: mm
        /// Comment: Right platform center offset</summary>
        /// <returns>Returns nullable sbyte representing the RightPco field</returns>
        public sbyte? GetRightPco()
        {
            Object val = GetFieldValue(68, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSByte(val));
            
        }

        /// <summary>
        /// Set RightPco field
        /// Units: mm
        /// Comment: Right platform center offset</summary>
        /// <param name="rightPco_">Nullable field value to be set</param>
        public void SetRightPco(sbyte? rightPco_)
        {
            SetFieldValue(68, 0, rightPco_, Fit.SubfieldIndexMainField);
        }
        
        
        /// <summary>
        ///
        /// </summary>
        /// <returns>returns number of elements in field LeftPowerPhase</returns>
        public int GetNumLeftPowerPhase()
        {
            return GetNumFieldValues(69, Fit.SubfieldIndexMainField);
        }

        ///<summary>
        /// Retrieves the LeftPowerPhase field
        /// Units: degrees
        /// Comment: Left power phase angles. Data value indexes defined by power_phase_type.</summary>
        /// <param name="index">0 based index of LeftPowerPhase element to retrieve</param>
        /// <returns>Returns nullable float representing the LeftPowerPhase field</returns>
        public float? GetLeftPowerPhase(int index)
        {
            Object val = GetFieldValue(69, index, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set LeftPowerPhase field
        /// Units: degrees
        /// Comment: Left power phase angles. Data value indexes defined by power_phase_type.</summary>
        /// <param name="index">0 based index of left_power_phase</param>
        /// <param name="leftPowerPhase_">Nullable field value to be set</param>
        public void SetLeftPowerPhase(int index, float? leftPowerPhase_)
        {
            SetFieldValue(69, index, leftPowerPhase_, Fit.SubfieldIndexMainField);
        }
        
        
        /// <summary>
        ///
        /// </summary>
        /// <returns>returns number of elements in field LeftPowerPhasePeak</returns>
        public int GetNumLeftPowerPhasePeak()
        {
            return GetNumFieldValues(70, Fit.SubfieldIndexMainField);
        }

        ///<summary>
        /// Retrieves the LeftPowerPhasePeak field
        /// Units: degrees
        /// Comment: Left power phase peak angles. Data value indexes defined by power_phase_type.</summary>
        /// <param name="index">0 based index of LeftPowerPhasePeak element to retrieve</param>
        /// <returns>Returns nullable float representing the LeftPowerPhasePeak field</returns>
        public float? GetLeftPowerPhasePeak(int index)
        {
            Object val = GetFieldValue(70, index, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set LeftPowerPhasePeak field
        /// Units: degrees
        /// Comment: Left power phase peak angles. Data value indexes defined by power_phase_type.</summary>
        /// <param name="index">0 based index of left_power_phase_peak</param>
        /// <param name="leftPowerPhasePeak_">Nullable field value to be set</param>
        public void SetLeftPowerPhasePeak(int index, float? leftPowerPhasePeak_)
        {
            SetFieldValue(70, index, leftPowerPhasePeak_, Fit.SubfieldIndexMainField);
        }
        
        
        /// <summary>
        ///
        /// </summary>
        /// <returns>returns number of elements in field RightPowerPhase</returns>
        public int GetNumRightPowerPhase()
        {
            return GetNumFieldValues(71, Fit.SubfieldIndexMainField);
        }

        ///<summary>
        /// Retrieves the RightPowerPhase field
        /// Units: degrees
        /// Comment: Right power phase angles. Data value indexes defined by power_phase_type.</summary>
        /// <param name="index">0 based index of RightPowerPhase element to retrieve</param>
        /// <returns>Returns nullable float representing the RightPowerPhase field</returns>
        public float? GetRightPowerPhase(int index)
        {
            Object val = GetFieldValue(71, index, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set RightPowerPhase field
        /// Units: degrees
        /// Comment: Right power phase angles. Data value indexes defined by power_phase_type.</summary>
        /// <param name="index">0 based index of right_power_phase</param>
        /// <param name="rightPowerPhase_">Nullable field value to be set</param>
        public void SetRightPowerPhase(int index, float? rightPowerPhase_)
        {
            SetFieldValue(71, index, rightPowerPhase_, Fit.SubfieldIndexMainField);
        }
        
        
        /// <summary>
        ///
        /// </summary>
        /// <returns>returns number of elements in field RightPowerPhasePeak</returns>
        public int GetNumRightPowerPhasePeak()
        {
            return GetNumFieldValues(72, Fit.SubfieldIndexMainField);
        }

        ///<summary>
        /// Retrieves the RightPowerPhasePeak field
        /// Units: degrees
        /// Comment: Right power phase peak angles. Data value indexes defined by power_phase_type.</summary>
        /// <param name="index">0 based index of RightPowerPhasePeak element to retrieve</param>
        /// <returns>Returns nullable float representing the RightPowerPhasePeak field</returns>
        public float? GetRightPowerPhasePeak(int index)
        {
            Object val = GetFieldValue(72, index, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set RightPowerPhasePeak field
        /// Units: degrees
        /// Comment: Right power phase peak angles. Data value indexes defined by power_phase_type.</summary>
        /// <param name="index">0 based index of right_power_phase_peak</param>
        /// <param name="rightPowerPhasePeak_">Nullable field value to be set</param>
        public void SetRightPowerPhasePeak(int index, float? rightPowerPhasePeak_)
        {
            SetFieldValue(72, index, rightPowerPhasePeak_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the EnhancedSpeed field
        /// Units: m/s</summary>
        /// <returns>Returns nullable float representing the EnhancedSpeed field</returns>
        public float? GetEnhancedSpeed()
        {
            Object val = GetFieldValue(73, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set EnhancedSpeed field
        /// Units: m/s</summary>
        /// <param name="enhancedSpeed_">Nullable field value to be set</param>
        public void SetEnhancedSpeed(float? enhancedSpeed_)
        {
            SetFieldValue(73, 0, enhancedSpeed_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the EnhancedAltitude field
        /// Units: m</summary>
        /// <returns>Returns nullable float representing the EnhancedAltitude field</returns>
        public float? GetEnhancedAltitude()
        {
            Object val = GetFieldValue(78, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set EnhancedAltitude field
        /// Units: m</summary>
        /// <param name="enhancedAltitude_">Nullable field value to be set</param>
        public void SetEnhancedAltitude(float? enhancedAltitude_)
        {
            SetFieldValue(78, 0, enhancedAltitude_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the BatterySoc field
        /// Units: percent
        /// Comment: lev battery state of charge</summary>
        /// <returns>Returns nullable float representing the BatterySoc field</returns>
        public float? GetBatterySoc()
        {
            Object val = GetFieldValue(81, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set BatterySoc field
        /// Units: percent
        /// Comment: lev battery state of charge</summary>
        /// <param name="batterySoc_">Nullable field value to be set</param>
        public void SetBatterySoc(float? batterySoc_)
        {
            SetFieldValue(81, 0, batterySoc_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the MotorPower field
        /// Units: watts
        /// Comment: lev motor power</summary>
        /// <returns>Returns nullable ushort representing the MotorPower field</returns>
        public ushort? GetMotorPower()
        {
            Object val = GetFieldValue(82, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToUInt16(val));
            
        }

        /// <summary>
        /// Set MotorPower field
        /// Units: watts
        /// Comment: lev motor power</summary>
        /// <param name="motorPower_">Nullable field value to be set</param>
        public void SetMotorPower(ushort? motorPower_)
        {
            SetFieldValue(82, 0, motorPower_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the VerticalRatio field
        /// Units: percent</summary>
        /// <returns>Returns nullable float representing the VerticalRatio field</returns>
        public float? GetVerticalRatio()
        {
            Object val = GetFieldValue(83, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set VerticalRatio field
        /// Units: percent</summary>
        /// <param name="verticalRatio_">Nullable field value to be set</param>
        public void SetVerticalRatio(float? verticalRatio_)
        {
            SetFieldValue(83, 0, verticalRatio_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the StanceTimeBalance field
        /// Units: percent</summary>
        /// <returns>Returns nullable float representing the StanceTimeBalance field</returns>
        public float? GetStanceTimeBalance()
        {
            Object val = GetFieldValue(84, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set StanceTimeBalance field
        /// Units: percent</summary>
        /// <param name="stanceTimeBalance_">Nullable field value to be set</param>
        public void SetStanceTimeBalance(float? stanceTimeBalance_)
        {
            SetFieldValue(84, 0, stanceTimeBalance_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the StepLength field
        /// Units: mm</summary>
        /// <returns>Returns nullable float representing the StepLength field</returns>
        public float? GetStepLength()
        {
            Object val = GetFieldValue(85, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set StepLength field
        /// Units: mm</summary>
        /// <param name="stepLength_">Nullable field value to be set</param>
        public void SetStepLength(float? stepLength_)
        {
            SetFieldValue(85, 0, stepLength_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the AbsolutePressure field
        /// Units: Pa
        /// Comment: Includes atmospheric pressure</summary>
        /// <returns>Returns nullable uint representing the AbsolutePressure field</returns>
        public uint? GetAbsolutePressure()
        {
            Object val = GetFieldValue(91, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToUInt32(val));
            
        }

        /// <summary>
        /// Set AbsolutePressure field
        /// Units: Pa
        /// Comment: Includes atmospheric pressure</summary>
        /// <param name="absolutePressure_">Nullable field value to be set</param>
        public void SetAbsolutePressure(uint? absolutePressure_)
        {
            SetFieldValue(91, 0, absolutePressure_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the Depth field
        /// Units: m
        /// Comment: 0 if above water</summary>
        /// <returns>Returns nullable float representing the Depth field</returns>
        public float? GetDepth()
        {
            Object val = GetFieldValue(92, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set Depth field
        /// Units: m
        /// Comment: 0 if above water</summary>
        /// <param name="depth_">Nullable field value to be set</param>
        public void SetDepth(float? depth_)
        {
            SetFieldValue(92, 0, depth_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the NextStopDepth field
        /// Units: m
        /// Comment: 0 if above water</summary>
        /// <returns>Returns nullable float representing the NextStopDepth field</returns>
        public float? GetNextStopDepth()
        {
            Object val = GetFieldValue(93, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set NextStopDepth field
        /// Units: m
        /// Comment: 0 if above water</summary>
        /// <param name="nextStopDepth_">Nullable field value to be set</param>
        public void SetNextStopDepth(float? nextStopDepth_)
        {
            SetFieldValue(93, 0, nextStopDepth_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the NextStopTime field
        /// Units: s</summary>
        /// <returns>Returns nullable uint representing the NextStopTime field</returns>
        public uint? GetNextStopTime()
        {
            Object val = GetFieldValue(94, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToUInt32(val));
            
        }

        /// <summary>
        /// Set NextStopTime field
        /// Units: s</summary>
        /// <param name="nextStopTime_">Nullable field value to be set</param>
        public void SetNextStopTime(uint? nextStopTime_)
        {
            SetFieldValue(94, 0, nextStopTime_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the TimeToSurface field
        /// Units: s</summary>
        /// <returns>Returns nullable uint representing the TimeToSurface field</returns>
        public uint? GetTimeToSurface()
        {
            Object val = GetFieldValue(95, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToUInt32(val));
            
        }

        /// <summary>
        /// Set TimeToSurface field
        /// Units: s</summary>
        /// <param name="timeToSurface_">Nullable field value to be set</param>
        public void SetTimeToSurface(uint? timeToSurface_)
        {
            SetFieldValue(95, 0, timeToSurface_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the NdlTime field
        /// Units: s</summary>
        /// <returns>Returns nullable uint representing the NdlTime field</returns>
        public uint? GetNdlTime()
        {
            Object val = GetFieldValue(96, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToUInt32(val));
            
        }

        /// <summary>
        /// Set NdlTime field
        /// Units: s</summary>
        /// <param name="ndlTime_">Nullable field value to be set</param>
        public void SetNdlTime(uint? ndlTime_)
        {
            SetFieldValue(96, 0, ndlTime_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the CnsLoad field
        /// Units: percent</summary>
        /// <returns>Returns nullable byte representing the CnsLoad field</returns>
        public byte? GetCnsLoad()
        {
            Object val = GetFieldValue(97, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToByte(val));
            
        }

        /// <summary>
        /// Set CnsLoad field
        /// Units: percent</summary>
        /// <param name="cnsLoad_">Nullable field value to be set</param>
        public void SetCnsLoad(byte? cnsLoad_)
        {
            SetFieldValue(97, 0, cnsLoad_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the N2Load field
        /// Units: percent</summary>
        /// <returns>Returns nullable ushort representing the N2Load field</returns>
        public ushort? GetN2Load()
        {
            Object val = GetFieldValue(98, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToUInt16(val));
            
        }

        /// <summary>
        /// Set N2Load field
        /// Units: percent</summary>
        /// <param name="n2Load_">Nullable field value to be set</param>
        public void SetN2Load(ushort? n2Load_)
        {
            SetFieldValue(98, 0, n2Load_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the Grit field
        /// Comment: The grit score estimates how challenging a route could be for a cyclist in terms of time spent going over sharp turns or large grade slopes.</summary>
        /// <returns>Returns nullable float representing the Grit field</returns>
        public float? GetGrit()
        {
            Object val = GetFieldValue(114, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set Grit field
        /// Comment: The grit score estimates how challenging a route could be for a cyclist in terms of time spent going over sharp turns or large grade slopes.</summary>
        /// <param name="grit_">Nullable field value to be set</param>
        public void SetGrit(float? grit_)
        {
            SetFieldValue(114, 0, grit_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the Flow field
        /// Comment: The flow score estimates how long distance wise a cyclist deaccelerates over intervals where deacceleration is unnecessary such as smooth turns or small grade angle intervals.</summary>
        /// <returns>Returns nullable float representing the Flow field</returns>
        public float? GetFlow()
        {
            Object val = GetFieldValue(115, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set Flow field
        /// Comment: The flow score estimates how long distance wise a cyclist deaccelerates over intervals where deacceleration is unnecessary such as smooth turns or small grade angle intervals.</summary>
        /// <param name="flow_">Nullable field value to be set</param>
        public void SetFlow(float? flow_)
        {
            SetFieldValue(115, 0, flow_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the EbikeTravelRange field
        /// Units: km</summary>
        /// <returns>Returns nullable ushort representing the EbikeTravelRange field</returns>
        public ushort? GetEbikeTravelRange()
        {
            Object val = GetFieldValue(117, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToUInt16(val));
            
        }

        /// <summary>
        /// Set EbikeTravelRange field
        /// Units: km</summary>
        /// <param name="ebikeTravelRange_">Nullable field value to be set</param>
        public void SetEbikeTravelRange(ushort? ebikeTravelRange_)
        {
            SetFieldValue(117, 0, ebikeTravelRange_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the EbikeBatteryLevel field
        /// Units: percent</summary>
        /// <returns>Returns nullable byte representing the EbikeBatteryLevel field</returns>
        public byte? GetEbikeBatteryLevel()
        {
            Object val = GetFieldValue(118, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToByte(val));
            
        }

        /// <summary>
        /// Set EbikeBatteryLevel field
        /// Units: percent</summary>
        /// <param name="ebikeBatteryLevel_">Nullable field value to be set</param>
        public void SetEbikeBatteryLevel(byte? ebikeBatteryLevel_)
        {
            SetFieldValue(118, 0, ebikeBatteryLevel_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the EbikeAssistMode field
        /// Units: depends on sensor</summary>
        /// <returns>Returns nullable byte representing the EbikeAssistMode field</returns>
        public byte? GetEbikeAssistMode()
        {
            Object val = GetFieldValue(119, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToByte(val));
            
        }

        /// <summary>
        /// Set EbikeAssistMode field
        /// Units: depends on sensor</summary>
        /// <param name="ebikeAssistMode_">Nullable field value to be set</param>
        public void SetEbikeAssistMode(byte? ebikeAssistMode_)
        {
            SetFieldValue(119, 0, ebikeAssistMode_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the EbikeAssistLevelPercent field
        /// Units: percent</summary>
        /// <returns>Returns nullable byte representing the EbikeAssistLevelPercent field</returns>
        public byte? GetEbikeAssistLevelPercent()
        {
            Object val = GetFieldValue(120, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToByte(val));
            
        }

        /// <summary>
        /// Set EbikeAssistLevelPercent field
        /// Units: percent</summary>
        /// <param name="ebikeAssistLevelPercent_">Nullable field value to be set</param>
        public void SetEbikeAssistLevelPercent(byte? ebikeAssistLevelPercent_)
        {
            SetFieldValue(120, 0, ebikeAssistLevelPercent_, Fit.SubfieldIndexMainField);
        }
        
        #endregion // Methods
    } // Class
} // namespace
