#region Copyright
////////////////////////////////////////////////////////////////////////////////
// The following FIT Protocol software provided may be used with FIT protocol
// devices only and remains the copyrighted property of Garmin Canada Inc.
// The software is being provided on an "as-is" basis and as an accommodation,
// and therefore all warranties, representations, or guarantees of any kind
// (whether express, implied or statutory) including, without limitation,
// warranties of merchantability, non-infringement, or fitness for a particular
// purpose, are specifically disclaimed.
//
// Copyright 2020 Garmin Canada Inc.
////////////////////////////////////////////////////////////////////////////////
// ****WARNING****  This file is auto-generated!  Do NOT edit this file.
// Profile Version = 21.38Release
// Tag = production/akw/21.38.00-0-g0d69e49
////////////////////////////////////////////////////////////////////////////////

#endregion

using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Text;
using System.IO;
using System.Linq;

namespace Dynastream.Fit
{
    /// <summary>
    /// Implements the Event profile message.
    /// </summary>
    public class EventMesg : Mesg
    {
        #region Fields
        static class DataSubfield
        {
            public static ushort TimerTrigger = 0;
            public static ushort CoursePointIndex = 1;
            public static ushort BatteryLevel = 2;
            public static ushort VirtualPartnerSpeed = 3;
            public static ushort HrHighAlert = 4;
            public static ushort HrLowAlert = 5;
            public static ushort SpeedHighAlert = 6;
            public static ushort SpeedLowAlert = 7;
            public static ushort CadHighAlert = 8;
            public static ushort CadLowAlert = 9;
            public static ushort PowerHighAlert = 10;
            public static ushort PowerLowAlert = 11;
            public static ushort TimeDurationAlert = 12;
            public static ushort DistanceDurationAlert = 13;
            public static ushort CalorieDurationAlert = 14;
            public static ushort FitnessEquipmentState = 15;
            public static ushort SportPoint = 16;
            public static ushort GearChangeData = 17;
            public static ushort RiderPosition = 18;
            public static ushort CommTimeout = 19;
            public static ushort RadarThreatAlert = 20;
            public static ushort Subfields = 21;
            public static ushort Active = Fit.SubfieldIndexActiveSubfield;
            public static ushort MainField = Fit.SubfieldIndexMainField;
        }
        #endregion

        /// <summary>
        /// Field Numbers for <see cref="EventMesg"/>
        /// </summary>
        public sealed class FieldDefNum
        {
            public const byte Timestamp = 253;
            public const byte Event = 0;
            public const byte EventType = 1;
            public const byte Data16 = 2;
            public const byte Data = 3;
            public const byte EventGroup = 4;
            public const byte Score = 7;
            public const byte OpponentScore = 8;
            public const byte FrontGearNum = 9;
            public const byte FrontGear = 10;
            public const byte RearGearNum = 11;
            public const byte RearGear = 12;
            public const byte DeviceIndex = 13;
            public const byte RadarThreatLevelMax = 21;
            public const byte RadarThreatCount = 22;
            public const byte Invalid = Fit.FieldNumInvalid;
        }

        #region Constructors
        public EventMesg() : base(Profile.GetMesg(MesgNum.Event))
        {
        }

        public EventMesg(Mesg mesg) : base(mesg)
        {
        }
        #endregion // Constructors

        #region Methods
        ///<summary>
        /// Retrieves the Timestamp field
        /// Units: s</summary>
        /// <returns>Returns DateTime representing the Timestamp field</returns>
        public DateTime GetTimestamp()
        {
            Object val = GetFieldValue(253, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return TimestampToDateTime(Convert.ToUInt32(val));
            
        }

        /// <summary>
        /// Set Timestamp field
        /// Units: s</summary>
        /// <param name="timestamp_">Nullable field value to be set</param>
        public void SetTimestamp(DateTime timestamp_)
        {
            SetFieldValue(253, 0, timestamp_.GetTimeStamp(), Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the Event field</summary>
        /// <returns>Returns nullable Event enum representing the Event field</returns>
        public Event? GetEvent()
        {
            object obj = GetFieldValue(0, 0, Fit.SubfieldIndexMainField);
            Event? value = obj == null ? (Event?)null : (Event)obj;
            return value;
        }

        /// <summary>
        /// Set Event field</summary>
        /// <param name="event_">Nullable field value to be set</param>
        public void SetEvent(Event? event_)
        {
            SetFieldValue(0, 0, event_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the EventType field</summary>
        /// <returns>Returns nullable EventType enum representing the EventType field</returns>
        public EventType? GetEventType()
        {
            object obj = GetFieldValue(1, 0, Fit.SubfieldIndexMainField);
            EventType? value = obj == null ? (EventType?)null : (EventType)obj;
            return value;
        }

        /// <summary>
        /// Set EventType field</summary>
        /// <param name="eventType_">Nullable field value to be set</param>
        public void SetEventType(EventType? eventType_)
        {
            SetFieldValue(1, 0, eventType_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the Data16 field</summary>
        /// <returns>Returns nullable ushort representing the Data16 field</returns>
        public ushort? GetData16()
        {
            Object val = GetFieldValue(2, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToUInt16(val));
            
        }

        /// <summary>
        /// Set Data16 field</summary>
        /// <param name="data16_">Nullable field value to be set</param>
        public void SetData16(ushort? data16_)
        {
            SetFieldValue(2, 0, data16_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the Data field</summary>
        /// <returns>Returns nullable uint representing the Data field</returns>
        public uint? GetData()
        {
            Object val = GetFieldValue(3, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToUInt32(val));
            
        }

        /// <summary>
        /// Set Data field</summary>
        /// <param name="data_">Nullable field value to be set</param>
        public void SetData(uint? data_)
        {
            SetFieldValue(3, 0, data_, Fit.SubfieldIndexMainField);
        }
        

        /// <summary>
        /// Retrieves the TimerTrigger subfield</summary>
        /// <returns>Nullable TimerTrigger enum representing the TimerTrigger subfield</returns>
        public TimerTrigger? GetTimerTrigger()
        {
            return (TimerTrigger?)GetFieldValue(3, 0, DataSubfield.TimerTrigger);
        }

        /// <summary>
        ///
        /// Set TimerTrigger subfield</summary>
        /// <param name="timerTrigger">Subfield value to be set</param>
        public void SetTimerTrigger(byte? timerTrigger)
        {
            SetFieldValue(3, 0, timerTrigger, DataSubfield.TimerTrigger);
        }

        /// <summary>
        /// Retrieves the CoursePointIndex subfield</summary>
        /// <returns>Nullable ushort representing the CoursePointIndex subfield</returns>
        public ushort? GetCoursePointIndex()
        {
            Object val = GetFieldValue(3, 0, DataSubfield.CoursePointIndex);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToUInt16(val));
            
        }

        /// <summary>
        ///
        /// Set CoursePointIndex subfield</summary>
        /// <param name="coursePointIndex">Subfield value to be set</param>
        public void SetCoursePointIndex(ushort? coursePointIndex)
        {
            SetFieldValue(3, 0, coursePointIndex, DataSubfield.CoursePointIndex);
        }

        /// <summary>
        /// Retrieves the BatteryLevel subfield
        /// Units: V</summary>
        /// <returns>Nullable float representing the BatteryLevel subfield</returns>
        public float? GetBatteryLevel()
        {
            Object val = GetFieldValue(3, 0, DataSubfield.BatteryLevel);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        ///
        /// Set BatteryLevel subfield
        /// Units: V</summary>
        /// <param name="batteryLevel">Subfield value to be set</param>
        public void SetBatteryLevel(float? batteryLevel)
        {
            SetFieldValue(3, 0, batteryLevel, DataSubfield.BatteryLevel);
        }

        /// <summary>
        /// Retrieves the VirtualPartnerSpeed subfield
        /// Units: m/s</summary>
        /// <returns>Nullable float representing the VirtualPartnerSpeed subfield</returns>
        public float? GetVirtualPartnerSpeed()
        {
            Object val = GetFieldValue(3, 0, DataSubfield.VirtualPartnerSpeed);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        ///
        /// Set VirtualPartnerSpeed subfield
        /// Units: m/s</summary>
        /// <param name="virtualPartnerSpeed">Subfield value to be set</param>
        public void SetVirtualPartnerSpeed(float? virtualPartnerSpeed)
        {
            SetFieldValue(3, 0, virtualPartnerSpeed, DataSubfield.VirtualPartnerSpeed);
        }

        /// <summary>
        /// Retrieves the HrHighAlert subfield
        /// Units: bpm</summary>
        /// <returns>Nullable byte representing the HrHighAlert subfield</returns>
        public byte? GetHrHighAlert()
        {
            Object val = GetFieldValue(3, 0, DataSubfield.HrHighAlert);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToByte(val));
            
        }

        /// <summary>
        ///
        /// Set HrHighAlert subfield
        /// Units: bpm</summary>
        /// <param name="hrHighAlert">Subfield value to be set</param>
        public void SetHrHighAlert(byte? hrHighAlert)
        {
            SetFieldValue(3, 0, hrHighAlert, DataSubfield.HrHighAlert);
        }

        /// <summary>
        /// Retrieves the HrLowAlert subfield
        /// Units: bpm</summary>
        /// <returns>Nullable byte representing the HrLowAlert subfield</returns>
        public byte? GetHrLowAlert()
        {
            Object val = GetFieldValue(3, 0, DataSubfield.HrLowAlert);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToByte(val));
            
        }

        /// <summary>
        ///
        /// Set HrLowAlert subfield
        /// Units: bpm</summary>
        /// <param name="hrLowAlert">Subfield value to be set</param>
        public void SetHrLowAlert(byte? hrLowAlert)
        {
            SetFieldValue(3, 0, hrLowAlert, DataSubfield.HrLowAlert);
        }

        /// <summary>
        /// Retrieves the SpeedHighAlert subfield
        /// Units: m/s</summary>
        /// <returns>Nullable float representing the SpeedHighAlert subfield</returns>
        public float? GetSpeedHighAlert()
        {
            Object val = GetFieldValue(3, 0, DataSubfield.SpeedHighAlert);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        ///
        /// Set SpeedHighAlert subfield
        /// Units: m/s</summary>
        /// <param name="speedHighAlert">Subfield value to be set</param>
        public void SetSpeedHighAlert(float? speedHighAlert)
        {
            SetFieldValue(3, 0, speedHighAlert, DataSubfield.SpeedHighAlert);
        }

        /// <summary>
        /// Retrieves the SpeedLowAlert subfield
        /// Units: m/s</summary>
        /// <returns>Nullable float representing the SpeedLowAlert subfield</returns>
        public float? GetSpeedLowAlert()
        {
            Object val = GetFieldValue(3, 0, DataSubfield.SpeedLowAlert);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        ///
        /// Set SpeedLowAlert subfield
        /// Units: m/s</summary>
        /// <param name="speedLowAlert">Subfield value to be set</param>
        public void SetSpeedLowAlert(float? speedLowAlert)
        {
            SetFieldValue(3, 0, speedLowAlert, DataSubfield.SpeedLowAlert);
        }

        /// <summary>
        /// Retrieves the CadHighAlert subfield
        /// Units: rpm</summary>
        /// <returns>Nullable ushort representing the CadHighAlert subfield</returns>
        public ushort? GetCadHighAlert()
        {
            Object val = GetFieldValue(3, 0, DataSubfield.CadHighAlert);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToUInt16(val));
            
        }

        /// <summary>
        ///
        /// Set CadHighAlert subfield
        /// Units: rpm</summary>
        /// <param name="cadHighAlert">Subfield value to be set</param>
        public void SetCadHighAlert(ushort? cadHighAlert)
        {
            SetFieldValue(3, 0, cadHighAlert, DataSubfield.CadHighAlert);
        }

        /// <summary>
        /// Retrieves the CadLowAlert subfield
        /// Units: rpm</summary>
        /// <returns>Nullable ushort representing the CadLowAlert subfield</returns>
        public ushort? GetCadLowAlert()
        {
            Object val = GetFieldValue(3, 0, DataSubfield.CadLowAlert);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToUInt16(val));
            
        }

        /// <summary>
        ///
        /// Set CadLowAlert subfield
        /// Units: rpm</summary>
        /// <param name="cadLowAlert">Subfield value to be set</param>
        public void SetCadLowAlert(ushort? cadLowAlert)
        {
            SetFieldValue(3, 0, cadLowAlert, DataSubfield.CadLowAlert);
        }

        /// <summary>
        /// Retrieves the PowerHighAlert subfield
        /// Units: watts</summary>
        /// <returns>Nullable ushort representing the PowerHighAlert subfield</returns>
        public ushort? GetPowerHighAlert()
        {
            Object val = GetFieldValue(3, 0, DataSubfield.PowerHighAlert);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToUInt16(val));
            
        }

        /// <summary>
        ///
        /// Set PowerHighAlert subfield
        /// Units: watts</summary>
        /// <param name="powerHighAlert">Subfield value to be set</param>
        public void SetPowerHighAlert(ushort? powerHighAlert)
        {
            SetFieldValue(3, 0, powerHighAlert, DataSubfield.PowerHighAlert);
        }

        /// <summary>
        /// Retrieves the PowerLowAlert subfield
        /// Units: watts</summary>
        /// <returns>Nullable ushort representing the PowerLowAlert subfield</returns>
        public ushort? GetPowerLowAlert()
        {
            Object val = GetFieldValue(3, 0, DataSubfield.PowerLowAlert);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToUInt16(val));
            
        }

        /// <summary>
        ///
        /// Set PowerLowAlert subfield
        /// Units: watts</summary>
        /// <param name="powerLowAlert">Subfield value to be set</param>
        public void SetPowerLowAlert(ushort? powerLowAlert)
        {
            SetFieldValue(3, 0, powerLowAlert, DataSubfield.PowerLowAlert);
        }

        /// <summary>
        /// Retrieves the TimeDurationAlert subfield
        /// Units: s</summary>
        /// <returns>Nullable float representing the TimeDurationAlert subfield</returns>
        public float? GetTimeDurationAlert()
        {
            Object val = GetFieldValue(3, 0, DataSubfield.TimeDurationAlert);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        ///
        /// Set TimeDurationAlert subfield
        /// Units: s</summary>
        /// <param name="timeDurationAlert">Subfield value to be set</param>
        public void SetTimeDurationAlert(float? timeDurationAlert)
        {
            SetFieldValue(3, 0, timeDurationAlert, DataSubfield.TimeDurationAlert);
        }

        /// <summary>
        /// Retrieves the DistanceDurationAlert subfield
        /// Units: m</summary>
        /// <returns>Nullable float representing the DistanceDurationAlert subfield</returns>
        public float? GetDistanceDurationAlert()
        {
            Object val = GetFieldValue(3, 0, DataSubfield.DistanceDurationAlert);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        ///
        /// Set DistanceDurationAlert subfield
        /// Units: m</summary>
        /// <param name="distanceDurationAlert">Subfield value to be set</param>
        public void SetDistanceDurationAlert(float? distanceDurationAlert)
        {
            SetFieldValue(3, 0, distanceDurationAlert, DataSubfield.DistanceDurationAlert);
        }

        /// <summary>
        /// Retrieves the CalorieDurationAlert subfield
        /// Units: calories</summary>
        /// <returns>Nullable uint representing the CalorieDurationAlert subfield</returns>
        public uint? GetCalorieDurationAlert()
        {
            Object val = GetFieldValue(3, 0, DataSubfield.CalorieDurationAlert);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToUInt32(val));
            
        }

        /// <summary>
        ///
        /// Set CalorieDurationAlert subfield
        /// Units: calories</summary>
        /// <param name="calorieDurationAlert">Subfield value to be set</param>
        public void SetCalorieDurationAlert(uint? calorieDurationAlert)
        {
            SetFieldValue(3, 0, calorieDurationAlert, DataSubfield.CalorieDurationAlert);
        }

        /// <summary>
        /// Retrieves the FitnessEquipmentState subfield</summary>
        /// <returns>Nullable FitnessEquipmentState enum representing the FitnessEquipmentState subfield</returns>
        public FitnessEquipmentState? GetFitnessEquipmentState()
        {
            return (FitnessEquipmentState?)GetFieldValue(3, 0, DataSubfield.FitnessEquipmentState);
        }

        /// <summary>
        ///
        /// Set FitnessEquipmentState subfield</summary>
        /// <param name="fitnessEquipmentState">Subfield value to be set</param>
        public void SetFitnessEquipmentState(byte? fitnessEquipmentState)
        {
            SetFieldValue(3, 0, fitnessEquipmentState, DataSubfield.FitnessEquipmentState);
        }

        /// <summary>
        /// Retrieves the SportPoint subfield</summary>
        /// <returns>Nullable uint representing the SportPoint subfield</returns>
        public uint? GetSportPoint()
        {
            Object val = GetFieldValue(3, 0, DataSubfield.SportPoint);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToUInt32(val));
            
        }

        /// <summary>
        ///
        /// Set SportPoint subfield</summary>
        /// <param name="sportPoint">Subfield value to be set</param>
        public void SetSportPoint(uint? sportPoint)
        {
            SetFieldValue(3, 0, sportPoint, DataSubfield.SportPoint);
        }

        /// <summary>
        /// Retrieves the GearChangeData subfield</summary>
        /// <returns>Nullable uint representing the GearChangeData subfield</returns>
        public uint? GetGearChangeData()
        {
            Object val = GetFieldValue(3, 0, DataSubfield.GearChangeData);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToUInt32(val));
            
        }

        /// <summary>
        ///
        /// Set GearChangeData subfield</summary>
        /// <param name="gearChangeData">Subfield value to be set</param>
        public void SetGearChangeData(uint? gearChangeData)
        {
            SetFieldValue(3, 0, gearChangeData, DataSubfield.GearChangeData);
        }

        /// <summary>
        /// Retrieves the RiderPosition subfield
        /// Comment: Indicates the rider position value.</summary>
        /// <returns>Nullable RiderPositionType enum representing the RiderPosition subfield</returns>
        public RiderPositionType? GetRiderPosition()
        {
            return (RiderPositionType?)GetFieldValue(3, 0, DataSubfield.RiderPosition);
        }

        /// <summary>
        ///
        /// Set RiderPosition subfield
        /// Comment: Indicates the rider position value.</summary>
        /// <param name="riderPosition">Subfield value to be set</param>
        public void SetRiderPosition(byte? riderPosition)
        {
            SetFieldValue(3, 0, riderPosition, DataSubfield.RiderPosition);
        }

        /// <summary>
        /// Retrieves the CommTimeout subfield</summary>
        /// <returns>Nullable ushort representing the CommTimeout subfield</returns>
        public ushort? GetCommTimeout()
        {
            Object val = GetFieldValue(3, 0, DataSubfield.CommTimeout);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToUInt16(val));
            
        }

        /// <summary>
        ///
        /// Set CommTimeout subfield</summary>
        /// <param name="commTimeout">Subfield value to be set</param>
        public void SetCommTimeout(ushort? commTimeout)
        {
            SetFieldValue(3, 0, commTimeout, DataSubfield.CommTimeout);
        }

        /// <summary>
        /// Retrieves the RadarThreatAlert subfield
        /// Comment: TheÂ firstÂ byteÂ isÂ theÂ radar_threat_level_max, theÂ secondÂ byteÂ isÂ theÂ radar_threat_count, and theÂ lastÂ 16Â bitsÂ areÂ reservedÂ forÂ futureÂ useÂ andÂ shouldÂ beÂ setÂ toÂ FFFF.</summary>
        /// <returns>Nullable uint representing the RadarThreatAlert subfield</returns>
        public uint? GetRadarThreatAlert()
        {
            Object val = GetFieldValue(3, 0, DataSubfield.RadarThreatAlert);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToUInt32(val));
            
        }

        /// <summary>
        ///
        /// Set RadarThreatAlert subfield
        /// Comment: TheÂ firstÂ byteÂ isÂ theÂ radar_threat_level_max, theÂ secondÂ byteÂ isÂ theÂ radar_threat_count, and theÂ lastÂ 16Â bitsÂ areÂ reservedÂ forÂ futureÂ useÂ andÂ shouldÂ beÂ setÂ toÂ FFFF.</summary>
        /// <param name="radarThreatAlert">Subfield value to be set</param>
        public void SetRadarThreatAlert(uint? radarThreatAlert)
        {
            SetFieldValue(3, 0, radarThreatAlert, DataSubfield.RadarThreatAlert);
        }
        ///<summary>
        /// Retrieves the EventGroup field</summary>
        /// <returns>Returns nullable byte representing the EventGroup field</returns>
        public byte? GetEventGroup()
        {
            Object val = GetFieldValue(4, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToByte(val));
            
        }

        /// <summary>
        /// Set EventGroup field</summary>
        /// <param name="eventGroup_">Nullable field value to be set</param>
        public void SetEventGroup(byte? eventGroup_)
        {
            SetFieldValue(4, 0, eventGroup_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the Score field
        /// Comment: Do not populate directly. Autogenerated by decoder for sport_point subfield components</summary>
        /// <returns>Returns nullable ushort representing the Score field</returns>
        public ushort? GetScore()
        {
            Object val = GetFieldValue(7, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToUInt16(val));
            
        }

        /// <summary>
        /// Set Score field
        /// Comment: Do not populate directly. Autogenerated by decoder for sport_point subfield components</summary>
        /// <param name="score_">Nullable field value to be set</param>
        public void SetScore(ushort? score_)
        {
            SetFieldValue(7, 0, score_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the OpponentScore field
        /// Comment: Do not populate directly. Autogenerated by decoder for sport_point subfield components</summary>
        /// <returns>Returns nullable ushort representing the OpponentScore field</returns>
        public ushort? GetOpponentScore()
        {
            Object val = GetFieldValue(8, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToUInt16(val));
            
        }

        /// <summary>
        /// Set OpponentScore field
        /// Comment: Do not populate directly. Autogenerated by decoder for sport_point subfield components</summary>
        /// <param name="opponentScore_">Nullable field value to be set</param>
        public void SetOpponentScore(ushort? opponentScore_)
        {
            SetFieldValue(8, 0, opponentScore_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the FrontGearNum field
        /// Comment: Do not populate directly. Autogenerated by decoder for gear_change subfield components.  Front gear number. 1 is innermost.</summary>
        /// <returns>Returns nullable byte representing the FrontGearNum field</returns>
        public byte? GetFrontGearNum()
        {
            Object val = GetFieldValue(9, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToByte(val));
            
        }

        /// <summary>
        /// Set FrontGearNum field
        /// Comment: Do not populate directly. Autogenerated by decoder for gear_change subfield components.  Front gear number. 1 is innermost.</summary>
        /// <param name="frontGearNum_">Nullable field value to be set</param>
        public void SetFrontGearNum(byte? frontGearNum_)
        {
            SetFieldValue(9, 0, frontGearNum_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the FrontGear field
        /// Comment: Do not populate directly. Autogenerated by decoder for gear_change subfield components.  Number of front teeth.</summary>
        /// <returns>Returns nullable byte representing the FrontGear field</returns>
        public byte? GetFrontGear()
        {
            Object val = GetFieldValue(10, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToByte(val));
            
        }

        /// <summary>
        /// Set FrontGear field
        /// Comment: Do not populate directly. Autogenerated by decoder for gear_change subfield components.  Number of front teeth.</summary>
        /// <param name="frontGear_">Nullable field value to be set</param>
        public void SetFrontGear(byte? frontGear_)
        {
            SetFieldValue(10, 0, frontGear_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the RearGearNum field
        /// Comment: Do not populate directly. Autogenerated by decoder for gear_change subfield components.  Rear gear number. 1 is innermost.</summary>
        /// <returns>Returns nullable byte representing the RearGearNum field</returns>
        public byte? GetRearGearNum()
        {
            Object val = GetFieldValue(11, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToByte(val));
            
        }

        /// <summary>
        /// Set RearGearNum field
        /// Comment: Do not populate directly. Autogenerated by decoder for gear_change subfield components.  Rear gear number. 1 is innermost.</summary>
        /// <param name="rearGearNum_">Nullable field value to be set</param>
        public void SetRearGearNum(byte? rearGearNum_)
        {
            SetFieldValue(11, 0, rearGearNum_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the RearGear field
        /// Comment: Do not populate directly. Autogenerated by decoder for gear_change subfield components.  Number of rear teeth.</summary>
        /// <returns>Returns nullable byte representing the RearGear field</returns>
        public byte? GetRearGear()
        {
            Object val = GetFieldValue(12, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToByte(val));
            
        }

        /// <summary>
        /// Set RearGear field
        /// Comment: Do not populate directly. Autogenerated by decoder for gear_change subfield components.  Number of rear teeth.</summary>
        /// <param name="rearGear_">Nullable field value to be set</param>
        public void SetRearGear(byte? rearGear_)
        {
            SetFieldValue(12, 0, rearGear_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the DeviceIndex field</summary>
        /// <returns>Returns nullable byte representing the DeviceIndex field</returns>
        public byte? GetDeviceIndex()
        {
            Object val = GetFieldValue(13, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToByte(val));
            
        }

        /// <summary>
        /// Set DeviceIndex field</summary>
        /// <param name="deviceIndex_">Nullable field value to be set</param>
        public void SetDeviceIndex(byte? deviceIndex_)
        {
            SetFieldValue(13, 0, deviceIndex_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the RadarThreatLevelMax field
        /// Comment: Do not populate directly. Autogenerated by decoder for threat_alert subfield components.</summary>
        /// <returns>Returns nullable RadarThreatLevelType enum representing the RadarThreatLevelMax field</returns>
        public RadarThreatLevelType? GetRadarThreatLevelMax()
        {
            object obj = GetFieldValue(21, 0, Fit.SubfieldIndexMainField);
            RadarThreatLevelType? value = obj == null ? (RadarThreatLevelType?)null : (RadarThreatLevelType)obj;
            return value;
        }

        /// <summary>
        /// Set RadarThreatLevelMax field
        /// Comment: Do not populate directly. Autogenerated by decoder for threat_alert subfield components.</summary>
        /// <param name="radarThreatLevelMax_">Nullable field value to be set</param>
        public void SetRadarThreatLevelMax(RadarThreatLevelType? radarThreatLevelMax_)
        {
            SetFieldValue(21, 0, radarThreatLevelMax_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the RadarThreatCount field
        /// Comment: Do not populate directly. Autogenerated by decoder for threat_alert subfield components.</summary>
        /// <returns>Returns nullable byte representing the RadarThreatCount field</returns>
        public byte? GetRadarThreatCount()
        {
            Object val = GetFieldValue(22, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToByte(val));
            
        }

        /// <summary>
        /// Set RadarThreatCount field
        /// Comment: Do not populate directly. Autogenerated by decoder for threat_alert subfield components.</summary>
        /// <param name="radarThreatCount_">Nullable field value to be set</param>
        public void SetRadarThreatCount(byte? radarThreatCount_)
        {
            SetFieldValue(22, 0, radarThreatCount_, Fit.SubfieldIndexMainField);
        }
        
        #endregion // Methods
    } // Class
} // namespace
