#region Copyright
////////////////////////////////////////////////////////////////////////////////
// The following FIT Protocol software provided may be used with FIT protocol
// devices only and remains the copyrighted property of Garmin Canada Inc.
// The software is being provided on an "as-is" basis and as an accommodation,
// and therefore all warranties, representations, or guarantees of any kind
// (whether express, implied or statutory) including, without limitation,
// warranties of merchantability, non-infringement, or fitness for a particular
// purpose, are specifically disclaimed.
//
// Copyright 2020 Garmin Canada Inc.
////////////////////////////////////////////////////////////////////////////////
// ****WARNING****  This file is auto-generated!  Do NOT edit this file.
// Profile Version = 21.38Release
// Tag = production/akw/21.38.00-0-g0d69e49
////////////////////////////////////////////////////////////////////////////////

#endregion

using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Text;
using System.IO;
using System.Linq;

namespace Dynastream.Fit
{
    /// <summary>
    /// Implements the DiveSummary profile message.
    /// </summary>
    public class DiveSummaryMesg : Mesg
    {
        #region Fields
        #endregion

        /// <summary>
        /// Field Numbers for <see cref="DiveSummaryMesg"/>
        /// </summary>
        public sealed class FieldDefNum
        {
            public const byte Timestamp = 253;
            public const byte ReferenceMesg = 0;
            public const byte ReferenceIndex = 1;
            public const byte AvgDepth = 2;
            public const byte MaxDepth = 3;
            public const byte SurfaceInterval = 4;
            public const byte StartCns = 5;
            public const byte EndCns = 6;
            public const byte StartN2 = 7;
            public const byte EndN2 = 8;
            public const byte O2Toxicity = 9;
            public const byte DiveNumber = 10;
            public const byte BottomTime = 11;
            public const byte Invalid = Fit.FieldNumInvalid;
        }

        #region Constructors
        public DiveSummaryMesg() : base(Profile.GetMesg(MesgNum.DiveSummary))
        {
        }

        public DiveSummaryMesg(Mesg mesg) : base(mesg)
        {
        }
        #endregion // Constructors

        #region Methods
        ///<summary>
        /// Retrieves the Timestamp field
        /// Units: s</summary>
        /// <returns>Returns DateTime representing the Timestamp field</returns>
        public DateTime GetTimestamp()
        {
            Object val = GetFieldValue(253, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return TimestampToDateTime(Convert.ToUInt32(val));
            
        }

        /// <summary>
        /// Set Timestamp field
        /// Units: s</summary>
        /// <param name="timestamp_">Nullable field value to be set</param>
        public void SetTimestamp(DateTime timestamp_)
        {
            SetFieldValue(253, 0, timestamp_.GetTimeStamp(), Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the ReferenceMesg field</summary>
        /// <returns>Returns nullable ushort representing the ReferenceMesg field</returns>
        public ushort? GetReferenceMesg()
        {
            Object val = GetFieldValue(0, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToUInt16(val));
            
        }

        /// <summary>
        /// Set ReferenceMesg field</summary>
        /// <param name="referenceMesg_">Nullable field value to be set</param>
        public void SetReferenceMesg(ushort? referenceMesg_)
        {
            SetFieldValue(0, 0, referenceMesg_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the ReferenceIndex field</summary>
        /// <returns>Returns nullable ushort representing the ReferenceIndex field</returns>
        public ushort? GetReferenceIndex()
        {
            Object val = GetFieldValue(1, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToUInt16(val));
            
        }

        /// <summary>
        /// Set ReferenceIndex field</summary>
        /// <param name="referenceIndex_">Nullable field value to be set</param>
        public void SetReferenceIndex(ushort? referenceIndex_)
        {
            SetFieldValue(1, 0, referenceIndex_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the AvgDepth field
        /// Units: m
        /// Comment: 0 if above water</summary>
        /// <returns>Returns nullable float representing the AvgDepth field</returns>
        public float? GetAvgDepth()
        {
            Object val = GetFieldValue(2, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set AvgDepth field
        /// Units: m
        /// Comment: 0 if above water</summary>
        /// <param name="avgDepth_">Nullable field value to be set</param>
        public void SetAvgDepth(float? avgDepth_)
        {
            SetFieldValue(2, 0, avgDepth_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the MaxDepth field
        /// Units: m
        /// Comment: 0 if above water</summary>
        /// <returns>Returns nullable float representing the MaxDepth field</returns>
        public float? GetMaxDepth()
        {
            Object val = GetFieldValue(3, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set MaxDepth field
        /// Units: m
        /// Comment: 0 if above water</summary>
        /// <param name="maxDepth_">Nullable field value to be set</param>
        public void SetMaxDepth(float? maxDepth_)
        {
            SetFieldValue(3, 0, maxDepth_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the SurfaceInterval field
        /// Units: s
        /// Comment: Time since end of last dive</summary>
        /// <returns>Returns nullable uint representing the SurfaceInterval field</returns>
        public uint? GetSurfaceInterval()
        {
            Object val = GetFieldValue(4, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToUInt32(val));
            
        }

        /// <summary>
        /// Set SurfaceInterval field
        /// Units: s
        /// Comment: Time since end of last dive</summary>
        /// <param name="surfaceInterval_">Nullable field value to be set</param>
        public void SetSurfaceInterval(uint? surfaceInterval_)
        {
            SetFieldValue(4, 0, surfaceInterval_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the StartCns field
        /// Units: percent</summary>
        /// <returns>Returns nullable byte representing the StartCns field</returns>
        public byte? GetStartCns()
        {
            Object val = GetFieldValue(5, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToByte(val));
            
        }

        /// <summary>
        /// Set StartCns field
        /// Units: percent</summary>
        /// <param name="startCns_">Nullable field value to be set</param>
        public void SetStartCns(byte? startCns_)
        {
            SetFieldValue(5, 0, startCns_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the EndCns field
        /// Units: percent</summary>
        /// <returns>Returns nullable byte representing the EndCns field</returns>
        public byte? GetEndCns()
        {
            Object val = GetFieldValue(6, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToByte(val));
            
        }

        /// <summary>
        /// Set EndCns field
        /// Units: percent</summary>
        /// <param name="endCns_">Nullable field value to be set</param>
        public void SetEndCns(byte? endCns_)
        {
            SetFieldValue(6, 0, endCns_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the StartN2 field
        /// Units: percent</summary>
        /// <returns>Returns nullable ushort representing the StartN2 field</returns>
        public ushort? GetStartN2()
        {
            Object val = GetFieldValue(7, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToUInt16(val));
            
        }

        /// <summary>
        /// Set StartN2 field
        /// Units: percent</summary>
        /// <param name="startN2_">Nullable field value to be set</param>
        public void SetStartN2(ushort? startN2_)
        {
            SetFieldValue(7, 0, startN2_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the EndN2 field
        /// Units: percent</summary>
        /// <returns>Returns nullable ushort representing the EndN2 field</returns>
        public ushort? GetEndN2()
        {
            Object val = GetFieldValue(8, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToUInt16(val));
            
        }

        /// <summary>
        /// Set EndN2 field
        /// Units: percent</summary>
        /// <param name="endN2_">Nullable field value to be set</param>
        public void SetEndN2(ushort? endN2_)
        {
            SetFieldValue(8, 0, endN2_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the O2Toxicity field
        /// Units: OTUs</summary>
        /// <returns>Returns nullable ushort representing the O2Toxicity field</returns>
        public ushort? GetO2Toxicity()
        {
            Object val = GetFieldValue(9, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToUInt16(val));
            
        }

        /// <summary>
        /// Set O2Toxicity field
        /// Units: OTUs</summary>
        /// <param name="o2Toxicity_">Nullable field value to be set</param>
        public void SetO2Toxicity(ushort? o2Toxicity_)
        {
            SetFieldValue(9, 0, o2Toxicity_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the DiveNumber field</summary>
        /// <returns>Returns nullable uint representing the DiveNumber field</returns>
        public uint? GetDiveNumber()
        {
            Object val = GetFieldValue(10, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToUInt32(val));
            
        }

        /// <summary>
        /// Set DiveNumber field</summary>
        /// <param name="diveNumber_">Nullable field value to be set</param>
        public void SetDiveNumber(uint? diveNumber_)
        {
            SetFieldValue(10, 0, diveNumber_, Fit.SubfieldIndexMainField);
        }
        
        ///<summary>
        /// Retrieves the BottomTime field
        /// Units: s</summary>
        /// <returns>Returns nullable float representing the BottomTime field</returns>
        public float? GetBottomTime()
        {
            Object val = GetFieldValue(11, 0, Fit.SubfieldIndexMainField);
            if(val == null)
            {
                return null;
            }

            return (Convert.ToSingle(val));
            
        }

        /// <summary>
        /// Set BottomTime field
        /// Units: s</summary>
        /// <param name="bottomTime_">Nullable field value to be set</param>
        public void SetBottomTime(float? bottomTime_)
        {
            SetFieldValue(11, 0, bottomTime_, Fit.SubfieldIndexMainField);
        }
        
        #endregion // Methods
    } // Class
} // namespace
