#region Copyright
////////////////////////////////////////////////////////////////////////////////
// The following FIT Protocol software provided may be used with FIT protocol
// devices only and remains the copyrighted property of Garmin Canada Inc.
// The software is being provided on an "as-is" basis and as an accommodation,
// and therefore all warranties, representations, or guarantees of any kind
// (whether express, implied or statutory) including, without limitation,
// warranties of merchantability, non-infringement, or fitness for a particular
// purpose, are specifically disclaimed.
//
// Copyright 2020 Garmin Canada Inc.
////////////////////////////////////////////////////////////////////////////////
// ****WARNING****  This file is auto-generated!  Do NOT edit this file.
// Profile Version = 21.38Release
// Tag = production/akw/21.38.00-0-g0d69e49
////////////////////////////////////////////////////////////////////////////////

#endregion

using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Text;
using System.IO;

namespace Dynastream.Fit
{
    /// <summary>
    /// Represents the Fit Profile including message, field and type definition.
    /// </summary>
    public static class Profile
    {
        #region Nested Types

        public enum Type
        {
            Enum,
            Sint8,
            Uint8,
            Sint16,
            Uint16,
            Sint32,
            Uint32,
            String,
            Float32,
            Float64,
            Uint8z,
            Uint16z,
            Uint32z,
            Byte,
            Sint64,
            Uint64,
            Uint64z,
            Bool,
            File,
            MesgNum,
            Checksum,
            FileFlags,
            MesgCount,
            DateTime,
            LocalDateTime,
            MessageIndex,
            DeviceIndex,
            Gender,
            Language,
            LanguageBits0,
            LanguageBits1,
            LanguageBits2,
            LanguageBits3,
            LanguageBits4,
            TimeZone,
            DisplayMeasure,
            DisplayHeart,
            DisplayPower,
            DisplayPosition,
            Switch,
            Sport,
            SportBits0,
            SportBits1,
            SportBits2,
            SportBits3,
            SportBits4,
            SportBits5,
            SportBits6,
            SubSport,
            SportEvent,
            Activity,
            Intensity,
            SessionTrigger,
            AutolapTrigger,
            LapTrigger,
            TimeMode,
            BacklightMode,
            DateMode,
            BacklightTimeout,
            Event,
            EventType,
            TimerTrigger,
            FitnessEquipmentState,
            Tone,
            Autoscroll,
            ActivityClass,
            HrZoneCalc,
            PwrZoneCalc,
            WktStepDuration,
            WktStepTarget,
            Goal,
            GoalRecurrence,
            GoalSource,
            Schedule,
            CoursePoint,
            Manufacturer,
            GarminProduct,
            AntplusDeviceType,
            AntNetwork,
            WorkoutCapabilities,
            BatteryStatus,
            HrType,
            CourseCapabilities,
            Weight,
            WorkoutHr,
            WorkoutPower,
            BpStatus,
            UserLocalId,
            SwimStroke,
            ActivityType,
            ActivitySubtype,
            ActivityLevel,
            Side,
            LeftRightBalance,
            LeftRightBalance100,
            LengthType,
            DayOfWeek,
            ConnectivityCapabilities,
            WeatherReport,
            WeatherStatus,
            WeatherSeverity,
            WeatherSevereType,
            TimeIntoDay,
            LocaltimeIntoDay,
            StrokeType,
            BodyLocation,
            SegmentLapStatus,
            SegmentLeaderboardType,
            SegmentDeleteStatus,
            SegmentSelectionType,
            SourceType,
            LocalDeviceType,
            DisplayOrientation,
            WorkoutEquipment,
            WatchfaceMode,
            DigitalWatchfaceLayout,
            AnalogWatchfaceLayout,
            RiderPositionType,
            PowerPhaseType,
            CameraEventType,
            SensorType,
            BikeLightNetworkConfigType,
            CommTimeoutType,
            CameraOrientationType,
            AttitudeStage,
            AttitudeValidity,
            AutoSyncFrequency,
            ExdLayout,
            ExdDisplayType,
            ExdDataUnits,
            ExdQualifiers,
            ExdDescriptors,
            AutoActivityDetect,
            SupportedExdScreenLayouts,
            FitBaseType,
            TurnType,
            BikeLightBeamAngleMode,
            FitBaseUnit,
            SetType,
            ExerciseCategory,
            BenchPressExerciseName,
            CalfRaiseExerciseName,
            CardioExerciseName,
            CarryExerciseName,
            ChopExerciseName,
            CoreExerciseName,
            CrunchExerciseName,
            CurlExerciseName,
            DeadliftExerciseName,
            FlyeExerciseName,
            HipRaiseExerciseName,
            HipStabilityExerciseName,
            HipSwingExerciseName,
            HyperextensionExerciseName,
            LateralRaiseExerciseName,
            LegCurlExerciseName,
            LegRaiseExerciseName,
            LungeExerciseName,
            OlympicLiftExerciseName,
            PlankExerciseName,
            PlyoExerciseName,
            PullUpExerciseName,
            PushUpExerciseName,
            RowExerciseName,
            ShoulderPressExerciseName,
            ShoulderStabilityExerciseName,
            ShrugExerciseName,
            SitUpExerciseName,
            SquatExerciseName,
            TotalBodyExerciseName,
            TricepsExtensionExerciseName,
            WarmUpExerciseName,
            RunExerciseName,
            WaterType,
            TissueModelType,
            DiveGasStatus,
            DiveAlarmType,
            DiveBacklightMode,
            FaveroProduct,
            ClimbProEvent,
            TapSensitivity,
            RadarThreatLevelType,
            
            NumTypes
        }

        #endregion

        #region Fields

        private static readonly Dictionary<ushort, Mesg> m_mesgLookup = new Dictionary<ushort, Mesg>();

        #endregion // Fields

        #region Properties

        #endregion

        #region Constructors

        #endregion

        #region Methods
        public static Mesg GetMesg(ushort globalMesgNum)
        {
            Mesg mesg = LookupMesg(globalMesgNum);

            if(null != mesg)
            {
                return mesg;
            }

            return new Mesg("unknown", globalMesgNum);
        }

        public static Field GetField(ushort globalMesgNum, byte fieldNum)
        {
            Mesg mesg = LookupMesg(globalMesgNum);

            if(null != mesg)
            {
                return mesg.GetField(fieldNum);
            }

            return new Field("unknown", fieldNum, 0, 1, 0, "", false, Type.Enum);
        }

        public static Field GetField(ushort globalMesgNum, string fieldName)
        {
            Mesg mesg = LookupMesg(globalMesgNum);

            if(null != mesg)
            {
                return mesg.GetField(fieldName);
            }

            return null;
        }

        private static Mesg LookupMesg(ushort globalMesgNum)
        {
            Mesg rv = null;
            if(!m_mesgLookup.ContainsKey(globalMesgNum))
            {
                // Maybe it isnt in the lookup because we haven't initialized it
                // yet
                InitMesg(globalMesgNum);
            }

            return m_mesgLookup.TryGetValue(globalMesgNum, out rv) ? rv : null;
        }

        private static void InitMesg(ushort num)
        {
            Mesg newMesg = null;
            if(m_mesgLookup.ContainsKey(num))
            {
                // Message has already been initialized
                return;
            }

            switch(num)
            {
                case MesgNum.FileId:
                    newMesg = CreateFileIdMesg();
                    break;
                
                case MesgNum.FileCreator:
                    newMesg = CreateFileCreatorMesg();
                    break;
                
                case MesgNum.TimestampCorrelation:
                    newMesg = CreateTimestampCorrelationMesg();
                    break;
                
                case MesgNum.Software:
                    newMesg = CreateSoftwareMesg();
                    break;
                
                case MesgNum.SlaveDevice:
                    newMesg = CreateSlaveDeviceMesg();
                    break;
                
                case MesgNum.Capabilities:
                    newMesg = CreateCapabilitiesMesg();
                    break;
                
                case MesgNum.FileCapabilities:
                    newMesg = CreateFileCapabilitiesMesg();
                    break;
                
                case MesgNum.MesgCapabilities:
                    newMesg = CreateMesgCapabilitiesMesg();
                    break;
                
                case MesgNum.FieldCapabilities:
                    newMesg = CreateFieldCapabilitiesMesg();
                    break;
                
                case MesgNum.DeviceSettings:
                    newMesg = CreateDeviceSettingsMesg();
                    break;
                
                case MesgNum.UserProfile:
                    newMesg = CreateUserProfileMesg();
                    break;
                
                case MesgNum.HrmProfile:
                    newMesg = CreateHrmProfileMesg();
                    break;
                
                case MesgNum.SdmProfile:
                    newMesg = CreateSdmProfileMesg();
                    break;
                
                case MesgNum.BikeProfile:
                    newMesg = CreateBikeProfileMesg();
                    break;
                
                case MesgNum.Connectivity:
                    newMesg = CreateConnectivityMesg();
                    break;
                
                case MesgNum.WatchfaceSettings:
                    newMesg = CreateWatchfaceSettingsMesg();
                    break;
                
                case MesgNum.OhrSettings:
                    newMesg = CreateOhrSettingsMesg();
                    break;
                
                case MesgNum.ZonesTarget:
                    newMesg = CreateZonesTargetMesg();
                    break;
                
                case MesgNum.Sport:
                    newMesg = CreateSportMesg();
                    break;
                
                case MesgNum.HrZone:
                    newMesg = CreateHrZoneMesg();
                    break;
                
                case MesgNum.SpeedZone:
                    newMesg = CreateSpeedZoneMesg();
                    break;
                
                case MesgNum.CadenceZone:
                    newMesg = CreateCadenceZoneMesg();
                    break;
                
                case MesgNum.PowerZone:
                    newMesg = CreatePowerZoneMesg();
                    break;
                
                case MesgNum.MetZone:
                    newMesg = CreateMetZoneMesg();
                    break;
                
                case MesgNum.DiveSettings:
                    newMesg = CreateDiveSettingsMesg();
                    break;
                
                case MesgNum.DiveAlarm:
                    newMesg = CreateDiveAlarmMesg();
                    break;
                
                case MesgNum.DiveGas:
                    newMesg = CreateDiveGasMesg();
                    break;
                
                case MesgNum.Goal:
                    newMesg = CreateGoalMesg();
                    break;
                
                case MesgNum.Activity:
                    newMesg = CreateActivityMesg();
                    break;
                
                case MesgNum.Session:
                    newMesg = CreateSessionMesg();
                    break;
                
                case MesgNum.Lap:
                    newMesg = CreateLapMesg();
                    break;
                
                case MesgNum.Length:
                    newMesg = CreateLengthMesg();
                    break;
                
                case MesgNum.Record:
                    newMesg = CreateRecordMesg();
                    break;
                
                case MesgNum.Event:
                    newMesg = CreateEventMesg();
                    break;
                
                case MesgNum.DeviceInfo:
                    newMesg = CreateDeviceInfoMesg();
                    break;
                
                case MesgNum.TrainingFile:
                    newMesg = CreateTrainingFileMesg();
                    break;
                
                case MesgNum.Hrv:
                    newMesg = CreateHrvMesg();
                    break;
                
                case MesgNum.WeatherConditions:
                    newMesg = CreateWeatherConditionsMesg();
                    break;
                
                case MesgNum.WeatherAlert:
                    newMesg = CreateWeatherAlertMesg();
                    break;
                
                case MesgNum.GpsMetadata:
                    newMesg = CreateGpsMetadataMesg();
                    break;
                
                case MesgNum.CameraEvent:
                    newMesg = CreateCameraEventMesg();
                    break;
                
                case MesgNum.GyroscopeData:
                    newMesg = CreateGyroscopeDataMesg();
                    break;
                
                case MesgNum.AccelerometerData:
                    newMesg = CreateAccelerometerDataMesg();
                    break;
                
                case MesgNum.MagnetometerData:
                    newMesg = CreateMagnetometerDataMesg();
                    break;
                
                case MesgNum.BarometerData:
                    newMesg = CreateBarometerDataMesg();
                    break;
                
                case MesgNum.ThreeDSensorCalibration:
                    newMesg = CreateThreeDSensorCalibrationMesg();
                    break;
                
                case MesgNum.OneDSensorCalibration:
                    newMesg = CreateOneDSensorCalibrationMesg();
                    break;
                
                case MesgNum.VideoFrame:
                    newMesg = CreateVideoFrameMesg();
                    break;
                
                case MesgNum.ObdiiData:
                    newMesg = CreateObdiiDataMesg();
                    break;
                
                case MesgNum.NmeaSentence:
                    newMesg = CreateNmeaSentenceMesg();
                    break;
                
                case MesgNum.AviationAttitude:
                    newMesg = CreateAviationAttitudeMesg();
                    break;
                
                case MesgNum.Video:
                    newMesg = CreateVideoMesg();
                    break;
                
                case MesgNum.VideoTitle:
                    newMesg = CreateVideoTitleMesg();
                    break;
                
                case MesgNum.VideoDescription:
                    newMesg = CreateVideoDescriptionMesg();
                    break;
                
                case MesgNum.VideoClip:
                    newMesg = CreateVideoClipMesg();
                    break;
                
                case MesgNum.Set:
                    newMesg = CreateSetMesg();
                    break;
                
                case MesgNum.Jump:
                    newMesg = CreateJumpMesg();
                    break;
                
                case MesgNum.Course:
                    newMesg = CreateCourseMesg();
                    break;
                
                case MesgNum.CoursePoint:
                    newMesg = CreateCoursePointMesg();
                    break;
                
                case MesgNum.SegmentId:
                    newMesg = CreateSegmentIdMesg();
                    break;
                
                case MesgNum.SegmentLeaderboardEntry:
                    newMesg = CreateSegmentLeaderboardEntryMesg();
                    break;
                
                case MesgNum.SegmentPoint:
                    newMesg = CreateSegmentPointMesg();
                    break;
                
                case MesgNum.SegmentLap:
                    newMesg = CreateSegmentLapMesg();
                    break;
                
                case MesgNum.SegmentFile:
                    newMesg = CreateSegmentFileMesg();
                    break;
                
                case MesgNum.Workout:
                    newMesg = CreateWorkoutMesg();
                    break;
                
                case MesgNum.WorkoutSession:
                    newMesg = CreateWorkoutSessionMesg();
                    break;
                
                case MesgNum.WorkoutStep:
                    newMesg = CreateWorkoutStepMesg();
                    break;
                
                case MesgNum.ExerciseTitle:
                    newMesg = CreateExerciseTitleMesg();
                    break;
                
                case MesgNum.Schedule:
                    newMesg = CreateScheduleMesg();
                    break;
                
                case MesgNum.Totals:
                    newMesg = CreateTotalsMesg();
                    break;
                
                case MesgNum.WeightScale:
                    newMesg = CreateWeightScaleMesg();
                    break;
                
                case MesgNum.BloodPressure:
                    newMesg = CreateBloodPressureMesg();
                    break;
                
                case MesgNum.MonitoringInfo:
                    newMesg = CreateMonitoringInfoMesg();
                    break;
                
                case MesgNum.Monitoring:
                    newMesg = CreateMonitoringMesg();
                    break;
                
                case MesgNum.Hr:
                    newMesg = CreateHrMesg();
                    break;
                
                case MesgNum.StressLevel:
                    newMesg = CreateStressLevelMesg();
                    break;
                
                case MesgNum.MemoGlob:
                    newMesg = CreateMemoGlobMesg();
                    break;
                
                case MesgNum.AntChannelId:
                    newMesg = CreateAntChannelIdMesg();
                    break;
                
                case MesgNum.AntRx:
                    newMesg = CreateAntRxMesg();
                    break;
                
                case MesgNum.AntTx:
                    newMesg = CreateAntTxMesg();
                    break;
                
                case MesgNum.ExdScreenConfiguration:
                    newMesg = CreateExdScreenConfigurationMesg();
                    break;
                
                case MesgNum.ExdDataFieldConfiguration:
                    newMesg = CreateExdDataFieldConfigurationMesg();
                    break;
                
                case MesgNum.ExdDataConceptConfiguration:
                    newMesg = CreateExdDataConceptConfigurationMesg();
                    break;
                
                case MesgNum.FieldDescription:
                    newMesg = CreateFieldDescriptionMesg();
                    break;
                
                case MesgNum.DeveloperDataId:
                    newMesg = CreateDeveloperDataIdMesg();
                    break;
                
                case MesgNum.DiveSummary:
                    newMesg = CreateDiveSummaryMesg();
                    break;
                
                case MesgNum.ClimbPro:
                    newMesg = CreateClimbProMesg();
                    break;
                
                case MesgNum.Pad:
                    newMesg = CreatePadMesg();
                    break;
                
                default:
                    break;
            }

            if(null != newMesg)
            {
                lock(m_mesgLookup)
                {
                    // Make Sure another thread didn't get here first
                    if(!m_mesgLookup.ContainsKey(num))
                    {
                        m_mesgLookup.Add(num, newMesg);
                    }
                }
            }
        }

        #pragma warning disable 0168
        #pragma warning disable 0219
        private static Mesg CreateFileIdMesg()
        {
            ushort fieldIndex, subfieldIndex;
            Mesg newMesg = new Mesg("FileId", MesgNum.FileId);
            fieldIndex = 0;
            newMesg.SetField(new Field("Type", 0, 0, 1, 0, "", false, Type.File));
            fieldIndex++;
            newMesg.SetField(new Field("Manufacturer", 1, 132, 1, 0, "", false, Type.Manufacturer));
            fieldIndex++;
            newMesg.SetField(new Field("Product", 2, 132, 1, 0, "", false, Type.Uint16));
            subfieldIndex = 0;
            newMesg.FieldsList[fieldIndex].subfields.Add(new Subfield("FaveroProduct", 132, 1, 0, ""));
            newMesg.FieldsList[fieldIndex].subfields[subfieldIndex].AddMap(1, 263);
            subfieldIndex++;
            newMesg.FieldsList[fieldIndex].subfields.Add(new Subfield("GarminProduct", 132, 1, 0, ""));
            newMesg.FieldsList[fieldIndex].subfields[subfieldIndex].AddMap(1, 1);
            newMesg.FieldsList[fieldIndex].subfields[subfieldIndex].AddMap(1, 15);
            newMesg.FieldsList[fieldIndex].subfields[subfieldIndex].AddMap(1, 13);
            newMesg.FieldsList[fieldIndex].subfields[subfieldIndex].AddMap(1, 89);
            subfieldIndex++;
            fieldIndex++;
            newMesg.SetField(new Field("SerialNumber", 3, 140, 1, 0, "", false, Type.Uint32z));
            fieldIndex++;
            newMesg.SetField(new Field("TimeCreated", 4, 134, 1, 0, "", false, Type.DateTime));
            fieldIndex++;
            newMesg.SetField(new Field("Number", 5, 132, 1, 0, "", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("ProductName", 8, 7, 1, 0, "", false, Type.String));
            fieldIndex++;

            return newMesg;
        }
        
        private static Mesg CreateFileCreatorMesg()
        {
            ushort fieldIndex, subfieldIndex;
            Mesg newMesg = new Mesg("FileCreator", MesgNum.FileCreator);
            fieldIndex = 0;
            newMesg.SetField(new Field("SoftwareVersion", 0, 132, 1, 0, "", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("HardwareVersion", 1, 2, 1, 0, "", false, Type.Uint8));
            fieldIndex++;

            return newMesg;
        }
        
        private static Mesg CreateTimestampCorrelationMesg()
        {
            ushort fieldIndex, subfieldIndex;
            Mesg newMesg = new Mesg("TimestampCorrelation", MesgNum.TimestampCorrelation);
            fieldIndex = 0;
            newMesg.SetField(new Field("Timestamp", 253, 134, 1, 0, "s", false, Type.DateTime));
            fieldIndex++;
            newMesg.SetField(new Field("FractionalTimestamp", 0, 132, 32768, 0, "s", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("SystemTimestamp", 1, 134, 1, 0, "s", false, Type.DateTime));
            fieldIndex++;
            newMesg.SetField(new Field("FractionalSystemTimestamp", 2, 132, 32768, 0, "s", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("LocalTimestamp", 3, 134, 1, 0, "s", false, Type.LocalDateTime));
            fieldIndex++;
            newMesg.SetField(new Field("TimestampMs", 4, 132, 1, 0, "ms", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("SystemTimestampMs", 5, 132, 1, 0, "ms", false, Type.Uint16));
            fieldIndex++;

            return newMesg;
        }
        
        private static Mesg CreateSoftwareMesg()
        {
            ushort fieldIndex, subfieldIndex;
            Mesg newMesg = new Mesg("Software", MesgNum.Software);
            fieldIndex = 0;
            newMesg.SetField(new Field("MessageIndex", 254, 132, 1, 0, "", false, Type.MessageIndex));
            fieldIndex++;
            newMesg.SetField(new Field("Version", 3, 132, 100, 0, "", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("PartNumber", 5, 7, 1, 0, "", false, Type.String));
            fieldIndex++;

            return newMesg;
        }
        
        private static Mesg CreateSlaveDeviceMesg()
        {
            ushort fieldIndex, subfieldIndex;
            Mesg newMesg = new Mesg("SlaveDevice", MesgNum.SlaveDevice);
            fieldIndex = 0;
            newMesg.SetField(new Field("Manufacturer", 0, 132, 1, 0, "", false, Type.Manufacturer));
            fieldIndex++;
            newMesg.SetField(new Field("Product", 1, 132, 1, 0, "", false, Type.Uint16));
            subfieldIndex = 0;
            newMesg.FieldsList[fieldIndex].subfields.Add(new Subfield("FaveroProduct", 132, 1, 0, ""));
            newMesg.FieldsList[fieldIndex].subfields[subfieldIndex].AddMap(0, 263);
            subfieldIndex++;
            newMesg.FieldsList[fieldIndex].subfields.Add(new Subfield("GarminProduct", 132, 1, 0, ""));
            newMesg.FieldsList[fieldIndex].subfields[subfieldIndex].AddMap(0, 1);
            newMesg.FieldsList[fieldIndex].subfields[subfieldIndex].AddMap(0, 15);
            newMesg.FieldsList[fieldIndex].subfields[subfieldIndex].AddMap(0, 13);
            newMesg.FieldsList[fieldIndex].subfields[subfieldIndex].AddMap(0, 89);
            subfieldIndex++;
            fieldIndex++;

            return newMesg;
        }
        
        private static Mesg CreateCapabilitiesMesg()
        {
            ushort fieldIndex, subfieldIndex;
            Mesg newMesg = new Mesg("Capabilities", MesgNum.Capabilities);
            fieldIndex = 0;
            newMesg.SetField(new Field("Languages", 0, 10, 1, 0, "", false, Type.Uint8z));
            fieldIndex++;
            newMesg.SetField(new Field("Sports", 1, 10, 1, 0, "", false, Type.SportBits0));
            fieldIndex++;
            newMesg.SetField(new Field("WorkoutsSupported", 21, 140, 1, 0, "", false, Type.WorkoutCapabilities));
            fieldIndex++;
            newMesg.SetField(new Field("ConnectivitySupported", 23, 140, 1, 0, "", false, Type.ConnectivityCapabilities));
            fieldIndex++;

            return newMesg;
        }
        
        private static Mesg CreateFileCapabilitiesMesg()
        {
            ushort fieldIndex, subfieldIndex;
            Mesg newMesg = new Mesg("FileCapabilities", MesgNum.FileCapabilities);
            fieldIndex = 0;
            newMesg.SetField(new Field("MessageIndex", 254, 132, 1, 0, "", false, Type.MessageIndex));
            fieldIndex++;
            newMesg.SetField(new Field("Type", 0, 0, 1, 0, "", false, Type.File));
            fieldIndex++;
            newMesg.SetField(new Field("Flags", 1, 10, 1, 0, "", false, Type.FileFlags));
            fieldIndex++;
            newMesg.SetField(new Field("Directory", 2, 7, 1, 0, "", false, Type.String));
            fieldIndex++;
            newMesg.SetField(new Field("MaxCount", 3, 132, 1, 0, "", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("MaxSize", 4, 134, 1, 0, "bytes", false, Type.Uint32));
            fieldIndex++;

            return newMesg;
        }
        
        private static Mesg CreateMesgCapabilitiesMesg()
        {
            ushort fieldIndex, subfieldIndex;
            Mesg newMesg = new Mesg("MesgCapabilities", MesgNum.MesgCapabilities);
            fieldIndex = 0;
            newMesg.SetField(new Field("MessageIndex", 254, 132, 1, 0, "", false, Type.MessageIndex));
            fieldIndex++;
            newMesg.SetField(new Field("File", 0, 0, 1, 0, "", false, Type.File));
            fieldIndex++;
            newMesg.SetField(new Field("MesgNum", 1, 132, 1, 0, "", false, Type.MesgNum));
            fieldIndex++;
            newMesg.SetField(new Field("CountType", 2, 0, 1, 0, "", false, Type.MesgCount));
            fieldIndex++;
            newMesg.SetField(new Field("Count", 3, 132, 1, 0, "", false, Type.Uint16));
            subfieldIndex = 0;
            newMesg.FieldsList[fieldIndex].subfields.Add(new Subfield("NumPerFile", 132, 1, 0, ""));
            newMesg.FieldsList[fieldIndex].subfields[subfieldIndex].AddMap(2, 0);
            subfieldIndex++;
            newMesg.FieldsList[fieldIndex].subfields.Add(new Subfield("MaxPerFile", 132, 1, 0, ""));
            newMesg.FieldsList[fieldIndex].subfields[subfieldIndex].AddMap(2, 1);
            subfieldIndex++;
            newMesg.FieldsList[fieldIndex].subfields.Add(new Subfield("MaxPerFileType", 132, 1, 0, ""));
            newMesg.FieldsList[fieldIndex].subfields[subfieldIndex].AddMap(2, 2);
            subfieldIndex++;
            fieldIndex++;

            return newMesg;
        }
        
        private static Mesg CreateFieldCapabilitiesMesg()
        {
            ushort fieldIndex, subfieldIndex;
            Mesg newMesg = new Mesg("FieldCapabilities", MesgNum.FieldCapabilities);
            fieldIndex = 0;
            newMesg.SetField(new Field("MessageIndex", 254, 132, 1, 0, "", false, Type.MessageIndex));
            fieldIndex++;
            newMesg.SetField(new Field("File", 0, 0, 1, 0, "", false, Type.File));
            fieldIndex++;
            newMesg.SetField(new Field("MesgNum", 1, 132, 1, 0, "", false, Type.MesgNum));
            fieldIndex++;
            newMesg.SetField(new Field("FieldNum", 2, 2, 1, 0, "", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("Count", 3, 132, 1, 0, "", false, Type.Uint16));
            fieldIndex++;

            return newMesg;
        }
        
        private static Mesg CreateDeviceSettingsMesg()
        {
            ushort fieldIndex, subfieldIndex;
            Mesg newMesg = new Mesg("DeviceSettings", MesgNum.DeviceSettings);
            fieldIndex = 0;
            newMesg.SetField(new Field("ActiveTimeZone", 0, 2, 1, 0, "", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("UtcOffset", 1, 134, 1, 0, "", false, Type.Uint32));
            fieldIndex++;
            newMesg.SetField(new Field("TimeOffset", 2, 134, 1, 0, "s", false, Type.Uint32));
            fieldIndex++;
            newMesg.SetField(new Field("TimeMode", 4, 0, 1, 0, "", false, Type.TimeMode));
            fieldIndex++;
            newMesg.SetField(new Field("TimeZoneOffset", 5, 1, 4, 0, "hr", false, Type.Sint8));
            fieldIndex++;
            newMesg.SetField(new Field("BacklightMode", 12, 0, 1, 0, "", false, Type.BacklightMode));
            fieldIndex++;
            newMesg.SetField(new Field("ActivityTrackerEnabled", 36, 0, 1, 0, "", false, Type.Bool));
            fieldIndex++;
            newMesg.SetField(new Field("ClockTime", 39, 134, 1, 0, "", false, Type.DateTime));
            fieldIndex++;
            newMesg.SetField(new Field("PagesEnabled", 40, 132, 1, 0, "", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("MoveAlertEnabled", 46, 0, 1, 0, "", false, Type.Bool));
            fieldIndex++;
            newMesg.SetField(new Field("DateMode", 47, 0, 1, 0, "", false, Type.DateMode));
            fieldIndex++;
            newMesg.SetField(new Field("DisplayOrientation", 55, 0, 1, 0, "", false, Type.DisplayOrientation));
            fieldIndex++;
            newMesg.SetField(new Field("MountingSide", 56, 0, 1, 0, "", false, Type.Side));
            fieldIndex++;
            newMesg.SetField(new Field("DefaultPage", 57, 132, 1, 0, "", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("AutosyncMinSteps", 58, 132, 1, 0, "steps", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("AutosyncMinTime", 59, 132, 1, 0, "minutes", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("LactateThresholdAutodetectEnabled", 80, 0, 1, 0, "", false, Type.Bool));
            fieldIndex++;
            newMesg.SetField(new Field("BleAutoUploadEnabled", 86, 0, 1, 0, "", false, Type.Bool));
            fieldIndex++;
            newMesg.SetField(new Field("AutoSyncFrequency", 89, 0, 1, 0, "", false, Type.AutoSyncFrequency));
            fieldIndex++;
            newMesg.SetField(new Field("AutoActivityDetect", 90, 134, 1, 0, "", false, Type.AutoActivityDetect));
            fieldIndex++;
            newMesg.SetField(new Field("NumberOfScreens", 94, 2, 1, 0, "", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("SmartNotificationDisplayOrientation", 95, 0, 1, 0, "", false, Type.DisplayOrientation));
            fieldIndex++;
            newMesg.SetField(new Field("TapInterface", 134, 0, 1, 0, "", false, Type.Switch));
            fieldIndex++;
            newMesg.SetField(new Field("TapSensitivity", 174, 0, 1, 1, "", false, Type.TapSensitivity));
            fieldIndex++;

            return newMesg;
        }
        
        private static Mesg CreateUserProfileMesg()
        {
            ushort fieldIndex, subfieldIndex;
            Mesg newMesg = new Mesg("UserProfile", MesgNum.UserProfile);
            fieldIndex = 0;
            newMesg.SetField(new Field("MessageIndex", 254, 132, 1, 0, "", false, Type.MessageIndex));
            fieldIndex++;
            newMesg.SetField(new Field("FriendlyName", 0, 7, 1, 0, "", false, Type.String));
            fieldIndex++;
            newMesg.SetField(new Field("Gender", 1, 0, 1, 0, "", false, Type.Gender));
            fieldIndex++;
            newMesg.SetField(new Field("Age", 2, 2, 1, 0, "years", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("Height", 3, 2, 100, 0, "m", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("Weight", 4, 132, 10, 0, "kg", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("Language", 5, 0, 1, 0, "", false, Type.Language));
            fieldIndex++;
            newMesg.SetField(new Field("ElevSetting", 6, 0, 1, 0, "", false, Type.DisplayMeasure));
            fieldIndex++;
            newMesg.SetField(new Field("WeightSetting", 7, 0, 1, 0, "", false, Type.DisplayMeasure));
            fieldIndex++;
            newMesg.SetField(new Field("RestingHeartRate", 8, 2, 1, 0, "bpm", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("DefaultMaxRunningHeartRate", 9, 2, 1, 0, "bpm", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("DefaultMaxBikingHeartRate", 10, 2, 1, 0, "bpm", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("DefaultMaxHeartRate", 11, 2, 1, 0, "bpm", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("HrSetting", 12, 0, 1, 0, "", false, Type.DisplayHeart));
            fieldIndex++;
            newMesg.SetField(new Field("SpeedSetting", 13, 0, 1, 0, "", false, Type.DisplayMeasure));
            fieldIndex++;
            newMesg.SetField(new Field("DistSetting", 14, 0, 1, 0, "", false, Type.DisplayMeasure));
            fieldIndex++;
            newMesg.SetField(new Field("PowerSetting", 16, 0, 1, 0, "", false, Type.DisplayPower));
            fieldIndex++;
            newMesg.SetField(new Field("ActivityClass", 17, 0, 1, 0, "", false, Type.ActivityClass));
            fieldIndex++;
            newMesg.SetField(new Field("PositionSetting", 18, 0, 1, 0, "", false, Type.DisplayPosition));
            fieldIndex++;
            newMesg.SetField(new Field("TemperatureSetting", 21, 0, 1, 0, "", false, Type.DisplayMeasure));
            fieldIndex++;
            newMesg.SetField(new Field("LocalId", 22, 132, 1, 0, "", false, Type.UserLocalId));
            fieldIndex++;
            newMesg.SetField(new Field("GlobalId", 23, 13, 1, 0, "", false, Type.Byte));
            fieldIndex++;
            newMesg.SetField(new Field("WakeTime", 28, 134, 1, 0, "", false, Type.LocaltimeIntoDay));
            fieldIndex++;
            newMesg.SetField(new Field("SleepTime", 29, 134, 1, 0, "", false, Type.LocaltimeIntoDay));
            fieldIndex++;
            newMesg.SetField(new Field("HeightSetting", 30, 0, 1, 0, "", false, Type.DisplayMeasure));
            fieldIndex++;
            newMesg.SetField(new Field("UserRunningStepLength", 31, 132, 1000, 0, "m", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("UserWalkingStepLength", 32, 132, 1000, 0, "m", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("DepthSetting", 47, 0, 1, 0, "", false, Type.DisplayMeasure));
            fieldIndex++;
            newMesg.SetField(new Field("DiveCount", 49, 134, 1, 0, "", false, Type.Uint32));
            fieldIndex++;

            return newMesg;
        }
        
        private static Mesg CreateHrmProfileMesg()
        {
            ushort fieldIndex, subfieldIndex;
            Mesg newMesg = new Mesg("HrmProfile", MesgNum.HrmProfile);
            fieldIndex = 0;
            newMesg.SetField(new Field("MessageIndex", 254, 132, 1, 0, "", false, Type.MessageIndex));
            fieldIndex++;
            newMesg.SetField(new Field("Enabled", 0, 0, 1, 0, "", false, Type.Bool));
            fieldIndex++;
            newMesg.SetField(new Field("HrmAntId", 1, 139, 1, 0, "", false, Type.Uint16z));
            fieldIndex++;
            newMesg.SetField(new Field("LogHrv", 2, 0, 1, 0, "", false, Type.Bool));
            fieldIndex++;
            newMesg.SetField(new Field("HrmAntIdTransType", 3, 10, 1, 0, "", false, Type.Uint8z));
            fieldIndex++;

            return newMesg;
        }
        
        private static Mesg CreateSdmProfileMesg()
        {
            ushort fieldIndex, subfieldIndex;
            Mesg newMesg = new Mesg("SdmProfile", MesgNum.SdmProfile);
            fieldIndex = 0;
            newMesg.SetField(new Field("MessageIndex", 254, 132, 1, 0, "", false, Type.MessageIndex));
            fieldIndex++;
            newMesg.SetField(new Field("Enabled", 0, 0, 1, 0, "", false, Type.Bool));
            fieldIndex++;
            newMesg.SetField(new Field("SdmAntId", 1, 139, 1, 0, "", false, Type.Uint16z));
            fieldIndex++;
            newMesg.SetField(new Field("SdmCalFactor", 2, 132, 10, 0, "%", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("Odometer", 3, 134, 100, 0, "m", false, Type.Uint32));
            fieldIndex++;
            newMesg.SetField(new Field("SpeedSource", 4, 0, 1, 0, "", false, Type.Bool));
            fieldIndex++;
            newMesg.SetField(new Field("SdmAntIdTransType", 5, 10, 1, 0, "", false, Type.Uint8z));
            fieldIndex++;
            newMesg.SetField(new Field("OdometerRollover", 7, 2, 1, 0, "", false, Type.Uint8));
            fieldIndex++;

            return newMesg;
        }
        
        private static Mesg CreateBikeProfileMesg()
        {
            ushort fieldIndex, subfieldIndex;
            Mesg newMesg = new Mesg("BikeProfile", MesgNum.BikeProfile);
            fieldIndex = 0;
            newMesg.SetField(new Field("MessageIndex", 254, 132, 1, 0, "", false, Type.MessageIndex));
            fieldIndex++;
            newMesg.SetField(new Field("Name", 0, 7, 1, 0, "", false, Type.String));
            fieldIndex++;
            newMesg.SetField(new Field("Sport", 1, 0, 1, 0, "", false, Type.Sport));
            fieldIndex++;
            newMesg.SetField(new Field("SubSport", 2, 0, 1, 0, "", false, Type.SubSport));
            fieldIndex++;
            newMesg.SetField(new Field("Odometer", 3, 134, 100, 0, "m", false, Type.Uint32));
            fieldIndex++;
            newMesg.SetField(new Field("BikeSpdAntId", 4, 139, 1, 0, "", false, Type.Uint16z));
            fieldIndex++;
            newMesg.SetField(new Field("BikeCadAntId", 5, 139, 1, 0, "", false, Type.Uint16z));
            fieldIndex++;
            newMesg.SetField(new Field("BikeSpdcadAntId", 6, 139, 1, 0, "", false, Type.Uint16z));
            fieldIndex++;
            newMesg.SetField(new Field("BikePowerAntId", 7, 139, 1, 0, "", false, Type.Uint16z));
            fieldIndex++;
            newMesg.SetField(new Field("CustomWheelsize", 8, 132, 1000, 0, "m", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("AutoWheelsize", 9, 132, 1000, 0, "m", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("BikeWeight", 10, 132, 10, 0, "kg", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("PowerCalFactor", 11, 132, 10, 0, "%", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("AutoWheelCal", 12, 0, 1, 0, "", false, Type.Bool));
            fieldIndex++;
            newMesg.SetField(new Field("AutoPowerZero", 13, 0, 1, 0, "", false, Type.Bool));
            fieldIndex++;
            newMesg.SetField(new Field("Id", 14, 2, 1, 0, "", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("SpdEnabled", 15, 0, 1, 0, "", false, Type.Bool));
            fieldIndex++;
            newMesg.SetField(new Field("CadEnabled", 16, 0, 1, 0, "", false, Type.Bool));
            fieldIndex++;
            newMesg.SetField(new Field("SpdcadEnabled", 17, 0, 1, 0, "", false, Type.Bool));
            fieldIndex++;
            newMesg.SetField(new Field("PowerEnabled", 18, 0, 1, 0, "", false, Type.Bool));
            fieldIndex++;
            newMesg.SetField(new Field("CrankLength", 19, 2, 2, -110, "mm", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("Enabled", 20, 0, 1, 0, "", false, Type.Bool));
            fieldIndex++;
            newMesg.SetField(new Field("BikeSpdAntIdTransType", 21, 10, 1, 0, "", false, Type.Uint8z));
            fieldIndex++;
            newMesg.SetField(new Field("BikeCadAntIdTransType", 22, 10, 1, 0, "", false, Type.Uint8z));
            fieldIndex++;
            newMesg.SetField(new Field("BikeSpdcadAntIdTransType", 23, 10, 1, 0, "", false, Type.Uint8z));
            fieldIndex++;
            newMesg.SetField(new Field("BikePowerAntIdTransType", 24, 10, 1, 0, "", false, Type.Uint8z));
            fieldIndex++;
            newMesg.SetField(new Field("OdometerRollover", 37, 2, 1, 0, "", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("FrontGearNum", 38, 10, 1, 0, "", false, Type.Uint8z));
            fieldIndex++;
            newMesg.SetField(new Field("FrontGear", 39, 10, 1, 0, "", false, Type.Uint8z));
            fieldIndex++;
            newMesg.SetField(new Field("RearGearNum", 40, 10, 1, 0, "", false, Type.Uint8z));
            fieldIndex++;
            newMesg.SetField(new Field("RearGear", 41, 10, 1, 0, "", false, Type.Uint8z));
            fieldIndex++;
            newMesg.SetField(new Field("ShimanoDi2Enabled", 44, 0, 1, 0, "", false, Type.Bool));
            fieldIndex++;

            return newMesg;
        }
        
        private static Mesg CreateConnectivityMesg()
        {
            ushort fieldIndex, subfieldIndex;
            Mesg newMesg = new Mesg("Connectivity", MesgNum.Connectivity);
            fieldIndex = 0;
            newMesg.SetField(new Field("BluetoothEnabled", 0, 0, 1, 0, "", false, Type.Bool));
            fieldIndex++;
            newMesg.SetField(new Field("BluetoothLeEnabled", 1, 0, 1, 0, "", false, Type.Bool));
            fieldIndex++;
            newMesg.SetField(new Field("AntEnabled", 2, 0, 1, 0, "", false, Type.Bool));
            fieldIndex++;
            newMesg.SetField(new Field("Name", 3, 7, 1, 0, "", false, Type.String));
            fieldIndex++;
            newMesg.SetField(new Field("LiveTrackingEnabled", 4, 0, 1, 0, "", false, Type.Bool));
            fieldIndex++;
            newMesg.SetField(new Field("WeatherConditionsEnabled", 5, 0, 1, 0, "", false, Type.Bool));
            fieldIndex++;
            newMesg.SetField(new Field("WeatherAlertsEnabled", 6, 0, 1, 0, "", false, Type.Bool));
            fieldIndex++;
            newMesg.SetField(new Field("AutoActivityUploadEnabled", 7, 0, 1, 0, "", false, Type.Bool));
            fieldIndex++;
            newMesg.SetField(new Field("CourseDownloadEnabled", 8, 0, 1, 0, "", false, Type.Bool));
            fieldIndex++;
            newMesg.SetField(new Field("WorkoutDownloadEnabled", 9, 0, 1, 0, "", false, Type.Bool));
            fieldIndex++;
            newMesg.SetField(new Field("GpsEphemerisDownloadEnabled", 10, 0, 1, 0, "", false, Type.Bool));
            fieldIndex++;
            newMesg.SetField(new Field("IncidentDetectionEnabled", 11, 0, 1, 0, "", false, Type.Bool));
            fieldIndex++;
            newMesg.SetField(new Field("GrouptrackEnabled", 12, 0, 1, 0, "", false, Type.Bool));
            fieldIndex++;

            return newMesg;
        }
        
        private static Mesg CreateWatchfaceSettingsMesg()
        {
            ushort fieldIndex, subfieldIndex;
            Mesg newMesg = new Mesg("WatchfaceSettings", MesgNum.WatchfaceSettings);
            fieldIndex = 0;
            newMesg.SetField(new Field("MessageIndex", 254, 132, 1, 0, "", false, Type.MessageIndex));
            fieldIndex++;
            newMesg.SetField(new Field("Mode", 0, 0, 1, 0, "", false, Type.WatchfaceMode));
            fieldIndex++;
            newMesg.SetField(new Field("Layout", 1, 13, 1, 0, "", false, Type.Byte));
            subfieldIndex = 0;
            newMesg.FieldsList[fieldIndex].subfields.Add(new Subfield("DigitalLayout", 0, 1, 0, ""));
            newMesg.FieldsList[fieldIndex].subfields[subfieldIndex].AddMap(0, 0);
            subfieldIndex++;
            newMesg.FieldsList[fieldIndex].subfields.Add(new Subfield("AnalogLayout", 0, 1, 0, ""));
            newMesg.FieldsList[fieldIndex].subfields[subfieldIndex].AddMap(0, 1);
            subfieldIndex++;
            fieldIndex++;

            return newMesg;
        }
        
        private static Mesg CreateOhrSettingsMesg()
        {
            ushort fieldIndex, subfieldIndex;
            Mesg newMesg = new Mesg("OhrSettings", MesgNum.OhrSettings);
            fieldIndex = 0;
            newMesg.SetField(new Field("Timestamp", 253, 134, 1, 0, "s", false, Type.DateTime));
            fieldIndex++;
            newMesg.SetField(new Field("Enabled", 0, 0, 1, 0, "", false, Type.Switch));
            fieldIndex++;

            return newMesg;
        }
        
        private static Mesg CreateZonesTargetMesg()
        {
            ushort fieldIndex, subfieldIndex;
            Mesg newMesg = new Mesg("ZonesTarget", MesgNum.ZonesTarget);
            fieldIndex = 0;
            newMesg.SetField(new Field("MaxHeartRate", 1, 2, 1, 0, "", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("ThresholdHeartRate", 2, 2, 1, 0, "", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("FunctionalThresholdPower", 3, 132, 1, 0, "", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("HrCalcType", 5, 0, 1, 0, "", false, Type.HrZoneCalc));
            fieldIndex++;
            newMesg.SetField(new Field("PwrCalcType", 7, 0, 1, 0, "", false, Type.PwrZoneCalc));
            fieldIndex++;

            return newMesg;
        }
        
        private static Mesg CreateSportMesg()
        {
            ushort fieldIndex, subfieldIndex;
            Mesg newMesg = new Mesg("Sport", MesgNum.Sport);
            fieldIndex = 0;
            newMesg.SetField(new Field("Sport", 0, 0, 1, 0, "", false, Type.Sport));
            fieldIndex++;
            newMesg.SetField(new Field("SubSport", 1, 0, 1, 0, "", false, Type.SubSport));
            fieldIndex++;
            newMesg.SetField(new Field("Name", 3, 7, 1, 0, "", false, Type.String));
            fieldIndex++;

            return newMesg;
        }
        
        private static Mesg CreateHrZoneMesg()
        {
            ushort fieldIndex, subfieldIndex;
            Mesg newMesg = new Mesg("HrZone", MesgNum.HrZone);
            fieldIndex = 0;
            newMesg.SetField(new Field("MessageIndex", 254, 132, 1, 0, "", false, Type.MessageIndex));
            fieldIndex++;
            newMesg.SetField(new Field("HighBpm", 1, 2, 1, 0, "bpm", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("Name", 2, 7, 1, 0, "", false, Type.String));
            fieldIndex++;

            return newMesg;
        }
        
        private static Mesg CreateSpeedZoneMesg()
        {
            ushort fieldIndex, subfieldIndex;
            Mesg newMesg = new Mesg("SpeedZone", MesgNum.SpeedZone);
            fieldIndex = 0;
            newMesg.SetField(new Field("MessageIndex", 254, 132, 1, 0, "", false, Type.MessageIndex));
            fieldIndex++;
            newMesg.SetField(new Field("HighValue", 0, 132, 1000, 0, "m/s", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("Name", 1, 7, 1, 0, "", false, Type.String));
            fieldIndex++;

            return newMesg;
        }
        
        private static Mesg CreateCadenceZoneMesg()
        {
            ushort fieldIndex, subfieldIndex;
            Mesg newMesg = new Mesg("CadenceZone", MesgNum.CadenceZone);
            fieldIndex = 0;
            newMesg.SetField(new Field("MessageIndex", 254, 132, 1, 0, "", false, Type.MessageIndex));
            fieldIndex++;
            newMesg.SetField(new Field("HighValue", 0, 2, 1, 0, "rpm", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("Name", 1, 7, 1, 0, "", false, Type.String));
            fieldIndex++;

            return newMesg;
        }
        
        private static Mesg CreatePowerZoneMesg()
        {
            ushort fieldIndex, subfieldIndex;
            Mesg newMesg = new Mesg("PowerZone", MesgNum.PowerZone);
            fieldIndex = 0;
            newMesg.SetField(new Field("MessageIndex", 254, 132, 1, 0, "", false, Type.MessageIndex));
            fieldIndex++;
            newMesg.SetField(new Field("HighValue", 1, 132, 1, 0, "watts", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("Name", 2, 7, 1, 0, "", false, Type.String));
            fieldIndex++;

            return newMesg;
        }
        
        private static Mesg CreateMetZoneMesg()
        {
            ushort fieldIndex, subfieldIndex;
            Mesg newMesg = new Mesg("MetZone", MesgNum.MetZone);
            fieldIndex = 0;
            newMesg.SetField(new Field("MessageIndex", 254, 132, 1, 0, "", false, Type.MessageIndex));
            fieldIndex++;
            newMesg.SetField(new Field("HighBpm", 1, 2, 1, 0, "", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("Calories", 2, 132, 10, 0, "kcal / min", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("FatCalories", 3, 2, 10, 0, "kcal / min", false, Type.Uint8));
            fieldIndex++;

            return newMesg;
        }
        
        private static Mesg CreateDiveSettingsMesg()
        {
            ushort fieldIndex, subfieldIndex;
            Mesg newMesg = new Mesg("DiveSettings", MesgNum.DiveSettings);
            fieldIndex = 0;
            newMesg.SetField(new Field("MessageIndex", 254, 132, 1, 0, "", false, Type.MessageIndex));
            fieldIndex++;
            newMesg.SetField(new Field("Name", 0, 7, 1, 0, "", false, Type.String));
            fieldIndex++;
            newMesg.SetField(new Field("Model", 1, 0, 1, 0, "", false, Type.TissueModelType));
            fieldIndex++;
            newMesg.SetField(new Field("GfLow", 2, 2, 1, 0, "percent", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("GfHigh", 3, 2, 1, 0, "percent", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("WaterType", 4, 0, 1, 0, "", false, Type.WaterType));
            fieldIndex++;
            newMesg.SetField(new Field("WaterDensity", 5, 136, 1, 0, "kg/m^3", false, Type.Float32));
            fieldIndex++;
            newMesg.SetField(new Field("Po2Warn", 6, 2, 100, 0, "percent", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("Po2Critical", 7, 2, 100, 0, "percent", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("Po2Deco", 8, 2, 100, 0, "percent", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("SafetyStopEnabled", 9, 0, 1, 0, "", false, Type.Bool));
            fieldIndex++;
            newMesg.SetField(new Field("BottomDepth", 10, 136, 1, 0, "", false, Type.Float32));
            fieldIndex++;
            newMesg.SetField(new Field("BottomTime", 11, 134, 1, 0, "", false, Type.Uint32));
            fieldIndex++;
            newMesg.SetField(new Field("ApneaCountdownEnabled", 12, 0, 1, 0, "", false, Type.Bool));
            fieldIndex++;
            newMesg.SetField(new Field("ApneaCountdownTime", 13, 134, 1, 0, "", false, Type.Uint32));
            fieldIndex++;
            newMesg.SetField(new Field("BacklightMode", 14, 0, 1, 0, "", false, Type.DiveBacklightMode));
            fieldIndex++;
            newMesg.SetField(new Field("BacklightBrightness", 15, 2, 1, 0, "", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("BacklightTimeout", 16, 2, 1, 0, "", false, Type.BacklightTimeout));
            fieldIndex++;
            newMesg.SetField(new Field("RepeatDiveInterval", 17, 132, 1, 0, "s", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("SafetyStopTime", 18, 132, 1, 0, "s", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("HeartRateSourceType", 19, 0, 1, 0, "", false, Type.SourceType));
            fieldIndex++;
            newMesg.SetField(new Field("HeartRateSource", 20, 2, 1, 0, "", false, Type.Uint8));
            subfieldIndex = 0;
            newMesg.FieldsList[fieldIndex].subfields.Add(new Subfield("HeartRateAntplusDeviceType", 2, 1, 0, ""));
            newMesg.FieldsList[fieldIndex].subfields[subfieldIndex].AddMap(19, 1);
            subfieldIndex++;
            newMesg.FieldsList[fieldIndex].subfields.Add(new Subfield("HeartRateLocalDeviceType", 2, 1, 0, ""));
            newMesg.FieldsList[fieldIndex].subfields[subfieldIndex].AddMap(19, 5);
            subfieldIndex++;
            fieldIndex++;

            return newMesg;
        }
        
        private static Mesg CreateDiveAlarmMesg()
        {
            ushort fieldIndex, subfieldIndex;
            Mesg newMesg = new Mesg("DiveAlarm", MesgNum.DiveAlarm);
            fieldIndex = 0;
            newMesg.SetField(new Field("MessageIndex", 254, 132, 1, 0, "", false, Type.MessageIndex));
            fieldIndex++;
            newMesg.SetField(new Field("Depth", 0, 134, 1000, 0, "m", false, Type.Uint32));
            fieldIndex++;
            newMesg.SetField(new Field("Time", 1, 133, 1, 0, "s", false, Type.Sint32));
            fieldIndex++;
            newMesg.SetField(new Field("Enabled", 2, 0, 1, 0, "", false, Type.Bool));
            fieldIndex++;
            newMesg.SetField(new Field("AlarmType", 3, 0, 1, 0, "", false, Type.DiveAlarmType));
            fieldIndex++;
            newMesg.SetField(new Field("Sound", 4, 0, 1, 0, "", false, Type.Tone));
            fieldIndex++;
            newMesg.SetField(new Field("DiveTypes", 5, 0, 1, 0, "", false, Type.SubSport));
            fieldIndex++;

            return newMesg;
        }
        
        private static Mesg CreateDiveGasMesg()
        {
            ushort fieldIndex, subfieldIndex;
            Mesg newMesg = new Mesg("DiveGas", MesgNum.DiveGas);
            fieldIndex = 0;
            newMesg.SetField(new Field("MessageIndex", 254, 132, 1, 0, "", false, Type.MessageIndex));
            fieldIndex++;
            newMesg.SetField(new Field("HeliumContent", 0, 2, 1, 0, "percent", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("OxygenContent", 1, 2, 1, 0, "percent", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("Status", 2, 0, 1, 0, "", false, Type.DiveGasStatus));
            fieldIndex++;

            return newMesg;
        }
        
        private static Mesg CreateGoalMesg()
        {
            ushort fieldIndex, subfieldIndex;
            Mesg newMesg = new Mesg("Goal", MesgNum.Goal);
            fieldIndex = 0;
            newMesg.SetField(new Field("MessageIndex", 254, 132, 1, 0, "", false, Type.MessageIndex));
            fieldIndex++;
            newMesg.SetField(new Field("Sport", 0, 0, 1, 0, "", false, Type.Sport));
            fieldIndex++;
            newMesg.SetField(new Field("SubSport", 1, 0, 1, 0, "", false, Type.SubSport));
            fieldIndex++;
            newMesg.SetField(new Field("StartDate", 2, 134, 1, 0, "", false, Type.DateTime));
            fieldIndex++;
            newMesg.SetField(new Field("EndDate", 3, 134, 1, 0, "", false, Type.DateTime));
            fieldIndex++;
            newMesg.SetField(new Field("Type", 4, 0, 1, 0, "", false, Type.Goal));
            fieldIndex++;
            newMesg.SetField(new Field("Value", 5, 134, 1, 0, "", false, Type.Uint32));
            fieldIndex++;
            newMesg.SetField(new Field("Repeat", 6, 0, 1, 0, "", false, Type.Bool));
            fieldIndex++;
            newMesg.SetField(new Field("TargetValue", 7, 134, 1, 0, "", false, Type.Uint32));
            fieldIndex++;
            newMesg.SetField(new Field("Recurrence", 8, 0, 1, 0, "", false, Type.GoalRecurrence));
            fieldIndex++;
            newMesg.SetField(new Field("RecurrenceValue", 9, 132, 1, 0, "", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("Enabled", 10, 0, 1, 0, "", false, Type.Bool));
            fieldIndex++;
            newMesg.SetField(new Field("Source", 11, 0, 1, 0, "", false, Type.GoalSource));
            fieldIndex++;

            return newMesg;
        }
        
        private static Mesg CreateActivityMesg()
        {
            ushort fieldIndex, subfieldIndex;
            Mesg newMesg = new Mesg("Activity", MesgNum.Activity);
            fieldIndex = 0;
            newMesg.SetField(new Field("Timestamp", 253, 134, 1, 0, "", false, Type.DateTime));
            fieldIndex++;
            newMesg.SetField(new Field("TotalTimerTime", 0, 134, 1000, 0, "s", false, Type.Uint32));
            fieldIndex++;
            newMesg.SetField(new Field("NumSessions", 1, 132, 1, 0, "", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("Type", 2, 0, 1, 0, "", false, Type.Activity));
            fieldIndex++;
            newMesg.SetField(new Field("Event", 3, 0, 1, 0, "", false, Type.Event));
            fieldIndex++;
            newMesg.SetField(new Field("EventType", 4, 0, 1, 0, "", false, Type.EventType));
            fieldIndex++;
            newMesg.SetField(new Field("LocalTimestamp", 5, 134, 1, 0, "", false, Type.LocalDateTime));
            fieldIndex++;
            newMesg.SetField(new Field("EventGroup", 6, 2, 1, 0, "", false, Type.Uint8));
            fieldIndex++;

            return newMesg;
        }
        
        private static Mesg CreateSessionMesg()
        {
            ushort fieldIndex, subfieldIndex;
            Mesg newMesg = new Mesg("Session", MesgNum.Session);
            fieldIndex = 0;
            newMesg.SetField(new Field("MessageIndex", 254, 132, 1, 0, "", false, Type.MessageIndex));
            fieldIndex++;
            newMesg.SetField(new Field("Timestamp", 253, 134, 1, 0, "s", false, Type.DateTime));
            fieldIndex++;
            newMesg.SetField(new Field("Event", 0, 0, 1, 0, "", false, Type.Event));
            fieldIndex++;
            newMesg.SetField(new Field("EventType", 1, 0, 1, 0, "", false, Type.EventType));
            fieldIndex++;
            newMesg.SetField(new Field("StartTime", 2, 134, 1, 0, "", false, Type.DateTime));
            fieldIndex++;
            newMesg.SetField(new Field("StartPositionLat", 3, 133, 1, 0, "semicircles", false, Type.Sint32));
            fieldIndex++;
            newMesg.SetField(new Field("StartPositionLong", 4, 133, 1, 0, "semicircles", false, Type.Sint32));
            fieldIndex++;
            newMesg.SetField(new Field("Sport", 5, 0, 1, 0, "", false, Type.Sport));
            fieldIndex++;
            newMesg.SetField(new Field("SubSport", 6, 0, 1, 0, "", false, Type.SubSport));
            fieldIndex++;
            newMesg.SetField(new Field("TotalElapsedTime", 7, 134, 1000, 0, "s", false, Type.Uint32));
            fieldIndex++;
            newMesg.SetField(new Field("TotalTimerTime", 8, 134, 1000, 0, "s", false, Type.Uint32));
            fieldIndex++;
            newMesg.SetField(new Field("TotalDistance", 9, 134, 100, 0, "m", false, Type.Uint32));
            fieldIndex++;
            newMesg.SetField(new Field("TotalCycles", 10, 134, 1, 0, "cycles", false, Type.Uint32));
            subfieldIndex = 0;
            newMesg.FieldsList[fieldIndex].subfields.Add(new Subfield("TotalStrides", 134, 1, 0, "strides"));
            newMesg.FieldsList[fieldIndex].subfields[subfieldIndex].AddMap(5, 1);
            newMesg.FieldsList[fieldIndex].subfields[subfieldIndex].AddMap(5, 11);
            subfieldIndex++;
            newMesg.FieldsList[fieldIndex].subfields.Add(new Subfield("TotalStrokes", 134, 1, 0, "strokes"));
            newMesg.FieldsList[fieldIndex].subfields[subfieldIndex].AddMap(5, 2);
            newMesg.FieldsList[fieldIndex].subfields[subfieldIndex].AddMap(5, 5);
            newMesg.FieldsList[fieldIndex].subfields[subfieldIndex].AddMap(5, 15);
            newMesg.FieldsList[fieldIndex].subfields[subfieldIndex].AddMap(5, 37);
            subfieldIndex++;
            fieldIndex++;
            newMesg.SetField(new Field("TotalCalories", 11, 132, 1, 0, "kcal", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("TotalFatCalories", 13, 132, 1, 0, "kcal", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("AvgSpeed", 14, 132, 1000, 0, "m/s", false, Type.Uint16));
            newMesg.FieldsList[fieldIndex].components.Add(new FieldComponent(124, false, 16, 1000, 0)); // enhanced_avg_speed
            fieldIndex++;
            newMesg.SetField(new Field("MaxSpeed", 15, 132, 1000, 0, "m/s", false, Type.Uint16));
            newMesg.FieldsList[fieldIndex].components.Add(new FieldComponent(125, false, 16, 1000, 0)); // enhanced_max_speed
            fieldIndex++;
            newMesg.SetField(new Field("AvgHeartRate", 16, 2, 1, 0, "bpm", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("MaxHeartRate", 17, 2, 1, 0, "bpm", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("AvgCadence", 18, 2, 1, 0, "rpm", false, Type.Uint8));
            subfieldIndex = 0;
            newMesg.FieldsList[fieldIndex].subfields.Add(new Subfield("AvgRunningCadence", 2, 1, 0, "strides/min"));
            newMesg.FieldsList[fieldIndex].subfields[subfieldIndex].AddMap(5, 1);
            subfieldIndex++;
            fieldIndex++;
            newMesg.SetField(new Field("MaxCadence", 19, 2, 1, 0, "rpm", false, Type.Uint8));
            subfieldIndex = 0;
            newMesg.FieldsList[fieldIndex].subfields.Add(new Subfield("MaxRunningCadence", 2, 1, 0, "strides/min"));
            newMesg.FieldsList[fieldIndex].subfields[subfieldIndex].AddMap(5, 1);
            subfieldIndex++;
            fieldIndex++;
            newMesg.SetField(new Field("AvgPower", 20, 132, 1, 0, "watts", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("MaxPower", 21, 132, 1, 0, "watts", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("TotalAscent", 22, 132, 1, 0, "m", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("TotalDescent", 23, 132, 1, 0, "m", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("TotalTrainingEffect", 24, 2, 10, 0, "", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("FirstLapIndex", 25, 132, 1, 0, "", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("NumLaps", 26, 132, 1, 0, "", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("EventGroup", 27, 2, 1, 0, "", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("Trigger", 28, 0, 1, 0, "", false, Type.SessionTrigger));
            fieldIndex++;
            newMesg.SetField(new Field("NecLat", 29, 133, 1, 0, "semicircles", false, Type.Sint32));
            fieldIndex++;
            newMesg.SetField(new Field("NecLong", 30, 133, 1, 0, "semicircles", false, Type.Sint32));
            fieldIndex++;
            newMesg.SetField(new Field("SwcLat", 31, 133, 1, 0, "semicircles", false, Type.Sint32));
            fieldIndex++;
            newMesg.SetField(new Field("SwcLong", 32, 133, 1, 0, "semicircles", false, Type.Sint32));
            fieldIndex++;
            newMesg.SetField(new Field("NumLengths", 33, 132, 1, 0, "lengths", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("NormalizedPower", 34, 132, 1, 0, "watts", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("TrainingStressScore", 35, 132, 10, 0, "tss", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("IntensityFactor", 36, 132, 1000, 0, "if", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("LeftRightBalance", 37, 132, 1, 0, "", false, Type.LeftRightBalance100));
            fieldIndex++;
            newMesg.SetField(new Field("AvgStrokeCount", 41, 134, 10, 0, "strokes/lap", false, Type.Uint32));
            fieldIndex++;
            newMesg.SetField(new Field("AvgStrokeDistance", 42, 132, 100, 0, "m", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("SwimStroke", 43, 0, 1, 0, "swim_stroke", false, Type.SwimStroke));
            fieldIndex++;
            newMesg.SetField(new Field("PoolLength", 44, 132, 100, 0, "m", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("ThresholdPower", 45, 132, 1, 0, "watts", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("PoolLengthUnit", 46, 0, 1, 0, "", false, Type.DisplayMeasure));
            fieldIndex++;
            newMesg.SetField(new Field("NumActiveLengths", 47, 132, 1, 0, "lengths", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("TotalWork", 48, 134, 1, 0, "J", false, Type.Uint32));
            fieldIndex++;
            newMesg.SetField(new Field("AvgAltitude", 49, 132, 5, 500, "m", false, Type.Uint16));
            newMesg.FieldsList[fieldIndex].components.Add(new FieldComponent(126, false, 16, 5, 500)); // enhanced_avg_altitude
            fieldIndex++;
            newMesg.SetField(new Field("MaxAltitude", 50, 132, 5, 500, "m", false, Type.Uint16));
            newMesg.FieldsList[fieldIndex].components.Add(new FieldComponent(128, false, 16, 5, 500)); // enhanced_max_altitude
            fieldIndex++;
            newMesg.SetField(new Field("GpsAccuracy", 51, 2, 1, 0, "m", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("AvgGrade", 52, 131, 100, 0, "%", false, Type.Sint16));
            fieldIndex++;
            newMesg.SetField(new Field("AvgPosGrade", 53, 131, 100, 0, "%", false, Type.Sint16));
            fieldIndex++;
            newMesg.SetField(new Field("AvgNegGrade", 54, 131, 100, 0, "%", false, Type.Sint16));
            fieldIndex++;
            newMesg.SetField(new Field("MaxPosGrade", 55, 131, 100, 0, "%", false, Type.Sint16));
            fieldIndex++;
            newMesg.SetField(new Field("MaxNegGrade", 56, 131, 100, 0, "%", false, Type.Sint16));
            fieldIndex++;
            newMesg.SetField(new Field("AvgTemperature", 57, 1, 1, 0, "C", false, Type.Sint8));
            fieldIndex++;
            newMesg.SetField(new Field("MaxTemperature", 58, 1, 1, 0, "C", false, Type.Sint8));
            fieldIndex++;
            newMesg.SetField(new Field("TotalMovingTime", 59, 134, 1000, 0, "s", false, Type.Uint32));
            fieldIndex++;
            newMesg.SetField(new Field("AvgPosVerticalSpeed", 60, 131, 1000, 0, "m/s", false, Type.Sint16));
            fieldIndex++;
            newMesg.SetField(new Field("AvgNegVerticalSpeed", 61, 131, 1000, 0, "m/s", false, Type.Sint16));
            fieldIndex++;
            newMesg.SetField(new Field("MaxPosVerticalSpeed", 62, 131, 1000, 0, "m/s", false, Type.Sint16));
            fieldIndex++;
            newMesg.SetField(new Field("MaxNegVerticalSpeed", 63, 131, 1000, 0, "m/s", false, Type.Sint16));
            fieldIndex++;
            newMesg.SetField(new Field("MinHeartRate", 64, 2, 1, 0, "bpm", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("TimeInHrZone", 65, 134, 1000, 0, "s", false, Type.Uint32));
            fieldIndex++;
            newMesg.SetField(new Field("TimeInSpeedZone", 66, 134, 1000, 0, "s", false, Type.Uint32));
            fieldIndex++;
            newMesg.SetField(new Field("TimeInCadenceZone", 67, 134, 1000, 0, "s", false, Type.Uint32));
            fieldIndex++;
            newMesg.SetField(new Field("TimeInPowerZone", 68, 134, 1000, 0, "s", false, Type.Uint32));
            fieldIndex++;
            newMesg.SetField(new Field("AvgLapTime", 69, 134, 1000, 0, "s", false, Type.Uint32));
            fieldIndex++;
            newMesg.SetField(new Field("BestLapIndex", 70, 132, 1, 0, "", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("MinAltitude", 71, 132, 5, 500, "m", false, Type.Uint16));
            newMesg.FieldsList[fieldIndex].components.Add(new FieldComponent(127, false, 16, 5, 500)); // enhanced_min_altitude
            fieldIndex++;
            newMesg.SetField(new Field("PlayerScore", 82, 132, 1, 0, "", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("OpponentScore", 83, 132, 1, 0, "", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("OpponentName", 84, 7, 1, 0, "", false, Type.String));
            fieldIndex++;
            newMesg.SetField(new Field("StrokeCount", 85, 132, 1, 0, "counts", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("ZoneCount", 86, 132, 1, 0, "counts", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("MaxBallSpeed", 87, 132, 100, 0, "m/s", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("AvgBallSpeed", 88, 132, 100, 0, "m/s", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("AvgVerticalOscillation", 89, 132, 10, 0, "mm", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("AvgStanceTimePercent", 90, 132, 100, 0, "percent", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("AvgStanceTime", 91, 132, 10, 0, "ms", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("AvgFractionalCadence", 92, 2, 128, 0, "rpm", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("MaxFractionalCadence", 93, 2, 128, 0, "rpm", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("TotalFractionalCycles", 94, 2, 128, 0, "cycles", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("AvgTotalHemoglobinConc", 95, 132, 100, 0, "g/dL", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("MinTotalHemoglobinConc", 96, 132, 100, 0, "g/dL", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("MaxTotalHemoglobinConc", 97, 132, 100, 0, "g/dL", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("AvgSaturatedHemoglobinPercent", 98, 132, 10, 0, "%", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("MinSaturatedHemoglobinPercent", 99, 132, 10, 0, "%", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("MaxSaturatedHemoglobinPercent", 100, 132, 10, 0, "%", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("AvgLeftTorqueEffectiveness", 101, 2, 2, 0, "percent", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("AvgRightTorqueEffectiveness", 102, 2, 2, 0, "percent", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("AvgLeftPedalSmoothness", 103, 2, 2, 0, "percent", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("AvgRightPedalSmoothness", 104, 2, 2, 0, "percent", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("AvgCombinedPedalSmoothness", 105, 2, 2, 0, "percent", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("SportIndex", 111, 2, 1, 0, "", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("TimeStanding", 112, 134, 1000, 0, "s", false, Type.Uint32));
            fieldIndex++;
            newMesg.SetField(new Field("StandCount", 113, 132, 1, 0, "", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("AvgLeftPco", 114, 1, 1, 0, "mm", false, Type.Sint8));
            fieldIndex++;
            newMesg.SetField(new Field("AvgRightPco", 115, 1, 1, 0, "mm", false, Type.Sint8));
            fieldIndex++;
            newMesg.SetField(new Field("AvgLeftPowerPhase", 116, 2, 0.7111111, 0, "degrees", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("AvgLeftPowerPhasePeak", 117, 2, 0.7111111, 0, "degrees", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("AvgRightPowerPhase", 118, 2, 0.7111111, 0, "degrees", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("AvgRightPowerPhasePeak", 119, 2, 0.7111111, 0, "degrees", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("AvgPowerPosition", 120, 132, 1, 0, "watts", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("MaxPowerPosition", 121, 132, 1, 0, "watts", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("AvgCadencePosition", 122, 2, 1, 0, "rpm", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("MaxCadencePosition", 123, 2, 1, 0, "rpm", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("EnhancedAvgSpeed", 124, 134, 1000, 0, "m/s", false, Type.Uint32));
            fieldIndex++;
            newMesg.SetField(new Field("EnhancedMaxSpeed", 125, 134, 1000, 0, "m/s", false, Type.Uint32));
            fieldIndex++;
            newMesg.SetField(new Field("EnhancedAvgAltitude", 126, 134, 5, 500, "m", false, Type.Uint32));
            fieldIndex++;
            newMesg.SetField(new Field("EnhancedMinAltitude", 127, 134, 5, 500, "m", false, Type.Uint32));
            fieldIndex++;
            newMesg.SetField(new Field("EnhancedMaxAltitude", 128, 134, 5, 500, "m", false, Type.Uint32));
            fieldIndex++;
            newMesg.SetField(new Field("AvgLevMotorPower", 129, 132, 1, 0, "watts", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("MaxLevMotorPower", 130, 132, 1, 0, "watts", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("LevBatteryConsumption", 131, 2, 2, 0, "percent", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("AvgVerticalRatio", 132, 132, 100, 0, "percent", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("AvgStanceTimeBalance", 133, 132, 100, 0, "percent", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("AvgStepLength", 134, 132, 10, 0, "mm", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("TotalAnaerobicTrainingEffect", 137, 2, 10, 0, "", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("AvgVam", 139, 132, 1000, 0, "m/s", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("TotalGrit", 181, 136, 1, 0, "kGrit", false, Type.Float32));
            fieldIndex++;
            newMesg.SetField(new Field("TotalFlow", 182, 136, 1, 0, "Flow", false, Type.Float32));
            fieldIndex++;
            newMesg.SetField(new Field("JumpCount", 183, 132, 1, 0, "", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("AvgGrit", 186, 136, 1, 0, "kGrit", false, Type.Float32));
            fieldIndex++;
            newMesg.SetField(new Field("AvgFlow", 187, 136, 1, 0, "Flow", false, Type.Float32));
            fieldIndex++;

            return newMesg;
        }
        
        private static Mesg CreateLapMesg()
        {
            ushort fieldIndex, subfieldIndex;
            Mesg newMesg = new Mesg("Lap", MesgNum.Lap);
            fieldIndex = 0;
            newMesg.SetField(new Field("MessageIndex", 254, 132, 1, 0, "", false, Type.MessageIndex));
            fieldIndex++;
            newMesg.SetField(new Field("Timestamp", 253, 134, 1, 0, "s", false, Type.DateTime));
            fieldIndex++;
            newMesg.SetField(new Field("Event", 0, 0, 1, 0, "", false, Type.Event));
            fieldIndex++;
            newMesg.SetField(new Field("EventType", 1, 0, 1, 0, "", false, Type.EventType));
            fieldIndex++;
            newMesg.SetField(new Field("StartTime", 2, 134, 1, 0, "", false, Type.DateTime));
            fieldIndex++;
            newMesg.SetField(new Field("StartPositionLat", 3, 133, 1, 0, "semicircles", false, Type.Sint32));
            fieldIndex++;
            newMesg.SetField(new Field("StartPositionLong", 4, 133, 1, 0, "semicircles", false, Type.Sint32));
            fieldIndex++;
            newMesg.SetField(new Field("EndPositionLat", 5, 133, 1, 0, "semicircles", false, Type.Sint32));
            fieldIndex++;
            newMesg.SetField(new Field("EndPositionLong", 6, 133, 1, 0, "semicircles", false, Type.Sint32));
            fieldIndex++;
            newMesg.SetField(new Field("TotalElapsedTime", 7, 134, 1000, 0, "s", false, Type.Uint32));
            fieldIndex++;
            newMesg.SetField(new Field("TotalTimerTime", 8, 134, 1000, 0, "s", false, Type.Uint32));
            fieldIndex++;
            newMesg.SetField(new Field("TotalDistance", 9, 134, 100, 0, "m", false, Type.Uint32));
            fieldIndex++;
            newMesg.SetField(new Field("TotalCycles", 10, 134, 1, 0, "cycles", false, Type.Uint32));
            subfieldIndex = 0;
            newMesg.FieldsList[fieldIndex].subfields.Add(new Subfield("TotalStrides", 134, 1, 0, "strides"));
            newMesg.FieldsList[fieldIndex].subfields[subfieldIndex].AddMap(25, 1);
            newMesg.FieldsList[fieldIndex].subfields[subfieldIndex].AddMap(25, 11);
            subfieldIndex++;
            newMesg.FieldsList[fieldIndex].subfields.Add(new Subfield("TotalStrokes", 134, 1, 0, "strokes"));
            newMesg.FieldsList[fieldIndex].subfields[subfieldIndex].AddMap(25, 2);
            newMesg.FieldsList[fieldIndex].subfields[subfieldIndex].AddMap(25, 5);
            newMesg.FieldsList[fieldIndex].subfields[subfieldIndex].AddMap(25, 15);
            newMesg.FieldsList[fieldIndex].subfields[subfieldIndex].AddMap(25, 37);
            subfieldIndex++;
            fieldIndex++;
            newMesg.SetField(new Field("TotalCalories", 11, 132, 1, 0, "kcal", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("TotalFatCalories", 12, 132, 1, 0, "kcal", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("AvgSpeed", 13, 132, 1000, 0, "m/s", false, Type.Uint16));
            newMesg.FieldsList[fieldIndex].components.Add(new FieldComponent(110, false, 16, 1000, 0)); // enhanced_avg_speed
            fieldIndex++;
            newMesg.SetField(new Field("MaxSpeed", 14, 132, 1000, 0, "m/s", false, Type.Uint16));
            newMesg.FieldsList[fieldIndex].components.Add(new FieldComponent(111, false, 16, 1000, 0)); // enhanced_max_speed
            fieldIndex++;
            newMesg.SetField(new Field("AvgHeartRate", 15, 2, 1, 0, "bpm", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("MaxHeartRate", 16, 2, 1, 0, "bpm", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("AvgCadence", 17, 2, 1, 0, "rpm", false, Type.Uint8));
            subfieldIndex = 0;
            newMesg.FieldsList[fieldIndex].subfields.Add(new Subfield("AvgRunningCadence", 2, 1, 0, "strides/min"));
            newMesg.FieldsList[fieldIndex].subfields[subfieldIndex].AddMap(25, 1);
            subfieldIndex++;
            fieldIndex++;
            newMesg.SetField(new Field("MaxCadence", 18, 2, 1, 0, "rpm", false, Type.Uint8));
            subfieldIndex = 0;
            newMesg.FieldsList[fieldIndex].subfields.Add(new Subfield("MaxRunningCadence", 2, 1, 0, "strides/min"));
            newMesg.FieldsList[fieldIndex].subfields[subfieldIndex].AddMap(25, 1);
            subfieldIndex++;
            fieldIndex++;
            newMesg.SetField(new Field("AvgPower", 19, 132, 1, 0, "watts", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("MaxPower", 20, 132, 1, 0, "watts", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("TotalAscent", 21, 132, 1, 0, "m", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("TotalDescent", 22, 132, 1, 0, "m", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("Intensity", 23, 0, 1, 0, "", false, Type.Intensity));
            fieldIndex++;
            newMesg.SetField(new Field("LapTrigger", 24, 0, 1, 0, "", false, Type.LapTrigger));
            fieldIndex++;
            newMesg.SetField(new Field("Sport", 25, 0, 1, 0, "", false, Type.Sport));
            fieldIndex++;
            newMesg.SetField(new Field("EventGroup", 26, 2, 1, 0, "", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("NumLengths", 32, 132, 1, 0, "lengths", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("NormalizedPower", 33, 132, 1, 0, "watts", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("LeftRightBalance", 34, 132, 1, 0, "", false, Type.LeftRightBalance100));
            fieldIndex++;
            newMesg.SetField(new Field("FirstLengthIndex", 35, 132, 1, 0, "", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("AvgStrokeDistance", 37, 132, 100, 0, "m", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("SwimStroke", 38, 0, 1, 0, "", false, Type.SwimStroke));
            fieldIndex++;
            newMesg.SetField(new Field("SubSport", 39, 0, 1, 0, "", false, Type.SubSport));
            fieldIndex++;
            newMesg.SetField(new Field("NumActiveLengths", 40, 132, 1, 0, "lengths", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("TotalWork", 41, 134, 1, 0, "J", false, Type.Uint32));
            fieldIndex++;
            newMesg.SetField(new Field("AvgAltitude", 42, 132, 5, 500, "m", false, Type.Uint16));
            newMesg.FieldsList[fieldIndex].components.Add(new FieldComponent(112, false, 16, 5, 500)); // enhanced_avg_altitude
            fieldIndex++;
            newMesg.SetField(new Field("MaxAltitude", 43, 132, 5, 500, "m", false, Type.Uint16));
            newMesg.FieldsList[fieldIndex].components.Add(new FieldComponent(114, false, 16, 5, 500)); // enhanced_max_altitude
            fieldIndex++;
            newMesg.SetField(new Field("GpsAccuracy", 44, 2, 1, 0, "m", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("AvgGrade", 45, 131, 100, 0, "%", false, Type.Sint16));
            fieldIndex++;
            newMesg.SetField(new Field("AvgPosGrade", 46, 131, 100, 0, "%", false, Type.Sint16));
            fieldIndex++;
            newMesg.SetField(new Field("AvgNegGrade", 47, 131, 100, 0, "%", false, Type.Sint16));
            fieldIndex++;
            newMesg.SetField(new Field("MaxPosGrade", 48, 131, 100, 0, "%", false, Type.Sint16));
            fieldIndex++;
            newMesg.SetField(new Field("MaxNegGrade", 49, 131, 100, 0, "%", false, Type.Sint16));
            fieldIndex++;
            newMesg.SetField(new Field("AvgTemperature", 50, 1, 1, 0, "C", false, Type.Sint8));
            fieldIndex++;
            newMesg.SetField(new Field("MaxTemperature", 51, 1, 1, 0, "C", false, Type.Sint8));
            fieldIndex++;
            newMesg.SetField(new Field("TotalMovingTime", 52, 134, 1000, 0, "s", false, Type.Uint32));
            fieldIndex++;
            newMesg.SetField(new Field("AvgPosVerticalSpeed", 53, 131, 1000, 0, "m/s", false, Type.Sint16));
            fieldIndex++;
            newMesg.SetField(new Field("AvgNegVerticalSpeed", 54, 131, 1000, 0, "m/s", false, Type.Sint16));
            fieldIndex++;
            newMesg.SetField(new Field("MaxPosVerticalSpeed", 55, 131, 1000, 0, "m/s", false, Type.Sint16));
            fieldIndex++;
            newMesg.SetField(new Field("MaxNegVerticalSpeed", 56, 131, 1000, 0, "m/s", false, Type.Sint16));
            fieldIndex++;
            newMesg.SetField(new Field("TimeInHrZone", 57, 134, 1000, 0, "s", false, Type.Uint32));
            fieldIndex++;
            newMesg.SetField(new Field("TimeInSpeedZone", 58, 134, 1000, 0, "s", false, Type.Uint32));
            fieldIndex++;
            newMesg.SetField(new Field("TimeInCadenceZone", 59, 134, 1000, 0, "s", false, Type.Uint32));
            fieldIndex++;
            newMesg.SetField(new Field("TimeInPowerZone", 60, 134, 1000, 0, "s", false, Type.Uint32));
            fieldIndex++;
            newMesg.SetField(new Field("RepetitionNum", 61, 132, 1, 0, "", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("MinAltitude", 62, 132, 5, 500, "m", false, Type.Uint16));
            newMesg.FieldsList[fieldIndex].components.Add(new FieldComponent(113, false, 16, 5, 500)); // enhanced_min_altitude
            fieldIndex++;
            newMesg.SetField(new Field("MinHeartRate", 63, 2, 1, 0, "bpm", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("WktStepIndex", 71, 132, 1, 0, "", false, Type.MessageIndex));
            fieldIndex++;
            newMesg.SetField(new Field("OpponentScore", 74, 132, 1, 0, "", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("StrokeCount", 75, 132, 1, 0, "counts", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("ZoneCount", 76, 132, 1, 0, "counts", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("AvgVerticalOscillation", 77, 132, 10, 0, "mm", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("AvgStanceTimePercent", 78, 132, 100, 0, "percent", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("AvgStanceTime", 79, 132, 10, 0, "ms", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("AvgFractionalCadence", 80, 2, 128, 0, "rpm", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("MaxFractionalCadence", 81, 2, 128, 0, "rpm", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("TotalFractionalCycles", 82, 2, 128, 0, "cycles", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("PlayerScore", 83, 132, 1, 0, "", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("AvgTotalHemoglobinConc", 84, 132, 100, 0, "g/dL", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("MinTotalHemoglobinConc", 85, 132, 100, 0, "g/dL", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("MaxTotalHemoglobinConc", 86, 132, 100, 0, "g/dL", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("AvgSaturatedHemoglobinPercent", 87, 132, 10, 0, "%", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("MinSaturatedHemoglobinPercent", 88, 132, 10, 0, "%", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("MaxSaturatedHemoglobinPercent", 89, 132, 10, 0, "%", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("AvgLeftTorqueEffectiveness", 91, 2, 2, 0, "percent", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("AvgRightTorqueEffectiveness", 92, 2, 2, 0, "percent", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("AvgLeftPedalSmoothness", 93, 2, 2, 0, "percent", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("AvgRightPedalSmoothness", 94, 2, 2, 0, "percent", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("AvgCombinedPedalSmoothness", 95, 2, 2, 0, "percent", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("TimeStanding", 98, 134, 1000, 0, "s", false, Type.Uint32));
            fieldIndex++;
            newMesg.SetField(new Field("StandCount", 99, 132, 1, 0, "", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("AvgLeftPco", 100, 1, 1, 0, "mm", false, Type.Sint8));
            fieldIndex++;
            newMesg.SetField(new Field("AvgRightPco", 101, 1, 1, 0, "mm", false, Type.Sint8));
            fieldIndex++;
            newMesg.SetField(new Field("AvgLeftPowerPhase", 102, 2, 0.7111111, 0, "degrees", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("AvgLeftPowerPhasePeak", 103, 2, 0.7111111, 0, "degrees", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("AvgRightPowerPhase", 104, 2, 0.7111111, 0, "degrees", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("AvgRightPowerPhasePeak", 105, 2, 0.7111111, 0, "degrees", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("AvgPowerPosition", 106, 132, 1, 0, "watts", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("MaxPowerPosition", 107, 132, 1, 0, "watts", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("AvgCadencePosition", 108, 2, 1, 0, "rpm", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("MaxCadencePosition", 109, 2, 1, 0, "rpm", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("EnhancedAvgSpeed", 110, 134, 1000, 0, "m/s", false, Type.Uint32));
            fieldIndex++;
            newMesg.SetField(new Field("EnhancedMaxSpeed", 111, 134, 1000, 0, "m/s", false, Type.Uint32));
            fieldIndex++;
            newMesg.SetField(new Field("EnhancedAvgAltitude", 112, 134, 5, 500, "m", false, Type.Uint32));
            fieldIndex++;
            newMesg.SetField(new Field("EnhancedMinAltitude", 113, 134, 5, 500, "m", false, Type.Uint32));
            fieldIndex++;
            newMesg.SetField(new Field("EnhancedMaxAltitude", 114, 134, 5, 500, "m", false, Type.Uint32));
            fieldIndex++;
            newMesg.SetField(new Field("AvgLevMotorPower", 115, 132, 1, 0, "watts", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("MaxLevMotorPower", 116, 132, 1, 0, "watts", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("LevBatteryConsumption", 117, 2, 2, 0, "percent", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("AvgVerticalRatio", 118, 132, 100, 0, "percent", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("AvgStanceTimeBalance", 119, 132, 100, 0, "percent", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("AvgStepLength", 120, 132, 10, 0, "mm", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("AvgVam", 121, 132, 1000, 0, "m/s", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("TotalGrit", 149, 136, 1, 0, "kGrit", false, Type.Float32));
            fieldIndex++;
            newMesg.SetField(new Field("TotalFlow", 150, 136, 1, 0, "Flow", false, Type.Float32));
            fieldIndex++;
            newMesg.SetField(new Field("JumpCount", 151, 132, 1, 0, "", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("AvgGrit", 153, 136, 1, 0, "kGrit", false, Type.Float32));
            fieldIndex++;
            newMesg.SetField(new Field("AvgFlow", 154, 136, 1, 0, "Flow", false, Type.Float32));
            fieldIndex++;

            return newMesg;
        }
        
        private static Mesg CreateLengthMesg()
        {
            ushort fieldIndex, subfieldIndex;
            Mesg newMesg = new Mesg("Length", MesgNum.Length);
            fieldIndex = 0;
            newMesg.SetField(new Field("MessageIndex", 254, 132, 1, 0, "", false, Type.MessageIndex));
            fieldIndex++;
            newMesg.SetField(new Field("Timestamp", 253, 134, 1, 0, "", false, Type.DateTime));
            fieldIndex++;
            newMesg.SetField(new Field("Event", 0, 0, 1, 0, "", false, Type.Event));
            fieldIndex++;
            newMesg.SetField(new Field("EventType", 1, 0, 1, 0, "", false, Type.EventType));
            fieldIndex++;
            newMesg.SetField(new Field("StartTime", 2, 134, 1, 0, "", false, Type.DateTime));
            fieldIndex++;
            newMesg.SetField(new Field("TotalElapsedTime", 3, 134, 1000, 0, "s", false, Type.Uint32));
            fieldIndex++;
            newMesg.SetField(new Field("TotalTimerTime", 4, 134, 1000, 0, "s", false, Type.Uint32));
            fieldIndex++;
            newMesg.SetField(new Field("TotalStrokes", 5, 132, 1, 0, "strokes", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("AvgSpeed", 6, 132, 1000, 0, "m/s", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("SwimStroke", 7, 0, 1, 0, "swim_stroke", false, Type.SwimStroke));
            fieldIndex++;
            newMesg.SetField(new Field("AvgSwimmingCadence", 9, 2, 1, 0, "strokes/min", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("EventGroup", 10, 2, 1, 0, "", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("TotalCalories", 11, 132, 1, 0, "kcal", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("LengthType", 12, 0, 1, 0, "", false, Type.LengthType));
            fieldIndex++;
            newMesg.SetField(new Field("PlayerScore", 18, 132, 1, 0, "", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("OpponentScore", 19, 132, 1, 0, "", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("StrokeCount", 20, 132, 1, 0, "counts", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("ZoneCount", 21, 132, 1, 0, "counts", false, Type.Uint16));
            fieldIndex++;

            return newMesg;
        }
        
        private static Mesg CreateRecordMesg()
        {
            ushort fieldIndex, subfieldIndex;
            Mesg newMesg = new Mesg("Record", MesgNum.Record);
            fieldIndex = 0;
            newMesg.SetField(new Field("Timestamp", 253, 134, 1, 0, "s", false, Type.DateTime));
            fieldIndex++;
            newMesg.SetField(new Field("PositionLat", 0, 133, 1, 0, "semicircles", false, Type.Sint32));
            fieldIndex++;
            newMesg.SetField(new Field("PositionLong", 1, 133, 1, 0, "semicircles", false, Type.Sint32));
            fieldIndex++;
            newMesg.SetField(new Field("Altitude", 2, 132, 5, 500, "m", false, Type.Uint16));
            newMesg.FieldsList[fieldIndex].components.Add(new FieldComponent(78, false, 16, 5, 500)); // enhanced_altitude
            fieldIndex++;
            newMesg.SetField(new Field("HeartRate", 3, 2, 1, 0, "bpm", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("Cadence", 4, 2, 1, 0, "rpm", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("Distance", 5, 134, 100, 0, "m", true, Type.Uint32));
            fieldIndex++;
            newMesg.SetField(new Field("Speed", 6, 132, 1000, 0, "m/s", false, Type.Uint16));
            newMesg.FieldsList[fieldIndex].components.Add(new FieldComponent(73, false, 16, 1000, 0)); // enhanced_speed
            fieldIndex++;
            newMesg.SetField(new Field("Power", 7, 132, 1, 0, "watts", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("CompressedSpeedDistance", 8, 13, 1, 0, "", false, Type.Byte));
            newMesg.FieldsList[fieldIndex].components.Add(new FieldComponent(6, false, 12, 100, 0)); // speed
            newMesg.FieldsList[fieldIndex].components.Add(new FieldComponent(5, true, 12, 16, 0)); // distance
            fieldIndex++;
            newMesg.SetField(new Field("Grade", 9, 131, 100, 0, "%", false, Type.Sint16));
            fieldIndex++;
            newMesg.SetField(new Field("Resistance", 10, 2, 1, 0, "", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("TimeFromCourse", 11, 133, 1000, 0, "s", false, Type.Sint32));
            fieldIndex++;
            newMesg.SetField(new Field("CycleLength", 12, 2, 100, 0, "m", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("Temperature", 13, 1, 1, 0, "C", false, Type.Sint8));
            fieldIndex++;
            newMesg.SetField(new Field("Speed1s", 17, 2, 16, 0, "m/s", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("Cycles", 18, 2, 1, 0, "cycles", false, Type.Uint8));
            newMesg.FieldsList[fieldIndex].components.Add(new FieldComponent(19, true, 8, 1, 0)); // total_cycles
            fieldIndex++;
            newMesg.SetField(new Field("TotalCycles", 19, 134, 1, 0, "cycles", true, Type.Uint32));
            fieldIndex++;
            newMesg.SetField(new Field("CompressedAccumulatedPower", 28, 132, 1, 0, "watts", false, Type.Uint16));
            newMesg.FieldsList[fieldIndex].components.Add(new FieldComponent(29, true, 16, 1, 0)); // accumulated_power
            fieldIndex++;
            newMesg.SetField(new Field("AccumulatedPower", 29, 134, 1, 0, "watts", true, Type.Uint32));
            fieldIndex++;
            newMesg.SetField(new Field("LeftRightBalance", 30, 2, 1, 0, "", false, Type.LeftRightBalance));
            fieldIndex++;
            newMesg.SetField(new Field("GpsAccuracy", 31, 2, 1, 0, "m", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("VerticalSpeed", 32, 131, 1000, 0, "m/s", false, Type.Sint16));
            fieldIndex++;
            newMesg.SetField(new Field("Calories", 33, 132, 1, 0, "kcal", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("VerticalOscillation", 39, 132, 10, 0, "mm", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("StanceTimePercent", 40, 132, 100, 0, "percent", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("StanceTime", 41, 132, 10, 0, "ms", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("ActivityType", 42, 0, 1, 0, "", false, Type.ActivityType));
            fieldIndex++;
            newMesg.SetField(new Field("LeftTorqueEffectiveness", 43, 2, 2, 0, "percent", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("RightTorqueEffectiveness", 44, 2, 2, 0, "percent", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("LeftPedalSmoothness", 45, 2, 2, 0, "percent", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("RightPedalSmoothness", 46, 2, 2, 0, "percent", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("CombinedPedalSmoothness", 47, 2, 2, 0, "percent", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("Time128", 48, 2, 128, 0, "s", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("StrokeType", 49, 0, 1, 0, "", false, Type.StrokeType));
            fieldIndex++;
            newMesg.SetField(new Field("Zone", 50, 2, 1, 0, "", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("BallSpeed", 51, 132, 100, 0, "m/s", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("Cadence256", 52, 132, 256, 0, "rpm", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("FractionalCadence", 53, 2, 128, 0, "rpm", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("TotalHemoglobinConc", 54, 132, 100, 0, "g/dL", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("TotalHemoglobinConcMin", 55, 132, 100, 0, "g/dL", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("TotalHemoglobinConcMax", 56, 132, 100, 0, "g/dL", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("SaturatedHemoglobinPercent", 57, 132, 10, 0, "%", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("SaturatedHemoglobinPercentMin", 58, 132, 10, 0, "%", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("SaturatedHemoglobinPercentMax", 59, 132, 10, 0, "%", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("DeviceIndex", 62, 2, 1, 0, "", false, Type.DeviceIndex));
            fieldIndex++;
            newMesg.SetField(new Field("LeftPco", 67, 1, 1, 0, "mm", false, Type.Sint8));
            fieldIndex++;
            newMesg.SetField(new Field("RightPco", 68, 1, 1, 0, "mm", false, Type.Sint8));
            fieldIndex++;
            newMesg.SetField(new Field("LeftPowerPhase", 69, 2, 0.7111111, 0, "degrees", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("LeftPowerPhasePeak", 70, 2, 0.7111111, 0, "degrees", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("RightPowerPhase", 71, 2, 0.7111111, 0, "degrees", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("RightPowerPhasePeak", 72, 2, 0.7111111, 0, "degrees", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("EnhancedSpeed", 73, 134, 1000, 0, "m/s", false, Type.Uint32));
            fieldIndex++;
            newMesg.SetField(new Field("EnhancedAltitude", 78, 134, 5, 500, "m", false, Type.Uint32));
            fieldIndex++;
            newMesg.SetField(new Field("BatterySoc", 81, 2, 2, 0, "percent", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("MotorPower", 82, 132, 1, 0, "watts", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("VerticalRatio", 83, 132, 100, 0, "percent", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("StanceTimeBalance", 84, 132, 100, 0, "percent", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("StepLength", 85, 132, 10, 0, "mm", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("AbsolutePressure", 91, 134, 1, 0, "Pa", false, Type.Uint32));
            fieldIndex++;
            newMesg.SetField(new Field("Depth", 92, 134, 1000, 0, "m", false, Type.Uint32));
            fieldIndex++;
            newMesg.SetField(new Field("NextStopDepth", 93, 134, 1000, 0, "m", false, Type.Uint32));
            fieldIndex++;
            newMesg.SetField(new Field("NextStopTime", 94, 134, 1, 0, "s", false, Type.Uint32));
            fieldIndex++;
            newMesg.SetField(new Field("TimeToSurface", 95, 134, 1, 0, "s", false, Type.Uint32));
            fieldIndex++;
            newMesg.SetField(new Field("NdlTime", 96, 134, 1, 0, "s", false, Type.Uint32));
            fieldIndex++;
            newMesg.SetField(new Field("CnsLoad", 97, 2, 1, 0, "percent", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("N2Load", 98, 132, 1, 0, "percent", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("Grit", 114, 136, 1, 0, "", false, Type.Float32));
            fieldIndex++;
            newMesg.SetField(new Field("Flow", 115, 136, 1, 0, "", false, Type.Float32));
            fieldIndex++;
            newMesg.SetField(new Field("EbikeTravelRange", 117, 132, 1, 0, "km", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("EbikeBatteryLevel", 118, 2, 1, 0, "percent", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("EbikeAssistMode", 119, 2, 1, 0, "depends on sensor", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("EbikeAssistLevelPercent", 120, 2, 1, 0, "percent", false, Type.Uint8));
            fieldIndex++;

            return newMesg;
        }
        
        private static Mesg CreateEventMesg()
        {
            ushort fieldIndex, subfieldIndex;
            Mesg newMesg = new Mesg("Event", MesgNum.Event);
            fieldIndex = 0;
            newMesg.SetField(new Field("Timestamp", 253, 134, 1, 0, "s", false, Type.DateTime));
            fieldIndex++;
            newMesg.SetField(new Field("Event", 0, 0, 1, 0, "", false, Type.Event));
            fieldIndex++;
            newMesg.SetField(new Field("EventType", 1, 0, 1, 0, "", false, Type.EventType));
            fieldIndex++;
            newMesg.SetField(new Field("Data16", 2, 132, 1, 0, "", false, Type.Uint16));
            newMesg.FieldsList[fieldIndex].components.Add(new FieldComponent(3, false, 16, 1, 0)); // data
            fieldIndex++;
            newMesg.SetField(new Field("Data", 3, 134, 1, 0, "", false, Type.Uint32));
            subfieldIndex = 0;
            newMesg.FieldsList[fieldIndex].subfields.Add(new Subfield("TimerTrigger", 0, 1, 0, ""));
            newMesg.FieldsList[fieldIndex].subfields[subfieldIndex].AddMap(0, 0);
            subfieldIndex++;
            newMesg.FieldsList[fieldIndex].subfields.Add(new Subfield("CoursePointIndex", 132, 1, 0, ""));
            newMesg.FieldsList[fieldIndex].subfields[subfieldIndex].AddMap(0, 10);
            subfieldIndex++;
            newMesg.FieldsList[fieldIndex].subfields.Add(new Subfield("BatteryLevel", 132, 1000, 0, "V"));
            newMesg.FieldsList[fieldIndex].subfields[subfieldIndex].AddMap(0, 11);
            subfieldIndex++;
            newMesg.FieldsList[fieldIndex].subfields.Add(new Subfield("VirtualPartnerSpeed", 132, 1000, 0, "m/s"));
            newMesg.FieldsList[fieldIndex].subfields[subfieldIndex].AddMap(0, 12);
            subfieldIndex++;
            newMesg.FieldsList[fieldIndex].subfields.Add(new Subfield("HrHighAlert", 2, 1, 0, "bpm"));
            newMesg.FieldsList[fieldIndex].subfields[subfieldIndex].AddMap(0, 13);
            subfieldIndex++;
            newMesg.FieldsList[fieldIndex].subfields.Add(new Subfield("HrLowAlert", 2, 1, 0, "bpm"));
            newMesg.FieldsList[fieldIndex].subfields[subfieldIndex].AddMap(0, 14);
            subfieldIndex++;
            newMesg.FieldsList[fieldIndex].subfields.Add(new Subfield("SpeedHighAlert", 134, 1000, 0, "m/s"));
            newMesg.FieldsList[fieldIndex].subfields[subfieldIndex].AddMap(0, 15);
            subfieldIndex++;
            newMesg.FieldsList[fieldIndex].subfields.Add(new Subfield("SpeedLowAlert", 134, 1000, 0, "m/s"));
            newMesg.FieldsList[fieldIndex].subfields[subfieldIndex].AddMap(0, 16);
            subfieldIndex++;
            newMesg.FieldsList[fieldIndex].subfields.Add(new Subfield("CadHighAlert", 132, 1, 0, "rpm"));
            newMesg.FieldsList[fieldIndex].subfields[subfieldIndex].AddMap(0, 17);
            subfieldIndex++;
            newMesg.FieldsList[fieldIndex].subfields.Add(new Subfield("CadLowAlert", 132, 1, 0, "rpm"));
            newMesg.FieldsList[fieldIndex].subfields[subfieldIndex].AddMap(0, 18);
            subfieldIndex++;
            newMesg.FieldsList[fieldIndex].subfields.Add(new Subfield("PowerHighAlert", 132, 1, 0, "watts"));
            newMesg.FieldsList[fieldIndex].subfields[subfieldIndex].AddMap(0, 19);
            subfieldIndex++;
            newMesg.FieldsList[fieldIndex].subfields.Add(new Subfield("PowerLowAlert", 132, 1, 0, "watts"));
            newMesg.FieldsList[fieldIndex].subfields[subfieldIndex].AddMap(0, 20);
            subfieldIndex++;
            newMesg.FieldsList[fieldIndex].subfields.Add(new Subfield("TimeDurationAlert", 134, 1000, 0, "s"));
            newMesg.FieldsList[fieldIndex].subfields[subfieldIndex].AddMap(0, 23);
            subfieldIndex++;
            newMesg.FieldsList[fieldIndex].subfields.Add(new Subfield("DistanceDurationAlert", 134, 100, 0, "m"));
            newMesg.FieldsList[fieldIndex].subfields[subfieldIndex].AddMap(0, 24);
            subfieldIndex++;
            newMesg.FieldsList[fieldIndex].subfields.Add(new Subfield("CalorieDurationAlert", 134, 1, 0, "calories"));
            newMesg.FieldsList[fieldIndex].subfields[subfieldIndex].AddMap(0, 25);
            subfieldIndex++;
            newMesg.FieldsList[fieldIndex].subfields.Add(new Subfield("FitnessEquipmentState", 0, 1, 0, ""));
            newMesg.FieldsList[fieldIndex].subfields[subfieldIndex].AddMap(0, 27);
            subfieldIndex++;
            newMesg.FieldsList[fieldIndex].subfields.Add(new Subfield("SportPoint", 134, 1, 0, ""));
            newMesg.FieldsList[fieldIndex].subfields[subfieldIndex].AddMap(0, 33);
            newMesg.FieldsList[fieldIndex].subfields[subfieldIndex].AddComponent(new FieldComponent(7, false, 16, 1, 0)); // score
            newMesg.FieldsList[fieldIndex].subfields[subfieldIndex].AddComponent(new FieldComponent(8, false, 16, 1, 0)); // opponent_score
            subfieldIndex++;
            newMesg.FieldsList[fieldIndex].subfields.Add(new Subfield("GearChangeData", 134, 1, 0, ""));
            newMesg.FieldsList[fieldIndex].subfields[subfieldIndex].AddMap(0, 42);
            newMesg.FieldsList[fieldIndex].subfields[subfieldIndex].AddMap(0, 43);
            newMesg.FieldsList[fieldIndex].subfields[subfieldIndex].AddComponent(new FieldComponent(11, false, 8, 1, 0)); // rear_gear_num
            newMesg.FieldsList[fieldIndex].subfields[subfieldIndex].AddComponent(new FieldComponent(12, false, 8, 1, 0)); // rear_gear
            newMesg.FieldsList[fieldIndex].subfields[subfieldIndex].AddComponent(new FieldComponent(9, false, 8, 1, 0)); // front_gear_num
            newMesg.FieldsList[fieldIndex].subfields[subfieldIndex].AddComponent(new FieldComponent(10, false, 8, 1, 0)); // front_gear
            subfieldIndex++;
            newMesg.FieldsList[fieldIndex].subfields.Add(new Subfield("RiderPosition", 0, 1, 0, ""));
            newMesg.FieldsList[fieldIndex].subfields[subfieldIndex].AddMap(0, 44);
            subfieldIndex++;
            newMesg.FieldsList[fieldIndex].subfields.Add(new Subfield("CommTimeout", 132, 1, 0, ""));
            newMesg.FieldsList[fieldIndex].subfields[subfieldIndex].AddMap(0, 47);
            subfieldIndex++;
            newMesg.FieldsList[fieldIndex].subfields.Add(new Subfield("RadarThreatAlert", 134, 1, 0, ""));
            newMesg.FieldsList[fieldIndex].subfields[subfieldIndex].AddMap(0, 75);
            newMesg.FieldsList[fieldIndex].subfields[subfieldIndex].AddComponent(new FieldComponent(21, false, 8, 1, 0)); // radar_threat_level_max
            newMesg.FieldsList[fieldIndex].subfields[subfieldIndex].AddComponent(new FieldComponent(22, false, 8, 1, 0)); // radar_threat_count
            subfieldIndex++;
            fieldIndex++;
            newMesg.SetField(new Field("EventGroup", 4, 2, 1, 0, "", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("Score", 7, 132, 1, 0, "", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("OpponentScore", 8, 132, 1, 0, "", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("FrontGearNum", 9, 10, 1, 0, "", false, Type.Uint8z));
            fieldIndex++;
            newMesg.SetField(new Field("FrontGear", 10, 10, 1, 0, "", false, Type.Uint8z));
            fieldIndex++;
            newMesg.SetField(new Field("RearGearNum", 11, 10, 1, 0, "", false, Type.Uint8z));
            fieldIndex++;
            newMesg.SetField(new Field("RearGear", 12, 10, 1, 0, "", false, Type.Uint8z));
            fieldIndex++;
            newMesg.SetField(new Field("DeviceIndex", 13, 2, 1, 0, "", false, Type.DeviceIndex));
            fieldIndex++;
            newMesg.SetField(new Field("RadarThreatLevelMax", 21, 0, 1, 0, "", false, Type.RadarThreatLevelType));
            fieldIndex++;
            newMesg.SetField(new Field("RadarThreatCount", 22, 2, 1, 0, "", false, Type.Uint8));
            fieldIndex++;

            return newMesg;
        }
        
        private static Mesg CreateDeviceInfoMesg()
        {
            ushort fieldIndex, subfieldIndex;
            Mesg newMesg = new Mesg("DeviceInfo", MesgNum.DeviceInfo);
            fieldIndex = 0;
            newMesg.SetField(new Field("Timestamp", 253, 134, 1, 0, "s", false, Type.DateTime));
            fieldIndex++;
            newMesg.SetField(new Field("DeviceIndex", 0, 2, 1, 0, "", false, Type.DeviceIndex));
            fieldIndex++;
            newMesg.SetField(new Field("DeviceType", 1, 2, 1, 0, "", false, Type.Uint8));
            subfieldIndex = 0;
            newMesg.FieldsList[fieldIndex].subfields.Add(new Subfield("AntplusDeviceType", 2, 1, 0, ""));
            newMesg.FieldsList[fieldIndex].subfields[subfieldIndex].AddMap(25, 1);
            subfieldIndex++;
            newMesg.FieldsList[fieldIndex].subfields.Add(new Subfield("AntDeviceType", 2, 1, 0, ""));
            newMesg.FieldsList[fieldIndex].subfields[subfieldIndex].AddMap(25, 0);
            subfieldIndex++;
            fieldIndex++;
            newMesg.SetField(new Field("Manufacturer", 2, 132, 1, 0, "", false, Type.Manufacturer));
            fieldIndex++;
            newMesg.SetField(new Field("SerialNumber", 3, 140, 1, 0, "", false, Type.Uint32z));
            fieldIndex++;
            newMesg.SetField(new Field("Product", 4, 132, 1, 0, "", false, Type.Uint16));
            subfieldIndex = 0;
            newMesg.FieldsList[fieldIndex].subfields.Add(new Subfield("FaveroProduct", 132, 1, 0, ""));
            newMesg.FieldsList[fieldIndex].subfields[subfieldIndex].AddMap(2, 263);
            subfieldIndex++;
            newMesg.FieldsList[fieldIndex].subfields.Add(new Subfield("GarminProduct", 132, 1, 0, ""));
            newMesg.FieldsList[fieldIndex].subfields[subfieldIndex].AddMap(2, 1);
            newMesg.FieldsList[fieldIndex].subfields[subfieldIndex].AddMap(2, 15);
            newMesg.FieldsList[fieldIndex].subfields[subfieldIndex].AddMap(2, 13);
            newMesg.FieldsList[fieldIndex].subfields[subfieldIndex].AddMap(2, 89);
            subfieldIndex++;
            fieldIndex++;
            newMesg.SetField(new Field("SoftwareVersion", 5, 132, 100, 0, "", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("HardwareVersion", 6, 2, 1, 0, "", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("CumOperatingTime", 7, 134, 1, 0, "s", false, Type.Uint32));
            fieldIndex++;
            newMesg.SetField(new Field("BatteryVoltage", 10, 132, 256, 0, "V", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("BatteryStatus", 11, 2, 1, 0, "", false, Type.BatteryStatus));
            fieldIndex++;
            newMesg.SetField(new Field("SensorPosition", 18, 0, 1, 0, "", false, Type.BodyLocation));
            fieldIndex++;
            newMesg.SetField(new Field("Descriptor", 19, 7, 1, 0, "", false, Type.String));
            fieldIndex++;
            newMesg.SetField(new Field("AntTransmissionType", 20, 10, 1, 0, "", false, Type.Uint8z));
            fieldIndex++;
            newMesg.SetField(new Field("AntDeviceNumber", 21, 139, 1, 0, "", false, Type.Uint16z));
            fieldIndex++;
            newMesg.SetField(new Field("AntNetwork", 22, 0, 1, 0, "", false, Type.AntNetwork));
            fieldIndex++;
            newMesg.SetField(new Field("SourceType", 25, 0, 1, 0, "", false, Type.SourceType));
            fieldIndex++;
            newMesg.SetField(new Field("ProductName", 27, 7, 1, 0, "", false, Type.String));
            fieldIndex++;

            return newMesg;
        }
        
        private static Mesg CreateTrainingFileMesg()
        {
            ushort fieldIndex, subfieldIndex;
            Mesg newMesg = new Mesg("TrainingFile", MesgNum.TrainingFile);
            fieldIndex = 0;
            newMesg.SetField(new Field("Timestamp", 253, 134, 1, 0, "", false, Type.DateTime));
            fieldIndex++;
            newMesg.SetField(new Field("Type", 0, 0, 1, 0, "", false, Type.File));
            fieldIndex++;
            newMesg.SetField(new Field("Manufacturer", 1, 132, 1, 0, "", false, Type.Manufacturer));
            fieldIndex++;
            newMesg.SetField(new Field("Product", 2, 132, 1, 0, "", false, Type.Uint16));
            subfieldIndex = 0;
            newMesg.FieldsList[fieldIndex].subfields.Add(new Subfield("FaveroProduct", 132, 1, 0, ""));
            newMesg.FieldsList[fieldIndex].subfields[subfieldIndex].AddMap(1, 263);
            subfieldIndex++;
            newMesg.FieldsList[fieldIndex].subfields.Add(new Subfield("GarminProduct", 132, 1, 0, ""));
            newMesg.FieldsList[fieldIndex].subfields[subfieldIndex].AddMap(1, 1);
            newMesg.FieldsList[fieldIndex].subfields[subfieldIndex].AddMap(1, 15);
            newMesg.FieldsList[fieldIndex].subfields[subfieldIndex].AddMap(1, 13);
            newMesg.FieldsList[fieldIndex].subfields[subfieldIndex].AddMap(1, 89);
            subfieldIndex++;
            fieldIndex++;
            newMesg.SetField(new Field("SerialNumber", 3, 140, 1, 0, "", false, Type.Uint32z));
            fieldIndex++;
            newMesg.SetField(new Field("TimeCreated", 4, 134, 1, 0, "", false, Type.DateTime));
            fieldIndex++;

            return newMesg;
        }
        
        private static Mesg CreateHrvMesg()
        {
            ushort fieldIndex, subfieldIndex;
            Mesg newMesg = new Mesg("Hrv", MesgNum.Hrv);
            fieldIndex = 0;
            newMesg.SetField(new Field("Time", 0, 132, 1000, 0, "s", false, Type.Uint16));
            fieldIndex++;

            return newMesg;
        }
        
        private static Mesg CreateWeatherConditionsMesg()
        {
            ushort fieldIndex, subfieldIndex;
            Mesg newMesg = new Mesg("WeatherConditions", MesgNum.WeatherConditions);
            fieldIndex = 0;
            newMesg.SetField(new Field("Timestamp", 253, 134, 1, 0, "", false, Type.DateTime));
            fieldIndex++;
            newMesg.SetField(new Field("WeatherReport", 0, 0, 1, 0, "", false, Type.WeatherReport));
            fieldIndex++;
            newMesg.SetField(new Field("Temperature", 1, 1, 1, 0, "C", false, Type.Sint8));
            fieldIndex++;
            newMesg.SetField(new Field("Condition", 2, 0, 1, 0, "", false, Type.WeatherStatus));
            fieldIndex++;
            newMesg.SetField(new Field("WindDirection", 3, 132, 1, 0, "degrees", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("WindSpeed", 4, 132, 1000, 0, "m/s", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("PrecipitationProbability", 5, 2, 1, 0, "", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("TemperatureFeelsLike", 6, 1, 1, 0, "C", false, Type.Sint8));
            fieldIndex++;
            newMesg.SetField(new Field("RelativeHumidity", 7, 2, 1, 0, "", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("Location", 8, 7, 1, 0, "", false, Type.String));
            fieldIndex++;
            newMesg.SetField(new Field("ObservedAtTime", 9, 134, 1, 0, "", false, Type.DateTime));
            fieldIndex++;
            newMesg.SetField(new Field("ObservedLocationLat", 10, 133, 1, 0, "semicircles", false, Type.Sint32));
            fieldIndex++;
            newMesg.SetField(new Field("ObservedLocationLong", 11, 133, 1, 0, "semicircles", false, Type.Sint32));
            fieldIndex++;
            newMesg.SetField(new Field("DayOfWeek", 12, 0, 1, 0, "", false, Type.DayOfWeek));
            fieldIndex++;
            newMesg.SetField(new Field("HighTemperature", 13, 1, 1, 0, "C", false, Type.Sint8));
            fieldIndex++;
            newMesg.SetField(new Field("LowTemperature", 14, 1, 1, 0, "C", false, Type.Sint8));
            fieldIndex++;

            return newMesg;
        }
        
        private static Mesg CreateWeatherAlertMesg()
        {
            ushort fieldIndex, subfieldIndex;
            Mesg newMesg = new Mesg("WeatherAlert", MesgNum.WeatherAlert);
            fieldIndex = 0;
            newMesg.SetField(new Field("Timestamp", 253, 134, 1, 0, "", false, Type.DateTime));
            fieldIndex++;
            newMesg.SetField(new Field("ReportId", 0, 7, 1, 0, "", false, Type.String));
            fieldIndex++;
            newMesg.SetField(new Field("IssueTime", 1, 134, 1, 0, "", false, Type.DateTime));
            fieldIndex++;
            newMesg.SetField(new Field("ExpireTime", 2, 134, 1, 0, "", false, Type.DateTime));
            fieldIndex++;
            newMesg.SetField(new Field("Severity", 3, 0, 1, 0, "", false, Type.WeatherSeverity));
            fieldIndex++;
            newMesg.SetField(new Field("Type", 4, 0, 1, 0, "", false, Type.WeatherSevereType));
            fieldIndex++;

            return newMesg;
        }
        
        private static Mesg CreateGpsMetadataMesg()
        {
            ushort fieldIndex, subfieldIndex;
            Mesg newMesg = new Mesg("GpsMetadata", MesgNum.GpsMetadata);
            fieldIndex = 0;
            newMesg.SetField(new Field("Timestamp", 253, 134, 1, 0, "s", false, Type.DateTime));
            fieldIndex++;
            newMesg.SetField(new Field("TimestampMs", 0, 132, 1, 0, "ms", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("PositionLat", 1, 133, 1, 0, "semicircles", false, Type.Sint32));
            fieldIndex++;
            newMesg.SetField(new Field("PositionLong", 2, 133, 1, 0, "semicircles", false, Type.Sint32));
            fieldIndex++;
            newMesg.SetField(new Field("EnhancedAltitude", 3, 134, 5, 500, "m", false, Type.Uint32));
            fieldIndex++;
            newMesg.SetField(new Field("EnhancedSpeed", 4, 134, 1000, 0, "m/s", false, Type.Uint32));
            fieldIndex++;
            newMesg.SetField(new Field("Heading", 5, 132, 100, 0, "degrees", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("UtcTimestamp", 6, 134, 1, 0, "s", false, Type.DateTime));
            fieldIndex++;
            newMesg.SetField(new Field("Velocity", 7, 131, 100, 0, "m/s", false, Type.Sint16));
            fieldIndex++;

            return newMesg;
        }
        
        private static Mesg CreateCameraEventMesg()
        {
            ushort fieldIndex, subfieldIndex;
            Mesg newMesg = new Mesg("CameraEvent", MesgNum.CameraEvent);
            fieldIndex = 0;
            newMesg.SetField(new Field("Timestamp", 253, 134, 1, 0, "s", false, Type.DateTime));
            fieldIndex++;
            newMesg.SetField(new Field("TimestampMs", 0, 132, 1, 0, "ms", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("CameraEventType", 1, 0, 1, 0, "", false, Type.CameraEventType));
            fieldIndex++;
            newMesg.SetField(new Field("CameraFileUuid", 2, 7, 1, 0, "", false, Type.String));
            fieldIndex++;
            newMesg.SetField(new Field("CameraOrientation", 3, 0, 1, 0, "", false, Type.CameraOrientationType));
            fieldIndex++;

            return newMesg;
        }
        
        private static Mesg CreateGyroscopeDataMesg()
        {
            ushort fieldIndex, subfieldIndex;
            Mesg newMesg = new Mesg("GyroscopeData", MesgNum.GyroscopeData);
            fieldIndex = 0;
            newMesg.SetField(new Field("Timestamp", 253, 134, 1, 0, "s", false, Type.DateTime));
            fieldIndex++;
            newMesg.SetField(new Field("TimestampMs", 0, 132, 1, 0, "ms", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("SampleTimeOffset", 1, 132, 1, 0, "ms", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("GyroX", 2, 132, 1, 0, "counts", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("GyroY", 3, 132, 1, 0, "counts", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("GyroZ", 4, 132, 1, 0, "counts", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("CalibratedGyroX", 5, 136, 1, 0, "deg/s", false, Type.Float32));
            fieldIndex++;
            newMesg.SetField(new Field("CalibratedGyroY", 6, 136, 1, 0, "deg/s", false, Type.Float32));
            fieldIndex++;
            newMesg.SetField(new Field("CalibratedGyroZ", 7, 136, 1, 0, "deg/s", false, Type.Float32));
            fieldIndex++;

            return newMesg;
        }
        
        private static Mesg CreateAccelerometerDataMesg()
        {
            ushort fieldIndex, subfieldIndex;
            Mesg newMesg = new Mesg("AccelerometerData", MesgNum.AccelerometerData);
            fieldIndex = 0;
            newMesg.SetField(new Field("Timestamp", 253, 134, 1, 0, "s", false, Type.DateTime));
            fieldIndex++;
            newMesg.SetField(new Field("TimestampMs", 0, 132, 1, 0, "ms", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("SampleTimeOffset", 1, 132, 1, 0, "ms", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("AccelX", 2, 132, 1, 0, "counts", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("AccelY", 3, 132, 1, 0, "counts", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("AccelZ", 4, 132, 1, 0, "counts", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("CalibratedAccelX", 5, 136, 1, 0, "g", false, Type.Float32));
            fieldIndex++;
            newMesg.SetField(new Field("CalibratedAccelY", 6, 136, 1, 0, "g", false, Type.Float32));
            fieldIndex++;
            newMesg.SetField(new Field("CalibratedAccelZ", 7, 136, 1, 0, "g", false, Type.Float32));
            fieldIndex++;
            newMesg.SetField(new Field("CompressedCalibratedAccelX", 8, 131, 1, 0, "mG", false, Type.Sint16));
            fieldIndex++;
            newMesg.SetField(new Field("CompressedCalibratedAccelY", 9, 131, 1, 0, "mG", false, Type.Sint16));
            fieldIndex++;
            newMesg.SetField(new Field("CompressedCalibratedAccelZ", 10, 131, 1, 0, "mG", false, Type.Sint16));
            fieldIndex++;

            return newMesg;
        }
        
        private static Mesg CreateMagnetometerDataMesg()
        {
            ushort fieldIndex, subfieldIndex;
            Mesg newMesg = new Mesg("MagnetometerData", MesgNum.MagnetometerData);
            fieldIndex = 0;
            newMesg.SetField(new Field("Timestamp", 253, 134, 1, 0, "s", false, Type.DateTime));
            fieldIndex++;
            newMesg.SetField(new Field("TimestampMs", 0, 132, 1, 0, "ms", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("SampleTimeOffset", 1, 132, 1, 0, "ms", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("MagX", 2, 132, 1, 0, "counts", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("MagY", 3, 132, 1, 0, "counts", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("MagZ", 4, 132, 1, 0, "counts", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("CalibratedMagX", 5, 136, 1, 0, "G", false, Type.Float32));
            fieldIndex++;
            newMesg.SetField(new Field("CalibratedMagY", 6, 136, 1, 0, "G", false, Type.Float32));
            fieldIndex++;
            newMesg.SetField(new Field("CalibratedMagZ", 7, 136, 1, 0, "G", false, Type.Float32));
            fieldIndex++;

            return newMesg;
        }
        
        private static Mesg CreateBarometerDataMesg()
        {
            ushort fieldIndex, subfieldIndex;
            Mesg newMesg = new Mesg("BarometerData", MesgNum.BarometerData);
            fieldIndex = 0;
            newMesg.SetField(new Field("Timestamp", 253, 134, 1, 0, "s", false, Type.DateTime));
            fieldIndex++;
            newMesg.SetField(new Field("TimestampMs", 0, 132, 1, 0, "ms", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("SampleTimeOffset", 1, 132, 1, 0, "ms", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("BaroPres", 2, 134, 1, 0, "Pa", false, Type.Uint32));
            fieldIndex++;

            return newMesg;
        }
        
        private static Mesg CreateThreeDSensorCalibrationMesg()
        {
            ushort fieldIndex, subfieldIndex;
            Mesg newMesg = new Mesg("ThreeDSensorCalibration", MesgNum.ThreeDSensorCalibration);
            fieldIndex = 0;
            newMesg.SetField(new Field("Timestamp", 253, 134, 1, 0, "s", false, Type.DateTime));
            fieldIndex++;
            newMesg.SetField(new Field("SensorType", 0, 0, 1, 0, "", false, Type.SensorType));
            fieldIndex++;
            newMesg.SetField(new Field("CalibrationFactor", 1, 134, 1, 0, "", false, Type.Uint32));
            subfieldIndex = 0;
            newMesg.FieldsList[fieldIndex].subfields.Add(new Subfield("AccelCalFactor", 134, 1, 0, "g"));
            newMesg.FieldsList[fieldIndex].subfields[subfieldIndex].AddMap(0, 0);
            subfieldIndex++;
            newMesg.FieldsList[fieldIndex].subfields.Add(new Subfield("GyroCalFactor", 134, 1, 0, "deg/s"));
            newMesg.FieldsList[fieldIndex].subfields[subfieldIndex].AddMap(0, 1);
            subfieldIndex++;
            fieldIndex++;
            newMesg.SetField(new Field("CalibrationDivisor", 2, 134, 1, 0, "counts", false, Type.Uint32));
            fieldIndex++;
            newMesg.SetField(new Field("LevelShift", 3, 134, 1, 0, "", false, Type.Uint32));
            fieldIndex++;
            newMesg.SetField(new Field("OffsetCal", 4, 133, 1, 0, "", false, Type.Sint32));
            fieldIndex++;
            newMesg.SetField(new Field("OrientationMatrix", 5, 133, 65535, 0, "", false, Type.Sint32));
            fieldIndex++;

            return newMesg;
        }
        
        private static Mesg CreateOneDSensorCalibrationMesg()
        {
            ushort fieldIndex, subfieldIndex;
            Mesg newMesg = new Mesg("OneDSensorCalibration", MesgNum.OneDSensorCalibration);
            fieldIndex = 0;
            newMesg.SetField(new Field("Timestamp", 253, 134, 1, 0, "s", false, Type.DateTime));
            fieldIndex++;
            newMesg.SetField(new Field("SensorType", 0, 0, 1, 0, "", false, Type.SensorType));
            fieldIndex++;
            newMesg.SetField(new Field("CalibrationFactor", 1, 134, 1, 0, "", false, Type.Uint32));
            subfieldIndex = 0;
            newMesg.FieldsList[fieldIndex].subfields.Add(new Subfield("BaroCalFactor", 134, 1, 0, "Pa"));
            newMesg.FieldsList[fieldIndex].subfields[subfieldIndex].AddMap(0, 3);
            subfieldIndex++;
            fieldIndex++;
            newMesg.SetField(new Field("CalibrationDivisor", 2, 134, 1, 0, "counts", false, Type.Uint32));
            fieldIndex++;
            newMesg.SetField(new Field("LevelShift", 3, 134, 1, 0, "", false, Type.Uint32));
            fieldIndex++;
            newMesg.SetField(new Field("OffsetCal", 4, 133, 1, 0, "", false, Type.Sint32));
            fieldIndex++;

            return newMesg;
        }
        
        private static Mesg CreateVideoFrameMesg()
        {
            ushort fieldIndex, subfieldIndex;
            Mesg newMesg = new Mesg("VideoFrame", MesgNum.VideoFrame);
            fieldIndex = 0;
            newMesg.SetField(new Field("Timestamp", 253, 134, 1, 0, "s", false, Type.DateTime));
            fieldIndex++;
            newMesg.SetField(new Field("TimestampMs", 0, 132, 1, 0, "ms", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("FrameNumber", 1, 134, 1, 0, "", false, Type.Uint32));
            fieldIndex++;

            return newMesg;
        }
        
        private static Mesg CreateObdiiDataMesg()
        {
            ushort fieldIndex, subfieldIndex;
            Mesg newMesg = new Mesg("ObdiiData", MesgNum.ObdiiData);
            fieldIndex = 0;
            newMesg.SetField(new Field("Timestamp", 253, 134, 1, 0, "s", false, Type.DateTime));
            fieldIndex++;
            newMesg.SetField(new Field("TimestampMs", 0, 132, 1, 0, "ms", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("TimeOffset", 1, 132, 1, 0, "ms", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("Pid", 2, 13, 1, 0, "", false, Type.Byte));
            fieldIndex++;
            newMesg.SetField(new Field("RawData", 3, 13, 1, 0, "", false, Type.Byte));
            fieldIndex++;
            newMesg.SetField(new Field("PidDataSize", 4, 2, 1, 0, "", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("SystemTime", 5, 134, 1, 0, "", false, Type.Uint32));
            fieldIndex++;
            newMesg.SetField(new Field("StartTimestamp", 6, 134, 1, 0, "", false, Type.DateTime));
            fieldIndex++;
            newMesg.SetField(new Field("StartTimestampMs", 7, 132, 1, 0, "ms", false, Type.Uint16));
            fieldIndex++;

            return newMesg;
        }
        
        private static Mesg CreateNmeaSentenceMesg()
        {
            ushort fieldIndex, subfieldIndex;
            Mesg newMesg = new Mesg("NmeaSentence", MesgNum.NmeaSentence);
            fieldIndex = 0;
            newMesg.SetField(new Field("Timestamp", 253, 134, 1, 0, "s", false, Type.DateTime));
            fieldIndex++;
            newMesg.SetField(new Field("TimestampMs", 0, 132, 1, 0, "ms", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("Sentence", 1, 7, 1, 0, "", false, Type.String));
            fieldIndex++;

            return newMesg;
        }
        
        private static Mesg CreateAviationAttitudeMesg()
        {
            ushort fieldIndex, subfieldIndex;
            Mesg newMesg = new Mesg("AviationAttitude", MesgNum.AviationAttitude);
            fieldIndex = 0;
            newMesg.SetField(new Field("Timestamp", 253, 134, 1, 0, "s", false, Type.DateTime));
            fieldIndex++;
            newMesg.SetField(new Field("TimestampMs", 0, 132, 1, 0, "ms", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("SystemTime", 1, 134, 1, 0, "ms", false, Type.Uint32));
            fieldIndex++;
            newMesg.SetField(new Field("Pitch", 2, 131, 10430.38, 0, "radians", false, Type.Sint16));
            fieldIndex++;
            newMesg.SetField(new Field("Roll", 3, 131, 10430.38, 0, "radians", false, Type.Sint16));
            fieldIndex++;
            newMesg.SetField(new Field("AccelLateral", 4, 131, 100, 0, "m/s^2", false, Type.Sint16));
            fieldIndex++;
            newMesg.SetField(new Field("AccelNormal", 5, 131, 100, 0, "m/s^2", false, Type.Sint16));
            fieldIndex++;
            newMesg.SetField(new Field("TurnRate", 6, 131, 1024, 0, "radians/second", false, Type.Sint16));
            fieldIndex++;
            newMesg.SetField(new Field("Stage", 7, 0, 1, 0, "", false, Type.AttitudeStage));
            fieldIndex++;
            newMesg.SetField(new Field("AttitudeStageComplete", 8, 2, 1, 0, "%", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("Track", 9, 132, 10430.38, 0, "radians", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("Validity", 10, 132, 1, 0, "", false, Type.AttitudeValidity));
            fieldIndex++;

            return newMesg;
        }
        
        private static Mesg CreateVideoMesg()
        {
            ushort fieldIndex, subfieldIndex;
            Mesg newMesg = new Mesg("Video", MesgNum.Video);
            fieldIndex = 0;
            newMesg.SetField(new Field("Url", 0, 7, 1, 0, "", false, Type.String));
            fieldIndex++;
            newMesg.SetField(new Field("HostingProvider", 1, 7, 1, 0, "", false, Type.String));
            fieldIndex++;
            newMesg.SetField(new Field("Duration", 2, 134, 1, 0, "ms", false, Type.Uint32));
            fieldIndex++;

            return newMesg;
        }
        
        private static Mesg CreateVideoTitleMesg()
        {
            ushort fieldIndex, subfieldIndex;
            Mesg newMesg = new Mesg("VideoTitle", MesgNum.VideoTitle);
            fieldIndex = 0;
            newMesg.SetField(new Field("MessageIndex", 254, 132, 1, 0, "", false, Type.MessageIndex));
            fieldIndex++;
            newMesg.SetField(new Field("MessageCount", 0, 132, 1, 0, "", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("Text", 1, 7, 1, 0, "", false, Type.String));
            fieldIndex++;

            return newMesg;
        }
        
        private static Mesg CreateVideoDescriptionMesg()
        {
            ushort fieldIndex, subfieldIndex;
            Mesg newMesg = new Mesg("VideoDescription", MesgNum.VideoDescription);
            fieldIndex = 0;
            newMesg.SetField(new Field("MessageIndex", 254, 132, 1, 0, "", false, Type.MessageIndex));
            fieldIndex++;
            newMesg.SetField(new Field("MessageCount", 0, 132, 1, 0, "", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("Text", 1, 7, 1, 0, "", false, Type.String));
            fieldIndex++;

            return newMesg;
        }
        
        private static Mesg CreateVideoClipMesg()
        {
            ushort fieldIndex, subfieldIndex;
            Mesg newMesg = new Mesg("VideoClip", MesgNum.VideoClip);
            fieldIndex = 0;
            newMesg.SetField(new Field("ClipNumber", 0, 132, 1, 0, "", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("StartTimestamp", 1, 134, 1, 0, "", false, Type.DateTime));
            fieldIndex++;
            newMesg.SetField(new Field("StartTimestampMs", 2, 132, 1, 0, "", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("EndTimestamp", 3, 134, 1, 0, "", false, Type.DateTime));
            fieldIndex++;
            newMesg.SetField(new Field("EndTimestampMs", 4, 132, 1, 0, "", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("ClipStart", 6, 134, 1, 0, "ms", false, Type.Uint32));
            fieldIndex++;
            newMesg.SetField(new Field("ClipEnd", 7, 134, 1, 0, "ms", false, Type.Uint32));
            fieldIndex++;

            return newMesg;
        }
        
        private static Mesg CreateSetMesg()
        {
            ushort fieldIndex, subfieldIndex;
            Mesg newMesg = new Mesg("Set", MesgNum.Set);
            fieldIndex = 0;
            newMesg.SetField(new Field("Timestamp", 254, 134, 1, 0, "", false, Type.DateTime));
            fieldIndex++;
            newMesg.SetField(new Field("Duration", 0, 134, 1000, 0, "s", false, Type.Uint32));
            fieldIndex++;
            newMesg.SetField(new Field("Repetitions", 3, 132, 1, 0, "", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("Weight", 4, 132, 16, 0, "kg", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("SetType", 5, 2, 1, 0, "", false, Type.SetType));
            fieldIndex++;
            newMesg.SetField(new Field("StartTime", 6, 134, 1, 0, "", false, Type.DateTime));
            fieldIndex++;
            newMesg.SetField(new Field("Category", 7, 132, 1, 0, "", false, Type.ExerciseCategory));
            fieldIndex++;
            newMesg.SetField(new Field("CategorySubtype", 8, 132, 1, 0, "", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("WeightDisplayUnit", 9, 132, 1, 0, "", false, Type.FitBaseUnit));
            fieldIndex++;
            newMesg.SetField(new Field("MessageIndex", 10, 132, 1, 0, "", false, Type.MessageIndex));
            fieldIndex++;
            newMesg.SetField(new Field("WktStepIndex", 11, 132, 1, 0, "", false, Type.MessageIndex));
            fieldIndex++;

            return newMesg;
        }
        
        private static Mesg CreateJumpMesg()
        {
            ushort fieldIndex, subfieldIndex;
            Mesg newMesg = new Mesg("Jump", MesgNum.Jump);
            fieldIndex = 0;
            newMesg.SetField(new Field("Timestamp", 253, 134, 1, 0, "s", false, Type.DateTime));
            fieldIndex++;
            newMesg.SetField(new Field("Distance", 0, 136, 1, 0, "m", false, Type.Float32));
            fieldIndex++;
            newMesg.SetField(new Field("Height", 1, 136, 1, 0, "m", false, Type.Float32));
            fieldIndex++;
            newMesg.SetField(new Field("Rotations", 2, 2, 1, 0, "", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("HangTime", 3, 136, 1, 0, "s", false, Type.Float32));
            fieldIndex++;
            newMesg.SetField(new Field("Score", 4, 136, 1, 0, "", false, Type.Float32));
            fieldIndex++;
            newMesg.SetField(new Field("PositionLat", 5, 133, 1, 0, "semicircles", false, Type.Sint32));
            fieldIndex++;
            newMesg.SetField(new Field("PositionLong", 6, 133, 1, 0, "semicircles", false, Type.Sint32));
            fieldIndex++;
            newMesg.SetField(new Field("Speed", 7, 132, 1000, 0, "m/s", false, Type.Uint16));
            newMesg.FieldsList[fieldIndex].components.Add(new FieldComponent(8, false, 16, 1000, 0)); // enhanced_speed
            fieldIndex++;
            newMesg.SetField(new Field("EnhancedSpeed", 8, 134, 1000, 0, "m/s", false, Type.Uint32));
            fieldIndex++;

            return newMesg;
        }
        
        private static Mesg CreateCourseMesg()
        {
            ushort fieldIndex, subfieldIndex;
            Mesg newMesg = new Mesg("Course", MesgNum.Course);
            fieldIndex = 0;
            newMesg.SetField(new Field("Sport", 4, 0, 1, 0, "", false, Type.Sport));
            fieldIndex++;
            newMesg.SetField(new Field("Name", 5, 7, 1, 0, "", false, Type.String));
            fieldIndex++;
            newMesg.SetField(new Field("Capabilities", 6, 140, 1, 0, "", false, Type.CourseCapabilities));
            fieldIndex++;
            newMesg.SetField(new Field("SubSport", 7, 0, 1, 0, "", false, Type.SubSport));
            fieldIndex++;

            return newMesg;
        }
        
        private static Mesg CreateCoursePointMesg()
        {
            ushort fieldIndex, subfieldIndex;
            Mesg newMesg = new Mesg("CoursePoint", MesgNum.CoursePoint);
            fieldIndex = 0;
            newMesg.SetField(new Field("MessageIndex", 254, 132, 1, 0, "", false, Type.MessageIndex));
            fieldIndex++;
            newMesg.SetField(new Field("Timestamp", 1, 134, 1, 0, "", false, Type.DateTime));
            fieldIndex++;
            newMesg.SetField(new Field("PositionLat", 2, 133, 1, 0, "semicircles", false, Type.Sint32));
            fieldIndex++;
            newMesg.SetField(new Field("PositionLong", 3, 133, 1, 0, "semicircles", false, Type.Sint32));
            fieldIndex++;
            newMesg.SetField(new Field("Distance", 4, 134, 100, 0, "m", false, Type.Uint32));
            fieldIndex++;
            newMesg.SetField(new Field("Type", 5, 0, 1, 0, "", false, Type.CoursePoint));
            fieldIndex++;
            newMesg.SetField(new Field("Name", 6, 7, 1, 0, "", false, Type.String));
            fieldIndex++;
            newMesg.SetField(new Field("Favorite", 8, 0, 1, 0, "", false, Type.Bool));
            fieldIndex++;

            return newMesg;
        }
        
        private static Mesg CreateSegmentIdMesg()
        {
            ushort fieldIndex, subfieldIndex;
            Mesg newMesg = new Mesg("SegmentId", MesgNum.SegmentId);
            fieldIndex = 0;
            newMesg.SetField(new Field("Name", 0, 7, 1, 0, "", false, Type.String));
            fieldIndex++;
            newMesg.SetField(new Field("Uuid", 1, 7, 1, 0, "", false, Type.String));
            fieldIndex++;
            newMesg.SetField(new Field("Sport", 2, 0, 1, 0, "", false, Type.Sport));
            fieldIndex++;
            newMesg.SetField(new Field("Enabled", 3, 0, 1, 0, "", false, Type.Bool));
            fieldIndex++;
            newMesg.SetField(new Field("UserProfilePrimaryKey", 4, 134, 1, 0, "", false, Type.Uint32));
            fieldIndex++;
            newMesg.SetField(new Field("DeviceId", 5, 134, 1, 0, "", false, Type.Uint32));
            fieldIndex++;
            newMesg.SetField(new Field("DefaultRaceLeader", 6, 2, 1, 0, "", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("DeleteStatus", 7, 0, 1, 0, "", false, Type.SegmentDeleteStatus));
            fieldIndex++;
            newMesg.SetField(new Field("SelectionType", 8, 0, 1, 0, "", false, Type.SegmentSelectionType));
            fieldIndex++;

            return newMesg;
        }
        
        private static Mesg CreateSegmentLeaderboardEntryMesg()
        {
            ushort fieldIndex, subfieldIndex;
            Mesg newMesg = new Mesg("SegmentLeaderboardEntry", MesgNum.SegmentLeaderboardEntry);
            fieldIndex = 0;
            newMesg.SetField(new Field("MessageIndex", 254, 132, 1, 0, "", false, Type.MessageIndex));
            fieldIndex++;
            newMesg.SetField(new Field("Name", 0, 7, 1, 0, "", false, Type.String));
            fieldIndex++;
            newMesg.SetField(new Field("Type", 1, 0, 1, 0, "", false, Type.SegmentLeaderboardType));
            fieldIndex++;
            newMesg.SetField(new Field("GroupPrimaryKey", 2, 134, 1, 0, "", false, Type.Uint32));
            fieldIndex++;
            newMesg.SetField(new Field("ActivityId", 3, 134, 1, 0, "", false, Type.Uint32));
            fieldIndex++;
            newMesg.SetField(new Field("SegmentTime", 4, 134, 1000, 0, "s", false, Type.Uint32));
            fieldIndex++;
            newMesg.SetField(new Field("ActivityIdString", 5, 7, 1, 0, "", false, Type.String));
            fieldIndex++;

            return newMesg;
        }
        
        private static Mesg CreateSegmentPointMesg()
        {
            ushort fieldIndex, subfieldIndex;
            Mesg newMesg = new Mesg("SegmentPoint", MesgNum.SegmentPoint);
            fieldIndex = 0;
            newMesg.SetField(new Field("MessageIndex", 254, 132, 1, 0, "", false, Type.MessageIndex));
            fieldIndex++;
            newMesg.SetField(new Field("PositionLat", 1, 133, 1, 0, "semicircles", false, Type.Sint32));
            fieldIndex++;
            newMesg.SetField(new Field("PositionLong", 2, 133, 1, 0, "semicircles", false, Type.Sint32));
            fieldIndex++;
            newMesg.SetField(new Field("Distance", 3, 134, 100, 0, "m", false, Type.Uint32));
            fieldIndex++;
            newMesg.SetField(new Field("Altitude", 4, 132, 5, 500, "m", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("LeaderTime", 5, 134, 1000, 0, "s", false, Type.Uint32));
            fieldIndex++;

            return newMesg;
        }
        
        private static Mesg CreateSegmentLapMesg()
        {
            ushort fieldIndex, subfieldIndex;
            Mesg newMesg = new Mesg("SegmentLap", MesgNum.SegmentLap);
            fieldIndex = 0;
            newMesg.SetField(new Field("MessageIndex", 254, 132, 1, 0, "", false, Type.MessageIndex));
            fieldIndex++;
            newMesg.SetField(new Field("Timestamp", 253, 134, 1, 0, "s", false, Type.DateTime));
            fieldIndex++;
            newMesg.SetField(new Field("Event", 0, 0, 1, 0, "", false, Type.Event));
            fieldIndex++;
            newMesg.SetField(new Field("EventType", 1, 0, 1, 0, "", false, Type.EventType));
            fieldIndex++;
            newMesg.SetField(new Field("StartTime", 2, 134, 1, 0, "", false, Type.DateTime));
            fieldIndex++;
            newMesg.SetField(new Field("StartPositionLat", 3, 133, 1, 0, "semicircles", false, Type.Sint32));
            fieldIndex++;
            newMesg.SetField(new Field("StartPositionLong", 4, 133, 1, 0, "semicircles", false, Type.Sint32));
            fieldIndex++;
            newMesg.SetField(new Field("EndPositionLat", 5, 133, 1, 0, "semicircles", false, Type.Sint32));
            fieldIndex++;
            newMesg.SetField(new Field("EndPositionLong", 6, 133, 1, 0, "semicircles", false, Type.Sint32));
            fieldIndex++;
            newMesg.SetField(new Field("TotalElapsedTime", 7, 134, 1000, 0, "s", false, Type.Uint32));
            fieldIndex++;
            newMesg.SetField(new Field("TotalTimerTime", 8, 134, 1000, 0, "s", false, Type.Uint32));
            fieldIndex++;
            newMesg.SetField(new Field("TotalDistance", 9, 134, 100, 0, "m", false, Type.Uint32));
            fieldIndex++;
            newMesg.SetField(new Field("TotalCycles", 10, 134, 1, 0, "cycles", false, Type.Uint32));
            subfieldIndex = 0;
            newMesg.FieldsList[fieldIndex].subfields.Add(new Subfield("TotalStrokes", 134, 1, 0, "strokes"));
            newMesg.FieldsList[fieldIndex].subfields[subfieldIndex].AddMap(23, 2);
            subfieldIndex++;
            fieldIndex++;
            newMesg.SetField(new Field("TotalCalories", 11, 132, 1, 0, "kcal", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("TotalFatCalories", 12, 132, 1, 0, "kcal", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("AvgSpeed", 13, 132, 1000, 0, "m/s", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("MaxSpeed", 14, 132, 1000, 0, "m/s", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("AvgHeartRate", 15, 2, 1, 0, "bpm", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("MaxHeartRate", 16, 2, 1, 0, "bpm", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("AvgCadence", 17, 2, 1, 0, "rpm", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("MaxCadence", 18, 2, 1, 0, "rpm", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("AvgPower", 19, 132, 1, 0, "watts", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("MaxPower", 20, 132, 1, 0, "watts", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("TotalAscent", 21, 132, 1, 0, "m", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("TotalDescent", 22, 132, 1, 0, "m", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("Sport", 23, 0, 1, 0, "", false, Type.Sport));
            fieldIndex++;
            newMesg.SetField(new Field("EventGroup", 24, 2, 1, 0, "", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("NecLat", 25, 133, 1, 0, "semicircles", false, Type.Sint32));
            fieldIndex++;
            newMesg.SetField(new Field("NecLong", 26, 133, 1, 0, "semicircles", false, Type.Sint32));
            fieldIndex++;
            newMesg.SetField(new Field("SwcLat", 27, 133, 1, 0, "semicircles", false, Type.Sint32));
            fieldIndex++;
            newMesg.SetField(new Field("SwcLong", 28, 133, 1, 0, "semicircles", false, Type.Sint32));
            fieldIndex++;
            newMesg.SetField(new Field("Name", 29, 7, 1, 0, "", false, Type.String));
            fieldIndex++;
            newMesg.SetField(new Field("NormalizedPower", 30, 132, 1, 0, "watts", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("LeftRightBalance", 31, 132, 1, 0, "", false, Type.LeftRightBalance100));
            fieldIndex++;
            newMesg.SetField(new Field("SubSport", 32, 0, 1, 0, "", false, Type.SubSport));
            fieldIndex++;
            newMesg.SetField(new Field("TotalWork", 33, 134, 1, 0, "J", false, Type.Uint32));
            fieldIndex++;
            newMesg.SetField(new Field("AvgAltitude", 34, 132, 5, 500, "m", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("MaxAltitude", 35, 132, 5, 500, "m", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("GpsAccuracy", 36, 2, 1, 0, "m", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("AvgGrade", 37, 131, 100, 0, "%", false, Type.Sint16));
            fieldIndex++;
            newMesg.SetField(new Field("AvgPosGrade", 38, 131, 100, 0, "%", false, Type.Sint16));
            fieldIndex++;
            newMesg.SetField(new Field("AvgNegGrade", 39, 131, 100, 0, "%", false, Type.Sint16));
            fieldIndex++;
            newMesg.SetField(new Field("MaxPosGrade", 40, 131, 100, 0, "%", false, Type.Sint16));
            fieldIndex++;
            newMesg.SetField(new Field("MaxNegGrade", 41, 131, 100, 0, "%", false, Type.Sint16));
            fieldIndex++;
            newMesg.SetField(new Field("AvgTemperature", 42, 1, 1, 0, "C", false, Type.Sint8));
            fieldIndex++;
            newMesg.SetField(new Field("MaxTemperature", 43, 1, 1, 0, "C", false, Type.Sint8));
            fieldIndex++;
            newMesg.SetField(new Field("TotalMovingTime", 44, 134, 1000, 0, "s", false, Type.Uint32));
            fieldIndex++;
            newMesg.SetField(new Field("AvgPosVerticalSpeed", 45, 131, 1000, 0, "m/s", false, Type.Sint16));
            fieldIndex++;
            newMesg.SetField(new Field("AvgNegVerticalSpeed", 46, 131, 1000, 0, "m/s", false, Type.Sint16));
            fieldIndex++;
            newMesg.SetField(new Field("MaxPosVerticalSpeed", 47, 131, 1000, 0, "m/s", false, Type.Sint16));
            fieldIndex++;
            newMesg.SetField(new Field("MaxNegVerticalSpeed", 48, 131, 1000, 0, "m/s", false, Type.Sint16));
            fieldIndex++;
            newMesg.SetField(new Field("TimeInHrZone", 49, 134, 1000, 0, "s", false, Type.Uint32));
            fieldIndex++;
            newMesg.SetField(new Field("TimeInSpeedZone", 50, 134, 1000, 0, "s", false, Type.Uint32));
            fieldIndex++;
            newMesg.SetField(new Field("TimeInCadenceZone", 51, 134, 1000, 0, "s", false, Type.Uint32));
            fieldIndex++;
            newMesg.SetField(new Field("TimeInPowerZone", 52, 134, 1000, 0, "s", false, Type.Uint32));
            fieldIndex++;
            newMesg.SetField(new Field("RepetitionNum", 53, 132, 1, 0, "", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("MinAltitude", 54, 132, 5, 500, "m", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("MinHeartRate", 55, 2, 1, 0, "bpm", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("ActiveTime", 56, 134, 1000, 0, "s", false, Type.Uint32));
            fieldIndex++;
            newMesg.SetField(new Field("WktStepIndex", 57, 132, 1, 0, "", false, Type.MessageIndex));
            fieldIndex++;
            newMesg.SetField(new Field("SportEvent", 58, 0, 1, 0, "", false, Type.SportEvent));
            fieldIndex++;
            newMesg.SetField(new Field("AvgLeftTorqueEffectiveness", 59, 2, 2, 0, "percent", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("AvgRightTorqueEffectiveness", 60, 2, 2, 0, "percent", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("AvgLeftPedalSmoothness", 61, 2, 2, 0, "percent", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("AvgRightPedalSmoothness", 62, 2, 2, 0, "percent", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("AvgCombinedPedalSmoothness", 63, 2, 2, 0, "percent", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("Status", 64, 0, 1, 0, "", false, Type.SegmentLapStatus));
            fieldIndex++;
            newMesg.SetField(new Field("Uuid", 65, 7, 1, 0, "", false, Type.String));
            fieldIndex++;
            newMesg.SetField(new Field("AvgFractionalCadence", 66, 2, 128, 0, "rpm", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("MaxFractionalCadence", 67, 2, 128, 0, "rpm", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("TotalFractionalCycles", 68, 2, 128, 0, "cycles", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("FrontGearShiftCount", 69, 132, 1, 0, "", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("RearGearShiftCount", 70, 132, 1, 0, "", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("TimeStanding", 71, 134, 1000, 0, "s", false, Type.Uint32));
            fieldIndex++;
            newMesg.SetField(new Field("StandCount", 72, 132, 1, 0, "", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("AvgLeftPco", 73, 1, 1, 0, "mm", false, Type.Sint8));
            fieldIndex++;
            newMesg.SetField(new Field("AvgRightPco", 74, 1, 1, 0, "mm", false, Type.Sint8));
            fieldIndex++;
            newMesg.SetField(new Field("AvgLeftPowerPhase", 75, 2, 0.7111111, 0, "degrees", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("AvgLeftPowerPhasePeak", 76, 2, 0.7111111, 0, "degrees", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("AvgRightPowerPhase", 77, 2, 0.7111111, 0, "degrees", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("AvgRightPowerPhasePeak", 78, 2, 0.7111111, 0, "degrees", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("AvgPowerPosition", 79, 132, 1, 0, "watts", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("MaxPowerPosition", 80, 132, 1, 0, "watts", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("AvgCadencePosition", 81, 2, 1, 0, "rpm", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("MaxCadencePosition", 82, 2, 1, 0, "rpm", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("Manufacturer", 83, 132, 1, 0, "", false, Type.Manufacturer));
            fieldIndex++;
            newMesg.SetField(new Field("TotalGrit", 84, 136, 1, 0, "kGrit", false, Type.Float32));
            fieldIndex++;
            newMesg.SetField(new Field("TotalFlow", 85, 136, 1, 0, "Flow", false, Type.Float32));
            fieldIndex++;
            newMesg.SetField(new Field("AvgGrit", 86, 136, 1, 0, "kGrit", false, Type.Float32));
            fieldIndex++;
            newMesg.SetField(new Field("AvgFlow", 87, 136, 1, 0, "Flow", false, Type.Float32));
            fieldIndex++;

            return newMesg;
        }
        
        private static Mesg CreateSegmentFileMesg()
        {
            ushort fieldIndex, subfieldIndex;
            Mesg newMesg = new Mesg("SegmentFile", MesgNum.SegmentFile);
            fieldIndex = 0;
            newMesg.SetField(new Field("MessageIndex", 254, 132, 1, 0, "", false, Type.MessageIndex));
            fieldIndex++;
            newMesg.SetField(new Field("FileUuid", 1, 7, 1, 0, "", false, Type.String));
            fieldIndex++;
            newMesg.SetField(new Field("Enabled", 3, 0, 1, 0, "", false, Type.Bool));
            fieldIndex++;
            newMesg.SetField(new Field("UserProfilePrimaryKey", 4, 134, 1, 0, "", false, Type.Uint32));
            fieldIndex++;
            newMesg.SetField(new Field("LeaderType", 7, 0, 1, 0, "", false, Type.SegmentLeaderboardType));
            fieldIndex++;
            newMesg.SetField(new Field("LeaderGroupPrimaryKey", 8, 134, 1, 0, "", false, Type.Uint32));
            fieldIndex++;
            newMesg.SetField(new Field("LeaderActivityId", 9, 134, 1, 0, "", false, Type.Uint32));
            fieldIndex++;
            newMesg.SetField(new Field("LeaderActivityIdString", 10, 7, 1, 0, "", false, Type.String));
            fieldIndex++;
            newMesg.SetField(new Field("DefaultRaceLeader", 11, 2, 1, 0, "", false, Type.Uint8));
            fieldIndex++;

            return newMesg;
        }
        
        private static Mesg CreateWorkoutMesg()
        {
            ushort fieldIndex, subfieldIndex;
            Mesg newMesg = new Mesg("Workout", MesgNum.Workout);
            fieldIndex = 0;
            newMesg.SetField(new Field("Sport", 4, 0, 1, 0, "", false, Type.Sport));
            fieldIndex++;
            newMesg.SetField(new Field("Capabilities", 5, 140, 1, 0, "", false, Type.WorkoutCapabilities));
            fieldIndex++;
            newMesg.SetField(new Field("NumValidSteps", 6, 132, 1, 0, "", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("WktName", 8, 7, 1, 0, "", false, Type.String));
            fieldIndex++;
            newMesg.SetField(new Field("SubSport", 11, 0, 1, 0, "", false, Type.SubSport));
            fieldIndex++;
            newMesg.SetField(new Field("PoolLength", 14, 132, 100, 0, "m", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("PoolLengthUnit", 15, 0, 1, 0, "", false, Type.DisplayMeasure));
            fieldIndex++;

            return newMesg;
        }
        
        private static Mesg CreateWorkoutSessionMesg()
        {
            ushort fieldIndex, subfieldIndex;
            Mesg newMesg = new Mesg("WorkoutSession", MesgNum.WorkoutSession);
            fieldIndex = 0;
            newMesg.SetField(new Field("MessageIndex", 254, 132, 1, 0, "", false, Type.MessageIndex));
            fieldIndex++;
            newMesg.SetField(new Field("Sport", 0, 0, 1, 0, "", false, Type.Sport));
            fieldIndex++;
            newMesg.SetField(new Field("SubSport", 1, 0, 1, 0, "", false, Type.SubSport));
            fieldIndex++;
            newMesg.SetField(new Field("NumValidSteps", 2, 132, 1, 0, "", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("FirstStepIndex", 3, 132, 1, 0, "", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("PoolLength", 4, 132, 100, 0, "m", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("PoolLengthUnit", 5, 0, 1, 0, "", false, Type.DisplayMeasure));
            fieldIndex++;

            return newMesg;
        }
        
        private static Mesg CreateWorkoutStepMesg()
        {
            ushort fieldIndex, subfieldIndex;
            Mesg newMesg = new Mesg("WorkoutStep", MesgNum.WorkoutStep);
            fieldIndex = 0;
            newMesg.SetField(new Field("MessageIndex", 254, 132, 1, 0, "", false, Type.MessageIndex));
            fieldIndex++;
            newMesg.SetField(new Field("WktStepName", 0, 7, 1, 0, "", false, Type.String));
            fieldIndex++;
            newMesg.SetField(new Field("DurationType", 1, 0, 1, 0, "", false, Type.WktStepDuration));
            fieldIndex++;
            newMesg.SetField(new Field("DurationValue", 2, 134, 1, 0, "", false, Type.Uint32));
            subfieldIndex = 0;
            newMesg.FieldsList[fieldIndex].subfields.Add(new Subfield("DurationTime", 134, 1000, 0, "s"));
            newMesg.FieldsList[fieldIndex].subfields[subfieldIndex].AddMap(1, 0);
            newMesg.FieldsList[fieldIndex].subfields[subfieldIndex].AddMap(1, 28);
            subfieldIndex++;
            newMesg.FieldsList[fieldIndex].subfields.Add(new Subfield("DurationDistance", 134, 100, 0, "m"));
            newMesg.FieldsList[fieldIndex].subfields[subfieldIndex].AddMap(1, 1);
            subfieldIndex++;
            newMesg.FieldsList[fieldIndex].subfields.Add(new Subfield("DurationHr", 134, 1, 0, "% or bpm"));
            newMesg.FieldsList[fieldIndex].subfields[subfieldIndex].AddMap(1, 2);
            newMesg.FieldsList[fieldIndex].subfields[subfieldIndex].AddMap(1, 3);
            subfieldIndex++;
            newMesg.FieldsList[fieldIndex].subfields.Add(new Subfield("DurationCalories", 134, 1, 0, "calories"));
            newMesg.FieldsList[fieldIndex].subfields[subfieldIndex].AddMap(1, 4);
            subfieldIndex++;
            newMesg.FieldsList[fieldIndex].subfields.Add(new Subfield("DurationStep", 134, 1, 0, ""));
            newMesg.FieldsList[fieldIndex].subfields[subfieldIndex].AddMap(1, 6);
            newMesg.FieldsList[fieldIndex].subfields[subfieldIndex].AddMap(1, 7);
            newMesg.FieldsList[fieldIndex].subfields[subfieldIndex].AddMap(1, 8);
            newMesg.FieldsList[fieldIndex].subfields[subfieldIndex].AddMap(1, 9);
            newMesg.FieldsList[fieldIndex].subfields[subfieldIndex].AddMap(1, 10);
            newMesg.FieldsList[fieldIndex].subfields[subfieldIndex].AddMap(1, 11);
            newMesg.FieldsList[fieldIndex].subfields[subfieldIndex].AddMap(1, 12);
            newMesg.FieldsList[fieldIndex].subfields[subfieldIndex].AddMap(1, 13);
            subfieldIndex++;
            newMesg.FieldsList[fieldIndex].subfields.Add(new Subfield("DurationPower", 134, 1, 0, "% or watts"));
            newMesg.FieldsList[fieldIndex].subfields[subfieldIndex].AddMap(1, 14);
            newMesg.FieldsList[fieldIndex].subfields[subfieldIndex].AddMap(1, 15);
            subfieldIndex++;
            newMesg.FieldsList[fieldIndex].subfields.Add(new Subfield("DurationReps", 134, 1, 0, ""));
            newMesg.FieldsList[fieldIndex].subfields[subfieldIndex].AddMap(1, 29);
            subfieldIndex++;
            fieldIndex++;
            newMesg.SetField(new Field("TargetType", 3, 0, 1, 0, "", false, Type.WktStepTarget));
            fieldIndex++;
            newMesg.SetField(new Field("TargetValue", 4, 134, 1, 0, "", false, Type.Uint32));
            subfieldIndex = 0;
            newMesg.FieldsList[fieldIndex].subfields.Add(new Subfield("TargetSpeedZone", 134, 1, 0, ""));
            newMesg.FieldsList[fieldIndex].subfields[subfieldIndex].AddMap(3, 0);
            subfieldIndex++;
            newMesg.FieldsList[fieldIndex].subfields.Add(new Subfield("TargetHrZone", 134, 1, 0, ""));
            newMesg.FieldsList[fieldIndex].subfields[subfieldIndex].AddMap(3, 1);
            subfieldIndex++;
            newMesg.FieldsList[fieldIndex].subfields.Add(new Subfield("TargetCadenceZone", 134, 1, 0, ""));
            newMesg.FieldsList[fieldIndex].subfields[subfieldIndex].AddMap(3, 3);
            subfieldIndex++;
            newMesg.FieldsList[fieldIndex].subfields.Add(new Subfield("TargetPowerZone", 134, 1, 0, ""));
            newMesg.FieldsList[fieldIndex].subfields[subfieldIndex].AddMap(3, 4);
            subfieldIndex++;
            newMesg.FieldsList[fieldIndex].subfields.Add(new Subfield("RepeatSteps", 134, 1, 0, ""));
            newMesg.FieldsList[fieldIndex].subfields[subfieldIndex].AddMap(1, 6);
            subfieldIndex++;
            newMesg.FieldsList[fieldIndex].subfields.Add(new Subfield("RepeatTime", 134, 1000, 0, "s"));
            newMesg.FieldsList[fieldIndex].subfields[subfieldIndex].AddMap(1, 7);
            subfieldIndex++;
            newMesg.FieldsList[fieldIndex].subfields.Add(new Subfield("RepeatDistance", 134, 100, 0, "m"));
            newMesg.FieldsList[fieldIndex].subfields[subfieldIndex].AddMap(1, 8);
            subfieldIndex++;
            newMesg.FieldsList[fieldIndex].subfields.Add(new Subfield("RepeatCalories", 134, 1, 0, "calories"));
            newMesg.FieldsList[fieldIndex].subfields[subfieldIndex].AddMap(1, 9);
            subfieldIndex++;
            newMesg.FieldsList[fieldIndex].subfields.Add(new Subfield("RepeatHr", 134, 1, 0, "% or bpm"));
            newMesg.FieldsList[fieldIndex].subfields[subfieldIndex].AddMap(1, 10);
            newMesg.FieldsList[fieldIndex].subfields[subfieldIndex].AddMap(1, 11);
            subfieldIndex++;
            newMesg.FieldsList[fieldIndex].subfields.Add(new Subfield("RepeatPower", 134, 1, 0, "% or watts"));
            newMesg.FieldsList[fieldIndex].subfields[subfieldIndex].AddMap(1, 12);
            newMesg.FieldsList[fieldIndex].subfields[subfieldIndex].AddMap(1, 13);
            subfieldIndex++;
            newMesg.FieldsList[fieldIndex].subfields.Add(new Subfield("TargetStrokeType", 0, 1, 0, ""));
            newMesg.FieldsList[fieldIndex].subfields[subfieldIndex].AddMap(3, 11);
            subfieldIndex++;
            fieldIndex++;
            newMesg.SetField(new Field("CustomTargetValueLow", 5, 134, 1, 0, "", false, Type.Uint32));
            subfieldIndex = 0;
            newMesg.FieldsList[fieldIndex].subfields.Add(new Subfield("CustomTargetSpeedLow", 134, 1000, 0, "m/s"));
            newMesg.FieldsList[fieldIndex].subfields[subfieldIndex].AddMap(3, 0);
            subfieldIndex++;
            newMesg.FieldsList[fieldIndex].subfields.Add(new Subfield("CustomTargetHeartRateLow", 134, 1, 0, "% or bpm"));
            newMesg.FieldsList[fieldIndex].subfields[subfieldIndex].AddMap(3, 1);
            subfieldIndex++;
            newMesg.FieldsList[fieldIndex].subfields.Add(new Subfield("CustomTargetCadenceLow", 134, 1, 0, "rpm"));
            newMesg.FieldsList[fieldIndex].subfields[subfieldIndex].AddMap(3, 3);
            subfieldIndex++;
            newMesg.FieldsList[fieldIndex].subfields.Add(new Subfield("CustomTargetPowerLow", 134, 1, 0, "% or watts"));
            newMesg.FieldsList[fieldIndex].subfields[subfieldIndex].AddMap(3, 4);
            subfieldIndex++;
            fieldIndex++;
            newMesg.SetField(new Field("CustomTargetValueHigh", 6, 134, 1, 0, "", false, Type.Uint32));
            subfieldIndex = 0;
            newMesg.FieldsList[fieldIndex].subfields.Add(new Subfield("CustomTargetSpeedHigh", 134, 1000, 0, "m/s"));
            newMesg.FieldsList[fieldIndex].subfields[subfieldIndex].AddMap(3, 0);
            subfieldIndex++;
            newMesg.FieldsList[fieldIndex].subfields.Add(new Subfield("CustomTargetHeartRateHigh", 134, 1, 0, "% or bpm"));
            newMesg.FieldsList[fieldIndex].subfields[subfieldIndex].AddMap(3, 1);
            subfieldIndex++;
            newMesg.FieldsList[fieldIndex].subfields.Add(new Subfield("CustomTargetCadenceHigh", 134, 1, 0, "rpm"));
            newMesg.FieldsList[fieldIndex].subfields[subfieldIndex].AddMap(3, 3);
            subfieldIndex++;
            newMesg.FieldsList[fieldIndex].subfields.Add(new Subfield("CustomTargetPowerHigh", 134, 1, 0, "% or watts"));
            newMesg.FieldsList[fieldIndex].subfields[subfieldIndex].AddMap(3, 4);
            subfieldIndex++;
            fieldIndex++;
            newMesg.SetField(new Field("Intensity", 7, 0, 1, 0, "", false, Type.Intensity));
            fieldIndex++;
            newMesg.SetField(new Field("Notes", 8, 7, 1, 0, "", false, Type.String));
            fieldIndex++;
            newMesg.SetField(new Field("Equipment", 9, 0, 1, 0, "", false, Type.WorkoutEquipment));
            fieldIndex++;
            newMesg.SetField(new Field("ExerciseCategory", 10, 132, 1, 0, "", false, Type.ExerciseCategory));
            fieldIndex++;
            newMesg.SetField(new Field("ExerciseName", 11, 132, 1, 0, "", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("ExerciseWeight", 12, 132, 100, 0, "kg", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("WeightDisplayUnit", 13, 132, 1, 0, "", false, Type.FitBaseUnit));
            fieldIndex++;

            return newMesg;
        }
        
        private static Mesg CreateExerciseTitleMesg()
        {
            ushort fieldIndex, subfieldIndex;
            Mesg newMesg = new Mesg("ExerciseTitle", MesgNum.ExerciseTitle);
            fieldIndex = 0;
            newMesg.SetField(new Field("MessageIndex", 254, 132, 1, 0, "", false, Type.MessageIndex));
            fieldIndex++;
            newMesg.SetField(new Field("ExerciseCategory", 0, 132, 1, 0, "", false, Type.ExerciseCategory));
            fieldIndex++;
            newMesg.SetField(new Field("ExerciseName", 1, 132, 1, 0, "", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("WktStepName", 2, 7, 1, 0, "", false, Type.String));
            fieldIndex++;

            return newMesg;
        }
        
        private static Mesg CreateScheduleMesg()
        {
            ushort fieldIndex, subfieldIndex;
            Mesg newMesg = new Mesg("Schedule", MesgNum.Schedule);
            fieldIndex = 0;
            newMesg.SetField(new Field("Manufacturer", 0, 132, 1, 0, "", false, Type.Manufacturer));
            fieldIndex++;
            newMesg.SetField(new Field("Product", 1, 132, 1, 0, "", false, Type.Uint16));
            subfieldIndex = 0;
            newMesg.FieldsList[fieldIndex].subfields.Add(new Subfield("FaveroProduct", 132, 1, 0, ""));
            newMesg.FieldsList[fieldIndex].subfields[subfieldIndex].AddMap(0, 263);
            subfieldIndex++;
            newMesg.FieldsList[fieldIndex].subfields.Add(new Subfield("GarminProduct", 132, 1, 0, ""));
            newMesg.FieldsList[fieldIndex].subfields[subfieldIndex].AddMap(0, 1);
            newMesg.FieldsList[fieldIndex].subfields[subfieldIndex].AddMap(0, 15);
            newMesg.FieldsList[fieldIndex].subfields[subfieldIndex].AddMap(0, 13);
            newMesg.FieldsList[fieldIndex].subfields[subfieldIndex].AddMap(0, 89);
            subfieldIndex++;
            fieldIndex++;
            newMesg.SetField(new Field("SerialNumber", 2, 140, 1, 0, "", false, Type.Uint32z));
            fieldIndex++;
            newMesg.SetField(new Field("TimeCreated", 3, 134, 1, 0, "", false, Type.DateTime));
            fieldIndex++;
            newMesg.SetField(new Field("Completed", 4, 0, 1, 0, "", false, Type.Bool));
            fieldIndex++;
            newMesg.SetField(new Field("Type", 5, 0, 1, 0, "", false, Type.Schedule));
            fieldIndex++;
            newMesg.SetField(new Field("ScheduledTime", 6, 134, 1, 0, "", false, Type.LocalDateTime));
            fieldIndex++;

            return newMesg;
        }
        
        private static Mesg CreateTotalsMesg()
        {
            ushort fieldIndex, subfieldIndex;
            Mesg newMesg = new Mesg("Totals", MesgNum.Totals);
            fieldIndex = 0;
            newMesg.SetField(new Field("MessageIndex", 254, 132, 1, 0, "", false, Type.MessageIndex));
            fieldIndex++;
            newMesg.SetField(new Field("Timestamp", 253, 134, 1, 0, "s", false, Type.DateTime));
            fieldIndex++;
            newMesg.SetField(new Field("TimerTime", 0, 134, 1, 0, "s", false, Type.Uint32));
            fieldIndex++;
            newMesg.SetField(new Field("Distance", 1, 134, 1, 0, "m", false, Type.Uint32));
            fieldIndex++;
            newMesg.SetField(new Field("Calories", 2, 134, 1, 0, "kcal", false, Type.Uint32));
            fieldIndex++;
            newMesg.SetField(new Field("Sport", 3, 0, 1, 0, "", false, Type.Sport));
            fieldIndex++;
            newMesg.SetField(new Field("ElapsedTime", 4, 134, 1, 0, "s", false, Type.Uint32));
            fieldIndex++;
            newMesg.SetField(new Field("Sessions", 5, 132, 1, 0, "", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("ActiveTime", 6, 134, 1, 0, "s", false, Type.Uint32));
            fieldIndex++;
            newMesg.SetField(new Field("SportIndex", 9, 2, 1, 0, "", false, Type.Uint8));
            fieldIndex++;

            return newMesg;
        }
        
        private static Mesg CreateWeightScaleMesg()
        {
            ushort fieldIndex, subfieldIndex;
            Mesg newMesg = new Mesg("WeightScale", MesgNum.WeightScale);
            fieldIndex = 0;
            newMesg.SetField(new Field("Timestamp", 253, 134, 1, 0, "s", false, Type.DateTime));
            fieldIndex++;
            newMesg.SetField(new Field("Weight", 0, 132, 100, 0, "kg", false, Type.Weight));
            fieldIndex++;
            newMesg.SetField(new Field("PercentFat", 1, 132, 100, 0, "%", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("PercentHydration", 2, 132, 100, 0, "%", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("VisceralFatMass", 3, 132, 100, 0, "kg", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("BoneMass", 4, 132, 100, 0, "kg", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("MuscleMass", 5, 132, 100, 0, "kg", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("BasalMet", 7, 132, 4, 0, "kcal/day", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("PhysiqueRating", 8, 2, 1, 0, "", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("ActiveMet", 9, 132, 4, 0, "kcal/day", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("MetabolicAge", 10, 2, 1, 0, "years", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("VisceralFatRating", 11, 2, 1, 0, "", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("UserProfileIndex", 12, 132, 1, 0, "", false, Type.MessageIndex));
            fieldIndex++;

            return newMesg;
        }
        
        private static Mesg CreateBloodPressureMesg()
        {
            ushort fieldIndex, subfieldIndex;
            Mesg newMesg = new Mesg("BloodPressure", MesgNum.BloodPressure);
            fieldIndex = 0;
            newMesg.SetField(new Field("Timestamp", 253, 134, 1, 0, "s", false, Type.DateTime));
            fieldIndex++;
            newMesg.SetField(new Field("SystolicPressure", 0, 132, 1, 0, "mmHg", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("DiastolicPressure", 1, 132, 1, 0, "mmHg", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("MeanArterialPressure", 2, 132, 1, 0, "mmHg", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("Map3SampleMean", 3, 132, 1, 0, "mmHg", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("MapMorningValues", 4, 132, 1, 0, "mmHg", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("MapEveningValues", 5, 132, 1, 0, "mmHg", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("HeartRate", 6, 2, 1, 0, "bpm", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("HeartRateType", 7, 0, 1, 0, "", false, Type.HrType));
            fieldIndex++;
            newMesg.SetField(new Field("Status", 8, 0, 1, 0, "", false, Type.BpStatus));
            fieldIndex++;
            newMesg.SetField(new Field("UserProfileIndex", 9, 132, 1, 0, "", false, Type.MessageIndex));
            fieldIndex++;

            return newMesg;
        }
        
        private static Mesg CreateMonitoringInfoMesg()
        {
            ushort fieldIndex, subfieldIndex;
            Mesg newMesg = new Mesg("MonitoringInfo", MesgNum.MonitoringInfo);
            fieldIndex = 0;
            newMesg.SetField(new Field("Timestamp", 253, 134, 1, 0, "s", false, Type.DateTime));
            fieldIndex++;
            newMesg.SetField(new Field("LocalTimestamp", 0, 134, 1, 0, "s", false, Type.LocalDateTime));
            fieldIndex++;
            newMesg.SetField(new Field("ActivityType", 1, 0, 1, 0, "", false, Type.ActivityType));
            fieldIndex++;
            newMesg.SetField(new Field("CyclesToDistance", 3, 132, 5000, 0, "m/cycle", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("CyclesToCalories", 4, 132, 5000, 0, "kcal/cycle", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("RestingMetabolicRate", 5, 132, 1, 0, "kcal / day", false, Type.Uint16));
            fieldIndex++;

            return newMesg;
        }
        
        private static Mesg CreateMonitoringMesg()
        {
            ushort fieldIndex, subfieldIndex;
            Mesg newMesg = new Mesg("Monitoring", MesgNum.Monitoring);
            fieldIndex = 0;
            newMesg.SetField(new Field("Timestamp", 253, 134, 1, 0, "s", false, Type.DateTime));
            fieldIndex++;
            newMesg.SetField(new Field("DeviceIndex", 0, 2, 1, 0, "", false, Type.DeviceIndex));
            fieldIndex++;
            newMesg.SetField(new Field("Calories", 1, 132, 1, 0, "kcal", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("Distance", 2, 134, 100, 0, "m", false, Type.Uint32));
            fieldIndex++;
            newMesg.SetField(new Field("Cycles", 3, 134, 2, 0, "cycles", false, Type.Uint32));
            subfieldIndex = 0;
            newMesg.FieldsList[fieldIndex].subfields.Add(new Subfield("Steps", 134, 1, 0, "steps"));
            newMesg.FieldsList[fieldIndex].subfields[subfieldIndex].AddMap(5, 6);
            newMesg.FieldsList[fieldIndex].subfields[subfieldIndex].AddMap(5, 1);
            subfieldIndex++;
            newMesg.FieldsList[fieldIndex].subfields.Add(new Subfield("Strokes", 134, 2, 0, "strokes"));
            newMesg.FieldsList[fieldIndex].subfields[subfieldIndex].AddMap(5, 2);
            newMesg.FieldsList[fieldIndex].subfields[subfieldIndex].AddMap(5, 5);
            subfieldIndex++;
            fieldIndex++;
            newMesg.SetField(new Field("ActiveTime", 4, 134, 1000, 0, "s", false, Type.Uint32));
            fieldIndex++;
            newMesg.SetField(new Field("ActivityType", 5, 0, 1, 0, "", false, Type.ActivityType));
            fieldIndex++;
            newMesg.SetField(new Field("ActivitySubtype", 6, 0, 1, 0, "", false, Type.ActivitySubtype));
            fieldIndex++;
            newMesg.SetField(new Field("ActivityLevel", 7, 0, 1, 0, "", false, Type.ActivityLevel));
            fieldIndex++;
            newMesg.SetField(new Field("Distance16", 8, 132, 1, 0, "100 * m", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("Cycles16", 9, 132, 1, 0, "2 * cycles (steps)", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("ActiveTime16", 10, 132, 1, 0, "s", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("LocalTimestamp", 11, 134, 1, 0, "", false, Type.LocalDateTime));
            fieldIndex++;
            newMesg.SetField(new Field("Temperature", 12, 131, 100, 0, "C", false, Type.Sint16));
            fieldIndex++;
            newMesg.SetField(new Field("TemperatureMin", 14, 131, 100, 0, "C", false, Type.Sint16));
            fieldIndex++;
            newMesg.SetField(new Field("TemperatureMax", 15, 131, 100, 0, "C", false, Type.Sint16));
            fieldIndex++;
            newMesg.SetField(new Field("ActivityTime", 16, 132, 1, 0, "minutes", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("ActiveCalories", 19, 132, 1, 0, "kcal", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("CurrentActivityTypeIntensity", 24, 13, 1, 0, "", false, Type.Byte));
            newMesg.FieldsList[fieldIndex].components.Add(new FieldComponent(5, false, 5, 1, 0)); // activity_type
            newMesg.FieldsList[fieldIndex].components.Add(new FieldComponent(28, false, 3, 1, 0)); // intensity
            fieldIndex++;
            newMesg.SetField(new Field("TimestampMin8", 25, 2, 1, 0, "min", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("Timestamp16", 26, 132, 1, 0, "s", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("HeartRate", 27, 2, 1, 0, "bpm", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("Intensity", 28, 2, 10, 0, "", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("DurationMin", 29, 132, 1, 0, "min", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("Duration", 30, 134, 1, 0, "s", false, Type.Uint32));
            fieldIndex++;
            newMesg.SetField(new Field("Ascent", 31, 134, 1000, 0, "m", false, Type.Uint32));
            fieldIndex++;
            newMesg.SetField(new Field("Descent", 32, 134, 1000, 0, "m", false, Type.Uint32));
            fieldIndex++;
            newMesg.SetField(new Field("ModerateActivityMinutes", 33, 132, 1, 0, "minutes", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("VigorousActivityMinutes", 34, 132, 1, 0, "minutes", false, Type.Uint16));
            fieldIndex++;

            return newMesg;
        }
        
        private static Mesg CreateHrMesg()
        {
            ushort fieldIndex, subfieldIndex;
            Mesg newMesg = new Mesg("Hr", MesgNum.Hr);
            fieldIndex = 0;
            newMesg.SetField(new Field("Timestamp", 253, 134, 1, 0, "", false, Type.DateTime));
            fieldIndex++;
            newMesg.SetField(new Field("FractionalTimestamp", 0, 132, 32768, 0, "s", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("Time256", 1, 2, 256, 0, "s", false, Type.Uint8));
            newMesg.FieldsList[fieldIndex].components.Add(new FieldComponent(0, false, 8, 256, 0)); // fractional_timestamp
            fieldIndex++;
            newMesg.SetField(new Field("FilteredBpm", 6, 2, 1, 0, "bpm", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("EventTimestamp", 9, 134, 1024, 0, "s", true, Type.Uint32));
            fieldIndex++;
            newMesg.SetField(new Field("EventTimestamp12", 10, 13, 1, 0, "", false, Type.Byte));
            newMesg.FieldsList[fieldIndex].components.Add(new FieldComponent(9, true, 12, 1024, 0)); // event_timestamp
            newMesg.FieldsList[fieldIndex].components.Add(new FieldComponent(9, true, 12, 1024, 0)); // event_timestamp
            newMesg.FieldsList[fieldIndex].components.Add(new FieldComponent(9, true, 12, 1024, 0)); // event_timestamp
            newMesg.FieldsList[fieldIndex].components.Add(new FieldComponent(9, true, 12, 1024, 0)); // event_timestamp
            newMesg.FieldsList[fieldIndex].components.Add(new FieldComponent(9, true, 12, 1024, 0)); // event_timestamp
            newMesg.FieldsList[fieldIndex].components.Add(new FieldComponent(9, true, 12, 1024, 0)); // event_timestamp
            newMesg.FieldsList[fieldIndex].components.Add(new FieldComponent(9, true, 12, 1024, 0)); // event_timestamp
            newMesg.FieldsList[fieldIndex].components.Add(new FieldComponent(9, true, 12, 1024, 0)); // event_timestamp
            newMesg.FieldsList[fieldIndex].components.Add(new FieldComponent(9, true, 12, 1024, 0)); // event_timestamp
            newMesg.FieldsList[fieldIndex].components.Add(new FieldComponent(9, true, 12, 1024, 0)); // event_timestamp
            fieldIndex++;

            return newMesg;
        }
        
        private static Mesg CreateStressLevelMesg()
        {
            ushort fieldIndex, subfieldIndex;
            Mesg newMesg = new Mesg("StressLevel", MesgNum.StressLevel);
            fieldIndex = 0;
            newMesg.SetField(new Field("StressLevelValue", 0, 131, 1, 0, "", false, Type.Sint16));
            fieldIndex++;
            newMesg.SetField(new Field("StressLevelTime", 1, 134, 1, 0, "s", false, Type.DateTime));
            fieldIndex++;

            return newMesg;
        }
        
        private static Mesg CreateMemoGlobMesg()
        {
            ushort fieldIndex, subfieldIndex;
            Mesg newMesg = new Mesg("MemoGlob", MesgNum.MemoGlob);
            fieldIndex = 0;
            newMesg.SetField(new Field("PartIndex", 250, 134, 1, 0, "", false, Type.Uint32));
            fieldIndex++;
            newMesg.SetField(new Field("Memo", 0, 13, 1, 0, "", false, Type.Byte));
            fieldIndex++;
            newMesg.SetField(new Field("MessageNumber", 1, 132, 1, 0, "", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("MessageIndex", 2, 132, 1, 0, "", false, Type.MessageIndex));
            fieldIndex++;

            return newMesg;
        }
        
        private static Mesg CreateAntChannelIdMesg()
        {
            ushort fieldIndex, subfieldIndex;
            Mesg newMesg = new Mesg("AntChannelId", MesgNum.AntChannelId);
            fieldIndex = 0;
            newMesg.SetField(new Field("ChannelNumber", 0, 2, 1, 0, "", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("DeviceType", 1, 10, 1, 0, "", false, Type.Uint8z));
            fieldIndex++;
            newMesg.SetField(new Field("DeviceNumber", 2, 139, 1, 0, "", false, Type.Uint16z));
            fieldIndex++;
            newMesg.SetField(new Field("TransmissionType", 3, 10, 1, 0, "", false, Type.Uint8z));
            fieldIndex++;
            newMesg.SetField(new Field("DeviceIndex", 4, 2, 1, 0, "", false, Type.DeviceIndex));
            fieldIndex++;

            return newMesg;
        }
        
        private static Mesg CreateAntRxMesg()
        {
            ushort fieldIndex, subfieldIndex;
            Mesg newMesg = new Mesg("AntRx", MesgNum.AntRx);
            fieldIndex = 0;
            newMesg.SetField(new Field("Timestamp", 253, 134, 1, 0, "s", false, Type.DateTime));
            fieldIndex++;
            newMesg.SetField(new Field("FractionalTimestamp", 0, 132, 32768, 0, "s", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("MesgId", 1, 13, 1, 0, "", false, Type.Byte));
            fieldIndex++;
            newMesg.SetField(new Field("MesgData", 2, 13, 1, 0, "", false, Type.Byte));
            newMesg.FieldsList[fieldIndex].components.Add(new FieldComponent(3, false, 8, 1, 0)); // channel_number
            newMesg.FieldsList[fieldIndex].components.Add(new FieldComponent(4, false, 8, 1, 0)); // data
            newMesg.FieldsList[fieldIndex].components.Add(new FieldComponent(4, false, 8, 1, 0)); // data
            newMesg.FieldsList[fieldIndex].components.Add(new FieldComponent(4, false, 8, 1, 0)); // data
            newMesg.FieldsList[fieldIndex].components.Add(new FieldComponent(4, false, 8, 1, 0)); // data
            newMesg.FieldsList[fieldIndex].components.Add(new FieldComponent(4, false, 8, 1, 0)); // data
            newMesg.FieldsList[fieldIndex].components.Add(new FieldComponent(4, false, 8, 1, 0)); // data
            newMesg.FieldsList[fieldIndex].components.Add(new FieldComponent(4, false, 8, 1, 0)); // data
            newMesg.FieldsList[fieldIndex].components.Add(new FieldComponent(4, false, 8, 1, 0)); // data
            fieldIndex++;
            newMesg.SetField(new Field("ChannelNumber", 3, 2, 1, 0, "", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("Data", 4, 13, 1, 0, "", false, Type.Byte));
            fieldIndex++;

            return newMesg;
        }
        
        private static Mesg CreateAntTxMesg()
        {
            ushort fieldIndex, subfieldIndex;
            Mesg newMesg = new Mesg("AntTx", MesgNum.AntTx);
            fieldIndex = 0;
            newMesg.SetField(new Field("Timestamp", 253, 134, 1, 0, "s", false, Type.DateTime));
            fieldIndex++;
            newMesg.SetField(new Field("FractionalTimestamp", 0, 132, 32768, 0, "s", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("MesgId", 1, 13, 1, 0, "", false, Type.Byte));
            fieldIndex++;
            newMesg.SetField(new Field("MesgData", 2, 13, 1, 0, "", false, Type.Byte));
            newMesg.FieldsList[fieldIndex].components.Add(new FieldComponent(3, false, 8, 1, 0)); // channel_number
            newMesg.FieldsList[fieldIndex].components.Add(new FieldComponent(4, false, 8, 1, 0)); // data
            newMesg.FieldsList[fieldIndex].components.Add(new FieldComponent(4, false, 8, 1, 0)); // data
            newMesg.FieldsList[fieldIndex].components.Add(new FieldComponent(4, false, 8, 1, 0)); // data
            newMesg.FieldsList[fieldIndex].components.Add(new FieldComponent(4, false, 8, 1, 0)); // data
            newMesg.FieldsList[fieldIndex].components.Add(new FieldComponent(4, false, 8, 1, 0)); // data
            newMesg.FieldsList[fieldIndex].components.Add(new FieldComponent(4, false, 8, 1, 0)); // data
            newMesg.FieldsList[fieldIndex].components.Add(new FieldComponent(4, false, 8, 1, 0)); // data
            newMesg.FieldsList[fieldIndex].components.Add(new FieldComponent(4, false, 8, 1, 0)); // data
            fieldIndex++;
            newMesg.SetField(new Field("ChannelNumber", 3, 2, 1, 0, "", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("Data", 4, 13, 1, 0, "", false, Type.Byte));
            fieldIndex++;

            return newMesg;
        }
        
        private static Mesg CreateExdScreenConfigurationMesg()
        {
            ushort fieldIndex, subfieldIndex;
            Mesg newMesg = new Mesg("ExdScreenConfiguration", MesgNum.ExdScreenConfiguration);
            fieldIndex = 0;
            newMesg.SetField(new Field("ScreenIndex", 0, 2, 1, 0, "", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("FieldCount", 1, 2, 1, 0, "", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("Layout", 2, 0, 1, 0, "", false, Type.ExdLayout));
            fieldIndex++;
            newMesg.SetField(new Field("ScreenEnabled", 3, 0, 1, 0, "", false, Type.Bool));
            fieldIndex++;

            return newMesg;
        }
        
        private static Mesg CreateExdDataFieldConfigurationMesg()
        {
            ushort fieldIndex, subfieldIndex;
            Mesg newMesg = new Mesg("ExdDataFieldConfiguration", MesgNum.ExdDataFieldConfiguration);
            fieldIndex = 0;
            newMesg.SetField(new Field("ScreenIndex", 0, 2, 1, 0, "", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("ConceptField", 1, 13, 1, 0, "", false, Type.Byte));
            newMesg.FieldsList[fieldIndex].components.Add(new FieldComponent(2, false, 4, 1, 0)); // field_id
            newMesg.FieldsList[fieldIndex].components.Add(new FieldComponent(3, false, 4, 1, 0)); // concept_count
            fieldIndex++;
            newMesg.SetField(new Field("FieldId", 2, 2, 1, 0, "", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("ConceptCount", 3, 2, 1, 0, "", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("DisplayType", 4, 0, 1, 0, "", false, Type.ExdDisplayType));
            fieldIndex++;
            newMesg.SetField(new Field("Title", 5, 7, 1, 0, "", false, Type.String));
            fieldIndex++;

            return newMesg;
        }
        
        private static Mesg CreateExdDataConceptConfigurationMesg()
        {
            ushort fieldIndex, subfieldIndex;
            Mesg newMesg = new Mesg("ExdDataConceptConfiguration", MesgNum.ExdDataConceptConfiguration);
            fieldIndex = 0;
            newMesg.SetField(new Field("ScreenIndex", 0, 2, 1, 0, "", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("ConceptField", 1, 13, 1, 0, "", false, Type.Byte));
            newMesg.FieldsList[fieldIndex].components.Add(new FieldComponent(2, false, 4, 1, 0)); // field_id
            newMesg.FieldsList[fieldIndex].components.Add(new FieldComponent(3, false, 4, 1, 0)); // concept_index
            fieldIndex++;
            newMesg.SetField(new Field("FieldId", 2, 2, 1, 0, "", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("ConceptIndex", 3, 2, 1, 0, "", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("DataPage", 4, 2, 1, 0, "", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("ConceptKey", 5, 2, 1, 0, "", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("Scaling", 6, 2, 1, 0, "", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("DataUnits", 8, 0, 1, 0, "", false, Type.ExdDataUnits));
            fieldIndex++;
            newMesg.SetField(new Field("Qualifier", 9, 0, 1, 0, "", false, Type.ExdQualifiers));
            fieldIndex++;
            newMesg.SetField(new Field("Descriptor", 10, 0, 1, 0, "", false, Type.ExdDescriptors));
            fieldIndex++;
            newMesg.SetField(new Field("IsSigned", 11, 0, 1, 0, "", false, Type.Bool));
            fieldIndex++;

            return newMesg;
        }
        
        private static Mesg CreateFieldDescriptionMesg()
        {
            ushort fieldIndex, subfieldIndex;
            Mesg newMesg = new Mesg("FieldDescription", MesgNum.FieldDescription);
            fieldIndex = 0;
            newMesg.SetField(new Field("DeveloperDataIndex", 0, 2, 1, 0, "", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("FieldDefinitionNumber", 1, 2, 1, 0, "", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("FitBaseTypeId", 2, 2, 1, 0, "", false, Type.FitBaseType));
            fieldIndex++;
            newMesg.SetField(new Field("FieldName", 3, 7, 1, 0, "", false, Type.String));
            fieldIndex++;
            newMesg.SetField(new Field("Array", 4, 2, 1, 0, "", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("Components", 5, 7, 1, 0, "", false, Type.String));
            fieldIndex++;
            newMesg.SetField(new Field("Scale", 6, 2, 1, 0, "", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("Offset", 7, 1, 1, 0, "", false, Type.Sint8));
            fieldIndex++;
            newMesg.SetField(new Field("Units", 8, 7, 1, 0, "", false, Type.String));
            fieldIndex++;
            newMesg.SetField(new Field("Bits", 9, 7, 1, 0, "", false, Type.String));
            fieldIndex++;
            newMesg.SetField(new Field("Accumulate", 10, 7, 1, 0, "", false, Type.String));
            fieldIndex++;
            newMesg.SetField(new Field("FitBaseUnitId", 13, 132, 1, 0, "", false, Type.FitBaseUnit));
            fieldIndex++;
            newMesg.SetField(new Field("NativeMesgNum", 14, 132, 1, 0, "", false, Type.MesgNum));
            fieldIndex++;
            newMesg.SetField(new Field("NativeFieldNum", 15, 2, 1, 0, "", false, Type.Uint8));
            fieldIndex++;

            return newMesg;
        }
        
        private static Mesg CreateDeveloperDataIdMesg()
        {
            ushort fieldIndex, subfieldIndex;
            Mesg newMesg = new Mesg("DeveloperDataId", MesgNum.DeveloperDataId);
            fieldIndex = 0;
            newMesg.SetField(new Field("DeveloperId", 0, 13, 1, 0, "", false, Type.Byte));
            fieldIndex++;
            newMesg.SetField(new Field("ApplicationId", 1, 13, 1, 0, "", false, Type.Byte));
            fieldIndex++;
            newMesg.SetField(new Field("ManufacturerId", 2, 132, 1, 0, "", false, Type.Manufacturer));
            fieldIndex++;
            newMesg.SetField(new Field("DeveloperDataIndex", 3, 2, 1, 0, "", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("ApplicationVersion", 4, 134, 1, 0, "", false, Type.Uint32));
            fieldIndex++;

            return newMesg;
        }
        
        private static Mesg CreateDiveSummaryMesg()
        {
            ushort fieldIndex, subfieldIndex;
            Mesg newMesg = new Mesg("DiveSummary", MesgNum.DiveSummary);
            fieldIndex = 0;
            newMesg.SetField(new Field("Timestamp", 253, 134, 1, 0, "s", false, Type.DateTime));
            fieldIndex++;
            newMesg.SetField(new Field("ReferenceMesg", 0, 132, 1, 0, "", false, Type.MesgNum));
            fieldIndex++;
            newMesg.SetField(new Field("ReferenceIndex", 1, 132, 1, 0, "", false, Type.MessageIndex));
            fieldIndex++;
            newMesg.SetField(new Field("AvgDepth", 2, 134, 1000, 0, "m", false, Type.Uint32));
            fieldIndex++;
            newMesg.SetField(new Field("MaxDepth", 3, 134, 1000, 0, "m", false, Type.Uint32));
            fieldIndex++;
            newMesg.SetField(new Field("SurfaceInterval", 4, 134, 1, 0, "s", false, Type.Uint32));
            fieldIndex++;
            newMesg.SetField(new Field("StartCns", 5, 2, 1, 0, "percent", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("EndCns", 6, 2, 1, 0, "percent", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("StartN2", 7, 132, 1, 0, "percent", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("EndN2", 8, 132, 1, 0, "percent", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("O2Toxicity", 9, 132, 1, 0, "OTUs", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("DiveNumber", 10, 134, 1, 0, "", false, Type.Uint32));
            fieldIndex++;
            newMesg.SetField(new Field("BottomTime", 11, 134, 1000, 0, "s", false, Type.Uint32));
            fieldIndex++;

            return newMesg;
        }
        
        private static Mesg CreateClimbProMesg()
        {
            ushort fieldIndex, subfieldIndex;
            Mesg newMesg = new Mesg("ClimbPro", MesgNum.ClimbPro);
            fieldIndex = 0;
            newMesg.SetField(new Field("Timestamp", 253, 134, 1, 0, "s", false, Type.DateTime));
            fieldIndex++;
            newMesg.SetField(new Field("PositionLat", 0, 133, 1, 0, "semicircles", false, Type.Sint32));
            fieldIndex++;
            newMesg.SetField(new Field("PositionLong", 1, 133, 1, 0, "semicircles", false, Type.Sint32));
            fieldIndex++;
            newMesg.SetField(new Field("ClimbProEvent", 2, 0, 1, 0, "", false, Type.ClimbProEvent));
            fieldIndex++;
            newMesg.SetField(new Field("ClimbNumber", 3, 132, 1, 0, "", false, Type.Uint16));
            fieldIndex++;
            newMesg.SetField(new Field("ClimbCategory", 4, 2, 1, 0, "", false, Type.Uint8));
            fieldIndex++;
            newMesg.SetField(new Field("CurrentDist", 5, 136, 1, 0, "m", false, Type.Float32));
            fieldIndex++;

            return newMesg;
        }
        
        private static Mesg CreatePadMesg()
        {
            ushort fieldIndex, subfieldIndex;
            Mesg newMesg = new Mesg("Pad", MesgNum.Pad);
            fieldIndex = 0;

            return newMesg;
        }
        
        #pragma warning restore 0168
        #pragma warning restore 0219

        #endregion
    } // class
} // namespace
