# Flashcards App

## Overview

The Flashcards App is a mobile application designed to assist users in learning and memorization through the use of digital flashcards. With a focus on simplicity and user experience, this app allows users to create, edit, and study from sets of flashcards, each representing a topic or a subject of interest.

## Features

- **Create Decks**: Users can create multiple decks for different subjects or topics, each with a unique name and description.
- **Add Flashcards**: Each deck can contain numerous flashcards with a front (question or prompt) and back (answer or information).
- **Study Mode**: Engage in a study session where flashcards are presented, allowing for spaced repetition and active recall.
- **Track Progress**: The app tracks viewing history and provides statistics on learning progress.
- **Favourites**: Users can mark decks as favourites for quick access.
- **Long Press Actions**: Long pressing on a deck or flashcard allows editing or deleting, providing a smooth user interaction.
- **Adaptive UI**: The app features a responsive UI that adapts to device orientation and screen size, ensuring a consistent experience across all devices.

## Technical Stack

- **Language**: Swift
- **Frameworks**: UIKit, Combine for reactive programming
- **Data Management**: CoreData for local data persistence
- **Design Pattern**: MVC (Model-View-Controller) for clean architecture

## Getting Started

Clone the repository and open the project in Xcode to start:

```bash
git clone https://github.com/yourusername/flashcards-app.git
cd flashcards-app
open Flashcards.xcodeproj
```

Run the project on your preferred simulator or real device running iOS 16.0 or later.

## Screenshots

### Main Interface

<p float="left">
  <img src="/screenshots/1.png" width="49%" />
  <img src="/screenshots/1a.png" width="49%" /> 
</p>

### Favourited Decks

<p float="left">
  <img src="/screenshots/2.png" width="49%" />
  <img src="/screenshots/2a.png" width="49%" />
</p>

### Flashcards Page

<p float="left">
  <img src="/screenshots/3.png" width="49%" />
  <img src="/screenshots/3a.png" width="49%" />
</p>

### Flashcard Practice Sessions

<p float="left">
  <img src="/screenshots/4.png" width="49%" />
  <img src="/screenshots/4a.png" width="49%" />
</p>

### Add New Deck Page

<p float="left">
  <img src="/screenshots/5.png" width="49%" />
  <img src="/screenshots/5a.png" width="49%" />
</p>

### Add new Flashcards Page

<p float="left">
  <img src="/screenshots/6.png" width="49%" />
  <img src="/screenshots/6a.png" width="49%" />
</p>

Each pair of screenshots shows the dark and light mode variations, providing a comprehensive view of the app's thematic adaptability.

## Contributions

Contributions are welcome. Please fork the repository and submit a pull request with your features or fixes.

## License

Distributed under the MIT License. See `LICENSE` for more information.

## Contact

Your Name – [@DanujaJayasuri3](https://twitter.com/DanujaJayasuri3) - todanuja01@gmail.com  
Project Link: [https://github.com/danuja01/FlashcardsApp-iOS](https://github.com/danuja01/FlashcardsApp-iOS)
