#include "node.h"

int test_write(fs_node_t *node, int offset, int size, char *buf) {
    log::info("testfs: Writing '%s' into file '%s'\n", buf, node->path);
    return 0;
}

int test_read(fs_node_t *node, int offset, int size, char *buf) {
    log::info("testfs: Reading from file '%s'\n", node->path);
    strcpy(buf, "SUCCESS");
    return 0;
}

int test_mkfile(fs_node_t *node) {
    log::info("Creating file '%s'\n", node->path);
    return 0;
}

int test_mkdir(fs_node_t *node) {
    log::info("Creating new folder %s\n", node->path);
    return 0;
}

fs_driver_t fs_test_driver = {
    NULL,
    NULL,
    test_write,
    test_read,
    test_mkfile,
    test_mkdir
};

void test_install() {
    fs_node_t *node = mount_fs("test", "/", fs_test_driver, USER_PERMISSION);

    if (node == NULL)
        log::info("Failed to mount 'test' at '/'\n");
    else
        log::info("Successfully mounted '%s' at '%s'!\n", node->name, nodes[node->parent_id]->path);
}
