import { Form, Link, useNavigate } from 'react-router-dom';
import Wrapper from '../assets/wrappers/RegisterAndLoginPage';
import Logo from '../components/Logo';
import FormRow from '../components/FormRow';
import { SubmitBtn } from '../components';
import customRequest from '../../../utils/customRequest';
import { toast } from 'react-toastify';

const Login = () => {
  const isDarkTheme = localStorage.getItem('darkTheme') === 'true';
  const navigate = useNavigate();

  const loginDemoUser = async () => {
    const data = {
      email: 'test@gmail.com',
      password: '123456',
    };

    try {
      await customRequest.post('/auth/login', data);
      toast.success('Take a tour with demo user');
      navigate('/dashboard');
    } catch (error) {
      toast.error(error?.response?.data?.msg);
    }
  };

  return (
    <Wrapper>
      <Form method="post" className="form">
        <Logo src={isDarkTheme ? '/logo_white.png' : '/logo_black.png'} />
        <h4>Login Page</h4>
        <FormRow type="email" name="email" />
        <FormRow type="password" name="password" />
        <SubmitBtn submitText="Submit" />
        <button type="button" className="btn btn-block" onClick={loginDemoUser}>
          Explore the app
        </button>
        <p>
          Not a member yet?
          <Link to="/register" className="member-btn">
            Register
          </Link>
        </p>
      </Form>
    </Wrapper>
  );
};
export default Login;
