# MarkdownZen

MarkdownZen is a web application designed to streamline the creation and management of markdown documents. With a user-friendly interface and powerful features, MarkdownZen is your go-to tool for a zenful markdown experience.

## Table of Contents

- [Getting Started](#getting-started)
  - [Prerequisites](#prerequisites)
  - [Installation](#installation)
- [Usage](#usage)
- [Features](#features)
- [Running With Docker](#running-with-docker)
- [Contributing](#contributing)
- [License](#license)

## Getting Started

### Prerequisites

Before you begin, make sure you have the following software installed on your computer:

- [Node.js](https://nodejs.org/en/)
- npm (Node Package Manager)

### Installation

1. **Clone the repository**:

   Open your terminal/command prompt and navigate to the location where you want to store the project. Then, run the following command:

``
git clone https://github.com/daniel752/markdown-zen.git
``

This will download the project files to your computer.

2. **Navigate to the project folder**:

Use the `cd` command to change your working directory to the cloned project folder:

``
cd markdown-zen
``

3. **Install Dependencies**:

Inside the project folder, install the necessary dependencies for both the server and the client using a single command:

``
npm run setup-project
``

This will install the required packages for the server and client components of the app.

## Usage

1. **Start the Application**:

To launch the application, run the following command in the root (markdown-zen/) folder:

``
npm run dev
``

This command starts both the server and the client concurrently, so you can access the app in your browser.

2. **Access the App**:

Open your web browser and go to `http://localhost:5173`. This is where you'll find the MarkdownZen app.

3. **Creating and Managing Markdowns**:

- Log in or create an account.
- Start creating and managing your markdown documents effortlessly.

## Features

- Create, edit, and manage markdown documents with ease.
- Real-time markdown preview while editing.
- Organize markdowns using categories and tags.
- Secure authentication and authorization system.
- ...

## Running with Docker

You can also run MarkdownZen using Docker. Follow these steps:

1. **Pull the Docker Image**:

   Pull the MarkdownZen Docker image from Docker Hub:

   ```shell
   docker pull daniel752/markdown-zen:v1.0.0
  
2. **Run the Container**:

   Start the MarkdownZen container:
   ```shell
   docker run -d daniel752/markdown-zen:v1.0.0

  
  * -d: Run the container in detached mode (in the background).
  * The container will run port 8000 inside and 5173 outside.
   
## Contributing

We welcome contributions from the community! To contribute to MarkdownZen, follow these steps:

1. **Fork the Repository**:

Click the "Fork" button on the top right of the GitHub repository page. This creates a copy of the repository under your GitHub account.

2. **Clone Your Fork**:

Clone your forked repository to your local machine:

``
git clone https://github.com/your-username/markdown-zen.git
``

3. **Create a New Branch**:

Change to the project directory:

``
cd markdown-zen
``

Create a new branch for your feature:

``
git checkout -b feature/my-new-feature
``

4. **Make Changes**:

Make the necessary changes and commit them:

``
git commit -m 'Add some feature'
``

5. **Push Your Changes**:

Push your changes to your forked repository:

``
git push origin feature/my-new-feature
``

6. **Submit a Pull Request**:

Visit the original repository on GitHub and click the "New Pull Request" button to submit your changes for review.

## License

This project is licensed under the MIT License. See the [LICENSE](LICENSE) file for details.
