# 电池信息辅助补丁

## 概述

- 较新的 ***VirtualSMC.kext*** 以及它的组件 ***kext***【8月14日之后】提供了显示电池辅助信息接口。通过定制SSDT补丁在驱动的作用下可以显示电池的 `PackLotCode`、`PCBLotCode`、`固件版本`、`硬件校正` 以及 `电池矫正` 等
- 本补丁来自 ***VirtualSMC.kext*** 官方补丁并做了些调整
- 本补丁和 `电池` 补丁无主从关系。非必要！
- 本补丁适用所有笔记本

### 补丁说明

- 在ACPI规范中，`_BST` 定义了一些电池信息，本补丁中通过方法 `CBIS` 和 `CBSS` 注入这些信息。有关 `_BST` 定义的详细内容请查阅 ACPI 规范

- 为了能够在 **无需 `电池` 补丁的机器** 上使用本补丁，示例补丁的电池路径下添加了B1B2方法

### SSDT-BATS-PRO13示例

- `电池` 路径：`_SB.PCI0.LPCB.H_EC.BAT1` 

  使用时应保证原始ACPI的电池路径与示例的电池路径一致
  
- `CBIS` 方法
  
  - 根据`_BST` 的内容查找对应变量，按 `低字节`、`高字节` 写入B1B2。如:PKG1 [0x02]=B1B2 ( `FUSL`, `FUSH` )，如果这个变量是双字节，参考电池补丁拆分数据的方法进行数据拆分、重新定义数据
  - 如果不能确认变量，可以在win或者Linux下查看电池相关信息【**未验证**】，直接填写其内容。比如：`固件版本` 是123，令PKG1 [0x04] = B1B2 (0x23, 0x01)

- `CBSS` 方法

  数据填写方法同`CBIS` 
  
  **注1**：如果不需要填写任何内容，删除 `PKG1 [Zero]=...` 至 `PKG1 [0x06]=...` 的所有内容，参见示例
  
  **注2**： 不可删除 `CBSS` 方法
  
  

