# 仿冒设备

## 综述

在众多 `SSDT` 补丁当中，相当数量的补丁可以归纳为仿冒设备补丁，如：

- 某些设备在ACPI中不存在，可是MAC系统需要它们。通过补丁对这些设备正确描述能够加载设备驱动。如《05-2-PNLF注入方法》、《添加缺失的部件》、《仿冒以太网》等。
- EC问题。如《仿冒EC》。
- 对于某些特殊的设备，使用禁止原始设备再仿冒它的方法，会给我们调整补丁的工作带来方便。如《OCI2C-TPXX补丁方法》。
- 某个原因造成某个设备被禁用，可是MAC系统需要它才能工作。见`本章`示例。
- 多数情况下，使用《二进制更名与预置变量》也可以启用设备。

## 仿冒设备

- 特点
  
  - 被仿冒的设备在ACPI中已存在，相对代码短、少、独立存在。
  
  - 原始设备具有规范的 `_HID` 或者 `_CID` 。
  - 即使原始设备未被禁用，使用仿冒设备的补丁也不会对ACPI造成伤害。
  
- 要求

  - 仿冒设备名称和ACPI的原始设备名称**不同**。

  - 补丁内容和原始设备主要内容**相同**。

  - 仿冒补丁的 `_STA` 部分应包括以下内容，确保windows系统使用原始的ACPI。

    ```Swift
        Method (_STA, 0, NotSerialized)
        {
            If (_OSI ("Darwin"))
            {
                ...
                Return (0x0F)
            }
            Else
            {
                Return (Zero)
            }
        }
    ```
  
- 示例
  - ***SSDT-RTC0*** — 仿冒RTC

    - 原始设备名称：RTC
    - _HID：PNP0B00

    **注意** ： `LPCB` 名称应和原始ACPI名称一致。
