# ACPI定制USB端口

## 描述

- 本方法通过修改 ACPI 文件实现USB端口的定制。
- 本方法操作过程需要 drop 某个 ACPI 文件。通常情况下，OpenCore **不建议** 这样做，定制 USB 端口一般使用 ***Hackintool.app*** 工具。
- 本方法献给爱好者们。

## 适用范围

- XHC 以及它的 `_UPC` 存在于单独的 ACPI 文件中
- 此方法不适用于 `_UPC` 存在于 DSDT 中的设备 (e.g. 华硕)

## `_UPC` 规范

```Swift
_UPC, Package ()
{
    xxxx,
    yyyy,
    0x00,
    0x00
}
```

### 解释

1. **`xxxx`**
   - `0x00` 代表这个端口不存在
   - 其他值 (通常为 `0x0F`) 代表这个端口存在

2. **`yyyy`**

   **`yyyy`** 处定义的是端口的类型, 参考下表

   | **`yyyy`** | 端口类型                      |
   | :------: | ----------------------------- |
   |  `0x00`  | USB Type `A`                  |
   |  `0x01`  | USB `Mini-AB`                 |
   |  `0x02`  | USB 智能卡                    |
   |  `0x03`  | USB 3 标准 Type `A`           |
   |  `0x04`  | USB 3 标准 Type `B`           |
   |  `0x05`  | USB 3 `Micro-B`               |
   |  `0x06`  | USB 3 `Micro-AB`              |
   |  `0x07`  | USB 3 `Power-B`               |
   |  `0x08`  | USB Type `C` **(只有 USB 2)** |
   |  `0x09`  | USB Type `C` **(带有转向器)** |
   |  `0x0A`  | USB Type `C` **(不带转向器)** |
   |  `0xFF`  | 内置 |

   > 如果 USB-C 正反两面插入在 Hackintool 都显示为同一个端口就说明这个端口有转向器
   >
   > 反之，如果正反两面占用了两个端口就说明没有转向器

## USB定制过程

- 清除其他定制方法的补丁、驱动等。

- drop ACPI文件

  - 确认 XHC 并包括 `_UPC` 的 ACPI 文件
    > 如 dell5480 的 ***SSDT-2-xh_OEMBD.aml***
    >
    > 如 小新 PRO13（i5）的 ***SSDT-8-CB-01.aml*** （无独显机器是 ***SSDT-6-CB-01.aml*** ）

  - `config\ACPI\Delete\` 以 `TableLength` （十进制）和 `TableSignature` 方式 drop ACPI 文件。如：

    **dell5480**： **`TableLength`** = `2001`， **`TableSignature`** = `53534454`（SSDT）

    **小新PRO13（i5）**： **`TableLength`** = `12565`， **`TableSignature`** = `53534454`（SSDT）
    
    **TableLength**可以从该aml文件的表头处`Length`中得到。

- 定制 SSDT 补丁文件

  - 将需要 drop 的原始 ACPI 文件拖到桌面，**建议：**

    - 另存为 `.asl / .dsl` 格式
    - 修改文件名。如： ***SSDT-xh_OEMBD_XHC.dsl***, ***SSDT-CB-01_XHC.dsl***
    - 修改文件内的 `OEM Table ID` 为自己喜欢的名字。
    - 排除错误。

  - SSDT 文件中所有端口的 `_UPC` 最前端添加以下代码：

    ```Swift
    Method (_UPC, 0, NotSerialized)
    {
        If (_OSI ("Darwin"))
        {
            Return (Package ()
            {
                xxxx,
                yyyy,
                0x00,
                0x00
            })
        }
        /* 以下是原内容 */
        ...
    }
    ```

  - 根据 `_UPC` 规范定制 USB 端口。即，修正 xxxx、yyyy 的值。

    - 如果端口不存在
      - **`xxxx`** = `0x00`
      - **`yyyy`** = `0x00`
    - 如果端口存在
      - **`xxxx`** = `0xFF`
      - **`yyyy`**

    > 参考上文的表格
  
  - 排错、编译、补丁文件放至 `ACPI` 、添加补丁列表。

### 参考示例

- ***SSDT-xh_OEMBD_XHC***
- ***SSDT-CB-01_XHC***
