# **CMOS** 内存和 RTCMemoryFixup

## 描述

- 当 **AppleRTC** 与 **BIOS** 发生冲突而时，可以尝试使用 **RTCMemoryFixup** 模拟 **CMOS** 内存规避冲突。
- **RTCMemoryFixup** 下载地址：<https://github.com/acidanthera/RTCMemoryFixup>

## **CMOS** 内存

- **CMOS** 内存保存着日期、时间、硬件配置信息、辅助设置信息、启动设置、休眠信息等重要数据。

- 一些 **CMOS** 内存空间定义：

  - 日期、时间、硬件配置：`00-0D` 
  - 休眠信息存放区间：`80-AB` 
  - 电源管理：`B0-B4` 
  - 其他

## 查看COMS内存

- `EFI\OC\Tools` 安装 ***RtcRw.efi*** 
- config添加 ***RtcRw.efi*** 的 `items` 
- 引导界面进入 `Shell`【确保已经安装 ***OpenShell.efi*** 】，进入目录tools，键入rtcrw read XX并回车。其中XX是CMOS内存地址。如：rtcrw read 08 可以查看当前月份。如本月是5月份，查看结果为 0x05（BCD码）。


## 模拟 **CMOS** 内存

- 安装 **RTCMemoryFixup** 至 `OC\Kexts`，并添加驱动列表。

- 引导 **`boot-args`** 添加 `rtcfx_exclude=...`

   格式： `rtcfx_exclude=offset1,offset2,start_offset-end_offset,...` 如：`rtcfx_exclude=0D`，`rtcfx_exclude=40-AF`，`rtcfx_exclude=2A,2D,80-AB` 等。


## 注意事项

- 模拟 **CMOS** 内存会抹掉原来定义的功能，请 **谨慎使用** 。如: `rtcfx_exclude=00-0D` 将导致睡眠期间机器的日期、时间不再更新。

## 附录：**CMOS** 内存`00-3F` 定义

| 地址  | 说明                                                                            |
| ----- | ------------------------------------------------------------------------------- |
| `0`     | 秒                                                                              |
| `1`     | 秒报警                                                                          |
| `2`     | 分                                                                              |
| `3`     | 分报警                                                       |
| `4`    | 时                                                                         |
| `5`    | 时报警                                                                           |
| `6`    | 星期                                                                        |
| `7`    | 日                                                                           |
| `8`    | 月                                                                             |
| `9`    | 年                                                                             |
| `A`    | 状态寄存器 A                                                                       |
| `B`    | 状态寄存器 B                                                                   |
| `C`   | 状态寄存器 C                                                                   |
| `D`    | 状态寄存器 D（0:电池失效；80:电池有效）                                                   |
| `E`    | 诊断状态字节                                        |
| `F`    | 关机状态字节（上电诊断定义）                                              |
| `10`   | 软盘驱动器类型 (位 7-4: A 驱，位 3-0: B 驱 1-360KB; 2-1.2MB; 6-1.44MB; 7-720KB) |
| `11`   | 保留 |
| `12`   | 硬盘驱动器类型 (位 7-4: C驱，位 3-0: D 驱)                                              |
| `13`   | 保留                                    |
| `14`   | 设备字节 (软驱数目，显示器类型，协处理器)                                                      |
| `15`   | 基本存储器低字节                               |
| `16`   | 基本存储器高字节                                                        |
| `17`   | 扩展存储器低字节                                                       |
| `18`   | 扩展存储器高字节                                                        |
| `19`   | 第一主硬盘类型                                                         |
| `1A`  | 第一从硬盘类型                                           |
| `1B—1C` | 保留                                                                            |
| `1D—24` | 第一主硬盘的柱面、磁头、扇区等 |
| `25—2C` | 第一从硬盘的柱面、磁头、扇区等 |
| `2D` | 保留 |
| `2E—2F` | CMOS 校验和 (10-2D 各字节和)                                                    |
| `30`   | 扩充存储器低字节                                                                |
| `31`    | 扩充存储器高字节                                                                |
| `32`    | 日期世纪字节(19H:19 世纪)                                                       |
| `33`    | 信息标志                                                                        |
| `34—3F` | 保留                                            |

