# AOAC 总述

## AOAC 技术

- 新的笔记本电脑引入了一项新技术—— `AOAC` ，即：*Always On/Always Connected* 。 `AOAC` 由 `Intel` 公司提出，旨在电脑在睡眠或者休眠模式下仍然保持网络连接及资料传输。简单的说，  `AOAC` 的引入使笔记本像我们的手机一样，永不关机，永远在线。

### `AOAC` 机器的判断方法

- 用 MaciASL 打开 `ACPI` 的 `FACP.aml` ，搜索 `Low Power S0 Idle` ，如果=1即属于 `AOAC` 机器。如：

  ```asl
  Low Power S0 Idle (V5) : 1
  ```

- 有关 `AOAC` 方面的内容请百度 `AOAC` 、 `联想AOAC` 、 `AOAC网卡` 等。

## AOAC 问题

### 睡眠失败问题

- 由于 `AOAC` 和 `S3` 本身相矛盾，采用了 `AOAC` 技术的机器不具有 `S3` 睡眠功能，如 `Lenovo PRO13` 。这样的机器一旦进入 `S3` 睡眠就会 **睡眠失败** 。 **睡眠失败** 主要表现为：睡眠后无法被唤醒，呈现死机状态，只能强制关机。**睡眠失败** 本质是机器一直停滞在睡眠过程，始终没有睡眠成功。
- 有关 `S3` 睡眠方面内容参见《ACPI 规范》。

### 待机时间问题

- **禁止`S3`睡眠** 可以解决 **睡眠失败** 问题，但是机器将不再睡眠。没有了睡眠随之而来的问题是：在电池供电模式下，机器待机时间大大缩短。比如，在"菜单睡眠"、"自动睡眠"、"盒盖睡眠"等情况下，电池耗电量较大，大约每小时耗电5%--10%。

## AOAC解决方案

- 禁止 `S3` 睡眠
- 关闭独显的供电电源
- 电源空闲管理
- 选择品质较好的 SSD：SLC>MLC>TLC>QLC（不确定）
- 可能的话更新 SSD 固件以提高电源管理的效能
- 使用 NVMeFix.kext 开启 SSD 的 APST
- 启用 ASPM（BIOS 高级选项启用ASPM、补丁启用 L1）

## AOAC 睡眠、唤醒

- `AOAC` 睡眠

  以上方案可以使机器睡眠，这种睡眠叫 `AOAC` 睡眠 。 `AOAC` 睡眠本质是系统、硬件进入了空闲状态，非传统意义上的 `S3` 睡眠。

- `AOAC` 唤醒

  机器进入 `AOAC` 睡眠后唤醒它会比较困难，通常需要电源键唤醒。某些机器可能需要电源键 + `PNP0C0D` 方法来唤醒机器。

## AOAC 补丁

- 禁止 `S3` 睡眠——参见《禁止S3睡眠》
- 禁用独显补丁——参见《AOAC禁止独显》
- 电源空闲管理补丁——参见《电源空闲管理》
- AOAC唤醒补丁——参见《AOAC唤醒方法》
- 秒醒补丁——参见《060D补丁》
- 启用设备 LI ——参见《禁止PCI设备及设置ASPM工作模式》中的 《设置ASPM工作模式》，感谢 @iStar丶Forever 提供方法
- 管控蓝牙WIFI——参见《睡眠自动关闭蓝牙WIFI》，感谢 @i5 ex900 0.66%/h 华星 OC Dreamn 提供方法

## 注意事项

- `AOAC` 解决方案是临时解决方案。随着 `AOAC` 技术的广泛应用，可能将来会有更好的解决方法。
- `AOAC` 睡眠、唤醒和 `S3` 睡眠、唤醒不同，以下补丁不在适用
  - 《PTSWAK综合扩展补丁》
  - 《PNP0C0E睡眠修正方法》
- 同上原因，`AOAC` 睡眠期间无法正确显示工作状态，如睡眠期间无呼吸灯闪烁。
- 非 `AOAC` 机器也可尝试本方法。
