# AOAC唤醒方法

## 描述

- ***SSDT-DeepIdle*** 补丁可以使机器进入深度空闲状态，延长机器待机时间。但同时也会导致唤醒机器比较困难，需要采取特殊方法来唤醒机器。有关***SSDT-DeepIdle*** 方面的内容参见《电源空闲管理》。
- **本方法** 通过定制补丁 **重置唤醒状态** 。

## 唤醒方法：电源按键

请先确认 **电源按键** 能够呼出 “重新启动、睡眠、取消、关机” 菜单，如果 **电源按键** 无法呼出上述菜单先行补丁。补丁方法参见《总述》的《ACPI表单》。

## 唤醒原理简述

- 一般情况下， **电源按键** 能够唤醒机器。但有些时候，机器被唤醒后的状态并不完整。有可能会：不能 **点亮屏幕** 或者不能 **更新电源数据** 。这种情况下，需要在 `LPCB` 设备下添加 `_PS0` 方法，并且在`_PS0` 里添加 **重置唤醒状态** 的方法。通常， `_WAK` 方法【Arg0 = 3】里包括了 **点亮屏幕** 和 **更新电源数据** 的相关内容。
- 依据 ACPI 规范，建议同时使用 `_PS0` 和 `_PS3` 方法。

## 补丁示例

- ***SSDT-PCI0.LPCB-Wake-AOAC*** 

  ```Swift
  ...
  Scope (_SB.PCI0.LPCB)
  {
      If (_OSI ("Darwin"))
      {
          Method (_PS0, 0, Serialized)
          {
              \_WAK(0x03) //恢复唤醒状态
              //可能需要定制电源数据恢复方法
          }
          Method (_PS3, 0, Serialized)
          {
          }
      }
  }
  ...
  ```
  

## 附

- **点亮屏幕条件** 
  - `_LID`  返回 `One` 。 `_LID` 是 `PNP0C0D` 设备当前状态
  - 执行 `Notify(***.LID0, 0x80)`。 `LID0` 是 `PNP0C0D` 设备名称

- **更新电源数据方法** 

  因睡眠期间改变电源状态（比如，在睡眠期间拔掉电源或者插入电源）而出现唤醒后电源图标无法更新的，可参考以下方法：

  - 查找电源设备（ `_HID` =  `ACPI0003` ）名称和路径，按电源名称搜索、记录包涵 `Notify (***电源名称, 0x80)` 的 `Method` 。将这个 `Method` 添加到 ***SSDT-PCI0.LPCB-Wake-AOAC*** 的 `_PS0` 中。
  - `Notify (***电源名称, 0x80)` 可能存在于多个 `Method` 之中，这必须通过《ACPIDebug》方法加以确认。**确认方法**：对插、拔电源有响应的 `Method` 就是我们需要的。

