# ACPI 二进制与 ASL 对照表

> ASL 是 ACPI Sourse Language 的简写，字面意思是 `ACPI 源码`

|          ASL           |   Binary    |
| :--------------------: | :---------: |
|          ZERO          |   `0x00`    |
|          ONE           |   `0x01`    |
| **##################** | **-------** |
|         ALIAS          |   `0x06`    |
|          Name          |   `0x08`    |
| **##################** | **-------** |
|          Byte          |   `0x0a`    |
|          Word          |   `0x0b`    |
|         DWORD          |   `0x0c`    |
|         STRING         |   `0x0d`    |
|         QWORD          |   `0x0e`    |
| **##################** | **-------** |
|         Scope          |   `0x10`    |
|         Buffer         |   `0x11`    |
|        Package         |   `0x12`    |
|      VAR_PACKAGE       |   `0x13`    |
|         Method         |   `0x14`    |
|        Externel        |   `0x15`    |
|       DUAL_NAME        |   `0x2e`    |
|       MULTI_NAME       |   `0x2f`    |
| **##################** | **-------** |
|           A            |   `0x41`    |
|           B            |   `0x42`    |
|           C            |   `0x43`    |
|           D            |   `0x44`    |
|           E            |   `0x45`    |
|           F            |   `0x46`    |
|           G            |   `0x47`    |
|           H            |   `0x48`    |
|           I            |   `0x49`    |
|           J            |   `0x4a`    |
|           K            |   `0x4b`    |
|           L            |   `0x4c`    |
|           M            |   `0x4d`    |
|           N            |   `0x4e`    |
|           O            |   `0x4f`    |
|           P            |   `0x50`    |
|           Q            |   `0x51`    |
|           R            |   `0x52`    |
|           S            |   `0x53`    |
|           T            |   `0x54`    |
|           U            |   `0x55`    |
|           V            |   `0x56`    |
|           W            |   `0x57`    |
|           X            |   `0x58`    |
|           Y            |   `0x59`    |
|           Z            |   `0x5a`    |
|           \            |   `0x5c`    |
|           ^            |   `0x5e`    |
|           __           |   `0x5f`    |
| **##################** | **-------** |
|         Local0         |   `0x60`    |
|         Local1         |   `0x61`    |
|         Local2         |   `0x62`    |
|         Local3         |   `0x63`    |
|         Local4         |   `0x64`    |
|         Local5         |   `0x65`    |
|         Local6         |   `0x66`    |
|         Local7         |   `0x67`    |
| **##################** | **-------** |
|          Arg0          |   `0x68`    |
|          Arg1          |   `0x69`    |
|          Arg2          |   `0x6a`    |
|          Arg3          |   `0x6b`    |
|          Arg4          |   `0x6c`    |
|          Arg5          |   `0x6d`    |
|          Arg6          |   `0x6e`    |
| **##################** | **-------** |
|         Store          |   `0x70`    |
|         Refor          |   `0x71`    |
|          Add           |   `0x72`    |
|         Concat         |   `0x73`    |
|        Suntract        |   `0x74`    |
|       INCREMENT        |   `0x75`    |
|       DECREMENT        |   `0x76`    |
|        MULTIPLY        |   `0x77`    |
|         DIVIDE         |   `0x78`    |
|       SHIFT_LEFT       |   `0x79`    |
|      SHIFT_RIGHT       |   `0x7a`    |
|          AND           |   `0x7b`    |
|          NAND          |   `0x7c`    |
|           OR           |   `0x7d`    |
|          NOR           |   `0x7e`    |
|          XOR           |   `0x7f`    |
|          NOT           |   `0x80`    |
|   FIND_SET_LEFT_BIT    |   `0x81`    |
|   FIND_SET_RIGHT_BIT   |   `0x82`    |
|        DEREF_OF        |   `0x83`    |
|       CONCAT_RES       |   `0x84`    |
|          MOD           |   `0x85`    |
|         NOTIFY         |   `0x86`    |
|        SIZE_OF         |   `0x87`    |
|         INDEX          |   `0x88`    |
|         MATCH          |   `0x89`    |
|   CREATE_DWORD_FIELD   |   `0x8a`    |
|   CREATE_WORD_FIELD    |   `0x8b`    |
|   CREATE_BYTE_FIELD    |   `0x8c`    |
|    CREATE_BIT_FIELD    |   `0x8d`    |
|      OBJECT_TYPE       |   `0x8e`    |
|   CREATE_QWORD_FIELD   |   `0x8f`    |
|          LAND          |   `0x90`    |
|          LOR           |   `0x91`    |
|          LNOT          |   `0x92`    |
|         LEQUAL         |   `0x93`    |
|        LGREATER        |   `0x94`    |
|         LLESS          |   `0x95`    |
|       TO_BUFFER        |   `0x96`    |
|     TO_DEC_STRING      |   `0x97`    |
|     TO_HEX_STRING      |   `0x98`    |
|       TO_INTEGER       |   `0x99`    |
|       TO_STRING        |   `0x9c`    |
|      COPY_OBJECT       |   `0x9d`    |
|          MID           |   `0x9e`    |
|        CONTINUE        |   `0x9f`    |
|           IF           |   `0xa0`    |
|          ELSE          |   `0xa1`    |
|         WHILE          |   `0xa2`    |
|          NOOP          |   `0xa3`    |
|         RETURN         |   `0xa4`    |
|         BREAK          |   `0xa5`    |
|      BREAK_POINT       |   `0xcc`    |
|          ONES          |   `0xff`    |
| **##################** | **-------** |
|    **扩展操作 EXT**    | **`0x5b`**  |
| **##################** | **-------** |
|         MUTEX          |   `0x01`    |
|         EVENT          |   `0x02`    |
|      COND_REF_OF       |   `0x12`    |
|      CREATE_FIELD      |   `0x13`    |
|       LOAD_TABLE       |   `0x1f`    |
|          LOAD          |   `0x20`    |
|         STALL          |   `0x21`    |
|         SLEEP          |   `0x22`    |
|        ACQUIRE         |   `0x23`    |
|         SIGNAL         |   `0x24`    |
|          WAIT          |   `0x25`    |
|         RESET          |   `0x26`    |
|        RELEASE         |   `0x27`    |
|        FROM_BCD        |   `0x28`    |
|         TO_BCD         |   `0x29`    |
|         UNLOAD         |   `0x2a`    |
|        REVISION        |   `0x30`    |
|         DEBUG          |   `0x31`    |
|         FATAL          |   `0x32`    |
|         TIMER          |   `0x33`    |
|         REGION         |   `0x80`    |
|         FIELD          |   `0x81`    |
|         DEVICE         |   `0x82`    |
|       PROCESSOR        |   `0x83`    |
|       POWER_RES        |   `0x84`    |
|      THERMAL_ZONE      |   `0x85`    |
|      INDEX_FIELD       |   `0x86`    |
|       BANK_FIELD       |   `0x87`    |
|      DATA_REGION       |   `0x88`    |