## Assembly report for Vanara.Windows.Shell.dll
Classes for Windows Shell items derived from the Vanara PInvoke libraries. Includes shell items, files, icons, links, and taskbar lists.
### Enumerations
Enum | Description | Values
---- | ---- | ----
[Vanara.Windows.Shell.NavigationLogDirection](https://github.com/dahall/Vanara/search?l=C%23&q=NavigationLogDirection) | The direction argument for NavigateFromHistory() | Forward, Backward
[Vanara.Windows.Shell.SFVMUD](https://github.com/dahall/Vanara/search?l=C%23&q=SFVMUD) | Undocumented Flags used by `Vanara.PInvoke.Shell32.IShellFolderViewCB.MessageSFVCB(Vanara.PInvoke.Shell32.SFVM,System.IntPtr,System.IntPtr,System.IntPtr@)` Callback Handler. | SFVM_SELECTIONCHANGED, SFVM_DRAWMENUITEM, SFVM_MEASUREMENUITEM, SFVM_EXITMENULOOP, SFVM_VIEWRELEASE, SFVM_GETNAMELENGTH, SFVM_WINDOWCLOSING, SFVM_LISTREFRESHED, SFVM_WINDOWFOCUSED, SFVM_REGISTERCOPYHOOK, SFVM_COPYHOOKCALLBACK, SFVM_ADDINGOBJECT, SFVM_REMOVINGOBJECT, SFVM_GETCOMMANDDIR, SFVM_GETCOLUMNSTREAM, SFVM_CANSELECTALL, SFVM_ISSTRICTREFRESH, SFVM_ISCHILDOBJECT, SFVM_GETEXTVIEWS, SFVM_GET_CUSTOMVIEWINFO, SFVM_ENUMERATEDITEMS, SFVM_GET_VIEW_DATA, SFVM_GET_WEBVIEW_LAYOUT, SFVM_GET_WEBVIEW_CONTENT, SFVM_GET_WEBVIEW_TASKS, SFVM_GET_WEBVIEW_THEME, SFVM_GETDEFERREDVIEWSETTINGS
[Vanara.Windows.Shell.ShellBrowserViewMode](https://github.com/dahall/Vanara/search?l=C%23&q=ShellBrowserViewMode) | Indicates the viewing mode of the ShellBrowser | Icon, SmallIcon, List, Details, Thumbnail, Tile, ThumbStrip, Content, Auto
[Vanara.Windows.Shell.TaskbarItemTabThumbnailOption](https://github.com/dahall/Vanara/search?l=C%23&q=TaskbarItemTabThumbnailOption) | Specifies taskbar button thumbnail tab properties. | TabWindow, MainWindow, MainWindowWhenActive
[Vanara.Windows.Shell.Visibility](https://github.com/dahall/Vanara/search?l=C%23&q=Visibility) |  | Visible, Hidden, Collapsed
### Classes
Class | Description
---- | ----
[Vanara.Windows.Shell.FilterShellItemEventArgs](https://github.com/dahall/Vanara/search?l=C%23&q=FilterShellItemEventArgs) | Event argument for FilterItem event
[Vanara.Windows.Shell.NavigatedEventArgs](https://github.com/dahall/Vanara/search?l=C%23&q=NavigatedEventArgs) | Event argument for The Navigated event
[Vanara.Windows.Shell.NavigatingEventArgs](https://github.com/dahall/Vanara/search?l=C%23&q=NavigatingEventArgs) | Event argument for The Navigating event
[Vanara.Windows.Shell.NavigationFailedEventArgs](https://github.com/dahall/Vanara/search?l=C%23&q=NavigationFailedEventArgs) | Event argument for the NavigatinoFailed event
[Vanara.Windows.Shell.ShellBrowser](https://github.com/dahall/Vanara/search?l=C%23&q=ShellBrowser) | Encapsulates a `Vanara.PInvoke.Shell32.IShellBrowser`-Implementation within an `System.Windows.Forms.UserControl`. <br /><br /> Implements the following Interfaces: <br /> - <seealso cref="T:System.Windows.Forms.IWin32Window" /><br /> - <seealso cref="T:Vanara.PInvoke.Shell32.IShellBrowser" /><br /> - <seealso cref="T:Vanara.PInvoke.Shell32.IServiceProvider" /><br /><br /> For more Information on used techniques see: <br /> - <seealso href="https://www.codeproject.com/Articles/28961/Full-implementation-of-IShellBrowser" /><br /><br /><br /> Known Issues: <br /> - Using windows 10, the virtual Quick-Access folder doesn't get displayed properly. It has to be grouped by "Group" (as shown in Windows Explorer UI), but I couldn't find the OLE-Property for this. Also, if using Groups, the Frequent Files List doesn't have its Icons. Maybe we have to bind to another version of ComCtrls to get this rendered properly - That's just an idea though, cause the Collapse-/Expand-Icons of the Groups have the Windows Vista / Windows 7-Theme, not the Windows 10 Theme as I can see. <br /> - DONE: Keyboard input doesn't work so far. <br /> - DONE: Only Details-Mode should have column headers: (Using Shell32.FOLDERFLAGS.FWF_NOHEADERINALLVIEWS) <br /> https://stackoverflow.com/questions/11776266/ishellview-columnheaders-not-hidden-if-autoview-does-not-choose-details - TODO: CustomDraw, when currently no shellView available <br /> - DONE: Network folder: E_FAIL =&gt; DONE: Returning HRESULT.E_NOTIMPL from MessageSFVCB fixes this <br /> - DONE: Disk Drive (empty): E_CANCELLED_BY_USER <br /> - DONE: Disable header in Details view when grouping is enabled - DONE: Creating ViewWindow using '.CreateViewWindow()' fails on Zip-Folders; =&gt; Fixed again by returning HRESULT.E_NOTIMPL from MessageSFVCB - TODO: internal static readonly bool IsMinVista = Environment.OSVersion.Version.Major &gt;= 6; // TODO: We use one interface, afaik, that only works in vista and above: IFolderView2 - TODO: Windows 10' Quick Access folder has a special type of grouping, can't find out how this works yet. As soon as we would be able to get all the available properties for an particular item, we would be able found out how this grouping works. However, it seems to be a special group, since folders are Tiles, whereas files are shown in Details mode. - NOTE: The grouping is done by 'Group'. Activate it using "Group by-&gt;More-&gt;Group", and then do the grouping. However, the Icons for 'Recent Files'-Group get lost. - TODO: ViewMode-Property, Thumbnailsize =&gt; Set ThumbnailSize for Large, ExtraLarge, etc. - DONE: Keyboard-Handling - DONE: BrowseObject -&gt;Parent -&gt; Relative - TODO: Properties in design editor!!! - TODO: Write History correctly! - TODO: Check getting / losing Focus! again - TODO: Context-Menu -&gt; "Open File Location" doesn't work on folder "Quick Access" - TODO: When columns get reordered in details mode, then navigate to another folder, then back =&gt; column content gets messed NOTE: https://stackoverflow.com/questions/7698602/how-to-get-embedded-explorer-ishellview-to-be-browsable-i-e-trigger-browseobje NOTE: https://stackoverflow.com/questions/54390268/getting-the-current-ishellview-user-is-interacting-with NOTE: https://www.codeproject.com/Articles/35197/Undocumented-List-View-Features // IMPORTANT! NOTE: https://answers.microsoft.com/en-us/windows/forum/windows_10-files-winpc/windows-10-quick-access-folders-grouped-separately/ecd4be4a-1847-4327-8c44-5aa96e0120b8
[Vanara.Windows.Shell.ShellBrowserNavigatedEventArgs](https://github.com/dahall/Vanara/search?l=C%23&q=ShellBrowserNavigatedEventArgs) | Event argument for The Navigated event.
[Vanara.Windows.Shell.ShellBrowserViewHandler](https://github.com/dahall/Vanara/search?l=C%23&q=ShellBrowserViewHandler) | Encapsulates an `Vanara.PInvoke.Shell32.IShellFolderViewCB">IShellFolderViewCB</see>-Implementation within an <see cref="T:System.IDisposable`-Object. Beside that it's implemented as a Wrapper-Object that is responsible for creating and disposing the following objects aka Interface-Instances: <br /> - <seealso cref="T:Vanara.Windows.Shell.ShellFolder" /><br /> - <seealso cref="T:Vanara.PInvoke.Shell32.IShellView" /><br /> - <seealso cref="T:Vanara.PInvoke.Shell32.IFolderView2" /><br /><br /> While doing that, it also handles some common error cases: <br /> - When there's no disk in a disk drive <br /><br /> Implements the following Interfaces: <br /> - <seealso cref="T:Vanara.PInvoke.Shell32.IShellFolderViewCB" /><br /><br /> This class make use of some <see cref="T:Vanara.Windows.Shell.SFVMUD">undocumented Messages</see> in its `Vanara.PInvoke.Shell32.IShellFolderViewCB.MessageSFVCB(Vanara.PInvoke.Shell32.SFVM,System.IntPtr,System.IntPtr,System.IntPtr@)` Callback Handler. <br /><br /> For more Information on these see: <br /> - Google Drive Shell Extension: <seealso href="https://github.com/google/google-drive-shell-extension/blob/master/DriveFusion/ShellFolderViewCBHandler.cpp"> ShellFolderViewCBHandler.cpp</seealso><br /> - ReactOS: <seealso href="https://doxygen.reactos.org/d2/dbb/IShellFolderViewCB_8cpp.html">IShellFolderViewCB.cpp File Reference </seealso>, <seealso href="https://doxygen.reactos.org/d2/dbb/IShellFolderViewCB_8cpp_source.html">IShellFolderViewCB.cpp</seealso>
[Vanara.Windows.Shell.ShellDataObject](https://github.com/dahall/Vanara/search?l=C%23&q=ShellDataObject) | Shell extended `System.Windows.Forms.DataObject`.
[Vanara.Windows.Shell.ShellFileDescriptor](https://github.com/dahall/Vanara/search?l=C%23&q=ShellFileDescriptor) | Describes the properties of a file that is being copied by means of the clipboard during a Microsoft ActiveX drag-and-drop operation.
[Vanara.Windows.Shell.TaskbarButton](https://github.com/dahall/Vanara/search?l=C%23&q=TaskbarButton) | Provides access to the functionality of the taskbar button.
[Vanara.Windows.Shell.TaskbarButtonThumbnail](https://github.com/dahall/Vanara/search?l=C%23&q=TaskbarButtonThumbnail) | 
[Vanara.Windows.Shell.TaskbarButtonThumbnails](https://github.com/dahall/Vanara/search?l=C%23&q=TaskbarButtonThumbnails) | The list of thumbnails to be displayed on the taskbar button.
[Vanara.Windows.Shell.ThumbnailToolbar](https://github.com/dahall/Vanara/search?l=C%23&q=ThumbnailToolbar) | The toolbar associated with thumbnails shown when hovering over an application's taskbar button.
[Vanara.Windows.Shell.ThumbnailToolbarButton](https://github.com/dahall/Vanara/search?l=C%23&q=ThumbnailToolbarButton) | A button in the toolbar associated with thumbnails displayed on a taskbar button.
[Vanara.Windows.Shell.ThumbnailToolbarButtonCollection](https://github.com/dahall/Vanara/search?l=C%23&q=ThumbnailToolbarButtonCollection) | A collection of thumbnail toolbar buttons.
