## Assembly report for Vanara.Windows.Shell.Common.dll
Common classes for Windows Shell items derived from the Vanara PInvoke libraries. Includes shell items, files, icons, links, and taskbar lists.
### Enumerations
Enum | Description | Values
---- | ---- | ----
[Vanara.Windows.Shell.ChangeFilters](https://github.com/dahall/Vanara/search?l=C%23&q=ChangeFilters) | Changes that might occur to a shell item or folder. | ItemRenamed, ItemCreated, ItemDeleted, FolderCreated, FolderDeleted, MediaInserted, MediaRemoved, DriveRemoved, DriveAdded, FolderShared, FolderUnshared, Attributes, FolderUpdated, ItemUpdated, ServerDisconnected, SystemImageUpdated, DriveAddedInteractive, FolderRenamed, AllDiskEvents, DriveFreeSpaceChanged, ExtendedEvent, FileAssociationChanged, AllGlobalEvents, AllEvents
[Vanara.Windows.Shell.ShellFileOperationDialog.DialogStatus](https://github.com/dahall/Vanara/search?l=C%23&q=DialogStatus) | Provides operation status flags for ShellFileOperationDialog. | NotStarted, Running, Paused, Cancelled, Stopped, Errors
[Vanara.Windows.Shell.ExecutableType](https://github.com/dahall/Vanara/search?l=C%23&q=ExecutableType) | Specifies the executable file type. | Nonexecutable, DOS, Win32Console, Windows
[Vanara.Windows.Shell.FileUsageType](https://github.com/dahall/Vanara/search?l=C%23&q=FileUsageType) | Constants used to indicate how a file in use is being used. | Playing, Editing, Generic
[Vanara.Windows.Shell.FolderItemFilter](https://github.com/dahall/Vanara/search?l=C%23&q=FolderItemFilter) | A filter for the types of children to enumerate. | Folders, NonFolders, IncludeHidden, Printers, Shareable, Storage, FastItems, FlatList, IncludeSuperHidden
[Vanara.Windows.Shell.LibraryFolderFilter](https://github.com/dahall/Vanara/search?l=C%23&q=LibraryFolderFilter) | Defines options for filtering folder items. | FileSystemOnly, StorageObjects, AllItems
[Vanara.Windows.Shell.LibraryViewTemplate](https://github.com/dahall/Vanara/search?l=C%23&q=LibraryViewTemplate) | Defines the type of view assigned to a library folder. | Documents, General, Music, Pictures, Videos, Custom
[Vanara.Windows.Shell.LinkResolution](https://github.com/dahall/Vanara/search?l=C%23&q=LinkResolution) | Flags determining how the links with missing targets are resolved. | None, NoUI, AnyMatch, Update, NoUpdate, NoSearch, NoTrack, NoLinkInfo, InvokeMSI, NoUIWithMsgPump, OfferDeleteWithoutFile, KnownFolder, MachineInLocalTarget, UpdateMachineAndSid, NoObjectID
[Vanara.Configuration.MRUManager.MenuPlacement](https://github.com/dahall/Vanara/search?l=C%23&q=MenuPlacement) | The placement of a menu item in a list. | Bottom, Top
[Vanara.Windows.Shell.ShellFileOperations.OperationFlags](https://github.com/dahall/Vanara/search?l=C%23&q=OperationFlags) | Flags that control the file operation. | MultiDestFiles, Silent, RenameOnCollision, NoConfirmation, WantMappingHandle, AllowUndo, FilesOnly, SimpleProgress, NoConfirmMkDir, NoErrorUI, NoUI, NoCopySecurityAttribs, NoRecursion, NoConnectedElements, WantNukeWarning, NoSkipJunctions, PreferHardLink, ShowElevationPrompt, RecycleOnDelete, EarlyFailure, PreserveFileExtensions, KeepNewerFile, NoCopyHooks, NoMinimizeBox, MoveACLsAcrossVolumes, DontDisplaySourcePath, DontDisplayDestPath, RequireElevation, AddUndoRecord, CopyAsDownload, DontDisplayLocations
[Vanara.Windows.Shell.ShellFileOperationDialog.OperationMode](https://github.com/dahall/Vanara/search?l=C%23&q=OperationMode) | Flags used in Mode | Default, Running, Starting, Undoing, BlockedByErrors, Indeterminate
[Vanara.Windows.Shell.ShellFileOperationDialog.OperationType](https://github.com/dahall/Vanara/search?l=C%23&q=OperationType) | Describes an action being performed that requires progress to be shown to the user using progress dialog. | None, Moving, Copying, Recycling, ApplyingAttributes, Downloading, SearchingInternet, Calculating, Uploading, SearchingFiles, Deleting, Renaming, Formatting, CopyMoving
[Vanara.Windows.Shell.ShellIconType](https://github.com/dahall/Vanara/search?l=C%23&q=ShellIconType) | The type of icon to be returned from `Vanara.Windows.Shell.ShellFileInfo.GetIcon(Vanara.Windows.Shell.ShellIconType)`. | Large, Small, Open, ShellDefinedSize, LinkOverlay, Selected
[Vanara.Windows.Shell.ShellImageSize](https://github.com/dahall/Vanara/search?l=C%23&q=ShellImageSize) | Used to determine the size of the icon returned by <c>ShellImageList.GetSystemIcon</c>. | Large, Small, ExtraLarge, SystemSmall, Jumbo
[Vanara.Windows.Shell.ShellItemAttribute](https://github.com/dahall/Vanara/search?l=C%23&q=ShellItemAttribute) | Attributes that can be retrieved on an item (file or folder) or set of items using `Vanara.Windows.Shell.ShellItem.Attributes`. | CanCopy, CanMove, CanLink, Storage, CanRename, CanDelete, HasPropSheet, DropTarget, CapabilityMask, System, Encrypted, IsSlow, Ghosted, Link, Share, ReadOnly, Hidden, DisplayAttrMask, NonEnumerated, NewContent, CanMoniker, HasStorage, Stream, StorageAncestor, Validate, Removable, Compressed, Browsable, FileSysAncestor, Folder, FileSystem, StorageCapMask, HasSubfolder, ContentsMask, PKEYMask
[Vanara.Windows.Shell.ShellItemComparison](https://github.com/dahall/Vanara/search?l=C%23&q=ShellItemComparison) | Used to determine how to compare two Shell items. ShellItem.Compare uses this enumerated type. | Display, Canonical, SecondaryFileSystemPath, AllFields
[Vanara.Windows.Shell.ShellItemDisplayString](https://github.com/dahall/Vanara/search?l=C%23&q=ShellItemDisplayString) | Requests the form of an item's display name to retrieve through `Vanara.Windows.Shell.ShellItem.GetDisplayName(Vanara.Windows.Shell.ShellItemDisplayString)`. | NormalDisplay, ParentRelativeParsing, DesktopAbsoluteParsing, ParentRelativeEditing, DesktopAbsoluteEditing, FileSysPath, Url, ParentRelativeForAddressBar, ParentRelative, ParentRelativeForUI
[Vanara.Windows.Shell.ShellItemGetImageOptions](https://github.com/dahall/Vanara/search?l=C%23&q=ShellItemGetImageOptions) | Options for retrieving images from a `Vanara.Windows.Shell.ShellItem`. | ResizeToFit, BiggerSizeOk, MemoryOnly, IconOnly, ThumbnailOnly, InCacheOnly, CropToSquare, WideThumbnails, IconBackground, ScaleUp
[Vanara.Windows.Shell.ShellItemToolTipOptions](https://github.com/dahall/Vanara/search?l=C%23&q=ShellItemToolTipOptions) | Flags that direct the handling of the item from which you're retrieving the info tip text. | Default, Name, LinkNotTarget, LinkTarget, AllowDelay, SingleLine
[Vanara.Windows.Shell.TaskbarButtonProgressState](https://github.com/dahall/Vanara/search?l=C%23&q=TaskbarButtonProgressState) | State of the progress shown on a taskbar button. | None, Indeterminate, Normal, Error, Paused
[Vanara.Windows.Shell.ShellFileOperations.TransferFlags](https://github.com/dahall/Vanara/search?l=C%23&q=TransferFlags) | Used by methods of the ITransferSource and ITransferDestination interfaces to control their file operations. | Normal, FailExist, RenameExist, OverwriteExist, AllowDecryption, NoSecurity, CopyCreationTime, CopyWriteTime, UseFullAccess, DeleteRecycleIfPossible, CopyHardLink, CopyLocalizedName, MoveAsCopyDelete, SuspendShellEvents
[Vanara.Windows.Shell.VerbMultiSelectModel](https://github.com/dahall/Vanara/search?l=C%23&q=VerbMultiSelectModel) | A value that determines if a user can select a single item, multiple items, or a selection from an item. | Unset, Player, Single, Document
[Vanara.Windows.Shell.VerbPosition](https://github.com/dahall/Vanara/search?l=C%23&q=VerbPosition) | Determines the placement of a verb in a menu. | Undefined, Top, Bottom
[Vanara.Windows.Shell.VerbSelectionModel](https://github.com/dahall/Vanara/search?l=C%23&q=VerbSelectionModel) | Determines menu location. | Item, BackgroundShortcutMenu
[Vanara.Windows.Shell.WallpaperFit](https://github.com/dahall/Vanara/search?l=C%23&q=WallpaperFit) | Specifies how the desktop wallpaper should be displayed. | Center, Tile, Stretch, Fit, Fill, Span
### Interfaces
Interface | Description
---- | ----
[Vanara.Windows.Shell.IComObject](https://github.com/dahall/Vanara/search?l=C%23&q=IComObject) | Exposed methods from `Vanara.Windows.Shell.ComObject`.
[Vanara.Configuration.MRUManager.IFileListStorage](https://github.com/dahall/Vanara/search?l=C%23&q=IFileListStorage) | Defines a class that implements storage for an MRU file list.
[Vanara.Windows.Shell.IJumpListItem](https://github.com/dahall/Vanara/search?l=C%23&q=IJumpListItem) | Represents a Jump List item.
[Vanara.Configuration.MRUManager.IMenuBuilder](https://github.com/dahall/Vanara/search?l=C%23&q=IMenuBuilder) | Defines a class that implements a menu handler for an MRU file list.
### Classes
Class | Description
---- | ----
[Vanara.Windows.ExtenderProviderBase&lt;T&gt;.AddExtenderEventArgs](https://github.com/dahall/Vanara/search?l=C%23&q=AddExtenderEventArgs) | Arguments for the `Vanara.Windows.ExtenderProviderBase.AddingExtender` event.
[Vanara.Windows.Shell.Registration.AppRegistration](https://github.com/dahall/Vanara/search?l=C%23&q=AppRegistration) | Represents the registration entries for an application.
[Vanara.Configuration.MRUManager.AppSettingsFileListStorage](https://github.com/dahall/Vanara/search?l=C%23&q=AppSettingsFileListStorage) | Storage in the local application settings.
[Vanara.Windows.Shell.BindContext](https://github.com/dahall/Vanara/search?l=C%23&q=BindContext) | Wraps the `System.Runtime.InteropServices.ComTypes.IBindCtx` COM type.
[Vanara.Windows.Shell.ComClassFactory](https://github.com/dahall/Vanara/search?l=C%23&q=ComClassFactory) | An implementation of `Vanara.PInvoke.Ole32.IClassFactory` to be used in conjunction with `Vanara.Windows.Shell.IComObject` derivatives.
[Vanara.Windows.Shell.CommandVerb](https://github.com/dahall/Vanara/search?l=C%23&q=CommandVerb) | Encapsulates a shortcut menu verb in the registry.
[Vanara.Windows.Shell.CommandVerbDictionary](https://github.com/dahall/Vanara/search?l=C%23&q=CommandVerbDictionary) | A dictionary of Command Verbs defined in the Windows Registry.
[Vanara.Windows.Shell.ComObject](https://github.com/dahall/Vanara/search?l=C%23&q=ComObject) | Base class for all COM objects which handles calling AddRef and Release for the assembly, connection to IClassFactory, implements IObjectWithSite, using an internal message loop, and a mechanism to issue a non-blocking call to itself. Once implemented, you only need to implement your own interfaces. The IClassFactory implementation can get any derived interfaces through casting for calls to its QueryInterface method. If you want more control, override the QueryInterface method in this class.
[Vanara.Windows.Shell.ComObjWrapper&lt;T&gt;](https://github.com/dahall/Vanara/search?l=C%23&q=ComObjWrapper%26lt%3BT%26gt%3B) | 
[Vanara.Windows.Shell.ControlPanel](https://github.com/dahall/Vanara/search?l=C%23&q=ControlPanel) | Provides a means to open Control Panel items and get their paths.
[Vanara.Windows.Shell.DragEventArgs](https://github.com/dahall/Vanara/search?l=C%23&q=DragEventArgs) | Provides data for the `Vanara.Windows.Shell.ShellDropTarget.DragDrop`, `Vanara.Windows.Shell.ShellDropTarget.DragEnter`, or `Vanara.Windows.Shell.ShellDropTarget.DragOver` event.
[Vanara.Windows.ExtenderProviderBase&lt;T&gt;](https://github.com/dahall/Vanara/search?l=C%23&q=ExtenderProviderBase%26lt%3BT%26gt%3B) | A generic base to implement `System.ComponentModel.IExtenderProvider` for a single extender type.
[Vanara.Windows.Shell.FileInUseHandler](https://github.com/dahall/Vanara/search?l=C%23&q=FileInUseHandler) | A handler for applications that open file types that can be opened by other applications. An application's use of this object enables Windows Explorer to discover the source of sharing errors, which enables users to address and retry operations that fail due to those errors. This object handles registering the file with the Running Object Table (see `Vanara.PInvoke.Ole32.IRunningObjectTable`). It will revoke that registration on disposal or when the `Vanara.Windows.Shell.FileInUseHandler.Registered` property is set to <see langword="false" />.
[Vanara.Windows.Shell.Registration.FileTypeAssociation](https://github.com/dahall/Vanara/search?l=C%23&q=FileTypeAssociation) | Manages registry entries related to file types and file associations.
[Vanara.Windows.Shell.IconLocation](https://github.com/dahall/Vanara/search?l=C%23&q=IconLocation) | Wraps the icon location string used by some Shell classes.
[Vanara.Windows.Shell.JumpList](https://github.com/dahall/Vanara/search?l=C%23&q=JumpList) | Provides access to the jump list on the application's task bar icon.
[Vanara.Windows.Shell.JumpListDestination](https://github.com/dahall/Vanara/search?l=C%23&q=JumpListDestination) | A file-based destination for a jumplist with an associated category.
[Vanara.Windows.Shell.JumpListItem](https://github.com/dahall/Vanara/search?l=C%23&q=JumpListItem) | An item in a Jump List.
[Vanara.Windows.Shell.JumpListSeparator](https://github.com/dahall/Vanara/search?l=C%23&q=JumpListSeparator) | A separator which can be inserted into a custom list or task list.
[Vanara.Windows.Shell.JumpListTask](https://github.com/dahall/Vanara/search?l=C%23&q=JumpListTask) | A task for a jumplist.
[Vanara.Windows.Shell.MemoryPropertyStore](https://github.com/dahall/Vanara/search?l=C%23&q=MemoryPropertyStore) | An in-memory property store.
[Vanara.Windows.Shell.ShellContextMenu.MenuItemInfo](https://github.com/dahall/Vanara/search?l=C%23&q=MenuItemInfo) | Provides information about a single menu entry discovered in a native menu.
[Vanara.PInvoke.MessageLoop.MessageEventArgs](https://github.com/dahall/Vanara/search?l=C%23&q=MessageEventArgs) | Holds a copy of the MSG instance retrieved by GetMessage.
[Vanara.PInvoke.MessageLoop](https://github.com/dahall/Vanara/search?l=C%23&q=MessageLoop) | <p> This class encapsulates the management of a message loop for an application. It supports queuing a callback to the application via the message loop to enable the app to return from a call and continue processing that call later. This behavior is needed when implementing a shell verb as verbs must not block the caller. </p> <note type="note">The ComObject derived class should call QueueNonBlockingCallback in its invoke function, for example IExecuteCommand::Execute() or IDropTarget::Drop() passing a method that will complete the initialization work.</note>
[Vanara.Configuration.MRUManager](https://github.com/dahall/Vanara/search?l=C%23&q=MRUManager) | A class that manages a Most Recently Used file listing.
[Vanara.Windows.Shell.NativeClipboard](https://github.com/dahall/Vanara/search?l=C%23&q=NativeClipboard) | Static class with methods to interact with the Clipboard.
[Vanara.Windows.Shell.ProgId](https://github.com/dahall/Vanara/search?l=C%23&q=ProgId) | Represents a programmatic identifier in the registry for an application.
[Vanara.Windows.Shell.PropertyBag](https://github.com/dahall/Vanara/search?l=C%23&q=PropertyBag) | Encapsulates an `Vanara.PInvoke.OleAut32.IPropertyBag` instance.
[Vanara.Windows.Shell.PropertyDescription](https://github.com/dahall/Vanara/search?l=C%23&q=PropertyDescription) | Enumerate and retrieve individual property description details. Wraps the `Vanara.PInvoke.PropSys.IPropertyDescription` shell interface
[Vanara.Windows.Shell.PropertyDescriptionList](https://github.com/dahall/Vanara/search?l=C%23&q=PropertyDescriptionList) | Exposes methods that extract information from a collection of property descriptions presented as a list.
[Vanara.Windows.Shell.PropertyStore](https://github.com/dahall/Vanara/search?l=C%23&q=PropertyStore) | Encapsulates the IPropertyStore object.
[Vanara.Windows.Shell.PropertyType](https://github.com/dahall/Vanara/search?l=C%23&q=PropertyType) | Exposes methods that extract data from enumeration information.
[Vanara.Windows.Shell.PropertyTypeList](https://github.com/dahall/Vanara/search?l=C%23&q=PropertyTypeList) | Exposes methods that enumerate the possible values for a property.
[Vanara.Windows.Shell.RecycleBin](https://github.com/dahall/Vanara/search?l=C%23&q=RecycleBin) | A static object that represents the system Recycle Bin.
[Vanara.Windows.Shell.RegBasedDictionary&lt;T&gt;](https://github.com/dahall/Vanara/search?l=C%23&q=RegBasedDictionary%26lt%3BT%26gt%3B) | A virtual dictionary that is based on values in the Windows Registry.
[Vanara.Windows.Shell.RegBasedSettings](https://github.com/dahall/Vanara/search?l=C%23&q=RegBasedSettings) | Base class for registry based settings.
[Vanara.Configuration.MRUManager.RegistryFileListStorage](https://github.com/dahall/Vanara/search?l=C%23&q=RegistryFileListStorage) | 
[Vanara.Windows.Shell.SearchCondition](https://github.com/dahall/Vanara/search?l=C%23&q=SearchCondition) | Provides properties and methods for retrieving information about a search condition.
[Vanara.Windows.Shell.ShellAssociation](https://github.com/dahall/Vanara/search?l=C%23&q=ShellAssociation) | Represents a Shell file association defined in the Windows Registry. Wraps `Vanara.PInvoke.ShlwApi.IQueryAssociations`.
[Vanara.Windows.Shell.ShellAssociation.ShellAssociationHandler](https://github.com/dahall/Vanara/search?l=C%23&q=ShellAssociationHandler) | Represents a handler (executable) for a `Vanara.Windows.Shell.ShellAssociation`.
[Vanara.Windows.Shell.ShellCommand](https://github.com/dahall/Vanara/search?l=C%23&q=ShellCommand) | Wraps the functionality of IInitializeCommand. When deriving, handling the `Vanara.Windows.Shell.ShellCommand.InitializeCommand` event is optional.
[Vanara.Windows.Shell.ShellContextMenu](https://github.com/dahall/Vanara/search?l=C%23&q=ShellContextMenu) | Provides support for displaying the context menu of a shell item.
[Vanara.Windows.Shell.ShellDataTable](https://github.com/dahall/Vanara/search?l=C%23&q=ShellDataTable) | Represents a `System.Data.DataTable` that is populated asynchronously with information about shell items.
[Vanara.Windows.Shell.ShellDropTarget](https://github.com/dahall/Vanara/search?l=C%23&q=ShellDropTarget) | COM object that implements IDropTarget. Solves race problem on drop and simplifies interface calls. All IDropTarget methods call their equivalent On[MethodName] equivalents. To specialize their handling, simply override the On[MethodName] method or hook an event to the corresponding event.
[Vanara.Windows.Shell.ShellExecuteCommand](https://github.com/dahall/Vanara/search?l=C%23&q=ShellExecuteCommand) | Wraps the functionality of IExecuteCommand. To implement, derive from this class and override the `Vanara.Windows.Shell.ShellExecuteCommand.OnExecute` method. All Shell items passed to the command are available through the `Vanara.Windows.Shell.ShellExecuteCommand.SelectedItems` property.
[Vanara.Windows.Shell.ShellFileInfo](https://github.com/dahall/Vanara/search?l=C%23&q=ShellFileInfo) | Information and icons for any shell file.
[Vanara.Windows.Shell.ShellFileOperations.ShellFileNewOpEventArgs](https://github.com/dahall/Vanara/search?l=C%23&q=ShellFileNewOpEventArgs) | Arguments supplied to the `Vanara.Windows.Shell.ShellFileOperations.PostNewItem` event.
[Vanara.Windows.Shell.ShellFileOperationDialog](https://github.com/dahall/Vanara/search?l=C%23&q=ShellFileOperationDialog) | The Shell's progress dialog.
[Vanara.Windows.Shell.ShellFileOperations](https://github.com/dahall/Vanara/search?l=C%23&q=ShellFileOperations) | Queued and static file operations using the Shell.
[Vanara.Windows.Shell.ShellFileOperations.ShellFileOpEventArgs](https://github.com/dahall/Vanara/search?l=C%23&q=ShellFileOpEventArgs) | Arguments supplied to events from `Vanara.Windows.Shell.ShellFileOperations`. Depending on the event, some properties may not be set.
[Vanara.Windows.Shell.ShellFolder](https://github.com/dahall/Vanara/search?l=C%23&q=ShellFolder) | A folder or container of `Vanara.Windows.Shell.ShellItem` instances.
[Vanara.Windows.Shell.ShellFolderCategorizer](https://github.com/dahall/Vanara/search?l=C%23&q=ShellFolderCategorizer) | Exposes a list of categorizers registered on an IShellFolder.
[Vanara.Windows.Shell.ShellFolderCategory](https://github.com/dahall/Vanara/search?l=C%23&q=ShellFolderCategory) | A shell folder category object.
[Vanara.Windows.Shell.ShellIconExtractedEventArgs](https://github.com/dahall/Vanara/search?l=C%23&q=ShellIconExtractedEventArgs) | Event arguments that expose an ID list and associated image.
[Vanara.Windows.Shell.ShellIconExtractor](https://github.com/dahall/Vanara/search?l=C%23&q=ShellIconExtractor) | Class that simplifies extracting icons from items in a Shell Folder.
[Vanara.Windows.Shell.ShellImageList](https://github.com/dahall/Vanara/search?l=C%23&q=ShellImageList) | Represents the System Image List holding images for all shell icons.
[Vanara.Windows.Shell.ShellItem](https://github.com/dahall/Vanara/search?l=C%23&q=ShellItem) | Encapsulates an item in the Windows Shell.
[Vanara.Windows.Shell.ShellItemArray](https://github.com/dahall/Vanara/search?l=C%23&q=ShellItemArray) | A folder or container of `Vanara.Windows.Shell.ShellItem` instances.
[Vanara.Windows.Shell.ShellItemChangeWatcher.ShellItemChangeEventArgs](https://github.com/dahall/Vanara/search?l=C%23&q=ShellItemChangeEventArgs) | Provides data for `Vanara.Windows.Shell.ShellItemChangeWatcher` events.
[Vanara.Windows.Shell.ShellItemChangeWatcher](https://github.com/dahall/Vanara/search?l=C%23&q=ShellItemChangeWatcher) | Listens to the shell item change notifications and raises events when a folder, or item in a folder, changes.
[Vanara.Windows.Shell.ShellItemImages](https://github.com/dahall/Vanara/search?l=C%23&q=ShellItemImages) | Exposes methods that get images related to shell items.
[Vanara.Windows.Shell.ShellItemPropertyStore](https://github.com/dahall/Vanara/search?l=C%23&q=ShellItemPropertyStore) | A property store for a `Vanara.Windows.Shell.ShellItem`.
[Vanara.Windows.Shell.ShellItemPropertyUpdates](https://github.com/dahall/Vanara/search?l=C%23&q=ShellItemPropertyUpdates) | A dictionary of properties that can be used to set or update property values on Shell items via the `Vanara.Windows.Shell.ShellFileOperations.QueueApplyPropertiesOperation(Vanara.Windows.Shell.ShellItem,Vanara.Windows.Shell.ShellItemPropertyUpdates)` method. This class wraps the `Vanara.Windows.Shell.ShellItemPropertyUpdates.IPropertyChangeArray` COM interface.
[Vanara.Windows.Shell.ShellLibrary](https://github.com/dahall/Vanara/search?l=C%23&q=ShellLibrary) | Shell library encapsulation.
[Vanara.Windows.Shell.ShellLibrary.ShellLibraryFolders](https://github.com/dahall/Vanara/search?l=C%23&q=ShellLibraryFolders) | Folders of a `Vanara.Windows.Shell.ShellLibrary`.
[Vanara.Windows.Shell.ShellLink](https://github.com/dahall/Vanara/search?l=C%23&q=ShellLink) | Represents a Shell Shortcut (.lnk) file.
[Vanara.Windows.Shell.ShellNavigationHistory](https://github.com/dahall/Vanara/search?l=C%23&q=ShellNavigationHistory) | The navigation log is a history of the locations visited by a shell view object.
[Vanara.Windows.Shell.ShellRegistrar](https://github.com/dahall/Vanara/search?l=C%23&q=ShellRegistrar) | Contains static methods used to register and unregister shell items in the Windows Registry.
[Vanara.Windows.Shell.ShellSearch](https://github.com/dahall/Vanara/search?l=C%23&q=ShellSearch) | Represents functionality of the Windows Search Service.
[Vanara.Windows.Shell.ShellSearchViewSettings](https://github.com/dahall/Vanara/search?l=C%23&q=ShellSearchViewSettings) | Settings that change the folder view of a search.
[Vanara.Windows.Shell.StockIcon](https://github.com/dahall/Vanara/search?l=C%23&q=StockIcon) | Represents a standard system icon.
[Vanara.Windows.Shell.TaskBar.Taskbar](https://github.com/dahall/Vanara/search?l=C%23&q=Taskbar) | Provides information about and some control of the system taskbar.
[Vanara.Windows.Shell.TaskbarList](https://github.com/dahall/Vanara/search?l=C%23&q=TaskbarList) | Methods that control the Windows taskbar. It allows you to dynamically add, remove, and activate items on the taskbar. This wraps all of the ITaskbarListX interfaces.
[Vanara.Windows.Shell.TaskBar.TrayIcon](https://github.com/dahall/Vanara/search?l=C%23&q=TrayIcon) | 
[Vanara.Windows.Shell.Utils](https://github.com/dahall/Vanara/search?l=C%23&q=Utils) | Utility methods for shell functions.
[Vanara.Windows.Shell.WallpaperManager](https://github.com/dahall/Vanara/search?l=C%23&q=WallpaperManager) | Provides methods for managing the desktop wallpaper.
[Vanara.Windows.Shell.WallpaperManager.WallpaperMonitor](https://github.com/dahall/Vanara/search?l=C%23&q=WallpaperMonitor) | Represents the wallpaper settings on a single monitor.
[Vanara.Windows.Shell.WallpaperManager.WallpaperSlideshow](https://github.com/dahall/Vanara/search?l=C%23&q=WallpaperSlideshow) | Represents the settings for a wallpaper slideshow.
