## Assembly report for Vanara.Windows.Forms.dll
Classes for user interface related items derived from the Vanara PInvoke libraries. Includes extensions for almost all common controls to give post Vista capabilities, WinForms controls (panel, commandlink, enhanced combo boxes, IPAddress, split button, trackbar and themed controls), shutdown/restart/lock control, buffered painting, resource files, access control editor, simplifed designer framework for Windows.Forms.
### Enumerations
Enum | Description | Values
---- | ---- | ----
[Vanara.Windows.Forms.VisualTheme.BitmapProperty](https://github.com/dahall/Vanara/search?l=C%23&q=BitmapProperty) | Properties accessible via `Vanara.Windows.Forms.VisualTheme.GetBitmap(System.Int32,System.Int32,Vanara.Windows.Forms.VisualTheme.BitmapProperty)`. | BackgroundImage, GlyphImage, Handle
[Vanara.Windows.Forms.VisualTheme.BoolProperty](https://github.com/dahall/Vanara/search?l=C%23&q=BoolProperty) | Properties accessible via `Vanara.Windows.Forms.VisualTheme.GetBool(System.Int32,System.Int32,Vanara.Windows.Forms.VisualTheme.BoolProperty)`. | FlatMenus, Transparent, AutoSize, BorderOnly, Composited, BackgroundFill, GlyphTransparent, GlyphOnly, AlwaysShowSizingBar, MirrorImage, UniformSizing, IntegralSizing, SourceGrow, SourceShrink, DrawBorders, NoEtchedEffect, TextApplyOverlay, TextGlow, TextItalic, CompositedOpaque, LocalizedMirrorImage, UserPicture, ScaledBackground
[Vanara.Windows.Forms.DesktopWindowManager.CloakingSource](https://github.com/dahall/Vanara/search?l=C%23&q=CloakingSource) | Use with GetWindowAttr and WindowAttribute.Cloaked. If the window is cloaked, provides one of the following values explaining why. | App, Shell, Inherited
[Vanara.Windows.Forms.CollapsiblePanelBorderCondition](https://github.com/dahall/Vanara/search?l=C%23&q=CollapsiblePanelBorderCondition) | Determines when a border will be displayed. | Always, OnlyExpanded, Never
[Vanara.Windows.Forms.CollapsiblePanelHeaderState](https://github.com/dahall/Vanara/search?l=C%23&q=CollapsiblePanelHeaderState) | Determines the state of the panel's header. | Normal, Hot, Pressed, ExpandedNormal, ExpandedHot, ExpandedPressed, Disabled, ExpandedDisabled
[Vanara.Windows.Forms.VisualTheme.ColorProperty](https://github.com/dahall/Vanara/search?l=C%23&q=ColorProperty) | Properties accessible via `Vanara.Windows.Forms.VisualTheme.GetColor(System.Int32,System.Int32,Vanara.Windows.Forms.VisualTheme.ColorProperty)`. | ScrollBar, Background, ActiveCaption, InactiveCaption, Menu, Window, WindowFrame, MenuText, WindowText, CaptionText, ActiveBorder, InactiveBorder, AppWorkspace, Highlight, HighlightText, ButtonFace, ButtonShadow, GrayText, ButtonText, InactiveCaptionText, ButtonHighlight, DarkShadow3D, Light3D, InfoText, InfoBackground, ButtonAlternateFace, HotTracking, GradientActiveCaption, GradientInactiveCaption, MenuHilight, MenuBar, FromColor1, FromColor2, FromColor3, FromColor4, FromColor5, BorderColor, FillColor, TextColor, EdgeLightColor, EdgeHighlightColor, EdgeShadowColor, EdgeDarkShadowColor, EdgeFillColor, TransparentColor, GradientColor1, GradientColor2, GradientColor3, GradientColor4, GradientColor5, ShadowColor, GlowColor, TextBorderColor, TextShadowColor, GlyphTextColor, GlyphTransparentColor, FillColorHint, BorderColorHint, AccentColorHint, TextColorHint, Heading1TextColor, Heading2TextColor, BodyTextColor, BlendColor
[Vanara.Windows.Forms.ControlState](https://github.com/dahall/Vanara/search?l=C%23&q=ControlState) | State flags for controls derived from `Vanara.Windows.Forms.CustomDrawBase`. | Hot, Pressed, Disabled, Animating, MouseDown, InButtonUp, Defaulted, Focused
[Vanara.Windows.Forms.VisualTheme.EnumProperty](https://github.com/dahall/Vanara/search?l=C%23&q=EnumProperty) | Properties accessible via <c>GetEnumValue</c>. | BackgroundType, BorderType, FillType, SizingType, HAlign, ContentAlignment, VAlign, OffsetType, IconEffect, TextShadowType, ImageLayout, GlyphType, ImageSelectType, GlyphFontSizingType, TrueSizeScalingType
[Vanara.Windows.Forms.ExplorerBrowserContentSectionOptions](https://github.com/dahall/Vanara/search?l=C%23&q=ExplorerBrowserContentSectionOptions) | Indicates the content options of the explorer browser. Typically use one, or a bitwise combination of these flags to specify how content should appear in the explorer browser control | None, AutoArrange, Desktop, SingleSelection, NoSubfolders, Transparent, NoScrollBars, AlignLeft, NoIcons, SingleClickActivate, NoWebView, HideFileNames, CheckSelect, NoEnumOnRefresh, NoGrouping, FullRowSelect, NoFilters, NoColumnHeader, NoHeaderInAllViews, ExtendedTiles, AutoCheckSelect, NoBrowserViewState, SubsetGroup, UseSearchFolder, AllowRtlReading
[Vanara.Windows.Forms.ExplorerBrowserLoadFlags](https://github.com/dahall/Vanara/search?l=C%23&q=ExplorerBrowserLoadFlags) | These flags are used with `Vanara.Windows.Forms.ExplorerBrowser.LoadCustomItems(System.Object,Vanara.Windows.Forms.ExplorerBrowserLoadFlags)`. | None, SelectFromDataObject, NoDropTarget
[Vanara.Windows.Forms.ExplorerBrowserNavigateOptions](https://github.com/dahall/Vanara/search?l=C%23&q=ExplorerBrowserNavigateOptions) | Specifies the options that control subsequent navigation. Typically use one, or a bitwise combination of these flags to specify how the explorer browser navigates. | None, NavigateOnce, ShowFrames, AlwaysNavigate, NoTravelLog, NoWrapperWindow, HtmlSharePointView, NoBorder, NoPersistViewState
[Vanara.Windows.Forms.ExplorerBrowserNavigationItemCategory](https://github.com/dahall/Vanara/search?l=C%23&q=ExplorerBrowserNavigationItemCategory) | Flags specifying the folder to be browsed. | Absolute, UseCurrentWindow, Default, SameWindow, NewWindow, NoFolderTree, ExploreMode, NoTransferHistory, Relative, ParentFolder, NavigateBack, NavigateForward, AllowAutoNavigate, KeepSearchText, ActivateNoFocus, CreateNoHistory, PlayNoSound, CallerUntrusted, TrustFirstDownload, UntrustedForDownload, NoHistorySelect, WriteNoHistory, TrustedForActiveX, FeedNavigation, Redirect
[Vanara.Windows.Forms.ExplorerBrowserViewMode](https://github.com/dahall/Vanara/search?l=C%23&q=ExplorerBrowserViewMode) | Indicates the viewing mode of the explorer browser | Icon, SmallIcon, List, Details, Thumbnail, Tile, ThumbStrip, Content, Auto
[Vanara.Windows.Forms.VisualTheme.FilenameProperty](https://github.com/dahall/Vanara/search?l=C%23&q=FilenameProperty) | Properties accessible via `Vanara.Windows.Forms.VisualTheme.GetFilename(System.Int32,System.Int32,Vanara.Windows.Forms.VisualTheme.FilenameProperty)`. | ImageFile, ImageFile1, ImageFile2, ImageFile3, ImageFile4, ImageFile5, GlyphImageFile
[Vanara.Windows.Forms.DesktopWindowManager.Flip3DWindowPolicy](https://github.com/dahall/Vanara/search?l=C%23&q=Flip3DWindowPolicy) | Flags used by the SetWindowAttr method to specify the Flip3D window policy. | Default, ExcludeBelow, ExcludeAbove
[Vanara.Windows.Forms.FolderBrowserDialogOptions](https://github.com/dahall/Vanara/search?l=C%23&q=FolderBrowserDialogOptions) |  | Folders, FoldersAndFiles, Computers, Printers
[Vanara.Windows.Forms.VisualTheme.FontProperty](https://github.com/dahall/Vanara/search?l=C%23&q=FontProperty) | Properties accessible via `Vanara.Windows.Forms.VisualTheme.GetFont(System.Drawing.IDeviceContext,System.Int32,System.Int32,Vanara.Windows.Forms.VisualTheme.FontProperty)`. | Caption, SmallCaption, Menu, Status, MessageBox, IconTitle, Heading1, Heading2, Body, Glyph
[Vanara.Extensions.IconSize](https://github.com/dahall/Vanara/search?l=C%23&q=IconSize) | Used to determine the size of the icon returned by various shell methods. | Large, Small, ExtraLarge, Jumbo
[Vanara.Windows.Forms.VisualTheme.IntProperty](https://github.com/dahall/Vanara/search?l=C%23&q=IntProperty) | Properties accessible via `Vanara.Windows.Forms.VisualTheme.GetInt(System.Int32,System.Int32,Vanara.Windows.Forms.VisualTheme.IntProperty)`. | CharSet, MinimumColorDepth, FromHue1, FromHue2, FromHue3, FromHue4, FromHue5, ToHue1, ToHue2, ToHue3, ToHue4, ToHue5, ToColor1, ToColor2, ToColor3, ToColor4, ToColor5, TextGlowSize, FramesPerSecond, PixelsPerFrame, AnimationDelay, GlowIntensity, Opacity, ColorizationColor, ColorizationOpacity, AnimationDuration
[Vanara.Windows.Forms.ItemHitLocation](https://github.com/dahall/Vanara/search?l=C%23&q=ItemHitLocation) | The location on the IShellItem that was clicked. | NoWhere, OnIcon, OnLabel, OnIndent, OnButton, OnRight, OnStateIcon, OnItem, OnTabButton
[Vanara.Windows.Forms.KnownFolder](https://github.com/dahall/Vanara/search?l=C%23&q=KnownFolder) | Standard folders registered with the system as Known Folders. A computer will have only folders appropriate to it installed. | AccountPictures, AddNewPrograms, AdminTools, ApplicationShortcuts, AppsFolder, AppUpdates, CameraRoll, CDBurning, ChangeRemovePrograms, CommonAdminTools, CommonOEMLinks, CommonPrograms, CommonStartMenu, CommonStartup, CommonTemplates, ComputerFolder, ConflictFolder, ConnectionsFolder, Contacts, ControlPanelFolder, Cookies, Desktop, DeviceMetadataStore, Documents, DocumentsLibrary, Downloads, Favorites, Fonts, Games, GameTasks, History, HomeGroup, HomeGroupCurrentUser, ImplicitAppShortcuts, InternetCache, InternetFolder, Libraries, Links, LocalAppData, LocalAppDataLow, LocalizedResourcesDir, Music, MusicLibrary, NetHood, NetworkFolder, OriginalImages, PhotoAlbums, PicturesLibrary, Pictures, Playlists, PrintersFolder, PrintHood, Profile, ProgramData, ProgramFiles, ProgramFilesX64, ProgramFilesX86, ProgramFilesCommon, ProgramFilesCommonX64, ProgramFilesCommonX86, Programs, Public, PublicDesktop, PublicDocuments, PublicDownloads, PublicGameTasks, PublicLibraries, PublicMusic, PublicPictures, PublicRingtones, PublicUserTiles, PublicVideos, QuickLaunch, Recent, RecordedTVLibrary, RecycleBinFolder, ResourceDir, Ringtones, RoamingAppData, RoamedTileImages, RoamingTiles, SampleMusic, SamplePictures, SamplePlaylists, SampleVideos, SavedGames, SavedPictures, SavedPicturesLibrary, SavedSearches, Screenshots, SEARCH_CSC, SearchHistory, SearchHome, SEARCH_MAPI, SearchTemplates, SendTo, SidebarDefaultParts, SidebarParts, SkyDrive, SkyDriveCameraRoll, SkyDriveDocuments, SkyDrivePictures, StartMenu, Startup, SyncManagerFolder, SyncResultsFolder, SyncSetupFolder, System, SystemX86, Templates, UserPinned, UserProfiles, UserProgramFiles, UserProgramFilesCommon, UsersFiles, UsersLibraries, Videos, VideosLibrary, Windows, Undefined
[Vanara.Windows.Forms.VisualTheme.MarginsProperty](https://github.com/dahall/Vanara/search?l=C%23&q=MarginsProperty) | Properties accessible via `Vanara.Windows.Forms.VisualTheme.GetMargins(System.Drawing.IDeviceContext,System.Int32,System.Int32,Vanara.Windows.Forms.VisualTheme.MarginsProperty)`. | Sizing, Content, Caption
[Vanara.Windows.Forms.VisualTheme.MetricProperty](https://github.com/dahall/Vanara/search?l=C%23&q=MetricProperty) | Properties accessible via `Vanara.Windows.Forms.VisualTheme.GetMetric(System.Drawing.IDeviceContext,System.Int32,System.Int32,Vanara.Windows.Forms.VisualTheme.MetricProperty)`. | ImageCount, AlphaLevel, BorderSize, RoundCornerWidth, RoundCornerHeight, GradientRatio1, GradientRatio2, GradientRatio3, GradientRatio4, GradientRatio5, ProgressChunkSize, ProgressSpaceSize, Saturation, TextBorderSize, AlphaThreshold, Width, Height, GlyphIndex, TrueSizeStretchMark, MinDpi1, MinDpi2, MinDpi3, MinDpi4, MinDpi5
[Vanara.Windows.Forms.DesktopWindowManager.NonClientRenderingPolicy](https://github.com/dahall/Vanara/search?l=C%23&q=NonClientRenderingPolicy) | Flags used by the SetWindowAttr method to specify the non-client area rendering policy. | UseWindowStyle, Disabled, Enabled
[Vanara.Windows.Forms.PaneVisibilityState](https://github.com/dahall/Vanara/search?l=C%23&q=PaneVisibilityState) | Indicates the visibility state of an ExplorerBrowser pane. | Default, Show, Hide
[Vanara.Windows.Forms.VisualTheme.PartSize](https://github.com/dahall/Vanara/search?l=C%23&q=PartSize) | Identifies the type of size value to retrieve for a visual style part. | Minimum, BestFit, Default
[Vanara.Windows.Forms.VisualTheme.PositionProperty](https://github.com/dahall/Vanara/search?l=C%23&q=PositionProperty) | Properties accessible via `Vanara.Windows.Forms.VisualTheme.GetPosition(System.Int32,System.Int32,Vanara.Windows.Forms.VisualTheme.PositionProperty)`. | Offset, TextShadowOffset, MinSize, MinSize1, MinSize2, MinSize3, MinSize4, MinSize5, NormalSize
[Vanara.Windows.Forms.ProgressBarState](https://github.com/dahall/Vanara/search?l=C%23&q=ProgressBarState) | Progress bar state. | Normal, Error, Paused
[Vanara.Windows.Forms.VisualTheme.PropertyOrigin](https://github.com/dahall/Vanara/search?l=C%23&q=PropertyOrigin) | Returned by <c>GetPropertyOrigin</c> to specify where a property was found. | State, Part, Class, Global, NotFound
[Vanara.Windows.Forms.VisualTheme.RectangleProperty](https://github.com/dahall/Vanara/search?l=C%23&q=RectangleProperty) | Properties accessible via `Vanara.Windows.Forms.VisualTheme.GetRect(System.Int32,System.Int32,Vanara.Windows.Forms.VisualTheme.RectangleProperty)`. | DefaultPane, CustomSplit, AnimationButton, Atlas
[Vanara.Windows.Forms.RenderStyle](https://github.com/dahall/Vanara/search?l=C%23&q=RenderStyle) | Style used to render the theme. | SystemTheme, Custom
[Vanara.Windows.Forms.SecurityPageType](https://github.com/dahall/Vanara/search?l=C%23&q=SecurityPageType) | Values that indicate the types of property pages in an access control editor property sheet. | BasicPermissions, AdvancedPermissions, Audit, Owner, EffectiveRights, TakeOwnership, Share
[Vanara.Windows.Forms.ShellNamespaceTreeControlAction](https://github.com/dahall/Vanara/search?l=C%23&q=ShellNamespaceTreeControlAction) | Actions on a `Vanara.Windows.Forms.ShellNamespaceTreeControl` exposed through `Vanara.Windows.Forms.ShellNamespaceTreeControlEventArgs`. | Unknown, ByKeyboard, ByMouse, AfterAdd, AfterDelete, BeforeDelete, Collapse, Expand
[Vanara.Windows.Forms.ShellProgressDialogStyle](https://github.com/dahall/Vanara/search?l=C%23&q=ShellProgressDialogStyle) | Display style for a `Vanara.Windows.Forms.ShellProgressDialog`. | Normal, Marquee, Hidden
[Vanara.Windows.Forms.ShellTreeItemButton](https://github.com/dahall/Vanara/search?l=C%23&q=ShellTreeItemButton) | Determines the image displayed to the right of an item in `Vanara.Windows.Forms.ShellNamespaceTreeControl`. | None, Arrow, Delete, Refresh
[Vanara.Windows.Forms.ShellTreeItemCheckBoxStyle](https://github.com/dahall/Vanara/search?l=C%23&q=ShellTreeItemCheckBoxStyle) | The style of check box to display. | None, Normal, Partial, Exclusion, Dimmed
[Vanara.Windows.Forms.ShellTreeItemState](https://github.com/dahall/Vanara/search?l=C%23&q=ShellTreeItemState) | Specifies the state of a tree item. | None, Selected, Expanded, Bold, Disabled, SelectedNotExpanded
[Vanara.Windows.Forms.CustomComboBox.SizeMode](https://github.com/dahall/Vanara/search?l=C%23&q=SizeMode) | Sizing mode for the CustomComboBox drop-down area. | UseComboSize, UseControlSize, UseDropDownSize
[Vanara.Windows.Forms.VisualTheme.StringProperty](https://github.com/dahall/Vanara/search?l=C%23&q=StringProperty) | Properties accessible via `Vanara.Windows.Forms.VisualTheme.GetString(System.Int32,System.Int32,Vanara.Windows.Forms.VisualTheme.StringProperty)`. | ColorSchemes, Sizes, Name, DisplayName, Tooltip, Company, Author, Copyright, Url, Version, Description, CssName, XmlName, LastUpdated, Alias, Text, ClassicValue, AtlasInputImage
[Vanara.Windows.Forms.TaskDialogButtonDisplay](https://github.com/dahall/Vanara/search?l=C%23&q=TaskDialogButtonDisplay) | Indicates how buttons are displayed on a `Vanara.Windows.Forms.TaskDialog`. | StandardButton, CommandLink, CommandLinkNoIcon
[Vanara.Windows.Forms.TaskDialogCommonButtons](https://github.com/dahall/Vanara/search?l=C%23&q=TaskDialogCommonButtons) | The TaskDialog common button flags used to specify the built in buttons to show in the TaskDialog. | None, Ok, Yes, No, Cancel, Retry, Close
[Vanara.Windows.Forms.TaskDialogIcon](https://github.com/dahall/Vanara/search?l=C%23&q=TaskDialogIcon) | The System icons the TaskDialog supports. | None, ShieldGray, SecuritySuccess, SecurityError, SecurityWarning, ShieldBlue, Shield, Information, Error, Warning
### Structures
Struct | Description
---- | ----
[Vanara.Windows.Forms.TaskDialog.TaskDialogResult](https://github.com/dahall/Vanara/search?l=C%23&q=TaskDialogResult) | Results from running the `Vanara.Windows.Forms.TaskDialog`.
### Interfaces
Interface | Description
---- | ----
[Vanara.Security.AccessControl.IAccessControlEditorDialogProvider](https://github.com/dahall/Vanara/search?l=C%23&q=IAccessControlEditorDialogProvider) | An interface for defining an information provider for object types supplied to the `Vanara.Windows.Forms.AccessControlEditorDialog`.
[Vanara.Windows.Forms.Design.IActionGetItem](https://github.com/dahall/Vanara/search?l=C%23&q=IActionGetItem) | Interface for an action that has items and a category.
[Vanara.Windows.Forms.IDrawingStyle&lt;T&gt;](https://github.com/dahall/Vanara/search?l=C%23&q=IDrawingStyle%26lt%3BT%26gt%3B) | An interface for controls that provide drawing styles.
[Vanara.Windows.Forms.IEnableable](https://github.com/dahall/Vanara/search?l=C%23&q=IEnableable) | Interface that exposes an <c>Enabled</c> property for an item supplied to `Vanara.Windows.Forms.DisabledItemComboBox`.
### Classes
Class | Description
---- | ----
[Vanara.Windows.Forms.AccessControlEditorDialog](https://github.com/dahall/Vanara/search?l=C%23&q=AccessControlEditorDialog) | Displays a property sheet that contains a basic security property page. This property page enables the user to view and edit the access rights allowed or denied by the ACEs in an object's DACL.
[Vanara.Windows.Forms.ActivationContext](https://github.com/dahall/Vanara/search?l=C%23&q=ActivationContext) | Provides an activation context for a manifest file or PE image. On disposal, the context is deactivated.
[Vanara.Windows.Forms.Design.AttributedComponentDesigner&lt;T&gt;](https://github.com/dahall/Vanara/search?l=C%23&q=AttributedComponentDesigner%26lt%3BT%26gt%3B) | A designer for components that support attributes.
[Vanara.Windows.Forms.Design.AttributedComponentDesignerEx&lt;T&gt;](https://github.com/dahall/Vanara/search?l=C%23&q=AttributedComponentDesignerEx%26lt%3BT%26gt%3B) | An extended designer for components that support attributes.
[Vanara.Windows.Forms.Design.AttributedControlDesigner&lt;T&gt;](https://github.com/dahall/Vanara/search?l=C%23&q=AttributedControlDesigner%26lt%3BT%26gt%3B) | A designer for controls that support attributes.
[Vanara.Windows.Forms.Design.AttributedControlDesignerEx&lt;T&gt;](https://github.com/dahall/Vanara/search?l=C%23&q=AttributedControlDesignerEx%26lt%3BT%26gt%3B) | An extended designer for controls that support attributes.
[Vanara.Windows.Forms.Design.AttributedDesignerActionList](https://github.com/dahall/Vanara/search?l=C%23&q=AttributedDesignerActionList) | A designer action list pulled from attributes.
[Vanara.Windows.Forms.Design.AttributedParentControlDesigner&lt;T&gt;](https://github.com/dahall/Vanara/search?l=C%23&q=AttributedParentControlDesigner%26lt%3BT%26gt%3B) | A designer for parent controls supported by attributes.
[Vanara.Windows.Forms.Design.AttributedParentControlDesignerEx&lt;T&gt;](https://github.com/dahall/Vanara/search?l=C%23&q=AttributedParentControlDesignerEx%26lt%3BT%26gt%3B) | An extended designer for parent controls supported by attributes.
[Vanara.Security.AuthenticationBuffer](https://github.com/dahall/Vanara/search?l=C%23&q=AuthenticationBuffer) | Safe container for an authentication buffer. Allows for creation using native <c>CredPackAuthenticationBuffer</c> method or assignment from an existing <c>IntPtr</c>. Can unpack to `System.String` or `System.Security.SecureString` values.
[Vanara.Drawing.BufferedAnimationPainter](https://github.com/dahall/Vanara/search?l=C%23&q=BufferedAnimationPainter) | Use to paint a buffered animation.
[Vanara.Drawing.BufferedPaint](https://github.com/dahall/Vanara/search?l=C%23&q=BufferedPaint) | Buffered painting helper class.
[Vanara.Drawing.BufferedPainter](https://github.com/dahall/Vanara/search?l=C%23&q=BufferedPainter) | Use to perform buffered painting.
[Vanara.Windows.Forms.TaskDialog.ButtonClickedEventArgs](https://github.com/dahall/Vanara/search?l=C%23&q=ButtonClickedEventArgs) | Provides data for the `Vanara.Windows.Forms.TaskDialog.ButtonClicked` and the `Vanara.Windows.Forms.TaskDialog.RadioButtonClicked` events.
[Vanara.Extensions.ButtonExtension](https://github.com/dahall/Vanara/search?l=C%23&q=ButtonExtension) | Extension methods for `System.Windows.Forms.ButtonBase`.
[Vanara.Windows.Forms.CollapsiblePanel](https://github.com/dahall/Vanara/search?l=C%23&q=CollapsiblePanel) | Control providing a panel that can be collapsed.
[Vanara.Extensions.ComboBoxExtension](https://github.com/dahall/Vanara/search?l=C%23&q=ComboBoxExtension) | Extension methods for `System.Windows.Forms.ComboBox`.
[Vanara.Windows.Forms.CommandLink](https://github.com/dahall/Vanara/search?l=C%23&q=CommandLink) | Represents a Windows Command Link control.
[Vanara.Windows.Forms.Design.ComponentDesignerExtension](https://github.com/dahall/Vanara/search?l=C%23&q=ComponentDesignerExtension) | Methods to assist when using designer code.
[Vanara.Extensions.ControlExtension](https://github.com/dahall/Vanara/search?l=C%23&q=ControlExtension) | Control extension methods.
[Vanara.Windows.Forms.ControlImage](https://github.com/dahall/Vanara/search?l=C%23&q=ControlImage) | Represents an image used within a control.
[Vanara.Windows.Forms.CredentialsDialog](https://github.com/dahall/Vanara/search?l=C%23&q=CredentialsDialog) | Dialog box which prompts for user credentials using the Win32 CREDUI methods.
[Vanara.Extensions.CursorExtension](https://github.com/dahall/Vanara/search?l=C%23&q=CursorExtension) | Extension methods for `System.Windows.Forms.Cursor`.
[Vanara.Windows.Forms.CustomButton](https://github.com/dahall/Vanara/search?l=C%23&q=CustomButton) | A custom drawn button.
[Vanara.Windows.Forms.CustomComboBox](https://github.com/dahall/Vanara/search?l=C%23&q=CustomComboBox) | <c>CustomComboBox</c> is an extension of `System.Windows.Forms.ComboBox` which provides drop-down customization.
[Vanara.Windows.Forms.CustomDrawBase](https://github.com/dahall/Vanara/search?l=C%23&q=CustomDrawBase) | Abstract class for implementing a custom-drawn control that tracks mouse movement and has text and/or an image. It exposes all property changes.
[Vanara.Windows.Forms.Design.DesignerActionMethodAttribute](https://github.com/dahall/Vanara/search?l=C%23&q=DesignerActionMethodAttribute) | Attribute placed on methods that indicate they support a designer action.
[Vanara.Windows.Forms.Design.DesignerActionPropertyAttribute](https://github.com/dahall/Vanara/search?l=C%23&q=DesignerActionPropertyAttribute) | Attribute placed on properties that indicate they support a designer action.
[Vanara.Windows.Forms.Design.DesignerVerbAttribute](https://github.com/dahall/Vanara/search?l=C%23&q=DesignerVerbAttribute) | Attribute placed on methods that indicate they support a designer attribute.
[Vanara.Windows.Forms.DesktopWindowManager](https://github.com/dahall/Vanara/search?l=C%23&q=DesktopWindowManager) | Main DWM class, provides glass sheet effect and blur behind.
[Vanara.Windows.Forms.DisabledItemComboBox](https://github.com/dahall/Vanara/search?l=C%23&q=DisabledItemComboBox) | A version of `System.Windows.Forms.ComboBox` that allows for disabled items.
[Vanara.Windows.Forms.CustomButton.DrawPattern](https://github.com/dahall/Vanara/search?l=C%23&q=DrawPattern) | A pattern to use for drawing the button.
[Vanara.Windows.Forms.Design.EditorServiceContext](https://github.com/dahall/Vanara/search?l=C%23&q=EditorServiceContext) | A service context implementation for an editor.
[Vanara.Windows.Forms.EnumComboBox](https://github.com/dahall/Vanara/search?l=C%23&q=EnumComboBox) | A combo box that displays the items of an `System.Enum` type. If the Enum type has a `System.FlagsAttribute`, then the drop-down will be checked list of the values.
[Vanara.Windows.Forms.TaskDialog.ExpandedEventArgs](https://github.com/dahall/Vanara/search?l=C%23&q=ExpandedEventArgs) | Provides data for the `Vanara.Windows.Forms.TaskDialog.ExpandedEventArgs.Expanded` event.
[Vanara.Windows.Forms.ExplorerBrowser](https://github.com/dahall/Vanara/search?l=C%23&q=ExplorerBrowser) | <c>ExplorerBrowser</c> is a browser object that can be either navigated or that can host a view of a data object. As a full-featured browser object, it also supports an automatic travel log.
[Vanara.Windows.Forms.ExplorerBrowser.ExplorerBrowserPaneVisibility](https://github.com/dahall/Vanara/search?l=C%23&q=ExplorerBrowserPaneVisibility) | Controls the visibility of the various ExplorerBrowser panes on subsequent navigation
[Vanara.Windows.Forms.Design.FlagEnumUIEditor&lt;T&gt;.FlagCheckedListBox](https://github.com/dahall/Vanara/search?l=C%23&q=FlagCheckedListBox) | A checked list box to use as the editor.
[Vanara.Windows.Forms.Design.FlagEnumUIEditor&lt;T&gt;.FlagCheckedListBox.FlagCheckedListBoxItem](https://github.com/dahall/Vanara/search?l=C%23&q=FlagCheckedListBoxItem) | Represents an item in the CheckListBox
[Vanara.Windows.Forms.Design.FlagEnumUIEditor&lt;T&gt;](https://github.com/dahall/Vanara/search?l=C%23&q=FlagEnumUIEditor%26lt%3BT%26gt%3B) | A `System.Drawing.Design.UITypeEditor` for editing flag enums.
[Vanara.Windows.Forms.FolderBrowserDialog](https://github.com/dahall/Vanara/search?l=C%23&q=FolderBrowserDialog) | Class to let the user browse for a folder.
[Vanara.Windows.Forms.FolderBrowserDialogInitializedEventArgs](https://github.com/dahall/Vanara/search?l=C%23&q=FolderBrowserDialogInitializedEventArgs) | Event arguments for when the `Vanara.Windows.Forms.FolderBrowserDialog` has been initialized.
[Vanara.Security.AccessControl.GenericProvider](https://github.com/dahall/Vanara/search?l=C%23&q=GenericProvider) | Base implementation of `Vanara.Security.AccessControl.IAccessControlEditorDialogProvider`.
[Vanara.Drawing.BufferedPaint.GetDuration&lt;T&gt;](https://github.com/dahall/Vanara/search?l=C%23&q=GetDuration%26lt%3BT%26gt%3B) | A method delegate that retrieves a duration, in milliseconds, to use as the time over which buffered painting occurs.
[Vanara.Windows.Forms.GlassExtenderProvider](https://github.com/dahall/Vanara/search?l=C%23&q=GlassExtenderProvider) | GlassExtenderProvider extends a `System.Windows.Forms.Form` and provides glass margins.
[Vanara.Extensions.GraphicsExtension](https://github.com/dahall/Vanara/search?l=C%23&q=GraphicsExtension) | Extensions to <c>Graphics</c> related classes.
[Vanara.Resources.ResourceFile.GroupIconResIndexer](https://github.com/dahall/Vanara/search?l=C%23&q=GroupIconResIndexer) | An indexer for group icons.
[Vanara.Extensions.IconExtension](https://github.com/dahall/Vanara/search?l=C%23&q=IconExtension) | Extension methods for `System.Drawing.Icon`.
[Vanara.Extensions.ImageListExtension](https://github.com/dahall/Vanara/search?l=C%23&q=ImageListExtension) | Extension methods for `System.Windows.Forms.ImageList`.
[Vanara.Resources.ResourceFile.ImageResIndexer&lt;T&gt;](https://github.com/dahall/Vanara/search?l=C%23&q=ImageResIndexer%26lt%3BT%26gt%3B) | An indexer for images.
[Vanara.Windows.Forms.InputDialog](https://github.com/dahall/Vanara/search?l=C%23&q=InputDialog) | An input dialog that automatically creates controls to collect the values of the object supplied via the `Vanara.Windows.Forms.InputDialog.Data` property.
[Vanara.Windows.Forms.InputDialogItemAttribute](https://github.com/dahall/Vanara/search?l=C%23&q=InputDialogItemAttribute) | Allows a developer to attribute a property or field with text that gets shown instead of the field or property name in an `Vanara.Windows.Forms.InputDialog`.
[Vanara.Windows.Forms.InvalidFolderEventArgs](https://github.com/dahall/Vanara/search?l=C%23&q=InvalidFolderEventArgs) | Event arguments for when an invalid folder is selected.
[Vanara.Windows.Forms.IPAddressBox](https://github.com/dahall/Vanara/search?l=C%23&q=IPAddressBox) | An Internet Protocol (IP) address control allows the user to enter an IP address in an easily understood format.
[Vanara.Windows.Forms.IPAddressFieldChangedEventArgs](https://github.com/dahall/Vanara/search?l=C%23&q=IPAddressFieldChangedEventArgs) | Contains the arguments needed to handle the `Vanara.Windows.Forms.IPAddressBox.FieldChanged` event.
[Vanara.Extensions.LabelExtension](https://github.com/dahall/Vanara/search?l=C%23&q=LabelExtension) | Extension methods for `System.Windows.Forms.Label`.
[Vanara.Extensions.ListViewExtension](https://github.com/dahall/Vanara/search?l=C%23&q=ListViewExtension) | Extension methods for `System.Windows.Forms.ListView`.
[Vanara.Extensions.ListViewGroupingSet&lt;T&gt;](https://github.com/dahall/Vanara/search?l=C%23&q=ListViewGroupingSet%26lt%3BT%26gt%3B) | Takes a list of groups and matching predicates to be used by the ApplyGroupingSet extension method.
[Vanara.Windows.Forms.LiveThumbnail](https://github.com/dahall/Vanara/search?l=C%23&q=LiveThumbnail) | Extracts all or a portion of a window and renders it as a thumbnail on another portion of the desktop.
[Vanara.Extensions.MapPointExtension](https://github.com/dahall/Vanara/search?l=C%23&q=MapPointExtension) | Extension methods for windows to process points in the coordinate space.
[Vanara.Windows.Forms.MenuStripMRUManager](https://github.com/dahall/Vanara/search?l=C%23&q=MenuStripMRUManager) | A class that manages a Most Recently Used file listing and interacts with a MenuStrip to display a menu list of the files. By default, the application settings are used to store the history. Optionally a constructor can be used to provide an alternate class to handle that work.
[Vanara.Windows.Forms.ExplorerBrowser.NavigatedEventArgs](https://github.com/dahall/Vanara/search?l=C%23&q=NavigatedEventArgs) | Event argument for The Navigated event
[Vanara.Windows.Forms.ExplorerBrowser.NavigatingEventArgs](https://github.com/dahall/Vanara/search?l=C%23&q=NavigatingEventArgs) | Event argument for The Navigating event
[Vanara.Windows.Forms.ExplorerBrowser.NavigationFailedEventArgs](https://github.com/dahall/Vanara/search?l=C%23&q=NavigationFailedEventArgs) | Event argument for the NavigatinoFailed event
[Vanara.Windows.Forms.ExplorerBrowser.NavigationLog](https://github.com/dahall/Vanara/search?l=C%23&q=NavigationLog) | The navigation log is a history of the locations visited by the explorer browser.
[Vanara.Windows.Forms.ExplorerBrowser.NavigationLogEventArgs](https://github.com/dahall/Vanara/search?l=C%23&q=NavigationLogEventArgs) | The event argument for NavigationLogChangedEvent
[Vanara.Windows.Forms.NetworkConnectionDialog](https://github.com/dahall/Vanara/search?l=C%23&q=NetworkConnectionDialog) | A dialog box that allows the user to browse and connect to network resources.
[Vanara.Windows.Forms.NetworkDisconnectDialog](https://github.com/dahall/Vanara/search?l=C%23&q=NetworkDisconnectDialog) | A dialog box that allows the user to browse and connect to network resources.
[Vanara.Extensions.NotifyIconExtensions](https://github.com/dahall/Vanara/search?l=C%23&q=NotifyIconExtensions) | Extension methods for `System.Windows.Forms.NotifyIcon`.
[Vanara.Drawing.BufferedPaint.PaintAction&lt;T&gt;](https://github.com/dahall/Vanara/search?l=C%23&q=PaintAction%26lt%3BT%26gt%3B) | A method delegate to paint a stateful image.
[Vanara.Windows.Forms.CredentialsDialog.PasswordValidatorEventArgs](https://github.com/dahall/Vanara/search?l=C%23&q=PasswordValidatorEventArgs) | Used by the `Vanara.Windows.Forms.CredentialsDialog.ValidatePassword` event.
[Vanara.Windows.Forms.Forms.PreventShutdownContext](https://github.com/dahall/Vanara/search?l=C%23&q=PreventShutdownContext) | Used to define a set of operations within which any shutdown request will be met with a reason why this application is blocking it.
[Vanara.Windows.Forms.ProgressDialog](https://github.com/dahall/Vanara/search?l=C%23&q=ProgressDialog) | Multi-level, auto-sizing, progress dialog supporting asyncronous tasks. The background activities are provided as asyncronous methods who have a `System.Threading.CancellationToken` and an `System.IProgress` instance passed as parameters. The method uses the `System.Threading.CancellationToken` instance to determine if the user has pressed the "Cancel" button and the `System.IProgress.Report()` method to report progress.
[Vanara.Windows.Forms.ProgressEventArgs](https://github.com/dahall/Vanara/search?l=C%23&q=ProgressEventArgs) | Updates progress on a `Vanara.Windows.Forms.ProgressDialog`.
[Vanara.Windows.Forms.Design.RedirectedDesignerItemAttribute](https://github.com/dahall/Vanara/search?l=C%23&q=RedirectedDesignerItemAttribute) | Attribute placed on class items that indicate they support a designer redirected item.
[Vanara.Resources.ResourceFile](https://github.com/dahall/Vanara/search?l=C%23&q=ResourceFile) | Represents a file that contains resources.
[Vanara.Windows.Forms.Design.ServiceProviderExtension](https://github.com/dahall/Vanara/search?l=C%23&q=ServiceProviderExtension) | Extension methods for IServiceProvider.
[Vanara.Windows.Forms.ShellNamespaceTreeControl](https://github.com/dahall/Vanara/search?l=C%23&q=ShellNamespaceTreeControl) | A control used to view and manipulate nodes in a tree of Shell items.
[Vanara.Windows.Forms.ShellNamespaceTreeControlCancelEventArgs](https://github.com/dahall/Vanara/search?l=C%23&q=ShellNamespaceTreeControlCancelEventArgs) | Provides data for the BeforeExpand, and BeforeSelect events of a `Vanara.Windows.Forms.ShellNamespaceTreeControl` control.
[Vanara.Windows.Forms.ShellNamespaceTreeControlEventArgs](https://github.com/dahall/Vanara/search?l=C%23&q=ShellNamespaceTreeControlEventArgs) | Event arguments for actions against `Vanara.Windows.Forms.ShellNamespaceTreeControl`.
[Vanara.Windows.Forms.ShellNamespaceTreeControlItemLabelEditEventArgs](https://github.com/dahall/Vanara/search?l=C%23&q=ShellNamespaceTreeControlItemLabelEditEventArgs) | Arguments for item label edit events in a `Vanara.Windows.Forms.ShellNamespaceTreeControl`.
[Vanara.Windows.Forms.ShellNamespaceTreeControlItemMouseClickEventArgs](https://github.com/dahall/Vanara/search?l=C%23&q=ShellNamespaceTreeControlItemMouseClickEventArgs) | Arguments for mouse click events in a `Vanara.Windows.Forms.ShellNamespaceTreeControl`.
[Vanara.Windows.Forms.ShellNamespaceTreeRootList](https://github.com/dahall/Vanara/search?l=C%23&q=ShellNamespaceTreeRootList) | Encapsulates the list of root items in a `Vanara.Windows.Forms.ShellNamespaceTreeControl`.
[Vanara.Windows.Forms.ShellProgressDialog](https://github.com/dahall/Vanara/search?l=C%23&q=ShellProgressDialog) | Wrapper for IProgressDialog which displays a system progress dialog. This object is a generic way to show a user how an operation is progressing. It is typically used when deleting, uploading, copying, moving, or downloading large numbers of files. The dialog is shown on a separate thread and will not block operations in the current thread.
[Vanara.Windows.Forms.SplitButton](https://github.com/dahall/Vanara/search?l=C%23&q=SplitButton) | The SplitButton is a composite control with which the user can select from a drop-down list bound to the button.
[Vanara.Windows.Forms.SplitButton.SplitMenuEventArgs](https://github.com/dahall/Vanara/search?l=C%23&q=SplitMenuEventArgs) | Provides data for the clicking of split buttons and the opening of context menus.
[Vanara.Resources.ResourceFile.StringResIndexer](https://github.com/dahall/Vanara/search?l=C%23&q=StringResIndexer) | An indexer for strings.
[Vanara.Windows.Forms.CollapsiblePanel.Style](https://github.com/dahall/Vanara/search?l=C%23&q=Style) | The panel's style.
[Vanara.Windows.Forms.TaskDialog](https://github.com/dahall/Vanara/search?l=C%23&q=TaskDialog) | A Task Dialog. This is like a MessageBox but with many more features. For Windows version prior to Vista, an emulated version of the system dialog is displayed.
[Vanara.Windows.Forms.TaskDialogButton](https://github.com/dahall/Vanara/search?l=C%23&q=TaskDialogButton) | Represents a button on a task dialog.
[Vanara.Windows.Forms.TaskDialog.TaskDialogButtonBase](https://github.com/dahall/Vanara/search?l=C%23&q=TaskDialogButtonBase) | A custom button for the TaskDialog.
[Vanara.Windows.Forms.TaskDialog.TaskDialogButtonCollection&lt;T&gt;](https://github.com/dahall/Vanara/search?l=C%23&q=TaskDialogButtonCollection%26lt%3BT%26gt%3B) | A collection of `Vanara.Windows.Forms.TaskDialogButton` elements.
[Vanara.Windows.Forms.TaskDialog.TaskDialogProgressBar](https://github.com/dahall/Vanara/search?l=C%23&q=TaskDialogProgressBar) | Represents the progress bar that can be displayed in a task dialog.
[Vanara.Windows.Forms.TaskDialogRadioButton](https://github.com/dahall/Vanara/search?l=C%23&q=TaskDialogRadioButton) | Represents a radio button on a task dialog.
[Vanara.Extensions.TextBoxExtension](https://github.com/dahall/Vanara/search?l=C%23&q=TextBoxExtension) | Extension methods for `System.Windows.Forms.TextBox`.
[Vanara.Windows.Forms.ThemedImageDraw](https://github.com/dahall/Vanara/search?l=C%23&q=ThemedImageDraw) | A button that displays an image and no text.
[Vanara.Windows.Forms.ThemedLabel](https://github.com/dahall/Vanara/search?l=C%23&q=ThemedLabel) | A Label containing some text that will be drawn with glowing border on top of the Glass Sheet effect.
[Vanara.Windows.Forms.ThemedPanel](https://github.com/dahall/Vanara/search?l=C%23&q=ThemedPanel) | A panel that supports a glass overlay and is drawn using a visual style.
[Vanara.Windows.Forms.ThemedTableLayoutPanel](https://github.com/dahall/Vanara/search?l=C%23&q=ThemedTableLayoutPanel) | A table layout panel that supports a glass overlay.
[Vanara.Windows.Forms.TaskDialog.TimerEventArgs](https://github.com/dahall/Vanara/search?l=C%23&q=TimerEventArgs) | Provides data for the `Vanara.Windows.Forms.TaskDialog.Timer` event.
[Vanara.Windows.Forms.TrackBarEx](https://github.com/dahall/Vanara/search?l=C%23&q=TrackBarEx) | Extends the `System.Windows.Forms.TrackBar` class to provide full native-control functionality, including tick marks and value, and custom drawing.
[Vanara.Extensions.TreeViewExtension](https://github.com/dahall/Vanara/search?l=C%23&q=TreeViewExtension) | Extension methods for `System.Windows.Forms.TreeView` controls.
[Vanara.Windows.Forms.Design.TypedBehavior&lt;T&gt;](https://github.com/dahall/Vanara/search?l=C%23&q=TypedBehavior%26lt%3BT%26gt%3B) | A behavior derivative for a supplied type.
[Vanara.Windows.Forms.Design.TypedDesignerActionList&lt;T&gt;](https://github.com/dahall/Vanara/search?l=C%23&q=TypedDesignerActionList%26lt%3BT%26gt%3B) | An action list for a generic designer.
[Vanara.Windows.Forms.Design.TypedGlyph&lt;T&gt;](https://github.com/dahall/Vanara/search?l=C%23&q=TypedGlyph%26lt%3BT%26gt%3B) | A glyph associated with a designer.
[Vanara.Windows.Forms.TaskDialog.VerificationClickedEventArgs](https://github.com/dahall/Vanara/search?l=C%23&q=VerificationClickedEventArgs) | Provides data for the `Vanara.Windows.Forms.TaskDialog.VerificationClicked` event.
[Vanara.Windows.Forms.VistaButtonBase](https://github.com/dahall/Vanara/search?l=C%23&q=VistaButtonBase) | Implements a CommandLink button that can be used in WinForms user interfaces.
[Vanara.Windows.Forms.VistaControlExtender](https://github.com/dahall/Vanara/search?l=C%23&q=VistaControlExtender) | Extends standard WinForms controls with post-Vista capabilities.
[Vanara.Extensions.VisualStylesRendererExtension](https://github.com/dahall/Vanara/search?l=C%23&q=VisualStylesRendererExtension) | Extension methods for `System.Windows.Forms.VisualStyles.VisualStyleRenderer` for glass effects and extended method functionality. Also provides GetFont2 and GetMargins2 methods that corrects base library's non-functioning methods.
[Vanara.Windows.Forms.VisualTheme](https://github.com/dahall/Vanara/search?l=C%23&q=VisualTheme) | A wrapper around the UxTheme methods.
