![Vanara](/docs/icons/VanaraHeading.png)

[![Version](https://img.shields.io/github/release/dahall/Vanara.svg?style=flat-square)](https://github.com/dahall/Vanara/releases) [![Downloads](https://img.shields.io/nuget/dt/Vanara.Core.svg?style=flat-square)](https://www.nuget.org/packages/Vanara.Core/) [![Build status](https://ci.appveyor.com/api/projects/status/p6jj1j3sbt95opdr?svg=true)](https://ci.appveyor.com/project/dahall/vanara)

This project contains various .NET assemblies that contain P/Invoke functions, interfaces, enums and structures from Windows libraries. Each assembly is associated with one or a few tightly related libraries. For example, Shlwapi.dll has all the exported functions from shlwapi.lib; Kernel32.dll has all for both kernel32.lib and kernelbase.lib.

All assemblies are available via NuGet and provide builds against .NET 4.5, 4.8, 5.0, 6.0, 7.0, 8.0, .NET Standard 2.0, Core 3.1 and support [SourceLink](https://docs.microsoft.com/en-us/dotnet/standard/library-guidance/sourcelink). Extensions are available for WinForms, WPF, and UWP projects. If you need support for other .NET versions, look to versions 3.3.15 and earlier.

This project releases new versions every few weeks after sufficient testing. New releases are cataloged, along with release notes, in the [Releases](https://github.com/dahall/Vanara/releases) section and all NuGet packages are published to [nuget.org](https://www.nuget.org/packages?q=dahall+Vanara). Each GitHub push triggers an [AppVeyor](https://ci.appveyor.com/project/dahall/vanara) build. The owners thank them for the free Open-Source account! The status of that build is in the header of this page. The NuGet packages from those builds are available for test purposes on AppVeyor's project NuGet source at https://ci.appveyor.com/nuget/vanara-prerelease.

## Use
1. Look for the function you need in Microsoft documentation. Note which library or DLL the function is in.
2. Confirm the Vanara library exists and has your function by looking at the Supported Libraries table below. Clicking on the Assembly link will take you to a drill down of that assembly's coverage. Find your function and if there is a matching implementation it will appear to the right. You can also use GitHub's project search (upper left of page) to search for your function, method or constant. Make sure to select "In this repository".
3. Add the assembly to your project via NuGet.
4. To use the function, you can:
   1. Call it directly `var bret = Vanara.PInvoke.Kernel32.GetComputerName(sb, ref sbSz);`
   2. Under C# 6.0 and later, use a static using directive and call it:
   ```
   using static Vanara.PInvoke.Kernel32;
   
   var bret = GetComputerName(sb, ref sbSz);
   ```
5. In some cases there is a corresponding helper/wrapper class in one of the [Supporting Assemblies](#Supporting-Assemblies), especially for Security, System Services, Forms and Shell. Go to their library page (click on link in section) and look through the classes included in each library.

## Design Concepts

* All functions that are imported from a single DLL should be placed into a single assembly that is named after the DLL.
  * (e.g. The assembly `Vanara.PInvoke.Gdi32.dll` hosts all functions and supporting enumerations, constants and structures that are exported from `gdi32.dll` in the system directory.)
* Any structure or macro or enumeration (no function) that is used by many libraries is put into either `Vanara.Core` or `Vanara.PInvoke.Shared`.
  * (e.g. The macro `HIWORD` and the structure `SIZE` are both in `Vanara.PInvoke.Shared` and classes to simplify interop calls and native memory management are in `Vanara.Core`.)
* Inside a project, all constructs are contained in a file named after the header file (*.h) in which they are defined in the Windows API.
  * (e.g. In the `Vanara.PInvoke.Kernel32` project directory, you'll find a FileApi.cs, a WinBase.cs and a WinNT.cs file representing fileapi.h, winbase.h and winnt.h respectively.)
* Where the direct interpretation of a structure or function leads to memory leaks or misuse, I have tried to simplify its use.
* Where a structure is always passed by reference and where that structure needs to clean up memory allocations, I have changed the structure to a class implementing `IDisposable`.
* Wherever possible, all handles have been turned into `SafeHandle` derivatives named after the Windows API handle. If those handles require a call to a function to release/close/destroy, a derived `SafeHANDLE` exists that performs that function on disposal.
  * e.g. `HTOKEN` is defined. `SafeHTOKEN` builds upon that handle with an automated release calling `CloseHandle`.
* Wherever possible, all functions that allocate memory that is to be freed by the caller use a safe memory handle.
* All PInvoke calls are in assemblies prefixed by `Vanara.PInvoke`.
* If a structure is to passed into a function as a constant, that structure is marshaled using the `in` statement which will pass the structure by reference without requiring the `ref` keyword.
  * Windows API: `BOOL MapDialogRect(HWND hDlg, LPRECT lpRect)`
  * Vanara: `bool MapDialogRect(HWND hDlg, in RECT lpRect);`
* If there are classes or extensions that make use of the PInvoke calls, they are in wrapper assemblies prefixed by `Vanara` and then followed by a logical name for the functionality. Today, those are Core, Security, SystemServices, Windows.Forms and Windows.Shell.

## Supported Libraries

Library/DLL | Assembly | Coverage | NuGet&nbsp;Link&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
--- | --- | --- | ---
aclui.dll | [Vanara.PInvoke.AclUI](https://github.com/dahall/Vanara/blob/master/PInvoke/AclUI/readme.md) | ![Coverage](https://img.shields.io/badge/100%25-green.svg?style=flat-square) | [![Nuget](https://img.shields.io/nuget/v/Vanara.PInvoke.AclUI?label=%20&logo=nuget&style=flat-square)![Nuget](https://img.shields.io/nuget/dt/Vanara.PInvoke.AclUI?label=%20&style=flat-square)](https://www.nuget.org/packages/Vanara.PInvoke.AclUI)
activeds.dll | [Vanara.PInvoke.ActiveDS](https://github.com/dahall/Vanara/blob/master/PInvoke/ActiveDS/readme.md) | ![Coverage](https://img.shields.io/badge/100%25-green.svg?style=flat-square) | [![Nuget](https://img.shields.io/nuget/v/Vanara.PInvoke.ActiveDS?label=%20&logo=nuget&style=flat-square)![Nuget](https://img.shields.io/nuget/dt/Vanara.PInvoke.ActiveDS?label=%20&style=flat-square)](https://www.nuget.org/packages/Vanara.PInvoke.ActiveDS)
advapi32.dll, secur32.dll, authz.dll, sspicli.dll, schannel.dll, tdh.dll | [Vanara.PInvoke.Security](https://github.com/dahall/Vanara/blob/master/PInvoke/Security/readme.md) | ![Coverage](https://img.shields.io/badge/100%25-green.svg?style=flat-square) | [![Nuget](https://img.shields.io/nuget/v/Vanara.PInvoke.Security?label=%20&logo=nuget&style=flat-square)![Nuget](https://img.shields.io/nuget/dt/Vanara.PInvoke.Security?label=%20&style=flat-square)](https://www.nuget.org/packages/Vanara.PInvoke.Security)
amsi.dll | [Vanara.PInvoke.AMSI](https://github.com/dahall/Vanara/blob/master/PInvoke/AMSI/readme.md) | ![Coverage](https://img.shields.io/badge/100%25-green.svg?style=flat-square) | [![Nuget](https://img.shields.io/nuget/v/Vanara.PInvoke.AMSI?label=%20&logo=nuget&style=flat-square)![Nuget](https://img.shields.io/nuget/dt/Vanara.PInvoke.AMSI?label=%20&style=flat-square)](https://www.nuget.org/packages/Vanara.PInvoke.AMSI)
avicap32.dll, avifil32.dll, msacm32.dll, msvfw32.dll, winmm.dll | [Vanara.PInvoke.Multimedia](https://github.com/dahall/Vanara/blob/master/PInvoke/Multimedia/readme.md) | ![Coverage](https://img.shields.io/badge/100%25-green.svg?style=flat-square) | [![Nuget](https://img.shields.io/nuget/v/Vanara.PInvoke.Multimedia?label=%20&logo=nuget&style=flat-square)![Nuget](https://img.shields.io/nuget/dt/Vanara.PInvoke.Multimedia?label=%20&style=flat-square)](https://www.nuget.org/packages/Vanara.PInvoke.Multimedia)
avrt.dll | [Vanara.PInvoke.Avrt](https://github.com/dahall/Vanara/blob/master/PInvoke/Avrt/readme.md) | ![Coverage](https://img.shields.io/badge/100%25-green.svg?style=flat-square) | [![Nuget](https://img.shields.io/nuget/v/Vanara.PInvoke.Avrt?label=%20&logo=nuget&style=flat-square)![Nuget](https://img.shields.io/nuget/dt/Vanara.PInvoke.Avrt?label=%20&style=flat-square)](https://www.nuget.org/packages/Vanara.PInvoke.Avrt)
cabinet.dll | [Vanara.PInvoke.Cabinet](https://github.com/dahall/Vanara/blob/master/PInvoke/Cabinet/readme.md) | ![Coverage](https://img.shields.io/badge/100%25-green.svg?style=flat-square) | [![Nuget](https://img.shields.io/nuget/v/Vanara.PInvoke.Cabinet?label=%20&logo=nuget&style=flat-square)![Nuget](https://img.shields.io/nuget/dt/Vanara.PInvoke.Cabinet?label=%20&style=flat-square)](https://www.nuget.org/packages/Vanara.PInvoke.Cabinet)
CfgMgr32.dll | [Vanara.PInvoke.CfgMgr32](https://github.com/dahall/Vanara/blob/master/PInvoke/CfgMgr32/readme.md) | ![Coverage](https://img.shields.io/badge/100%25-green.svg?style=flat-square) | [![Nuget](https://img.shields.io/nuget/v/Vanara.PInvoke.CfgMgr32?label=%20&logo=nuget&style=flat-square)![Nuget](https://img.shields.io/nuget/dt/Vanara.PInvoke.CfgMgr32?label=%20&style=flat-square)](https://www.nuget.org/packages/Vanara.PInvoke.CfgMgr32)
cimfs.dll | [Vanara.PInvoke.CimFs](https://github.com/dahall/Vanara/blob/master/PInvoke/CimFs/readme.md) | ![Coverage](https://img.shields.io/badge/100%25-green.svg?style=flat-square) | [![Nuget](https://img.shields.io/nuget/v/Vanara.PInvoke.CimFs?label=%20&logo=nuget&style=flat-square)![Nuget](https://img.shields.io/nuget/dt/Vanara.PInvoke.CimFs?label=%20&style=flat-square)](https://www.nuget.org/packages/Vanara.PInvoke.CimFs)
CldApi.dll | [Vanara.PInvoke.CldApi](https://github.com/dahall/Vanara/blob/master/PInvoke/CldApi/readme.md) | ![Coverage](https://img.shields.io/badge/100%25-green.svg?style=flat-square) | [![Nuget](https://img.shields.io/nuget/v/Vanara.PInvoke.CldApi?label=%20&logo=nuget&style=flat-square)![Nuget](https://img.shields.io/nuget/dt/Vanara.PInvoke.CldApi?label=%20&style=flat-square)](https://www.nuget.org/packages/Vanara.PInvoke.CldApi)
clfsw32.dll | [Vanara.PInvoke.ClfsW32](https://github.com/dahall/Vanara/blob/master/PInvoke/ClfsW32/readme.md) | ![Coverage](https://img.shields.io/badge/100%25-green.svg?style=flat-square) | [![Nuget](https://img.shields.io/nuget/v/Vanara.PInvoke.ClfsW32?label=%20&logo=nuget&style=flat-square)![Nuget](https://img.shields.io/nuget/dt/Vanara.PInvoke.ClfsW32?label=%20&style=flat-square)](https://www.nuget.org/packages/Vanara.PInvoke.ClfsW32)
comctl32.dll | [Vanara.PInvoke.ComCtl32](https://github.com/dahall/Vanara/blob/master/PInvoke/ComCtl32/readme.md) | ![Coverage](https://img.shields.io/badge/100%25-green.svg?style=flat-square) | [![Nuget](https://img.shields.io/nuget/v/Vanara.PInvoke.ComCtl32?label=%20&logo=nuget&style=flat-square)![Nuget](https://img.shields.io/nuget/dt/Vanara.PInvoke.ComCtl32?label=%20&style=flat-square)](https://www.nuget.org/packages/Vanara.PInvoke.ComCtl32)
ComDlg32.dll | [Vanara.PInvoke.ComDlg32](https://github.com/dahall/Vanara/blob/master/PInvoke/ComDlg32/readme.md) | ![Coverage](https://img.shields.io/badge/100%25-green.svg?style=flat-square) | [![Nuget](https://img.shields.io/nuget/v/Vanara.PInvoke.ComDlg32?label=%20&logo=nuget&style=flat-square)![Nuget](https://img.shields.io/nuget/dt/Vanara.PInvoke.ComDlg32?label=%20&style=flat-square)](https://www.nuget.org/packages/Vanara.PInvoke.ComDlg32)
credui.dll | [Vanara.PInvoke.CredUI](https://github.com/dahall/Vanara/blob/master/PInvoke/CredUI/readme.md) | ![Coverage](https://img.shields.io/badge/100%25-green.svg?style=flat-square) | [![Nuget](https://img.shields.io/nuget/v/Vanara.PInvoke.CredUI?label=%20&logo=nuget&style=flat-square)![Nuget](https://img.shields.io/nuget/dt/Vanara.PInvoke.CredUI?label=%20&style=flat-square)](https://www.nuget.org/packages/Vanara.PInvoke.CredUI)
crypt32.dll, bcrypt.dll, ncrypt.dll, tokenbinding.dll, cryptui.dll, cryptnet.dll, cryptdlg.dll | [Vanara.PInvoke.Cryptography](https://github.com/dahall/Vanara/blob/master/PInvoke/Cryptography/readme.md) | ![Coverage](https://img.shields.io/badge/100%25-green.svg?style=flat-square) | [![Nuget](https://img.shields.io/nuget/v/Vanara.PInvoke.Cryptography?label=%20&logo=nuget&style=flat-square)![Nuget](https://img.shields.io/nuget/dt/Vanara.PInvoke.Cryptography?label=%20&style=flat-square)](https://www.nuget.org/packages/Vanara.PInvoke.Cryptography)
d2d1.dll | [Vanara.PInvoke.Direct2D](https://github.com/dahall/Vanara/blob/master/PInvoke/Direct2D/readme.md) | ![Coverage](https://img.shields.io/badge/100%25-green.svg?style=flat-square) | [![Nuget](https://img.shields.io/nuget/v/Vanara.PInvoke.Direct2D?label=%20&logo=nuget&style=flat-square)![Nuget](https://img.shields.io/nuget/dt/Vanara.PInvoke.Direct2D?label=%20&style=flat-square)](https://www.nuget.org/packages/Vanara.PInvoke.Direct2D)
d3d11.dll, d3dcsx.dll, d3d11sdklayers.dll | [Vanara.PInvoke.Direct3D11](https://github.com/dahall/Vanara/blob/master/PInvoke/Direct3D11/readme.md) | ![Coverage](https://img.shields.io/badge/26%25-red.svg?style=flat-square) | [![Nuget](https://img.shields.io/nuget/v/Vanara.PInvoke.Direct3D11?label=%20&logo=nuget&style=flat-square)![Nuget](https://img.shields.io/nuget/dt/Vanara.PInvoke.Direct3D11?label=%20&style=flat-square)](https://www.nuget.org/packages/Vanara.PInvoke.Direct3D11)
d3d12.dll | [Vanara.PInvoke.Direct3D12](https://github.com/dahall/Vanara/blob/master/PInvoke/Direct3D12/readme.md) | ![Coverage](https://img.shields.io/badge/100%25-green.svg?style=flat-square) | [![Nuget](https://img.shields.io/nuget/v/Vanara.PInvoke.Direct3D12?label=%20&logo=nuget&style=flat-square)![Nuget](https://img.shields.io/nuget/dt/Vanara.PInvoke.Direct3D12?label=%20&style=flat-square)](https://www.nuget.org/packages/Vanara.PInvoke.Direct3D12)
d3dcompiler_47.dll, dxilconv.dll | [Vanara.PInvoke.D3DCompiler](https://github.com/dahall/Vanara/blob/master/PInvoke/D3DCompiler/readme.md) | ![Coverage](https://img.shields.io/badge/100%25-green.svg?style=flat-square) | [![Nuget](https://img.shields.io/nuget/v/Vanara.PInvoke.D3DCompiler?label=%20&logo=nuget&style=flat-square)![Nuget](https://img.shields.io/nuget/dt/Vanara.PInvoke.D3DCompiler?label=%20&style=flat-square)](https://www.nuget.org/packages/Vanara.PInvoke.D3DCompiler)
davclnt.dll | [Vanara.PInvoke.DavClnt](https://github.com/dahall/Vanara/blob/master/PInvoke/DavClnt/readme.md) | ![Coverage](https://img.shields.io/badge/100%25-green.svg?style=flat-square) | [![Nuget](https://img.shields.io/nuget/v/Vanara.PInvoke.DavClnt?label=%20&logo=nuget&style=flat-square)![Nuget](https://img.shields.io/nuget/dt/Vanara.PInvoke.DavClnt?label=%20&style=flat-square)](https://www.nuget.org/packages/Vanara.PInvoke.DavClnt)
DbgHelp.dll, ImageHlp.dll | [Vanara.PInvoke.DbgHelp](https://github.com/dahall/Vanara/blob/master/PInvoke/DbgHelp/readme.md) | ![Coverage](https://img.shields.io/badge/100%25-green.svg?style=flat-square) | [![Nuget](https://img.shields.io/nuget/v/Vanara.PInvoke.DbgHelp?label=%20&logo=nuget&style=flat-square)![Nuget](https://img.shields.io/nuget/dt/Vanara.PInvoke.DbgHelp?label=%20&style=flat-square)](https://www.nuget.org/packages/Vanara.PInvoke.DbgHelp)
Dhcpcsvc6.dll, Dhcpcsvc.dll | [Vanara.PInvoke.Dhcp](https://github.com/dahall/Vanara/blob/master/PInvoke/Dhcp/readme.md) | ![Coverage](https://img.shields.io/badge/100%25-green.svg?style=flat-square) | [![Nuget](https://img.shields.io/nuget/v/Vanara.PInvoke.Dhcp?label=%20&logo=nuget&style=flat-square)![Nuget](https://img.shields.io/nuget/dt/Vanara.PInvoke.Dhcp?label=%20&style=flat-square)](https://www.nuget.org/packages/Vanara.PInvoke.Dhcp)
DnsApi.dll | [Vanara.PInvoke.DnsApi](https://github.com/dahall/Vanara/blob/master/PInvoke/DnsApi/readme.md) | ![Coverage](https://img.shields.io/badge/100%25-green.svg?style=flat-square) | [![Nuget](https://img.shields.io/nuget/v/Vanara.PInvoke.DnsApi?label=%20&logo=nuget&style=flat-square)![Nuget](https://img.shields.io/nuget/dt/Vanara.PInvoke.DnsApi?label=%20&style=flat-square)](https://www.nuget.org/packages/Vanara.PInvoke.DnsApi)
dosvc.dll | [Vanara.PInvoke.DOSvc](https://github.com/dahall/Vanara/blob/master/PInvoke/DOSvc/readme.md) | ![Coverage](https://img.shields.io/badge/100%25-green.svg?style=flat-square) | [![Nuget](https://img.shields.io/nuget/v/Vanara.PInvoke.DOSvc?label=%20&logo=nuget&style=flat-square)![Nuget](https://img.shields.io/nuget/dt/Vanara.PInvoke.DOSvc?label=%20&style=flat-square)](https://www.nuget.org/packages/Vanara.PInvoke.DOSvc)
drt.dll, drtprov.dll, drttransport.dll | [Vanara.PInvoke.Drt](https://github.com/dahall/Vanara/blob/master/PInvoke/Drt/readme.md) | ![Coverage](https://img.shields.io/badge/100%25-green.svg?style=flat-square) | [![Nuget](https://img.shields.io/nuget/v/Vanara.PInvoke.Drt?label=%20&logo=nuget&style=flat-square)![Nuget](https://img.shields.io/nuget/dt/Vanara.PInvoke.Drt?label=%20&style=flat-square)](https://www.nuget.org/packages/Vanara.PInvoke.Drt)
dstorage.dll | [Vanara.PInvoke.DStorage](https://github.com/dahall/Vanara/blob/master/PInvoke/DStorage/readme.md) | ![Coverage](https://img.shields.io/badge/100%25-green.svg?style=flat-square) | [![Nuget](https://img.shields.io/nuget/v/Vanara.PInvoke.DStorage?label=%20&logo=nuget&style=flat-square)![Nuget](https://img.shields.io/nuget/dt/Vanara.PInvoke.DStorage?label=%20&style=flat-square)](https://www.nuget.org/packages/Vanara.PInvoke.DStorage)
dwmapi.dll | [Vanara.PInvoke.DwmApi](https://github.com/dahall/Vanara/blob/master/PInvoke/DwmApi/readme.md) | ![Coverage](https://img.shields.io/badge/100%25-green.svg?style=flat-square) | [![Nuget](https://img.shields.io/nuget/v/Vanara.PInvoke.DwmApi?label=%20&logo=nuget&style=flat-square)![Nuget](https://img.shields.io/nuget/dt/Vanara.PInvoke.DwmApi?label=%20&style=flat-square)](https://www.nuget.org/packages/Vanara.PInvoke.DwmApi)
dwrite.dll | [Vanara.PInvoke.DWrite](https://github.com/dahall/Vanara/blob/master/PInvoke/DWrite/readme.md) | ![Coverage](https://img.shields.io/badge/100%25-green.svg?style=flat-square) | [![Nuget](https://img.shields.io/nuget/v/Vanara.PInvoke.DWrite?label=%20&logo=nuget&style=flat-square)![Nuget](https://img.shields.io/nuget/dt/Vanara.PInvoke.DWrite?label=%20&style=flat-square)](https://www.nuget.org/packages/Vanara.PInvoke.DWrite)
dxcore.dll | [Vanara.PInvoke.DXCore](https://github.com/dahall/Vanara/blob/master/PInvoke/DXCore/readme.md) | ![Coverage](https://img.shields.io/badge/100%25-green.svg?style=flat-square) | [![Nuget](https://img.shields.io/nuget/v/Vanara.PInvoke.DXCore?label=%20&logo=nuget&style=flat-square)![Nuget](https://img.shields.io/nuget/dt/Vanara.PInvoke.DXCore?label=%20&style=flat-square)](https://www.nuget.org/packages/Vanara.PInvoke.DXCore)
dxgi.dll | [Vanara.PInvoke.DXGI](https://github.com/dahall/Vanara/blob/master/PInvoke/DXGI/readme.md) | ![Coverage](https://img.shields.io/badge/100%25-green.svg?style=flat-square) | [![Nuget](https://img.shields.io/nuget/v/Vanara.PInvoke.DXGI?label=%20&logo=nuget&style=flat-square)![Nuget](https://img.shields.io/nuget/dt/Vanara.PInvoke.DXGI?label=%20&style=flat-square)](https://www.nuget.org/packages/Vanara.PInvoke.DXGI)
ehstorapi.dll | [Vanara.PInvoke.EnhancedStorage](https://github.com/dahall/Vanara/blob/master/PInvoke/EnhancedStorage/readme.md) | ![Coverage](https://img.shields.io/badge/100%25-green.svg?style=flat-square) | [![Nuget](https://img.shields.io/nuget/v/Vanara.PInvoke.EnhancedStorage?label=%20&logo=nuget&style=flat-square)![Nuget](https://img.shields.io/nuget/dt/Vanara.PInvoke.EnhancedStorage?label=%20&style=flat-square)](https://www.nuget.org/packages/Vanara.PInvoke.EnhancedStorage)
elscore.dll | [Vanara.PInvoke.ElsCore](https://github.com/dahall/Vanara/blob/master/PInvoke/ElsCore/readme.md) | ![Coverage](https://img.shields.io/badge/100%25-green.svg?style=flat-square) | [![Nuget](https://img.shields.io/nuget/v/Vanara.PInvoke.ElsCore?label=%20&logo=nuget&style=flat-square)![Nuget](https://img.shields.io/nuget/dt/Vanara.PInvoke.ElsCore?label=%20&style=flat-square)](https://www.nuget.org/packages/Vanara.PInvoke.ElsCore)
fhsvcctl.dll | [Vanara.PInvoke.FhSvcCtl](https://github.com/dahall/Vanara/blob/master/PInvoke/FhSvcCtl/readme.md) | ![Coverage](https://img.shields.io/badge/100%25-green.svg?style=flat-square) | [![Nuget](https://img.shields.io/nuget/v/Vanara.PInvoke.FhSvcCtl?label=%20&logo=nuget&style=flat-square)![Nuget](https://img.shields.io/nuget/dt/Vanara.PInvoke.FhSvcCtl?label=%20&style=flat-square)](https://www.nuget.org/packages/Vanara.PInvoke.FhSvcCtl)
FirewallApi.dll | [Vanara.PInvoke.FirewallApi](https://github.com/dahall/Vanara/blob/master/PInvoke/FirewallApi/readme.md) | ![Coverage](https://img.shields.io/badge/100%25-green.svg?style=flat-square) | [![Nuget](https://img.shields.io/nuget/v/Vanara.PInvoke.FirewallApi?label=%20&logo=nuget&style=flat-square)![Nuget](https://img.shields.io/nuget/dt/Vanara.PInvoke.FirewallApi?label=%20&style=flat-square)](https://www.nuget.org/packages/Vanara.PInvoke.FirewallApi)
fundisc.dll | [Vanara.PInvoke.FunDisc](https://github.com/dahall/Vanara/blob/master/PInvoke/FunDisc/readme.md) | ![Coverage](https://img.shields.io/badge/100%25-green.svg?style=flat-square) | [![Nuget](https://img.shields.io/nuget/v/Vanara.PInvoke.FunDisc?label=%20&logo=nuget&style=flat-square)![Nuget](https://img.shields.io/nuget/dt/Vanara.PInvoke.FunDisc?label=%20&style=flat-square)](https://www.nuget.org/packages/Vanara.PInvoke.FunDisc)
fwpuclnt.dll | [Vanara.PInvoke.FwpUClnt](https://github.com/dahall/Vanara/blob/master/PInvoke/FwpUClnt/readme.md) | ![Coverage](https://img.shields.io/badge/100%25-green.svg?style=flat-square) | [![Nuget](https://img.shields.io/nuget/v/Vanara.PInvoke.FwpUClnt?label=%20&logo=nuget&style=flat-square)![Nuget](https://img.shields.io/nuget/dt/Vanara.PInvoke.FwpUClnt?label=%20&style=flat-square)](https://www.nuget.org/packages/Vanara.PInvoke.FwpUClnt)
gdi32.dll | [Vanara.PInvoke.Gdi32](https://github.com/dahall/Vanara/blob/master/PInvoke/Gdi32/readme.md) | ![Coverage](https://img.shields.io/badge/100%25-green.svg?style=flat-square) | [![Nuget](https://img.shields.io/nuget/v/Vanara.PInvoke.Gdi32?label=%20&logo=nuget&style=flat-square)![Nuget](https://img.shields.io/nuget/dt/Vanara.PInvoke.Gdi32?label=%20&style=flat-square)](https://www.nuget.org/packages/Vanara.PInvoke.Gdi32)
httpapi.dll | [Vanara.PInvoke.HttpApi](https://github.com/dahall/Vanara/blob/master/PInvoke/HttpApi/readme.md) | ![Coverage](https://img.shields.io/badge/100%25-green.svg?style=flat-square) | [![Nuget](https://img.shields.io/nuget/v/Vanara.PInvoke.HttpApi?label=%20&logo=nuget&style=flat-square)![Nuget](https://img.shields.io/nuget/dt/Vanara.PInvoke.HttpApi?label=%20&style=flat-square)](https://www.nuget.org/packages/Vanara.PInvoke.HttpApi)
imapi2.dll, imapi2fs.dll | [Vanara.PInvoke.IMAPI](https://github.com/dahall/Vanara/blob/master/PInvoke/IMAPI/readme.md) | ![Coverage](https://img.shields.io/badge/100%25-green.svg?style=flat-square) | [![Nuget](https://img.shields.io/nuget/v/Vanara.PInvoke.IMAPI?label=%20&logo=nuget&style=flat-square)![Nuget](https://img.shields.io/nuget/dt/Vanara.PInvoke.IMAPI?label=%20&style=flat-square)](https://www.nuget.org/packages/Vanara.PInvoke.IMAPI)
imm32.dll | [Vanara.PInvoke.Imm32](https://github.com/dahall/Vanara/blob/master/PInvoke/Imm32/readme.md) | ![Coverage](https://img.shields.io/badge/100%25-green.svg?style=flat-square) | [![Nuget](https://img.shields.io/nuget/v/Vanara.PInvoke.Imm32?label=%20&logo=nuget&style=flat-square)![Nuget](https://img.shields.io/nuget/dt/Vanara.PInvoke.Imm32?label=%20&style=flat-square)](https://www.nuget.org/packages/Vanara.PInvoke.Imm32)
iphlpapi.dll | [Vanara.PInvoke.IpHlpApi](https://github.com/dahall/Vanara/blob/master/PInvoke/IpHlpApi/readme.md) | ![Coverage](https://img.shields.io/badge/100%25-green.svg?style=flat-square) | [![Nuget](https://img.shields.io/nuget/v/Vanara.PInvoke.IpHlpApi?label=%20&logo=nuget&style=flat-square)![Nuget](https://img.shields.io/nuget/dt/Vanara.PInvoke.IpHlpApi?label=%20&style=flat-square)](https://www.nuget.org/packages/Vanara.PInvoke.IpHlpApi)
IScsiDsc.dll | [Vanara.PInvoke.IScsiDsc](https://github.com/dahall/Vanara/blob/master/PInvoke/IScsiDsc/readme.md) | ![Coverage](https://img.shields.io/badge/100%25-green.svg?style=flat-square) | [![Nuget](https://img.shields.io/nuget/v/Vanara.PInvoke.IScsiDsc?label=%20&logo=nuget&style=flat-square)![Nuget](https://img.shields.io/nuget/dt/Vanara.PInvoke.IScsiDsc?label=%20&style=flat-square)](https://www.nuget.org/packages/Vanara.PInvoke.IScsiDsc)
kernel32.dll, kernelbase.dll, normaliz.dll, vertdll.dll | [Vanara.PInvoke.Kernel32](https://github.com/dahall/Vanara/blob/master/PInvoke/Kernel32/readme.md) | ![Coverage](https://img.shields.io/badge/100%25-green.svg?style=flat-square) | [![Nuget](https://img.shields.io/nuget/v/Vanara.PInvoke.Kernel32?label=%20&logo=nuget&style=flat-square)![Nuget](https://img.shields.io/nuget/dt/Vanara.PInvoke.Kernel32?label=%20&style=flat-square)](https://www.nuget.org/packages/Vanara.PInvoke.Kernel32)
ktmw32.dll | [Vanara.PInvoke.KtmW32](https://github.com/dahall/Vanara/blob/master/PInvoke/KtmW32/readme.md) | ![Coverage](https://img.shields.io/badge/100%25-green.svg?style=flat-square) | [![Nuget](https://img.shields.io/nuget/v/Vanara.PInvoke.KtmW32?label=%20&logo=nuget&style=flat-square)![Nuget](https://img.shields.io/nuget/dt/Vanara.PInvoke.KtmW32?label=%20&style=flat-square)](https://www.nuget.org/packages/Vanara.PInvoke.KtmW32)
Lz32.dll | [Vanara.PInvoke.Lz32](https://github.com/dahall/Vanara/blob/master/PInvoke/Lz32/readme.md) | ![Coverage](https://img.shields.io/badge/100%25-green.svg?style=flat-square) | [![Nuget](https://img.shields.io/nuget/v/Vanara.PInvoke.Lz32?label=%20&logo=nuget&style=flat-square)![Nuget](https://img.shields.io/nuget/dt/Vanara.PInvoke.Lz32?label=%20&style=flat-square)](https://www.nuget.org/packages/Vanara.PInvoke.Lz32)
magnification.dll | [Vanara.PInvoke.Magnification](https://github.com/dahall/Vanara/blob/master/PInvoke/Magnification/readme.md) | ![Coverage](https://img.shields.io/badge/100%25-green.svg?style=flat-square) | [![Nuget](https://img.shields.io/nuget/v/Vanara.PInvoke.Magnification?label=%20&logo=nuget&style=flat-square)![Nuget](https://img.shields.io/nuget/dt/Vanara.PInvoke.Magnification?label=%20&style=flat-square)](https://www.nuget.org/packages/Vanara.PInvoke.Magnification)
mmdevapi.dll | [Vanara.PInvoke.CoreAudio](https://github.com/dahall/Vanara/blob/master/PInvoke/CoreAudio/readme.md) | ![Coverage](https://img.shields.io/badge/100%25-green.svg?style=flat-square) | [![Nuget](https://img.shields.io/nuget/v/Vanara.PInvoke.CoreAudio?label=%20&logo=nuget&style=flat-square)![Nuget](https://img.shields.io/nuget/dt/Vanara.PInvoke.CoreAudio?label=%20&style=flat-square)](https://www.nuget.org/packages/Vanara.PInvoke.CoreAudio)
mpr.dll | [Vanara.PInvoke.Mpr](https://github.com/dahall/Vanara/blob/master/PInvoke/Mpr/readme.md) | ![Coverage](https://img.shields.io/badge/100%25-green.svg?style=flat-square) | [![Nuget](https://img.shields.io/nuget/v/Vanara.PInvoke.Mpr?label=%20&logo=nuget&style=flat-square)![Nuget](https://img.shields.io/nuget/dt/Vanara.PInvoke.Mpr?label=%20&style=flat-square)](https://www.nuget.org/packages/Vanara.PInvoke.Mpr)
msctf.dll, input.dll, msimtf.dll | [Vanara.PInvoke.TextServicesFramework](https://github.com/dahall/Vanara/blob/master/PInvoke/TextServicesFramework/readme.md) | ![Coverage](https://img.shields.io/badge/100%25-green.svg?style=flat-square) | [![Nuget](https://img.shields.io/nuget/v/Vanara.PInvoke.TextServicesFramework?label=%20&logo=nuget&style=flat-square)![Nuget](https://img.shields.io/nuget/dt/Vanara.PInvoke.TextServicesFramework?label=%20&style=flat-square)](https://www.nuget.org/packages/Vanara.PInvoke.TextServicesFramework)
msftedit.dll,riched20.dll | [Vanara.PInvoke.MsftEdit](https://github.com/dahall/Vanara/blob/master/PInvoke/MsftEdit/readme.md) | ![Coverage](https://img.shields.io/badge/100%25-green.svg?style=flat-square) | [![Nuget](https://img.shields.io/nuget/v/Vanara.PInvoke.MsftEdit?label=%20&logo=nuget&style=flat-square)![Nuget](https://img.shields.io/nuget/dt/Vanara.PInvoke.MsftEdit?label=%20&style=flat-square)](https://www.nuget.org/packages/Vanara.PInvoke.MsftEdit)
Msi.dll | [Vanara.PInvoke.Msi](https://github.com/dahall/Vanara/blob/master/PInvoke/Msi/readme.md) | ![Coverage](https://img.shields.io/badge/100%25-green.svg?style=flat-square) | [![Nuget](https://img.shields.io/nuget/v/Vanara.PInvoke.Msi?label=%20&logo=nuget&style=flat-square)![Nuget](https://img.shields.io/nuget/dt/Vanara.PInvoke.Msi?label=%20&style=flat-square)](https://www.nuget.org/packages/Vanara.PInvoke.Msi)
msrdc.dll | [Vanara.PInvoke.MsRdc](https://github.com/dahall/Vanara/blob/master/PInvoke/MsRdc/readme.md) | ![Coverage](https://img.shields.io/badge/100%25-green.svg?style=flat-square) | [![Nuget](https://img.shields.io/nuget/v/Vanara.PInvoke.MsRdc?label=%20&logo=nuget&style=flat-square)![Nuget](https://img.shields.io/nuget/dt/Vanara.PInvoke.MsRdc?label=%20&style=flat-square)](https://www.nuget.org/packages/Vanara.PInvoke.MsRdc)
ndfapi.dll | [Vanara.PInvoke.NdfApi](https://github.com/dahall/Vanara/blob/master/PInvoke/NdfApi/readme.md) | ![Coverage](https://img.shields.io/badge/100%25-green.svg?style=flat-square) | [![Nuget](https://img.shields.io/nuget/v/Vanara.PInvoke.NdfApi?label=%20&logo=nuget&style=flat-square)![Nuget](https://img.shields.io/nuget/dt/Vanara.PInvoke.NdfApi?label=%20&style=flat-square)](https://www.nuget.org/packages/Vanara.PInvoke.NdfApi)
netapi32.dll | [Vanara.PInvoke.NetApi32](https://github.com/dahall/Vanara/blob/master/PInvoke/NetApi32/readme.md) | ![Coverage](https://img.shields.io/badge/100%25-green.svg?style=flat-square) | [![Nuget](https://img.shields.io/nuget/v/Vanara.PInvoke.NetApi32?label=%20&logo=nuget&style=flat-square)![Nuget](https://img.shields.io/nuget/dt/Vanara.PInvoke.NetApi32?label=%20&style=flat-square)](https://www.nuget.org/packages/Vanara.PInvoke.NetApi32)
netprofm.dll | [Vanara.PInvoke.NetListMgr](https://github.com/dahall/Vanara/blob/master/PInvoke/NetListMgr/readme.md) | ![Coverage](https://img.shields.io/badge/100%25-green.svg?style=flat-square) | [![Nuget](https://img.shields.io/nuget/v/Vanara.PInvoke.NetListMgr?label=%20&logo=nuget&style=flat-square)![Nuget](https://img.shields.io/nuget/dt/Vanara.PInvoke.NetListMgr?label=%20&style=flat-square)](https://www.nuget.org/packages/Vanara.PInvoke.NetListMgr)
NewDev.dll | [Vanara.PInvoke.NewDev](https://github.com/dahall/Vanara/blob/master/PInvoke/NewDev/readme.md) | ![Coverage](https://img.shields.io/badge/100%25-green.svg?style=flat-square) | [![Nuget](https://img.shields.io/nuget/v/Vanara.PInvoke.NewDev?label=%20&logo=nuget&style=flat-square)![Nuget](https://img.shields.io/nuget/dt/Vanara.PInvoke.NewDev?label=%20&style=flat-square)](https://www.nuget.org/packages/Vanara.PInvoke.NewDev)
ntdll.dll | [Vanara.PInvoke.NtDll](https://github.com/dahall/Vanara/blob/master/PInvoke/NtDll/readme.md) | ![Coverage](https://img.shields.io/badge/5%25-red.svg?style=flat-square) | [![Nuget](https://img.shields.io/nuget/v/Vanara.PInvoke.NtDll?label=%20&logo=nuget&style=flat-square)![Nuget](https://img.shields.io/nuget/dt/Vanara.PInvoke.NtDll?label=%20&style=flat-square)](https://www.nuget.org/packages/Vanara.PInvoke.NtDll)
ntdsapi.dll | [Vanara.PInvoke.NTDSApi](https://github.com/dahall/Vanara/blob/master/PInvoke/NTDSApi/readme.md) | ![Coverage](https://img.shields.io/badge/100%25-green.svg?style=flat-square) | [![Nuget](https://img.shields.io/nuget/v/Vanara.PInvoke.NTDSApi?label=%20&logo=nuget&style=flat-square)![Nuget](https://img.shields.io/nuget/dt/Vanara.PInvoke.NTDSApi?label=%20&style=flat-square)](https://www.nuget.org/packages/Vanara.PInvoke.NTDSApi)
odbc32.dll | [Vanara.PInvoke.Odbc32](https://github.com/dahall/Vanara/blob/master/PInvoke/Odbc32/readme.md) | ![Coverage](https://img.shields.io/badge/100%25-green.svg?style=flat-square) | [![Nuget](https://img.shields.io/nuget/v/Vanara.PInvoke.Odbc32?label=%20&logo=nuget&style=flat-square)![Nuget](https://img.shields.io/nuget/dt/Vanara.PInvoke.Odbc32?label=%20&style=flat-square)](https://www.nuget.org/packages/Vanara.PInvoke.Odbc32)
ole32.dll, oleaut32.dll, propsys.dll | [Vanara.PInvoke.Ole](https://github.com/dahall/Vanara/blob/master/PInvoke/Ole/readme.md) | ![Coverage](https://img.shields.io/badge/100%25-green.svg?style=flat-square) | [![Nuget](https://img.shields.io/nuget/v/Vanara.PInvoke.Ole?label=%20&logo=nuget&style=flat-square)![Nuget](https://img.shields.io/nuget/dt/Vanara.PInvoke.Ole?label=%20&style=flat-square)](https://www.nuget.org/packages/Vanara.PInvoke.Ole)
oleacc.dll | [Vanara.PInvoke.Accessibility](https://github.com/dahall/Vanara/blob/master/PInvoke/Accessibility/readme.md) | ![Coverage](https://img.shields.io/badge/100%25-green.svg?style=flat-square) | [![Nuget](https://img.shields.io/nuget/v/Vanara.PInvoke.Accessibility?label=%20&logo=nuget&style=flat-square)![Nuget](https://img.shields.io/nuget/dt/Vanara.PInvoke.Accessibility?label=%20&style=flat-square)](https://www.nuget.org/packages/Vanara.PInvoke.Accessibility)
oledb.dll | [Vanara.PInvoke.OleDb](https://github.com/dahall/Vanara/blob/master/PInvoke/OleDb/readme.md) | ![Coverage](https://img.shields.io/badge/100%25-green.svg?style=flat-square) | [![Nuget](https://img.shields.io/nuget/v/Vanara.PInvoke.OleDb?label=%20&logo=nuget&style=flat-square)![Nuget](https://img.shields.io/nuget/dt/Vanara.PInvoke.OleDb?label=%20&style=flat-square)](https://www.nuget.org/packages/Vanara.PInvoke.OleDb)
OleDlg.dll | [Vanara.PInvoke.OleDlg](https://github.com/dahall/Vanara/blob/master/PInvoke/OleDlg/readme.md) | ![Coverage](https://img.shields.io/badge/100%25-green.svg?style=flat-square) | [![Nuget](https://img.shields.io/nuget/v/Vanara.PInvoke.OleDlg?label=%20&logo=nuget&style=flat-square)![Nuget](https://img.shields.io/nuget/dt/Vanara.PInvoke.OleDlg?label=%20&style=flat-square)](https://www.nuget.org/packages/Vanara.PInvoke.OleDlg)
opcservices.dll | [Vanara.PInvoke.Opc](https://github.com/dahall/Vanara/blob/master/PInvoke/Opc/readme.md) | ![Coverage](https://img.shields.io/badge/100%25-green.svg?style=flat-square) | [![Nuget](https://img.shields.io/nuget/v/Vanara.PInvoke.Opc?label=%20&logo=nuget&style=flat-square)![Nuget](https://img.shields.io/nuget/dt/Vanara.PInvoke.Opc?label=%20&style=flat-square)](https://www.nuget.org/packages/Vanara.PInvoke.Opc)
P2P.dll | [Vanara.PInvoke.P2P](https://github.com/dahall/Vanara/blob/master/PInvoke/P2P/readme.md) | ![Coverage](https://img.shields.io/badge/100%25-green.svg?style=flat-square) | [![Nuget](https://img.shields.io/nuget/v/Vanara.PInvoke.P2P?label=%20&logo=nuget&style=flat-square)![Nuget](https://img.shields.io/nuget/dt/Vanara.PInvoke.P2P?label=%20&style=flat-square)](https://www.nuget.org/packages/Vanara.PInvoke.P2P)
pdh.dll | [Vanara.PInvoke.Pdh](https://github.com/dahall/Vanara/blob/master/PInvoke/Pdh/readme.md) | ![Coverage](https://img.shields.io/badge/100%25-green.svg?style=flat-square) | [![Nuget](https://img.shields.io/nuget/v/Vanara.PInvoke.Pdh?label=%20&logo=nuget&style=flat-square)![Nuget](https://img.shields.io/nuget/dt/Vanara.PInvoke.Pdh?label=%20&style=flat-square)](https://www.nuget.org/packages/Vanara.PInvoke.Pdh)
PeerDist.dll | [Vanara.PInvoke.PeerDist](https://github.com/dahall/Vanara/blob/master/PInvoke/PeerDist/readme.md) | ![Coverage](https://img.shields.io/badge/100%25-green.svg?style=flat-square) | [![Nuget](https://img.shields.io/nuget/v/Vanara.PInvoke.PeerDist?label=%20&logo=nuget&style=flat-square)![Nuget](https://img.shields.io/nuget/dt/Vanara.PInvoke.PeerDist?label=%20&style=flat-square)](https://www.nuget.org/packages/Vanara.PInvoke.PeerDist)
photoacq.dll | [Vanara.PInvoke.PhotoAcquire](https://github.com/dahall/Vanara/blob/master/PInvoke/PhotoAcquire/readme.md) | ![Coverage](https://img.shields.io/badge/100%25-green.svg?style=flat-square) | [![Nuget](https://img.shields.io/nuget/v/Vanara.PInvoke.PhotoAcquire?label=%20&logo=nuget&style=flat-square)![Nuget](https://img.shields.io/nuget/dt/Vanara.PInvoke.PhotoAcquire?label=%20&style=flat-square)](https://www.nuget.org/packages/Vanara.PInvoke.PhotoAcquire)
portabledeviceapi.dll, portabledeviceconnectapi.dll, portabledevicetypes.dll | [Vanara.PInvoke.PortableDeviceApi](https://github.com/dahall/Vanara/blob/master/PInvoke/PortableDeviceApi/readme.md) | ![Coverage](https://img.shields.io/badge/100%25-green.svg?style=flat-square) | [![Nuget](https://img.shields.io/nuget/v/Vanara.PInvoke.PortableDeviceApi?label=%20&logo=nuget&style=flat-square)![Nuget](https://img.shields.io/nuget/dt/Vanara.PInvoke.PortableDeviceApi?label=%20&style=flat-square)](https://www.nuget.org/packages/Vanara.PInvoke.PortableDeviceApi)
powrprof.dll | [Vanara.PInvoke.PowrProf](https://github.com/dahall/Vanara/blob/master/PInvoke/PowrProf/readme.md) | ![Coverage](https://img.shields.io/badge/100%25-green.svg?style=flat-square) | [![Nuget](https://img.shields.io/nuget/v/Vanara.PInvoke.PowrProf?label=%20&logo=nuget&style=flat-square)![Nuget](https://img.shields.io/nuget/dt/Vanara.PInvoke.PowrProf?label=%20&style=flat-square)](https://www.nuget.org/packages/Vanara.PInvoke.PowrProf)
ProjectedFSLib.dll | [Vanara.PInvoke.ProjectedFSLib](https://github.com/dahall/Vanara/blob/master/PInvoke/ProjectedFSLib/readme.md) | ![Coverage](https://img.shields.io/badge/100%25-green.svg?style=flat-square) | [![Nuget](https://img.shields.io/nuget/v/Vanara.PInvoke.ProjectedFSLib?label=%20&logo=nuget&style=flat-square)![Nuget](https://img.shields.io/nuget/dt/Vanara.PInvoke.ProjectedFSLib?label=%20&style=flat-square)](https://www.nuget.org/packages/Vanara.PInvoke.ProjectedFSLib)
qmgr.dll | [Vanara.PInvoke.BITS](https://github.com/dahall/Vanara/blob/master/PInvoke/BITS/readme.md) | ![Coverage](https://img.shields.io/badge/100%25-green.svg?style=flat-square) | [![Nuget](https://img.shields.io/nuget/v/Vanara.PInvoke.BITS?label=%20&logo=nuget&style=flat-square)![Nuget](https://img.shields.io/nuget/dt/Vanara.PInvoke.BITS?label=%20&style=flat-square)](https://www.nuget.org/packages/Vanara.PInvoke.BITS)
qwave.dll, traffic.dll | [Vanara.PInvoke.QoS](https://github.com/dahall/Vanara/blob/master/PInvoke/QoS/readme.md) | ![Coverage](https://img.shields.io/badge/100%25-green.svg?style=flat-square) | [![Nuget](https://img.shields.io/nuget/v/Vanara.PInvoke.QoS?label=%20&logo=nuget&style=flat-square)![Nuget](https://img.shields.io/nuget/dt/Vanara.PInvoke.QoS?label=%20&style=flat-square)](https://www.nuget.org/packages/Vanara.PInvoke.QoS)
rpcrt4.dll | [Vanara.PInvoke.Rpc](https://github.com/dahall/Vanara/blob/master/PInvoke/Rpc/readme.md) | ![Coverage](https://img.shields.io/badge/5%25-red.svg?style=flat-square) | [![Nuget](https://img.shields.io/nuget/v/Vanara.PInvoke.Rpc?label=%20&logo=nuget&style=flat-square)![Nuget](https://img.shields.io/nuget/dt/Vanara.PInvoke.Rpc?label=%20&style=flat-square)](https://www.nuget.org/packages/Vanara.PInvoke.Rpc)
RstrtMgr.dll | [Vanara.PInvoke.RstrtMgr](https://github.com/dahall/Vanara/blob/master/PInvoke/RstrtMgr/readme.md) | ![Coverage](https://img.shields.io/badge/100%25-green.svg?style=flat-square) | [![Nuget](https://img.shields.io/nuget/v/Vanara.PInvoke.RstrtMgr?label=%20&logo=nuget&style=flat-square)![Nuget](https://img.shields.io/nuget/dt/Vanara.PInvoke.RstrtMgr?label=%20&style=flat-square)](https://www.nuget.org/packages/Vanara.PInvoke.RstrtMgr)
SearchApi | [Vanara.PInvoke.SearchApi](https://github.com/dahall/Vanara/blob/master/PInvoke/SearchApi/readme.md) | ![Coverage](https://img.shields.io/badge/100%25-green.svg?style=flat-square) | [![Nuget](https://img.shields.io/nuget/v/Vanara.PInvoke.SearchApi?label=%20&logo=nuget&style=flat-square)![Nuget](https://img.shields.io/nuget/dt/Vanara.PInvoke.SearchApi?label=%20&style=flat-square)](https://www.nuget.org/packages/Vanara.PInvoke.SearchApi)
sensorsapi.dll | [Vanara.PInvoke.SensorsApi](https://github.com/dahall/Vanara/blob/master/PInvoke/SensorsApi/readme.md) | ![Coverage](https://img.shields.io/badge/100%25-green.svg?style=flat-square) | [![Nuget](https://img.shields.io/nuget/v/Vanara.PInvoke.SensorsApi?label=%20&logo=nuget&style=flat-square)![Nuget](https://img.shields.io/nuget/dt/Vanara.PInvoke.SensorsApi?label=%20&style=flat-square)](https://www.nuget.org/packages/Vanara.PInvoke.SensorsApi)
SetupAPI.dll | [Vanara.PInvoke.SetupAPI](https://github.com/dahall/Vanara/blob/master/PInvoke/SetupAPI/readme.md) | ![Coverage](https://img.shields.io/badge/100%25-green.svg?style=flat-square) | [![Nuget](https://img.shields.io/nuget/v/Vanara.PInvoke.SetupAPI?label=%20&logo=nuget&style=flat-square)![Nuget](https://img.shields.io/nuget/dt/Vanara.PInvoke.SetupAPI?label=%20&style=flat-square)](https://www.nuget.org/packages/Vanara.PInvoke.SetupAPI)
SHCore.dll | [Vanara.PInvoke.SHCore](https://github.com/dahall/Vanara/blob/master/PInvoke/SHCore/readme.md) | ![Coverage](https://img.shields.io/badge/100%25-green.svg?style=flat-square) | [![Nuget](https://img.shields.io/nuget/v/Vanara.PInvoke.SHCore?label=%20&logo=nuget&style=flat-square)![Nuget](https://img.shields.io/nuget/dt/Vanara.PInvoke.SHCore?label=%20&style=flat-square)](https://www.nuget.org/packages/Vanara.PInvoke.SHCore)
shell32.dll, url.dll | [Vanara.PInvoke.Shell32](https://github.com/dahall/Vanara/blob/master/PInvoke/Shell32/readme.md) | ![Coverage](https://img.shields.io/badge/100%25-green.svg?style=flat-square) | [![Nuget](https://img.shields.io/nuget/v/Vanara.PInvoke.Shell32?label=%20&logo=nuget&style=flat-square)![Nuget](https://img.shields.io/nuget/dt/Vanara.PInvoke.Shell32?label=%20&style=flat-square)](https://www.nuget.org/packages/Vanara.PInvoke.Shell32)
shlwapi.dll | [Vanara.PInvoke.ShlwApi](https://github.com/dahall/Vanara/blob/master/PInvoke/ShlwApi/readme.md) | ![Coverage](https://img.shields.io/badge/100%25-green.svg?style=flat-square) | [![Nuget](https://img.shields.io/nuget/v/Vanara.PInvoke.ShlwApi?label=%20&logo=nuget&style=flat-square)![Nuget](https://img.shields.io/nuget/dt/Vanara.PInvoke.ShlwApi?label=%20&style=flat-square)](https://www.nuget.org/packages/Vanara.PInvoke.ShlwApi)
taskschd.dll, mstask.dll | [Vanara.PInvoke.TaskSchd](https://github.com/dahall/Vanara/blob/master/PInvoke/TaskSchd/readme.md) | ![Coverage](https://img.shields.io/badge/100%25-green.svg?style=flat-square) | [![Nuget](https://img.shields.io/nuget/v/Vanara.PInvoke.TaskSchd?label=%20&logo=nuget&style=flat-square)![Nuget](https://img.shields.io/nuget/dt/Vanara.PInvoke.TaskSchd?label=%20&style=flat-square)](https://www.nuget.org/packages/Vanara.PInvoke.TaskSchd)
uianimation.dll | [Vanara.PInvoke.UIAnimation](https://github.com/dahall/Vanara/blob/master/PInvoke/UIAnimation/readme.md) | ![Coverage](https://img.shields.io/badge/100%25-green.svg?style=flat-square) | [![Nuget](https://img.shields.io/nuget/v/Vanara.PInvoke.UIAnimation?label=%20&logo=nuget&style=flat-square)![Nuget](https://img.shields.io/nuget/dt/Vanara.PInvoke.UIAnimation?label=%20&style=flat-square)](https://www.nuget.org/packages/Vanara.PInvoke.UIAnimation)
uiautomationcore.dll | [Vanara.PInvoke.UIAutomation](https://github.com/dahall/Vanara/blob/master/PInvoke/UIAutomation/readme.md) | ![Coverage](https://img.shields.io/badge/100%25-green.svg?style=flat-square) | [![Nuget](https://img.shields.io/nuget/v/Vanara.PInvoke.UIAutomation?label=%20&logo=nuget&style=flat-square)![Nuget](https://img.shields.io/nuget/dt/Vanara.PInvoke.UIAutomation?label=%20&style=flat-square)](https://www.nuget.org/packages/Vanara.PInvoke.UIAutomation)
UrlMon.dll | [Vanara.PInvoke.UrlMon](https://github.com/dahall/Vanara/blob/master/PInvoke/UrlMon/readme.md) | ![Coverage](https://img.shields.io/badge/100%25-green.svg?style=flat-square) | [![Nuget](https://img.shields.io/nuget/v/Vanara.PInvoke.UrlMon?label=%20&logo=nuget&style=flat-square)![Nuget](https://img.shields.io/nuget/dt/Vanara.PInvoke.UrlMon?label=%20&style=flat-square)](https://www.nuget.org/packages/Vanara.PInvoke.UrlMon)
user32.dll | [Vanara.PInvoke.User32](https://github.com/dahall/Vanara/blob/master/PInvoke/User32/readme.md) | ![Coverage](https://img.shields.io/badge/100%25-green.svg?style=flat-square) | [![Nuget](https://img.shields.io/nuget/v/Vanara.PInvoke.User32?label=%20&logo=nuget&style=flat-square)![Nuget](https://img.shields.io/nuget/dt/Vanara.PInvoke.User32?label=%20&style=flat-square)](https://www.nuget.org/packages/Vanara.PInvoke.User32)
UserEnv.dll | [Vanara.PInvoke.UserEnv](https://github.com/dahall/Vanara/blob/master/PInvoke/UserEnv/readme.md) | ![Coverage](https://img.shields.io/badge/100%25-green.svg?style=flat-square) | [![Nuget](https://img.shields.io/nuget/v/Vanara.PInvoke.UserEnv?label=%20&logo=nuget&style=flat-square)![Nuget](https://img.shields.io/nuget/dt/Vanara.PInvoke.UserEnv?label=%20&style=flat-square)](https://www.nuget.org/packages/Vanara.PInvoke.UserEnv)
usp10.dll | [Vanara.PInvoke.Usp10](https://github.com/dahall/Vanara/blob/master/PInvoke/Usp10/readme.md) | ![Coverage](https://img.shields.io/badge/100%25-green.svg?style=flat-square) | [![Nuget](https://img.shields.io/nuget/v/Vanara.PInvoke.Usp10?label=%20&logo=nuget&style=flat-square)![Nuget](https://img.shields.io/nuget/dt/Vanara.PInvoke.Usp10?label=%20&style=flat-square)](https://www.nuget.org/packages/Vanara.PInvoke.Usp10)
uxtheme.dll | [Vanara.PInvoke.UxTheme](https://github.com/dahall/Vanara/blob/master/PInvoke/UxTheme/readme.md) | ![Coverage](https://img.shields.io/badge/100%25-green.svg?style=flat-square) | [![Nuget](https://img.shields.io/nuget/v/Vanara.PInvoke.UxTheme?label=%20&logo=nuget&style=flat-square)![Nuget](https://img.shields.io/nuget/dt/Vanara.PInvoke.UxTheme?label=%20&style=flat-square)](https://www.nuget.org/packages/Vanara.PInvoke.UxTheme)
Version.dll | [Vanara.PInvoke.Version](https://github.com/dahall/Vanara/blob/master/PInvoke/Version/readme.md) | ![Coverage](https://img.shields.io/badge/100%25-green.svg?style=flat-square) | [![Nuget](https://img.shields.io/nuget/v/Vanara.PInvoke.Version?label=%20&logo=nuget&style=flat-square)![Nuget](https://img.shields.io/nuget/dt/Vanara.PInvoke.Version?label=%20&style=flat-square)](https://www.nuget.org/packages/Vanara.PInvoke.Version)
virtdisk.dll | [Vanara.PInvoke.VirtDisk](https://github.com/dahall/Vanara/blob/master/PInvoke/VirtDisk/readme.md) | ![Coverage](https://img.shields.io/badge/100%25-green.svg?style=flat-square) | [![Nuget](https://img.shields.io/nuget/v/Vanara.PInvoke.VirtDisk?label=%20&logo=nuget&style=flat-square)![Nuget](https://img.shields.io/nuget/dt/Vanara.PInvoke.VirtDisk?label=%20&style=flat-square)](https://www.nuget.org/packages/Vanara.PInvoke.VirtDisk)
vssapi.dll | [Vanara.PInvoke.VssApi](https://github.com/dahall/Vanara/blob/master/PInvoke/VssApi/readme.md) | ![Coverage](https://img.shields.io/badge/100%25-green.svg?style=flat-square) | [![Nuget](https://img.shields.io/nuget/v/Vanara.PInvoke.VssApi?label=%20&logo=nuget&style=flat-square)![Nuget](https://img.shields.io/nuget/dt/Vanara.PInvoke.VssApi?label=%20&style=flat-square)](https://www.nuget.org/packages/Vanara.PInvoke.VssApi)
WcmApi.dll | [Vanara.PInvoke.WcmApi](https://github.com/dahall/Vanara/blob/master/PInvoke/WcmApi/readme.md) | ![Coverage](https://img.shields.io/badge/100%25-green.svg?style=flat-square) | [![Nuget](https://img.shields.io/nuget/v/Vanara.PInvoke.WcmApi?label=%20&logo=nuget&style=flat-square)![Nuget](https://img.shields.io/nuget/dt/Vanara.PInvoke.WcmApi?label=%20&style=flat-square)](https://www.nuget.org/packages/Vanara.PInvoke.WcmApi)
wcnapi.dll | [Vanara.PInvoke.WcnApi](https://github.com/dahall/Vanara/blob/master/PInvoke/WcnApi/readme.md) | ![Coverage](https://img.shields.io/badge/100%25-green.svg?style=flat-square) | [![Nuget](https://img.shields.io/nuget/v/Vanara.PInvoke.WcnApi?label=%20&logo=nuget&style=flat-square)![Nuget](https://img.shields.io/nuget/dt/Vanara.PInvoke.WcnApi?label=%20&style=flat-square)](https://www.nuget.org/packages/Vanara.PInvoke.WcnApi)
websocket.dll | [Vanara.PInvoke.WebSocket](https://github.com/dahall/Vanara/blob/master/PInvoke/WebSocket/readme.md) | ![Coverage](https://img.shields.io/badge/100%25-green.svg?style=flat-square) | [![Nuget](https://img.shields.io/nuget/v/Vanara.PInvoke.WebSocket?label=%20&logo=nuget&style=flat-square)![Nuget](https://img.shields.io/nuget/dt/Vanara.PInvoke.WebSocket?label=%20&style=flat-square)](https://www.nuget.org/packages/Vanara.PInvoke.WebSocket)
wer.dll | [Vanara.PInvoke.Wer](https://github.com/dahall/Vanara/blob/master/PInvoke/Wer/readme.md) | ![Coverage](https://img.shields.io/badge/100%25-green.svg?style=flat-square) | [![Nuget](https://img.shields.io/nuget/v/Vanara.PInvoke.Wer?label=%20&logo=nuget&style=flat-square)![Nuget](https://img.shields.io/nuget/dt/Vanara.PInvoke.Wer?label=%20&style=flat-square)](https://www.nuget.org/packages/Vanara.PInvoke.Wer)
WinBio.dll | [Vanara.PInvoke.WinBio](https://github.com/dahall/Vanara/blob/master/PInvoke/WinBio/readme.md) | ![Coverage](https://img.shields.io/badge/100%25-green.svg?style=flat-square) | [![Nuget](https://img.shields.io/nuget/v/Vanara.PInvoke.WinBio?label=%20&logo=nuget&style=flat-square)![Nuget](https://img.shields.io/nuget/dt/Vanara.PInvoke.WinBio?label=%20&style=flat-square)](https://www.nuget.org/packages/Vanara.PInvoke.WinBio)
winhttp.dll | [Vanara.PInvoke.WinHTTP](https://github.com/dahall/Vanara/blob/master/PInvoke/WinHTTP/readme.md) | ![Coverage](https://img.shields.io/badge/100%25-green.svg?style=flat-square) | [![Nuget](https://img.shields.io/nuget/v/Vanara.PInvoke.WinHTTP?label=%20&logo=nuget&style=flat-square)![Nuget](https://img.shields.io/nuget/dt/Vanara.PInvoke.WinHTTP?label=%20&style=flat-square)](https://www.nuget.org/packages/Vanara.PInvoke.WinHTTP)
wininet.dll | [Vanara.PInvoke.WinINet](https://github.com/dahall/Vanara/blob/master/PInvoke/WinINet/readme.md) | ![Coverage](https://img.shields.io/badge/100%25-green.svg?style=flat-square) | [![Nuget](https://img.shields.io/nuget/v/Vanara.PInvoke.WinINet?label=%20&logo=nuget&style=flat-square)![Nuget](https://img.shields.io/nuget/dt/Vanara.PInvoke.WinINet?label=%20&style=flat-square)](https://www.nuget.org/packages/Vanara.PInvoke.WinINet)
winscard.dll | [Vanara.PInvoke.WinSCard](https://github.com/dahall/Vanara/blob/master/PInvoke/WinSCard/readme.md) | ![Coverage](https://img.shields.io/badge/100%25-green.svg?style=flat-square) | [![Nuget](https://img.shields.io/nuget/v/Vanara.PInvoke.WinSCard?label=%20&logo=nuget&style=flat-square)![Nuget](https://img.shields.io/nuget/dt/Vanara.PInvoke.WinSCard?label=%20&style=flat-square)](https://www.nuget.org/packages/Vanara.PInvoke.WinSCard)
winspool.drv, prntvpt.dll | [Vanara.PInvoke.Printing](https://github.com/dahall/Vanara/blob/master/PInvoke/Printing/readme.md) | ![Coverage](https://img.shields.io/badge/100%25-green.svg?style=flat-square) | [![Nuget](https://img.shields.io/nuget/v/Vanara.PInvoke.Printing?label=%20&logo=nuget&style=flat-square)![Nuget](https://img.shields.io/nuget/dt/Vanara.PInvoke.Printing?label=%20&style=flat-square)](https://www.nuget.org/packages/Vanara.PInvoke.Printing)
wintrust.dll | [Vanara.PInvoke.WinTrust](https://github.com/dahall/Vanara/blob/master/PInvoke/WinTrust/readme.md) | ![Coverage](https://img.shields.io/badge/100%25-green.svg?style=flat-square) | [![Nuget](https://img.shields.io/nuget/v/Vanara.PInvoke.WinTrust?label=%20&logo=nuget&style=flat-square)![Nuget](https://img.shields.io/nuget/dt/Vanara.PInvoke.WinTrust?label=%20&style=flat-square)](https://www.nuget.org/packages/Vanara.PInvoke.WinTrust)
WlanApi.dll, Wlanui.dll | [Vanara.PInvoke.WlanApi](https://github.com/dahall/Vanara/blob/master/PInvoke/WlanApi/readme.md) | ![Coverage](https://img.shields.io/badge/100%25-green.svg?style=flat-square) | [![Nuget](https://img.shields.io/nuget/v/Vanara.PInvoke.WlanApi?label=%20&logo=nuget&style=flat-square)![Nuget](https://img.shields.io/nuget/dt/Vanara.PInvoke.WlanApi?label=%20&style=flat-square)](https://www.nuget.org/packages/Vanara.PInvoke.WlanApi)
ws2_32.dll | [Vanara.PInvoke.Ws2_32](https://github.com/dahall/Vanara/blob/master/PInvoke/Ws2_32/readme.md) | ![Coverage](https://img.shields.io/badge/100%25-green.svg?style=flat-square) | [![Nuget](https://img.shields.io/nuget/v/Vanara.PInvoke.Ws2_32?label=%20&logo=nuget&style=flat-square)![Nuget](https://img.shields.io/nuget/dt/Vanara.PInvoke.Ws2_32?label=%20&style=flat-square)](https://www.nuget.org/packages/Vanara.PInvoke.Ws2_32)
wscapi.dll | [Vanara.PInvoke.WscApi](https://github.com/dahall/Vanara/blob/master/PInvoke/WscApi/readme.md) | ![Coverage](https://img.shields.io/badge/100%25-green.svg?style=flat-square) | [![Nuget](https://img.shields.io/nuget/v/Vanara.PInvoke.WscApi?label=%20&logo=nuget&style=flat-square)![Nuget](https://img.shields.io/nuget/dt/Vanara.PInvoke.WscApi?label=%20&style=flat-square)](https://www.nuget.org/packages/Vanara.PInvoke.WscApi)
wslapi.dll | [Vanara.PInvoke.WslApi](https://github.com/dahall/Vanara/blob/master/PInvoke/WslApi/readme.md) | ![Coverage](https://img.shields.io/badge/100%25-green.svg?style=flat-square) | [![Nuget](https://img.shields.io/nuget/v/Vanara.PInvoke.WslApi?label=%20&logo=nuget&style=flat-square)![Nuget](https://img.shields.io/nuget/dt/Vanara.PInvoke.WslApi?label=%20&style=flat-square)](https://www.nuget.org/packages/Vanara.PInvoke.WslApi)
WsmSvc.dll | [Vanara.PInvoke.WsmSvc](https://github.com/dahall/Vanara/blob/master/PInvoke/WsmSvc/readme.md) | ![Coverage](https://img.shields.io/badge/100%25-green.svg?style=flat-square) | [![Nuget](https://img.shields.io/nuget/v/Vanara.PInvoke.WsmSvc?label=%20&logo=nuget&style=flat-square)![Nuget](https://img.shields.io/nuget/dt/Vanara.PInvoke.WsmSvc?label=%20&style=flat-square)](https://www.nuget.org/packages/Vanara.PInvoke.WsmSvc)
WTSApi32.dll | [Vanara.PInvoke.WTSApi32](https://github.com/dahall/Vanara/blob/master/PInvoke/WTSApi32/readme.md) | ![Coverage](https://img.shields.io/badge/100%25-green.svg?style=flat-square) | [![Nuget](https://img.shields.io/nuget/v/Vanara.PInvoke.WTSApi32?label=%20&logo=nuget&style=flat-square)![Nuget](https://img.shields.io/nuget/dt/Vanara.PInvoke.WTSApi32?label=%20&style=flat-square)](https://www.nuget.org/packages/Vanara.PInvoke.WTSApi32)
wuapi.dll | [Vanara.PInvoke.WUApi](https://github.com/dahall/Vanara/blob/master/PInvoke/WUApi/readme.md) | ![Coverage](https://img.shields.io/badge/100%25-green.svg?style=flat-square) | [![Nuget](https://img.shields.io/nuget/v/Vanara.PInvoke.WUApi?label=%20&logo=nuget&style=flat-square)![Nuget](https://img.shields.io/nuget/dt/Vanara.PInvoke.WUApi?label=%20&style=flat-square)](https://www.nuget.org/packages/Vanara.PInvoke.WUApi)

## Supporting Assemblies

Assembly | &nbsp;&nbsp;&nbsp;NuGet&nbsp;Link&nbsp;&nbsp;&nbsp; | Description
--- | --- | --- 
[Vanara.BITS](https://github.com/dahall/Vanara/blob/master/BITS/readme.md) | [![Nuget](https://img.shields.io/nuget/v/Vanara.BITS?label=%20&logo=nuget&style=flat-square)![Nuget](https://img.shields.io/nuget/dt/Vanara.BITS?label=%20&style=flat-square)](https://www.nuget.org/packages/Vanara.BITS) | Complete .NET coverage of Windows BITS (Background Intelligent Transfer Service) functionality. Provides access to all library functions through Windows 11 and gracefully fails when new features are not available on older OS versions.
[Vanara.Core](https://github.com/dahall/Vanara/blob/master/Core/readme.md) | [![Nuget](https://img.shields.io/nuget/v/Vanara.Core?label=%20&logo=nuget&style=flat-square)![Nuget](https://img.shields.io/nuget/dt/Vanara.Core?label=%20&style=flat-square)](https://www.nuget.org/packages/Vanara.Core) | This library includes shared methods, structures and constants for use throughout the Vanara assemblies. Think of it as windows.h with some useful extensions. It includes:<br><ul><li>Extension methods for working with enumerated types (enum), FILETIME, and method and property extractions via reflection</li><li>Extension and helper methods to marshaling structures arrays and strings</li><li>SafeHandle based classes for working with memory allocated via CoTaskMem, HGlobal, or Local calls that handles packing and extracting arrays, structures and raw memory</li><li>Safe pinning of objects in memory</li><li>Memory stream based on marshaled memory</li></ul>
[Vanara.DirectoryServices](https://github.com/dahall/Vanara/blob/master/DirectoryServices/readme.md) | [![Nuget](https://img.shields.io/nuget/v/Vanara.DirectoryServices?label=%20&logo=nuget&style=flat-square)![Nuget](https://img.shields.io/nuget/dt/Vanara.DirectoryServices?label=%20&style=flat-square)](https://www.nuget.org/packages/Vanara.DirectoryServices) | Wrapper classes around Win32 ADs methods and interfaces to provide simplified and object-oriented access to Active Directory and other directory service calls.
[Vanara.Management](https://github.com/dahall/Vanara/blob/master/Management/readme.md) | [![Nuget](https://img.shields.io/nuget/v/Vanara.Management?label=%20&logo=nuget&style=flat-square)![Nuget](https://img.shields.io/nuget/dt/Vanara.Management?label=%20&style=flat-square)](https://www.nuget.org/packages/Vanara.Management) | Extensions and helper classes for System.Management.
[Vanara.Net](https://github.com/dahall/Vanara/blob/master/Net/readme.md) | [![Nuget](https://img.shields.io/nuget/v/Vanara.Net?label=%20&logo=nuget&style=flat-square)![Nuget](https://img.shields.io/nuget/dt/Vanara.Net?label=%20&style=flat-square)](https://www.nuget.org/packages/Vanara.Net) | Abstracted classes around Win32 networking functions to provide simplified and object-oriented access to key networking capabilities like DNS, DHCP, filtering, access, and discovery.
[Vanara.PInvoke.DirectX](https://github.com/dahall/Vanara/blob/master/PInvoke/DirectX/readme.md) | [![Nuget](https://img.shields.io/nuget/v/Vanara.PInvoke.DirectX?label=%20&logo=nuget&style=flat-square)![Nuget](https://img.shields.io/nuget/dt/Vanara.PInvoke.DirectX?label=%20&style=flat-square)](https://www.nuget.org/packages/Vanara.PInvoke.DirectX) | PInvoke API (methods, interfaces, structures and constants) imported from DirectX.
[Vanara.PInvoke.DirectXMath](https://github.com/dahall/Vanara/blob/master/PInvoke/DirectXMath/readme.md) | [![Nuget](https://img.shields.io/nuget/v/Vanara.PInvoke.DirectXMath?label=%20&logo=nuget&style=flat-square)![Nuget](https://img.shields.io/nuget/dt/Vanara.PInvoke.DirectXMath?label=%20&style=flat-square)](https://www.nuget.org/packages/Vanara.PInvoke.DirectXMath) | PInvoke API (methods, structures and constants) imported from Windows DirectX Math.
[Vanara.PInvoke.Shared](https://github.com/dahall/Vanara/blob/master/PInvoke/Shared/readme.md) | [![Nuget](https://img.shields.io/nuget/v/Vanara.PInvoke.Shared?label=%20&logo=nuget&style=flat-square)![Nuget](https://img.shields.io/nuget/dt/Vanara.PInvoke.Shared?label=%20&style=flat-square)](https://www.nuget.org/packages/Vanara.PInvoke.Shared) | Shared methods, structures and constants for use throughout the Vanara.PInvoke assemblies. Includes:<br><ul><li>IEnumerable helpers for COM enumerations</li><li>Custom marshaler for CoTaskMem pointers</li><li>Enhanced error results classes for HRESULT, Win32Error and NTStatus</li><li>Standard windows.h macros (e.g. HIWORD, MAKELONG, etc.)</li><li>Overlapped method wrapper</li><li>Resource ID holder</li><li>Shared structures and enums (see release notes)</li></ul>
[Vanara.PInvoke.SpellCheckingApi](https://github.com/dahall/Vanara/blob/master/PInvoke/SpellCheckingApi/readme.md) | [![Nuget](https://img.shields.io/nuget/v/Vanara.PInvoke.SpellCheckingApi?label=%20&logo=nuget&style=flat-square)![Nuget](https://img.shields.io/nuget/dt/Vanara.PInvoke.SpellCheckingApi?label=%20&style=flat-square)](https://www.nuget.org/packages/Vanara.PInvoke.SpellCheckingApi) | PInvoke API (methods, structures and constants) imported from Windows Spell Checking API.
[Vanara.Security](https://github.com/dahall/Vanara/blob/master/Security/readme.md) | [![Nuget](https://img.shields.io/nuget/v/Vanara.Security?label=%20&logo=nuget&style=flat-square)![Nuget](https://img.shields.io/nuget/dt/Vanara.Security?label=%20&style=flat-square)](https://www.nuget.org/packages/Vanara.Security) | Classes for security related items derived from the Vanara PInvoke libraries. Includes extension methods for Active Directory and access control classes, methods for working with accounts, UAC, privileges, system access, impersonation and SIDs, and a full LSA wrapper.
[Vanara.SystemServices](https://github.com/dahall/Vanara/blob/master/System/readme.md) | [![Nuget](https://img.shields.io/nuget/v/Vanara.SystemServices?label=%20&logo=nuget&style=flat-square)![Nuget](https://img.shields.io/nuget/dt/Vanara.SystemServices?label=%20&style=flat-square)](https://www.nuget.org/packages/Vanara.SystemServices) | Classes for system related items derived from the Vanara PInvoke libraries. Includes extensions for Process (privileges and elavation), FileInfo (compression info), Shared Network Drives and Devices, and ServiceController (SetStartType) that pull extended information through native API calls.
[Vanara.VirtualDisk](https://github.com/dahall/Vanara/blob/master/VirtualDisk/readme.md) | [![Nuget](https://img.shields.io/nuget/v/Vanara.VirtualDisk?label=%20&logo=nuget&style=flat-square)![Nuget](https://img.shields.io/nuget/dt/Vanara.VirtualDisk?label=%20&style=flat-square)](https://www.nuget.org/packages/Vanara.VirtualDisk) | .NET classes to manage Windows Virtual Storage (VHD and VHDX) using P/Invoke functions from VirtDisk.dll.
[Vanara.Windows.Extensions](https://github.com/dahall/Vanara/blob/master/Windows.Extensions/readme.md) | [![Nuget](https://img.shields.io/nuget/v/Vanara.Windows.Extensions?label=%20&logo=nuget&style=flat-square)![Nuget](https://img.shields.io/nuget/dt/Vanara.Windows.Extensions?label=%20&style=flat-square)](https://www.nuget.org/packages/Vanara.Windows.Extensions) | Extension methods and conversions from Vanara P/Invoke types and methods to Windows Forms types and methods.
[Vanara.Windows.Forms](https://github.com/dahall/Vanara/blob/master/Windows.Forms/readme.md) | [![Nuget](https://img.shields.io/nuget/v/Vanara.Windows.Forms?label=%20&logo=nuget&style=flat-square)![Nuget](https://img.shields.io/nuget/dt/Vanara.Windows.Forms?label=%20&style=flat-square)](https://www.nuget.org/packages/Vanara.Windows.Forms) | Classes for user interface related items derived from the Vanara PInvoke libraries. Includes extensions for almost all common controls to give post Vista capabilities, WinForms controls (panel, commandlink, enhanced combo boxes, IPAddress, split button, trackbar and themed controls), shutdown/restart/lock control, buffered painting, resource files, access control editor, simplifed designer framework for Windows.Forms.
[Vanara.Windows.Shell.Common](https://github.com/dahall/Vanara/blob/master/Windows.Shell.Common/readme.md) | [![Nuget](https://img.shields.io/nuget/v/Vanara.Windows.Shell.Common?label=%20&logo=nuget&style=flat-square)![Nuget](https://img.shields.io/nuget/dt/Vanara.Windows.Shell.Common?label=%20&style=flat-square)](https://www.nuget.org/packages/Vanara.Windows.Shell.Common) | Common classes for Windows Shell items derived from the Vanara PInvoke libraries. Includes shell items, files, icons, links, and taskbar lists.
[Vanara.Windows.Shell](https://github.com/dahall/Vanara/blob/master/Windows.Shell/readme.md) | [![Nuget](https://img.shields.io/nuget/v/Vanara.Windows.Shell?label=%20&logo=nuget&style=flat-square)![Nuget](https://img.shields.io/nuget/dt/Vanara.Windows.Shell?label=%20&style=flat-square)](https://www.nuget.org/packages/Vanara.Windows.Shell) | Classes for Windows Shell items derived from the Vanara PInvoke libraries. Includes shell items, files, icons, links, and taskbar lists.
[Vanara.WinUI.Extensions](https://github.com/dahall/Vanara/blob/master/WinUI.Extensions/readme.md) | [![Nuget](https://img.shields.io/nuget/v/Vanara.WinUI.Extensions?label=%20&logo=nuget&style=flat-square)![Nuget](https://img.shields.io/nuget/dt/Vanara.WinUI.Extensions?label=%20&style=flat-square)](https://www.nuget.org/packages/Vanara.WinUI.Extensions) | Extension methods and conversions from Vanara P/Invoke types and methods to UWP and WinUI types and methods.
[Vanara.WPF.Extensions](https://github.com/dahall/Vanara/blob/master/WPF.Extensions/readme.md) | [![Nuget](https://img.shields.io/nuget/v/Vanara.WPF.Extensions?label=%20&logo=nuget&style=flat-square)![Nuget](https://img.shields.io/nuget/dt/Vanara.WPF.Extensions?label=%20&style=flat-square)](https://www.nuget.org/packages/Vanara.WPF.Extensions) | Extension methods and conversions from Vanara P/Invoke types and methods to WPF types and methods.

## Quick Links
* [Documentation](https://github.com/dahall/Vanara/wiki)
* [Issues](https://github.com/dahall/Vanara/issues)

## Sample Code
There are numerous examples in the [UnitTest](https://github.com/dahall/Vanara/tree/master/UnitTests) folder and in the [WinClassicSamplesCS](https://github.com/dahall/WinClassicSamplesCS) project that recreates the Windows Samples in C# using Vanara.
