## Assembly report for Vanara.PInvoke.Shared.dll
Shared methods, structures and constants for use throughout the Vanara.PInvoke assemblies. Includes:
* IEnumerable helpers for COM enumerations
* Custom marshaler for CoTaskMem pointers
* Enhanced error results classes for HRESULT, Win32Error and NTStatus
* Standard windows.h macros (e.g. HIWORD, MAKELONG, etc.)
* Overlapped method wrapper
* Resource ID holder
* Shared structures and enums (see release notes)
### Enumerations
Enum | Description | Values
---- | ---- | ----
[Vanara.PInvoke.CharacterSet](https://github.com/dahall/Vanara/search?l=C%23&q=CharacterSet) | The character set. | ANSI_CHARSET, DEFAULT_CHARSET, SYMBOL_CHARSET, MAC_CHARSET, SHIFTJIS_CHARSET, HANGEUL_CHARSET, HANGUL_CHARSET, JOHAB_CHARSET, GB2312_CHARSET, CHINESEBIG5_CHARSET, GREEK_CHARSET, TURKISH_CHARSET, VIETNAMESE_CHARSET, HEBREW_CHARSET, ARABIC_CHARSET, BALTIC_CHARSET, RUSSIAN_CHARSET, THAI_CHARSET, EASTEUROPE_CHARSET, OEM_CHARSET
[Vanara.PInvoke.CM_DEVCAP](https://github.com/dahall/Vanara/search?l=C%23&q=CM_DEVCAP) |  | CM_DEVCAP_LOCKSUPPORTED, CM_DEVCAP_EJECTSUPPORTED, CM_DEVCAP_REMOVABLE, CM_DEVCAP_DOCKDEVICE, CM_DEVCAP_UNIQUEID, CM_DEVCAP_SILENTINSTALL, CM_DEVCAP_RAWDEVICEOK, CM_DEVCAP_SURPRISEREMOVALOK, CM_DEVCAP_HARDWAREDISABLED, CM_DEVCAP_NONDYNAMIC, CM_DEVCAP_SECUREDEVICE
[Vanara.PInvoke.CM_FILE](https://github.com/dahall/Vanara/search?l=C%23&q=CM_FILE) | Specifies characteristics for the device. | FILE_REMOVABLE_MEDIA, FILE_READ_ONLY_DEVICE, FILE_FLOPPY_DISKETTE, FILE_WRITE_ONCE_MEDIA, FILE_REMOTE_DEVICE, FILE_DEVICE_IS_MOUNTED, FILE_VIRTUAL_VOLUME, FILE_AUTOGENERATED_DEVICE_NAME, FILE_DEVICE_SECURE_OPEN, FILE_CHARACTERISTIC_PNP_DEVICE, FILE_CHARACTERISTIC_TS_DEVICE, FILE_CHARACTERISTIC_WEBDAV_DEVICE, FILE_CHARACTERISTIC_CSV, FILE_DEVICE_ALLOW_APPCONTAINER_TRAVERSAL, FILE_PORTABLE_DEVICE
[Vanara.PInvoke.CM_INSTALL_STATE](https://github.com/dahall/Vanara/search?l=C%23&q=CM_INSTALL_STATE) |  | CM_INSTALL_STATE_INSTALLED, CM_INSTALL_STATE_NEEDS_REINSTALL, CM_INSTALL_STATE_FAILED_INSTALL, CM_INSTALL_STATE_FINISH_INSTALL
[Vanara.PInvoke.CM_REMOVAL_POLICY](https://github.com/dahall/Vanara/search?l=C%23&q=CM_REMOVAL_POLICY) |  | CM_REMOVAL_POLICY_EXPECT_NO_REMOVAL, CM_REMOVAL_POLICY_EXPECT_ORDERLY_REMOVAL, CM_REMOVAL_POLICY_EXPECT_SURPRISE_REMOVAL
[Vanara.PInvoke.CM_RESOURCE](https://github.com/dahall/Vanara/search?l=C%23&q=CM_RESOURCE) | Contains flag bits that are specific to the resource type, as indicated in the following table. Flags can be bitwise-ORed together as appropriate. | CM_RESOURCE_INTERRUPT_LEVEL_SENSITIVE, DMAV3_TRANFER_WIDTH_8, CM_RESOURCE_DMA_8, CM_RESOURCE_MEMORY_READ_WRITE, CM_RESOURCE_PORT_MEMORY, CM_RESOURCE_CONNECTION_TYPE_SERIAL_I2C, CM_RESOURCE_CONNECTION_CLASS_GPIO, DMAV3_TRANFER_WIDTH_16, CM_RESOURCE_DMA_16, CM_RESOURCE_PORT_IO, CM_RESOURCE_CONNECTION_TYPE_FUNCTION_CONFIG, CM_RESOURCE_INTERRUPT_LEVEL_LATCHED_BITS, CM_RESOURCE_INTERRUPT_LATCHED, CM_RESOURCE_MEMORY_READ_ONLY, CM_RESOURCE_CONNECTION_TYPE_SERIAL_SPI, CM_RESOURCE_CONNECTION_TYPE_GPIO_IO, CM_RESOURCE_CONNECTION_CLASS_SERIAL, CM_RESOURCE_INTERRUPT_MESSAGE, DMAV3_TRANFER_WIDTH_32, CM_RESOURCE_DMA_32, CM_RESOURCE_MEMORY_WRITE_ONLY, CM_RESOURCE_CONNECTION_CLASS_FUNCTION_CONFIG, DMAV3_TRANFER_WIDTH_64, CM_RESOURCE_CONNECTION_TYPE_SERIAL_UART, CM_RESOURCE_MEMORY_WRITEABILITY_MASK, CM_RESOURCE_PORT_10_BIT_DECODE, CM_RESOURCE_MEMORY_PREFETCHABLE, DMAV3_TRANFER_WIDTH_128, CM_RESOURCE_INTERRUPT_POLICY_INCLUDED, CM_RESOURCE_DMA_8_AND_16, DMAV3_TRANFER_WIDTH_256, CM_RESOURCE_PORT_12_BIT_DECODE, CM_RESOURCE_MEMORY_COMBINEDWRITE, CM_RESOURCE_DMA_BUS_MASTER, CM_RESOURCE_MEMORY_24, CM_RESOURCE_INTERRUPT_SECONDARY_INTERRUPT, CM_RESOURCE_DMA_TYPE_A, CM_RESOURCE_PORT_16_BIT_DECODE, CM_RESOURCE_DMA_TYPE_B, CM_RESOURCE_PORT_POSITIVE_DECODE, CM_RESOURCE_INTERRUPT_WAKE_HINT, CM_RESOURCE_MEMORY_CACHEABLE, CM_RESOURCE_PORT_PASSIVE_DECODE, CM_RESOURCE_MEMORY_WINDOW_DECODE, CM_RESOURCE_DMA_TYPE_F, CM_RESOURCE_MEMORY_BAR, CM_RESOURCE_DMA_V3, CM_RESOURCE_PORT_WINDOW_DECODE, CM_RESOURCE_PORT_BAR, CM_RESOURCE_MEMORY_COMPAT_FOR_INACCESSIBLE_RANGE, CM_RESOURCE_MEMORY_LARGE_40, CM_RESOURCE_MEMORY_LARGE_48, CM_RESOURCE_MEMORY_LARGE_64, CM_RESOURCE_MEMORY_LARGE, CM_RESOURCE_INTERRUPT_MESSAGE_TOKEN
[Vanara.PInvoke.CM_SHARE_DISPOSITION](https://github.com/dahall/Vanara/search?l=C%23&q=CM_SHARE_DISPOSITION) | Indicates whether the described resource can be shared. | CmResourceShareUndetermined, CmResourceShareDeviceExclusive, CmResourceShareDriverExclusive, CmResourceShareShared
[Vanara.PInvoke.CmResourceType](https://github.com/dahall/Vanara/search?l=C%23&q=CmResourceType) | Identifies the resource type. The constant value specified for Type indicates which structure within the u union is valid, as indicated in the following table. (These flags are used within both CM_PARTIAL_RESOURCE_DESCRIPTOR and IO_RESOURCE_DESCRIPTOR structures, except where noted.) | CmResourceTypeNull, CmResourceTypePort, CmResourceTypeInterrupt, CmResourceTypeMemory, CmResourceTypeDma, CmResourceTypeDeviceSpecific, CmResourceTypeBusNumber, CmResourceTypeMemoryLarge, CmResourceTypeNonArbitrated, CmResourceTypeConfigData, CmResourceTypeDevicePrivate, CmResourceTypePcCardConfig, CmResourceTypeMfCardConfig, CmResourceTypeConnection
[Vanara.PInvoke.CONFIGFLAG](https://github.com/dahall/Vanara/search?l=C%23&q=CONFIGFLAG) | A device's configuration flags | CONFIGFLAG_DISABLED, CONFIGFLAG_REMOVED, CONFIGFLAG_MANUAL_INSTALL, CONFIGFLAG_IGNORE_BOOT_LC, CONFIGFLAG_NET_BOOT, CONFIGFLAG_REINSTALL, CONFIGFLAG_FAILEDINSTALL, CONFIGFLAG_CANTSTOPACHILD, CONFIGFLAG_OKREMOVEROM, CONFIGFLAG_NOREMOVEEXIT, CONFIGFLAG_FINISH_INSTALL, CONFIGFLAG_NEEDS_FORCED_CONFIG, CONFIGFLAG_NETBOOT_CARD, CONFIGFLAG_PARTIAL_LOG_CONF, CONFIGFLAG_SUPPRESS_SURPRISE, CONFIGFLAG_VERIFY_HARDWARE, CONFIGFLAG_FINISHINSTALL_UI, CONFIGFLAG_FINISHINSTALL_ACTION, CONFIGFLAG_BOOT_DEVICE, CONFIGFLAG_NEEDS_CLASS_CONFIG
[Vanara.PInvoke.DEVICE_POWER_STATE](https://github.com/dahall/Vanara/search?l=C%23&q=DEVICE_POWER_STATE) | The <c>DEVICE_POWER_STATE</c> enumeration type indicates a device power state. | PowerDeviceUnspecified, PowerDeviceD0, PowerDeviceD1, PowerDeviceD2, PowerDeviceD3, PowerDeviceMaximum
[Vanara.PInvoke.DEVICE_SCALE_FACTOR](https://github.com/dahall/Vanara/search?l=C%23&q=DEVICE_SCALE_FACTOR) | Indicates a spoofed device scale factor, as a percent. Used by IApplicationDesignModeSettings::SetApplicationViewState and IApplicationDesignModeSettings::IsApplicationViewStateSupported | DEVICE_SCALE_FACTOR_INVALID, SCALE_100_PERCENT, SCALE_120_PERCENT, SCALE_125_PERCENT, SCALE_140_PERCENT, SCALE_150_PERCENT, SCALE_160_PERCENT, SCALE_175_PERCENT, SCALE_180_PERCENT, SCALE_200_PERCENT, SCALE_225_PERCENT, SCALE_250_PERCENT, SCALE_300_PERCENT, SCALE_350_PERCENT, SCALE_400_PERCENT, SCALE_450_PERCENT, SCALE_500_PERCENT
[Vanara.PInvoke.DMCOLLATE](https://github.com/dahall/Vanara/search?l=C%23&q=DMCOLLATE) | Specifies whether collation should be used when printing multiple copies. | DMCOLLATE_FALSE, DMCOLLATE_TRUE
[Vanara.PInvoke.DMCOLOR](https://github.com/dahall/Vanara/search?l=C%23&q=DMCOLOR) | The printer color. | DMCOLOR_MONOCHROME, DMCOLOR_COLOR
[Vanara.PInvoke.DMDFO](https://github.com/dahall/Vanara/search?l=C%23&q=DMDFO) | How the display presents a low-resolution mode on a higher-resolution display. | DMDFO_DEFAULT, DMDFO_STRETCH, DMDFO_CENTER
[Vanara.PInvoke.DMDISPLAY](https://github.com/dahall/Vanara/search?l=C%23&q=DMDISPLAY) | Specifies the device's display mode. | DM_GRAYSCALE, DM_INTERLACED, DMDISPLAYFLAGS_TEXTMODE
[Vanara.PInvoke.DMDITHER](https://github.com/dahall/Vanara/search?l=C%23&q=DMDITHER) | Specifies how dithering is to be done. | DMDITHER_NONE, DMDITHER_COARSE, DMDITHER_FINE, DMDITHER_LINEART, DMDITHER_ERRORDIFFUSION, DMDITHER_RESERVED6, DMDITHER_RESERVED7, DMDITHER_RESERVED8, DMDITHER_RESERVED9, DMDITHER_GRAYSCALE, DMDITHER_USER
[Vanara.PInvoke.DMDO](https://github.com/dahall/Vanara/search?l=C%23&q=DMDO) | The orientation at which images should be presented. | DMDO_DEFAULT, DMDO_90, DMDO_180, DMDO_270
[Vanara.PInvoke.DMDUP](https://github.com/dahall/Vanara/search?l=C%23&q=DMDUP) | Selects duplex or double-sided printing for printers capable of duplex printing. | DMDUP_UNKNOWN, DMDUP_SIMPLEX, DMDUP_VERTICAL, DMDUP_HORIZONTAL
[Vanara.PInvoke.DMFIELDS](https://github.com/dahall/Vanara/search?l=C%23&q=DMFIELDS) | Specifies whether certain members of the DEVMODE structure have been initialized. | DM_ORIENTATION, DM_PAPERSIZE, DM_PAPERLENGTH, DM_PAPERWIDTH, DM_SCALE, DM_POSITION, DM_NUP, DM_DISPLAYORIENTATION, DM_COPIES, DM_DEFAULTSOURCE, DM_PRINTQUALITY, DM_COLOR, DM_DUPLEX, DM_YRESOLUTION, DM_TTOPTION, DM_COLLATE, DM_FORMNAME, DM_LOGPIXELS, DM_BITSPERPEL, DM_PELSWIDTH, DM_PELSHEIGHT, DM_DISPLAYFLAGS, DM_DISPLAYFREQUENCY, DM_ICMMETHOD, DM_ICMINTENT, DM_MEDIATYPE, DM_DITHERTYPE, DM_PANNINGWIDTH, DM_PANNINGHEIGHT, DM_DISPLAYFIXEDOUTPUT
[Vanara.PInvoke.DMICM](https://github.com/dahall/Vanara/search?l=C%23&q=DMICM) | Specifies which color matching method, or intent, should be used by default. This member is primarily for non-ICM applications. ICM applications can establish intents by using the ICM functions. | DMICM_SATURATE, DMICM_CONTRAST, DMICM_COLORIMETRIC, DMICM_ABS_COLORIMETRIC, DMICM_USER
[Vanara.PInvoke.DMICMMETHOD](https://github.com/dahall/Vanara/search?l=C%23&q=DMICMMETHOD) | Specifies how ICM is handled. For a non-ICM application, this member determines if ICM is enabled or disabled. For ICM applications, the system examines this member to determine how to handle ICM support. | DMICMMETHOD_NONE, DMICMMETHOD_SYSTEM, DMICMMETHOD_DRIVER, DMICMMETHOD_DEVICE, DMICMMETHOD_USER
[Vanara.PInvoke.DMMEDIA](https://github.com/dahall/Vanara/search?l=C%23&q=DMMEDIA) | Specifies the type of media being printed on. | DMMEDIA_STANDARD, DMMEDIA_TRANSPARENCY, DMMEDIA_GLOSSY, DMMEDIA_USER
[Vanara.PInvoke.DMNUP](https://github.com/dahall/Vanara/search?l=C%23&q=DMNUP) | Specifies where the NUP is done. | DMNUP_SYSTEM, DMNUP_ONEUP
[Vanara.PInvoke.DMORIENT](https://github.com/dahall/Vanara/search?l=C%23&q=DMORIENT) | The orientation of the paper. | DMORIENT_PORTRAIT, DMORIENT_LANDSCAPE
[Vanara.PInvoke.DMPAPER](https://github.com/dahall/Vanara/search?l=C%23&q=DMPAPER) | The size of the paper to print on. | DMPAPER_LETTER, DMPAPER_LETTERSMALL, DMPAPER_TABLOID, DMPAPER_LEDGER, DMPAPER_LEGAL, DMPAPER_STATEMENT, DMPAPER_EXECUTIVE, DMPAPER_A3, DMPAPER_A4, DMPAPER_A4SMALL, DMPAPER_A5, DMPAPER_B4, DMPAPER_B5, DMPAPER_FOLIO, DMPAPER_QUARTO, DMPAPER_10X14, DMPAPER_11X17, DMPAPER_NOTE, DMPAPER_ENV_9, DMPAPER_ENV_10, DMPAPER_ENV_11, DMPAPER_ENV_12, DMPAPER_ENV_14, DMPAPER_CSHEET, DMPAPER_DSHEET, DMPAPER_ESHEET, DMPAPER_ENV_DL, DMPAPER_ENV_C5, DMPAPER_ENV_C3, DMPAPER_ENV_C4, DMPAPER_ENV_C6, DMPAPER_ENV_C65, DMPAPER_ENV_B4, DMPAPER_ENV_B5, DMPAPER_ENV_B6, DMPAPER_ENV_ITALY, DMPAPER_ENV_MONARCH, DMPAPER_ENV_PERSONAL, DMPAPER_FANFOLD_US, DMPAPER_FANFOLD_STD_GERMAN, DMPAPER_FANFOLD_LGL_GERMAN, DMPAPER_ISO_B4, DMPAPER_JAPANESE_POSTCARD, DMPAPER_9X11, DMPAPER_10X11, DMPAPER_15X11, DMPAPER_ENV_INVITE, DMPAPER_RESERVED_48, DMPAPER_RESERVED_49, DMPAPER_LETTER_EXTRA, DMPAPER_LEGAL_EXTRA, DMPAPER_TABLOID_EXTRA, DMPAPER_A4_EXTRA, DMPAPER_LETTER_TRANSVERSE, DMPAPER_A4_TRANSVERSE, DMPAPER_LETTER_EXTRA_TRANSVERSE, DMPAPER_A_PLUS, DMPAPER_B_PLUS, DMPAPER_LETTER_PLUS, DMPAPER_A4_PLUS, DMPAPER_A5_TRANSVERSE, DMPAPER_B5_TRANSVERSE, DMPAPER_A3_EXTRA, DMPAPER_A5_EXTRA, DMPAPER_B5_EXTRA, DMPAPER_A2, DMPAPER_A3_TRANSVERSE, DMPAPER_A3_EXTRA_TRANSVERSE, DMPAPER_DBL_JAPANESE_POSTCARD, DMPAPER_A6, DMPAPER_JENV_KAKU2, DMPAPER_JENV_KAKU3, DMPAPER_JENV_CHOU3, DMPAPER_JENV_CHOU4, DMPAPER_LETTER_ROTATED, DMPAPER_A3_ROTATED, DMPAPER_A4_ROTATED, DMPAPER_A5_ROTATED, DMPAPER_B4_JIS_ROTATED, DMPAPER_B5_JIS_ROTATED, DMPAPER_JAPANESE_POSTCARD_ROTATED, DMPAPER_DBL_JAPANESE_POSTCARD_ROTATED, DMPAPER_A6_ROTATED, DMPAPER_JENV_KAKU2_ROTATED, DMPAPER_JENV_KAKU3_ROTATED, DMPAPER_JENV_CHOU3_ROTATED, DMPAPER_JENV_CHOU4_ROTATED, DMPAPER_B6_JIS, DMPAPER_B6_JIS_ROTATED, DMPAPER_12X11, DMPAPER_JENV_YOU4, DMPAPER_JENV_YOU4_ROTATED, DMPAPER_P16K, DMPAPER_P32K, DMPAPER_P32KBIG, DMPAPER_PENV_1, DMPAPER_PENV_2, DMPAPER_PENV_3, DMPAPER_PENV_4, DMPAPER_PENV_5, DMPAPER_PENV_6, DMPAPER_PENV_7, DMPAPER_PENV_8, DMPAPER_PENV_9, DMPAPER_PENV_10, DMPAPER_P16K_ROTATED, DMPAPER_P32K_ROTATED, DMPAPER_P32KBIG_ROTATED, DMPAPER_PENV_1_ROTATED, DMPAPER_PENV_2_ROTATED, DMPAPER_PENV_3_ROTATED, DMPAPER_PENV_4_ROTATED, DMPAPER_PENV_5_ROTATED, DMPAPER_PENV_6_ROTATED, DMPAPER_PENV_7_ROTATED, DMPAPER_PENV_8_ROTATED, DMPAPER_PENV_9_ROTATED, DMPAPER_PENV_10_ROTATED, DMPAPER_USER
[Vanara.PInvoke.DMRES](https://github.com/dahall/Vanara/search?l=C%23&q=DMRES) | The printer resolution. | DMRES_HIGH, DMRES_MEDIUM, DMRES_LOW, DMRES_DRAFT
[Vanara.PInvoke.DMTT](https://github.com/dahall/Vanara/search?l=C%23&q=DMTT) | Specifies how TrueType fonts should be printed. | DMTT_BITMAP, DMTT_DOWNLOAD, DMTT_SUBDEV, DMTT_DOWNLOAD_OUTLINE
[Vanara.PInvoke.DN](https://github.com/dahall/Vanara/search?l=C%23&q=DN) | The status of a device node (devnode). | DN_ROOT_ENUMERATED, DN_DRIVER_LOADED, DN_ENUM_LOADED, DN_STARTED, DN_MANUAL, DN_NEED_TO_ENUM, DN_NOT_FIRST_TIME, DN_DRIVER_BLOCKED, DN_HARDWARE_ENUM, DN_NEED_RESTART, DN_LIAR, DN_CHILD_WITH_INVALID_ID, DN_HAS_MARK, DN_HAS_PROBLEM, DN_FILTERED, DN_MOVED, DN_LEGACY_DRIVER, DN_DISABLEABLE, DN_REMOVABLE, DN_PRIVATE_PROBLEM, DN_MF_PARENT, DN_QUERY_REMOVE_PENDING, DN_QUERY_REMOVE_ACTIVE, DN_MF_CHILD, DN_WILL_BE_REMOVED, DN_NOT_FIRST_TIMEE, DN_STOP_FREE_RES, DN_REBAL_CANDIDATE, DN_BAD_PARTIAL, DN_NT_ENUMERATOR, DN_NT_DRIVER, DN_NEEDS_LOCKING, DN_DEVICE_DISCONNECTED, DN_ARM_WAKEUP, DN_APM_ENUMERATOR, DN_APM_DRIVER, DN_SILENT_INSTALL, DN_NO_SHOW_IN_DM, DN_BOOT_LOG_PROB
[Vanara.PInvoke.DrawTextFlags](https://github.com/dahall/Vanara/search?l=C%23&q=DrawTextFlags) | The formatting options for DrawText. | DT_TOP, DT_LEFT, DT_CENTER, DT_RIGHT, DT_VCENTER, DT_BOTTOM, DT_WORDBREAK, DT_SINGLELINE, DT_EXPANDTABS, DT_TABSTOP, DT_NOCLIP, DT_EXTERNALLEADING, DT_CALCRECT, DT_NOPREFIX, DT_INTERNAL, DT_EDITCONTROL, DT_PATH_ELLIPSIS, DT_END_ELLIPSIS, DT_MODIFYSTRING, DT_RTLREADING, DT_WORD_ELLIPSIS, DT_NOFULLWIDTHCHARBREAK, DT_HIDEPREFIX, DT_PREFIXONLY
[Vanara.PInvoke.HRESULT.FacilityCode](https://github.com/dahall/Vanara/search?l=C%23&q=FacilityCode) | Enumeration of facility codes | FACILITY_NULL, FACILITY_RPC, FACILITY_DISPATCH, FACILITY_STORAGE, FACILITY_ITF, FACILITY_WIN32, FACILITY_WINDOWS, FACILITY_SECURITY, FACILITY_SSPI, FACILITY_CONTROL, FACILITY_CERT, FACILITY_INTERNET, FACILITY_MEDIASERVER, FACILITY_MSMQ, FACILITY_SETUPAPI, FACILITY_SCARD, FACILITY_COMPLUS, FACILITY_AAF, FACILITY_URT, FACILITY_ACS, FACILITY_DPLAY, FACILITY_UMI, FACILITY_SXS, FACILITY_WINDOWS_CE, FACILITY_HTTP, FACILITY_USERMODE_COMMONLOG, FACILITY_USERMODE_FILTER_MANAGER, FACILITY_BACKGROUNDCOPY, FACILITY_CONFIGURATION, FACILITY_STATE_MANAGEMENT, FACILITY_METADIRECTORY, FACILITY_WINDOWSUPDATE, FACILITY_DIRECTORYSERVICE, FACILITY_GRAPHICS, FACILITY_SHELL, FACILITY_TPM_SERVICES, FACILITY_TPM_SOFTWARE, FACILITY_PLA, FACILITY_FVE, FACILITY_FWP, FACILITY_WINRM, FACILITY_NDIS, FACILITY_USERMODE_HYPERVISOR, FACILITY_CMI, FACILITY_USERMODE_VIRTUALIZATION, FACILITY_USERMODE_VOLMGR, FACILITY_BCD, FACILITY_USERMODE_VHD, FACILITY_SDIAG, FACILITY_WEBSERVICES, FACILITY_WINDOWS_DEFENDER, FACILITY_OPC, FACILITY_XPS, FACILITY_RAS, FACILITY_MBN, FACILITY_POWERSHELL, FACILITY_EAS, FACILITY_P2P_INT, FACILITY_P2P, FACILITY_DAF, FACILITY_BLUETOOTH_ATT, FACILITY_AUDIO, FACILITY_STATEREPOSITORY, FACILITY_VISUALCPP, FACILITY_SCRIPT, FACILITY_PARSE, FACILITY_BLB, FACILITY_BLB_CLI, FACILITY_WSBAPP, FACILITY_BLBUI, FACILITY_USN, FACILITY_USERMODE_VOLSNAP, FACILITY_TIERING, FACILITY_WSB_ONLINE, FACILITY_ONLINE_ID, FACILITY_DEVICE_UPDATE_AGENT, FACILITY_DRVSERVICING, FACILITY_DLS, FACILITY_SOS, FACILITY_DEBUGGERS, FACILITY_DELIVERY_OPTIMIZATION, FACILITY_USERMODE_SPACES, FACILITY_USER_MODE_SECURITY_CORE, FACILITY_USERMODE_LICENSING, FACILITY_SPP, FACILITY_RESTORE, FACILITY_DMSERVER, FACILITY_DEPLOYMENT_SERVICES_SERVER, FACILITY_DEPLOYMENT_SERVICES_IMAGING, FACILITY_DEPLOYMENT_SERVICES_MANAGEMENT, FACILITY_DEPLOYMENT_SERVICES_UTIL, FACILITY_DEPLOYMENT_SERVICES_BINLSVC, FACILITY_DEPLOYMENT_SERVICES_PXE, FACILITY_DEPLOYMENT_SERVICES_TFTP, FACILITY_DEPLOYMENT_SERVICES_TRANSPORT_MANAGEMENT, FACILITY_DEPLOYMENT_SERVICES_DRIVER_PROVISIONING, FACILITY_DEPLOYMENT_SERVICES_MULTICAST_SERVER, FACILITY_DEPLOYMENT_SERVICES_MULTICAST_CLIENT, FACILITY_DEPLOYMENT_SERVICES_CONTENT_PROVIDER, FACILITY_LINGUISTIC_SERVICES, FACILITY_WEB, FACILITY_WEB_SOCKET, FACILITY_AUDIOSTREAMING, FACILITY_ACCELERATOR, FACILITY_MOBILE, FACILITY_SQLITE, FACILITY_UTC, FACILITY_WMAAECMA, FACILITY_WEP, FACILITY_SYNCENGINE, FACILITY_DIRECTMUSIC, FACILITY_DIRECT3D10, FACILITY_DXGI, FACILITY_DXGI_DDI, FACILITY_DIRECT3D11, FACILITY_DIRECT3D11_DEBUG, FACILITY_DIRECT3D12, FACILITY_DIRECT3D12_DEBUG, FACILITY_LEAP, FACILITY_AUDCLNT, FACILITY_WINML, FACILITY_WINCODEC_DWRITE_DWM, FACILITY_DIRECT2D, FACILITY_DEFRAG, FACILITY_USERMODE_SDBUS, FACILITY_JSCRIPT, FACILITY_XBOX, FACILITY_GAME, FACILITY_PIDGENX, FACILITY_PIX
[Vanara.PInvoke.NTStatus.FacilityCode](https://github.com/dahall/Vanara/search?l=C%23&q=FacilityCode) | Enumeration of facility codes | FACILITY_NULL, FACILITY_DEBUGGER, FACILITY_RPC_RUNTIME, FACILITY_RPC_STUBS, FACILITY_IO_ERROR_CODE, FACILITY_CODCLASS_ERROR_CODE, FACILITY_NTWIN32, FACILITY_NTCERT, FACILITY_NTSSPI, FACILITY_TERMINAL_SERVER, FACILTIY_MUI_ERROR_CODE, FACILITY_USB_ERROR_CODE, FACILITY_HID_ERROR_CODE, FACILITY_FIREWIRE_ERROR_CODE, FACILITY_CLUSTER_ERROR_CODE, FACILITY_ACPI_ERROR_CODE, FACILITY_SXS_ERROR_CODE, FACILITY_TRANSACTION, FACILITY_COMMONLOG, FACILITY_VIDEO, FACILITY_FILTER_MANAGER, FACILITY_MONITOR, FACILITY_GRAPHICS_KERNEL, FACILITY_DRIVER_FRAMEWORK, FACILITY_FVE_ERROR_CODE, FACILITY_FWP_ERROR_CODE, FACILITY_NDIS_ERROR_CODE, FACILITY_TPM, FACILITY_RTPM, FACILITY_HYPERVISOR, FACILITY_IPSEC, FACILITY_VIRTUALIZATION, FACILITY_VOLMGR, FACILITY_BCD_ERROR_CODE, FACILITY_WIN32K_NTUSER, FACILITY_WIN32K_NTGDI, FACILITY_RESUME_KEY_FILTER, FACILITY_RDBSS, FACILITY_BTH_ATT, FACILITY_SECUREBOOT, FACILITY_AUDIO_KERNEL, FACILITY_VSM, FACILITY_VOLSNAP, FACILITY_SDBUS, FACILITY_SHARED_VHDX, FACILITY_SMB, FACILITY_INTERIX, FACILITY_SPACES, FACILITY_SECURITY_CORE, FACILITY_SYSTEM_INTEGRITY, FACILITY_LICENSING, FACILITY_PLATFORM_MANIFEST, FACILITY_MAXIMUM_VALUE
[Vanara.PInvoke.FILE_DEVICE](https://github.com/dahall/Vanara/search?l=C%23&q=FILE_DEVICE) | The device type represents the type of underlying hardware for the driver. | FILE_DEVICE_BEEP, FILE_DEVICE_CD_ROM, FILE_DEVICE_CD_ROM_FILE_SYSTEM, FILE_DEVICE_CONTROLLER, FILE_DEVICE_DATALINK, FILE_DEVICE_DFS, FILE_DEVICE_DISK, FILE_DEVICE_DISK_FILE_SYSTEM, FILE_DEVICE_FILE_SYSTEM, FILE_DEVICE_INPORT_PORT, FILE_DEVICE_KEYBOARD, FILE_DEVICE_MAILSLOT, FILE_DEVICE_MIDI_IN, FILE_DEVICE_MIDI_OUT, FILE_DEVICE_MOUSE, FILE_DEVICE_MULTI_UNC_PROVIDER, FILE_DEVICE_NAMED_PIPE, FILE_DEVICE_NETWORK, FILE_DEVICE_NETWORK_BROWSER, FILE_DEVICE_NETWORK_FILE_SYSTEM, FILE_DEVICE_NULL, FILE_DEVICE_PARALLEL_PORT, FILE_DEVICE_PHYSICAL_NETCARD, FILE_DEVICE_PRINTER, FILE_DEVICE_SCANNER, FILE_DEVICE_SERIAL_MOUSE_PORT, FILE_DEVICE_SERIAL_PORT, FILE_DEVICE_SCREEN, FILE_DEVICE_SOUND, FILE_DEVICE_STREAMS, FILE_DEVICE_TAPE, FILE_DEVICE_TAPE_FILE_SYSTEM, FILE_DEVICE_TRANSPORT, FILE_DEVICE_UNKNOWN, FILE_DEVICE_VIDEO, FILE_DEVICE_VIRTUAL_DISK, FILE_DEVICE_WAVE_IN, FILE_DEVICE_WAVE_OUT, FILE_DEVICE_8042_PORT, FILE_DEVICE_NETWORK_REDIRECTOR, FILE_DEVICE_BATTERY, FILE_DEVICE_BUS_EXTENDER, FILE_DEVICE_MODEM, FILE_DEVICE_VDM, FILE_DEVICE_MASS_STORAGE, FILE_DEVICE_SMB, FILE_DEVICE_KS, FILE_DEVICE_CHANGER, FILE_DEVICE_SMARTCARD, FILE_DEVICE_ACPI, FILE_DEVICE_DVD, FILE_DEVICE_FULLSCREEN_VIDEO, FILE_DEVICE_DFS_FILE_SYSTEM, FILE_DEVICE_DFS_VOLUME, FILE_DEVICE_SERENUM, FILE_DEVICE_TERMSRV, FILE_DEVICE_KSEC, FILE_DEVICE_FIPS, FILE_DEVICE_INFINIBAND, FILE_DEVICE_VMBUS, FILE_DEVICE_CRYPT_PROVIDER, FILE_DEVICE_WPD, FILE_DEVICE_BLUETOOTH, FILE_DEVICE_MT_COMPOSITE, FILE_DEVICE_MT_TRANSPORT, FILE_DEVICE_BIOMETRIC, FILE_DEVICE_PMI, FILE_DEVICE_EHSTOR, FILE_DEVICE_DEVAPI, FILE_DEVICE_GPIO, FILE_DEVICE_USBEX, FILE_DEVICE_CONSOLE, FILE_DEVICE_NFP, FILE_DEVICE_SYSENV, FILE_DEVICE_VIRTUAL_BLOCK, FILE_DEVICE_POINT_OF_SERVICE, FILE_DEVICE_STORAGE_REPLICATION, FILE_DEVICE_TRUST_ENV, FILE_DEVICE_UCM, FILE_DEVICE_UCMTCPCI
[Vanara.PInvoke.FILE_SHARE](https://github.com/dahall/Vanara/search?l=C%23&q=FILE_SHARE) | The requested sharing mode of the file or device, which can be read, write, both, delete, all of these, or none (refer to the following table). Access requests to attributes or extended attributes are not affected by this flag. | FILE_SHARE_READ, FILE_SHARE_WRITE, FILE_SHARE_DELETE
[Vanara.PInvoke.FileFlagsAndAttributes](https://github.com/dahall/Vanara/search?l=C%23&q=FileFlagsAndAttributes) | File attributes are metadata values stored by the file system on disk and are used by the system and are available to developers via various file I/O APIs. | SECURITY_ANONYMOUS, FILE_ATTRIBUTE_READONLY, FILE_ATTRIBUTE_HIDDEN, FILE_ATTRIBUTE_SYSTEM, FILE_ATTRIBUTE_DIRECTORY, FILE_ATTRIBUTE_ARCHIVE, FILE_ATTRIBUTE_DEVICE, FILE_ATTRIBUTE_NORMAL, FILE_ATTRIBUTE_TEMPORARY, FILE_ATTRIBUTE_SPARSE_FILE, FILE_ATTRIBUTE_REPARSE_POINT, FILE_ATTRIBUTE_COMPRESSED, FILE_ATTRIBUTE_OFFLINE, FILE_ATTRIBUTE_NOT_CONTENT_INDEXED, FILE_ATTRIBUTE_ENCRYPTED, FILE_VOLUME_IS_COMPRESSED, FILE_ATTRIBUTE_INTEGRITY_STREAM, FILE_SUPPORTS_OBJECT_IDS, FILE_ATTRIBUTE_VIRTUAL, SECURITY_IDENTIFICATION, FILE_SUPPORTS_ENCRYPTION, SECURITY_IMPERSONATION, FILE_ATTRIBUTE_NO_SCRUB_DATA, SECURITY_DELEGATION, FILE_ATTRIBUTE_EA, FILE_ATTRIBUTE_RECALL_ON_OPEN, FILE_NAMED_STREAMS, SECURITY_CONTEXT_TRACKING, SECURITY_EFFECTIVE_ONLY, FILE_FLAG_FIRST_PIPE_INSTANCE, FILE_READ_ONLY_VOLUME, FILE_ATTRIBUTE_PINNED, FILE_FLAG_OPEN_NO_RECALL, FILE_SEQUENTIAL_WRITE_ONCE, SECURITY_SQOS_PRESENT, FILE_ATTRIBUTE_UNPINNED, FILE_FLAG_OPEN_REPARSE_POINT, FILE_SUPPORTS_TRANSACTIONS, FILE_SUPPORTS_HARD_LINKS, FILE_ATTRIBUTE_RECALL_ON_DATA_ACCESS, FILE_FLAG_SESSION_AWARE, FILE_SUPPORTS_EXTENDED_ATTRIBUTES, FILE_SUPPORTS_OPEN_BY_FILE_ID, FILE_FLAG_POSIX_SEMANTICS, FILE_FLAG_BACKUP_SEMANTICS, FILE_SUPPORTS_USN_JOURNAL, FILE_SUPPORTS_INTEGRITY_STREAMS, FILE_FLAG_DELETE_ON_CLOSE, FILE_FLAG_SEQUENTIAL_SCAN, FILE_SUPPORTS_BLOCK_REFCOUNTING, FILE_FLAG_RANDOM_ACCESS, FILE_SUPPORTS_SPARSE_VDL, FILE_FLAG_NO_BUFFERING, FILE_ATTRIBUTE_STRICTLY_SEQUENTIAL, FILE_DAX_VOLUME, FILE_FLAG_OVERLAPPED, FILE_SUPPORTS_GHOSTING, FILE_FLAG_WRITE_THROUGH
[Vanara.PInvoke.FontFamily](https://github.com/dahall/Vanara/search?l=C%23&q=FontFamily) | Font families describe the look of a font in a general way. They are intended for specifying fonts when the exact typeface desired is not available. | FF_DONTCARE, FF_ROMAN, FF_SWISS, FF_MODERN, FF_SCRIPT, FF_DECORATIVE
[Vanara.PInvoke.FontPitch](https://github.com/dahall/Vanara/search?l=C%23&q=FontPitch) | Specifies information about the pitch, the technology, and the family of a physical font. | DEFAULT_PITCH, FIXED_PITCH, TMPF_FIXED_PITCH, VARIABLE_PITCH, TMPF_VECTOR, TMPF_TRUETYPE, MONO_FONT, TMPF_DEVICE
[Vanara.PInvoke.INTERFACE_TYPE](https://github.com/dahall/Vanara/search?l=C%23&q=INTERFACE_TYPE) | The <c>INTERFACE_TYPE</c> enumeration indicates the bus type. | Internal, Isa, Eisa, MicroChannel, TurboChannel, PCIBus, VMEBus, NuBus, PCMCIABus, CBus, MPIBus, MPSABus, ProcessorInternal, InternalPowerBus, PNPISABus, PNPBus, Vmcs, ACPIBus, MaximumInterfaceType, InterfaceTypeUndefined
[Vanara.PInvoke.LANGID.LANG](https://github.com/dahall/Vanara/search?l=C%23&q=LANG) | Primary language identifier. | LANG_NEUTRAL, LANG_ARABIC, LANG_BULGARIAN, LANG_CATALAN, LANG_VALENCIAN, LANG_CHINESE_SIMPLIFIED, LANG_CHINESE, LANG_CZECH, LANG_DANISH, LANG_GERMAN, LANG_GREEK, LANG_ENGLISH, LANG_SPANISH, LANG_FINNISH, LANG_FRENCH, LANG_HEBREW, LANG_HUNGARIAN, LANG_ICELANDIC, LANG_ITALIAN, LANG_JAPANESE, LANG_KOREAN, LANG_DUTCH, LANG_NORWEGIAN, LANG_POLISH, LANG_PORTUGUESE, LANG_ROMANSH, LANG_ROMANIAN, LANG_RUSSIAN, LANG_CROATIAN, LANG_BOSNIAN, LANG_SERBIAN, LANG_SLOVAK, LANG_ALBANIAN, LANG_SWEDISH, LANG_THAI, LANG_TURKISH, LANG_URDU, LANG_INDONESIAN, LANG_UKRAINIAN, LANG_BELARUSIAN, LANG_SLOVENIAN, LANG_ESTONIAN, LANG_LATVIAN, LANG_LITHUANIAN, LANG_TAJIK, LANG_PERSIAN, LANG_FARSI, LANG_VIETNAMESE, LANG_ARMENIAN, LANG_AZERBAIJANI, LANG_AZERI, LANG_BASQUE, LANG_LOWER_SORBIAN, LANG_UPPER_SORBIAN, LANG_MACEDONIAN, LANG_TSWANA, LANG_XHOSA, LANG_ZULU, LANG_AFRIKAANS, LANG_GEORGIAN, LANG_FAEROESE, LANG_HINDI, LANG_MALTESE, LANG_SAMI, LANG_IRISH, LANG_MALAY, LANG_KAZAK, LANG_KYRGYZ, LANG_SWAHILI, LANG_TURKMEN, LANG_UZBEK, LANG_TATAR, LANG_BANGLA, LANG_BENGALI, LANG_PUNJABI, LANG_GUJARATI, LANG_ORIYA, LANG_ODIA, LANG_TAMIL, LANG_TELUGU, LANG_KANNADA, LANG_MALAYALAM, LANG_ASSAMESE, LANG_MARATHI, LANG_SANSKRIT, LANG_MONGOLIAN, LANG_TIBETAN, LANG_WELSH, LANG_KHMER, LANG_LAO, LANG_GALICIAN, LANG_KONKANI, LANG_MANIPURI, LANG_SINDHI, LANG_SYRIAC, LANG_SINHALESE, LANG_CHEROKEE, LANG_INUKTITUT, LANG_AMHARIC, LANG_TAMAZIGHT, LANG_KASHMIRI, LANG_NEPALI, LANG_FRISIAN, LANG_PASHTO, LANG_FILIPINO, LANG_DIVEHI, LANG_PULAR, LANG_FULAH, LANG_HAUSA, LANG_YORUBA, LANG_QUECHUA, LANG_SOTHO, LANG_BASHKIR, LANG_LUXEMBOURGISH, LANG_GREENLANDIC, LANG_IGBO, LANG_TIGRINYA, LANG_TIGRIGNA, LANG_HAWAIIAN, LANG_YI, LANG_MAPUDUNGUN, LANG_MOHAWK, LANG_BRETON, LANG_INVARIANT, LANG_UIGHUR, LANG_MAORI, LANG_OCCITAN, LANG_CORSICAN, LANG_ALSATIAN, LANG_SAKHA, LANG_YAKUT, LANG_KICHE, LANG_KINYARWANDA, LANG_WOLOF, LANG_DARI, LANG_SCOTTISH_GAELIC, LANG_CENTRAL_KURDISH, LANG_BOSNIAN_NEUTRAL, LANG_CHINESE_TRADITIONAL, LANG_SERBIAN_NEUTRAL
[Vanara.PInvoke.LogFontClippingPrecision](https://github.com/dahall/Vanara/search?l=C%23&q=LogFontClippingPrecision) | The clipping precision defines how to clip characters that are partially outside the clipping region. | CLIP_DEFAULT_PRECIS, CLIP_CHARACTER_PRECIS, CLIP_STROKE_PRECIS, CLIP_MASK, CLIP_LH_ANGLES, CLIP_TT_ALWAYS, CLIP_DFA_DISABLE, CLIP_DFA_OVERRIDE, CLIP_EMBEDDED
[Vanara.PInvoke.LogFontOutputPrecision](https://github.com/dahall/Vanara/search?l=C%23&q=LogFontOutputPrecision) | The output precision. The output precision defines how closely the output must match the requested font's height, width, character orientation, escapement, pitch, and font type. | OUT_DEFAULT_PRECIS, OUT_STRING_PRECIS, OUT_CHARACTER_PRECIS, OUT_STROKE_PRECIS, OUT_TT_PRECIS, OUT_DEVICE_PRECIS, OUT_RASTER_PRECIS, OUT_TT_ONLY_PRECIS, OUT_OUTLINE_PRECIS, OUT_SCREEN_OUTLINE_PRECIS, OUT_PS_ONLY_PRECIS
[Vanara.PInvoke.LogFontOutputQuality](https://github.com/dahall/Vanara/search?l=C%23&q=LogFontOutputQuality) | The output quality defines how carefully the graphics device interface (GDI) must attempt to match the logical-font attributes to those of an actual physical font. | DEFAULT_QUALITY, DRAFT_QUALITY, PROOF_QUALITY, NONANTIALIASED_QUALITY, ANTIALIASED_QUALITY, CLEARTYPE_QUALITY, CLEARTYPE_NATURAL_QUALITY
[Vanara.PInvoke.MouseButtonState](https://github.com/dahall/Vanara/search?l=C%23&q=MouseButtonState) | The state of the other mouse buttons plus the SHIFT and CTRL keys. | MK_LBUTTON, MK_RBUTTON, MK_SHIFT, MK_CONTROL, MK_MBUTTON, MK_XBUTTON1, MK_XBUTTON2
[Vanara.PInvoke.NTDDI](https://github.com/dahall/Vanara/search?l=C%23&q=NTDDI) | NTDDI version constants | NTDDI_WIN2K, NTDDI_WIN2KSP1, NTDDI_WIN2KSP2, NTDDI_WIN2KSP3, NTDDI_WIN2KSP4, NTDDI_WINXP, NTDDI_WINXPSP1, NTDDI_WINXPSP2, NTDDI_WINXPSP3, NTDDI_WINXPSP4, NTDDI_WS03, NTDDI_WS03SP1, NTDDI_WS03SP2, NTDDI_WS03SP3, NTDDI_WS03SP4, NTDDI_LONGHORN, NTDDI_VISTA, NTDDI_WIN6, NTDDI_WIN6SP1, NTDDI_VISTASP1, NTDDI_WS08, NTDDI_WIN6SP2, NTDDI_VISTASP2, NTDDI_WS08SP2, NTDDI_WIN6SP3, NTDDI_WS08SP3, NTDDI_VISTASP3, NTDDI_WS08SP4, NTDDI_WIN6SP4, NTDDI_VISTASP4, NTDDI_WIN7, NTDDI_WIN8, NTDDI_WINBLUE, NTDDI_WINTHRESHOLD, NTDDI_WIN10, NTDDI_WIN10_TH2, NTDDI_WIN10_RS1, NTDDI_WIN10_RS2, NTDDI_WIN10_RS3, NTDDI_WIN10_RS4, NTDDI_WIN10_RS5, NTDDI_WIN10_19H1
[Vanara.PInvoke.ObjectTypeListLevel](https://github.com/dahall/Vanara/search?l=C%23&q=ObjectTypeListLevel) | Valid values for the `Vanara.PInvoke.OBJECT_TYPE_LIST.level` field. | ACCESS_OBJECT_GUID, ACCESS_PROPERTY_SET_GUID, ACCESS_PROPERTY_GUID, ACCESS_MAX_LEVEL
[Vanara.PInvoke.PC](https://github.com/dahall/Vanara/search?l=C%23&q=PC) | The alpha intensity value for the palette entry. | PC_RESERVED, PC_EXPLICIT, PC_NOCOLLAPSE
[Vanara.PInvoke.PDCAP](https://github.com/dahall/Vanara/search?l=C%23&q=PDCAP) | The device's power capabilities. | PDCAP_D0_SUPPORTED, PDCAP_D1_SUPPORTED, PDCAP_D2_SUPPORTED, PDCAP_D3_SUPPORTED, PDCAP_WAKE_FROM_D0_SUPPORTED, PDCAP_WAKE_FROM_D1_SUPPORTED, PDCAP_WAKE_FROM_D2_SUPPORTED, PDCAP_WAKE_FROM_D3_SUPPORTED, PDCAP_WARM_EJECT_SUPPORTED, PDCAP_S0_SUPPORTED, PDCAP_S1_SUPPORTED, PDCAP_S2_SUPPORTED, PDCAP_S3_SUPPORTED, PDCAP_WAKE_FROM_S0_SUPPORTED, PDCAP_WAKE_FROM_S1_SUPPORTED, PDCAP_WAKE_FROM_S2_SUPPORTED, PDCAP_WAKE_FROM_S3_SUPPORTED, PDCAP_S4_SUPPORTED, PDCAP_S5_SUPPORTED
[Vanara.PInvoke.PInvokeClient](https://github.com/dahall/Vanara/search?l=C%23&q=PInvokeClient) | Flags that determine the minimum supported client(s) for a P/Invoke function. | None, Windows2000, WindowsXP, WindowsXP_SP2, WindowsVista, WindowsVista_SP2, Windows7, Windows8, Windows81, Windows10, Windows11
[Vanara.PInvoke.ProcessorArchitecture](https://github.com/dahall/Vanara/search?l=C%23&q=ProcessorArchitecture) | Processor architecture | PROCESSOR_ARCHITECTURE_INTEL, PROCESSOR_ARCHITECTURE_MIPS, PROCESSOR_ARCHITECTURE_ALPHA, PROCESSOR_ARCHITECTURE_PPC, PROCESSOR_ARCHITECTURE_SHX, PROCESSOR_ARCHITECTURE_ARM, PROCESSOR_ARCHITECTURE_IA64, PROCESSOR_ARCHITECTURE_ALPHA64, PROCESSOR_ARCHITECTURE_MSIL, PROCESSOR_ARCHITECTURE_AMD64, PROCESSOR_ARCHITECTURE_IA32_ON_WIN64, PROCESSOR_ARCHITECTURE_NEUTRAL, PROCESSOR_ARCHITECTURE_ARM64, PROCESSOR_ARCHITECTURE_ARM32_ON_WIN64, PROCESSOR_ARCHITECTURE_UNKNOWN
[Vanara.PInvoke.REG_VALUE_TYPE](https://github.com/dahall/Vanara/search?l=C%23&q=REG_VALUE_TYPE) | A registry value can store data in various formats. When you store data under a registry value, for instance by calling the RegSetValueEx function, you can specify one of the following values to indicate the type of data being stored. When you retrieve a registry value, functions such as RegQueryValueEx use these values to indicate the type of data retrieved. | REG_NONE, REG_SZ, REG_EXPAND_SZ, REG_BINARY, REG_DWORD, REG_DWORD_BIG_ENDIAN, REG_LINK, REG_MULTI_SZ, REG_RESOURCE_LIST, REG_FULL_RESOURCE_DESCRIPTOR, REG_RESOURCE_REQUIREMENTS_LIST, REG_QWORD
[Vanara.PInvoke.ResourceType](https://github.com/dahall/Vanara/search?l=C%23&q=ResourceType) | Predefined resource types. | RT_CURSOR, RT_BITMAP, RT_ICON, RT_MENU, RT_DIALOG, RT_STRING, RT_FONTDIR, RT_FONT, RT_ACCELERATOR, RT_RCDATA, RT_MESSAGETABLE, RT_GROUP_CURSOR, RT_GROUP_ICON, RT_VERSION, RT_DLGINCLUDE, RT_PLUGPLAY, RT_VXD, RT_ANICURSOR, RT_ANIICON, RT_HTML, RT_MANIFEST
[Vanara.PInvoke.SECURITY_INFORMATION](https://github.com/dahall/Vanara/search?l=C%23&q=SECURITY_INFORMATION) | The SECURITY_INFORMATION data type identifies the object-related security information being set or queried. This security information includes: <list type="bullet"> <item> <term>The owner of an object</term> </item> <item> <term>The primary group of an object</term> </item> <item> <term>The discretionary access control list (DACL) of an object</term> </item> <item> <term>The system access control list (SACL) of an object</term> </item> </list> | OWNER_SECURITY_INFORMATION, GROUP_SECURITY_INFORMATION, DACL_SECURITY_INFORMATION, SACL_SECURITY_INFORMATION, LABEL_SECURITY_INFORMATION, ATTRIBUTE_SECURITY_INFORMATION, SCOPE_SECURITY_INFORMATION, PROCESS_TRUST_LABEL_SECURITY_INFORMATION, BACKUP_SECURITY_INFORMATION, UNPROTECTED_SACL_SECURITY_INFORMATION, UNPROTECTED_DACL_SECURITY_INFORMATION, PROTECTED_SACL_SECURITY_INFORMATION, PROTECTED_DACL_SECURITY_INFORMATION
[Vanara.PInvoke.HRESULT.SeverityLevel](https://github.com/dahall/Vanara/search?l=C%23&q=SeverityLevel) | A value indicating whether an `Vanara.PInvoke.HRESULT` is a success (Severity bit 31 equals 0). | Success, Fail
[Vanara.PInvoke.NTStatus.SeverityLevel](https://github.com/dahall/Vanara/search?l=C%23&q=SeverityLevel) | A value indicating the severity of an `Vanara.PInvoke.NTStatus` value (bits 30-31). | STATUS_SEVERITY_SUCCESS, STATUS_SEVERITY_INFORMATIONAL, STATUS_SEVERITY_WARNING, STATUS_SEVERITY_ERROR
[Vanara.PInvoke.ShowWindowCommand](https://github.com/dahall/Vanara/search?l=C%23&q=ShowWindowCommand) | The flags that specify how an application is to be displayed when it is opened. | SW_HIDE, SW_SHOWNORMAL, SW_NORMAL, SW_SHOWMINIMIZED, SW_SHOWMAXIMIZED, SW_MAXIMIZE, SW_SHOWNOACTIVATE, SW_SHOW, SW_MINIMIZE, SW_SHOWMINNOACTIVE, SW_SHOWNA, SW_RESTORE, SW_SHOWDEFAULT, SW_FORCEMINIMIZE
[Vanara.PInvoke.LCID.SORT](https://github.com/dahall/Vanara/search?l=C%23&q=SORT) | Sort order identifiers. | SORT_DEFAULT, SORT_JAPANESE_XJIS, SORT_HUNGARIAN_DEFAULT, SORT_CHINESE_BIG5, SORT_CHINESE_PRCP, SORT_GEORGIAN_TRADITIONAL, SORT_KOREAN_KSC, SORT_HUNGARIAN_TECHNICAL, SORT_GERMAN_PHONE_BOOK, SORT_KOREAN_UNICODE, SORT_GEORGIAN_MODERN, SORT_CHINESE_UNICODE, SORT_JAPANESE_UNICODE, SORT_INVARIANT_MATH, SORT_CHINESE_PRC, SORT_CHINESE_BOPOMOFO, SORT_JAPANESE_RADICALSTROKE, SORT_CHINESE_RADICALSTROKE
[Vanara.PInvoke.STGM](https://github.com/dahall/Vanara/search?l=C%23&q=STGM) | The STGM constants are flags that indicate conditions for creating and deleting the object and access modes for the object. The STGM constants are included in the IStorage, IStream, and IPropertySetStorage interfaces and in the StgCreateDocfile, StgCreateStorageEx, StgCreateDocfileOnILockBytes, StgOpenStorage, and StgOpenStorageEx functions. <p> These elements are often combined using an OR operator. They are interpreted in groups as listed in the following table. It is not valid to use more than one element from a single group. </p> <p>Use a flag from the creation group when creating an object, such as with StgCreateStorageEx or IStorage::CreateStream.</p> | STGM_READ, STGM_DIRECT, STGM_FAILIFTHERE, STGM_WRITE, STGM_READWRITE, STGM_SHARE_EXCLUSIVE, STGM_SHARE_DENY_WRITE, STGM_SHARE_DENY_READ, STGM_SHARE_DENY_NONE, STGM_CREATE, STGM_TRANSACTED, STGM_CONVERT, STGM_PRIORITY, STGM_NOSCRATCH, STGM_NOSNAPSHOT, STGM_DIRECT_SWMR, STGM_DELETEONRELEASE, STGM_SIMPLE
[Vanara.PInvoke.LANGID.SUBLANG](https://github.com/dahall/Vanara/search?l=C%23&q=SUBLANG) | Sublanguage identifier. | SUBLANG_NEUTRAL, SUBLANG_YORUBA_NIGERIA, SUBLANG_LAO_LAO, SUBLANG_LATVIAN_LATVIA, SUBLANG_LITHUANIAN, SUBLANG_LUXEMBOURGISH_LUXEMBOURG, SUBLANG_MACEDONIAN_MACEDONIA, SUBLANG_MALAY_MALAYSIA, SUBLANG_MALAYALAM_INDIA, SUBLANG_KOREAN, SUBLANG_MALTESE_MALTA, SUBLANG_MAPUDUNGUN_CHILE, SUBLANG_MARATHI_INDIA, SUBLANG_MOHAWK_MOHAWK, SUBLANG_MONGOLIAN_CYRILLIC_MONGOLIA, SUBLANG_NEPALI_NEPAL, SUBLANG_NORWEGIAN_BOKMAL, SUBLANG_OCCITAN_FRANCE, SUBLANG_ODIA_INDIA, SUBLANG_MAORI_NEW_ZEALAND, SUBLANG_ORIYA_INDIA, SUBLANG_KONKANI_INDIA, SUBLANG_KICHE_GUATEMALA, SUBLANG_GERMAN, SUBLANG_GREEK_GREECE, SUBLANG_GREENLANDIC_GREENLAND, SUBLANG_GUJARATI_INDIA, SUBLANG_HAUSA_NIGERIA_LATIN, SUBLANG_HAWAIIAN_US, SUBLANG_HEBREW_ISRAEL, SUBLANG_HINDI_INDIA, SUBLANG_KINYARWANDA_RWANDA, SUBLANG_HUNGARIAN_HUNGARY, SUBLANG_IGBO_NIGERIA, SUBLANG_INDONESIAN_INDONESIA, SUBLANG_INUKTITUT_CANADA, SUBLANG_ITALIAN, SUBLANG_JAPANESE_JAPAN, SUBLANG_KANNADA_INDIA, SUBLANG_KAZAK_KAZAKHSTAN, SUBLANG_KHMER_CAMBODIA, SUBLANG_ICELANDIC_ICELAND, SUBLANG_PASHTO_AFGHANISTAN, SUBLANG_PERSIAN_IRAN, SUBLANG_POLISH_POLAND, SUBLANG_TELUGU_INDIA, SUBLANG_THAI_THAILAND, SUBLANG_TIBETAN_PRC, SUBLANG_TIGRINYA_ETHIOPIA, SUBLANG_TSWANA_SOUTH_AFRICA, SUBLANG_TURKISH_TURKEY, SUBLANG_TURKMEN_TURKMENISTAN, SUBLANG_UIGHUR_PRC, SUBLANG_TATAR_RUSSIA, SUBLANG_UKRAINIAN_UKRAINE, SUBLANG_URDU_PAKISTAN, SUBLANG_UZBEK_LATIN, SUBLANG_VIETNAMESE_VIETNAM, SUBLANG_WELSH_UNITED_KINGDOM, SUBLANG_WOLOF_SENEGAL, SUBLANG_XHOSA_SOUTH_AFRICA, SUBLANG_YAKUT_RUSSIA, SUBLANG_YI_PRC, SUBLANG_UPPER_SORBIAN_GERMANY, SUBLANG_TAMIL_INDIA, SUBLANG_TAJIK_TAJIKISTAN, SUBLANG_SYRIAC_SYRIA, SUBLANG_PORTUGUESE_BRAZILIAN, SUBLANG_PUNJABI_INDIA, SUBLANG_QUECHUA_BOLIVIA, SUBLANG_ROMANIAN_ROMANIA, SUBLANG_ROMANSH_SWITZERLAND, SUBLANG_RUSSIAN_RUSSIA, SUBLANG_SAKHA_RUSSIA, SUBLANG_SAMI_NORTHERN_NORWAY, SUBLANG_SANSKRIT_INDIA, SUBLANG_SCOTTISH_GAELIC, SUBLANG_SERBIAN_CROATIA, SUBLANG_SINDHI_INDIA, SUBLANG_SINHALESE_SRI_LANKA, SUBLANG_SOTHO_NORTHERN_SOUTH_AFRICA, SUBLANG_SLOVAK_SLOVAKIA, SUBLANG_SLOVENIAN_SLOVENIA, SUBLANG_SPANISH, SUBLANG_SWAHILI_KENYA, SUBLANG_SWEDISH, SUBLANG_GEORGIAN_GEORGIA, SUBLANG_GALICIAN_GALICIAN, SUBLANG_KYRGYZ_KYRGYZSTAN, SUBLANG_FRISIAN_NETHERLANDS, SUBLANG_DIVEHI_MALDIVES, SUBLANG_DARI_AFGHANISTAN, SUBLANG_DANISH_DENMARK, SUBLANG_CROATIAN_CROATIA, SUBLANG_CZECH_CZECH_REPUBLIC, SUBLANG_CORSICAN_FRANCE, SUBLANG_CHINESE_TRADITIONAL, SUBLANG_CHEROKEE_CHEROKEE, SUBLANG_CENTRAL_KURDISH_IRAQ, SUBLANG_CATALAN_CATALAN, SUBLANG_BULGARIAN_BULGARIA, SUBLANG_BRETON_FRANCE, SUBLANG_BENGALI_INDIA, SUBLANG_BELARUSIAN_BELARUS, SUBLANG_BASQUE_BASQUE, SUBLANG_BASHKIR_RUSSIA, SUBLANG_BANGLA_INDIA, SUBLANG_AZERBAIJANI_AZERBAIJAN_LATIN, SUBLANG_AZERI_LATIN, SUBLANG_ASSAMESE_INDIA, SUBLANG_ARMENIAN_ARMENIA, SUBLANG_ARABIC_SAUDI_ARABIA, SUBLANG_AMHARIC_ETHIOPIA, SUBLANG_ALSATIAN_FRANCE, SUBLANG_ALBANIAN_ALBANIA, SUBLANG_AFRIKAANS_SOUTH_AFRICA, SUBLANG_DEFAULT, SUBLANG_DUTCH, SUBLANG_ENGLISH_US, SUBLANG_ZULU_SOUTH_AFRICA, SUBLANG_FRENCH, SUBLANG_ESTONIAN_ESTONIA, SUBLANG_FAEROESE_FAROE_ISLANDS, SUBLANG_FILIPINO_PHILIPPINES, SUBLANG_FINNISH_FINLAND, SUBLANG_SINDHI_PAKISTAN, SUBLANG_PULAR_SENEGAL, SUBLANG_PUNJABI_PAKISTAN, SUBLANG_SPANISH_MEXICAN, SUBLANG_BENGALI_BANGLADESH, SUBLANG_ARABIC_IRAQ, SUBLANG_SAMI_NORTHERN_SWEDEN, SUBLANG_FULAH_SENEGAL, SUBLANG_TSWANA_BOTSWANA, SUBLANG_BANGLA_BANGLADESH, SUBLANG_TIGRINYA_ERITREA, SUBLANG_TIGRIGNA_ERITREA, SUBLANG_TAMIL_SRI_LANKA, SUBLANG_TAMAZIGHT_ALGERIA_LATIN, SUBLANG_SWEDISH_FINLAND, SUBLANG_AZERBAIJANI_AZERBAIJAN_CYRILLIC, SUBLANG_SERBIAN_LATIN, SUBLANG_SINDHI_AFGHANISTAN, SUBLANG_AZERI_CYRILLIC, SUBLANG_FRENCH_BELGIAN, SUBLANG_PORTUGUESE, SUBLANG_URDU_INDIA, SUBLANG_QUECHUA_ECUADOR, SUBLANG_IRISH_IRELAND, SUBLANG_ENGLISH_UK, SUBLANG_SYS_DEFAULT, SUBLANG_LOWER_SORBIAN_GERMANY, SUBLANG_DUTCH_BELGIAN, SUBLANG_MALAY_BRUNEI_DARUSSALAM, SUBLANG_KASHMIRI_INDIA, SUBLANG_KASHMIRI_SASIA, SUBLANG_INUKTITUT_CANADA_LATIN, SUBLANG_VALENCIAN_VALENCIA, SUBLANG_UZBEK_CYRILLIC, SUBLANG_MONGOLIAN_PRC, SUBLANG_GERMAN_SWISS, SUBLANG_NEPALI_INDIA, SUBLANG_CHINESE_SIMPLIFIED, SUBLANG_ITALIAN_SWISS, SUBLANG_NORWEGIAN_NYNORSK, SUBLANG_SPANISH_MODERN, SUBLANG_CUSTOM_DEFAULT, SUBLANG_GERMAN_AUSTRIAN, SUBLANG_ENGLISH_AUS, SUBLANG_QUECHUA_PERU, SUBLANG_CHINESE_HONGKONG, SUBLANG_ARABIC_EGYPT, SUBLANG_SAMI_NORTHERN_FINLAND, SUBLANG_FRENCH_CANADIAN, SUBLANG_SERBIAN_CYRILLIC, SUBLANG_ENGLISH_CAN, SUBLANG_FRENCH_SWISS, SUBLANG_GERMAN_LUXEMBOURG, SUBLANG_SPANISH_GUATEMALA, SUBLANG_CUSTOM_UNSPECIFIED, SUBLANG_TAMAZIGHT_MOROCCO_TIFINAGH, SUBLANG_CROATIAN_BOSNIA_HERZEGOVINA_LATIN, SUBLANG_ARABIC_LIBYA, SUBLANG_SAMI_LULE_NORWAY, SUBLANG_CHINESE_SINGAPORE, SUBLANG_SPANISH_COSTA_RICA, SUBLANG_FRENCH_LUXEMBOURG, SUBLANG_UI_CUSTOM_DEFAULT, SUBLANG_ARABIC_ALGERIA, SUBLANG_GERMAN_LIECHTENSTEIN, SUBLANG_ENGLISH_NZ, SUBLANG_CHINESE_MACAU, SUBLANG_BOSNIAN_BOSNIA_HERZEGOVINA_LATIN, SUBLANG_SAMI_LULE_SWEDEN, SUBLANG_ENGLISH_EIRE, SUBLANG_SPANISH_PANAMA, SUBLANG_FRENCH_MONACO, SUBLANG_SAMI_SOUTHERN_NORWAY, SUBLANG_ARABIC_MOROCCO, SUBLANG_SERBIAN_BOSNIA_HERZEGOVINA_LATIN, SUBLANG_ENGLISH_SOUTH_AFRICA, SUBLANG_SERBIAN_BOSNIA_HERZEGOVINA_CYRILLIC, SUBLANG_ARABIC_TUNISIA, SUBLANG_SAMI_SOUTHERN_SWEDEN, SUBLANG_SPANISH_DOMINICAN_REPUBLIC, SUBLANG_SPANISH_VENEZUELA, SUBLANG_ENGLISH_JAMAICA, SUBLANG_SAMI_SKOLT_FINLAND, SUBLANG_BOSNIAN_BOSNIA_HERZEGOVINA_CYRILLIC, SUBLANG_ARABIC_OMAN, SUBLANG_ENGLISH_CARIBBEAN, SUBLANG_SAMI_INARI_FINLAND, SUBLANG_SERBIAN_SERBIA_LATIN, SUBLANG_SPANISH_COLOMBIA, SUBLANG_ARABIC_YEMEN, SUBLANG_ARABIC_SYRIA, SUBLANG_ENGLISH_BELIZE, SUBLANG_SERBIAN_SERBIA_CYRILLIC, SUBLANG_SPANISH_PERU, SUBLANG_ARABIC_JORDAN, SUBLANG_SERBIAN_MONTENEGRO_LATIN, SUBLANG_ENGLISH_TRINIDAD, SUBLANG_SPANISH_ARGENTINA, SUBLANG_SPANISH_ECUADOR, SUBLANG_SERBIAN_MONTENEGRO_CYRILLIC, SUBLANG_ARABIC_LEBANON, SUBLANG_ENGLISH_ZIMBABWE, SUBLANG_ENGLISH_PHILIPPINES, SUBLANG_SPANISH_CHILE, SUBLANG_ARABIC_KUWAIT, SUBLANG_SPANISH_URUGUAY, SUBLANG_ARABIC_UAE, SUBLANG_SPANISH_PARAGUAY, SUBLANG_ARABIC_BAHRAIN, SUBLANG_ENGLISH_INDIA, SUBLANG_SPANISH_BOLIVIA, SUBLANG_ARABIC_QATAR, SUBLANG_SPANISH_EL_SALVADOR, SUBLANG_ENGLISH_MALAYSIA, SUBLANG_ENGLISH_SINGAPORE, SUBLANG_SPANISH_HONDURAS, SUBLANG_SPANISH_NICARAGUA, SUBLANG_SPANISH_PUERTO_RICO, SUBLANG_SPANISH_US
[Vanara.PInvoke.SYSTEM_POWER_STATE](https://github.com/dahall/Vanara/search?l=C%23&q=SYSTEM_POWER_STATE) | <p>The <c>SYSTEM_POWER_STATE</c> enumeration type is used to indicate a system power state.</p> | PowerSystemUnspecified, PowerSystemWorking, PowerSystemSleeping1, PowerSystemSleeping2, PowerSystemSleeping3, PowerSystemHibernate, PowerSystemShutdown, PowerSystemMaximum
[Vanara.PInvoke.SystemColorIndex](https://github.com/dahall/Vanara/search?l=C%23&q=SystemColorIndex) | Color index used to get a system color from <c>GetSysColor</c>. | COLOR_SCROLLBAR, COLOR_DESKTOP, COLOR_BACKGROUND, COLOR_ACTIVECAPTION, COLOR_INACTIVECAPTION, COLOR_MENU, COLOR_WINDOW, COLOR_WINDOWFRAME, COLOR_MENUTEXT, COLOR_WINDOWTEXT, COLOR_CAPTIONTEXT, COLOR_ACTIVEBORDER, COLOR_INACTIVEBORDER, COLOR_APPWORKSPACE, COLOR_HIGHLIGHT, COLOR_HIGHLIGHTTEXT, COLOR_BTNFACE, COLOR_3DFACE, COLOR_BTNSHADOW, COLOR_3DSHADOW, COLOR_GRAYTEXT, COLOR_BTNTEXT, COLOR_INACTIVECAPTIONTEXT, COLOR_3DHILIGHT, COLOR_3DHIGHLIGHT, COLOR_BTNHIGHLIGHT, COLOR_BTNHILIGHT, COLOR_3DDKSHADOW, COLOR_3DLIGHT, COLOR_INFOTEXT, COLOR_INFOBK, COLOR_HOTLIGHT, COLOR_GRADIENTACTIVECAPTION, COLOR_GRADIENTINACTIVECAPTION, COLOR_MENUHILIGHT, COLOR_MENUBAR
[Vanara.PInvoke.SystemShutDownReason](https://github.com/dahall/Vanara/search?l=C%23&q=SystemShutDownReason) | Flags used in the ExitWindowsEx, InitiateShutdown and InitiateSystemShutdownEx functions. | SHTDN_REASON_MINOR_OTHER, SHTDN_REASON_MAJOR_OTHER, SHTDN_REASON_MAJOR_NONE, SHTDN_REASON_MINOR_MAINTENANCE, SHTDN_REASON_MINOR_INSTALLATION, SHTDN_REASON_MINOR_UPGRADE, SHTDN_REASON_MINOR_RECONFIG, SHTDN_REASON_MINOR_HUNG, SHTDN_REASON_MINOR_UNSTABLE, SHTDN_REASON_MINOR_DISK, SHTDN_REASON_MINOR_PROCESSOR, SHTDN_REASON_MINOR_NETWORKCARD, SHTDN_REASON_MINOR_POWER_SUPPLY, SHTDN_REASON_MINOR_CORDUNPLUGGED, SHTDN_REASON_MINOR_ENVIRONMENT, SHTDN_REASON_MINOR_HARDWARE_DRIVER, SHTDN_REASON_MINOR_OTHERDRIVER, SHTDN_REASON_MINOR_BLUESCREEN, SHTDN_REASON_MINOR_SERVICEPACK, SHTDN_REASON_MINOR_HOTFIX, SHTDN_REASON_MINOR_SECURITYFIX, SHTDN_REASON_MINOR_SECURITY, SHTDN_REASON_MINOR_NETWORK_CONNECTIVITY, SHTDN_REASON_MINOR_WMI, SHTDN_REASON_MINOR_SERVICEPACK_UNINSTALL, SHTDN_REASON_MINOR_HOTFIX_UNINSTALL, SHTDN_REASON_MINOR_SECURITYFIX_UNINSTALL, SHTDN_REASON_MINOR_MMC, SHTDN_REASON_MINOR_SYSTEMRESTORE, SHTDN_REASON_MINOR_TERMSRV, SHTDN_REASON_MINOR_DC_PROMOTION, SHTDN_REASON_MINOR_DC_DEMOTION, SHTDN_REASON_UNKNOWN, SHTDN_REASON_MINOR_NONE, SHTDN_REASON_MAJOR_HARDWARE, SHTDN_REASON_MAJOR_OPERATINGSYSTEM, SHTDN_REASON_MAJOR_SOFTWARE, SHTDN_REASON_MAJOR_APPLICATION, SHTDN_REASON_MAJOR_SYSTEM, SHTDN_REASON_MAJOR_POWER, SHTDN_REASON_MAJOR_LEGACY_API, SHTDN_REASON_FLAG_COMMENT_REQUIRED, SHTDN_REASON_FLAG_DIRTY_PROBLEM_ID_REQUIRED, SHTDN_REASON_FLAG_CLEAN_UI, SHTDN_REASON_FLAG_DIRTY_UI, SHTDN_REASON_FLAG_MOBILE_UI_RESERVED, SHTDN_REASON_FLAG_USER_DEFINED, SHTDN_REASON_FLAG_PLANNED, SHTDN_REASON_LEGACY_API
[Vanara.PInvoke.URLZONE](https://github.com/dahall/Vanara/search?l=C%23&q=URLZONE) | Contains all the predefined zones used by Windows Internet Explorer. | URLZONE_PREDEFINED_MIN, URLZONE_LOCAL_MACHINE, URLZONE_INTRANET, URLZONE_TRUSTED, URLZONE_INTERNET, URLZONE_UNTRUSTED, URLZONE_PREDEFINED_MAX, URLZONE_USER_MIN, URLZONE_USER_MAX, URLZONE_INVALID
[Vanara.PInvoke.WIN32_WINNT](https://github.com/dahall/Vanara/search?l=C%23&q=WIN32_WINNT) | _WIN32_WINNT version constants | _WIN32_WINNT_NT4, _WIN32_WINNT_WIN2K, _WIN32_WINNT_WINXP, _WIN32_WINNT_WS03, _WIN32_WINNT_WIN6, _WIN32_WINNT_VISTA, _WIN32_WINNT_WS08, _WIN32_WINNT_LONGHORN, _WIN32_WINNT_WIN7, _WIN32_WINNT_WIN8, _WIN32_WINNT_WINBLUE, _WIN32_WINNT_WINTHRESHOLD, _WIN32_WINNT_WIN10
### Structures
Struct | Description
---- | ----
[Vanara.PInvoke.ACCESS_MASK](https://github.com/dahall/Vanara/search?l=C%23&q=ACCESS_MASK) | Access flags.
[Vanara.PInvoke.CM_PARTIAL_RESOURCE_DESCRIPTOR.BusNumber](https://github.com/dahall/Vanara/search?l=C%23&q=BusNumber) | 
[Vanara.PInvoke.CLIPFORMAT](https://github.com/dahall/Vanara/search?l=C%23&q=CLIPFORMAT) | CLIPFORMAT is a 2-byte value representing a clipboard format. <p> This cannot be used as a drop-in replacement for many of the winuser.h function as they expect a 4-byte value. However, this can automatically convert between the 4-byte values and the 2-byte value. </p>
[Vanara.PInvoke.CM_FULL_RESOURCE_DESCRIPTOR](https://github.com/dahall/Vanara/search?l=C%23&q=CM_FULL_RESOURCE_DESCRIPTOR) | <p> The <c>CM_FULL_RESOURCE_DESCRIPTOR</c> structure specifies a set of system hardware resources of various types, assigned to a device that is connected to a specific bus. This structure is contained within a CM_RESOURCE_LIST structure. </p>
[Vanara.PInvoke.CM_PARTIAL_RESOURCE_DESCRIPTOR](https://github.com/dahall/Vanara/search?l=C%23&q=CM_PARTIAL_RESOURCE_DESCRIPTOR) | The <c>CM_PARTIAL_RESOURCE_DESCRIPTOR</c> structure specifies one or more system hardware resources, of a single type, assigned to a device. This structure is used to create an array within a CM_PARTIAL_RESOURCE_LIST structure.
[Vanara.PInvoke.CM_PARTIAL_RESOURCE_LIST](https://github.com/dahall/Vanara/search?l=C%23&q=CM_PARTIAL_RESOURCE_LIST) | <p> The <c>CM_PARTIAL_RESOURCE_LIST</c> structure specifies a set of system hardware resources, of various types, assigned to a device. This structure is contained within a CM_FULL_RESOURCE_DESCRIPTOR structure. </p>
[Vanara.PInvoke.CM_POWER_DATA](https://github.com/dahall/Vanara/search?l=C%23&q=CM_POWER_DATA) | The <c>CM_POWER_DATA</c> structure contains information about a device's power management state and capabilities.
[Vanara.PInvoke.CM_RESOURCE_LIST](https://github.com/dahall/Vanara/search?l=C%23&q=CM_RESOURCE_LIST) | The <c>CM_RESOURCE_LIST</c> structure specifies all of the system hardware resources assigned to a device.
[Vanara.PInvoke.COLORREF](https://github.com/dahall/Vanara/search?l=C%23&q=COLORREF) | The COLORREF value is used to specify an RGB color in the form <c>0x00bbggrr</c>.
[Vanara.PInvoke.CM_PARTIAL_RESOURCE_DESCRIPTOR.Connection](https://github.com/dahall/Vanara/search?l=C%23&q=Connection) | 
[Vanara.PInvoke.CORRELATION_VECTOR](https://github.com/dahall/Vanara/search?l=C%23&q=CORRELATION_VECTOR) | Store the correlation vector that is used to reference events and the generated logs for diagnostic purposes.
[Vanara.CY](https://github.com/dahall/Vanara/search?l=C%23&q=CY) | Managed instance of the OLE CY type.
[Vanara.DATE](https://github.com/dahall/Vanara/search?l=C%23&q=DATE) | Managed instance of the OLE DATE type.
[Vanara.DECIMAL](https://github.com/dahall/Vanara/search?l=C%23&q=DECIMAL) | Managed instance of the OLE DECIMAL type.
[Vanara.PInvoke.DEVICE_CAPABILITIES](https://github.com/dahall/Vanara/search?l=C%23&q=DEVICE_CAPABILITIES) | A <c>DEVICE_CAPABILITIES</c> structure describes PnP and power capabilities of a device. This structure is returned in response to an IRP_MN_QUERY_CAPABILITIES IRP.
[Vanara.PInvoke.CM_PARTIAL_RESOURCE_DESCRIPTOR.DevicePrivate](https://github.com/dahall/Vanara/search?l=C%23&q=DevicePrivate) | 
[Vanara.PInvoke.CM_PARTIAL_RESOURCE_DESCRIPTOR.DeviceSpecificData](https://github.com/dahall/Vanara/search?l=C%23&q=DeviceSpecificData) | 
[Vanara.PInvoke.DEVMODE](https://github.com/dahall/Vanara/search?l=C%23&q=DEVMODE) | The <c>DEVMODE</c> data structure contains information about the initialization and environment of a printer or a display device.
[Vanara.PInvoke.CM_PARTIAL_RESOURCE_DESCRIPTOR.Dma](https://github.com/dahall/Vanara/search?l=C%23&q=Dma) | 
[Vanara.PInvoke.CM_PARTIAL_RESOURCE_DESCRIPTOR.DmaV3](https://github.com/dahall/Vanara/search?l=C%23&q=DmaV3) | 
[Vanara.PInvoke.CM_PARTIAL_RESOURCE_DESCRIPTOR.Generic](https://github.com/dahall/Vanara/search?l=C%23&q=Generic) | 
[Vanara.PInvoke.HACCEL](https://github.com/dahall/Vanara/search?l=C%23&q=HACCEL) | Provides a handle to an accelerator table.
[Vanara.PInvoke.HANDLE](https://github.com/dahall/Vanara/search?l=C%23&q=HANDLE) | Provides a generic handle.
[Vanara.PInvoke.HBITMAP](https://github.com/dahall/Vanara/search?l=C%23&q=HBITMAP) | Provides a handle to a bitmap.
[Vanara.PInvoke.HBRUSH](https://github.com/dahall/Vanara/search?l=C%23&q=HBRUSH) | Provides a handle to drawing brush.
[Vanara.PInvoke.HCOLORSPACE](https://github.com/dahall/Vanara/search?l=C%23&q=HCOLORSPACE) | Provides a handle to a color space.
[Vanara.PInvoke.HCURSOR](https://github.com/dahall/Vanara/search?l=C%23&q=HCURSOR) | Provides a handle to cursor.
[Vanara.PInvoke.HDC](https://github.com/dahall/Vanara/search?l=C%23&q=HDC) | Provides a handle to a graphic device context.
[Vanara.PInvoke.HDESK](https://github.com/dahall/Vanara/search?l=C%23&q=HDESK) | Provides a handle to a desktop.
[Vanara.PInvoke.HDPA](https://github.com/dahall/Vanara/search?l=C%23&q=HDPA) | Provides a handle to a DPA.
[Vanara.PInvoke.HDROP](https://github.com/dahall/Vanara/search?l=C%23&q=HDROP) | Provides a handle to a Windows drop operation.
[Vanara.PInvoke.HDSA](https://github.com/dahall/Vanara/search?l=C%23&q=HDSA) | Provides a handle to a DSA.
[Vanara.PInvoke.HDWP](https://github.com/dahall/Vanara/search?l=C%23&q=HDWP) | Provides a handle to a deferred windows position.
[Vanara.PInvoke.HENHMETAFILE](https://github.com/dahall/Vanara/search?l=C%23&q=HENHMETAFILE) | Provides a handle to an enhanced metafile.
[Vanara.PInvoke.HEVENT](https://github.com/dahall/Vanara/search?l=C%23&q=HEVENT) | Provides a handle to a sync event.
[Vanara.PInvoke.HFILE](https://github.com/dahall/Vanara/search?l=C%23&q=HFILE) | Provides a handle to a file.
[Vanara.PInvoke.HFONT](https://github.com/dahall/Vanara/search?l=C%23&q=HFONT) | Provides a handle to a font.
[Vanara.PInvoke.HGDIOBJ](https://github.com/dahall/Vanara/search?l=C%23&q=HGDIOBJ) | Provides a handle to a graphic device object.
[Vanara.PInvoke.HICON](https://github.com/dahall/Vanara/search?l=C%23&q=HICON) | Provides a handle to an icon.
[Vanara.PInvoke.HIMAGELIST](https://github.com/dahall/Vanara/search?l=C%23&q=HIMAGELIST) | Provides a handle to a Windows image list.
[Vanara.PInvoke.HINSTANCE](https://github.com/dahall/Vanara/search?l=C%23&q=HINSTANCE) | Provides a handle to a module or library instance.
[Vanara.PInvoke.HKEY](https://github.com/dahall/Vanara/search?l=C%23&q=HKEY) | Provides a handle to a Windows registry key.
[Vanara.PInvoke.HMENU](https://github.com/dahall/Vanara/search?l=C%23&q=HMENU) | Provides a handle to a menu.
[Vanara.PInvoke.HMETAFILE](https://github.com/dahall/Vanara/search?l=C%23&q=HMETAFILE) | Provides a handle to a metafile.
[Vanara.PInvoke.HMONITOR](https://github.com/dahall/Vanara/search?l=C%23&q=HMONITOR) | Provides a handle to a monitor.
[Vanara.PInvoke.HPALETTE](https://github.com/dahall/Vanara/search?l=C%23&q=HPALETTE) | Provides a handle to a palette.
[Vanara.PInvoke.HPEN](https://github.com/dahall/Vanara/search?l=C%23&q=HPEN) | Provides a handle to a drawing pen.
[Vanara.PInvoke.HPROCESS](https://github.com/dahall/Vanara/search?l=C%23&q=HPROCESS) | Provides a handle to a process.
[Vanara.PInvoke.HPROPSHEET](https://github.com/dahall/Vanara/search?l=C%23&q=HPROPSHEET) | Provides a handle to a Windows property sheet.
[Vanara.PInvoke.HPROPSHEETPAGE](https://github.com/dahall/Vanara/search?l=C%23&q=HPROPSHEETPAGE) | Provides a handle to a property sheet page.
[Vanara.PInvoke.HRESULT](https://github.com/dahall/Vanara/search?l=C%23&q=HRESULT) | Formal replacement for the Windows HRESULT definition. In windows.h, it is a defined UINT value. For .NET, this class strongly types the value. <p>The 32-bit value is organized as follows:</p> <list type="table"> <item> <term>Bit</term> <description>31</description> <description>30</description> <description>29</description> <description>28</description> <description>27</description> <description>26 - 16</description> <description>15 - 0</description> </item> <item> <term>Field</term> <description>Severity</description> <description>Severity</description> <description>Customer</description> <description>NT status</description> <description>MsgID</description> <description>Facility</description> <description>Code</description> </item> </list>
[Vanara.PInvoke.HRGN](https://github.com/dahall/Vanara/search?l=C%23&q=HRGN) | Provides a handle to a drawing region.
[Vanara.PInvoke.HSECTION](https://github.com/dahall/Vanara/search?l=C%23&q=HSECTION) | Provides a handle to a file mapping object.
[Vanara.PInvoke.HTASK](https://github.com/dahall/Vanara/search?l=C%23&q=HTASK) | Provides a handle to a blocking task.
[Vanara.PInvoke.HTHEME](https://github.com/dahall/Vanara/search?l=C%23&q=HTHEME) | Provides a handle to a Windows theme.
[Vanara.PInvoke.HTHREAD](https://github.com/dahall/Vanara/search?l=C%23&q=HTHREAD) | Provides a handle to a thread.
[Vanara.PInvoke.HTHUMBNAIL](https://github.com/dahall/Vanara/search?l=C%23&q=HTHUMBNAIL) | Provides a handle to a Windows thumbnail.
[Vanara.PInvoke.HTOKEN](https://github.com/dahall/Vanara/search?l=C%23&q=HTOKEN) | Provides a handle to an access token.
[Vanara.PInvoke.HWINSTA](https://github.com/dahall/Vanara/search?l=C%23&q=HWINSTA) | Provides a handle to a windows station.
[Vanara.PInvoke.HWND](https://github.com/dahall/Vanara/search?l=C%23&q=HWND) | Provides a handle to a window or dialog.
[Vanara.PInvoke.CM_PARTIAL_RESOURCE_DESCRIPTOR.Interrupt](https://github.com/dahall/Vanara/search?l=C%23&q=Interrupt) | 
[Vanara.PInvoke.LANGID](https://github.com/dahall/Vanara/search?l=C%23&q=LANGID) | Managed instance of the 16 bit LANGID type. <p> A language identifier is a standard international numeric abbreviation for the language in a country or geographical region. Each language has a unique language identifier (data type LANGID), a 16-bit value that consists of a primary language identifier and a sublanguage identifier. </p>
[Vanara.PInvoke.LCID](https://github.com/dahall/Vanara/search?l=C%23&q=LCID) | An LCID is a 4-byte value. The value supplied in an LCID is a standard numeric substitution for the international [RFC5646] string.
[Vanara.PInvoke.LOGFONT](https://github.com/dahall/Vanara/search?l=C%23&q=LOGFONT) | The LOGFONT structure defines the attributes of a font.
[Vanara.PInvoke.LOGPALETTE](https://github.com/dahall/Vanara/search?l=C%23&q=LOGPALETTE) | The <c>LOGPALETTE</c> structure defines a logical palette.
[Vanara.PInvoke.LUID](https://github.com/dahall/Vanara/search?l=C%23&q=LUID) | An LUID is a 64-bit value guaranteed to be unique only on the system on which it was generated. The uniqueness of a locally unique identifier (LUID) is guaranteed only until the system is restarted. <p>Applications must use functions and structures to manipulate LUID values.</p>
[Vanara.PInvoke.CM_PARTIAL_RESOURCE_DESCRIPTOR.Memory40](https://github.com/dahall/Vanara/search?l=C%23&q=Memory40) | 
[Vanara.PInvoke.CM_PARTIAL_RESOURCE_DESCRIPTOR.Memory48](https://github.com/dahall/Vanara/search?l=C%23&q=Memory48) | 
[Vanara.PInvoke.CM_PARTIAL_RESOURCE_DESCRIPTOR.Memory64](https://github.com/dahall/Vanara/search?l=C%23&q=Memory64) | 
[Vanara.PInvoke.CM_PARTIAL_RESOURCE_DESCRIPTOR.MessageInterruptRaw](https://github.com/dahall/Vanara/search?l=C%23&q=MessageInterruptRaw) | 
[Vanara.PInvoke.MSG](https://github.com/dahall/Vanara/search?l=C%23&q=MSG) | Contains message information from a thread's message queue.
[Vanara.PInvoke.NTStatus](https://github.com/dahall/Vanara/search?l=C%23&q=NTStatus) | Formal replacement for the Windows NTStatus definition. In ntstatus.h, it is a defined UINT value. For .NET, this class strongly types the value. <p>The 32-bit value is organized as follows:</p> <list type="table"> <item> <term>Bit</term> <description>0 - 1</description> <description>2</description> <description>3</description> <description>4 - 15</description> <description>16 - 31</description> </item> <item> <term>Field</term> <description>Sev</description> <description>Customer</description> <description>Reserved</description> <description>Facility</description> <description>Code</description> </item> </list>
[Vanara.PInvoke.OBJECT_TYPE_LIST](https://github.com/dahall/Vanara/search?l=C%23&q=OBJECT_TYPE_LIST) | The <c>OBJECT_TYPE_LIST</c> structure identifies an object type element in a hierarchy of object types. The AccessCheckByType functions use an array of <c>OBJECT_TYPE_LIST</c> structures to define a hierarchy of an object and its subobjects, such as property sets and properties.
[Vanara.PInvoke.OFSTRUCT](https://github.com/dahall/Vanara/search?l=C%23&q=OFSTRUCT) | Contains information about a file that the <c>OpenFile</c> function opened or attempted to open.
[Vanara.PInvoke.PACE](https://github.com/dahall/Vanara/search?l=C%23&q=PACE) | Provides a pointer to an access control entry.
[Vanara.PInvoke.PACL](https://github.com/dahall/Vanara/search?l=C%23&q=PACL) | Provides a handle to an access control list.
[Vanara.PInvoke.PALETTEENTRY](https://github.com/dahall/Vanara/search?l=C%23&q=PALETTEENTRY) | Specifies the color and usage of an entry in a logical palette.
[Vanara.PInvoke.PFILETIME](https://github.com/dahall/Vanara/search?l=C%23&q=PFILETIME) | Represents a pointer to a `System.Runtime.InteropServices.ComTypes.FILETIME` structure which holds the number of 100-nanosecond intervals since January 1, 1601. This structure is a 64-bit value.
[Vanara.PInvoke.POINT](https://github.com/dahall/Vanara/search?l=C%23&q=POINT) | The POINT structure defines the x- and y-coordinates of a point.
[Vanara.PInvoke.POINTS](https://github.com/dahall/Vanara/search?l=C%23&q=POINTS) | The POINTS structure defines the coordinates of a point.
[Vanara.PInvoke.PRECT](https://github.com/dahall/Vanara/search?l=C%23&q=PRECT) | Defines the coordinates of the upper-left and lower-right corners of a rectangle.
[Vanara.PInvoke.PSECURITY_DESCRIPTOR](https://github.com/dahall/Vanara/search?l=C%23&q=PSECURITY_DESCRIPTOR) | Provides a handle to a security descriptor.
[Vanara.PInvoke.PSID](https://github.com/dahall/Vanara/search?l=C%23&q=PSID) | Provides a handle to a security identifier.
[Vanara.PInvoke.PSYSTEMTIME](https://github.com/dahall/Vanara/search?l=C%23&q=PSYSTEMTIME) | Specifies a date and time, using individual members for the month, day, year, weekday, hour, minute, second, and millisecond. The time is either in coordinated universal time (UTC) or local time, depending on the function that is being called.
[Vanara.PInvoke.RECT](https://github.com/dahall/Vanara/search?l=C%23&q=RECT) | Defines the coordinates of the upper-left and lower-right corners of a rectangle.
[Vanara.PInvoke.ResourceId](https://github.com/dahall/Vanara/search?l=C%23&q=ResourceId) | Helper structure to use for a pointer that can morph into a string, pointer or integer.
[Vanara.PInvoke.ResourceIdOrHandle&lt;T&gt;](https://github.com/dahall/Vanara/search?l=C%23&q=ResourceIdOrHandle%26lt%3BT%26gt%3B) | Helper structure to use for a pointer that can morph into a string, handle or integer.
[Vanara.PInvoke.RGBQUAD](https://github.com/dahall/Vanara/search?l=C%23&q=RGBQUAD) | The RGBQUAD structure describes a color consisting of relative intensities of red, green, and blue.
[Vanara.PInvoke.SECURITY_ATTRIBUTES](https://github.com/dahall/Vanara/search?l=C%23&q=SECURITY_ATTRIBUTES) | The SECURITY_ATTRIBUTES structure contains the security descriptor for an object and specifies whether the handle retrieved by specifying this structure is inheritable. This structure provides security settings for objects created by various functions, such as CreateFile, CreatePipe, CreateProcess, RegCreateKeyEx, or RegSaveKeyEx.
[Vanara.PInvoke.SIZE](https://github.com/dahall/Vanara/search?l=C%23&q=SIZE) | The <c>SIZE</c> structure specifies the width and height of a rectangle.
[Vanara.PInvoke.SYSTEMTIME](https://github.com/dahall/Vanara/search?l=C%23&q=SYSTEMTIME) | Specifies a date and time, using individual members for the month, day, year, weekday, hour, minute, second, and millisecond. The time is either in coordinated universal time (UTC) or local time, depending on the function that is being called.
[Vanara.PInvoke.tagSECURITY_ATTRIBUTES](https://github.com/dahall/Vanara/search?l=C%23&q=tagSECURITY_ATTRIBUTES) | The SECURITY_ATTRIBUTES structure contains the security descriptor for an object and specifies whether the handle retrieved by specifying this structure is inheritable. This structure provides security settings for objects created by various functions, such as CreateFile, CreatePipe, CreateProcess, RegCreateKeyEx, or RegSaveKeyEx.
[Vanara.PInvoke.TEXTMETRIC](https://github.com/dahall/Vanara/search?l=C%23&q=TEXTMETRIC) | The <c>TEXTMETRIC</c> structure contains basic information about a physical font. All sizes are specified in logical units; that is, they depend on the current mapping mode of the display context.
[Vanara.PInvoke.CM_PARTIAL_RESOURCE_DESCRIPTOR.Union](https://github.com/dahall/Vanara/search?l=C%23&q=Union) | The union
[Vanara.PInvoke.WIN32_FIND_DATA](https://github.com/dahall/Vanara/search?l=C%23&q=WIN32_FIND_DATA) | Contains information about the file that is found by the FindFirstFile, FindFirstFileEx, or FindNextFile function.
[Vanara.PInvoke.Win32Error](https://github.com/dahall/Vanara/search?l=C%23&q=Win32Error) | Represents a Win32 Error Code. This can be used in place of a return value.
### Interfaces
Interface | Description
---- | ----
[Vanara.PInvoke.IClipboardFormatter](https://github.com/dahall/Vanara/search?l=C%23&q=IClipboardFormatter) | A formatter used to get and set objects on the clipboard. When implemented, use the `Vanara.PInvoke.ClipCorrespondingTypeAttribute.Formatter` property to
[Vanara.Collections.ICOMEnum&lt;T&gt;](https://github.com/dahall/Vanara/search?l=C%23&q=ICOMEnum%26lt%3BT%26gt%3B) | A generic interface to identify matching COM enumerator interfaces
[Vanara.PInvoke.IErrorProvider](https://github.com/dahall/Vanara/search?l=C%23&q=IErrorProvider) | Common properties and methods for errors.
[Vanara.PInvoke.IGraphicsObjectHandle](https://github.com/dahall/Vanara/search?l=C%23&q=IGraphicsObjectHandle) | Signals that a structure or class holds a handle to a graphics object.
[Vanara.PInvoke.IKernelHandle](https://github.com/dahall/Vanara/search?l=C%23&q=IKernelHandle) | Signals that a structure or class holds a handle to a kernel object.
[Vanara.PInvoke.ISecurityObject](https://github.com/dahall/Vanara/search?l=C%23&q=ISecurityObject) | Signals that a structure or class holds a pointer to a security object.
[Vanara.PInvoke.IShellHandle](https://github.com/dahall/Vanara/search?l=C%23&q=IShellHandle) | Signals that a structure or class holds a handle to a shell object.
[Vanara.PInvoke.ISyncHandle](https://github.com/dahall/Vanara/search?l=C%23&q=ISyncHandle) | Signals that a structure or class holds a handle to a synchronization object.
[Vanara.PInvoke.IUserHandle](https://github.com/dahall/Vanara/search?l=C%23&q=IUserHandle) | Signals that a structure or class holds a handle to a user object.
### Classes
Class | Description
---- | ----
[Vanara.InteropServices.AnySizeStringMarshaler&lt;T&gt;](https://github.com/dahall/Vanara/search?l=C%23&q=AnySizeStringMarshaler%26lt%3BT%26gt%3B) | A marshaler implementation of `Vanara.InteropServices.IVanaraMarshaler` to marshal structures whose last field is a character array of length (1) and that uses a field to determine the length of the full string. <p> Use the cookie paramter of `Vanara.InteropServices.AnySizeStringMarshaler` to specify the name of the field in <typeparamref name="T" /> that specifies the length of the string in the last field of <typeparamref name="T" /> along with use indicators. </p> <p> If the field specifies byte, rather than character length, follow the field name with a colon (:) followed by 'b' (for bytes) or 'c' (for characters). </p> <p> If the field specifies a length that does NOT include the NULL terminator, follow the field name, colon (:), and type specifier by 'r' (for raw) or 'n' (for null-terminated). </p> <p>If the field name is "*", then the string length will be determined by the amount of allocated memory.</p>
[Vanara.PInvoke.AssociateAttribute](https://github.com/dahall/Vanara/search?l=C%23&q=AssociateAttribute) | Associates a Guid with an element.
[Vanara.PInvoke.AssociateStringAttribute](https://github.com/dahall/Vanara/search?l=C%23&q=AssociateStringAttribute) | Associates a string with an element.
[Vanara.PInvoke.ClipCorrespondingTypeAttribute](https://github.com/dahall/Vanara/search?l=C%23&q=ClipCorrespondingTypeAttribute) | Indicates the type, medium and method for getting and setting the payload associated with known clipboard formats.
[Vanara.Collections.IEnumFromCom&lt;T&gt;.ComTryGetNext](https://github.com/dahall/Vanara/search?l=C%23&q=ComTryGetNext) | Delegate that gets the next value in an enumeration and returns true or returns false to indicate there are no more items in the enumeration.
[Vanara.InteropServices.CoTaskMemStringMarshaler](https://github.com/dahall/Vanara/search?l=C%23&q=CoTaskMemStringMarshaler) | Marshals strings that are allocated by native code and must be freed using CoTaskMemFree after use.
[System.Runtime.InteropServices.CustomMarshalers.EnumeratorToEnumVariantMarshaler](https://github.com/dahall/Vanara/search?l=C%23&q=EnumeratorToEnumVariantMarshaler) | Marshals the COM <c>IEnumVARIANT</c> interface to the .NET Framework `System.Collections.IEnumerator` interface, and vice versa.
[Vanara.PInvoke.ErrorHelper](https://github.com/dahall/Vanara/search?l=C%23&q=ErrorHelper) | Functions to help get error messages from error codes.
[Vanara.PInvoke.FunctionHelper](https://github.com/dahall/Vanara/search?l=C%23&q=FunctionHelper) | Generic functions to help with standard function patterns like getting a string from a method.
[Vanara.InteropServices.GenericStringMarshaler&lt;T&gt;](https://github.com/dahall/Vanara/search?l=C%23&q=GenericStringMarshaler%26lt%3BT%26gt%3B) | Marshals strings that are allocated by native code and must be freed after use.
[Vanara.InteropServices.GenericStringMarshalerBase&lt;T&gt;](https://github.com/dahall/Vanara/search?l=C%23&q=GenericStringMarshalerBase%26lt%3BT%26gt%3B) | Base abstract class for marshaling strings that are allocated by native code and must be freed after use.
[Vanara.PInvoke.HANDLEConverter](https://github.com/dahall/Vanara/search?l=C%23&q=HANDLEConverter) | Converts a handle to a string or an integer and vice versa. The string representation is the handle value as an integer.
[Vanara.Collections.IEnumeratorFromNext&lt;T&gt;](https://github.com/dahall/Vanara/search?l=C%23&q=IEnumeratorFromNext%26lt%3BT%26gt%3B) | An implementation the `System.Collections.IEnumerator` interface that can iterate through next and reset methods.
[Vanara.Collections.IEnumFromCom&lt;T&gt;](https://github.com/dahall/Vanara/search?l=C%23&q=IEnumFromCom%26lt%3BT%26gt%3B) | Creates an enumerable class from a get next method in the form of HRESULT Next(uint, TItem[], out uint) and a reset method. Useful if a class doesn't support `System.Collections.IEnumerable` or `System.Collections.Generic.IEnumerable` like some COM objects.
[Vanara.Collections.IEnumFromIndexer&lt;T&gt;](https://github.com/dahall/Vanara/search?l=C%23&q=IEnumFromIndexer%26lt%3BT%26gt%3B) | Creates an enumerable class from a counter and an indexer. Useful if a class doesn't support `System.Collections.IEnumerable` or `System.Collections.Generic.IEnumerable` like some COM objects.
[Vanara.Collections.IEnumFromNext&lt;T&gt;](https://github.com/dahall/Vanara/search?l=C%23&q=IEnumFromNext%26lt%3BT%26gt%3B) | Creates an enumerable class from a get next method and a reset method. Useful if a class doesn't support `System.Collections.IEnumerable` or `System.Collections.Generic.IEnumerable` like some COM objects.
[Vanara.PInvoke.FunctionHelper.IidFunc](https://github.com/dahall/Vanara/search?l=C%23&q=IidFunc) | Delegate for functions that use an IID to retrieve an object.
[Vanara.PInvoke.FunctionHelper.IidFunc&lt;T&gt;](https://github.com/dahall/Vanara/search?l=C%23&q=IidFunc%26lt%3BT%26gt%3B) | Delegate for functions that use an IID to retrieve an object.
[Vanara.PInvoke.FunctionHelper.IidFunc1&lt;T&gt;](https://github.com/dahall/Vanara/search?l=C%23&q=IidFunc1%26lt%3BT%26gt%3B) | Delegate for functions that use an IID to retrieve an object.
[Vanara.PInvoke.FunctionHelper.IidFunc1&lt;T&gt;](https://github.com/dahall/Vanara/search?l=C%23&q=IidFunc1%26lt%3BT%26gt%3B) | Delegate for functions that use an IID to retrieve an object.
[Vanara.PInvoke.FunctionHelper.IidFunc2&lt;T&gt;](https://github.com/dahall/Vanara/search?l=C%23&q=IidFunc2%26lt%3BT%26gt%3B) | Delegate for functions that use an IID to retrieve an object.
[Vanara.PInvoke.FunctionHelper.IidFunc2&lt;T&gt;](https://github.com/dahall/Vanara/search?l=C%23&q=IidFunc2%26lt%3BT%26gt%3B) | Delegate for functions that use an IID to retrieve an object.
[Vanara.Windows.Shell.IndirectResource](https://github.com/dahall/Vanara/search?l=C%23&q=IndirectResource) | Wraps a resource reference used by some Shell classes.
[Vanara.Windows.Shell.IndirectString](https://github.com/dahall/Vanara/search?l=C%23&q=IndirectString) | Wraps a string resource reference used by some Shell classes.
[Vanara.PInvoke.Lib](https://github.com/dahall/Vanara/search?l=C%23&q=Lib) | Holds string values for all used external API libraries.
[Vanara.PInvoke.LOGPALETTE](https://github.com/dahall/Vanara/search?l=C%23&q=LOGPALETTE) | The <c>LOGPALETTE</c> structure defines a logical palette.
[Vanara.PInvoke.Macros](https://github.com/dahall/Vanara/search?l=C%23&q=Macros) | Platform invokable enumerated types, constants and functions from windows.h
[Vanara.InteropServices.NullTermStringArrayMarshaler](https://github.com/dahall/Vanara/search?l=C%23&q=NullTermStringArrayMarshaler) | Marshals an array of strings to a concatenated list of strings with an extra NULL terminator.
[Vanara.PInvoke.OverlappedAsync](https://github.com/dahall/Vanara/search?l=C%23&q=OverlappedAsync) | Helper methods to work with asynchronous methods using `System.Threading.NativeOverlapped`.
[Vanara.PInvoke.OverlappedAsync.OverlappedAsyncResult](https://github.com/dahall/Vanara/search?l=C%23&q=OverlappedAsyncResult) | Holds all pertinent information for handling results and errors in an overlapped set of method calls.
[Vanara.PInvoke.PFILETIME](https://github.com/dahall/Vanara/search?l=C%23&q=PFILETIME) | Represents a pointer to a `System.Runtime.InteropServices.ComTypes.FILETIME` structure which holds the number of 100-nanosecond intervals since January 1, 1601. This structure is a 64-bit value.
[Vanara.Extensions.PInvokeClientExtensions](https://github.com/dahall/Vanara/search?l=C%23&q=PInvokeClientExtensions) | Extension methods for `Vanara.PInvoke.PInvokeClient`.
[Vanara.PInvoke.PInvokeDataAttribute](https://github.com/dahall/Vanara/search?l=C%23&q=PInvokeDataAttribute) | Captures information about P/Invoke calls.
[Vanara.PInvoke.PRECT](https://github.com/dahall/Vanara/search?l=C%23&q=PRECT) | Defines the coordinates of the upper-left and lower-right corners of a rectangle.
[Vanara.PInvoke.PSYSTEMTIME](https://github.com/dahall/Vanara/search?l=C%23&q=PSYSTEMTIME) | Specifies a date and time, using individual members for the month, day, year, weekday, hour, minute, second, and millisecond. The time is either in coordinated universal time (UTC) or local time, depending on the function that is being called.
[Vanara.PInvoke.FunctionHelper.PtrFunc&lt;T&gt;](https://github.com/dahall/Vanara/search?l=C%23&q=PtrFunc%26lt%3BT%26gt%3B) | Delegate to get the size of memory allocated to a pointer.
[Vanara.Extensions.RegistryTypeExt](https://github.com/dahall/Vanara/search?l=C%23&q=RegistryTypeExt) | Extension methods for registry types.
[Vanara.InteropServices.SafeAnysizeStruct&lt;T&gt;](https://github.com/dahall/Vanara/search?l=C%23&q=SafeAnysizeStruct%26lt%3BT%26gt%3B) | For structures with a single array as the last field that are intended to be variable length, this class manages the structure and automatically marshals the correct structure to memory.
[Vanara.InteropServices.SafeAnysizeStructBase&lt;T&gt;](https://github.com/dahall/Vanara/search?l=C%23&q=SafeAnysizeStructBase%26lt%3BT%26gt%3B) | For structures with a single array as the last field that are intended to be variable length, this class manages the structure and automatically marshals the correct structure to memory.
[Vanara.InteropServices.SafeAnysizeStructMarshaler&lt;T&gt;](https://github.com/dahall/Vanara/search?l=C%23&q=SafeAnysizeStructMarshaler%26lt%3BT%26gt%3B) | A marshaler implementation of `Vanara.InteropServices.IVanaraMarshaler` to set the marshaler as an attribute using `Vanara.InteropServices.SafeAnysizeStruct`. Use the cookie paramter of `Vanara.InteropServices.SafeAnysizeStructMarshaler.#ctor(System.String)` to specify the name of the field in <typeparamref name="T" /> that specifies the number of elements in the last field of <typeparamref name="T" />.
[Vanara.InteropServices.SafeElementArray&lt;T&gt;](https://github.com/dahall/Vanara/search?l=C%23&q=SafeElementArray%26lt%3BT%26gt%3B) | A safe unmanaged array of structures allocated on the global heap with a prefix type (usually a uint or int) that determines the count of elements.
[Vanara.PInvoke.SafeHANDLE](https://github.com/dahall/Vanara/search?l=C%23&q=SafeHANDLE) | Base class for all native handles.
[Vanara.InteropServices.SafeNativeArray&lt;T&gt;](https://github.com/dahall/Vanara/search?l=C%23&q=SafeNativeArray%26lt%3BT%26gt%3B) | A safe unmanaged array of structures allocated on the global heap. Array size determined by allocated memory size divided by size of structure.
[Vanara.InteropServices.SafeNativeArrayBase&lt;T&gt;](https://github.com/dahall/Vanara/search?l=C%23&q=SafeNativeArrayBase%26lt%3BT%26gt%3B) | A safe unmanaged array of structures. Array size determined by size of structure.
[Vanara.InteropServices.SafeNativeLinkedList&lt;T&gt;](https://github.com/dahall/Vanara/search?l=C%23&q=SafeNativeLinkedList%26lt%3BT%26gt%3B) | A safe unmanaged linked list of structures allocated on the global heap.
[Vanara.InteropServices.SafeNativeListBase&lt;T&gt;](https://github.com/dahall/Vanara/search?l=C%23&q=SafeNativeListBase%26lt%3BT%26gt%3B) | An abstract base class for a safe, unmanaged list of structures allocated by a memory scheme.
[Vanara.PInvoke.SafeResourceId](https://github.com/dahall/Vanara/search?l=C%23&q=SafeResourceId) | Represents a system resource name that can identify as a string, integer, or pointer.
[Vanara.PInvoke.FunctionHelper.SBFunc&lt;T&gt;](https://github.com/dahall/Vanara/search?l=C%23&q=SBFunc%26lt%3BT%26gt%3B) | Delegate that takes and StringBuilder and initial size and returns a result.
[Vanara.PInvoke.FunctionHelper.SBFunc&lt;T&gt;](https://github.com/dahall/Vanara/search?l=C%23&q=SBFunc%26lt%3BT%26gt%3B) | Delegate that takes and StringBuilder and initial size and returns a result.
[Vanara.PInvoke.FunctionHelper.SBFunc&lt;T&gt;](https://github.com/dahall/Vanara/search?l=C%23&q=SBFunc%26lt%3BT%26gt%3B) | Delegate that takes and StringBuilder and initial size and returns a result.
[Vanara.PInvoke.SECURITY_ATTRIBUTES](https://github.com/dahall/Vanara/search?l=C%23&q=SECURITY_ATTRIBUTES) | The SECURITY_ATTRIBUTES structure contains the security descriptor for an object and specifies whether the handle retrieved by specifying this structure is inheritable. This structure provides security settings for objects created by various functions, such as CreateFile, CreatePipe, CreateProcess, RegCreateKeyEx, or RegSaveKeyEx.
[Vanara.PInvoke.FunctionHelper.SizeFunc&lt;T&gt;](https://github.com/dahall/Vanara/search?l=C%23&q=SizeFunc%26lt%3BT%26gt%3B) | Gets a size and returns an error.
[Vanara.PInvoke.StaticFieldValueHash](https://github.com/dahall/Vanara/search?l=C%23&q=StaticFieldValueHash) | Gets a static field's name from its value and caches the list for faster lookups.
[Vanara.InteropServices.StringPtrArrayMarshaler](https://github.com/dahall/Vanara/search?l=C%23&q=StringPtrArrayMarshaler) | Marshals an array of strings to an array of pointers to strings with a NULL pointer at the end of the array.
[Vanara.PInvoke.StructHelper](https://github.com/dahall/Vanara/search?l=C%23&q=StructHelper) | Helper methods for structures.
[Vanara.Collections.TryGetNext&lt;T&gt;](https://github.com/dahall/Vanara/search?l=C%23&q=TryGetNext%26lt%3BT%26gt%3B) | Delegate that gets the next value in an enumeration and returns true or returns false to indicate there are no more items in the enumeration.
[Vanara.Collections.TryGetNext&lt;T&gt;](https://github.com/dahall/Vanara/search?l=C%23&q=TryGetNext%26lt%3BT%26gt%3B) | Delegate that gets the next value in an enumeration and returns true or returns false to indicate there are no more items in the enumeration.
