﻿#pragma warning disable CS1591 // Missing XML comment for publicly visible type or member

namespace Vanara.PInvoke;

public static partial class SensorsApi
{
	/// <summary>Sensor constants defined in sensors.h</summary>
	public static class Sensors
	{
		/////////////////////////////////////////////////////////////////////
		// Sensor Categories
		//

		// {C317C286-C468-4288-9975-D4C4587C442C}
		public static Guid SENSOR_CATEGORY_ALL => new(0XC317C286, 0XC468, 0X4288, 0X99, 0X75, 0XD4, 0XC4, 0X58, 0X7C, 0X44, 0X2C);
		// {BFA794E4-F964-4FDB-90F6-51056BFE4B44}
		public static Guid SENSOR_CATEGORY_LOCATION => new(0XBFA794E4, 0XF964, 0X4FDB, 0X90, 0XF6, 0X51, 0X05, 0X6B, 0XFE, 0X4B, 0X44);
		// {323439AA-7F66-492B-BA0C-73E9AA0A65D5}
		public static Guid SENSOR_CATEGORY_ENVIRONMENTAL => new(0X323439AA, 0X7F66, 0X492B, 0XBA, 0X0C, 0X73, 0XE9, 0XAA, 0X0A, 0X65, 0XD5);
		// {CD09DAF1-3B2E-4C3D-B598-B5E5FF93FD46}
		public static Guid SENSOR_CATEGORY_MOTION => new(0XCD09DAF1, 0X3B2E, 0X4C3D, 0XB5, 0X98, 0XB5, 0XE5, 0XFF, 0X93, 0XFD, 0X46);
		// {9E6C04B6-96FE-4954-B726-68682A473F69}
		public static Guid SENSOR_CATEGORY_ORIENTATION => new(0X9E6C04B6, 0X96FE, 0X4954, 0XB7, 0X26, 0X68, 0X68, 0X2A, 0X47, 0X3F, 0X69);
		// {8D131D68-8EF7-4656-80B5-CCCBD93791C5}
		public static Guid SENSOR_CATEGORY_MECHANICAL => new(0X8D131D68, 0X8EF7, 0X4656, 0X80, 0XB5, 0XCC, 0XCB, 0XD9, 0X37, 0X91, 0XC5);
		// {FB73FCD8-FC4A-483C-AC58-27B691C6BEFF}
		public static Guid SENSOR_CATEGORY_ELECTRICAL => new(0XFB73FCD8, 0XFC4A, 0X483C, 0XAC, 0X58, 0X27, 0XB6, 0X91, 0XC6, 0XBE, 0XFF);
		// {CA19690F-A2C7-477D-A99E-99EC6E2B5648}
		public static Guid SENSOR_CATEGORY_BIOMETRIC => new(0XCA19690F, 0XA2C7, 0X477D, 0XA9, 0X9E, 0X99, 0XEC, 0X6E, 0X2B, 0X56, 0X48);
		// {17A665C0-9063-4216-B202-5C7A255E18CE}
		public static Guid SENSOR_CATEGORY_LIGHT => new(0X17A665C0, 0X9063, 0X4216, 0XB2, 0X02, 0X5C, 0X7A, 0X25, 0X5E, 0X18, 0XCE);
		// {B000E77E-F5B5-420F-815D-0270A726F270}
		public static Guid SENSOR_CATEGORY_SCANNER => new(0XB000E77E, 0XF5B5, 0X420F, 0X81, 0X5D, 0X02, 0X70, 0XA7, 0X26, 0XF2, 0X70);
		// {2C90E7A9-F4C9-4FA2-AF37-56D471FE5A3D}
		public static Guid SENSOR_CATEGORY_OTHER => new(0x2C90E7A9, 0xF4C9, 0x4FA2, 0xAF, 0x37, 0x56, 0xD4, 0x71, 0xFE, 0x5A, 0x3D);
		// {2BEAE7FA-19B0-48C5-A1F6-B5480DC206B0}
		public static Guid SENSOR_CATEGORY_UNSUPPORTED => new(0x2BEAE7fA, 0x19B0, 0x48C5, 0xA1, 0xF6, 0xB5, 0x48, 0x0D, 0xC2, 0x06, 0xB0);

		/////////////////////////////////////////////////////////////////////
		// Sensor Types
		//

		//
		// Location Sensor Types
		//

		// {ED4CA589-327A-4FF9-A560-91DA4B48275E}
		public static Guid SENSOR_TYPE_LOCATION_GPS => new(0XED4CA589, 0X327A, 0X4FF9, 0XA5, 0X60, 0X91, 0XDA, 0X4B, 0X48, 0X27, 0X5E);
		// {095F8184-0FA9-4445-8E6E-B70F320B6B4C}
		public static Guid SENSOR_TYPE_LOCATION_STATIC => new(0X095F8184, 0X0FA9, 0X4445, 0X8E, 0X6E, 0XB7, 0X0F, 0X32, 0X0B, 0X6B, 0X4C);
		// {3B2EAE4A-72CE-436D-96D2-3C5B8570E987}
		public static Guid SENSOR_TYPE_LOCATION_LOOKUP => new(0X3B2EAE4A, 0X72CE, 0X436D, 0X96, 0XD2, 0X3C, 0X5B, 0X85, 0X70, 0XE9, 0X87);
		// {691C341A-5406-4FE1-942F-2246CBEB39E0}
		public static Guid SENSOR_TYPE_LOCATION_TRIANGULATION => new(0X691C341A, 0X5406, 0X4FE1, 0X94, 0X2F, 0X22, 0X46, 0XCB, 0XEB, 0X39, 0XE0);
		// {9B2D0566-0368-4F71-B88D-533F132031DE}
		public static Guid SENSOR_TYPE_LOCATION_OTHER => new(0X9B2D0566, 0X0368, 0X4F71, 0XB8, 0X8D, 0X53, 0X3F, 0X13, 0X20, 0X31, 0XDE);
		// {D26988CF-5162-4039-BB17-4C58B698E44A}
		public static Guid SENSOR_TYPE_LOCATION_BROADCAST => new(0XD26988CF, 0X5162, 0X4039, 0XBB, 0X17, 0X4C, 0X58, 0XB6, 0X98, 0XE4, 0X4A);
		// {1A37D538-F28B-42DA-9FCE-A9D0A2A6D829}
		public static Guid SENSOR_TYPE_LOCATION_DEAD_RECKONING => new(0X1A37D538, 0XF28B, 0X42DA, 0X9F, 0XCE, 0XA9, 0XD0, 0XA2, 0XA6, 0XD8, 0X29);

		//
		// Environmental Sensor Types
		//

		// {04FD0EC4-D5DA-45FA-95A9-5DB38EE19306}
		public static Guid SENSOR_TYPE_ENVIRONMENTAL_TEMPERATURE => new(0X04FD0EC4, 0XD5DA, 0X45FA, 0X95, 0XA9, 0X5D, 0XB3, 0X8E, 0XE1, 0X93, 0X06);
		// {0E903829-FF8A-4A93-97DF-3DCBDE402288}
		public static Guid SENSOR_TYPE_ENVIRONMENTAL_ATMOSPHERIC_PRESSURE => new(0X0E903829, 0XFF8A, 0X4A93, 0X97, 0XDF, 0X3D, 0XCB, 0XDE, 0X40, 0X22, 0X88);
		// {5C72BF67-BD7E-4257-990B-98A3BA3B400A}
		public static Guid SENSOR_TYPE_ENVIRONMENTAL_HUMIDITY => new(0X5C72BF67, 0XBD7E, 0X4257, 0X99, 0X0B, 0X98, 0XA3, 0XBA, 0X3B, 0X40, 0X0A);
		// {DD50607B-A45F-42CD-8EFD-EC61761C4226}
		public static Guid SENSOR_TYPE_ENVIRONMENTAL_WIND_SPEED => new(0XDD50607B, 0XA45F, 0X42CD, 0X8E, 0XFD, 0XEC, 0X61, 0X76, 0X1C, 0X42, 0X26);
		// {9EF57A35-9306-434D-AF09-37FA5A9C00BD}
		public static Guid SENSOR_TYPE_ENVIRONMENTAL_WIND_DIRECTION => new(0X9EF57A35, 0X9306, 0X434D, 0XAF, 0X09, 0X37, 0XFA, 0X5A, 0X9C, 0X00, 0XBD);

		//
		// Motion Sensor Types
		//

		// {C04D2387-7340-4CC2-991E-3B18CB8EF2F4}
		public static Guid SENSOR_TYPE_ACCELEROMETER_1D => new(0XC04D2387, 0X7340, 0X4CC2, 0X99, 0X1E, 0X3B, 0X18, 0XCB, 0X8E, 0XF2, 0XF4);
		// {B2C517A8-F6B5-4BA6-A423-5DF560B4CC07}
		public static Guid SENSOR_TYPE_ACCELEROMETER_2D => new(0XB2C517A8, 0XF6B5, 0X4BA6, 0XA4, 0X23, 0X5D, 0XF5, 0X60, 0XB4, 0XCC, 0X07);
		// {C2FB0F5F-E2D2-4C78-BCD0-352A9582819D}
		public static Guid SENSOR_TYPE_ACCELEROMETER_3D => new(0XC2FB0F5F, 0XE2D2, 0X4C78, 0XBC, 0XD0, 0X35, 0X2A, 0X95, 0X82, 0X81, 0X9D);
		// {5C7C1A12-30A5-43B9-A4B2-CF09EC5B7BE8}
		public static Guid SENSOR_TYPE_MOTION_DETECTOR => new(0X5C7C1A12, 0X30A5, 0X43B9, 0XA4, 0XB2, 0XCF, 0X09, 0XEC, 0X5B, 0X7B, 0XE8);
		// {FA088734-F552-4584-8324-EDFAF649652C}
		public static Guid SENSOR_TYPE_GYROMETER_1D => new(0XFA088734, 0XF552, 0X4584, 0X83, 0X24, 0XED, 0XFA, 0XF6, 0X49, 0X65, 0X2C);
		// {31EF4F83-919B-48BF-8DE0-5D7A9D240556}
		public static Guid SENSOR_TYPE_GYROMETER_2D => new(0X31EF4F83, 0X919B, 0X48BF, 0X8D, 0XE0, 0X5D, 0X7A, 0X9D, 0X24, 0X05, 0X56);
		// {09485F5A-759E-42C2-BD4B-A349B75C8643}
		public static Guid SENSOR_TYPE_GYROMETER_3D => new(0X09485F5A, 0X759E, 0X42C2, 0XBD, 0X4B, 0XA3, 0X49, 0XB7, 0X5C, 0X86, 0X43);
		// {6BD73C1F-0BB4-4310-81B2-DFC18A52BF94}
		public static Guid SENSOR_TYPE_SPEEDOMETER => new(0X6BD73C1F, 0X0BB4, 0X4310, 0X81, 0XB2, 0XDF, 0XC1, 0X8A, 0X52, 0XBF, 0X94);

		//
		// Orientation Sensor Types
		//

		// {A415F6C5-CB50-49D0-8E62-A8270BD7A26C}
		public static Guid SENSOR_TYPE_COMPASS_1D => new(0XA415F6C5, 0XCB50, 0X49D0, 0X8E, 0X62, 0XA8, 0X27, 0X0B, 0XD7, 0XA2, 0X6C);
		// {15655CC0-997A-4D30-84DB-57CABA3648BB}
		public static Guid SENSOR_TYPE_COMPASS_2D => new(0X15655CC0, 0X997A, 0X4D30, 0X84, 0XDB, 0X57, 0XCA, 0XBA, 0X36, 0X48, 0XBB);
		// {76B5CE0D-17DD-414D-93A1-E127F40BDF6E}
		public static Guid SENSOR_TYPE_COMPASS_3D => new(0X76B5CE0D, 0X17DD, 0X414D, 0X93, 0XA1, 0XE1, 0X27, 0XF4, 0X0B, 0XDF, 0X6E);
		// {B96F98C5-7A75-4BA7-94E9-AC868C966DD8}
		public static Guid SENSOR_TYPE_INCLINOMETER_1D => new(0XB96F98C5, 0X7A75, 0X4BA7, 0X94, 0XE9, 0XAC, 0X86, 0X8C, 0X96, 0X6D, 0XD8);
		// {AB140F6D-83EB-4264-B70B-B16A5B256A01}
		public static Guid SENSOR_TYPE_INCLINOMETER_2D => new(0XAB140F6D, 0X83EB, 0X4264, 0XB7, 0X0B, 0XB1, 0X6A, 0X5B, 0X25, 0X6A, 0X01);
		// {B84919FB-EA85-4976-8444-6F6F5C6D31DB}
		public static Guid SENSOR_TYPE_INCLINOMETER_3D => new(0XB84919FB, 0XEA85, 0X4976, 0X84, 0X44, 0X6F, 0X6F, 0X5C, 0X6D, 0X31, 0XDB);
		// {5F14AB2F-1407-4306-A93F-B1DBABE4F9C0}
		public static Guid SENSOR_TYPE_DISTANCE_1D => new(0X5F14AB2F, 0X1407, 0X4306, 0XA9, 0X3F, 0XB1, 0XDB, 0XAB, 0XE4, 0XF9, 0XC0);
		// {5CF9A46C-A9A2-4E55-B6A1-A04AAFA95A92}
		public static Guid SENSOR_TYPE_DISTANCE_2D => new(0X5CF9A46C, 0XA9A2, 0X4E55, 0XB6, 0XA1, 0XA0, 0X4A, 0XAF, 0XA9, 0X5A, 0X92);
		// {A20CAE31-0E25-4772-9FE5-96608A1354B2}
		public static Guid SENSOR_TYPE_DISTANCE_3D => new(0XA20CAE31, 0X0E25, 0X4772, 0X9F, 0XE5, 0X96, 0X60, 0X8A, 0X13, 0X54, 0XB2);
		// {9F81F1AF-C4AB-4307-9904-C828BFB90829}
		public static Guid SENSOR_TYPE_AGGREGATED_QUADRANT_ORIENTATION => new(0X9F81F1AF, 0XC4AB, 0X4307, 0X99, 0X04, 0XC8, 0X28, 0XBF, 0XB9, 0X08, 0X29);
		// {CDB5D8F7-3CFD-41C8-8542-CCE622CF5D6E}
		public static Guid SENSOR_TYPE_AGGREGATED_DEVICE_ORIENTATION => new(0XCDB5D8F7, 0X3CFD, 0X41C8, 0X85, 0X42, 0XCC, 0XE6, 0X22, 0XCF, 0X5D, 0X6E);
		// {86A19291-0482-402C-BF4C-ADDAC52B1C39}
		public static Guid SENSOR_TYPE_AGGREGATED_SIMPLE_DEVICE_ORIENTATION => new(0X86A19291, 0X0482, 0X402C, 0XBF, 0X4C, 0XAD, 0XDA, 0XC5, 0X2B, 0X1C, 0X39);

		//
		// Electrical Sensor Types
		//

		// {C5484637-4FB7-4953-98B8-A56D8AA1FB1E}
		public static Guid SENSOR_TYPE_VOLTAGE => new(0XC5484637, 0X4FB7, 0X4953, 0X98, 0XB8, 0XA5, 0X6D, 0X8A, 0XA1, 0XFB, 0X1E);
		// {5ADC9FCE-15A0-4BBE-A1AD-2D38A9AE831C}
		public static Guid SENSOR_TYPE_CURRENT => new(0X5ADC9FCE, 0X15A0, 0X4BBE, 0XA1, 0XAD, 0X2D, 0X38, 0XA9, 0XAE, 0X83, 0X1C);
		// {CA2FFB1C-2317-49C0-A0B4-B63CE63461A0}
		public static Guid SENSOR_TYPE_CAPACITANCE => new(0XCA2FFB1C, 0X2317, 0X49C0, 0XA0, 0XB4, 0XB6, 0X3C, 0XE6, 0X34, 0X61, 0XA0);
		// {9993D2C8-C157-4A52-A7B5-195C76037231}
		public static Guid SENSOR_TYPE_RESISTANCE => new(0X9993D2C8, 0XC157, 0X4A52, 0XA7, 0XB5, 0X19, 0X5C, 0X76, 0X03, 0X72, 0X31);
		// {DC1D933F-C435-4C7D-A2FE-607192A524D3}
		public static Guid SENSOR_TYPE_INDUCTANCE => new(0XDC1D933F, 0XC435, 0X4C7D, 0XA2, 0XFE, 0X60, 0X71, 0X92, 0XA5, 0X24, 0XD3);
		// {212F10F5-14AB-4376-9A43-A7794098C2FE}
		public static Guid SENSOR_TYPE_ELECTRICAL_POWER => new(0X212F10F5, 0X14AB, 0X4376, 0X9A, 0X43, 0XA7, 0X79, 0X40, 0X98, 0XC2, 0XFE);
		// {2B3681A9-CADC-45AA-A6FF-54957C8BB440}
		public static Guid SENSOR_TYPE_POTENTIOMETER => new(0X2B3681A9, 0XCADC, 0X45AA, 0XA6, 0XFF, 0X54, 0X95, 0X7C, 0X8B, 0XB4, 0X40);
		// {8CD2CBB6-73E6-4640-A709-72AE8FB60D7F}
		public static Guid SENSOR_TYPE_FREQUENCY => new(0X8CD2CBB6, 0X73E6, 0X4640, 0XA7, 0X09, 0X72, 0XAE, 0X8F, 0XB6, 0X0D, 0X7F);

		//
		// Mechanical Sensor Types
		//

		// {9C7E371F-1041-460B-8D5C-71E4752E350C}
		public static Guid SENSOR_TYPE_BOOLEAN_SWITCH => new(0X9C7E371F, 0X1041, 0X460B, 0X8D, 0X5C, 0X71, 0XE4, 0X75, 0X2E, 0X35, 0X0C);
		// {B3EE4D76-37A4-4402-B25E-99C60A775FA1}
		public static Guid SENSOR_TYPE_MULTIVALUE_SWITCH => new(0XB3EE4D76, 0X37A4, 0X4402, 0XB2, 0X5E, 0X99, 0XC6, 0X0A, 0X77, 0X5F, 0XA1);
		// {C2AB2B02-1A1C-4778-A81B-954A1788CC75}
		public static Guid SENSOR_TYPE_FORCE => new(0XC2AB2B02, 0X1A1C, 0X4778, 0XA8, 0X1B, 0X95, 0X4A, 0X17, 0X88, 0XCC, 0X75);
		// {C06DD92C-7FEB-438E-9BF6-82207FFF5BB8}
		public static Guid SENSOR_TYPE_SCALE => new(0XC06DD92C, 0X7FEB, 0X438E, 0X9B, 0XF6, 0X82, 0X20, 0X7F, 0XFF, 0X5B, 0XB8);
		// {26D31F34-6352-41CF-B793-EA0713D53D77}
		public static Guid SENSOR_TYPE_PRESSURE => new(0X26D31F34, 0X6352, 0X41CF, 0XB7, 0X93, 0XEA, 0X07, 0X13, 0XD5, 0X3D, 0X77);
		// {C6D1EC0E-6803-4361-AD3D-85BCC58C6D29}
		public static Guid SENSOR_TYPE_STRAIN => new(0XC6D1EC0E, 0X6803, 0X4361, 0XAD, 0X3D, 0X85, 0XBC, 0XC5, 0X8C, 0X6D, 0X29);
		// {545C8BA5-B143-4545-868F-CA7FD986B4F6}
		public static Guid SENSOR_TYPE_BOOLEAN_SWITCH_ARRAY => new(0X545C8BA5, 0XB143, 0X4545, 0X86, 0X8F, 0XCA, 0X7F, 0XD9, 0X86, 0XB4, 0XF6);

		//
		// Biometric Sensor Types
		//

		// {C138C12B-AD52-451C-9375-87F518FF10C6}
		public static Guid SENSOR_TYPE_HUMAN_PRESENCE => new(0XC138C12B, 0XAD52, 0X451C, 0X93, 0X75, 0X87, 0XF5, 0X18, 0XFF, 0X10, 0XC6);
		// {5220DAE9-3179-4430-9F90-06266D2A34DE}
		public static Guid SENSOR_TYPE_HUMAN_PROXIMITY => new(0X5220DAE9, 0X3179, 0X4430, 0X9F, 0X90, 0X06, 0X26, 0X6D, 0X2A, 0X34, 0XDE);
		// {17DB3018-06C4-4F7D-81AF-9274B7599C27}
		public static Guid SENSOR_TYPE_TOUCH => new(0X17DB3018, 0X06C4, 0X4F7D, 0X81, 0XAF, 0X92, 0X74, 0XB7, 0X59, 0X9C, 0X27);

		//
		// Light Sensor Types
		//

		// {97F115C8-599A-4153-8894-D2D12899918A}
		public static Guid SENSOR_TYPE_AMBIENT_LIGHT => new(0X97F115C8, 0X599A, 0X4153, 0X88, 0X94, 0XD2, 0XD1, 0X28, 0X99, 0X91, 0X8A);

		//
		// Scanner Sensor Types
		//

		// {44328EF5-02DD-4E8D-AD5D-9249832B2ECA}
		public static Guid SENSOR_TYPE_RFID_SCANNER => new(0X44328EF5, 0X02DD, 0X4E8D, 0XAD, 0X5D, 0X92, 0X49, 0X83, 0X2B, 0X2E, 0XCA);
		// {990B3D8F-85BB-45FF-914D-998C04F372DF}
		public static Guid SENSOR_TYPE_BARCODE_SCANNER => new(0X990B3D8F, 0X85BB, 0X45FF, 0X91, 0X4D, 0X99, 0X8C, 0X04, 0XF3, 0X72, 0XDF);


		//
		// Custom Sensor Types
		//

		// {E83AF229-8640-4D18-A213-E22675EBB2C3}
		public static Guid SENSOR_TYPE_CUSTOM => new(0XE83AF229, 0X8640, 0X4D18, 0XA2, 0X13, 0XE2, 0X26, 0X75, 0XEB, 0XB2, 0XC3);

		//
		// Unknown Sensor Types
		//

		// {10BA83E3-EF4F-41ED-9885-A87D6435A8E1}
		public static Guid SENSOR_TYPE_UNKNOWN => new(0X10BA83E3, 0XEF4F, 0X41ED, 0X98, 0X85, 0XA8, 0X7D, 0X64, 0X35, 0XA8, 0XE1);


		/////////////////////////////////////////////////////////////////////
		// Sensor Data Types
		//

		//
		// Common Sensor Data Types
		//

		// {DB5E0CF2-CF1F-4C18-B46C-D86011D62150}
		public static Guid SENSOR_DATA_TYPE_COMMON_GUID => new(0XDB5E0CF2, 0XCF1F, 0X4C18, 0XB4, 0X6C, 0XD8, 0X60, 0X11, 0XD6, 0X21, 0X50);
		public static PROPERTYKEY SENSOR_DATA_TYPE_TIMESTAMP => new(new(0XDB5E0CF2, 0XCF1F, 0X4C18, 0XB4, 0X6C, 0XD8, 0X60, 0X11, 0XD6, 0X21, 0X50), 2); //[VT_FILETIME]

		//
		// Location Sensor Data Types
		//

		// {055C74D8-CA6F-47D6-95C6-1ED3637A0FF4}
		public static Guid SENSOR_DATA_TYPE_LOCATION_GUID => new(0X055C74D8, 0XCA6F, 0X47D6, 0X95, 0XC6, 0X1E, 0XD3, 0X63, 0X7A, 0X0F, 0XF4);
		// SENSOR_DATA_TYPE_LATITUDE: Degrees latitude where North is positive
		public static PROPERTYKEY SENSOR_DATA_TYPE_LATITUDE_DEGREES => new(new(0X055C74D8, 0XCA6F, 0X47D6, 0X95, 0XC6, 0X1E, 0XD3, 0X63, 0X7A, 0X0F, 0XF4), 2); //[VT_R8]
																																								  // SENSOR_DATA_TYPE_LONGITUDE: Degrees longitude where East is positive
		public static PROPERTYKEY SENSOR_DATA_TYPE_LONGITUDE_DEGREES => new(new(0X055C74D8, 0XCA6F, 0X47D6, 0X95, 0XC6, 0X1E, 0XD3, 0X63, 0X7A, 0X0F, 0XF4), 3); //[VT_R8]
																																								   // SENSOR_DATA_TYPE_ALTITUDE_SEALEVEL_METERS: Altitude with regards to sea level, in meters
		public static PROPERTYKEY SENSOR_DATA_TYPE_ALTITUDE_SEALEVEL_METERS => new(new(0X055C74D8, 0XCA6F, 0X47D6, 0X95, 0XC6, 0X1E, 0XD3, 0X63, 0X7A, 0X0F, 0XF4), 4); //[VT_R8]
																																										  // SENSOR_DATA_TYPE_ALTITUDE_ELLIPSOID_METERS: Altitude with regards to ellipsoid, in meters
		public static PROPERTYKEY SENSOR_DATA_TYPE_ALTITUDE_ELLIPSOID_METERS => new(new(0X055C74D8, 0XCA6F, 0X47D6, 0X95, 0XC6, 0X1E, 0XD3, 0X63, 0X7A, 0X0F, 0XF4), 5); //[VT_R8]
																																										   // SENSOR_DATA_TYPE_SPEED_KNOTS: Speed measured in knots
		public static PROPERTYKEY SENSOR_DATA_TYPE_SPEED_KNOTS => new(new(0X055C74D8, 0XCA6F, 0X47D6, 0X95, 0XC6, 0X1E, 0XD3, 0X63, 0X7A, 0X0F, 0XF4), 6); //[VT_R8]
																																							 // SENSOR_DATA_TYPE_TRUE_HEADING_DEGREES: Heading relative to true North in degrees
		public static PROPERTYKEY SENSOR_DATA_TYPE_TRUE_HEADING_DEGREES => new(new(0X055C74D8, 0XCA6F, 0X47D6, 0X95, 0XC6, 0X1E, 0XD3, 0X63, 0X7A, 0X0F, 0XF4), 7); //[VT_R8]
																																									  // SENSOR_DATA_TYPE_MAGNETIC_HEADING_DEGREES: Heading relative to magnetic North in degrees
		public static PROPERTYKEY SENSOR_DATA_TYPE_MAGNETIC_HEADING_DEGREES => new(new(0X055C74D8, 0XCA6F, 0X47D6, 0X95, 0XC6, 0X1E, 0XD3, 0X63, 0X7A, 0X0F, 0XF4), 8); //[VT_R8]
																																										  // SENSOR_DATA_TYPE_MAGNETIC_VARIATION: Magnetic variation. East is positive
		public static PROPERTYKEY SENSOR_DATA_TYPE_MAGNETIC_VARIATION => new(new(0X055C74D8, 0XCA6F, 0X47D6, 0X95, 0XC6, 0X1E, 0XD3, 0X63, 0X7A, 0X0F, 0XF4), 9); //[VT_R8]
																																									// SENSOR_DATA_TYPE_FIX_QUALITY: Quality of fix
		public static PROPERTYKEY SENSOR_DATA_TYPE_FIX_QUALITY => new(new(0X055C74D8, 0XCA6F, 0X47D6, 0X95, 0XC6, 0X1E, 0XD3, 0X63, 0X7A, 0X0F, 0XF4), 10); //[VT_I4]
																																							  // SENSOR_DATA_TYPE_FIX_TYPE: Fix Type
		public static PROPERTYKEY SENSOR_DATA_TYPE_FIX_TYPE => new(new(0X055C74D8, 0XCA6F, 0X47D6, 0X95, 0XC6, 0X1E, 0XD3, 0X63, 0X7A, 0X0F, 0XF4), 11); //[VT_I4]
																																						   // SENSOR_DATA_TYPE_POSITION_DILUTION_OF_PRECISION: Position Dilution of Precision
		public static PROPERTYKEY SENSOR_DATA_TYPE_POSITION_DILUTION_OF_PRECISION => new(new(0X055C74D8, 0XCA6F, 0X47D6, 0X95, 0XC6, 0X1E, 0XD3, 0X63, 0X7A, 0X0F, 0XF4), 12); //[VT_R8]
																																												 // SENSOR_DATA_TYPE_HORIZONAL_DILUTION_OF_PRECISION: HORIZONTAL Dilution of Precision
		public static PROPERTYKEY SENSOR_DATA_TYPE_HORIZONAL_DILUTION_OF_PRECISION => new(new(0X055C74D8, 0XCA6F, 0X47D6, 0X95, 0XC6, 0X1E, 0XD3, 0X63, 0X7A, 0X0F, 0XF4), 13); //[VT_R8]
																																												  // SENSOR_DATA_TYPE_VERTICAL_DILUTION_OF_PRECISION: VERTICAL Dilution of Precision
		public static PROPERTYKEY SENSOR_DATA_TYPE_VERTICAL_DILUTION_OF_PRECISION => new(new(0X055C74D8, 0XCA6F, 0X47D6, 0X95, 0XC6, 0X1E, 0XD3, 0X63, 0X7A, 0X0F, 0XF4), 14); //[VT_R8]
																																												 // SENSOR_DATA_TYPE_SATELLITES_USED_COUNT: Number of satellites used in solution
		public static PROPERTYKEY SENSOR_DATA_TYPE_SATELLITES_USED_COUNT => new(new(0X055C74D8, 0XCA6F, 0X47D6, 0X95, 0XC6, 0X1E, 0XD3, 0X63, 0X7A, 0X0F, 0XF4), 15); //[VT_I4]
																																										// SENSOR_DATA_TYPE_SATELLITES_USED_PRNS: PRN numbers of satellites used in the solution
		public static PROPERTYKEY SENSOR_DATA_TYPE_SATELLITES_USED_PRNS => new(new(0X055C74D8, 0XCA6F, 0X47D6, 0X95, 0XC6, 0X1E, 0XD3, 0X63, 0X7A, 0X0F, 0XF4), 16); //[VT_VECTOR | VT_UI1]
																																									   // SENSOR_DATA_TYPE_SATELLITES_IN_VIEW: Number of satellites in view.  From 0-GPS_MAX_SATELLITES
		public static PROPERTYKEY SENSOR_DATA_TYPE_SATELLITES_IN_VIEW => new(new(0X055C74D8, 0XCA6F, 0X47D6, 0X95, 0XC6, 0X1E, 0XD3, 0X63, 0X7A, 0X0F, 0XF4), 17); //[VT_I4]
																																									 // SENSOR_DATA_TYPE_SATELLITES_IN_VIEW_PRNS: PRN numbers of satellites in view
		public static PROPERTYKEY SENSOR_DATA_TYPE_SATELLITES_IN_VIEW_PRNS => new(new(0X055C74D8, 0XCA6F, 0X47D6, 0X95, 0XC6, 0X1E, 0XD3, 0X63, 0X7A, 0X0F, 0XF4), 18); //[VT_VECTOR | VT_UI1]
																																										  // SENSOR_DATA_TYPE_SATELLITES_IN_VIEW_ELEVATION: Elevation of each sattellite in view
		public static PROPERTYKEY SENSOR_DATA_TYPE_SATELLITES_IN_VIEW_ELEVATION => new(new(0X055C74D8, 0XCA6F, 0X47D6, 0X95, 0XC6, 0X1E, 0XD3, 0X63, 0X7A, 0X0F, 0XF4), 19); //[VT_VECTOR | VT_UI1]
																																											   // SENSOR_DATA_TYPE_SATELLITES_IN_VIEW_AZIMUTH: Azimuth of each satellite in view
		public static PROPERTYKEY SENSOR_DATA_TYPE_SATELLITES_IN_VIEW_AZIMUTH => new(new(0X055C74D8, 0XCA6F, 0X47D6, 0X95, 0XC6, 0X1E, 0XD3, 0X63, 0X7A, 0X0F, 0XF4), 20); //[VT_VECTOR | VT_UI1
																																											 // SENSOR_DATA_TYPE_SATELLITES_IN_VIEW_STN_RATIO: Signal to noise ratio for each satellite in view
		public static PROPERTYKEY SENSOR_DATA_TYPE_SATELLITES_IN_VIEW_STN_RATIO => new(new(0X055C74D8, 0XCA6F, 0X47D6, 0X95, 0XC6, 0X1E, 0XD3, 0X63, 0X7A, 0X0F, 0XF4), 21); //[VT_VECTOR | VT_UI1]
																																											   // SENSOR_DATA_TYPE_ERROR_RADIUS_METERS: Accuracy of Latitude and Longitude values
		public static PROPERTYKEY SENSOR_DATA_TYPE_ERROR_RADIUS_METERS => new(new(0X055C74D8, 0XCA6F, 0X47D6, 0X95, 0XC6, 0X1E, 0XD3, 0X63, 0X7A, 0X0F, 0XF4), 22); //[VT_R8]
																																									  // SENSOR_DATA_TYPE_ADDRESS1: AddressLine1
		public static PROPERTYKEY SENSOR_DATA_TYPE_ADDRESS1 => new(new(0X055C74D8, 0XCA6F, 0X47D6, 0X95, 0XC6, 0X1E, 0XD3, 0X63, 0X7A, 0X0F, 0XF4), 23); //[VT_LPWSTR]
																																						   // SENSOR_DATA_TYPE_ADDRESS2: AddressLine2
		public static PROPERTYKEY SENSOR_DATA_TYPE_ADDRESS2 => new(new(0X055C74D8, 0XCA6F, 0X47D6, 0X95, 0XC6, 0X1E, 0XD3, 0X63, 0X7A, 0X0F, 0XF4), 24); //[VT_LPWSTR]
																																						   // SENSOR_DATA_TYPE_CITY: City
		public static PROPERTYKEY SENSOR_DATA_TYPE_CITY => new(new(0X055C74D8, 0XCA6F, 0X47D6, 0X95, 0XC6, 0X1E, 0XD3, 0X63, 0X7A, 0X0F, 0XF4), 25); //[VT_LPWSTR]
																																					   // SENSOR_DATA_TYPE_STATE_PROVINCE: State/Province
		public static PROPERTYKEY SENSOR_DATA_TYPE_STATE_PROVINCE => new(new(0X055C74D8, 0XCA6F, 0X47D6, 0X95, 0XC6, 0X1E, 0XD3, 0X63, 0X7A, 0X0F, 0XF4), 26); //[VT_LPWSTR]
																																								 // SENSOR_DATA_TYPE_POSTALCODE: Postal Code (e.g. ZIP)
		public static PROPERTYKEY SENSOR_DATA_TYPE_POSTALCODE => new(new(0X055C74D8, 0XCA6F, 0X47D6, 0X95, 0XC6, 0X1E, 0XD3, 0X63, 0X7A, 0X0F, 0XF4), 27); //[VT_LPWSTR]
																																							 // SENSOR_DATA_TYPE_COUNTRY_REGION: Country/Region
		public static PROPERTYKEY SENSOR_DATA_TYPE_COUNTRY_REGION => new(new(0X055C74D8, 0XCA6F, 0X47D6, 0X95, 0XC6, 0X1E, 0XD3, 0X63, 0X7A, 0X0F, 0XF4), 28); //[VT_LPWSTR]
																																								 // SENSOR_DATA_TYPE_ALTITUDE_ELLIPSOID_ERROR_METERS: Altitude Error with regards to ellipsoid, in meters
		public static PROPERTYKEY SENSOR_DATA_TYPE_ALTITUDE_ELLIPSOID_ERROR_METERS => new(new(0X055C74D8, 0XCA6F, 0X47D6, 0X95, 0XC6, 0X1E, 0XD3, 0X63, 0X7A, 0X0F, 0XF4), 29); //[VT_R8]
																																												  // SENSOR_DATA_TYPE_ALTITUDE_SEALEVEL_ERROR_METERS: Altitude Error with regards to sea level, in meters
		public static PROPERTYKEY SENSOR_DATA_TYPE_ALTITUDE_SEALEVEL_ERROR_METERS => new(new(0X055C74D8, 0XCA6F, 0X47D6, 0X95, 0XC6, 0X1E, 0XD3, 0X63, 0X7A, 0X0F, 0XF4), 30); //[VT_R8]
																																												 // SENSOR_DATA_TYPE_GPS_SELECTION_MODE:
		public static PROPERTYKEY SENSOR_DATA_TYPE_GPS_SELECTION_MODE => new(new(0X055C74D8, 0XCA6F, 0X47D6, 0X95, 0XC6, 0X1E, 0XD3, 0X63, 0X7A, 0X0F, 0XF4), 31); //[VT_I4]
																																									 // SENSOR_DATA_TYPE_GPS_OPERATION_MODE:
		public static PROPERTYKEY SENSOR_DATA_TYPE_GPS_OPERATION_MODE => new(new(0X055C74D8, 0XCA6F, 0X47D6, 0X95, 0XC6, 0X1E, 0XD3, 0X63, 0X7A, 0X0F, 0XF4), 32); //[VT_I4]
																																									 // SENSOR_DATA_TYPE_GPS_STATUS:
		public static PROPERTYKEY SENSOR_DATA_TYPE_GPS_STATUS => new(new(0X055C74D8, 0XCA6F, 0X47D6, 0X95, 0XC6, 0X1E, 0XD3, 0X63, 0X7A, 0X0F, 0XF4), 33); //[VT_I4]
																																							 // SENSOR_DATA_TYPE_GEOIDAL_SEPARATION:
		public static PROPERTYKEY SENSOR_DATA_TYPE_GEOIDAL_SEPARATION => new(new(0X055C74D8, 0XCA6F, 0X47D6, 0X95, 0XC6, 0X1E, 0XD3, 0X63, 0X7A, 0X0F, 0XF4), 34); //[VT_R8]
																																									 // SENSOR_DATA_TYPE_DGPS_DATA_AGE:
		public static PROPERTYKEY SENSOR_DATA_TYPE_DGPS_DATA_AGE => new(new(0X055C74D8, 0XCA6F, 0X47D6, 0X95, 0XC6, 0X1E, 0XD3, 0X63, 0X7A, 0X0F, 0XF4), 35); //[VT_R8]
																																								// SENSOR_DATA_TYPE_ALTITUDE_ANTENNA_SEALEVEL_METERS:
		public static PROPERTYKEY SENSOR_DATA_TYPE_ALTITUDE_ANTENNA_SEALEVEL_METERS => new(new(0X055C74D8, 0XCA6F, 0X47D6, 0X95, 0XC6, 0X1E, 0XD3, 0X63, 0X7A, 0X0F, 0XF4), 36); //[VT_R8]
																																												   // SENSOR_DATA_TYPE_DIFFERENTIAL_REFERENCE_STATION_ID:
		public static PROPERTYKEY SENSOR_DATA_TYPE_DIFFERENTIAL_REFERENCE_STATION_ID => new(new(0X055C74D8, 0XCA6F, 0X47D6, 0X95, 0XC6, 0X1E, 0XD3, 0X63, 0X7A, 0X0F, 0XF4), 37); //[VT_I4]
																																													// SENSOR_DATA_TYPE_NMEA_SENTENCE:
		public static PROPERTYKEY SENSOR_DATA_TYPE_NMEA_SENTENCE => new(new(0X055C74D8, 0XCA6F, 0X47D6, 0X95, 0XC6, 0X1E, 0XD3, 0X63, 0X7A, 0X0F, 0XF4), 38); //[VT_LPWSTR]
																																								// SENSOR_DATA_TYPE_SATELLITES_IN_VIEW_ID:
		public static PROPERTYKEY SENSOR_DATA_TYPE_SATELLITES_IN_VIEW_ID => new(new(0X055C74D8, 0XCA6F, 0X47D6, 0X95, 0XC6, 0X1E, 0XD3, 0X63, 0X7A, 0X0F, 0XF4), 39); //[VT_VECTOR|VT_UI1]
																																										// SENSOR_DATA_TYPE_LOCATION_SOURCE:
		public static PROPERTYKEY SENSOR_DATA_TYPE_LOCATION_SOURCE => new(new(0X055C74D8, 0XCA6F, 0X47D6, 0X95, 0XC6, 0X1E, 0XD3, 0X63, 0X7A, 0X0F, 0XF4), 40); //[VT_UI4]
		// SENSOR_DATA_TYPE_SATELLITES_USED_PRNS_AND_CONSTELLATIONS: PRN numbers and constellation information of satellites used in the solution
		public static PROPERTYKEY SENSOR_DATA_TYPE_SATELLITES_USED_PRNS_AND_CONSTELLATIONS => new(new(0X055C74D8, 0XCA6F, 0X47D6, 0X95, 0XC6, 0X1E, 0XD3, 0X63, 0X7A, 0X0F, 0XF4), 41); //[VT_VECTOR | VT_UI2]

		//
		// Environmental Sensor Data Types
		//

		// {8B0AA2F1-2D57-42EE-8CC0-4D27622B46C4}
		public static Guid SENSOR_DATA_TYPE_ENVIRONMENTAL_GUID => new(0X8B0AA2F1, 0X2D57, 0X42EE, 0X8C, 0XC0, 0X4D, 0X27, 0X62, 0X2B, 0X46, 0XC4);
		public static PROPERTYKEY SENSOR_DATA_TYPE_TEMPERATURE_CELSIUS => new(new(0X8B0AA2F1, 0X2D57, 0X42EE, 0X8C, 0XC0, 0X4D, 0X27, 0X62, 0X2B, 0X46, 0XC4), 2); //[VT_R4]
		public static PROPERTYKEY SENSOR_DATA_TYPE_RELATIVE_HUMIDITY_PERCENT => new(new(0X8B0AA2F1, 0X2D57, 0X42EE, 0X8C, 0XC0, 0X4D, 0X27, 0X62, 0X2B, 0X46, 0XC4), 3); //[VT_R4]
		public static PROPERTYKEY SENSOR_DATA_TYPE_ATMOSPHERIC_PRESSURE_BAR => new(new(0X8B0AA2F1, 0X2D57, 0X42EE, 0X8C, 0XC0, 0X4D, 0X27, 0X62, 0X2B, 0X46, 0XC4), 4); //[VT_R4]
		public static PROPERTYKEY SENSOR_DATA_TYPE_WIND_DIRECTION_DEGREES_ANTICLOCKWISE => new(new(0X8B0AA2F1, 0X2D57, 0X42EE, 0X8C, 0XC0, 0X4D, 0X27, 0X62, 0X2B, 0X46, 0XC4), 5); //[VT_R4]
		public static PROPERTYKEY SENSOR_DATA_TYPE_WIND_SPEED_METERS_PER_SECOND => new(new(0X8B0AA2F1, 0X2D57, 0X42EE, 0X8C, 0XC0, 0X4D, 0X27, 0X62, 0X2B, 0X46, 0XC4), 6); //[VT_R4]


		//
		// Motion Sensor Data Types
		//

		// {3F8A69A2-07C5-4E48-A965-CD797AAB56D5}
		public static Guid SENSOR_DATA_TYPE_MOTION_GUID => new(0X3F8A69A2, 0X7C5, 0X4E48, 0XA9, 0X65, 0XCD, 0X79, 0X7A, 0XAB, 0X56, 0XD5);
		// Accelerometer Data Types
		public static PROPERTYKEY SENSOR_DATA_TYPE_ACCELERATION_X_G => new(new(0X3F8A69A2, 0X7C5, 0X4E48, 0XA9, 0X65, 0XCD, 0X79, 0X7A, 0XAB, 0X56, 0XD5), 2); //[VT_R8]
		public static PROPERTYKEY SENSOR_DATA_TYPE_ACCELERATION_Y_G => new(new(0X3F8A69A2, 0X7C5, 0X4E48, 0XA9, 0X65, 0XCD, 0X79, 0X7A, 0XAB, 0X56, 0XD5), 3); //[VT_R8]
		public static PROPERTYKEY SENSOR_DATA_TYPE_ACCELERATION_Z_G => new(new(0X3F8A69A2, 0X7C5, 0X4E48, 0XA9, 0X65, 0XCD, 0X79, 0X7A, 0XAB, 0X56, 0XD5), 4); //[VT_R8]
																																								 // Gyrometer Data Types
		public static PROPERTYKEY SENSOR_DATA_TYPE_ANGULAR_ACCELERATION_X_DEGREES_PER_SECOND_SQUARED => new(new(0X3F8A69A2, 0X7C5, 0X4E48, 0XA9, 0X65, 0XCD, 0X79, 0X7A, 0XAB, 0X56, 0XD5), 5); //[VT_R8]
		public static PROPERTYKEY SENSOR_DATA_TYPE_ANGULAR_ACCELERATION_Y_DEGREES_PER_SECOND_SQUARED => new(new(0X3F8A69A2, 0X7C5, 0X4E48, 0XA9, 0X65, 0XCD, 0X79, 0X7A, 0XAB, 0X56, 0XD5), 6); //[VT_R8]
		public static PROPERTYKEY SENSOR_DATA_TYPE_ANGULAR_ACCELERATION_Z_DEGREES_PER_SECOND_SQUARED => new(new(0X3F8A69A2, 0X7C5, 0X4E48, 0XA9, 0X65, 0XCD, 0X79, 0X7A, 0XAB, 0X56, 0XD5), 7); //[VT_R8]
		public static PROPERTYKEY SENSOR_DATA_TYPE_SPEED_METERS_PER_SECOND => new(new(0X3F8A69A2, 0X7C5, 0X4E48, 0XA9, 0X65, 0XCD, 0X79, 0X7A, 0XAB, 0X56, 0XD5), 8); //[VT_R8]
		public static PROPERTYKEY SENSOR_DATA_TYPE_MOTION_STATE => new(new(0X3F8A69A2, 0X7C5, 0X4E48, 0XA9, 0X65, 0XCD, 0X79, 0X7A, 0XAB, 0X56, 0XD5), 9); //[VT_BOOL]
																																							 // Additional Motion Data Types
		public static PROPERTYKEY SENSOR_DATA_TYPE_ANGULAR_VELOCITY_X_DEGREES_PER_SECOND => new(new(0X3F8A69A2, 0X7C5, 0X4E48, 0XA9, 0X65, 0XCD, 0X79, 0X7A, 0XAB, 0X56, 0XD5), 10); //[VT_R8]
		public static PROPERTYKEY SENSOR_DATA_TYPE_ANGULAR_VELOCITY_Y_DEGREES_PER_SECOND => new(new(0X3F8A69A2, 0X7C5, 0X4E48, 0XA9, 0X65, 0XCD, 0X79, 0X7A, 0XAB, 0X56, 0XD5), 11); //[VT_R8]
		public static PROPERTYKEY SENSOR_DATA_TYPE_ANGULAR_VELOCITY_Z_DEGREES_PER_SECOND => new(new(0X3F8A69A2, 0X7C5, 0X4E48, 0XA9, 0X65, 0XCD, 0X79, 0X7A, 0XAB, 0X56, 0XD5), 12); //[VT_R8]

		//
		// Orientation Sensor Data Types
		//

		// {1637D8A2-4248-4275-865D-558DE84AEDFD}
		public static Guid SENSOR_DATA_TYPE_ORIENTATION_GUID => new(0X1637D8A2, 0X4248, 0X4275, 0X86, 0X5D, 0X55, 0X8D, 0XE8, 0X4A, 0XED, 0XFD);
		// Inclinometer Data Types
		public static PROPERTYKEY SENSOR_DATA_TYPE_TILT_X_DEGREES => new(new(0X1637D8A2, 0X4248, 0X4275, 0X86, 0X5D, 0X55, 0X8D, 0XE8, 0X4A, 0XED, 0XFD), 2); //[VT_R4]
		public static PROPERTYKEY SENSOR_DATA_TYPE_TILT_Y_DEGREES => new(new(0X1637D8A2, 0X4248, 0X4275, 0X86, 0X5D, 0X55, 0X8D, 0XE8, 0X4A, 0XED, 0XFD), 3); //[VT_R4]
		public static PROPERTYKEY SENSOR_DATA_TYPE_TILT_Z_DEGREES => new(new(0X1637D8A2, 0X4248, 0X4275, 0X86, 0X5D, 0X55, 0X8D, 0XE8, 0X4A, 0XED, 0XFD), 4); //[VT_R4]
																																								// Compass Data Types
		public static PROPERTYKEY SENSOR_DATA_TYPE_MAGNETIC_HEADING_X_DEGREES => new(new(0X1637D8A2, 0X4248, 0X4275, 0X86, 0X5D, 0X55, 0X8D, 0XE8, 0X4A, 0XED, 0XFD), 5); //[VT_R4]
		public static PROPERTYKEY SENSOR_DATA_TYPE_MAGNETIC_HEADING_Y_DEGREES => new(new(0X1637D8A2, 0X4248, 0X4275, 0X86, 0X5D, 0X55, 0X8D, 0XE8, 0X4A, 0XED, 0XFD), 6); //[VT_R4]
		public static PROPERTYKEY SENSOR_DATA_TYPE_MAGNETIC_HEADING_Z_DEGREES => new(new(0X1637D8A2, 0X4248, 0X4275, 0X86, 0X5D, 0X55, 0X8D, 0XE8, 0X4A, 0XED, 0XFD), 7); //[VT_R4]
																																											// Distance Data Types
		public static PROPERTYKEY SENSOR_DATA_TYPE_DISTANCE_X_METERS => new(new(0X1637D8A2, 0X4248, 0X4275, 0X86, 0X5D, 0X55, 0X8D, 0XE8, 0X4A, 0XED, 0XFD), 8); //[VT_R4]
		public static PROPERTYKEY SENSOR_DATA_TYPE_DISTANCE_Y_METERS => new(new(0X1637D8A2, 0X4248, 0X4275, 0X86, 0X5D, 0X55, 0X8D, 0XE8, 0X4A, 0XED, 0XFD), 9); //[VT_R4]
		public static PROPERTYKEY SENSOR_DATA_TYPE_DISTANCE_Z_METERS => new(new(0X1637D8A2, 0X4248, 0X4275, 0X86, 0X5D, 0X55, 0X8D, 0XE8, 0X4A, 0XED, 0XFD), 10); //[VT_R4]
																																									// Additional Compass Data Types
		public static PROPERTYKEY SENSOR_DATA_TYPE_MAGNETIC_HEADING_COMPENSATED_MAGNETIC_NORTH_DEGREES => new(new(0X1637D8A2, 0X4248, 0X4275, 0X86, 0X5D, 0X55, 0X8D, 0XE8, 0X4A, 0XED, 0XFD), 11); //[VT_R8]
		public static PROPERTYKEY SENSOR_DATA_TYPE_MAGNETIC_HEADING_COMPENSATED_TRUE_NORTH_DEGREES => new(new(0X1637D8A2, 0X4248, 0X4275, 0X86, 0X5D, 0X55, 0X8D, 0XE8, 0X4A, 0XED, 0XFD), 12); //[VT_R8]
		public static PROPERTYKEY SENSOR_DATA_TYPE_MAGNETIC_HEADING_MAGNETIC_NORTH_DEGREES => new(new(0X1637D8A2, 0X4248, 0X4275, 0X86, 0X5D, 0X55, 0X8D, 0XE8, 0X4A, 0XED, 0XFD), 13); //[VT_R8]
		public static PROPERTYKEY SENSOR_DATA_TYPE_MAGNETIC_HEADING_TRUE_NORTH_DEGREES => new(new(0X1637D8A2, 0X4248, 0X4275, 0X86, 0X5D, 0X55, 0X8D, 0XE8, 0X4A, 0XED, 0XFD), 14); //[VT_R8]
																																													  // Additional Orientation Data Types
		public static PROPERTYKEY SENSOR_DATA_TYPE_QUADRANT_ANGLE_DEGREES => new(new(0X1637D8A2, 0X4248, 0X4275, 0X86, 0X5D, 0X55, 0X8D, 0XE8, 0X4A, 0XED, 0XFD), 15); //[VT_R8]
		public static PROPERTYKEY SENSOR_DATA_TYPE_ROTATION_MATRIX => new(new(0X1637D8A2, 0X4248, 0X4275, 0X86, 0X5D, 0X55, 0X8D, 0XE8, 0X4A, 0XED, 0XFD), 16); //[VT_VECTOR|VT_UI1]
		public static PROPERTYKEY SENSOR_DATA_TYPE_QUATERNION => new(new(0X1637D8A2, 0X4248, 0X4275, 0X86, 0X5D, 0X55, 0X8D, 0XE8, 0X4A, 0XED, 0XFD), 17); //[VT_VECTOR|VT_UI1]
		public static PROPERTYKEY SENSOR_DATA_TYPE_SIMPLE_DEVICE_ORIENTATION => new(new(0X1637D8A2, 0X4248, 0X4275, 0X86, 0X5D, 0X55, 0X8D, 0XE8, 0X4A, 0XED, 0XFD), 18); //[VT_UI4]
																																											// Compass (Magnetometer) Data Types
		public static PROPERTYKEY SENSOR_DATA_TYPE_MAGNETIC_FIELD_STRENGTH_X_MILLIGAUSS => new(new(0X1637D8A2, 0X4248, 0X4275, 0X86, 0X5D, 0X55, 0X8D, 0XE8, 0X4A, 0XED, 0XFD), 19); //[VT_R8]
		public static PROPERTYKEY SENSOR_DATA_TYPE_MAGNETIC_FIELD_STRENGTH_Y_MILLIGAUSS => new(new(0X1637D8A2, 0X4248, 0X4275, 0X86, 0X5D, 0X55, 0X8D, 0XE8, 0X4A, 0XED, 0XFD), 20); //[VT_R8]
		public static PROPERTYKEY SENSOR_DATA_TYPE_MAGNETIC_FIELD_STRENGTH_Z_MILLIGAUSS => new(new(0X1637D8A2, 0X4248, 0X4275, 0X86, 0X5D, 0X55, 0X8D, 0XE8, 0X4A, 0XED, 0XFD), 21); //[VT_R8]
																																													   // Magnetometer Accuracy Data Types
		public static PROPERTYKEY SENSOR_DATA_TYPE_MAGNETOMETER_ACCURACY => new(new(0X1637D8A2, 0X4248, 0X4275, 0X86, 0X5D, 0X55, 0X8D, 0XE8, 0X4A, 0XED, 0XFD), 22); //[VT_I4]

		//
		// Mechanical Sensor Data Types
		//

		// {38564A7C-F2F2-49BB-9B2B-BA60F66A58DF}
		public static Guid SENSOR_DATA_TYPE_GUID_MECHANICAL_GUID => new(0X38564A7C, 0XF2F2, 0X49BB, 0X9B, 0X2B, 0XBA, 0X60, 0XF6, 0X6A, 0X58, 0XDF);
		public static PROPERTYKEY SENSOR_DATA_TYPE_BOOLEAN_SWITCH_STATE => new(new(0X38564A7C, 0XF2F2, 0X49BB, 0X9B, 0X2B, 0XBA, 0X60, 0XF6, 0X6A, 0X58, 0XDF), 2); //[VT_BOOL]
		public static PROPERTYKEY SENSOR_DATA_TYPE_MULTIVALUE_SWITCH_STATE => new(new(0X38564A7C, 0XF2F2, 0X49BB, 0X9B, 0X2B, 0XBA, 0X60, 0XF6, 0X6A, 0X58, 0XDF), 3); //[VT_R8]
		public static PROPERTYKEY SENSOR_DATA_TYPE_FORCE_NEWTONS => new(new(0X38564A7C, 0XF2F2, 0X49BB, 0X9B, 0X2B, 0XBA, 0X60, 0XF6, 0X6A, 0X58, 0XDF), 4); //[VT_R8]
		public static PROPERTYKEY SENSOR_DATA_TYPE_ABSOLUTE_PRESSURE_PASCAL => new(new(0X38564A7C, 0XF2F2, 0X49BB, 0X9B, 0X2B, 0XBA, 0X60, 0XF6, 0X6A, 0X58, 0XDF), 5); //[VT_R8]
		public static PROPERTYKEY SENSOR_DATA_TYPE_GAUGE_PRESSURE_PASCAL => new(new(0X38564A7C, 0XF2F2, 0X49BB, 0X9B, 0X2B, 0XBA, 0X60, 0XF6, 0X6A, 0X58, 0XDF), 6); //[VT_R8]
		public static PROPERTYKEY SENSOR_DATA_TYPE_STRAIN => new(new(0X38564A7C, 0XF2F2, 0X49BB, 0X9B, 0X2B, 0XBA, 0X60, 0XF6, 0X6A, 0X58, 0XDF), 7); //[VT_R8]
		public static PROPERTYKEY SENSOR_DATA_TYPE_WEIGHT_KILOGRAMS => new(new(0X38564A7C, 0XF2F2, 0X49BB, 0X9B, 0X2B, 0XBA, 0X60, 0XF6, 0X6A, 0X58, 0XDF), 8); //[VT_R8]
		public static PROPERTYKEY SENSOR_DATA_TYPE_BOOLEAN_SWITCH_ARRAY_STATES => new(new(0X38564A7C, 0XF2F2, 0X49BB, 0X9B, 0X2B, 0XBA, 0X60, 0XF6, 0X6A, 0X58, 0XDF), 10); //[VT_UI4]

		//
		// Biometric Sensor Data Types
		//

		// {2299288A-6D9E-4B0B-B7EC-3528F89E40AF}
		public static Guid SENSOR_DATA_TYPE_BIOMETRIC_GUID => new(0X2299288A, 0X6D9E, 0X4B0B, 0XB7, 0XEC, 0X35, 0X28, 0XF8, 0X9E, 0X40, 0XAF);
		public static PROPERTYKEY SENSOR_DATA_TYPE_HUMAN_PRESENCE => new(new(0X2299288A, 0X6D9E, 0X4B0B, 0XB7, 0XEC, 0X35, 0X28, 0XF8, 0X9E, 0X40, 0XAF), 2); //[VT_BOOL]
		public static PROPERTYKEY SENSOR_DATA_TYPE_HUMAN_PROXIMITY_METERS => new(new(0X2299288A, 0X6D9E, 0X4B0B, 0XB7, 0XEC, 0X35, 0X28, 0XF8, 0X9E, 0X40, 0XAF), 3); //[VT_R4]
		public static PROPERTYKEY SENSOR_DATA_TYPE_TOUCH_STATE => new(new(0X2299288A, 0X6D9E, 0X4B0B, 0XB7, 0XEC, 0X35, 0X28, 0XF8, 0X9E, 0X40, 0XAF), 4); //[VT_BOOL]

		//
		// Light Sensor Data Types
		//

		// {E4C77CE2-DCB7-46E9-8439-4FEC548833A6}
		public static Guid SENSOR_DATA_TYPE_LIGHT_GUID => new(0XE4C77CE2, 0XDCB7, 0X46E9, 0X84, 0X39, 0X4F, 0XEC, 0X54, 0X88, 0X33, 0XA6);
		// Ambient light in LUX, Lumens per square meter, the ACPI convention for reporting ambient light values
		public static PROPERTYKEY SENSOR_DATA_TYPE_LIGHT_LEVEL_LUX => new(new(0XE4C77CE2, 0XDCB7, 0X46E9, 0X84, 0X39, 0X4F, 0XEC, 0X54, 0X88, 0X33, 0XA6), 2); //[VT_R4]
		public static PROPERTYKEY SENSOR_DATA_TYPE_LIGHT_TEMPERATURE_KELVIN => new(new(0XE4C77CE2, 0XDCB7, 0X46E9, 0X84, 0X39, 0X4F, 0XEC, 0X54, 0X88, 0X33, 0XA6), 3); //[VT_R4]
		public static PROPERTYKEY SENSOR_DATA_TYPE_LIGHT_CHROMACITY => new(new(0XE4C77CE2, 0XDCB7, 0X46E9, 0X84, 0X39, 0X4F, 0XEC, 0X54, 0X88, 0X33, 0XA6), 4); //[VT_VECTOR|VT_UI1]

		//
		// Scanner Sensor Data Types
		//

		// {D7A59A3C-3421-44AB-8D3A-9DE8AB6C4CAE}
		public static Guid SENSOR_DATA_TYPE_SCANNER_GUID => new(0XD7A59A3C, 0X3421, 0X44AB, 0X8D, 0X3A, 0X9D, 0XE8, 0XAB, 0X6C, 0X4C, 0XAE);
		// EM4102 RFID protocol uses 40 bit tags, stored in 64 bit value: VT_UI8
		public static PROPERTYKEY SENSOR_DATA_TYPE_RFID_TAG_40_BIT => new(new(0XD7A59A3C, 0X3421, 0X44AB, 0X8D, 0X3A, 0X9D, 0XE8, 0XAB, 0X6C, 0X4C, 0XAE), 2); //[VT_UI8]

		//
		// Electrical Sensor Data Types
		//

		// {BBB246D1-E242-4780-A2D3-CDED84F35842}
		public static Guid SENSOR_DATA_TYPE_ELECTRICAL_GUID => new(0XBBB246D1, 0XE242, 0X4780, 0XA2, 0XD3, 0XCD, 0XED, 0X84, 0XF3, 0X58, 0X42);
		public static PROPERTYKEY SENSOR_DATA_TYPE_VOLTAGE_VOLTS => new(new(0XBBB246D1, 0XE242, 0X4780, 0XA2, 0XD3, 0XCD, 0XED, 0X84, 0XF3, 0X58, 0X42), 2); //[VT_R8]
		public static PROPERTYKEY SENSOR_DATA_TYPE_CURRENT_AMPS => new(new(0XBBB246D1, 0XE242, 0X4780, 0XA2, 0XD3, 0XCD, 0XED, 0X84, 0XF3, 0X58, 0X42), 3); //[VT_R8]
		public static PROPERTYKEY SENSOR_DATA_TYPE_CAPACITANCE_FARAD => new(new(0XBBB246D1, 0XE242, 0X4780, 0XA2, 0XD3, 0XCD, 0XED, 0X84, 0XF3, 0X58, 0X42), 4); //[VT_R8]
		public static PROPERTYKEY SENSOR_DATA_TYPE_RESISTANCE_OHMS => new(new(0XBBB246D1, 0XE242, 0X4780, 0XA2, 0XD3, 0XCD, 0XED, 0X84, 0XF3, 0X58, 0X42), 5); //[VT_R8]
		public static PROPERTYKEY SENSOR_DATA_TYPE_INDUCTANCE_HENRY => new(new(0XBBB246D1, 0XE242, 0X4780, 0XA2, 0XD3, 0XCD, 0XED, 0X84, 0XF3, 0X58, 0X42), 6); //[VT_R8]
		public static PROPERTYKEY SENSOR_DATA_TYPE_ELECTRICAL_POWER_WATTS => new(new(0XBBB246D1, 0XE242, 0X4780, 0XA2, 0XD3, 0XCD, 0XED, 0X84, 0XF3, 0X58, 0X42), 7); //[VT_R8]
		public static PROPERTYKEY SENSOR_DATA_TYPE_ELECTRICAL_PERCENT_OF_RANGE => new(new(0XBBB246D1, 0XE242, 0X4780, 0XA2, 0XD3, 0XCD, 0XED, 0X84, 0XF3, 0X58, 0X42), 8); //[VT_R8]
		public static PROPERTYKEY SENSOR_DATA_TYPE_ELECTRICAL_FREQUENCY_HERTZ => new(new(0XBBB246D1, 0XE242, 0X4780, 0XA2, 0XD3, 0XCD, 0XED, 0X84, 0XF3, 0X58, 0X42), 9); //[VT_R8]

		//
		// Custom Sensor Data Types (additions to sensors.h)
		//

		// {B14C764F-07CF-41E8-9D82-EBE3D0776A6F}
		public static Guid SENSOR_DATA_TYPE_CUSTOM_GUID => new(0XB14C764F, 0X7CF, 0X41E8, 0X9D, 0X82, 0XEB, 0XE3, 0XD0, 0X77, 0X6A, 0X6F);
		public static PROPERTYKEY SENSOR_DATA_TYPE_CUSTOM_USAGE => new(new(0XB14C764F, 0X7CF, 0X41E8, 0X9D, 0X82, 0XEB, 0XE3, 0XD0, 0X77, 0X6A, 0X6F), 5);    //[VT_UI4]
		public static PROPERTYKEY SENSOR_DATA_TYPE_CUSTOM_BOOLEAN_ARRAY => new(new(0XB14C764F, 0X7CF, 0X41E8, 0X9D, 0X82, 0XEB, 0XE3, 0XD0, 0X77, 0X6A, 0X6F), 6);    //[VT_UI4]
		public static PROPERTYKEY SENSOR_DATA_TYPE_CUSTOM_VALUE1 => new(new(0XB14C764F, 0X7CF, 0X41E8, 0X9D, 0X82, 0XEB, 0XE3, 0XD0, 0X77, 0X6A, 0X6F), 7);    //[VT_UI4||VT_R4]
		public static PROPERTYKEY SENSOR_DATA_TYPE_CUSTOM_VALUE2 => new(new(0XB14C764F, 0X7CF, 0X41E8, 0X9D, 0X82, 0XEB, 0XE3, 0XD0, 0X77, 0X6A, 0X6F), 8);    //[VT_UI4||VT_R4]
		public static PROPERTYKEY SENSOR_DATA_TYPE_CUSTOM_VALUE3 => new(new(0XB14C764F, 0X7CF, 0X41E8, 0X9D, 0X82, 0XEB, 0XE3, 0XD0, 0X77, 0X6A, 0X6F), 9);    //[VT_UI4||VT_R4]
		public static PROPERTYKEY SENSOR_DATA_TYPE_CUSTOM_VALUE4 => new(new(0XB14C764F, 0X7CF, 0X41E8, 0X9D, 0X82, 0XEB, 0XE3, 0XD0, 0X77, 0X6A, 0X6F), 10);   //[VT_UI4||VT_R4]
		public static PROPERTYKEY SENSOR_DATA_TYPE_CUSTOM_VALUE5 => new(new(0XB14C764F, 0X7CF, 0X41E8, 0X9D, 0X82, 0XEB, 0XE3, 0XD0, 0X77, 0X6A, 0X6F), 11);   //[VT_UI4||VT_R4]
		public static PROPERTYKEY SENSOR_DATA_TYPE_CUSTOM_VALUE6 => new(new(0XB14C764F, 0X7CF, 0X41E8, 0X9D, 0X82, 0XEB, 0XE3, 0XD0, 0X77, 0X6A, 0X6F), 12);   //[VT_UI4||VT_R4]
		public static PROPERTYKEY SENSOR_DATA_TYPE_CUSTOM_VALUE7 => new(new(0XB14C764F, 0X7CF, 0X41E8, 0X9D, 0X82, 0XEB, 0XE3, 0XD0, 0X77, 0X6A, 0X6F), 13);   //[VT_UI4||VT_R4]
		public static PROPERTYKEY SENSOR_DATA_TYPE_CUSTOM_VALUE8 => new(new(0XB14C764F, 0X7CF, 0X41E8, 0X9D, 0X82, 0XEB, 0XE3, 0XD0, 0X77, 0X6A, 0X6F), 14);   //[VT_UI4||VT_R4]
		public static PROPERTYKEY SENSOR_DATA_TYPE_CUSTOM_VALUE9 => new(new(0XB14C764F, 0X7CF, 0X41E8, 0X9D, 0X82, 0XEB, 0XE3, 0XD0, 0X77, 0X6A, 0X6F), 15);   //[VT_UI4||VT_R4]
		public static PROPERTYKEY SENSOR_DATA_TYPE_CUSTOM_VALUE10 => new(new(0XB14C764F, 0X7CF, 0X41E8, 0X9D, 0X82, 0XEB, 0XE3, 0XD0, 0X77, 0X6A, 0X6F), 16);   //[VT_UI4||VT_R4]
		public static PROPERTYKEY SENSOR_DATA_TYPE_CUSTOM_VALUE11 => new(new(0XB14C764F, 0X7CF, 0X41E8, 0X9D, 0X82, 0XEB, 0XE3, 0XD0, 0X77, 0X6A, 0X6F), 17);   //[VT_UI4||VT_R4]
		public static PROPERTYKEY SENSOR_DATA_TYPE_CUSTOM_VALUE12 => new(new(0XB14C764F, 0X7CF, 0X41E8, 0X9D, 0X82, 0XEB, 0XE3, 0XD0, 0X77, 0X6A, 0X6F), 18);   //[VT_UI4||VT_R4]
		public static PROPERTYKEY SENSOR_DATA_TYPE_CUSTOM_VALUE13 => new(new(0XB14C764F, 0X7CF, 0X41E8, 0X9D, 0X82, 0XEB, 0XE3, 0XD0, 0X77, 0X6A, 0X6F), 19);   //[VT_UI4||VT_R4]
		public static PROPERTYKEY SENSOR_DATA_TYPE_CUSTOM_VALUE14 => new(new(0XB14C764F, 0X7CF, 0X41E8, 0X9D, 0X82, 0XEB, 0XE3, 0XD0, 0X77, 0X6A, 0X6F), 20);   //[VT_UI4||VT_R4]
		public static PROPERTYKEY SENSOR_DATA_TYPE_CUSTOM_VALUE15 => new(new(0XB14C764F, 0X7CF, 0X41E8, 0X9D, 0X82, 0XEB, 0XE3, 0XD0, 0X77, 0X6A, 0X6F), 21);   //[VT_UI4||VT_R4]
		public static PROPERTYKEY SENSOR_DATA_TYPE_CUSTOM_VALUE16 => new(new(0XB14C764F, 0X7CF, 0X41E8, 0X9D, 0X82, 0XEB, 0XE3, 0XD0, 0X77, 0X6A, 0X6F), 22);   //[VT_UI4||VT_R4]
		public static PROPERTYKEY SENSOR_DATA_TYPE_CUSTOM_VALUE17 => new(new(0XB14C764F, 0X7CF, 0X41E8, 0X9D, 0X82, 0XEB, 0XE3, 0XD0, 0X77, 0X6A, 0X6F), 23);   //[VT_UI4||VT_R4]
		public static PROPERTYKEY SENSOR_DATA_TYPE_CUSTOM_VALUE18 => new(new(0XB14C764F, 0X7CF, 0X41E8, 0X9D, 0X82, 0XEB, 0XE3, 0XD0, 0X77, 0X6A, 0X6F), 24);   //[VT_UI4||VT_R4]
		public static PROPERTYKEY SENSOR_DATA_TYPE_CUSTOM_VALUE19 => new(new(0XB14C764F, 0X7CF, 0X41E8, 0X9D, 0X82, 0XEB, 0XE3, 0XD0, 0X77, 0X6A, 0X6F), 25);   //[VT_UI4||VT_R4]
		public static PROPERTYKEY SENSOR_DATA_TYPE_CUSTOM_VALUE20 => new(new(0XB14C764F, 0X7CF, 0X41E8, 0X9D, 0X82, 0XEB, 0XE3, 0XD0, 0X77, 0X6A, 0X6F), 26);   //[VT_UI4||VT_R4]
		public static PROPERTYKEY SENSOR_DATA_TYPE_CUSTOM_VALUE21 => new(new(0XB14C764F, 0X7CF, 0X41E8, 0X9D, 0X82, 0XEB, 0XE3, 0XD0, 0X77, 0X6A, 0X6F), 27);   //[VT_UI4||VT_R4]
		public static PROPERTYKEY SENSOR_DATA_TYPE_CUSTOM_VALUE22 => new(new(0XB14C764F, 0X7CF, 0X41E8, 0X9D, 0X82, 0XEB, 0XE3, 0XD0, 0X77, 0X6A, 0X6F), 28);   //[VT_UI4||VT_R4]
		public static PROPERTYKEY SENSOR_DATA_TYPE_CUSTOM_VALUE23 => new(new(0XB14C764F, 0X7CF, 0X41E8, 0X9D, 0X82, 0XEB, 0XE3, 0XD0, 0X77, 0X6A, 0X6F), 29);   //[VT_UI4||VT_R4]
		public static PROPERTYKEY SENSOR_DATA_TYPE_CUSTOM_VALUE24 => new(new(0XB14C764F, 0X7CF, 0X41E8, 0X9D, 0X82, 0XEB, 0XE3, 0XD0, 0X77, 0X6A, 0X6F), 30);   //[VT_UI4||VT_R4]
		public static PROPERTYKEY SENSOR_DATA_TYPE_CUSTOM_VALUE25 => new(new(0XB14C764F, 0X7CF, 0X41E8, 0X9D, 0X82, 0XEB, 0XE3, 0XD0, 0X77, 0X6A, 0X6F), 31);   //[VT_UI4||VT_R4]
		public static PROPERTYKEY SENSOR_DATA_TYPE_CUSTOM_VALUE26 => new(new(0XB14C764F, 0X7CF, 0X41E8, 0X9D, 0X82, 0XEB, 0XE3, 0XD0, 0X77, 0X6A, 0X6F), 32);   //[VT_UI4||VT_R4]
		public static PROPERTYKEY SENSOR_DATA_TYPE_CUSTOM_VALUE27 => new(new(0XB14C764F, 0X7CF, 0X41E8, 0X9D, 0X82, 0XEB, 0XE3, 0XD0, 0X77, 0X6A, 0X6F), 33);   //[VT_UI4||VT_R4]
		public static PROPERTYKEY SENSOR_DATA_TYPE_CUSTOM_VALUE28 => new(new(0XB14C764F, 0X7CF, 0X41E8, 0X9D, 0X82, 0XEB, 0XE3, 0XD0, 0X77, 0X6A, 0X6F), 34);   //[VT_UI4||VT_R4]

		//
		// Test hooks
		//

		//{e1e962f4-6e65-45f7-9c36-d487b7b1bd34}
		public static Guid SENSOR_PROPERTY_TEST_GUID => new(0XE1E962F4, 0X6E65, 0X45F7, 0X9C, 0X36, 0XD4, 0X87, 0XB7, 0XB1, 0XBD, 0X34);
		public static PROPERTYKEY SENSOR_PROPERTY_CLEAR_ASSISTANCE_DATA => new(new(0XE1E962F4, 0X6E65, 0X45F7, 0X9C, 0X36, 0XD4, 0X87, 0XB7, 0XB1, 0XBD, 0X34), 2); //[VT_UI4]
		public static PROPERTYKEY SENSOR_PROPERTY_TURN_ON_OFF_NMEA => new(new(0XE1E962F4, 0X6E65, 0X45F7, 0X9C, 0X36, 0XD4, 0X87, 0XB7, 0XB1, 0XBD, 0X34), 3); //[VT_UI4]
	}
}