namespace Vanara.PInvoke;

public static partial class D3D12
{
	/// <summary>Undocumented</summary>
	public delegate void D3D12MessageFunc(D3D12_MESSAGE_CATEGORY Category, D3D12_MESSAGE_SEVERITY Severity, D3D12_MESSAGE_ID ID,
		[MarshalAs(UnmanagedType.LPStr)] string pDescription, IntPtr pContext);

	/// <summary>Indicates the debug parameter type used by <c>ID3D12DebugCommandList1::SetDebugParameter</c> and <c>ID3D12DebugCommandList1::GetDebugParameter</c>.</summary>
	// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/ne-d3d12sdklayers-d3d12_debug_command_list_parameter_type typedef
	// enum D3D12_DEBUG_COMMAND_LIST_PARAMETER_TYPE { D3D12_DEBUG_COMMAND_LIST_PARAMETER_GPU_BASED_VALIDATION_SETTINGS = 0 } ;
	[PInvokeData("d3d12sdklayers.h", MSDNShortId = "NE:d3d12sdklayers.D3D12_DEBUG_COMMAND_LIST_PARAMETER_TYPE")]
	public enum D3D12_DEBUG_COMMAND_LIST_PARAMETER_TYPE
	{
		/// <summary>
		/// <para>Value: 0 Indicates the parameter is type D3D12_DEBUG_COMMAND_LIST_GPU_BASED_VALIDATION_SETTINGS.</para>
		/// </summary>
		D3D12_DEBUG_COMMAND_LIST_PARAMETER_GPU_BASED_VALIDATION_SETTINGS,
	}

	/// <summary>
	/// Specifies the data type of the memory pointed to by the <i>pData</i> parameter of <c>ID3D12DebugDevice1::SetDebugParameter</c> and <c>ID3D12DebugDevice1::GetDebugParameter</c>.
	/// </summary>
	// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/ne-d3d12sdklayers-d3d12_debug_device_parameter_type typedef enum
	// D3D12_DEBUG_DEVICE_PARAMETER_TYPE { D3D12_DEBUG_DEVICE_PARAMETER_FEATURE_FLAGS = 0,
	// D3D12_DEBUG_DEVICE_PARAMETER_GPU_BASED_VALIDATION_SETTINGS, D3D12_DEBUG_DEVICE_PARAMETER_GPU_SLOWDOWN_PERFORMANCE_FACTOR } ;
	[PInvokeData("d3d12sdklayers.h", MSDNShortId = "NE:d3d12sdklayers.D3D12_DEBUG_DEVICE_PARAMETER_TYPE")]
	public enum D3D12_DEBUG_DEVICE_PARAMETER_TYPE
	{
		/// <summary>
		/// <para>Value: 0 Indicates pData points to a D3D12_DEBUG_FEATURE value.</para>
		/// </summary>
		D3D12_DEBUG_DEVICE_PARAMETER_FEATURE_FLAGS,

		/// <summary>
		/// <para>Indicates pData points to a D3D12_DEBUG_DEVICE_GPU_BASED_VALIDATION_SETTINGS structure.</para>
		/// </summary>
		D3D12_DEBUG_DEVICE_PARAMETER_GPU_BASED_VALIDATION_SETTINGS,

		/// <summary>
		/// <para>Indicates pData points to a D3D12_DEBUG_DEVICE_GPU_SLOWDOWN_PERFORMANCE_FACTOR structure.</para>
		/// </summary>
		D3D12_DEBUG_DEVICE_PARAMETER_GPU_SLOWDOWN_PERFORMANCE_FACTOR,
	}

	/// <summary>Flags for optional D3D12 Debug Layer features.</summary>
	/// <remarks>This enum is used by <c>ID3D12DebugDevice1::SetDebugParameter</c> and <c>ID3D12DebugDevice1::GetDebugParameter</c>.</remarks>
	// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/ne-d3d12sdklayers-d3d12_debug_feature typedef enum
	// D3D12_DEBUG_FEATURE { D3D12_DEBUG_FEATURE_NONE = 0, D3D12_DEBUG_FEATURE_ALLOW_BEHAVIOR_CHANGING_DEBUG_AIDS = 0x1,
	// D3D12_DEBUG_FEATURE_CONSERVATIVE_RESOURCE_STATE_TRACKING = 0x2, D3D12_DEBUG_FEATURE_DISABLE_VIRTUALIZED_BUNDLES_VALIDATION = 0x4,
	// D3D12_DEBUG_FEATURE_EMULATE_WINDOWS7 } ;
	[PInvokeData("d3d12sdklayers.h", MSDNShortId = "NE:d3d12sdklayers.D3D12_DEBUG_FEATURE")]
	[Flags]
	public enum D3D12_DEBUG_FEATURE
	{
		/// <summary>
		/// <para>Value: 0 The default. No optional Debug Layer features.</para>
		/// </summary>
		D3D12_DEBUG_FEATURE_NONE = 0x0,

		/// <summary>
		/// <para>Value: 0x1 
		/// The Debug Layer is allowed to deliberately change functional behavior of an application in order to help identify potential
		/// errors. By default, the Debug Layer allows most invalid API usage to run the natural course.
		/// </para>
		/// </summary>
		D3D12_DEBUG_FEATURE_ALLOW_BEHAVIOR_CHANGING_DEBUG_AIDS = 0x1,

		/// <summary>
		/// <para>Value: 0x2 Performs additional resource state validation of resources set in descriptors at the time</para>
		/// <para>ID3D12CommandQueue::ExecuteCommandLists</para>
		/// <para>
		/// is called. By design descriptors can be changed even after submitting command lists assuming proper synchronization.
		/// Conservative resource state tracking ignores this allowance and validates all resources used in descriptor tables when
		///  ExecuteCommandLists is called. The result may be false validation errors.</para>
		/// </summary>
		D3D12_DEBUG_FEATURE_CONSERVATIVE_RESOURCE_STATE_TRACKING = 0x2,

		/// <summary>
		/// <para>Value: 0x4 Disables validation of bundle commands by virtually injecting checks into the calling command list validation paths.</para>
		/// </summary>
		D3D12_DEBUG_FEATURE_DISABLE_VIRTUALIZED_BUNDLES_VALIDATION = 0x4,
	}

	/// <summary>Describes the level of GPU-based validation to perform at runtime.</summary>
	/// <remarks>
	/// This enumeration is used with the <c>ID3D12Debug2::SetGPUBasedValidationFlags</c> method to configure the amount of runtime
	/// validation that will occur.
	/// </remarks>
	// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/ne-d3d12sdklayers-d3d12_gpu_based_validation_flags typedef enum
	// D3D12_GPU_BASED_VALIDATION_FLAGS { D3D12_GPU_BASED_VALIDATION_FLAGS_NONE = 0, D3D12_GPU_BASED_VALIDATION_FLAGS_DISABLE_STATE_TRACKING
	// = 0x1 } ;
	[PInvokeData("d3d12sdklayers.h", MSDNShortId = "NE:d3d12sdklayers.D3D12_GPU_BASED_VALIDATION_FLAGS")]
	[Flags]
	public enum D3D12_GPU_BASED_VALIDATION_FLAGS
	{
		/// <summary>
		/// <para>Value: 0 Default behavior; resource states, descriptors, and descriptor tables are all validated.</para>
		/// </summary>
		D3D12_GPU_BASED_VALIDATION_FLAGS_NONE = 0x0,

		/// <summary>
		/// <para>Value: 0x1 
		/// When set, GPU-based validation does not perform resource state validation which greatly reduces the performance cost of
		/// GPU-based validation. Descriptors and descriptor heaps are still validated.
		/// </para>
		/// </summary>
		D3D12_GPU_BASED_VALIDATION_FLAGS_DISABLE_STATE_TRACKING = 0x1,
	}

	/// <summary>
	/// Specifies how GPU-Based Validation handles patched pipeline states during <c>ID3D12Device::CreateGraphicsPipelineState</c> and <c>ID3D12Device::CreateComputePipelineState</c>.
	/// </summary>
	/// <remarks>
	/// <para>This enum is used by the <c>D3D12_DEBUG_DEVICE_GPU_BASED_VALIDATION_SETTINGS</c> structure.</para>
	/// <para>
	/// Generally speaking most application developers are likely to leave this parameter unchanged. However, if the overhead of deferring
	/// patched PSO creation is suspected to be too much of a performance problem, then developers should consider changing this setting.
	/// </para>
	/// </remarks>
	// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/ne-d3d12sdklayers-d3d12_gpu_based_validation_pipeline_state_create_flags
	// typedef enum D3D12_GPU_BASED_VALIDATION_PIPELINE_STATE_CREATE_FLAGS { D3D12_GPU_BASED_VALIDATION_PIPELINE_STATE_CREATE_FLAG_NONE = 0,
	// D3D12_GPU_BASED_VALIDATION_PIPELINE_STATE_CREATE_FLAG_FRONT_LOAD_CREATE_TRACKING_ONLY_SHADERS = 0x1,
	// D3D12_GPU_BASED_VALIDATION_PIPELINE_STATE_CREATE_FLAG_FRONT_LOAD_CREATE_UNGUARDED_VALIDATION_SHADERS = 0x2,
	// D3D12_GPU_BASED_VALIDATION_PIPELINE_STATE_CREATE_FLAG_FRONT_LOAD_CREATE_GUARDED_VALIDATION_SHADERS = 0x4,
	// D3D12_GPU_BASED_VALIDATION_PIPELINE_STATE_CREATE_FLAGS_VALID_MASK = 0x7 } ;
	[PInvokeData("d3d12sdklayers.h", MSDNShortId = "NE:d3d12sdklayers.D3D12_GPU_BASED_VALIDATION_PIPELINE_STATE_CREATE_FLAGS")]
	[Flags]
	public enum D3D12_GPU_BASED_VALIDATION_PIPELINE_STATE_CREATE_FLAGS
	{
		/// <summary>
		/// <para>Value: 0 
		/// This is the default value. Indicates no patching of pipeline states should be done during PSO creation. Instead PSOs are
		/// patched on first use in a command list. This can help to reduce the up-front cost of PSO creation but may instead slow down
		/// command list recording until a steady-state is reached.
		/// </para>
		/// </summary>
		D3D12_GPU_BASED_VALIDATION_PIPELINE_STATE_CREATE_FLAG_NONE = 0x0,

		/// <summary>
		/// <para>Value: 0x1 Indicates that state-tracking GPU-Based Validation PSOs should be created along with the original PSO at create time.</para>
		/// </summary>
		D3D12_GPU_BASED_VALIDATION_PIPELINE_STATE_CREATE_FLAG_FRONT_LOAD_CREATE_TRACKING_ONLY_SHADERS = 0x1,

		/// <summary>
		/// <para>Value: 0x2 Indicates that unguarded GPU-Based Validation PSOs should be created along with the original PSO at create time.</para>
		/// </summary>
		D3D12_GPU_BASED_VALIDATION_PIPELINE_STATE_CREATE_FLAG_FRONT_LOAD_CREATE_UNGUARDED_VALIDATION_SHADERS = 0x2,

		/// <summary>
		/// <para>Value: 0x4 Indicates that guarded GPU-Based Validation PSOs should be created along with the original PSO at create time.</para>
		/// </summary>
		D3D12_GPU_BASED_VALIDATION_PIPELINE_STATE_CREATE_FLAG_FRONT_LOAD_CREATE_GUARDED_VALIDATION_SHADERS = 0x4,

		/// <summary>
		/// <para>Value: 0x7 Internal use only.</para>
		/// </summary>
		D3D12_GPU_BASED_VALIDATION_PIPELINE_STATE_CREATE_FLAGS_VALID_MASK = 0x7,
	}

	/// <summary>Specifies the type of shader patching used by GPU-Based Validation at either the device or command list level.</summary>
	/// <remarks>This enum is used by the <c>D3D12_DEBUG_DEVICE_GPU_BASED_VALIDATION_SETTINGS</c> structure.</remarks>
	// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/ne-d3d12sdklayers-d3d12_gpu_based_validation_shader_patch_mode
	// typedef enum D3D12_GPU_BASED_VALIDATION_SHADER_PATCH_MODE { D3D12_GPU_BASED_VALIDATION_SHADER_PATCH_MODE_NONE = 0,
	// D3D12_GPU_BASED_VALIDATION_SHADER_PATCH_MODE_STATE_TRACKING_ONLY, D3D12_GPU_BASED_VALIDATION_SHADER_PATCH_MODE_UNGUARDED_VALIDATION,
	// D3D12_GPU_BASED_VALIDATION_SHADER_PATCH_MODE_GUARDED_VALIDATION, NUM_D3D12_GPU_BASED_VALIDATION_SHADER_PATCH_MODES } ;
	[PInvokeData("d3d12sdklayers.h", MSDNShortId = "NE:d3d12sdklayers.D3D12_GPU_BASED_VALIDATION_SHADER_PATCH_MODE")]
	public enum D3D12_GPU_BASED_VALIDATION_SHADER_PATCH_MODE
	{
		/// <summary>
		/// <para>Value: 0 
		/// No shader patching is to be done. This will retain the original shader bytecode. Can lead to errors in some of the GPU-Based
		/// Validation state tracking as the unpatched shader may still change resource state (see
		/// </para>
		/// <para>Common state promotion</para>
		/// <para>
		/// ) but the promotion will be untracked without patching the shader. This can improve performance but no validation will be
		/// performed and may also lead to misleading GPU-Based Validation errors. Use this mode very carefully.
		/// </para>
		/// </summary>
		D3D12_GPU_BASED_VALIDATION_SHADER_PATCH_MODE_NONE,

		/// <summary>
		/// Shaders can be patched with resource state tracking code but no validation. This may improve performance but no validation will
		/// be performed.
		/// </summary>
		D3D12_GPU_BASED_VALIDATION_SHADER_PATCH_MODE_STATE_TRACKING_ONLY,

		/// <summary>The default. Shaders are patched with validation code but erroneous instructions will still be executed.</summary>
		D3D12_GPU_BASED_VALIDATION_SHADER_PATCH_MODE_UNGUARDED_VALIDATION,

		/// <summary>
		/// Shaders are patched with validation code and erroneous instructions are skipped in execution. This can help avoid crashes or
		/// device removal.
		/// </summary>
		D3D12_GPU_BASED_VALIDATION_SHADER_PATCH_MODE_GUARDED_VALIDATION,

		/// <summary>Unused, simply the count of the number of modes.</summary>
		NUM_D3D12_GPU_BASED_VALIDATION_SHADER_PATCH_MODES,
	}

	/// <summary>Undocumented</summary>
	[PInvokeData("d3d12sdklayers.h")]
	[Flags]
	public enum D3D12_MESSAGE_CALLBACK_FLAGS
	{
		/// <summary/>
		D3D12_MESSAGE_CALLBACK_FLAG_NONE = 0x00,

		/// <summary/>
		D3D12_MESSAGE_CALLBACK_IGNORE_FILTERS = 0x01,
	}

	/// <summary>
	/// Specifies categories of debug messages. This will identify the category of a message when retrieving a message with
	/// <c>ID3D12InfoQueue::GetMessage</c> and when adding a message with <c>ID3D12InfoQueue::AddMessage</c>. When creating an info queue
	/// filter, these values can be used to allow or deny any categories of messages to pass through the storage and retrieval filters.
	/// </summary>
	/// <remarks>This is part of the Information Queue feature, refer to the <c>ID3D12InfoQueue</c> Interface.</remarks>
	// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/ne-d3d12sdklayers-d3d12_message_category typedef enum
	// D3D12_MESSAGE_CATEGORY { D3D12_MESSAGE_CATEGORY_APPLICATION_DEFINED = 0, D3D12_MESSAGE_CATEGORY_MISCELLANEOUS,
	// D3D12_MESSAGE_CATEGORY_INITIALIZATION, D3D12_MESSAGE_CATEGORY_CLEANUP, D3D12_MESSAGE_CATEGORY_COMPILATION,
	// D3D12_MESSAGE_CATEGORY_STATE_CREATION, D3D12_MESSAGE_CATEGORY_STATE_SETTING, D3D12_MESSAGE_CATEGORY_STATE_GETTING,
	// D3D12_MESSAGE_CATEGORY_RESOURCE_MANIPULATION, D3D12_MESSAGE_CATEGORY_EXECUTION, D3D12_MESSAGE_CATEGORY_SHADER } ;
	[PInvokeData("d3d12sdklayers.h", MSDNShortId = "NE:d3d12sdklayers.D3D12_MESSAGE_CATEGORY")]
	public enum D3D12_MESSAGE_CATEGORY
	{
		/// <summary>
		/// <para>Value: 0 Indicates a user defined message, see</para>
		/// <para>ID3D12InfoQueue::AddMessage</para>
		/// <para>.</para>
		/// </summary>
		D3D12_MESSAGE_CATEGORY_APPLICATION_DEFINED,

		/// <summary/>
		D3D12_MESSAGE_CATEGORY_MISCELLANEOUS,

		/// <summary/>
		D3D12_MESSAGE_CATEGORY_INITIALIZATION,

		/// <summary/>
		D3D12_MESSAGE_CATEGORY_CLEANUP,

		/// <summary/>
		D3D12_MESSAGE_CATEGORY_COMPILATION,

		/// <summary/>
		D3D12_MESSAGE_CATEGORY_STATE_CREATION,

		/// <summary/>
		D3D12_MESSAGE_CATEGORY_STATE_SETTING,

		/// <summary/>
		D3D12_MESSAGE_CATEGORY_STATE_GETTING,

		/// <summary/>
		D3D12_MESSAGE_CATEGORY_RESOURCE_MANIPULATION,

		/// <summary/>
		D3D12_MESSAGE_CATEGORY_EXECUTION,

		/// <summary/>
		D3D12_MESSAGE_CATEGORY_SHADER,
	}

	/// <summary>
	/// Specifies debug message IDs for setting up an info-queue filter (see <c>D3D12_INFO_QUEUE_FILTER</c>); use these messages to allow or
	/// deny message categories to pass through the storage and retrieval filters. These IDs are used by methods such as
	/// <c>ID3D12InfoQueue::GetMessage</c> or <c>ID3D12InfoQueue::AddMessage</c>.
	/// </summary>
	/// <remarks>This enum is used by <c>AddMessage</c>.</remarks>
	// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/ne-d3d12sdklayers-d3d12_message_id typedef enum D3D12_MESSAGE_ID {
	// D3D12_MESSAGE_ID_UNKNOWN = 0, D3D12_MESSAGE_ID_STRING_FROM_APPLICATION = 1, D3D12_MESSAGE_ID_CORRUPTED_THIS = 2,
	// D3D12_MESSAGE_ID_CORRUPTED_PARAMETER1 = 3, D3D12_MESSAGE_ID_CORRUPTED_PARAMETER2 = 4, D3D12_MESSAGE_ID_CORRUPTED_PARAMETER3 = 5,
	// D3D12_MESSAGE_ID_CORRUPTED_PARAMETER4 = 6, D3D12_MESSAGE_ID_CORRUPTED_PARAMETER5 = 7, D3D12_MESSAGE_ID_CORRUPTED_PARAMETER6 = 8,
	// D3D12_MESSAGE_ID_CORRUPTED_PARAMETER7 = 9, D3D12_MESSAGE_ID_CORRUPTED_PARAMETER8 = 10, D3D12_MESSAGE_ID_CORRUPTED_PARAMETER9 = 11,
	// D3D12_MESSAGE_ID_CORRUPTED_PARAMETER10 = 12, D3D12_MESSAGE_ID_CORRUPTED_PARAMETER11 = 13, D3D12_MESSAGE_ID_CORRUPTED_PARAMETER12 =
	// 14, D3D12_MESSAGE_ID_CORRUPTED_PARAMETER13 = 15, D3D12_MESSAGE_ID_CORRUPTED_PARAMETER14 = 16, D3D12_MESSAGE_ID_CORRUPTED_PARAMETER15
	// = 17, D3D12_MESSAGE_ID_CORRUPTED_MULTITHREADING = 18, D3D12_MESSAGE_ID_MESSAGE_REPORTING_OUTOFMEMORY = 19,
	// D3D12_MESSAGE_ID_GETPRIVATEDATA_MOREDATA = 20, D3D12_MESSAGE_ID_SETPRIVATEDATA_INVALIDFREEDATA = 21,
	// D3D12_MESSAGE_ID_SETPRIVATEDATA_CHANGINGPARAMS = 24, D3D12_MESSAGE_ID_SETPRIVATEDATA_OUTOFMEMORY = 25,
	// D3D12_MESSAGE_ID_CREATESHADERRESOURCEVIEW_UNRECOGNIZEDFORMAT = 26, D3D12_MESSAGE_ID_CREATESHADERRESOURCEVIEW_INVALIDDESC = 27,
	// D3D12_MESSAGE_ID_CREATESHADERRESOURCEVIEW_INVALIDFORMAT = 28, D3D12_MESSAGE_ID_CREATESHADERRESOURCEVIEW_INVALIDVIDEOPLANESLICE = 29,
	// D3D12_MESSAGE_ID_CREATESHADERRESOURCEVIEW_INVALIDPLANESLICE = 30, D3D12_MESSAGE_ID_CREATESHADERRESOURCEVIEW_INVALIDDIMENSIONS = 31,
	// D3D12_MESSAGE_ID_CREATESHADERRESOURCEVIEW_INVALIDRESOURCE = 32, D3D12_MESSAGE_ID_CREATERENDERTARGETVIEW_UNRECOGNIZEDFORMAT = 35,
	// D3D12_MESSAGE_ID_CREATERENDERTARGETVIEW_UNSUPPORTEDFORMAT = 36, D3D12_MESSAGE_ID_CREATERENDERTARGETVIEW_INVALIDDESC = 37,
	// D3D12_MESSAGE_ID_CREATERENDERTARGETVIEW_INVALIDFORMAT = 38, D3D12_MESSAGE_ID_CREATERENDERTARGETVIEW_INVALIDVIDEOPLANESLICE = 39,
	// D3D12_MESSAGE_ID_CREATERENDERTARGETVIEW_INVALIDPLANESLICE = 40, D3D12_MESSAGE_ID_CREATERENDERTARGETVIEW_INVALIDDIMENSIONS = 41,
	// D3D12_MESSAGE_ID_CREATERENDERTARGETVIEW_INVALIDRESOURCE = 42, D3D12_MESSAGE_ID_CREATEDEPTHSTENCILVIEW_UNRECOGNIZEDFORMAT = 45,
	// D3D12_MESSAGE_ID_CREATEDEPTHSTENCILVIEW_INVALIDDESC = 46, D3D12_MESSAGE_ID_CREATEDEPTHSTENCILVIEW_INVALIDFORMAT = 47,
	// D3D12_MESSAGE_ID_CREATEDEPTHSTENCILVIEW_INVALIDDIMENSIONS = 48, D3D12_MESSAGE_ID_CREATEDEPTHSTENCILVIEW_INVALIDRESOURCE = 49,
	// D3D12_MESSAGE_ID_CREATEINPUTLAYOUT_OUTOFMEMORY = 52, D3D12_MESSAGE_ID_CREATEINPUTLAYOUT_TOOMANYELEMENTS = 53,
	// D3D12_MESSAGE_ID_CREATEINPUTLAYOUT_INVALIDFORMAT = 54, D3D12_MESSAGE_ID_CREATEINPUTLAYOUT_INCOMPATIBLEFORMAT = 55,
	// D3D12_MESSAGE_ID_CREATEINPUTLAYOUT_INVALIDSLOT = 56, D3D12_MESSAGE_ID_CREATEINPUTLAYOUT_INVALIDINPUTSLOTCLASS = 57,
	// D3D12_MESSAGE_ID_CREATEINPUTLAYOUT_STEPRATESLOTCLASSMISMATCH = 58, D3D12_MESSAGE_ID_CREATEINPUTLAYOUT_INVALIDSLOTCLASSCHANGE = 59,
	// D3D12_MESSAGE_ID_CREATEINPUTLAYOUT_INVALIDSTEPRATECHANGE = 60, D3D12_MESSAGE_ID_CREATEINPUTLAYOUT_INVALIDALIGNMENT = 61,
	// D3D12_MESSAGE_ID_CREATEINPUTLAYOUT_DUPLICATESEMANTIC = 62, D3D12_MESSAGE_ID_CREATEINPUTLAYOUT_UNPARSEABLEINPUTSIGNATURE = 63,
	// D3D12_MESSAGE_ID_CREATEINPUTLAYOUT_NULLSEMANTIC = 64, D3D12_MESSAGE_ID_CREATEINPUTLAYOUT_MISSINGELEMENT = 65,
	// D3D12_MESSAGE_ID_CREATEVERTEXSHADER_OUTOFMEMORY = 66, D3D12_MESSAGE_ID_CREATEVERTEXSHADER_INVALIDSHADERBYTECODE = 67,
	// D3D12_MESSAGE_ID_CREATEVERTEXSHADER_INVALIDSHADERTYPE = 68, D3D12_MESSAGE_ID_CREATEGEOMETRYSHADER_OUTOFMEMORY = 69,
	// D3D12_MESSAGE_ID_CREATEGEOMETRYSHADER_INVALIDSHADERBYTECODE = 70, D3D12_MESSAGE_ID_CREATEGEOMETRYSHADER_INVALIDSHADERTYPE = 71,
	// D3D12_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_OUTOFMEMORY = 72,
	// D3D12_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDSHADERBYTECODE = 73,
	// D3D12_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDSHADERTYPE = 74,
	// D3D12_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDNUMENTRIES = 75,
	// D3D12_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_OUTPUTSTREAMSTRIDEUNUSED = 76,
	// D3D12_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_OUTPUTSLOT0EXPECTED = 79,
	// D3D12_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDOUTPUTSLOT = 80,
	// D3D12_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_ONLYONEELEMENTPERSLOT = 81,
	// D3D12_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDCOMPONENTCOUNT = 82,
	// D3D12_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDSTARTCOMPONENTANDCOMPONENTCOUNT = 83,
	// D3D12_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDGAPDEFINITION = 84,
	// D3D12_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_REPEATEDOUTPUT = 85,
	// D3D12_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDOUTPUTSTREAMSTRIDE = 86,
	// D3D12_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_MISSINGSEMANTIC = 87,
	// D3D12_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_MASKMISMATCH = 88,
	// D3D12_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_CANTHAVEONLYGAPS = 89,
	// D3D12_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_DECLTOOCOMPLEX = 90,
	// D3D12_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_MISSINGOUTPUTSIGNATURE = 91, D3D12_MESSAGE_ID_CREATEPIXELSHADER_OUTOFMEMORY =
	// 92, D3D12_MESSAGE_ID_CREATEPIXELSHADER_INVALIDSHADERBYTECODE = 93, D3D12_MESSAGE_ID_CREATEPIXELSHADER_INVALIDSHADERTYPE = 94,
	// D3D12_MESSAGE_ID_CREATERASTERIZERSTATE_INVALIDFILLMODE = 95, D3D12_MESSAGE_ID_CREATERASTERIZERSTATE_INVALIDCULLMODE = 96,
	// D3D12_MESSAGE_ID_CREATERASTERIZERSTATE_INVALIDDEPTHBIASCLAMP = 97, D3D12_MESSAGE_ID_CREATERASTERIZERSTATE_INVALIDSLOPESCALEDDEPTHBIAS
	// = 98, D3D12_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_INVALIDDEPTHWRITEMASK = 100, D3D12_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_INVALIDDEPTHFUNC
	// = 101, D3D12_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_INVALIDFRONTFACESTENCILFAILOP = 102,
	// D3D12_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_INVALIDFRONTFACESTENCILZFAILOP = 103,
	// D3D12_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_INVALIDFRONTFACESTENCILPASSOP = 104,
	// D3D12_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_INVALIDFRONTFACESTENCILFUNC = 105,
	// D3D12_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_INVALIDBACKFACESTENCILFAILOP = 106,
	// D3D12_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_INVALIDBACKFACESTENCILZFAILOP = 107,
	// D3D12_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_INVALIDBACKFACESTENCILPASSOP = 108,
	// D3D12_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_INVALIDBACKFACESTENCILFUNC = 109, D3D12_MESSAGE_ID_CREATEBLENDSTATE_INVALIDSRCBLEND = 111,
	// D3D12_MESSAGE_ID_CREATEBLENDSTATE_INVALIDDESTBLEND = 112, D3D12_MESSAGE_ID_CREATEBLENDSTATE_INVALIDBLENDOP = 113,
	// D3D12_MESSAGE_ID_CREATEBLENDSTATE_INVALIDSRCBLENDALPHA = 114, D3D12_MESSAGE_ID_CREATEBLENDSTATE_INVALIDDESTBLENDALPHA = 115,
	// D3D12_MESSAGE_ID_CREATEBLENDSTATE_INVALIDBLENDOPALPHA = 116, D3D12_MESSAGE_ID_CREATEBLENDSTATE_INVALIDRENDERTARGETWRITEMASK = 117,
	// D3D12_MESSAGE_ID_GET_PROGRAM_IDENTIFIER_ERROR, D3D12_MESSAGE_ID_GET_WORK_GRAPH_PROPERTIES_ERROR, D3D12_MESSAGE_ID_SET_PROGRAM_ERROR,
	// D3D12_MESSAGE_ID_CLEARDEPTHSTENCILVIEW_INVALID = 135, D3D12_MESSAGE_ID_COMMAND_LIST_DRAW_ROOT_SIGNATURE_NOT_SET = 200,
	// D3D12_MESSAGE_ID_COMMAND_LIST_DRAW_ROOT_SIGNATURE_MISMATCH = 201, D3D12_MESSAGE_ID_COMMAND_LIST_DRAW_VERTEX_BUFFER_NOT_SET = 202,
	// D3D12_MESSAGE_ID_COMMAND_LIST_DRAW_VERTEX_BUFFER_STRIDE_TOO_SMALL = 209, D3D12_MESSAGE_ID_COMMAND_LIST_DRAW_VERTEX_BUFFER_TOO_SMALL =
	// 210, D3D12_MESSAGE_ID_COMMAND_LIST_DRAW_INDEX_BUFFER_NOT_SET = 211, D3D12_MESSAGE_ID_COMMAND_LIST_DRAW_INDEX_BUFFER_FORMAT_INVALID =
	// 212, D3D12_MESSAGE_ID_COMMAND_LIST_DRAW_INDEX_BUFFER_TOO_SMALL = 213, D3D12_MESSAGE_ID_COMMAND_LIST_DRAW_INVALID_PRIMITIVETOPOLOGY =
	// 219, D3D12_MESSAGE_ID_COMMAND_LIST_DRAW_VERTEX_STRIDE_UNALIGNED = 221, D3D12_MESSAGE_ID_COMMAND_LIST_DRAW_INDEX_OFFSET_UNALIGNED =
	// 222, D3D12_MESSAGE_ID_DEVICE_REMOVAL_PROCESS_AT_FAULT = 232, D3D12_MESSAGE_ID_DEVICE_REMOVAL_PROCESS_POSSIBLY_AT_FAULT = 233,
	// D3D12_MESSAGE_ID_DEVICE_REMOVAL_PROCESS_NOT_AT_FAULT = 234, D3D12_MESSAGE_ID_CREATEINPUTLAYOUT_TRAILING_DIGIT_IN_SEMANTIC = 239,
	// D3D12_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_TRAILING_DIGIT_IN_SEMANTIC = 240,
	// D3D12_MESSAGE_ID_CREATEINPUTLAYOUT_TYPE_MISMATCH = 245, D3D12_MESSAGE_ID_CREATEINPUTLAYOUT_EMPTY_LAYOUT = 253,
	// D3D12_MESSAGE_ID_LIVE_OBJECT_SUMMARY = 255, D3D12_MESSAGE_ID_LIVE_DEVICE = 274, D3D12_MESSAGE_ID_LIVE_SWAPCHAIN = 275,
	// D3D12_MESSAGE_ID_CREATEDEPTHSTENCILVIEW_INVALIDFLAGS = 276, D3D12_MESSAGE_ID_CREATEVERTEXSHADER_INVALIDCLASSLINKAGE = 277,
	// D3D12_MESSAGE_ID_CREATEGEOMETRYSHADER_INVALIDCLASSLINKAGE = 278,
	// D3D12_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDSTREAMTORASTERIZER = 280,
	// D3D12_MESSAGE_ID_CREATEPIXELSHADER_INVALIDCLASSLINKAGE = 283, D3D12_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDSTREAM =
	// 284, D3D12_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_UNEXPECTEDENTRIES = 285,
	// D3D12_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_UNEXPECTEDSTRIDES = 286,
	// D3D12_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDNUMSTRIDES = 287, D3D12_MESSAGE_ID_CREATEHULLSHADER_OUTOFMEMORY = 289,
	// D3D12_MESSAGE_ID_CREATEHULLSHADER_INVALIDSHADERBYTECODE = 290, D3D12_MESSAGE_ID_CREATEHULLSHADER_INVALIDSHADERTYPE = 291,
	// D3D12_MESSAGE_ID_CREATEHULLSHADER_INVALIDCLASSLINKAGE = 292, D3D12_MESSAGE_ID_CREATEDOMAINSHADER_OUTOFMEMORY = 294,
	// D3D12_MESSAGE_ID_CREATEDOMAINSHADER_INVALIDSHADERBYTECODE = 295, D3D12_MESSAGE_ID_CREATEDOMAINSHADER_INVALIDSHADERTYPE = 296,
	// D3D12_MESSAGE_ID_CREATEDOMAINSHADER_INVALIDCLASSLINKAGE = 297, D3D12_MESSAGE_ID_RESOURCE_UNMAP_NOTMAPPED = 310,
	// D3D12_MESSAGE_ID_DEVICE_CHECKFEATURESUPPORT_MISMATCHED_DATA_SIZE = 318, D3D12_MESSAGE_ID_CREATECOMPUTESHADER_OUTOFMEMORY = 321,
	// D3D12_MESSAGE_ID_CREATECOMPUTESHADER_INVALIDSHADERBYTECODE = 322, D3D12_MESSAGE_ID_CREATECOMPUTESHADER_INVALIDCLASSLINKAGE = 323,
	// D3D12_MESSAGE_ID_DEVICE_CREATEVERTEXSHADER_DOUBLEFLOATOPSNOTSUPPORTED = 331,
	// D3D12_MESSAGE_ID_DEVICE_CREATEHULLSHADER_DOUBLEFLOATOPSNOTSUPPORTED = 332,
	// D3D12_MESSAGE_ID_DEVICE_CREATEDOMAINSHADER_DOUBLEFLOATOPSNOTSUPPORTED = 333,
	// D3D12_MESSAGE_ID_DEVICE_CREATEGEOMETRYSHADER_DOUBLEFLOATOPSNOTSUPPORTED = 334,
	// D3D12_MESSAGE_ID_DEVICE_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_DOUBLEFLOATOPSNOTSUPPORTED = 335,
	// D3D12_MESSAGE_ID_DEVICE_CREATEPIXELSHADER_DOUBLEFLOATOPSNOTSUPPORTED = 336,
	// D3D12_MESSAGE_ID_DEVICE_CREATECOMPUTESHADER_DOUBLEFLOATOPSNOTSUPPORTED = 337,
	// D3D12_MESSAGE_ID_CREATEUNORDEREDACCESSVIEW_INVALIDRESOURCE = 340, D3D12_MESSAGE_ID_CREATEUNORDEREDACCESSVIEW_INVALIDDESC = 341,
	// D3D12_MESSAGE_ID_CREATEUNORDEREDACCESSVIEW_INVALIDFORMAT = 342, D3D12_MESSAGE_ID_CREATEUNORDEREDACCESSVIEW_INVALIDVIDEOPLANESLICE =
	// 343, D3D12_MESSAGE_ID_CREATEUNORDEREDACCESSVIEW_INVALIDPLANESLICE = 344, D3D12_MESSAGE_ID_CREATEUNORDEREDACCESSVIEW_INVALIDDIMENSIONS
	// = 345, D3D12_MESSAGE_ID_CREATEUNORDEREDACCESSVIEW_UNRECOGNIZEDFORMAT = 346, D3D12_MESSAGE_ID_CREATEUNORDEREDACCESSVIEW_INVALIDFLAGS =
	// 354, D3D12_MESSAGE_ID_CREATERASTERIZERSTATE_INVALIDFORCEDSAMPLECOUNT = 401, D3D12_MESSAGE_ID_CREATEBLENDSTATE_INVALIDLOGICOPS = 403,
	// D3D12_MESSAGE_ID_DEVICE_CREATEVERTEXSHADER_DOUBLEEXTENSIONSNOTSUPPORTED = 410,
	// D3D12_MESSAGE_ID_DEVICE_CREATEHULLSHADER_DOUBLEEXTENSIONSNOTSUPPORTED = 412,
	// D3D12_MESSAGE_ID_DEVICE_CREATEDOMAINSHADER_DOUBLEEXTENSIONSNOTSUPPORTED = 414,
	// D3D12_MESSAGE_ID_DEVICE_CREATEGEOMETRYSHADER_DOUBLEEXTENSIONSNOTSUPPORTED = 416,
	// D3D12_MESSAGE_ID_DEVICE_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_DOUBLEEXTENSIONSNOTSUPPORTED = 418,
	// D3D12_MESSAGE_ID_DEVICE_CREATEPIXELSHADER_DOUBLEEXTENSIONSNOTSUPPORTED = 420,
	// D3D12_MESSAGE_ID_DEVICE_CREATECOMPUTESHADER_DOUBLEEXTENSIONSNOTSUPPORTED = 422,
	// D3D12_MESSAGE_ID_DEVICE_CREATEVERTEXSHADER_UAVSNOTSUPPORTED = 425, D3D12_MESSAGE_ID_DEVICE_CREATEHULLSHADER_UAVSNOTSUPPORTED = 426,
	// D3D12_MESSAGE_ID_DEVICE_CREATEDOMAINSHADER_UAVSNOTSUPPORTED = 427, D3D12_MESSAGE_ID_DEVICE_CREATEGEOMETRYSHADER_UAVSNOTSUPPORTED =
	// 428, D3D12_MESSAGE_ID_DEVICE_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_UAVSNOTSUPPORTED = 429,
	// D3D12_MESSAGE_ID_DEVICE_CREATEPIXELSHADER_UAVSNOTSUPPORTED = 430, D3D12_MESSAGE_ID_DEVICE_CREATECOMPUTESHADER_UAVSNOTSUPPORTED = 431,
	// D3D12_MESSAGE_ID_DEVICE_CLEARVIEW_INVALIDSOURCERECT = 447, D3D12_MESSAGE_ID_DEVICE_CLEARVIEW_EMPTYRECT = 448,
	// D3D12_MESSAGE_ID_UPDATETILEMAPPINGS_INVALID_PARAMETER = 493, D3D12_MESSAGE_ID_COPYTILEMAPPINGS_INVALID_PARAMETER = 494,
	// D3D12_MESSAGE_ID_CREATEDEVICE_INVALIDARGS = 506, D3D12_MESSAGE_ID_CREATEDEVICE_WARNING = 507,
	// D3D12_MESSAGE_ID_RESOURCE_BARRIER_INVALID_TYPE = 519, D3D12_MESSAGE_ID_RESOURCE_BARRIER_NULL_POINTER = 520,
	// D3D12_MESSAGE_ID_RESOURCE_BARRIER_INVALID_SUBRESOURCE = 521, D3D12_MESSAGE_ID_RESOURCE_BARRIER_RESERVED_BITS = 522,
	// D3D12_MESSAGE_ID_RESOURCE_BARRIER_MISSING_BIND_FLAGS = 523, D3D12_MESSAGE_ID_RESOURCE_BARRIER_MISMATCHING_MISC_FLAGS = 524,
	// D3D12_MESSAGE_ID_RESOURCE_BARRIER_MATCHING_STATES = 525, D3D12_MESSAGE_ID_RESOURCE_BARRIER_INVALID_COMBINATION = 526,
	// D3D12_MESSAGE_ID_RESOURCE_BARRIER_BEFORE_AFTER_MISMATCH = 527, D3D12_MESSAGE_ID_RESOURCE_BARRIER_INVALID_RESOURCE = 528,
	// D3D12_MESSAGE_ID_RESOURCE_BARRIER_SAMPLE_COUNT = 529, D3D12_MESSAGE_ID_RESOURCE_BARRIER_INVALID_FLAGS = 530,
	// D3D12_MESSAGE_ID_RESOURCE_BARRIER_INVALID_COMBINED_FLAGS = 531, D3D12_MESSAGE_ID_RESOURCE_BARRIER_INVALID_FLAGS_FOR_FORMAT = 532,
	// D3D12_MESSAGE_ID_RESOURCE_BARRIER_INVALID_SPLIT_BARRIER = 533, D3D12_MESSAGE_ID_RESOURCE_BARRIER_UNMATCHED_END = 534,
	// D3D12_MESSAGE_ID_RESOURCE_BARRIER_UNMATCHED_BEGIN = 535, D3D12_MESSAGE_ID_RESOURCE_BARRIER_INVALID_FLAG = 536,
	// D3D12_MESSAGE_ID_RESOURCE_BARRIER_INVALID_COMMAND_LIST_TYPE = 537, D3D12_MESSAGE_ID_INVALID_SUBRESOURCE_STATE = 538,
	// D3D12_MESSAGE_ID_COMMAND_ALLOCATOR_CONTENTION = 540, D3D12_MESSAGE_ID_COMMAND_ALLOCATOR_RESET = 541,
	// D3D12_MESSAGE_ID_COMMAND_ALLOCATOR_RESET_BUNDLE = 542, D3D12_MESSAGE_ID_COMMAND_ALLOCATOR_CANNOT_RESET = 543,
	// D3D12_MESSAGE_ID_COMMAND_LIST_OPEN = 544, D3D12_MESSAGE_ID_INVALID_BUNDLE_API = 546, D3D12_MESSAGE_ID_COMMAND_LIST_CLOSED = 547,
	// D3D12_MESSAGE_ID_WRONG_COMMAND_ALLOCATOR_TYPE = 549, D3D12_MESSAGE_ID_COMMAND_ALLOCATOR_SYNC = 552,
	// D3D12_MESSAGE_ID_COMMAND_LIST_SYNC = 553, D3D12_MESSAGE_ID_SET_DESCRIPTOR_HEAP_INVALID = 554, D3D12_MESSAGE_ID_CREATE_COMMANDQUEUE =
	// 557, D3D12_MESSAGE_ID_CREATE_COMMANDALLOCATOR = 558, D3D12_MESSAGE_ID_CREATE_PIPELINESTATE = 559,
	// D3D12_MESSAGE_ID_CREATE_COMMANDLIST12 = 560, D3D12_MESSAGE_ID_CREATE_RESOURCE = 562, D3D12_MESSAGE_ID_CREATE_DESCRIPTORHEAP = 563,
	// D3D12_MESSAGE_ID_CREATE_ROOTSIGNATURE = 564, D3D12_MESSAGE_ID_CREATE_LIBRARY = 565, D3D12_MESSAGE_ID_CREATE_HEAP = 566,
	// D3D12_MESSAGE_ID_CREATE_MONITOREDFENCE = 567, D3D12_MESSAGE_ID_CREATE_QUERYHEAP = 568, D3D12_MESSAGE_ID_CREATE_COMMANDSIGNATURE =
	// 569, D3D12_MESSAGE_ID_LIVE_COMMANDQUEUE = 570, D3D12_MESSAGE_ID_LIVE_COMMANDALLOCATOR = 571, D3D12_MESSAGE_ID_LIVE_PIPELINESTATE =
	// 572, D3D12_MESSAGE_ID_LIVE_COMMANDLIST12 = 573, D3D12_MESSAGE_ID_LIVE_RESOURCE = 575, D3D12_MESSAGE_ID_LIVE_DESCRIPTORHEAP = 576,
	// D3D12_MESSAGE_ID_LIVE_ROOTSIGNATURE = 577, D3D12_MESSAGE_ID_LIVE_LIBRARY = 578, D3D12_MESSAGE_ID_LIVE_HEAP = 579,
	// D3D12_MESSAGE_ID_LIVE_MONITOREDFENCE = 580, D3D12_MESSAGE_ID_LIVE_QUERYHEAP = 581, D3D12_MESSAGE_ID_LIVE_COMMANDSIGNATURE = 582,
	// D3D12_MESSAGE_ID_DESTROY_COMMANDQUEUE = 583, D3D12_MESSAGE_ID_DESTROY_COMMANDALLOCATOR = 584, D3D12_MESSAGE_ID_DESTROY_PIPELINESTATE
	// = 585, D3D12_MESSAGE_ID_DESTROY_COMMANDLIST12 = 586, D3D12_MESSAGE_ID_DESTROY_RESOURCE = 588, D3D12_MESSAGE_ID_DESTROY_DESCRIPTORHEAP
	// = 589, D3D12_MESSAGE_ID_DESTROY_ROOTSIGNATURE = 590, D3D12_MESSAGE_ID_DESTROY_LIBRARY = 591, D3D12_MESSAGE_ID_DESTROY_HEAP = 592,
	// D3D12_MESSAGE_ID_DESTROY_MONITOREDFENCE = 593, D3D12_MESSAGE_ID_DESTROY_QUERYHEAP = 594, D3D12_MESSAGE_ID_DESTROY_COMMANDSIGNATURE =
	// 595, D3D12_MESSAGE_ID_CREATERESOURCE_INVALIDDIMENSIONS = 597, D3D12_MESSAGE_ID_CREATERESOURCE_INVALIDMISCFLAGS = 599,
	// D3D12_MESSAGE_ID_CREATERESOURCE_INVALIDARG_RETURN = 602, D3D12_MESSAGE_ID_CREATERESOURCE_OUTOFMEMORY_RETURN = 603,
	// D3D12_MESSAGE_ID_CREATERESOURCE_INVALIDDESC = 604, D3D12_MESSAGE_ID_POSSIBLY_INVALID_SUBRESOURCE_STATE = 607,
	// D3D12_MESSAGE_ID_INVALID_USE_OF_NON_RESIDENT_RESOURCE = 608, D3D12_MESSAGE_ID_POSSIBLE_INVALID_USE_OF_NON_RESIDENT_RESOURCE = 609,
	// D3D12_MESSAGE_ID_BUNDLE_PIPELINE_STATE_MISMATCH = 610, D3D12_MESSAGE_ID_PRIMITIVE_TOPOLOGY_MISMATCH_PIPELINE_STATE = 611,
	// D3D12_MESSAGE_ID_RENDER_TARGET_FORMAT_MISMATCH_PIPELINE_STATE = 613,
	// D3D12_MESSAGE_ID_RENDER_TARGET_SAMPLE_DESC_MISMATCH_PIPELINE_STATE = 614,
	// D3D12_MESSAGE_ID_DEPTH_STENCIL_FORMAT_MISMATCH_PIPELINE_STATE = 615,
	// D3D12_MESSAGE_ID_DEPTH_STENCIL_SAMPLE_DESC_MISMATCH_PIPELINE_STATE = 616, D3D12_MESSAGE_ID_CREATESHADER_INVALIDBYTECODE = 622,
	// D3D12_MESSAGE_ID_CREATEHEAP_NULLDESC = 623, D3D12_MESSAGE_ID_CREATEHEAP_INVALIDSIZE = 624,
	// D3D12_MESSAGE_ID_CREATEHEAP_UNRECOGNIZEDHEAPTYPE = 625, D3D12_MESSAGE_ID_CREATEHEAP_UNRECOGNIZEDCPUPAGEPROPERTIES = 626,
	// D3D12_MESSAGE_ID_CREATEHEAP_UNRECOGNIZEDMEMORYPOOL = 627, D3D12_MESSAGE_ID_CREATEHEAP_INVALIDPROPERTIES = 628,
	// D3D12_MESSAGE_ID_CREATEHEAP_INVALIDALIGNMENT = 629, D3D12_MESSAGE_ID_CREATEHEAP_UNRECOGNIZEDMISCFLAGS = 630,
	// D3D12_MESSAGE_ID_CREATEHEAP_INVALIDMISCFLAGS = 631, D3D12_MESSAGE_ID_CREATEHEAP_INVALIDARG_RETURN = 632,
	// D3D12_MESSAGE_ID_CREATEHEAP_OUTOFMEMORY_RETURN = 633, D3D12_MESSAGE_ID_CREATERESOURCEANDHEAP_NULLHEAPPROPERTIES = 634,
	// D3D12_MESSAGE_ID_CREATERESOURCEANDHEAP_UNRECOGNIZEDHEAPTYPE = 635,
	// D3D12_MESSAGE_ID_CREATERESOURCEANDHEAP_UNRECOGNIZEDCPUPAGEPROPERTIES = 636,
	// D3D12_MESSAGE_ID_CREATERESOURCEANDHEAP_UNRECOGNIZEDMEMORYPOOL = 637, D3D12_MESSAGE_ID_CREATERESOURCEANDHEAP_INVALIDHEAPPROPERTIES =
	// 638, D3D12_MESSAGE_ID_CREATERESOURCEANDHEAP_UNRECOGNIZEDHEAPMISCFLAGS = 639,
	// D3D12_MESSAGE_ID_CREATERESOURCEANDHEAP_INVALIDHEAPMISCFLAGS = 640, D3D12_MESSAGE_ID_CREATERESOURCEANDHEAP_INVALIDARG_RETURN = 641,
	// D3D12_MESSAGE_ID_CREATERESOURCEANDHEAP_OUTOFMEMORY_RETURN = 642, D3D12_MESSAGE_ID_GETCUSTOMHEAPPROPERTIES_UNRECOGNIZEDHEAPTYPE = 643,
	// D3D12_MESSAGE_ID_GETCUSTOMHEAPPROPERTIES_INVALIDHEAPTYPE = 644, D3D12_MESSAGE_ID_CREATE_DESCRIPTOR_HEAP_INVALID_DESC = 645,
	// D3D12_MESSAGE_ID_INVALID_DESCRIPTOR_HANDLE = 646, D3D12_MESSAGE_ID_CREATERASTERIZERSTATE_INVALID_CONSERVATIVERASTERMODE = 647,
	// D3D12_MESSAGE_ID_CREATE_CONSTANT_BUFFER_VIEW_INVALID_RESOURCE = 649, D3D12_MESSAGE_ID_CREATE_CONSTANT_BUFFER_VIEW_INVALID_DESC = 650,
	// D3D12_MESSAGE_ID_CREATE_UNORDEREDACCESS_VIEW_INVALID_COUNTER_USAGE = 652, D3D12_MESSAGE_ID_COPY_DESCRIPTORS_INVALID_RANGES = 653,
	// D3D12_MESSAGE_ID_COPY_DESCRIPTORS_WRITE_ONLY_DESCRIPTOR = 654, D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_RTV_FORMAT_NOT_UNKNOWN =
	// 655, D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_INVALID_RENDER_TARGET_COUNT = 656,
	// D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_VERTEX_SHADER_NOT_SET = 657,
	// D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_INPUTLAYOUT_NOT_SET = 658,
	// D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_SHADER_LINKAGE_HS_DS_SIGNATURE_MISMATCH = 659,
	// D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_SHADER_LINKAGE_REGISTERINDEX = 660,
	// D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_SHADER_LINKAGE_COMPONENTTYPE = 661,
	// D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_SHADER_LINKAGE_REGISTERMASK = 662,
	// D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_SHADER_LINKAGE_SYSTEMVALUE = 663,
	// D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_SHADER_LINKAGE_NEVERWRITTEN_ALWAYSREADS = 664,
	// D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_SHADER_LINKAGE_MINPRECISION = 665,
	// D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_SHADER_LINKAGE_SEMANTICNAME_NOT_FOUND = 666,
	// D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_HS_XOR_DS_MISMATCH = 667,
	// D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_HULL_SHADER_INPUT_TOPOLOGY_MISMATCH = 668,
	// D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_HS_DS_CONTROL_POINT_COUNT_MISMATCH = 669,
	// D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_HS_DS_TESSELLATOR_DOMAIN_MISMATCH = 670,
	// D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_INVALID_USE_OF_CENTER_MULTISAMPLE_PATTERN = 671,
	// D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_INVALID_USE_OF_FORCED_SAMPLE_COUNT = 672,
	// D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_INVALID_PRIMITIVETOPOLOGY = 673,
	// D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_INVALID_SYSTEMVALUE = 674,
	// D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_OM_DUAL_SOURCE_BLENDING_CAN_ONLY_HAVE_RENDER_TARGET_0 = 675,
	// D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_OM_RENDER_TARGET_DOES_NOT_SUPPORT_BLENDING = 676,
	// D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_PS_OUTPUT_TYPE_MISMATCH = 677,
	// D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_OM_RENDER_TARGET_DOES_NOT_SUPPORT_LOGIC_OPS = 678,
	// D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_RENDERTARGETVIEW_NOT_SET = 679,
	// D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_DEPTHSTENCILVIEW_NOT_SET = 680,
	// D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_GS_INPUT_PRIMITIVE_MISMATCH = 681,
	// D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_POSITION_NOT_PRESENT = 682,
	// D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_MISSING_ROOT_SIGNATURE_FLAGS = 683,
	// D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_INVALID_INDEX_BUFFER_PROPERTIES = 684,
	// D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_INVALID_SAMPLE_DESC = 685,
	// D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_HS_ROOT_SIGNATURE_MISMATCH = 686,
	// D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_DS_ROOT_SIGNATURE_MISMATCH = 687,
	// D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_VS_ROOT_SIGNATURE_MISMATCH = 688,
	// D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_GS_ROOT_SIGNATURE_MISMATCH = 689,
	// D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_PS_ROOT_SIGNATURE_MISMATCH = 690,
	// D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_MISSING_ROOT_SIGNATURE = 691, D3D12_MESSAGE_ID_EXECUTE_BUNDLE_OPEN_BUNDLE = 692,
	// D3D12_MESSAGE_ID_EXECUTE_BUNDLE_DESCRIPTOR_HEAP_MISMATCH = 693, D3D12_MESSAGE_ID_EXECUTE_BUNDLE_TYPE = 694,
	// D3D12_MESSAGE_ID_DRAW_EMPTY_SCISSOR_RECTANGLE = 695, D3D12_MESSAGE_ID_CREATE_ROOT_SIGNATURE_BLOB_NOT_FOUND = 696,
	// D3D12_MESSAGE_ID_CREATE_ROOT_SIGNATURE_DESERIALIZE_FAILED = 697, D3D12_MESSAGE_ID_CREATE_ROOT_SIGNATURE_INVALID_CONFIGURATION = 698,
	// D3D12_MESSAGE_ID_CREATE_ROOT_SIGNATURE_NOT_SUPPORTED_ON_DEVICE = 699, D3D12_MESSAGE_ID_CREATERESOURCEANDHEAP_NULLRESOURCEPROPERTIES =
	// 700, D3D12_MESSAGE_ID_CREATERESOURCEANDHEAP_NULLHEAP = 701, D3D12_MESSAGE_ID_GETRESOURCEALLOCATIONINFO_INVALIDRDESCS = 702,
	// D3D12_MESSAGE_ID_MAKERESIDENT_NULLOBJECTARRAY = 703, D3D12_MESSAGE_ID_EVICT_NULLOBJECTARRAY = 705,
	// D3D12_MESSAGE_ID_SET_DESCRIPTOR_TABLE_INVALID = 708, D3D12_MESSAGE_ID_SET_ROOT_CONSTANT_INVALID = 709,
	// D3D12_MESSAGE_ID_SET_ROOT_CONSTANT_BUFFER_VIEW_INVALID = 710, D3D12_MESSAGE_ID_SET_ROOT_SHADER_RESOURCE_VIEW_INVALID = 711,
	// D3D12_MESSAGE_ID_SET_ROOT_UNORDERED_ACCESS_VIEW_INVALID = 712, D3D12_MESSAGE_ID_SET_VERTEX_BUFFERS_INVALID_DESC = 713,
	// D3D12_MESSAGE_ID_SET_INDEX_BUFFER_INVALID_DESC = 715, D3D12_MESSAGE_ID_SET_STREAM_OUTPUT_BUFFERS_INVALID_DESC = 717,
	// D3D12_MESSAGE_ID_CREATERESOURCE_UNRECOGNIZEDDIMENSIONALITY = 718, D3D12_MESSAGE_ID_CREATERESOURCE_UNRECOGNIZEDLAYOUT = 719,
	// D3D12_MESSAGE_ID_CREATERESOURCE_INVALIDDIMENSIONALITY = 720, D3D12_MESSAGE_ID_CREATERESOURCE_INVALIDALIGNMENT = 721,
	// D3D12_MESSAGE_ID_CREATERESOURCE_INVALIDMIPLEVELS = 722, D3D12_MESSAGE_ID_CREATERESOURCE_INVALIDSAMPLEDESC = 723,
	// D3D12_MESSAGE_ID_CREATERESOURCE_INVALIDLAYOUT = 724, D3D12_MESSAGE_ID_SET_INDEX_BUFFER_INVALID = 725,
	// D3D12_MESSAGE_ID_SET_VERTEX_BUFFERS_INVALID = 726, D3D12_MESSAGE_ID_SET_STREAM_OUTPUT_BUFFERS_INVALID = 727,
	// D3D12_MESSAGE_ID_SET_RENDER_TARGETS_INVALID = 728, D3D12_MESSAGE_ID_CREATEQUERY_HEAP_INVALID_PARAMETERS = 729,
	// D3D12_MESSAGE_ID_BEGIN_END_QUERY_INVALID_PARAMETERS = 731, D3D12_MESSAGE_ID_CLOSE_COMMAND_LIST_OPEN_QUERY = 732,
	// D3D12_MESSAGE_ID_RESOLVE_QUERY_DATA_INVALID_PARAMETERS = 733, D3D12_MESSAGE_ID_SET_PREDICATION_INVALID_PARAMETERS = 734,
	// D3D12_MESSAGE_ID_TIMESTAMPS_NOT_SUPPORTED = 735, D3D12_MESSAGE_ID_CREATERESOURCE_UNRECOGNIZEDFORMAT = 737,
	// D3D12_MESSAGE_ID_CREATERESOURCE_INVALIDFORMAT = 738, D3D12_MESSAGE_ID_GETCOPYABLEFOOTPRINTS_INVALIDSUBRESOURCERANGE = 739,
	// D3D12_MESSAGE_ID_GETCOPYABLEFOOTPRINTS_INVALIDBASEOFFSET = 740, D3D12_MESSAGE_ID_GETCOPYABLELAYOUT_INVALIDSUBRESOURCERANGE = 739,
	// D3D12_MESSAGE_ID_GETCOPYABLELAYOUT_INVALIDBASEOFFSET = 740, D3D12_MESSAGE_ID_RESOURCE_BARRIER_INVALID_HEAP = 741,
	// D3D12_MESSAGE_ID_CREATE_SAMPLER_INVALID = 742, D3D12_MESSAGE_ID_CREATECOMMANDSIGNATURE_INVALID = 743,
	// D3D12_MESSAGE_ID_EXECUTE_INDIRECT_INVALID_PARAMETERS = 744, D3D12_MESSAGE_ID_GETGPUVIRTUALADDRESS_INVALID_RESOURCE_DIMENSION = 745,
	// D3D12_MESSAGE_ID_CREATERESOURCE_INVALIDCLEARVALUE = 815, D3D12_MESSAGE_ID_CREATERESOURCE_UNRECOGNIZEDCLEARVALUEFORMAT = 816,
	// D3D12_MESSAGE_ID_CREATERESOURCE_INVALIDCLEARVALUEFORMAT = 817, D3D12_MESSAGE_ID_CREATERESOURCE_CLEARVALUEDENORMFLUSH = 818,
	// D3D12_MESSAGE_ID_CLEARRENDERTARGETVIEW_MISMATCHINGCLEARVALUE = 820, D3D12_MESSAGE_ID_CLEARDEPTHSTENCILVIEW_MISMATCHINGCLEARVALUE =
	// 821, D3D12_MESSAGE_ID_MAP_INVALIDHEAP = 822, D3D12_MESSAGE_ID_UNMAP_INVALIDHEAP = 823, D3D12_MESSAGE_ID_MAP_INVALIDRESOURCE = 824,
	// D3D12_MESSAGE_ID_UNMAP_INVALIDRESOURCE = 825, D3D12_MESSAGE_ID_MAP_INVALIDSUBRESOURCE = 826,
	// D3D12_MESSAGE_ID_UNMAP_INVALIDSUBRESOURCE = 827, D3D12_MESSAGE_ID_MAP_INVALIDRANGE = 828, D3D12_MESSAGE_ID_UNMAP_INVALIDRANGE = 829,
	// D3D12_MESSAGE_ID_MAP_INVALIDDATAPOINTER = 832, D3D12_MESSAGE_ID_MAP_INVALIDARG_RETURN = 833, D3D12_MESSAGE_ID_MAP_OUTOFMEMORY_RETURN
	// = 834, D3D12_MESSAGE_ID_EXECUTECOMMANDLISTS_BUNDLENOTSUPPORTED = 835, D3D12_MESSAGE_ID_EXECUTECOMMANDLISTS_COMMANDLISTMISMATCH = 836,
	// D3D12_MESSAGE_ID_EXECUTECOMMANDLISTS_OPENCOMMANDLIST = 837, D3D12_MESSAGE_ID_EXECUTECOMMANDLISTS_FAILEDCOMMANDLIST = 838,
	// D3D12_MESSAGE_ID_COPYBUFFERREGION_NULLDST = 839, D3D12_MESSAGE_ID_COPYBUFFERREGION_INVALIDDSTRESOURCEDIMENSION = 840,
	// D3D12_MESSAGE_ID_COPYBUFFERREGION_DSTRANGEOUTOFBOUNDS = 841, D3D12_MESSAGE_ID_COPYBUFFERREGION_NULLSRC = 842,
	// D3D12_MESSAGE_ID_COPYBUFFERREGION_INVALIDSRCRESOURCEDIMENSION = 843, D3D12_MESSAGE_ID_COPYBUFFERREGION_SRCRANGEOUTOFBOUNDS = 844,
	// D3D12_MESSAGE_ID_COPYBUFFERREGION_INVALIDCOPYFLAGS = 845, D3D12_MESSAGE_ID_COPYTEXTUREREGION_NULLDST = 846,
	// D3D12_MESSAGE_ID_COPYTEXTUREREGION_UNRECOGNIZEDDSTTYPE = 847, D3D12_MESSAGE_ID_COPYTEXTUREREGION_INVALIDDSTRESOURCEDIMENSION = 848,
	// D3D12_MESSAGE_ID_COPYTEXTUREREGION_INVALIDDSTRESOURCE = 849, D3D12_MESSAGE_ID_COPYTEXTUREREGION_INVALIDDSTSUBRESOURCE = 850,
	// D3D12_MESSAGE_ID_COPYTEXTUREREGION_INVALIDDSTOFFSET = 851, D3D12_MESSAGE_ID_COPYTEXTUREREGION_UNRECOGNIZEDDSTFORMAT = 852,
	// D3D12_MESSAGE_ID_COPYTEXTUREREGION_INVALIDDSTFORMAT = 853, D3D12_MESSAGE_ID_COPYTEXTUREREGION_INVALIDDSTDIMENSIONS = 854,
	// D3D12_MESSAGE_ID_COPYTEXTUREREGION_INVALIDDSTROWPITCH = 855, D3D12_MESSAGE_ID_COPYTEXTUREREGION_INVALIDDSTPLACEMENT = 856,
	// D3D12_MESSAGE_ID_COPYTEXTUREREGION_INVALIDDSTDSPLACEDFOOTPRINTFORMAT = 857, D3D12_MESSAGE_ID_COPYTEXTUREREGION_DSTREGIONOUTOFBOUNDS =
	// 858, D3D12_MESSAGE_ID_COPYTEXTUREREGION_NULLSRC = 859, D3D12_MESSAGE_ID_COPYTEXTUREREGION_UNRECOGNIZEDSRCTYPE = 860,
	// D3D12_MESSAGE_ID_COPYTEXTUREREGION_INVALIDSRCRESOURCEDIMENSION = 861, D3D12_MESSAGE_ID_COPYTEXTUREREGION_INVALIDSRCRESOURCE = 862,
	// D3D12_MESSAGE_ID_COPYTEXTUREREGION_INVALIDSRCSUBRESOURCE = 863, D3D12_MESSAGE_ID_COPYTEXTUREREGION_INVALIDSRCOFFSET = 864,
	// D3D12_MESSAGE_ID_COPYTEXTUREREGION_UNRECOGNIZEDSRCFORMAT = 865, D3D12_MESSAGE_ID_COPYTEXTUREREGION_INVALIDSRCFORMAT = 866,
	// D3D12_MESSAGE_ID_COPYTEXTUREREGION_INVALIDSRCDIMENSIONS = 867, D3D12_MESSAGE_ID_COPYTEXTUREREGION_INVALIDSRCROWPITCH = 868,
	// D3D12_MESSAGE_ID_COPYTEXTUREREGION_INVALIDSRCPLACEMENT = 869, D3D12_MESSAGE_ID_COPYTEXTUREREGION_INVALIDSRCDSPLACEDFOOTPRINTFORMAT =
	// 870, D3D12_MESSAGE_ID_COPYTEXTUREREGION_SRCREGIONOUTOFBOUNDS = 871, D3D12_MESSAGE_ID_COPYTEXTUREREGION_INVALIDDSTCOORDINATES = 872,
	// D3D12_MESSAGE_ID_COPYTEXTUREREGION_INVALIDSRCBOX = 873, D3D12_MESSAGE_ID_COPYTEXTUREREGION_FORMATMISMATCH = 874,
	// D3D12_MESSAGE_ID_COPYTEXTUREREGION_EMPTYBOX = 875, D3D12_MESSAGE_ID_COPYTEXTUREREGION_INVALIDCOPYFLAGS = 876,
	// D3D12_MESSAGE_ID_RESOLVESUBRESOURCE_INVALID_SUBRESOURCE_INDEX = 877, D3D12_MESSAGE_ID_RESOLVESUBRESOURCE_INVALID_FORMAT = 878,
	// D3D12_MESSAGE_ID_RESOLVESUBRESOURCE_RESOURCE_MISMATCH = 879, D3D12_MESSAGE_ID_RESOLVESUBRESOURCE_INVALID_SAMPLE_COUNT = 880,
	// D3D12_MESSAGE_ID_CREATECOMPUTEPIPELINESTATE_INVALID_SHADER = 881,
	// D3D12_MESSAGE_ID_CREATECOMPUTEPIPELINESTATE_CS_ROOT_SIGNATURE_MISMATCH = 882,
	// D3D12_MESSAGE_ID_CREATECOMPUTEPIPELINESTATE_MISSING_ROOT_SIGNATURE = 883, D3D12_MESSAGE_ID_CREATEPIPELINESTATE_INVALIDCACHEDBLOB =
	// 884, D3D12_MESSAGE_ID_CREATEPIPELINESTATE_CACHEDBLOBADAPTERMISMATCH = 885,
	// D3D12_MESSAGE_ID_CREATEPIPELINESTATE_CACHEDBLOBDRIVERVERSIONMISMATCH = 886,
	// D3D12_MESSAGE_ID_CREATEPIPELINESTATE_CACHEDBLOBDESCMISMATCH = 887, D3D12_MESSAGE_ID_CREATEPIPELINESTATE_CACHEDBLOBIGNORED = 888,
	// D3D12_MESSAGE_ID_WRITETOSUBRESOURCE_INVALIDHEAP = 889, D3D12_MESSAGE_ID_WRITETOSUBRESOURCE_INVALIDRESOURCE = 890,
	// D3D12_MESSAGE_ID_WRITETOSUBRESOURCE_INVALIDBOX = 891, D3D12_MESSAGE_ID_WRITETOSUBRESOURCE_INVALIDSUBRESOURCE = 892,
	// D3D12_MESSAGE_ID_WRITETOSUBRESOURCE_EMPTYBOX = 893, D3D12_MESSAGE_ID_READFROMSUBRESOURCE_INVALIDHEAP = 894,
	// D3D12_MESSAGE_ID_READFROMSUBRESOURCE_INVALIDRESOURCE = 895, D3D12_MESSAGE_ID_READFROMSUBRESOURCE_INVALIDBOX = 896,
	// D3D12_MESSAGE_ID_READFROMSUBRESOURCE_INVALIDSUBRESOURCE = 897, D3D12_MESSAGE_ID_READFROMSUBRESOURCE_EMPTYBOX = 898,
	// D3D12_MESSAGE_ID_TOO_MANY_NODES_SPECIFIED = 899, D3D12_MESSAGE_ID_INVALID_NODE_INDEX = 900,
	// D3D12_MESSAGE_ID_GETHEAPPROPERTIES_INVALIDRESOURCE = 901, D3D12_MESSAGE_ID_NODE_MASK_MISMATCH = 902,
	// D3D12_MESSAGE_ID_COMMAND_LIST_OUTOFMEMORY = 903, D3D12_MESSAGE_ID_COMMAND_LIST_MULTIPLE_SWAPCHAIN_BUFFER_REFERENCES = 904,
	// D3D12_MESSAGE_ID_COMMAND_LIST_TOO_MANY_SWAPCHAIN_REFERENCES = 905, D3D12_MESSAGE_ID_COMMAND_QUEUE_TOO_MANY_SWAPCHAIN_REFERENCES =
	// 906, D3D12_MESSAGE_ID_EXECUTECOMMANDLISTS_WRONGSWAPCHAINBUFFERREFERENCE = 907,
	// D3D12_MESSAGE_ID_COMMAND_LIST_SETRENDERTARGETS_INVALIDNUMRENDERTARGETS = 908, D3D12_MESSAGE_ID_CREATE_QUEUE_INVALID_TYPE = 909,
	// D3D12_MESSAGE_ID_CREATE_QUEUE_INVALID_FLAGS = 910, D3D12_MESSAGE_ID_CREATESHAREDRESOURCE_INVALIDFLAGS = 911,
	// D3D12_MESSAGE_ID_CREATESHAREDRESOURCE_INVALIDFORMAT = 912, D3D12_MESSAGE_ID_CREATESHAREDHEAP_INVALIDFLAGS = 913,
	// D3D12_MESSAGE_ID_REFLECTSHAREDPROPERTIES_UNRECOGNIZEDPROPERTIES = 914, D3D12_MESSAGE_ID_REFLECTSHAREDPROPERTIES_INVALIDSIZE = 915,
	// D3D12_MESSAGE_ID_REFLECTSHAREDPROPERTIES_INVALIDOBJECT = 916, D3D12_MESSAGE_ID_KEYEDMUTEX_INVALIDOBJECT = 917,
	// D3D12_MESSAGE_ID_KEYEDMUTEX_INVALIDKEY = 918, D3D12_MESSAGE_ID_KEYEDMUTEX_WRONGSTATE = 919,
	// D3D12_MESSAGE_ID_CREATE_QUEUE_INVALID_PRIORITY = 920, D3D12_MESSAGE_ID_OBJECT_DELETED_WHILE_STILL_IN_USE = 921,
	// D3D12_MESSAGE_ID_CREATEPIPELINESTATE_INVALID_FLAGS = 922, D3D12_MESSAGE_ID_HEAP_ADDRESS_RANGE_HAS_NO_RESOURCE = 923,
	// D3D12_MESSAGE_ID_COMMAND_LIST_DRAW_RENDER_TARGET_DELETED = 924,
	// D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_ALL_RENDER_TARGETS_HAVE_UNKNOWN_FORMAT = 925,
	// D3D12_MESSAGE_ID_HEAP_ADDRESS_RANGE_INTERSECTS_MULTIPLE_BUFFERS = 926,
	// D3D12_MESSAGE_ID_EXECUTECOMMANDLISTS_GPU_WRITTEN_READBACK_RESOURCE_MAPPED = 927, D3D12_MESSAGE_ID_UNMAP_RANGE_NOT_EMPTY = 929,
	// D3D12_MESSAGE_ID_MAP_INVALID_NULLRANGE = 930, D3D12_MESSAGE_ID_UNMAP_INVALID_NULLRANGE = 931,
	// D3D12_MESSAGE_ID_NO_GRAPHICS_API_SUPPORT = 932, D3D12_MESSAGE_ID_NO_COMPUTE_API_SUPPORT = 933,
	// D3D12_MESSAGE_ID_RESOLVESUBRESOURCE_RESOURCE_FLAGS_NOT_SUPPORTED = 934,
	// D3D12_MESSAGE_ID_GPU_BASED_VALIDATION_ROOT_ARGUMENT_UNINITIALIZED = 935,
	// D3D12_MESSAGE_ID_GPU_BASED_VALIDATION_DESCRIPTOR_HEAP_INDEX_OUT_OF_BOUNDS = 936,
	// D3D12_MESSAGE_ID_GPU_BASED_VALIDATION_DESCRIPTOR_TABLE_REGISTER_INDEX_OUT_OF_BOUNDS = 937,
	// D3D12_MESSAGE_ID_GPU_BASED_VALIDATION_DESCRIPTOR_UNINITIALIZED = 938, D3D12_MESSAGE_ID_GPU_BASED_VALIDATION_DESCRIPTOR_TYPE_MISMATCH
	// = 939, D3D12_MESSAGE_ID_GPU_BASED_VALIDATION_SRV_RESOURCE_DIMENSION_MISMATCH = 940,
	// D3D12_MESSAGE_ID_GPU_BASED_VALIDATION_UAV_RESOURCE_DIMENSION_MISMATCH = 941,
	// D3D12_MESSAGE_ID_GPU_BASED_VALIDATION_INCOMPATIBLE_RESOURCE_STATE = 942, D3D12_MESSAGE_ID_COPYRESOURCE_NULLDST = 943,
	// D3D12_MESSAGE_ID_COPYRESOURCE_INVALIDDSTRESOURCE = 944, D3D12_MESSAGE_ID_COPYRESOURCE_NULLSRC = 945,
	// D3D12_MESSAGE_ID_COPYRESOURCE_INVALIDSRCRESOURCE = 946, D3D12_MESSAGE_ID_RESOLVESUBRESOURCE_NULLDST = 947,
	// D3D12_MESSAGE_ID_RESOLVESUBRESOURCE_INVALIDDSTRESOURCE = 948, D3D12_MESSAGE_ID_RESOLVESUBRESOURCE_NULLSRC = 949,
	// D3D12_MESSAGE_ID_RESOLVESUBRESOURCE_INVALIDSRCRESOURCE = 950, D3D12_MESSAGE_ID_PIPELINE_STATE_TYPE_MISMATCH = 951,
	// D3D12_MESSAGE_ID_COMMAND_LIST_DISPATCH_ROOT_SIGNATURE_NOT_SET = 952, D3D12_MESSAGE_ID_COMMAND_LIST_DISPATCH_ROOT_SIGNATURE_MISMATCH =
	// 953, D3D12_MESSAGE_ID_RESOURCE_BARRIER_ZERO_BARRIERS = 954, D3D12_MESSAGE_ID_BEGIN_END_EVENT_MISMATCH = 955,
	// D3D12_MESSAGE_ID_RESOURCE_BARRIER_POSSIBLE_BEFORE_AFTER_MISMATCH = 956, D3D12_MESSAGE_ID_RESOURCE_BARRIER_MISMATCHING_BEGIN_END =
	// 957, D3D12_MESSAGE_ID_GPU_BASED_VALIDATION_INVALID_RESOURCE = 958, D3D12_MESSAGE_ID_USE_OF_ZERO_REFCOUNT_OBJECT = 959,
	// D3D12_MESSAGE_ID_OBJECT_EVICTED_WHILE_STILL_IN_USE = 960, D3D12_MESSAGE_ID_GPU_BASED_VALIDATION_ROOT_DESCRIPTOR_ACCESS_OUT_OF_BOUNDS
	// = 961, D3D12_MESSAGE_ID_CREATEPIPELINELIBRARY_INVALIDLIBRARYBLOB = 962, D3D12_MESSAGE_ID_CREATEPIPELINELIBRARY_DRIVERVERSIONMISMATCH
	// = 963, D3D12_MESSAGE_ID_CREATEPIPELINELIBRARY_ADAPTERVERSIONMISMATCH = 964, D3D12_MESSAGE_ID_CREATEPIPELINELIBRARY_UNSUPPORTED = 965,
	// D3D12_MESSAGE_ID_CREATE_PIPELINELIBRARY = 966, D3D12_MESSAGE_ID_LIVE_PIPELINELIBRARY = 967, D3D12_MESSAGE_ID_DESTROY_PIPELINELIBRARY
	// = 968, D3D12_MESSAGE_ID_STOREPIPELINE_NONAME = 969, D3D12_MESSAGE_ID_STOREPIPELINE_DUPLICATENAME = 970,
	// D3D12_MESSAGE_ID_LOADPIPELINE_NAMENOTFOUND = 971, D3D12_MESSAGE_ID_LOADPIPELINE_INVALIDDESC = 972,
	// D3D12_MESSAGE_ID_PIPELINELIBRARY_SERIALIZE_NOTENOUGHMEMORY = 973,
	// D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_PS_OUTPUT_RT_OUTPUT_MISMATCH = 974,
	// D3D12_MESSAGE_ID_SETEVENTONMULTIPLEFENCECOMPLETION_INVALIDFLAGS = 975, D3D12_MESSAGE_ID_CREATE_QUEUE_VIDEO_NOT_SUPPORTED = 976,
	// D3D12_MESSAGE_ID_CREATE_COMMAND_ALLOCATOR_VIDEO_NOT_SUPPORTED = 977,
	// D3D12_MESSAGE_ID_CREATEQUERY_HEAP_VIDEO_DECODE_STATISTICS_NOT_SUPPORTED = 978, D3D12_MESSAGE_ID_CREATE_VIDEODECODECOMMANDLIST = 979,
	// D3D12_MESSAGE_ID_CREATE_VIDEODECODER = 980, D3D12_MESSAGE_ID_CREATE_VIDEODECODESTREAM = 981,
	// D3D12_MESSAGE_ID_LIVE_VIDEODECODECOMMANDLIST = 982, D3D12_MESSAGE_ID_LIVE_VIDEODECODER = 983, D3D12_MESSAGE_ID_LIVE_VIDEODECODESTREAM
	// = 984, D3D12_MESSAGE_ID_DESTROY_VIDEODECODECOMMANDLIST = 985, D3D12_MESSAGE_ID_DESTROY_VIDEODECODER = 986,
	// D3D12_MESSAGE_ID_DESTROY_VIDEODECODESTREAM = 987, D3D12_MESSAGE_ID_DECODE_FRAME_INVALID_PARAMETERS = 988,
	// D3D12_MESSAGE_ID_DEPRECATED_API = 989, D3D12_MESSAGE_ID_RESOURCE_BARRIER_MISMATCHING_COMMAND_LIST_TYPE = 990,
	// D3D12_MESSAGE_ID_COMMAND_LIST_DESCRIPTOR_TABLE_NOT_SET = 991, D3D12_MESSAGE_ID_COMMAND_LIST_ROOT_CONSTANT_BUFFER_VIEW_NOT_SET = 992,
	// D3D12_MESSAGE_ID_COMMAND_LIST_ROOT_SHADER_RESOURCE_VIEW_NOT_SET = 993,
	// D3D12_MESSAGE_ID_COMMAND_LIST_ROOT_UNORDERED_ACCESS_VIEW_NOT_SET = 994, D3D12_MESSAGE_ID_DISCARD_INVALID_SUBRESOURCE_RANGE = 995,
	// D3D12_MESSAGE_ID_DISCARD_ONE_SUBRESOURCE_FOR_MIPS_WITH_RECTS = 996, D3D12_MESSAGE_ID_DISCARD_NO_RECTS_FOR_NON_TEXTURE2D = 997,
	// D3D12_MESSAGE_ID_COPY_ON_SAME_SUBRESOURCE = 998, D3D12_MESSAGE_ID_SETRESIDENCYPRIORITY_INVALID_PAGEABLE = 999,
	// D3D12_MESSAGE_ID_GPU_BASED_VALIDATION_UNSUPPORTED = 1000, D3D12_MESSAGE_ID_STATIC_DESCRIPTOR_INVALID_DESCRIPTOR_CHANGE = 1001,
	// D3D12_MESSAGE_ID_DATA_STATIC_DESCRIPTOR_INVALID_DATA_CHANGE = 1002,
	// D3D12_MESSAGE_ID_DATA_STATIC_WHILE_SET_AT_EXECUTE_DESCRIPTOR_INVALID_DATA_CHANGE = 1003,
	// D3D12_MESSAGE_ID_EXECUTE_BUNDLE_STATIC_DESCRIPTOR_DATA_STATIC_NOT_SET = 1004,
	// D3D12_MESSAGE_ID_GPU_BASED_VALIDATION_RESOURCE_ACCESS_OUT_OF_BOUNDS = 1005,
	// D3D12_MESSAGE_ID_GPU_BASED_VALIDATION_SAMPLER_MODE_MISMATCH = 1006, D3D12_MESSAGE_ID_CREATE_FENCE_INVALID_FLAGS = 1007,
	// D3D12_MESSAGE_ID_RESOURCE_BARRIER_DUPLICATE_SUBRESOURCE_TRANSITIONS = 1008, D3D12_MESSAGE_ID_SETRESIDENCYPRIORITY_INVALID_PRIORITY =
	// 1009, D3D12_MESSAGE_ID_CREATE_DESCRIPTOR_HEAP_LARGE_NUM_DESCRIPTORS = 1013, D3D12_MESSAGE_ID_BEGIN_EVENT = 1014,
	// D3D12_MESSAGE_ID_END_EVENT = 1015, D3D12_MESSAGE_ID_CREATEDEVICE_DEBUG_LAYER_STARTUP_OPTIONS = 1016,
	// D3D12_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_DEPTHBOUNDSTEST_UNSUPPORTED = 1017, D3D12_MESSAGE_ID_CREATEPIPELINESTATE_DUPLICATE_SUBOBJECT
	// = 1018, D3D12_MESSAGE_ID_CREATEPIPELINESTATE_UNKNOWN_SUBOBJECT = 1019, D3D12_MESSAGE_ID_CREATEPIPELINESTATE_ZERO_SIZE_STREAM = 1020,
	// D3D12_MESSAGE_ID_CREATEPIPELINESTATE_INVALID_STREAM = 1021, D3D12_MESSAGE_ID_CREATEPIPELINESTATE_CANNOT_DEDUCE_TYPE = 1022,
	// D3D12_MESSAGE_ID_COMMAND_LIST_STATIC_DESCRIPTOR_RESOURCE_DIMENSION_MISMATCH = 1023,
	// D3D12_MESSAGE_ID_CREATE_COMMAND_QUEUE_INSUFFICIENT_PRIVILEGE_FOR_GLOBAL_REALTIME = 1024,
	// D3D12_MESSAGE_ID_CREATE_COMMAND_QUEUE_INSUFFICIENT_HARDWARE_SUPPORT_FOR_GLOBAL_REALTIME = 1025,
	// D3D12_MESSAGE_ID_ATOMICCOPYBUFFER_INVALID_ARCHITECTURE = 1026, D3D12_MESSAGE_ID_ATOMICCOPYBUFFER_NULL_DST = 1027,
	// D3D12_MESSAGE_ID_ATOMICCOPYBUFFER_INVALID_DST_RESOURCE_DIMENSION = 1028, D3D12_MESSAGE_ID_ATOMICCOPYBUFFER_DST_RANGE_OUT_OF_BOUNDS =
	// 1029, D3D12_MESSAGE_ID_ATOMICCOPYBUFFER_NULL_SRC = 1030, D3D12_MESSAGE_ID_ATOMICCOPYBUFFER_INVALID_SRC_RESOURCE_DIMENSION = 1031,
	// D3D12_MESSAGE_ID_ATOMICCOPYBUFFER_SRC_RANGE_OUT_OF_BOUNDS = 1032, D3D12_MESSAGE_ID_ATOMICCOPYBUFFER_INVALID_OFFSET_ALIGNMENT = 1033,
	// D3D12_MESSAGE_ID_ATOMICCOPYBUFFER_NULL_DEPENDENT_RESOURCES = 1034,
	// D3D12_MESSAGE_ID_ATOMICCOPYBUFFER_NULL_DEPENDENT_SUBRESOURCE_RANGES = 1035,
	// D3D12_MESSAGE_ID_ATOMICCOPYBUFFER_INVALID_DEPENDENT_RESOURCE = 1036,
	// D3D12_MESSAGE_ID_ATOMICCOPYBUFFER_INVALID_DEPENDENT_SUBRESOURCE_RANGE = 1037,
	// D3D12_MESSAGE_ID_ATOMICCOPYBUFFER_DEPENDENT_SUBRESOURCE_OUT_OF_BOUNDS = 1038,
	// D3D12_MESSAGE_ID_ATOMICCOPYBUFFER_DEPENDENT_RANGE_OUT_OF_BOUNDS = 1039, D3D12_MESSAGE_ID_ATOMICCOPYBUFFER_ZERO_DEPENDENCIES = 1040,
	// D3D12_MESSAGE_ID_DEVICE_CREATE_SHARED_HANDLE_INVALIDARG = 1041, D3D12_MESSAGE_ID_DESCRIPTOR_HANDLE_WITH_INVALID_RESOURCE = 1042,
	// D3D12_MESSAGE_ID_SETDEPTHBOUNDS_INVALIDARGS = 1043, D3D12_MESSAGE_ID_GPU_BASED_VALIDATION_RESOURCE_STATE_IMPRECISE = 1044,
	// D3D12_MESSAGE_ID_COMMAND_LIST_PIPELINE_STATE_NOT_SET = 1045, D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_SHADER_MODEL_MISMATCH =
	// 1046, D3D12_MESSAGE_ID_OBJECT_ACCESSED_WHILE_STILL_IN_USE = 1047, D3D12_MESSAGE_ID_PROGRAMMABLE_MSAA_UNSUPPORTED = 1048,
	// D3D12_MESSAGE_ID_SETSAMPLEPOSITIONS_INVALIDARGS = 1049, D3D12_MESSAGE_ID_RESOLVESUBRESOURCEREGION_INVALID_RECT = 1050,
	// D3D12_MESSAGE_ID_CREATE_VIDEODECODECOMMANDQUEUE = 1051, D3D12_MESSAGE_ID_CREATE_VIDEOPROCESSCOMMANDLIST = 1052,
	// D3D12_MESSAGE_ID_CREATE_VIDEOPROCESSCOMMANDQUEUE = 1053, D3D12_MESSAGE_ID_LIVE_VIDEODECODECOMMANDQUEUE = 1054,
	// D3D12_MESSAGE_ID_LIVE_VIDEOPROCESSCOMMANDLIST = 1055, D3D12_MESSAGE_ID_LIVE_VIDEOPROCESSCOMMANDQUEUE = 1056,
	// D3D12_MESSAGE_ID_DESTROY_VIDEODECODECOMMANDQUEUE = 1057, D3D12_MESSAGE_ID_DESTROY_VIDEOPROCESSCOMMANDLIST = 1058,
	// D3D12_MESSAGE_ID_DESTROY_VIDEOPROCESSCOMMANDQUEUE = 1059, D3D12_MESSAGE_ID_CREATE_VIDEOPROCESSOR = 1060,
	// D3D12_MESSAGE_ID_CREATE_VIDEOPROCESSSTREAM = 1061, D3D12_MESSAGE_ID_LIVE_VIDEOPROCESSOR = 1062,
	// D3D12_MESSAGE_ID_LIVE_VIDEOPROCESSSTREAM = 1063, D3D12_MESSAGE_ID_DESTROY_VIDEOPROCESSOR = 1064,
	// D3D12_MESSAGE_ID_DESTROY_VIDEOPROCESSSTREAM = 1065, D3D12_MESSAGE_ID_PROCESS_FRAME_INVALID_PARAMETERS = 1066,
	// D3D12_MESSAGE_ID_COPY_INVALIDLAYOUT = 1067, D3D12_MESSAGE_ID_CREATE_CRYPTO_SESSION = 1068,
	// D3D12_MESSAGE_ID_CREATE_CRYPTO_SESSION_POLICY = 1069, D3D12_MESSAGE_ID_CREATE_PROTECTED_RESOURCE_SESSION = 1070,
	// D3D12_MESSAGE_ID_LIVE_CRYPTO_SESSION = 1071, D3D12_MESSAGE_ID_LIVE_CRYPTO_SESSION_POLICY = 1072,
	// D3D12_MESSAGE_ID_LIVE_PROTECTED_RESOURCE_SESSION = 1073, D3D12_MESSAGE_ID_DESTROY_CRYPTO_SESSION = 1074,
	// D3D12_MESSAGE_ID_DESTROY_CRYPTO_SESSION_POLICY = 1075, D3D12_MESSAGE_ID_DESTROY_PROTECTED_RESOURCE_SESSION = 1076,
	// D3D12_MESSAGE_ID_PROTECTED_RESOURCE_SESSION_UNSUPPORTED = 1077, D3D12_MESSAGE_ID_FENCE_INVALIDOPERATION = 1078,
	// D3D12_MESSAGE_ID_CREATEQUERY_HEAP_COPY_QUEUE_TIMESTAMPS_NOT_SUPPORTED = 1079, D3D12_MESSAGE_ID_SAMPLEPOSITIONS_MISMATCH_DEFERRED =
	// 1080, D3D12_MESSAGE_ID_SAMPLEPOSITIONS_MISMATCH_RECORDTIME_ASSUMEDFROMFIRSTUSE = 1081,
	// D3D12_MESSAGE_ID_SAMPLEPOSITIONS_MISMATCH_RECORDTIME_ASSUMEDFROMCLEAR = 1082, D3D12_MESSAGE_ID_CREATE_VIDEODECODERHEAP = 1083,
	// D3D12_MESSAGE_ID_LIVE_VIDEODECODERHEAP = 1084, D3D12_MESSAGE_ID_DESTROY_VIDEODECODERHEAP = 1085,
	// D3D12_MESSAGE_ID_OPENEXISTINGHEAP_INVALIDARG_RETURN = 1086, D3D12_MESSAGE_ID_OPENEXISTINGHEAP_OUTOFMEMORY_RETURN = 1087,
	// D3D12_MESSAGE_ID_OPENEXISTINGHEAP_INVALIDADDRESS = 1088, D3D12_MESSAGE_ID_OPENEXISTINGHEAP_INVALIDHANDLE = 1089,
	// D3D12_MESSAGE_ID_WRITEBUFFERIMMEDIATE_INVALID_DEST = 1090, D3D12_MESSAGE_ID_WRITEBUFFERIMMEDIATE_INVALID_MODE = 1091,
	// D3D12_MESSAGE_ID_WRITEBUFFERIMMEDIATE_INVALID_ALIGNMENT = 1092, D3D12_MESSAGE_ID_WRITEBUFFERIMMEDIATE_NOT_SUPPORTED = 1093,
	// D3D12_MESSAGE_ID_SETVIEWINSTANCEMASK_INVALIDARGS = 1094, D3D12_MESSAGE_ID_VIEW_INSTANCING_UNSUPPORTED = 1095,
	// D3D12_MESSAGE_ID_VIEW_INSTANCING_INVALIDARGS = 1096, D3D12_MESSAGE_ID_COPYTEXTUREREGION_MISMATCH_DECODE_REFERENCE_ONLY_FLAG = 1097,
	// D3D12_MESSAGE_ID_COPYRESOURCE_MISMATCH_DECODE_REFERENCE_ONLY_FLAG = 1098, D3D12_MESSAGE_ID_CREATE_VIDEO_DECODE_HEAP_CAPS_FAILURE =
	// 1099, D3D12_MESSAGE_ID_CREATE_VIDEO_DECODE_HEAP_CAPS_UNSUPPORTED = 1100, D3D12_MESSAGE_ID_VIDEO_DECODE_SUPPORT_INVALID_INPUT = 1101,
	// D3D12_MESSAGE_ID_CREATE_VIDEO_DECODER_UNSUPPORTED = 1102, D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_METADATA_ERROR = 1103,
	// D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_VIEW_INSTANCING_VERTEX_SIZE_EXCEEDED = 1104,
	// D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_RUNTIME_INTERNAL_ERROR = 1105, D3D12_MESSAGE_ID_NO_VIDEO_API_SUPPORT = 1106,
	// D3D12_MESSAGE_ID_VIDEO_PROCESS_SUPPORT_INVALID_INPUT = 1107, D3D12_MESSAGE_ID_CREATE_VIDEO_PROCESSOR_CAPS_FAILURE = 1108,
	// D3D12_MESSAGE_ID_VIDEO_PROCESS_SUPPORT_UNSUPPORTED_FORMAT = 1109, D3D12_MESSAGE_ID_VIDEO_DECODE_FRAME_INVALID_ARGUMENT = 1110,
	// D3D12_MESSAGE_ID_ENQUEUE_MAKE_RESIDENT_INVALID_FLAGS = 1111, D3D12_MESSAGE_ID_OPENEXISTINGHEAP_UNSUPPORTED = 1112,
	// D3D12_MESSAGE_ID_VIDEO_PROCESS_FRAMES_INVALID_ARGUMENT = 1113, D3D12_MESSAGE_ID_VIDEO_DECODE_SUPPORT_UNSUPPORTED = 1114,
	// D3D12_MESSAGE_ID_CREATE_COMMANDRECORDER = 1115, D3D12_MESSAGE_ID_LIVE_COMMANDRECORDER = 1116,
	// D3D12_MESSAGE_ID_DESTROY_COMMANDRECORDER = 1117, D3D12_MESSAGE_ID_CREATE_COMMAND_RECORDER_VIDEO_NOT_SUPPORTED = 1118,
	// D3D12_MESSAGE_ID_CREATE_COMMAND_RECORDER_INVALID_SUPPORT_FLAGS = 1119, D3D12_MESSAGE_ID_CREATE_COMMAND_RECORDER_INVALID_FLAGS = 1120,
	// D3D12_MESSAGE_ID_CREATE_COMMAND_RECORDER_MORE_RECORDERS_THAN_LOGICAL_PROCESSORS = 1121, D3D12_MESSAGE_ID_CREATE_COMMANDPOOL = 1122,
	// D3D12_MESSAGE_ID_LIVE_COMMANDPOOL = 1123, D3D12_MESSAGE_ID_DESTROY_COMMANDPOOL = 1124,
	// D3D12_MESSAGE_ID_CREATE_COMMAND_POOL_INVALID_FLAGS = 1125, D3D12_MESSAGE_ID_CREATE_COMMAND_LIST_VIDEO_NOT_SUPPORTED = 1126,
	// D3D12_MESSAGE_ID_COMMAND_RECORDER_SUPPORT_FLAGS_MISMATCH = 1127, D3D12_MESSAGE_ID_COMMAND_RECORDER_CONTENTION = 1128,
	// D3D12_MESSAGE_ID_COMMAND_RECORDER_USAGE_WITH_CREATECOMMANDLIST_COMMAND_LIST = 1129,
	// D3D12_MESSAGE_ID_COMMAND_ALLOCATOR_USAGE_WITH_CREATECOMMANDLIST1_COMMAND_LIST = 1130,
	// D3D12_MESSAGE_ID_CANNOT_EXECUTE_EMPTY_COMMAND_LIST = 1131, D3D12_MESSAGE_ID_CANNOT_RESET_COMMAND_POOL_WITH_OPEN_COMMAND_LISTS = 1132,
	// D3D12_MESSAGE_ID_CANNOT_USE_COMMAND_RECORDER_WITHOUT_CURRENT_TARGET = 1133,
	// D3D12_MESSAGE_ID_CANNOT_CHANGE_COMMAND_RECORDER_TARGET_WHILE_RECORDING = 1134, D3D12_MESSAGE_ID_COMMAND_POOL_SYNC = 1135,
	// D3D12_MESSAGE_ID_EVICT_UNDERFLOW = 1136, D3D12_MESSAGE_ID_CREATE_META_COMMAND = 1137, D3D12_MESSAGE_ID_LIVE_META_COMMAND = 1138,
	// D3D12_MESSAGE_ID_DESTROY_META_COMMAND = 1139, D3D12_MESSAGE_ID_COPYBUFFERREGION_INVALID_DST_RESOURCE = 1140,
	// D3D12_MESSAGE_ID_COPYBUFFERREGION_INVALID_SRC_RESOURCE = 1141, D3D12_MESSAGE_ID_ATOMICCOPYBUFFER_INVALID_DST_RESOURCE = 1142,
	// D3D12_MESSAGE_ID_ATOMICCOPYBUFFER_INVALID_SRC_RESOURCE = 1143, D3D12_MESSAGE_ID_CREATEPLACEDRESOURCEONBUFFER_NULL_BUFFER = 1144,
	// D3D12_MESSAGE_ID_CREATEPLACEDRESOURCEONBUFFER_NULL_RESOURCE_DESC = 1145, D3D12_MESSAGE_ID_CREATEPLACEDRESOURCEONBUFFER_UNSUPPORTED =
	// 1146, D3D12_MESSAGE_ID_CREATEPLACEDRESOURCEONBUFFER_INVALID_BUFFER_DIMENSION = 1147,
	// D3D12_MESSAGE_ID_CREATEPLACEDRESOURCEONBUFFER_INVALID_BUFFER_FLAGS = 1148,
	// D3D12_MESSAGE_ID_CREATEPLACEDRESOURCEONBUFFER_INVALID_BUFFER_OFFSET = 1149,
	// D3D12_MESSAGE_ID_CREATEPLACEDRESOURCEONBUFFER_INVALID_RESOURCE_DIMENSION = 1150,
	// D3D12_MESSAGE_ID_CREATEPLACEDRESOURCEONBUFFER_INVALID_RESOURCE_FLAGS = 1151,
	// D3D12_MESSAGE_ID_CREATEPLACEDRESOURCEONBUFFER_OUTOFMEMORY_RETURN = 1152,
	// D3D12_MESSAGE_ID_CANNOT_CREATE_GRAPHICS_AND_VIDEO_COMMAND_RECORDER = 1153,
	// D3D12_MESSAGE_ID_UPDATETILEMAPPINGS_POSSIBLY_MISMATCHING_PROPERTIES = 1154,
	// D3D12_MESSAGE_ID_CREATE_COMMAND_LIST_INVALID_COMMAND_LIST_TYPE = 1155,
	// D3D12_MESSAGE_ID_CLEARUNORDEREDACCESSVIEW_INCOMPATIBLE_WITH_STRUCTURED_BUFFERS = 1156,
	// D3D12_MESSAGE_ID_COMPUTE_ONLY_DEVICE_OPERATION_UNSUPPORTED = 1157, D3D12_MESSAGE_ID_BUILD_RAYTRACING_ACCELERATION_STRUCTURE_INVALID =
	// 1158, D3D12_MESSAGE_ID_EMIT_RAYTRACING_ACCELERATION_STRUCTURE_POSTBUILD_INFO_INVALID = 1159,
	// D3D12_MESSAGE_ID_COPY_RAYTRACING_ACCELERATION_STRUCTURE_INVALID = 1160, D3D12_MESSAGE_ID_DISPATCH_RAYS_INVALID = 1161,
	// D3D12_MESSAGE_ID_GET_RAYTRACING_ACCELERATION_STRUCTURE_PREBUILD_INFO_INVALID = 1162, D3D12_MESSAGE_ID_CREATE_LIFETIMETRACKER = 1163,
	// D3D12_MESSAGE_ID_LIVE_LIFETIMETRACKER = 1164, D3D12_MESSAGE_ID_DESTROY_LIFETIMETRACKER = 1165,
	// D3D12_MESSAGE_ID_DESTROYOWNEDOBJECT_OBJECTNOTOWNED = 1166, D3D12_MESSAGE_ID_CREATE_TRACKEDWORKLOAD = 1167,
	// D3D12_MESSAGE_ID_LIVE_TRACKEDWORKLOAD = 1168, D3D12_MESSAGE_ID_DESTROY_TRACKEDWORKLOAD = 1169, D3D12_MESSAGE_ID_RENDER_PASS_ERROR =
	// 1170, D3D12_MESSAGE_ID_META_COMMAND_ID_INVALID = 1171, D3D12_MESSAGE_ID_META_COMMAND_UNSUPPORTED_PARAMS = 1172,
	// D3D12_MESSAGE_ID_META_COMMAND_FAILED_ENUMERATION = 1173, D3D12_MESSAGE_ID_META_COMMAND_PARAMETER_SIZE_MISMATCH = 1174,
	// D3D12_MESSAGE_ID_UNINITIALIZED_META_COMMAND = 1175, D3D12_MESSAGE_ID_META_COMMAND_INVALID_GPU_VIRTUAL_ADDRESS = 1176,
	// D3D12_MESSAGE_ID_CREATE_VIDEOENCODECOMMANDLIST = 1177, D3D12_MESSAGE_ID_LIVE_VIDEOENCODECOMMANDLIST = 1178,
	// D3D12_MESSAGE_ID_DESTROY_VIDEOENCODECOMMANDLIST = 1179, D3D12_MESSAGE_ID_CREATE_VIDEOENCODECOMMANDQUEUE = 1180,
	// D3D12_MESSAGE_ID_LIVE_VIDEOENCODECOMMANDQUEUE = 1181, D3D12_MESSAGE_ID_DESTROY_VIDEOENCODECOMMANDQUEUE = 1182,
	// D3D12_MESSAGE_ID_CREATE_VIDEOMOTIONESTIMATOR = 1183, D3D12_MESSAGE_ID_LIVE_VIDEOMOTIONESTIMATOR = 1184,
	// D3D12_MESSAGE_ID_DESTROY_VIDEOMOTIONESTIMATOR = 1185, D3D12_MESSAGE_ID_CREATE_VIDEOMOTIONVECTORHEAP = 1186,
	// D3D12_MESSAGE_ID_LIVE_VIDEOMOTIONVECTORHEAP = 1187, D3D12_MESSAGE_ID_DESTROY_VIDEOMOTIONVECTORHEAP = 1188,
	// D3D12_MESSAGE_ID_MULTIPLE_TRACKED_WORKLOADS = 1189, D3D12_MESSAGE_ID_MULTIPLE_TRACKED_WORKLOAD_PAIRS = 1190,
	// D3D12_MESSAGE_ID_OUT_OF_ORDER_TRACKED_WORKLOAD_PAIR = 1191, D3D12_MESSAGE_ID_CANNOT_ADD_TRACKED_WORKLOAD = 1192,
	// D3D12_MESSAGE_ID_INCOMPLETE_TRACKED_WORKLOAD_PAIR = 1193, D3D12_MESSAGE_ID_CREATE_STATE_OBJECT_ERROR = 1194,
	// D3D12_MESSAGE_ID_GET_SHADER_IDENTIFIER_ERROR = 1195, D3D12_MESSAGE_ID_GET_SHADER_STACK_SIZE_ERROR = 1196,
	// D3D12_MESSAGE_ID_GET_PIPELINE_STACK_SIZE_ERROR = 1197, D3D12_MESSAGE_ID_SET_PIPELINE_STACK_SIZE_ERROR = 1198,
	// D3D12_MESSAGE_ID_GET_SHADER_IDENTIFIER_SIZE_INVALID = 1199, D3D12_MESSAGE_ID_CHECK_DRIVER_MATCHING_IDENTIFIER_INVALID = 1200,
	// D3D12_MESSAGE_ID_CHECK_DRIVER_MATCHING_IDENTIFIER_DRIVER_REPORTED_ISSUE = 1201, D3D12_MESSAGE_ID_RENDER_PASS_INVALID_RESOURCE_BARRIER
	// = 1202, D3D12_MESSAGE_ID_RENDER_PASS_DISALLOWED_API_CALLED = 1203, D3D12_MESSAGE_ID_RENDER_PASS_CANNOT_NEST_RENDER_PASSES = 1204,
	// D3D12_MESSAGE_ID_RENDER_PASS_CANNOT_END_WITHOUT_BEGIN = 1205, D3D12_MESSAGE_ID_RENDER_PASS_CANNOT_CLOSE_COMMAND_LIST = 1206,
	// D3D12_MESSAGE_ID_RENDER_PASS_GPU_WORK_WHILE_SUSPENDED = 1207, D3D12_MESSAGE_ID_RENDER_PASS_MISMATCHING_SUSPEND_RESUME = 1208,
	// D3D12_MESSAGE_ID_RENDER_PASS_NO_PRIOR_SUSPEND_WITHIN_EXECUTECOMMANDLISTS = 1209,
	// D3D12_MESSAGE_ID_RENDER_PASS_NO_SUBSEQUENT_RESUME_WITHIN_EXECUTECOMMANDLISTS = 1210,
	// D3D12_MESSAGE_ID_TRACKED_WORKLOAD_COMMAND_QUEUE_MISMATCH = 1211, D3D12_MESSAGE_ID_TRACKED_WORKLOAD_NOT_SUPPORTED = 1212,
	// D3D12_MESSAGE_ID_RENDER_PASS_MISMATCHING_NO_ACCESS = 1213, D3D12_MESSAGE_ID_RENDER_PASS_UNSUPPORTED_RESOLVE = 1214,
	// D3D12_MESSAGE_ID_CLEARUNORDEREDACCESSVIEW_INVALID_RESOURCE_PTR = 1215, D3D12_MESSAGE_ID_WINDOWS7_FENCE_OUTOFORDER_SIGNAL = 1216,
	// D3D12_MESSAGE_ID_WINDOWS7_FENCE_OUTOFORDER_WAIT = 1217, D3D12_MESSAGE_ID_VIDEO_CREATE_MOTION_ESTIMATOR_INVALID_ARGUMENT = 1218,
	// D3D12_MESSAGE_ID_VIDEO_CREATE_MOTION_VECTOR_HEAP_INVALID_ARGUMENT = 1219, D3D12_MESSAGE_ID_ESTIMATE_MOTION_INVALID_ARGUMENT = 1220,
	// D3D12_MESSAGE_ID_RESOLVE_MOTION_VECTOR_HEAP_INVALID_ARGUMENT = 1221, D3D12_MESSAGE_ID_GETGPUVIRTUALADDRESS_INVALID_HEAP_TYPE = 1222,
	// D3D12_MESSAGE_ID_SET_BACKGROUND_PROCESSING_MODE_INVALID_ARGUMENT = 1223,
	// D3D12_MESSAGE_ID_CREATE_COMMAND_LIST_INVALID_COMMAND_LIST_TYPE_FOR_FEATURE_LEVEL = 1224,
	// D3D12_MESSAGE_ID_CREATE_VIDEOEXTENSIONCOMMAND = 1225, D3D12_MESSAGE_ID_LIVE_VIDEOEXTENSIONCOMMAND = 1226,
	// D3D12_MESSAGE_ID_DESTROY_VIDEOEXTENSIONCOMMAND = 1227, D3D12_MESSAGE_ID_INVALID_VIDEO_EXTENSION_COMMAND_ID = 1228,
	// D3D12_MESSAGE_ID_VIDEO_EXTENSION_COMMAND_INVALID_ARGUMENT = 1229, D3D12_MESSAGE_ID_CREATE_ROOT_SIGNATURE_NOT_UNIQUE_IN_DXIL_LIBRARY =
	// 1230, D3D12_MESSAGE_ID_VARIABLE_SHADING_RATE_NOT_ALLOWED_WITH_TIR = 1231,
	// D3D12_MESSAGE_ID_GEOMETRY_SHADER_OUTPUTTING_BOTH_VIEWPORT_ARRAY_INDEX_AND_SHADING_RATE_NOT_SUPPORTED_ON_DEVICE = 1232,
	// D3D12_MESSAGE_ID_RSSETSHADING_RATE_INVALID_SHADING_RATE = 1233, D3D12_MESSAGE_ID_RSSETSHADING_RATE_SHADING_RATE_NOT_PERMITTED_BY_CAP
	// = 1234, D3D12_MESSAGE_ID_RSSETSHADING_RATE_INVALID_COMBINER = 1235, D3D12_MESSAGE_ID_RSSETSHADINGRATEIMAGE_REQUIRES_TIER_2 = 1236,
	// D3D12_MESSAGE_ID_RSSETSHADINGRATE_REQUIRES_TIER_1 = 1237, D3D12_MESSAGE_ID_SHADING_RATE_IMAGE_INCORRECT_FORMAT = 1238,
	// D3D12_MESSAGE_ID_SHADING_RATE_IMAGE_INCORRECT_ARRAY_SIZE = 1239, D3D12_MESSAGE_ID_SHADING_RATE_IMAGE_INCORRECT_MIP_LEVEL = 1240,
	// D3D12_MESSAGE_ID_SHADING_RATE_IMAGE_INCORRECT_SAMPLE_COUNT = 1241, D3D12_MESSAGE_ID_SHADING_RATE_IMAGE_INCORRECT_SAMPLE_QUALITY =
	// 1242, D3D12_MESSAGE_ID_NON_RETAIL_SHADER_MODEL_WONT_VALIDATE = 1243,
	// D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_AS_ROOT_SIGNATURE_MISMATCH = 1244,
	// D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_MS_ROOT_SIGNATURE_MISMATCH = 1245, D3D12_MESSAGE_ID_ADD_TO_STATE_OBJECT_ERROR = 1246,
	// D3D12_MESSAGE_ID_CREATE_PROTECTED_RESOURCE_SESSION_INVALID_ARGUMENT = 1247,
	// D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_MS_PSO_DESC_MISMATCH = 1248, D3D12_MESSAGE_ID_CREATEPIPELINESTATE_MS_INCOMPLETE_TYPE =
	// 1249, D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_AS_NOT_MS_MISMATCH = 1250,
	// D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_MS_NOT_PS_MISMATCH = 1251,
	// D3D12_MESSAGE_ID_NONZERO_SAMPLER_FEEDBACK_MIP_REGION_WITH_INCOMPATIBLE_FORMAT = 1252,
	// D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_INPUTLAYOUT_SHADER_MISMATCH = 1253, D3D12_MESSAGE_ID_EMPTY_DISPATCH = 1254,
	// D3D12_MESSAGE_ID_RESOURCE_FORMAT_REQUIRES_SAMPLER_FEEDBACK_CAPABILITY = 1255,
	// D3D12_MESSAGE_ID_SAMPLER_FEEDBACK_MAP_INVALID_MIP_REGION = 1256, D3D12_MESSAGE_ID_SAMPLER_FEEDBACK_MAP_INVALID_DIMENSION = 1257,
	// D3D12_MESSAGE_ID_SAMPLER_FEEDBACK_MAP_INVALID_SAMPLE_COUNT = 1258, D3D12_MESSAGE_ID_SAMPLER_FEEDBACK_MAP_INVALID_SAMPLE_QUALITY =
	// 1259, D3D12_MESSAGE_ID_SAMPLER_FEEDBACK_MAP_INVALID_LAYOUT = 1260,
	// D3D12_MESSAGE_ID_SAMPLER_FEEDBACK_MAP_REQUIRES_UNORDERED_ACCESS_FLAG = 1261,
	// D3D12_MESSAGE_ID_SAMPLER_FEEDBACK_CREATE_UAV_NULL_ARGUMENTS = 1262,
	// D3D12_MESSAGE_ID_SAMPLER_FEEDBACK_UAV_REQUIRES_SAMPLER_FEEDBACK_CAPABILITY = 1263,
	// D3D12_MESSAGE_ID_SAMPLER_FEEDBACK_CREATE_UAV_REQUIRES_FEEDBACK_MAP_FORMAT = 1264,
	// D3D12_MESSAGE_ID_CREATEMESHSHADER_INVALIDSHADERBYTECODE = 1265, D3D12_MESSAGE_ID_CREATEMESHSHADER_OUTOFMEMORY = 1266,
	// D3D12_MESSAGE_ID_CREATEMESHSHADERWITHSTREAMOUTPUT_INVALIDSHADERTYPE = 1267,
	// D3D12_MESSAGE_ID_RESOLVESUBRESOURCE_SAMPLER_FEEDBACK_TRANSCODE_INVALID_FORMAT = 1268,
	// D3D12_MESSAGE_ID_RESOLVESUBRESOURCE_SAMPLER_FEEDBACK_INVALID_MIP_LEVEL_COUNT = 1269,
	// D3D12_MESSAGE_ID_RESOLVESUBRESOURCE_SAMPLER_FEEDBACK_TRANSCODE_ARRAY_SIZE_MISMATCH = 1270,
	// D3D12_MESSAGE_ID_SAMPLER_FEEDBACK_CREATE_UAV_MISMATCHING_TARGETED_RESOURCE = 1271,
	// D3D12_MESSAGE_ID_CREATEMESHSHADER_OUTPUTEXCEEDSMAXSIZE = 1272, D3D12_MESSAGE_ID_CREATEMESHSHADER_GROUPSHAREDEXCEEDSMAXSIZE = 1273,
	// D3D12_MESSAGE_ID_VERTEX_SHADER_OUTPUTTING_BOTH_VIEWPORT_ARRAY_INDEX_AND_SHADING_RATE_NOT_SUPPORTED_ON_DEVICE = 1274,
	// D3D12_MESSAGE_ID_MESH_SHADER_OUTPUTTING_BOTH_VIEWPORT_ARRAY_INDEX_AND_SHADING_RATE_NOT_SUPPORTED_ON_DEVICE = 1275,
	// D3D12_MESSAGE_ID_CREATEMESHSHADER_MISMATCHEDASMSPAYLOADSIZE = 1276,
	// D3D12_MESSAGE_ID_CREATE_ROOT_SIGNATURE_UNBOUNDED_STATIC_DESCRIPTORS = 1277,
	// D3D12_MESSAGE_ID_CREATEAMPLIFICATIONSHADER_INVALIDSHADERBYTECODE = 1278, D3D12_MESSAGE_ID_CREATEAMPLIFICATIONSHADER_OUTOFMEMORY =
	// 1279, D3D12_MESSAGE_ID_CREATE_SHADERCACHESESSION = 1280, D3D12_MESSAGE_ID_LIVE_SHADERCACHESESSION = 1281,
	// D3D12_MESSAGE_ID_DESTROY_SHADERCACHESESSION = 1282, D3D12_MESSAGE_ID_CREATESHADERCACHESESSION_INVALIDARGS = 1283,
	// D3D12_MESSAGE_ID_CREATESHADERCACHESESSION_DISABLED = 1284, D3D12_MESSAGE_ID_CREATESHADERCACHESESSION_ALREADYOPEN = 1285,
	// D3D12_MESSAGE_ID_SHADERCACHECONTROL_DEVELOPERMODE = 1286, D3D12_MESSAGE_ID_SHADERCACHECONTROL_INVALIDFLAGS = 1287,
	// D3D12_MESSAGE_ID_SHADERCACHECONTROL_STATEALREADYSET = 1288, D3D12_MESSAGE_ID_SHADERCACHECONTROL_IGNOREDFLAG = 1289,
	// D3D12_MESSAGE_ID_SHADERCACHESESSION_STOREVALUE_ALREADYPRESENT = 1290, D3D12_MESSAGE_ID_SHADERCACHESESSION_STOREVALUE_HASHCOLLISION =
	// 1291, D3D12_MESSAGE_ID_SHADERCACHESESSION_STOREVALUE_CACHEFULL = 1292, D3D12_MESSAGE_ID_SHADERCACHESESSION_FINDVALUE_NOTFOUND = 1293,
	// D3D12_MESSAGE_ID_SHADERCACHESESSION_CORRUPT = 1294, D3D12_MESSAGE_ID_SHADERCACHESESSION_DISABLED = 1295,
	// D3D12_MESSAGE_ID_OVERSIZED_DISPATCH = 1296, D3D12_MESSAGE_ID_CREATE_VIDEOENCODER = 1297, D3D12_MESSAGE_ID_LIVE_VIDEOENCODER = 1298,
	// D3D12_MESSAGE_ID_DESTROY_VIDEOENCODER = 1299, D3D12_MESSAGE_ID_CREATE_VIDEOENCODERHEAP = 1300, D3D12_MESSAGE_ID_LIVE_VIDEOENCODERHEAP
	// = 1301, D3D12_MESSAGE_ID_DESTROY_VIDEOENCODERHEAP = 1302, D3D12_MESSAGE_ID_COPYTEXTUREREGION_MISMATCH_ENCODE_REFERENCE_ONLY_FLAG =
	// 1303, D3D12_MESSAGE_ID_COPYRESOURCE_MISMATCH_ENCODE_REFERENCE_ONLY_FLAG = 1304, D3D12_MESSAGE_ID_ENCODE_FRAME_INVALID_PARAMETERS =
	// 1305, D3D12_MESSAGE_ID_ENCODE_FRAME_UNSUPPORTED_PARAMETERS = 1306,
	// D3D12_MESSAGE_ID_RESOLVE_ENCODER_OUTPUT_METADATA_INVALID_PARAMETERS = 1307,
	// D3D12_MESSAGE_ID_RESOLVE_ENCODER_OUTPUT_METADATA_UNSUPPORTED_PARAMETERS = 1308,
	// D3D12_MESSAGE_ID_CREATE_VIDEO_ENCODER_INVALID_PARAMETERS = 1309, D3D12_MESSAGE_ID_CREATE_VIDEO_ENCODER_UNSUPPORTED_PARAMETERS = 1310,
	// D3D12_MESSAGE_ID_CREATE_VIDEO_ENCODER_HEAP_INVALID_PARAMETERS = 1311,
	// D3D12_MESSAGE_ID_CREATE_VIDEO_ENCODER_HEAP_UNSUPPORTED_PARAMETERS = 1312, D3D12_MESSAGE_ID_CREATECOMMANDLIST_NULL_COMMANDALLOCATOR,
	// D3D12_MESSAGE_ID_CLEAR_UNORDERED_ACCESS_VIEW_INVALID_DESCRIPTOR_HANDLE, D3D12_MESSAGE_ID_DESCRIPTOR_HEAP_NOT_SHADER_VISIBLE,
	// D3D12_MESSAGE_ID_CREATEBLENDSTATE_BLENDOP_WARNING, D3D12_MESSAGE_ID_CREATEBLENDSTATE_BLENDOPALPHA_WARNING,
	// D3D12_MESSAGE_ID_WRITE_COMBINE_PERFORMANCE_WARNING, D3D12_MESSAGE_ID_RESOLVE_QUERY_INVALID_QUERY_STATE,
	// D3D12_MESSAGE_ID_SETPRIVATEDATA_NO_ACCESS, D3D12_MESSAGE_ID_COMMAND_LIST_STATIC_DESCRIPTOR_SAMPLER_MODE_MISMATCH,
	// D3D12_MESSAGE_ID_GETCOPYABLEFOOTPRINTS_UNSUPPORTED_BUFFER_WIDTH, D3D12_MESSAGE_ID_CREATEMESHSHADER_TOPOLOGY_MISMATCH,
	// D3D12_MESSAGE_ID_VRS_SUM_COMBINER_REQUIRES_CAPABILITY, D3D12_MESSAGE_ID_SETTING_SHADING_RATE_FROM_MS_REQUIRES_CAPABILITY,
	// D3D12_MESSAGE_ID_SHADERCACHESESSION_SHADERCACHEDELETE_NOTSUPPORTED,
	// D3D12_MESSAGE_ID_SHADERCACHECONTROL_SHADERCACHECLEAR_NOTSUPPORTED, D3D12_MESSAGE_ID_CREATERESOURCE_STATE_IGNORED,
	// D3D12_MESSAGE_ID_UNUSED_CROSS_EXECUTE_SPLIT_BARRIER, D3D12_MESSAGE_ID_DEVICE_OPEN_SHARED_HANDLE_ACCESS_DENIED,
	// D3D12_MESSAGE_ID_INCOMPATIBLE_BARRIER_VALUES, D3D12_MESSAGE_ID_INCOMPATIBLE_BARRIER_ACCESS,
	// D3D12_MESSAGE_ID_INCOMPATIBLE_BARRIER_SYNC, D3D12_MESSAGE_ID_INCOMPATIBLE_BARRIER_LAYOUT, D3D12_MESSAGE_ID_INCOMPATIBLE_BARRIER_TYPE,
	// D3D12_MESSAGE_ID_OUT_OF_BOUNDS_BARRIER_SUBRESOURCE_RANGE, D3D12_MESSAGE_ID_INCOMPATIBLE_BARRIER_RESOURCE_DIMENSION,
	// D3D12_MESSAGE_ID_SET_SCISSOR_RECTS_INVALID_RECT, D3D12_MESSAGE_ID_SHADING_RATE_SOURCE_REQUIRES_DIMENSION_TEXTURE2D,
	// D3D12_MESSAGE_ID_BUFFER_BARRIER_SUBREGION_OUT_OF_BOUNDS, D3D12_MESSAGE_ID_UNSUPPORTED_BARRIER_LAYOUT,
	// D3D12_MESSAGE_ID_CREATERESOURCEANDHEAP_INVALID_PARAMETERS, D3D12_MESSAGE_ID_ENHANCED_BARRIERS_NOT_SUPPORTED,
	// D3D12_MESSAGE_ID_LEGACY_BARRIER_VALIDATION_FORCED_ON, D3D12_MESSAGE_ID_EMPTY_ROOT_DESCRIPTOR_TABLE,
	// D3D12_MESSAGE_ID_COMMAND_LIST_DRAW_ELEMENT_OFFSET_UNALIGNED, D3D12_MESSAGE_ID_ALPHA_BLEND_FACTOR_NOT_SUPPORTED,
	// D3D12_MESSAGE_ID_BARRIER_INTEROP_INVALID_LAYOUT, D3D12_MESSAGE_ID_BARRIER_INTEROP_INVALID_STATE,
	// D3D12_MESSAGE_ID_GRAPHICS_PIPELINE_STATE_DESC_ZERO_SAMPLE_MASK, D3D12_MESSAGE_ID_INDEPENDENT_STENCIL_REF_NOT_SUPPORTED,
	// D3D12_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_INDEPENDENT_MASKS_UNSUPPORTED, D3D12_MESSAGE_ID_TEXTURE_BARRIER_SUBRESOURCES_OUT_OF_BOUNDS,
	// D3D12_MESSAGE_ID_NON_OPTIMAL_BARRIER_ONLY_EXECUTE_COMMAND_LISTS, D3D12_MESSAGE_ID_EXECUTE_INDIRECT_ZERO_COMMAND_COUNT,
	// D3D12_MESSAGE_ID_GPU_BASED_VALIDATION_INCOMPATIBLE_TEXTURE_LAYOUT, D3D12_MESSAGE_ID_DYNAMIC_INDEX_BUFFER_STRIP_CUT_NOT_SUPPORTED,
	// D3D12_MESSAGE_ID_PRIMITIVE_TOPOLOGY_TRIANGLE_FANS_NOT_SUPPORTED, D3D12_MESSAGE_ID_CREATE_SAMPLER_COMPARISON_FUNC_IGNORED,
	// D3D12_MESSAGE_ID_CREATEHEAP_INVALIDHEAPTYPE, D3D12_MESSAGE_ID_CREATERESOURCEANDHEAP_INVALIDHEAPTYPE,
	// D3D12_MESSAGE_ID_DYNAMIC_DEPTH_BIAS_NOT_SUPPORTED, D3D12_MESSAGE_ID_CREATERASTERIZERSTATE_NON_WHOLE_DYNAMIC_DEPTH_BIAS,
	// D3D12_MESSAGE_ID_DYNAMIC_DEPTH_BIAS_FLAG_MISSING, D3D12_MESSAGE_ID_DYNAMIC_DEPTH_BIAS_NO_PIPELINE,
	// D3D12_MESSAGE_ID_DYNAMIC_INDEX_BUFFER_STRIP_CUT_FLAG_MISSING, D3D12_MESSAGE_ID_DYNAMIC_INDEX_BUFFER_STRIP_CUT_NO_PIPELINE,
	// D3D12_MESSAGE_ID_NONNORMALIZED_COORDINATE_SAMPLING_NOT_SUPPORTED, D3D12_MESSAGE_ID_INVALID_CAST_TARGET,
	// D3D12_MESSAGE_ID_RENDER_PASS_COMMANDLIST_INVALID_END_STATE, D3D12_MESSAGE_ID_RENDER_PASS_COMMANDLIST_INVALID_START_STATE,
	// D3D12_MESSAGE_ID_RENDER_PASS_MISMATCHING_ACCESS, D3D12_MESSAGE_ID_RENDER_PASS_MISMATCHING_LOCAL_PRESERVE_PARAMETERS,
	// D3D12_MESSAGE_ID_RENDER_PASS_LOCAL_PRESERVE_RENDER_PARAMETERS_ERROR, D3D12_MESSAGE_ID_RENDER_PASS_LOCAL_DEPTH_STENCIL_ERROR,
	// D3D12_MESSAGE_ID_DRAW_POTENTIALLY_OUTSIDE_OF_VALID_RENDER_AREA, D3D12_MESSAGE_ID_CREATERASTERIZERSTATE_INVALID_LINERASTERIZATIONMODE,
	// D3D12_MESSAGE_ID_CREATERESOURCE_INVALIDALIGNMENT_SMALLRESOURCE, D3D12_MESSAGE_ID_GENERIC_DEVICE_OPERATION_UNSUPPORTED,
	// D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_RENDER_TARGET_WRONG_WRITE_MASK, D3D12_MESSAGE_ID_PROBABLE_PIX_EVENT_LEAK,
	// D3D12_MESSAGE_ID_PIX_EVENT_UNDERFLOW, D3D12_MESSAGE_ID_RECREATEAT_INVALID_TARGET, D3D12_MESSAGE_ID_RECREATEAT_INSUFFICIENT_SUPPORT,
	// D3D12_MESSAGE_ID_GPU_BASED_VALIDATION_STRUCTURED_BUFFER_STRIDE_MISMATCH, D3D12_MESSAGE_ID_D3D12_MESSAGES_END } ;
	[PInvokeData("d3d12sdklayers.h", MSDNShortId = "NE:d3d12sdklayers.D3D12_MESSAGE_ID")]
	public enum D3D12_MESSAGE_ID
	{
		/// <summary/>
		D3D12_MESSAGE_ID_UNKNOWN = 0,

		/// <summary/>
		D3D12_MESSAGE_ID_STRING_FROM_APPLICATION = 1,

		/// <summary/>
		D3D12_MESSAGE_ID_CORRUPTED_THIS = 2,

		/// <summary/>
		D3D12_MESSAGE_ID_CORRUPTED_PARAMETER1 = 3,

		/// <summary/>
		D3D12_MESSAGE_ID_CORRUPTED_PARAMETER2 = 4,

		/// <summary/>
		D3D12_MESSAGE_ID_CORRUPTED_PARAMETER3 = 5,

		/// <summary/>
		D3D12_MESSAGE_ID_CORRUPTED_PARAMETER4 = 6,

		/// <summary/>
		D3D12_MESSAGE_ID_CORRUPTED_PARAMETER5 = 7,

		/// <summary/>
		D3D12_MESSAGE_ID_CORRUPTED_PARAMETER6 = 8,

		/// <summary/>
		D3D12_MESSAGE_ID_CORRUPTED_PARAMETER7 = 9,

		/// <summary/>
		D3D12_MESSAGE_ID_CORRUPTED_PARAMETER8 = 10,

		/// <summary/>
		D3D12_MESSAGE_ID_CORRUPTED_PARAMETER9 = 11,

		/// <summary/>
		D3D12_MESSAGE_ID_CORRUPTED_PARAMETER10 = 12,

		/// <summary/>
		D3D12_MESSAGE_ID_CORRUPTED_PARAMETER11 = 13,

		/// <summary/>
		D3D12_MESSAGE_ID_CORRUPTED_PARAMETER12 = 14,

		/// <summary/>
		D3D12_MESSAGE_ID_CORRUPTED_PARAMETER13 = 15,

		/// <summary/>
		D3D12_MESSAGE_ID_CORRUPTED_PARAMETER14 = 16,

		/// <summary/>
		D3D12_MESSAGE_ID_CORRUPTED_PARAMETER15 = 17,

		/// <summary/>
		D3D12_MESSAGE_ID_CORRUPTED_MULTITHREADING = 18,

		/// <summary/>
		D3D12_MESSAGE_ID_MESSAGE_REPORTING_OUTOFMEMORY = 19,

		/// <summary/>
		D3D12_MESSAGE_ID_GETPRIVATEDATA_MOREDATA = 20,

		/// <summary/>
		D3D12_MESSAGE_ID_SETPRIVATEDATA_INVALIDFREEDATA = 21,

		/// <summary/>
		D3D12_MESSAGE_ID_SETPRIVATEDATA_CHANGINGPARAMS = 24,

		/// <summary/>
		D3D12_MESSAGE_ID_SETPRIVATEDATA_OUTOFMEMORY = 25,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATESHADERRESOURCEVIEW_UNRECOGNIZEDFORMAT = 26,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATESHADERRESOURCEVIEW_INVALIDDESC = 27,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATESHADERRESOURCEVIEW_INVALIDFORMAT = 28,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATESHADERRESOURCEVIEW_INVALIDVIDEOPLANESLICE = 29,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATESHADERRESOURCEVIEW_INVALIDPLANESLICE = 30,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATESHADERRESOURCEVIEW_INVALIDDIMENSIONS = 31,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATESHADERRESOURCEVIEW_INVALIDRESOURCE = 32,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATERENDERTARGETVIEW_UNRECOGNIZEDFORMAT = 35,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATERENDERTARGETVIEW_UNSUPPORTEDFORMAT = 36,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATERENDERTARGETVIEW_INVALIDDESC = 37,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATERENDERTARGETVIEW_INVALIDFORMAT = 38,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATERENDERTARGETVIEW_INVALIDVIDEOPLANESLICE = 39,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATERENDERTARGETVIEW_INVALIDPLANESLICE = 40,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATERENDERTARGETVIEW_INVALIDDIMENSIONS = 41,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATERENDERTARGETVIEW_INVALIDRESOURCE = 42,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEDEPTHSTENCILVIEW_UNRECOGNIZEDFORMAT = 45,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEDEPTHSTENCILVIEW_INVALIDDESC = 46,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEDEPTHSTENCILVIEW_INVALIDFORMAT = 47,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEDEPTHSTENCILVIEW_INVALIDDIMENSIONS = 48,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEDEPTHSTENCILVIEW_INVALIDRESOURCE = 49,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEINPUTLAYOUT_OUTOFMEMORY = 52,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEINPUTLAYOUT_TOOMANYELEMENTS = 53,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEINPUTLAYOUT_INVALIDFORMAT = 54,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEINPUTLAYOUT_INCOMPATIBLEFORMAT = 55,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEINPUTLAYOUT_INVALIDSLOT = 56,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEINPUTLAYOUT_INVALIDINPUTSLOTCLASS = 57,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEINPUTLAYOUT_STEPRATESLOTCLASSMISMATCH = 58,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEINPUTLAYOUT_INVALIDSLOTCLASSCHANGE = 59,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEINPUTLAYOUT_INVALIDSTEPRATECHANGE = 60,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEINPUTLAYOUT_INVALIDALIGNMENT = 61,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEINPUTLAYOUT_DUPLICATESEMANTIC = 62,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEINPUTLAYOUT_UNPARSEABLEINPUTSIGNATURE = 63,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEINPUTLAYOUT_NULLSEMANTIC = 64,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEINPUTLAYOUT_MISSINGELEMENT = 65,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEVERTEXSHADER_OUTOFMEMORY = 66,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEVERTEXSHADER_INVALIDSHADERBYTECODE = 67,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEVERTEXSHADER_INVALIDSHADERTYPE = 68,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEGEOMETRYSHADER_OUTOFMEMORY = 69,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEGEOMETRYSHADER_INVALIDSHADERBYTECODE = 70,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEGEOMETRYSHADER_INVALIDSHADERTYPE = 71,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_OUTOFMEMORY = 72,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDSHADERBYTECODE = 73,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDSHADERTYPE = 74,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDNUMENTRIES = 75,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_OUTPUTSTREAMSTRIDEUNUSED = 76,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_OUTPUTSLOT0EXPECTED = 79,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDOUTPUTSLOT = 80,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_ONLYONEELEMENTPERSLOT = 81,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDCOMPONENTCOUNT = 82,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDSTARTCOMPONENTANDCOMPONENTCOUNT = 83,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDGAPDEFINITION = 84,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_REPEATEDOUTPUT = 85,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDOUTPUTSTREAMSTRIDE = 86,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_MISSINGSEMANTIC = 87,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_MASKMISMATCH = 88,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_CANTHAVEONLYGAPS = 89,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_DECLTOOCOMPLEX = 90,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_MISSINGOUTPUTSIGNATURE = 91,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEPIXELSHADER_OUTOFMEMORY = 92,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEPIXELSHADER_INVALIDSHADERBYTECODE = 93,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEPIXELSHADER_INVALIDSHADERTYPE = 94,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATERASTERIZERSTATE_INVALIDFILLMODE = 95,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATERASTERIZERSTATE_INVALIDCULLMODE = 96,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATERASTERIZERSTATE_INVALIDDEPTHBIASCLAMP = 97,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATERASTERIZERSTATE_INVALIDSLOPESCALEDDEPTHBIAS = 98,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_INVALIDDEPTHWRITEMASK = 100,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_INVALIDDEPTHFUNC = 101,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_INVALIDFRONTFACESTENCILFAILOP = 102,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_INVALIDFRONTFACESTENCILZFAILOP = 103,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_INVALIDFRONTFACESTENCILPASSOP = 104,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_INVALIDFRONTFACESTENCILFUNC = 105,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_INVALIDBACKFACESTENCILFAILOP = 106,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_INVALIDBACKFACESTENCILZFAILOP = 107,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_INVALIDBACKFACESTENCILPASSOP = 108,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_INVALIDBACKFACESTENCILFUNC = 109,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEBLENDSTATE_INVALIDSRCBLEND = 111,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEBLENDSTATE_INVALIDDESTBLEND = 112,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEBLENDSTATE_INVALIDBLENDOP = 113,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEBLENDSTATE_INVALIDSRCBLENDALPHA = 114,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEBLENDSTATE_INVALIDDESTBLENDALPHA = 115,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEBLENDSTATE_INVALIDBLENDOPALPHA = 116,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEBLENDSTATE_INVALIDRENDERTARGETWRITEMASK = 117,

		/// <summary/>
		D3D12_MESSAGE_ID_GET_PROGRAM_IDENTIFIER_ERROR = 118,

		/// <summary/>
		D3D12_MESSAGE_ID_GET_WORK_GRAPH_PROPERTIES_ERROR = 119,

		/// <summary/>
		D3D12_MESSAGE_ID_SET_PROGRAM_ERROR = 120,

		/// <summary/>
		D3D12_MESSAGE_ID_CLEARDEPTHSTENCILVIEW_INVALID = 135,

		/// <summary/>
		D3D12_MESSAGE_ID_COMMAND_LIST_DRAW_ROOT_SIGNATURE_NOT_SET = 200,

		/// <summary/>
		D3D12_MESSAGE_ID_COMMAND_LIST_DRAW_ROOT_SIGNATURE_MISMATCH = 201,

		/// <summary/>
		D3D12_MESSAGE_ID_COMMAND_LIST_DRAW_VERTEX_BUFFER_NOT_SET = 202,

		/// <summary/>
		D3D12_MESSAGE_ID_COMMAND_LIST_DRAW_VERTEX_BUFFER_STRIDE_TOO_SMALL = 209,

		/// <summary/>
		D3D12_MESSAGE_ID_COMMAND_LIST_DRAW_VERTEX_BUFFER_TOO_SMALL = 210,

		/// <summary/>
		D3D12_MESSAGE_ID_COMMAND_LIST_DRAW_INDEX_BUFFER_NOT_SET = 211,

		/// <summary/>
		D3D12_MESSAGE_ID_COMMAND_LIST_DRAW_INDEX_BUFFER_FORMAT_INVALID = 212,

		/// <summary/>
		D3D12_MESSAGE_ID_COMMAND_LIST_DRAW_INDEX_BUFFER_TOO_SMALL = 213,

		/// <summary/>
		D3D12_MESSAGE_ID_COMMAND_LIST_DRAW_INVALID_PRIMITIVETOPOLOGY = 219,

		/// <summary/>
		D3D12_MESSAGE_ID_COMMAND_LIST_DRAW_VERTEX_STRIDE_UNALIGNED = 221,

		/// <summary/>
		D3D12_MESSAGE_ID_COMMAND_LIST_DRAW_INDEX_OFFSET_UNALIGNED = 222,

		/// <summary/>
		D3D12_MESSAGE_ID_DEVICE_REMOVAL_PROCESS_AT_FAULT = 232,

		/// <summary/>
		D3D12_MESSAGE_ID_DEVICE_REMOVAL_PROCESS_POSSIBLY_AT_FAULT = 233,

		/// <summary/>
		D3D12_MESSAGE_ID_DEVICE_REMOVAL_PROCESS_NOT_AT_FAULT = 234,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEINPUTLAYOUT_TRAILING_DIGIT_IN_SEMANTIC = 239,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_TRAILING_DIGIT_IN_SEMANTIC = 240,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEINPUTLAYOUT_TYPE_MISMATCH = 245,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEINPUTLAYOUT_EMPTY_LAYOUT = 253,

		/// <summary/>
		D3D12_MESSAGE_ID_LIVE_OBJECT_SUMMARY = 255,

		/// <summary/>
		D3D12_MESSAGE_ID_LIVE_DEVICE = 274,

		/// <summary/>
		D3D12_MESSAGE_ID_LIVE_SWAPCHAIN = 275,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEDEPTHSTENCILVIEW_INVALIDFLAGS = 276,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEVERTEXSHADER_INVALIDCLASSLINKAGE = 277,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEGEOMETRYSHADER_INVALIDCLASSLINKAGE = 278,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDSTREAMTORASTERIZER = 280,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEPIXELSHADER_INVALIDCLASSLINKAGE = 283,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDSTREAM = 284,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_UNEXPECTEDENTRIES = 285,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_UNEXPECTEDSTRIDES = 286,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDNUMSTRIDES = 287,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEHULLSHADER_OUTOFMEMORY = 289,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEHULLSHADER_INVALIDSHADERBYTECODE = 290,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEHULLSHADER_INVALIDSHADERTYPE = 291,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEHULLSHADER_INVALIDCLASSLINKAGE = 292,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEDOMAINSHADER_OUTOFMEMORY = 294,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEDOMAINSHADER_INVALIDSHADERBYTECODE = 295,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEDOMAINSHADER_INVALIDSHADERTYPE = 296,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEDOMAINSHADER_INVALIDCLASSLINKAGE = 297,

		/// <summary/>
		D3D12_MESSAGE_ID_RESOURCE_UNMAP_NOTMAPPED = 310,

		/// <summary/>
		D3D12_MESSAGE_ID_DEVICE_CHECKFEATURESUPPORT_MISMATCHED_DATA_SIZE = 318,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATECOMPUTESHADER_OUTOFMEMORY = 321,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATECOMPUTESHADER_INVALIDSHADERBYTECODE = 322,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATECOMPUTESHADER_INVALIDCLASSLINKAGE = 323,

		/// <summary/>
		D3D12_MESSAGE_ID_DEVICE_CREATEVERTEXSHADER_DOUBLEFLOATOPSNOTSUPPORTED = 331,

		/// <summary/>
		D3D12_MESSAGE_ID_DEVICE_CREATEHULLSHADER_DOUBLEFLOATOPSNOTSUPPORTED = 332,

		/// <summary/>
		D3D12_MESSAGE_ID_DEVICE_CREATEDOMAINSHADER_DOUBLEFLOATOPSNOTSUPPORTED = 333,

		/// <summary/>
		D3D12_MESSAGE_ID_DEVICE_CREATEGEOMETRYSHADER_DOUBLEFLOATOPSNOTSUPPORTED = 334,

		/// <summary/>
		D3D12_MESSAGE_ID_DEVICE_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_DOUBLEFLOATOPSNOTSUPPORTED = 335,

		/// <summary/>
		D3D12_MESSAGE_ID_DEVICE_CREATEPIXELSHADER_DOUBLEFLOATOPSNOTSUPPORTED = 336,

		/// <summary/>
		D3D12_MESSAGE_ID_DEVICE_CREATECOMPUTESHADER_DOUBLEFLOATOPSNOTSUPPORTED = 337,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEUNORDEREDACCESSVIEW_INVALIDRESOURCE = 340,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEUNORDEREDACCESSVIEW_INVALIDDESC = 341,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEUNORDEREDACCESSVIEW_INVALIDFORMAT = 342,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEUNORDEREDACCESSVIEW_INVALIDVIDEOPLANESLICE = 343,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEUNORDEREDACCESSVIEW_INVALIDPLANESLICE = 344,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEUNORDEREDACCESSVIEW_INVALIDDIMENSIONS = 345,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEUNORDEREDACCESSVIEW_UNRECOGNIZEDFORMAT = 346,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEUNORDEREDACCESSVIEW_INVALIDFLAGS = 354,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATERASTERIZERSTATE_INVALIDFORCEDSAMPLECOUNT = 401,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEBLENDSTATE_INVALIDLOGICOPS = 403,

		/// <summary/>
		D3D12_MESSAGE_ID_DEVICE_CREATEVERTEXSHADER_DOUBLEEXTENSIONSNOTSUPPORTED = 410,

		/// <summary/>
		D3D12_MESSAGE_ID_DEVICE_CREATEHULLSHADER_DOUBLEEXTENSIONSNOTSUPPORTED = 412,

		/// <summary/>
		D3D12_MESSAGE_ID_DEVICE_CREATEDOMAINSHADER_DOUBLEEXTENSIONSNOTSUPPORTED = 414,

		/// <summary/>
		D3D12_MESSAGE_ID_DEVICE_CREATEGEOMETRYSHADER_DOUBLEEXTENSIONSNOTSUPPORTED = 416,

		/// <summary/>
		D3D12_MESSAGE_ID_DEVICE_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_DOUBLEEXTENSIONSNOTSUPPORTED = 418,

		/// <summary/>
		D3D12_MESSAGE_ID_DEVICE_CREATEPIXELSHADER_DOUBLEEXTENSIONSNOTSUPPORTED = 420,

		/// <summary/>
		D3D12_MESSAGE_ID_DEVICE_CREATECOMPUTESHADER_DOUBLEEXTENSIONSNOTSUPPORTED = 422,

		/// <summary/>
		D3D12_MESSAGE_ID_DEVICE_CREATEVERTEXSHADER_UAVSNOTSUPPORTED = 425,

		/// <summary/>
		D3D12_MESSAGE_ID_DEVICE_CREATEHULLSHADER_UAVSNOTSUPPORTED = 426,

		/// <summary/>
		D3D12_MESSAGE_ID_DEVICE_CREATEDOMAINSHADER_UAVSNOTSUPPORTED = 427,

		/// <summary/>
		D3D12_MESSAGE_ID_DEVICE_CREATEGEOMETRYSHADER_UAVSNOTSUPPORTED = 428,

		/// <summary/>
		D3D12_MESSAGE_ID_DEVICE_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_UAVSNOTSUPPORTED = 429,

		/// <summary/>
		D3D12_MESSAGE_ID_DEVICE_CREATEPIXELSHADER_UAVSNOTSUPPORTED = 430,

		/// <summary/>
		D3D12_MESSAGE_ID_DEVICE_CREATECOMPUTESHADER_UAVSNOTSUPPORTED = 431,

		/// <summary/>
		D3D12_MESSAGE_ID_DEVICE_CLEARVIEW_INVALIDSOURCERECT = 447,

		/// <summary/>
		D3D12_MESSAGE_ID_DEVICE_CLEARVIEW_EMPTYRECT = 448,

		/// <summary/>
		D3D12_MESSAGE_ID_UPDATETILEMAPPINGS_INVALID_PARAMETER = 493,

		/// <summary/>
		D3D12_MESSAGE_ID_COPYTILEMAPPINGS_INVALID_PARAMETER = 494,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEDEVICE_INVALIDARGS = 506,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEDEVICE_WARNING = 507,

		/// <summary/>
		D3D12_MESSAGE_ID_RESOURCE_BARRIER_INVALID_TYPE = 519,

		/// <summary/>
		D3D12_MESSAGE_ID_RESOURCE_BARRIER_NULL_POINTER = 520,

		/// <summary/>
		D3D12_MESSAGE_ID_RESOURCE_BARRIER_INVALID_SUBRESOURCE = 521,

		/// <summary/>
		D3D12_MESSAGE_ID_RESOURCE_BARRIER_RESERVED_BITS = 522,

		/// <summary/>
		D3D12_MESSAGE_ID_RESOURCE_BARRIER_MISSING_BIND_FLAGS = 523,

		/// <summary/>
		D3D12_MESSAGE_ID_RESOURCE_BARRIER_MISMATCHING_MISC_FLAGS = 524,

		/// <summary/>
		D3D12_MESSAGE_ID_RESOURCE_BARRIER_MATCHING_STATES = 525,

		/// <summary/>
		D3D12_MESSAGE_ID_RESOURCE_BARRIER_INVALID_COMBINATION = 526,

		/// <summary/>
		D3D12_MESSAGE_ID_RESOURCE_BARRIER_BEFORE_AFTER_MISMATCH = 527,

		/// <summary/>
		D3D12_MESSAGE_ID_RESOURCE_BARRIER_INVALID_RESOURCE = 528,

		/// <summary/>
		D3D12_MESSAGE_ID_RESOURCE_BARRIER_SAMPLE_COUNT = 529,

		/// <summary/>
		D3D12_MESSAGE_ID_RESOURCE_BARRIER_INVALID_FLAGS = 530,

		/// <summary/>
		D3D12_MESSAGE_ID_RESOURCE_BARRIER_INVALID_COMBINED_FLAGS = 531,

		/// <summary/>
		D3D12_MESSAGE_ID_RESOURCE_BARRIER_INVALID_FLAGS_FOR_FORMAT = 532,

		/// <summary/>
		D3D12_MESSAGE_ID_RESOURCE_BARRIER_INVALID_SPLIT_BARRIER = 533,

		/// <summary/>
		D3D12_MESSAGE_ID_RESOURCE_BARRIER_UNMATCHED_END = 534,

		/// <summary/>
		D3D12_MESSAGE_ID_RESOURCE_BARRIER_UNMATCHED_BEGIN = 535,

		/// <summary/>
		D3D12_MESSAGE_ID_RESOURCE_BARRIER_INVALID_FLAG = 536,

		/// <summary/>
		D3D12_MESSAGE_ID_RESOURCE_BARRIER_INVALID_COMMAND_LIST_TYPE = 537,

		/// <summary/>
		D3D12_MESSAGE_ID_INVALID_SUBRESOURCE_STATE = 538,

		/// <summary/>
		D3D12_MESSAGE_ID_COMMAND_ALLOCATOR_CONTENTION = 540,

		/// <summary/>
		D3D12_MESSAGE_ID_COMMAND_ALLOCATOR_RESET = 541,

		/// <summary/>
		D3D12_MESSAGE_ID_COMMAND_ALLOCATOR_RESET_BUNDLE = 542,

		/// <summary/>
		D3D12_MESSAGE_ID_COMMAND_ALLOCATOR_CANNOT_RESET = 543,

		/// <summary/>
		D3D12_MESSAGE_ID_COMMAND_LIST_OPEN = 544,

		/// <summary/>
		D3D12_MESSAGE_ID_INVALID_BUNDLE_API = 546,

		/// <summary/>
		D3D12_MESSAGE_ID_COMMAND_LIST_CLOSED = 547,

		/// <summary/>
		D3D12_MESSAGE_ID_WRONG_COMMAND_ALLOCATOR_TYPE = 549,

		/// <summary/>
		D3D12_MESSAGE_ID_COMMAND_ALLOCATOR_SYNC = 552,

		/// <summary/>
		D3D12_MESSAGE_ID_COMMAND_LIST_SYNC = 553,

		/// <summary/>
		D3D12_MESSAGE_ID_SET_DESCRIPTOR_HEAP_INVALID = 554,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATE_COMMANDQUEUE = 557,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATE_COMMANDALLOCATOR = 558,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATE_PIPELINESTATE = 559,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATE_COMMANDLIST12 = 560,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATE_RESOURCE = 562,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATE_DESCRIPTORHEAP = 563,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATE_ROOTSIGNATURE = 564,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATE_LIBRARY = 565,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATE_HEAP = 566,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATE_MONITOREDFENCE = 567,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATE_QUERYHEAP = 568,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATE_COMMANDSIGNATURE = 569,

		/// <summary/>
		D3D12_MESSAGE_ID_LIVE_COMMANDQUEUE = 570,

		/// <summary/>
		D3D12_MESSAGE_ID_LIVE_COMMANDALLOCATOR = 571,

		/// <summary/>
		D3D12_MESSAGE_ID_LIVE_PIPELINESTATE = 572,

		/// <summary/>
		D3D12_MESSAGE_ID_LIVE_COMMANDLIST12 = 573,

		/// <summary/>
		D3D12_MESSAGE_ID_LIVE_RESOURCE = 575,

		/// <summary/>
		D3D12_MESSAGE_ID_LIVE_DESCRIPTORHEAP = 576,

		/// <summary/>
		D3D12_MESSAGE_ID_LIVE_ROOTSIGNATURE = 577,

		/// <summary/>
		D3D12_MESSAGE_ID_LIVE_LIBRARY = 578,

		/// <summary/>
		D3D12_MESSAGE_ID_LIVE_HEAP = 579,

		/// <summary/>
		D3D12_MESSAGE_ID_LIVE_MONITOREDFENCE = 580,

		/// <summary/>
		D3D12_MESSAGE_ID_LIVE_QUERYHEAP = 581,

		/// <summary/>
		D3D12_MESSAGE_ID_LIVE_COMMANDSIGNATURE = 582,

		/// <summary/>
		D3D12_MESSAGE_ID_DESTROY_COMMANDQUEUE = 583,

		/// <summary/>
		D3D12_MESSAGE_ID_DESTROY_COMMANDALLOCATOR = 584,

		/// <summary/>
		D3D12_MESSAGE_ID_DESTROY_PIPELINESTATE = 585,

		/// <summary/>
		D3D12_MESSAGE_ID_DESTROY_COMMANDLIST12 = 586,

		/// <summary/>
		D3D12_MESSAGE_ID_DESTROY_RESOURCE = 588,

		/// <summary/>
		D3D12_MESSAGE_ID_DESTROY_DESCRIPTORHEAP = 589,

		/// <summary/>
		D3D12_MESSAGE_ID_DESTROY_ROOTSIGNATURE = 590,

		/// <summary/>
		D3D12_MESSAGE_ID_DESTROY_LIBRARY = 591,

		/// <summary/>
		D3D12_MESSAGE_ID_DESTROY_HEAP = 592,

		/// <summary/>
		D3D12_MESSAGE_ID_DESTROY_MONITOREDFENCE = 593,

		/// <summary/>
		D3D12_MESSAGE_ID_DESTROY_QUERYHEAP = 594,

		/// <summary/>
		D3D12_MESSAGE_ID_DESTROY_COMMANDSIGNATURE = 595,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATERESOURCE_INVALIDDIMENSIONS = 597,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATERESOURCE_INVALIDMISCFLAGS = 599,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATERESOURCE_INVALIDARG_RETURN = 602,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATERESOURCE_OUTOFMEMORY_RETURN = 603,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATERESOURCE_INVALIDDESC = 604,

		/// <summary/>
		D3D12_MESSAGE_ID_POSSIBLY_INVALID_SUBRESOURCE_STATE = 607,

		/// <summary/>
		D3D12_MESSAGE_ID_INVALID_USE_OF_NON_RESIDENT_RESOURCE = 608,

		/// <summary/>
		D3D12_MESSAGE_ID_POSSIBLE_INVALID_USE_OF_NON_RESIDENT_RESOURCE = 609,

		/// <summary/>
		D3D12_MESSAGE_ID_BUNDLE_PIPELINE_STATE_MISMATCH = 610,

		/// <summary/>
		D3D12_MESSAGE_ID_PRIMITIVE_TOPOLOGY_MISMATCH_PIPELINE_STATE = 611,

		/// <summary/>
		D3D12_MESSAGE_ID_RENDER_TARGET_FORMAT_MISMATCH_PIPELINE_STATE = 613,

		/// <summary/>
		D3D12_MESSAGE_ID_RENDER_TARGET_SAMPLE_DESC_MISMATCH_PIPELINE_STATE = 614,

		/// <summary/>
		D3D12_MESSAGE_ID_DEPTH_STENCIL_FORMAT_MISMATCH_PIPELINE_STATE = 615,

		/// <summary/>
		D3D12_MESSAGE_ID_DEPTH_STENCIL_SAMPLE_DESC_MISMATCH_PIPELINE_STATE = 616,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATESHADER_INVALIDBYTECODE = 622,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEHEAP_NULLDESC = 623,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEHEAP_INVALIDSIZE = 624,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEHEAP_UNRECOGNIZEDHEAPTYPE = 625,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEHEAP_UNRECOGNIZEDCPUPAGEPROPERTIES = 626,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEHEAP_UNRECOGNIZEDMEMORYPOOL = 627,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEHEAP_INVALIDPROPERTIES = 628,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEHEAP_INVALIDALIGNMENT = 629,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEHEAP_UNRECOGNIZEDMISCFLAGS = 630,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEHEAP_INVALIDMISCFLAGS = 631,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEHEAP_INVALIDARG_RETURN = 632,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEHEAP_OUTOFMEMORY_RETURN = 633,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATERESOURCEANDHEAP_NULLHEAPPROPERTIES = 634,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATERESOURCEANDHEAP_UNRECOGNIZEDHEAPTYPE = 635,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATERESOURCEANDHEAP_UNRECOGNIZEDCPUPAGEPROPERTIES = 636,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATERESOURCEANDHEAP_UNRECOGNIZEDMEMORYPOOL = 637,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATERESOURCEANDHEAP_INVALIDHEAPPROPERTIES = 638,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATERESOURCEANDHEAP_UNRECOGNIZEDHEAPMISCFLAGS = 639,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATERESOURCEANDHEAP_INVALIDHEAPMISCFLAGS = 640,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATERESOURCEANDHEAP_INVALIDARG_RETURN = 641,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATERESOURCEANDHEAP_OUTOFMEMORY_RETURN = 642,

		/// <summary/>
		D3D12_MESSAGE_ID_GETCUSTOMHEAPPROPERTIES_UNRECOGNIZEDHEAPTYPE = 643,

		/// <summary/>
		D3D12_MESSAGE_ID_GETCUSTOMHEAPPROPERTIES_INVALIDHEAPTYPE = 644,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATE_DESCRIPTOR_HEAP_INVALID_DESC = 645,

		/// <summary/>
		D3D12_MESSAGE_ID_INVALID_DESCRIPTOR_HANDLE = 646,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATERASTERIZERSTATE_INVALID_CONSERVATIVERASTERMODE = 647,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATE_CONSTANT_BUFFER_VIEW_INVALID_RESOURCE = 649,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATE_CONSTANT_BUFFER_VIEW_INVALID_DESC = 650,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATE_UNORDEREDACCESS_VIEW_INVALID_COUNTER_USAGE = 652,

		/// <summary/>
		D3D12_MESSAGE_ID_COPY_DESCRIPTORS_INVALID_RANGES = 653,

		/// <summary/>
		D3D12_MESSAGE_ID_COPY_DESCRIPTORS_WRITE_ONLY_DESCRIPTOR = 654,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_RTV_FORMAT_NOT_UNKNOWN = 655,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_INVALID_RENDER_TARGET_COUNT = 656,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_VERTEX_SHADER_NOT_SET = 657,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_INPUTLAYOUT_NOT_SET = 658,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_SHADER_LINKAGE_HS_DS_SIGNATURE_MISMATCH = 659,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_SHADER_LINKAGE_REGISTERINDEX = 660,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_SHADER_LINKAGE_COMPONENTTYPE = 661,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_SHADER_LINKAGE_REGISTERMASK = 662,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_SHADER_LINKAGE_SYSTEMVALUE = 663,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_SHADER_LINKAGE_NEVERWRITTEN_ALWAYSREADS = 664,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_SHADER_LINKAGE_MINPRECISION = 665,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_SHADER_LINKAGE_SEMANTICNAME_NOT_FOUND = 666,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_HS_XOR_DS_MISMATCH = 667,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_HULL_SHADER_INPUT_TOPOLOGY_MISMATCH = 668,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_HS_DS_CONTROL_POINT_COUNT_MISMATCH = 669,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_HS_DS_TESSELLATOR_DOMAIN_MISMATCH = 670,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_INVALID_USE_OF_CENTER_MULTISAMPLE_PATTERN = 671,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_INVALID_USE_OF_FORCED_SAMPLE_COUNT = 672,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_INVALID_PRIMITIVETOPOLOGY = 673,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_INVALID_SYSTEMVALUE = 674,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_OM_DUAL_SOURCE_BLENDING_CAN_ONLY_HAVE_RENDER_TARGET_0 = 675,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_OM_RENDER_TARGET_DOES_NOT_SUPPORT_BLENDING = 676,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_PS_OUTPUT_TYPE_MISMATCH = 677,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_OM_RENDER_TARGET_DOES_NOT_SUPPORT_LOGIC_OPS = 678,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_RENDERTARGETVIEW_NOT_SET = 679,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_DEPTHSTENCILVIEW_NOT_SET = 680,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_GS_INPUT_PRIMITIVE_MISMATCH = 681,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_POSITION_NOT_PRESENT = 682,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_MISSING_ROOT_SIGNATURE_FLAGS = 683,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_INVALID_INDEX_BUFFER_PROPERTIES = 684,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_INVALID_SAMPLE_DESC = 685,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_HS_ROOT_SIGNATURE_MISMATCH = 686,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_DS_ROOT_SIGNATURE_MISMATCH = 687,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_VS_ROOT_SIGNATURE_MISMATCH = 688,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_GS_ROOT_SIGNATURE_MISMATCH = 689,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_PS_ROOT_SIGNATURE_MISMATCH = 690,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_MISSING_ROOT_SIGNATURE = 691,

		/// <summary/>
		D3D12_MESSAGE_ID_EXECUTE_BUNDLE_OPEN_BUNDLE = 692,

		/// <summary/>
		D3D12_MESSAGE_ID_EXECUTE_BUNDLE_DESCRIPTOR_HEAP_MISMATCH = 693,

		/// <summary/>
		D3D12_MESSAGE_ID_EXECUTE_BUNDLE_TYPE = 694,

		/// <summary/>
		D3D12_MESSAGE_ID_DRAW_EMPTY_SCISSOR_RECTANGLE = 695,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATE_ROOT_SIGNATURE_BLOB_NOT_FOUND = 696,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATE_ROOT_SIGNATURE_DESERIALIZE_FAILED = 697,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATE_ROOT_SIGNATURE_INVALID_CONFIGURATION = 698,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATE_ROOT_SIGNATURE_NOT_SUPPORTED_ON_DEVICE = 699,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATERESOURCEANDHEAP_NULLRESOURCEPROPERTIES = 700,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATERESOURCEANDHEAP_NULLHEAP = 701,

		/// <summary/>
		D3D12_MESSAGE_ID_GETRESOURCEALLOCATIONINFO_INVALIDRDESCS = 702,

		/// <summary/>
		D3D12_MESSAGE_ID_MAKERESIDENT_NULLOBJECTARRAY = 703,

		/// <summary/>
		D3D12_MESSAGE_ID_EVICT_NULLOBJECTARRAY = 705,

		/// <summary/>
		D3D12_MESSAGE_ID_SET_DESCRIPTOR_TABLE_INVALID = 708,

		/// <summary/>
		D3D12_MESSAGE_ID_SET_ROOT_CONSTANT_INVALID = 709,

		/// <summary/>
		D3D12_MESSAGE_ID_SET_ROOT_CONSTANT_BUFFER_VIEW_INVALID = 710,

		/// <summary/>
		D3D12_MESSAGE_ID_SET_ROOT_SHADER_RESOURCE_VIEW_INVALID = 711,

		/// <summary/>
		D3D12_MESSAGE_ID_SET_ROOT_UNORDERED_ACCESS_VIEW_INVALID = 712,

		/// <summary/>
		D3D12_MESSAGE_ID_SET_VERTEX_BUFFERS_INVALID_DESC = 713,

		/// <summary/>
		D3D12_MESSAGE_ID_SET_INDEX_BUFFER_INVALID_DESC = 715,

		/// <summary/>
		D3D12_MESSAGE_ID_SET_STREAM_OUTPUT_BUFFERS_INVALID_DESC = 717,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATERESOURCE_UNRECOGNIZEDDIMENSIONALITY = 718,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATERESOURCE_UNRECOGNIZEDLAYOUT = 719,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATERESOURCE_INVALIDDIMENSIONALITY = 720,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATERESOURCE_INVALIDALIGNMENT = 721,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATERESOURCE_INVALIDMIPLEVELS = 722,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATERESOURCE_INVALIDSAMPLEDESC = 723,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATERESOURCE_INVALIDLAYOUT = 724,

		/// <summary/>
		D3D12_MESSAGE_ID_SET_INDEX_BUFFER_INVALID = 725,

		/// <summary/>
		D3D12_MESSAGE_ID_SET_VERTEX_BUFFERS_INVALID = 726,

		/// <summary/>
		D3D12_MESSAGE_ID_SET_STREAM_OUTPUT_BUFFERS_INVALID = 727,

		/// <summary/>
		D3D12_MESSAGE_ID_SET_RENDER_TARGETS_INVALID = 728,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEQUERY_HEAP_INVALID_PARAMETERS = 729,

		/// <summary/>
		D3D12_MESSAGE_ID_BEGIN_END_QUERY_INVALID_PARAMETERS = 731,

		/// <summary/>
		D3D12_MESSAGE_ID_CLOSE_COMMAND_LIST_OPEN_QUERY = 732,

		/// <summary/>
		D3D12_MESSAGE_ID_RESOLVE_QUERY_DATA_INVALID_PARAMETERS = 733,

		/// <summary/>
		D3D12_MESSAGE_ID_SET_PREDICATION_INVALID_PARAMETERS = 734,

		/// <summary/>
		D3D12_MESSAGE_ID_TIMESTAMPS_NOT_SUPPORTED = 735,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATERESOURCE_UNRECOGNIZEDFORMAT = 737,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATERESOURCE_INVALIDFORMAT = 738,

		/// <summary/>
		D3D12_MESSAGE_ID_GETCOPYABLEFOOTPRINTS_INVALIDSUBRESOURCERANGE = 739,

		/// <summary/>
		D3D12_MESSAGE_ID_GETCOPYABLEFOOTPRINTS_INVALIDBASEOFFSET = 740,

		/// <summary/>
		D3D12_MESSAGE_ID_GETCOPYABLELAYOUT_INVALIDSUBRESOURCERANGE = 739,

		/// <summary/>
		D3D12_MESSAGE_ID_GETCOPYABLELAYOUT_INVALIDBASEOFFSET = 740,

		/// <summary/>
		D3D12_MESSAGE_ID_RESOURCE_BARRIER_INVALID_HEAP = 741,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATE_SAMPLER_INVALID = 742,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATECOMMANDSIGNATURE_INVALID = 743,

		/// <summary/>
		D3D12_MESSAGE_ID_EXECUTE_INDIRECT_INVALID_PARAMETERS = 744,

		/// <summary/>
		D3D12_MESSAGE_ID_GETGPUVIRTUALADDRESS_INVALID_RESOURCE_DIMENSION = 745,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATERESOURCE_INVALIDCLEARVALUE = 815,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATERESOURCE_UNRECOGNIZEDCLEARVALUEFORMAT = 816,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATERESOURCE_INVALIDCLEARVALUEFORMAT = 817,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATERESOURCE_CLEARVALUEDENORMFLUSH = 818,

		/// <summary/>
		D3D12_MESSAGE_ID_CLEARRENDERTARGETVIEW_MISMATCHINGCLEARVALUE = 820,

		/// <summary/>
		D3D12_MESSAGE_ID_CLEARDEPTHSTENCILVIEW_MISMATCHINGCLEARVALUE = 821,

		/// <summary/>
		D3D12_MESSAGE_ID_MAP_INVALIDHEAP = 822,

		/// <summary/>
		D3D12_MESSAGE_ID_UNMAP_INVALIDHEAP = 823,

		/// <summary/>
		D3D12_MESSAGE_ID_MAP_INVALIDRESOURCE = 824,

		/// <summary/>
		D3D12_MESSAGE_ID_UNMAP_INVALIDRESOURCE = 825,

		/// <summary/>
		D3D12_MESSAGE_ID_MAP_INVALIDSUBRESOURCE = 826,

		/// <summary/>
		D3D12_MESSAGE_ID_UNMAP_INVALIDSUBRESOURCE = 827,

		/// <summary/>
		D3D12_MESSAGE_ID_MAP_INVALIDRANGE = 828,

		/// <summary/>
		D3D12_MESSAGE_ID_UNMAP_INVALIDRANGE = 829,

		/// <summary/>
		D3D12_MESSAGE_ID_MAP_INVALIDDATAPOINTER = 832,

		/// <summary/>
		D3D12_MESSAGE_ID_MAP_INVALIDARG_RETURN = 833,

		/// <summary/>
		D3D12_MESSAGE_ID_MAP_OUTOFMEMORY_RETURN = 834,

		/// <summary/>
		D3D12_MESSAGE_ID_EXECUTECOMMANDLISTS_BUNDLENOTSUPPORTED = 835,

		/// <summary/>
		D3D12_MESSAGE_ID_EXECUTECOMMANDLISTS_COMMANDLISTMISMATCH = 836,

		/// <summary/>
		D3D12_MESSAGE_ID_EXECUTECOMMANDLISTS_OPENCOMMANDLIST = 837,

		/// <summary/>
		D3D12_MESSAGE_ID_EXECUTECOMMANDLISTS_FAILEDCOMMANDLIST = 838,

		/// <summary/>
		D3D12_MESSAGE_ID_COPYBUFFERREGION_NULLDST = 839,

		/// <summary/>
		D3D12_MESSAGE_ID_COPYBUFFERREGION_INVALIDDSTRESOURCEDIMENSION = 840,

		/// <summary/>
		D3D12_MESSAGE_ID_COPYBUFFERREGION_DSTRANGEOUTOFBOUNDS = 841,

		/// <summary/>
		D3D12_MESSAGE_ID_COPYBUFFERREGION_NULLSRC = 842,

		/// <summary/>
		D3D12_MESSAGE_ID_COPYBUFFERREGION_INVALIDSRCRESOURCEDIMENSION = 843,

		/// <summary/>
		D3D12_MESSAGE_ID_COPYBUFFERREGION_SRCRANGEOUTOFBOUNDS = 844,

		/// <summary/>
		D3D12_MESSAGE_ID_COPYBUFFERREGION_INVALIDCOPYFLAGS = 845,

		/// <summary/>
		D3D12_MESSAGE_ID_COPYTEXTUREREGION_NULLDST = 846,

		/// <summary/>
		D3D12_MESSAGE_ID_COPYTEXTUREREGION_UNRECOGNIZEDDSTTYPE = 847,

		/// <summary/>
		D3D12_MESSAGE_ID_COPYTEXTUREREGION_INVALIDDSTRESOURCEDIMENSION = 848,

		/// <summary/>
		D3D12_MESSAGE_ID_COPYTEXTUREREGION_INVALIDDSTRESOURCE = 849,

		/// <summary/>
		D3D12_MESSAGE_ID_COPYTEXTUREREGION_INVALIDDSTSUBRESOURCE = 850,

		/// <summary/>
		D3D12_MESSAGE_ID_COPYTEXTUREREGION_INVALIDDSTOFFSET = 851,

		/// <summary/>
		D3D12_MESSAGE_ID_COPYTEXTUREREGION_UNRECOGNIZEDDSTFORMAT = 852,

		/// <summary/>
		D3D12_MESSAGE_ID_COPYTEXTUREREGION_INVALIDDSTFORMAT = 853,

		/// <summary/>
		D3D12_MESSAGE_ID_COPYTEXTUREREGION_INVALIDDSTDIMENSIONS = 854,

		/// <summary/>
		D3D12_MESSAGE_ID_COPYTEXTUREREGION_INVALIDDSTROWPITCH = 855,

		/// <summary/>
		D3D12_MESSAGE_ID_COPYTEXTUREREGION_INVALIDDSTPLACEMENT = 856,

		/// <summary/>
		D3D12_MESSAGE_ID_COPYTEXTUREREGION_INVALIDDSTDSPLACEDFOOTPRINTFORMAT = 857,

		/// <summary/>
		D3D12_MESSAGE_ID_COPYTEXTUREREGION_DSTREGIONOUTOFBOUNDS = 858,

		/// <summary/>
		D3D12_MESSAGE_ID_COPYTEXTUREREGION_NULLSRC = 859,

		/// <summary/>
		D3D12_MESSAGE_ID_COPYTEXTUREREGION_UNRECOGNIZEDSRCTYPE = 860,

		/// <summary/>
		D3D12_MESSAGE_ID_COPYTEXTUREREGION_INVALIDSRCRESOURCEDIMENSION = 861,

		/// <summary/>
		D3D12_MESSAGE_ID_COPYTEXTUREREGION_INVALIDSRCRESOURCE = 862,

		/// <summary/>
		D3D12_MESSAGE_ID_COPYTEXTUREREGION_INVALIDSRCSUBRESOURCE = 863,

		/// <summary/>
		D3D12_MESSAGE_ID_COPYTEXTUREREGION_INVALIDSRCOFFSET = 864,

		/// <summary/>
		D3D12_MESSAGE_ID_COPYTEXTUREREGION_UNRECOGNIZEDSRCFORMAT = 865,

		/// <summary/>
		D3D12_MESSAGE_ID_COPYTEXTUREREGION_INVALIDSRCFORMAT = 866,

		/// <summary/>
		D3D12_MESSAGE_ID_COPYTEXTUREREGION_INVALIDSRCDIMENSIONS = 867,

		/// <summary/>
		D3D12_MESSAGE_ID_COPYTEXTUREREGION_INVALIDSRCROWPITCH = 868,

		/// <summary/>
		D3D12_MESSAGE_ID_COPYTEXTUREREGION_INVALIDSRCPLACEMENT = 869,

		/// <summary/>
		D3D12_MESSAGE_ID_COPYTEXTUREREGION_INVALIDSRCDSPLACEDFOOTPRINTFORMAT = 870,

		/// <summary/>
		D3D12_MESSAGE_ID_COPYTEXTUREREGION_SRCREGIONOUTOFBOUNDS = 871,

		/// <summary/>
		D3D12_MESSAGE_ID_COPYTEXTUREREGION_INVALIDDSTCOORDINATES = 872,

		/// <summary/>
		D3D12_MESSAGE_ID_COPYTEXTUREREGION_INVALIDSRCBOX = 873,

		/// <summary/>
		D3D12_MESSAGE_ID_COPYTEXTUREREGION_FORMATMISMATCH = 874,

		/// <summary/>
		D3D12_MESSAGE_ID_COPYTEXTUREREGION_EMPTYBOX = 875,

		/// <summary/>
		D3D12_MESSAGE_ID_COPYTEXTUREREGION_INVALIDCOPYFLAGS = 876,

		/// <summary/>
		D3D12_MESSAGE_ID_RESOLVESUBRESOURCE_INVALID_SUBRESOURCE_INDEX = 877,

		/// <summary/>
		D3D12_MESSAGE_ID_RESOLVESUBRESOURCE_INVALID_FORMAT = 878,

		/// <summary/>
		D3D12_MESSAGE_ID_RESOLVESUBRESOURCE_RESOURCE_MISMATCH = 879,

		/// <summary/>
		D3D12_MESSAGE_ID_RESOLVESUBRESOURCE_INVALID_SAMPLE_COUNT = 880,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATECOMPUTEPIPELINESTATE_INVALID_SHADER = 881,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATECOMPUTEPIPELINESTATE_CS_ROOT_SIGNATURE_MISMATCH = 882,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATECOMPUTEPIPELINESTATE_MISSING_ROOT_SIGNATURE = 883,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEPIPELINESTATE_INVALIDCACHEDBLOB = 884,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEPIPELINESTATE_CACHEDBLOBADAPTERMISMATCH = 885,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEPIPELINESTATE_CACHEDBLOBDRIVERVERSIONMISMATCH = 886,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEPIPELINESTATE_CACHEDBLOBDESCMISMATCH = 887,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEPIPELINESTATE_CACHEDBLOBIGNORED = 888,

		/// <summary/>
		D3D12_MESSAGE_ID_WRITETOSUBRESOURCE_INVALIDHEAP = 889,

		/// <summary/>
		D3D12_MESSAGE_ID_WRITETOSUBRESOURCE_INVALIDRESOURCE = 890,

		/// <summary/>
		D3D12_MESSAGE_ID_WRITETOSUBRESOURCE_INVALIDBOX = 891,

		/// <summary/>
		D3D12_MESSAGE_ID_WRITETOSUBRESOURCE_INVALIDSUBRESOURCE = 892,

		/// <summary/>
		D3D12_MESSAGE_ID_WRITETOSUBRESOURCE_EMPTYBOX = 893,

		/// <summary/>
		D3D12_MESSAGE_ID_READFROMSUBRESOURCE_INVALIDHEAP = 894,

		/// <summary/>
		D3D12_MESSAGE_ID_READFROMSUBRESOURCE_INVALIDRESOURCE = 895,

		/// <summary/>
		D3D12_MESSAGE_ID_READFROMSUBRESOURCE_INVALIDBOX = 896,

		/// <summary/>
		D3D12_MESSAGE_ID_READFROMSUBRESOURCE_INVALIDSUBRESOURCE = 897,

		/// <summary/>
		D3D12_MESSAGE_ID_READFROMSUBRESOURCE_EMPTYBOX = 898,

		/// <summary/>
		D3D12_MESSAGE_ID_TOO_MANY_NODES_SPECIFIED = 899,

		/// <summary/>
		D3D12_MESSAGE_ID_INVALID_NODE_INDEX = 900,

		/// <summary/>
		D3D12_MESSAGE_ID_GETHEAPPROPERTIES_INVALIDRESOURCE = 901,

		/// <summary/>
		D3D12_MESSAGE_ID_NODE_MASK_MISMATCH = 902,

		/// <summary/>
		D3D12_MESSAGE_ID_COMMAND_LIST_OUTOFMEMORY = 903,

		/// <summary/>
		D3D12_MESSAGE_ID_COMMAND_LIST_MULTIPLE_SWAPCHAIN_BUFFER_REFERENCES = 904,

		/// <summary/>
		D3D12_MESSAGE_ID_COMMAND_LIST_TOO_MANY_SWAPCHAIN_REFERENCES = 905,

		/// <summary/>
		D3D12_MESSAGE_ID_COMMAND_QUEUE_TOO_MANY_SWAPCHAIN_REFERENCES = 906,

		/// <summary/>
		D3D12_MESSAGE_ID_EXECUTECOMMANDLISTS_WRONGSWAPCHAINBUFFERREFERENCE = 907,

		/// <summary/>
		D3D12_MESSAGE_ID_COMMAND_LIST_SETRENDERTARGETS_INVALIDNUMRENDERTARGETS = 908,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATE_QUEUE_INVALID_TYPE = 909,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATE_QUEUE_INVALID_FLAGS = 910,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATESHAREDRESOURCE_INVALIDFLAGS = 911,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATESHAREDRESOURCE_INVALIDFORMAT = 912,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATESHAREDHEAP_INVALIDFLAGS = 913,

		/// <summary/>
		D3D12_MESSAGE_ID_REFLECTSHAREDPROPERTIES_UNRECOGNIZEDPROPERTIES = 914,

		/// <summary/>
		D3D12_MESSAGE_ID_REFLECTSHAREDPROPERTIES_INVALIDSIZE = 915,

		/// <summary/>
		D3D12_MESSAGE_ID_REFLECTSHAREDPROPERTIES_INVALIDOBJECT = 916,

		/// <summary/>
		D3D12_MESSAGE_ID_KEYEDMUTEX_INVALIDOBJECT = 917,

		/// <summary/>
		D3D12_MESSAGE_ID_KEYEDMUTEX_INVALIDKEY = 918,

		/// <summary/>
		D3D12_MESSAGE_ID_KEYEDMUTEX_WRONGSTATE = 919,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATE_QUEUE_INVALID_PRIORITY = 920,

		/// <summary/>
		D3D12_MESSAGE_ID_OBJECT_DELETED_WHILE_STILL_IN_USE = 921,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEPIPELINESTATE_INVALID_FLAGS = 922,

		/// <summary/>
		D3D12_MESSAGE_ID_HEAP_ADDRESS_RANGE_HAS_NO_RESOURCE = 923,

		/// <summary/>
		D3D12_MESSAGE_ID_COMMAND_LIST_DRAW_RENDER_TARGET_DELETED = 924,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_ALL_RENDER_TARGETS_HAVE_UNKNOWN_FORMAT = 925,

		/// <summary/>
		D3D12_MESSAGE_ID_HEAP_ADDRESS_RANGE_INTERSECTS_MULTIPLE_BUFFERS = 926,

		/// <summary/>
		D3D12_MESSAGE_ID_EXECUTECOMMANDLISTS_GPU_WRITTEN_READBACK_RESOURCE_MAPPED = 927,

		/// <summary/>
		D3D12_MESSAGE_ID_UNMAP_RANGE_NOT_EMPTY = 929,

		/// <summary/>
		D3D12_MESSAGE_ID_MAP_INVALID_NULLRANGE = 930,

		/// <summary/>
		D3D12_MESSAGE_ID_UNMAP_INVALID_NULLRANGE = 931,

		/// <summary/>
		D3D12_MESSAGE_ID_NO_GRAPHICS_API_SUPPORT = 932,

		/// <summary/>
		D3D12_MESSAGE_ID_NO_COMPUTE_API_SUPPORT = 933,

		/// <summary/>
		D3D12_MESSAGE_ID_RESOLVESUBRESOURCE_RESOURCE_FLAGS_NOT_SUPPORTED = 934,

		/// <summary/>
		D3D12_MESSAGE_ID_GPU_BASED_VALIDATION_ROOT_ARGUMENT_UNINITIALIZED = 935,

		/// <summary/>
		D3D12_MESSAGE_ID_GPU_BASED_VALIDATION_DESCRIPTOR_HEAP_INDEX_OUT_OF_BOUNDS = 936,

		/// <summary/>
		D3D12_MESSAGE_ID_GPU_BASED_VALIDATION_DESCRIPTOR_TABLE_REGISTER_INDEX_OUT_OF_BOUNDS = 937,

		/// <summary/>
		D3D12_MESSAGE_ID_GPU_BASED_VALIDATION_DESCRIPTOR_UNINITIALIZED = 938,

		/// <summary/>
		D3D12_MESSAGE_ID_GPU_BASED_VALIDATION_DESCRIPTOR_TYPE_MISMATCH = 939,

		/// <summary/>
		D3D12_MESSAGE_ID_GPU_BASED_VALIDATION_SRV_RESOURCE_DIMENSION_MISMATCH = 940,

		/// <summary/>
		D3D12_MESSAGE_ID_GPU_BASED_VALIDATION_UAV_RESOURCE_DIMENSION_MISMATCH = 941,

		/// <summary/>
		D3D12_MESSAGE_ID_GPU_BASED_VALIDATION_INCOMPATIBLE_RESOURCE_STATE = 942,

		/// <summary/>
		D3D12_MESSAGE_ID_COPYRESOURCE_NULLDST = 943,

		/// <summary/>
		D3D12_MESSAGE_ID_COPYRESOURCE_INVALIDDSTRESOURCE = 944,

		/// <summary/>
		D3D12_MESSAGE_ID_COPYRESOURCE_NULLSRC = 945,

		/// <summary/>
		D3D12_MESSAGE_ID_COPYRESOURCE_INVALIDSRCRESOURCE = 946,

		/// <summary/>
		D3D12_MESSAGE_ID_RESOLVESUBRESOURCE_NULLDST = 947,

		/// <summary/>
		D3D12_MESSAGE_ID_RESOLVESUBRESOURCE_INVALIDDSTRESOURCE = 948,

		/// <summary/>
		D3D12_MESSAGE_ID_RESOLVESUBRESOURCE_NULLSRC = 949,

		/// <summary/>
		D3D12_MESSAGE_ID_RESOLVESUBRESOURCE_INVALIDSRCRESOURCE = 950,

		/// <summary/>
		D3D12_MESSAGE_ID_PIPELINE_STATE_TYPE_MISMATCH = 951,

		/// <summary/>
		D3D12_MESSAGE_ID_COMMAND_LIST_DISPATCH_ROOT_SIGNATURE_NOT_SET = 952,

		/// <summary/>
		D3D12_MESSAGE_ID_COMMAND_LIST_DISPATCH_ROOT_SIGNATURE_MISMATCH = 953,

		/// <summary/>
		D3D12_MESSAGE_ID_RESOURCE_BARRIER_ZERO_BARRIERS = 954,

		/// <summary/>
		D3D12_MESSAGE_ID_BEGIN_END_EVENT_MISMATCH = 955,

		/// <summary/>
		D3D12_MESSAGE_ID_RESOURCE_BARRIER_POSSIBLE_BEFORE_AFTER_MISMATCH = 956,

		/// <summary/>
		D3D12_MESSAGE_ID_RESOURCE_BARRIER_MISMATCHING_BEGIN_END = 957,

		/// <summary/>
		D3D12_MESSAGE_ID_GPU_BASED_VALIDATION_INVALID_RESOURCE = 958,

		/// <summary/>
		D3D12_MESSAGE_ID_USE_OF_ZERO_REFCOUNT_OBJECT = 959,

		/// <summary/>
		D3D12_MESSAGE_ID_OBJECT_EVICTED_WHILE_STILL_IN_USE = 960,

		/// <summary/>
		D3D12_MESSAGE_ID_GPU_BASED_VALIDATION_ROOT_DESCRIPTOR_ACCESS_OUT_OF_BOUNDS = 961,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEPIPELINELIBRARY_INVALIDLIBRARYBLOB = 962,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEPIPELINELIBRARY_DRIVERVERSIONMISMATCH = 963,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEPIPELINELIBRARY_ADAPTERVERSIONMISMATCH = 964,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEPIPELINELIBRARY_UNSUPPORTED = 965,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATE_PIPELINELIBRARY = 966,

		/// <summary/>
		D3D12_MESSAGE_ID_LIVE_PIPELINELIBRARY = 967,

		/// <summary/>
		D3D12_MESSAGE_ID_DESTROY_PIPELINELIBRARY = 968,

		/// <summary/>
		D3D12_MESSAGE_ID_STOREPIPELINE_NONAME = 969,

		/// <summary/>
		D3D12_MESSAGE_ID_STOREPIPELINE_DUPLICATENAME = 970,

		/// <summary/>
		D3D12_MESSAGE_ID_LOADPIPELINE_NAMENOTFOUND = 971,

		/// <summary/>
		D3D12_MESSAGE_ID_LOADPIPELINE_INVALIDDESC = 972,

		/// <summary/>
		D3D12_MESSAGE_ID_PIPELINELIBRARY_SERIALIZE_NOTENOUGHMEMORY = 973,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_PS_OUTPUT_RT_OUTPUT_MISMATCH = 974,

		/// <summary/>
		D3D12_MESSAGE_ID_SETEVENTONMULTIPLEFENCECOMPLETION_INVALIDFLAGS = 975,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATE_QUEUE_VIDEO_NOT_SUPPORTED = 976,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATE_COMMAND_ALLOCATOR_VIDEO_NOT_SUPPORTED = 977,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEQUERY_HEAP_VIDEO_DECODE_STATISTICS_NOT_SUPPORTED = 978,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATE_VIDEODECODECOMMANDLIST = 979,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATE_VIDEODECODER = 980,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATE_VIDEODECODESTREAM = 981,

		/// <summary/>
		D3D12_MESSAGE_ID_LIVE_VIDEODECODECOMMANDLIST = 982,

		/// <summary/>
		D3D12_MESSAGE_ID_LIVE_VIDEODECODER = 983,

		/// <summary/>
		D3D12_MESSAGE_ID_LIVE_VIDEODECODESTREAM = 984,

		/// <summary/>
		D3D12_MESSAGE_ID_DESTROY_VIDEODECODECOMMANDLIST = 985,

		/// <summary/>
		D3D12_MESSAGE_ID_DESTROY_VIDEODECODER = 986,

		/// <summary/>
		D3D12_MESSAGE_ID_DESTROY_VIDEODECODESTREAM = 987,

		/// <summary/>
		D3D12_MESSAGE_ID_DECODE_FRAME_INVALID_PARAMETERS = 988,

		/// <summary/>
		D3D12_MESSAGE_ID_DEPRECATED_API = 989,

		/// <summary/>
		D3D12_MESSAGE_ID_RESOURCE_BARRIER_MISMATCHING_COMMAND_LIST_TYPE = 990,

		/// <summary/>
		D3D12_MESSAGE_ID_COMMAND_LIST_DESCRIPTOR_TABLE_NOT_SET = 991,

		/// <summary/>
		D3D12_MESSAGE_ID_COMMAND_LIST_ROOT_CONSTANT_BUFFER_VIEW_NOT_SET = 992,

		/// <summary/>
		D3D12_MESSAGE_ID_COMMAND_LIST_ROOT_SHADER_RESOURCE_VIEW_NOT_SET = 993,

		/// <summary/>
		D3D12_MESSAGE_ID_COMMAND_LIST_ROOT_UNORDERED_ACCESS_VIEW_NOT_SET = 994,

		/// <summary/>
		D3D12_MESSAGE_ID_DISCARD_INVALID_SUBRESOURCE_RANGE = 995,

		/// <summary/>
		D3D12_MESSAGE_ID_DISCARD_ONE_SUBRESOURCE_FOR_MIPS_WITH_RECTS = 996,

		/// <summary/>
		D3D12_MESSAGE_ID_DISCARD_NO_RECTS_FOR_NON_TEXTURE2D = 997,

		/// <summary/>
		D3D12_MESSAGE_ID_COPY_ON_SAME_SUBRESOURCE = 998,

		/// <summary/>
		D3D12_MESSAGE_ID_SETRESIDENCYPRIORITY_INVALID_PAGEABLE = 999,

		/// <summary/>
		D3D12_MESSAGE_ID_GPU_BASED_VALIDATION_UNSUPPORTED = 1000,

		/// <summary/>
		D3D12_MESSAGE_ID_STATIC_DESCRIPTOR_INVALID_DESCRIPTOR_CHANGE = 1001,

		/// <summary/>
		D3D12_MESSAGE_ID_DATA_STATIC_DESCRIPTOR_INVALID_DATA_CHANGE = 1002,

		/// <summary/>
		D3D12_MESSAGE_ID_DATA_STATIC_WHILE_SET_AT_EXECUTE_DESCRIPTOR_INVALID_DATA_CHANGE = 1003,

		/// <summary/>
		D3D12_MESSAGE_ID_EXECUTE_BUNDLE_STATIC_DESCRIPTOR_DATA_STATIC_NOT_SET = 1004,

		/// <summary/>
		D3D12_MESSAGE_ID_GPU_BASED_VALIDATION_RESOURCE_ACCESS_OUT_OF_BOUNDS = 1005,

		/// <summary/>
		D3D12_MESSAGE_ID_GPU_BASED_VALIDATION_SAMPLER_MODE_MISMATCH = 1006,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATE_FENCE_INVALID_FLAGS = 1007,

		/// <summary/>
		D3D12_MESSAGE_ID_RESOURCE_BARRIER_DUPLICATE_SUBRESOURCE_TRANSITIONS = 1008,

		/// <summary/>
		D3D12_MESSAGE_ID_SETRESIDENCYPRIORITY_INVALID_PRIORITY = 1009,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATE_DESCRIPTOR_HEAP_LARGE_NUM_DESCRIPTORS = 1013,

		/// <summary/>
		D3D12_MESSAGE_ID_BEGIN_EVENT = 1014,

		/// <summary/>
		D3D12_MESSAGE_ID_END_EVENT = 1015,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEDEVICE_DEBUG_LAYER_STARTUP_OPTIONS = 1016,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_DEPTHBOUNDSTEST_UNSUPPORTED = 1017,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEPIPELINESTATE_DUPLICATE_SUBOBJECT = 1018,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEPIPELINESTATE_UNKNOWN_SUBOBJECT = 1019,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEPIPELINESTATE_ZERO_SIZE_STREAM = 1020,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEPIPELINESTATE_INVALID_STREAM = 1021,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEPIPELINESTATE_CANNOT_DEDUCE_TYPE = 1022,

		/// <summary/>
		D3D12_MESSAGE_ID_COMMAND_LIST_STATIC_DESCRIPTOR_RESOURCE_DIMENSION_MISMATCH = 1023,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATE_COMMAND_QUEUE_INSUFFICIENT_PRIVILEGE_FOR_GLOBAL_REALTIME = 1024,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATE_COMMAND_QUEUE_INSUFFICIENT_HARDWARE_SUPPORT_FOR_GLOBAL_REALTIME = 1025,

		/// <summary/>
		D3D12_MESSAGE_ID_ATOMICCOPYBUFFER_INVALID_ARCHITECTURE = 1026,

		/// <summary/>
		D3D12_MESSAGE_ID_ATOMICCOPYBUFFER_NULL_DST = 1027,

		/// <summary/>
		D3D12_MESSAGE_ID_ATOMICCOPYBUFFER_INVALID_DST_RESOURCE_DIMENSION = 1028,

		/// <summary/>
		D3D12_MESSAGE_ID_ATOMICCOPYBUFFER_DST_RANGE_OUT_OF_BOUNDS = 1029,

		/// <summary/>
		D3D12_MESSAGE_ID_ATOMICCOPYBUFFER_NULL_SRC = 1030,

		/// <summary/>
		D3D12_MESSAGE_ID_ATOMICCOPYBUFFER_INVALID_SRC_RESOURCE_DIMENSION = 1031,

		/// <summary/>
		D3D12_MESSAGE_ID_ATOMICCOPYBUFFER_SRC_RANGE_OUT_OF_BOUNDS = 1032,

		/// <summary/>
		D3D12_MESSAGE_ID_ATOMICCOPYBUFFER_INVALID_OFFSET_ALIGNMENT = 1033,

		/// <summary/>
		D3D12_MESSAGE_ID_ATOMICCOPYBUFFER_NULL_DEPENDENT_RESOURCES = 1034,

		/// <summary/>
		D3D12_MESSAGE_ID_ATOMICCOPYBUFFER_NULL_DEPENDENT_SUBRESOURCE_RANGES = 1035,

		/// <summary/>
		D3D12_MESSAGE_ID_ATOMICCOPYBUFFER_INVALID_DEPENDENT_RESOURCE = 1036,

		/// <summary/>
		D3D12_MESSAGE_ID_ATOMICCOPYBUFFER_INVALID_DEPENDENT_SUBRESOURCE_RANGE = 1037,

		/// <summary/>
		D3D12_MESSAGE_ID_ATOMICCOPYBUFFER_DEPENDENT_SUBRESOURCE_OUT_OF_BOUNDS = 1038,

		/// <summary/>
		D3D12_MESSAGE_ID_ATOMICCOPYBUFFER_DEPENDENT_RANGE_OUT_OF_BOUNDS = 1039,

		/// <summary/>
		D3D12_MESSAGE_ID_ATOMICCOPYBUFFER_ZERO_DEPENDENCIES = 1040,

		/// <summary/>
		D3D12_MESSAGE_ID_DEVICE_CREATE_SHARED_HANDLE_INVALIDARG = 1041,

		/// <summary/>
		D3D12_MESSAGE_ID_DESCRIPTOR_HANDLE_WITH_INVALID_RESOURCE = 1042,

		/// <summary/>
		D3D12_MESSAGE_ID_SETDEPTHBOUNDS_INVALIDARGS = 1043,

		/// <summary/>
		D3D12_MESSAGE_ID_GPU_BASED_VALIDATION_RESOURCE_STATE_IMPRECISE = 1044,

		/// <summary/>
		D3D12_MESSAGE_ID_COMMAND_LIST_PIPELINE_STATE_NOT_SET = 1045,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_SHADER_MODEL_MISMATCH = 1046,

		/// <summary/>
		D3D12_MESSAGE_ID_OBJECT_ACCESSED_WHILE_STILL_IN_USE = 1047,

		/// <summary/>
		D3D12_MESSAGE_ID_PROGRAMMABLE_MSAA_UNSUPPORTED = 1048,

		/// <summary/>
		D3D12_MESSAGE_ID_SETSAMPLEPOSITIONS_INVALIDARGS = 1049,

		/// <summary/>
		D3D12_MESSAGE_ID_RESOLVESUBRESOURCEREGION_INVALID_RECT = 1050,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATE_VIDEODECODECOMMANDQUEUE = 1051,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATE_VIDEOPROCESSCOMMANDLIST = 1052,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATE_VIDEOPROCESSCOMMANDQUEUE = 1053,

		/// <summary/>
		D3D12_MESSAGE_ID_LIVE_VIDEODECODECOMMANDQUEUE = 1054,

		/// <summary/>
		D3D12_MESSAGE_ID_LIVE_VIDEOPROCESSCOMMANDLIST = 1055,

		/// <summary/>
		D3D12_MESSAGE_ID_LIVE_VIDEOPROCESSCOMMANDQUEUE = 1056,

		/// <summary/>
		D3D12_MESSAGE_ID_DESTROY_VIDEODECODECOMMANDQUEUE = 1057,

		/// <summary/>
		D3D12_MESSAGE_ID_DESTROY_VIDEOPROCESSCOMMANDLIST = 1058,

		/// <summary/>
		D3D12_MESSAGE_ID_DESTROY_VIDEOPROCESSCOMMANDQUEUE = 1059,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATE_VIDEOPROCESSOR = 1060,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATE_VIDEOPROCESSSTREAM = 1061,

		/// <summary/>
		D3D12_MESSAGE_ID_LIVE_VIDEOPROCESSOR = 1062,

		/// <summary/>
		D3D12_MESSAGE_ID_LIVE_VIDEOPROCESSSTREAM = 1063,

		/// <summary/>
		D3D12_MESSAGE_ID_DESTROY_VIDEOPROCESSOR = 1064,

		/// <summary/>
		D3D12_MESSAGE_ID_DESTROY_VIDEOPROCESSSTREAM = 1065,

		/// <summary/>
		D3D12_MESSAGE_ID_PROCESS_FRAME_INVALID_PARAMETERS = 1066,

		/// <summary/>
		D3D12_MESSAGE_ID_COPY_INVALIDLAYOUT = 1067,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATE_CRYPTO_SESSION = 1068,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATE_CRYPTO_SESSION_POLICY = 1069,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATE_PROTECTED_RESOURCE_SESSION = 1070,

		/// <summary/>
		D3D12_MESSAGE_ID_LIVE_CRYPTO_SESSION = 1071,

		/// <summary/>
		D3D12_MESSAGE_ID_LIVE_CRYPTO_SESSION_POLICY = 1072,

		/// <summary/>
		D3D12_MESSAGE_ID_LIVE_PROTECTED_RESOURCE_SESSION = 1073,

		/// <summary/>
		D3D12_MESSAGE_ID_DESTROY_CRYPTO_SESSION = 1074,

		/// <summary/>
		D3D12_MESSAGE_ID_DESTROY_CRYPTO_SESSION_POLICY = 1075,

		/// <summary/>
		D3D12_MESSAGE_ID_DESTROY_PROTECTED_RESOURCE_SESSION = 1076,

		/// <summary/>
		D3D12_MESSAGE_ID_PROTECTED_RESOURCE_SESSION_UNSUPPORTED = 1077,

		/// <summary/>
		D3D12_MESSAGE_ID_FENCE_INVALIDOPERATION = 1078,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEQUERY_HEAP_COPY_QUEUE_TIMESTAMPS_NOT_SUPPORTED = 1079,

		/// <summary/>
		D3D12_MESSAGE_ID_SAMPLEPOSITIONS_MISMATCH_DEFERRED = 1080,

		/// <summary/>
		D3D12_MESSAGE_ID_SAMPLEPOSITIONS_MISMATCH_RECORDTIME_ASSUMEDFROMFIRSTUSE = 1081,

		/// <summary/>
		D3D12_MESSAGE_ID_SAMPLEPOSITIONS_MISMATCH_RECORDTIME_ASSUMEDFROMCLEAR = 1082,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATE_VIDEODECODERHEAP = 1083,

		/// <summary/>
		D3D12_MESSAGE_ID_LIVE_VIDEODECODERHEAP = 1084,

		/// <summary/>
		D3D12_MESSAGE_ID_DESTROY_VIDEODECODERHEAP = 1085,

		/// <summary/>
		D3D12_MESSAGE_ID_OPENEXISTINGHEAP_INVALIDARG_RETURN = 1086,

		/// <summary/>
		D3D12_MESSAGE_ID_OPENEXISTINGHEAP_OUTOFMEMORY_RETURN = 1087,

		/// <summary/>
		D3D12_MESSAGE_ID_OPENEXISTINGHEAP_INVALIDADDRESS = 1088,

		/// <summary/>
		D3D12_MESSAGE_ID_OPENEXISTINGHEAP_INVALIDHANDLE = 1089,

		/// <summary/>
		D3D12_MESSAGE_ID_WRITEBUFFERIMMEDIATE_INVALID_DEST = 1090,

		/// <summary/>
		D3D12_MESSAGE_ID_WRITEBUFFERIMMEDIATE_INVALID_MODE = 1091,

		/// <summary/>
		D3D12_MESSAGE_ID_WRITEBUFFERIMMEDIATE_INVALID_ALIGNMENT = 1092,

		/// <summary/>
		D3D12_MESSAGE_ID_WRITEBUFFERIMMEDIATE_NOT_SUPPORTED = 1093,

		/// <summary/>
		D3D12_MESSAGE_ID_SETVIEWINSTANCEMASK_INVALIDARGS = 1094,

		/// <summary/>
		D3D12_MESSAGE_ID_VIEW_INSTANCING_UNSUPPORTED = 1095,

		/// <summary/>
		D3D12_MESSAGE_ID_VIEW_INSTANCING_INVALIDARGS = 1096,

		/// <summary/>
		D3D12_MESSAGE_ID_COPYTEXTUREREGION_MISMATCH_DECODE_REFERENCE_ONLY_FLAG = 1097,

		/// <summary/>
		D3D12_MESSAGE_ID_COPYRESOURCE_MISMATCH_DECODE_REFERENCE_ONLY_FLAG = 1098,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATE_VIDEO_DECODE_HEAP_CAPS_FAILURE = 1099,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATE_VIDEO_DECODE_HEAP_CAPS_UNSUPPORTED = 1100,

		/// <summary/>
		D3D12_MESSAGE_ID_VIDEO_DECODE_SUPPORT_INVALID_INPUT = 1101,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATE_VIDEO_DECODER_UNSUPPORTED = 1102,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_METADATA_ERROR = 1103,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_VIEW_INSTANCING_VERTEX_SIZE_EXCEEDED = 1104,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_RUNTIME_INTERNAL_ERROR = 1105,

		/// <summary/>
		D3D12_MESSAGE_ID_NO_VIDEO_API_SUPPORT = 1106,

		/// <summary/>
		D3D12_MESSAGE_ID_VIDEO_PROCESS_SUPPORT_INVALID_INPUT = 1107,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATE_VIDEO_PROCESSOR_CAPS_FAILURE = 1108,

		/// <summary/>
		D3D12_MESSAGE_ID_VIDEO_PROCESS_SUPPORT_UNSUPPORTED_FORMAT = 1109,

		/// <summary/>
		D3D12_MESSAGE_ID_VIDEO_DECODE_FRAME_INVALID_ARGUMENT = 1110,

		/// <summary/>
		D3D12_MESSAGE_ID_ENQUEUE_MAKE_RESIDENT_INVALID_FLAGS = 1111,

		/// <summary/>
		D3D12_MESSAGE_ID_OPENEXISTINGHEAP_UNSUPPORTED = 1112,

		/// <summary/>
		D3D12_MESSAGE_ID_VIDEO_PROCESS_FRAMES_INVALID_ARGUMENT = 1113,

		/// <summary/>
		D3D12_MESSAGE_ID_VIDEO_DECODE_SUPPORT_UNSUPPORTED = 1114,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATE_COMMANDRECORDER = 1115,

		/// <summary/>
		D3D12_MESSAGE_ID_LIVE_COMMANDRECORDER = 1116,

		/// <summary/>
		D3D12_MESSAGE_ID_DESTROY_COMMANDRECORDER = 1117,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATE_COMMAND_RECORDER_VIDEO_NOT_SUPPORTED = 1118,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATE_COMMAND_RECORDER_INVALID_SUPPORT_FLAGS = 1119,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATE_COMMAND_RECORDER_INVALID_FLAGS = 1120,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATE_COMMAND_RECORDER_MORE_RECORDERS_THAN_LOGICAL_PROCESSORS = 1121,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATE_COMMANDPOOL = 1122,

		/// <summary/>
		D3D12_MESSAGE_ID_LIVE_COMMANDPOOL = 1123,

		/// <summary/>
		D3D12_MESSAGE_ID_DESTROY_COMMANDPOOL = 1124,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATE_COMMAND_POOL_INVALID_FLAGS = 1125,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATE_COMMAND_LIST_VIDEO_NOT_SUPPORTED = 1126,

		/// <summary/>
		D3D12_MESSAGE_ID_COMMAND_RECORDER_SUPPORT_FLAGS_MISMATCH = 1127,

		/// <summary/>
		D3D12_MESSAGE_ID_COMMAND_RECORDER_CONTENTION = 1128,

		/// <summary/>
		D3D12_MESSAGE_ID_COMMAND_RECORDER_USAGE_WITH_CREATECOMMANDLIST_COMMAND_LIST = 1129,

		/// <summary/>
		D3D12_MESSAGE_ID_COMMAND_ALLOCATOR_USAGE_WITH_CREATECOMMANDLIST1_COMMAND_LIST = 1130,

		/// <summary/>
		D3D12_MESSAGE_ID_CANNOT_EXECUTE_EMPTY_COMMAND_LIST = 1131,

		/// <summary/>
		D3D12_MESSAGE_ID_CANNOT_RESET_COMMAND_POOL_WITH_OPEN_COMMAND_LISTS = 1132,

		/// <summary/>
		D3D12_MESSAGE_ID_CANNOT_USE_COMMAND_RECORDER_WITHOUT_CURRENT_TARGET = 1133,

		/// <summary/>
		D3D12_MESSAGE_ID_CANNOT_CHANGE_COMMAND_RECORDER_TARGET_WHILE_RECORDING = 1134,

		/// <summary/>
		D3D12_MESSAGE_ID_COMMAND_POOL_SYNC = 1135,

		/// <summary/>
		D3D12_MESSAGE_ID_EVICT_UNDERFLOW = 1136,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATE_META_COMMAND = 1137,

		/// <summary/>
		D3D12_MESSAGE_ID_LIVE_META_COMMAND = 1138,

		/// <summary/>
		D3D12_MESSAGE_ID_DESTROY_META_COMMAND = 1139,

		/// <summary/>
		D3D12_MESSAGE_ID_COPYBUFFERREGION_INVALID_DST_RESOURCE = 1140,

		/// <summary/>
		D3D12_MESSAGE_ID_COPYBUFFERREGION_INVALID_SRC_RESOURCE = 1141,

		/// <summary/>
		D3D12_MESSAGE_ID_ATOMICCOPYBUFFER_INVALID_DST_RESOURCE = 1142,

		/// <summary/>
		D3D12_MESSAGE_ID_ATOMICCOPYBUFFER_INVALID_SRC_RESOURCE = 1143,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEPLACEDRESOURCEONBUFFER_NULL_BUFFER = 1144,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEPLACEDRESOURCEONBUFFER_NULL_RESOURCE_DESC = 1145,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEPLACEDRESOURCEONBUFFER_UNSUPPORTED = 1146,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEPLACEDRESOURCEONBUFFER_INVALID_BUFFER_DIMENSION = 1147,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEPLACEDRESOURCEONBUFFER_INVALID_BUFFER_FLAGS = 1148,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEPLACEDRESOURCEONBUFFER_INVALID_BUFFER_OFFSET = 1149,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEPLACEDRESOURCEONBUFFER_INVALID_RESOURCE_DIMENSION = 1150,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEPLACEDRESOURCEONBUFFER_INVALID_RESOURCE_FLAGS = 1151,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEPLACEDRESOURCEONBUFFER_OUTOFMEMORY_RETURN = 1152,

		/// <summary/>
		D3D12_MESSAGE_ID_CANNOT_CREATE_GRAPHICS_AND_VIDEO_COMMAND_RECORDER = 1153,

		/// <summary/>
		D3D12_MESSAGE_ID_UPDATETILEMAPPINGS_POSSIBLY_MISMATCHING_PROPERTIES = 1154,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATE_COMMAND_LIST_INVALID_COMMAND_LIST_TYPE = 1155,

		/// <summary/>
		D3D12_MESSAGE_ID_CLEARUNORDEREDACCESSVIEW_INCOMPATIBLE_WITH_STRUCTURED_BUFFERS = 1156,

		/// <summary/>
		D3D12_MESSAGE_ID_COMPUTE_ONLY_DEVICE_OPERATION_UNSUPPORTED = 1157,

		/// <summary/>
		D3D12_MESSAGE_ID_BUILD_RAYTRACING_ACCELERATION_STRUCTURE_INVALID = 1158,

		/// <summary/>
		D3D12_MESSAGE_ID_EMIT_RAYTRACING_ACCELERATION_STRUCTURE_POSTBUILD_INFO_INVALID = 1159,

		/// <summary/>
		D3D12_MESSAGE_ID_COPY_RAYTRACING_ACCELERATION_STRUCTURE_INVALID = 1160,

		/// <summary/>
		D3D12_MESSAGE_ID_DISPATCH_RAYS_INVALID = 1161,

		/// <summary/>
		D3D12_MESSAGE_ID_GET_RAYTRACING_ACCELERATION_STRUCTURE_PREBUILD_INFO_INVALID = 1162,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATE_LIFETIMETRACKER = 1163,

		/// <summary/>
		D3D12_MESSAGE_ID_LIVE_LIFETIMETRACKER = 1164,

		/// <summary/>
		D3D12_MESSAGE_ID_DESTROY_LIFETIMETRACKER = 1165,

		/// <summary/>
		D3D12_MESSAGE_ID_DESTROYOWNEDOBJECT_OBJECTNOTOWNED = 1166,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATE_TRACKEDWORKLOAD = 1167,

		/// <summary/>
		D3D12_MESSAGE_ID_LIVE_TRACKEDWORKLOAD = 1168,

		/// <summary/>
		D3D12_MESSAGE_ID_DESTROY_TRACKEDWORKLOAD = 1169,

		/// <summary/>
		D3D12_MESSAGE_ID_RENDER_PASS_ERROR = 1170,

		/// <summary/>
		D3D12_MESSAGE_ID_META_COMMAND_ID_INVALID = 1171,

		/// <summary/>
		D3D12_MESSAGE_ID_META_COMMAND_UNSUPPORTED_PARAMS = 1172,

		/// <summary/>
		D3D12_MESSAGE_ID_META_COMMAND_FAILED_ENUMERATION = 1173,

		/// <summary/>
		D3D12_MESSAGE_ID_META_COMMAND_PARAMETER_SIZE_MISMATCH = 1174,

		/// <summary/>
		D3D12_MESSAGE_ID_UNINITIALIZED_META_COMMAND = 1175,

		/// <summary/>
		D3D12_MESSAGE_ID_META_COMMAND_INVALID_GPU_VIRTUAL_ADDRESS = 1176,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATE_VIDEOENCODECOMMANDLIST = 1177,

		/// <summary/>
		D3D12_MESSAGE_ID_LIVE_VIDEOENCODECOMMANDLIST = 1178,

		/// <summary/>
		D3D12_MESSAGE_ID_DESTROY_VIDEOENCODECOMMANDLIST = 1179,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATE_VIDEOENCODECOMMANDQUEUE = 1180,

		/// <summary/>
		D3D12_MESSAGE_ID_LIVE_VIDEOENCODECOMMANDQUEUE = 1181,

		/// <summary/>
		D3D12_MESSAGE_ID_DESTROY_VIDEOENCODECOMMANDQUEUE = 1182,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATE_VIDEOMOTIONESTIMATOR = 1183,

		/// <summary/>
		D3D12_MESSAGE_ID_LIVE_VIDEOMOTIONESTIMATOR = 1184,

		/// <summary/>
		D3D12_MESSAGE_ID_DESTROY_VIDEOMOTIONESTIMATOR = 1185,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATE_VIDEOMOTIONVECTORHEAP = 1186,

		/// <summary/>
		D3D12_MESSAGE_ID_LIVE_VIDEOMOTIONVECTORHEAP = 1187,

		/// <summary/>
		D3D12_MESSAGE_ID_DESTROY_VIDEOMOTIONVECTORHEAP = 1188,

		/// <summary/>
		D3D12_MESSAGE_ID_MULTIPLE_TRACKED_WORKLOADS = 1189,

		/// <summary/>
		D3D12_MESSAGE_ID_MULTIPLE_TRACKED_WORKLOAD_PAIRS = 1190,

		/// <summary/>
		D3D12_MESSAGE_ID_OUT_OF_ORDER_TRACKED_WORKLOAD_PAIR = 1191,

		/// <summary/>
		D3D12_MESSAGE_ID_CANNOT_ADD_TRACKED_WORKLOAD = 1192,

		/// <summary/>
		D3D12_MESSAGE_ID_INCOMPLETE_TRACKED_WORKLOAD_PAIR = 1193,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATE_STATE_OBJECT_ERROR = 1194,

		/// <summary/>
		D3D12_MESSAGE_ID_GET_SHADER_IDENTIFIER_ERROR = 1195,

		/// <summary/>
		D3D12_MESSAGE_ID_GET_SHADER_STACK_SIZE_ERROR = 1196,

		/// <summary/>
		D3D12_MESSAGE_ID_GET_PIPELINE_STACK_SIZE_ERROR = 1197,

		/// <summary/>
		D3D12_MESSAGE_ID_SET_PIPELINE_STACK_SIZE_ERROR = 1198,

		/// <summary/>
		D3D12_MESSAGE_ID_GET_SHADER_IDENTIFIER_SIZE_INVALID = 1199,

		/// <summary/>
		D3D12_MESSAGE_ID_CHECK_DRIVER_MATCHING_IDENTIFIER_INVALID = 1200,

		/// <summary/>
		D3D12_MESSAGE_ID_CHECK_DRIVER_MATCHING_IDENTIFIER_DRIVER_REPORTED_ISSUE = 1201,

		/// <summary/>
		D3D12_MESSAGE_ID_RENDER_PASS_INVALID_RESOURCE_BARRIER = 1202,

		/// <summary/>
		D3D12_MESSAGE_ID_RENDER_PASS_DISALLOWED_API_CALLED = 1203,

		/// <summary/>
		D3D12_MESSAGE_ID_RENDER_PASS_CANNOT_NEST_RENDER_PASSES = 1204,

		/// <summary/>
		D3D12_MESSAGE_ID_RENDER_PASS_CANNOT_END_WITHOUT_BEGIN = 1205,

		/// <summary/>
		D3D12_MESSAGE_ID_RENDER_PASS_CANNOT_CLOSE_COMMAND_LIST = 1206,

		/// <summary/>
		D3D12_MESSAGE_ID_RENDER_PASS_GPU_WORK_WHILE_SUSPENDED = 1207,

		/// <summary/>
		D3D12_MESSAGE_ID_RENDER_PASS_MISMATCHING_SUSPEND_RESUME = 1208,

		/// <summary/>
		D3D12_MESSAGE_ID_RENDER_PASS_NO_PRIOR_SUSPEND_WITHIN_EXECUTECOMMANDLISTS = 1209,

		/// <summary/>
		D3D12_MESSAGE_ID_RENDER_PASS_NO_SUBSEQUENT_RESUME_WITHIN_EXECUTECOMMANDLISTS = 1210,

		/// <summary/>
		D3D12_MESSAGE_ID_TRACKED_WORKLOAD_COMMAND_QUEUE_MISMATCH = 1211,

		/// <summary/>
		D3D12_MESSAGE_ID_TRACKED_WORKLOAD_NOT_SUPPORTED = 1212,

		/// <summary/>
		D3D12_MESSAGE_ID_RENDER_PASS_MISMATCHING_NO_ACCESS = 1213,

		/// <summary/>
		D3D12_MESSAGE_ID_RENDER_PASS_UNSUPPORTED_RESOLVE = 1214,

		/// <summary/>
		D3D12_MESSAGE_ID_CLEARUNORDEREDACCESSVIEW_INVALID_RESOURCE_PTR = 1215,

		/// <summary/>
		D3D12_MESSAGE_ID_WINDOWS7_FENCE_OUTOFORDER_SIGNAL = 1216,

		/// <summary/>
		D3D12_MESSAGE_ID_WINDOWS7_FENCE_OUTOFORDER_WAIT = 1217,

		/// <summary/>
		D3D12_MESSAGE_ID_VIDEO_CREATE_MOTION_ESTIMATOR_INVALID_ARGUMENT = 1218,

		/// <summary/>
		D3D12_MESSAGE_ID_VIDEO_CREATE_MOTION_VECTOR_HEAP_INVALID_ARGUMENT = 1219,

		/// <summary/>
		D3D12_MESSAGE_ID_ESTIMATE_MOTION_INVALID_ARGUMENT = 1220,

		/// <summary/>
		D3D12_MESSAGE_ID_RESOLVE_MOTION_VECTOR_HEAP_INVALID_ARGUMENT = 1221,

		/// <summary/>
		D3D12_MESSAGE_ID_GETGPUVIRTUALADDRESS_INVALID_HEAP_TYPE = 1222,

		/// <summary/>
		D3D12_MESSAGE_ID_SET_BACKGROUND_PROCESSING_MODE_INVALID_ARGUMENT = 1223,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATE_COMMAND_LIST_INVALID_COMMAND_LIST_TYPE_FOR_FEATURE_LEVEL = 1224,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATE_VIDEOEXTENSIONCOMMAND = 1225,

		/// <summary/>
		D3D12_MESSAGE_ID_LIVE_VIDEOEXTENSIONCOMMAND = 1226,

		/// <summary/>
		D3D12_MESSAGE_ID_DESTROY_VIDEOEXTENSIONCOMMAND = 1227,

		/// <summary/>
		D3D12_MESSAGE_ID_INVALID_VIDEO_EXTENSION_COMMAND_ID = 1228,

		/// <summary/>
		D3D12_MESSAGE_ID_VIDEO_EXTENSION_COMMAND_INVALID_ARGUMENT = 1229,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATE_ROOT_SIGNATURE_NOT_UNIQUE_IN_DXIL_LIBRARY = 1230,

		/// <summary/>
		D3D12_MESSAGE_ID_VARIABLE_SHADING_RATE_NOT_ALLOWED_WITH_TIR = 1231,

		/// <summary/>
		D3D12_MESSAGE_ID_GEOMETRY_SHADER_OUTPUTTING_BOTH_VIEWPORT_ARRAY_INDEX_AND_SHADING_RATE_NOT_SUPPORTED_ON_DEVICE = 1232,

		/// <summary/>
		D3D12_MESSAGE_ID_RSSETSHADING_RATE_INVALID_SHADING_RATE = 1233,

		/// <summary/>
		D3D12_MESSAGE_ID_RSSETSHADING_RATE_SHADING_RATE_NOT_PERMITTED_BY_CAP = 1234,

		/// <summary/>
		D3D12_MESSAGE_ID_RSSETSHADING_RATE_INVALID_COMBINER = 1235,

		/// <summary/>
		D3D12_MESSAGE_ID_RSSETSHADINGRATEIMAGE_REQUIRES_TIER_2 = 1236,

		/// <summary/>
		D3D12_MESSAGE_ID_RSSETSHADINGRATE_REQUIRES_TIER_1 = 1237,

		/// <summary/>
		D3D12_MESSAGE_ID_SHADING_RATE_IMAGE_INCORRECT_FORMAT = 1238,

		/// <summary/>
		D3D12_MESSAGE_ID_SHADING_RATE_IMAGE_INCORRECT_ARRAY_SIZE = 1239,

		/// <summary/>
		D3D12_MESSAGE_ID_SHADING_RATE_IMAGE_INCORRECT_MIP_LEVEL = 1240,

		/// <summary/>
		D3D12_MESSAGE_ID_SHADING_RATE_IMAGE_INCORRECT_SAMPLE_COUNT = 1241,

		/// <summary/>
		D3D12_MESSAGE_ID_SHADING_RATE_IMAGE_INCORRECT_SAMPLE_QUALITY = 1242,

		/// <summary/>
		D3D12_MESSAGE_ID_NON_RETAIL_SHADER_MODEL_WONT_VALIDATE = 1243,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_AS_ROOT_SIGNATURE_MISMATCH = 1244,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_MS_ROOT_SIGNATURE_MISMATCH = 1245,

		/// <summary/>
		D3D12_MESSAGE_ID_ADD_TO_STATE_OBJECT_ERROR = 1246,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATE_PROTECTED_RESOURCE_SESSION_INVALID_ARGUMENT = 1247,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_MS_PSO_DESC_MISMATCH = 1248,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEPIPELINESTATE_MS_INCOMPLETE_TYPE = 1249,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_AS_NOT_MS_MISMATCH = 1250,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_MS_NOT_PS_MISMATCH = 1251,

		/// <summary/>
		D3D12_MESSAGE_ID_NONZERO_SAMPLER_FEEDBACK_MIP_REGION_WITH_INCOMPATIBLE_FORMAT = 1252,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_INPUTLAYOUT_SHADER_MISMATCH = 1253,

		/// <summary/>
		D3D12_MESSAGE_ID_EMPTY_DISPATCH = 1254,

		/// <summary/>
		D3D12_MESSAGE_ID_RESOURCE_FORMAT_REQUIRES_SAMPLER_FEEDBACK_CAPABILITY = 1255,

		/// <summary/>
		D3D12_MESSAGE_ID_SAMPLER_FEEDBACK_MAP_INVALID_MIP_REGION = 1256,

		/// <summary/>
		D3D12_MESSAGE_ID_SAMPLER_FEEDBACK_MAP_INVALID_DIMENSION = 1257,

		/// <summary/>
		D3D12_MESSAGE_ID_SAMPLER_FEEDBACK_MAP_INVALID_SAMPLE_COUNT = 1258,

		/// <summary/>
		D3D12_MESSAGE_ID_SAMPLER_FEEDBACK_MAP_INVALID_SAMPLE_QUALITY = 1259,

		/// <summary/>
		D3D12_MESSAGE_ID_SAMPLER_FEEDBACK_MAP_INVALID_LAYOUT = 1260,

		/// <summary/>
		D3D12_MESSAGE_ID_SAMPLER_FEEDBACK_MAP_REQUIRES_UNORDERED_ACCESS_FLAG = 1261,

		/// <summary/>
		D3D12_MESSAGE_ID_SAMPLER_FEEDBACK_CREATE_UAV_NULL_ARGUMENTS = 1262,

		/// <summary/>
		D3D12_MESSAGE_ID_SAMPLER_FEEDBACK_UAV_REQUIRES_SAMPLER_FEEDBACK_CAPABILITY = 1263,

		/// <summary/>
		D3D12_MESSAGE_ID_SAMPLER_FEEDBACK_CREATE_UAV_REQUIRES_FEEDBACK_MAP_FORMAT = 1264,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEMESHSHADER_INVALIDSHADERBYTECODE = 1265,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEMESHSHADER_OUTOFMEMORY = 1266,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEMESHSHADERWITHSTREAMOUTPUT_INVALIDSHADERTYPE = 1267,

		/// <summary/>
		D3D12_MESSAGE_ID_RESOLVESUBRESOURCE_SAMPLER_FEEDBACK_TRANSCODE_INVALID_FORMAT = 1268,

		/// <summary/>
		D3D12_MESSAGE_ID_RESOLVESUBRESOURCE_SAMPLER_FEEDBACK_INVALID_MIP_LEVEL_COUNT = 1269,

		/// <summary/>
		D3D12_MESSAGE_ID_RESOLVESUBRESOURCE_SAMPLER_FEEDBACK_TRANSCODE_ARRAY_SIZE_MISMATCH = 1270,

		/// <summary/>
		D3D12_MESSAGE_ID_SAMPLER_FEEDBACK_CREATE_UAV_MISMATCHING_TARGETED_RESOURCE = 1271,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEMESHSHADER_OUTPUTEXCEEDSMAXSIZE = 1272,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEMESHSHADER_GROUPSHAREDEXCEEDSMAXSIZE = 1273,

		/// <summary/>
		D3D12_MESSAGE_ID_VERTEX_SHADER_OUTPUTTING_BOTH_VIEWPORT_ARRAY_INDEX_AND_SHADING_RATE_NOT_SUPPORTED_ON_DEVICE = 1274,

		/// <summary/>
		D3D12_MESSAGE_ID_MESH_SHADER_OUTPUTTING_BOTH_VIEWPORT_ARRAY_INDEX_AND_SHADING_RATE_NOT_SUPPORTED_ON_DEVICE = 1275,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEMESHSHADER_MISMATCHEDASMSPAYLOADSIZE = 1276,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATE_ROOT_SIGNATURE_UNBOUNDED_STATIC_DESCRIPTORS = 1277,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEAMPLIFICATIONSHADER_INVALIDSHADERBYTECODE = 1278,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEAMPLIFICATIONSHADER_OUTOFMEMORY = 1279,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATE_SHADERCACHESESSION = 1280,

		/// <summary/>
		D3D12_MESSAGE_ID_LIVE_SHADERCACHESESSION = 1281,

		/// <summary/>
		D3D12_MESSAGE_ID_DESTROY_SHADERCACHESESSION = 1282,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATESHADERCACHESESSION_INVALIDARGS = 1283,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATESHADERCACHESESSION_DISABLED = 1284,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATESHADERCACHESESSION_ALREADYOPEN = 1285,

		/// <summary/>
		D3D12_MESSAGE_ID_SHADERCACHECONTROL_DEVELOPERMODE = 1286,

		/// <summary/>
		D3D12_MESSAGE_ID_SHADERCACHECONTROL_INVALIDFLAGS = 1287,

		/// <summary/>
		D3D12_MESSAGE_ID_SHADERCACHECONTROL_STATEALREADYSET = 1288,

		/// <summary/>
		D3D12_MESSAGE_ID_SHADERCACHECONTROL_IGNOREDFLAG = 1289,

		/// <summary/>
		D3D12_MESSAGE_ID_SHADERCACHESESSION_STOREVALUE_ALREADYPRESENT = 1290,

		/// <summary/>
		D3D12_MESSAGE_ID_SHADERCACHESESSION_STOREVALUE_HASHCOLLISION = 1291,

		/// <summary/>
		D3D12_MESSAGE_ID_SHADERCACHESESSION_STOREVALUE_CACHEFULL = 1292,

		/// <summary/>
		D3D12_MESSAGE_ID_SHADERCACHESESSION_FINDVALUE_NOTFOUND = 1293,

		/// <summary/>
		D3D12_MESSAGE_ID_SHADERCACHESESSION_CORRUPT = 1294,

		/// <summary/>
		D3D12_MESSAGE_ID_SHADERCACHESESSION_DISABLED = 1295,

		/// <summary/>
		D3D12_MESSAGE_ID_OVERSIZED_DISPATCH = 1296,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATE_VIDEOENCODER = 1297,

		/// <summary/>
		D3D12_MESSAGE_ID_LIVE_VIDEOENCODER = 1298,

		/// <summary/>
		D3D12_MESSAGE_ID_DESTROY_VIDEOENCODER = 1299,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATE_VIDEOENCODERHEAP = 1300,

		/// <summary/>
		D3D12_MESSAGE_ID_LIVE_VIDEOENCODERHEAP = 1301,

		/// <summary/>
		D3D12_MESSAGE_ID_DESTROY_VIDEOENCODERHEAP = 1302,

		/// <summary/>
		D3D12_MESSAGE_ID_COPYTEXTUREREGION_MISMATCH_ENCODE_REFERENCE_ONLY_FLAG = 1303,

		/// <summary/>
		D3D12_MESSAGE_ID_COPYRESOURCE_MISMATCH_ENCODE_REFERENCE_ONLY_FLAG = 1304,

		/// <summary/>
		D3D12_MESSAGE_ID_ENCODE_FRAME_INVALID_PARAMETERS = 1305,

		/// <summary/>
		D3D12_MESSAGE_ID_ENCODE_FRAME_UNSUPPORTED_PARAMETERS = 1306,

		/// <summary/>
		D3D12_MESSAGE_ID_RESOLVE_ENCODER_OUTPUT_METADATA_INVALID_PARAMETERS = 1307,

		/// <summary/>
		D3D12_MESSAGE_ID_RESOLVE_ENCODER_OUTPUT_METADATA_UNSUPPORTED_PARAMETERS = 1308,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATE_VIDEO_ENCODER_INVALID_PARAMETERS = 1309,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATE_VIDEO_ENCODER_UNSUPPORTED_PARAMETERS = 1310,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATE_VIDEO_ENCODER_HEAP_INVALID_PARAMETERS = 1311,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATE_VIDEO_ENCODER_HEAP_UNSUPPORTED_PARAMETERS = 1312,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATECOMMANDLIST_NULL_COMMANDALLOCATOR = 1313,

		/// <summary/>
		D3D12_MESSAGE_ID_CLEAR_UNORDERED_ACCESS_VIEW_INVALID_DESCRIPTOR_HANDLE = 1314,

		/// <summary/>
		D3D12_MESSAGE_ID_DESCRIPTOR_HEAP_NOT_SHADER_VISIBLE = 1315,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEBLENDSTATE_BLENDOP_WARNING = 1316,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEBLENDSTATE_BLENDOPALPHA_WARNING = 1317,

		/// <summary/>
		D3D12_MESSAGE_ID_WRITE_COMBINE_PERFORMANCE_WARNING = 1318,

		/// <summary/>
		D3D12_MESSAGE_ID_RESOLVE_QUERY_INVALID_QUERY_STATE = 1319,

		/// <summary/>
		D3D12_MESSAGE_ID_SETPRIVATEDATA_NO_ACCESS = 1320,

		/// <summary/>
		D3D12_MESSAGE_ID_COMMAND_LIST_STATIC_DESCRIPTOR_SAMPLER_MODE_MISMATCH = 1321,

		/// <summary/>
		D3D12_MESSAGE_ID_GETCOPYABLEFOOTPRINTS_UNSUPPORTED_BUFFER_WIDTH = 1322,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEMESHSHADER_TOPOLOGY_MISMATCH = 1323,

		/// <summary/>
		D3D12_MESSAGE_ID_VRS_SUM_COMBINER_REQUIRES_CAPABILITY = 1324,

		/// <summary/>
		D3D12_MESSAGE_ID_SETTING_SHADING_RATE_FROM_MS_REQUIRES_CAPABILITY = 1325,

		/// <summary/>
		D3D12_MESSAGE_ID_SHADERCACHESESSION_SHADERCACHEDELETE_NOTSUPPORTED = 1326,

		/// <summary/>
		D3D12_MESSAGE_ID_SHADERCACHECONTROL_SHADERCACHECLEAR_NOTSUPPORTED = 1327,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATERESOURCE_STATE_IGNORED = 1328,

		/// <summary/>
		D3D12_MESSAGE_ID_UNUSED_CROSS_EXECUTE_SPLIT_BARRIER = 1329,

		/// <summary/>
		D3D12_MESSAGE_ID_DEVICE_OPEN_SHARED_HANDLE_ACCESS_DENIED = 1330,

		/// <summary/>
		D3D12_MESSAGE_ID_INCOMPATIBLE_BARRIER_VALUES = 1331,

		/// <summary/>
		D3D12_MESSAGE_ID_INCOMPATIBLE_BARRIER_ACCESS = 1332,

		/// <summary/>
		D3D12_MESSAGE_ID_INCOMPATIBLE_BARRIER_SYNC = 1333,

		/// <summary/>
		D3D12_MESSAGE_ID_INCOMPATIBLE_BARRIER_LAYOUT = 1334,

		/// <summary/>
		D3D12_MESSAGE_ID_INCOMPATIBLE_BARRIER_TYPE = 1335,

		/// <summary/>
		D3D12_MESSAGE_ID_OUT_OF_BOUNDS_BARRIER_SUBRESOURCE_RANGE = 1336,

		/// <summary/>
		D3D12_MESSAGE_ID_INCOMPATIBLE_BARRIER_RESOURCE_DIMENSION = 1337,

		/// <summary/>
		D3D12_MESSAGE_ID_SET_SCISSOR_RECTS_INVALID_RECT = 1338,

		/// <summary/>
		D3D12_MESSAGE_ID_SHADING_RATE_SOURCE_REQUIRES_DIMENSION_TEXTURE2D = 1339,

		/// <summary/>
		D3D12_MESSAGE_ID_BUFFER_BARRIER_SUBREGION_OUT_OF_BOUNDS = 1340,

		/// <summary/>
		D3D12_MESSAGE_ID_UNSUPPORTED_BARRIER_LAYOUT = 1341,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATERESOURCEANDHEAP_INVALID_PARAMETERS = 1342,

		/// <summary/>
		D3D12_MESSAGE_ID_ENHANCED_BARRIERS_NOT_SUPPORTED = 1343,

		/// <summary/>
		D3D12_MESSAGE_ID_LEGACY_BARRIER_VALIDATION_FORCED_ON = 1346,

		/// <summary/>
		D3D12_MESSAGE_ID_EMPTY_ROOT_DESCRIPTOR_TABLE = 1347,

		/// <summary/>
		D3D12_MESSAGE_ID_COMMAND_LIST_DRAW_ELEMENT_OFFSET_UNALIGNED = 1348,

		/// <summary/>
		D3D12_MESSAGE_ID_ALPHA_BLEND_FACTOR_NOT_SUPPORTED = 1349,

		/// <summary/>
		D3D12_MESSAGE_ID_BARRIER_INTEROP_INVALID_LAYOUT = 1350,

		/// <summary/>
		D3D12_MESSAGE_ID_BARRIER_INTEROP_INVALID_STATE = 1351,

		/// <summary/>
		D3D12_MESSAGE_ID_GRAPHICS_PIPELINE_STATE_DESC_ZERO_SAMPLE_MASK = 1352,

		/// <summary/>
		D3D12_MESSAGE_ID_INDEPENDENT_STENCIL_REF_NOT_SUPPORTED = 1353,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_INDEPENDENT_MASKS_UNSUPPORTED = 1354,

		/// <summary/>
		D3D12_MESSAGE_ID_TEXTURE_BARRIER_SUBRESOURCES_OUT_OF_BOUNDS = 1355,

		/// <summary/>
		D3D12_MESSAGE_ID_NON_OPTIMAL_BARRIER_ONLY_EXECUTE_COMMAND_LISTS = 1356,

		/// <summary/>
		D3D12_MESSAGE_ID_EXECUTE_INDIRECT_ZERO_COMMAND_COUNT = 1357,

		/// <summary/>
		D3D12_MESSAGE_ID_GPU_BASED_VALIDATION_INCOMPATIBLE_TEXTURE_LAYOUT = 1358,

		/// <summary/>
		D3D12_MESSAGE_ID_DYNAMIC_INDEX_BUFFER_STRIP_CUT_NOT_SUPPORTED = 1359,

		/// <summary/>
		D3D12_MESSAGE_ID_PRIMITIVE_TOPOLOGY_TRIANGLE_FANS_NOT_SUPPORTED = 1360,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATE_SAMPLER_COMPARISON_FUNC_IGNORED = 1361,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEHEAP_INVALIDHEAPTYPE = 1362,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATERESOURCEANDHEAP_INVALIDHEAPTYPE = 1363,

		/// <summary/>
		D3D12_MESSAGE_ID_DYNAMIC_DEPTH_BIAS_NOT_SUPPORTED = 1364,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATERASTERIZERSTATE_NON_WHOLE_DYNAMIC_DEPTH_BIAS = 1365,

		/// <summary/>
		D3D12_MESSAGE_ID_DYNAMIC_DEPTH_BIAS_FLAG_MISSING = 1366,

		/// <summary/>
		D3D12_MESSAGE_ID_DYNAMIC_DEPTH_BIAS_NO_PIPELINE = 1367,

		/// <summary/>
		D3D12_MESSAGE_ID_DYNAMIC_INDEX_BUFFER_STRIP_CUT_FLAG_MISSING = 1368,

		/// <summary/>
		D3D12_MESSAGE_ID_DYNAMIC_INDEX_BUFFER_STRIP_CUT_NO_PIPELINE = 1369,

		/// <summary/>
		D3D12_MESSAGE_ID_NONNORMALIZED_COORDINATE_SAMPLING_NOT_SUPPORTED = 1370,

		/// <summary/>
		D3D12_MESSAGE_ID_INVALID_CAST_TARGET = 1371,

		/// <summary/>
		D3D12_MESSAGE_ID_RENDER_PASS_COMMANDLIST_INVALID_END_STATE = 1372,

		/// <summary/>
		D3D12_MESSAGE_ID_RENDER_PASS_COMMANDLIST_INVALID_START_STATE = 1373,

		/// <summary/>
		D3D12_MESSAGE_ID_RENDER_PASS_MISMATCHING_ACCESS = 1374,

		/// <summary/>
		D3D12_MESSAGE_ID_RENDER_PASS_MISMATCHING_LOCAL_PRESERVE_PARAMETERS = 1375,

		/// <summary/>
		D3D12_MESSAGE_ID_RENDER_PASS_LOCAL_PRESERVE_RENDER_PARAMETERS_ERROR = 1376,

		/// <summary/>
		D3D12_MESSAGE_ID_RENDER_PASS_LOCAL_DEPTH_STENCIL_ERROR = 1377,

		/// <summary/>
		D3D12_MESSAGE_ID_DRAW_POTENTIALLY_OUTSIDE_OF_VALID_RENDER_AREA = 1378,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATERASTERIZERSTATE_INVALID_LINERASTERIZATIONMODE = 1379,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATERESOURCE_INVALIDALIGNMENT_SMALLRESOURCE = 1380,

		/// <summary/>
		D3D12_MESSAGE_ID_GENERIC_DEVICE_OPERATION_UNSUPPORTED = 1381,

		/// <summary/>
		D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_RENDER_TARGET_WRONG_WRITE_MASK = 1382,

		/// <summary/>
		D3D12_MESSAGE_ID_PROBABLE_PIX_EVENT_LEAK = 1383,

		/// <summary/>
		D3D12_MESSAGE_ID_PIX_EVENT_UNDERFLOW = 1384,

		/// <summary/>
		D3D12_MESSAGE_ID_RECREATEAT_INVALID_TARGET = 1385,

		/// <summary/>
		D3D12_MESSAGE_ID_RECREATEAT_INSUFFICIENT_SUPPORT = 1386,

		/// <summary/>
		D3D12_MESSAGE_ID_GPU_BASED_VALIDATION_STRUCTURED_BUFFER_STRIDE_MISMATCH = 1387,
	}

	/// <summary>Debug message severity levels for an information queue.</summary>
	/// <remarks>
	/// Use these values to allow or deny message categories to pass through the storage and retrieval filters for an information queue (see
	/// <c>D3D12_INFO_QUEUE_FILTER</c>). This API is used by <c>AddApplicationMessage</c> and <c>AddMessage</c>.
	/// </remarks>
	// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/ne-d3d12sdklayers-d3d12_message_severity typedef enum
	// D3D12_MESSAGE_SEVERITY { D3D12_MESSAGE_SEVERITY_CORRUPTION = 0, D3D12_MESSAGE_SEVERITY_ERROR, D3D12_MESSAGE_SEVERITY_WARNING,
	// D3D12_MESSAGE_SEVERITY_INFO, D3D12_MESSAGE_SEVERITY_MESSAGE } ;
	[PInvokeData("d3d12sdklayers.h", MSDNShortId = "NE:d3d12sdklayers.D3D12_MESSAGE_SEVERITY")]
	public enum D3D12_MESSAGE_SEVERITY
	{
		/// <summary>
		/// <para>Value: 0 Indicates a corruption error.</para>
		/// </summary>
		D3D12_MESSAGE_SEVERITY_CORRUPTION,

		/// <summary>Indicates an error.</summary>
		D3D12_MESSAGE_SEVERITY_ERROR,

		/// <summary>Indicates a warning.</summary>
		D3D12_MESSAGE_SEVERITY_WARNING,

		/// <summary>Indicates an information message.</summary>
		D3D12_MESSAGE_SEVERITY_INFO,

		/// <summary>Indicates a message other than corruption, error, warning or information.</summary>
		D3D12_MESSAGE_SEVERITY_MESSAGE,
	}

	/// <summary>Specifies options for the amount of information to report about a live device object's lifetime.</summary>
	/// <remarks>This enumeration is used by <c>ID3D12DebugDevice::ReportLiveDeviceObjects</c>.</remarks>
	// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/ne-d3d12sdklayers-d3d12_rldo_flags typedef enum D3D12_RLDO_FLAGS {
	// D3D12_RLDO_NONE = 0, D3D12_RLDO_SUMMARY = 0x1, D3D12_RLDO_DETAIL = 0x2, D3D12_RLDO_IGNORE_INTERNAL = 0x4 } ;
	[PInvokeData("d3d12sdklayers.h", MSDNShortId = "NE:d3d12sdklayers.D3D12_RLDO_FLAGS")]
	[Flags]
	public enum D3D12_RLDO_FLAGS
	{
		/// <summary>
		/// <para>Value:</para>
		/// <para>0</para>
		/// </summary>
		D3D12_RLDO_NONE = 0x0,

		/// <summary>
		/// <para>Value: 0x1 Obtain a summary about a live device object's lifetime.</para>
		/// </summary>
		D3D12_RLDO_SUMMARY = 0x1,

		/// <summary>
		/// <para>Value: 0x2 Obtain detailed information about a live device object's lifetime.</para>
		/// </summary>
		D3D12_RLDO_DETAIL = 0x2,

		/// <summary>
		/// <para>Value: 0x4 
		/// This flag indicates to ignore objects which have no external refcounts keeping them alive. D3D objects are printed using an
		/// external refcount and an internal refcount. Typically, all objects are printed. This flag means ignore the objects whose
		/// external refcount is 0, because the application is not responsible for keeping them alive.
		/// </para>
		/// </summary>
		D3D12_RLDO_IGNORE_INTERNAL = 0x4,
	}

	/// <summary>An interface used to turn on the debug layer. See <c>EnableDebugLayer</c> for more information.</summary>
	/// <remarks>This interface is obtained by querying it from <c>D3D12GetDebugInterface</c>.</remarks>
	// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nn-d3d12sdklayers-id3d12debug
	[PInvokeData("d3d12sdklayers.h", MSDNShortId = "NN:d3d12sdklayers.ID3D12Debug")]
	[ComImport, Guid("344488b7-6846-474b-b989-f027448245e0"), InterfaceType(ComInterfaceType.InterfaceIsIUnknown), CoClass(typeof(D3D12Debug))]
	public interface ID3D12Debug
	{
		/// <summary>Enables the debug layer.</summary>
		/// <returns>None</returns>
		/// <remarks>
		/// To enable the debug layers using this API, it must be called before the D3D12 device is created. Calling this API after creating
		/// the D3D12 device will cause the D3D12 runtime to remove the device.
		/// </remarks>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nf-d3d12sdklayers-id3d12debug-enabledebuglayer void EnableDebugLayer();
		[PreserveSig]
		void EnableDebugLayer();
	}

	/// <summary>Adds GPU-Based Validation and Dependent Command Queue Synchronization to the debug layer.</summary>
	/// <remarks>This interface is currently in Preview mode.</remarks>
	// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nn-d3d12sdklayers-id3d12debug1
	[PInvokeData("d3d12sdklayers.h", MSDNShortId = "NN:d3d12sdklayers.ID3D12Debug1")]
	[ComImport, Guid("affaa4ca-63fe-4d8e-b8ad-159000af4304"), InterfaceType(ComInterfaceType.InterfaceIsIUnknown)]
	public interface ID3D12Debug1
	{
		/// <summary>Enables the debug layer.</summary>
		/// <returns>None</returns>
		/// <remarks>This method is identical to <c>ID3D12Debug::EnableDebugLayer</c>.</remarks>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nf-d3d12sdklayers-id3d12debug1-enabledebuglayer void EnableDebugLayer();
		[PreserveSig]
		void EnableDebugLayer();

		/// <summary>This method enables or disables GPU-Based Validation (GBV) before creating a device with the debug layer enabled.</summary>
		/// <param name="Enable">
		/// <para>Type: <b>BOOL</b></para>
		/// <para>TRUE to enable GPU-Based Validation, otherwise FALSE.</para>
		/// </param>
		/// <returns>None</returns>
		/// <remarks>
		/// <para>
		/// GPU-Based Validation can only be enabled/disabled prior to creating a device. By default, GPU-Based Validation is disabled. To
		/// disable GPU-Based Validation after initially enabling it the device must be fully released and recreated; disabling or enabling
		/// it after device creation will cause device removal.
		/// </para>
		/// <para>For more information, see <c>Using D3D12 Debug Layer GPU-Based Validation</c>.</para>
		/// </remarks>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nf-d3d12sdklayers-id3d12debug1-setenablegpubasedvalidation
		// void SetEnableGPUBasedValidation( BOOL Enable );
		[PreserveSig]
		void SetEnableGPUBasedValidation(bool Enable);

		/// <summary>Enables or disables dependent command queue synchronization when using a D3D12 device with the debug layer enabled.</summary>
		/// <param name="Enable">
		/// <para>Type: <b>BOOL</b></para>
		/// <para>TRUE to enable Dependent Command Queue Synchronization, otherwise FALSE.</para>
		/// </param>
		/// <returns>None</returns>
		/// <remarks>
		/// <para>
		/// Dependent Command Queue Synchronization is a D3D12 Debug Layer feature that gives the debug layer the ability to track resource
		/// states more accurately when enabled. Dependent Command Queue Synchronization is enabled by default.
		/// </para>
		/// <para>
		/// When Dependent Command Queue Synchronization is enabled, the debug layer holds back actual submission of GPU work until all
		/// outstanding fence <c>Wait</c> conditions are met. This gives the debug layer the ability to make reasonable assumptions about
		/// GPU state (such as resource states) on the CPU-timeline when multiple command queues are potentially doing concurrent work.
		/// </para>
		/// <para>
		/// With Dependent Command Queue Synchronization disabled, all resource states tracked by the debug layer are cleared each time
		/// <c>ID3D12CommandQueue::Signal</c> is called. This results in significantly less useful resource state validation.
		/// </para>
		/// <para>
		/// Disabling Dependent Command Queue Synchronization may reduce some debug layer performance overhead when using multiple command
		/// queues. However, it is suggested to leave it enabled unless this overhead is problematic. Note that applications that use only a
		/// single command queue will see no performance changes with Dependent Command Queue Synchronization disabled.
		/// </para>
		/// </remarks>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nf-d3d12sdklayers-id3d12debug1-setenablesynchronizedcommandqueuevalidation
		// void SetEnableSynchronizedCommandQueueValidation( BOOL Enable );
		[PreserveSig]
		void SetEnableSynchronizedCommandQueueValidation(bool Enable);
	}

	/// <summary>Adds configurable levels of GPU-based validation to the debug layer.</summary>
	// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nn-d3d12sdklayers-id3d12debug2
	[PInvokeData("d3d12sdklayers.h", MSDNShortId = "NN:d3d12sdklayers.ID3D12Debug2")]
	[ComImport, Guid("93a665c4-a3b2-4e5d-b692-a26ae14e3374"), InterfaceType(ComInterfaceType.InterfaceIsIUnknown)]
	public interface ID3D12Debug2
	{
		/// <summary>This method configures the level of GPU-based validation that the debug device is to perform at runtime.</summary>
		/// <param name="Flags">
		/// <para>Type: <b><c>D3D12_GPU_BASED_VALIDATION_FLAGS</c></b></para>
		/// <para>Specifies the level of GPU-based validation to perform at runtime.</para>
		/// </param>
		/// <returns>None</returns>
		/// <remarks>
		/// This method overrides the default behavior of GPU-based validation so it must be called before creating the Direct3D 12 device.
		/// These settings can't be changed or cancelled after the device is created. If you want to change the behavior of GPU-based
		/// validation at a later time, the device must be destroyed and recreated with different parameters.
		/// </remarks>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nf-d3d12sdklayers-id3d12debug2-setgpubasedvalidationflags void
		// SetGPUBasedValidationFlags( D3D12_GPU_BASED_VALIDATION_FLAGS Flags );
		[PreserveSig]
		void SetGPUBasedValidationFlags(D3D12_GPU_BASED_VALIDATION_FLAGS Flags);
	}

	/// <summary>Adds configurable levels of GPU-based validation to the debug layer.</summary>
	// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nn-d3d12sdklayers-id3d12debug3
	[PInvokeData("d3d12sdklayers.h", MSDNShortId = "NN:d3d12sdklayers.ID3D12Debug3")]
	[ComImport, Guid("5cf4e58f-f671-4ff1-a542-3686e3d153d1"), InterfaceType(ComInterfaceType.InterfaceIsIUnknown)]
	public interface ID3D12Debug3 : ID3D12Debug
	{
		/// <summary>Enables the debug layer.</summary>
		/// <returns>None</returns>
		/// <remarks>
		/// To enable the debug layers using this API, it must be called before the D3D12 device is created. Calling this API after creating
		/// the D3D12 device will cause the D3D12 runtime to remove the device.
		/// </remarks>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nf-d3d12sdklayers-id3d12debug-enabledebuglayer void EnableDebugLayer();
		[PreserveSig]
		new void EnableDebugLayer();

		/// <summary>This method enables or disables GPU-based validation (GBV) before creating a device with the debug layer enabled.</summary>
		/// <param name="Enable">
		/// <para>Type: <b>BOOL</b></para>
		/// <para>TRUE to enable GPU-based validation, otherwise FALSE.</para>
		/// </param>
		/// <returns>None</returns>
		/// <remarks>
		/// <para>
		/// GPU-based validation can be enabled/disabled only prior to creating a device. By default, GPU-based validation is disabled. To
		/// disable GPU-based validation after initially enabling it, the device must be fully released and recreated.
		/// </para>
		/// <para>For more information, see <c>Using D3D12 Debug Layer GPU-based validation</c>.</para>
		/// </remarks>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nf-d3d12sdklayers-id3d12debug3-setenablegpubasedvalidation
		// void SetEnableGPUBasedValidation( BOOL Enable );
		[PreserveSig]
		void SetEnableGPUBasedValidation(bool Enable);

		/// <summary>
		/// Enables or disables dependent command queue synchronization when using a Direct3D 12 device with the debug layer enabled.
		/// </summary>
		/// <param name="Enable">
		/// <para>Type: <b>BOOL</b></para>
		/// <para>TRUE to enable Dependent Command Queue Synchronization, otherwise FALSE.</para>
		/// </param>
		/// <returns>None</returns>
		/// <remarks>
		/// <para>
		/// Dependent Command Queue Synchronization is a D3D12 Debug Layer feature that gives the debug layer the ability to track resource
		/// states more accurately when enabled. Dependent Command Queue Synchronization is enabled by default.
		/// </para>
		/// <para>
		/// When Dependent Command Queue Synchronization is enabled, the debug layer holds back actual submission of GPU work until all
		/// outstanding fence <c>Wait</c> conditions are met. This gives the debug layer the ability to make reasonable assumptions about
		/// GPU state (such as resource states) on the CPU-timeline when multiple command queues are potentially doing concurrent work.
		/// </para>
		/// <para>
		/// With Dependent Command Queue Synchronization disabled, all resource states tracked by the debug layer are cleared each time
		/// <c>ID3D12CommandQueue::Signal</c> is called. This results in significantly less useful resource state validation.
		/// </para>
		/// <para>
		/// Disabling Dependent Command Queue Synchronization may reduce some debug layer performance overhead when using multiple command
		/// queues. However, it is suggested to leave it enabled unless this overhead is problematic. Note that applications that use only a
		/// single command queue will see no performance changes with Dependent Command Queue Synchronization disabled.
		/// </para>
		/// </remarks>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nf-d3d12sdklayers-id3d12debug3-setenablesynchronizedcommandqueuevalidation
		// void SetEnableSynchronizedCommandQueueValidation( BOOL Enable );
		[PreserveSig]
		void SetEnableSynchronizedCommandQueueValidation(bool Enable);

		/// <summary>This method configures the level of GPU-based validation that the debug device is to perform at runtime.</summary>
		/// <param name="Flags">
		/// <para>Type: <b><c>D3D12_GPU_BASED_VALIDATION_FLAGS</c></b></para>
		/// <para>Specifies the level of GPU-based validation to perform at runtime.</para>
		/// </param>
		/// <returns>None</returns>
		/// <remarks>
		/// This method overrides the default behavior of GPU-based validation so it must be called before creating the D3D12 Device. These
		/// settings can't be changed or cancelled after the device is created. If you want to change the behavior of GPU-based validation
		/// at a later time, the device must be destroyed and recreated with different parameters.
		/// </remarks>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nf-d3d12sdklayers-id3d12debug3-setgpubasedvalidationflags void
		// SetGPUBasedValidationFlags( D3D12_GPU_BASED_VALIDATION_FLAGS Flags );
		[PreserveSig]
		void SetGPUBasedValidationFlags(D3D12_GPU_BASED_VALIDATION_FLAGS Flags);
	}

	/// <summary>Adds the ability to disable the debug layer.</summary>
	// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nn-d3d12sdklayers-id3d12debug4
	[PInvokeData("d3d12sdklayers.h", MSDNShortId = "NN:d3d12sdklayers.ID3D12Debug4")]
	[ComImport, Guid("014b816e-9ec5-4a2f-a845-ffbe441ce13a"), InterfaceType(ComInterfaceType.InterfaceIsIUnknown)]
	public interface ID3D12Debug4 : ID3D12Debug3
	{
		/// <summary>Enables the debug layer.</summary>
		/// <returns>None</returns>
		/// <remarks>
		/// To enable the debug layers using this API, it must be called before the D3D12 device is created. Calling this API after creating
		/// the D3D12 device will cause the D3D12 runtime to remove the device.
		/// </remarks>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nf-d3d12sdklayers-id3d12debug-enabledebuglayer void EnableDebugLayer();
		[PreserveSig]
		new void EnableDebugLayer();

		/// <summary>This method enables or disables GPU-based validation (GBV) before creating a device with the debug layer enabled.</summary>
		/// <param name="Enable">
		/// <para>Type: <b>BOOL</b></para>
		/// <para>TRUE to enable GPU-based validation, otherwise FALSE.</para>
		/// </param>
		/// <returns>None</returns>
		/// <remarks>
		/// <para>
		/// GPU-based validation can be enabled/disabled only prior to creating a device. By default, GPU-based validation is disabled. To
		/// disable GPU-based validation after initially enabling it, the device must be fully released and recreated.
		/// </para>
		/// <para>For more information, see <c>Using D3D12 Debug Layer GPU-based validation</c>.</para>
		/// </remarks>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nf-d3d12sdklayers-id3d12debug3-setenablegpubasedvalidation
		// void SetEnableGPUBasedValidation( BOOL Enable );
		[PreserveSig]
		new void SetEnableGPUBasedValidation(bool Enable);

		/// <summary>
		/// Enables or disables dependent command queue synchronization when using a Direct3D 12 device with the debug layer enabled.
		/// </summary>
		/// <param name="Enable">
		/// <para>Type: <b>BOOL</b></para>
		/// <para>TRUE to enable Dependent Command Queue Synchronization, otherwise FALSE.</para>
		/// </param>
		/// <returns>None</returns>
		/// <remarks>
		/// <para>
		/// Dependent Command Queue Synchronization is a D3D12 Debug Layer feature that gives the debug layer the ability to track resource
		/// states more accurately when enabled. Dependent Command Queue Synchronization is enabled by default.
		/// </para>
		/// <para>
		/// When Dependent Command Queue Synchronization is enabled, the debug layer holds back actual submission of GPU work until all
		/// outstanding fence <c>Wait</c> conditions are met. This gives the debug layer the ability to make reasonable assumptions about
		/// GPU state (such as resource states) on the CPU-timeline when multiple command queues are potentially doing concurrent work.
		/// </para>
		/// <para>
		/// With Dependent Command Queue Synchronization disabled, all resource states tracked by the debug layer are cleared each time
		/// <c>ID3D12CommandQueue::Signal</c> is called. This results in significantly less useful resource state validation.
		/// </para>
		/// <para>
		/// Disabling Dependent Command Queue Synchronization may reduce some debug layer performance overhead when using multiple command
		/// queues. However, it is suggested to leave it enabled unless this overhead is problematic. Note that applications that use only a
		/// single command queue will see no performance changes with Dependent Command Queue Synchronization disabled.
		/// </para>
		/// </remarks>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nf-d3d12sdklayers-id3d12debug3-setenablesynchronizedcommandqueuevalidation
		// void SetEnableSynchronizedCommandQueueValidation( BOOL Enable );
		[PreserveSig]
		new void SetEnableSynchronizedCommandQueueValidation(bool Enable);

		/// <summary>This method configures the level of GPU-based validation that the debug device is to perform at runtime.</summary>
		/// <param name="Flags">
		/// <para>Type: <b><c>D3D12_GPU_BASED_VALIDATION_FLAGS</c></b></para>
		/// <para>Specifies the level of GPU-based validation to perform at runtime.</para>
		/// </param>
		/// <returns>None</returns>
		/// <remarks>
		/// This method overrides the default behavior of GPU-based validation so it must be called before creating the D3D12 Device. These
		/// settings can't be changed or cancelled after the device is created. If you want to change the behavior of GPU-based validation
		/// at a later time, the device must be destroyed and recreated with different parameters.
		/// </remarks>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nf-d3d12sdklayers-id3d12debug3-setgpubasedvalidationflags void
		// SetGPUBasedValidationFlags( D3D12_GPU_BASED_VALIDATION_FLAGS Flags );
		[PreserveSig]
		new void SetGPUBasedValidationFlags(D3D12_GPU_BASED_VALIDATION_FLAGS Flags);

		/// <summary>
		/// <para>Disables the debug layer.</para>
		/// <para>
		/// <b>DisableDebugLayer</b> takes effect only when all <c><b>ID3D12Device</b></c> objects (for a given adapter) have been released.
		/// See <b>Remarks</b> for <c>D3D12CreateDevice</c>.
		/// </para>
		/// </summary>
		/// <returns>None</returns>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nf-d3d12sdklayers-id3d12debug4-disabledebuglayer void DisableDebugLayer();
		[PreserveSig]
		void DisableDebugLayer();
	}

	/// <summary>Adds to the debug layer the ability to configure the auto-naming of objects.</summary>
	// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nn-d3d12sdklayers-id3d12debug5
	[PInvokeData("d3d12sdklayers.h", MSDNShortId = "NN:d3d12sdklayers.ID3D12Debug5")]
	[ComImport, Guid("548d6b12-09fa-40e0-9069-5dcd589a52c9"), InterfaceType(ComInterfaceType.InterfaceIsIUnknown)]
	public interface ID3D12Debug5 : ID3D12Debug4
	{
		/// <summary>Enables the debug layer.</summary>
		/// <returns>None</returns>
		/// <remarks>
		/// To enable the debug layers using this API, it must be called before the D3D12 device is created. Calling this API after creating
		/// the D3D12 device will cause the D3D12 runtime to remove the device.
		/// </remarks>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nf-d3d12sdklayers-id3d12debug-enabledebuglayer void EnableDebugLayer();
		[PreserveSig]
		new void EnableDebugLayer();

		/// <summary>This method enables or disables GPU-based validation (GBV) before creating a device with the debug layer enabled.</summary>
		/// <param name="Enable">
		/// <para>Type: <b>BOOL</b></para>
		/// <para>TRUE to enable GPU-based validation, otherwise FALSE.</para>
		/// </param>
		/// <returns>None</returns>
		/// <remarks>
		/// <para>
		/// GPU-based validation can be enabled/disabled only prior to creating a device. By default, GPU-based validation is disabled. To
		/// disable GPU-based validation after initially enabling it, the device must be fully released and recreated.
		/// </para>
		/// <para>For more information, see <c>Using D3D12 Debug Layer GPU-based validation</c>.</para>
		/// </remarks>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nf-d3d12sdklayers-id3d12debug3-setenablegpubasedvalidation
		// void SetEnableGPUBasedValidation( BOOL Enable );
		[PreserveSig]
		new void SetEnableGPUBasedValidation(bool Enable);

		/// <summary>
		/// Enables or disables dependent command queue synchronization when using a Direct3D 12 device with the debug layer enabled.
		/// </summary>
		/// <param name="Enable">
		/// <para>Type: <b>BOOL</b></para>
		/// <para>TRUE to enable Dependent Command Queue Synchronization, otherwise FALSE.</para>
		/// </param>
		/// <returns>None</returns>
		/// <remarks>
		/// <para>
		/// Dependent Command Queue Synchronization is a D3D12 Debug Layer feature that gives the debug layer the ability to track resource
		/// states more accurately when enabled. Dependent Command Queue Synchronization is enabled by default.
		/// </para>
		/// <para>
		/// When Dependent Command Queue Synchronization is enabled, the debug layer holds back actual submission of GPU work until all
		/// outstanding fence <c>Wait</c> conditions are met. This gives the debug layer the ability to make reasonable assumptions about
		/// GPU state (such as resource states) on the CPU-timeline when multiple command queues are potentially doing concurrent work.
		/// </para>
		/// <para>
		/// With Dependent Command Queue Synchronization disabled, all resource states tracked by the debug layer are cleared each time
		/// <c>ID3D12CommandQueue::Signal</c> is called. This results in significantly less useful resource state validation.
		/// </para>
		/// <para>
		/// Disabling Dependent Command Queue Synchronization may reduce some debug layer performance overhead when using multiple command
		/// queues. However, it is suggested to leave it enabled unless this overhead is problematic. Note that applications that use only a
		/// single command queue will see no performance changes with Dependent Command Queue Synchronization disabled.
		/// </para>
		/// </remarks>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nf-d3d12sdklayers-id3d12debug3-setenablesynchronizedcommandqueuevalidation
		// void SetEnableSynchronizedCommandQueueValidation( BOOL Enable );
		[PreserveSig]
		new void SetEnableSynchronizedCommandQueueValidation(bool Enable);

		/// <summary>This method configures the level of GPU-based validation that the debug device is to perform at runtime.</summary>
		/// <param name="Flags">
		/// <para>Type: <b><c>D3D12_GPU_BASED_VALIDATION_FLAGS</c></b></para>
		/// <para>Specifies the level of GPU-based validation to perform at runtime.</para>
		/// </param>
		/// <returns>None</returns>
		/// <remarks>
		/// This method overrides the default behavior of GPU-based validation so it must be called before creating the D3D12 Device. These
		/// settings can't be changed or cancelled after the device is created. If you want to change the behavior of GPU-based validation
		/// at a later time, the device must be destroyed and recreated with different parameters.
		/// </remarks>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nf-d3d12sdklayers-id3d12debug3-setgpubasedvalidationflags void
		// SetGPUBasedValidationFlags( D3D12_GPU_BASED_VALIDATION_FLAGS Flags );
		[PreserveSig]
		new void SetGPUBasedValidationFlags(D3D12_GPU_BASED_VALIDATION_FLAGS Flags);

		/// <summary>
		/// <para>Disables the debug layer.</para>
		/// <para>
		/// <b>DisableDebugLayer</b> takes effect only when all <c><b>ID3D12Device</b></c> objects (for a given adapter) have been released.
		/// See <b>Remarks</b> for <c>D3D12CreateDevice</c>.
		/// </para>
		/// </summary>
		/// <returns>None</returns>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nf-d3d12sdklayers-id3d12debug4-disabledebuglayer void DisableDebugLayer();
		[PreserveSig]
		new void DisableDebugLayer();

		/// <summary>Configures the auto-naming of objects.</summary>
		/// <param name="Enable">
		/// Type: <b><c>BOOL</c></b>
		/// <para><see langword="true"/> to enable auto-naming; <c>false</c> to disable auto-naming.</para>
		/// </param>
		/// <returns>None</returns>
		/// <remarks>
		/// <para>
		/// By default, objects are not named unless you use <c>ID3D12Object::SetName</c> or <c>ID3D12Object::SetPrivateData</c> to assign a name.
		/// </para>
		/// <para>
		/// It's a best practice to name all of your Direct3D 12 objects; at least in debug builds. Failing that, you might find it
		/// convenient to allow automatic name assignment in order to cover the gaps. Direct3D 12 objects created with auto-name enabled are
		/// automatically assigned a name, which is used for debug layer output and for DRED page fault data.
		/// </para>
		/// <para>
		/// So as not to create a dependency on a specific auto-naming format, you can't retrieve the auto-name strings by using
		/// ID3D12Object::GetName or <c>ID3D12Object::GetPrivateData</c>. But, to generate a unique name string, Direct3D 12 uses the
		/// locally-unique identifier (LUID) assigned to every <b>ID3D12DeviceChild</b> object at create time. You can retrieve that LUID by
		/// using <b>ID3D12Object::GetPrivateData</b> with the <b>REFGUID</b> value WKPDID_D3D12UniqueObjectId. You might find that useful
		/// for your own object-naming schemas.
		/// </para>
		/// <para>
		/// When debugging existing software, you can control auto-naming by using the D3DConfig graphics tools utility and the command
		/// <c>d3dconfig.exe device auto-debug-name=forced-on</c>.
		/// </para>
		/// <para>
		/// Any object given a name using <c>ID3D12Object::SetName</c> or <c>ID3D12Object::SetPrivateData</c> uses the assigned name instead
		/// of the auto-name.
		/// </para>
		/// </remarks>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nf-d3d12sdklayers-id3d12debug5-setenableautoname void
		// SetEnableAutoName( BOOL Enable );
		[PreserveSig]
		void SetEnableAutoName(bool Enable);
	}

	/// <summary>
	/// <para>A debug interface controls debug settings.</para>
	/// <para>Requires the DirectX 12 Agility SDK 1.7 or later.</para>
	/// </summary>
	// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nn-d3d12sdklayers-id3d12debug6
	[PInvokeData("d3d12sdklayers.h", MSDNShortId = "NN:d3d12sdklayers.ID3D12Debug6")]
	[ComImport, Guid("82a816d6-5d01-4157-97d0-4975463fd1ed"), InterfaceType(ComInterfaceType.InterfaceIsIUnknown)]
	public interface ID3D12Debug6 : ID3D12Debug5
	{
		/// <summary>Enables the debug layer.</summary>
		/// <returns>None</returns>
		/// <remarks>
		/// To enable the debug layers using this API, it must be called before the D3D12 device is created. Calling this API after creating
		/// the D3D12 device will cause the D3D12 runtime to remove the device.
		/// </remarks>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nf-d3d12sdklayers-id3d12debug-enabledebuglayer void EnableDebugLayer();
		[PreserveSig]
		new void EnableDebugLayer();

		/// <summary>This method enables or disables GPU-based validation (GBV) before creating a device with the debug layer enabled.</summary>
		/// <param name="Enable">
		/// <para>Type: <b>BOOL</b></para>
		/// <para>TRUE to enable GPU-based validation, otherwise FALSE.</para>
		/// </param>
		/// <returns>None</returns>
		/// <remarks>
		/// <para>
		/// GPU-based validation can be enabled/disabled only prior to creating a device. By default, GPU-based validation is disabled. To
		/// disable GPU-based validation after initially enabling it, the device must be fully released and recreated.
		/// </para>
		/// <para>For more information, see <c>Using D3D12 Debug Layer GPU-based validation</c>.</para>
		/// </remarks>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nf-d3d12sdklayers-id3d12debug3-setenablegpubasedvalidation
		// void SetEnableGPUBasedValidation( BOOL Enable );
		[PreserveSig]
		new void SetEnableGPUBasedValidation(bool Enable);

		/// <summary>
		/// Enables or disables dependent command queue synchronization when using a Direct3D 12 device with the debug layer enabled.
		/// </summary>
		/// <param name="Enable">
		/// <para>Type: <b>BOOL</b></para>
		/// <para>TRUE to enable Dependent Command Queue Synchronization, otherwise FALSE.</para>
		/// </param>
		/// <returns>None</returns>
		/// <remarks>
		/// <para>
		/// Dependent Command Queue Synchronization is a D3D12 Debug Layer feature that gives the debug layer the ability to track resource
		/// states more accurately when enabled. Dependent Command Queue Synchronization is enabled by default.
		/// </para>
		/// <para>
		/// When Dependent Command Queue Synchronization is enabled, the debug layer holds back actual submission of GPU work until all
		/// outstanding fence <c>Wait</c> conditions are met. This gives the debug layer the ability to make reasonable assumptions about
		/// GPU state (such as resource states) on the CPU-timeline when multiple command queues are potentially doing concurrent work.
		/// </para>
		/// <para>
		/// With Dependent Command Queue Synchronization disabled, all resource states tracked by the debug layer are cleared each time
		/// <c>ID3D12CommandQueue::Signal</c> is called. This results in significantly less useful resource state validation.
		/// </para>
		/// <para>
		/// Disabling Dependent Command Queue Synchronization may reduce some debug layer performance overhead when using multiple command
		/// queues. However, it is suggested to leave it enabled unless this overhead is problematic. Note that applications that use only a
		/// single command queue will see no performance changes with Dependent Command Queue Synchronization disabled.
		/// </para>
		/// </remarks>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nf-d3d12sdklayers-id3d12debug3-setenablesynchronizedcommandqueuevalidation
		// void SetEnableSynchronizedCommandQueueValidation( BOOL Enable );
		[PreserveSig]
		new void SetEnableSynchronizedCommandQueueValidation(bool Enable);

		/// <summary>This method configures the level of GPU-based validation that the debug device is to perform at runtime.</summary>
		/// <param name="Flags">
		/// <para>Type: <b><c>D3D12_GPU_BASED_VALIDATION_FLAGS</c></b></para>
		/// <para>Specifies the level of GPU-based validation to perform at runtime.</para>
		/// </param>
		/// <returns>None</returns>
		/// <remarks>
		/// This method overrides the default behavior of GPU-based validation so it must be called before creating the D3D12 Device. These
		/// settings can't be changed or cancelled after the device is created. If you want to change the behavior of GPU-based validation
		/// at a later time, the device must be destroyed and recreated with different parameters.
		/// </remarks>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nf-d3d12sdklayers-id3d12debug3-setgpubasedvalidationflags void
		// SetGPUBasedValidationFlags( D3D12_GPU_BASED_VALIDATION_FLAGS Flags );
		[PreserveSig]
		new void SetGPUBasedValidationFlags(D3D12_GPU_BASED_VALIDATION_FLAGS Flags);

		/// <summary>
		/// <para>Disables the debug layer.</para>
		/// <para>
		/// <b>DisableDebugLayer</b> takes effect only when all <c><b>ID3D12Device</b></c> objects (for a given adapter) have been released.
		/// See <b>Remarks</b> for <c>D3D12CreateDevice</c>.
		/// </para>
		/// </summary>
		/// <returns>None</returns>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nf-d3d12sdklayers-id3d12debug4-disabledebuglayer void DisableDebugLayer();
		[PreserveSig]
		new void DisableDebugLayer();

		/// <summary>Configures the auto-naming of objects.</summary>
		/// <param name="Enable">
		/// Type: <b><c>BOOL</c></b>
		/// <para><see langword="true"/> to enable auto-naming; <c>false</c> to disable auto-naming.</para>
		/// </param>
		/// <returns>None</returns>
		/// <remarks>
		/// <para>
		/// By default, objects are not named unless you use <c>ID3D12Object::SetName</c> or <c>ID3D12Object::SetPrivateData</c> to assign a name.
		/// </para>
		/// <para>
		/// It's a best practice to name all of your Direct3D 12 objects; at least in debug builds. Failing that, you might find it
		/// convenient to allow automatic name assignment in order to cover the gaps. Direct3D 12 objects created with auto-name enabled are
		/// automatically assigned a name, which is used for debug layer output and for DRED page fault data.
		/// </para>
		/// <para>
		/// So as not to create a dependency on a specific auto-naming format, you can't retrieve the auto-name strings by using
		/// ID3D12Object::GetName or <c>ID3D12Object::GetPrivateData</c>. But, to generate a unique name string, Direct3D 12 uses the
		/// locally-unique identifier (LUID) assigned to every <b>ID3D12DeviceChild</b> object at create time. You can retrieve that LUID by
		/// using <b>ID3D12Object::GetPrivateData</b> with the <b>REFGUID</b> value WKPDID_D3D12UniqueObjectId. You might find that useful
		/// for your own object-naming schemas.
		/// </para>
		/// <para>
		/// When debugging existing software, you can control auto-naming by using the D3DConfig graphics tools utility and the command
		/// <c>d3dconfig.exe device auto-debug-name=forced-on</c>.
		/// </para>
		/// <para>
		/// Any object given a name using <c>ID3D12Object::SetName</c> or <c>ID3D12Object::SetPrivateData</c> uses the assigned name instead
		/// of the auto-name.
		/// </para>
		/// </remarks>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nf-d3d12sdklayers-id3d12debug5-setenableautoname void
		// SetEnableAutoName( BOOL Enable );
		[PreserveSig]
		new void SetEnableAutoName(bool Enable);

		/// <summary>
		/// <para>TBD</para>
		/// <para>Requires the DirectX 12 Agility SDK 1.7 or later.</para>
		/// </summary>
		/// <param name="Enable"/>
		/// <returns>None</returns>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nf-d3d12sdklayers-id3d12debug6-setforcelegacybarriervalidation
		// void SetForceLegacyBarrierValidation( BOOL Enable );
		[PreserveSig]
		void SetForceLegacyBarrierValidation(bool Enable);
	}

	/// <summary>Provides methods to monitor and debug a command list.</summary>
	// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nn-d3d12sdklayers-id3d12debugcommandlist
	[PInvokeData("d3d12sdklayers.h", MSDNShortId = "NN:d3d12sdklayers.ID3D12DebugCommandList")]
	[ComImport, Guid("09e0bf36-54ac-484f-8847-4baeeab6053f"), InterfaceType(ComInterfaceType.InterfaceIsIUnknown)]
	public interface ID3D12DebugCommandList
	{
		/// <summary>Checks whether a resource, or subresource, is in a specified state, or not.</summary>
		/// <param name="pResource">
		/// <para>Type: <b>ID3D12Resource*</b></para>
		/// <para>Specifies the <c>ID3D12Resource</c> to check.</para>
		/// </param>
		/// <param name="Subresource">
		/// <para>Type: <b>UINT</b></para>
		/// <para>The index of the subresource to check. This can be set to an index, or <see cref="D3D12_RESOURCE_BARRIER_ALL_SUBRESOURCES"/>.</para>
		/// </param>
		/// <param name="State">
		/// <para>Type: <b>UINT</b></para>
		/// <para>Specifies the state to check for. This can be one or more D3D12_RESOURCE_STATES flags Or'ed together.</para>
		/// </param>
		/// <returns>
		/// <para>Type: <b>BOOL</b></para>
		/// <para>This method returns true if the resource or subresource is in the specified state, false otherwise.</para>
		/// </returns>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nf-d3d12sdklayers-id3d12debugcommandlist-assertresourcestate
		// BOOL AssertResourceState( [in] ID3D12Resource *pResource, UINT Subresource, UINT State );
		[PreserveSig]
		bool AssertResourceState([In] ID3D12Resource pResource, uint Subresource, D3D12_RESOURCE_STATES State);

		/// <summary>Turns the debug features for a command list on or off.</summary>
		/// <param name="Mask">
		/// <para>Type: <b><c>D3D12_DEBUG_FEATURE</c></b></para>
		/// <para>
		/// A combination of feature-mask flags that are combined by using a bitwise OR operation. If a flag is present, that feature will
		/// be set to on, otherwise the feature will be set to off.
		/// </para>
		/// </param>
		/// <returns>
		/// <para>Type: <b><c>HRESULT</c></b></para>
		/// <para>This method returns one of the <c>Direct3D 12 Return Codes</c>.</para>
		/// </returns>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nf-d3d12sdklayers-id3d12debugcommandlist-setfeaturemask
		// HRESULT SetFeatureMask( D3D12_DEBUG_FEATURE Mask );
		[PreserveSig]
		HRESULT SetFeatureMask(D3D12_DEBUG_FEATURE Mask);

		/// <summary>Returns the debug feature flags that have been set on a command list.</summary>
		/// <returns>
		/// <para>Type: <b><c>D3D12_DEBUG_FEATURE</c></b></para>
		/// <para>A bit mask containing the set debug features.</para>
		/// </returns>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nf-d3d12sdklayers-id3d12debugcommandlist-getfeaturemask
		// D3D12_DEBUG_FEATURE GetFeatureMask();
		[PreserveSig]
		D3D12_DEBUG_FEATURE GetFeatureMask();
	}

	/// <summary>This interface enables modification of additional command list debug layer settings.</summary>
	/// <remarks>This interface is currently in Preview mode.</remarks>
	// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nn-d3d12sdklayers-id3d12debugcommandlist1
	[PInvokeData("d3d12sdklayers.h", MSDNShortId = "NN:d3d12sdklayers.ID3D12DebugCommandList1")]
	[ComImport, Guid("102ca951-311b-4b01-b11f-ecb83e061b37"), InterfaceType(ComInterfaceType.InterfaceIsIUnknown)]
	public interface ID3D12DebugCommandList1
	{
		/// <summary>
		/// Validates that the given state matches the state of the subresource, assuming the state of the given subresource is known during
		/// recording of a command list (e.g. the resource was transitioned earlier in the same command list recording). If the state is not
		/// yet known this method sets the known state for further validation later in the same command list recording.
		/// </summary>
		/// <param name="pResource">
		/// <para>Type: <b>ID3D12Resource*</b></para>
		/// <para>Specifies the <c>ID3D12Resource</c> to check.</para>
		/// </param>
		/// <param name="Subresource">
		/// <para>Type: <b>UINT</b></para>
		/// <para>The index of the subresource to check. This can be set to an index, or D3D12_RESOURCE_BARRIER_ALL_SUBRESOURCES.</para>
		/// </param>
		/// <param name="State">
		/// <para>Type: <b>UINT</b></para>
		/// <para>Specifies the state to check for. This can be one or more <c>D3D12_RESOURCE_STATES</c> flags Or'ed together.</para>
		/// </param>
		/// <returns>
		/// <para>Type: <b>BOOL</b></para>
		/// <para>
		/// This method returns <b>true</b> if the tracked state of the resource or subresource matches the specified state, <b>false</b> otherwise.
		/// </para>
		/// </returns>
		/// <remarks>
		/// <para>
		/// Since execution of command lists occurs sometime after recording, the state of a resource often cannot be known during command
		/// list recording. <b>AssertResourceState</b> gives an application developer the ability to impose an assumed state on a resource
		/// or subresource at a fixed recording point in a command list.
		/// </para>
		/// <para>
		/// Often the state of a resource or subresource can either be known due to a previous barrier or inferred-by-use (for example, was
		/// used in an earlier call to <c>CopyBufferRegion</c>) during command list recording. In such cases <b>AssertResourceState</b> can
		/// produce a debug message if the given state does not match the known or assumed state.
		/// </para>
		/// <para>This API is for debug validation only and does not affect the actual runtime or GPU state of the resource.</para>
		/// </remarks>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nf-d3d12sdklayers-id3d12debugcommandlist1-assertresourcestate
		// BOOL AssertResourceState( [in] ID3D12Resource *pResource, UINT Subresource, UINT State );
		[PreserveSig]
		bool AssertResourceState([In] ID3D12Resource pResource, uint Subresource, D3D12_RESOURCE_STATES State);

		/// <summary>Modifies optional Debug Layer settings of a command list.</summary>
		/// <param name="Type">
		/// <para>Type: <b><c>D3D12_DEBUG_COMMAND_LIST_PARAMETER_TYPE</c></b></para>
		/// <para>Specifies a <c>D3D12_DEBUG_COMMAND_LIST_PARAMETER_TYPE</c> value that indicates which debug parameter data to set.</para>
		/// </param>
		/// <param name="pData">
		/// <para>Type: <b>const void*</b></para>
		/// <para>
		/// Pointer to debug parameter data to set. The interpretation of this data depends on the
		/// <c>D3D12_DEBUG_COMMAND_LIST_PARAMETER_TYPE</c> given in the <i>Type</i> parameter.
		/// </para>
		/// </param>
		/// <param name="DataSize">
		/// <para>Type: <b>UINT</b></para>
		/// <para>Specifies the size in bytes of the debug parameter <i>pData</i>.</para>
		/// </param>
		/// <returns>
		/// <para>Type: <b><c>HRESULT</c></b></para>
		/// <para>This method returns one of the <c>Direct3D 12 Return Codes</c>.</para>
		/// </returns>
		/// <remarks>
		/// <para>
		/// Certain debug behaviors of D3D12 Debug Layer can be modified by setting debug parameters. These can be used to toggle extra
		/// validation or expose experimental debug features.
		/// </para>
		/// <para>
		/// <b>ID3D12DebugCommandList1::SetDebugParameter</b> only impacts debug settings for the associated command list. For device-wide
		/// debug parameters see the <c>ID3D12DebugDevice1::SetDebugParameter</c> method.
		/// </para>
		/// <para>
		/// Resetting a command list restores the debug parameters to the default values. This is because a command list reset is treated as
		/// equivalent to creating a new command list.
		/// </para>
		/// </remarks>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nf-d3d12sdklayers-id3d12debugcommandlist1-setdebugparameter
		// HRESULT SetDebugParameter( D3D12_DEBUG_COMMAND_LIST_PARAMETER_TYPE Type, [in] const void *pData, UINT DataSize );
		[PreserveSig]
		HRESULT SetDebugParameter(D3D12_DEBUG_COMMAND_LIST_PARAMETER_TYPE Type, [In] IntPtr pData, uint DataSize);

		/// <summary>Gets optional Command List Debug Layer settings.</summary>
		/// <param name="Type">
		/// <para>Type: <b><c>D3D12_DEBUG_COMMAND_LIST_PARAMETER_TYPE</c></b></para>
		/// <para>
		/// Specifies a <c>D3D12_DEBUG_COMMAND_LIST_PARAMETER_TYPE</c> value that determines which debug parameter data to copy to the
		/// memory pointed to by <i>pData</i>.
		/// </para>
		/// </param>
		/// <param name="pData">
		/// <para>Type: <b>void*</b></para>
		/// <para>
		/// Points to the memory that will be filled with a copy of the debug parameter data. The interpretation of this data depends on the
		/// <c>D3D12_DEBUG_COMMAND_LIST_PARAMETER_TYPE</c> given in the <i>Type</i> parameter.
		/// </para>
		/// </param>
		/// <param name="DataSize">
		/// <para>Type: <b>UINT</b></para>
		/// <para>Size in bytes of the memory buffer pointed to by <i>pData</i>.</para>
		/// </param>
		/// <returns>
		/// <para>Type: <b><c>HRESULT</c></b></para>
		/// <para>Returns S_OK if successful, otherwise E_INVALIDARG.</para>
		/// </returns>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nf-d3d12sdklayers-id3d12debugcommandlist1-getdebugparameter
		// HRESULT GetDebugParameter( D3D12_DEBUG_COMMAND_LIST_PARAMETER_TYPE Type, [out] void *pData, UINT DataSize );
		[PreserveSig]
		HRESULT GetDebugParameter(D3D12_DEBUG_COMMAND_LIST_PARAMETER_TYPE Type, [Out] IntPtr pData, uint DataSize);
	}

	/// <summary>Undocumented.</summary>
	/// <seealso cref="Vanara.PInvoke.D3D12.ID3D12DebugCommandList"/>
	[ComImport, Guid("aeb575cf-4e06-48be-ba3b-c450fc96652e"), InterfaceType(ComInterfaceType.InterfaceIsIUnknown)]
	public interface ID3D12DebugCommandList2 : ID3D12DebugCommandList
	{
		/// <summary>Checks whether a resource, or subresource, is in a specified state, or not.</summary>
		/// <param name="pResource">
		/// <para>Type: <b>ID3D12Resource*</b></para>
		/// <para>Specifies the <c>ID3D12Resource</c> to check.</para>
		/// </param>
		/// <param name="Subresource">
		/// <para>Type: <b>UINT</b></para>
		/// <para>The index of the subresource to check. This can be set to an index, or <see cref="D3D12_RESOURCE_BARRIER_ALL_SUBRESOURCES"/>.</para>
		/// </param>
		/// <param name="State">
		/// <para>Type: <b>UINT</b></para>
		/// <para>Specifies the state to check for. This can be one or more D3D12_RESOURCE_STATES flags Or'ed together.</para>
		/// </param>
		/// <returns>
		/// <para>Type: <b>BOOL</b></para>
		/// <para>This method returns true if the resource or subresource is in the specified state, false otherwise.</para>
		/// </returns>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nf-d3d12sdklayers-id3d12debugcommandlist-assertresourcestate
		// BOOL AssertResourceState( [in] ID3D12Resource *pResource, UINT Subresource, UINT State );
		[PreserveSig]
		new bool AssertResourceState([In] ID3D12Resource pResource, uint Subresource, D3D12_RESOURCE_STATES State);

		/// <summary>Turns the debug features for a command list on or off.</summary>
		/// <param name="Mask">
		/// <para>Type: <b><c>D3D12_DEBUG_FEATURE</c></b></para>
		/// <para>
		/// A combination of feature-mask flags that are combined by using a bitwise OR operation. If a flag is present, that feature will
		/// be set to on, otherwise the feature will be set to off.
		/// </para>
		/// </param>
		/// <returns>
		/// <para>Type: <b><c>HRESULT</c></b></para>
		/// <para>This method returns one of the <c>Direct3D 12 Return Codes</c>.</para>
		/// </returns>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nf-d3d12sdklayers-id3d12debugcommandlist-setfeaturemask
		// HRESULT SetFeatureMask( D3D12_DEBUG_FEATURE Mask );
		[PreserveSig]
		new HRESULT SetFeatureMask(D3D12_DEBUG_FEATURE Mask);

		/// <summary>Returns the debug feature flags that have been set on a command list.</summary>
		/// <returns>
		/// <para>Type: <b><c>D3D12_DEBUG_FEATURE</c></b></para>
		/// <para>A bit mask containing the set debug features.</para>
		/// </returns>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nf-d3d12sdklayers-id3d12debugcommandlist-getfeaturemask
		// D3D12_DEBUG_FEATURE GetFeatureMask();
		[PreserveSig]
		new D3D12_DEBUG_FEATURE GetFeatureMask();

		/// <summary>Undocumented.</summary>
		[PreserveSig]
		HRESULT SetDebugParameter(D3D12_DEBUG_COMMAND_LIST_PARAMETER_TYPE Type, [In] IntPtr pData, uint DataSize);

		/// <summary>Undocumented.</summary>
		[PreserveSig]
		HRESULT GetDebugParameter(D3D12_DEBUG_COMMAND_LIST_PARAMETER_TYPE Type, [Out] IntPtr pData, uint DataSize);
	}

	/// <summary>Undocumented.</summary>
	[ComImport, Guid("197d5e15-4d37-4d34-af78-724cd70fdb1f"), InterfaceType(ComInterfaceType.InterfaceIsIUnknown)]
	public interface ID3D12DebugCommandList3 : ID3D12DebugCommandList2
	{
		/// <summary>Checks whether a resource, or subresource, is in a specified state, or not.</summary>
		/// <param name="pResource">
		/// <para>Type: <b>ID3D12Resource*</b></para>
		/// <para>Specifies the <c>ID3D12Resource</c> to check.</para>
		/// </param>
		/// <param name="Subresource">
		/// <para>Type: <b>UINT</b></para>
		/// <para>The index of the subresource to check. This can be set to an index, or <see cref="D3D12_RESOURCE_BARRIER_ALL_SUBRESOURCES"/>.</para>
		/// </param>
		/// <param name="State">
		/// <para>Type: <b>UINT</b></para>
		/// <para>Specifies the state to check for. This can be one or more D3D12_RESOURCE_STATES flags Or'ed together.</para>
		/// </param>
		/// <returns>
		/// <para>Type: <b>BOOL</b></para>
		/// <para>This method returns true if the resource or subresource is in the specified state, false otherwise.</para>
		/// </returns>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nf-d3d12sdklayers-id3d12debugcommandlist-assertresourcestate
		// BOOL AssertResourceState( [in] ID3D12Resource *pResource, UINT Subresource, UINT State );
		[PreserveSig]
		new bool AssertResourceState([In] ID3D12Resource pResource, uint Subresource, D3D12_RESOURCE_STATES State);

		/// <summary>Turns the debug features for a command list on or off.</summary>
		/// <param name="Mask">
		/// <para>Type: <b><c>D3D12_DEBUG_FEATURE</c></b></para>
		/// <para>
		/// A combination of feature-mask flags that are combined by using a bitwise OR operation. If a flag is present, that feature will
		/// be set to on, otherwise the feature will be set to off.
		/// </para>
		/// </param>
		/// <returns>
		/// <para>Type: <b><c>HRESULT</c></b></para>
		/// <para>This method returns one of the <c>Direct3D 12 Return Codes</c>.</para>
		/// </returns>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nf-d3d12sdklayers-id3d12debugcommandlist-setfeaturemask
		// HRESULT SetFeatureMask( D3D12_DEBUG_FEATURE Mask );
		[PreserveSig]
		new HRESULT SetFeatureMask(D3D12_DEBUG_FEATURE Mask);

		/// <summary>Returns the debug feature flags that have been set on a command list.</summary>
		/// <returns>
		/// <para>Type: <b><c>D3D12_DEBUG_FEATURE</c></b></para>
		/// <para>A bit mask containing the set debug features.</para>
		/// </returns>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nf-d3d12sdklayers-id3d12debugcommandlist-getfeaturemask
		// D3D12_DEBUG_FEATURE GetFeatureMask();
		[PreserveSig]
		new D3D12_DEBUG_FEATURE GetFeatureMask();

		/// <summary>Undocumented.</summary>
		[PreserveSig]
		new HRESULT SetDebugParameter(D3D12_DEBUG_COMMAND_LIST_PARAMETER_TYPE Type, [In] IntPtr pData, uint DataSize);

		/// <summary>Undocumented.</summary>
		[PreserveSig]
		new HRESULT GetDebugParameter(D3D12_DEBUG_COMMAND_LIST_PARAMETER_TYPE Type, [Out] IntPtr pData, uint DataSize);

		/// <summary>Undocumented.</summary>
		[PreserveSig]
		void AssertResourceAccess([In] ID3D12Resource pResource, uint Subresource, D3D12_BARRIER_ACCESS Access);

		/// <summary>Undocumented.</summary>
		[PreserveSig]
		void AssertTextureLayout([In] ID3D12Resource pResource, uint Subresource, D3D12_BARRIER_LAYOUT Layout);
	}

	/// <summary>Provides methods to monitor and debug a command queue.</summary>
	// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nn-d3d12sdklayers-id3d12debugcommandqueue
	[PInvokeData("d3d12sdklayers.h", MSDNShortId = "NN:d3d12sdklayers.ID3D12DebugCommandQueue")]
	[ComImport, Guid("09e0bf36-54ac-484f-8847-4baeeab6053a"), InterfaceType(ComInterfaceType.InterfaceIsIUnknown)]
	public interface ID3D12DebugCommandQueue
	{
		/// <summary>Checks whether a resource, or subresource, is in a specified state, or not.</summary>
		/// <param name="pResource">
		/// <para>Type: <b>ID3D12Resource*</b></para>
		/// <para>Specifies the <c>ID3D12Resource</c> to check.</para>
		/// </param>
		/// <param name="Subresource">
		/// <para>Type: <b>UINT</b></para>
		/// <para>The index of the subresource to check. This can be set to an index, or D3D12_RESOURCE_BARRIER_ALL_SUBRESOURCES.</para>
		/// </param>
		/// <param name="State">
		/// <para>Type: <b>UINT</b></para>
		/// <para>Specifies the state to check for. This can be one or more D3D12_RESOURCE_STATES flags Or'ed together.</para>
		/// </param>
		/// <returns>
		/// <para>Type: <b>BOOL</b></para>
		/// <para>This method returns true if the resource or subresource is in the specified state, false otherwise.</para>
		/// </returns>
		/// <remarks>
		/// This method is very similar to <c>ID3D12DebugCommandList::AssertResourceState</c>, however there are methods on the command
		/// queue that work directly with resources that might need to be monitored (for example <c>ID3D12CommandQueue::CopyTileMappings</c>).
		/// </remarks>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nf-d3d12sdklayers-id3d12debugcommandqueue-assertresourcestate
		// BOOL AssertResourceState( [in] ID3D12Resource *pResource, UINT Subresource, UINT State );
		[PreserveSig]
		bool AssertResourceState([In] ID3D12Resource pResource, uint Subresource, D3D12_RESOURCE_STATES State);
	}

	/// <summary>Undocumented.</summary>
	/// <seealso cref="Vanara.PInvoke.D3D12.ID3D12DebugCommandQueue"/>
	[ComImport, Guid("16be35a2-bfd6-49f2-bcae-eaae4aff862d"), InterfaceType(ComInterfaceType.InterfaceIsIUnknown)]
	public interface ID3D12DebugCommandQueue1 : ID3D12DebugCommandQueue
	{
		/// <summary>Checks whether a resource, or subresource, is in a specified state, or not.</summary>
		/// <param name="pResource">
		/// <para>Type: <b>ID3D12Resource*</b></para>
		/// <para>Specifies the <c>ID3D12Resource</c> to check.</para>
		/// </param>
		/// <param name="Subresource">
		/// <para>Type: <b>UINT</b></para>
		/// <para>The index of the subresource to check. This can be set to an index, or D3D12_RESOURCE_BARRIER_ALL_SUBRESOURCES.</para>
		/// </param>
		/// <param name="State">
		/// <para>Type: <b>UINT</b></para>
		/// <para>Specifies the state to check for. This can be one or more D3D12_RESOURCE_STATES flags Or'ed together.</para>
		/// </param>
		/// <returns>
		/// <para>Type: <b>BOOL</b></para>
		/// <para>This method returns true if the resource or subresource is in the specified state, false otherwise.</para>
		/// </returns>
		/// <remarks>
		/// This method is very similar to <c>ID3D12DebugCommandList::AssertResourceState</c>, however there are methods on the command
		/// queue that work directly with resources that might need to be monitored (for example <c>ID3D12CommandQueue::CopyTileMappings</c>).
		/// </remarks>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nf-d3d12sdklayers-id3d12debugcommandqueue-assertresourcestate
		// BOOL AssertResourceState( [in] ID3D12Resource *pResource, UINT Subresource, UINT State );
		[PreserveSig]
		new bool AssertResourceState([In] ID3D12Resource pResource, uint Subresource, D3D12_RESOURCE_STATES State);

		/// <summary>Undocumented.</summary>
		[PreserveSig]
		void AssertResourceAccess([In] ID3D12Resource pResource, uint Subresource, D3D12_BARRIER_ACCESS Access);

		/// <summary>Undocumented.</summary>
		[PreserveSig]
		void AssertTextureLayout([In] ID3D12Resource pResource, uint Subresource, D3D12_BARRIER_LAYOUT Layout);
	}

	/// <summary>This interface represents a graphics device for debugging.</summary>
	// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nn-d3d12sdklayers-id3d12debugdevice
	[PInvokeData("d3d12sdklayers.h", MSDNShortId = "NN:d3d12sdklayers.ID3D12DebugDevice")]
	[ComImport, Guid("3febd6dd-4973-4787-8194-e45f9e28923e"), InterfaceType(ComInterfaceType.InterfaceIsIUnknown)]
	public interface ID3D12DebugDevice
	{
		/// <summary>Set a bit field of flags that will turn debug features on and off.</summary>
		/// <param name="Mask">
		/// <para>Type: <b><c>D3D12_DEBUG_FEATURE</c></b></para>
		/// <para>
		/// Feature-mask flags, as a bitwise-OR'd combination of <c>D3D12_DEBUG_FEATURE</c> enumeration constants. If a flag is present,
		/// that feature will be set to on; otherwise, the feature will be set to off.
		/// </para>
		/// </param>
		/// <returns>
		/// <para>Type: <b><c>HRESULT</c></b></para>
		/// <para>This method returns one of the <c>Direct3D 12 Return Codes</c>. <c>HRESULT</c></para>
		/// </returns>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nf-d3d12sdklayers-id3d12debugdevice-setfeaturemask HRESULT
		// SetFeatureMask( D3D12_DEBUG_FEATURE Mask );
		[PreserveSig]
		HRESULT SetFeatureMask(D3D12_DEBUG_FEATURE Mask);

		/// <summary>Gets a bit field of flags that indicates which debug features are on or off.</summary>
		/// <returns>
		/// <para>Type: <b><c>D3D12_DEBUG_FEATURE</c></b></para>
		/// <para>
		/// Mask of feature-mask flags, as a bitwise OR'ed combination of <c>D3D12_DEBUG_FEATURE</c> enumeration constants. If a flag is
		/// present, then that feature will be set to on, otherwise the feature will be set to off.
		/// </para>
		/// </returns>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nf-d3d12sdklayers-id3d12debugdevice-getfeaturemask
		// D3D12_DEBUG_FEATURE GetFeatureMask();
		[PreserveSig]
		D3D12_DEBUG_FEATURE GetFeatureMask();

		/// <summary>Reports information about a device object's lifetime.</summary>
		/// <param name="Flags">
		/// <para>Type: <b><c>D3D12_RLDO_FLAGS</c></b></para>
		/// <para>
		/// A value from the <c>D3D12_RLDO_FLAGS</c> enumeration. This method uses the value in <i>Flags</i> to determine the amount of
		/// information to report about a device object's lifetime.
		/// </para>
		/// </param>
		/// <returns>
		/// <para>Type: <b><c>HRESULT</c></b></para>
		/// <para>This method returns one of the <c>Direct3D 12 Return Codes</c>. <c>HRESULT</c></para>
		/// </returns>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nf-d3d12sdklayers-id3d12debugdevice-reportlivedeviceobjects
		// HRESULT ReportLiveDeviceObjects( D3D12_RLDO_FLAGS Flags );
		[PreserveSig]
		HRESULT ReportLiveDeviceObjects(D3D12_RLDO_FLAGS Flags);
	}

	/// <summary>Specifies device-wide debug layer settings.</summary>
	/// <remarks>This interface is currently in Preview mode.</remarks>
	// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nn-d3d12sdklayers-id3d12debugdevice1
	[PInvokeData("d3d12sdklayers.h", MSDNShortId = "NN:d3d12sdklayers.ID3D12DebugDevice1")]
	[ComImport, Guid("a9b71770-d099-4a65-a698-3dee10020f88"), InterfaceType(ComInterfaceType.InterfaceIsIUnknown)]
	public interface ID3D12DebugDevice1
	{
		/// <summary>Modifies the D3D12 optional device-wide Debug Layer settings.</summary>
		/// <param name="Type">
		/// <para>Type: <b><c>D3D12_DEBUG_DEVICE_PARAMETER_TYPE</c></b></para>
		/// <para>Specifies a <c>D3D12_DEBUG_DEVICE_PARAMETER_TYPE</c> value that indicates which debug parameter data to get.</para>
		/// </param>
		/// <param name="pData">
		/// <para>Type: <b>const void*</b></para>
		/// <para>Debug parameter data to set.</para>
		/// </param>
		/// <param name="DataSize">
		/// <para>Type: <b>UINT</b></para>
		/// <para>Size in bytes of the data pointed to by <i>pData</i>.</para>
		/// </param>
		/// <returns>
		/// <para>Type: <b><c>HRESULT</c></b></para>
		/// <para>This method returns one of the <c>Direct3D 12 Return Codes</c>.</para>
		/// </returns>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nf-d3d12sdklayers-id3d12debugdevice1-setdebugparameter HRESULT
		// SetDebugParameter( D3D12_DEBUG_DEVICE_PARAMETER_TYPE Type, [in] const void *pData, UINT DataSize );
		[PreserveSig]
		HRESULT SetDebugParameter(D3D12_DEBUG_DEVICE_PARAMETER_TYPE Type, [In] IntPtr pData, uint DataSize);

		/// <summary>Gets optional device-wide Debug Layer settings.</summary>
		/// <param name="Type">
		/// <para>Type: <b><c>D3D12_DEBUG_DEVICE_PARAMETER_TYPE</c></b></para>
		/// <para>Specifies a <c>D3D12_DEBUG_DEVICE_PARAMETER_TYPE</c> value that indicates which debug parameter data to set.</para>
		/// </param>
		/// <param name="pData">
		/// <para>Type: <b>void*</b></para>
		/// <para>
		/// Points to the memory that will be filled with a copy of the debug parameter data. The interpretation of this data depends on the
		/// <c>D3D12_DEBUG_DEVICE_PARAMETER_TYPE</c> given in the <i>Type</i> parameter.
		/// </para>
		/// </param>
		/// <param name="DataSize">
		/// <para>Type: <b>UINT</b></para>
		/// <para>Size in bytes of the memory buffer pointed to by <i>pData</i>.</para>
		/// </param>
		/// <returns>
		/// <para>Type: <b><c>HRESULT</c></b></para>
		/// <para>This method returns one of the <c>Direct3D 12 Return Codes</c>.</para>
		/// </returns>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nf-d3d12sdklayers-id3d12debugdevice1-getdebugparameter HRESULT
		// GetDebugParameter( D3D12_DEBUG_DEVICE_PARAMETER_TYPE Type, [out] void *pData, UINT DataSize );
		[PreserveSig]
		HRESULT GetDebugParameter(D3D12_DEBUG_DEVICE_PARAMETER_TYPE Type, [Out] IntPtr pData, uint DataSize);

		/// <summary>Specifies the amount of information to report on a device object's lifetime.</summary>
		/// <param name="Flags">
		/// <para>Type: <b><c>D3D12_RLDO_FLAGS</c></b></para>
		/// <para>
		/// A value from the <c>D3D12_RLDO_FLAGS</c> enumeration. This method uses the value in <i>Flags</i> to determine the amount of
		/// information to report about a device object's lifetime.
		/// </para>
		/// </param>
		/// <returns>
		/// <para>Type: <b><c>HRESULT</c></b></para>
		/// <para>This method returns one of the <c>Direct3D 12 Return Codes</c>.</para>
		/// </returns>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nf-d3d12sdklayers-id3d12debugdevice1-reportlivedeviceobjects
		// HRESULT ReportLiveDeviceObjects( D3D12_RLDO_FLAGS Flags );
		[PreserveSig]
		HRESULT ReportLiveDeviceObjects(D3D12_RLDO_FLAGS Flags);
	}

	/// <summary>Undocumented.</summary>
	[ComImport, Guid("60eccbc1-378d-4df1-894c-f8ac5ce4d7dd"), InterfaceType(ComInterfaceType.InterfaceIsIUnknown)]
	public interface ID3D12DebugDevice2 : ID3D12DebugDevice
	{
		/// <summary>Set a bit field of flags that will turn debug features on and off.</summary>
		/// <param name="Mask">
		/// <para>Type: <b><c>D3D12_DEBUG_FEATURE</c></b></para>
		/// <para>
		/// Feature-mask flags, as a bitwise-OR'd combination of <c>D3D12_DEBUG_FEATURE</c> enumeration constants. If a flag is present,
		/// that feature will be set to on; otherwise, the feature will be set to off.
		/// </para>
		/// </param>
		/// <returns>
		/// <para>Type: <b><c>HRESULT</c></b></para>
		/// <para>This method returns one of the <c>Direct3D 12 Return Codes</c>. <c>HRESULT</c></para>
		/// </returns>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nf-d3d12sdklayers-id3d12debugdevice-setfeaturemask HRESULT
		// SetFeatureMask( D3D12_DEBUG_FEATURE Mask );
		[PreserveSig]
		new HRESULT SetFeatureMask(D3D12_DEBUG_FEATURE Mask);

		/// <summary>Gets a bit field of flags that indicates which debug features are on or off.</summary>
		/// <returns>
		/// <para>Type: <b><c>D3D12_DEBUG_FEATURE</c></b></para>
		/// <para>
		/// Mask of feature-mask flags, as a bitwise OR'ed combination of <c>D3D12_DEBUG_FEATURE</c> enumeration constants. If a flag is
		/// present, then that feature will be set to on, otherwise the feature will be set to off.
		/// </para>
		/// </returns>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nf-d3d12sdklayers-id3d12debugdevice-getfeaturemask
		// D3D12_DEBUG_FEATURE GetFeatureMask();
		[PreserveSig]
		new D3D12_DEBUG_FEATURE GetFeatureMask();

		/// <summary>Reports information about a device object's lifetime.</summary>
		/// <param name="Flags">
		/// <para>Type: <b><c>D3D12_RLDO_FLAGS</c></b></para>
		/// <para>
		/// A value from the <c>D3D12_RLDO_FLAGS</c> enumeration. This method uses the value in <i>Flags</i> to determine the amount of
		/// information to report about a device object's lifetime.
		/// </para>
		/// </param>
		/// <returns>
		/// <para>Type: <b><c>HRESULT</c></b></para>
		/// <para>This method returns one of the <c>Direct3D 12 Return Codes</c>. <c>HRESULT</c></para>
		/// </returns>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nf-d3d12sdklayers-id3d12debugdevice-reportlivedeviceobjects
		// HRESULT ReportLiveDeviceObjects( D3D12_RLDO_FLAGS Flags );
		[PreserveSig]
		new HRESULT ReportLiveDeviceObjects(D3D12_RLDO_FLAGS Flags);

		/// <summary>Undocumented.</summary>
		[PreserveSig]
		HRESULT SetDebugParameter(D3D12_DEBUG_DEVICE_PARAMETER_TYPE Type, [In] IntPtr pData, uint DataSize);

		/// <summary>Undocumented.</summary>
		[PreserveSig]
		HRESULT GetDebugParameter(D3D12_DEBUG_DEVICE_PARAMETER_TYPE Type, [Out] IntPtr pData, uint DataSize);
	}

	/// <summary>
	/// An information-queue interface stores, retrieves, and filters debug messages. The queue consists of a message queue, an optional
	/// storage filter stack, and a optional retrieval filter stack.
	/// </summary>
	/// <remarks>
	/// This interface is obtained by querying it from the <c>ID3D12Device</c> using <c>IUnknown::QueryInterface</c>. The <c>ID3D12Debug</c>
	/// layer must be enabled through <c>ID3D12Debug::EnableDebugLayer</c> for that operation to succeed.
	/// </remarks>
	// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nn-d3d12sdklayers-id3d12infoqueue
	[PInvokeData("d3d12sdklayers.h", MSDNShortId = "NN:d3d12sdklayers.ID3D12InfoQueue")]
	[ComImport, Guid("0742a90b-c387-483f-b946-30a7e4e61458"), InterfaceType(ComInterfaceType.InterfaceIsIUnknown)]
	public interface ID3D12InfoQueue
	{
		/// <summary>Set the maximum number of messages that can be added to the message queue.</summary>
		/// <param name="MessageCountLimit">
		/// <para>Type: <b>UINT64</b></para>
		/// <para>Maximum number of messages that can be added to the message queue. -1 means no limit.</para>
		/// <para>
		/// When the number of messages in the message queue has reached the maximum limit, new messages coming in will push old messages out.
		/// </para>
		/// </param>
		/// <returns>
		/// <para>Type: <b><c>HRESULT</c></b></para>
		/// <para>This method returns one of the <c>Direct3D 12 Return Codes</c>.</para>
		/// </returns>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nf-d3d12sdklayers-id3d12infoqueue-setmessagecountlimit HRESULT
		// SetMessageCountLimit( [in] UINT64 MessageCountLimit );
		[PreserveSig]
		HRESULT SetMessageCountLimit(ulong MessageCountLimit);

		/// <summary>Clear all messages from the message queue.</summary>
		/// <returns>None</returns>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nf-d3d12sdklayers-id3d12infoqueue-clearstoredmessages void ClearStoredMessages();
		[PreserveSig]
		void ClearStoredMessages();

		/// <summary>Get a message from the message queue.</summary>
		/// <param name="MessageIndex">
		/// <para>Type: <b>UINT64</b></para>
		/// <para>
		/// Index into message queue after an optional retrieval filter has been applied. This can be between 0 and the number of messages
		/// in the message queue that pass through the retrieval filter (which can be obtained with
		/// <c>GetNumStoredMessagesAllowedByRetrievalFilter</c>). 0 is the message at the front of the message queue.
		/// </para>
		/// </param>
		/// <param name="pMessage">
		/// <para>Type: <b><c>D3D12_MESSAGE</c>*</b></para>
		/// <para>Returned message.</para>
		/// </param>
		/// <param name="pMessageByteLength">
		/// <para>Type: <b>SIZE_T*</b></para>
		/// <para>Size of <i>pMessage</i> in bytes.</para>
		/// </param>
		/// <returns>
		/// <para>Type: <b><c>HRESULT</c></b></para>
		/// <para>This method returns one of the <c>Direct3D 12 Return Codes</c>.</para>
		/// </returns>
		/// <remarks>
		/// <para>This method does not remove any messages from the message queue.</para>
		/// <para>This method gets messages from the message queue after an optional retrieval filter has been applied.</para>
		/// <para>
		/// Applications should call this method twice to retrieve a message - first to obtain the size of the message and second to get the
		/// message. Here is a typical example:
		/// </para>
		/// <para>
		/// <c>// Get the size of the message SIZE_T messageLength = 0; HRESULT hr = pInfoQueue-&gt;GetMessage(0, NULL, &amp;messageLength);
		/// // Allocate space and get the message D3D12_MESSAGE * pMessage = (D3D12_MESSAGE*)malloc(messageLength); hr =
		/// pInfoQueue-&gt;GetMessage(0, pMessage, &amp;messageLength);</c>
		/// </para>
		/// </remarks>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nf-d3d12sdklayers-id3d12infoqueue-getmessage HRESULT
		// GetMessage( [in] UINT64 MessageIndex, [out, optional] D3D12_MESSAGE *pMessage, [in, out] SIZE_T *pMessageByteLength );
		[PreserveSig]
		HRESULT GetMessage(ulong MessageIndex, [Out, Optional] ManagedStructPointer<D3D12_MESSAGE> pMessage, ref SizeT pMessageByteLength);

		/// <summary>Get the number of messages that were allowed to pass through a storage filter.</summary>
		/// <returns>
		/// <para>Type: <b>UINT64</b></para>
		/// <para>Number of messages allowed by a storage filter.</para>
		/// </returns>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nf-d3d12sdklayers-id3d12infoqueue-getnummessagesallowedbystoragefilter
		// UINT64 GetNumMessagesAllowedByStorageFilter();
		[PreserveSig]
		ulong GetNumMessagesAllowedByStorageFilter();

		/// <summary>Get the number of messages that were denied passage through a storage filter.</summary>
		/// <returns>
		/// <para>Type: <b>UINT64</b></para>
		/// <para>Number of messages denied by a storage filter.</para>
		/// </returns>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nf-d3d12sdklayers-id3d12infoqueue-getnummessagesdeniedbystoragefilter
		// UINT64 GetNumMessagesDeniedByStorageFilter();
		[PreserveSig]
		ulong GetNumMessagesDeniedByStorageFilter();

		/// <summary>Get the number of messages currently stored in the message queue.</summary>
		/// <returns>
		/// <para>Type: <b>UINT64</b></para>
		/// <para>Number of messages currently stored in the message queue.</para>
		/// </returns>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nf-d3d12sdklayers-id3d12infoqueue-getnumstoredmessages UINT64 GetNumStoredMessages();
		[PreserveSig]
		ulong GetNumStoredMessages();

		/// <summary>Get the number of messages that are able to pass through a retrieval filter.</summary>
		/// <returns>
		/// <para>Type: <b>UINT64</b></para>
		/// <para>Number of messages allowed by a retrieval filter.</para>
		/// </returns>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nf-d3d12sdklayers-id3d12infoqueue-getnumstoredmessagesallowedbyretrievalfilter
		// UINT64 GetNumStoredMessagesAllowedByRetrievalFilter();
		[PreserveSig]
		ulong GetNumStoredMessagesAllowedByRetrievalFilter();

		/// <summary>Get the number of messages that were discarded due to the message count limit.</summary>
		/// <returns>
		/// <para>Type: <b>UINT64</b></para>
		/// <para>Number of messages discarded.</para>
		/// </returns>
		/// <remarks>Get and set the message count limit with <c>GetMessageCountLimit</c> and <c>SetMessageCountLimit</c>, respectively.</remarks>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nf-d3d12sdklayers-id3d12infoqueue-getnummessagesdiscardedbymessagecountlimit
		// UINT64 GetNumMessagesDiscardedByMessageCountLimit();
		[PreserveSig]
		ulong GetNumMessagesDiscardedByMessageCountLimit();

		/// <summary>Get the maximum number of messages that can be added to the message queue.</summary>
		/// <returns>
		/// <para>Type: <b>UINT64</b></para>
		/// <para>Maximum number of messages that can be added to the queue. -1 means no limit.</para>
		/// <para>
		/// When the number of messages in the message queue has reached the maximum limit, new messages coming in will push old messages out.
		/// </para>
		/// </returns>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nf-d3d12sdklayers-id3d12infoqueue-getmessagecountlimit UINT64 GetMessageCountLimit();
		[PreserveSig]
		ulong GetMessageCountLimit();

		/// <summary>Add storage filters to the top of the storage-filter stack.</summary>
		/// <param name="pFilter">
		/// <para>Type: <b><c>D3D12_INFO_QUEUE_FILTER</c>*</b></para>
		/// <para>Array of storage filters.</para>
		/// </param>
		/// <returns>
		/// <para>Type: <b><c>HRESULT</c></b></para>
		/// <para>This method returns one of the <c>Direct3D 12 Return Codes</c>.</para>
		/// </returns>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nf-d3d12sdklayers-id3d12infoqueue-addstoragefilterentries
		// HRESULT AddStorageFilterEntries( [in] D3D12_INFO_QUEUE_FILTER *pFilter );
		[PreserveSig]
		HRESULT AddStorageFilterEntries([In, MarshalAs(UnmanagedType.LPArray)] D3D12_INFO_QUEUE_FILTER[] pFilter);

		/// <summary>Get the storage filter at the top of the storage-filter stack.</summary>
		/// <param name="pFilter">
		/// <para>Type: <b><c>D3D12_INFO_QUEUE_FILTER</c>*</b></para>
		/// <para>Storage filter at the top of the storage-filter stack.</para>
		/// </param>
		/// <param name="pFilterByteLength">
		/// <para>Type: <b>SIZE_T*</b></para>
		/// <para>
		/// Size of the storage filter in bytes. If <i>pFilter</i> is NULL, the size of the storage filter will be output to this parameter.
		/// </para>
		/// </param>
		/// <returns>
		/// <para>Type: <b><c>HRESULT</c></b></para>
		/// <para>This method returns one of the <c>Direct3D 12 Return Codes</c>.</para>
		/// </returns>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nf-d3d12sdklayers-id3d12infoqueue-getstoragefilter HRESULT
		// GetStorageFilter( [out, optional] D3D12_INFO_QUEUE_FILTER *pFilter, [in, out] SIZE_T *pFilterByteLength );
		[PreserveSig]
		HRESULT GetStorageFilter([Out, Optional] StructPointer<D3D12_INFO_QUEUE_FILTER> pFilter, ref SizeT pFilterByteLength);

		/// <summary>Remove a storage filter from the top of the storage-filter stack.</summary>
		/// <returns>None</returns>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nf-d3d12sdklayers-id3d12infoqueue-clearstoragefilter void ClearStorageFilter();
		[PreserveSig]
		void ClearStorageFilter();

		/// <summary>Push an empty storage filter onto the storage-filter stack.</summary>
		/// <returns>
		/// <para>Type: <b><c>HRESULT</c></b></para>
		/// <para>This method returns one of the <c>Direct3D 12 Return Codes</c>.</para>
		/// </returns>
		/// <remarks>An empty storage filter allows all messages to pass through.</remarks>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nf-d3d12sdklayers-id3d12infoqueue-pushemptystoragefilter
		// HRESULT PushEmptyStorageFilter();
		[PreserveSig]
		HRESULT PushEmptyStorageFilter();

		/// <summary>Push a copy of storage filter currently on the top of the storage-filter stack onto the storage-filter stack.</summary>
		/// <returns>
		/// <para>Type: <b><c>HRESULT</c></b></para>
		/// <para>This method returns one of the <c>Direct3D 12 Return Codes</c>.</para>
		/// </returns>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nf-d3d12sdklayers-id3d12infoqueue-pushcopyofstoragefilter
		// HRESULT PushCopyOfStorageFilter();
		[PreserveSig]
		HRESULT PushCopyOfStorageFilter();

		/// <summary>Push a storage filter onto the storage-filter stack.</summary>
		/// <param name="pFilter">
		/// <para>Type: <b><c>D3D12_INFO_QUEUE_FILTER</c>*</b></para>
		/// <para>Pointer to a storage filter.</para>
		/// </param>
		/// <returns>
		/// <para>Type: <b><c>HRESULT</c></b></para>
		/// <para>This method returns one of the <c>Direct3D 12 Return Codes</c>.</para>
		/// </returns>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nf-d3d12sdklayers-id3d12infoqueue-pushstoragefilter HRESULT
		// PushStorageFilter( [in] D3D12_INFO_QUEUE_FILTER *pFilter );
		[PreserveSig]
		HRESULT PushStorageFilter(in D3D12_INFO_QUEUE_FILTER pFilter);

		/// <summary>Pop a storage filter from the top of the storage-filter stack.</summary>
		/// <returns>None</returns>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nf-d3d12sdklayers-id3d12infoqueue-popstoragefilter void PopStorageFilter();
		[PreserveSig]
		void PopStorageFilter();

		/// <summary>Get the size of the storage-filter stack in bytes.</summary>
		/// <returns>
		/// <para>Type: <b>UINT</b></para>
		/// <para>Size of the storage-filter stack in bytes.</para>
		/// </returns>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nf-d3d12sdklayers-id3d12infoqueue-getstoragefilterstacksize
		// UINT GetStorageFilterStackSize();
		[PreserveSig]
		uint GetStorageFilterStackSize();

		/// <summary>Add storage filters to the top of the retrieval-filter stack.</summary>
		/// <param name="pFilter">
		/// <para>Type: <b><c>D3D12_INFO_QUEUE_FILTER</c>*</b></para>
		/// <para>Array of retrieval filters.</para>
		/// </param>
		/// <returns>
		/// <para>Type: <b><c>HRESULT</c></b></para>
		/// <para>This method returns one of the <c>Direct3D 12 Return Codes</c>.</para>
		/// </returns>
		/// <remarks>
		/// <para>The following code example shows how to use this method:</para>
		/// <para>
		/// <c>D3D12_MESSAGE_CATEGORY cats[] = { ..., ..., ... }; D3D12_MESSAGE_SEVERITY sevs[] = { ..., ..., ... }; D3D12_MESSAGE_ID ids[]
		/// = { ..., ..., ... }; D3D12_INFO_QUEUE_FILTER filter; memset( &amp;filter, 0, sizeof(filter) ); // To set the type of messages to
		/// allow, // set filter.AllowList as follows: filter.AllowList.NumCategories = _countof(cats); filter.AllowList.pCategoryList =
		/// cats; filter.AllowList.NumSeverities = _countof(sevs); filter.AllowList.pSeverityList = sevs; filter.AllowList.NumIDs =
		/// _countof(ids); filter.AllowList.pIDList = ids; // To set the type of messages to deny, set filter.DenyList // similarly to the
		/// preceding filter.AllowList. // The following single call sets all of the preceding information. hr =
		/// infoQueue-&gt;AddRetrievalFilterEntries( &amp;filter );</c>
		/// </para>
		/// </remarks>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nf-d3d12sdklayers-id3d12infoqueue-addretrievalfilterentries
		// HRESULT AddRetrievalFilterEntries( [in] D3D12_INFO_QUEUE_FILTER *pFilter );
		[PreserveSig]
		HRESULT AddRetrievalFilterEntries([In, MarshalAs(UnmanagedType.LPArray)] D3D12_INFO_QUEUE_FILTER[] pFilter);

		/// <summary>Get the retrieval filter at the top of the retrieval-filter stack.</summary>
		/// <param name="pFilter">
		/// <para>Type: <b><c>D3D12_INFO_QUEUE_FILTER</c>*</b></para>
		/// <para>Retrieval filter at the top of the retrieval-filter stack.</para>
		/// </param>
		/// <param name="pFilterByteLength">
		/// <para>Type: <b>SIZE_T*</b></para>
		/// <para>
		/// Size of the retrieval filter in bytes. If <i>pFilter</i> is NULL, the size of the retrieval filter will be output to this parameter.
		/// </para>
		/// </param>
		/// <returns>
		/// <para>Type: <b><c>HRESULT</c></b></para>
		/// <para>This method returns one of the <c>Direct3D 12 Return Codes</c>.</para>
		/// </returns>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nf-d3d12sdklayers-id3d12infoqueue-getretrievalfilter HRESULT
		// GetRetrievalFilter( [out, optional] D3D12_INFO_QUEUE_FILTER *pFilter, [in, out] SIZE_T *pFilterByteLength );
		[PreserveSig]
		HRESULT GetRetrievalFilter([Out, Optional] StructPointer<D3D12_INFO_QUEUE_FILTER> pFilter, ref SizeT pFilterByteLength);

		/// <summary>Remove a retrieval filter from the top of the retrieval-filter stack.</summary>
		/// <returns>None</returns>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nf-d3d12sdklayers-id3d12infoqueue-clearretrievalfilter void ClearRetrievalFilter();
		[PreserveSig]
		void ClearRetrievalFilter();

		/// <summary>Push an empty retrieval filter onto the retrieval-filter stack.</summary>
		/// <returns>
		/// <para>Type: <b><c>HRESULT</c></b></para>
		/// <para>This method returns one of the <c>Direct3D 12 Return Codes</c>.</para>
		/// </returns>
		/// <remarks>An empty retrieval filter allows all messages to pass through.</remarks>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nf-d3d12sdklayers-id3d12infoqueue-pushemptyretrievalfilter
		// HRESULT PushEmptyRetrievalFilter();
		[PreserveSig]
		HRESULT PushEmptyRetrievalFilter();

		/// <summary>Push a copy of retrieval filter currently on the top of the retrieval-filter stack onto the retrieval-filter stack.</summary>
		/// <returns>
		/// <para>Type: <b><c>HRESULT</c></b></para>
		/// <para>This method returns one of the <c>Direct3D 12 Return Codes</c>.</para>
		/// </returns>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nf-d3d12sdklayers-id3d12infoqueue-pushcopyofretrievalfilter
		// HRESULT PushCopyOfRetrievalFilter();
		[PreserveSig]
		HRESULT PushCopyOfRetrievalFilter();

		/// <summary>Push a retrieval filter onto the retrieval-filter stack.</summary>
		/// <param name="pFilter">
		/// <para>Type: <b><c>D3D12_INFO_QUEUE_FILTER</c>*</b></para>
		/// <para>Pointer to a retrieval filter.</para>
		/// </param>
		/// <returns>
		/// <para>Type: <b><c>HRESULT</c></b></para>
		/// <para>This method returns one of the <c>Direct3D 12 Return Codes</c>.</para>
		/// </returns>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nf-d3d12sdklayers-id3d12infoqueue-pushretrievalfilter HRESULT
		// PushRetrievalFilter( [in] D3D12_INFO_QUEUE_FILTER *pFilter );
		[PreserveSig]
		HRESULT PushRetrievalFilter(in D3D12_INFO_QUEUE_FILTER pFilter);

		/// <summary>Pop a retrieval filter from the top of the retrieval-filter stack.</summary>
		/// <returns>None</returns>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nf-d3d12sdklayers-id3d12infoqueue-popretrievalfilter void PopRetrievalFilter();
		[PreserveSig]
		void PopRetrievalFilter();

		/// <summary>Get the size of the retrieval-filter stack in bytes.</summary>
		/// <returns>
		/// <para>Type: <b>UINT</b></para>
		/// <para>Size of the retrieval-filter stack in bytes.</para>
		/// </returns>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nf-d3d12sdklayers-id3d12infoqueue-getretrievalfilterstacksize
		// UINT GetRetrievalFilterStackSize();
		[PreserveSig]
		uint GetRetrievalFilterStackSize();

		/// <summary>Adds a debug message to the message queue and sends that message to debug output.</summary>
		/// <param name="Category">
		/// <para>Type: <b><c>D3D12_MESSAGE_CATEGORY</c></b></para>
		/// <para>Category of a message.</para>
		/// </param>
		/// <param name="Severity">
		/// <para>Type: <b><c>D3D12_MESSAGE_SEVERITY</c></b></para>
		/// <para>Severity of a message.</para>
		/// </param>
		/// <param name="ID">
		/// <para>Type: <b><c>D3D12_MESSAGE_ID</c></b></para>
		/// <para>Unique identifier of a message.</para>
		/// </param>
		/// <param name="pDescription">
		/// <para>Type: <b>LPCSTR</b></para>
		/// <para>User-defined message.</para>
		/// </param>
		/// <returns>
		/// <para>Type: <b><c>HRESULT</c></b></para>
		/// <para>This method returns one of the <c>Direct3D 12 Return Codes</c>.</para>
		/// </returns>
		/// <remarks>
		/// This method is used by the runtime's internal mechanisms to add debug messages to the message queue and send them to debug
		/// output. For applications to add their own custom messages to the message queue and send them to debug output, call <c>ID3D12InfoQueue::AddApplicationMessage</c>.
		/// </remarks>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nf-d3d12sdklayers-id3d12infoqueue-addmessage HRESULT
		// AddMessage( [in] D3D12_MESSAGE_CATEGORY Category, [in] D3D12_MESSAGE_SEVERITY Severity, [in] D3D12_MESSAGE_ID ID, [in] LPCSTR
		// pDescription );
		[PreserveSig]
		HRESULT AddMessage(D3D12_MESSAGE_CATEGORY Category, D3D12_MESSAGE_SEVERITY Severity, D3D12_MESSAGE_ID ID,
			[MarshalAs(UnmanagedType.LPStr)] string pDescription);

		/// <summary>Adds a user-defined message to the message queue and sends that message to debug output.</summary>
		/// <param name="Severity">
		/// <para>Type: <b><c>D3D12_MESSAGE_SEVERITY</c></b></para>
		/// <para>Severity of a message.</para>
		/// </param>
		/// <param name="pDescription">
		/// <para>Type: <b>LPCSTR</b></para>
		/// <para>Specifies the message string.</para>
		/// </param>
		/// <returns>
		/// <para>Type: <b><c>HRESULT</c></b></para>
		/// <para>This method returns one of the <c>Direct3D 12 Return Codes</c>.</para>
		/// </returns>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nf-d3d12sdklayers-id3d12infoqueue-addapplicationmessage
		// HRESULT AddApplicationMessage( [in] D3D12_MESSAGE_SEVERITY Severity, [in] LPCSTR pDescription );
		[PreserveSig]
		HRESULT AddApplicationMessage(D3D12_MESSAGE_SEVERITY Severity, [MarshalAs(UnmanagedType.LPStr)] string pDescription);

		/// <summary>Set a message category to break on when a message with that category passes through the storage filter.</summary>
		/// <param name="Category">
		/// <para>Type: <b><c>D3D12_MESSAGE_CATEGORY</c></b></para>
		/// <para>Message category to break on.</para>
		/// </param>
		/// <param name="bEnable">
		/// <para>Type: <b>BOOL</b></para>
		/// <para>Turns this breaking condition on or off (true for on, false for off).</para>
		/// </param>
		/// <returns>
		/// <para>Type: <b><c>HRESULT</c></b></para>
		/// <para>This method returns one of the <c>Direct3D 12 Return Codes</c>.</para>
		/// </returns>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nf-d3d12sdklayers-id3d12infoqueue-setbreakoncategory HRESULT
		// SetBreakOnCategory( [in] D3D12_MESSAGE_CATEGORY Category, [in] BOOL bEnable );
		[PreserveSig]
		HRESULT SetBreakOnCategory(D3D12_MESSAGE_CATEGORY Category, bool bEnable);

		/// <summary>Set a message severity level to break on when a message with that severity level passes through the storage filter.</summary>
		/// <param name="Severity">
		/// <para>Type: <b><c>D3D12_MESSAGE_SEVERITY</c></b></para>
		/// <para>A message severity level to break on.</para>
		/// </param>
		/// <param name="bEnable">
		/// <para>Type: <b>BOOL</b></para>
		/// <para>Turns this breaking condition on or off (true for on, false for off).</para>
		/// </param>
		/// <returns>
		/// <para>Type: <b><c>HRESULT</c></b></para>
		/// <para>This method returns one of the <c>Direct3D 12 Return Codes</c>.</para>
		/// </returns>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nf-d3d12sdklayers-id3d12infoqueue-setbreakonseverity HRESULT
		// SetBreakOnSeverity( [in] D3D12_MESSAGE_SEVERITY Severity, [in] BOOL bEnable );
		[PreserveSig]
		HRESULT SetBreakOnSeverity(D3D12_MESSAGE_SEVERITY Severity, bool bEnable);

		/// <summary>Set a message identifier to break on when a message with that identifier passes through the storage filter.</summary>
		/// <param name="ID">
		/// <para>Type: <b><c>D3D12_MESSAGE_ID</c></b></para>
		/// <para>Message identifier to break on.</para>
		/// </param>
		/// <param name="bEnable">
		/// <para>Type: <b>BOOL</b></para>
		/// <para>Turns this breaking condition on or off (true for on, false for off).</para>
		/// </param>
		/// <returns>
		/// <para>Type: <b><c>HRESULT</c></b></para>
		/// <para>This method returns one of the <c>Direct3D 12 Return Codes</c>.</para>
		/// </returns>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nf-d3d12sdklayers-id3d12infoqueue-setbreakonid HRESULT
		// SetBreakOnID( [in] D3D12_MESSAGE_ID ID, [in] BOOL bEnable );
		[PreserveSig]
		HRESULT SetBreakOnID(D3D12_MESSAGE_ID ID, bool bEnable);

		/// <summary>Get a message category to break on when a message with that category passes through the storage filter.</summary>
		/// <param name="Category">
		/// <para>Type: <b><c>D3D12_MESSAGE_CATEGORY</c></b></para>
		/// <para>Message category to break on.</para>
		/// </param>
		/// <returns>
		/// <para>Type: <b>BOOL</b></para>
		/// <para>Whether this breaking condition is turned on or off (true for on, false for off).</para>
		/// </returns>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nf-d3d12sdklayers-id3d12infoqueue-getbreakoncategory BOOL
		// GetBreakOnCategory( [in] D3D12_MESSAGE_CATEGORY Category );
		[PreserveSig]
		bool GetBreakOnCategory(D3D12_MESSAGE_CATEGORY Category);

		/// <summary>Get a message severity level to break on when a message with that severity level passes through the storage filter.</summary>
		/// <param name="Severity">
		/// <para>Type: <b><c>D3D12_MESSAGE_SEVERITY</c></b></para>
		/// <para>Message severity level to break on.</para>
		/// </param>
		/// <returns>
		/// <para>Type: <b>BOOL</b></para>
		/// <para>Whether this breaking condition is turned on or off (true for on, false for off).</para>
		/// </returns>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nf-d3d12sdklayers-id3d12infoqueue-getbreakonseverity BOOL
		// GetBreakOnSeverity( [in] D3D12_MESSAGE_SEVERITY Severity );
		[PreserveSig]
		bool GetBreakOnSeverity(D3D12_MESSAGE_SEVERITY Severity);

		/// <summary>Get a message identifier to break on when a message with that identifier passes through the storage filter.</summary>
		/// <param name="ID">
		/// <para>Type: <b><c>D3D12_MESSAGE_ID</c></b></para>
		/// <para>Message identifier to break on.</para>
		/// </param>
		/// <returns>
		/// <para>Type: <b>BOOL</b></para>
		/// <para>Whether this breaking condition is turned on or off (true for on, false for off).</para>
		/// </returns>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nf-d3d12sdklayers-id3d12infoqueue-getbreakonid BOOL
		// GetBreakOnID( [in] D3D12_MESSAGE_ID ID );
		[PreserveSig]
		bool GetBreakOnID(D3D12_MESSAGE_ID ID);

		/// <summary>Set a boolean that turns the debug output on or off.</summary>
		/// <param name="bMute">
		/// <para>Type: <b>BOOL</b></para>
		/// <para>Disable/Enable the debug output (true to disable or mute the output, false to enable the output).</para>
		/// </param>
		/// <returns>None</returns>
		/// <remarks>
		/// This will stop messages that pass the storage filter from being printed out in the debug output, however those messages will
		/// still be added to the message queue.
		/// </remarks>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nf-d3d12sdklayers-id3d12infoqueue-setmutedebugoutput void
		// SetMuteDebugOutput( [in] BOOL bMute );
		[PreserveSig]
		void SetMuteDebugOutput(bool bMute);

		/// <summary>Get a boolean that determines if debug output is on or off.</summary>
		/// <returns>
		/// <para>Type: <b>BOOL</b></para>
		/// <para>Whether the debug output is on or off (true for on, false for off).</para>
		/// </returns>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nf-d3d12sdklayers-id3d12infoqueue-getmutedebugoutput BOOL GetMuteDebugOutput();
		[PreserveSig]
		bool GetMuteDebugOutput();
	}

	/// <summary>Get a message from the message queue.</summary>
	/// <param name="queue">The <see cref="ID3D12InfoQueue" />.</param>
	/// <param name="MessageIndex">Index into message queue after an optional retrieval filter has been applied. This can be between 0 and the number of messages
	/// in the message queue that pass through the retrieval filter (which can be obtained with
	/// <c>GetNumStoredMessagesAllowedByRetrievalFilter</c>). 0 is the message at the front of the message queue.</param>
	/// <param name="pMessage">Returned message.</param>
	/// <returns>This method returns one of the <c>Direct3D 12 Return Codes</c>.</returns>
	/// <remarks>
	/// <para>This method does not remove any messages from the message queue.</para>
	/// <para>This method gets messages from the message queue after an optional retrieval filter has been applied.</para>
	/// </remarks>
	public static HRESULT GetMessage(this ID3D12InfoQueue queue, ulong MessageIndex, out D3D12_MESSAGE pMessage)
	{
		SizeT sz = 0;
		var hr = queue.GetMessage(MessageIndex, default, ref sz);
		using SafeCoTaskMemStruct<D3D12_MESSAGE> mem = new(sz);
		hr = queue.GetMessage(MessageIndex, mem, ref sz);
		pMessage = hr.Succeeded ? mem.Value : default;
		return hr;
	}

	/// <summary>Get the storage filter at the top of the storage-filter stack.</summary>
	/// <param name="queue">The <see cref="ID3D12InfoQueue" />.</param>
	/// <param name="pFilter">Storage filter at the top of the storage-filter stack.</param>
	/// <returns>This method returns one of the <c>Direct3D 12 Return Codes</c>.</returns>
	public static HRESULT GetStorageFilter(this ID3D12InfoQueue queue, out D3D12_INFO_QUEUE_FILTER pFilter)
	{
		SizeT sz = 0;
		var hr = queue.GetStorageFilter(default, ref sz);
		using SafeCoTaskMemStruct<D3D12_INFO_QUEUE_FILTER> mem = new(sz);
		hr = queue.GetStorageFilter(mem, ref sz);
		pFilter = hr.Succeeded ? mem.Value : default;
		return hr;
	}

	/// <summary>Get the retrieval filter at the top of the retrieval-filter stack.</summary>
	/// <param name="queue">The <see cref="ID3D12InfoQueue" />.</param>
	/// <param name="pFilter">Retrieval filter at the top of the retrieval-filter stack.</param>
	/// <returns>This method returns one of the <c>Direct3D 12 Return Codes</c>.</returns>
	public static HRESULT GetRetrievalFilter(this ID3D12InfoQueue queue, out D3D12_INFO_QUEUE_FILTER pFilter)
	{
		SizeT sz = 0;
		var hr = queue.GetRetrievalFilter(default, ref sz);
		using SafeCoTaskMemStruct<D3D12_INFO_QUEUE_FILTER> mem = new(sz);
		hr = queue.GetRetrievalFilter(mem, ref sz);
		pFilter = hr.Succeeded ? mem.Value : default;
		return hr;
	}

	/// <summary>Undocumented</summary>
	/// <seealso cref="Vanara.PInvoke.D3D12.ID3D12InfoQueue"/>
	[ComImport, Guid("2852dd88-b484-4c0c-b6b1-67168500e600"), InterfaceType(ComInterfaceType.InterfaceIsIUnknown)]
	public interface ID3D12InfoQueue1 : ID3D12InfoQueue
	{
		/// <summary>Set the maximum number of messages that can be added to the message queue.</summary>
		/// <param name="MessageCountLimit">
		/// <para>Type: <b>UINT64</b></para>
		/// <para>Maximum number of messages that can be added to the message queue. -1 means no limit.</para>
		/// <para>
		/// When the number of messages in the message queue has reached the maximum limit, new messages coming in will push old messages out.
		/// </para>
		/// </param>
		/// <returns>
		/// <para>Type: <b><c>HRESULT</c></b></para>
		/// <para>This method returns one of the <c>Direct3D 12 Return Codes</c>.</para>
		/// </returns>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nf-d3d12sdklayers-id3d12infoqueue-setmessagecountlimit HRESULT
		// SetMessageCountLimit( [in] UINT64 MessageCountLimit );
		[PreserveSig]
		new HRESULT SetMessageCountLimit(ulong MessageCountLimit);

		/// <summary>Clear all messages from the message queue.</summary>
		/// <returns>None</returns>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nf-d3d12sdklayers-id3d12infoqueue-clearstoredmessages void ClearStoredMessages();
		[PreserveSig]
		new void ClearStoredMessages();

		/// <summary>Get a message from the message queue.</summary>
		/// <param name="MessageIndex">
		/// <para>Type: <b>UINT64</b></para>
		/// <para>
		/// Index into message queue after an optional retrieval filter has been applied. This can be between 0 and the number of messages
		/// in the message queue that pass through the retrieval filter (which can be obtained with
		/// <c>GetNumStoredMessagesAllowedByRetrievalFilter</c>). 0 is the message at the front of the message queue.
		/// </para>
		/// </param>
		/// <param name="pMessage">
		/// <para>Type: <b><c>D3D12_MESSAGE</c>*</b></para>
		/// <para>Returned message.</para>
		/// </param>
		/// <param name="pMessageByteLength">
		/// <para>Type: <b>SIZE_T*</b></para>
		/// <para>Size of <i>pMessage</i> in bytes.</para>
		/// </param>
		/// <returns>
		/// <para>Type: <b><c>HRESULT</c></b></para>
		/// <para>This method returns one of the <c>Direct3D 12 Return Codes</c>.</para>
		/// </returns>
		/// <remarks>
		/// <para>This method does not remove any messages from the message queue.</para>
		/// <para>This method gets messages from the message queue after an optional retrieval filter has been applied.</para>
		/// <para>
		/// Applications should call this method twice to retrieve a message - first to obtain the size of the message and second to get the
		/// message. Here is a typical example:
		/// </para>
		/// <para>
		/// <c>// Get the size of the message SIZE_T messageLength = 0; HRESULT hr = pInfoQueue-&gt;GetMessage(0, NULL, &amp;messageLength);
		/// // Allocate space and get the message D3D12_MESSAGE * pMessage = (D3D12_MESSAGE*)malloc(messageLength); hr =
		/// pInfoQueue-&gt;GetMessage(0, pMessage, &amp;messageLength);</c>
		/// </para>
		/// </remarks>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nf-d3d12sdklayers-id3d12infoqueue-getmessage HRESULT
		// GetMessage( [in] UINT64 MessageIndex, [out, optional] D3D12_MESSAGE *pMessage, [in, out] SIZE_T *pMessageByteLength );
		[PreserveSig]
		new HRESULT GetMessage(ulong MessageIndex, [Out, Optional] ManagedStructPointer<D3D12_MESSAGE> pMessage, ref SizeT pMessageByteLength);

		/// <summary>Get the number of messages that were allowed to pass through a storage filter.</summary>
		/// <returns>
		/// <para>Type: <b>UINT64</b></para>
		/// <para>Number of messages allowed by a storage filter.</para>
		/// </returns>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nf-d3d12sdklayers-id3d12infoqueue-getnummessagesallowedbystoragefilter
		// UINT64 GetNumMessagesAllowedByStorageFilter();
		[PreserveSig]
		new ulong GetNumMessagesAllowedByStorageFilter();

		/// <summary>Get the number of messages that were denied passage through a storage filter.</summary>
		/// <returns>
		/// <para>Type: <b>UINT64</b></para>
		/// <para>Number of messages denied by a storage filter.</para>
		/// </returns>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nf-d3d12sdklayers-id3d12infoqueue-getnummessagesdeniedbystoragefilter
		// UINT64 GetNumMessagesDeniedByStorageFilter();
		[PreserveSig]
		new ulong GetNumMessagesDeniedByStorageFilter();

		/// <summary>Get the number of messages currently stored in the message queue.</summary>
		/// <returns>
		/// <para>Type: <b>UINT64</b></para>
		/// <para>Number of messages currently stored in the message queue.</para>
		/// </returns>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nf-d3d12sdklayers-id3d12infoqueue-getnumstoredmessages UINT64 GetNumStoredMessages();
		[PreserveSig]
		new ulong GetNumStoredMessages();

		/// <summary>Get the number of messages that are able to pass through a retrieval filter.</summary>
		/// <returns>
		/// <para>Type: <b>UINT64</b></para>
		/// <para>Number of messages allowed by a retrieval filter.</para>
		/// </returns>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nf-d3d12sdklayers-id3d12infoqueue-getnumstoredmessagesallowedbyretrievalfilter
		// UINT64 GetNumStoredMessagesAllowedByRetrievalFilter();
		[PreserveSig]
		new ulong GetNumStoredMessagesAllowedByRetrievalFilter();

		/// <summary>Get the number of messages that were discarded due to the message count limit.</summary>
		/// <returns>
		/// <para>Type: <b>UINT64</b></para>
		/// <para>Number of messages discarded.</para>
		/// </returns>
		/// <remarks>Get and set the message count limit with <c>GetMessageCountLimit</c> and <c>SetMessageCountLimit</c>, respectively.</remarks>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nf-d3d12sdklayers-id3d12infoqueue-getnummessagesdiscardedbymessagecountlimit
		// UINT64 GetNumMessagesDiscardedByMessageCountLimit();
		[PreserveSig]
		new ulong GetNumMessagesDiscardedByMessageCountLimit();

		/// <summary>Get the maximum number of messages that can be added to the message queue.</summary>
		/// <returns>
		/// <para>Type: <b>UINT64</b></para>
		/// <para>Maximum number of messages that can be added to the queue. -1 means no limit.</para>
		/// <para>
		/// When the number of messages in the message queue has reached the maximum limit, new messages coming in will push old messages out.
		/// </para>
		/// </returns>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nf-d3d12sdklayers-id3d12infoqueue-getmessagecountlimit UINT64 GetMessageCountLimit();
		[PreserveSig]
		new ulong GetMessageCountLimit();

		/// <summary>Add storage filters to the top of the storage-filter stack.</summary>
		/// <param name="pFilter">
		/// <para>Type: <b><c>D3D12_INFO_QUEUE_FILTER</c>*</b></para>
		/// <para>Array of storage filters.</para>
		/// </param>
		/// <returns>
		/// <para>Type: <b><c>HRESULT</c></b></para>
		/// <para>This method returns one of the <c>Direct3D 12 Return Codes</c>.</para>
		/// </returns>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nf-d3d12sdklayers-id3d12infoqueue-addstoragefilterentries
		// HRESULT AddStorageFilterEntries( [in] D3D12_INFO_QUEUE_FILTER *pFilter );
		[PreserveSig]
		new HRESULT AddStorageFilterEntries([In, MarshalAs(UnmanagedType.LPArray)] D3D12_INFO_QUEUE_FILTER[] pFilter);

		/// <summary>Get the storage filter at the top of the storage-filter stack.</summary>
		/// <param name="pFilter">
		/// <para>Type: <b><c>D3D12_INFO_QUEUE_FILTER</c>*</b></para>
		/// <para>Storage filter at the top of the storage-filter stack.</para>
		/// </param>
		/// <param name="pFilterByteLength">
		/// <para>Type: <b>SIZE_T*</b></para>
		/// <para>
		/// Size of the storage filter in bytes. If <i>pFilter</i> is NULL, the size of the storage filter will be output to this parameter.
		/// </para>
		/// </param>
		/// <returns>
		/// <para>Type: <b><c>HRESULT</c></b></para>
		/// <para>This method returns one of the <c>Direct3D 12 Return Codes</c>.</para>
		/// </returns>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nf-d3d12sdklayers-id3d12infoqueue-getstoragefilter HRESULT
		// GetStorageFilter( [out, optional] D3D12_INFO_QUEUE_FILTER *pFilter, [in, out] SIZE_T *pFilterByteLength );
		[PreserveSig]
		new HRESULT GetStorageFilter([Out, Optional] StructPointer<D3D12_INFO_QUEUE_FILTER> pFilter, ref SizeT pFilterByteLength);

		/// <summary>Remove a storage filter from the top of the storage-filter stack.</summary>
		/// <returns>None</returns>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nf-d3d12sdklayers-id3d12infoqueue-clearstoragefilter void ClearStorageFilter();
		[PreserveSig]
		new void ClearStorageFilter();

		/// <summary>Push an empty storage filter onto the storage-filter stack.</summary>
		/// <returns>
		/// <para>Type: <b><c>HRESULT</c></b></para>
		/// <para>This method returns one of the <c>Direct3D 12 Return Codes</c>.</para>
		/// </returns>
		/// <remarks>An empty storage filter allows all messages to pass through.</remarks>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nf-d3d12sdklayers-id3d12infoqueue-pushemptystoragefilter
		// HRESULT PushEmptyStorageFilter();
		[PreserveSig]
		new HRESULT PushEmptyStorageFilter();

		/// <summary>Push a copy of storage filter currently on the top of the storage-filter stack onto the storage-filter stack.</summary>
		/// <returns>
		/// <para>Type: <b><c>HRESULT</c></b></para>
		/// <para>This method returns one of the <c>Direct3D 12 Return Codes</c>.</para>
		/// </returns>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nf-d3d12sdklayers-id3d12infoqueue-pushcopyofstoragefilter
		// HRESULT PushCopyOfStorageFilter();
		[PreserveSig]
		new HRESULT PushCopyOfStorageFilter();

		/// <summary>Push a storage filter onto the storage-filter stack.</summary>
		/// <param name="pFilter">
		/// <para>Type: <b><c>D3D12_INFO_QUEUE_FILTER</c>*</b></para>
		/// <para>Pointer to a storage filter.</para>
		/// </param>
		/// <returns>
		/// <para>Type: <b><c>HRESULT</c></b></para>
		/// <para>This method returns one of the <c>Direct3D 12 Return Codes</c>.</para>
		/// </returns>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nf-d3d12sdklayers-id3d12infoqueue-pushstoragefilter HRESULT
		// PushStorageFilter( [in] D3D12_INFO_QUEUE_FILTER *pFilter );
		[PreserveSig]
		new HRESULT PushStorageFilter(in D3D12_INFO_QUEUE_FILTER pFilter);

		/// <summary>Pop a storage filter from the top of the storage-filter stack.</summary>
		/// <returns>None</returns>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nf-d3d12sdklayers-id3d12infoqueue-popstoragefilter void PopStorageFilter();
		[PreserveSig]
		new void PopStorageFilter();

		/// <summary>Get the size of the storage-filter stack in bytes.</summary>
		/// <returns>
		/// <para>Type: <b>UINT</b></para>
		/// <para>Size of the storage-filter stack in bytes.</para>
		/// </returns>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nf-d3d12sdklayers-id3d12infoqueue-getstoragefilterstacksize
		// UINT GetStorageFilterStackSize();
		[PreserveSig]
		new uint GetStorageFilterStackSize();

		/// <summary>Add storage filters to the top of the retrieval-filter stack.</summary>
		/// <param name="pFilter">
		/// <para>Type: <b><c>D3D12_INFO_QUEUE_FILTER</c>*</b></para>
		/// <para>Array of retrieval filters.</para>
		/// </param>
		/// <returns>
		/// <para>Type: <b><c>HRESULT</c></b></para>
		/// <para>This method returns one of the <c>Direct3D 12 Return Codes</c>.</para>
		/// </returns>
		/// <remarks>
		/// <para>The following code example shows how to use this method:</para>
		/// <para>
		/// <c>D3D12_MESSAGE_CATEGORY cats[] = { ..., ..., ... }; D3D12_MESSAGE_SEVERITY sevs[] = { ..., ..., ... }; D3D12_MESSAGE_ID ids[]
		/// = { ..., ..., ... }; D3D12_INFO_QUEUE_FILTER filter; memset( &amp;filter, 0, sizeof(filter) ); // To set the type of messages to
		/// allow, // set filter.AllowList as follows: filter.AllowList.NumCategories = _countof(cats); filter.AllowList.pCategoryList =
		/// cats; filter.AllowList.NumSeverities = _countof(sevs); filter.AllowList.pSeverityList = sevs; filter.AllowList.NumIDs =
		/// _countof(ids); filter.AllowList.pIDList = ids; // To set the type of messages to deny, set filter.DenyList // similarly to the
		/// preceding filter.AllowList. // The following single call sets all of the preceding information. hr =
		/// infoQueue-&gt;AddRetrievalFilterEntries( &amp;filter );</c>
		/// </para>
		/// </remarks>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nf-d3d12sdklayers-id3d12infoqueue-addretrievalfilterentries
		// HRESULT AddRetrievalFilterEntries( [in] D3D12_INFO_QUEUE_FILTER *pFilter );
		[PreserveSig]
		new HRESULT AddRetrievalFilterEntries([In, MarshalAs(UnmanagedType.LPArray)] D3D12_INFO_QUEUE_FILTER[] pFilter);

		/// <summary>Get the retrieval filter at the top of the retrieval-filter stack.</summary>
		/// <param name="pFilter">
		/// <para>Type: <b><c>D3D12_INFO_QUEUE_FILTER</c>*</b></para>
		/// <para>Retrieval filter at the top of the retrieval-filter stack.</para>
		/// </param>
		/// <param name="pFilterByteLength">
		/// <para>Type: <b>SIZE_T*</b></para>
		/// <para>
		/// Size of the retrieval filter in bytes. If <i>pFilter</i> is NULL, the size of the retrieval filter will be output to this parameter.
		/// </para>
		/// </param>
		/// <returns>
		/// <para>Type: <b><c>HRESULT</c></b></para>
		/// <para>This method returns one of the <c>Direct3D 12 Return Codes</c>.</para>
		/// </returns>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nf-d3d12sdklayers-id3d12infoqueue-getretrievalfilter HRESULT
		// GetRetrievalFilter( [out, optional] D3D12_INFO_QUEUE_FILTER *pFilter, [in, out] SIZE_T *pFilterByteLength );
		[PreserveSig]
		new HRESULT GetRetrievalFilter([Out, Optional] StructPointer<D3D12_INFO_QUEUE_FILTER> pFilter, ref SizeT pFilterByteLength);

		/// <summary>Remove a retrieval filter from the top of the retrieval-filter stack.</summary>
		/// <returns>None</returns>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nf-d3d12sdklayers-id3d12infoqueue-clearretrievalfilter void ClearRetrievalFilter();
		[PreserveSig]
		new void ClearRetrievalFilter();

		/// <summary>Push an empty retrieval filter onto the retrieval-filter stack.</summary>
		/// <returns>
		/// <para>Type: <b><c>HRESULT</c></b></para>
		/// <para>This method returns one of the <c>Direct3D 12 Return Codes</c>.</para>
		/// </returns>
		/// <remarks>An empty retrieval filter allows all messages to pass through.</remarks>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nf-d3d12sdklayers-id3d12infoqueue-pushemptyretrievalfilter
		// HRESULT PushEmptyRetrievalFilter();
		[PreserveSig]
		new HRESULT PushEmptyRetrievalFilter();

		/// <summary>Push a copy of retrieval filter currently on the top of the retrieval-filter stack onto the retrieval-filter stack.</summary>
		/// <returns>
		/// <para>Type: <b><c>HRESULT</c></b></para>
		/// <para>This method returns one of the <c>Direct3D 12 Return Codes</c>.</para>
		/// </returns>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nf-d3d12sdklayers-id3d12infoqueue-pushcopyofretrievalfilter
		// HRESULT PushCopyOfRetrievalFilter();
		[PreserveSig]
		new HRESULT PushCopyOfRetrievalFilter();

		/// <summary>Push a retrieval filter onto the retrieval-filter stack.</summary>
		/// <param name="pFilter">
		/// <para>Type: <b><c>D3D12_INFO_QUEUE_FILTER</c>*</b></para>
		/// <para>Pointer to a retrieval filter.</para>
		/// </param>
		/// <returns>
		/// <para>Type: <b><c>HRESULT</c></b></para>
		/// <para>This method returns one of the <c>Direct3D 12 Return Codes</c>.</para>
		/// </returns>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nf-d3d12sdklayers-id3d12infoqueue-pushretrievalfilter HRESULT
		// PushRetrievalFilter( [in] D3D12_INFO_QUEUE_FILTER *pFilter );
		[PreserveSig]
		new HRESULT PushRetrievalFilter(in D3D12_INFO_QUEUE_FILTER pFilter);

		/// <summary>Pop a retrieval filter from the top of the retrieval-filter stack.</summary>
		/// <returns>None</returns>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nf-d3d12sdklayers-id3d12infoqueue-popretrievalfilter void PopRetrievalFilter();
		[PreserveSig]
		new void PopRetrievalFilter();

		/// <summary>Get the size of the retrieval-filter stack in bytes.</summary>
		/// <returns>
		/// <para>Type: <b>UINT</b></para>
		/// <para>Size of the retrieval-filter stack in bytes.</para>
		/// </returns>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nf-d3d12sdklayers-id3d12infoqueue-getretrievalfilterstacksize
		// UINT GetRetrievalFilterStackSize();
		[PreserveSig]
		new uint GetRetrievalFilterStackSize();

		/// <summary>Adds a debug message to the message queue and sends that message to debug output.</summary>
		/// <param name="Category">
		/// <para>Type: <b><c>D3D12_MESSAGE_CATEGORY</c></b></para>
		/// <para>Category of a message.</para>
		/// </param>
		/// <param name="Severity">
		/// <para>Type: <b><c>D3D12_MESSAGE_SEVERITY</c></b></para>
		/// <para>Severity of a message.</para>
		/// </param>
		/// <param name="ID">
		/// <para>Type: <b><c>D3D12_MESSAGE_ID</c></b></para>
		/// <para>Unique identifier of a message.</para>
		/// </param>
		/// <param name="pDescription">
		/// <para>Type: <b>LPCSTR</b></para>
		/// <para>User-defined message.</para>
		/// </param>
		/// <returns>
		/// <para>Type: <b><c>HRESULT</c></b></para>
		/// <para>This method returns one of the <c>Direct3D 12 Return Codes</c>.</para>
		/// </returns>
		/// <remarks>
		/// This method is used by the runtime's internal mechanisms to add debug messages to the message queue and send them to debug
		/// output. For applications to add their own custom messages to the message queue and send them to debug output, call <c>ID3D12InfoQueue::AddApplicationMessage</c>.
		/// </remarks>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nf-d3d12sdklayers-id3d12infoqueue-addmessage HRESULT
		// AddMessage( [in] D3D12_MESSAGE_CATEGORY Category, [in] D3D12_MESSAGE_SEVERITY Severity, [in] D3D12_MESSAGE_ID ID, [in] LPCSTR
		// pDescription );
		[PreserveSig]
		new HRESULT AddMessage(D3D12_MESSAGE_CATEGORY Category, D3D12_MESSAGE_SEVERITY Severity, D3D12_MESSAGE_ID ID,
			[MarshalAs(UnmanagedType.LPStr)] string pDescription);

		/// <summary>Adds a user-defined message to the message queue and sends that message to debug output.</summary>
		/// <param name="Severity">
		/// <para>Type: <b><c>D3D12_MESSAGE_SEVERITY</c></b></para>
		/// <para>Severity of a message.</para>
		/// </param>
		/// <param name="pDescription">
		/// <para>Type: <b>LPCSTR</b></para>
		/// <para>Specifies the message string.</para>
		/// </param>
		/// <returns>
		/// <para>Type: <b><c>HRESULT</c></b></para>
		/// <para>This method returns one of the <c>Direct3D 12 Return Codes</c>.</para>
		/// </returns>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nf-d3d12sdklayers-id3d12infoqueue-addapplicationmessage
		// HRESULT AddApplicationMessage( [in] D3D12_MESSAGE_SEVERITY Severity, [in] LPCSTR pDescription );
		[PreserveSig]
		new HRESULT AddApplicationMessage(D3D12_MESSAGE_SEVERITY Severity, [MarshalAs(UnmanagedType.LPStr)] string pDescription);

		/// <summary>Set a message category to break on when a message with that category passes through the storage filter.</summary>
		/// <param name="Category">
		/// <para>Type: <b><c>D3D12_MESSAGE_CATEGORY</c></b></para>
		/// <para>Message category to break on.</para>
		/// </param>
		/// <param name="bEnable">
		/// <para>Type: <b>BOOL</b></para>
		/// <para>Turns this breaking condition on or off (true for on, false for off).</para>
		/// </param>
		/// <returns>
		/// <para>Type: <b><c>HRESULT</c></b></para>
		/// <para>This method returns one of the <c>Direct3D 12 Return Codes</c>.</para>
		/// </returns>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nf-d3d12sdklayers-id3d12infoqueue-setbreakoncategory HRESULT
		// SetBreakOnCategory( [in] D3D12_MESSAGE_CATEGORY Category, [in] BOOL bEnable );
		[PreserveSig]
		new HRESULT SetBreakOnCategory(D3D12_MESSAGE_CATEGORY Category, bool bEnable);

		/// <summary>Set a message severity level to break on when a message with that severity level passes through the storage filter.</summary>
		/// <param name="Severity">
		/// <para>Type: <b><c>D3D12_MESSAGE_SEVERITY</c></b></para>
		/// <para>A message severity level to break on.</para>
		/// </param>
		/// <param name="bEnable">
		/// <para>Type: <b>BOOL</b></para>
		/// <para>Turns this breaking condition on or off (true for on, false for off).</para>
		/// </param>
		/// <returns>
		/// <para>Type: <b><c>HRESULT</c></b></para>
		/// <para>This method returns one of the <c>Direct3D 12 Return Codes</c>.</para>
		/// </returns>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nf-d3d12sdklayers-id3d12infoqueue-setbreakonseverity HRESULT
		// SetBreakOnSeverity( [in] D3D12_MESSAGE_SEVERITY Severity, [in] BOOL bEnable );
		[PreserveSig]
		new HRESULT SetBreakOnSeverity(D3D12_MESSAGE_SEVERITY Severity, bool bEnable);

		/// <summary>Set a message identifier to break on when a message with that identifier passes through the storage filter.</summary>
		/// <param name="ID">
		/// <para>Type: <b><c>D3D12_MESSAGE_ID</c></b></para>
		/// <para>Message identifier to break on.</para>
		/// </param>
		/// <param name="bEnable">
		/// <para>Type: <b>BOOL</b></para>
		/// <para>Turns this breaking condition on or off (true for on, false for off).</para>
		/// </param>
		/// <returns>
		/// <para>Type: <b><c>HRESULT</c></b></para>
		/// <para>This method returns one of the <c>Direct3D 12 Return Codes</c>.</para>
		/// </returns>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nf-d3d12sdklayers-id3d12infoqueue-setbreakonid HRESULT
		// SetBreakOnID( [in] D3D12_MESSAGE_ID ID, [in] BOOL bEnable );
		[PreserveSig]
		new HRESULT SetBreakOnID(D3D12_MESSAGE_ID ID, bool bEnable);

		/// <summary>Get a message category to break on when a message with that category passes through the storage filter.</summary>
		/// <param name="Category">
		/// <para>Type: <b><c>D3D12_MESSAGE_CATEGORY</c></b></para>
		/// <para>Message category to break on.</para>
		/// </param>
		/// <returns>
		/// <para>Type: <b>BOOL</b></para>
		/// <para>Whether this breaking condition is turned on or off (true for on, false for off).</para>
		/// </returns>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nf-d3d12sdklayers-id3d12infoqueue-getbreakoncategory BOOL
		// GetBreakOnCategory( [in] D3D12_MESSAGE_CATEGORY Category );
		[PreserveSig]
		new bool GetBreakOnCategory(D3D12_MESSAGE_CATEGORY Category);

		/// <summary>Get a message severity level to break on when a message with that severity level passes through the storage filter.</summary>
		/// <param name="Severity">
		/// <para>Type: <b><c>D3D12_MESSAGE_SEVERITY</c></b></para>
		/// <para>Message severity level to break on.</para>
		/// </param>
		/// <returns>
		/// <para>Type: <b>BOOL</b></para>
		/// <para>Whether this breaking condition is turned on or off (true for on, false for off).</para>
		/// </returns>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nf-d3d12sdklayers-id3d12infoqueue-getbreakonseverity BOOL
		// GetBreakOnSeverity( [in] D3D12_MESSAGE_SEVERITY Severity );
		[PreserveSig]
		new bool GetBreakOnSeverity(D3D12_MESSAGE_SEVERITY Severity);

		/// <summary>Get a message identifier to break on when a message with that identifier passes through the storage filter.</summary>
		/// <param name="ID">
		/// <para>Type: <b><c>D3D12_MESSAGE_ID</c></b></para>
		/// <para>Message identifier to break on.</para>
		/// </param>
		/// <returns>
		/// <para>Type: <b>BOOL</b></para>
		/// <para>Whether this breaking condition is turned on or off (true for on, false for off).</para>
		/// </returns>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nf-d3d12sdklayers-id3d12infoqueue-getbreakonid BOOL
		// GetBreakOnID( [in] D3D12_MESSAGE_ID ID );
		[PreserveSig]
		new bool GetBreakOnID(D3D12_MESSAGE_ID ID);

		/// <summary>Set a boolean that turns the debug output on or off.</summary>
		/// <param name="bMute">
		/// <para>Type: <b>BOOL</b></para>
		/// <para>Disable/Enable the debug output (true to disable or mute the output, false to enable the output).</para>
		/// </param>
		/// <returns>None</returns>
		/// <remarks>
		/// This will stop messages that pass the storage filter from being printed out in the debug output, however those messages will
		/// still be added to the message queue.
		/// </remarks>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nf-d3d12sdklayers-id3d12infoqueue-setmutedebugoutput void
		// SetMuteDebugOutput( [in] BOOL bMute );
		[PreserveSig]
		new void SetMuteDebugOutput(bool bMute);

		/// <summary>Get a boolean that determines if debug output is on or off.</summary>
		/// <returns>
		/// <para>Type: <b>BOOL</b></para>
		/// <para>Whether the debug output is on or off (true for on, false for off).</para>
		/// </returns>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nf-d3d12sdklayers-id3d12infoqueue-getmutedebugoutput BOOL GetMuteDebugOutput();
		[PreserveSig]
		new bool GetMuteDebugOutput();

		/// <summary/>
		[PreserveSig]
		HRESULT RegisterMessageCallback([In] D3D12MessageFunc CallbackFunc, D3D12_MESSAGE_CALLBACK_FLAGS CallbackFilterFlags, [In, Out] IntPtr pContext,
			ref uint pCallbackCookie);

		/// <summary/>
		[PreserveSig]
		HRESULT UnregisterMessageCallback(uint CallbackCookie);
	}

	/// <summary>
	/// <para>
	/// Part of a contract between D3D11On12 diagnostic layers and graphics diagnostics tools. This interface facilitates diagnostics tools
	/// to capture information at a lower level than the DXGI swapchain.
	/// </para>
	/// <para>
	/// You may want to use this interface to enable diagnostic tools to capture usage patterns that don't use DXGI swap chains for
	/// presentation. If so, you can access this interface via <b>QueryInterface</b> from a D3D12 command queue. Note that this interface is
	/// not supported when there are no diagnostic tools present, so your application mustn't rely on it existing.
	/// </para>
	/// </summary>
	// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nn-d3d12sdklayers-id3d12sharingcontract
	[PInvokeData("d3d12sdklayers.h", MSDNShortId = "NN:d3d12sdklayers.ID3D12SharingContract")]
	[ComImport, Guid("0adf7d52-929c-4e61-addb-ffed30de66ef"), InterfaceType(ComInterfaceType.InterfaceIsIUnknown)]
	public interface ID3D12SharingContract
	{
		/// <summary>
		/// Notifies diagnostic tools about an end-of-frame operation without the use of a swap chain. Calling this API enables usage of
		/// tools like PIX with applications that either don't render to a window, or that do so in non-traditional ways.
		/// </summary>
		/// <param name="pResource">
		/// <para>Type: <b><c>ID3D12Resource</c>*</b></para>
		/// <para>A pointer to the resource that contains the final frame contents. This resource is treated as the back buffer of the <b>Present</b>.</para>
		/// </param>
		/// <param name="Subresource">
		/// <para>Type: <b><c>UINT</c></b></para>
		/// <para>An unsigned 32bit subresource id.</para>
		/// </param>
		/// <param name="window">If provided, indicates which window the tools should use for displaying additional diagnostic information.</param>
		/// <returns>None</returns>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nf-d3d12sdklayers-id3d12sharingcontract-present void Present(
		// [in] ID3D12Resource *pResource, UINT Subresource, HWND window );
		[PreserveSig]
		void Present([In] ID3D12Resource pResource, uint Subresource, HWND window);

		/// <summary>Signals a shared fence between the D3D layers and diagnostics tools.</summary>
		/// <param name="pFence">
		/// <para>Type: <b><c>ID3D12Fence</c>*</b></para>
		/// <para>A pointer to the shared fence to signal.</para>
		/// </param>
		/// <param name="FenceValue">
		/// <para>Type: <b><c>UINT64</c></b></para>
		/// <para>An unsigned 64bit value to signal the shared fence with.</para>
		/// </param>
		/// <returns>None</returns>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/nf-d3d12sdklayers-id3d12sharingcontract-sharedfencesignal void
		// SharedFenceSignal( [in] ID3D12Fence *pFence, UINT64 FenceValue );
		[PreserveSig]
		void SharedFenceSignal([In] ID3D12Fence pFence, ulong FenceValue);

		/// <summary>Undocumented</summary>
		[PreserveSig]
		void BeginCapturableWork(in Guid guid);

		/// <summary>Undocumented</summary>
		[PreserveSig]
		void EndCapturableWork(in Guid guid);
	}

	/// <summary>Describes per-command-list settings used by GPU-Based Validation.</summary>
	/// <remarks>
	/// Point to an object using this structure with the <i>pData</i> member of <c>ID3D12DebugCommandList1::SetDebugParameter</c> to
	/// configure per-command-list GPU-Based Validation settings.
	/// </remarks>
	// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/ns-d3d12sdklayers-d3d12_debug_command_list_gpu_based_validation_settings
	// typedef struct D3D12_DEBUG_COMMAND_LIST_GPU_BASED_VALIDATION_SETTINGS { D3D12_GPU_BASED_VALIDATION_SHADER_PATCH_MODE ShaderPatchMode;
	// } D3D12_DEBUG_COMMAND_LIST_GPU_BASED_VALIDATION_SETTINGS;
	[PInvokeData("d3d12sdklayers.h", MSDNShortId = "NS:d3d12sdklayers.D3D12_DEBUG_COMMAND_LIST_GPU_BASED_VALIDATION_SETTINGS")]
	[StructLayout(LayoutKind.Sequential)]
	public struct D3D12_DEBUG_COMMAND_LIST_GPU_BASED_VALIDATION_SETTINGS
	{
		/// <summary>
		/// Specifies a <c>D3D12_GPU_BASED_VALIDATION_SHADER_PATCH_MODE</c> that overrides the default device-level shader patch mode (see
		/// <c>ID3D12DebugDevice1::SetDebugParameter</c>). By default this value is initialized to the <i>DefaultShaderPatchMode</i>
		/// assigned to the device (see <c>D3D12_DEBUG_DEVICE_GPU_BASED_VALIDATION_SETTINGS</c>.
		/// </summary>
		public D3D12_GPU_BASED_VALIDATION_SHADER_PATCH_MODE ShaderPatchMode;
	}

	/// <summary>Describes settings used by GPU-Based Validation.</summary>
	/// <remarks>
	/// <para>
	/// Point to an object using this structure with the <i>pData</i> member of <c>ID3D12DebugDevice1::SetDebugParameter</c> to configure
	/// device-wide GPU-Based Validation settings.
	/// </para>
	/// <para>Individual command lists can override the default shader patch mode using <c>ID3D12DebugCommandList1::SetDebugParameter</c>.</para>
	/// </remarks>
	// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/ns-d3d12sdklayers-d3d12_debug_device_gpu_based_validation_settings
	// typedef struct D3D12_DEBUG_DEVICE_GPU_BASED_VALIDATION_SETTINGS { UINT MaxMessagesPerCommandList;
	// D3D12_GPU_BASED_VALIDATION_SHADER_PATCH_MODE DefaultShaderPatchMode; D3D12_GPU_BASED_VALIDATION_PIPELINE_STATE_CREATE_FLAGS
	// PipelineStateCreateFlags; } D3D12_DEBUG_DEVICE_GPU_BASED_VALIDATION_SETTINGS;
	[PInvokeData("d3d12sdklayers.h", MSDNShortId = "NS:d3d12sdklayers.D3D12_DEBUG_DEVICE_GPU_BASED_VALIDATION_SETTINGS")]
	[StructLayout(LayoutKind.Sequential)]
	public struct D3D12_DEBUG_DEVICE_GPU_BASED_VALIDATION_SETTINGS
	{
		/// <summary>
		/// Specifies a UINT that limits the number of messages that can be stored in the GPU-Based Validation message log. The default
		/// value is 256. Since many identical errors can be produced in a single Draw/Dispatch call it may be useful to increase this
		/// number. Note this can become a memory burden if a large number of command lists are used as there is a committed message log per
		/// command list.
		/// </summary>
		public uint MaxMessagesPerCommandList;

		/// <summary>
		/// Specifies the <c>D3D12_GPU_BASED_VALIDATION_SHADER_PATCH_MODE</c> that GPU-Based Validation uses when injecting validation code
		/// into shaders, except when overridden by per-command-list GPU-Based Validation settings (see
		/// <c>D3D12_DEBUG_COMMAND_LIST_GPU_BASED_VALIDATION_SETTINGS</c>). The default value is D3D12_GPU_BASED_VALIDATION_SHADER_PATCH_MODE_UNGUARDED_VALIDATION.
		/// </summary>
		public D3D12_GPU_BASED_VALIDATION_SHADER_PATCH_MODE DefaultShaderPatchMode;

		/// <summary>
		/// Specifies one of the <c>D3D12_GPU_BASED_VALIDATION_PIPELINE_STATE_CREATE_FLAGS</c> that indicates how GPU-Based Validation
		/// handles patching pipeline states. The default value is D3D12_GPU_BASED_VALIDATION_PIPELINE_STATE_CREATE_FLAG_NONE.
		/// </summary>
		public D3D12_GPU_BASED_VALIDATION_PIPELINE_STATE_CREATE_FLAGS PipelineStateCreateFlags;
	}

	/// <summary>Describes the amount of artificial slowdown inserted by the debug device to simulate lower-performance graphics adapters.</summary>
	/// <remarks>
	/// The SlowdownFactor is applied by artificially delaying the time it takes for a fence to signal. When SlowdownFactor is non-zero, the
	/// time taken for a fence to signal is approximately 1.0 + SlowdownFactor times the length of the nominal timing.
	/// </remarks>
	// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/ns-d3d12sdklayers-d3d12_debug_device_gpu_slowdown_performance_factor
	// typedef struct D3D12_DEBUG_DEVICE_GPU_SLOWDOWN_PERFORMANCE_FACTOR { FLOAT SlowdownFactor; } D3D12_DEBUG_DEVICE_GPU_SLOWDOWN_PERFORMANCE_FACTOR;
	[PInvokeData("d3d12sdklayers.h", MSDNShortId = "NS:d3d12sdklayers.D3D12_DEBUG_DEVICE_GPU_SLOWDOWN_PERFORMANCE_FACTOR")]
	[StructLayout(LayoutKind.Sequential)]
	public struct D3D12_DEBUG_DEVICE_GPU_SLOWDOWN_PERFORMANCE_FACTOR
	{
		/// <summary>
		/// Specifies the amount of slowdown artificially applied, as a factor of the nominal time for the fence to signal. The default
		/// value is 0.
		/// </summary>
		public float SlowdownFactor;
	}

	/// <summary>Debug message filter; contains a lists of message types to allow or deny.</summary>
	/// <remarks>For use with an <c>ID3D12InfoQueue</c> Interface.</remarks>
	// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/ns-d3d12sdklayers-d3d12_info_queue_filter typedef struct
	// D3D12_INFO_QUEUE_FILTER { D3D12_INFO_QUEUE_FILTER_DESC AllowList; D3D12_INFO_QUEUE_FILTER_DESC DenyList; } D3D12_INFO_QUEUE_FILTER;
	[PInvokeData("d3d12sdklayers.h", MSDNShortId = "NS:d3d12sdklayers.D3D12_INFO_QUEUE_FILTER")]
	[StructLayout(LayoutKind.Sequential)]
	public struct D3D12_INFO_QUEUE_FILTER
	{
		/// <summary>Specifies types of messages that you want to allow. See <c>D3D12_INFO_QUEUE_FILTER_DESC</c>.</summary>
		public D3D12_INFO_QUEUE_FILTER_DESC AllowList;

		/// <summary>Specifies types of messages that you want to deny.</summary>
		public D3D12_INFO_QUEUE_FILTER_DESC DenyList;
	}

	/// <summary>Allow or deny certain types of messages to pass through a filter.</summary>
	/// <remarks>For use with an <c>ID3D12InfoQueue</c> Interface.</remarks>
	// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/ns-d3d12sdklayers-d3d12_info_queue_filter_desc typedef struct
	// D3D12_INFO_QUEUE_FILTER_DESC { UINT NumCategories; D3D12_MESSAGE_CATEGORY *pCategoryList; UINT NumSeverities; D3D12_MESSAGE_SEVERITY
	// *pSeverityList; UINT NumIDs; D3D12_MESSAGE_ID *pIDList; } D3D12_INFO_QUEUE_FILTER_DESC;
	[PInvokeData("d3d12sdklayers.h", MSDNShortId = "NS:d3d12sdklayers.D3D12_INFO_QUEUE_FILTER_DESC")]
	[StructLayout(LayoutKind.Sequential)]
	public struct D3D12_INFO_QUEUE_FILTER_DESC
	{
		/// <summary>Number of message categories to allow or deny.</summary>
		public uint NumCategories;

		/// <summary>Array of message categories to allow or deny. Array must have at least <i>NumCategories</i> members (see <c>D3D12_MESSAGE_CATEGORY</c>).</summary>
		public ArrayPointer<D3D12_MESSAGE_CATEGORY> pCategoryList;

		/// <summary>Number of message severity levels to allow or deny.</summary>
		public uint NumSeverities;

		/// <summary>Array of message severity levels to allow or deny. Array must have at least <i>NumSeverities</i> members (see <c>D3D12_MESSAGE_SEVERITY</c>).</summary>
		public ArrayPointer<D3D12_MESSAGE_SEVERITY> pSeverityList;

		/// <summary>Number of message IDs to allow or deny.</summary>
		public uint NumIDs;

		/// <summary>Array of message IDs to allow or deny. Array must have at least <i>NumIDs</i> members (see <c>D3D12_MESSAGE_ID</c>).</summary>
		public ArrayPointer<D3D12_MESSAGE_ID> pIDList;
	}

	/// <summary>A debug message in the Information Queue.</summary>
	/// <remarks>This structure is returned from <c>ID3D12InfoQueue::GetMessage</c> as part of the Information Queue feature (see <c>ID3D12InfoQueue</c>).</remarks>
	// https://learn.microsoft.com/en-us/windows/win32/api/d3d12sdklayers/ns-d3d12sdklayers-d3d12_message typedef struct D3D12_MESSAGE {
	// D3D12_MESSAGE_CATEGORY Category; D3D12_MESSAGE_SEVERITY Severity; D3D12_MESSAGE_ID ID; const char *pDescription; SIZE_T
	// DescriptionByteLength; } D3D12_MESSAGE;
	[PInvokeData("d3d12sdklayers.h", MSDNShortId = "NS:d3d12sdklayers.D3D12_MESSAGE")]
	[StructLayout(LayoutKind.Sequential)]
	public struct D3D12_MESSAGE
	{
		/// <summary>The category of the message. See <c>D3D12_MESSAGE_CATEGORY</c>.</summary>
		public D3D12_MESSAGE_CATEGORY Category;

		/// <summary>The severity of the message. See <c>D3D12_MESSAGE_SEVERITY</c>.</summary>
		public D3D12_MESSAGE_SEVERITY Severity;

		/// <summary>The ID of the message. See <c>D3D12_MESSAGE_ID</c>.</summary>
		public D3D12_MESSAGE_ID ID;

		/// <summary>The message string.</summary>
		[MarshalAs(UnmanagedType.LPStr)] public string pDescription;

		/// <summary>The length of <i>pDescription</i>, in bytes.</summary>
		public SizeT DescriptionByteLength;
	}
}