﻿namespace Vanara.PInvoke;

public static partial class D3D11
{
	/// <summary>
	/// Setting one of the following feature-mask flags will cause a rendering-operation method (listed below) to do some extra task when called.
	/// </summary>
	[PInvokeData("d3d11sdklayers.h", MSDNShortId = "NN:d3d11sdklayers.D3D11_DEBUG_FEATURE")]
	[Flags]
	public enum D3D11_DEBUG_FEATURE
	{
		/// <summary>Runtime will additionally call ID3D11DeviceContext::Flush.</summary>
		D3D11_DEBUG_FEATURE_FLUSH_PER_RENDER_OP = 0x1,

		/// <summary>Application will wait for the GPU to finish processing the rendering operation before continuing.</summary>
		D3D11_DEBUG_FEATURE_FINISH_PER_RENDER_OP = 0x2,

		/// <summary>
		/// Runtime will call IDXGISwapChain::Present. Presentation of render buffers will occur according to the settings established by
		/// prior calls to ID3D11Debug::SetSwapChain and ID3D11Debug::SetPresentPerRenderOpDelay.
		/// </summary>
		D3D11_DEBUG_FEATURE_PRESENT_PER_RENDER_OP = 0x4,

		/// <summary>
		/// When you call IDXGIDevice2::OfferResources to offer resources while this flag is enabled, their content is always discarded. Use
		/// this flag to test code paths that regenerate resource content on reclaim. You cannot use this flag in combination with D3D11_DEBUG_FEATURE_NEVER_DISCARD_OFFERED_RESOURCE.
		/// </summary>
		D3D11_DEBUG_FEATURE_ALWAYS_DISCARD_OFFERED_RESOURCE = 0x8,

		/// <summary>
		/// When you call IDXGIDevice2::OfferResources to offer resources while this flag is enabled, their content is never discarded. Use
		/// this flag to test code paths that do not need to regenerate resource content on reclaim. You cannot use this flag in combination
		/// with D3D11_DEBUG_FEATURE_ALWAYS_DISCARD_OFFERED_RESOURCE.
		/// </summary>
		D3D11_DEBUG_FEATURE_NEVER_DISCARD_OFFERED_RESOURCE = 0x10,

		/// <summary>Disables the following default debugging behavior.</summary>
		D3D11_DEBUG_FEATURE_AVOID_BEHAVIOR_CHANGING_DEBUG_AIDS = 0x40,

		/// <summary>Disables the following default debugging behavior.</summary>
		D3D11_DEBUG_FEATURE_DISABLE_TILED_RESOURCE_MAPPING_TRACKING_AND_VALIDATION = 0x80,
	}

	/// <summary>
	/// Categories of debug messages. This will identify the category of a message when retrieving a message with
	/// ID3D11InfoQueue::GetMessage and when adding a message with ID3D11InfoQueue::AddMessage. When creating an info queue filter, these
	/// values can be used to allow or deny any categories of messages to pass through the storage and retrieval filters.
	/// </summary>
	/// <remarks>This is part of the Information Queue feature. See ID3D11InfoQueue Interface.</remarks>
	// https://learn.microsoft.com/en-us/windows/win32/api/d3d11sdklayers/ne-d3d11sdklayers-d3d11_message_category typedef enum
	// D3D11_MESSAGE_CATEGORY { D3D11_MESSAGE_CATEGORY_APPLICATION_DEFINED = 0, D3D11_MESSAGE_CATEGORY_MISCELLANEOUS,
	// D3D11_MESSAGE_CATEGORY_INITIALIZATION, D3D11_MESSAGE_CATEGORY_CLEANUP, D3D11_MESSAGE_CATEGORY_COMPILATION,
	// D3D11_MESSAGE_CATEGORY_STATE_CREATION, D3D11_MESSAGE_CATEGORY_STATE_SETTING, D3D11_MESSAGE_CATEGORY_STATE_GETTING,
	// D3D11_MESSAGE_CATEGORY_RESOURCE_MANIPULATION, D3D11_MESSAGE_CATEGORY_EXECUTION, D3D11_MESSAGE_CATEGORY_SHADER } ;
	[PInvokeData("d3d11sdklayers.h", MSDNShortId = "NE:d3d11sdklayers.D3D11_MESSAGE_CATEGORY")]
	public enum D3D11_MESSAGE_CATEGORY
	{
		/// <summary>
		/// <para>Value:</para>
		/// <para>0</para>
		/// <para>User defined message. See</para>
		/// <para>ID3D11InfoQueue::AddMessage</para>
		/// <para>.</para>
		/// </summary>
		D3D11_MESSAGE_CATEGORY_APPLICATION_DEFINED = 0,

		/// <summary/>
		D3D11_MESSAGE_CATEGORY_MISCELLANEOUS,

		/// <summary/>
		D3D11_MESSAGE_CATEGORY_INITIALIZATION,

		/// <summary/>
		D3D11_MESSAGE_CATEGORY_CLEANUP,

		/// <summary/>
		D3D11_MESSAGE_CATEGORY_COMPILATION,

		/// <summary/>
		D3D11_MESSAGE_CATEGORY_STATE_CREATION,

		/// <summary/>
		D3D11_MESSAGE_CATEGORY_STATE_SETTING,

		/// <summary/>
		D3D11_MESSAGE_CATEGORY_STATE_GETTING,

		/// <summary/>
		D3D11_MESSAGE_CATEGORY_RESOURCE_MANIPULATION,

		/// <summary/>
		D3D11_MESSAGE_CATEGORY_EXECUTION,

		/// <summary>
		/// <para>Direct3D 11:  </para>
		/// <para>This value is not supported until Direct3D 11.1.</para>
		/// </summary>
		D3D11_MESSAGE_CATEGORY_SHADER,
	}

	/// <summary>
	/// Debug messages for setting up an info-queue filter (see D3D11_INFO_QUEUE_FILTER); use these messages to allow or deny message
	/// categories to pass through the storage and retrieval filters. These IDs are used by methods such as ID3D11InfoQueue::GetMessage or ID3D11InfoQueue::AddMessage.
	/// </summary>
	// https://learn.microsoft.com/en-us/windows/win32/api/d3d11sdklayers/ne-d3d11sdklayers-d3d11_message_id typedef enum D3D11_MESSAGE_ID {
	// D3D11_MESSAGE_ID_UNKNOWN = 0, D3D11_MESSAGE_ID_DEVICE_IASETVERTEXBUFFERS_HAZARD, D3D11_MESSAGE_ID_DEVICE_IASETINDEXBUFFER_HAZARD,
	// D3D11_MESSAGE_ID_DEVICE_VSSETSHADERRESOURCES_HAZARD, D3D11_MESSAGE_ID_DEVICE_VSSETCONSTANTBUFFERS_HAZARD,
	// D3D11_MESSAGE_ID_DEVICE_GSSETSHADERRESOURCES_HAZARD, D3D11_MESSAGE_ID_DEVICE_GSSETCONSTANTBUFFERS_HAZARD,
	// D3D11_MESSAGE_ID_DEVICE_PSSETSHADERRESOURCES_HAZARD, D3D11_MESSAGE_ID_DEVICE_PSSETCONSTANTBUFFERS_HAZARD,
	// D3D11_MESSAGE_ID_DEVICE_OMSETRENDERTARGETS_HAZARD, D3D11_MESSAGE_ID_DEVICE_SOSETTARGETS_HAZARD,
	// D3D11_MESSAGE_ID_STRING_FROM_APPLICATION, D3D11_MESSAGE_ID_CORRUPTED_THIS, D3D11_MESSAGE_ID_CORRUPTED_PARAMETER1,
	// D3D11_MESSAGE_ID_CORRUPTED_PARAMETER2, D3D11_MESSAGE_ID_CORRUPTED_PARAMETER3, D3D11_MESSAGE_ID_CORRUPTED_PARAMETER4,
	// D3D11_MESSAGE_ID_CORRUPTED_PARAMETER5, D3D11_MESSAGE_ID_CORRUPTED_PARAMETER6, D3D11_MESSAGE_ID_CORRUPTED_PARAMETER7,
	// D3D11_MESSAGE_ID_CORRUPTED_PARAMETER8, D3D11_MESSAGE_ID_CORRUPTED_PARAMETER9, D3D11_MESSAGE_ID_CORRUPTED_PARAMETER10,
	// D3D11_MESSAGE_ID_CORRUPTED_PARAMETER11, D3D11_MESSAGE_ID_CORRUPTED_PARAMETER12, D3D11_MESSAGE_ID_CORRUPTED_PARAMETER13,
	// D3D11_MESSAGE_ID_CORRUPTED_PARAMETER14, D3D11_MESSAGE_ID_CORRUPTED_PARAMETER15, D3D11_MESSAGE_ID_CORRUPTED_MULTITHREADING,
	// D3D11_MESSAGE_ID_MESSAGE_REPORTING_OUTOFMEMORY, D3D11_MESSAGE_ID_IASETINPUTLAYOUT_UNBINDDELETINGOBJECT,
	// D3D11_MESSAGE_ID_IASETVERTEXBUFFERS_UNBINDDELETINGOBJECT, D3D11_MESSAGE_ID_IASETINDEXBUFFER_UNBINDDELETINGOBJECT,
	// D3D11_MESSAGE_ID_VSSETSHADER_UNBINDDELETINGOBJECT, D3D11_MESSAGE_ID_VSSETSHADERRESOURCES_UNBINDDELETINGOBJECT,
	// D3D11_MESSAGE_ID_VSSETCONSTANTBUFFERS_UNBINDDELETINGOBJECT, D3D11_MESSAGE_ID_VSSETSAMPLERS_UNBINDDELETINGOBJECT,
	// D3D11_MESSAGE_ID_GSSETSHADER_UNBINDDELETINGOBJECT, D3D11_MESSAGE_ID_GSSETSHADERRESOURCES_UNBINDDELETINGOBJECT,
	// D3D11_MESSAGE_ID_GSSETCONSTANTBUFFERS_UNBINDDELETINGOBJECT, D3D11_MESSAGE_ID_GSSETSAMPLERS_UNBINDDELETINGOBJECT,
	// D3D11_MESSAGE_ID_SOSETTARGETS_UNBINDDELETINGOBJECT, D3D11_MESSAGE_ID_PSSETSHADER_UNBINDDELETINGOBJECT,
	// D3D11_MESSAGE_ID_PSSETSHADERRESOURCES_UNBINDDELETINGOBJECT, D3D11_MESSAGE_ID_PSSETCONSTANTBUFFERS_UNBINDDELETINGOBJECT,
	// D3D11_MESSAGE_ID_PSSETSAMPLERS_UNBINDDELETINGOBJECT, D3D11_MESSAGE_ID_RSSETSTATE_UNBINDDELETINGOBJECT,
	// D3D11_MESSAGE_ID_OMSETBLENDSTATE_UNBINDDELETINGOBJECT, D3D11_MESSAGE_ID_OMSETDEPTHSTENCILSTATE_UNBINDDELETINGOBJECT,
	// D3D11_MESSAGE_ID_OMSETRENDERTARGETS_UNBINDDELETINGOBJECT, D3D11_MESSAGE_ID_SETPREDICATION_UNBINDDELETINGOBJECT,
	// D3D11_MESSAGE_ID_GETPRIVATEDATA_MOREDATA, D3D11_MESSAGE_ID_SETPRIVATEDATA_INVALIDFREEDATA,
	// D3D11_MESSAGE_ID_SETPRIVATEDATA_INVALIDIUNKNOWN, D3D11_MESSAGE_ID_SETPRIVATEDATA_INVALIDFLAGS,
	// D3D11_MESSAGE_ID_SETPRIVATEDATA_CHANGINGPARAMS, D3D11_MESSAGE_ID_SETPRIVATEDATA_OUTOFMEMORY,
	// D3D11_MESSAGE_ID_CREATEBUFFER_UNRECOGNIZEDFORMAT, D3D11_MESSAGE_ID_CREATEBUFFER_INVALIDSAMPLES,
	// D3D11_MESSAGE_ID_CREATEBUFFER_UNRECOGNIZEDUSAGE, D3D11_MESSAGE_ID_CREATEBUFFER_UNRECOGNIZEDBINDFLAGS,
	// D3D11_MESSAGE_ID_CREATEBUFFER_UNRECOGNIZEDCPUACCESSFLAGS, D3D11_MESSAGE_ID_CREATEBUFFER_UNRECOGNIZEDMISCFLAGS,
	// D3D11_MESSAGE_ID_CREATEBUFFER_INVALIDCPUACCESSFLAGS, D3D11_MESSAGE_ID_CREATEBUFFER_INVALIDBINDFLAGS,
	// D3D11_MESSAGE_ID_CREATEBUFFER_INVALIDINITIALDATA, D3D11_MESSAGE_ID_CREATEBUFFER_INVALIDDIMENSIONS,
	// D3D11_MESSAGE_ID_CREATEBUFFER_INVALIDMIPLEVELS, D3D11_MESSAGE_ID_CREATEBUFFER_INVALIDMISCFLAGS,
	// D3D11_MESSAGE_ID_CREATEBUFFER_INVALIDARG_RETURN, D3D11_MESSAGE_ID_CREATEBUFFER_OUTOFMEMORY_RETURN,
	// D3D11_MESSAGE_ID_CREATEBUFFER_NULLDESC, D3D11_MESSAGE_ID_CREATEBUFFER_INVALIDCONSTANTBUFFERBINDINGS,
	// D3D11_MESSAGE_ID_CREATEBUFFER_LARGEALLOCATION, D3D11_MESSAGE_ID_CREATETEXTURE1D_UNRECOGNIZEDFORMAT,
	// D3D11_MESSAGE_ID_CREATETEXTURE1D_UNSUPPORTEDFORMAT, D3D11_MESSAGE_ID_CREATETEXTURE1D_INVALIDSAMPLES,
	// D3D11_MESSAGE_ID_CREATETEXTURE1D_UNRECOGNIZEDUSAGE, D3D11_MESSAGE_ID_CREATETEXTURE1D_UNRECOGNIZEDBINDFLAGS,
	// D3D11_MESSAGE_ID_CREATETEXTURE1D_UNRECOGNIZEDCPUACCESSFLAGS, D3D11_MESSAGE_ID_CREATETEXTURE1D_UNRECOGNIZEDMISCFLAGS,
	// D3D11_MESSAGE_ID_CREATETEXTURE1D_INVALIDCPUACCESSFLAGS, D3D11_MESSAGE_ID_CREATETEXTURE1D_INVALIDBINDFLAGS,
	// D3D11_MESSAGE_ID_CREATETEXTURE1D_INVALIDINITIALDATA, D3D11_MESSAGE_ID_CREATETEXTURE1D_INVALIDDIMENSIONS,
	// D3D11_MESSAGE_ID_CREATETEXTURE1D_INVALIDMIPLEVELS, D3D11_MESSAGE_ID_CREATETEXTURE1D_INVALIDMISCFLAGS,
	// D3D11_MESSAGE_ID_CREATETEXTURE1D_INVALIDARG_RETURN, D3D11_MESSAGE_ID_CREATETEXTURE1D_OUTOFMEMORY_RETURN,
	// D3D11_MESSAGE_ID_CREATETEXTURE1D_NULLDESC, D3D11_MESSAGE_ID_CREATETEXTURE1D_LARGEALLOCATION,
	// D3D11_MESSAGE_ID_CREATETEXTURE2D_UNRECOGNIZEDFORMAT, D3D11_MESSAGE_ID_CREATETEXTURE2D_UNSUPPORTEDFORMAT,
	// D3D11_MESSAGE_ID_CREATETEXTURE2D_INVALIDSAMPLES, D3D11_MESSAGE_ID_CREATETEXTURE2D_UNRECOGNIZEDUSAGE,
	// D3D11_MESSAGE_ID_CREATETEXTURE2D_UNRECOGNIZEDBINDFLAGS, D3D11_MESSAGE_ID_CREATETEXTURE2D_UNRECOGNIZEDCPUACCESSFLAGS,
	// D3D11_MESSAGE_ID_CREATETEXTURE2D_UNRECOGNIZEDMISCFLAGS, D3D11_MESSAGE_ID_CREATETEXTURE2D_INVALIDCPUACCESSFLAGS,
	// D3D11_MESSAGE_ID_CREATETEXTURE2D_INVALIDBINDFLAGS, D3D11_MESSAGE_ID_CREATETEXTURE2D_INVALIDINITIALDATA,
	// D3D11_MESSAGE_ID_CREATETEXTURE2D_INVALIDDIMENSIONS, D3D11_MESSAGE_ID_CREATETEXTURE2D_INVALIDMIPLEVELS,
	// D3D11_MESSAGE_ID_CREATETEXTURE2D_INVALIDMISCFLAGS, D3D11_MESSAGE_ID_CREATETEXTURE2D_INVALIDARG_RETURN,
	// D3D11_MESSAGE_ID_CREATETEXTURE2D_OUTOFMEMORY_RETURN, D3D11_MESSAGE_ID_CREATETEXTURE2D_NULLDESC,
	// D3D11_MESSAGE_ID_CREATETEXTURE2D_LARGEALLOCATION, D3D11_MESSAGE_ID_CREATETEXTURE3D_UNRECOGNIZEDFORMAT,
	// D3D11_MESSAGE_ID_CREATETEXTURE3D_UNSUPPORTEDFORMAT, D3D11_MESSAGE_ID_CREATETEXTURE3D_INVALIDSAMPLES,
	// D3D11_MESSAGE_ID_CREATETEXTURE3D_UNRECOGNIZEDUSAGE, D3D11_MESSAGE_ID_CREATETEXTURE3D_UNRECOGNIZEDBINDFLAGS,
	// D3D11_MESSAGE_ID_CREATETEXTURE3D_UNRECOGNIZEDCPUACCESSFLAGS, D3D11_MESSAGE_ID_CREATETEXTURE3D_UNRECOGNIZEDMISCFLAGS,
	// D3D11_MESSAGE_ID_CREATETEXTURE3D_INVALIDCPUACCESSFLAGS, D3D11_MESSAGE_ID_CREATETEXTURE3D_INVALIDBINDFLAGS,
	// D3D11_MESSAGE_ID_CREATETEXTURE3D_INVALIDINITIALDATA, D3D11_MESSAGE_ID_CREATETEXTURE3D_INVALIDDIMENSIONS,
	// D3D11_MESSAGE_ID_CREATETEXTURE3D_INVALIDMIPLEVELS, D3D11_MESSAGE_ID_CREATETEXTURE3D_INVALIDMISCFLAGS,
	// D3D11_MESSAGE_ID_CREATETEXTURE3D_INVALIDARG_RETURN, D3D11_MESSAGE_ID_CREATETEXTURE3D_OUTOFMEMORY_RETURN,
	// D3D11_MESSAGE_ID_CREATETEXTURE3D_NULLDESC, D3D11_MESSAGE_ID_CREATETEXTURE3D_LARGEALLOCATION,
	// D3D11_MESSAGE_ID_CREATESHADERRESOURCEVIEW_UNRECOGNIZEDFORMAT, D3D11_MESSAGE_ID_CREATESHADERRESOURCEVIEW_INVALIDDESC,
	// D3D11_MESSAGE_ID_CREATESHADERRESOURCEVIEW_INVALIDFORMAT, D3D11_MESSAGE_ID_CREATESHADERRESOURCEVIEW_INVALIDDIMENSIONS,
	// D3D11_MESSAGE_ID_CREATESHADERRESOURCEVIEW_INVALIDRESOURCE, D3D11_MESSAGE_ID_CREATESHADERRESOURCEVIEW_TOOMANYOBJECTS,
	// D3D11_MESSAGE_ID_CREATESHADERRESOURCEVIEW_INVALIDARG_RETURN, D3D11_MESSAGE_ID_CREATESHADERRESOURCEVIEW_OUTOFMEMORY_RETURN,
	// D3D11_MESSAGE_ID_CREATERENDERTARGETVIEW_UNRECOGNIZEDFORMAT, D3D11_MESSAGE_ID_CREATERENDERTARGETVIEW_UNSUPPORTEDFORMAT,
	// D3D11_MESSAGE_ID_CREATERENDERTARGETVIEW_INVALIDDESC, D3D11_MESSAGE_ID_CREATERENDERTARGETVIEW_INVALIDFORMAT,
	// D3D11_MESSAGE_ID_CREATERENDERTARGETVIEW_INVALIDDIMENSIONS, D3D11_MESSAGE_ID_CREATERENDERTARGETVIEW_INVALIDRESOURCE,
	// D3D11_MESSAGE_ID_CREATERENDERTARGETVIEW_TOOMANYOBJECTS, D3D11_MESSAGE_ID_CREATERENDERTARGETVIEW_INVALIDARG_RETURN,
	// D3D11_MESSAGE_ID_CREATERENDERTARGETVIEW_OUTOFMEMORY_RETURN, D3D11_MESSAGE_ID_CREATEDEPTHSTENCILVIEW_UNRECOGNIZEDFORMAT,
	// D3D11_MESSAGE_ID_CREATEDEPTHSTENCILVIEW_INVALIDDESC, D3D11_MESSAGE_ID_CREATEDEPTHSTENCILVIEW_INVALIDFORMAT,
	// D3D11_MESSAGE_ID_CREATEDEPTHSTENCILVIEW_INVALIDDIMENSIONS, D3D11_MESSAGE_ID_CREATEDEPTHSTENCILVIEW_INVALIDRESOURCE,
	// D3D11_MESSAGE_ID_CREATEDEPTHSTENCILVIEW_TOOMANYOBJECTS, D3D11_MESSAGE_ID_CREATEDEPTHSTENCILVIEW_INVALIDARG_RETURN,
	// D3D11_MESSAGE_ID_CREATEDEPTHSTENCILVIEW_OUTOFMEMORY_RETURN, D3D11_MESSAGE_ID_CREATEINPUTLAYOUT_OUTOFMEMORY,
	// D3D11_MESSAGE_ID_CREATEINPUTLAYOUT_TOOMANYELEMENTS, D3D11_MESSAGE_ID_CREATEINPUTLAYOUT_INVALIDFORMAT,
	// D3D11_MESSAGE_ID_CREATEINPUTLAYOUT_INCOMPATIBLEFORMAT, D3D11_MESSAGE_ID_CREATEINPUTLAYOUT_INVALIDSLOT,
	// D3D11_MESSAGE_ID_CREATEINPUTLAYOUT_INVALIDINPUTSLOTCLASS, D3D11_MESSAGE_ID_CREATEINPUTLAYOUT_STEPRATESLOTCLASSMISMATCH,
	// D3D11_MESSAGE_ID_CREATEINPUTLAYOUT_INVALIDSLOTCLASSCHANGE, D3D11_MESSAGE_ID_CREATEINPUTLAYOUT_INVALIDSTEPRATECHANGE,
	// D3D11_MESSAGE_ID_CREATEINPUTLAYOUT_INVALIDALIGNMENT, D3D11_MESSAGE_ID_CREATEINPUTLAYOUT_DUPLICATESEMANTIC,
	// D3D11_MESSAGE_ID_CREATEINPUTLAYOUT_UNPARSEABLEINPUTSIGNATURE, D3D11_MESSAGE_ID_CREATEINPUTLAYOUT_NULLSEMANTIC,
	// D3D11_MESSAGE_ID_CREATEINPUTLAYOUT_MISSINGELEMENT, D3D11_MESSAGE_ID_CREATEINPUTLAYOUT_NULLDESC,
	// D3D11_MESSAGE_ID_CREATEVERTEXSHADER_OUTOFMEMORY, D3D11_MESSAGE_ID_CREATEVERTEXSHADER_INVALIDSHADERBYTECODE,
	// D3D11_MESSAGE_ID_CREATEVERTEXSHADER_INVALIDSHADERTYPE, D3D11_MESSAGE_ID_CREATEGEOMETRYSHADER_OUTOFMEMORY,
	// D3D11_MESSAGE_ID_CREATEGEOMETRYSHADER_INVALIDSHADERBYTECODE, D3D11_MESSAGE_ID_CREATEGEOMETRYSHADER_INVALIDSHADERTYPE,
	// D3D11_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_OUTOFMEMORY,
	// D3D11_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDSHADERBYTECODE,
	// D3D11_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDSHADERTYPE,
	// D3D11_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDNUMENTRIES,
	// D3D11_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_OUTPUTSTREAMSTRIDEUNUSED,
	// D3D11_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_UNEXPECTEDDECL,
	// D3D11_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_EXPECTEDDECL,
	// D3D11_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_OUTPUTSLOT0EXPECTED,
	// D3D11_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDOUTPUTSLOT,
	// D3D11_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_ONLYONEELEMENTPERSLOT,
	// D3D11_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDCOMPONENTCOUNT,
	// D3D11_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDSTARTCOMPONENTANDCOMPONENTCOUNT,
	// D3D11_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDGAPDEFINITION,
	// D3D11_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_REPEATEDOUTPUT,
	// D3D11_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDOUTPUTSTREAMSTRIDE,
	// D3D11_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_MISSINGSEMANTIC,
	// D3D11_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_MASKMISMATCH,
	// D3D11_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_CANTHAVEONLYGAPS,
	// D3D11_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_DECLTOOCOMPLEX,
	// D3D11_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_MISSINGOUTPUTSIGNATURE, D3D11_MESSAGE_ID_CREATEPIXELSHADER_OUTOFMEMORY,
	// D3D11_MESSAGE_ID_CREATEPIXELSHADER_INVALIDSHADERBYTECODE, D3D11_MESSAGE_ID_CREATEPIXELSHADER_INVALIDSHADERTYPE,
	// D3D11_MESSAGE_ID_CREATERASTERIZERSTATE_INVALIDFILLMODE, D3D11_MESSAGE_ID_CREATERASTERIZERSTATE_INVALIDCULLMODE,
	// D3D11_MESSAGE_ID_CREATERASTERIZERSTATE_INVALIDDEPTHBIASCLAMP, D3D11_MESSAGE_ID_CREATERASTERIZERSTATE_INVALIDSLOPESCALEDDEPTHBIAS,
	// D3D11_MESSAGE_ID_CREATERASTERIZERSTATE_TOOMANYOBJECTS, D3D11_MESSAGE_ID_CREATERASTERIZERSTATE_NULLDESC,
	// D3D11_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_INVALIDDEPTHWRITEMASK, D3D11_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_INVALIDDEPTHFUNC,
	// D3D11_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_INVALIDFRONTFACESTENCILFAILOP,
	// D3D11_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_INVALIDFRONTFACESTENCILZFAILOP,
	// D3D11_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_INVALIDFRONTFACESTENCILPASSOP,
	// D3D11_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_INVALIDFRONTFACESTENCILFUNC,
	// D3D11_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_INVALIDBACKFACESTENCILFAILOP,
	// D3D11_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_INVALIDBACKFACESTENCILZFAILOP,
	// D3D11_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_INVALIDBACKFACESTENCILPASSOP,
	// D3D11_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_INVALIDBACKFACESTENCILFUNC, D3D11_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_TOOMANYOBJECTS,
	// D3D11_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_NULLDESC, D3D11_MESSAGE_ID_CREATEBLENDSTATE_INVALIDSRCBLEND,
	// D3D11_MESSAGE_ID_CREATEBLENDSTATE_INVALIDDESTBLEND, D3D11_MESSAGE_ID_CREATEBLENDSTATE_INVALIDBLENDOP,
	// D3D11_MESSAGE_ID_CREATEBLENDSTATE_INVALIDSRCBLENDALPHA, D3D11_MESSAGE_ID_CREATEBLENDSTATE_INVALIDDESTBLENDALPHA,
	// D3D11_MESSAGE_ID_CREATEBLENDSTATE_INVALIDBLENDOPALPHA, D3D11_MESSAGE_ID_CREATEBLENDSTATE_INVALIDRENDERTARGETWRITEMASK,
	// D3D11_MESSAGE_ID_CREATEBLENDSTATE_TOOMANYOBJECTS, D3D11_MESSAGE_ID_CREATEBLENDSTATE_NULLDESC,
	// D3D11_MESSAGE_ID_CREATESAMPLERSTATE_INVALIDFILTER, D3D11_MESSAGE_ID_CREATESAMPLERSTATE_INVALIDADDRESSU,
	// D3D11_MESSAGE_ID_CREATESAMPLERSTATE_INVALIDADDRESSV, D3D11_MESSAGE_ID_CREATESAMPLERSTATE_INVALIDADDRESSW,
	// D3D11_MESSAGE_ID_CREATESAMPLERSTATE_INVALIDMIPLODBIAS, D3D11_MESSAGE_ID_CREATESAMPLERSTATE_INVALIDMAXANISOTROPY,
	// D3D11_MESSAGE_ID_CREATESAMPLERSTATE_INVALIDCOMPARISONFUNC, D3D11_MESSAGE_ID_CREATESAMPLERSTATE_INVALIDMINLOD,
	// D3D11_MESSAGE_ID_CREATESAMPLERSTATE_INVALIDMAXLOD, D3D11_MESSAGE_ID_CREATESAMPLERSTATE_TOOMANYOBJECTS,
	// D3D11_MESSAGE_ID_CREATESAMPLERSTATE_NULLDESC, D3D11_MESSAGE_ID_CREATEQUERYORPREDICATE_INVALIDQUERY,
	// D3D11_MESSAGE_ID_CREATEQUERYORPREDICATE_INVALIDMISCFLAGS, D3D11_MESSAGE_ID_CREATEQUERYORPREDICATE_UNEXPECTEDMISCFLAG,
	// D3D11_MESSAGE_ID_CREATEQUERYORPREDICATE_NULLDESC, D3D11_MESSAGE_ID_DEVICE_IASETPRIMITIVETOPOLOGY_TOPOLOGY_UNRECOGNIZED,
	// D3D11_MESSAGE_ID_DEVICE_IASETPRIMITIVETOPOLOGY_TOPOLOGY_UNDEFINED, D3D11_MESSAGE_ID_IASETVERTEXBUFFERS_INVALIDBUFFER,
	// D3D11_MESSAGE_ID_DEVICE_IASETVERTEXBUFFERS_OFFSET_TOO_LARGE, D3D11_MESSAGE_ID_DEVICE_IASETVERTEXBUFFERS_BUFFERS_EMPTY,
	// D3D11_MESSAGE_ID_IASETINDEXBUFFER_INVALIDBUFFER, D3D11_MESSAGE_ID_DEVICE_IASETINDEXBUFFER_FORMAT_INVALID,
	// D3D11_MESSAGE_ID_DEVICE_IASETINDEXBUFFER_OFFSET_TOO_LARGE, D3D11_MESSAGE_ID_DEVICE_IASETINDEXBUFFER_OFFSET_UNALIGNED,
	// D3D11_MESSAGE_ID_DEVICE_VSSETSHADERRESOURCES_VIEWS_EMPTY, D3D11_MESSAGE_ID_VSSETCONSTANTBUFFERS_INVALIDBUFFER,
	// D3D11_MESSAGE_ID_DEVICE_VSSETCONSTANTBUFFERS_BUFFERS_EMPTY, D3D11_MESSAGE_ID_DEVICE_VSSETSAMPLERS_SAMPLERS_EMPTY,
	// D3D11_MESSAGE_ID_DEVICE_GSSETSHADERRESOURCES_VIEWS_EMPTY, D3D11_MESSAGE_ID_GSSETCONSTANTBUFFERS_INVALIDBUFFER,
	// D3D11_MESSAGE_ID_DEVICE_GSSETCONSTANTBUFFERS_BUFFERS_EMPTY, D3D11_MESSAGE_ID_DEVICE_GSSETSAMPLERS_SAMPLERS_EMPTY,
	// D3D11_MESSAGE_ID_SOSETTARGETS_INVALIDBUFFER, D3D11_MESSAGE_ID_DEVICE_SOSETTARGETS_OFFSET_UNALIGNED,
	// D3D11_MESSAGE_ID_DEVICE_PSSETSHADERRESOURCES_VIEWS_EMPTY, D3D11_MESSAGE_ID_PSSETCONSTANTBUFFERS_INVALIDBUFFER,
	// D3D11_MESSAGE_ID_DEVICE_PSSETCONSTANTBUFFERS_BUFFERS_EMPTY, D3D11_MESSAGE_ID_DEVICE_PSSETSAMPLERS_SAMPLERS_EMPTY,
	// D3D11_MESSAGE_ID_DEVICE_RSSETVIEWPORTS_INVALIDVIEWPORT, D3D11_MESSAGE_ID_DEVICE_RSSETSCISSORRECTS_INVALIDSCISSOR,
	// D3D11_MESSAGE_ID_CLEARRENDERTARGETVIEW_DENORMFLUSH, D3D11_MESSAGE_ID_CLEARDEPTHSTENCILVIEW_DENORMFLUSH,
	// D3D11_MESSAGE_ID_CLEARDEPTHSTENCILVIEW_INVALID, D3D11_MESSAGE_ID_DEVICE_IAGETVERTEXBUFFERS_BUFFERS_EMPTY,
	// D3D11_MESSAGE_ID_DEVICE_VSGETSHADERRESOURCES_VIEWS_EMPTY, D3D11_MESSAGE_ID_DEVICE_VSGETCONSTANTBUFFERS_BUFFERS_EMPTY,
	// D3D11_MESSAGE_ID_DEVICE_VSGETSAMPLERS_SAMPLERS_EMPTY, D3D11_MESSAGE_ID_DEVICE_GSGETSHADERRESOURCES_VIEWS_EMPTY,
	// D3D11_MESSAGE_ID_DEVICE_GSGETCONSTANTBUFFERS_BUFFERS_EMPTY, D3D11_MESSAGE_ID_DEVICE_GSGETSAMPLERS_SAMPLERS_EMPTY,
	// D3D11_MESSAGE_ID_DEVICE_SOGETTARGETS_BUFFERS_EMPTY, D3D11_MESSAGE_ID_DEVICE_PSGETSHADERRESOURCES_VIEWS_EMPTY,
	// D3D11_MESSAGE_ID_DEVICE_PSGETCONSTANTBUFFERS_BUFFERS_EMPTY, D3D11_MESSAGE_ID_DEVICE_PSGETSAMPLERS_SAMPLERS_EMPTY,
	// D3D11_MESSAGE_ID_DEVICE_RSGETVIEWPORTS_VIEWPORTS_EMPTY, D3D11_MESSAGE_ID_DEVICE_RSGETSCISSORRECTS_RECTS_EMPTY,
	// D3D11_MESSAGE_ID_DEVICE_GENERATEMIPS_RESOURCE_INVALID, D3D11_MESSAGE_ID_COPYSUBRESOURCEREGION_INVALIDDESTINATIONSUBRESOURCE,
	// D3D11_MESSAGE_ID_COPYSUBRESOURCEREGION_INVALIDSOURCESUBRESOURCE, D3D11_MESSAGE_ID_COPYSUBRESOURCEREGION_INVALIDSOURCEBOX,
	// D3D11_MESSAGE_ID_COPYSUBRESOURCEREGION_INVALIDSOURCE, D3D11_MESSAGE_ID_COPYSUBRESOURCEREGION_INVALIDDESTINATIONSTATE,
	// D3D11_MESSAGE_ID_COPYSUBRESOURCEREGION_INVALIDSOURCESTATE, D3D11_MESSAGE_ID_COPYRESOURCE_INVALIDSOURCE,
	// D3D11_MESSAGE_ID_COPYRESOURCE_INVALIDDESTINATIONSTATE, D3D11_MESSAGE_ID_COPYRESOURCE_INVALIDSOURCESTATE,
	// D3D11_MESSAGE_ID_UPDATESUBRESOURCE_INVALIDDESTINATIONSUBRESOURCE, D3D11_MESSAGE_ID_UPDATESUBRESOURCE_INVALIDDESTINATIONBOX,
	// D3D11_MESSAGE_ID_UPDATESUBRESOURCE_INVALIDDESTINATIONSTATE, D3D11_MESSAGE_ID_DEVICE_RESOLVESUBRESOURCE_DESTINATION_INVALID,
	// D3D11_MESSAGE_ID_DEVICE_RESOLVESUBRESOURCE_DESTINATION_SUBRESOURCE_INVALID,
	// D3D11_MESSAGE_ID_DEVICE_RESOLVESUBRESOURCE_SOURCE_INVALID, D3D11_MESSAGE_ID_DEVICE_RESOLVESUBRESOURCE_SOURCE_SUBRESOURCE_INVALID,
	// D3D11_MESSAGE_ID_DEVICE_RESOLVESUBRESOURCE_FORMAT_INVALID, D3D11_MESSAGE_ID_BUFFER_MAP_INVALIDMAPTYPE,
	// D3D11_MESSAGE_ID_BUFFER_MAP_INVALIDFLAGS, D3D11_MESSAGE_ID_BUFFER_MAP_ALREADYMAPPED,
	// D3D11_MESSAGE_ID_BUFFER_MAP_DEVICEREMOVED_RETURN, D3D11_MESSAGE_ID_BUFFER_UNMAP_NOTMAPPED,
	// D3D11_MESSAGE_ID_TEXTURE1D_MAP_INVALIDMAPTYPE, D3D11_MESSAGE_ID_TEXTURE1D_MAP_INVALIDSUBRESOURCE,
	// D3D11_MESSAGE_ID_TEXTURE1D_MAP_INVALIDFLAGS, D3D11_MESSAGE_ID_TEXTURE1D_MAP_ALREADYMAPPED,
	// D3D11_MESSAGE_ID_TEXTURE1D_MAP_DEVICEREMOVED_RETURN, D3D11_MESSAGE_ID_TEXTURE1D_UNMAP_INVALIDSUBRESOURCE,
	// D3D11_MESSAGE_ID_TEXTURE1D_UNMAP_NOTMAPPED, D3D11_MESSAGE_ID_TEXTURE2D_MAP_INVALIDMAPTYPE,
	// D3D11_MESSAGE_ID_TEXTURE2D_MAP_INVALIDSUBRESOURCE, D3D11_MESSAGE_ID_TEXTURE2D_MAP_INVALIDFLAGS,
	// D3D11_MESSAGE_ID_TEXTURE2D_MAP_ALREADYMAPPED, D3D11_MESSAGE_ID_TEXTURE2D_MAP_DEVICEREMOVED_RETURN,
	// D3D11_MESSAGE_ID_TEXTURE2D_UNMAP_INVALIDSUBRESOURCE, D3D11_MESSAGE_ID_TEXTURE2D_UNMAP_NOTMAPPED,
	// D3D11_MESSAGE_ID_TEXTURE3D_MAP_INVALIDMAPTYPE, D3D11_MESSAGE_ID_TEXTURE3D_MAP_INVALIDSUBRESOURCE,
	// D3D11_MESSAGE_ID_TEXTURE3D_MAP_INVALIDFLAGS, D3D11_MESSAGE_ID_TEXTURE3D_MAP_ALREADYMAPPED,
	// D3D11_MESSAGE_ID_TEXTURE3D_MAP_DEVICEREMOVED_RETURN, D3D11_MESSAGE_ID_TEXTURE3D_UNMAP_INVALIDSUBRESOURCE,
	// D3D11_MESSAGE_ID_TEXTURE3D_UNMAP_NOTMAPPED, D3D11_MESSAGE_ID_CHECKFORMATSUPPORT_FORMAT_DEPRECATED,
	// D3D11_MESSAGE_ID_CHECKMULTISAMPLEQUALITYLEVELS_FORMAT_DEPRECATED, D3D11_MESSAGE_ID_SETEXCEPTIONMODE_UNRECOGNIZEDFLAGS,
	// D3D11_MESSAGE_ID_SETEXCEPTIONMODE_INVALIDARG_RETURN, D3D11_MESSAGE_ID_SETEXCEPTIONMODE_DEVICEREMOVED_RETURN,
	// D3D11_MESSAGE_ID_REF_SIMULATING_INFINITELY_FAST_HARDWARE, D3D11_MESSAGE_ID_REF_THREADING_MODE,
	// D3D11_MESSAGE_ID_REF_UMDRIVER_EXCEPTION, D3D11_MESSAGE_ID_REF_KMDRIVER_EXCEPTION, D3D11_MESSAGE_ID_REF_HARDWARE_EXCEPTION,
	// D3D11_MESSAGE_ID_REF_ACCESSING_INDEXABLE_TEMP_OUT_OF_RANGE, D3D11_MESSAGE_ID_REF_PROBLEM_PARSING_SHADER,
	// D3D11_MESSAGE_ID_REF_OUT_OF_MEMORY, D3D11_MESSAGE_ID_REF_INFO, D3D11_MESSAGE_ID_DEVICE_DRAW_VERTEXPOS_OVERFLOW,
	// D3D11_MESSAGE_ID_DEVICE_DRAWINDEXED_INDEXPOS_OVERFLOW, D3D11_MESSAGE_ID_DEVICE_DRAWINSTANCED_VERTEXPOS_OVERFLOW,
	// D3D11_MESSAGE_ID_DEVICE_DRAWINSTANCED_INSTANCEPOS_OVERFLOW, D3D11_MESSAGE_ID_DEVICE_DRAWINDEXEDINSTANCED_INSTANCEPOS_OVERFLOW,
	// D3D11_MESSAGE_ID_DEVICE_DRAWINDEXEDINSTANCED_INDEXPOS_OVERFLOW, D3D11_MESSAGE_ID_DEVICE_DRAW_VERTEX_SHADER_NOT_SET,
	// D3D11_MESSAGE_ID_DEVICE_SHADER_LINKAGE_SEMANTICNAME_NOT_FOUND, D3D11_MESSAGE_ID_DEVICE_SHADER_LINKAGE_REGISTERINDEX,
	// D3D11_MESSAGE_ID_DEVICE_SHADER_LINKAGE_COMPONENTTYPE, D3D11_MESSAGE_ID_DEVICE_SHADER_LINKAGE_REGISTERMASK,
	// D3D11_MESSAGE_ID_DEVICE_SHADER_LINKAGE_SYSTEMVALUE, D3D11_MESSAGE_ID_DEVICE_SHADER_LINKAGE_NEVERWRITTEN_ALWAYSREADS,
	// D3D11_MESSAGE_ID_DEVICE_DRAW_VERTEX_BUFFER_NOT_SET, D3D11_MESSAGE_ID_DEVICE_DRAW_INPUTLAYOUT_NOT_SET,
	// D3D11_MESSAGE_ID_DEVICE_DRAW_CONSTANT_BUFFER_NOT_SET, D3D11_MESSAGE_ID_DEVICE_DRAW_CONSTANT_BUFFER_TOO_SMALL,
	// D3D11_MESSAGE_ID_DEVICE_DRAW_SAMPLER_NOT_SET, D3D11_MESSAGE_ID_DEVICE_DRAW_SHADERRESOURCEVIEW_NOT_SET,
	// D3D11_MESSAGE_ID_DEVICE_DRAW_VIEW_DIMENSION_MISMATCH, D3D11_MESSAGE_ID_DEVICE_DRAW_VERTEX_BUFFER_STRIDE_TOO_SMALL,
	// D3D11_MESSAGE_ID_DEVICE_DRAW_VERTEX_BUFFER_TOO_SMALL, D3D11_MESSAGE_ID_DEVICE_DRAW_INDEX_BUFFER_NOT_SET,
	// D3D11_MESSAGE_ID_DEVICE_DRAW_INDEX_BUFFER_FORMAT_INVALID, D3D11_MESSAGE_ID_DEVICE_DRAW_INDEX_BUFFER_TOO_SMALL,
	// D3D11_MESSAGE_ID_DEVICE_DRAW_GS_INPUT_PRIMITIVE_MISMATCH, D3D11_MESSAGE_ID_DEVICE_DRAW_RESOURCE_RETURN_TYPE_MISMATCH,
	// D3D11_MESSAGE_ID_DEVICE_DRAW_POSITION_NOT_PRESENT, D3D11_MESSAGE_ID_DEVICE_DRAW_OUTPUT_STREAM_NOT_SET,
	// D3D11_MESSAGE_ID_DEVICE_DRAW_BOUND_RESOURCE_MAPPED, D3D11_MESSAGE_ID_DEVICE_DRAW_INVALID_PRIMITIVETOPOLOGY,
	// D3D11_MESSAGE_ID_DEVICE_DRAW_VERTEX_OFFSET_UNALIGNED, D3D11_MESSAGE_ID_DEVICE_DRAW_VERTEX_STRIDE_UNALIGNED,
	// D3D11_MESSAGE_ID_DEVICE_DRAW_INDEX_OFFSET_UNALIGNED, D3D11_MESSAGE_ID_DEVICE_DRAW_OUTPUT_STREAM_OFFSET_UNALIGNED,
	// D3D11_MESSAGE_ID_DEVICE_DRAW_RESOURCE_FORMAT_LD_UNSUPPORTED, D3D11_MESSAGE_ID_DEVICE_DRAW_RESOURCE_FORMAT_SAMPLE_UNSUPPORTED,
	// D3D11_MESSAGE_ID_DEVICE_DRAW_RESOURCE_FORMAT_SAMPLE_C_UNSUPPORTED, D3D11_MESSAGE_ID_DEVICE_DRAW_RESOURCE_MULTISAMPLE_UNSUPPORTED,
	// D3D11_MESSAGE_ID_DEVICE_DRAW_SO_TARGETS_BOUND_WITHOUT_SOURCE, D3D11_MESSAGE_ID_DEVICE_DRAW_SO_STRIDE_LARGER_THAN_BUFFER,
	// D3D11_MESSAGE_ID_DEVICE_DRAW_OM_RENDER_TARGET_DOES_NOT_SUPPORT_BLENDING,
	// D3D11_MESSAGE_ID_DEVICE_DRAW_OM_DUAL_SOURCE_BLENDING_CAN_ONLY_HAVE_RENDER_TARGET_0, D3D11_MESSAGE_ID_DEVICE_REMOVAL_PROCESS_AT_FAULT,
	// D3D11_MESSAGE_ID_DEVICE_REMOVAL_PROCESS_POSSIBLY_AT_FAULT, D3D11_MESSAGE_ID_DEVICE_REMOVAL_PROCESS_NOT_AT_FAULT,
	// D3D11_MESSAGE_ID_DEVICE_OPEN_SHARED_RESOURCE_INVALIDARG_RETURN, D3D11_MESSAGE_ID_DEVICE_OPEN_SHARED_RESOURCE_OUTOFMEMORY_RETURN,
	// D3D11_MESSAGE_ID_DEVICE_OPEN_SHARED_RESOURCE_BADINTERFACE_RETURN, D3D11_MESSAGE_ID_DEVICE_DRAW_VIEWPORT_NOT_SET,
	// D3D11_MESSAGE_ID_CREATEINPUTLAYOUT_TRAILING_DIGIT_IN_SEMANTIC,
	// D3D11_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_TRAILING_DIGIT_IN_SEMANTIC, D3D11_MESSAGE_ID_DEVICE_RSSETVIEWPORTS_DENORMFLUSH,
	// D3D11_MESSAGE_ID_OMSETRENDERTARGETS_INVALIDVIEW, D3D11_MESSAGE_ID_DEVICE_SETTEXTFILTERSIZE_INVALIDDIMENSIONS,
	// D3D11_MESSAGE_ID_DEVICE_DRAW_SAMPLER_MISMATCH, D3D11_MESSAGE_ID_CREATEINPUTLAYOUT_TYPE_MISMATCH,
	// D3D11_MESSAGE_ID_BLENDSTATE_GETDESC_LEGACY, D3D11_MESSAGE_ID_SHADERRESOURCEVIEW_GETDESC_LEGACY,
	// D3D11_MESSAGE_ID_CREATEQUERY_OUTOFMEMORY_RETURN, D3D11_MESSAGE_ID_CREATEPREDICATE_OUTOFMEMORY_RETURN,
	// D3D11_MESSAGE_ID_CREATECOUNTER_OUTOFRANGE_COUNTER, D3D11_MESSAGE_ID_CREATECOUNTER_SIMULTANEOUS_ACTIVE_COUNTERS_EXHAUSTED,
	// D3D11_MESSAGE_ID_CREATECOUNTER_UNSUPPORTED_WELLKNOWN_COUNTER, D3D11_MESSAGE_ID_CREATECOUNTER_OUTOFMEMORY_RETURN,
	// D3D11_MESSAGE_ID_CREATECOUNTER_NONEXCLUSIVE_RETURN, D3D11_MESSAGE_ID_CREATECOUNTER_NULLDESC,
	// D3D11_MESSAGE_ID_CHECKCOUNTER_OUTOFRANGE_COUNTER, D3D11_MESSAGE_ID_CHECKCOUNTER_UNSUPPORTED_WELLKNOWN_COUNTER,
	// D3D11_MESSAGE_ID_SETPREDICATION_INVALID_PREDICATE_STATE, D3D11_MESSAGE_ID_QUERY_BEGIN_UNSUPPORTED,
	// D3D11_MESSAGE_ID_PREDICATE_BEGIN_DURING_PREDICATION, D3D11_MESSAGE_ID_QUERY_BEGIN_DUPLICATE,
	// D3D11_MESSAGE_ID_QUERY_BEGIN_ABANDONING_PREVIOUS_RESULTS, D3D11_MESSAGE_ID_PREDICATE_END_DURING_PREDICATION,
	// D3D11_MESSAGE_ID_QUERY_END_ABANDONING_PREVIOUS_RESULTS, D3D11_MESSAGE_ID_QUERY_END_WITHOUT_BEGIN,
	// D3D11_MESSAGE_ID_QUERY_GETDATA_INVALID_DATASIZE, D3D11_MESSAGE_ID_QUERY_GETDATA_INVALID_FLAGS,
	// D3D11_MESSAGE_ID_QUERY_GETDATA_INVALID_CALL, D3D11_MESSAGE_ID_DEVICE_DRAW_PS_OUTPUT_TYPE_MISMATCH,
	// D3D11_MESSAGE_ID_DEVICE_DRAW_RESOURCE_FORMAT_GATHER_UNSUPPORTED,
	// D3D11_MESSAGE_ID_DEVICE_DRAW_INVALID_USE_OF_CENTER_MULTISAMPLE_PATTERN, D3D11_MESSAGE_ID_DEVICE_IASETVERTEXBUFFERS_STRIDE_TOO_LARGE,
	// D3D11_MESSAGE_ID_DEVICE_IASETVERTEXBUFFERS_INVALIDRANGE, D3D11_MESSAGE_ID_CREATEINPUTLAYOUT_EMPTY_LAYOUT,
	// D3D11_MESSAGE_ID_DEVICE_DRAW_RESOURCE_SAMPLE_COUNT_MISMATCH, D3D11_MESSAGE_ID_LIVE_OBJECT_SUMMARY, D3D11_MESSAGE_ID_LIVE_BUFFER,
	// D3D11_MESSAGE_ID_LIVE_TEXTURE1D, D3D11_MESSAGE_ID_LIVE_TEXTURE2D, D3D11_MESSAGE_ID_LIVE_TEXTURE3D,
	// D3D11_MESSAGE_ID_LIVE_SHADERRESOURCEVIEW, D3D11_MESSAGE_ID_LIVE_RENDERTARGETVIEW, D3D11_MESSAGE_ID_LIVE_DEPTHSTENCILVIEW,
	// D3D11_MESSAGE_ID_LIVE_VERTEXSHADER, D3D11_MESSAGE_ID_LIVE_GEOMETRYSHADER, D3D11_MESSAGE_ID_LIVE_PIXELSHADER,
	// D3D11_MESSAGE_ID_LIVE_INPUTLAYOUT, D3D11_MESSAGE_ID_LIVE_SAMPLER, D3D11_MESSAGE_ID_LIVE_BLENDSTATE,
	// D3D11_MESSAGE_ID_LIVE_DEPTHSTENCILSTATE, D3D11_MESSAGE_ID_LIVE_RASTERIZERSTATE, D3D11_MESSAGE_ID_LIVE_QUERY,
	// D3D11_MESSAGE_ID_LIVE_PREDICATE, D3D11_MESSAGE_ID_LIVE_COUNTER, D3D11_MESSAGE_ID_LIVE_DEVICE, D3D11_MESSAGE_ID_LIVE_SWAPCHAIN,
	// D3D11_MESSAGE_ID_D3D10_MESSAGES_END, D3D11_MESSAGE_ID_D3D10L9_MESSAGES_START = 0x100000,
	// D3D11_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_STENCIL_NO_TWO_SIDED, D3D11_MESSAGE_ID_CREATERASTERIZERSTATE_DepthBiasClamp_NOT_SUPPORTED,
	// D3D11_MESSAGE_ID_CREATESAMPLERSTATE_NO_COMPARISON_SUPPORT, D3D11_MESSAGE_ID_CREATESAMPLERSTATE_EXCESSIVE_ANISOTROPY,
	// D3D11_MESSAGE_ID_CREATESAMPLERSTATE_BORDER_OUT_OF_RANGE, D3D11_MESSAGE_ID_VSSETSAMPLERS_NOT_SUPPORTED,
	// D3D11_MESSAGE_ID_VSSETSAMPLERS_TOO_MANY_SAMPLERS, D3D11_MESSAGE_ID_PSSETSAMPLERS_TOO_MANY_SAMPLERS,
	// D3D11_MESSAGE_ID_CREATERESOURCE_NO_ARRAYS, D3D11_MESSAGE_ID_CREATERESOURCE_NO_VB_AND_IB_BIND,
	// D3D11_MESSAGE_ID_CREATERESOURCE_NO_TEXTURE_1D, D3D11_MESSAGE_ID_CREATERESOURCE_DIMENSION_OUT_OF_RANGE,
	// D3D11_MESSAGE_ID_CREATERESOURCE_NOT_BINDABLE_AS_SHADER_RESOURCE, D3D11_MESSAGE_ID_OMSETRENDERTARGETS_TOO_MANY_RENDER_TARGETS,
	// D3D11_MESSAGE_ID_OMSETRENDERTARGETS_NO_DIFFERING_BIT_DEPTHS, D3D11_MESSAGE_ID_IASETVERTEXBUFFERS_BAD_BUFFER_INDEX,
	// D3D11_MESSAGE_ID_DEVICE_RSSETVIEWPORTS_TOO_MANY_VIEWPORTS, D3D11_MESSAGE_ID_DEVICE_IASETPRIMITIVETOPOLOGY_ADJACENCY_UNSUPPORTED,
	// D3D11_MESSAGE_ID_DEVICE_RSSETSCISSORRECTS_TOO_MANY_SCISSORS, D3D11_MESSAGE_ID_COPYRESOURCE_ONLY_TEXTURE_2D_WITHIN_GPU_MEMORY,
	// D3D11_MESSAGE_ID_COPYRESOURCE_NO_TEXTURE_3D_READBACK, D3D11_MESSAGE_ID_COPYRESOURCE_NO_TEXTURE_ONLY_READBACK,
	// D3D11_MESSAGE_ID_CREATEINPUTLAYOUT_UNSUPPORTED_FORMAT, D3D11_MESSAGE_ID_CREATEBLENDSTATE_NO_ALPHA_TO_COVERAGE,
	// D3D11_MESSAGE_ID_CREATERASTERIZERSTATE_DepthClipEnable_MUST_BE_TRUE,
	// D3D11_MESSAGE_ID_DRAWINDEXED_STARTINDEXLOCATION_MUST_BE_POSITIVE, D3D11_MESSAGE_ID_CREATESHADERRESOURCEVIEW_MUST_USE_LOWEST_LOD,
	// D3D11_MESSAGE_ID_CREATESAMPLERSTATE_MINLOD_MUST_NOT_BE_FRACTIONAL, D3D11_MESSAGE_ID_CREATESAMPLERSTATE_MAXLOD_MUST_BE_FLT_MAX,
	// D3D11_MESSAGE_ID_CREATESHADERRESOURCEVIEW_FIRSTARRAYSLICE_MUST_BE_ZERO,
	// D3D11_MESSAGE_ID_CREATESHADERRESOURCEVIEW_CUBES_MUST_HAVE_6_SIDES, D3D11_MESSAGE_ID_CREATERESOURCE_NOT_BINDABLE_AS_RENDER_TARGET,
	// D3D11_MESSAGE_ID_CREATERESOURCE_NO_DWORD_INDEX_BUFFER, D3D11_MESSAGE_ID_CREATERESOURCE_MSAA_PRECLUDES_SHADER_RESOURCE,
	// D3D11_MESSAGE_ID_CREATERESOURCE_PRESENTATION_PRECLUDES_SHADER_RESOURCE,
	// D3D11_MESSAGE_ID_CREATEBLENDSTATE_NO_INDEPENDENT_BLEND_ENABLE, D3D11_MESSAGE_ID_CREATEBLENDSTATE_NO_INDEPENDENT_WRITE_MASKS,
	// D3D11_MESSAGE_ID_CREATERESOURCE_NO_STREAM_OUT, D3D11_MESSAGE_ID_CREATERESOURCE_ONLY_VB_IB_FOR_BUFFERS,
	// D3D11_MESSAGE_ID_CREATERESOURCE_NO_AUTOGEN_FOR_VOLUMES, D3D11_MESSAGE_ID_CREATERESOURCE_DXGI_FORMAT_R8G8B8A8_CANNOT_BE_SHARED,
	// D3D11_MESSAGE_ID_VSSHADERRESOURCES_NOT_SUPPORTED, D3D11_MESSAGE_ID_GEOMETRY_SHADER_NOT_SUPPORTED,
	// D3D11_MESSAGE_ID_STREAM_OUT_NOT_SUPPORTED, D3D11_MESSAGE_ID_TEXT_FILTER_NOT_SUPPORTED,
	// D3D11_MESSAGE_ID_CREATEBLENDSTATE_NO_SEPARATE_ALPHA_BLEND, D3D11_MESSAGE_ID_CREATEBLENDSTATE_NO_MRT_BLEND,
	// D3D11_MESSAGE_ID_CREATEBLENDSTATE_OPERATION_NOT_SUPPORTED, D3D11_MESSAGE_ID_CREATESAMPLERSTATE_NO_MIRRORONCE,
	// D3D11_MESSAGE_ID_DRAWINSTANCED_NOT_SUPPORTED, D3D11_MESSAGE_ID_DRAWINDEXEDINSTANCED_NOT_SUPPORTED_BELOW_9_3,
	// D3D11_MESSAGE_ID_DRAWINDEXED_POINTLIST_UNSUPPORTED, D3D11_MESSAGE_ID_SETBLENDSTATE_SAMPLE_MASK_CANNOT_BE_ZERO,
	// D3D11_MESSAGE_ID_CREATERESOURCE_DIMENSION_EXCEEDS_FEATURE_LEVEL_DEFINITION,
	// D3D11_MESSAGE_ID_CREATERESOURCE_ONLY_SINGLE_MIP_LEVEL_DEPTH_STENCIL_SUPPORTED,
	// D3D11_MESSAGE_ID_DEVICE_RSSETSCISSORRECTS_NEGATIVESCISSOR, D3D11_MESSAGE_ID_SLOT_ZERO_MUST_BE_D3D10_INPUT_PER_VERTEX_DATA,
	// D3D11_MESSAGE_ID_CREATERESOURCE_NON_POW_2_MIPMAP, D3D11_MESSAGE_ID_CREATESAMPLERSTATE_BORDER_NOT_SUPPORTED,
	// D3D11_MESSAGE_ID_OMSETRENDERTARGETS_NO_SRGB_MRT, D3D11_MESSAGE_ID_COPYRESOURCE_NO_3D_MISMATCHED_UPDATES,
	// D3D11_MESSAGE_ID_D3D10L9_MESSAGES_END, D3D11_MESSAGE_ID_D3D11_MESSAGES_START = 0x200000,
	// D3D11_MESSAGE_ID_CREATEDEPTHSTENCILVIEW_INVALIDFLAGS, D3D11_MESSAGE_ID_CREATEVERTEXSHADER_INVALIDCLASSLINKAGE,
	// D3D11_MESSAGE_ID_CREATEGEOMETRYSHADER_INVALIDCLASSLINKAGE, D3D11_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDNUMSTREAMS,
	// D3D11_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDSTREAMTORASTERIZER,
	// D3D11_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_UNEXPECTEDSTREAMS,
	// D3D11_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDCLASSLINKAGE, D3D11_MESSAGE_ID_CREATEPIXELSHADER_INVALIDCLASSLINKAGE,
	// D3D11_MESSAGE_ID_CREATEDEFERREDCONTEXT_INVALID_COMMANDLISTFLAGS, D3D11_MESSAGE_ID_CREATEDEFERREDCONTEXT_SINGLETHREADED,
	// D3D11_MESSAGE_ID_CREATEDEFERREDCONTEXT_INVALIDARG_RETURN, D3D11_MESSAGE_ID_CREATEDEFERREDCONTEXT_INVALID_CALL_RETURN,
	// D3D11_MESSAGE_ID_CREATEDEFERREDCONTEXT_OUTOFMEMORY_RETURN, D3D11_MESSAGE_ID_FINISHDISPLAYLIST_ONIMMEDIATECONTEXT,
	// D3D11_MESSAGE_ID_FINISHDISPLAYLIST_OUTOFMEMORY_RETURN, D3D11_MESSAGE_ID_FINISHDISPLAYLIST_INVALID_CALL_RETURN,
	// D3D11_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDSTREAM,
	// D3D11_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_UNEXPECTEDENTRIES,
	// D3D11_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_UNEXPECTEDSTRIDES,
	// D3D11_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDNUMSTRIDES, D3D11_MESSAGE_ID_DEVICE_HSSETSHADERRESOURCES_HAZARD,
	// D3D11_MESSAGE_ID_DEVICE_HSSETCONSTANTBUFFERS_HAZARD, D3D11_MESSAGE_ID_HSSETSHADERRESOURCES_UNBINDDELETINGOBJECT,
	// D3D11_MESSAGE_ID_HSSETCONSTANTBUFFERS_UNBINDDELETINGOBJECT, D3D11_MESSAGE_ID_CREATEHULLSHADER_INVALIDCALL,
	// D3D11_MESSAGE_ID_CREATEHULLSHADER_OUTOFMEMORY, D3D11_MESSAGE_ID_CREATEHULLSHADER_INVALIDSHADERBYTECODE,
	// D3D11_MESSAGE_ID_CREATEHULLSHADER_INVALIDSHADERTYPE, D3D11_MESSAGE_ID_CREATEHULLSHADER_INVALIDCLASSLINKAGE,
	// D3D11_MESSAGE_ID_DEVICE_HSSETSHADERRESOURCES_VIEWS_EMPTY, D3D11_MESSAGE_ID_HSSETCONSTANTBUFFERS_INVALIDBUFFER,
	// D3D11_MESSAGE_ID_DEVICE_HSSETCONSTANTBUFFERS_BUFFERS_EMPTY, D3D11_MESSAGE_ID_DEVICE_HSSETSAMPLERS_SAMPLERS_EMPTY,
	// D3D11_MESSAGE_ID_DEVICE_HSGETSHADERRESOURCES_VIEWS_EMPTY, D3D11_MESSAGE_ID_DEVICE_HSGETCONSTANTBUFFERS_BUFFERS_EMPTY,
	// D3D11_MESSAGE_ID_DEVICE_HSGETSAMPLERS_SAMPLERS_EMPTY, D3D11_MESSAGE_ID_DEVICE_DSSETSHADERRESOURCES_HAZARD,
	// D3D11_MESSAGE_ID_DEVICE_DSSETCONSTANTBUFFERS_HAZARD, D3D11_MESSAGE_ID_DSSETSHADERRESOURCES_UNBINDDELETINGOBJECT,
	// D3D11_MESSAGE_ID_DSSETCONSTANTBUFFERS_UNBINDDELETINGOBJECT, D3D11_MESSAGE_ID_CREATEDOMAINSHADER_INVALIDCALL,
	// D3D11_MESSAGE_ID_CREATEDOMAINSHADER_OUTOFMEMORY, D3D11_MESSAGE_ID_CREATEDOMAINSHADER_INVALIDSHADERBYTECODE,
	// D3D11_MESSAGE_ID_CREATEDOMAINSHADER_INVALIDSHADERTYPE, D3D11_MESSAGE_ID_CREATEDOMAINSHADER_INVALIDCLASSLINKAGE,
	// D3D11_MESSAGE_ID_DEVICE_DSSETSHADERRESOURCES_VIEWS_EMPTY, D3D11_MESSAGE_ID_DSSETCONSTANTBUFFERS_INVALIDBUFFER,
	// D3D11_MESSAGE_ID_DEVICE_DSSETCONSTANTBUFFERS_BUFFERS_EMPTY, D3D11_MESSAGE_ID_DEVICE_DSSETSAMPLERS_SAMPLERS_EMPTY,
	// D3D11_MESSAGE_ID_DEVICE_DSGETSHADERRESOURCES_VIEWS_EMPTY, D3D11_MESSAGE_ID_DEVICE_DSGETCONSTANTBUFFERS_BUFFERS_EMPTY,
	// D3D11_MESSAGE_ID_DEVICE_DSGETSAMPLERS_SAMPLERS_EMPTY, D3D11_MESSAGE_ID_DEVICE_DRAW_HS_XOR_DS_MISMATCH,
	// D3D11_MESSAGE_ID_DEFERRED_CONTEXT_REMOVAL_PROCESS_AT_FAULT, D3D11_MESSAGE_ID_DEVICE_DRAWINDIRECT_INVALID_ARG_BUFFER,
	// D3D11_MESSAGE_ID_DEVICE_DRAWINDIRECT_OFFSET_UNALIGNED, D3D11_MESSAGE_ID_DEVICE_DRAWINDIRECT_OFFSET_OVERFLOW,
	// D3D11_MESSAGE_ID_RESOURCE_MAP_INVALIDMAPTYPE, D3D11_MESSAGE_ID_RESOURCE_MAP_INVALIDSUBRESOURCE,
	// D3D11_MESSAGE_ID_RESOURCE_MAP_INVALIDFLAGS, D3D11_MESSAGE_ID_RESOURCE_MAP_ALREADYMAPPED,
	// D3D11_MESSAGE_ID_RESOURCE_MAP_DEVICEREMOVED_RETURN, D3D11_MESSAGE_ID_RESOURCE_MAP_OUTOFMEMORY_RETURN,
	// D3D11_MESSAGE_ID_RESOURCE_MAP_WITHOUT_INITIAL_DISCARD, D3D11_MESSAGE_ID_RESOURCE_UNMAP_INVALIDSUBRESOURCE,
	// D3D11_MESSAGE_ID_RESOURCE_UNMAP_NOTMAPPED, D3D11_MESSAGE_ID_DEVICE_DRAW_RASTERIZING_CONTROL_POINTS,
	// D3D11_MESSAGE_ID_DEVICE_IASETPRIMITIVETOPOLOGY_TOPOLOGY_UNSUPPORTED, D3D11_MESSAGE_ID_DEVICE_DRAW_HS_DS_SIGNATURE_MISMATCH,
	// D3D11_MESSAGE_ID_DEVICE_DRAW_HULL_SHADER_INPUT_TOPOLOGY_MISMATCH, D3D11_MESSAGE_ID_DEVICE_DRAW_HS_DS_CONTROL_POINT_COUNT_MISMATCH,
	// D3D11_MESSAGE_ID_DEVICE_DRAW_HS_DS_TESSELLATOR_DOMAIN_MISMATCH, D3D11_MESSAGE_ID_CREATE_CONTEXT, D3D11_MESSAGE_ID_LIVE_CONTEXT,
	// D3D11_MESSAGE_ID_DESTROY_CONTEXT, D3D11_MESSAGE_ID_CREATE_BUFFER, D3D11_MESSAGE_ID_LIVE_BUFFER_WIN7, D3D11_MESSAGE_ID_DESTROY_BUFFER,
	// D3D11_MESSAGE_ID_CREATE_TEXTURE1D, D3D11_MESSAGE_ID_LIVE_TEXTURE1D_WIN7, D3D11_MESSAGE_ID_DESTROY_TEXTURE1D,
	// D3D11_MESSAGE_ID_CREATE_TEXTURE2D, D3D11_MESSAGE_ID_LIVE_TEXTURE2D_WIN7, D3D11_MESSAGE_ID_DESTROY_TEXTURE2D,
	// D3D11_MESSAGE_ID_CREATE_TEXTURE3D, D3D11_MESSAGE_ID_LIVE_TEXTURE3D_WIN7, D3D11_MESSAGE_ID_DESTROY_TEXTURE3D,
	// D3D11_MESSAGE_ID_CREATE_SHADERRESOURCEVIEW, D3D11_MESSAGE_ID_LIVE_SHADERRESOURCEVIEW_WIN7,
	// D3D11_MESSAGE_ID_DESTROY_SHADERRESOURCEVIEW, D3D11_MESSAGE_ID_CREATE_RENDERTARGETVIEW, D3D11_MESSAGE_ID_LIVE_RENDERTARGETVIEW_WIN7,
	// D3D11_MESSAGE_ID_DESTROY_RENDERTARGETVIEW, D3D11_MESSAGE_ID_CREATE_DEPTHSTENCILVIEW, D3D11_MESSAGE_ID_LIVE_DEPTHSTENCILVIEW_WIN7,
	// D3D11_MESSAGE_ID_DESTROY_DEPTHSTENCILVIEW, D3D11_MESSAGE_ID_CREATE_VERTEXSHADER, D3D11_MESSAGE_ID_LIVE_VERTEXSHADER_WIN7,
	// D3D11_MESSAGE_ID_DESTROY_VERTEXSHADER, D3D11_MESSAGE_ID_CREATE_HULLSHADER, D3D11_MESSAGE_ID_LIVE_HULLSHADER,
	// D3D11_MESSAGE_ID_DESTROY_HULLSHADER, D3D11_MESSAGE_ID_CREATE_DOMAINSHADER, D3D11_MESSAGE_ID_LIVE_DOMAINSHADER,
	// D3D11_MESSAGE_ID_DESTROY_DOMAINSHADER, D3D11_MESSAGE_ID_CREATE_GEOMETRYSHADER, D3D11_MESSAGE_ID_LIVE_GEOMETRYSHADER_WIN7,
	// D3D11_MESSAGE_ID_DESTROY_GEOMETRYSHADER, D3D11_MESSAGE_ID_CREATE_PIXELSHADER, D3D11_MESSAGE_ID_LIVE_PIXELSHADER_WIN7,
	// D3D11_MESSAGE_ID_DESTROY_PIXELSHADER, D3D11_MESSAGE_ID_CREATE_INPUTLAYOUT, D3D11_MESSAGE_ID_LIVE_INPUTLAYOUT_WIN7,
	// D3D11_MESSAGE_ID_DESTROY_INPUTLAYOUT, D3D11_MESSAGE_ID_CREATE_SAMPLER, D3D11_MESSAGE_ID_LIVE_SAMPLER_WIN7,
	// D3D11_MESSAGE_ID_DESTROY_SAMPLER, D3D11_MESSAGE_ID_CREATE_BLENDSTATE, D3D11_MESSAGE_ID_LIVE_BLENDSTATE_WIN7,
	// D3D11_MESSAGE_ID_DESTROY_BLENDSTATE, D3D11_MESSAGE_ID_CREATE_DEPTHSTENCILSTATE, D3D11_MESSAGE_ID_LIVE_DEPTHSTENCILSTATE_WIN7,
	// D3D11_MESSAGE_ID_DESTROY_DEPTHSTENCILSTATE, D3D11_MESSAGE_ID_CREATE_RASTERIZERSTATE, D3D11_MESSAGE_ID_LIVE_RASTERIZERSTATE_WIN7,
	// D3D11_MESSAGE_ID_DESTROY_RASTERIZERSTATE, D3D11_MESSAGE_ID_CREATE_QUERY, D3D11_MESSAGE_ID_LIVE_QUERY_WIN7,
	// D3D11_MESSAGE_ID_DESTROY_QUERY, D3D11_MESSAGE_ID_CREATE_PREDICATE, D3D11_MESSAGE_ID_LIVE_PREDICATE_WIN7,
	// D3D11_MESSAGE_ID_DESTROY_PREDICATE, D3D11_MESSAGE_ID_CREATE_COUNTER, D3D11_MESSAGE_ID_DESTROY_COUNTER,
	// D3D11_MESSAGE_ID_CREATE_COMMANDLIST, D3D11_MESSAGE_ID_LIVE_COMMANDLIST, D3D11_MESSAGE_ID_DESTROY_COMMANDLIST,
	// D3D11_MESSAGE_ID_CREATE_CLASSINSTANCE, D3D11_MESSAGE_ID_LIVE_CLASSINSTANCE, D3D11_MESSAGE_ID_DESTROY_CLASSINSTANCE,
	// D3D11_MESSAGE_ID_CREATE_CLASSLINKAGE, D3D11_MESSAGE_ID_LIVE_CLASSLINKAGE, D3D11_MESSAGE_ID_DESTROY_CLASSLINKAGE,
	// D3D11_MESSAGE_ID_LIVE_DEVICE_WIN7, D3D11_MESSAGE_ID_LIVE_OBJECT_SUMMARY_WIN7, D3D11_MESSAGE_ID_CREATE_COMPUTESHADER,
	// D3D11_MESSAGE_ID_LIVE_COMPUTESHADER, D3D11_MESSAGE_ID_DESTROY_COMPUTESHADER, D3D11_MESSAGE_ID_CREATE_UNORDEREDACCESSVIEW,
	// D3D11_MESSAGE_ID_LIVE_UNORDEREDACCESSVIEW, D3D11_MESSAGE_ID_DESTROY_UNORDEREDACCESSVIEW,
	// D3D11_MESSAGE_ID_DEVICE_SETSHADER_INTERFACES_FEATURELEVEL, D3D11_MESSAGE_ID_DEVICE_SETSHADER_INTERFACE_COUNT_MISMATCH,
	// D3D11_MESSAGE_ID_DEVICE_SETSHADER_INVALID_INSTANCE, D3D11_MESSAGE_ID_DEVICE_SETSHADER_INVALID_INSTANCE_INDEX,
	// D3D11_MESSAGE_ID_DEVICE_SETSHADER_INVALID_INSTANCE_TYPE, D3D11_MESSAGE_ID_DEVICE_SETSHADER_INVALID_INSTANCE_DATA,
	// D3D11_MESSAGE_ID_DEVICE_SETSHADER_UNBOUND_INSTANCE_DATA, D3D11_MESSAGE_ID_DEVICE_SETSHADER_INSTANCE_DATA_BINDINGS,
	// D3D11_MESSAGE_ID_DEVICE_CREATESHADER_CLASSLINKAGE_FULL, D3D11_MESSAGE_ID_DEVICE_CHECKFEATURESUPPORT_UNRECOGNIZED_FEATURE,
	// D3D11_MESSAGE_ID_DEVICE_CHECKFEATURESUPPORT_MISMATCHED_DATA_SIZE, D3D11_MESSAGE_ID_DEVICE_CHECKFEATURESUPPORT_INVALIDARG_RETURN,
	// D3D11_MESSAGE_ID_DEVICE_CSSETSHADERRESOURCES_HAZARD, D3D11_MESSAGE_ID_DEVICE_CSSETCONSTANTBUFFERS_HAZARD,
	// D3D11_MESSAGE_ID_CSSETSHADERRESOURCES_UNBINDDELETINGOBJECT, D3D11_MESSAGE_ID_CSSETCONSTANTBUFFERS_UNBINDDELETINGOBJECT,
	// D3D11_MESSAGE_ID_CREATECOMPUTESHADER_INVALIDCALL, D3D11_MESSAGE_ID_CREATECOMPUTESHADER_OUTOFMEMORY,
	// D3D11_MESSAGE_ID_CREATECOMPUTESHADER_INVALIDSHADERBYTECODE, D3D11_MESSAGE_ID_CREATECOMPUTESHADER_INVALIDSHADERTYPE,
	// D3D11_MESSAGE_ID_CREATECOMPUTESHADER_INVALIDCLASSLINKAGE, D3D11_MESSAGE_ID_DEVICE_CSSETSHADERRESOURCES_VIEWS_EMPTY,
	// D3D11_MESSAGE_ID_CSSETCONSTANTBUFFERS_INVALIDBUFFER, D3D11_MESSAGE_ID_DEVICE_CSSETCONSTANTBUFFERS_BUFFERS_EMPTY,
	// D3D11_MESSAGE_ID_DEVICE_CSSETSAMPLERS_SAMPLERS_EMPTY, D3D11_MESSAGE_ID_DEVICE_CSGETSHADERRESOURCES_VIEWS_EMPTY,
	// D3D11_MESSAGE_ID_DEVICE_CSGETCONSTANTBUFFERS_BUFFERS_EMPTY, D3D11_MESSAGE_ID_DEVICE_CSGETSAMPLERS_SAMPLERS_EMPTY,
	// D3D11_MESSAGE_ID_DEVICE_CREATEVERTEXSHADER_DOUBLEFLOATOPSNOTSUPPORTED,
	// D3D11_MESSAGE_ID_DEVICE_CREATEHULLSHADER_DOUBLEFLOATOPSNOTSUPPORTED,
	// D3D11_MESSAGE_ID_DEVICE_CREATEDOMAINSHADER_DOUBLEFLOATOPSNOTSUPPORTED,
	// D3D11_MESSAGE_ID_DEVICE_CREATEGEOMETRYSHADER_DOUBLEFLOATOPSNOTSUPPORTED,
	// D3D11_MESSAGE_ID_DEVICE_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_DOUBLEFLOATOPSNOTSUPPORTED,
	// D3D11_MESSAGE_ID_DEVICE_CREATEPIXELSHADER_DOUBLEFLOATOPSNOTSUPPORTED,
	// D3D11_MESSAGE_ID_DEVICE_CREATECOMPUTESHADER_DOUBLEFLOATOPSNOTSUPPORTED, D3D11_MESSAGE_ID_CREATEBUFFER_INVALIDSTRUCTURESTRIDE,
	// D3D11_MESSAGE_ID_CREATESHADERRESOURCEVIEW_INVALIDFLAGS, D3D11_MESSAGE_ID_CREATEUNORDEREDACCESSVIEW_INVALIDRESOURCE,
	// D3D11_MESSAGE_ID_CREATEUNORDEREDACCESSVIEW_INVALIDDESC, D3D11_MESSAGE_ID_CREATEUNORDEREDACCESSVIEW_INVALIDFORMAT,
	// D3D11_MESSAGE_ID_CREATEUNORDEREDACCESSVIEW_INVALIDDIMENSIONS, D3D11_MESSAGE_ID_CREATEUNORDEREDACCESSVIEW_UNRECOGNIZEDFORMAT,
	// D3D11_MESSAGE_ID_DEVICE_OMSETRENDERTARGETSANDUNORDEREDACCESSVIEWS_HAZARD,
	// D3D11_MESSAGE_ID_DEVICE_OMSETRENDERTARGETSANDUNORDEREDACCESSVIEWS_OVERLAPPING_OLD_SLOTS,
	// D3D11_MESSAGE_ID_DEVICE_OMSETRENDERTARGETSANDUNORDEREDACCESSVIEWS_NO_OP,
	// D3D11_MESSAGE_ID_CSSETUNORDEREDACCESSVIEWS_UNBINDDELETINGOBJECT, D3D11_MESSAGE_ID_PSSETUNORDEREDACCESSVIEWS_UNBINDDELETINGOBJECT,
	// D3D11_MESSAGE_ID_CREATEUNORDEREDACCESSVIEW_INVALIDARG_RETURN, D3D11_MESSAGE_ID_CREATEUNORDEREDACCESSVIEW_OUTOFMEMORY_RETURN,
	// D3D11_MESSAGE_ID_CREATEUNORDEREDACCESSVIEW_TOOMANYOBJECTS, D3D11_MESSAGE_ID_DEVICE_CSSETUNORDEREDACCESSVIEWS_HAZARD,
	// D3D11_MESSAGE_ID_CLEARUNORDEREDACCESSVIEW_DENORMFLUSH, D3D11_MESSAGE_ID_DEVICE_CSSETUNORDEREDACCESSS_VIEWS_EMPTY,
	// D3D11_MESSAGE_ID_DEVICE_CSGETUNORDEREDACCESSS_VIEWS_EMPTY, D3D11_MESSAGE_ID_CREATEUNORDEREDACCESSVIEW_INVALIDFLAGS,
	// D3D11_MESSAGE_ID_CREATESHADERRESESOURCEVIEW_TOOMANYOBJECTS, D3D11_MESSAGE_ID_DEVICE_DISPATCHINDIRECT_INVALID_ARG_BUFFER,
	// D3D11_MESSAGE_ID_DEVICE_DISPATCHINDIRECT_OFFSET_UNALIGNED, D3D11_MESSAGE_ID_DEVICE_DISPATCHINDIRECT_OFFSET_OVERFLOW,
	// D3D11_MESSAGE_ID_DEVICE_SETRESOURCEMINLOD_INVALIDCONTEXT, D3D11_MESSAGE_ID_DEVICE_SETRESOURCEMINLOD_INVALIDRESOURCE,
	// D3D11_MESSAGE_ID_DEVICE_SETRESOURCEMINLOD_INVALIDMINLOD, D3D11_MESSAGE_ID_DEVICE_GETRESOURCEMINLOD_INVALIDCONTEXT,
	// D3D11_MESSAGE_ID_DEVICE_GETRESOURCEMINLOD_INVALIDRESOURCE, D3D11_MESSAGE_ID_OMSETDEPTHSTENCIL_UNBINDDELETINGOBJECT,
	// D3D11_MESSAGE_ID_CLEARDEPTHSTENCILVIEW_DEPTH_READONLY, D3D11_MESSAGE_ID_CLEARDEPTHSTENCILVIEW_STENCIL_READONLY,
	// D3D11_MESSAGE_ID_CHECKFEATURESUPPORT_FORMAT_DEPRECATED, D3D11_MESSAGE_ID_DEVICE_UNORDEREDACCESSVIEW_RETURN_TYPE_MISMATCH,
	// D3D11_MESSAGE_ID_DEVICE_UNORDEREDACCESSVIEW_NOT_SET, D3D11_MESSAGE_ID_DEVICE_DRAW_UNORDEREDACCESSVIEW_RENDERTARGETVIEW_OVERLAP,
	// D3D11_MESSAGE_ID_DEVICE_UNORDEREDACCESSVIEW_DIMENSION_MISMATCH, D3D11_MESSAGE_ID_DEVICE_UNORDEREDACCESSVIEW_APPEND_UNSUPPORTED,
	// D3D11_MESSAGE_ID_DEVICE_UNORDEREDACCESSVIEW_ATOMICS_UNSUPPORTED,
	// D3D11_MESSAGE_ID_DEVICE_UNORDEREDACCESSVIEW_STRUCTURE_STRIDE_MISMATCH,
	// D3D11_MESSAGE_ID_DEVICE_UNORDEREDACCESSVIEW_BUFFER_TYPE_MISMATCH, D3D11_MESSAGE_ID_DEVICE_UNORDEREDACCESSVIEW_RAW_UNSUPPORTED,
	// D3D11_MESSAGE_ID_DEVICE_UNORDEREDACCESSVIEW_FORMAT_LD_UNSUPPORTED,
	// D3D11_MESSAGE_ID_DEVICE_UNORDEREDACCESSVIEW_FORMAT_STORE_UNSUPPORTED,
	// D3D11_MESSAGE_ID_DEVICE_UNORDEREDACCESSVIEW_ATOMIC_ADD_UNSUPPORTED,
	// D3D11_MESSAGE_ID_DEVICE_UNORDEREDACCESSVIEW_ATOMIC_BITWISE_OPS_UNSUPPORTED,
	// D3D11_MESSAGE_ID_DEVICE_UNORDEREDACCESSVIEW_ATOMIC_CMPSTORE_CMPEXCHANGE_UNSUPPORTED,
	// D3D11_MESSAGE_ID_DEVICE_UNORDEREDACCESSVIEW_ATOMIC_EXCHANGE_UNSUPPORTED,
	// D3D11_MESSAGE_ID_DEVICE_UNORDEREDACCESSVIEW_ATOMIC_SIGNED_MINMAX_UNSUPPORTED,
	// D3D11_MESSAGE_ID_DEVICE_UNORDEREDACCESSVIEW_ATOMIC_UNSIGNED_MINMAX_UNSUPPORTED,
	// D3D11_MESSAGE_ID_DEVICE_DISPATCH_BOUND_RESOURCE_MAPPED, D3D11_MESSAGE_ID_DEVICE_DISPATCH_THREADGROUPCOUNT_OVERFLOW,
	// D3D11_MESSAGE_ID_DEVICE_DISPATCH_THREADGROUPCOUNT_ZERO, D3D11_MESSAGE_ID_DEVICE_SHADERRESOURCEVIEW_STRUCTURE_STRIDE_MISMATCH,
	// D3D11_MESSAGE_ID_DEVICE_SHADERRESOURCEVIEW_BUFFER_TYPE_MISMATCH, D3D11_MESSAGE_ID_DEVICE_SHADERRESOURCEVIEW_RAW_UNSUPPORTED,
	// D3D11_MESSAGE_ID_DEVICE_DISPATCH_UNSUPPORTED, D3D11_MESSAGE_ID_DEVICE_DISPATCHINDIRECT_UNSUPPORTED,
	// D3D11_MESSAGE_ID_COPYSTRUCTURECOUNT_INVALIDOFFSET, D3D11_MESSAGE_ID_COPYSTRUCTURECOUNT_LARGEOFFSET,
	// D3D11_MESSAGE_ID_COPYSTRUCTURECOUNT_INVALIDDESTINATIONSTATE, D3D11_MESSAGE_ID_COPYSTRUCTURECOUNT_INVALIDSOURCESTATE,
	// D3D11_MESSAGE_ID_CHECKFORMATSUPPORT_FORMAT_NOT_SUPPORTED, D3D11_MESSAGE_ID_DEVICE_CSSETUNORDEREDACCESSVIEWS_INVALIDVIEW,
	// D3D11_MESSAGE_ID_DEVICE_CSSETUNORDEREDACCESSVIEWS_INVALIDOFFSET, D3D11_MESSAGE_ID_DEVICE_CSSETUNORDEREDACCESSVIEWS_TOOMANYVIEWS,
	// D3D11_MESSAGE_ID_CLEARUNORDEREDACCESSVIEWFLOAT_INVALIDFORMAT, D3D11_MESSAGE_ID_DEVICE_UNORDEREDACCESSVIEW_COUNTER_UNSUPPORTED,
	// D3D11_MESSAGE_ID_REF_WARNING, D3D11_MESSAGE_ID_DEVICE_DRAW_PIXEL_SHADER_WITHOUT_RTV_OR_DSV, D3D11_MESSAGE_ID_SHADER_ABORT,
	// D3D11_MESSAGE_ID_SHADER_MESSAGE, D3D11_MESSAGE_ID_SHADER_ERROR, D3D11_MESSAGE_ID_OFFERRESOURCES_INVALIDRESOURCE,
	// D3D11_MESSAGE_ID_HSSETSAMPLERS_UNBINDDELETINGOBJECT, D3D11_MESSAGE_ID_DSSETSAMPLERS_UNBINDDELETINGOBJECT,
	// D3D11_MESSAGE_ID_CSSETSAMPLERS_UNBINDDELETINGOBJECT, D3D11_MESSAGE_ID_HSSETSHADER_UNBINDDELETINGOBJECT,
	// D3D11_MESSAGE_ID_DSSETSHADER_UNBINDDELETINGOBJECT, D3D11_MESSAGE_ID_CSSETSHADER_UNBINDDELETINGOBJECT,
	// D3D11_MESSAGE_ID_ENQUEUESETEVENT_INVALIDARG_RETURN, D3D11_MESSAGE_ID_ENQUEUESETEVENT_OUTOFMEMORY_RETURN,
	// D3D11_MESSAGE_ID_ENQUEUESETEVENT_ACCESSDENIED_RETURN,
	// D3D11_MESSAGE_ID_DEVICE_OMSETRENDERTARGETSANDUNORDEREDACCESSVIEWS_NUMUAVS_INVALIDRANGE, D3D11_MESSAGE_ID_USE_OF_ZERO_REFCOUNT_OBJECT,
	// D3D11_MESSAGE_ID_D3D11_MESSAGES_END, D3D11_MESSAGE_ID_D3D11_1_MESSAGES_START = 0x300000, D3D11_MESSAGE_ID_CREATE_VIDEODECODER,
	// D3D11_MESSAGE_ID_CREATE_VIDEOPROCESSORENUM, D3D11_MESSAGE_ID_CREATE_VIDEOPROCESSOR, D3D11_MESSAGE_ID_CREATE_DECODEROUTPUTVIEW,
	// D3D11_MESSAGE_ID_CREATE_PROCESSORINPUTVIEW, D3D11_MESSAGE_ID_CREATE_PROCESSOROUTPUTVIEW, D3D11_MESSAGE_ID_CREATE_DEVICECONTEXTSTATE,
	// D3D11_MESSAGE_ID_LIVE_VIDEODECODER, D3D11_MESSAGE_ID_LIVE_VIDEOPROCESSORENUM, D3D11_MESSAGE_ID_LIVE_VIDEOPROCESSOR,
	// D3D11_MESSAGE_ID_LIVE_DECODEROUTPUTVIEW, D3D11_MESSAGE_ID_LIVE_PROCESSORINPUTVIEW, D3D11_MESSAGE_ID_LIVE_PROCESSOROUTPUTVIEW,
	// D3D11_MESSAGE_ID_LIVE_DEVICECONTEXTSTATE, D3D11_MESSAGE_ID_DESTROY_VIDEODECODER, D3D11_MESSAGE_ID_DESTROY_VIDEOPROCESSORENUM,
	// D3D11_MESSAGE_ID_DESTROY_VIDEOPROCESSOR, D3D11_MESSAGE_ID_DESTROY_DECODEROUTPUTVIEW, D3D11_MESSAGE_ID_DESTROY_PROCESSORINPUTVIEW,
	// D3D11_MESSAGE_ID_DESTROY_PROCESSOROUTPUTVIEW, D3D11_MESSAGE_ID_DESTROY_DEVICECONTEXTSTATE,
	// D3D11_MESSAGE_ID_CREATEDEVICECONTEXTSTATE_INVALIDFLAGS, D3D11_MESSAGE_ID_CREATEDEVICECONTEXTSTATE_INVALIDFEATURELEVEL,
	// D3D11_MESSAGE_ID_CREATEDEVICECONTEXTSTATE_FEATURELEVELS_NOT_SUPPORTED, D3D11_MESSAGE_ID_CREATEDEVICECONTEXTSTATE_INVALIDREFIID,
	// D3D11_MESSAGE_ID_DEVICE_DISCARDVIEW_INVALIDVIEW, D3D11_MESSAGE_ID_COPYSUBRESOURCEREGION1_INVALIDCOPYFLAGS,
	// D3D11_MESSAGE_ID_UPDATESUBRESOURCE1_INVALIDCOPYFLAGS, D3D11_MESSAGE_ID_CREATERASTERIZERSTATE_INVALIDFORCEDSAMPLECOUNT,
	// D3D11_MESSAGE_ID_CREATEVIDEODECODER_OUTOFMEMORY_RETURN, D3D11_MESSAGE_ID_CREATEVIDEODECODER_NULLPARAM,
	// D3D11_MESSAGE_ID_CREATEVIDEODECODER_INVALIDFORMAT, D3D11_MESSAGE_ID_CREATEVIDEODECODER_ZEROWIDTHHEIGHT,
	// D3D11_MESSAGE_ID_CREATEVIDEODECODER_DRIVER_INVALIDBUFFERSIZE, D3D11_MESSAGE_ID_CREATEVIDEODECODER_DRIVER_INVALIDBUFFERUSAGE,
	// D3D11_MESSAGE_ID_GETVIDEODECODERPROFILECOUNT_OUTOFMEMORY, D3D11_MESSAGE_ID_GETVIDEODECODERPROFILE_NULLPARAM,
	// D3D11_MESSAGE_ID_GETVIDEODECODERPROFILE_INVALIDINDEX, D3D11_MESSAGE_ID_GETVIDEODECODERPROFILE_OUTOFMEMORY_RETURN,
	// D3D11_MESSAGE_ID_CHECKVIDEODECODERFORMAT_NULLPARAM, D3D11_MESSAGE_ID_CHECKVIDEODECODERFORMAT_OUTOFMEMORY_RETURN,
	// D3D11_MESSAGE_ID_GETVIDEODECODERCONFIGCOUNT_NULLPARAM, D3D11_MESSAGE_ID_GETVIDEODECODERCONFIGCOUNT_OUTOFMEMORY_RETURN,
	// D3D11_MESSAGE_ID_GETVIDEODECODERCONFIG_NULLPARAM, D3D11_MESSAGE_ID_GETVIDEODECODERCONFIG_INVALIDINDEX,
	// D3D11_MESSAGE_ID_GETVIDEODECODERCONFIG_OUTOFMEMORY_RETURN, D3D11_MESSAGE_ID_GETDECODERCREATIONPARAMS_NULLPARAM,
	// D3D11_MESSAGE_ID_GETDECODERDRIVERHANDLE_NULLPARAM, D3D11_MESSAGE_ID_GETDECODERBUFFER_NULLPARAM,
	// D3D11_MESSAGE_ID_GETDECODERBUFFER_INVALIDBUFFER, D3D11_MESSAGE_ID_GETDECODERBUFFER_INVALIDTYPE,
	// D3D11_MESSAGE_ID_GETDECODERBUFFER_LOCKED, D3D11_MESSAGE_ID_RELEASEDECODERBUFFER_NULLPARAM,
	// D3D11_MESSAGE_ID_RELEASEDECODERBUFFER_INVALIDTYPE, D3D11_MESSAGE_ID_RELEASEDECODERBUFFER_NOTLOCKED,
	// D3D11_MESSAGE_ID_DECODERBEGINFRAME_NULLPARAM, D3D11_MESSAGE_ID_DECODERBEGINFRAME_HAZARD, D3D11_MESSAGE_ID_DECODERENDFRAME_NULLPARAM,
	// D3D11_MESSAGE_ID_SUBMITDECODERBUFFERS_NULLPARAM, D3D11_MESSAGE_ID_SUBMITDECODERBUFFERS_INVALIDTYPE,
	// D3D11_MESSAGE_ID_DECODEREXTENSION_NULLPARAM, D3D11_MESSAGE_ID_DECODEREXTENSION_INVALIDRESOURCE,
	// D3D11_MESSAGE_ID_CREATEVIDEOPROCESSORENUMERATOR_OUTOFMEMORY_RETURN, D3D11_MESSAGE_ID_CREATEVIDEOPROCESSORENUMERATOR_NULLPARAM,
	// D3D11_MESSAGE_ID_CREATEVIDEOPROCESSORENUMERATOR_INVALIDFRAMEFORMAT, D3D11_MESSAGE_ID_CREATEVIDEOPROCESSORENUMERATOR_INVALIDUSAGE,
	// D3D11_MESSAGE_ID_CREATEVIDEOPROCESSORENUMERATOR_INVALIDINPUTFRAMERATE,
	// D3D11_MESSAGE_ID_CREATEVIDEOPROCESSORENUMERATOR_INVALIDOUTPUTFRAMERATE,
	// D3D11_MESSAGE_ID_CREATEVIDEOPROCESSORENUMERATOR_INVALIDWIDTHHEIGHT, D3D11_MESSAGE_ID_GETVIDEOPROCESSORCONTENTDESC_NULLPARAM,
	// D3D11_MESSAGE_ID_CHECKVIDEOPROCESSORFORMAT_NULLPARAM, D3D11_MESSAGE_ID_GETVIDEOPROCESSORCAPS_NULLPARAM,
	// D3D11_MESSAGE_ID_GETVIDEOPROCESSORRATECONVERSIONCAPS_NULLPARAM, D3D11_MESSAGE_ID_GETVIDEOPROCESSORRATECONVERSIONCAPS_INVALIDINDEX,
	// D3D11_MESSAGE_ID_GETVIDEOPROCESSORCUSTOMRATE_NULLPARAM, D3D11_MESSAGE_ID_GETVIDEOPROCESSORCUSTOMRATE_INVALIDINDEX,
	// D3D11_MESSAGE_ID_GETVIDEOPROCESSORFILTERRANGE_NULLPARAM, D3D11_MESSAGE_ID_GETVIDEOPROCESSORFILTERRANGE_UNSUPPORTED,
	// D3D11_MESSAGE_ID_CREATEVIDEOPROCESSOR_OUTOFMEMORY_RETURN, D3D11_MESSAGE_ID_CREATEVIDEOPROCESSOR_NULLPARAM,
	// D3D11_MESSAGE_ID_VIDEOPROCESSORSETOUTPUTTARGETRECT_NULLPARAM, D3D11_MESSAGE_ID_VIDEOPROCESSORSETOUTPUTBACKGROUNDCOLOR_NULLPARAM,
	// D3D11_MESSAGE_ID_VIDEOPROCESSORSETOUTPUTBACKGROUNDCOLOR_INVALIDALPHA, D3D11_MESSAGE_ID_VIDEOPROCESSORSETOUTPUTCOLORSPACE_NULLPARAM,
	// D3D11_MESSAGE_ID_VIDEOPROCESSORSETOUTPUTALPHAFILLMODE_NULLPARAM, D3D11_MESSAGE_ID_VIDEOPROCESSORSETOUTPUTALPHAFILLMODE_UNSUPPORTED,
	// D3D11_MESSAGE_ID_VIDEOPROCESSORSETOUTPUTALPHAFILLMODE_INVALIDSTREAM,
	// D3D11_MESSAGE_ID_VIDEOPROCESSORSETOUTPUTALPHAFILLMODE_INVALIDFILLMODE,
	// D3D11_MESSAGE_ID_VIDEOPROCESSORSETOUTPUTCONSTRICTION_NULLPARAM, D3D11_MESSAGE_ID_VIDEOPROCESSORSETOUTPUTSTEREOMODE_NULLPARAM,
	// D3D11_MESSAGE_ID_VIDEOPROCESSORSETOUTPUTSTEREOMODE_UNSUPPORTED, D3D11_MESSAGE_ID_VIDEOPROCESSORSETOUTPUTEXTENSION_NULLPARAM,
	// D3D11_MESSAGE_ID_VIDEOPROCESSORGETOUTPUTTARGETRECT_NULLPARAM, D3D11_MESSAGE_ID_VIDEOPROCESSORGETOUTPUTBACKGROUNDCOLOR_NULLPARAM,
	// D3D11_MESSAGE_ID_VIDEOPROCESSORGETOUTPUTCOLORSPACE_NULLPARAM, D3D11_MESSAGE_ID_VIDEOPROCESSORGETOUTPUTALPHAFILLMODE_NULLPARAM,
	// D3D11_MESSAGE_ID_VIDEOPROCESSORGETOUTPUTCONSTRICTION_NULLPARAM, D3D11_MESSAGE_ID_VIDEOPROCESSORSETOUTPUTCONSTRICTION_UNSUPPORTED,
	// D3D11_MESSAGE_ID_VIDEOPROCESSORSETOUTPUTCONSTRICTION_INVALIDSIZE, D3D11_MESSAGE_ID_VIDEOPROCESSORGETOUTPUTSTEREOMODE_NULLPARAM,
	// D3D11_MESSAGE_ID_VIDEOPROCESSORGETOUTPUTEXTENSION_NULLPARAM, D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMFRAMEFORMAT_NULLPARAM,
	// D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMFRAMEFORMAT_INVALIDFORMAT, D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMFRAMEFORMAT_INVALIDSTREAM,
	// D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMCOLORSPACE_NULLPARAM, D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMCOLORSPACE_INVALIDSTREAM,
	// D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMOUTPUTRATE_NULLPARAM, D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMOUTPUTRATE_INVALIDRATE,
	// D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMOUTPUTRATE_INVALIDFLAG, D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMOUTPUTRATE_INVALIDSTREAM,
	// D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMSOURCERECT_NULLPARAM, D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMSOURCERECT_INVALIDSTREAM,
	// D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMSOURCERECT_INVALIDRECT, D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMDESTRECT_NULLPARAM,
	// D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMDESTRECT_INVALIDSTREAM, D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMDESTRECT_INVALIDRECT,
	// D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMALPHA_NULLPARAM, D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMALPHA_INVALIDSTREAM,
	// D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMALPHA_INVALIDALPHA, D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMPALETTE_NULLPARAM,
	// D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMPALETTE_INVALIDSTREAM, D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMPALETTE_INVALIDCOUNT,
	// D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMPALETTE_INVALIDALPHA, D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMPIXELASPECTRATIO_NULLPARAM,
	// D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMPIXELASPECTRATIO_INVALIDSTREAM,
	// D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMPIXELASPECTRATIO_INVALIDRATIO, D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMLUMAKEY_NULLPARAM,
	// D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMLUMAKEY_INVALIDSTREAM, D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMLUMAKEY_INVALIDRANGE,
	// D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMLUMAKEY_UNSUPPORTED, D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMSTEREOFORMAT_NULLPARAM,
	// D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMSTEREOFORMAT_INVALIDSTREAM, D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMSTEREOFORMAT_UNSUPPORTED,
	// D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMSTEREOFORMAT_FLIPUNSUPPORTED,
	// D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMSTEREOFORMAT_MONOOFFSETUNSUPPORTED,
	// D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMSTEREOFORMAT_FORMATUNSUPPORTED,
	// D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMSTEREOFORMAT_INVALIDFORMAT,
	// D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMAUTOPROCESSINGMODE_NULLPARAM,
	// D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMAUTOPROCESSINGMODE_INVALIDSTREAM, D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMFILTER_NULLPARAM,
	// D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMFILTER_INVALIDSTREAM, D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMFILTER_INVALIDFILTER,
	// D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMFILTER_UNSUPPORTED, D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMFILTER_INVALIDLEVEL,
	// D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMEXTENSION_NULLPARAM, D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMEXTENSION_INVALIDSTREAM,
	// D3D11_MESSAGE_ID_VIDEOPROCESSORGETSTREAMFRAMEFORMAT_NULLPARAM, D3D11_MESSAGE_ID_VIDEOPROCESSORGETSTREAMCOLORSPACE_NULLPARAM,
	// D3D11_MESSAGE_ID_VIDEOPROCESSORGETSTREAMOUTPUTRATE_NULLPARAM, D3D11_MESSAGE_ID_VIDEOPROCESSORGETSTREAMSOURCERECT_NULLPARAM,
	// D3D11_MESSAGE_ID_VIDEOPROCESSORGETSTREAMDESTRECT_NULLPARAM, D3D11_MESSAGE_ID_VIDEOPROCESSORGETSTREAMALPHA_NULLPARAM,
	// D3D11_MESSAGE_ID_VIDEOPROCESSORGETSTREAMPALETTE_NULLPARAM, D3D11_MESSAGE_ID_VIDEOPROCESSORGETSTREAMPIXELASPECTRATIO_NULLPARAM,
	// D3D11_MESSAGE_ID_VIDEOPROCESSORGETSTREAMLUMAKEY_NULLPARAM, D3D11_MESSAGE_ID_VIDEOPROCESSORGETSTREAMSTEREOFORMAT_NULLPARAM,
	// D3D11_MESSAGE_ID_VIDEOPROCESSORGETSTREAMAUTOPROCESSINGMODE_NULLPARAM, D3D11_MESSAGE_ID_VIDEOPROCESSORGETSTREAMFILTER_NULLPARAM,
	// D3D11_MESSAGE_ID_VIDEOPROCESSORGETSTREAMEXTENSION_NULLPARAM, D3D11_MESSAGE_ID_VIDEOPROCESSORGETSTREAMEXTENSION_INVALIDSTREAM,
	// D3D11_MESSAGE_ID_VIDEOPROCESSORBLT_NULLPARAM, D3D11_MESSAGE_ID_VIDEOPROCESSORBLT_INVALIDSTREAMCOUNT,
	// D3D11_MESSAGE_ID_VIDEOPROCESSORBLT_TARGETRECT, D3D11_MESSAGE_ID_VIDEOPROCESSORBLT_INVALIDOUTPUT,
	// D3D11_MESSAGE_ID_VIDEOPROCESSORBLT_INVALIDPASTFRAMES, D3D11_MESSAGE_ID_VIDEOPROCESSORBLT_INVALIDFUTUREFRAMES,
	// D3D11_MESSAGE_ID_VIDEOPROCESSORBLT_INVALIDSOURCERECT, D3D11_MESSAGE_ID_VIDEOPROCESSORBLT_INVALIDDESTRECT,
	// D3D11_MESSAGE_ID_VIDEOPROCESSORBLT_INVALIDINPUTRESOURCE, D3D11_MESSAGE_ID_VIDEOPROCESSORBLT_INVALIDARRAYSIZE,
	// D3D11_MESSAGE_ID_VIDEOPROCESSORBLT_INVALIDARRAY, D3D11_MESSAGE_ID_VIDEOPROCESSORBLT_RIGHTEXPECTED,
	// D3D11_MESSAGE_ID_VIDEOPROCESSORBLT_RIGHTNOTEXPECTED, D3D11_MESSAGE_ID_VIDEOPROCESSORBLT_STEREONOTENABLED,
	// D3D11_MESSAGE_ID_VIDEOPROCESSORBLT_INVALIDRIGHTRESOURCE, D3D11_MESSAGE_ID_VIDEOPROCESSORBLT_NOSTEREOSTREAMS,
	// D3D11_MESSAGE_ID_VIDEOPROCESSORBLT_INPUTHAZARD, D3D11_MESSAGE_ID_VIDEOPROCESSORBLT_OUTPUTHAZARD,
	// D3D11_MESSAGE_ID_CREATEVIDEODECODEROUTPUTVIEW_OUTOFMEMORY_RETURN, D3D11_MESSAGE_ID_CREATEVIDEODECODEROUTPUTVIEW_NULLPARAM,
	// D3D11_MESSAGE_ID_CREATEVIDEODECODEROUTPUTVIEW_INVALIDTYPE, D3D11_MESSAGE_ID_CREATEVIDEODECODEROUTPUTVIEW_INVALIDBIND,
	// D3D11_MESSAGE_ID_CREATEVIDEODECODEROUTPUTVIEW_UNSUPPORTEDFORMAT, D3D11_MESSAGE_ID_CREATEVIDEODECODEROUTPUTVIEW_INVALIDMIP,
	// D3D11_MESSAGE_ID_CREATEVIDEODECODEROUTPUTVIEW_UNSUPPORTEMIP, D3D11_MESSAGE_ID_CREATEVIDEODECODEROUTPUTVIEW_INVALIDARRAYSIZE,
	// D3D11_MESSAGE_ID_CREATEVIDEODECODEROUTPUTVIEW_INVALIDARRAY, D3D11_MESSAGE_ID_CREATEVIDEODECODEROUTPUTVIEW_INVALIDDIMENSION,
	// D3D11_MESSAGE_ID_CREATEVIDEOPROCESSORINPUTVIEW_OUTOFMEMORY_RETURN, D3D11_MESSAGE_ID_CREATEVIDEOPROCESSORINPUTVIEW_NULLPARAM,
	// D3D11_MESSAGE_ID_CREATEVIDEOPROCESSORINPUTVIEW_INVALIDTYPE, D3D11_MESSAGE_ID_CREATEVIDEOPROCESSORINPUTVIEW_INVALIDBIND,
	// D3D11_MESSAGE_ID_CREATEVIDEOPROCESSORINPUTVIEW_INVALIDMISC, D3D11_MESSAGE_ID_CREATEVIDEOPROCESSORINPUTVIEW_INVALIDUSAGE,
	// D3D11_MESSAGE_ID_CREATEVIDEOPROCESSORINPUTVIEW_INVALIDFORMAT, D3D11_MESSAGE_ID_CREATEVIDEOPROCESSORINPUTVIEW_INVALIDFOURCC,
	// D3D11_MESSAGE_ID_CREATEVIDEOPROCESSORINPUTVIEW_INVALIDMIP, D3D11_MESSAGE_ID_CREATEVIDEOPROCESSORINPUTVIEW_UNSUPPORTEDMIP,
	// D3D11_MESSAGE_ID_CREATEVIDEOPROCESSORINPUTVIEW_INVALIDARRAYSIZE, D3D11_MESSAGE_ID_CREATEVIDEOPROCESSORINPUTVIEW_INVALIDARRAY,
	// D3D11_MESSAGE_ID_CREATEVIDEOPROCESSORINPUTVIEW_INVALIDDIMENSION, D3D11_MESSAGE_ID_CREATEVIDEOPROCESSOROUTPUTVIEW_OUTOFMEMORY_RETURN,
	// D3D11_MESSAGE_ID_CREATEVIDEOPROCESSOROUTPUTVIEW_NULLPARAM, D3D11_MESSAGE_ID_CREATEVIDEOPROCESSOROUTPUTVIEW_INVALIDTYPE,
	// D3D11_MESSAGE_ID_CREATEVIDEOPROCESSOROUTPUTVIEW_INVALIDBIND, D3D11_MESSAGE_ID_CREATEVIDEOPROCESSOROUTPUTVIEW_INVALIDFORMAT,
	// D3D11_MESSAGE_ID_CREATEVIDEOPROCESSOROUTPUTVIEW_INVALIDMIP, D3D11_MESSAGE_ID_CREATEVIDEOPROCESSOROUTPUTVIEW_UNSUPPORTEDMIP,
	// D3D11_MESSAGE_ID_CREATEVIDEOPROCESSOROUTPUTVIEW_UNSUPPORTEDARRAY, D3D11_MESSAGE_ID_CREATEVIDEOPROCESSOROUTPUTVIEW_INVALIDARRAY,
	// D3D11_MESSAGE_ID_CREATEVIDEOPROCESSOROUTPUTVIEW_INVALIDDIMENSION, D3D11_MESSAGE_ID_DEVICE_DRAW_INVALID_USE_OF_FORCED_SAMPLE_COUNT,
	// D3D11_MESSAGE_ID_CREATEBLENDSTATE_INVALIDLOGICOPS, D3D11_MESSAGE_ID_CREATESHADERRESOURCEVIEW_INVALIDDARRAYWITHDECODER,
	// D3D11_MESSAGE_ID_CREATEUNORDEREDACCESSVIEW_INVALIDDARRAYWITHDECODER,
	// D3D11_MESSAGE_ID_CREATERENDERTARGETVIEW_INVALIDDARRAYWITHDECODER, D3D11_MESSAGE_ID_DEVICE_LOCKEDOUT_INTERFACE,
	// D3D11_MESSAGE_ID_REF_WARNING_ATOMIC_INCONSISTENT, D3D11_MESSAGE_ID_REF_WARNING_READING_UNINITIALIZED_RESOURCE,
	// D3D11_MESSAGE_ID_REF_WARNING_RAW_HAZARD, D3D11_MESSAGE_ID_REF_WARNING_WAR_HAZARD, D3D11_MESSAGE_ID_REF_WARNING_WAW_HAZARD,
	// D3D11_MESSAGE_ID_CREATECRYPTOSESSION_NULLPARAM, D3D11_MESSAGE_ID_CREATECRYPTOSESSION_OUTOFMEMORY_RETURN,
	// D3D11_MESSAGE_ID_GETCRYPTOTYPE_NULLPARAM, D3D11_MESSAGE_ID_GETDECODERPROFILE_NULLPARAM,
	// D3D11_MESSAGE_ID_GETCRYPTOSESSIONCERTIFICATESIZE_NULLPARAM, D3D11_MESSAGE_ID_GETCRYPTOSESSIONCERTIFICATE_NULLPARAM,
	// D3D11_MESSAGE_ID_GETCRYPTOSESSIONCERTIFICATE_WRONGSIZE, D3D11_MESSAGE_ID_GETCRYPTOSESSIONHANDLE_WRONGSIZE,
	// D3D11_MESSAGE_ID_NEGOTIATECRPYTOSESSIONKEYEXCHANGE_NULLPARAM, D3D11_MESSAGE_ID_ENCRYPTIONBLT_UNSUPPORTED,
	// D3D11_MESSAGE_ID_ENCRYPTIONBLT_NULLPARAM, D3D11_MESSAGE_ID_ENCRYPTIONBLT_SRC_WRONGDEVICE,
	// D3D11_MESSAGE_ID_ENCRYPTIONBLT_DST_WRONGDEVICE, D3D11_MESSAGE_ID_ENCRYPTIONBLT_FORMAT_MISMATCH,
	// D3D11_MESSAGE_ID_ENCRYPTIONBLT_SIZE_MISMATCH, D3D11_MESSAGE_ID_ENCRYPTIONBLT_SRC_MULTISAMPLED,
	// D3D11_MESSAGE_ID_ENCRYPTIONBLT_DST_NOT_STAGING, D3D11_MESSAGE_ID_ENCRYPTIONBLT_SRC_MAPPED, D3D11_MESSAGE_ID_ENCRYPTIONBLT_DST_MAPPED,
	// D3D11_MESSAGE_ID_ENCRYPTIONBLT_SRC_OFFERED, D3D11_MESSAGE_ID_ENCRYPTIONBLT_DST_OFFERED,
	// D3D11_MESSAGE_ID_ENCRYPTIONBLT_SRC_CONTENT_UNDEFINED, D3D11_MESSAGE_ID_DECRYPTIONBLT_UNSUPPORTED,
	// D3D11_MESSAGE_ID_DECRYPTIONBLT_NULLPARAM, D3D11_MESSAGE_ID_DECRYPTIONBLT_SRC_WRONGDEVICE,
	// D3D11_MESSAGE_ID_DECRYPTIONBLT_DST_WRONGDEVICE, D3D11_MESSAGE_ID_DECRYPTIONBLT_FORMAT_MISMATCH,
	// D3D11_MESSAGE_ID_DECRYPTIONBLT_SIZE_MISMATCH, D3D11_MESSAGE_ID_DECRYPTIONBLT_DST_MULTISAMPLED,
	// D3D11_MESSAGE_ID_DECRYPTIONBLT_SRC_NOT_STAGING, D3D11_MESSAGE_ID_DECRYPTIONBLT_DST_NOT_RENDER_TARGET,
	// D3D11_MESSAGE_ID_DECRYPTIONBLT_SRC_MAPPED, D3D11_MESSAGE_ID_DECRYPTIONBLT_DST_MAPPED, D3D11_MESSAGE_ID_DECRYPTIONBLT_SRC_OFFERED,
	// D3D11_MESSAGE_ID_DECRYPTIONBLT_DST_OFFERED, D3D11_MESSAGE_ID_DECRYPTIONBLT_SRC_CONTENT_UNDEFINED,
	// D3D11_MESSAGE_ID_STARTSESSIONKEYREFRESH_NULLPARAM, D3D11_MESSAGE_ID_STARTSESSIONKEYREFRESH_INVALIDSIZE,
	// D3D11_MESSAGE_ID_FINISHSESSIONKEYREFRESH_NULLPARAM, D3D11_MESSAGE_ID_GETENCRYPTIONBLTKEY_NULLPARAM,
	// D3D11_MESSAGE_ID_GETENCRYPTIONBLTKEY_INVALIDSIZE, D3D11_MESSAGE_ID_GETCONTENTPROTECTIONCAPS_NULLPARAM,
	// D3D11_MESSAGE_ID_CHECKCRYPTOKEYEXCHANGE_NULLPARAM, D3D11_MESSAGE_ID_CHECKCRYPTOKEYEXCHANGE_INVALIDINDEX,
	// D3D11_MESSAGE_ID_CREATEAUTHENTICATEDCHANNEL_NULLPARAM, D3D11_MESSAGE_ID_CREATEAUTHENTICATEDCHANNEL_UNSUPPORTED,
	// D3D11_MESSAGE_ID_CREATEAUTHENTICATEDCHANNEL_INVALIDTYPE, D3D11_MESSAGE_ID_CREATEAUTHENTICATEDCHANNEL_OUTOFMEMORY_RETURN,
	// D3D11_MESSAGE_ID_GETAUTHENTICATEDCHANNELCERTIFICATESIZE_INVALIDCHANNEL,
	// D3D11_MESSAGE_ID_GETAUTHENTICATEDCHANNELCERTIFICATESIZE_NULLPARAM,
	// D3D11_MESSAGE_ID_GETAUTHENTICATEDCHANNELCERTIFICATE_INVALIDCHANNEL, D3D11_MESSAGE_ID_GETAUTHENTICATEDCHANNELCERTIFICATE_NULLPARAM,
	// D3D11_MESSAGE_ID_GETAUTHENTICATEDCHANNELCERTIFICATE_WRONGSIZE,
	// D3D11_MESSAGE_ID_NEGOTIATEAUTHENTICATEDCHANNELKEYEXCHANGE_INVALIDCHANNEL,
	// D3D11_MESSAGE_ID_NEGOTIATEAUTHENTICATEDCHANNELKEYEXCHANGE_NULLPARAM, D3D11_MESSAGE_ID_QUERYAUTHENTICATEDCHANNEL_NULLPARAM,
	// D3D11_MESSAGE_ID_QUERYAUTHENTICATEDCHANNEL_WRONGCHANNEL, D3D11_MESSAGE_ID_QUERYAUTHENTICATEDCHANNEL_UNSUPPORTEDQUERY,
	// D3D11_MESSAGE_ID_QUERYAUTHENTICATEDCHANNEL_WRONGSIZE, D3D11_MESSAGE_ID_QUERYAUTHENTICATEDCHANNEL_INVALIDPROCESSINDEX,
	// D3D11_MESSAGE_ID_CONFIGUREAUTHENTICATEDCHANNEL_NULLPARAM, D3D11_MESSAGE_ID_CONFIGUREAUTHENTICATEDCHANNEL_WRONGCHANNEL,
	// D3D11_MESSAGE_ID_CONFIGUREAUTHENTICATEDCHANNEL_UNSUPPORTEDCONFIGURE, D3D11_MESSAGE_ID_CONFIGUREAUTHENTICATEDCHANNEL_WRONGSIZE,
	// D3D11_MESSAGE_ID_CONFIGUREAUTHENTICATEDCHANNEL_INVALIDPROCESSIDTYPE,
	// D3D11_MESSAGE_ID_VSSETCONSTANTBUFFERS_INVALIDBUFFEROFFSETORCOUNT, D3D11_MESSAGE_ID_DSSETCONSTANTBUFFERS_INVALIDBUFFEROFFSETORCOUNT,
	// D3D11_MESSAGE_ID_HSSETCONSTANTBUFFERS_INVALIDBUFFEROFFSETORCOUNT, D3D11_MESSAGE_ID_GSSETCONSTANTBUFFERS_INVALIDBUFFEROFFSETORCOUNT,
	// D3D11_MESSAGE_ID_PSSETCONSTANTBUFFERS_INVALIDBUFFEROFFSETORCOUNT, D3D11_MESSAGE_ID_CSSETCONSTANTBUFFERS_INVALIDBUFFEROFFSETORCOUNT,
	// D3D11_MESSAGE_ID_NEGOTIATECRPYTOSESSIONKEYEXCHANGE_INVALIDSIZE,
	// D3D11_MESSAGE_ID_NEGOTIATEAUTHENTICATEDCHANNELKEYEXCHANGE_INVALIDSIZE, D3D11_MESSAGE_ID_OFFERRESOURCES_INVALIDPRIORITY,
	// D3D11_MESSAGE_ID_GETCRYPTOSESSIONHANDLE_OUTOFMEMORY, D3D11_MESSAGE_ID_ACQUIREHANDLEFORCAPTURE_NULLPARAM,
	// D3D11_MESSAGE_ID_ACQUIREHANDLEFORCAPTURE_INVALIDTYPE, D3D11_MESSAGE_ID_ACQUIREHANDLEFORCAPTURE_INVALIDBIND,
	// D3D11_MESSAGE_ID_ACQUIREHANDLEFORCAPTURE_INVALIDARRAY, D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMROTATION_NULLPARAM,
	// D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMROTATION_INVALIDSTREAM, D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMROTATION_INVALID,
	// D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMROTATION_UNSUPPORTED, D3D11_MESSAGE_ID_VIDEOPROCESSORGETSTREAMROTATION_NULLPARAM,
	// D3D11_MESSAGE_ID_DEVICE_CLEARVIEW_INVALIDVIEW, D3D11_MESSAGE_ID_DEVICE_CREATEVERTEXSHADER_DOUBLEEXTENSIONSNOTSUPPORTED,
	// D3D11_MESSAGE_ID_DEVICE_CREATEVERTEXSHADER_SHADEREXTENSIONSNOTSUPPORTED,
	// D3D11_MESSAGE_ID_DEVICE_CREATEHULLSHADER_DOUBLEEXTENSIONSNOTSUPPORTED,
	// D3D11_MESSAGE_ID_DEVICE_CREATEHULLSHADER_SHADEREXTENSIONSNOTSUPPORTED,
	// D3D11_MESSAGE_ID_DEVICE_CREATEDOMAINSHADER_DOUBLEEXTENSIONSNOTSUPPORTED,
	// D3D11_MESSAGE_ID_DEVICE_CREATEDOMAINSHADER_SHADEREXTENSIONSNOTSUPPORTED,
	// D3D11_MESSAGE_ID_DEVICE_CREATEGEOMETRYSHADER_DOUBLEEXTENSIONSNOTSUPPORTED,
	// D3D11_MESSAGE_ID_DEVICE_CREATEGEOMETRYSHADER_SHADEREXTENSIONSNOTSUPPORTED,
	// D3D11_MESSAGE_ID_DEVICE_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_DOUBLEEXTENSIONSNOTSUPPORTED,
	// D3D11_MESSAGE_ID_DEVICE_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_SHADEREXTENSIONSNOTSUPPORTED,
	// D3D11_MESSAGE_ID_DEVICE_CREATEPIXELSHADER_DOUBLEEXTENSIONSNOTSUPPORTED,
	// D3D11_MESSAGE_ID_DEVICE_CREATEPIXELSHADER_SHADEREXTENSIONSNOTSUPPORTED,
	// D3D11_MESSAGE_ID_DEVICE_CREATECOMPUTESHADER_DOUBLEEXTENSIONSNOTSUPPORTED,
	// D3D11_MESSAGE_ID_DEVICE_CREATECOMPUTESHADER_SHADEREXTENSIONSNOTSUPPORTED, D3D11_MESSAGE_ID_DEVICE_SHADER_LINKAGE_MINPRECISION,
	// D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMALPHA_UNSUPPORTED, D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMPIXELASPECTRATIO_UNSUPPORTED,
	// D3D11_MESSAGE_ID_DEVICE_CREATEVERTEXSHADER_UAVSNOTSUPPORTED, D3D11_MESSAGE_ID_DEVICE_CREATEHULLSHADER_UAVSNOTSUPPORTED,
	// D3D11_MESSAGE_ID_DEVICE_CREATEDOMAINSHADER_UAVSNOTSUPPORTED, D3D11_MESSAGE_ID_DEVICE_CREATEGEOMETRYSHADER_UAVSNOTSUPPORTED,
	// D3D11_MESSAGE_ID_DEVICE_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_UAVSNOTSUPPORTED,
	// D3D11_MESSAGE_ID_DEVICE_CREATEPIXELSHADER_UAVSNOTSUPPORTED, D3D11_MESSAGE_ID_DEVICE_CREATECOMPUTESHADER_UAVSNOTSUPPORTED,
	// D3D11_MESSAGE_ID_DEVICE_OMSETRENDERTARGETSANDUNORDEREDACCESSVIEWS_INVALIDOFFSET,
	// D3D11_MESSAGE_ID_DEVICE_OMSETRENDERTARGETSANDUNORDEREDACCESSVIEWS_TOOMANYVIEWS, D3D11_MESSAGE_ID_DEVICE_CLEARVIEW_NOTSUPPORTED,
	// D3D11_MESSAGE_ID_SWAPDEVICECONTEXTSTATE_NOTSUPPORTED, D3D11_MESSAGE_ID_UPDATESUBRESOURCE_PREFERUPDATESUBRESOURCE1,
	// D3D11_MESSAGE_ID_GETDC_INACCESSIBLE, D3D11_MESSAGE_ID_DEVICE_CLEARVIEW_INVALIDRECT,
	// D3D11_MESSAGE_ID_DEVICE_DRAW_SAMPLE_MASK_IGNORED_ON_FL9, D3D11_MESSAGE_ID_DEVICE_OPEN_SHARED_RESOURCE1_NOT_SUPPORTED,
	// D3D11_MESSAGE_ID_DEVICE_OPEN_SHARED_RESOURCE_BY_NAME_NOT_SUPPORTED, D3D11_MESSAGE_ID_ENQUEUESETEVENT_NOT_SUPPORTED,
	// D3D11_MESSAGE_ID_OFFERRELEASE_NOT_SUPPORTED, D3D11_MESSAGE_ID_OFFERRESOURCES_INACCESSIBLE,
	// D3D11_MESSAGE_ID_CREATEVIDEOPROCESSORINPUTVIEW_INVALIDMSAA, D3D11_MESSAGE_ID_CREATEVIDEOPROCESSOROUTPUTVIEW_INVALIDMSAA,
	// D3D11_MESSAGE_ID_DEVICE_CLEARVIEW_INVALIDSOURCERECT, D3D11_MESSAGE_ID_DEVICE_CLEARVIEW_EMPTYRECT,
	// D3D11_MESSAGE_ID_UPDATESUBRESOURCE_EMPTYDESTBOX, D3D11_MESSAGE_ID_COPYSUBRESOURCEREGION_EMPTYSOURCEBOX,
	// D3D11_MESSAGE_ID_DEVICE_DRAW_OM_RENDER_TARGET_DOES_NOT_SUPPORT_LOGIC_OPS, D3D11_MESSAGE_ID_DEVICE_DRAW_DEPTHSTENCILVIEW_NOT_SET,
	// D3D11_MESSAGE_ID_DEVICE_DRAW_RENDERTARGETVIEW_NOT_SET, D3D11_MESSAGE_ID_DEVICE_DRAW_RENDERTARGETVIEW_NOT_SET_DUE_TO_FLIP_PRESENT,
	// D3D11_MESSAGE_ID_DEVICE_UNORDEREDACCESSVIEW_NOT_SET_DUE_TO_FLIP_PRESENT, D3D11_MESSAGE_ID_GETDATAFORNEWHARDWAREKEY_NULLPARAM,
	// D3D11_MESSAGE_ID_CHECKCRYPTOSESSIONSTATUS_NULLPARAM, D3D11_MESSAGE_ID_GETCRYPTOSESSIONPRIVATEDATASIZE_NULLPARAM,
	// D3D11_MESSAGE_ID_GETVIDEODECODERCAPS_NULLPARAM, D3D11_MESSAGE_ID_GETVIDEODECODERCAPS_ZEROWIDTHHEIGHT,
	// D3D11_MESSAGE_ID_CHECKVIDEODECODERDOWNSAMPLING_NULLPARAM, D3D11_MESSAGE_ID_CHECKVIDEODECODERDOWNSAMPLING_INVALIDCOLORSPACE,
	// D3D11_MESSAGE_ID_CHECKVIDEODECODERDOWNSAMPLING_ZEROWIDTHHEIGHT, D3D11_MESSAGE_ID_VIDEODECODERENABLEDOWNSAMPLING_NULLPARAM,
	// D3D11_MESSAGE_ID_VIDEODECODERENABLEDOWNSAMPLING_UNSUPPORTED, D3D11_MESSAGE_ID_VIDEODECODERUPDATEDOWNSAMPLING_NULLPARAM,
	// D3D11_MESSAGE_ID_VIDEODECODERUPDATEDOWNSAMPLING_UNSUPPORTED, D3D11_MESSAGE_ID_CHECKVIDEOPROCESSORFORMATCONVERSION_NULLPARAM,
	// D3D11_MESSAGE_ID_VIDEOPROCESSORSETOUTPUTCOLORSPACE1_NULLPARAM, D3D11_MESSAGE_ID_VIDEOPROCESSORGETOUTPUTCOLORSPACE1_NULLPARAM,
	// D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMCOLORSPACE1_NULLPARAM, D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMCOLORSPACE1_INVALIDSTREAM,
	// D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMMIRROR_NULLPARAM, D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMMIRROR_INVALIDSTREAM,
	// D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMMIRROR_UNSUPPORTED, D3D11_MESSAGE_ID_VIDEOPROCESSORGETSTREAMCOLORSPACE1_NULLPARAM,
	// D3D11_MESSAGE_ID_VIDEOPROCESSORGETSTREAMMIRROR_NULLPARAM, D3D11_MESSAGE_ID_RECOMMENDVIDEODECODERDOWNSAMPLING_NULLPARAM,
	// D3D11_MESSAGE_ID_RECOMMENDVIDEODECODERDOWNSAMPLING_INVALIDCOLORSPACE,
	// D3D11_MESSAGE_ID_RECOMMENDVIDEODECODERDOWNSAMPLING_ZEROWIDTHHEIGHT, D3D11_MESSAGE_ID_VIDEOPROCESSORSETOUTPUTSHADERUSAGE_NULLPARAM,
	// D3D11_MESSAGE_ID_VIDEOPROCESSORGETOUTPUTSHADERUSAGE_NULLPARAM, D3D11_MESSAGE_ID_VIDEOPROCESSORGETBEHAVIORHINTS_NULLPARAM,
	// D3D11_MESSAGE_ID_VIDEOPROCESSORGETBEHAVIORHINTS_INVALIDSTREAMCOUNT, D3D11_MESSAGE_ID_VIDEOPROCESSORGETBEHAVIORHINTS_TARGETRECT,
	// D3D11_MESSAGE_ID_VIDEOPROCESSORGETBEHAVIORHINTS_INVALIDSOURCERECT, D3D11_MESSAGE_ID_VIDEOPROCESSORGETBEHAVIORHINTS_INVALIDDESTRECT,
	// D3D11_MESSAGE_ID_GETCRYPTOSESSIONPRIVATEDATASIZE_INVALID_KEY_EXCHANGE_TYPE,
	// D3D11_MESSAGE_ID_DEVICE_OPEN_SHARED_RESOURCE1_ACCESS_DENIED, D3D11_MESSAGE_ID_D3D11_1_MESSAGES_END,
	// D3D11_MESSAGE_ID_D3D11_2_MESSAGES_START, D3D11_MESSAGE_ID_CREATEBUFFER_INVALIDUSAGE, D3D11_MESSAGE_ID_CREATETEXTURE1D_INVALIDUSAGE,
	// D3D11_MESSAGE_ID_CREATETEXTURE2D_INVALIDUSAGE, D3D11_MESSAGE_ID_CREATEINPUTLAYOUT_LEVEL9_STEPRATE_NOT_1,
	// D3D11_MESSAGE_ID_CREATEINPUTLAYOUT_LEVEL9_INSTANCING_NOT_SUPPORTED, D3D11_MESSAGE_ID_UPDATETILEMAPPINGS_INVALID_PARAMETER,
	// D3D11_MESSAGE_ID_COPYTILEMAPPINGS_INVALID_PARAMETER, D3D11_MESSAGE_ID_COPYTILES_INVALID_PARAMETER,
	// D3D11_MESSAGE_ID_UPDATETILES_INVALID_PARAMETER, D3D11_MESSAGE_ID_RESIZETILEPOOL_INVALID_PARAMETER,
	// D3D11_MESSAGE_ID_TILEDRESOURCEBARRIER_INVALID_PARAMETER, D3D11_MESSAGE_ID_NULL_TILE_MAPPING_ACCESS_WARNING,
	// D3D11_MESSAGE_ID_NULL_TILE_MAPPING_ACCESS_ERROR, D3D11_MESSAGE_ID_DIRTY_TILE_MAPPING_ACCESS,
	// D3D11_MESSAGE_ID_DUPLICATE_TILE_MAPPINGS_IN_COVERED_AREA, D3D11_MESSAGE_ID_TILE_MAPPINGS_IN_COVERED_AREA_DUPLICATED_OUTSIDE,
	// D3D11_MESSAGE_ID_TILE_MAPPINGS_SHARED_BETWEEN_INCOMPATIBLE_RESOURCES, D3D11_MESSAGE_ID_TILE_MAPPINGS_SHARED_BETWEEN_INPUT_AND_OUTPUT,
	// D3D11_MESSAGE_ID_CHECKMULTISAMPLEQUALITYLEVELS_INVALIDFLAGS, D3D11_MESSAGE_ID_GETRESOURCETILING_NONTILED_RESOURCE,
	// D3D11_MESSAGE_ID_RESIZETILEPOOL_SHRINK_WITH_MAPPINGS_STILL_DEFINED_PAST_END, D3D11_MESSAGE_ID_NEED_TO_CALL_TILEDRESOURCEBARRIER,
	// D3D11_MESSAGE_ID_CREATEDEVICE_INVALIDARGS, D3D11_MESSAGE_ID_CREATEDEVICE_WARNING,
	// D3D11_MESSAGE_ID_CLEARUNORDEREDACCESSVIEWUINT_HAZARD, D3D11_MESSAGE_ID_CLEARUNORDEREDACCESSVIEWFLOAT_HAZARD,
	// D3D11_MESSAGE_ID_TILED_RESOURCE_TIER_1_BUFFER_TEXTURE_MISMATCH, D3D11_MESSAGE_ID_CREATE_CRYPTOSESSION,
	// D3D11_MESSAGE_ID_CREATE_AUTHENTICATEDCHANNEL, D3D11_MESSAGE_ID_LIVE_CRYPTOSESSION, D3D11_MESSAGE_ID_LIVE_AUTHENTICATEDCHANNEL,
	// D3D11_MESSAGE_ID_DESTROY_CRYPTOSESSION, D3D11_MESSAGE_ID_DESTROY_AUTHENTICATEDCHANNEL, D3D11_MESSAGE_ID_D3D11_2_MESSAGES_END,
	// D3D11_MESSAGE_ID_D3D11_3_MESSAGES_START, D3D11_MESSAGE_ID_CREATERASTERIZERSTATE_INVALID_CONSERVATIVERASTERMODE,
	// D3D11_MESSAGE_ID_DEVICE_DRAW_INVALID_SYSTEMVALUE, D3D11_MESSAGE_ID_CREATEQUERYORPREDICATE_INVALIDCONTEXTTYPE,
	// D3D11_MESSAGE_ID_CREATEQUERYORPREDICATE_DECODENOTSUPPORTED, D3D11_MESSAGE_ID_CREATEQUERYORPREDICATE_ENCODENOTSUPPORTED,
	// D3D11_MESSAGE_ID_CREATESHADERRESOURCEVIEW_INVALIDPLANEINDEX, D3D11_MESSAGE_ID_CREATESHADERRESOURCEVIEW_INVALIDVIDEOPLANEINDEX,
	// D3D11_MESSAGE_ID_CREATESHADERRESOURCEVIEW_AMBIGUOUSVIDEOPLANEINDEX, D3D11_MESSAGE_ID_CREATERENDERTARGETVIEW_INVALIDPLANEINDEX,
	// D3D11_MESSAGE_ID_CREATERENDERTARGETVIEW_INVALIDVIDEOPLANEINDEX, D3D11_MESSAGE_ID_CREATERENDERTARGETVIEW_AMBIGUOUSVIDEOPLANEINDEX,
	// D3D11_MESSAGE_ID_CREATEUNORDEREDACCESSVIEW_INVALIDPLANEINDEX, D3D11_MESSAGE_ID_CREATEUNORDEREDACCESSVIEW_INVALIDVIDEOPLANEINDEX,
	// D3D11_MESSAGE_ID_CREATEUNORDEREDACCESSVIEW_AMBIGUOUSVIDEOPLANEINDEX, D3D11_MESSAGE_ID_JPEGDECODE_INVALIDSCANDATAOFFSET,
	// D3D11_MESSAGE_ID_JPEGDECODE_NOTSUPPORTED, D3D11_MESSAGE_ID_JPEGDECODE_DIMENSIONSTOOLARGE,
	// D3D11_MESSAGE_ID_JPEGDECODE_INVALIDCOMPONENTS, D3D11_MESSAGE_ID_JPEGDECODE_DESTINATIONNOT2D,
	// D3D11_MESSAGE_ID_JPEGDECODE_TILEDRESOURCESUNSUPPORTED, D3D11_MESSAGE_ID_JPEGDECODE_GUARDRECTSUNSUPPORTED,
	// D3D11_MESSAGE_ID_JPEGDECODE_FORMATUNSUPPORTED, D3D11_MESSAGE_ID_JPEGDECODE_INVALIDSUBRESOURCE,
	// D3D11_MESSAGE_ID_JPEGDECODE_INVALIDMIPLEVEL, D3D11_MESSAGE_ID_JPEGDECODE_EMPTYDESTBOX, D3D11_MESSAGE_ID_JPEGDECODE_DESTBOXNOT2D,
	// D3D11_MESSAGE_ID_JPEGDECODE_DESTBOXNOTSUB, D3D11_MESSAGE_ID_JPEGDECODE_DESTBOXESINTERSECT,
	// D3D11_MESSAGE_ID_JPEGDECODE_XSUBSAMPLEMISMATCH, D3D11_MESSAGE_ID_JPEGDECODE_YSUBSAMPLEMISMATCH,
	// D3D11_MESSAGE_ID_JPEGDECODE_XSUBSAMPLEODD, D3D11_MESSAGE_ID_JPEGDECODE_YSUBSAMPLEODD,
	// D3D11_MESSAGE_ID_JPEGDECODE_OUTPUTDIMENSIONSTOOLARGE, D3D11_MESSAGE_ID_JPEGDECODE_NONPOW2SCALEUNSUPPORTED,
	// D3D11_MESSAGE_ID_JPEGDECODE_FRACTIONALDOWNSCALETOLARGE, D3D11_MESSAGE_ID_JPEGDECODE_CHROMASIZEMISMATCH,
	// D3D11_MESSAGE_ID_JPEGDECODE_LUMACHROMASIZEMISMATCH, D3D11_MESSAGE_ID_JPEGDECODE_INVALIDNUMDESTINATIONS,
	// D3D11_MESSAGE_ID_JPEGDECODE_SUBBOXUNSUPPORTED, D3D11_MESSAGE_ID_JPEGDECODE_1DESTUNSUPPORTEDFORMAT,
	// D3D11_MESSAGE_ID_JPEGDECODE_3DESTUNSUPPORTEDFORMAT, D3D11_MESSAGE_ID_JPEGDECODE_SCALEUNSUPPORTED,
	// D3D11_MESSAGE_ID_JPEGDECODE_INVALIDSOURCESIZE, D3D11_MESSAGE_ID_JPEGDECODE_INVALIDCOPYFLAGS, D3D11_MESSAGE_ID_JPEGDECODE_HAZARD,
	// D3D11_MESSAGE_ID_JPEGDECODE_UNSUPPORTEDSRCBUFFERUSAGE, D3D11_MESSAGE_ID_JPEGDECODE_UNSUPPORTEDSRCBUFFERMISCFLAGS,
	// D3D11_MESSAGE_ID_JPEGDECODE_UNSUPPORTEDDSTTEXTUREUSAGE, D3D11_MESSAGE_ID_JPEGDECODE_BACKBUFFERNOTSUPPORTED,
	// D3D11_MESSAGE_ID_JPEGDECODE_UNSUPPRTEDCOPYFLAGS, D3D11_MESSAGE_ID_JPEGENCODE_NOTSUPPORTED,
	// D3D11_MESSAGE_ID_JPEGENCODE_INVALIDSCANDATAOFFSET, D3D11_MESSAGE_ID_JPEGENCODE_INVALIDCOMPONENTS,
	// D3D11_MESSAGE_ID_JPEGENCODE_SOURCENOT2D, D3D11_MESSAGE_ID_JPEGENCODE_TILEDRESOURCESUNSUPPORTED,
	// D3D11_MESSAGE_ID_JPEGENCODE_GUARDRECTSUNSUPPORTED, D3D11_MESSAGE_ID_JPEGENCODE_XSUBSAMPLEMISMATCH,
	// D3D11_MESSAGE_ID_JPEGENCODE_YSUBSAMPLEMISMATCH, D3D11_MESSAGE_ID_JPEGENCODE_FORMATUNSUPPORTED,
	// D3D11_MESSAGE_ID_JPEGENCODE_INVALIDSUBRESOURCE, D3D11_MESSAGE_ID_JPEGENCODE_INVALIDMIPLEVEL,
	// D3D11_MESSAGE_ID_JPEGENCODE_DIMENSIONSTOOLARGE, D3D11_MESSAGE_ID_JPEGENCODE_HAZARD,
	// D3D11_MESSAGE_ID_JPEGENCODE_UNSUPPORTEDDSTBUFFERUSAGE, D3D11_MESSAGE_ID_JPEGENCODE_UNSUPPORTEDDSTBUFFERMISCFLAGS,
	// D3D11_MESSAGE_ID_JPEGENCODE_UNSUPPORTEDSRCTEXTUREUSAGE, D3D11_MESSAGE_ID_JPEGENCODE_BACKBUFFERNOTSUPPORTED,
	// D3D11_MESSAGE_ID_CREATEQUERYORPREDICATE_UNSUPPORTEDCONTEXTTTYPEFORQUERY, D3D11_MESSAGE_ID_FLUSH1_INVALIDCONTEXTTYPE,
	// D3D11_MESSAGE_ID_DEVICE_SETHARDWAREPROTECTION_INVALIDCONTEXT, D3D11_MESSAGE_ID_VIDEOPROCESSORSETOUTPUTHDRMETADATA_NULLPARAM,
	// D3D11_MESSAGE_ID_VIDEOPROCESSORSETOUTPUTHDRMETADATA_INVALIDSIZE, D3D11_MESSAGE_ID_VIDEOPROCESSORGETOUTPUTHDRMETADATA_NULLPARAM,
	// D3D11_MESSAGE_ID_VIDEOPROCESSORGETOUTPUTHDRMETADATA_INVALIDSIZE, D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMHDRMETADATA_NULLPARAM,
	// D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMHDRMETADATA_INVALIDSTREAM, D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMHDRMETADATA_INVALIDSIZE,
	// D3D11_MESSAGE_ID_VIDEOPROCESSORGETSTREAMHDRMETADATA_NULLPARAM, D3D11_MESSAGE_ID_VIDEOPROCESSORGETSTREAMHDRMETADATA_INVALIDSTREAM,
	// D3D11_MESSAGE_ID_VIDEOPROCESSORGETSTREAMHDRMETADATA_INVALIDSIZE, D3D11_MESSAGE_ID_VIDEOPROCESSORGETSTREAMFRAMEFORMAT_INVALIDSTREAM,
	// D3D11_MESSAGE_ID_VIDEOPROCESSORGETSTREAMCOLORSPACE_INVALIDSTREAM, D3D11_MESSAGE_ID_VIDEOPROCESSORGETSTREAMOUTPUTRATE_INVALIDSTREAM,
	// D3D11_MESSAGE_ID_VIDEOPROCESSORGETSTREAMSOURCERECT_INVALIDSTREAM, D3D11_MESSAGE_ID_VIDEOPROCESSORGETSTREAMDESTRECT_INVALIDSTREAM,
	// D3D11_MESSAGE_ID_VIDEOPROCESSORGETSTREAMALPHA_INVALIDSTREAM, D3D11_MESSAGE_ID_VIDEOPROCESSORGETSTREAMPALETTE_INVALIDSTREAM,
	// D3D11_MESSAGE_ID_VIDEOPROCESSORGETSTREAMPIXELASPECTRATIO_INVALIDSTREAM,
	// D3D11_MESSAGE_ID_VIDEOPROCESSORGETSTREAMLUMAKEY_INVALIDSTREAM, D3D11_MESSAGE_ID_VIDEOPROCESSORGETSTREAMSTEREOFORMAT_INVALIDSTREAM,
	// D3D11_MESSAGE_ID_VIDEOPROCESSORGETSTREAMAUTOPROCESSINGMODE_INVALIDSTREAM,
	// D3D11_MESSAGE_ID_VIDEOPROCESSORGETSTREAMFILTER_INVALIDSTREAM, D3D11_MESSAGE_ID_VIDEOPROCESSORGETSTREAMROTATION_INVALIDSTREAM,
	// D3D11_MESSAGE_ID_VIDEOPROCESSORGETSTREAMCOLORSPACE1_INVALIDSTREAM, D3D11_MESSAGE_ID_VIDEOPROCESSORGETSTREAMMIRROR_INVALIDSTREAM,
	// D3D11_MESSAGE_ID_CREATE_FENCE, D3D11_MESSAGE_ID_LIVE_FENCE, D3D11_MESSAGE_ID_DESTROY_FENCE,
	// D3D11_MESSAGE_ID_CREATE_SYNCHRONIZEDCHANNEL, D3D11_MESSAGE_ID_LIVE_SYNCHRONIZEDCHANNEL, D3D11_MESSAGE_ID_DESTROY_SYNCHRONIZEDCHANNEL,
	// D3D11_MESSAGE_ID_CREATEFENCE_INVALIDFLAGS, D3D11_MESSAGE_ID_D3D11_3_MESSAGES_END, D3D11_MESSAGE_ID_D3D11_5_MESSAGES_START,
	// D3D11_MESSAGE_ID_NEGOTIATECRYPTOSESSIONKEYEXCHANGEMT_INVALIDKEYEXCHANGETYPE,
	// D3D11_MESSAGE_ID_NEGOTIATECRYPTOSESSIONKEYEXCHANGEMT_NOT_SUPPORTED,
	// D3D11_MESSAGE_ID_DECODERBEGINFRAME_INVALID_HISTOGRAM_COMPONENT_COUNT, D3D11_MESSAGE_ID_DECODERBEGINFRAME_INVALID_HISTOGRAM_COMPONENT,
	// D3D11_MESSAGE_ID_DECODERBEGINFRAME_INVALID_HISTOGRAM_BUFFER_SIZE, D3D11_MESSAGE_ID_DECODERBEGINFRAME_INVALID_HISTOGRAM_BUFFER_USAGE,
	// D3D11_MESSAGE_ID_DECODERBEGINFRAME_INVALID_HISTOGRAM_BUFFER_MISC_FLAGS,
	// D3D11_MESSAGE_ID_DECODERBEGINFRAME_INVALID_HISTOGRAM_BUFFER_OFFSET, D3D11_MESSAGE_ID_CREATE_TRACKEDWORKLOAD,
	// D3D11_MESSAGE_ID_LIVE_TRACKEDWORKLOAD, D3D11_MESSAGE_ID_DESTROY_TRACKEDWORKLOAD, D3D11_MESSAGE_ID_CREATE_TRACKED_WORKLOAD_NULLPARAM,
	// D3D11_MESSAGE_ID_CREATE_TRACKED_WORKLOAD_INVALID_MAX_INSTANCES, D3D11_MESSAGE_ID_CREATE_TRACKED_WORKLOAD_INVALID_DEADLINE_TYPE,
	// D3D11_MESSAGE_ID_CREATE_TRACKED_WORKLOAD_INVALID_ENGINE_TYPE, D3D11_MESSAGE_ID_MULTIPLE_TRACKED_WORKLOADS,
	// D3D11_MESSAGE_ID_MULTIPLE_TRACKED_WORKLOAD_PAIRS, D3D11_MESSAGE_ID_INCOMPLETE_TRACKED_WORKLOAD_PAIR,
	// D3D11_MESSAGE_ID_OUT_OF_ORDER_TRACKED_WORKLOAD_PAIR, D3D11_MESSAGE_ID_CANNOT_ADD_TRACKED_WORKLOAD,
	// D3D11_MESSAGE_ID_TRACKED_WORKLOAD_NOT_SUPPORTED, D3D11_MESSAGE_ID_TRACKED_WORKLOAD_ENGINE_TYPE_NOT_FOUND,
	// D3D11_MESSAGE_ID_NO_TRACKED_WORKLOAD_SLOT_AVAILABLE, D3D11_MESSAGE_ID_END_TRACKED_WORKLOAD_INVALID_ARG,
	// D3D11_MESSAGE_ID_TRACKED_WORKLOAD_DISJOINT_FAILURE, D3D11_MESSAGE_ID_DEVICE_DRAW_RESOURCE_FORMAT_AND_WRITE_MASK_MISMATCH,
	// D3D11_MESSAGE_ID_D3D11_5_MESSAGES_END } ;
	[PInvokeData("d3d11sdklayers.h", MSDNShortId = "NE:d3d11sdklayers.D3D11_MESSAGE_ID")]
	public enum D3D11_MESSAGE_ID
	{
		/// <summary>
		/// <para>Value:</para>
		/// <para>0</para>
		/// </summary>
		D3D11_MESSAGE_ID_UNKNOWN = 0,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_IASETVERTEXBUFFERS_HAZARD,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_IASETINDEXBUFFER_HAZARD,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_VSSETSHADERRESOURCES_HAZARD,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_VSSETCONSTANTBUFFERS_HAZARD,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_GSSETSHADERRESOURCES_HAZARD,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_GSSETCONSTANTBUFFERS_HAZARD,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_PSSETSHADERRESOURCES_HAZARD,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_PSSETCONSTANTBUFFERS_HAZARD,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_OMSETRENDERTARGETS_HAZARD,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_SOSETTARGETS_HAZARD,

		/// <summary/>
		D3D11_MESSAGE_ID_STRING_FROM_APPLICATION,

		/// <summary/>
		D3D11_MESSAGE_ID_CORRUPTED_THIS,

		/// <summary/>
		D3D11_MESSAGE_ID_CORRUPTED_PARAMETER1,

		/// <summary/>
		D3D11_MESSAGE_ID_CORRUPTED_PARAMETER2,

		/// <summary/>
		D3D11_MESSAGE_ID_CORRUPTED_PARAMETER3,

		/// <summary/>
		D3D11_MESSAGE_ID_CORRUPTED_PARAMETER4,

		/// <summary/>
		D3D11_MESSAGE_ID_CORRUPTED_PARAMETER5,

		/// <summary/>
		D3D11_MESSAGE_ID_CORRUPTED_PARAMETER6,

		/// <summary/>
		D3D11_MESSAGE_ID_CORRUPTED_PARAMETER7,

		/// <summary/>
		D3D11_MESSAGE_ID_CORRUPTED_PARAMETER8,

		/// <summary/>
		D3D11_MESSAGE_ID_CORRUPTED_PARAMETER9,

		/// <summary/>
		D3D11_MESSAGE_ID_CORRUPTED_PARAMETER10,

		/// <summary/>
		D3D11_MESSAGE_ID_CORRUPTED_PARAMETER11,

		/// <summary/>
		D3D11_MESSAGE_ID_CORRUPTED_PARAMETER12,

		/// <summary/>
		D3D11_MESSAGE_ID_CORRUPTED_PARAMETER13,

		/// <summary/>
		D3D11_MESSAGE_ID_CORRUPTED_PARAMETER14,

		/// <summary/>
		D3D11_MESSAGE_ID_CORRUPTED_PARAMETER15,

		/// <summary/>
		D3D11_MESSAGE_ID_CORRUPTED_MULTITHREADING,

		/// <summary/>
		D3D11_MESSAGE_ID_MESSAGE_REPORTING_OUTOFMEMORY,

		/// <summary/>
		D3D11_MESSAGE_ID_IASETINPUTLAYOUT_UNBINDDELETINGOBJECT,

		/// <summary/>
		D3D11_MESSAGE_ID_IASETVERTEXBUFFERS_UNBINDDELETINGOBJECT,

		/// <summary/>
		D3D11_MESSAGE_ID_IASETINDEXBUFFER_UNBINDDELETINGOBJECT,

		/// <summary/>
		D3D11_MESSAGE_ID_VSSETSHADER_UNBINDDELETINGOBJECT,

		/// <summary/>
		D3D11_MESSAGE_ID_VSSETSHADERRESOURCES_UNBINDDELETINGOBJECT,

		/// <summary/>
		D3D11_MESSAGE_ID_VSSETCONSTANTBUFFERS_UNBINDDELETINGOBJECT,

		/// <summary/>
		D3D11_MESSAGE_ID_VSSETSAMPLERS_UNBINDDELETINGOBJECT,

		/// <summary/>
		D3D11_MESSAGE_ID_GSSETSHADER_UNBINDDELETINGOBJECT,

		/// <summary/>
		D3D11_MESSAGE_ID_GSSETSHADERRESOURCES_UNBINDDELETINGOBJECT,

		/// <summary/>
		D3D11_MESSAGE_ID_GSSETCONSTANTBUFFERS_UNBINDDELETINGOBJECT,

		/// <summary/>
		D3D11_MESSAGE_ID_GSSETSAMPLERS_UNBINDDELETINGOBJECT,

		/// <summary/>
		D3D11_MESSAGE_ID_SOSETTARGETS_UNBINDDELETINGOBJECT,

		/// <summary/>
		D3D11_MESSAGE_ID_PSSETSHADER_UNBINDDELETINGOBJECT,

		/// <summary/>
		D3D11_MESSAGE_ID_PSSETSHADERRESOURCES_UNBINDDELETINGOBJECT,

		/// <summary/>
		D3D11_MESSAGE_ID_PSSETCONSTANTBUFFERS_UNBINDDELETINGOBJECT,

		/// <summary/>
		D3D11_MESSAGE_ID_PSSETSAMPLERS_UNBINDDELETINGOBJECT,

		/// <summary/>
		D3D11_MESSAGE_ID_RSSETSTATE_UNBINDDELETINGOBJECT,

		/// <summary/>
		D3D11_MESSAGE_ID_OMSETBLENDSTATE_UNBINDDELETINGOBJECT,

		/// <summary/>
		D3D11_MESSAGE_ID_OMSETDEPTHSTENCILSTATE_UNBINDDELETINGOBJECT,

		/// <summary/>
		D3D11_MESSAGE_ID_OMSETRENDERTARGETS_UNBINDDELETINGOBJECT,

		/// <summary/>
		D3D11_MESSAGE_ID_SETPREDICATION_UNBINDDELETINGOBJECT,

		/// <summary/>
		D3D11_MESSAGE_ID_GETPRIVATEDATA_MOREDATA,

		/// <summary/>
		D3D11_MESSAGE_ID_SETPRIVATEDATA_INVALIDFREEDATA,

		/// <summary/>
		D3D11_MESSAGE_ID_SETPRIVATEDATA_INVALIDIUNKNOWN,

		/// <summary/>
		D3D11_MESSAGE_ID_SETPRIVATEDATA_INVALIDFLAGS,

		/// <summary/>
		D3D11_MESSAGE_ID_SETPRIVATEDATA_CHANGINGPARAMS,

		/// <summary/>
		D3D11_MESSAGE_ID_SETPRIVATEDATA_OUTOFMEMORY,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEBUFFER_UNRECOGNIZEDFORMAT,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEBUFFER_INVALIDSAMPLES,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEBUFFER_UNRECOGNIZEDUSAGE,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEBUFFER_UNRECOGNIZEDBINDFLAGS,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEBUFFER_UNRECOGNIZEDCPUACCESSFLAGS,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEBUFFER_UNRECOGNIZEDMISCFLAGS,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEBUFFER_INVALIDCPUACCESSFLAGS,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEBUFFER_INVALIDBINDFLAGS,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEBUFFER_INVALIDINITIALDATA,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEBUFFER_INVALIDDIMENSIONS,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEBUFFER_INVALIDMIPLEVELS,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEBUFFER_INVALIDMISCFLAGS,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEBUFFER_INVALIDARG_RETURN,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEBUFFER_OUTOFMEMORY_RETURN,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEBUFFER_NULLDESC,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEBUFFER_INVALIDCONSTANTBUFFERBINDINGS,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEBUFFER_LARGEALLOCATION,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATETEXTURE1D_UNRECOGNIZEDFORMAT,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATETEXTURE1D_UNSUPPORTEDFORMAT,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATETEXTURE1D_INVALIDSAMPLES,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATETEXTURE1D_UNRECOGNIZEDUSAGE,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATETEXTURE1D_UNRECOGNIZEDBINDFLAGS,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATETEXTURE1D_UNRECOGNIZEDCPUACCESSFLAGS,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATETEXTURE1D_UNRECOGNIZEDMISCFLAGS,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATETEXTURE1D_INVALIDCPUACCESSFLAGS,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATETEXTURE1D_INVALIDBINDFLAGS,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATETEXTURE1D_INVALIDINITIALDATA,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATETEXTURE1D_INVALIDDIMENSIONS,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATETEXTURE1D_INVALIDMIPLEVELS,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATETEXTURE1D_INVALIDMISCFLAGS,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATETEXTURE1D_INVALIDARG_RETURN,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATETEXTURE1D_OUTOFMEMORY_RETURN,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATETEXTURE1D_NULLDESC,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATETEXTURE1D_LARGEALLOCATION,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATETEXTURE2D_UNRECOGNIZEDFORMAT,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATETEXTURE2D_UNSUPPORTEDFORMAT,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATETEXTURE2D_INVALIDSAMPLES,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATETEXTURE2D_UNRECOGNIZEDUSAGE,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATETEXTURE2D_UNRECOGNIZEDBINDFLAGS,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATETEXTURE2D_UNRECOGNIZEDCPUACCESSFLAGS,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATETEXTURE2D_UNRECOGNIZEDMISCFLAGS,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATETEXTURE2D_INVALIDCPUACCESSFLAGS,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATETEXTURE2D_INVALIDBINDFLAGS,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATETEXTURE2D_INVALIDINITIALDATA,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATETEXTURE2D_INVALIDDIMENSIONS,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATETEXTURE2D_INVALIDMIPLEVELS,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATETEXTURE2D_INVALIDMISCFLAGS,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATETEXTURE2D_INVALIDARG_RETURN,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATETEXTURE2D_OUTOFMEMORY_RETURN,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATETEXTURE2D_NULLDESC,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATETEXTURE2D_LARGEALLOCATION,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATETEXTURE3D_UNRECOGNIZEDFORMAT,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATETEXTURE3D_UNSUPPORTEDFORMAT,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATETEXTURE3D_INVALIDSAMPLES,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATETEXTURE3D_UNRECOGNIZEDUSAGE,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATETEXTURE3D_UNRECOGNIZEDBINDFLAGS,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATETEXTURE3D_UNRECOGNIZEDCPUACCESSFLAGS,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATETEXTURE3D_UNRECOGNIZEDMISCFLAGS,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATETEXTURE3D_INVALIDCPUACCESSFLAGS,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATETEXTURE3D_INVALIDBINDFLAGS,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATETEXTURE3D_INVALIDINITIALDATA,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATETEXTURE3D_INVALIDDIMENSIONS,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATETEXTURE3D_INVALIDMIPLEVELS,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATETEXTURE3D_INVALIDMISCFLAGS,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATETEXTURE3D_INVALIDARG_RETURN,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATETEXTURE3D_OUTOFMEMORY_RETURN,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATETEXTURE3D_NULLDESC,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATETEXTURE3D_LARGEALLOCATION,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATESHADERRESOURCEVIEW_UNRECOGNIZEDFORMAT,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATESHADERRESOURCEVIEW_INVALIDDESC,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATESHADERRESOURCEVIEW_INVALIDFORMAT,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATESHADERRESOURCEVIEW_INVALIDDIMENSIONS,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATESHADERRESOURCEVIEW_INVALIDRESOURCE,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATESHADERRESOURCEVIEW_TOOMANYOBJECTS,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATESHADERRESOURCEVIEW_INVALIDARG_RETURN,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATESHADERRESOURCEVIEW_OUTOFMEMORY_RETURN,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATERENDERTARGETVIEW_UNRECOGNIZEDFORMAT,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATERENDERTARGETVIEW_UNSUPPORTEDFORMAT,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATERENDERTARGETVIEW_INVALIDDESC,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATERENDERTARGETVIEW_INVALIDFORMAT,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATERENDERTARGETVIEW_INVALIDDIMENSIONS,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATERENDERTARGETVIEW_INVALIDRESOURCE,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATERENDERTARGETVIEW_TOOMANYOBJECTS,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATERENDERTARGETVIEW_INVALIDARG_RETURN,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATERENDERTARGETVIEW_OUTOFMEMORY_RETURN,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEDEPTHSTENCILVIEW_UNRECOGNIZEDFORMAT,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEDEPTHSTENCILVIEW_INVALIDDESC,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEDEPTHSTENCILVIEW_INVALIDFORMAT,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEDEPTHSTENCILVIEW_INVALIDDIMENSIONS,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEDEPTHSTENCILVIEW_INVALIDRESOURCE,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEDEPTHSTENCILVIEW_TOOMANYOBJECTS,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEDEPTHSTENCILVIEW_INVALIDARG_RETURN,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEDEPTHSTENCILVIEW_OUTOFMEMORY_RETURN,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEINPUTLAYOUT_OUTOFMEMORY,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEINPUTLAYOUT_TOOMANYELEMENTS,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEINPUTLAYOUT_INVALIDFORMAT,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEINPUTLAYOUT_INCOMPATIBLEFORMAT,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEINPUTLAYOUT_INVALIDSLOT,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEINPUTLAYOUT_INVALIDINPUTSLOTCLASS,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEINPUTLAYOUT_STEPRATESLOTCLASSMISMATCH,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEINPUTLAYOUT_INVALIDSLOTCLASSCHANGE,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEINPUTLAYOUT_INVALIDSTEPRATECHANGE,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEINPUTLAYOUT_INVALIDALIGNMENT,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEINPUTLAYOUT_DUPLICATESEMANTIC,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEINPUTLAYOUT_UNPARSEABLEINPUTSIGNATURE,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEINPUTLAYOUT_NULLSEMANTIC,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEINPUTLAYOUT_MISSINGELEMENT,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEINPUTLAYOUT_NULLDESC,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEVERTEXSHADER_OUTOFMEMORY,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEVERTEXSHADER_INVALIDSHADERBYTECODE,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEVERTEXSHADER_INVALIDSHADERTYPE,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEGEOMETRYSHADER_OUTOFMEMORY,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEGEOMETRYSHADER_INVALIDSHADERBYTECODE,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEGEOMETRYSHADER_INVALIDSHADERTYPE,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_OUTOFMEMORY,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDSHADERBYTECODE,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDSHADERTYPE,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDNUMENTRIES,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_OUTPUTSTREAMSTRIDEUNUSED,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_UNEXPECTEDDECL,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_EXPECTEDDECL,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_OUTPUTSLOT0EXPECTED,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDOUTPUTSLOT,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_ONLYONEELEMENTPERSLOT,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDCOMPONENTCOUNT,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDSTARTCOMPONENTANDCOMPONENTCOUNT,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDGAPDEFINITION,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_REPEATEDOUTPUT,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDOUTPUTSTREAMSTRIDE,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_MISSINGSEMANTIC,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_MASKMISMATCH,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_CANTHAVEONLYGAPS,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_DECLTOOCOMPLEX,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_MISSINGOUTPUTSIGNATURE,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEPIXELSHADER_OUTOFMEMORY,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEPIXELSHADER_INVALIDSHADERBYTECODE,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEPIXELSHADER_INVALIDSHADERTYPE,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATERASTERIZERSTATE_INVALIDFILLMODE,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATERASTERIZERSTATE_INVALIDCULLMODE,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATERASTERIZERSTATE_INVALIDDEPTHBIASCLAMP,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATERASTERIZERSTATE_INVALIDSLOPESCALEDDEPTHBIAS,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATERASTERIZERSTATE_TOOMANYOBJECTS,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATERASTERIZERSTATE_NULLDESC,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_INVALIDDEPTHWRITEMASK,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_INVALIDDEPTHFUNC,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_INVALIDFRONTFACESTENCILFAILOP,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_INVALIDFRONTFACESTENCILZFAILOP,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_INVALIDFRONTFACESTENCILPASSOP,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_INVALIDFRONTFACESTENCILFUNC,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_INVALIDBACKFACESTENCILFAILOP,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_INVALIDBACKFACESTENCILZFAILOP,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_INVALIDBACKFACESTENCILPASSOP,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_INVALIDBACKFACESTENCILFUNC,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_TOOMANYOBJECTS,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_NULLDESC,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEBLENDSTATE_INVALIDSRCBLEND,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEBLENDSTATE_INVALIDDESTBLEND,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEBLENDSTATE_INVALIDBLENDOP,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEBLENDSTATE_INVALIDSRCBLENDALPHA,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEBLENDSTATE_INVALIDDESTBLENDALPHA,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEBLENDSTATE_INVALIDBLENDOPALPHA,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEBLENDSTATE_INVALIDRENDERTARGETWRITEMASK,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEBLENDSTATE_TOOMANYOBJECTS,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEBLENDSTATE_NULLDESC,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATESAMPLERSTATE_INVALIDFILTER,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATESAMPLERSTATE_INVALIDADDRESSU,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATESAMPLERSTATE_INVALIDADDRESSV,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATESAMPLERSTATE_INVALIDADDRESSW,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATESAMPLERSTATE_INVALIDMIPLODBIAS,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATESAMPLERSTATE_INVALIDMAXANISOTROPY,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATESAMPLERSTATE_INVALIDCOMPARISONFUNC,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATESAMPLERSTATE_INVALIDMINLOD,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATESAMPLERSTATE_INVALIDMAXLOD,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATESAMPLERSTATE_TOOMANYOBJECTS,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATESAMPLERSTATE_NULLDESC,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEQUERYORPREDICATE_INVALIDQUERY,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEQUERYORPREDICATE_INVALIDMISCFLAGS,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEQUERYORPREDICATE_UNEXPECTEDMISCFLAG,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEQUERYORPREDICATE_NULLDESC,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_IASETPRIMITIVETOPOLOGY_TOPOLOGY_UNRECOGNIZED,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_IASETPRIMITIVETOPOLOGY_TOPOLOGY_UNDEFINED,

		/// <summary/>
		D3D11_MESSAGE_ID_IASETVERTEXBUFFERS_INVALIDBUFFER,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_IASETVERTEXBUFFERS_OFFSET_TOO_LARGE,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_IASETVERTEXBUFFERS_BUFFERS_EMPTY,

		/// <summary/>
		D3D11_MESSAGE_ID_IASETINDEXBUFFER_INVALIDBUFFER,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_IASETINDEXBUFFER_FORMAT_INVALID,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_IASETINDEXBUFFER_OFFSET_TOO_LARGE,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_IASETINDEXBUFFER_OFFSET_UNALIGNED,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_VSSETSHADERRESOURCES_VIEWS_EMPTY,

		/// <summary/>
		D3D11_MESSAGE_ID_VSSETCONSTANTBUFFERS_INVALIDBUFFER,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_VSSETCONSTANTBUFFERS_BUFFERS_EMPTY,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_VSSETSAMPLERS_SAMPLERS_EMPTY,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_GSSETSHADERRESOURCES_VIEWS_EMPTY,

		/// <summary/>
		D3D11_MESSAGE_ID_GSSETCONSTANTBUFFERS_INVALIDBUFFER,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_GSSETCONSTANTBUFFERS_BUFFERS_EMPTY,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_GSSETSAMPLERS_SAMPLERS_EMPTY,

		/// <summary/>
		D3D11_MESSAGE_ID_SOSETTARGETS_INVALIDBUFFER,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_SOSETTARGETS_OFFSET_UNALIGNED,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_PSSETSHADERRESOURCES_VIEWS_EMPTY,

		/// <summary/>
		D3D11_MESSAGE_ID_PSSETCONSTANTBUFFERS_INVALIDBUFFER,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_PSSETCONSTANTBUFFERS_BUFFERS_EMPTY,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_PSSETSAMPLERS_SAMPLERS_EMPTY,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_RSSETVIEWPORTS_INVALIDVIEWPORT,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_RSSETSCISSORRECTS_INVALIDSCISSOR,

		/// <summary/>
		D3D11_MESSAGE_ID_CLEARRENDERTARGETVIEW_DENORMFLUSH,

		/// <summary/>
		D3D11_MESSAGE_ID_CLEARDEPTHSTENCILVIEW_DENORMFLUSH,

		/// <summary/>
		D3D11_MESSAGE_ID_CLEARDEPTHSTENCILVIEW_INVALID,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_IAGETVERTEXBUFFERS_BUFFERS_EMPTY,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_VSGETSHADERRESOURCES_VIEWS_EMPTY,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_VSGETCONSTANTBUFFERS_BUFFERS_EMPTY,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_VSGETSAMPLERS_SAMPLERS_EMPTY,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_GSGETSHADERRESOURCES_VIEWS_EMPTY,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_GSGETCONSTANTBUFFERS_BUFFERS_EMPTY,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_GSGETSAMPLERS_SAMPLERS_EMPTY,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_SOGETTARGETS_BUFFERS_EMPTY,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_PSGETSHADERRESOURCES_VIEWS_EMPTY,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_PSGETCONSTANTBUFFERS_BUFFERS_EMPTY,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_PSGETSAMPLERS_SAMPLERS_EMPTY,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_RSGETVIEWPORTS_VIEWPORTS_EMPTY,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_RSGETSCISSORRECTS_RECTS_EMPTY,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_GENERATEMIPS_RESOURCE_INVALID,

		/// <summary/>
		D3D11_MESSAGE_ID_COPYSUBRESOURCEREGION_INVALIDDESTINATIONSUBRESOURCE,

		/// <summary/>
		D3D11_MESSAGE_ID_COPYSUBRESOURCEREGION_INVALIDSOURCESUBRESOURCE,

		/// <summary/>
		D3D11_MESSAGE_ID_COPYSUBRESOURCEREGION_INVALIDSOURCEBOX,

		/// <summary/>
		D3D11_MESSAGE_ID_COPYSUBRESOURCEREGION_INVALIDSOURCE,

		/// <summary/>
		D3D11_MESSAGE_ID_COPYSUBRESOURCEREGION_INVALIDDESTINATIONSTATE,

		/// <summary/>
		D3D11_MESSAGE_ID_COPYSUBRESOURCEREGION_INVALIDSOURCESTATE,

		/// <summary/>
		D3D11_MESSAGE_ID_COPYRESOURCE_INVALIDSOURCE,

		/// <summary/>
		D3D11_MESSAGE_ID_COPYRESOURCE_INVALIDDESTINATIONSTATE,

		/// <summary/>
		D3D11_MESSAGE_ID_COPYRESOURCE_INVALIDSOURCESTATE,

		/// <summary/>
		D3D11_MESSAGE_ID_UPDATESUBRESOURCE_INVALIDDESTINATIONSUBRESOURCE,

		/// <summary/>
		D3D11_MESSAGE_ID_UPDATESUBRESOURCE_INVALIDDESTINATIONBOX,

		/// <summary/>
		D3D11_MESSAGE_ID_UPDATESUBRESOURCE_INVALIDDESTINATIONSTATE,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_RESOLVESUBRESOURCE_DESTINATION_INVALID,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_RESOLVESUBRESOURCE_DESTINATION_SUBRESOURCE_INVALID,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_RESOLVESUBRESOURCE_SOURCE_INVALID,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_RESOLVESUBRESOURCE_SOURCE_SUBRESOURCE_INVALID,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_RESOLVESUBRESOURCE_FORMAT_INVALID,

		/// <summary/>
		D3D11_MESSAGE_ID_BUFFER_MAP_INVALIDMAPTYPE,

		/// <summary/>
		D3D11_MESSAGE_ID_BUFFER_MAP_INVALIDFLAGS,

		/// <summary/>
		D3D11_MESSAGE_ID_BUFFER_MAP_ALREADYMAPPED,

		/// <summary/>
		D3D11_MESSAGE_ID_BUFFER_MAP_DEVICEREMOVED_RETURN,

		/// <summary/>
		D3D11_MESSAGE_ID_BUFFER_UNMAP_NOTMAPPED,

		/// <summary/>
		D3D11_MESSAGE_ID_TEXTURE1D_MAP_INVALIDMAPTYPE,

		/// <summary/>
		D3D11_MESSAGE_ID_TEXTURE1D_MAP_INVALIDSUBRESOURCE,

		/// <summary/>
		D3D11_MESSAGE_ID_TEXTURE1D_MAP_INVALIDFLAGS,

		/// <summary/>
		D3D11_MESSAGE_ID_TEXTURE1D_MAP_ALREADYMAPPED,

		/// <summary/>
		D3D11_MESSAGE_ID_TEXTURE1D_MAP_DEVICEREMOVED_RETURN,

		/// <summary/>
		D3D11_MESSAGE_ID_TEXTURE1D_UNMAP_INVALIDSUBRESOURCE,

		/// <summary/>
		D3D11_MESSAGE_ID_TEXTURE1D_UNMAP_NOTMAPPED,

		/// <summary/>
		D3D11_MESSAGE_ID_TEXTURE2D_MAP_INVALIDMAPTYPE,

		/// <summary/>
		D3D11_MESSAGE_ID_TEXTURE2D_MAP_INVALIDSUBRESOURCE,

		/// <summary/>
		D3D11_MESSAGE_ID_TEXTURE2D_MAP_INVALIDFLAGS,

		/// <summary/>
		D3D11_MESSAGE_ID_TEXTURE2D_MAP_ALREADYMAPPED,

		/// <summary/>
		D3D11_MESSAGE_ID_TEXTURE2D_MAP_DEVICEREMOVED_RETURN,

		/// <summary/>
		D3D11_MESSAGE_ID_TEXTURE2D_UNMAP_INVALIDSUBRESOURCE,

		/// <summary/>
		D3D11_MESSAGE_ID_TEXTURE2D_UNMAP_NOTMAPPED,

		/// <summary/>
		D3D11_MESSAGE_ID_TEXTURE3D_MAP_INVALIDMAPTYPE,

		/// <summary/>
		D3D11_MESSAGE_ID_TEXTURE3D_MAP_INVALIDSUBRESOURCE,

		/// <summary/>
		D3D11_MESSAGE_ID_TEXTURE3D_MAP_INVALIDFLAGS,

		/// <summary/>
		D3D11_MESSAGE_ID_TEXTURE3D_MAP_ALREADYMAPPED,

		/// <summary/>
		D3D11_MESSAGE_ID_TEXTURE3D_MAP_DEVICEREMOVED_RETURN,

		/// <summary/>
		D3D11_MESSAGE_ID_TEXTURE3D_UNMAP_INVALIDSUBRESOURCE,

		/// <summary/>
		D3D11_MESSAGE_ID_TEXTURE3D_UNMAP_NOTMAPPED,

		/// <summary/>
		D3D11_MESSAGE_ID_CHECKFORMATSUPPORT_FORMAT_DEPRECATED,

		/// <summary/>
		D3D11_MESSAGE_ID_CHECKMULTISAMPLEQUALITYLEVELS_FORMAT_DEPRECATED,

		/// <summary/>
		D3D11_MESSAGE_ID_SETEXCEPTIONMODE_UNRECOGNIZEDFLAGS,

		/// <summary/>
		D3D11_MESSAGE_ID_SETEXCEPTIONMODE_INVALIDARG_RETURN,

		/// <summary/>
		D3D11_MESSAGE_ID_SETEXCEPTIONMODE_DEVICEREMOVED_RETURN,

		/// <summary/>
		D3D11_MESSAGE_ID_REF_SIMULATING_INFINITELY_FAST_HARDWARE,

		/// <summary/>
		D3D11_MESSAGE_ID_REF_THREADING_MODE,

		/// <summary/>
		D3D11_MESSAGE_ID_REF_UMDRIVER_EXCEPTION,

		/// <summary/>
		D3D11_MESSAGE_ID_REF_KMDRIVER_EXCEPTION,

		/// <summary/>
		D3D11_MESSAGE_ID_REF_HARDWARE_EXCEPTION,

		/// <summary/>
		D3D11_MESSAGE_ID_REF_ACCESSING_INDEXABLE_TEMP_OUT_OF_RANGE,

		/// <summary/>
		D3D11_MESSAGE_ID_REF_PROBLEM_PARSING_SHADER,

		/// <summary/>
		D3D11_MESSAGE_ID_REF_OUT_OF_MEMORY,

		/// <summary/>
		D3D11_MESSAGE_ID_REF_INFO,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_DRAW_VERTEXPOS_OVERFLOW,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_DRAWINDEXED_INDEXPOS_OVERFLOW,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_DRAWINSTANCED_VERTEXPOS_OVERFLOW,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_DRAWINSTANCED_INSTANCEPOS_OVERFLOW,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_DRAWINDEXEDINSTANCED_INSTANCEPOS_OVERFLOW,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_DRAWINDEXEDINSTANCED_INDEXPOS_OVERFLOW,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_DRAW_VERTEX_SHADER_NOT_SET,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_SHADER_LINKAGE_SEMANTICNAME_NOT_FOUND,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_SHADER_LINKAGE_REGISTERINDEX,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_SHADER_LINKAGE_COMPONENTTYPE,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_SHADER_LINKAGE_REGISTERMASK,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_SHADER_LINKAGE_SYSTEMVALUE,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_SHADER_LINKAGE_NEVERWRITTEN_ALWAYSREADS,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_DRAW_VERTEX_BUFFER_NOT_SET,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_DRAW_INPUTLAYOUT_NOT_SET,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_DRAW_CONSTANT_BUFFER_NOT_SET,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_DRAW_CONSTANT_BUFFER_TOO_SMALL,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_DRAW_SAMPLER_NOT_SET,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_DRAW_SHADERRESOURCEVIEW_NOT_SET,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_DRAW_VIEW_DIMENSION_MISMATCH,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_DRAW_VERTEX_BUFFER_STRIDE_TOO_SMALL,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_DRAW_VERTEX_BUFFER_TOO_SMALL,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_DRAW_INDEX_BUFFER_NOT_SET,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_DRAW_INDEX_BUFFER_FORMAT_INVALID,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_DRAW_INDEX_BUFFER_TOO_SMALL,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_DRAW_GS_INPUT_PRIMITIVE_MISMATCH,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_DRAW_RESOURCE_RETURN_TYPE_MISMATCH,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_DRAW_POSITION_NOT_PRESENT,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_DRAW_OUTPUT_STREAM_NOT_SET,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_DRAW_BOUND_RESOURCE_MAPPED,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_DRAW_INVALID_PRIMITIVETOPOLOGY,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_DRAW_VERTEX_OFFSET_UNALIGNED,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_DRAW_VERTEX_STRIDE_UNALIGNED,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_DRAW_INDEX_OFFSET_UNALIGNED,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_DRAW_OUTPUT_STREAM_OFFSET_UNALIGNED,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_DRAW_RESOURCE_FORMAT_LD_UNSUPPORTED,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_DRAW_RESOURCE_FORMAT_SAMPLE_UNSUPPORTED,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_DRAW_RESOURCE_FORMAT_SAMPLE_C_UNSUPPORTED,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_DRAW_RESOURCE_MULTISAMPLE_UNSUPPORTED,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_DRAW_SO_TARGETS_BOUND_WITHOUT_SOURCE,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_DRAW_SO_STRIDE_LARGER_THAN_BUFFER,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_DRAW_OM_RENDER_TARGET_DOES_NOT_SUPPORT_BLENDING,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_DRAW_OM_DUAL_SOURCE_BLENDING_CAN_ONLY_HAVE_RENDER_TARGET_0,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_REMOVAL_PROCESS_AT_FAULT,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_REMOVAL_PROCESS_POSSIBLY_AT_FAULT,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_REMOVAL_PROCESS_NOT_AT_FAULT,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_OPEN_SHARED_RESOURCE_INVALIDARG_RETURN,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_OPEN_SHARED_RESOURCE_OUTOFMEMORY_RETURN,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_OPEN_SHARED_RESOURCE_BADINTERFACE_RETURN,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_DRAW_VIEWPORT_NOT_SET,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEINPUTLAYOUT_TRAILING_DIGIT_IN_SEMANTIC,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_TRAILING_DIGIT_IN_SEMANTIC,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_RSSETVIEWPORTS_DENORMFLUSH,

		/// <summary/>
		D3D11_MESSAGE_ID_OMSETRENDERTARGETS_INVALIDVIEW,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_SETTEXTFILTERSIZE_INVALIDDIMENSIONS,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_DRAW_SAMPLER_MISMATCH,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEINPUTLAYOUT_TYPE_MISMATCH,

		/// <summary/>
		D3D11_MESSAGE_ID_BLENDSTATE_GETDESC_LEGACY,

		/// <summary/>
		D3D11_MESSAGE_ID_SHADERRESOURCEVIEW_GETDESC_LEGACY,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEQUERY_OUTOFMEMORY_RETURN,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEPREDICATE_OUTOFMEMORY_RETURN,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATECOUNTER_OUTOFRANGE_COUNTER,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATECOUNTER_SIMULTANEOUS_ACTIVE_COUNTERS_EXHAUSTED,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATECOUNTER_UNSUPPORTED_WELLKNOWN_COUNTER,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATECOUNTER_OUTOFMEMORY_RETURN,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATECOUNTER_NONEXCLUSIVE_RETURN,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATECOUNTER_NULLDESC,

		/// <summary/>
		D3D11_MESSAGE_ID_CHECKCOUNTER_OUTOFRANGE_COUNTER,

		/// <summary/>
		D3D11_MESSAGE_ID_CHECKCOUNTER_UNSUPPORTED_WELLKNOWN_COUNTER,

		/// <summary/>
		D3D11_MESSAGE_ID_SETPREDICATION_INVALID_PREDICATE_STATE,

		/// <summary/>
		D3D11_MESSAGE_ID_QUERY_BEGIN_UNSUPPORTED,

		/// <summary/>
		D3D11_MESSAGE_ID_PREDICATE_BEGIN_DURING_PREDICATION,

		/// <summary/>
		D3D11_MESSAGE_ID_QUERY_BEGIN_DUPLICATE,

		/// <summary/>
		D3D11_MESSAGE_ID_QUERY_BEGIN_ABANDONING_PREVIOUS_RESULTS,

		/// <summary/>
		D3D11_MESSAGE_ID_PREDICATE_END_DURING_PREDICATION,

		/// <summary/>
		D3D11_MESSAGE_ID_QUERY_END_ABANDONING_PREVIOUS_RESULTS,

		/// <summary/>
		D3D11_MESSAGE_ID_QUERY_END_WITHOUT_BEGIN,

		/// <summary/>
		D3D11_MESSAGE_ID_QUERY_GETDATA_INVALID_DATASIZE,

		/// <summary/>
		D3D11_MESSAGE_ID_QUERY_GETDATA_INVALID_FLAGS,

		/// <summary/>
		D3D11_MESSAGE_ID_QUERY_GETDATA_INVALID_CALL,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_DRAW_PS_OUTPUT_TYPE_MISMATCH,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_DRAW_RESOURCE_FORMAT_GATHER_UNSUPPORTED,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_DRAW_INVALID_USE_OF_CENTER_MULTISAMPLE_PATTERN,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_IASETVERTEXBUFFERS_STRIDE_TOO_LARGE,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_IASETVERTEXBUFFERS_INVALIDRANGE,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEINPUTLAYOUT_EMPTY_LAYOUT,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_DRAW_RESOURCE_SAMPLE_COUNT_MISMATCH,

		/// <summary/>
		D3D11_MESSAGE_ID_LIVE_OBJECT_SUMMARY,

		/// <summary/>
		D3D11_MESSAGE_ID_LIVE_BUFFER,

		/// <summary/>
		D3D11_MESSAGE_ID_LIVE_TEXTURE1D,

		/// <summary/>
		D3D11_MESSAGE_ID_LIVE_TEXTURE2D,

		/// <summary/>
		D3D11_MESSAGE_ID_LIVE_TEXTURE3D,

		/// <summary/>
		D3D11_MESSAGE_ID_LIVE_SHADERRESOURCEVIEW,

		/// <summary/>
		D3D11_MESSAGE_ID_LIVE_RENDERTARGETVIEW,

		/// <summary/>
		D3D11_MESSAGE_ID_LIVE_DEPTHSTENCILVIEW,

		/// <summary/>
		D3D11_MESSAGE_ID_LIVE_VERTEXSHADER,

		/// <summary/>
		D3D11_MESSAGE_ID_LIVE_GEOMETRYSHADER,

		/// <summary/>
		D3D11_MESSAGE_ID_LIVE_PIXELSHADER,

		/// <summary/>
		D3D11_MESSAGE_ID_LIVE_INPUTLAYOUT,

		/// <summary/>
		D3D11_MESSAGE_ID_LIVE_SAMPLER,

		/// <summary/>
		D3D11_MESSAGE_ID_LIVE_BLENDSTATE,

		/// <summary/>
		D3D11_MESSAGE_ID_LIVE_DEPTHSTENCILSTATE,

		/// <summary/>
		D3D11_MESSAGE_ID_LIVE_RASTERIZERSTATE,

		/// <summary/>
		D3D11_MESSAGE_ID_LIVE_QUERY,

		/// <summary/>
		D3D11_MESSAGE_ID_LIVE_PREDICATE,

		/// <summary/>
		D3D11_MESSAGE_ID_LIVE_COUNTER,

		/// <summary/>
		D3D11_MESSAGE_ID_LIVE_DEVICE,

		/// <summary/>
		D3D11_MESSAGE_ID_LIVE_SWAPCHAIN,

		/// <summary/>
		D3D11_MESSAGE_ID_D3D10_MESSAGES_END,

		/// <summary>
		/// <para>Value:</para>
		/// <para>0x100000</para>
		/// </summary>
		D3D11_MESSAGE_ID_D3D10L9_MESSAGES_START,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_STENCIL_NO_TWO_SIDED,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATERASTERIZERSTATE_DepthBiasClamp_NOT_SUPPORTED,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATESAMPLERSTATE_NO_COMPARISON_SUPPORT,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATESAMPLERSTATE_EXCESSIVE_ANISOTROPY,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATESAMPLERSTATE_BORDER_OUT_OF_RANGE,

		/// <summary/>
		D3D11_MESSAGE_ID_VSSETSAMPLERS_NOT_SUPPORTED,

		/// <summary/>
		D3D11_MESSAGE_ID_VSSETSAMPLERS_TOO_MANY_SAMPLERS,

		/// <summary/>
		D3D11_MESSAGE_ID_PSSETSAMPLERS_TOO_MANY_SAMPLERS,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATERESOURCE_NO_ARRAYS,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATERESOURCE_NO_VB_AND_IB_BIND,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATERESOURCE_NO_TEXTURE_1D,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATERESOURCE_DIMENSION_OUT_OF_RANGE,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATERESOURCE_NOT_BINDABLE_AS_SHADER_RESOURCE,

		/// <summary/>
		D3D11_MESSAGE_ID_OMSETRENDERTARGETS_TOO_MANY_RENDER_TARGETS,

		/// <summary/>
		D3D11_MESSAGE_ID_OMSETRENDERTARGETS_NO_DIFFERING_BIT_DEPTHS,

		/// <summary/>
		D3D11_MESSAGE_ID_IASETVERTEXBUFFERS_BAD_BUFFER_INDEX,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_RSSETVIEWPORTS_TOO_MANY_VIEWPORTS,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_IASETPRIMITIVETOPOLOGY_ADJACENCY_UNSUPPORTED,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_RSSETSCISSORRECTS_TOO_MANY_SCISSORS,

		/// <summary/>
		D3D11_MESSAGE_ID_COPYRESOURCE_ONLY_TEXTURE_2D_WITHIN_GPU_MEMORY,

		/// <summary/>
		D3D11_MESSAGE_ID_COPYRESOURCE_NO_TEXTURE_3D_READBACK,

		/// <summary/>
		D3D11_MESSAGE_ID_COPYRESOURCE_NO_TEXTURE_ONLY_READBACK,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEINPUTLAYOUT_UNSUPPORTED_FORMAT,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEBLENDSTATE_NO_ALPHA_TO_COVERAGE,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATERASTERIZERSTATE_DepthClipEnable_MUST_BE_TRUE,

		/// <summary/>
		D3D11_MESSAGE_ID_DRAWINDEXED_STARTINDEXLOCATION_MUST_BE_POSITIVE,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATESHADERRESOURCEVIEW_MUST_USE_LOWEST_LOD,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATESAMPLERSTATE_MINLOD_MUST_NOT_BE_FRACTIONAL,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATESAMPLERSTATE_MAXLOD_MUST_BE_FLT_MAX,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATESHADERRESOURCEVIEW_FIRSTARRAYSLICE_MUST_BE_ZERO,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATESHADERRESOURCEVIEW_CUBES_MUST_HAVE_6_SIDES,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATERESOURCE_NOT_BINDABLE_AS_RENDER_TARGET,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATERESOURCE_NO_DWORD_INDEX_BUFFER,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATERESOURCE_MSAA_PRECLUDES_SHADER_RESOURCE,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATERESOURCE_PRESENTATION_PRECLUDES_SHADER_RESOURCE,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEBLENDSTATE_NO_INDEPENDENT_BLEND_ENABLE,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEBLENDSTATE_NO_INDEPENDENT_WRITE_MASKS,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATERESOURCE_NO_STREAM_OUT,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATERESOURCE_ONLY_VB_IB_FOR_BUFFERS,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATERESOURCE_NO_AUTOGEN_FOR_VOLUMES,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATERESOURCE_DXGI_FORMAT_R8G8B8A8_CANNOT_BE_SHARED,

		/// <summary/>
		D3D11_MESSAGE_ID_VSSHADERRESOURCES_NOT_SUPPORTED,

		/// <summary/>
		D3D11_MESSAGE_ID_GEOMETRY_SHADER_NOT_SUPPORTED,

		/// <summary/>
		D3D11_MESSAGE_ID_STREAM_OUT_NOT_SUPPORTED,

		/// <summary/>
		D3D11_MESSAGE_ID_TEXT_FILTER_NOT_SUPPORTED,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEBLENDSTATE_NO_SEPARATE_ALPHA_BLEND,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEBLENDSTATE_NO_MRT_BLEND,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEBLENDSTATE_OPERATION_NOT_SUPPORTED,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATESAMPLERSTATE_NO_MIRRORONCE,

		/// <summary/>
		D3D11_MESSAGE_ID_DRAWINSTANCED_NOT_SUPPORTED,

		/// <summary/>
		D3D11_MESSAGE_ID_DRAWINDEXEDINSTANCED_NOT_SUPPORTED_BELOW_9_3,

		/// <summary/>
		D3D11_MESSAGE_ID_DRAWINDEXED_POINTLIST_UNSUPPORTED,

		/// <summary/>
		D3D11_MESSAGE_ID_SETBLENDSTATE_SAMPLE_MASK_CANNOT_BE_ZERO,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATERESOURCE_DIMENSION_EXCEEDS_FEATURE_LEVEL_DEFINITION,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATERESOURCE_ONLY_SINGLE_MIP_LEVEL_DEPTH_STENCIL_SUPPORTED,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_RSSETSCISSORRECTS_NEGATIVESCISSOR,

		/// <summary/>
		D3D11_MESSAGE_ID_SLOT_ZERO_MUST_BE_D3D10_INPUT_PER_VERTEX_DATA,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATERESOURCE_NON_POW_2_MIPMAP,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATESAMPLERSTATE_BORDER_NOT_SUPPORTED,

		/// <summary/>
		D3D11_MESSAGE_ID_OMSETRENDERTARGETS_NO_SRGB_MRT,

		/// <summary/>
		D3D11_MESSAGE_ID_COPYRESOURCE_NO_3D_MISMATCHED_UPDATES,

		/// <summary/>
		D3D11_MESSAGE_ID_D3D10L9_MESSAGES_END,

		/// <summary>
		/// <para>Value:</para>
		/// <para>0x200000</para>
		/// </summary>
		D3D11_MESSAGE_ID_D3D11_MESSAGES_START,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEDEPTHSTENCILVIEW_INVALIDFLAGS,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEVERTEXSHADER_INVALIDCLASSLINKAGE,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEGEOMETRYSHADER_INVALIDCLASSLINKAGE,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDNUMSTREAMS,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDSTREAMTORASTERIZER,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_UNEXPECTEDSTREAMS,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDCLASSLINKAGE,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEPIXELSHADER_INVALIDCLASSLINKAGE,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEDEFERREDCONTEXT_INVALID_COMMANDLISTFLAGS,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEDEFERREDCONTEXT_SINGLETHREADED,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEDEFERREDCONTEXT_INVALIDARG_RETURN,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEDEFERREDCONTEXT_INVALID_CALL_RETURN,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEDEFERREDCONTEXT_OUTOFMEMORY_RETURN,

		/// <summary/>
		D3D11_MESSAGE_ID_FINISHDISPLAYLIST_ONIMMEDIATECONTEXT,

		/// <summary/>
		D3D11_MESSAGE_ID_FINISHDISPLAYLIST_OUTOFMEMORY_RETURN,

		/// <summary/>
		D3D11_MESSAGE_ID_FINISHDISPLAYLIST_INVALID_CALL_RETURN,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDSTREAM,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_UNEXPECTEDENTRIES,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_UNEXPECTEDSTRIDES,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDNUMSTRIDES,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_HSSETSHADERRESOURCES_HAZARD,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_HSSETCONSTANTBUFFERS_HAZARD,

		/// <summary/>
		D3D11_MESSAGE_ID_HSSETSHADERRESOURCES_UNBINDDELETINGOBJECT,

		/// <summary/>
		D3D11_MESSAGE_ID_HSSETCONSTANTBUFFERS_UNBINDDELETINGOBJECT,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEHULLSHADER_INVALIDCALL,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEHULLSHADER_OUTOFMEMORY,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEHULLSHADER_INVALIDSHADERBYTECODE,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEHULLSHADER_INVALIDSHADERTYPE,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEHULLSHADER_INVALIDCLASSLINKAGE,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_HSSETSHADERRESOURCES_VIEWS_EMPTY,

		/// <summary/>
		D3D11_MESSAGE_ID_HSSETCONSTANTBUFFERS_INVALIDBUFFER,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_HSSETCONSTANTBUFFERS_BUFFERS_EMPTY,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_HSSETSAMPLERS_SAMPLERS_EMPTY,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_HSGETSHADERRESOURCES_VIEWS_EMPTY,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_HSGETCONSTANTBUFFERS_BUFFERS_EMPTY,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_HSGETSAMPLERS_SAMPLERS_EMPTY,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_DSSETSHADERRESOURCES_HAZARD,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_DSSETCONSTANTBUFFERS_HAZARD,

		/// <summary/>
		D3D11_MESSAGE_ID_DSSETSHADERRESOURCES_UNBINDDELETINGOBJECT,

		/// <summary/>
		D3D11_MESSAGE_ID_DSSETCONSTANTBUFFERS_UNBINDDELETINGOBJECT,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEDOMAINSHADER_INVALIDCALL,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEDOMAINSHADER_OUTOFMEMORY,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEDOMAINSHADER_INVALIDSHADERBYTECODE,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEDOMAINSHADER_INVALIDSHADERTYPE,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEDOMAINSHADER_INVALIDCLASSLINKAGE,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_DSSETSHADERRESOURCES_VIEWS_EMPTY,

		/// <summary/>
		D3D11_MESSAGE_ID_DSSETCONSTANTBUFFERS_INVALIDBUFFER,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_DSSETCONSTANTBUFFERS_BUFFERS_EMPTY,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_DSSETSAMPLERS_SAMPLERS_EMPTY,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_DSGETSHADERRESOURCES_VIEWS_EMPTY,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_DSGETCONSTANTBUFFERS_BUFFERS_EMPTY,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_DSGETSAMPLERS_SAMPLERS_EMPTY,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_DRAW_HS_XOR_DS_MISMATCH,

		/// <summary/>
		D3D11_MESSAGE_ID_DEFERRED_CONTEXT_REMOVAL_PROCESS_AT_FAULT,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_DRAWINDIRECT_INVALID_ARG_BUFFER,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_DRAWINDIRECT_OFFSET_UNALIGNED,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_DRAWINDIRECT_OFFSET_OVERFLOW,

		/// <summary/>
		D3D11_MESSAGE_ID_RESOURCE_MAP_INVALIDMAPTYPE,

		/// <summary/>
		D3D11_MESSAGE_ID_RESOURCE_MAP_INVALIDSUBRESOURCE,

		/// <summary/>
		D3D11_MESSAGE_ID_RESOURCE_MAP_INVALIDFLAGS,

		/// <summary/>
		D3D11_MESSAGE_ID_RESOURCE_MAP_ALREADYMAPPED,

		/// <summary/>
		D3D11_MESSAGE_ID_RESOURCE_MAP_DEVICEREMOVED_RETURN,

		/// <summary/>
		D3D11_MESSAGE_ID_RESOURCE_MAP_OUTOFMEMORY_RETURN,

		/// <summary/>
		D3D11_MESSAGE_ID_RESOURCE_MAP_WITHOUT_INITIAL_DISCARD,

		/// <summary/>
		D3D11_MESSAGE_ID_RESOURCE_UNMAP_INVALIDSUBRESOURCE,

		/// <summary/>
		D3D11_MESSAGE_ID_RESOURCE_UNMAP_NOTMAPPED,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_DRAW_RASTERIZING_CONTROL_POINTS,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_IASETPRIMITIVETOPOLOGY_TOPOLOGY_UNSUPPORTED,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_DRAW_HS_DS_SIGNATURE_MISMATCH,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_DRAW_HULL_SHADER_INPUT_TOPOLOGY_MISMATCH,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_DRAW_HS_DS_CONTROL_POINT_COUNT_MISMATCH,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_DRAW_HS_DS_TESSELLATOR_DOMAIN_MISMATCH,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATE_CONTEXT,

		/// <summary/>
		D3D11_MESSAGE_ID_LIVE_CONTEXT,

		/// <summary/>
		D3D11_MESSAGE_ID_DESTROY_CONTEXT,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATE_BUFFER,

		/// <summary/>
		D3D11_MESSAGE_ID_LIVE_BUFFER_WIN7,

		/// <summary/>
		D3D11_MESSAGE_ID_DESTROY_BUFFER,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATE_TEXTURE1D,

		/// <summary/>
		D3D11_MESSAGE_ID_LIVE_TEXTURE1D_WIN7,

		/// <summary/>
		D3D11_MESSAGE_ID_DESTROY_TEXTURE1D,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATE_TEXTURE2D,

		/// <summary/>
		D3D11_MESSAGE_ID_LIVE_TEXTURE2D_WIN7,

		/// <summary/>
		D3D11_MESSAGE_ID_DESTROY_TEXTURE2D,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATE_TEXTURE3D,

		/// <summary/>
		D3D11_MESSAGE_ID_LIVE_TEXTURE3D_WIN7,

		/// <summary/>
		D3D11_MESSAGE_ID_DESTROY_TEXTURE3D,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATE_SHADERRESOURCEVIEW,

		/// <summary/>
		D3D11_MESSAGE_ID_LIVE_SHADERRESOURCEVIEW_WIN7,

		/// <summary/>
		D3D11_MESSAGE_ID_DESTROY_SHADERRESOURCEVIEW,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATE_RENDERTARGETVIEW,

		/// <summary/>
		D3D11_MESSAGE_ID_LIVE_RENDERTARGETVIEW_WIN7,

		/// <summary/>
		D3D11_MESSAGE_ID_DESTROY_RENDERTARGETVIEW,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATE_DEPTHSTENCILVIEW,

		/// <summary/>
		D3D11_MESSAGE_ID_LIVE_DEPTHSTENCILVIEW_WIN7,

		/// <summary/>
		D3D11_MESSAGE_ID_DESTROY_DEPTHSTENCILVIEW,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATE_VERTEXSHADER,

		/// <summary/>
		D3D11_MESSAGE_ID_LIVE_VERTEXSHADER_WIN7,

		/// <summary/>
		D3D11_MESSAGE_ID_DESTROY_VERTEXSHADER,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATE_HULLSHADER,

		/// <summary/>
		D3D11_MESSAGE_ID_LIVE_HULLSHADER,

		/// <summary/>
		D3D11_MESSAGE_ID_DESTROY_HULLSHADER,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATE_DOMAINSHADER,

		/// <summary/>
		D3D11_MESSAGE_ID_LIVE_DOMAINSHADER,

		/// <summary/>
		D3D11_MESSAGE_ID_DESTROY_DOMAINSHADER,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATE_GEOMETRYSHADER,

		/// <summary/>
		D3D11_MESSAGE_ID_LIVE_GEOMETRYSHADER_WIN7,

		/// <summary/>
		D3D11_MESSAGE_ID_DESTROY_GEOMETRYSHADER,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATE_PIXELSHADER,

		/// <summary/>
		D3D11_MESSAGE_ID_LIVE_PIXELSHADER_WIN7,

		/// <summary/>
		D3D11_MESSAGE_ID_DESTROY_PIXELSHADER,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATE_INPUTLAYOUT,

		/// <summary/>
		D3D11_MESSAGE_ID_LIVE_INPUTLAYOUT_WIN7,

		/// <summary/>
		D3D11_MESSAGE_ID_DESTROY_INPUTLAYOUT,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATE_SAMPLER,

		/// <summary/>
		D3D11_MESSAGE_ID_LIVE_SAMPLER_WIN7,

		/// <summary/>
		D3D11_MESSAGE_ID_DESTROY_SAMPLER,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATE_BLENDSTATE,

		/// <summary/>
		D3D11_MESSAGE_ID_LIVE_BLENDSTATE_WIN7,

		/// <summary/>
		D3D11_MESSAGE_ID_DESTROY_BLENDSTATE,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATE_DEPTHSTENCILSTATE,

		/// <summary/>
		D3D11_MESSAGE_ID_LIVE_DEPTHSTENCILSTATE_WIN7,

		/// <summary/>
		D3D11_MESSAGE_ID_DESTROY_DEPTHSTENCILSTATE,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATE_RASTERIZERSTATE,

		/// <summary/>
		D3D11_MESSAGE_ID_LIVE_RASTERIZERSTATE_WIN7,

		/// <summary/>
		D3D11_MESSAGE_ID_DESTROY_RASTERIZERSTATE,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATE_QUERY,

		/// <summary/>
		D3D11_MESSAGE_ID_LIVE_QUERY_WIN7,

		/// <summary/>
		D3D11_MESSAGE_ID_DESTROY_QUERY,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATE_PREDICATE,

		/// <summary/>
		D3D11_MESSAGE_ID_LIVE_PREDICATE_WIN7,

		/// <summary/>
		D3D11_MESSAGE_ID_DESTROY_PREDICATE,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATE_COUNTER,

		/// <summary/>
		D3D11_MESSAGE_ID_DESTROY_COUNTER,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATE_COMMANDLIST,

		/// <summary/>
		D3D11_MESSAGE_ID_LIVE_COMMANDLIST,

		/// <summary/>
		D3D11_MESSAGE_ID_DESTROY_COMMANDLIST,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATE_CLASSINSTANCE,

		/// <summary/>
		D3D11_MESSAGE_ID_LIVE_CLASSINSTANCE,

		/// <summary/>
		D3D11_MESSAGE_ID_DESTROY_CLASSINSTANCE,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATE_CLASSLINKAGE,

		/// <summary/>
		D3D11_MESSAGE_ID_LIVE_CLASSLINKAGE,

		/// <summary/>
		D3D11_MESSAGE_ID_DESTROY_CLASSLINKAGE,

		/// <summary/>
		D3D11_MESSAGE_ID_LIVE_DEVICE_WIN7,

		/// <summary/>
		D3D11_MESSAGE_ID_LIVE_OBJECT_SUMMARY_WIN7,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATE_COMPUTESHADER,

		/// <summary/>
		D3D11_MESSAGE_ID_LIVE_COMPUTESHADER,

		/// <summary/>
		D3D11_MESSAGE_ID_DESTROY_COMPUTESHADER,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATE_UNORDEREDACCESSVIEW,

		/// <summary/>
		D3D11_MESSAGE_ID_LIVE_UNORDEREDACCESSVIEW,

		/// <summary/>
		D3D11_MESSAGE_ID_DESTROY_UNORDEREDACCESSVIEW,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_SETSHADER_INTERFACES_FEATURELEVEL,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_SETSHADER_INTERFACE_COUNT_MISMATCH,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_SETSHADER_INVALID_INSTANCE,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_SETSHADER_INVALID_INSTANCE_INDEX,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_SETSHADER_INVALID_INSTANCE_TYPE,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_SETSHADER_INVALID_INSTANCE_DATA,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_SETSHADER_UNBOUND_INSTANCE_DATA,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_SETSHADER_INSTANCE_DATA_BINDINGS,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_CREATESHADER_CLASSLINKAGE_FULL,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_CHECKFEATURESUPPORT_UNRECOGNIZED_FEATURE,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_CHECKFEATURESUPPORT_MISMATCHED_DATA_SIZE,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_CHECKFEATURESUPPORT_INVALIDARG_RETURN,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_CSSETSHADERRESOURCES_HAZARD,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_CSSETCONSTANTBUFFERS_HAZARD,

		/// <summary/>
		D3D11_MESSAGE_ID_CSSETSHADERRESOURCES_UNBINDDELETINGOBJECT,

		/// <summary/>
		D3D11_MESSAGE_ID_CSSETCONSTANTBUFFERS_UNBINDDELETINGOBJECT,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATECOMPUTESHADER_INVALIDCALL,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATECOMPUTESHADER_OUTOFMEMORY,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATECOMPUTESHADER_INVALIDSHADERBYTECODE,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATECOMPUTESHADER_INVALIDSHADERTYPE,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATECOMPUTESHADER_INVALIDCLASSLINKAGE,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_CSSETSHADERRESOURCES_VIEWS_EMPTY,

		/// <summary/>
		D3D11_MESSAGE_ID_CSSETCONSTANTBUFFERS_INVALIDBUFFER,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_CSSETCONSTANTBUFFERS_BUFFERS_EMPTY,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_CSSETSAMPLERS_SAMPLERS_EMPTY,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_CSGETSHADERRESOURCES_VIEWS_EMPTY,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_CSGETCONSTANTBUFFERS_BUFFERS_EMPTY,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_CSGETSAMPLERS_SAMPLERS_EMPTY,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_CREATEVERTEXSHADER_DOUBLEFLOATOPSNOTSUPPORTED,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_CREATEHULLSHADER_DOUBLEFLOATOPSNOTSUPPORTED,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_CREATEDOMAINSHADER_DOUBLEFLOATOPSNOTSUPPORTED,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_CREATEGEOMETRYSHADER_DOUBLEFLOATOPSNOTSUPPORTED,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_DOUBLEFLOATOPSNOTSUPPORTED,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_CREATEPIXELSHADER_DOUBLEFLOATOPSNOTSUPPORTED,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_CREATECOMPUTESHADER_DOUBLEFLOATOPSNOTSUPPORTED,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEBUFFER_INVALIDSTRUCTURESTRIDE,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATESHADERRESOURCEVIEW_INVALIDFLAGS,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEUNORDEREDACCESSVIEW_INVALIDRESOURCE,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEUNORDEREDACCESSVIEW_INVALIDDESC,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEUNORDEREDACCESSVIEW_INVALIDFORMAT,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEUNORDEREDACCESSVIEW_INVALIDDIMENSIONS,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEUNORDEREDACCESSVIEW_UNRECOGNIZEDFORMAT,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_OMSETRENDERTARGETSANDUNORDEREDACCESSVIEWS_HAZARD,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_OMSETRENDERTARGETSANDUNORDEREDACCESSVIEWS_OVERLAPPING_OLD_SLOTS,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_OMSETRENDERTARGETSANDUNORDEREDACCESSVIEWS_NO_OP,

		/// <summary/>
		D3D11_MESSAGE_ID_CSSETUNORDEREDACCESSVIEWS_UNBINDDELETINGOBJECT,

		/// <summary/>
		D3D11_MESSAGE_ID_PSSETUNORDEREDACCESSVIEWS_UNBINDDELETINGOBJECT,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEUNORDEREDACCESSVIEW_INVALIDARG_RETURN,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEUNORDEREDACCESSVIEW_OUTOFMEMORY_RETURN,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEUNORDEREDACCESSVIEW_TOOMANYOBJECTS,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_CSSETUNORDEREDACCESSVIEWS_HAZARD,

		/// <summary/>
		D3D11_MESSAGE_ID_CLEARUNORDEREDACCESSVIEW_DENORMFLUSH,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_CSSETUNORDEREDACCESSS_VIEWS_EMPTY,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_CSGETUNORDEREDACCESSS_VIEWS_EMPTY,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEUNORDEREDACCESSVIEW_INVALIDFLAGS,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATESHADERRESESOURCEVIEW_TOOMANYOBJECTS,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_DISPATCHINDIRECT_INVALID_ARG_BUFFER,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_DISPATCHINDIRECT_OFFSET_UNALIGNED,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_DISPATCHINDIRECT_OFFSET_OVERFLOW,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_SETRESOURCEMINLOD_INVALIDCONTEXT,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_SETRESOURCEMINLOD_INVALIDRESOURCE,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_SETRESOURCEMINLOD_INVALIDMINLOD,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_GETRESOURCEMINLOD_INVALIDCONTEXT,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_GETRESOURCEMINLOD_INVALIDRESOURCE,

		/// <summary/>
		D3D11_MESSAGE_ID_OMSETDEPTHSTENCIL_UNBINDDELETINGOBJECT,

		/// <summary/>
		D3D11_MESSAGE_ID_CLEARDEPTHSTENCILVIEW_DEPTH_READONLY,

		/// <summary/>
		D3D11_MESSAGE_ID_CLEARDEPTHSTENCILVIEW_STENCIL_READONLY,

		/// <summary/>
		D3D11_MESSAGE_ID_CHECKFEATURESUPPORT_FORMAT_DEPRECATED,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_UNORDEREDACCESSVIEW_RETURN_TYPE_MISMATCH,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_UNORDEREDACCESSVIEW_NOT_SET,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_DRAW_UNORDEREDACCESSVIEW_RENDERTARGETVIEW_OVERLAP,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_UNORDEREDACCESSVIEW_DIMENSION_MISMATCH,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_UNORDEREDACCESSVIEW_APPEND_UNSUPPORTED,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_UNORDEREDACCESSVIEW_ATOMICS_UNSUPPORTED,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_UNORDEREDACCESSVIEW_STRUCTURE_STRIDE_MISMATCH,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_UNORDEREDACCESSVIEW_BUFFER_TYPE_MISMATCH,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_UNORDEREDACCESSVIEW_RAW_UNSUPPORTED,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_UNORDEREDACCESSVIEW_FORMAT_LD_UNSUPPORTED,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_UNORDEREDACCESSVIEW_FORMAT_STORE_UNSUPPORTED,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_UNORDEREDACCESSVIEW_ATOMIC_ADD_UNSUPPORTED,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_UNORDEREDACCESSVIEW_ATOMIC_BITWISE_OPS_UNSUPPORTED,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_UNORDEREDACCESSVIEW_ATOMIC_CMPSTORE_CMPEXCHANGE_UNSUPPORTED,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_UNORDEREDACCESSVIEW_ATOMIC_EXCHANGE_UNSUPPORTED,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_UNORDEREDACCESSVIEW_ATOMIC_SIGNED_MINMAX_UNSUPPORTED,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_UNORDEREDACCESSVIEW_ATOMIC_UNSIGNED_MINMAX_UNSUPPORTED,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_DISPATCH_BOUND_RESOURCE_MAPPED,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_DISPATCH_THREADGROUPCOUNT_OVERFLOW,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_DISPATCH_THREADGROUPCOUNT_ZERO,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_SHADERRESOURCEVIEW_STRUCTURE_STRIDE_MISMATCH,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_SHADERRESOURCEVIEW_BUFFER_TYPE_MISMATCH,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_SHADERRESOURCEVIEW_RAW_UNSUPPORTED,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_DISPATCH_UNSUPPORTED,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_DISPATCHINDIRECT_UNSUPPORTED,

		/// <summary/>
		D3D11_MESSAGE_ID_COPYSTRUCTURECOUNT_INVALIDOFFSET,

		/// <summary/>
		D3D11_MESSAGE_ID_COPYSTRUCTURECOUNT_LARGEOFFSET,

		/// <summary/>
		D3D11_MESSAGE_ID_COPYSTRUCTURECOUNT_INVALIDDESTINATIONSTATE,

		/// <summary/>
		D3D11_MESSAGE_ID_COPYSTRUCTURECOUNT_INVALIDSOURCESTATE,

		/// <summary/>
		D3D11_MESSAGE_ID_CHECKFORMATSUPPORT_FORMAT_NOT_SUPPORTED,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_CSSETUNORDEREDACCESSVIEWS_INVALIDVIEW,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_CSSETUNORDEREDACCESSVIEWS_INVALIDOFFSET,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_CSSETUNORDEREDACCESSVIEWS_TOOMANYVIEWS,

		/// <summary/>
		D3D11_MESSAGE_ID_CLEARUNORDEREDACCESSVIEWFLOAT_INVALIDFORMAT,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_UNORDEREDACCESSVIEW_COUNTER_UNSUPPORTED,

		/// <summary/>
		D3D11_MESSAGE_ID_REF_WARNING,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_DRAW_PIXEL_SHADER_WITHOUT_RTV_OR_DSV,

		/// <summary/>
		D3D11_MESSAGE_ID_SHADER_ABORT,

		/// <summary/>
		D3D11_MESSAGE_ID_SHADER_MESSAGE,

		/// <summary/>
		D3D11_MESSAGE_ID_SHADER_ERROR,

		/// <summary/>
		D3D11_MESSAGE_ID_OFFERRESOURCES_INVALIDRESOURCE,

		/// <summary/>
		D3D11_MESSAGE_ID_HSSETSAMPLERS_UNBINDDELETINGOBJECT,

		/// <summary/>
		D3D11_MESSAGE_ID_DSSETSAMPLERS_UNBINDDELETINGOBJECT,

		/// <summary/>
		D3D11_MESSAGE_ID_CSSETSAMPLERS_UNBINDDELETINGOBJECT,

		/// <summary/>
		D3D11_MESSAGE_ID_HSSETSHADER_UNBINDDELETINGOBJECT,

		/// <summary/>
		D3D11_MESSAGE_ID_DSSETSHADER_UNBINDDELETINGOBJECT,

		/// <summary/>
		D3D11_MESSAGE_ID_CSSETSHADER_UNBINDDELETINGOBJECT,

		/// <summary/>
		D3D11_MESSAGE_ID_ENQUEUESETEVENT_INVALIDARG_RETURN,

		/// <summary/>
		D3D11_MESSAGE_ID_ENQUEUESETEVENT_OUTOFMEMORY_RETURN,

		/// <summary/>
		D3D11_MESSAGE_ID_ENQUEUESETEVENT_ACCESSDENIED_RETURN,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_OMSETRENDERTARGETSANDUNORDEREDACCESSVIEWS_NUMUAVS_INVALIDRANGE,

		/// <summary/>
		D3D11_MESSAGE_ID_USE_OF_ZERO_REFCOUNT_OBJECT,

		/// <summary/>
		D3D11_MESSAGE_ID_D3D11_MESSAGES_END,

		/// <summary>
		/// <para>Value:</para>
		/// <para>0x300000</para>
		/// </summary>
		D3D11_MESSAGE_ID_D3D11_1_MESSAGES_START,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATE_VIDEODECODER,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATE_VIDEOPROCESSORENUM,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATE_VIDEOPROCESSOR,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATE_DECODEROUTPUTVIEW,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATE_PROCESSORINPUTVIEW,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATE_PROCESSOROUTPUTVIEW,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATE_DEVICECONTEXTSTATE,

		/// <summary/>
		D3D11_MESSAGE_ID_LIVE_VIDEODECODER,

		/// <summary/>
		D3D11_MESSAGE_ID_LIVE_VIDEOPROCESSORENUM,

		/// <summary/>
		D3D11_MESSAGE_ID_LIVE_VIDEOPROCESSOR,

		/// <summary/>
		D3D11_MESSAGE_ID_LIVE_DECODEROUTPUTVIEW,

		/// <summary/>
		D3D11_MESSAGE_ID_LIVE_PROCESSORINPUTVIEW,

		/// <summary/>
		D3D11_MESSAGE_ID_LIVE_PROCESSOROUTPUTVIEW,

		/// <summary/>
		D3D11_MESSAGE_ID_LIVE_DEVICECONTEXTSTATE,

		/// <summary/>
		D3D11_MESSAGE_ID_DESTROY_VIDEODECODER,

		/// <summary/>
		D3D11_MESSAGE_ID_DESTROY_VIDEOPROCESSORENUM,

		/// <summary/>
		D3D11_MESSAGE_ID_DESTROY_VIDEOPROCESSOR,

		/// <summary/>
		D3D11_MESSAGE_ID_DESTROY_DECODEROUTPUTVIEW,

		/// <summary/>
		D3D11_MESSAGE_ID_DESTROY_PROCESSORINPUTVIEW,

		/// <summary/>
		D3D11_MESSAGE_ID_DESTROY_PROCESSOROUTPUTVIEW,

		/// <summary/>
		D3D11_MESSAGE_ID_DESTROY_DEVICECONTEXTSTATE,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEDEVICECONTEXTSTATE_INVALIDFLAGS,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEDEVICECONTEXTSTATE_INVALIDFEATURELEVEL,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEDEVICECONTEXTSTATE_FEATURELEVELS_NOT_SUPPORTED,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEDEVICECONTEXTSTATE_INVALIDREFIID,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_DISCARDVIEW_INVALIDVIEW,

		/// <summary/>
		D3D11_MESSAGE_ID_COPYSUBRESOURCEREGION1_INVALIDCOPYFLAGS,

		/// <summary/>
		D3D11_MESSAGE_ID_UPDATESUBRESOURCE1_INVALIDCOPYFLAGS,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATERASTERIZERSTATE_INVALIDFORCEDSAMPLECOUNT,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEVIDEODECODER_OUTOFMEMORY_RETURN,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEVIDEODECODER_NULLPARAM,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEVIDEODECODER_INVALIDFORMAT,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEVIDEODECODER_ZEROWIDTHHEIGHT,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEVIDEODECODER_DRIVER_INVALIDBUFFERSIZE,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEVIDEODECODER_DRIVER_INVALIDBUFFERUSAGE,

		/// <summary/>
		D3D11_MESSAGE_ID_GETVIDEODECODERPROFILECOUNT_OUTOFMEMORY,

		/// <summary/>
		D3D11_MESSAGE_ID_GETVIDEODECODERPROFILE_NULLPARAM,

		/// <summary/>
		D3D11_MESSAGE_ID_GETVIDEODECODERPROFILE_INVALIDINDEX,

		/// <summary/>
		D3D11_MESSAGE_ID_GETVIDEODECODERPROFILE_OUTOFMEMORY_RETURN,

		/// <summary/>
		D3D11_MESSAGE_ID_CHECKVIDEODECODERFORMAT_NULLPARAM,

		/// <summary/>
		D3D11_MESSAGE_ID_CHECKVIDEODECODERFORMAT_OUTOFMEMORY_RETURN,

		/// <summary/>
		D3D11_MESSAGE_ID_GETVIDEODECODERCONFIGCOUNT_NULLPARAM,

		/// <summary/>
		D3D11_MESSAGE_ID_GETVIDEODECODERCONFIGCOUNT_OUTOFMEMORY_RETURN,

		/// <summary/>
		D3D11_MESSAGE_ID_GETVIDEODECODERCONFIG_NULLPARAM,

		/// <summary/>
		D3D11_MESSAGE_ID_GETVIDEODECODERCONFIG_INVALIDINDEX,

		/// <summary/>
		D3D11_MESSAGE_ID_GETVIDEODECODERCONFIG_OUTOFMEMORY_RETURN,

		/// <summary/>
		D3D11_MESSAGE_ID_GETDECODERCREATIONPARAMS_NULLPARAM,

		/// <summary/>
		D3D11_MESSAGE_ID_GETDECODERDRIVERHANDLE_NULLPARAM,

		/// <summary/>
		D3D11_MESSAGE_ID_GETDECODERBUFFER_NULLPARAM,

		/// <summary/>
		D3D11_MESSAGE_ID_GETDECODERBUFFER_INVALIDBUFFER,

		/// <summary/>
		D3D11_MESSAGE_ID_GETDECODERBUFFER_INVALIDTYPE,

		/// <summary/>
		D3D11_MESSAGE_ID_GETDECODERBUFFER_LOCKED,

		/// <summary/>
		D3D11_MESSAGE_ID_RELEASEDECODERBUFFER_NULLPARAM,

		/// <summary/>
		D3D11_MESSAGE_ID_RELEASEDECODERBUFFER_INVALIDTYPE,

		/// <summary/>
		D3D11_MESSAGE_ID_RELEASEDECODERBUFFER_NOTLOCKED,

		/// <summary/>
		D3D11_MESSAGE_ID_DECODERBEGINFRAME_NULLPARAM,

		/// <summary/>
		D3D11_MESSAGE_ID_DECODERBEGINFRAME_HAZARD,

		/// <summary/>
		D3D11_MESSAGE_ID_DECODERENDFRAME_NULLPARAM,

		/// <summary/>
		D3D11_MESSAGE_ID_SUBMITDECODERBUFFERS_NULLPARAM,

		/// <summary/>
		D3D11_MESSAGE_ID_SUBMITDECODERBUFFERS_INVALIDTYPE,

		/// <summary/>
		D3D11_MESSAGE_ID_DECODEREXTENSION_NULLPARAM,

		/// <summary/>
		D3D11_MESSAGE_ID_DECODEREXTENSION_INVALIDRESOURCE,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEVIDEOPROCESSORENUMERATOR_OUTOFMEMORY_RETURN,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEVIDEOPROCESSORENUMERATOR_NULLPARAM,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEVIDEOPROCESSORENUMERATOR_INVALIDFRAMEFORMAT,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEVIDEOPROCESSORENUMERATOR_INVALIDUSAGE,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEVIDEOPROCESSORENUMERATOR_INVALIDINPUTFRAMERATE,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEVIDEOPROCESSORENUMERATOR_INVALIDOUTPUTFRAMERATE,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEVIDEOPROCESSORENUMERATOR_INVALIDWIDTHHEIGHT,

		/// <summary/>
		D3D11_MESSAGE_ID_GETVIDEOPROCESSORCONTENTDESC_NULLPARAM,

		/// <summary/>
		D3D11_MESSAGE_ID_CHECKVIDEOPROCESSORFORMAT_NULLPARAM,

		/// <summary/>
		D3D11_MESSAGE_ID_GETVIDEOPROCESSORCAPS_NULLPARAM,

		/// <summary/>
		D3D11_MESSAGE_ID_GETVIDEOPROCESSORRATECONVERSIONCAPS_NULLPARAM,

		/// <summary/>
		D3D11_MESSAGE_ID_GETVIDEOPROCESSORRATECONVERSIONCAPS_INVALIDINDEX,

		/// <summary/>
		D3D11_MESSAGE_ID_GETVIDEOPROCESSORCUSTOMRATE_NULLPARAM,

		/// <summary/>
		D3D11_MESSAGE_ID_GETVIDEOPROCESSORCUSTOMRATE_INVALIDINDEX,

		/// <summary/>
		D3D11_MESSAGE_ID_GETVIDEOPROCESSORFILTERRANGE_NULLPARAM,

		/// <summary/>
		D3D11_MESSAGE_ID_GETVIDEOPROCESSORFILTERRANGE_UNSUPPORTED,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEVIDEOPROCESSOR_OUTOFMEMORY_RETURN,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEVIDEOPROCESSOR_NULLPARAM,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORSETOUTPUTTARGETRECT_NULLPARAM,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORSETOUTPUTBACKGROUNDCOLOR_NULLPARAM,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORSETOUTPUTBACKGROUNDCOLOR_INVALIDALPHA,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORSETOUTPUTCOLORSPACE_NULLPARAM,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORSETOUTPUTALPHAFILLMODE_NULLPARAM,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORSETOUTPUTALPHAFILLMODE_UNSUPPORTED,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORSETOUTPUTALPHAFILLMODE_INVALIDSTREAM,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORSETOUTPUTALPHAFILLMODE_INVALIDFILLMODE,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORSETOUTPUTCONSTRICTION_NULLPARAM,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORSETOUTPUTSTEREOMODE_NULLPARAM,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORSETOUTPUTSTEREOMODE_UNSUPPORTED,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORSETOUTPUTEXTENSION_NULLPARAM,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORGETOUTPUTTARGETRECT_NULLPARAM,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORGETOUTPUTBACKGROUNDCOLOR_NULLPARAM,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORGETOUTPUTCOLORSPACE_NULLPARAM,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORGETOUTPUTALPHAFILLMODE_NULLPARAM,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORGETOUTPUTCONSTRICTION_NULLPARAM,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORSETOUTPUTCONSTRICTION_UNSUPPORTED,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORSETOUTPUTCONSTRICTION_INVALIDSIZE,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORGETOUTPUTSTEREOMODE_NULLPARAM,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORGETOUTPUTEXTENSION_NULLPARAM,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMFRAMEFORMAT_NULLPARAM,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMFRAMEFORMAT_INVALIDFORMAT,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMFRAMEFORMAT_INVALIDSTREAM,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMCOLORSPACE_NULLPARAM,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMCOLORSPACE_INVALIDSTREAM,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMOUTPUTRATE_NULLPARAM,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMOUTPUTRATE_INVALIDRATE,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMOUTPUTRATE_INVALIDFLAG,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMOUTPUTRATE_INVALIDSTREAM,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMSOURCERECT_NULLPARAM,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMSOURCERECT_INVALIDSTREAM,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMSOURCERECT_INVALIDRECT,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMDESTRECT_NULLPARAM,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMDESTRECT_INVALIDSTREAM,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMDESTRECT_INVALIDRECT,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMALPHA_NULLPARAM,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMALPHA_INVALIDSTREAM,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMALPHA_INVALIDALPHA,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMPALETTE_NULLPARAM,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMPALETTE_INVALIDSTREAM,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMPALETTE_INVALIDCOUNT,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMPALETTE_INVALIDALPHA,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMPIXELASPECTRATIO_NULLPARAM,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMPIXELASPECTRATIO_INVALIDSTREAM,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMPIXELASPECTRATIO_INVALIDRATIO,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMLUMAKEY_NULLPARAM,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMLUMAKEY_INVALIDSTREAM,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMLUMAKEY_INVALIDRANGE,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMLUMAKEY_UNSUPPORTED,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMSTEREOFORMAT_NULLPARAM,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMSTEREOFORMAT_INVALIDSTREAM,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMSTEREOFORMAT_UNSUPPORTED,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMSTEREOFORMAT_FLIPUNSUPPORTED,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMSTEREOFORMAT_MONOOFFSETUNSUPPORTED,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMSTEREOFORMAT_FORMATUNSUPPORTED,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMSTEREOFORMAT_INVALIDFORMAT,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMAUTOPROCESSINGMODE_NULLPARAM,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMAUTOPROCESSINGMODE_INVALIDSTREAM,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMFILTER_NULLPARAM,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMFILTER_INVALIDSTREAM,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMFILTER_INVALIDFILTER,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMFILTER_UNSUPPORTED,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMFILTER_INVALIDLEVEL,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMEXTENSION_NULLPARAM,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMEXTENSION_INVALIDSTREAM,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORGETSTREAMFRAMEFORMAT_NULLPARAM,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORGETSTREAMCOLORSPACE_NULLPARAM,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORGETSTREAMOUTPUTRATE_NULLPARAM,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORGETSTREAMSOURCERECT_NULLPARAM,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORGETSTREAMDESTRECT_NULLPARAM,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORGETSTREAMALPHA_NULLPARAM,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORGETSTREAMPALETTE_NULLPARAM,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORGETSTREAMPIXELASPECTRATIO_NULLPARAM,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORGETSTREAMLUMAKEY_NULLPARAM,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORGETSTREAMSTEREOFORMAT_NULLPARAM,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORGETSTREAMAUTOPROCESSINGMODE_NULLPARAM,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORGETSTREAMFILTER_NULLPARAM,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORGETSTREAMEXTENSION_NULLPARAM,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORGETSTREAMEXTENSION_INVALIDSTREAM,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORBLT_NULLPARAM,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORBLT_INVALIDSTREAMCOUNT,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORBLT_TARGETRECT,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORBLT_INVALIDOUTPUT,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORBLT_INVALIDPASTFRAMES,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORBLT_INVALIDFUTUREFRAMES,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORBLT_INVALIDSOURCERECT,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORBLT_INVALIDDESTRECT,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORBLT_INVALIDINPUTRESOURCE,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORBLT_INVALIDARRAYSIZE,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORBLT_INVALIDARRAY,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORBLT_RIGHTEXPECTED,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORBLT_RIGHTNOTEXPECTED,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORBLT_STEREONOTENABLED,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORBLT_INVALIDRIGHTRESOURCE,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORBLT_NOSTEREOSTREAMS,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORBLT_INPUTHAZARD,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORBLT_OUTPUTHAZARD,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEVIDEODECODEROUTPUTVIEW_OUTOFMEMORY_RETURN,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEVIDEODECODEROUTPUTVIEW_NULLPARAM,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEVIDEODECODEROUTPUTVIEW_INVALIDTYPE,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEVIDEODECODEROUTPUTVIEW_INVALIDBIND,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEVIDEODECODEROUTPUTVIEW_UNSUPPORTEDFORMAT,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEVIDEODECODEROUTPUTVIEW_INVALIDMIP,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEVIDEODECODEROUTPUTVIEW_UNSUPPORTEMIP,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEVIDEODECODEROUTPUTVIEW_INVALIDARRAYSIZE,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEVIDEODECODEROUTPUTVIEW_INVALIDARRAY,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEVIDEODECODEROUTPUTVIEW_INVALIDDIMENSION,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEVIDEOPROCESSORINPUTVIEW_OUTOFMEMORY_RETURN,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEVIDEOPROCESSORINPUTVIEW_NULLPARAM,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEVIDEOPROCESSORINPUTVIEW_INVALIDTYPE,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEVIDEOPROCESSORINPUTVIEW_INVALIDBIND,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEVIDEOPROCESSORINPUTVIEW_INVALIDMISC,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEVIDEOPROCESSORINPUTVIEW_INVALIDUSAGE,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEVIDEOPROCESSORINPUTVIEW_INVALIDFORMAT,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEVIDEOPROCESSORINPUTVIEW_INVALIDFOURCC,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEVIDEOPROCESSORINPUTVIEW_INVALIDMIP,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEVIDEOPROCESSORINPUTVIEW_UNSUPPORTEDMIP,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEVIDEOPROCESSORINPUTVIEW_INVALIDARRAYSIZE,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEVIDEOPROCESSORINPUTVIEW_INVALIDARRAY,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEVIDEOPROCESSORINPUTVIEW_INVALIDDIMENSION,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEVIDEOPROCESSOROUTPUTVIEW_OUTOFMEMORY_RETURN,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEVIDEOPROCESSOROUTPUTVIEW_NULLPARAM,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEVIDEOPROCESSOROUTPUTVIEW_INVALIDTYPE,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEVIDEOPROCESSOROUTPUTVIEW_INVALIDBIND,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEVIDEOPROCESSOROUTPUTVIEW_INVALIDFORMAT,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEVIDEOPROCESSOROUTPUTVIEW_INVALIDMIP,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEVIDEOPROCESSOROUTPUTVIEW_UNSUPPORTEDMIP,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEVIDEOPROCESSOROUTPUTVIEW_UNSUPPORTEDARRAY,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEVIDEOPROCESSOROUTPUTVIEW_INVALIDARRAY,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEVIDEOPROCESSOROUTPUTVIEW_INVALIDDIMENSION,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_DRAW_INVALID_USE_OF_FORCED_SAMPLE_COUNT,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEBLENDSTATE_INVALIDLOGICOPS,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATESHADERRESOURCEVIEW_INVALIDDARRAYWITHDECODER,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEUNORDEREDACCESSVIEW_INVALIDDARRAYWITHDECODER,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATERENDERTARGETVIEW_INVALIDDARRAYWITHDECODER,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_LOCKEDOUT_INTERFACE,

		/// <summary/>
		D3D11_MESSAGE_ID_REF_WARNING_ATOMIC_INCONSISTENT,

		/// <summary/>
		D3D11_MESSAGE_ID_REF_WARNING_READING_UNINITIALIZED_RESOURCE,

		/// <summary/>
		D3D11_MESSAGE_ID_REF_WARNING_RAW_HAZARD,

		/// <summary/>
		D3D11_MESSAGE_ID_REF_WARNING_WAR_HAZARD,

		/// <summary/>
		D3D11_MESSAGE_ID_REF_WARNING_WAW_HAZARD,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATECRYPTOSESSION_NULLPARAM,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATECRYPTOSESSION_OUTOFMEMORY_RETURN,

		/// <summary/>
		D3D11_MESSAGE_ID_GETCRYPTOTYPE_NULLPARAM,

		/// <summary/>
		D3D11_MESSAGE_ID_GETDECODERPROFILE_NULLPARAM,

		/// <summary/>
		D3D11_MESSAGE_ID_GETCRYPTOSESSIONCERTIFICATESIZE_NULLPARAM,

		/// <summary/>
		D3D11_MESSAGE_ID_GETCRYPTOSESSIONCERTIFICATE_NULLPARAM,

		/// <summary/>
		D3D11_MESSAGE_ID_GETCRYPTOSESSIONCERTIFICATE_WRONGSIZE,

		/// <summary/>
		D3D11_MESSAGE_ID_GETCRYPTOSESSIONHANDLE_WRONGSIZE,

		/// <summary/>
		D3D11_MESSAGE_ID_NEGOTIATECRPYTOSESSIONKEYEXCHANGE_NULLPARAM,

		/// <summary/>
		D3D11_MESSAGE_ID_ENCRYPTIONBLT_UNSUPPORTED,

		/// <summary/>
		D3D11_MESSAGE_ID_ENCRYPTIONBLT_NULLPARAM,

		/// <summary/>
		D3D11_MESSAGE_ID_ENCRYPTIONBLT_SRC_WRONGDEVICE,

		/// <summary/>
		D3D11_MESSAGE_ID_ENCRYPTIONBLT_DST_WRONGDEVICE,

		/// <summary/>
		D3D11_MESSAGE_ID_ENCRYPTIONBLT_FORMAT_MISMATCH,

		/// <summary/>
		D3D11_MESSAGE_ID_ENCRYPTIONBLT_SIZE_MISMATCH,

		/// <summary/>
		D3D11_MESSAGE_ID_ENCRYPTIONBLT_SRC_MULTISAMPLED,

		/// <summary/>
		D3D11_MESSAGE_ID_ENCRYPTIONBLT_DST_NOT_STAGING,

		/// <summary/>
		D3D11_MESSAGE_ID_ENCRYPTIONBLT_SRC_MAPPED,

		/// <summary/>
		D3D11_MESSAGE_ID_ENCRYPTIONBLT_DST_MAPPED,

		/// <summary/>
		D3D11_MESSAGE_ID_ENCRYPTIONBLT_SRC_OFFERED,

		/// <summary/>
		D3D11_MESSAGE_ID_ENCRYPTIONBLT_DST_OFFERED,

		/// <summary/>
		D3D11_MESSAGE_ID_ENCRYPTIONBLT_SRC_CONTENT_UNDEFINED,

		/// <summary/>
		D3D11_MESSAGE_ID_DECRYPTIONBLT_UNSUPPORTED,

		/// <summary/>
		D3D11_MESSAGE_ID_DECRYPTIONBLT_NULLPARAM,

		/// <summary/>
		D3D11_MESSAGE_ID_DECRYPTIONBLT_SRC_WRONGDEVICE,

		/// <summary/>
		D3D11_MESSAGE_ID_DECRYPTIONBLT_DST_WRONGDEVICE,

		/// <summary/>
		D3D11_MESSAGE_ID_DECRYPTIONBLT_FORMAT_MISMATCH,

		/// <summary/>
		D3D11_MESSAGE_ID_DECRYPTIONBLT_SIZE_MISMATCH,

		/// <summary/>
		D3D11_MESSAGE_ID_DECRYPTIONBLT_DST_MULTISAMPLED,

		/// <summary/>
		D3D11_MESSAGE_ID_DECRYPTIONBLT_SRC_NOT_STAGING,

		/// <summary/>
		D3D11_MESSAGE_ID_DECRYPTIONBLT_DST_NOT_RENDER_TARGET,

		/// <summary/>
		D3D11_MESSAGE_ID_DECRYPTIONBLT_SRC_MAPPED,

		/// <summary/>
		D3D11_MESSAGE_ID_DECRYPTIONBLT_DST_MAPPED,

		/// <summary/>
		D3D11_MESSAGE_ID_DECRYPTIONBLT_SRC_OFFERED,

		/// <summary/>
		D3D11_MESSAGE_ID_DECRYPTIONBLT_DST_OFFERED,

		/// <summary/>
		D3D11_MESSAGE_ID_DECRYPTIONBLT_SRC_CONTENT_UNDEFINED,

		/// <summary/>
		D3D11_MESSAGE_ID_STARTSESSIONKEYREFRESH_NULLPARAM,

		/// <summary/>
		D3D11_MESSAGE_ID_STARTSESSIONKEYREFRESH_INVALIDSIZE,

		/// <summary/>
		D3D11_MESSAGE_ID_FINISHSESSIONKEYREFRESH_NULLPARAM,

		/// <summary/>
		D3D11_MESSAGE_ID_GETENCRYPTIONBLTKEY_NULLPARAM,

		/// <summary/>
		D3D11_MESSAGE_ID_GETENCRYPTIONBLTKEY_INVALIDSIZE,

		/// <summary/>
		D3D11_MESSAGE_ID_GETCONTENTPROTECTIONCAPS_NULLPARAM,

		/// <summary/>
		D3D11_MESSAGE_ID_CHECKCRYPTOKEYEXCHANGE_NULLPARAM,

		/// <summary/>
		D3D11_MESSAGE_ID_CHECKCRYPTOKEYEXCHANGE_INVALIDINDEX,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEAUTHENTICATEDCHANNEL_NULLPARAM,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEAUTHENTICATEDCHANNEL_UNSUPPORTED,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEAUTHENTICATEDCHANNEL_INVALIDTYPE,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEAUTHENTICATEDCHANNEL_OUTOFMEMORY_RETURN,

		/// <summary/>
		D3D11_MESSAGE_ID_GETAUTHENTICATEDCHANNELCERTIFICATESIZE_INVALIDCHANNEL,

		/// <summary/>
		D3D11_MESSAGE_ID_GETAUTHENTICATEDCHANNELCERTIFICATESIZE_NULLPARAM,

		/// <summary/>
		D3D11_MESSAGE_ID_GETAUTHENTICATEDCHANNELCERTIFICATE_INVALIDCHANNEL,

		/// <summary/>
		D3D11_MESSAGE_ID_GETAUTHENTICATEDCHANNELCERTIFICATE_NULLPARAM,

		/// <summary/>
		D3D11_MESSAGE_ID_GETAUTHENTICATEDCHANNELCERTIFICATE_WRONGSIZE,

		/// <summary/>
		D3D11_MESSAGE_ID_NEGOTIATEAUTHENTICATEDCHANNELKEYEXCHANGE_INVALIDCHANNEL,

		/// <summary/>
		D3D11_MESSAGE_ID_NEGOTIATEAUTHENTICATEDCHANNELKEYEXCHANGE_NULLPARAM,

		/// <summary/>
		D3D11_MESSAGE_ID_QUERYAUTHENTICATEDCHANNEL_NULLPARAM,

		/// <summary/>
		D3D11_MESSAGE_ID_QUERYAUTHENTICATEDCHANNEL_WRONGCHANNEL,

		/// <summary/>
		D3D11_MESSAGE_ID_QUERYAUTHENTICATEDCHANNEL_UNSUPPORTEDQUERY,

		/// <summary/>
		D3D11_MESSAGE_ID_QUERYAUTHENTICATEDCHANNEL_WRONGSIZE,

		/// <summary/>
		D3D11_MESSAGE_ID_QUERYAUTHENTICATEDCHANNEL_INVALIDPROCESSINDEX,

		/// <summary/>
		D3D11_MESSAGE_ID_CONFIGUREAUTHENTICATEDCHANNEL_NULLPARAM,

		/// <summary/>
		D3D11_MESSAGE_ID_CONFIGUREAUTHENTICATEDCHANNEL_WRONGCHANNEL,

		/// <summary/>
		D3D11_MESSAGE_ID_CONFIGUREAUTHENTICATEDCHANNEL_UNSUPPORTEDCONFIGURE,

		/// <summary/>
		D3D11_MESSAGE_ID_CONFIGUREAUTHENTICATEDCHANNEL_WRONGSIZE,

		/// <summary/>
		D3D11_MESSAGE_ID_CONFIGUREAUTHENTICATEDCHANNEL_INVALIDPROCESSIDTYPE,

		/// <summary/>
		D3D11_MESSAGE_ID_VSSETCONSTANTBUFFERS_INVALIDBUFFEROFFSETORCOUNT,

		/// <summary/>
		D3D11_MESSAGE_ID_DSSETCONSTANTBUFFERS_INVALIDBUFFEROFFSETORCOUNT,

		/// <summary/>
		D3D11_MESSAGE_ID_HSSETCONSTANTBUFFERS_INVALIDBUFFEROFFSETORCOUNT,

		/// <summary/>
		D3D11_MESSAGE_ID_GSSETCONSTANTBUFFERS_INVALIDBUFFEROFFSETORCOUNT,

		/// <summary/>
		D3D11_MESSAGE_ID_PSSETCONSTANTBUFFERS_INVALIDBUFFEROFFSETORCOUNT,

		/// <summary/>
		D3D11_MESSAGE_ID_CSSETCONSTANTBUFFERS_INVALIDBUFFEROFFSETORCOUNT,

		/// <summary/>
		D3D11_MESSAGE_ID_NEGOTIATECRPYTOSESSIONKEYEXCHANGE_INVALIDSIZE,

		/// <summary/>
		D3D11_MESSAGE_ID_NEGOTIATEAUTHENTICATEDCHANNELKEYEXCHANGE_INVALIDSIZE,

		/// <summary/>
		D3D11_MESSAGE_ID_OFFERRESOURCES_INVALIDPRIORITY,

		/// <summary/>
		D3D11_MESSAGE_ID_GETCRYPTOSESSIONHANDLE_OUTOFMEMORY,

		/// <summary/>
		D3D11_MESSAGE_ID_ACQUIREHANDLEFORCAPTURE_NULLPARAM,

		/// <summary/>
		D3D11_MESSAGE_ID_ACQUIREHANDLEFORCAPTURE_INVALIDTYPE,

		/// <summary/>
		D3D11_MESSAGE_ID_ACQUIREHANDLEFORCAPTURE_INVALIDBIND,

		/// <summary/>
		D3D11_MESSAGE_ID_ACQUIREHANDLEFORCAPTURE_INVALIDARRAY,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMROTATION_NULLPARAM,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMROTATION_INVALIDSTREAM,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMROTATION_INVALID,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMROTATION_UNSUPPORTED,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORGETSTREAMROTATION_NULLPARAM,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_CLEARVIEW_INVALIDVIEW,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_CREATEVERTEXSHADER_DOUBLEEXTENSIONSNOTSUPPORTED,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_CREATEVERTEXSHADER_SHADEREXTENSIONSNOTSUPPORTED,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_CREATEHULLSHADER_DOUBLEEXTENSIONSNOTSUPPORTED,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_CREATEHULLSHADER_SHADEREXTENSIONSNOTSUPPORTED,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_CREATEDOMAINSHADER_DOUBLEEXTENSIONSNOTSUPPORTED,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_CREATEDOMAINSHADER_SHADEREXTENSIONSNOTSUPPORTED,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_CREATEGEOMETRYSHADER_DOUBLEEXTENSIONSNOTSUPPORTED,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_CREATEGEOMETRYSHADER_SHADEREXTENSIONSNOTSUPPORTED,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_DOUBLEEXTENSIONSNOTSUPPORTED,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_SHADEREXTENSIONSNOTSUPPORTED,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_CREATEPIXELSHADER_DOUBLEEXTENSIONSNOTSUPPORTED,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_CREATEPIXELSHADER_SHADEREXTENSIONSNOTSUPPORTED,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_CREATECOMPUTESHADER_DOUBLEEXTENSIONSNOTSUPPORTED,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_CREATECOMPUTESHADER_SHADEREXTENSIONSNOTSUPPORTED,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_SHADER_LINKAGE_MINPRECISION,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMALPHA_UNSUPPORTED,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMPIXELASPECTRATIO_UNSUPPORTED,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_CREATEVERTEXSHADER_UAVSNOTSUPPORTED,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_CREATEHULLSHADER_UAVSNOTSUPPORTED,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_CREATEDOMAINSHADER_UAVSNOTSUPPORTED,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_CREATEGEOMETRYSHADER_UAVSNOTSUPPORTED,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_UAVSNOTSUPPORTED,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_CREATEPIXELSHADER_UAVSNOTSUPPORTED,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_CREATECOMPUTESHADER_UAVSNOTSUPPORTED,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_OMSETRENDERTARGETSANDUNORDEREDACCESSVIEWS_INVALIDOFFSET,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_OMSETRENDERTARGETSANDUNORDEREDACCESSVIEWS_TOOMANYVIEWS,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_CLEARVIEW_NOTSUPPORTED,

		/// <summary/>
		D3D11_MESSAGE_ID_SWAPDEVICECONTEXTSTATE_NOTSUPPORTED,

		/// <summary/>
		D3D11_MESSAGE_ID_UPDATESUBRESOURCE_PREFERUPDATESUBRESOURCE1,

		/// <summary/>
		D3D11_MESSAGE_ID_GETDC_INACCESSIBLE,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_CLEARVIEW_INVALIDRECT,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_DRAW_SAMPLE_MASK_IGNORED_ON_FL9,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_OPEN_SHARED_RESOURCE1_NOT_SUPPORTED,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_OPEN_SHARED_RESOURCE_BY_NAME_NOT_SUPPORTED,

		/// <summary/>
		D3D11_MESSAGE_ID_ENQUEUESETEVENT_NOT_SUPPORTED,

		/// <summary/>
		D3D11_MESSAGE_ID_OFFERRELEASE_NOT_SUPPORTED,

		/// <summary/>
		D3D11_MESSAGE_ID_OFFERRESOURCES_INACCESSIBLE,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEVIDEOPROCESSORINPUTVIEW_INVALIDMSAA,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEVIDEOPROCESSOROUTPUTVIEW_INVALIDMSAA,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_CLEARVIEW_INVALIDSOURCERECT,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_CLEARVIEW_EMPTYRECT,

		/// <summary/>
		D3D11_MESSAGE_ID_UPDATESUBRESOURCE_EMPTYDESTBOX,

		/// <summary/>
		D3D11_MESSAGE_ID_COPYSUBRESOURCEREGION_EMPTYSOURCEBOX,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_DRAW_OM_RENDER_TARGET_DOES_NOT_SUPPORT_LOGIC_OPS,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_DRAW_DEPTHSTENCILVIEW_NOT_SET,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_DRAW_RENDERTARGETVIEW_NOT_SET,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_DRAW_RENDERTARGETVIEW_NOT_SET_DUE_TO_FLIP_PRESENT,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_UNORDEREDACCESSVIEW_NOT_SET_DUE_TO_FLIP_PRESENT,

		/// <summary/>
		D3D11_MESSAGE_ID_GETDATAFORNEWHARDWAREKEY_NULLPARAM,

		/// <summary/>
		D3D11_MESSAGE_ID_CHECKCRYPTOSESSIONSTATUS_NULLPARAM,

		/// <summary/>
		D3D11_MESSAGE_ID_GETCRYPTOSESSIONPRIVATEDATASIZE_NULLPARAM,

		/// <summary/>
		D3D11_MESSAGE_ID_GETVIDEODECODERCAPS_NULLPARAM,

		/// <summary/>
		D3D11_MESSAGE_ID_GETVIDEODECODERCAPS_ZEROWIDTHHEIGHT,

		/// <summary/>
		D3D11_MESSAGE_ID_CHECKVIDEODECODERDOWNSAMPLING_NULLPARAM,

		/// <summary/>
		D3D11_MESSAGE_ID_CHECKVIDEODECODERDOWNSAMPLING_INVALIDCOLORSPACE,

		/// <summary/>
		D3D11_MESSAGE_ID_CHECKVIDEODECODERDOWNSAMPLING_ZEROWIDTHHEIGHT,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEODECODERENABLEDOWNSAMPLING_NULLPARAM,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEODECODERENABLEDOWNSAMPLING_UNSUPPORTED,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEODECODERUPDATEDOWNSAMPLING_NULLPARAM,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEODECODERUPDATEDOWNSAMPLING_UNSUPPORTED,

		/// <summary/>
		D3D11_MESSAGE_ID_CHECKVIDEOPROCESSORFORMATCONVERSION_NULLPARAM,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORSETOUTPUTCOLORSPACE1_NULLPARAM,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORGETOUTPUTCOLORSPACE1_NULLPARAM,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMCOLORSPACE1_NULLPARAM,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMCOLORSPACE1_INVALIDSTREAM,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMMIRROR_NULLPARAM,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMMIRROR_INVALIDSTREAM,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMMIRROR_UNSUPPORTED,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORGETSTREAMCOLORSPACE1_NULLPARAM,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORGETSTREAMMIRROR_NULLPARAM,

		/// <summary/>
		D3D11_MESSAGE_ID_RECOMMENDVIDEODECODERDOWNSAMPLING_NULLPARAM,

		/// <summary/>
		D3D11_MESSAGE_ID_RECOMMENDVIDEODECODERDOWNSAMPLING_INVALIDCOLORSPACE,

		/// <summary/>
		D3D11_MESSAGE_ID_RECOMMENDVIDEODECODERDOWNSAMPLING_ZEROWIDTHHEIGHT,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORSETOUTPUTSHADERUSAGE_NULLPARAM,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORGETOUTPUTSHADERUSAGE_NULLPARAM,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORGETBEHAVIORHINTS_NULLPARAM,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORGETBEHAVIORHINTS_INVALIDSTREAMCOUNT,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORGETBEHAVIORHINTS_TARGETRECT,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORGETBEHAVIORHINTS_INVALIDSOURCERECT,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORGETBEHAVIORHINTS_INVALIDDESTRECT,

		/// <summary/>
		D3D11_MESSAGE_ID_GETCRYPTOSESSIONPRIVATEDATASIZE_INVALID_KEY_EXCHANGE_TYPE,

		/// <summary/>
		D3D11_MESSAGE_ID_D3D11_1_MESSAGES_END,

		/// <summary/>
		D3D11_MESSAGE_ID_D3D11_2_MESSAGES_START,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEBUFFER_INVALIDUSAGE,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATETEXTURE1D_INVALIDUSAGE,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATETEXTURE2D_INVALIDUSAGE,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEINPUTLAYOUT_LEVEL9_STEPRATE_NOT_1,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEINPUTLAYOUT_LEVEL9_INSTANCING_NOT_SUPPORTED,

		/// <summary/>
		D3D11_MESSAGE_ID_UPDATETILEMAPPINGS_INVALID_PARAMETER,

		/// <summary/>
		D3D11_MESSAGE_ID_COPYTILEMAPPINGS_INVALID_PARAMETER,

		/// <summary/>
		D3D11_MESSAGE_ID_COPYTILES_INVALID_PARAMETER,

		/// <summary/>
		D3D11_MESSAGE_ID_UPDATETILES_INVALID_PARAMETER,

		/// <summary/>
		D3D11_MESSAGE_ID_RESIZETILEPOOL_INVALID_PARAMETER,

		/// <summary/>
		D3D11_MESSAGE_ID_TILEDRESOURCEBARRIER_INVALID_PARAMETER,

		/// <summary/>
		D3D11_MESSAGE_ID_NULL_TILE_MAPPING_ACCESS_WARNING,

		/// <summary/>
		D3D11_MESSAGE_ID_NULL_TILE_MAPPING_ACCESS_ERROR,

		/// <summary/>
		D3D11_MESSAGE_ID_DIRTY_TILE_MAPPING_ACCESS,

		/// <summary/>
		D3D11_MESSAGE_ID_DUPLICATE_TILE_MAPPINGS_IN_COVERED_AREA,

		/// <summary/>
		D3D11_MESSAGE_ID_TILE_MAPPINGS_IN_COVERED_AREA_DUPLICATED_OUTSIDE,

		/// <summary/>
		D3D11_MESSAGE_ID_TILE_MAPPINGS_SHARED_BETWEEN_INCOMPATIBLE_RESOURCES,

		/// <summary/>
		D3D11_MESSAGE_ID_TILE_MAPPINGS_SHARED_BETWEEN_INPUT_AND_OUTPUT,

		/// <summary/>
		D3D11_MESSAGE_ID_CHECKMULTISAMPLEQUALITYLEVELS_INVALIDFLAGS,

		/// <summary/>
		D3D11_MESSAGE_ID_GETRESOURCETILING_NONTILED_RESOURCE,

		/// <summary/>
		D3D11_MESSAGE_ID_RESIZETILEPOOL_SHRINK_WITH_MAPPINGS_STILL_DEFINED_PAST_END,

		/// <summary/>
		D3D11_MESSAGE_ID_NEED_TO_CALL_TILEDRESOURCEBARRIER,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEDEVICE_INVALIDARGS,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEDEVICE_WARNING,

		/// <summary/>
		D3D11_MESSAGE_ID_CLEARUNORDEREDACCESSVIEWUINT_HAZARD,

		/// <summary/>
		D3D11_MESSAGE_ID_CLEARUNORDEREDACCESSVIEWFLOAT_HAZARD,

		/// <summary/>
		D3D11_MESSAGE_ID_TILED_RESOURCE_TIER_1_BUFFER_TEXTURE_MISMATCH,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATE_CRYPTOSESSION,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATE_AUTHENTICATEDCHANNEL,

		/// <summary/>
		D3D11_MESSAGE_ID_LIVE_CRYPTOSESSION,

		/// <summary/>
		D3D11_MESSAGE_ID_LIVE_AUTHENTICATEDCHANNEL,

		/// <summary/>
		D3D11_MESSAGE_ID_DESTROY_CRYPTOSESSION,

		/// <summary/>
		D3D11_MESSAGE_ID_DESTROY_AUTHENTICATEDCHANNEL,

		/// <summary/>
		D3D11_MESSAGE_ID_D3D11_2_MESSAGES_END,

		/// <summary/>
		D3D11_MESSAGE_ID_D3D11_3_MESSAGES_START,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATERASTERIZERSTATE_INVALID_CONSERVATIVERASTERMODE,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_DRAW_INVALID_SYSTEMVALUE,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEQUERYORPREDICATE_INVALIDCONTEXTTYPE,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEQUERYORPREDICATE_DECODENOTSUPPORTED,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEQUERYORPREDICATE_ENCODENOTSUPPORTED,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATESHADERRESOURCEVIEW_INVALIDPLANEINDEX,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATESHADERRESOURCEVIEW_INVALIDVIDEOPLANEINDEX,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATESHADERRESOURCEVIEW_AMBIGUOUSVIDEOPLANEINDEX,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATERENDERTARGETVIEW_INVALIDPLANEINDEX,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATERENDERTARGETVIEW_INVALIDVIDEOPLANEINDEX,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATERENDERTARGETVIEW_AMBIGUOUSVIDEOPLANEINDEX,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEUNORDEREDACCESSVIEW_INVALIDPLANEINDEX,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEUNORDEREDACCESSVIEW_INVALIDVIDEOPLANEINDEX,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEUNORDEREDACCESSVIEW_AMBIGUOUSVIDEOPLANEINDEX,

		/// <summary/>
		D3D11_MESSAGE_ID_JPEGDECODE_INVALIDSCANDATAOFFSET,

		/// <summary/>
		D3D11_MESSAGE_ID_JPEGDECODE_NOTSUPPORTED,

		/// <summary/>
		D3D11_MESSAGE_ID_JPEGDECODE_DIMENSIONSTOOLARGE,

		/// <summary/>
		D3D11_MESSAGE_ID_JPEGDECODE_INVALIDCOMPONENTS,

		/// <summary/>
		D3D11_MESSAGE_ID_JPEGDECODE_DESTINATIONNOT2D,

		/// <summary/>
		D3D11_MESSAGE_ID_JPEGDECODE_TILEDRESOURCESUNSUPPORTED,

		/// <summary/>
		D3D11_MESSAGE_ID_JPEGDECODE_GUARDRECTSUNSUPPORTED,

		/// <summary/>
		D3D11_MESSAGE_ID_JPEGDECODE_FORMATUNSUPPORTED,

		/// <summary/>
		D3D11_MESSAGE_ID_JPEGDECODE_INVALIDSUBRESOURCE,

		/// <summary/>
		D3D11_MESSAGE_ID_JPEGDECODE_INVALIDMIPLEVEL,

		/// <summary/>
		D3D11_MESSAGE_ID_JPEGDECODE_EMPTYDESTBOX,

		/// <summary/>
		D3D11_MESSAGE_ID_JPEGDECODE_DESTBOXNOT2D,

		/// <summary/>
		D3D11_MESSAGE_ID_JPEGDECODE_DESTBOXNOTSUB,

		/// <summary/>
		D3D11_MESSAGE_ID_JPEGDECODE_DESTBOXESINTERSECT,

		/// <summary/>
		D3D11_MESSAGE_ID_JPEGDECODE_XSUBSAMPLEMISMATCH,

		/// <summary/>
		D3D11_MESSAGE_ID_JPEGDECODE_YSUBSAMPLEMISMATCH,

		/// <summary/>
		D3D11_MESSAGE_ID_JPEGDECODE_XSUBSAMPLEODD,

		/// <summary/>
		D3D11_MESSAGE_ID_JPEGDECODE_YSUBSAMPLEODD,

		/// <summary/>
		D3D11_MESSAGE_ID_JPEGDECODE_OUTPUTDIMENSIONSTOOLARGE,

		/// <summary/>
		D3D11_MESSAGE_ID_JPEGDECODE_NONPOW2SCALEUNSUPPORTED,

		/// <summary/>
		D3D11_MESSAGE_ID_JPEGDECODE_FRACTIONALDOWNSCALETOLARGE,

		/// <summary/>
		D3D11_MESSAGE_ID_JPEGDECODE_CHROMASIZEMISMATCH,

		/// <summary/>
		D3D11_MESSAGE_ID_JPEGDECODE_LUMACHROMASIZEMISMATCH,

		/// <summary/>
		D3D11_MESSAGE_ID_JPEGDECODE_INVALIDNUMDESTINATIONS,

		/// <summary/>
		D3D11_MESSAGE_ID_JPEGDECODE_SUBBOXUNSUPPORTED,

		/// <summary/>
		D3D11_MESSAGE_ID_JPEGDECODE_1DESTUNSUPPORTEDFORMAT,

		/// <summary/>
		D3D11_MESSAGE_ID_JPEGDECODE_3DESTUNSUPPORTEDFORMAT,

		/// <summary/>
		D3D11_MESSAGE_ID_JPEGDECODE_SCALEUNSUPPORTED,

		/// <summary/>
		D3D11_MESSAGE_ID_JPEGDECODE_INVALIDSOURCESIZE,

		/// <summary/>
		D3D11_MESSAGE_ID_JPEGDECODE_INVALIDCOPYFLAGS,

		/// <summary/>
		D3D11_MESSAGE_ID_JPEGDECODE_HAZARD,

		/// <summary/>
		D3D11_MESSAGE_ID_JPEGDECODE_UNSUPPORTEDSRCBUFFERUSAGE,

		/// <summary/>
		D3D11_MESSAGE_ID_JPEGDECODE_UNSUPPORTEDSRCBUFFERMISCFLAGS,

		/// <summary/>
		D3D11_MESSAGE_ID_JPEGDECODE_UNSUPPORTEDDSTTEXTUREUSAGE,

		/// <summary/>
		D3D11_MESSAGE_ID_JPEGDECODE_BACKBUFFERNOTSUPPORTED,

		/// <summary/>
		D3D11_MESSAGE_ID_JPEGDECODE_UNSUPPRTEDCOPYFLAGS,

		/// <summary/>
		D3D11_MESSAGE_ID_JPEGENCODE_NOTSUPPORTED,

		/// <summary/>
		D3D11_MESSAGE_ID_JPEGENCODE_INVALIDSCANDATAOFFSET,

		/// <summary/>
		D3D11_MESSAGE_ID_JPEGENCODE_INVALIDCOMPONENTS,

		/// <summary/>
		D3D11_MESSAGE_ID_JPEGENCODE_SOURCENOT2D,

		/// <summary/>
		D3D11_MESSAGE_ID_JPEGENCODE_TILEDRESOURCESUNSUPPORTED,

		/// <summary/>
		D3D11_MESSAGE_ID_JPEGENCODE_GUARDRECTSUNSUPPORTED,

		/// <summary/>
		D3D11_MESSAGE_ID_JPEGENCODE_XSUBSAMPLEMISMATCH,

		/// <summary/>
		D3D11_MESSAGE_ID_JPEGENCODE_YSUBSAMPLEMISMATCH,

		/// <summary/>
		D3D11_MESSAGE_ID_JPEGENCODE_FORMATUNSUPPORTED,

		/// <summary/>
		D3D11_MESSAGE_ID_JPEGENCODE_INVALIDSUBRESOURCE,

		/// <summary/>
		D3D11_MESSAGE_ID_JPEGENCODE_INVALIDMIPLEVEL,

		/// <summary/>
		D3D11_MESSAGE_ID_JPEGENCODE_DIMENSIONSTOOLARGE,

		/// <summary/>
		D3D11_MESSAGE_ID_JPEGENCODE_HAZARD,

		/// <summary/>
		D3D11_MESSAGE_ID_JPEGENCODE_UNSUPPORTEDDSTBUFFERUSAGE,

		/// <summary/>
		D3D11_MESSAGE_ID_JPEGENCODE_UNSUPPORTEDDSTBUFFERMISCFLAGS,

		/// <summary/>
		D3D11_MESSAGE_ID_JPEGENCODE_UNSUPPORTEDSRCTEXTUREUSAGE,

		/// <summary/>
		D3D11_MESSAGE_ID_JPEGENCODE_BACKBUFFERNOTSUPPORTED,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEQUERYORPREDICATE_UNSUPPORTEDCONTEXTTTYPEFORQUERY,

		/// <summary/>
		D3D11_MESSAGE_ID_FLUSH1_INVALIDCONTEXTTYPE,

		/// <summary/>
		D3D11_MESSAGE_ID_DEVICE_SETHARDWAREPROTECTION_INVALIDCONTEXT,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORSETOUTPUTHDRMETADATA_NULLPARAM,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORSETOUTPUTHDRMETADATA_INVALIDSIZE,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORGETOUTPUTHDRMETADATA_NULLPARAM,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORGETOUTPUTHDRMETADATA_INVALIDSIZE,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMHDRMETADATA_NULLPARAM,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMHDRMETADATA_INVALIDSTREAM,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMHDRMETADATA_INVALIDSIZE,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORGETSTREAMHDRMETADATA_NULLPARAM,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORGETSTREAMHDRMETADATA_INVALIDSTREAM,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORGETSTREAMHDRMETADATA_INVALIDSIZE,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORGETSTREAMFRAMEFORMAT_INVALIDSTREAM,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORGETSTREAMCOLORSPACE_INVALIDSTREAM,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORGETSTREAMOUTPUTRATE_INVALIDSTREAM,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORGETSTREAMSOURCERECT_INVALIDSTREAM,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORGETSTREAMDESTRECT_INVALIDSTREAM,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORGETSTREAMALPHA_INVALIDSTREAM,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORGETSTREAMPALETTE_INVALIDSTREAM,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORGETSTREAMPIXELASPECTRATIO_INVALIDSTREAM,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORGETSTREAMLUMAKEY_INVALIDSTREAM,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORGETSTREAMSTEREOFORMAT_INVALIDSTREAM,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORGETSTREAMAUTOPROCESSINGMODE_INVALIDSTREAM,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORGETSTREAMFILTER_INVALIDSTREAM,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORGETSTREAMROTATION_INVALIDSTREAM,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORGETSTREAMCOLORSPACE1_INVALIDSTREAM,

		/// <summary/>
		D3D11_MESSAGE_ID_VIDEOPROCESSORGETSTREAMMIRROR_INVALIDSTREAM,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATE_FENCE,

		/// <summary/>
		D3D11_MESSAGE_ID_LIVE_FENCE,

		/// <summary/>
		D3D11_MESSAGE_ID_DESTROY_FENCE,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATE_SYNCHRONIZEDCHANNEL,

		/// <summary/>
		D3D11_MESSAGE_ID_LIVE_SYNCHRONIZEDCHANNEL,

		/// <summary/>
		D3D11_MESSAGE_ID_DESTROY_SYNCHRONIZEDCHANNEL,

		/// <summary/>
		D3D11_MESSAGE_ID_CREATEFENCE_INVALIDFLAGS,

		/// <summary/>
		D3D11_MESSAGE_ID_D3D11_3_MESSAGES_END,

		/// <summary/>
		D3D11_MESSAGE_ID_D3D11_5_MESSAGES_START,

		/// <summary/>
		D3D11_MESSAGE_ID_NEGOTIATECRYPTOSESSIONKEYEXCHANGEMT_INVALIDKEYEXCHANGETYPE,

		/// <summary/>
		D3D11_MESSAGE_ID_NEGOTIATECRYPTOSESSIONKEYEXCHANGEMT_NOT_SUPPORTED,

		/// <summary/>
		D3D11_MESSAGE_ID_DECODERBEGINFRAME_INVALID_HISTOGRAM_COMPONENT_COUNT,

		/// <summary/>
		D3D11_MESSAGE_ID_DECODERBEGINFRAME_INVALID_HISTOGRAM_COMPONENT,

		/// <summary/>
		D3D11_MESSAGE_ID_DECODERBEGINFRAME_INVALID_HISTOGRAM_BUFFER_SIZE,

		/// <summary/>
		D3D11_MESSAGE_ID_DECODERBEGINFRAME_INVALID_HISTOGRAM_BUFFER_USAGE,

		/// <summary/>
		D3D11_MESSAGE_ID_DECODERBEGINFRAME_INVALID_HISTOGRAM_BUFFER_MISC_FLAGS,

		/// <summary/>
		D3D11_MESSAGE_ID_DECODERBEGINFRAME_INVALID_HISTOGRAM_BUFFER_OFFSET,

		/// <summary/>
		D3D11_MESSAGE_ID_D3D11_5_MESSAGES_END,
	}

	/// <summary>Debug message severity levels for an information queue.</summary>
	/// <remarks>
	/// Use these values to allow or deny message categories to pass through the storage and retrieval filters for an information queue (see
	/// D3D11_INFO_QUEUE_FILTER). This API is used by ID3D11InfoQueue::AddApplicationMessage.
	/// </remarks>
	// https://learn.microsoft.com/en-us/windows/win32/api/d3d11sdklayers/ne-d3d11sdklayers-d3d11_message_severity typedef enum
	// D3D11_MESSAGE_SEVERITY { D3D11_MESSAGE_SEVERITY_CORRUPTION = 0, D3D11_MESSAGE_SEVERITY_ERROR, D3D11_MESSAGE_SEVERITY_WARNING,
	// D3D11_MESSAGE_SEVERITY_INFO, D3D11_MESSAGE_SEVERITY_MESSAGE } ;
	[PInvokeData("d3d11sdklayers.h", MSDNShortId = "NE:d3d11sdklayers.D3D11_MESSAGE_SEVERITY")]
	public enum D3D11_MESSAGE_SEVERITY
	{
		/// <summary>
		/// <para>Value:</para>
		/// <para>0</para>
		/// <para>Defines some type of corruption which has occurred.</para>
		/// </summary>
		D3D11_MESSAGE_SEVERITY_CORRUPTION = 0,

		/// <summary>Defines an error message.</summary>
		D3D11_MESSAGE_SEVERITY_ERROR,

		/// <summary>Defines a warning message.</summary>
		D3D11_MESSAGE_SEVERITY_WARNING,

		/// <summary>Defines an information message.</summary>
		D3D11_MESSAGE_SEVERITY_INFO,

		/// <summary>
		/// <para>Defines a message other than corruption, error, warning, or information.</para>
		/// <para>Direct3D 11:  </para>
		/// <para>This value is not supported until Direct3D 11.1.</para>
		/// </summary>
		D3D11_MESSAGE_SEVERITY_MESSAGE,
	}

	/// <summary>Options for the amount of information to report about a device object's lifetime.</summary>
	/// <remarks>
	/// <para>This enumeration is used by ID3D11Debug::ReportLiveDeviceObjects.</para>
	/// <para>Several inline functions exist to combine the options using operators, see the D3D11SDKLayers.h header file for details.</para>
	/// </remarks>
	// https://learn.microsoft.com/en-us/windows/win32/api/d3d11sdklayers/ne-d3d11sdklayers-d3d11_rldo_flags typedef enum D3D11_RLDO_FLAGS {
	// D3D11_RLDO_SUMMARY = 0x1, D3D11_RLDO_DETAIL = 0x2, D3D11_RLDO_IGNORE_INTERNAL = 0x4 } ;
	[PInvokeData("d3d11sdklayers.h", MSDNShortId = "NE:d3d11sdklayers.D3D11_RLDO_FLAGS")]
	[Flags]
	public enum D3D11_RLDO_FLAGS
	{
		/// <summary>
		/// <para>Value:</para>
		/// <para>0x1</para>
		/// <para>Specifies to obtain a summary about a device object's lifetime.</para>
		/// </summary>
		D3D11_RLDO_SUMMARY = 0x1,

		/// <summary>
		/// <para>Value:</para>
		/// <para>0x2</para>
		/// <para>Specifies to obtain detailed information about a device object's lifetime.</para>
		/// </summary>
		D3D11_RLDO_DETAIL = 0x2,

		/// <summary>
		/// <para>Value:</para>
		/// <para>0x4</para>
		/// <para>
		/// This flag indicates to ignore objects which have no external refcounts keeping them alive. D3D objects are printed using an
		/// external refcount and an internal refcount. Typically, all objects are printed. This flag means ignore the objects whose
		/// external refcount is 0, because the application is not responsible for keeping them alive.
		/// </para>
		/// </summary>
		D3D11_RLDO_IGNORE_INTERNAL = 0x4,
	}

	/// <summary>Options that specify how to perform shader debug tracking.</summary>
	/// <remarks>
	/// <para>This enumeration is used by the following methods:</para>
	/// <list type="bullet">
	/// <item>
	/// <description>ID3D11RefDefaultTrackingOptions::SetTrackingOptions</description>
	/// </item>
	/// <item>
	/// <description>ID3D11RefTrackingOptions::SetTrackingOptions</description>
	/// </item>
	/// <item>
	/// <description>ID3D11TracingDevice::SetShaderTrackingOptions</description>
	/// </item>
	/// <item>
	/// <description>ID3D11TracingDevice::SetShaderTrackingOptionsByType</description>
	/// </item>
	/// </list>
	/// <para><c>Note</c>  This API requires the Windows Software Development Kit (SDK) for Windows 8.</para>
	/// <para></para>
	/// </remarks>
	// https://learn.microsoft.com/en-us/windows/win32/api/d3d11sdklayers/ne-d3d11sdklayers-d3d11_shader_tracking_options typedef enum
	// D3D11_SHADER_TRACKING_OPTION { D3D11_SHADER_TRACKING_OPTION_IGNORE = 0, D3D11_SHADER_TRACKING_OPTION_TRACK_UNINITIALIZED = 0x1,
	// D3D11_SHADER_TRACKING_OPTION_TRACK_RAW = 0x2, D3D11_SHADER_TRACKING_OPTION_TRACK_WAR = 0x4, D3D11_SHADER_TRACKING_OPTION_TRACK_WAW =
	// 0x8, D3D11_SHADER_TRACKING_OPTION_ALLOW_SAME = 0x10, D3D11_SHADER_TRACKING_OPTION_TRACK_ATOMIC_CONSISTENCY = 0x20,
	// D3D11_SHADER_TRACKING_OPTION_TRACK_RAW_ACROSS_THREADGROUPS = 0x40, D3D11_SHADER_TRACKING_OPTION_TRACK_WAR_ACROSS_THREADGROUPS = 0x80,
	// D3D11_SHADER_TRACKING_OPTION_TRACK_WAW_ACROSS_THREADGROUPS = 0x100,
	// D3D11_SHADER_TRACKING_OPTION_TRACK_ATOMIC_CONSISTENCY_ACROSS_THREADGROUPS = 0x200, D3D11_SHADER_TRACKING_OPTION_UAV_SPECIFIC_FLAGS,
	// D3D11_SHADER_TRACKING_OPTION_ALL_HAZARDS, D3D11_SHADER_TRACKING_OPTION_ALL_HAZARDS_ALLOWING_SAME,
	// D3D11_SHADER_TRACKING_OPTION_ALL_OPTIONS } D3D11_SHADER_TRACKING_OPTIONS;
	[PInvokeData("d3d11sdklayers.h", MSDNShortId = "NE:d3d11sdklayers.D3D11_SHADER_TRACKING_OPTION")]
	[Flags]
	public enum D3D11_SHADER_TRACKING_OPTION
	{
		/// <summary>
		/// <para>Value:</para>
		/// <para>0</para>
		/// <para>No debug tracking is performed.</para>
		/// </summary>
		D3D11_SHADER_TRACKING_OPTION_IGNORE = 0x0,

		/// <summary>
		/// <para>Value:</para>
		/// <para>0x1</para>
		/// <para>Track the reading of uninitialized data.</para>
		/// </summary>
		D3D11_SHADER_TRACKING_OPTION_TRACK_UNINITIALIZED = 0x1,

		/// <summary>
		/// <para>Value:</para>
		/// <para>0x2</para>
		/// <para>Track read-after-write hazards.</para>
		/// </summary>
		D3D11_SHADER_TRACKING_OPTION_TRACK_RAW = 0x2,

		/// <summary>
		/// <para>Value:</para>
		/// <para>0x4</para>
		/// <para>Track write-after-read hazards.</para>
		/// </summary>
		D3D11_SHADER_TRACKING_OPTION_TRACK_WAR = 0x4,

		/// <summary>
		/// <para>Value:</para>
		/// <para>0x8</para>
		/// <para>Track write-after-write hazards.</para>
		/// </summary>
		D3D11_SHADER_TRACKING_OPTION_TRACK_WAW = 0x8,

		/// <summary>
		/// <para>Value:</para>
		/// <para>0x10</para>
		/// <para>Track that hazards are allowed in which data is written but the value does not change.</para>
		/// </summary>
		D3D11_SHADER_TRACKING_OPTION_ALLOW_SAME = 0x10,

		/// <summary>
		/// <para>Value:</para>
		/// <para>0x20</para>
		/// <para>Track that only one type of atomic operation is used on an address.</para>
		/// </summary>
		D3D11_SHADER_TRACKING_OPTION_TRACK_ATOMIC_CONSISTENCY = 0x20,

		/// <summary>
		/// <para>Value:</para>
		/// <para>0x40</para>
		/// <para>Track read-after-write hazards across thread groups.</para>
		/// </summary>
		D3D11_SHADER_TRACKING_OPTION_TRACK_RAW_ACROSS_THREADGROUPS = 0x40,

		/// <summary>
		/// <para>Value:</para>
		/// <para>0x80</para>
		/// <para>Track write-after-read hazards across thread groups.</para>
		/// </summary>
		D3D11_SHADER_TRACKING_OPTION_TRACK_WAR_ACROSS_THREADGROUPS = 0x80,

		/// <summary>
		/// <para>Value:</para>
		/// <para>0x100</para>
		/// <para>Track write-after-write hazards across thread groups.</para>
		/// </summary>
		D3D11_SHADER_TRACKING_OPTION_TRACK_WAW_ACROSS_THREADGROUPS = 0x100,

		/// <summary>
		/// <para>Value:</para>
		/// <para>0x200</para>
		/// <para>Track that only one type of atomic operation is used on an address across thread groups.</para>
		/// </summary>
		D3D11_SHADER_TRACKING_OPTION_TRACK_ATOMIC_CONSISTENCY_ACROSS_THREADGROUPS = 0x200,

		/// <summary>Track hazards that are specific to unordered access views (UAVs).</summary>
		D3D11_SHADER_TRACKING_OPTION_UAV_SPECIFIC_FLAGS = D3D11_SHADER_TRACKING_OPTION_TRACK_RAW_ACROSS_THREADGROUPS | D3D11_SHADER_TRACKING_OPTION_TRACK_WAR_ACROSS_THREADGROUPS | D3D11_SHADER_TRACKING_OPTION_TRACK_WAW_ACROSS_THREADGROUPS | D3D11_SHADER_TRACKING_OPTION_TRACK_ATOMIC_CONSISTENCY_ACROSS_THREADGROUPS,

		/// <summary>Track all hazards.</summary>
		D3D11_SHADER_TRACKING_OPTION_ALL_HAZARDS = D3D11_SHADER_TRACKING_OPTION_TRACK_RAW | D3D11_SHADER_TRACKING_OPTION_TRACK_WAR | D3D11_SHADER_TRACKING_OPTION_TRACK_WAW | D3D11_SHADER_TRACKING_OPTION_TRACK_ATOMIC_CONSISTENCY | D3D11_SHADER_TRACKING_OPTION_TRACK_RAW_ACROSS_THREADGROUPS | D3D11_SHADER_TRACKING_OPTION_TRACK_WAR_ACROSS_THREADGROUPS | D3D11_SHADER_TRACKING_OPTION_TRACK_WAW_ACROSS_THREADGROUPS | D3D11_SHADER_TRACKING_OPTION_TRACK_ATOMIC_CONSISTENCY_ACROSS_THREADGROUPS,

		/// <summary>Track all hazards and track that hazards are allowed in which data is written but the value does not change.</summary>
		D3D11_SHADER_TRACKING_OPTION_ALL_HAZARDS_ALLOWING_SAME = D3D11_SHADER_TRACKING_OPTION_ALL_HAZARDS | D3D11_SHADER_TRACKING_OPTION_ALLOW_SAME,

		/// <summary>All of the preceding tracking options are set except D3D11_SHADER_TRACKING_OPTION_IGNORE.</summary>
		D3D11_SHADER_TRACKING_OPTION_ALL_OPTIONS = D3D11_SHADER_TRACKING_OPTION_ALL_HAZARDS_ALLOWING_SAME | D3D11_SHADER_TRACKING_OPTION_TRACK_UNINITIALIZED,
	}

	/// <summary>Indicates which resource types to track.</summary>
	/// <remarks>
	/// <para>
	/// The ID3D11TracingDevice::SetShaderTrackingOptionsByType or ID3D11RefDefaultTrackingOptions::SetTrackingOptions method tracks a
	/// specific type of resource.
	/// </para>
	/// <para><c>Note</c>  This API requires the Windows Software Development Kit (SDK) for Windows 8.</para>
	/// <para></para>
	/// </remarks>
	// https://learn.microsoft.com/en-us/windows/win32/api/d3d11sdklayers/ne-d3d11sdklayers-d3d11_shader_tracking_resource_type typedef enum
	// D3D11_SHADER_TRACKING_RESOURCE_TYPE { D3D11_SHADER_TRACKING_RESOURCE_TYPE_NONE = 0,
	// D3D11_SHADER_TRACKING_RESOURCE_TYPE_UAV_DEVICEMEMORY = 1, D3D11_SHADER_TRACKING_RESOURCE_TYPE_NON_UAV_DEVICEMEMORY = 2,
	// D3D11_SHADER_TRACKING_RESOURCE_TYPE_ALL_DEVICEMEMORY = 3, D3D11_SHADER_TRACKING_RESOURCE_TYPE_GROUPSHARED_MEMORY = 4,
	// D3D11_SHADER_TRACKING_RESOURCE_TYPE_ALL_SHARED_MEMORY = 5, D3D11_SHADER_TRACKING_RESOURCE_TYPE_GROUPSHARED_NON_UAV = 6,
	// D3D11_SHADER_TRACKING_RESOURCE_TYPE_ALL = 7 } ;
	[PInvokeData("d3d11sdklayers.h", MSDNShortId = "NE:d3d11sdklayers.D3D11_SHADER_TRACKING_RESOURCE_TYPE")]
	public enum D3D11_SHADER_TRACKING_RESOURCE_TYPE
	{
		/// <summary>
		/// <para>Value:</para>
		/// <para>0</para>
		/// <para>No resource types are tracked.</para>
		/// </summary>
		D3D11_SHADER_TRACKING_RESOURCE_TYPE_NONE,

		/// <summary>
		/// <para>Value:</para>
		/// <para>1</para>
		/// <para>Track device memory that is created with unordered access view (UAV) bind flags.</para>
		/// </summary>
		D3D11_SHADER_TRACKING_RESOURCE_TYPE_UAV_DEVICEMEMORY,

		/// <summary>
		/// <para>Value:</para>
		/// <para>2</para>
		/// <para>Track device memory that is created without UAV bind flags.</para>
		/// </summary>
		D3D11_SHADER_TRACKING_RESOURCE_TYPE_NON_UAV_DEVICEMEMORY,

		/// <summary>
		/// <para>Value:</para>
		/// <para>3</para>
		/// <para>Track all device memory.</para>
		/// </summary>
		D3D11_SHADER_TRACKING_RESOURCE_TYPE_ALL_DEVICEMEMORY,

		/// <summary>
		/// <para>Value:</para>
		/// <para>4</para>
		/// <para>Track all shaders that use group shared memory.</para>
		/// </summary>
		D3D11_SHADER_TRACKING_RESOURCE_TYPE_GROUPSHARED_MEMORY,

		/// <summary>
		/// <para>Value:</para>
		/// <para>5</para>
		/// <para>Track all device memory except device memory that is created without UAV bind flags.</para>
		/// </summary>
		D3D11_SHADER_TRACKING_RESOURCE_TYPE_ALL_SHARED_MEMORY,

		/// <summary>
		/// <para>Value:</para>
		/// <para>6</para>
		/// <para>Track all device memory except device memory that is created with UAV bind flags.</para>
		/// </summary>
		D3D11_SHADER_TRACKING_RESOURCE_TYPE_GROUPSHARED_NON_UAV,

		/// <summary>
		/// <para>Value:</para>
		/// <para>7</para>
		/// <para>Track all memory on the device.</para>
		/// </summary>
		D3D11_SHADER_TRACKING_RESOURCE_TYPE_ALL,
	}

	/// <summary>
	/// A debug interface controls debug settings, validates pipeline state and can only be used if the debug layer is turned on.
	/// </summary>
	/// <remarks>
	/// <para>This interface is obtained by querying it from the ID3D11Device using IUnknown::QueryInterface.</para>
	/// <para>For more information about the debug layer, see Debug Layer.</para>
	/// <para><c>Windows Phone 8:</c> This API is supported.</para>
	/// </remarks>
	// https://learn.microsoft.com/en-us/windows/win32/api/d3d11sdklayers/nn-d3d11sdklayers-id3d11debug
	[PInvokeData("d3d11sdklayers.h", MSDNShortId = "NN:d3d11sdklayers.ID3D11Debug")]
	[ComImport, Guid("79cf2233-7536-4948-9d36-1e4692dc5760"), InterfaceType(ComInterfaceType.InterfaceIsIUnknown)]
	public interface ID3D11Debug
	{
		/// <summary>Set a bit field of flags that will turn debug features on and off.</summary>
		/// <param name="Mask">
		/// <para>Type: <c>UINT</c></para>
		/// <para>
		/// A combination of feature-mask flags that are combined by using a bitwise OR operation. If a flag is present, that feature will
		/// be set to on, otherwise the feature will be set to off. For descriptions of the feature-mask flags, see Remarks.
		/// </para>
		/// </param>
		/// <returns>
		/// <para>Type: <c>HRESULT</c></para>
		/// <para>This method returns one of the Direct3D 11 Return Codes.</para>
		/// </returns>
		/// <remarks>
		/// <para><c>Note</c>  If you call this API in a Session 0 process, it returns DXGI_ERROR_NOT_CURRENTLY_AVAILABLE.</para>
		/// <para></para>
		/// <para>
		/// Setting one of the following feature-mask flags will cause a rendering-operation method (listed below) to do some extra task
		/// when called.
		/// </para>
		/// <list type="table">
		/// <listheader>
		/// <description>D3D11_DEBUG_FEATURE_FINISH_PER_RENDER_OP (0x2)</description>
		/// <description>Application will wait for the GPU to finish processing the rendering operation before continuing.</description>
		/// </listheader>
		/// <item>
		/// <description>D3D11_DEBUG_FEATURE_FLUSH_PER_RENDER_OP (0x1)</description>
		/// <description>Runtime will additionally call ID3D11DeviceContext::Flush.</description>
		/// </item>
		/// <item>
		/// <description>D3D11_DEBUG_FEATURE_PRESENT_PER_RENDER_OP (0x4)</description>
		/// <description>
		/// Runtime will call IDXGISwapChain::Present. Presentation of render buffers will occur according to the settings established by
		/// prior calls to ID3D11Debug::SetSwapChain and ID3D11Debug::SetPresentPerRenderOpDelay.
		/// </description>
		/// </item>
		/// </list>
		/// <para></para>
		/// <para>These feature-mask flags apply to the following rendering-operation methods:</para>
		/// <list type="bullet">
		/// <item>
		/// <description>ID3D11DeviceContext::Draw</description>
		/// </item>
		/// <item>
		/// <description>ID3D11DeviceContext::DrawIndexed</description>
		/// </item>
		/// <item>
		/// <description>ID3D11DeviceContext::DrawInstanced</description>
		/// </item>
		/// <item>
		/// <description>ID3D11DeviceContext::DrawIndexedInstanced</description>
		/// </item>
		/// <item>
		/// <description>ID3D11DeviceContext::DrawAuto</description>
		/// </item>
		/// <item>
		/// <description>ID3D11DeviceContext::ClearRenderTargetView</description>
		/// </item>
		/// <item>
		/// <description>ID3D11DeviceContext::ClearDepthStencilView</description>
		/// </item>
		/// <item>
		/// <description>ID3D11DeviceContext::CopySubresourceRegion</description>
		/// </item>
		/// <item>
		/// <description>ID3D11DeviceContext::CopyResource</description>
		/// </item>
		/// <item>
		/// <description>ID3D11DeviceContext::UpdateSubresource</description>
		/// </item>
		/// <item>
		/// <description>ID3D11DeviceContext::GenerateMips</description>
		/// </item>
		/// <item>
		/// <description>ID3D11DeviceContext::ResolveSubresource</description>
		/// </item>
		/// </list>
		/// <para>
		/// By setting one of the following feature-mask flags, you can control the behavior of the IDXGIDevice2::OfferResources and
		/// IDXGIDevice2::ReclaimResources methods to aid in testing and debugging.
		/// </para>
		/// <note>These flags are supported by the Direct3D 11.1 runtime, which is available starting with Windows 8.</note>
		/// <list type="table">
		/// <item>
		/// <description>D3D11_DEBUG_FEATURE_ALWAYS_DISCARD_OFFERED_RESOURCE (0x8)</description>
		/// <description>
		/// When you call IDXGIDevice2::OfferResources to offer resources while this flag is enabled, their content is always discarded. Use
		/// this flag to test code paths that regenerate resource content on reclaim. You cannot use this flag in combination with D3D11_DEBUG_FEATURE_NEVER_DISCARD_OFFERED_RESOURCE.
		/// </description>
		/// </item>
		/// <item>
		/// <description>D3D11_DEBUG_FEATURE_NEVER_DISCARD_OFFERED_RESOURCE (0x10)</description>
		/// <description>
		/// When you call IDXGIDevice2::OfferResources to offer resources while this flag is enabled, their content is never discarded. Use
		/// this flag to test code paths that do not need to regenerate resource content on reclaim. You cannot use this flag in combination
		/// with D3D11_DEBUG_FEATURE_ALWAYS_DISCARD_OFFERED_RESOURCE.
		/// </description>
		/// </item>
		/// </list>
		/// <para>
		/// The behavior of the IDXGIDevice2::OfferResources and IDXGIDevice2::ReclaimResources methods depends on system-wide memory
		/// pressure. Therefore, the scenario where content is lost and must be regenerated is uncommon for most applications. The preceding
		/// new options in the Direct3D debug layer let you simulate that scenario consistently and test code paths.
		/// </para>
		/// <para>The following flag is supported by the Direct3D 11.1 runtime.</para>
		/// <list type="table">
		/// <listheader>
		/// <description>D3D11_DEBUG_FEATURE_AVOID_BEHAVIOR_CHANGING_DEBUG_AIDS (0x40)</description>
		/// <description>Disables the following default debugging behavior.</description>
		/// </listheader>
		/// </list>
		/// <para></para>
		/// <para>
		/// When the debug layer is enabled, it performs certain actions to reveal application problems. By setting the
		/// D3D11_DEBUG_FEATURE_AVOID_BEHAVIOR_CHANGING_DEBUG_AIDS feature-mask flag, you can enable the debug layer without getting the
		/// following default debugging behavior:
		/// </para>
		/// <list type="bullet">
		/// <item>
		/// <description>
		/// If an application calls ID3D11DeviceContext1::DiscardView, the runtime fills in the resource with a random color.
		/// </description>
		/// </item>
		/// <item>
		/// <description>
		/// If an application calls IDXGISwapChain1::Present1 with partial presentation parameters, the runtime ignores the partial
		/// presentation information.
		/// </description>
		/// </item>
		/// </list>
		/// <para>The following flag is supported by the Direct3D 11.2 runtime.</para>
		/// <list type="table">
		/// <listheader>
		/// <description>D3D11_DEBUG_FEATURE_DISABLE_TILED_RESOURCE_MAPPING_TRACKING_AND_VALIDATION (0x80)</description>
		/// <description>Disables the following default debugging behavior.</description>
		/// </listheader>
		/// </list>
		/// <para></para>
		/// <para>
		/// By default (that is, without D3D11_DEBUG_FEATURE_DISABLE_TILED_RESOURCE_MAPPING_TRACKING_AND_VALIDATION set), the debug layer
		/// validates the proper usage of all tile mappings for tiled resources for bound resources for every operation performed on the
		/// device context (for example, draw, copy, and so on). Depending on the size of the tiled resources used (if any), this validation
		/// can be processor intensive and slow. Apps might want to initially run with tiled resource tile mapping validation on; then, when
		/// they determine that the calling pattern is safe, they can disable the validation by setting D3D11_DEBUG_FEATURE_DISABLE_TILED_RESOURCE_MAPPING_TRACKING_AND_VALIDATION.
		/// </para>
		/// <para>
		/// If D3D11_DEBUG_FEATURE_DISABLE_TILED_RESOURCE_MAPPING_TRACKING_AND_VALIDATION is set when a tiled resource is created, the debug
		/// layer never performs the tracking of tile mapping for that resource for its entire lifetime. Alternatively, if
		/// D3D11_DEBUG_FEATURE_DISABLE_TILED_RESOURCE_MAPPING_TRACKING_AND_VALIDATION is set for any given device context method call (like
		/// draw or copy calls) involving tiled resources, the debug layer skips all tile mapping validation for the call.
		/// </para>
		/// </remarks>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d11sdklayers/nf-d3d11sdklayers-id3d11debug-setfeaturemask HRESULT
		// SetFeatureMask( UINT Mask );
		[PreserveSig]
		HRESULT SetFeatureMask(D3D11_DEBUG_FEATURE Mask);

		/// <summary>Get a bitfield of flags that indicates which debug features are on or off.</summary>
		/// <returns>
		/// <para>Type: <c>UINT</c></para>
		/// <para>
		/// Mask of feature-mask flags bitwise ORed together. If a flag is present, then that feature will be set to on, otherwise the
		/// feature will be set to off. See ID3D11Debug::SetFeatureMask for a list of possible feature-mask flags.
		/// </para>
		/// </returns>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d11sdklayers/nf-d3d11sdklayers-id3d11debug-getfeaturemask UINT GetFeatureMask();
		[PreserveSig]
		D3D11_DEBUG_FEATURE GetFeatureMask();

		/// <summary>Set the number of milliseconds to sleep after IDXGISwapChain::Present is called.</summary>
		/// <param name="Milliseconds">
		/// <para>Type: <c>UINT</c></para>
		/// <para>Number of milliseconds to sleep after Present is called.</para>
		/// </param>
		/// <returns>
		/// <para>Type: <c>HRESULT</c></para>
		/// <para>This method returns one of the following Direct3D 11 Return Codes.</para>
		/// </returns>
		/// <remarks>
		/// <para><c>Note</c>  If you call this API in a Session 0 process, it returns DXGI_ERROR_NOT_CURRENTLY_AVAILABLE.</para>
		/// <para></para>
		/// <para>
		/// The application will only sleep if D3D11_DEBUG_FEATURE_PRESENT_PER_RENDER_OP is a set in the feature mask. If that flag is not
		/// set the number of milliseconds is set but ignored and the application does not sleep. 10ms is used as a default value if this
		/// method is never called.
		/// </para>
		/// </remarks>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d11sdklayers/nf-d3d11sdklayers-id3d11debug-setpresentperrenderopdelay
		// HRESULT SetPresentPerRenderOpDelay( UINT Milliseconds );
		[PreserveSig]
		HRESULT SetPresentPerRenderOpDelay(uint Milliseconds);

		/// <summary>Get the number of milliseconds to sleep after IDXGISwapChain::Present is called.</summary>
		/// <returns>
		/// <para>Type: <c>UINT</c></para>
		/// <para>Number of milliseconds to sleep after Present is called.</para>
		/// </returns>
		/// <remarks>Value is set with ID3D11Debug::SetPresentPerRenderOpDelay.</remarks>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d11sdklayers/nf-d3d11sdklayers-id3d11debug-getpresentperrenderopdelay UINT GetPresentPerRenderOpDelay();
		[PreserveSig]
		uint GetPresentPerRenderOpDelay();

		/// <summary>Sets a swap chain that the runtime will use for automatically calling IDXGISwapChain::Present.</summary>
		/// <param name="pSwapChain">
		/// <para>Type: <c>IDXGISwapChain*</c></para>
		/// <para>
		/// Swap chain that the runtime will use for automatically calling IDXGISwapChain::Present; must have been created with the
		/// DXGI_SWAP_EFFECT_SEQUENTIAL swap-effect flag.
		/// </para>
		/// </param>
		/// <returns>
		/// <para>Type: <c>HRESULT</c></para>
		/// <para>This method returns one of the following Direct3D 11 Return Codes.</para>
		/// </returns>
		/// <remarks>
		/// <para><c>Note</c>  If you call this API in a Session 0 process, it returns DXGI_ERROR_NOT_CURRENTLY_AVAILABLE.</para>
		/// <para></para>
		/// <para>
		/// The swap chain set by this method will only be used if D3D11_DEBUG_FEATURE_PRESENT_PER_RENDER_OP is set in the feature mask.
		/// </para>
		/// </remarks>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d11sdklayers/nf-d3d11sdklayers-id3d11debug-setswapchain HRESULT
		// SetSwapChain( [in, optional] IDXGISwapChain *pSwapChain );
		[PreserveSig]
		HRESULT SetSwapChain([In, Optional] IDXGISwapChain? pSwapChain);

		/// <summary>Get the swap chain that the runtime will use for automatically calling IDXGISwapChain::Present.</summary>
		/// <param name="ppSwapChain">
		/// <para>Type: <c>IDXGISwapChain**</c></para>
		/// <para>Swap chain that the runtime will use for automatically calling IDXGISwapChain::Present.</para>
		/// </param>
		/// <returns>
		/// <para>Type: <c>HRESULT</c></para>
		/// <para>This method returns one of the following Direct3D 11 Return Codes.</para>
		/// </returns>
		/// <remarks>
		/// The swap chain retrieved by this method will only be used if D3D11_DEBUG_FEATURE_PRESENT_PER_RENDER_OP is set in the feature mask.
		/// </remarks>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d11sdklayers/nf-d3d11sdklayers-id3d11debug-getswapchain HRESULT
		// GetSwapChain( [out] IDXGISwapChain **ppSwapChain );
		[PreserveSig]
		HRESULT GetSwapChain(out IDXGISwapChain? ppSwapChain);

		/// <summary>Check to see if the draw pipeline state is valid.</summary>
		/// <param name="pContext">
		/// <para>Type: <c>ID3D11DeviceContext*</c></para>
		/// <para>A pointer to the ID3D11DeviceContext, that represents a device context.</para>
		/// </param>
		/// <returns>
		/// <para>Type: <c>HRESULT</c></para>
		/// <para>This method returns one of the following Direct3D 11 Return Codes.</para>
		/// </returns>
		/// <remarks>
		/// Use validate prior to calling a draw method (for example, ID3D11DeviceContext::Draw); validation requires the debug layer.
		/// </remarks>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d11sdklayers/nf-d3d11sdklayers-id3d11debug-validatecontext HRESULT
		// ValidateContext( [in] ID3D11DeviceContext *pContext );
		[PreserveSig]
		HRESULT ValidateContext([In] ID3D11DeviceContext pContext);

		/// <summary>Report information about a device object's lifetime.</summary>
		/// <param name="Flags">
		/// <para>Type: <c>D3D11_RLDO_FLAGS</c></para>
		/// <para>A value from the D3D11_RLDO_FLAGS enumeration.</para>
		/// </param>
		/// <returns>
		/// <para>Type: <c>HRESULT</c></para>
		/// <para>This method returns one of the following Direct3D 11 Return Codes.</para>
		/// </returns>
		/// <remarks>
		/// <c>ReportLiveDeviceObjects</c> uses the value in <c>Flags</c> to determine the amount of information to report about a device
		/// object's lifetime.
		/// </remarks>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d11sdklayers/nf-d3d11sdklayers-id3d11debug-reportlivedeviceobjects HRESULT
		// ReportLiveDeviceObjects( D3D11_RLDO_FLAGS Flags );
		[PreserveSig]
		HRESULT ReportLiveDeviceObjects(D3D11_RLDO_FLAGS Flags);

		/// <summary>Verifies whether the dispatch pipeline state is valid.</summary>
		/// <param name="pContext">
		/// <para>Type: <c>ID3D11DeviceContext*</c></para>
		/// <para>A pointer to the ID3D11DeviceContext that represents a device context.</para>
		/// </param>
		/// <returns>
		/// <para>Type: <c>HRESULT</c></para>
		/// <para>This method returns one of the return codes described in the topic Direct3D 11 Return Codes.</para>
		/// </returns>
		/// <remarks>
		/// Use this method before you call a dispatch method (for example, ID3D11DeviceContext::Dispatch). Validation requires the debug layer.
		/// </remarks>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d11sdklayers/nf-d3d11sdklayers-id3d11debug-validatecontextfordispatch
		// HRESULT ValidateContextForDispatch( [in] ID3D11DeviceContext *pContext );
		[PreserveSig]
		HRESULT ValidateContextForDispatch([In] ID3D11DeviceContext pContext);
	}

	/// <summary>
	/// An information-queue interface stores, retrieves, and filters debug messages. The queue consists of a message queue, an optional
	/// storage filter stack, and a optional retrieval filter stack.
	/// </summary>
	/// <remarks>
	/// <para>To get this interface, turn on debug layer and use IUnknown::QueryInterface from the ID3D11Device.</para>
	/// <para><c>Windows Phone 8:</c> This API is supported.</para>
	/// </remarks>
	// https://learn.microsoft.com/en-us/windows/win32/api/d3d11sdklayers/nn-d3d11sdklayers-id3d11infoqueue
	[PInvokeData("d3d11sdklayers.h", MSDNShortId = "NN:d3d11sdklayers.ID3D11InfoQueue")]
	[ComImport, Guid("6543dbb6-1b48-42f5-ab82-e97ec74326f6"), InterfaceType(ComInterfaceType.InterfaceIsIUnknown)]
	public interface ID3D11InfoQueue
	{
		/// <summary>Set the maximum number of messages that can be added to the message queue.</summary>
		/// <param name="MessageCountLimit">
		/// <para>Type: <c>UINT64</c></para>
		/// <para>Maximum number of messages that can be added to the message queue. -1 means no limit.</para>
		/// </param>
		/// <returns>
		/// <para>Type: <c>HRESULT</c></para>
		/// <para>This method returns one of the following Direct3D 11 Return Codes.</para>
		/// </returns>
		/// <remarks>
		/// When the number of messages in the message queue has reached the maximum limit, new messages coming in will push old messages out.
		/// </remarks>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d11sdklayers/nf-d3d11sdklayers-id3d11infoqueue-setmessagecountlimit HRESULT
		// SetMessageCountLimit( [in] UINT64 MessageCountLimit );
		[PreserveSig]
		HRESULT SetMessageCountLimit(ulong MessageCountLimit);

		/// <summary>Clear all messages from the message queue.</summary>
		/// <returns>None</returns>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d11sdklayers/nf-d3d11sdklayers-id3d11infoqueue-clearstoredmessages void ClearStoredMessages();
		[PreserveSig]
		void ClearStoredMessages();

		/// <summary>Get a message from the message queue.</summary>
		/// <param name="MessageIndex">
		/// <para>Type: <c>UINT64</c></para>
		/// <para>
		/// Index into message queue after an optional retrieval filter has been applied. This can be between 0 and the number of messages
		/// in the message queue that pass through the retrieval filter (which can be obtained with
		/// ID3D11InfoQueue::GetNumStoredMessagesAllowedByRetrievalFilter). 0 is the message at the front of the message queue.
		/// </para>
		/// </param>
		/// <param name="pMessage">
		/// <para>Type: <c>D3D11_MESSAGE*</c></para>
		/// <para>Returned message (see D3D11_MESSAGE).</para>
		/// </param>
		/// <param name="pMessageByteLength">
		/// <para>Type: <c>SIZE_T*</c></para>
		/// <para>Size of pMessage in bytes, including the size of the message string that the pMessage points to.</para>
		/// </param>
		/// <returns>
		/// <para>Type: <c>HRESULT</c></para>
		/// <para>This method returns one of the following Direct3D 11 Return Codes.</para>
		/// </returns>
		/// <remarks>
		/// <para>This method does not remove any messages from the message queue.</para>
		/// <para>This method gets messages from the message queue after an optional retrieval filter has been applied.</para>
		/// <para>
		/// Applications should call this method twice to retrieve a message - first to obtain the size of the message and second to get the
		/// message. Here is a typical example:
		/// </para>
		/// <para>For an overview see Information Queue Overview.</para>
		/// </remarks>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d11sdklayers/nf-d3d11sdklayers-id3d11infoqueue-getmessage HRESULT
		// GetMessage( [in] UINT64 MessageIndex, [out, optional] D3D11_MESSAGE *pMessage, [in, out] SIZE_T *pMessageByteLength );
		[PreserveSig]
		HRESULT GetMessage(ulong MessageIndex, [Out, Optional] StructPointer<D3D11_MESSAGE> pMessage, ref SizeT pMessageByteLength);

		/// <summary>Get the number of messages that were allowed to pass through a storage filter.</summary>
		/// <returns>
		/// <para>Type: <c>UINT64</c></para>
		/// <para>Number of messages allowed by a storage filter.</para>
		/// </returns>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d11sdklayers/nf-d3d11sdklayers-id3d11infoqueue-getnummessagesallowedbystoragefilter
		// UINT64 GetNumMessagesAllowedByStorageFilter();
		[PreserveSig]
		ulong GetNumMessagesAllowedByStorageFilter();

		/// <summary>Get the number of messages that were denied passage through a storage filter.</summary>
		/// <returns>
		/// <para>Type: <c>UINT64</c></para>
		/// <para>Number of messages denied by a storage filter.</para>
		/// </returns>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d11sdklayers/nf-d3d11sdklayers-id3d11infoqueue-getnummessagesdeniedbystoragefilter
		// UINT64 GetNumMessagesDeniedByStorageFilter();
		[PreserveSig]
		ulong GetNumMessagesDeniedByStorageFilter();

		/// <summary>Get the number of messages currently stored in the message queue.</summary>
		/// <returns>
		/// <para>Type: <c>UINT64</c></para>
		/// <para>Number of messages currently stored in the message queue.</para>
		/// </returns>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d11sdklayers/nf-d3d11sdklayers-id3d11infoqueue-getnumstoredmessages UINT64 GetNumStoredMessages();
		[PreserveSig]
		ulong GetNumStoredMessages();

		/// <summary>Get the number of messages that are able to pass through a retrieval filter.</summary>
		/// <returns>
		/// <para>Type: <c>UINT64</c></para>
		/// <para>Number of messages allowed by a retrieval filter.</para>
		/// </returns>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d11sdklayers/nf-d3d11sdklayers-id3d11infoqueue-getnumstoredmessagesallowedbyretrievalfilter
		// UINT64 GetNumStoredMessagesAllowedByRetrievalFilter();
		[PreserveSig]
		ulong GetNumStoredMessagesAllowedByRetrievalFilter();

		/// <summary>Get the number of messages that were discarded due to the message count limit.</summary>
		/// <returns>
		/// <para>Type: <c>UINT64</c></para>
		/// <para>Number of messages discarded.</para>
		/// </returns>
		/// <remarks>
		/// Get and set the message count limit with ID3D11InfoQueue::GetMessageCountLimit and ID3D11InfoQueue::SetMessageCountLimit, respectively.
		/// </remarks>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d11sdklayers/nf-d3d11sdklayers-id3d11infoqueue-getnummessagesdiscardedbymessagecountlimit
		// UINT64 GetNumMessagesDiscardedByMessageCountLimit();
		[PreserveSig]
		ulong GetNumMessagesDiscardedByMessageCountLimit();

		/// <summary>Get the maximum number of messages that can be added to the message queue.</summary>
		/// <returns>
		/// <para>Type: <c>UINT64</c></para>
		/// <para>Maximum number of messages that can be added to the queue. -1 means no limit.</para>
		/// </returns>
		/// <remarks>
		/// When the number of messages in the message queue has reached the maximum limit, new messages coming in will push old messages out.
		/// </remarks>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d11sdklayers/nf-d3d11sdklayers-id3d11infoqueue-getmessagecountlimit UINT64 GetMessageCountLimit();
		[PreserveSig]
		ulong GetMessageCountLimit();

		/// <summary>Add storage filters to the top of the storage-filter stack.</summary>
		/// <param name="pFilter">
		/// <para>Type: <c>D3D11_INFO_QUEUE_FILTER*</c></para>
		/// <para>Array of storage filters (see D3D11_INFO_QUEUE_FILTER).</para>
		/// </param>
		/// <returns>
		/// <para>Type: <c>HRESULT</c></para>
		/// <para>This method returns one of the following Direct3D 11 Return Codes.</para>
		/// </returns>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d11sdklayers/nf-d3d11sdklayers-id3d11infoqueue-addstoragefilterentries
		// HRESULT AddStorageFilterEntries( [in] D3D11_INFO_QUEUE_FILTER *pFilter );
		[PreserveSig]
		HRESULT AddStorageFilterEntries(in D3D11_INFO_QUEUE_FILTER pFilter);

		/// <summary>Get the storage filter at the top of the storage-filter stack.</summary>
		/// <param name="pFilter">
		/// <para>Type: <c>D3D11_INFO_QUEUE_FILTER*</c></para>
		/// <para>Storage filter at the top of the storage-filter stack.</para>
		/// </param>
		/// <param name="pFilterByteLength">
		/// <para>Type: <c>SIZE_T*</c></para>
		/// <para>
		/// Size of the storage filter in bytes. If pFilter is <c>NULL</c>, the size of the storage filter will be output to this parameter.
		/// </para>
		/// </param>
		/// <returns>
		/// <para>Type: <c>HRESULT</c></para>
		/// <para>This method returns one of the following Direct3D 11 Return Codes.</para>
		/// </returns>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d11sdklayers/nf-d3d11sdklayers-id3d11infoqueue-getstoragefilter HRESULT
		// GetStorageFilter( [out, optional] D3D11_INFO_QUEUE_FILTER *pFilter, [in, out] SIZE_T *pFilterByteLength );
		[PreserveSig]
		HRESULT GetStorageFilter([Out, Optional] StructPointer<D3D11_INFO_QUEUE_FILTER> pFilter, ref SizeT pFilterByteLength);

		/// <summary>Remove a storage filter from the top of the storage-filter stack.</summary>
		/// <returns>None</returns>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d11sdklayers/nf-d3d11sdklayers-id3d11infoqueue-clearstoragefilter void ClearStorageFilter();
		[PreserveSig]
		void ClearStorageFilter();

		/// <summary>Push an empty storage filter onto the storage-filter stack.</summary>
		/// <returns>
		/// <para>Type: <c>HRESULT</c></para>
		/// <para>This method returns one of the following Direct3D 11 Return Codes.</para>
		/// </returns>
		/// <remarks>An empty storage filter allows all messages to pass through.</remarks>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d11sdklayers/nf-d3d11sdklayers-id3d11infoqueue-pushemptystoragefilter
		// HRESULT PushEmptyStorageFilter();
		[PreserveSig]
		HRESULT PushEmptyStorageFilter();

		/// <summary>Push a copy of storage filter currently on the top of the storage-filter stack onto the storage-filter stack.</summary>
		/// <returns>
		/// <para>Type: <c>HRESULT</c></para>
		/// <para>This method returns one of the following Direct3D 11 Return Codes.</para>
		/// </returns>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d11sdklayers/nf-d3d11sdklayers-id3d11infoqueue-pushcopyofstoragefilter
		// HRESULT PushCopyOfStorageFilter();
		[PreserveSig]
		HRESULT PushCopyOfStorageFilter();

		/// <summary>Push a storage filter onto the storage-filter stack.</summary>
		/// <param name="pFilter">
		/// <para>Type: <c>D3D11_INFO_QUEUE_FILTER*</c></para>
		/// <para>Pointer to a storage filter (see D3D11_INFO_QUEUE_FILTER).</para>
		/// </param>
		/// <returns>
		/// <para>Type: <c>HRESULT</c></para>
		/// <para>This method returns one of the following Direct3D 11 Return Codes.</para>
		/// </returns>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d11sdklayers/nf-d3d11sdklayers-id3d11infoqueue-pushstoragefilter HRESULT
		// PushStorageFilter( [in] D3D11_INFO_QUEUE_FILTER *pFilter );
		[PreserveSig]
		HRESULT PushStorageFilter(in D3D11_INFO_QUEUE_FILTER pFilter);

		/// <summary>Pop a storage filter from the top of the storage-filter stack.</summary>
		/// <returns>None</returns>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d11sdklayers/nf-d3d11sdklayers-id3d11infoqueue-popstoragefilter void PopStorageFilter();
		[PreserveSig]
		void PopStorageFilter();

		/// <summary>Get the size of the storage-filter stack in bytes.</summary>
		/// <returns>
		/// <para>Type: <c>UINT</c></para>
		/// <para>Size of the storage-filter stack in bytes.</para>
		/// </returns>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d11sdklayers/nf-d3d11sdklayers-id3d11infoqueue-getstoragefilterstacksize
		// UINT GetStorageFilterStackSize();
		[PreserveSig]
		uint GetStorageFilterStackSize();

		/// <summary>Add storage filters to the top of the retrieval-filter stack.</summary>
		/// <param name="pFilter">
		/// <para>Type: <c>D3D11_INFO_QUEUE_FILTER*</c></para>
		/// <para>Array of retrieval filters (see D3D11_INFO_QUEUE_FILTER).</para>
		/// </param>
		/// <returns>
		/// <para>Type: <c>HRESULT</c></para>
		/// <para>This method returns one of the following Direct3D 11 Return Codes.</para>
		/// </returns>
		/// <remarks>The following code example shows how to use <c>ID3D11InfoQueue::AddRetrievalFilterEntries</c>:</remarks>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d11sdklayers/nf-d3d11sdklayers-id3d11infoqueue-addretrievalfilterentries
		// HRESULT AddRetrievalFilterEntries( [in] D3D11_INFO_QUEUE_FILTER *pFilter );
		[PreserveSig]
		HRESULT AddRetrievalFilterEntries(in D3D11_INFO_QUEUE_FILTER pFilter);

		/// <summary>Get the retrieval filter at the top of the retrieval-filter stack.</summary>
		/// <param name="pFilter">
		/// <para>Type: <c>D3D11_INFO_QUEUE_FILTER*</c></para>
		/// <para>Retrieval filter at the top of the retrieval-filter stack.</para>
		/// </param>
		/// <param name="pFilterByteLength">
		/// <para>Type: <c>SIZE_T*</c></para>
		/// <para>
		/// Size of the retrieval filter in bytes. If pFilter is <c>NULL</c>, the size of the retrieval filter will be output to this parameter.
		/// </para>
		/// </param>
		/// <returns>
		/// <para>Type: <c>HRESULT</c></para>
		/// <para>This method returns one of the following Direct3D 11 Return Codes.</para>
		/// </returns>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d11sdklayers/nf-d3d11sdklayers-id3d11infoqueue-getretrievalfilter HRESULT
		// GetRetrievalFilter( [out, optional] D3D11_INFO_QUEUE_FILTER *pFilter, [in, out] SIZE_T *pFilterByteLength );
		[PreserveSig]
		HRESULT GetRetrievalFilter([Out, Optional] StructPointer<D3D11_INFO_QUEUE_FILTER> pFilter, ref SizeT pFilterByteLength);

		/// <summary>Remove a retrieval filter from the top of the retrieval-filter stack.</summary>
		/// <returns>None</returns>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d11sdklayers/nf-d3d11sdklayers-id3d11infoqueue-clearretrievalfilter void ClearRetrievalFilter();
		[PreserveSig]
		void ClearRetrievalFilter();

		/// <summary>Push an empty retrieval filter onto the retrieval-filter stack.</summary>
		/// <returns>
		/// <para>Type: <c>HRESULT</c></para>
		/// <para>This method returns one of the following Direct3D 11 Return Codes.</para>
		/// </returns>
		/// <remarks>An empty retrieval filter allows all messages to pass through.</remarks>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d11sdklayers/nf-d3d11sdklayers-id3d11infoqueue-pushemptyretrievalfilter
		// HRESULT PushEmptyRetrievalFilter();
		[PreserveSig]
		HRESULT PushEmptyRetrievalFilter();

		/// <summary>Push a copy of retrieval filter currently on the top of the retrieval-filter stack onto the retrieval-filter stack.</summary>
		/// <returns>
		/// <para>Type: <c>HRESULT</c></para>
		/// <para>This method returns one of the following Direct3D 11 Return Codes.</para>
		/// </returns>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d11sdklayers/nf-d3d11sdklayers-id3d11infoqueue-pushcopyofretrievalfilter
		// HRESULT PushCopyOfRetrievalFilter();
		[PreserveSig]
		HRESULT PushCopyOfRetrievalFilter();

		/// <summary>Push a retrieval filter onto the retrieval-filter stack.</summary>
		/// <param name="pFilter">
		/// <para>Type: <c>D3D11_INFO_QUEUE_FILTER*</c></para>
		/// <para>Pointer to a retrieval filter (see D3D11_INFO_QUEUE_FILTER).</para>
		/// </param>
		/// <returns>
		/// <para>Type: <c>HRESULT</c></para>
		/// <para>This method returns one of the following Direct3D 11 Return Codes.</para>
		/// </returns>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d11sdklayers/nf-d3d11sdklayers-id3d11infoqueue-pushretrievalfilter HRESULT
		// PushRetrievalFilter( [in] D3D11_INFO_QUEUE_FILTER *pFilter );
		[PreserveSig]
		HRESULT PushRetrievalFilter(in D3D11_INFO_QUEUE_FILTER pFilter);

		/// <summary>Pop a retrieval filter from the top of the retrieval-filter stack.</summary>
		/// <returns>None</returns>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d11sdklayers/nf-d3d11sdklayers-id3d11infoqueue-popretrievalfilter void PopRetrievalFilter();
		[PreserveSig]
		void PopRetrievalFilter();

		/// <summary>Get the size of the retrieval-filter stack in bytes.</summary>
		/// <returns>
		/// <para>Type: <c>UINT</c></para>
		/// <para>Size of the retrieval-filter stack in bytes.</para>
		/// </returns>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d11sdklayers/nf-d3d11sdklayers-id3d11infoqueue-getretrievalfilterstacksize
		// UINT GetRetrievalFilterStackSize();
		[PreserveSig]
		uint GetRetrievalFilterStackSize();

		/// <summary>Add a debug message to the message queue and send that message to debug output.</summary>
		/// <param name="Category">
		/// <para>Type: <c>D3D11_MESSAGE_CATEGORY</c></para>
		/// <para>Category of a message (see D3D11_MESSAGE_CATEGORY).</para>
		/// </param>
		/// <param name="Severity">
		/// <para>Type: <c>D3D11_MESSAGE_SEVERITY</c></para>
		/// <para>Severity of a message (see D3D11_MESSAGE_SEVERITY).</para>
		/// </param>
		/// <param name="ID">
		/// <para>Type: <c>D3D11_MESSAGE_ID</c></para>
		/// <para>Unique identifier of a message (see D3D11_MESSAGE_ID).</para>
		/// </param>
		/// <param name="pDescription">
		/// <para>Type: <c>LPCSTR</c></para>
		/// <para>User-defined message.</para>
		/// </param>
		/// <returns>
		/// <para>Type: <c>HRESULT</c></para>
		/// <para>This method returns one of the following Direct3D 11 Return Codes.</para>
		/// </returns>
		/// <remarks>
		/// This method is used by the runtime's internal mechanisms to add debug messages to the message queue and send them to debug
		/// output. For applications to add their own custom messages to the message queue and send them to debug output, call ID3D11InfoQueue::AddApplicationMessage.
		/// </remarks>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d11sdklayers/nf-d3d11sdklayers-id3d11infoqueue-addmessage HRESULT
		// AddMessage( [in] D3D11_MESSAGE_CATEGORY Category, [in] D3D11_MESSAGE_SEVERITY Severity, [in] D3D11_MESSAGE_ID ID, [in] LPCSTR
		// pDescription );
		[PreserveSig]
		HRESULT AddMessage(D3D11_MESSAGE_CATEGORY Category, D3D11_MESSAGE_SEVERITY Severity, D3D11_MESSAGE_ID ID, [MarshalAs(UnmanagedType.LPStr)] string pDescription);

		/// <summary>Add a user-defined message to the message queue and send that message to debug output.</summary>
		/// <param name="Severity">
		/// <para>Type: <c>D3D11_MESSAGE_SEVERITY</c></para>
		/// <para>Severity of a message (see D3D11_MESSAGE_SEVERITY).</para>
		/// </param>
		/// <param name="pDescription">
		/// <para>Type: <c>LPCSTR</c></para>
		/// <para>Message string.</para>
		/// </param>
		/// <returns>
		/// <para>Type: <c>HRESULT</c></para>
		/// <para>This method returns one of the following Direct3D 11 Return Codes.</para>
		/// </returns>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d11sdklayers/nf-d3d11sdklayers-id3d11infoqueue-addapplicationmessage
		// HRESULT AddApplicationMessage( [in] D3D11_MESSAGE_SEVERITY Severity, [in] LPCSTR pDescription );
		[PreserveSig]
		HRESULT AddApplicationMessage(D3D11_MESSAGE_SEVERITY Severity, [MarshalAs(UnmanagedType.LPStr)] string pDescription);

		/// <summary>Set a message category to break on when a message with that category passes through the storage filter.</summary>
		/// <param name="Category">
		/// <para>Type: <c>D3D11_MESSAGE_CATEGORY</c></para>
		/// <para>Message category to break on (see D3D11_MESSAGE_CATEGORY).</para>
		/// </param>
		/// <param name="bEnable">
		/// <para>Type: <c>BOOL</c></para>
		/// <para>Turns this breaking condition on or off (true for on, false for off).</para>
		/// </param>
		/// <returns>
		/// <para>Type: <c>HRESULT</c></para>
		/// <para>This method returns one of the following Direct3D 11 Return Codes.</para>
		/// </returns>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d11sdklayers/nf-d3d11sdklayers-id3d11infoqueue-setbreakoncategory HRESULT
		// SetBreakOnCategory( [in] D3D11_MESSAGE_CATEGORY Category, [in] BOOL bEnable );
		[PreserveSig]
		HRESULT SetBreakOnCategory(D3D11_MESSAGE_CATEGORY Category, bool bEnable);

		/// <summary>Set a message severity level to break on when a message with that severity level passes through the storage filter.</summary>
		/// <param name="Severity">
		/// <para>Type: <c>D3D11_MESSAGE_SEVERITY</c></para>
		/// <para>A D3D11_MESSAGE_SEVERITY, which represents a message severity level to break on.</para>
		/// </param>
		/// <param name="bEnable">
		/// <para>Type: <c>BOOL</c></para>
		/// <para>Turns this breaking condition on or off (true for on, false for off).</para>
		/// </param>
		/// <returns>
		/// <para>Type: <c>HRESULT</c></para>
		/// <para>This method returns one of the following Direct3D 11 Return Codes.</para>
		/// </returns>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d11sdklayers/nf-d3d11sdklayers-id3d11infoqueue-setbreakonseverity HRESULT
		// SetBreakOnSeverity( [in] D3D11_MESSAGE_SEVERITY Severity, [in] BOOL bEnable );
		[PreserveSig]
		HRESULT SetBreakOnSeverity(D3D11_MESSAGE_SEVERITY Severity, bool bEnable);

		/// <summary>Set a message identifier to break on when a message with that identifier passes through the storage filter.</summary>
		/// <param name="ID">
		/// <para>Type: <c>D3D11_MESSAGE_ID</c></para>
		/// <para>Message identifier to break on (see D3D11_MESSAGE_ID).</para>
		/// </param>
		/// <param name="bEnable">
		/// <para>Type: <c>BOOL</c></para>
		/// <para>Turns this breaking condition on or off (true for on, false for off).</para>
		/// </param>
		/// <returns>
		/// <para>Type: <c>HRESULT</c></para>
		/// <para>This method returns one of the following Direct3D 11 Return Codes.</para>
		/// </returns>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d11sdklayers/nf-d3d11sdklayers-id3d11infoqueue-setbreakonid HRESULT
		// SetBreakOnID( [in] D3D11_MESSAGE_ID ID, [in] BOOL bEnable );
		[PreserveSig]
		HRESULT SetBreakOnID(D3D11_MESSAGE_ID ID, bool bEnable);

		/// <summary>Get a message category to break on when a message with that category passes through the storage filter.</summary>
		/// <param name="Category">
		/// <para>Type: <c>D3D11_MESSAGE_CATEGORY</c></para>
		/// <para>Message category to break on (see D3D11_MESSAGE_CATEGORY).</para>
		/// </param>
		/// <returns>
		/// <para>Type: <c>BOOL</c></para>
		/// <para>Whether this breaking condition is turned on or off (true for on, false for off).</para>
		/// </returns>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d11sdklayers/nf-d3d11sdklayers-id3d11infoqueue-getbreakoncategory BOOL
		// GetBreakOnCategory( [in] D3D11_MESSAGE_CATEGORY Category );
		[PreserveSig]
		bool GetBreakOnCategory(D3D11_MESSAGE_CATEGORY Category);

		/// <summary>Get a message severity level to break on when a message with that severity level passes through the storage filter.</summary>
		/// <param name="Severity">
		/// <para>Type: <c>D3D11_MESSAGE_SEVERITY</c></para>
		/// <para>Message severity level to break on (see D3D11_MESSAGE_SEVERITY).</para>
		/// </param>
		/// <returns>
		/// <para>Type: <c>BOOL</c></para>
		/// <para>Whether this breaking condition is turned on or off (true for on, false for off).</para>
		/// </returns>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d11sdklayers/nf-d3d11sdklayers-id3d11infoqueue-getbreakonseverity BOOL
		// GetBreakOnSeverity( [in] D3D11_MESSAGE_SEVERITY Severity );
		[PreserveSig]
		bool GetBreakOnSeverity(D3D11_MESSAGE_SEVERITY Severity);

		/// <summary>Get a message identifier to break on when a message with that identifier passes through the storage filter.</summary>
		/// <param name="ID">
		/// <para>Type: <c>D3D11_MESSAGE_ID</c></para>
		/// <para>Message identifier to break on (see D3D11_MESSAGE_ID).</para>
		/// </param>
		/// <returns>
		/// <para>Type: <c>BOOL</c></para>
		/// <para>Whether this breaking condition is turned on or off (true for on, false for off).</para>
		/// </returns>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d11sdklayers/nf-d3d11sdklayers-id3d11infoqueue-getbreakonid BOOL
		// GetBreakOnID( [in] D3D11_MESSAGE_ID ID );
		[PreserveSig]
		bool GetBreakOnID(D3D11_MESSAGE_ID ID);

		/// <summary>Set a boolean that turns the debug output on or off.</summary>
		/// <param name="bMute">
		/// <para>Type: <c>BOOL</c></para>
		/// <para>Disable/Enable the debug output ( <c>TRUE</c> to disable or mute the output, <c>FALSE</c> to enable the output).</para>
		/// </param>
		/// <returns>None</returns>
		/// <remarks>
		/// This will stop messages that pass the storage filter from being printed out in the debug output, however those messages will
		/// still be added to the message queue.
		/// </remarks>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d11sdklayers/nf-d3d11sdklayers-id3d11infoqueue-setmutedebugoutput void
		// SetMuteDebugOutput( [in] BOOL bMute );
		[PreserveSig]
		void SetMuteDebugOutput(bool bMute);

		/// <summary>Get a boolean that turns the debug output on or off.</summary>
		/// <returns>
		/// <para>Type: <c>BOOL</c></para>
		/// <para>Whether the debug output is on or off (true for on, false for off).</para>
		/// </returns>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d11sdklayers/nf-d3d11sdklayers-id3d11infoqueue-getmutedebugoutput BOOL GetMuteDebugOutput();
		[PreserveSig]
		bool GetMuteDebugOutput();
	}

	/// <summary>The default tracking interface sets reference default tracking options.</summary>
	/// <remarks>These APIs require the Windows Software Development Kit (SDK) for Windows 8.</remarks>
	// https://learn.microsoft.com/en-us/windows/win32/api/d3d11sdklayers/nn-d3d11sdklayers-id3d11refdefaulttrackingoptions
	[PInvokeData("d3d11sdklayers.h", MSDNShortId = "NN:d3d11sdklayers.ID3D11RefDefaultTrackingOptions")]
	[ComImport, Guid("03916615-c644-418c-9bf4-75db5be63ca0"), InterfaceType(ComInterfaceType.InterfaceIsIUnknown)]
	public interface ID3D11RefDefaultTrackingOptions
	{
		/// <summary>Sets graphics processing unit (GPU) debug reference default tracking options for specific resource types.</summary>
		/// <param name="ResourceTypeFlags">A D3D11_SHADER_TRACKING_RESOURCE_TYPE-typed value that specifies the type of resource to track.</param>
		/// <param name="Options">
		/// A combination of D3D11_SHADER_TRACKING_OPTIONS-typed flags that are combined by using a bitwise <c>OR</c> operation. The
		/// resulting value identifies tracking options. If a flag is present, the tracking option that the flag represents is set to "on";
		/// otherwise the tracking option is set to "off."
		/// </param>
		/// <returns>This method returns one of the Direct3D 11 return codes.</returns>
		/// <remarks>This API requires the Windows Software Development Kit (SDK) for Windows 8.</remarks>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d11sdklayers/nf-d3d11sdklayers-id3d11refdefaulttrackingoptions-settrackingoptions
		// HRESULT SetTrackingOptions( UINT ResourceTypeFlags, UINT Options );
		[PreserveSig]
		HRESULT SetTrackingOptions(D3D11_SHADER_TRACKING_RESOURCE_TYPE ResourceTypeFlags, D3D11_SHADER_TRACKING_OPTION Options);
	}

	/// <summary>The tracking interface sets reference tracking options.</summary>
	/// <remarks>These APIs require the Windows Software Development Kit (SDK) for Windows 8.</remarks>
	// https://learn.microsoft.com/en-us/windows/win32/api/d3d11sdklayers/nn-d3d11sdklayers-id3d11reftrackingoptions
	[PInvokeData("d3d11sdklayers.h", MSDNShortId = "NN:d3d11sdklayers.ID3D11RefTrackingOptions")]
	[ComImport, Guid("193dacdf-0db2-4c05-a55c-ef06cac56fd9"), InterfaceType(ComInterfaceType.InterfaceIsIUnknown)]
	public interface ID3D11RefTrackingOptions
	{
		/// <summary>Sets graphics processing unit (GPU) debug reference tracking options.</summary>
		/// <param name="uOptions">
		/// A combination of D3D11_SHADER_TRACKING_OPTIONS-typed flags that are combined by using a bitwise <c>OR</c> operation. The
		/// resulting value identifies tracking options. If a flag is present, the tracking option that the flag represents is set to "on";
		/// otherwise the tracking option is set to "off."
		/// </param>
		/// <returns>This method returns one of the Direct3D 11 return codes.</returns>
		/// <remarks>This API requires the Windows Software Development Kit (SDK) for Windows 8.</remarks>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d11sdklayers/nf-d3d11sdklayers-id3d11reftrackingoptions-settrackingoptions
		// HRESULT SetTrackingOptions( UINT uOptions );
		[PreserveSig]
		HRESULT SetTrackingOptions(D3D11_SHADER_TRACKING_OPTION uOptions);
	}

	/// <summary>
	/// The <c>ID3D11SwitchToRef</c> interface inherits from the IUnknown interface. <c>ID3D11SwitchToRef</c> also has these types of members:
	/// </summary>
	// https://learn.microsoft.com/en-us/windows/win32/api/d3d11sdklayers/nn-d3d11sdklayers-id3d11switchtoref
	[PInvokeData("d3d11sdklayers.h", MSDNShortId = "NN:d3d11sdklayers.ID3D11SwitchToRef")]
	[ComImport, Guid("1ef337e3-58e7-4f83-a692-db221f5ed47e"), InterfaceType(ComInterfaceType.InterfaceIsIUnknown)]
	public interface ID3D11SwitchToRef
	{
		/// <summary>
		/// <para>Type: <c>BOOL</c></para>
		/// <para>Reserved.</para>
		/// </summary>
		/// <param name="UseRef">
		/// <para>Type: <c>BOOL</c></para>
		/// <para>Reserved.</para>
		/// </param>
		/// <returns>
		/// <para>Type: <c>BOOL</c></para>
		/// <para>Reserved.</para>
		/// </returns>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d11sdklayers/nf-d3d11sdklayers-id3d11switchtoref-setuseref BOOL SetUseRef(
		// BOOL UseRef );
		[PreserveSig]
		bool SetUseRef(bool UseRef);

		/// <summary>
		/// <para>Type: <c>BOOL</c></para>
		/// <para>Reserved.</para>
		/// </summary>
		/// <returns>
		/// <para>Type: <c>BOOL</c></para>
		/// <para>Reserved.</para>
		/// </returns>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d11sdklayers/nf-d3d11sdklayers-id3d11switchtoref-getuseref BOOL GetUseRef();
		[PreserveSig]
		bool GetUseRef();
	}

	/// <summary>
	/// The tracing device interface sets shader tracking information, which enables accurate logging and playback of shader execution.
	/// </summary>
	/// <remarks>
	/// <para>To get this interface, turn on the debug layer and use IUnknown::QueryInterface from the ID3D11Device.</para>
	/// <para><c>Note</c>  This API requires the Windows Software Development Kit (SDK) for Windows 8.</para>
	/// <para></para>
	/// </remarks>
	// https://learn.microsoft.com/en-us/windows/win32/api/d3d11sdklayers/nn-d3d11sdklayers-id3d11tracingdevice
	[PInvokeData("d3d11sdklayers.h", MSDNShortId = "NN:d3d11sdklayers.ID3D11TracingDevice")]
	[ComImport, Guid("1911c771-1587-413e-a7e0-fb26c3de0268"), InterfaceType(ComInterfaceType.InterfaceIsIUnknown)]
	public interface ID3D11TracingDevice
	{
		/// <summary>Sets the reference rasterizer's default race-condition tracking options for the specified resource types.</summary>
		/// <param name="ResourceTypeFlags">A D3D11_SHADER_TRACKING_RESOURCE_TYPE-typed value that specifies the type of resource to track.</param>
		/// <param name="Options">
		/// A combination of D3D11_SHADER_TRACKING_OPTIONS-typed flags that are combined by using a bitwise <c>OR</c> operation. The
		/// resulting value identifies tracking options. If a flag is present, the tracking option that the flag represents is set to "on,"
		/// otherwise the tracking option is set to "off."
		/// </param>
		/// <returns>This method returns one of the Direct3D 11 return codes.</returns>
		/// <remarks>This API requires the Windows Software Development Kit (SDK) for Windows 8.</remarks>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d11sdklayers/nf-d3d11sdklayers-id3d11tracingdevice-setshadertrackingoptionsbytype
		// HRESULT SetShaderTrackingOptionsByType( [in] UINT ResourceTypeFlags, [in] UINT Options );
		[PreserveSig]
		HRESULT SetShaderTrackingOptionsByType(D3D11_SHADER_TRACKING_RESOURCE_TYPE ResourceTypeFlags, D3D11_SHADER_TRACKING_OPTION Options);

		/// <summary>Sets the reference rasterizer's race-condition tracking options for a specific shader.</summary>
		/// <param name="pShader">A pointer to the IUnknown interface of a shader.</param>
		/// <param name="Options">
		/// A combination of D3D11_SHADER_TRACKING_OPTIONS-typed flags that are combined by using a bitwise <c>OR</c> operation. The
		/// resulting value identifies tracking options. If a flag is present, the tracking option that the flag represents is set to "on";
		/// otherwise the tracking option is set to "off."
		/// </param>
		/// <returns>This method returns one of the Direct3D 11 return codes.</returns>
		/// <remarks>
		/// <para>
		/// D3D11_SHADER_TRACKING_OPTION_UAV_SPECIFIC_FLAGS) in the <c>Options</c> parameter for a compute shader,
		/// <c>SetShaderTrackingOptions</c> ignores it.
		/// </para>
		/// <note>This API requires the Windows Software Development Kit (SDK) for Windows 8.</note>
		/// </remarks>
		// https://learn.microsoft.com/en-us/windows/win32/api/d3d11sdklayers/nf-d3d11sdklayers-id3d11tracingdevice-setshadertrackingoptions
		// HRESULT SetShaderTrackingOptions( [in] IUnknown *pShader, [in] UINT Options );
		[PreserveSig]
		HRESULT SetShaderTrackingOptions([In, MarshalAs(UnmanagedType.Interface)] object pShader, D3D11_SHADER_TRACKING_OPTION Options);
	}

	/// <summary>Debug message filter; contains a lists of message types to allow or deny.</summary>
	/// <remarks>For use with an ID3D11InfoQueue Interface.</remarks>
	// https://learn.microsoft.com/en-us/windows/win32/api/d3d11sdklayers/ns-d3d11sdklayers-d3d11_info_queue_filter typedef struct
	// D3D11_INFO_QUEUE_FILTER { D3D11_INFO_QUEUE_FILTER_DESC AllowList; D3D11_INFO_QUEUE_FILTER_DESC DenyList; } D3D11_INFO_QUEUE_FILTER;
	[PInvokeData("d3d11sdklayers.h", MSDNShortId = "NS:d3d11sdklayers.D3D11_INFO_QUEUE_FILTER")]
	[StructLayout(LayoutKind.Sequential)]
	public struct D3D11_INFO_QUEUE_FILTER
	{
		/// <summary>
		/// <para>Type: <c>D3D11_INFO_QUEUE_FILTER_DESC</c></para>
		/// <para>Types of messages that you want to allow. See D3D11_INFO_QUEUE_FILTER_DESC.</para>
		/// </summary>
		public D3D11_INFO_QUEUE_FILTER_DESC AllowList;

		/// <summary>
		/// <para>Type: <c>D3D11_INFO_QUEUE_FILTER_DESC</c></para>
		/// <para>Types of messages that you want to deny.</para>
		/// </summary>
		public D3D11_INFO_QUEUE_FILTER_DESC DenyList;
	}

	/// <summary>Allow or deny certain types of messages to pass through a filter.</summary>
	// https://learn.microsoft.com/en-us/windows/win32/api/d3d11sdklayers/ns-d3d11sdklayers-d3d11_info_queue_filter_desc typedef struct
	// D3D11_INFO_QUEUE_FILTER_DESC { UINT NumCategories; D3D11_MESSAGE_CATEGORY *pCategoryList; UINT NumSeverities; D3D11_MESSAGE_SEVERITY
	// *pSeverityList; UINT NumIDs; D3D11_MESSAGE_ID *pIDList; } D3D11_INFO_QUEUE_FILTER_DESC;
	[PInvokeData("d3d11sdklayers.h", MSDNShortId = "NS:d3d11sdklayers.D3D11_INFO_QUEUE_FILTER_DESC")]
	[StructLayout(LayoutKind.Sequential)]
	public struct D3D11_INFO_QUEUE_FILTER_DESC
	{
		/// <summary>
		/// <para>Type: <c>UINT</c></para>
		/// <para>Number of message categories to allow or deny.</para>
		/// </summary>
		public uint NumCategories;

		/// <summary>
		/// <para>Type: <c>D3D11_MESSAGE_CATEGORY*</c></para>
		/// <para>Array of message categories to allow or deny. Array must have at least NumCategories members (see D3D11_MESSAGE_CATEGORY).</para>
		/// </summary>
		public ArrayPointer<D3D11_MESSAGE_CATEGORY> pCategoryList;

		/// <summary>
		/// <para>Type: <c>UINT</c></para>
		/// <para>Number of message severity levels to allow or deny.</para>
		/// </summary>
		public uint NumSeverities;

		/// <summary>
		/// <para>Type: <c>D3D11_MESSAGE_SEVERITY*</c></para>
		/// <para>Array of message severity levels to allow or deny. Array must have at least NumSeverities members (see D3D11_MESSAGE_SEVERITY).</para>
		/// </summary>
		public ArrayPointer<D3D11_MESSAGE_SEVERITY> pSeverityList;

		/// <summary>
		/// <para>Type: <c>UINT</c></para>
		/// <para>Number of message IDs to allow or deny.</para>
		/// </summary>
		public uint NumIDs;

		/// <summary>
		/// <para>Type: <c>D3D11_MESSAGE_ID*</c></para>
		/// <para>Array of message IDs to allow or deny. Array must have at least NumIDs members (see D3D11_MESSAGE_ID).</para>
		/// </summary>
		public ArrayPointer<D3D11_MESSAGE_ID> pIDList;
	}

	/// <summary>A debug message in the Information Queue.</summary>
	/// <remarks>
	/// This structure is returned from ID3D11InfoQueue::GetMessage as part of the Information Queue feature (see ID3D11InfoQueue Interface).
	/// </remarks>
	// https://learn.microsoft.com/en-us/windows/win32/api/d3d11sdklayers/ns-d3d11sdklayers-d3d11_message typedef struct D3D11_MESSAGE {
	// D3D11_MESSAGE_CATEGORY Category; D3D11_MESSAGE_SEVERITY Severity; D3D11_MESSAGE_ID ID; const char *pDescription; SIZE_T
	// DescriptionByteLength; } D3D11_MESSAGE;
	[PInvokeData("d3d11sdklayers.h", MSDNShortId = "NS:d3d11sdklayers.D3D11_MESSAGE")]
	[StructLayout(LayoutKind.Sequential)]
	public struct D3D11_MESSAGE
	{
		/// <summary>
		/// <para>Type: <c>D3D11_MESSAGE_CATEGORY</c></para>
		/// <para>The category of the message. See D3D11_MESSAGE_CATEGORY.</para>
		/// </summary>
		public D3D11_MESSAGE_CATEGORY Category;

		/// <summary>
		/// <para>Type: <c>D3D11_MESSAGE_SEVERITY</c></para>
		/// <para>The severity of the message. See D3D11_MESSAGE_SEVERITY.</para>
		/// </summary>
		public D3D11_MESSAGE_SEVERITY Severity;

		/// <summary>
		/// <para>Type: <c>D3D11_MESSAGE_ID</c></para>
		/// <para>The ID of the message. See D3D11_MESSAGE_ID.</para>
		/// </summary>
		public D3D11_MESSAGE_ID ID;

		/// <summary>
		/// <para>Type: <c>const char*</c></para>
		/// <para>The message string.</para>
		/// </summary>
		public StrPtrAnsi pDescription;

		/// <summary>
		/// <para>Type: <c>SIZE_T</c></para>
		/// <para>The length of pDescription in bytes.</para>
		/// </summary>
		public SizeT DescriptionByteLength;
	}
}