﻿namespace Vanara.PInvoke;

public static partial class D2d1
{
	/// <summary>CLSID_D2D1AlphaMask</summary>
	public static readonly Guid CLSID_D2D1AlphaMask = new(0xc80ecff0, 0x3fd5, 0x4f05, 0x83, 0x28, 0xc5, 0xd1, 0x72, 0x4b, 0x4f, 0x0a);

	/// <summary>CLSID_D2D1ChromaKey</summary>
	public static readonly Guid CLSID_D2D1ChromaKey = new(0x74C01F5B, 0x2A0D, 0x408C, 0x88, 0xE2, 0xC7, 0xA3, 0xC7, 0x19, 0x77, 0x42);

	/// <summary>CLSID_D2D1Contrast</summary>
	public static readonly Guid CLSID_D2D1Contrast = new(0xb648a78a, 0x0ed5, 0x4f80, 0xa9, 0x4a, 0x8e, 0x82, 0x5a, 0xca, 0x6b, 0x77);

	/// <summary>CLSID_D2D1CrossFade</summary>
	public static readonly Guid CLSID_D2D1CrossFade = new(0x12f575e8, 0x4db1, 0x485f, 0x9a, 0x84, 0x03, 0xa0, 0x7d, 0xd3, 0x82, 0x9f);

	/// <summary>CLSID_D2D1EdgeDetection</summary>
	public static readonly Guid CLSID_D2D1EdgeDetection = new(0xEFF583CA, 0xCB07, 0x4AA9, 0xAC, 0x5D, 0x2C, 0xC4, 0x4C, 0x76, 0x46, 0x0F);

	/// <summary>CLSID_D2D1Emboss</summary>
	public static readonly Guid CLSID_D2D1Emboss = new(0xb1c5eb2b, 0x0348, 0x43f0, 0x81, 0x07, 0x49, 0x57, 0xca, 0xcb, 0xa2, 0xae);

	/// <summary>CLSID_D2D1Exposure</summary>
	public static readonly Guid CLSID_D2D1Exposure = new(0xb56c8cfa, 0xf634, 0x41ee, 0xbe, 0xe0, 0xff, 0xa6, 0x17, 0x10, 0x60, 0x04);

	/// <summary>CLSID_D2D1Grayscale</summary>
	public static readonly Guid CLSID_D2D1Grayscale = new(0x36DDE0EB, 0x3725, 0x42E0, 0x83, 0x6D, 0x52, 0xFB, 0x20, 0xAE, 0xE6, 0x44);

	/// <summary>CLSID_D2D1HdrToneMap</summary>
	public static readonly Guid CLSID_D2D1HdrToneMap = new(0x7b0b748d, 0x4610, 0x4486, 0xa9, 0x0c, 0x99, 0x9d, 0x9a, 0x2e, 0x2b, 0x11);

	/// <summary>CLSID_D2D1HighlightsShadows</summary>
	public static readonly Guid CLSID_D2D1HighlightsShadows = new(0xCADC8384, 0x323F, 0x4C7E, 0xA3, 0x61, 0x2E, 0x2B, 0x24, 0xDF, 0x6E, 0xE4);

	/// <summary>CLSID_D2D1HueToRgb</summary>
	public static readonly Guid CLSID_D2D1HueToRgb = new(0x7b78a6bd, 0x0141, 0x4def, 0x8a, 0x52, 0x63, 0x56, 0xee, 0x0c, 0xbd, 0xd5);

	/// <summary>CLSID_D2D1Invert</summary>
	public static readonly Guid CLSID_D2D1Invert = new(0xe0c3784d, 0xcb39, 0x4e84, 0xb6, 0xfd, 0x6b, 0x72, 0xf0, 0x81, 0x02, 0x63);

	/// <summary>CLSID_D2D1LookupTable3D</summary>
	public static readonly Guid CLSID_D2D1LookupTable3D = new(0x349E0EDA, 0x0088, 0x4A79, 0x9C, 0xA3, 0xC7, 0xE3, 0x00, 0x20, 0x20, 0x20);

	/// <summary>CLSID_D2D1Opacity</summary>
	public static readonly Guid CLSID_D2D1Opacity = new(0x811d79a4, 0xde28, 0x4454, 0x80, 0x94, 0xc6, 0x46, 0x85, 0xf8, 0xbd, 0x4c);

	/// <summary>CLSID_D2D1Posterize</summary>
	public static readonly Guid CLSID_D2D1Posterize = new(0x2188945e, 0x33a3, 0x4366, 0xb7, 0xbc, 0x08, 0x6b, 0xd0, 0x2d, 0x08, 0x84);

	/// <summary>CLSID_D2D1RgbToHue</summary>
	public static readonly Guid CLSID_D2D1RgbToHue = new(0x23f3e5ec, 0x91e8, 0x4d3d, 0xad, 0x0a, 0xaf, 0xad, 0xc1, 0x00, 0x4a, 0xa1);

	/// <summary>CLSID_D2D1Sepia</summary>
	public static readonly Guid CLSID_D2D1Sepia = new(0x3a1af410, 0x5f1d, 0x4dbe, 0x84, 0xdf, 0x91, 0x5d, 0xa7, 0x9b, 0x71, 0x53);

	/// <summary>CLSID_D2D1Sharpen</summary>
	public static readonly Guid CLSID_D2D1Sharpen = new(0xC9B887CB, 0xC5FF, 0x4DC5, 0x97, 0x79, 0x27, 0x3D, 0xCF, 0x41, 0x7C, 0x7D);

	/// <summary>CLSID_D2D1Straighten</summary>
	public static readonly Guid CLSID_D2D1Straighten = new(0x4da47b12, 0x79a3, 0x4fb0, 0x82, 0x37, 0xbb, 0xc3, 0xb2, 0xa4, 0xde, 0x08);

	/// <summary>CLSID_D2D1TemperatureTint</summary>
	public static readonly Guid CLSID_D2D1TemperatureTint = new(0x89176087, 0x8AF9, 0x4A08, 0xAE, 0xB1, 0x89, 0x5F, 0x38, 0xDB, 0x17, 0x66);

	/// <summary>CLSID_D2D1Tint</summary>
	public static readonly Guid CLSID_D2D1Tint = new(0x36312b17, 0xf7dd, 0x4014, 0x91, 0x5d, 0xff, 0xca, 0x76, 0x8c, 0xf2, 0x11);

	/// <summary>CLSID_D2D1Vignette</summary>
	public static readonly Guid CLSID_D2D1Vignette = new(0xc00c40be, 0x5e67, 0x4ca3, 0x95, 0xb4, 0xf4, 0xb0, 0x2c, 0x11, 0x51, 0x35);

	/// <summary>CLSID_D2D1WhiteLevelAdjustment</summary>
	public static readonly Guid CLSID_D2D1WhiteLevelAdjustment = new(0x44a1cadb, 0x6cdd, 0x4818, 0x8f, 0xf4, 0x26, 0xc1, 0xcf, 0xe9, 0x5b, 0xdb);

	/// <summary>Identifiers for properties of the <c>Chroma-key effect</c>.</summary>
	// https://learn.microsoft.com/en-us/windows/win32/api/d2d1effects_2/ne-d2d1effects_2-d2d1_chromakey_prop typedef enum
	// D2D1_CHROMAKEY_PROP { D2D1_CHROMAKEY_PROP_COLOR = 0, D2D1_CHROMAKEY_PROP_TOLERANCE = 1, D2D1_CHROMAKEY_PROP_INVERT_ALPHA = 2,
	// D2D1_CHROMAKEY_PROP_FEATHER = 3, D2D1_CHROMAKEY_PROP_FORCE_DWORD = 0xffffffff } ;
	[PInvokeData("d2d1effects_2.h", MSDNShortId = "NE:d2d1effects_2.D2D1_CHROMAKEY_PROP")]
	public enum D2D1_CHROMAKEY_PROP : uint
	{
		/// <summary>
		/// <para>Value:</para>
		/// <para>0</para>
		/// <para>
		/// The D2D1_CHROMAKEY_PROP_COLOR property is a vector4 value indicating the color that should be converted to alpha. The default
		/// color is black.
		/// </para>
		/// </summary>
		[CorrespondingType(typeof(D2D_VECTOR_4F))]
		D2D1_CHROMAKEY_PROP_COLOR,

		/// <summary>
		/// <para>Value:</para>
		/// <para>1</para>
		/// <para>
		/// The D2D1_CHROMAKEY_PROP_TOLERANCE property is a float value indicating the tolerance for matching the color specified in the
		/// D2D1_CHROMAKEY_PROP_COLOR property.
		/// </para>
		/// <para>The allowed range is 0.0 to 1.0. The default value is 0.1.</para>
		/// </summary>
		[CorrespondingType(typeof(float))]
		D2D1_CHROMAKEY_PROP_TOLERANCE,

		/// <summary>
		/// <para>Value:</para>
		/// <para>2</para>
		/// <para>
		/// The D2D1_CHROMAKEY_PROP_INVERT_ALPHA property is a boolean value indicating whether the alpha values should be inverted. The
		/// default value if False.
		/// </para>
		/// </summary>
		[CorrespondingType(typeof(BOOL))]
		D2D1_CHROMAKEY_PROP_INVERT_ALPHA,

		/// <summary>
		/// <para>Value:</para>
		/// <para>3</para>
		/// <para>
		/// The D2D1_CHROMAKEY_PROP_FEATHER property is a boolean value whether the edges of the output should be softened in the alpha channel.
		/// </para>
		/// <para>
		/// When set to False, the alpha output by the effect is 1-bit: either fully opaque or fully transparent. Setting to True results in
		/// a softening of edges in the alpha channel of the Chroma Key output.
		/// </para>
		/// <para>The default value is False.</para>
		/// </summary>
		[CorrespondingType(typeof(BOOL))]
		D2D1_CHROMAKEY_PROP_FEATHER,
	}

	/// <summary>Identifiers for properties of the <c>Contrast effect</c>.</summary>
	// https://learn.microsoft.com/en-us/windows/win32/api/d2d1effects_2/ne-d2d1effects_2-d2d1_contrast_prop typedef enum D2D1_CONTRAST_PROP
	// { D2D1_CONTRAST_PROP_CONTRAST = 0, D2D1_CONTRAST_PROP_CLAMP_INPUT = 1, D2D1_CONTRAST_PROP_FORCE_DWORD = 0xffffffff } ;
	[PInvokeData("d2d1effects_2.h", MSDNShortId = "NE:d2d1effects_2.D2D1_CONTRAST_PROP")]
	public enum D2D1_CONTRAST_PROP : uint
	{
		/// <summary>
		/// <para>Value:</para>
		/// <para>0</para>
		/// <para>
		/// The D2D1_CONTRAST_PROP_CONTRAST property is a float value indicating the amount by which to adjust the contrast of the image.
		/// Negative values reduce contrast, while positive values increase contrast.
		/// </para>
		/// <para>Minimum value is -1.0f, maximum value is 1.0f. The default value for the property is 0.0f.</para>
		/// </summary>
		[CorrespondingType(typeof(float))]
		D2D1_CONTRAST_PROP_CONTRAST,

		/// <summary>
		/// <para>Value:</para>
		/// <para>1</para>
		/// <para>
		/// The D2D1_CONTRAST_PROP_CLAMP_INPUT property is a boolean value indicating whether or not to clamp the input to [0.0, 1.0]. The
		/// default value for the property is FALSE.
		/// </para>
		/// </summary>
		[CorrespondingType(typeof(BOOL))]
		D2D1_CONTRAST_PROP_CLAMP_INPUT,
	}

	/// <summary>Values for the <c>D2D1_EDGEDETECTION_PROP_MODE</c> property of the <c>Edge Detection effect</c>.</summary>
	// https://learn.microsoft.com/en-us/windows/win32/api/d2d1effects_2/ne-d2d1effects_2-d2d1_edgedetection_mode typedef enum
	// D2D1_EDGEDETECTION_MODE { D2D1_EDGEDETECTION_MODE_SOBEL = 0, D2D1_EDGEDETECTION_MODE_PREWITT = 1, D2D1_EDGEDETECTION_MODE_FORCE_DWORD
	// = 0xffffffff } ;
	[PInvokeData("d2d1effects_2.h", MSDNShortId = "NE:d2d1effects_2.D2D1_EDGEDETECTION_MODE")]
	public enum D2D1_EDGEDETECTION_MODE : uint
	{
		/// <summary>
		/// <para>Value:</para>
		/// <para>0</para>
		/// <para>Indicates the Sobel operator should be used for edge detection.</para>
		/// </summary>
		D2D1_EDGEDETECTION_MODE_SOBEL,

		/// <summary>
		/// <para>Value:</para>
		/// <para>1</para>
		/// <para>Indicates the Prewitt operator should be used for edge detection.</para>
		/// </summary>
		D2D1_EDGEDETECTION_MODE_PREWITT,
	}

	/// <summary>Identifiers for properties of the Edge Detection effect.</summary>
	// https://learn.microsoft.com/en-us/windows/win32/api/d2d1effects_2/ne-d2d1effects_2-d2d1_edgedetection_prop typedef enum
	// D2D1_EDGEDETECTION_PROP { D2D1_EDGEDETECTION_PROP_STRENGTH = 0, D2D1_EDGEDETECTION_PROP_BLUR_RADIUS = 1, D2D1_EDGEDETECTION_PROP_MODE
	// = 2, D2D1_EDGEDETECTION_PROP_OVERLAY_EDGES = 3, D2D1_EDGEDETECTION_PROP_ALPHA_MODE = 4, D2D1_EDGEDETECTION_PROP_FORCE_DWORD =
	// 0xffffffff } ;
	[PInvokeData("d2d1effects_2.h", MSDNShortId = "NE:d2d1effects_2.D2D1_EDGEDETECTION_PROP")]
	public enum D2D1_EDGEDETECTION_PROP
	{
		/// <summary>
		/// <para>Value:</para>
		/// <para>0</para>
		/// <para>
		/// The D2D1_EDGEDETECTION_PROP_STRENGTH property is a float value modulating the response of the edge detection filter. A low
		/// strength value means that weaker edges will get filtered out, while a high value means stronger edges will get filtered out. The
		/// allowed range is 0.0 to 1.0. The default value is 0.5.
		/// </para>
		/// </summary>
		[CorrespondingType(typeof(float))]
		D2D1_EDGEDETECTION_PROP_STRENGTH,

		/// <summary>
		/// <para>Value:</para>
		/// <para>1</para>
		/// <para>
		/// The D2D1_EDGEDETECTION_PROP_BLUR_RADIUS property is a float value specifying the amount of blur to apply. Applying blur is used
		/// to remove high frequencies and reduce phantom edges.
		/// </para>
		/// <para>The allowed range is 0.0 to 10.0. The default value is 0.0 (no blur applied).</para>
		/// </summary>
		[CorrespondingType(typeof(float))]
		D2D1_EDGEDETECTION_PROP_BLUR_RADIUS,

		/// <summary>
		/// <para>Value:</para>
		/// <para>2</para>
		/// <para>The D2D1_EDGEDETECTION_PROP_MODE property is a D2D1_EDGEDETECTION_MODE enumeration value which mode to use for edge detection.</para>
		/// <para>The default value is D2D1_EDGEDETECTION_MODE_SOBEL.</para>
		/// </summary>
		[CorrespondingType(typeof(D2D1_EDGEDETECTION_MODE))]
		D2D1_EDGEDETECTION_PROP_MODE,

		/// <summary>
		/// <para>Value:</para>
		/// <para>3</para>
		/// <para>
		/// The D2D1_EDGEDETECTION_PROP_OVERLAY_EDGES property is a boolean value. Edge detection only applies to the RGB channels, the
		/// alpha channel is ignored for purposes of detecting edges.
		/// </para>
		/// <para>
		/// If D2D1_EDGEDETECTION_PROP_OVERLAY_EDGES is false, the output edges is fully opaque. If D2D1_EDGEDETECTION_PROP_OVERLAY_EDGES is
		/// true, the input opacity is preserved.
		/// </para>
		/// <para>The default value is false.</para>
		/// </summary>
		[CorrespondingType(typeof(BOOL))]
		D2D1_EDGEDETECTION_PROP_OVERLAY_EDGES,

		/// <summary>
		/// <para>Value:</para>
		/// <para>4</para>
		/// <para>
		/// The D2D1_EDGEDETECTION_PROP_ALPHA_MODE property is a D2D1_ALPHA_MODE enumeration value indicating the alpha mode of the input file.
		/// </para>
		/// <para>If the input is not opaque, this value is used to determine whether to unpremultiply the inputs.</para>
		/// <para>See the About Alpha Modes section of the Supported Pixel Formats and Alpha Modes topic for additional information.</para>
		/// <para>The default value is D2D1_ALPHA_MODE_PREMULTIPLIED.</para>
		/// </summary>
		[CorrespondingType(typeof(D2D1_ALPHA_MODE))]
		D2D1_EDGEDETECTION_PROP_ALPHA_MODE,
	}

	/// <summary>Identifiers for properties of the <c>Emboss effect</c>.</summary>
	// https://learn.microsoft.com/en-us/windows/win32/api/d2d1effects_2/ne-d2d1effects_2-d2d1_emboss_prop typedef enum D2D1_EMBOSS_PROP {
	// D2D1_EMBOSS_PROP_HEIGHT = 0, D2D1_EMBOSS_PROP_DIRECTION = 1, D2D1_EMBOSS_PROP_FORCE_DWORD = 0xffffffff } ;
	[PInvokeData("d2d1effects_2.h", MSDNShortId = "NE:d2d1effects_2.D2D1_EMBOSS_PROP")]
	public enum D2D1_EMBOSS_PROP
	{
		/// <summary>
		/// <para>Value:</para>
		/// <para>0</para>
		/// <para>
		/// The D2D1_EMBOSS_PROP_HEIGHT property is a float value controlling the strength of the embossing effect. The allowed range is 0.0
		/// to 10.0. The default value is 1.0.
		/// </para>
		/// </summary>
		[CorrespondingType(typeof(float))]
		D2D1_EMBOSS_PROP_HEIGHT,

		/// <summary>
		/// <para>Value:</para>
		/// <para>1</para>
		/// <para>
		/// The D2D1_EMBOSS_PROP_DIRECTION property is a float value specifying the light direction used to create the effect. The allowed
		/// range is 0.0 to 360.0. The default value is 0.0.
		/// </para>
		/// </summary>
		[CorrespondingType(typeof(float))]
		D2D1_EMBOSS_PROP_DIRECTION,
	}

	/// <summary>Identifiers for properties of the <c>Exposure effect</c>.</summary>
	// https://learn.microsoft.com/en-us/windows/win32/api/d2d1effects_2/ne-d2d1effects_2-d2d1_exposure_prop typedef enum D2D1_EXPOSURE_PROP
	// { D2D1_EXPOSURE_PROP_EXPOSURE_VALUE = 0, D2D1_EXPOSURE_PROP_FORCE_DWORD = 0xffffffff } ;
	[PInvokeData("d2d1effects_2.h", MSDNShortId = "NE:d2d1effects_2.D2D1_EXPOSURE_PROP")]
	public enum D2D1_EXPOSURE_PROP
	{
		/// <summary>
		/// <para>Value:</para>
		/// <para>0</para>
		/// <para>
		/// The D2D1_EXPOSURE_PROP_EXPOSURE_VALUE property is a float value that specifies how much to increase or decrease the exposure of
		/// the image. The allowed range is -2.0 to 2.0. The default value is 0.0 (no change).
		/// </para>
		/// </summary>
		[CorrespondingType(typeof(float))]
		D2D1_EXPOSURE_PROP_EXPOSURE_VALUE,
	}

	/// <summary>
	/// Defines constants that specify a value for the <c>D2D1_HDRTONEMAP_PROP_DISPLAY_MODE</c> property of the <c>HDR tone map effect</c>.
	/// </summary>
	// https://learn.microsoft.com/en-us/windows/win32/api/d2d1effects_2/ne-d2d1effects_2-d2d1_hdrtonemap_display_mode typedef enum
	// D2D1_HDRTONEMAP_DISPLAY_MODE { D2D1_HDRTONEMAP_DISPLAY_MODE_SDR, D2D1_HDRTONEMAP_DISPLAY_MODE_HDR,
	// D2D1_HDRTONEMAP_DISPLAY_MODE_FORCE_DWORD } ;
	[PInvokeData("d2d1effects_2.h", MSDNShortId = "NE:d2d1effects_2.D2D1_HDRTONEMAP_DISPLAY_MODE")]
	public enum D2D1_HDRTONEMAP_DISPLAY_MODE
	{
		/// <summary>
		/// <para>Value:</para>
		/// <para>(0)</para>
		/// <para>Specifies that the tone mapper algorithm be optimized for best appearance on a standard dynamic range (SDR) display.</para>
		/// </summary>
		D2D1_HDRTONEMAP_DISPLAY_MODE_SDR,

		/// <summary>
		/// <para>Value:</para>
		/// <para>(1)</para>
		/// <para>Specifies that the tone mapper algorithm be optimized for best appearance on a high dynamic range (HDR) display.</para>
		/// </summary>
		D2D1_HDRTONEMAP_DISPLAY_MODE_HDR,
	}

	/// <summary>
	/// Defines constants that identify the top level properties of the <c>HDR tone map effect</c>. The effect adjusts the maximum luminance
	/// of the source image to fit within the maximum output luminance supported. Input and output luminance values are specified in nits.
	/// Note that the color space of the target image is assumed to be scRGB.
	/// </summary>
	// https://learn.microsoft.com/en-us/windows/win32/api/d2d1effects_2/ne-d2d1effects_2-d2d1_hdrtonemap_prop typedef enum
	// D2D1_HDRTONEMAP_PROP { D2D1_HDRTONEMAP_PROP_INPUT_MAX_LUMINANCE, D2D1_HDRTONEMAP_PROP_OUTPUT_MAX_LUMINANCE,
	// D2D1_HDRTONEMAP_PROP_DISPLAY_MODE, D2D1_HDRTONEMAP_PROP_FORCE_DWORD } ;
	[PInvokeData("d2d1effects_2.h", MSDNShortId = "NE:d2d1effects_2.D2D1_HDRTONEMAP_PROP")]
	public enum D2D1_HDRTONEMAP_PROP
	{
		/// <summary>
		/// <para>Value:</para>
		/// <para>(0)</para>
		/// <para>Identifies the</para>
		/// <para>InputMaxLuminance</para>
		/// <para>property of the effect. The property is of type FLOAT, and is specified in nits.</para>
		/// </summary>
		[CorrespondingType(typeof(float))]
		D2D1_HDRTONEMAP_PROP_INPUT_MAX_LUMINANCE,

		/// <summary>
		/// <para>Value:</para>
		/// <para>(1)</para>
		/// <para>Identifies the</para>
		/// <para>OutputMaxLuminance</para>
		/// <para>property of the effect. The property is of type FLOAT, and is specified in nits.</para>
		/// </summary>
		[CorrespondingType(typeof(float))]
		D2D1_HDRTONEMAP_PROP_OUTPUT_MAX_LUMINANCE,

		/// <summary>
		/// <para>Value:</para>
		/// <para>(2)</para>
		/// <para>Identifies the</para>
		/// <para>DisplayMode</para>
		/// <para>property of the effect. The property is of type</para>
		/// <para><b>D2D1_HDRTONEMAP_DISPLAY_MODE</b></para>
		/// <para>.</para>
		/// </summary>
		[CorrespondingType(typeof(D2D1_HDRTONEMAP_DISPLAY_MODE))]
		D2D1_HDRTONEMAP_PROP_DISPLAY_MODE,
	}

	/// <summary>Values for the <c>D2D1_HIGHLIGHTSANDSHADOWS_PROP_INPUT_GAMMA</c> property of the <c>Highlights and Shadows effect</c>.</summary>
	// https://learn.microsoft.com/en-us/windows/win32/api/d2d1effects_2/ne-d2d1effects_2-d2d1_highlightsandshadows_input_gamma typedef enum
	// D2D1_HIGHLIGHTSANDSHADOWS_INPUT_GAMMA { D2D1_HIGHLIGHTSANDSHADOWS_INPUT_GAMMA_LINEAR = 0, D2D1_HIGHLIGHTSANDSHADOWS_INPUT_GAMMA_SRGB
	// = 1, D2D1_HIGHLIGHTSANDSHADOWS_INPUT_GAMMA_FORCE_DWORD = 0xffffffff } ;
	[PInvokeData("d2d1effects_2.h", MSDNShortId = "NE:d2d1effects_2.D2D1_HIGHLIGHTSANDSHADOWS_INPUT_GAMMA")]
	public enum D2D1_HIGHLIGHTSANDSHADOWS_INPUT_GAMMA
	{
		/// <summary>
		/// <para>Value:</para>
		/// <para>0</para>
		/// <para>Indicates the input image is in linear gamma space.</para>
		/// </summary>
		D2D1_HIGHLIGHTSANDSHADOWS_INPUT_GAMMA_LINEAR,

		/// <summary>
		/// <para>Value:</para>
		/// <para>1</para>
		/// <para>Indicates the input image is sRGB gamma space.</para>
		/// </summary>
		D2D1_HIGHLIGHTSANDSHADOWS_INPUT_GAMMA_SRGB,
	}

	/// <summary>Identifiers for properties of the <c>Highlights and Shadows effect</c>.</summary>
	// https://learn.microsoft.com/en-us/windows/win32/api/d2d1effects_2/ne-d2d1effects_2-d2d1_highlightsandshadows_prop typedef enum
	// D2D1_HIGHLIGHTSANDSHADOWS_PROP { D2D1_HIGHLIGHTSANDSHADOWS_PROP_HIGHLIGHTS = 0, D2D1_HIGHLIGHTSANDSHADOWS_PROP_SHADOWS = 1,
	// D2D1_HIGHLIGHTSANDSHADOWS_PROP_CLARITY = 2, D2D1_HIGHLIGHTSANDSHADOWS_PROP_INPUT_GAMMA = 3,
	// D2D1_HIGHLIGHTSANDSHADOWS_PROP_MASK_BLUR_RADIUS = 4, D2D1_HIGHLIGHTSANDSHADOWS_PROP_FORCE_DWORD = 0xffffffff } ;
	[PInvokeData("d2d1effects_2.h", MSDNShortId = "NE:d2d1effects_2.D2D1_HIGHLIGHTSANDSHADOWS_PROP")]
	public enum D2D1_HIGHLIGHTSANDSHADOWS_PROP
	{
		/// <summary>
		/// <para>Value:</para>
		/// <para>0</para>
		/// <para>
		/// The D2D1_HIGHLIGHTSANDSHADOWS_PROP_HIGHLIGHTS property is a float value indicating how much to increase or decrease highlights.
		/// The allowed range is -1.0 to 1.0. The default value is 0.0.
		/// </para>
		/// </summary>
		[CorrespondingType(typeof(float))]
		D2D1_HIGHLIGHTSANDSHADOWS_PROP_HIGHLIGHTS,

		/// <summary>
		/// <para>Value:</para>
		/// <para>1</para>
		/// <para>
		/// The D2D1_HIGHLIGHTSANDSHADOWS_PROP_SHADOWS property is a float value indicating how much to increase or decrease shadows. The
		/// allowed range is -1.0 to 1.0. The default value is 0.0.
		/// </para>
		/// </summary>
		[CorrespondingType(typeof(float))]
		D2D1_HIGHLIGHTSANDSHADOWS_PROP_SHADOWS,

		/// <summary>
		/// <para>Value:</para>
		/// <para>2</para>
		/// <para>
		/// The D2D1_HIGHLIGHTSANDSHADOWS_PROP_CLARITY property is a float value indicating how much to increase or decrease clarity. The
		/// allowed range is -1.0 to 1.0. The default value is 0.0.
		/// </para>
		/// </summary>
		[CorrespondingType(typeof(float))]
		D2D1_HIGHLIGHTSANDSHADOWS_PROP_CLARITY,

		/// <summary>
		/// <para>Value:</para>
		/// <para>3</para>
		/// <para>The D2D1_HIGHLIGHTSANDSHADOWS_PROP_INPUT_GAMMA property is a</para>
		/// <para>D2D1_HIGHLIGHTSANDSHADOWS_INPUT_GAMMA</para>
		/// <para>enumeration value</para>
		/// <para>
		/// indicating the gamma of the input image. The Highlights and Shadows effect works in linear gamma space, so if the input image is
		/// know to be linear, the D2D1_HIGHLIGHTSANDSHADOWS_INPUT_GAMMA_LINEAR value should be used to prevent sRGB to linear conversions
		/// from being performed.
		/// </para>
		/// </summary>
		[CorrespondingType(typeof(D2D1_HIGHLIGHTSANDSHADOWS_INPUT_GAMMA))]
		D2D1_HIGHLIGHTSANDSHADOWS_PROP_INPUT_GAMMA,

		/// <summary>
		/// <para>Value:</para>
		/// <para>4</para>
		/// <para>
		/// The D2D1_HIGHLIGHTSANDSHADOWS_PROP_MASK_BLUR_RADIUS property is a float value controlling the size of the region used around a
		/// pixel to classify the pixel as highlight or shadow. Lower values result in more localized adjustments.
		/// </para>
		/// <para>The allowed range is 0.0 to 10.0. The default value is 1.25.</para>
		/// </summary>
		[CorrespondingType(typeof(float))]
		D2D1_HIGHLIGHTSANDSHADOWS_PROP_MASK_BLUR_RADIUS,
	}

	/// <summary>Values for the <c>D2D1_HUETORGB_PROP_INPUT_COLOR_SPACE</c> property of the <c>Hue to RGB effect</c>.</summary>
	// https://learn.microsoft.com/en-us/windows/win32/api/d2d1effects_2/ne-d2d1effects_2-d2d1_huetorgb_input_color_space typedef enum
	// D2D1_HUETORGB_INPUT_COLOR_SPACE { D2D1_HUETORGB_INPUT_COLOR_SPACE_HUE_SATURATION_VALUE = 0,
	// D2D1_HUETORGB_INPUT_COLOR_SPACE_HUE_SATURATION_LIGHTNESS = 1, D2D1_HUETORGB_INPUT_COLOR_SPACE_FORCE_DWORD = 0xffffffff } ;
	[PInvokeData("d2d1effects_2.h", MSDNShortId = "NE:d2d1effects_2.D2D1_HUETORGB_INPUT_COLOR_SPACE")]
	public enum D2D1_HUETORGB_INPUT_COLOR_SPACE : uint
	{
		/// <summary>
		/// <para>Value:</para>
		/// <para>0</para>
		/// <para>The effect converts from Hue Saturation Value (HSV) to RGB.</para>
		/// </summary>
		D2D1_HUETORGB_INPUT_COLOR_SPACE_HUE_SATURATION_VALUE,

		/// <summary>
		/// <para>Value:</para>
		/// <para>1</para>
		/// <para>The effect converts from Hue Saturation Lightness (HSL) to RGB.</para>
		/// </summary>
		D2D1_HUETORGB_INPUT_COLOR_SPACE_HUE_SATURATION_LIGHTNESS,
	}

	/// <summary>Identifiers for properties of the <c>Hue to RGB effect</c>.</summary>
	// https://learn.microsoft.com/en-us/windows/win32/api/d2d1effects_2/ne-d2d1effects_2-d2d1_huetorgb_prop typedef enum D2D1_HUETORGB_PROP
	// { D2D1_HUETORGB_PROP_INPUT_COLOR_SPACE = 0, D2D1_HUETORGB_PROP_FORCE_DWORD = 0xffffffff } ;
	[PInvokeData("d2d1effects_2.h", MSDNShortId = "NE:d2d1effects_2.D2D1_HUETORGB_PROP")]
	public enum D2D1_HUETORGB_PROP
	{
		/// <summary>
		/// <para>Value:</para>
		/// <para>0</para>
		/// <para>
		/// The D2D1_HUETORGB_PROP_INPUT_COLOR_SPACE property is an enumeration value which indicates which color space to convert from.
		/// </para>
		/// <para>The default value for the property is D2D1_HUETORGB_INPUT_COLOR_SPACE_HUE_SATURATION_VALUE.</para>
		/// <para>See</para>
		/// <para>D2D1_HUETORGB_INPUT_COLOR_SPACE</para>
		/// <para>enumeration for more information.</para>
		/// </summary>
		[CorrespondingType(typeof(D2D1_HUETORGB_INPUT_COLOR_SPACE))]
		D2D1_HUETORGB_PROP_INPUT_COLOR_SPACE,
	}

	/// <summary>Identifiers for the properties of the 3D Lookup Table effect.</summary>
	// https://learn.microsoft.com/en-us/windows/win32/api/d2d1effects_2/ne-d2d1effects_2-d2d1_lookuptable3d_prop typedef enum
	// D2D1_LOOKUPTABLE3D_PROP { D2D1_LOOKUPTABLE3D_PROP_LUT = 0, D2D1_LOOKUPTABLE3D_PROP_ALPHA_MODE = 1,
	// D2D1_LOOKUPTABLE3D_PROP_FORCE_DWORD = 0xffffffff } ;
	[PInvokeData("d2d1effects_2.h", MSDNShortId = "NE:d2d1effects_2.D2D1_LOOKUPTABLE3D_PROP")]
	public enum D2D1_LOOKUPTABLE3D_PROP
	{
		/// <summary>
		/// <para>Value:</para>
		/// <para>0</para>
		/// <para>The D2D1_LOOKUPTABLE3D_PROP_LUT property is a pointer to an</para>
		/// <para>ID2D1LookupTable3D</para>
		/// <para>object. The default value is null.</para>
		/// </summary>
		[CorrespondingType(typeof(ID2D1LookupTable3D))]
		D2D1_LOOKUPTABLE3D_PROP_LUT,

		/// <summary>
		/// <para>Value:</para>
		/// <para>1</para>
		/// <para>The D2D1_LOOKUPTABLE3D_PROP_ALPHA_MODE property is a</para>
		/// <para>D2D1_ALPHA_MODE</para>
		/// <para>value indicating the alpha mode of the input file.</para>
		/// <para>See the About Alpha Modes section of the</para>
		/// <para>Supported Pixel Formats and Alpha Modes</para>
		/// <para>topic for additional information.</para>
		/// </summary>
		[CorrespondingType(typeof(D2D1_ALPHA_MODE))]
		D2D1_LOOKUPTABLE3D_PROP_ALPHA_MODE,
	}

	/// <summary>Identifiers for properties of the <c>Posterize effect</c>.</summary>
	// https://learn.microsoft.com/en-us/windows/win32/api/d2d1effects_2/ne-d2d1effects_2-d2d1_posterize_prop typedef enum
	// D2D1_POSTERIZE_PROP { D2D1_POSTERIZE_PROP_RED_VALUE_COUNT = 0, D2D1_POSTERIZE_PROP_GREEN_VALUE_COUNT = 1,
	// D2D1_POSTERIZE_PROP_BLUE_VALUE_COUNT = 2, D2D1_POSTERIZE_PROP_FORCE_DWORD = 0xffffffff } ;
	[PInvokeData("d2d1effects_2.h", MSDNShortId = "NE:d2d1effects_2.D2D1_POSTERIZE_PROP")]
	public enum D2D1_POSTERIZE_PROP : uint
	{
		/// <summary>
		/// <para>Value:</para>
		/// <para>0</para>
		/// <para>
		/// The D2D1_POSTERIZE_PROP_RED_VALUE_COUNT property is an integer value specifying how many evenly spaced steps to divide the red
		/// channel range of 0.0 to 1.0 into.
		/// </para>
		/// <para>
		/// For example, a value of 4 generates a table with 4 steps, [0.0, 0.33, 0.67, 1.0]. The allowed range for this property is 2 to
		/// 16. The default value is 4.
		/// </para>
		/// </summary>
		[CorrespondingType(typeof(uint))]
		D2D1_POSTERIZE_PROP_RED_VALUE_COUNT,

		/// <summary>
		/// <para>Value:</para>
		/// <para>1</para>
		/// <para>
		/// The D2D1_POSTERIZE_PROP_GREEN_VALUE_COUNT property is an integer value specifying how many evenly spaced steps to divide the
		/// green channel range of 0.0 to 1.0 into.
		/// </para>
		/// <para>
		/// For example, a value of 4 generates a table with 4 steps, [0.0, 0.33, 0.67, 1.0]. The allowed range for this property is 2 to
		/// 16. The default value is 4.
		/// </para>
		/// </summary>
		[CorrespondingType(typeof(uint))]
		D2D1_POSTERIZE_PROP_GREEN_VALUE_COUNT,

		/// <summary>
		/// <para>Value:</para>
		/// <para>2</para>
		/// <para>
		/// The D2D1_POSTERIZE_PROP_BLUE_VALUE_COUNT property is an integer value specifying how many evenly spaced steps to divide the blue
		/// channel range of 0.0 to 1.0 into.
		/// </para>
		/// <para>
		/// For example, a value of 4 generates a table with 4 steps, [0.0, 0.33, 0.67, 1.0]. The allowed range for this property is 2 to
		/// 16. The default value is 4.
		/// </para>
		/// </summary>
		[CorrespondingType(typeof(uint))]
		D2D1_POSTERIZE_PROP_BLUE_VALUE_COUNT,
	}

	/// <summary>Values for the <c>D2D1_RGBTOHUE_PROP_OUTPUT_COLOR_SPACE</c> property of the <c>RGB to Hue effect</c>.</summary>
	// https://learn.microsoft.com/en-us/windows/win32/api/d2d1effects_2/ne-d2d1effects_2-d2d1_rgbtohue_output_color_space typedef enum
	// D2D1_RGBTOHUE_OUTPUT_COLOR_SPACE { D2D1_RGBTOHUE_OUTPUT_COLOR_SPACE_HUE_SATURATION_VALUE = 0,
	// D2D1_RGBTOHUE_OUTPUT_COLOR_SPACE_HUE_SATURATION_LIGHTNESS = 1, D2D1_RGBTOHUE_OUTPUT_COLOR_SPACE_FORCE_DWORD = 0xffffffff } ;
	[PInvokeData("d2d1effects_2.h", MSDNShortId = "NE:d2d1effects_2.D2D1_RGBTOHUE_OUTPUT_COLOR_SPACE")]
	public enum D2D1_RGBTOHUE_OUTPUT_COLOR_SPACE : uint
	{
		/// <summary>
		/// <para>Value:</para>
		/// <para>0</para>
		/// <para>The effect converts from RGB to Hue Saturation Value (HSV).</para>
		/// </summary>
		D2D1_RGBTOHUE_OUTPUT_COLOR_SPACE_HUE_SATURATION_VALUE,

		/// <summary>
		/// <para>Value:</para>
		/// <para>1</para>
		/// <para>The effect converts from RGB to Hue Saturation Lightness (HSL).</para>
		/// </summary>
		D2D1_RGBTOHUE_OUTPUT_COLOR_SPACE_HUE_SATURATION_LIGHTNESS,
	}

	/// <summary>Identifiers for properties of the <c>RGB to Hue effect</c>.</summary>
	// https://learn.microsoft.com/en-us/windows/win32/api/d2d1effects_2/ne-d2d1effects_2-d2d1_rgbtohue_prop typedef enum D2D1_RGBTOHUE_PROP
	// { D2D1_RGBTOHUE_PROP_OUTPUT_COLOR_SPACE = 0, D2D1_RGBTOHUE_PROP_FORCE_DWORD = 0xffffffff } ;
	[PInvokeData("d2d1effects_2.h", MSDNShortId = "NE:d2d1effects_2.D2D1_RGBTOHUE_PROP")]
	public enum D2D1_RGBTOHUE_PROP : uint
	{
		/// <summary>
		/// <para>Value:</para>
		/// <para>0</para>
		/// <para>
		/// The D2D1_RGBTOHUE_PROP_OUTPUT_COLOR_SPACE property is an enumeration value which indicates the color space to convert to.
		/// </para>
		/// <para>The default value for the property is D2D1_RGBTOHUE_OUTPUT_COLOR_SPACE_HUE_SATURATION_VALUE.</para>
		/// <para>See the</para>
		/// <para>D2D1_RGBTOHUE_OUTPUT_COLOR_SPACE</para>
		/// <para>enumeration for more information.</para>
		/// </summary>
		[CorrespondingType(typeof(D2D1_RGBTOHUE_OUTPUT_COLOR_SPACE))]
		D2D1_RGBTOHUE_PROP_OUTPUT_COLOR_SPACE,
	}

	/// <summary>Identifiers for properties of the <c>Sepia effect</c>.</summary>
	// https://learn.microsoft.com/en-us/windows/win32/api/d2d1effects_2/ne-d2d1effects_2-d2d1_sepia_prop typedef enum D2D1_SEPIA_PROP {
	// D2D1_SEPIA_PROP_INTENSITY = 0, D2D1_SEPIA_PROP_ALPHA_MODE = 1, D2D1_SEPIA_PROP_FORCE_DWORD = 0xffffffff } ;
	[PInvokeData("d2d1effects_2.h", MSDNShortId = "NE:d2d1effects_2.D2D1_SEPIA_PROP")]
	public enum D2D1_SEPIA_PROP : uint
	{
		/// <summary>
		/// <para>Value:</para>
		/// <para>0</para>
		/// <para>
		/// The D2D1_SEPIA_PROP_INTENSITY property is a float value indicating the intensity of the sepia effect. The allowed range is 0.0
		/// to 1.0. The default value is 0.5.
		/// </para>
		/// </summary>
		[CorrespondingType(typeof(float))]
		D2D1_SEPIA_PROP_INTENSITY,

		/// <summary>
		/// <para>Value:</para>
		/// <para>1</para>
		/// <para>The D2D1_SEPIA_PROP_ALPHA_MODE property is a</para>
		/// <para>D2D1_ALPHA_MODE</para>
		/// <para>enumeration value indicating the alpha mode of the input file.</para>
		/// <para>See the About Alpha Modes section of the</para>
		/// <para>Supported Pixel Formats and Alpha Modes</para>
		/// <para>topic for additional information..</para>
		/// <para>The default value is D2D1_ALPHA_MODE_PREMULTIPLIED.</para>
		/// </summary>
		[CorrespondingType(typeof(D2D1_ALPHA_MODE))]
		D2D1_SEPIA_PROP_ALPHA_MODE,
	}

	/// <summary>Identifiers for properties of the <c>Sharpen effect</c>.</summary>
	// https://learn.microsoft.com/en-us/windows/win32/api/d2d1effects_2/ne-d2d1effects_2-d2d1_sharpen_prop typedef enum D2D1_SHARPEN_PROP {
	// D2D1_SHARPEN_PROP_SHARPNESS = 0, D2D1_SHARPEN_PROP_THRESHOLD = 1, D2D1_SHARPEN_PROP_FORCE_DWORD = 0xffffffff } ;
	[PInvokeData("d2d1effects_2.h", MSDNShortId = "NE:d2d1effects_2.D2D1_SHARPEN_PROP")]
	public enum D2D1_SHARPEN_PROP : uint
	{
		/// <summary>
		/// <para>Value:</para>
		/// <para>0</para>
		/// <para>
		/// The D2D1_SHARPEN_PROP_SHARPNESS property is a float value indicating how much to sharpen the input image. The allowed range is
		/// 0.0 to 10.0. The default value is 0.0.
		/// </para>
		/// </summary>
		[CorrespondingType(typeof(float))]
		D2D1_SHARPEN_PROP_SHARPNESS,

		/// <summary>
		/// <para>Value:</para>
		/// <para>1</para>
		/// <para>The D2D1_SHARPEN_PROP_THRESHOLD property is a float value. The allowed range is 0.0 to 1.0. The default value is 0.0.</para>
		/// </summary>
		[CorrespondingType(typeof(float))]
		D2D1_SHARPEN_PROP_THRESHOLD,
	}

	/// <summary>Identifiers for properties of the <c>Straighten effect</c>.</summary>
	// https://learn.microsoft.com/en-us/windows/win32/api/d2d1effects_2/ne-d2d1effects_2-d2d1_straighten_prop typedef enum
	// D2D1_STRAIGHTEN_PROP { D2D1_STRAIGHTEN_PROP_ANGLE = 0, D2D1_STRAIGHTEN_PROP_MAINTAIN_SIZE = 1, D2D1_STRAIGHTEN_PROP_SCALE_MODE = 2,
	// D2D1_STRAIGHTEN_PROP_FORCE_DWORD = 0xffffffff } ;
	[PInvokeData("d2d1effects_2.h", MSDNShortId = "NE:d2d1effects_2.D2D1_STRAIGHTEN_PROP")]
	public enum D2D1_STRAIGHTEN_PROP : uint
	{
		/// <summary>
		/// <para>Value:</para>
		/// <para>0</para>
		/// <para>
		/// The D2D1_STRAIGHTEN_PROP_ANGLE property is a float value that specifies how much the image should be rotated. The allowed range
		/// is -45.0 to 45.0. The default value is 0.0.
		/// </para>
		/// </summary>
		[CorrespondingType(typeof(float))]
		D2D1_STRAIGHTEN_PROP_ANGLE,

		/// <summary>
		/// <para>Value:</para>
		/// <para>1</para>
		/// <para>
		/// The D2D1_STRAIGHTEN_PROP_MAINTAIN_SIZE property is a boolean value that specifies whether the image will be scaled such that the
		/// original size is maintained without any invalid regions.
		/// </para>
		/// <para>The default value is True.</para>
		/// </summary>
		[CorrespondingType(typeof(BOOL))]
		D2D1_STRAIGHTEN_PROP_MAINTAIN_SIZE,

		/// <summary>
		/// <para>Value:</para>
		/// <para>2</para>
		/// <para>The D2D1_STRAIGHTEN_PROP_SCALE_MODE property is a</para>
		/// <para>D2D1_STRAIGHTEN_SCALE_MODE</para>
		/// <para>enumeration value indicating the scaling mode that should be used.</para>
		/// </summary>
		[CorrespondingType(typeof(D2D1_STRAIGHTEN_SCALE_MODE))]
		D2D1_STRAIGHTEN_PROP_SCALE_MODE,
	}

	/// <summary>Values for the <c>D2D1_STRAIGHTEN_PROP_SCALE_MODE</c> property of the <c>Straighten effect</c>.</summary>
	// https://learn.microsoft.com/en-us/windows/win32/api/d2d1effects_2/ne-d2d1effects_2-d2d1_straighten_scale_mode typedef enum
	// D2D1_STRAIGHTEN_SCALE_MODE { D2D1_STRAIGHTEN_SCALE_MODE_NEAREST_NEIGHBOR = 0, D2D1_STRAIGHTEN_SCALE_MODE_LINEAR = 1,
	// D2D1_STRAIGHTEN_SCALE_MODE_CUBIC = 2, D2D1_STRAIGHTEN_SCALE_MODE_MULTI_SAMPLE_LINEAR = 3, D2D1_STRAIGHTEN_SCALE_MODE_ANISOTROPIC = 4,
	// D2D1_STRAIGHTEN_SCALE_MODE_FORCE_DWORD = 0xffffffff } ;
	[PInvokeData("d2d1effects_2.h", MSDNShortId = "NE:d2d1effects_2.D2D1_STRAIGHTEN_SCALE_MODE")]
	public enum D2D1_STRAIGHTEN_SCALE_MODE : uint
	{
		/// <summary>
		/// <para>Value:</para>
		/// <para>0</para>
		/// <para>Indicates nearest neighbor interpolation should be used.</para>
		/// </summary>
		D2D1_STRAIGHTEN_SCALE_MODE_NEAREST_NEIGHBOR,

		/// <summary>
		/// <para>Value:</para>
		/// <para>1</para>
		/// <para>Indicates linear interpolation should be used.</para>
		/// </summary>
		D2D1_STRAIGHTEN_SCALE_MODE_LINEAR,

		/// <summary>
		/// <para>Value:</para>
		/// <para>2</para>
		/// <para>Indicates cubic interpolation should be used.</para>
		/// </summary>
		D2D1_STRAIGHTEN_SCALE_MODE_CUBIC,

		/// <summary>
		/// <para>Value:</para>
		/// <para>3</para>
		/// <para>Indicates multi-sample linear interpolation should be used.</para>
		/// </summary>
		D2D1_STRAIGHTEN_SCALE_MODE_MULTI_SAMPLE_LINEAR,

		/// <summary>
		/// <para>Value:</para>
		/// <para>4</para>
		/// <para>Indicates anisotropic filtering should be used.</para>
		/// </summary>
		D2D1_STRAIGHTEN_SCALE_MODE_ANISOTROPIC,
	}

	/// <summary>Identifiers for properties of the <c>Temperature and Tint effect</c>.</summary>
	// https://learn.microsoft.com/en-us/windows/win32/api/d2d1effects_2/ne-d2d1effects_2-d2d1_temperatureandtint_prop typedef enum
	// D2D1_TEMPERATUREANDTINT_PROP { D2D1_TEMPERATUREANDTINT_PROP_TEMPERATURE = 0, D2D1_TEMPERATUREANDTINT_PROP_TINT = 1,
	// D2D1_TEMPERATUREANDTINT_PROP_FORCE_DWORD = 0xffffffff } ;
	[PInvokeData("d2d1effects_2.h", MSDNShortId = "NE:d2d1effects_2.D2D1_TEMPERATUREANDTINT_PROP")]
	public enum D2D1_TEMPERATUREANDTINT_PROP
	{
		/// <summary>
		/// <para>Value:</para>
		/// <para>0</para>
		/// <para>
		/// The D2D1_TEMPERATUREANDTINT_PROP_TEMPERATURE property is a float value specifying how much to increase or decrease the
		/// temperature of the input image. The allowed range is -1.0 to 1.0. The default value is 0.0.
		/// </para>
		/// </summary>
		[CorrespondingType(typeof(float))]
		D2D1_TEMPERATUREANDTINT_PROP_TEMPERATURE,

		/// <summary>
		/// <para>Value:</para>
		/// <para>1</para>
		/// <para>
		/// The D2D1_TEMPERATUREANDTINT_PROP_TINT property is a float value specifying how much to increase or decrease the tint of the
		/// input image. The allowed range is -1.0 to 1.0. The default value is 0.0.
		/// </para>
		/// </summary>
		[CorrespondingType(typeof(float))]
		D2D1_TEMPERATUREANDTINT_PROP_TINT,
	}

	/// <summary>Identifiers for properties of the <c>Vignette effect</c>.</summary>
	// https://learn.microsoft.com/en-us/windows/win32/api/d2d1effects_2/ne-d2d1effects_2-d2d1_vignette_prop typedef enum D2D1_VIGNETTE_PROP
	// { D2D1_VIGNETTE_PROP_COLOR = 0, D2D1_VIGNETTE_PROP_TRANSITION_SIZE = 1, D2D1_VIGNETTE_PROP_STRENGTH = 2,
	// D2D1_VIGNETTE_PROP_FORCE_DWORD = 0xffffffff } ;
	[PInvokeData("d2d1effects_2.h", MSDNShortId = "NE:d2d1effects_2.D2D1_VIGNETTE_PROP")]
	public enum D2D1_VIGNETTE_PROP : uint
	{
		/// <summary>
		/// <para>Value:</para>
		/// <para>0</para>
		/// <para>
		/// The D2D1_VIGNETTE_PROP_COLOR property is an RGB triplet that specifies the color to fade the image's edges to. The default color
		/// is black.
		/// </para>
		/// </summary>
		[CorrespondingType(typeof(D3DCOLORVALUE))]
		D2D1_VIGNETTE_PROP_COLOR,

		/// <summary>
		/// <para>Value:</para>
		/// <para>1</para>
		/// <para>
		/// The D2D1_VIGNETTE_PROP_TRANSITION_SIZE property is a float value that specifies the size of the vignette region as a percentage
		/// of the full image region.
		/// </para>
		/// <para>
		/// A size of 0 means the unfaded region is the entire image, while a size of 1 means the faded region is the entire source image.
		/// </para>
		/// <para>The allowed range is 0.0 to 1.0. The default value is 0.1.</para>
		/// </summary>
		[CorrespondingType(typeof(float))]
		D2D1_VIGNETTE_PROP_TRANSITION_SIZE,

		/// <summary>
		/// <para>Value:</para>
		/// <para>2</para>
		/// <para>
		/// The D2D1_VIGNETTE_PROP_STRENGTH property is a float value that specifies how much the vignette color bleeds in for a given
		/// transition size.
		/// </para>
		/// <para>The allowed range is 0.0 to 1.0. The default value is 0.5.</para>
		/// </summary>
		[CorrespondingType(typeof(float))]
		D2D1_VIGNETTE_PROP_STRENGTH,
	}

	/// <summary>
	/// Defines constants that identify the top level properties of the <c>White level adjustment effect</c>. The effect adjusts the white
	/// level of the source image by multiplying the source image color by the ratio of the input and output white levels. Input and output
	/// white levels are specified in nits.
	/// </summary>
	// https://learn.microsoft.com/en-us/windows/win32/api/d2d1effects_2/ne-d2d1effects_2-d2d1_whiteleveladjustment_prop typedef enum
	// D2D1_WHITELEVELADJUSTMENT_PROP { D2D1_WHITELEVELADJUSTMENT_PROP_INPUT_WHITE_LEVEL, D2D1_WHITELEVELADJUSTMENT_PROP_OUTPUT_WHITE_LEVEL,
	// D2D1_WHITELEVELADJUSTMENT_PROP_FORCE_DWORD } ;
	[PInvokeData("d2d1effects_2.h", MSDNShortId = "NE:d2d1effects_2.D2D1_WHITELEVELADJUSTMENT_PROP")]
	public enum D2D1_WHITELEVELADJUSTMENT_PROP : uint
	{
		/// <summary>
		/// <para>Value:</para>
		/// <para>(0)</para>
		/// <para>Identifies the</para>
		/// <para>InputWhiteLevel</para>
		/// <para>property of the effect. The property is of type FLOAT, and is specified in nits.</para>
		/// </summary>
		[CorrespondingType(typeof(float))]
		D2D1_WHITELEVELADJUSTMENT_PROP_INPUT_WHITE_LEVEL,

		/// <summary>
		/// <para>Value:</para>
		/// <para>(1)</para>
		/// <para>Identifies the</para>
		/// <para>OutputWhiteLevel</para>
		/// <para>property of the effect. The property is of type FLOAT, and is specified in nits.</para>
		/// </summary>
		[CorrespondingType(typeof(float))]
		D2D1_WHITELEVELADJUSTMENT_PROP_OUTPUT_WHITE_LEVEL,
	}
}