﻿namespace Vanara.PInvoke;

public static partial class D2d1
{
	/// <summary>CLSID_D2D12DAffineTransform</summary>
	public static readonly Guid CLSID_D2D12DAffineTransform = new(0x6AA97485, 0x6354, 0x4cfc, 0x90, 0x8C, 0xE4, 0xA7, 0x4F, 0x62, 0xC9, 0x6C);

	/// <summary>CLSID_D2D13DPerspectiveTransform</summary>
	public static readonly Guid CLSID_D2D13DPerspectiveTransform = new(0xC2844D0B, 0x3D86, 0x46e7, 0x85, 0xBA, 0x52, 0x6C, 0x92, 0x40, 0xF3, 0xFB);

	/// <summary>CLSID_D2D13DTransform</summary>
	public static readonly Guid CLSID_D2D13DTransform = new(0xe8467b04, 0xec61, 0x4b8a, 0xb5, 0xde, 0xd4, 0xd7, 0x3d, 0xeb, 0xea, 0x5a);

	/// <summary>CLSID_D2D1ArithmeticComposite</summary>
	public static readonly Guid CLSID_D2D1ArithmeticComposite = new(0xfc151437, 0x049a, 0x4784, 0xa2, 0x4a, 0xf1, 0xc4, 0xda, 0xf2, 0x09, 0x87);

	/// <summary>CLSID_D2D1Atlas</summary>
	public static readonly Guid CLSID_D2D1Atlas = new(0x913e2be4, 0xfdcf, 0x4fe2, 0xa5, 0xf0, 0x24, 0x54, 0xf1, 0x4f, 0xf4, 0x8);

	/// <summary>CLSID_D2D1BitmapSource</summary>
	public static readonly Guid CLSID_D2D1BitmapSource = new(0x5fb6c24d, 0xc6dd, 0x4231, 0x94, 0x4,  0x50, 0xf4, 0xd5, 0xc3, 0x25, 0x2d);

	/// <summary>CLSID_D2D1Blend</summary>
	public static readonly Guid CLSID_D2D1Blend = new(0x81c5b77b, 0x13f8, 0x4cdd, 0xad, 0x20, 0xc8, 0x90, 0x54, 0x7a, 0xc6, 0x5d);

	/// <summary>CLSID_D2D1Border</summary>
	public static readonly Guid CLSID_D2D1Border = new(0x2A2D49C0, 0x4ACF, 0x43c7, 0x8C, 0x6A, 0x7C, 0x4A, 0x27, 0x87, 0x4D, 0x27);

	/// <summary>CLSID_D2D1Brightness</summary>
	public static readonly Guid CLSID_D2D1Brightness = new(0x8cea8d1e, 0x77b0, 0x4986, 0xb3, 0xb9, 0x2f, 0x0c, 0x0e, 0xae, 0x78, 0x87);

	/// <summary>CLSID_D2D1ColorManagement</summary>
	public static readonly Guid CLSID_D2D1ColorManagement = new(0x1A28524C, 0xFDD6, 0x4AA4, 0xAE, 0x8F, 0x83, 0x7E, 0xB8, 0x26, 0x7B, 0x37);

	/// <summary>CLSID_D2D1ColorMatrix</summary>
	public static readonly Guid CLSID_D2D1ColorMatrix = new(0x921F03D6, 0x641C, 0x47DF, 0x85, 0x2D, 0xB4, 0xBB, 0x61, 0x53, 0xAE, 0x11);

	/// <summary>CLSID_D2D1Composite</summary>
	public static readonly Guid CLSID_D2D1Composite = new(0x48fc9f51, 0xf6ac, 0x48f1, 0x8b, 0x58, 0x3b, 0x28, 0xac, 0x46, 0xf7, 0x6d);

	/// <summary>CLSID_D2D1ConvolveMatrix</summary>
	public static readonly Guid CLSID_D2D1ConvolveMatrix = new(0x407f8c08, 0x5533, 0x4331, 0xa3, 0x41, 0x23, 0xcc, 0x38, 0x77, 0x84, 0x3e);

	/// <summary>CLSID_D2D1Crop</summary>
	public static readonly Guid CLSID_D2D1Crop = new(0xE23F7110, 0x0E9A, 0x4324, 0xAF, 0x47, 0x6A, 0x2C, 0x0C, 0x46, 0xF3, 0x5B);

	/// <summary>CLSID_D2D1DirectionalBlur</summary>
	public static readonly Guid CLSID_D2D1DirectionalBlur = new(0x174319a6, 0x58e9, 0x49b2, 0xbb, 0x63, 0xca, 0xf2, 0xc8, 0x11, 0xa3, 0xdb);

	/// <summary>CLSID_D2D1DiscreteTransfer</summary>
	public static readonly Guid CLSID_D2D1DiscreteTransfer = new(0x90866fcd, 0x488e, 0x454b, 0xaf, 0x06, 0xe5, 0x04, 0x1b, 0x66, 0xc3, 0x6c);

	/// <summary>CLSID_D2D1DisplacementMap</summary>
	public static readonly Guid CLSID_D2D1DisplacementMap = new(0xedc48364, 0x417,  0x4111, 0x94, 0x50, 0x43, 0x84, 0x5f, 0xa9, 0xf8, 0x90);

	/// <summary>CLSID_D2D1DistantDiffuse</summary>
	public static readonly Guid CLSID_D2D1DistantDiffuse = new(0x3e7efd62, 0xa32d, 0x46d4, 0xa8, 0x3c, 0x52, 0x78, 0x88, 0x9a, 0xc9, 0x54);

	/// <summary>CLSID_D2D1DistantSpecular</summary>
	public static readonly Guid CLSID_D2D1DistantSpecular = new(0x428c1ee5, 0x77b8, 0x4450, 0x8a, 0xb5, 0x72, 0x21, 0x9c, 0x21, 0xab, 0xda);

	/// <summary>CLSID_D2D1DpiCompensation</summary>
	public static readonly Guid CLSID_D2D1DpiCompensation = new(0x6c26c5c7, 0x34e0, 0x46fc, 0x9c, 0xfd, 0xe5, 0x82, 0x37, 0x6,  0xe2, 0x28);

	/// <summary>CLSID_D2D1Flood</summary>
	public static readonly Guid CLSID_D2D1Flood = new(0x61c23c20, 0xae69, 0x4d8e, 0x94, 0xcf, 0x50, 0x07, 0x8d, 0xf6, 0x38, 0xf2);

	/// <summary>CLSID_D2D1GammaTransfer</summary>
	public static readonly Guid CLSID_D2D1GammaTransfer = new(0x409444c4, 0xc419, 0x41a0, 0xb0, 0xc1, 0x8c, 0xd0, 0xc0, 0xa1, 0x8e, 0x42);

	/// <summary>CLSID_D2D1GaussianBlur</summary>
	public static readonly Guid CLSID_D2D1GaussianBlur = new(0x1feb6d69, 0x2fe6, 0x4ac9, 0x8c, 0x58, 0x1d, 0x7f, 0x93, 0xe7, 0xa6, 0xa5);

	/// <summary>CLSID_D2D1Scale</summary>
	public static readonly Guid CLSID_D2D1Scale = new(0x9daf9369, 0x3846, 0x4d0e, 0xa4, 0x4e, 0xc,  0x60, 0x79, 0x34, 0xa5, 0xd7);

	/// <summary>CLSID_D2D1Histogram</summary>
	public static readonly Guid CLSID_D2D1Histogram = new(0x881db7d0, 0xf7ee, 0x4d4d, 0xa6, 0xd2, 0x46, 0x97, 0xac, 0xc6, 0x6e, 0xe8);

	/// <summary>CLSID_D2D1HueRotation</summary>
	public static readonly Guid CLSID_D2D1HueRotation = new(0x0f4458ec, 0x4b32, 0x491b, 0x9e, 0x85, 0xbd, 0x73, 0xf4, 0x4d, 0x3e, 0xb6);

	/// <summary>CLSID_D2D1LinearTransfer</summary>
	public static readonly Guid CLSID_D2D1LinearTransfer = new(0xad47c8fd, 0x63ef, 0x4acc, 0x9b, 0x51, 0x67, 0x97, 0x9c, 0x03, 0x6c, 0x06);

	/// <summary>CLSID_D2D1LuminanceToAlpha</summary>
	public static readonly Guid CLSID_D2D1LuminanceToAlpha = new(0x41251ab7, 0x0beb, 0x46f8, 0x9d, 0xa7, 0x59, 0xe9, 0x3f, 0xcc, 0xe5, 0xde);

	/// <summary>CLSID_D2D1Morphology</summary>
	public static readonly Guid CLSID_D2D1Morphology = new(0xeae6c40d, 0x626a, 0x4c2d, 0xbf, 0xcb, 0x39, 0x10, 0x01, 0xab, 0xe2, 0x02);

	/// <summary>CLSID_D2D1OpacityMetadata</summary>
	public static readonly Guid CLSID_D2D1OpacityMetadata = new(0x6c53006a, 0x4450, 0x4199, 0xaa, 0x5b, 0xad, 0x16, 0x56, 0xfe, 0xce, 0x5e);

	/// <summary>CLSID_D2D1PointDiffuse</summary>
	public static readonly Guid CLSID_D2D1PointDiffuse = new(0xb9e303c3, 0xc08c, 0x4f91, 0x8b, 0x7b, 0x38, 0x65, 0x6b, 0xc4, 0x8c, 0x20);

	/// <summary>CLSID_D2D1PointSpecular</summary>
	public static readonly Guid CLSID_D2D1PointSpecular = new(0x09c3ca26, 0x3ae2, 0x4f09, 0x9e, 0xbc, 0xed, 0x38, 0x65, 0xd5, 0x3f, 0x22);

	/// <summary>CLSID_D2D1Premultiply</summary>
	public static readonly Guid CLSID_D2D1Premultiply = new(0x06eab419, 0xdeed, 0x4018, 0x80, 0xd2, 0x3e, 0x1d, 0x47, 0x1a, 0xde, 0xb2);

	/// <summary>CLSID_D2D1Saturation</summary>
	public static readonly Guid CLSID_D2D1Saturation = new(0x5cb2d9cf, 0x327d, 0x459f, 0xa0, 0xce, 0x40, 0xc0, 0xb2, 0x08, 0x6b, 0xf7);

	/// <summary>CLSID_D2D1Shadow</summary>
	public static readonly Guid CLSID_D2D1Shadow = new(0xC67EA361, 0x1863, 0x4e69, 0x89, 0xDB, 0x69, 0x5D, 0x3E, 0x9A, 0x5B, 0x6B);

	/// <summary>CLSID_D2D1SpotDiffuse</summary>
	public static readonly Guid CLSID_D2D1SpotDiffuse = new(0x818a1105, 0x7932, 0x44f4, 0xaa, 0x86, 0x08, 0xae, 0x7b, 0x2f, 0x2c, 0x93);

	/// <summary>CLSID_D2D1SpotSpecular</summary>
	public static readonly Guid CLSID_D2D1SpotSpecular = new(0xedae421e, 0x7654, 0x4a37, 0x9d, 0xb8, 0x71, 0xac, 0xc1, 0xbe, 0xb3, 0xc1);

	/// <summary>CLSID_D2D1TableTransfer</summary>
	public static readonly Guid CLSID_D2D1TableTransfer = new(0x5bf818c3, 0x5e43, 0x48cb, 0xb6, 0x31, 0x86, 0x83, 0x96, 0xd6, 0xa1, 0xd4);

	/// <summary>CLSID_D2D1Tile</summary>
	public static readonly Guid CLSID_D2D1Tile = new(0xB0784138, 0x3B76, 0x4bc5, 0xB1, 0x3B, 0x0F, 0xA2, 0xAD, 0x02, 0x65, 0x9F);

	/// <summary>CLSID_D2D1Turbulence</summary>
	public static readonly Guid CLSID_D2D1Turbulence = new(0xCF2BB6AE, 0x889A, 0x4ad7, 0xBA, 0x29, 0xA2, 0xFD, 0x73, 0x2C, 0x9F, 0xC9);

	/// <summary>CLSID_D2D1UnPremultiply</summary>
	public static readonly Guid CLSID_D2D1UnPremultiply = new(0xfb9ac489, 0xad8d, 0x41ed, 0x99, 0x99, 0xbb, 0x63, 0x47, 0xd1, 0x10, 0xf7);


	/// <summary>
	/// The interpolation mode to be used with the 2D affine transform effect to scale the image. There are 6 scale modes that range in
	/// quality and speed.
	/// </summary>
	// https://learn.microsoft.com/en-us/windows/win32/api/d2d1effects/ne-d2d1effects-d2d1_2daffinetransform_interpolation_mode typedef enum
	// D2D1_2DAFFINETRANSFORM_INTERPOLATION_MODE { D2D1_2DAFFINETRANSFORM_INTERPOLATION_MODE_NEAREST_NEIGHBOR = 0,
	// D2D1_2DAFFINETRANSFORM_INTERPOLATION_MODE_LINEAR = 1, D2D1_2DAFFINETRANSFORM_INTERPOLATION_MODE_CUBIC = 2,
	// D2D1_2DAFFINETRANSFORM_INTERPOLATION_MODE_MULTI_SAMPLE_LINEAR = 3, D2D1_2DAFFINETRANSFORM_INTERPOLATION_MODE_ANISOTROPIC = 4,
	// D2D1_2DAFFINETRANSFORM_INTERPOLATION_MODE_HIGH_QUALITY_CUBIC = 5, D2D1_2DAFFINETRANSFORM_INTERPOLATION_MODE_FORCE_DWORD = 0xffffffff
	// } ;
	[PInvokeData("d2d1effects.h", MSDNShortId = "NE:d2d1effects.D2D1_2DAFFINETRANSFORM_INTERPOLATION_MODE")]
	public enum D2D1_2DAFFINETRANSFORM_INTERPOLATION_MODE : uint
	{
		/// <summary>
		/// <para>Value:</para>
		/// <para>0</para>
		/// <para>Samples the nearest single point and uses that. This mode uses less processing time, but outputs the lowest quality image.</para>
		/// </summary>
		D2D1_2DAFFINETRANSFORM_INTERPOLATION_MODE_NEAREST_NEIGHBOR,

		/// <summary>
		/// <para>Value:</para>
		/// <para>1</para>
		/// <para>
		/// Uses a four point sample and linear interpolation. This mode uses more processing time than the nearest neighbor mode, but
		/// outputs a higher quality image.
		/// </para>
		/// </summary>
		D2D1_2DAFFINETRANSFORM_INTERPOLATION_MODE_LINEAR,

		/// <summary>
		/// <para>Value:</para>
		/// <para>2</para>
		/// <para>
		/// Uses a 16 sample cubic kernel for interpolation. This mode uses the most processing time, but outputs a higher quality image.
		/// </para>
		/// </summary>
		D2D1_2DAFFINETRANSFORM_INTERPOLATION_MODE_CUBIC,

		/// <summary>
		/// <para>Value:</para>
		/// <para>3</para>
		/// <para>
		/// Uses 4 linear samples within a single pixel for good edge anti-aliasing. This mode is good for scaling down by small amounts on
		/// images with few pixels.
		/// </para>
		/// </summary>
		D2D1_2DAFFINETRANSFORM_INTERPOLATION_MODE_MULTI_SAMPLE_LINEAR,

		/// <summary>
		/// <para>Value:</para>
		/// <para>4</para>
		/// <para>Uses anisotropic filtering to sample a pattern according to the transformed shape of the bitmap.</para>
		/// </summary>
		D2D1_2DAFFINETRANSFORM_INTERPOLATION_MODE_ANISOTROPIC,

		/// <summary>
		/// <para>Value:</para>
		/// <para>5</para>
		/// <para>
		/// Uses a variable size high quality cubic kernel to perform a pre-downscale the image if downscaling is involved in the transform
		/// matrix. Then uses the cubic interpolation mode for the final output.
		/// </para>
		/// </summary>
		D2D1_2DAFFINETRANSFORM_INTERPOLATION_MODE_HIGH_QUALITY_CUBIC,
	}

	/// <summary>Identifiers for properties of the <c>2D affine transform effect</c>.</summary>
	// https://learn.microsoft.com/en-us/windows/win32/api/d2d1effects/ne-d2d1effects-d2d1_2daffinetransform_prop typedef enum
	// D2D1_2DAFFINETRANSFORM_PROP { D2D1_2DAFFINETRANSFORM_PROP_INTERPOLATION_MODE = 0, D2D1_2DAFFINETRANSFORM_PROP_BORDER_MODE = 1,
	// D2D1_2DAFFINETRANSFORM_PROP_TRANSFORM_MATRIX = 2, D2D1_2DAFFINETRANSFORM_PROP_SHARPNESS = 3, D2D1_2DAFFINETRANSFORM_PROP_FORCE_DWORD
	// = 0xffffffff } ;
	[PInvokeData("d2d1effects.h", MSDNShortId = "NE:d2d1effects.D2D1_2DAFFINETRANSFORM_PROP")]
	public enum D2D1_2DAFFINETRANSFORM_PROP : uint
	{
		/// <summary>
		/// <para>Value:</para>
		/// <para>0</para>
		/// <para>The interpolation mode used to scale the image. There are 6 scale modes that range in quality and speed.</para>
		/// <para>Type is D2D1_2DAFFINETRANSFORM_INTERPOLATION_MODE.</para>
		/// <para>Default value is D2D1_2DAFFINETRANSFORM_INTERPOLATION_MODE_LINEAR.</para>
		/// </summary>
		[CorrespondingType(typeof(D2D1_2DAFFINETRANSFORM_INTERPOLATION_MODE))]
		D2D1_2DAFFINETRANSFORM_PROP_INTERPOLATION_MODE,

		/// <summary>
		/// <para>Value:</para>
		/// <para>1</para>
		/// <para>The mode used to calculate the border of the image, soft or hard.</para>
		/// <para>Type is D2D1_BORDER_MODE.</para>
		/// <para>Default value is D2D1_BORDER_MODE_SOFT.</para>
		/// </summary>
		[CorrespondingType(typeof(D2D1_BORDER_MODE))]
		D2D1_2DAFFINETRANSFORM_PROP_BORDER_MODE,

		/// <summary>
		/// <para>Value:</para>
		/// <para>2</para>
		/// <para>The 3x2 matrix to transform the image using the Direct2D matrix transform.</para>
		/// <para>Type is D2D1_MATRIX_3X2_F.</para>
		/// <para>Default value is Matrix3x2F::Identity().</para>
		/// </summary>
		[CorrespondingType(typeof(D2D1_MATRIX_3X2_F))]
		D2D1_2DAFFINETRANSFORM_PROP_TRANSFORM_MATRIX,

		/// <summary>
		/// <para>Value:</para>
		/// <para>3</para>
		/// <para>
		/// In the high quality cubic interpolation mode, the sharpness level of the scaling filter as a float between 0 and 1. The values
		/// are unitless. You can use sharpness to adjust the quality of an image when you scale the image.
		/// </para>
		/// <para>The sharpness factor affects the shape of the kernel. The higher the sharpness factor, the smaller the kernel.</para>
		/// <para><b>Note</b>  This property affects only the high quality cubic interpolation mode.</para>
		/// <para>Type is FLOAT.</para>
		/// <para>Default value is 1.0f.</para>
		/// </summary>
		[CorrespondingType(typeof(float))]
		D2D1_2DAFFINETRANSFORM_PROP_SHARPNESS,
	}

	/// <summary>
	/// The interpolation mode the <c>3D perspective transform effect</c> uses on the image. There are 5 scale modes that range in quality
	/// and speed.
	/// </summary>
	// https://learn.microsoft.com/en-us/windows/win32/api/d2d1effects/ne-d2d1effects-d2d1_3dperspectivetransform_interpolation_mode typedef
	// enum D2D1_3DPERSPECTIVETRANSFORM_INTERPOLATION_MODE { D2D1_3DPERSPECTIVETRANSFORM_INTERPOLATION_MODE_NEAREST_NEIGHBOR = 0,
	// D2D1_3DPERSPECTIVETRANSFORM_INTERPOLATION_MODE_LINEAR = 1, D2D1_3DPERSPECTIVETRANSFORM_INTERPOLATION_MODE_CUBIC = 2,
	// D2D1_3DPERSPECTIVETRANSFORM_INTERPOLATION_MODE_MULTI_SAMPLE_LINEAR = 3, D2D1_3DPERSPECTIVETRANSFORM_INTERPOLATION_MODE_ANISOTROPIC =
	// 4, D2D1_3DPERSPECTIVETRANSFORM_INTERPOLATION_MODE_FORCE_DWORD = 0xffffffff } ;
	[PInvokeData("d2d1effects.h", MSDNShortId = "NE:d2d1effects.D2D1_3DPERSPECTIVETRANSFORM_INTERPOLATION_MODE")]
	public enum D2D1_3DPERSPECTIVETRANSFORM_INTERPOLATION_MODE : uint
	{
		/// <summary>
		/// <para>Value:</para>
		/// <para>0</para>
		/// <para>Samples the nearest single point and uses that. This mode uses less processing time, but outputs the lowest quality image.</para>
		/// </summary>
		D2D1_3DPERSPECTIVETRANSFORM_INTERPOLATION_MODE_NEAREST_NEIGHBOR,

		/// <summary>
		/// <para>Value:</para>
		/// <para>1</para>
		/// <para>
		/// Uses a four point sample and linear interpolation. This mode uses more processing time than the nearest neighbor mode, but
		/// outputs a higher quality image.
		/// </para>
		/// </summary>
		D2D1_3DPERSPECTIVETRANSFORM_INTERPOLATION_MODE_LINEAR,

		/// <summary>
		/// <para>Value:</para>
		/// <para>2</para>
		/// <para>
		/// Uses a 16 sample cubic kernel for interpolation. This mode uses the most processing time, but outputs a higher quality image.
		/// </para>
		/// </summary>
		D2D1_3DPERSPECTIVETRANSFORM_INTERPOLATION_MODE_CUBIC,

		/// <summary>
		/// <para>Value:</para>
		/// <para>3</para>
		/// <para>
		/// Uses 4 linear samples within a single pixel for good edge anti-aliasing. This mode is good for scaling down by small amounts on
		/// images with few pixels.
		/// </para>
		/// </summary>
		D2D1_3DPERSPECTIVETRANSFORM_INTERPOLATION_MODE_MULTI_SAMPLE_LINEAR,

		/// <summary>
		/// <para>Value:</para>
		/// <para>4</para>
		/// <para>Uses anisotropic filtering to sample a pattern according to the transformed shape of the bitmap.</para>
		/// </summary>
		D2D1_3DPERSPECTIVETRANSFORM_INTERPOLATION_MODE_ANISOTROPIC,
	}

	/// <summary>Identifiers for the properties of the <c>3D perspective transform effect</c>.</summary>
	// https://learn.microsoft.com/en-us/windows/win32/api/d2d1effects/ne-d2d1effects-d2d1_3dperspectivetransform_prop typedef enum
	// D2D1_3DPERSPECTIVETRANSFORM_PROP { D2D1_3DPERSPECTIVETRANSFORM_PROP_INTERPOLATION_MODE = 0,
	// D2D1_3DPERSPECTIVETRANSFORM_PROP_BORDER_MODE = 1, D2D1_3DPERSPECTIVETRANSFORM_PROP_DEPTH = 2,
	// D2D1_3DPERSPECTIVETRANSFORM_PROP_PERSPECTIVE_ORIGIN = 3, D2D1_3DPERSPECTIVETRANSFORM_PROP_LOCAL_OFFSET = 4,
	// D2D1_3DPERSPECTIVETRANSFORM_PROP_GLOBAL_OFFSET = 5, D2D1_3DPERSPECTIVETRANSFORM_PROP_ROTATION_ORIGIN = 6,
	// D2D1_3DPERSPECTIVETRANSFORM_PROP_ROTATION = 7, D2D1_3DPERSPECTIVETRANSFORM_PROP_FORCE_DWORD = 0xffffffff } ;
	[PInvokeData("d2d1effects.h", MSDNShortId = "NE:d2d1effects.D2D1_3DPERSPECTIVETRANSFORM_PROP")]
	public enum D2D1_3DPERSPECTIVETRANSFORM_PROP : uint
	{
		/// <summary>
		/// <para>Value:</para>
		/// <para>0</para>
		/// <para>The interpolation mode the effect uses on the image. There are 5 scale modes that range in quality and speed.</para>
		/// <para>Type is D2D1_3DPERSPECTIVETRANSFORM_INTERPOLATION_MODE.</para>
		/// <para>Default value is D2D1_3DPERSPECTIVETRANSFORM_INTERPOLATION_MODE_LINEAR.</para>
		/// </summary>
		[CorrespondingType(typeof(D2D1_3DPERSPECTIVETRANSFORM_INTERPOLATION_MODE))]
		D2D1_3DPERSPECTIVETRANSFORM_PROP_INTERPOLATION_MODE,

		/// <summary>
		/// <para>Value:</para>
		/// <para>1</para>
		/// <para>The mode used to calculate the border of the image, soft or hard. See Border modes for more info.</para>
		/// <para>Type is D2D1_BORDER_MODE.</para>
		/// <para>Default value is D2D1_BORDER_MODE_SOFT.</para>
		/// </summary>
		[CorrespondingType(typeof(D2D1_BORDER_MODE))]
		D2D1_3DPERSPECTIVETRANSFORM_PROP_BORDER_MODE,

		/// <summary>
		/// <para>Value:</para>
		/// <para>2</para>
		/// <para>
		/// The distance from the PerspectiveOrigin to the projection plane. The value specified in DIPs and must be greater than 0.
		/// </para>
		/// <para>Type is FLOAT.</para>
		/// <para>Default value is 1000.0f.</para>
		/// </summary>
		[CorrespondingType(typeof(float))]
		D2D1_3DPERSPECTIVETRANSFORM_PROP_DEPTH,

		/// <summary>
		/// <para>Value:</para>
		/// <para>3</para>
		/// <para>
		/// The X and Y location of the viewer in the 3D scene. This property is a D2D1_VECTOR_2F defined as: (point X, point Y). The units
		/// are in DIPs.
		/// </para>
		/// <para>You set the Z value with the Depth property.</para>
		/// <para>Type is D2D1_VECTOR_2F.</para>
		/// <para>Default value is {0.0f, 0.0f}.</para>
		/// </summary>
		[CorrespondingType(typeof(D2D_VECTOR_2F))]
		D2D1_3DPERSPECTIVETRANSFORM_PROP_PERSPECTIVE_ORIGIN,

		/// <summary>
		/// <para>Value:</para>
		/// <para>4</para>
		/// <para>
		/// A translation the effect performs before it rotates the projection plane. This property is a D2D1_VECTOR_3F defined as: (X, Y,
		/// Z). The units are in DIPs.
		/// </para>
		/// <para>Type is D2D1_VECTOR_3F.</para>
		/// <para>Default value is {0.0f, 0.0f, 0.0f}.</para>
		/// </summary>
		[CorrespondingType(typeof(D2D_VECTOR_3F))]
		D2D1_3DPERSPECTIVETRANSFORM_PROP_LOCAL_OFFSET,

		/// <summary>
		/// <para>Value:</para>
		/// <para>5</para>
		/// <para>
		/// A translation the effect performs after it rotates the projection plane. This property is a D2D1_VECTOR_3F defined as: (X, Y,
		/// Z). The units are in DIPs.
		/// </para>
		/// <para>Type is D2D1_VECTOR_3F.</para>
		/// <para>Default value is {0.0f, 0.0f, 0.0f}.</para>
		/// </summary>
		[CorrespondingType(typeof(D2D_VECTOR_3F))]
		D2D1_3DPERSPECTIVETRANSFORM_PROP_GLOBAL_OFFSET,

		/// <summary>
		/// <para>Value:</para>
		/// <para>6</para>
		/// <para>
		/// The center point of the rotation the effect performs. This property is a D2D1_VECTOR_3F defined as: (X, Y, Z). The units are in DIPs.
		/// </para>
		/// <para>Type is D2D1_VECTOR_3F.</para>
		/// <para>Default value is {0.0f, 0.0f, 0.0f}.</para>
		/// </summary>
		[CorrespondingType(typeof(D2D_VECTOR_3F))]
		D2D1_3DPERSPECTIVETRANSFORM_PROP_ROTATION_ORIGIN,

		/// <summary>
		/// <para>Value:</para>
		/// <para>7</para>
		/// <para>The angles of rotation for each axis. This property is a D2D1_VECTOR_3F defined as: (X, Y, Z). The units are in degrees.</para>
		/// <para>Type is D2D1_VECTOR_3F.</para>
		/// <para>Default value is {0.0f, 0.0f, 0.0f}.</para>
		/// </summary>
		[CorrespondingType(typeof(D2D_VECTOR_3F))]
		D2D1_3DPERSPECTIVETRANSFORM_PROP_ROTATION,
	}

	/// <summary>
	/// The interpolation mode the <c>3D transform effect</c> uses on the image. There are 5 scale modes that range in quality and speed.
	/// </summary>
	// https://learn.microsoft.com/en-us/windows/win32/api/d2d1effects/ne-d2d1effects-d2d1_3dtransform_interpolation_mode typedef enum
	// D2D1_3DTRANSFORM_INTERPOLATION_MODE { D2D1_3DTRANSFORM_INTERPOLATION_MODE_NEAREST_NEIGHBOR = 0,
	// D2D1_3DTRANSFORM_INTERPOLATION_MODE_LINEAR = 1, D2D1_3DTRANSFORM_INTERPOLATION_MODE_CUBIC = 2,
	// D2D1_3DTRANSFORM_INTERPOLATION_MODE_MULTI_SAMPLE_LINEAR = 3, D2D1_3DTRANSFORM_INTERPOLATION_MODE_ANISOTROPIC = 4,
	// D2D1_3DTRANSFORM_INTERPOLATION_MODE_FORCE_DWORD = 0xffffffff } ;
	[PInvokeData("d2d1effects.h", MSDNShortId = "NE:d2d1effects.D2D1_3DTRANSFORM_INTERPOLATION_MODE")]
	public enum D2D1_3DTRANSFORM_INTERPOLATION_MODE : uint
	{
		/// <summary>
		/// <para>Value:</para>
		/// <para>0</para>
		/// <para>Samples the nearest single point and uses that. This mode uses less processing time, but outputs the lowest quality image.</para>
		/// </summary>
		D2D1_3DTRANSFORM_INTERPOLATION_MODE_NEAREST_NEIGHBOR,

		/// <summary>
		/// <para>Value:</para>
		/// <para>1</para>
		/// <para>
		/// Uses a four point sample and linear interpolation. This mode uses more processing time than the nearest neighbor mode, but
		/// outputs a higher quality image.
		/// </para>
		/// </summary>
		D2D1_3DTRANSFORM_INTERPOLATION_MODE_LINEAR,

		/// <summary>
		/// <para>Value:</para>
		/// <para>2</para>
		/// <para>
		/// Uses a 16 sample cubic kernel for interpolation. This mode uses the most processing time, but outputs a higher quality image.
		/// </para>
		/// </summary>
		D2D1_3DTRANSFORM_INTERPOLATION_MODE_CUBIC,

		/// <summary>
		/// <para>Value:</para>
		/// <para>3</para>
		/// <para>
		/// Uses 4 linear samples within a single pixel for good edge anti-aliasing. This mode is good for scaling down by small amounts on
		/// images with few pixels.
		/// </para>
		/// </summary>
		D2D1_3DTRANSFORM_INTERPOLATION_MODE_MULTI_SAMPLE_LINEAR,

		/// <summary>
		/// <para>Value:</para>
		/// <para>4</para>
		/// <para>Uses anisotropic filtering to sample a pattern according to the transformed shape of the bitmap.</para>
		/// </summary>
		D2D1_3DTRANSFORM_INTERPOLATION_MODE_ANISOTROPIC,
	}

	/// <summary>Identifiers for properties of the <c>3D transform effect</c>.</summary>
	// https://learn.microsoft.com/en-us/windows/win32/api/d2d1effects/ne-d2d1effects-d2d1_3dtransform_prop typedef enum
	// D2D1_3DTRANSFORM_PROP { D2D1_3DTRANSFORM_PROP_INTERPOLATION_MODE = 0, D2D1_3DTRANSFORM_PROP_BORDER_MODE = 1,
	// D2D1_3DTRANSFORM_PROP_TRANSFORM_MATRIX = 2, D2D1_3DTRANSFORM_PROP_FORCE_DWORD = 0xffffffff } ;
	[PInvokeData("d2d1effects.h", MSDNShortId = "NE:d2d1effects.D2D1_3DTRANSFORM_PROP")]
	public enum D2D1_3DTRANSFORM_PROP : uint
	{
		/// <summary>
		/// <para>Value:</para>
		/// <para>0</para>
		/// <para>The interpolation mode the effect uses on the image. There are 5 scale modes that range in quality and speed.</para>
		/// <para>Type is D2D1_3DTRANSFORM_INTERPOLATION_MODE.</para>
		/// <para>Default value is D2D1_3DTRANSFORM_INTERPOLATION_MODE_LINEAR.</para>
		/// </summary>
		[CorrespondingType(typeof(D2D1_3DTRANSFORM_INTERPOLATION_MODE))]
		D2D1_3DTRANSFORM_PROP_INTERPOLATION_MODE,

		/// <summary>
		/// <para>Value:</para>
		/// <para>1</para>
		/// <para>The mode used to calculate the border of the image, soft or hard. See Border modes for more info.</para>
		/// <para>Type is D2D1_BORDER_MODE.</para>
		/// <para>Default value is D2D1_BORDER_MODE_SOFT.</para>
		/// </summary>
		[CorrespondingType(typeof(D2D1_BORDER_MODE))]
		D2D1_3DTRANSFORM_PROP_BORDER_MODE,

		/// <summary>
		/// <para>Value:</para>
		/// <para>2</para>
		/// <para>
		/// A 4x4 transform matrix applied to the projection plane. The following matrix calculation is used to map points from one 3D
		/// coordinate system
		/// </para>
		/// <para>to the transformed 2D coordinate system.</para>
		/// <para>Where:</para>
		/// <list/>
		/// <para>The individual matrix elements are not bounded and are unitless.</para>
		/// <para>Type is D2D1_MATRIX_4X4_F.</para>
		/// <para>Default value is Matrix4x4F(1, 0, 0, 0,</para>
		/// <para>0, 1, 0, 0,</para>
		/// <para>0, 0, 1, 0,</para>
		/// <para>0, 0, 0, 1).</para>
		/// </summary>
		[CorrespondingType(typeof(D2D_MATRIX_4X4_F))]
		D2D1_3DTRANSFORM_PROP_TRANSFORM_MATRIX,
	}

	/// <summary>Identifiers for the properties of the <c>Arithmetic composite effect</c>.</summary>
	// https://learn.microsoft.com/en-us/windows/win32/api/d2d1effects/ne-d2d1effects-d2d1_arithmeticcomposite_prop typedef enum
	// D2D1_ARITHMETICCOMPOSITE_PROP { D2D1_ARITHMETICCOMPOSITE_PROP_COEFFICIENTS = 0, D2D1_ARITHMETICCOMPOSITE_PROP_CLAMP_OUTPUT = 1,
	// D2D1_ARITHMETICCOMPOSITE_PROP_FORCE_DWORD = 0xffffffff } ;
	[PInvokeData("d2d1effects.h", MSDNShortId = "NE:d2d1effects.D2D1_ARITHMETICCOMPOSITE_PROP")]
	public enum D2D1_ARITHMETICCOMPOSITE_PROP : uint
	{
		/// <summary>
		/// <para>Value:</para>
		/// <para>0</para>
		/// <para>The coefficients for the equation used to composite the two input images. The coefficients are unitless and unbounded.</para>
		/// <para>Type is D2D1_VECTOR_4F.</para>
		/// <para>Default value is {1.0f, 0.0f, 0.0f, 0.0f}.</para>
		/// </summary>
		[CorrespondingType(typeof(D2D_VECTOR_4F))]
		D2D1_ARITHMETICCOMPOSITE_PROP_COEFFICIENTS,

		/// <summary>
		/// <para>Value:</para>
		/// <para>1</para>
		/// <para>The effect clamps color values to between 0 and 1 before the effect passes the values to the next effect in the graph.</para>
		/// <para>
		/// If you set this to TRUE the effect will clamp the values. If you set this to FALSE, the effect will not clamp the color values,
		/// </para>
		/// <para>but other effects and the output surface may clamp the values if they are not of high enough precision.</para>
		/// <para>Type is BOOL.</para>
		/// <para>Default value is FALSE.</para>
		/// </summary>
		[CorrespondingType(typeof(BOOL))]
		D2D1_ARITHMETICCOMPOSITE_PROP_CLAMP_OUTPUT,
	}

	/// <summary>Identifiers for properties of the <c>Atlas effect</c>.</summary>
	// https://learn.microsoft.com/en-us/windows/win32/api/d2d1effects/ne-d2d1effects-d2d1_atlas_prop typedef enum D2D1_ATLAS_PROP {
	// D2D1_ATLAS_PROP_INPUT_RECT = 0, D2D1_ATLAS_PROP_INPUT_PADDING_RECT = 1, D2D1_ATLAS_PROP_FORCE_DWORD = 0xffffffff } ;
	[PInvokeData("d2d1effects.h", MSDNShortId = "NE:d2d1effects.D2D1_ATLAS_PROP")]
	public enum D2D1_ATLAS_PROP : uint
	{
		/// <summary>
		/// <para>Value:</para>
		/// <para>0</para>
		/// <para>The portion of the image passed to the next effect.</para>
		/// <para>Type is D2D1_VECTOR_4F.</para>
		/// <para>Default value is (-FLT_MAX, -FLT_MAX, FLT_MAX, FLT_MAX).</para>
		/// </summary>
		[CorrespondingType(typeof(D2D_VECTOR_4F))]
		D2D1_ATLAS_PROP_INPUT_RECT,

		/// <summary>
		/// <para>Value:</para>
		/// <para>1</para>
		/// <para>The maximum size sampled for the output rectangle.</para>
		/// <para>Type is D2D1_VECTOR_4F.</para>
		/// <para>Default value is (-FLT_MAX, -FLT_MAX, FLT_MAX, FLT_MAX).</para>
		/// </summary>
		[CorrespondingType(typeof(D2D_VECTOR_4F))]
		D2D1_ATLAS_PROP_INPUT_PADDING_RECT,
	}

	/// <summary>Specifies the alpha mode of the output of the <c>Bitmap source effect</c>.</summary>
	// https://learn.microsoft.com/en-us/windows/win32/api/d2d1effects/ne-d2d1effects-d2d1_bitmapsource_alpha_mode typedef enum
	// D2D1_BITMAPSOURCE_ALPHA_MODE { D2D1_BITMAPSOURCE_ALPHA_MODE_PREMULTIPLIED = 1, D2D1_BITMAPSOURCE_ALPHA_MODE_STRAIGHT = 2,
	// D2D1_BITMAPSOURCE_ALPHA_MODE_FORCE_DWORD = 0xffffffff } ;
	[PInvokeData("d2d1effects.h", MSDNShortId = "NE:d2d1effects.D2D1_BITMAPSOURCE_ALPHA_MODE")]
	public enum D2D1_BITMAPSOURCE_ALPHA_MODE : uint
	{
		/// <summary>
		/// <para>Value:</para>
		/// <para>1</para>
		/// <para>The effect output uses premultiplied alpha.</para>
		/// </summary>
		D2D1_BITMAPSOURCE_ALPHA_MODE_PREMULTIPLIED = 1,

		/// <summary>
		/// <para>Value:</para>
		/// <para>2</para>
		/// <para>The effect output uses straight alpha.</para>
		/// </summary>
		D2D1_BITMAPSOURCE_ALPHA_MODE_STRAIGHT,
	}

	/// <summary>
	/// The interpolation mode used to scale the image in the <c>Bitmap source effect</c>.If the mode disables the mipmap, then BitmapSouce
	/// will cache the image at the resolution determined by the Scale and EnableDPICorrection properties.
	/// </summary>
	// https://learn.microsoft.com/en-us/windows/win32/api/d2d1effects/ne-d2d1effects-d2d1_bitmapsource_interpolation_mode typedef enum
	// D2D1_BITMAPSOURCE_INTERPOLATION_MODE { D2D1_BITMAPSOURCE_INTERPOLATION_MODE_NEAREST_NEIGHBOR = 0,
	// D2D1_BITMAPSOURCE_INTERPOLATION_MODE_LINEAR = 1, D2D1_BITMAPSOURCE_INTERPOLATION_MODE_CUBIC = 2,
	// D2D1_BITMAPSOURCE_INTERPOLATION_MODE_FANT = 6, D2D1_BITMAPSOURCE_INTERPOLATION_MODE_MIPMAP_LINEAR = 7,
	// D2D1_BITMAPSOURCE_INTERPOLATION_MODE_FORCE_DWORD = 0xffffffff } ;
	[PInvokeData("d2d1effects.h", MSDNShortId = "NE:d2d1effects.D2D1_BITMAPSOURCE_INTERPOLATION_MODE")]
	public enum D2D1_BITMAPSOURCE_INTERPOLATION_MODE : uint
	{
		/// <summary>
		/// <para>Value:</para>
		/// <para>0</para>
		/// <para>Samples the nearest single point and uses that. Doesn't generate a mipmap.</para>
		/// </summary>
		D2D1_BITMAPSOURCE_INTERPOLATION_MODE_NEAREST_NEIGHBOR,

		/// <summary>
		/// <para>Value:</para>
		/// <para>1</para>
		/// <para>Uses a four point sample and linear interpolation. Doesn't generate a mipmap.</para>
		/// </summary>
		D2D1_BITMAPSOURCE_INTERPOLATION_MODE_LINEAR,

		/// <summary>
		/// <para>Value:</para>
		/// <para>2</para>
		/// <para>Uses a 16 sample cubic kernel for interpolation. Doesn't generate a mipmap.</para>
		/// </summary>
		D2D1_BITMAPSOURCE_INTERPOLATION_MODE_CUBIC,

		/// <summary>
		/// <para>Value:</para>
		/// <para>6</para>
		/// <para>Uses the WIC fant interpolation, the same as the IWICBitmapScaler interface. Doesn't generate a mipmap.</para>
		/// </summary>
		D2D1_BITMAPSOURCE_INTERPOLATION_MODE_FANT = 6,

		/// <summary>
		/// <para>Value:</para>
		/// <para>7</para>
		/// <para>
		/// Generates mipmap chain in system memory using bilinear interpolation. For each mipmap the effect scales to the nearest multiple
		/// of 0.5 using bilinear interpolation
		/// </para>
		/// <para>and then scales the remaining amount using linear interpolation.</para>
		/// </summary>
		D2D1_BITMAPSOURCE_INTERPOLATION_MODE_MIPMAP_LINEAR,
	}

	/// <summary>Specifies whether a flip and/or rotation operation should be performed by the <c>Bitmap source effect</c></summary>
	// https://learn.microsoft.com/en-us/windows/win32/api/d2d1effects/ne-d2d1effects-d2d1_bitmapsource_orientation typedef enum
	// D2D1_BITMAPSOURCE_ORIENTATION { D2D1_BITMAPSOURCE_ORIENTATION_DEFAULT = 1, D2D1_BITMAPSOURCE_ORIENTATION_FLIP_HORIZONTAL = 2,
	// D2D1_BITMAPSOURCE_ORIENTATION_ROTATE_CLOCKWISE180 = 3, D2D1_BITMAPSOURCE_ORIENTATION_ROTATE_CLOCKWISE180_FLIP_HORIZONTAL = 4,
	// D2D1_BITMAPSOURCE_ORIENTATION_ROTATE_CLOCKWISE270_FLIP_HORIZONTAL = 5, D2D1_BITMAPSOURCE_ORIENTATION_ROTATE_CLOCKWISE90 = 6,
	// D2D1_BITMAPSOURCE_ORIENTATION_ROTATE_CLOCKWISE90_FLIP_HORIZONTAL = 7, D2D1_BITMAPSOURCE_ORIENTATION_ROTATE_CLOCKWISE270 = 8,
	// D2D1_BITMAPSOURCE_ORIENTATION_FORCE_DWORD = 0xffffffff } ;
	[PInvokeData("d2d1effects.h", MSDNShortId = "NE:d2d1effects.D2D1_BITMAPSOURCE_ORIENTATION")]
	public enum D2D1_BITMAPSOURCE_ORIENTATION : uint
	{
		/// <summary>
		/// <para>Value:</para>
		/// <para>1</para>
		/// <para>The effect doesn't change the orientation of the input.</para>
		/// </summary>
		D2D1_BITMAPSOURCE_ORIENTATION_DEFAULT = 1,

		/// <summary>
		/// <para>Value:</para>
		/// <para>2</para>
		/// <para>Flips the image horizontally.</para>
		/// </summary>
		D2D1_BITMAPSOURCE_ORIENTATION_FLIP_HORIZONTAL,

		/// <summary>
		/// <para>Value:</para>
		/// <para>3</para>
		/// <para>Rotates the image clockwise 180 degrees.</para>
		/// </summary>
		D2D1_BITMAPSOURCE_ORIENTATION_ROTATE_CLOCKWISE180,

		/// <summary>
		/// <para>Value:</para>
		/// <para>4</para>
		/// <para>Rotates the image clockwise 180 degrees and flips it horizontally.</para>
		/// </summary>
		D2D1_BITMAPSOURCE_ORIENTATION_ROTATE_CLOCKWISE180_FLIP_HORIZONTAL,

		/// <summary>
		/// <para>Value:</para>
		/// <para>5</para>
		/// <para>Rotates the image clockwise 270 degrees and flips it horizontally.</para>
		/// </summary>
		D2D1_BITMAPSOURCE_ORIENTATION_ROTATE_CLOCKWISE270_FLIP_HORIZONTAL,

		/// <summary>
		/// <para>Value:</para>
		/// <para>6</para>
		/// <para>Rotates the image clockwise 90 degrees.</para>
		/// </summary>
		D2D1_BITMAPSOURCE_ORIENTATION_ROTATE_CLOCKWISE90,

		/// <summary>
		/// <para>Value:</para>
		/// <para>7</para>
		/// <para>Rotates the image clockwise 90 degrees and flips it horizontally.</para>
		/// </summary>
		D2D1_BITMAPSOURCE_ORIENTATION_ROTATE_CLOCKWISE90_FLIP_HORIZONTAL,

		/// <summary>
		/// <para>Value:</para>
		/// <para>8</para>
		/// <para>Rotates the image clockwise 270 degrees.</para>
		/// </summary>
		D2D1_BITMAPSOURCE_ORIENTATION_ROTATE_CLOCKWISE270,
	}

	/// <summary>Identifiers for properties of the <c>Bitmap source effect</c>.</summary>
	// https://learn.microsoft.com/en-us/windows/win32/api/d2d1effects/ne-d2d1effects-d2d1_bitmapsource_prop typedef enum
	// D2D1_BITMAPSOURCE_PROP { D2D1_BITMAPSOURCE_PROP_WIC_BITMAP_SOURCE = 0, D2D1_BITMAPSOURCE_PROP_SCALE = 1,
	// D2D1_BITMAPSOURCE_PROP_INTERPOLATION_MODE = 2, D2D1_BITMAPSOURCE_PROP_ENABLE_DPI_CORRECTION = 3, D2D1_BITMAPSOURCE_PROP_ALPHA_MODE =
	// 4, D2D1_BITMAPSOURCE_PROP_ORIENTATION = 5, D2D1_BITMAPSOURCE_PROP_FORCE_DWORD = 0xffffffff } ;
	[PInvokeData("d2d1effects.h", MSDNShortId = "NE:d2d1effects.D2D1_BITMAPSOURCE_PROP")]
	public enum D2D1_BITMAPSOURCE_PROP : uint
	{
		/// <summary>
		/// <para>Value:</para>
		/// <para>0</para>
		/// <para>The IWICBitmapSource containing the image data to be loaded.</para>
		/// <para>The type is IWICBitmapSource.</para>
		/// <para>The default value is NULL.</para>
		/// </summary>
		[CorrespondingType(typeof(IWICBitmapSource))]
		D2D1_BITMAPSOURCE_PROP_WIC_BITMAP_SOURCE,

		/// <summary>
		/// <para>Value:</para>
		/// <para>1</para>
		/// <para>The scale amount in the X and Y direction. The effect multiplies the width by the X value and the height by the Y value.</para>
		/// <para>
		/// This property is a D2D1_VECTOR_2F defined as: (X scale, Y scale). The scale amounts are FLOAT, unitless, and must be positive or 0.
		/// </para>
		/// <para>The type is D2D1_VECTOR_2F.</para>
		/// <para>The default value is {1.0f, 1.0f}.</para>
		/// </summary>
		[CorrespondingType(typeof(D2D_VECTOR_2F))]
		D2D1_BITMAPSOURCE_PROP_SCALE,

		/// <summary>
		/// <para>Value:</para>
		/// <para>2</para>
		/// <para>The interpolation mode used to scale the image.</para>
		/// <para>
		/// If the mode disables the mipmap, then BitmapSouce will cache the image at the resolution determined by the Scale and
		/// EnableDPICorrection properties.
		/// </para>
		/// <para>The type is D2D1_BITMAPSOURCE_INTERPOLATION_MODE.</para>
		/// <para>The default value is D2D1_BITMAPSOURCE_INTERPOLATION_MODE_LINEAR.</para>
		/// </summary>
		[CorrespondingType(typeof(D2D1_BITMAPSOURCE_INTERPOLATION_MODE))]
		D2D1_BITMAPSOURCE_PROP_INTERPOLATION_MODE,

		/// <summary>
		/// <para>Value:</para>
		/// <para>3</para>
		/// <para>
		/// If you set this to TRUE, the effect will scale the input image to convert the DPI reported by IWICBitmapSource to the DPI of the
		/// device context.
		/// </para>
		/// <para>
		/// The effect uses the interpolation mode you set with the InterpolationMode property. If you set this to FALSE, the effect uses a
		/// DPI of 96.0 for the output image.
		/// </para>
		/// <para>The type is BOOL.</para>
		/// <para>The default value is FALSE.</para>
		/// </summary>
		[CorrespondingType(typeof(BOOL))]
		D2D1_BITMAPSOURCE_PROP_ENABLE_DPI_CORRECTION,

		/// <summary>
		/// <para>Value:</para>
		/// <para>4</para>
		/// <para>The alpha mode of the output. This can be either premultiplied or straight.</para>
		/// <para>The type is D2D1_BITMAPSOURCE_ALPHA_MODE.</para>
		/// <para>The default value is D2D1_BITMAPSOURCE_ALPHA_MODE_PREMULTIPLIED.</para>
		/// </summary>
		[CorrespondingType(typeof(D2D1_BITMAPSOURCE_ALPHA_MODE))]
		D2D1_BITMAPSOURCE_PROP_ALPHA_MODE,

		/// <summary>
		/// <para>Value:</para>
		/// <para>5</para>
		/// <para>A flip and/or rotation operation to be performed on the image.</para>
		/// <para>The type is D2D1_BITMAPSOURCE_ORIENTATION.</para>
		/// <para>The default value is D2D1_BITMAPSOURCE_ORIENTATION_DEFAULT.</para>
		/// </summary>
		[CorrespondingType(typeof(D2D1_BITMAPSOURCE_ORIENTATION))]
		D2D1_BITMAPSOURCE_PROP_ORIENTATION,
	}

	/// <summary>The blend mode used for the <c>Blend effect</c>.</summary>
	// https://learn.microsoft.com/en-us/windows/win32/api/d2d1effects/ne-d2d1effects-d2d1_blend_mode typedef enum D2D1_BLEND_MODE {
	// D2D1_BLEND_MODE_MULTIPLY = 0, D2D1_BLEND_MODE_SCREEN = 1, D2D1_BLEND_MODE_DARKEN = 2, D2D1_BLEND_MODE_LIGHTEN = 3,
	// D2D1_BLEND_MODE_DISSOLVE = 4, D2D1_BLEND_MODE_COLOR_BURN = 5, D2D1_BLEND_MODE_LINEAR_BURN = 6, D2D1_BLEND_MODE_DARKER_COLOR = 7,
	// D2D1_BLEND_MODE_LIGHTER_COLOR = 8, D2D1_BLEND_MODE_COLOR_DODGE = 9, D2D1_BLEND_MODE_LINEAR_DODGE = 10, D2D1_BLEND_MODE_OVERLAY = 11,
	// D2D1_BLEND_MODE_SOFT_LIGHT = 12, D2D1_BLEND_MODE_HARD_LIGHT = 13, D2D1_BLEND_MODE_VIVID_LIGHT = 14, D2D1_BLEND_MODE_LINEAR_LIGHT =
	// 15, D2D1_BLEND_MODE_PIN_LIGHT = 16, D2D1_BLEND_MODE_HARD_MIX = 17, D2D1_BLEND_MODE_DIFFERENCE = 18, D2D1_BLEND_MODE_EXCLUSION = 19,
	// D2D1_BLEND_MODE_HUE = 20, D2D1_BLEND_MODE_SATURATION = 21, D2D1_BLEND_MODE_COLOR = 22, D2D1_BLEND_MODE_LUMINOSITY = 23,
	// D2D1_BLEND_MODE_SUBTRACT = 24, D2D1_BLEND_MODE_DIVISION = 25, D2D1_BLEND_MODE_FORCE_DWORD = 0xffffffff } ;
	[PInvokeData("d2d1effects.h", MSDNShortId = "NE:d2d1effects.D2D1_BLEND_MODE")]
	public enum D2D1_BLEND_MODE
	{
		/// <summary>
		/// <para>Value:</para>
		/// <para>0</para>
		/// <para>Basic blend formula for alpha only.</para>
		/// </summary>
		D2D1_BLEND_MODE_MULTIPLY,

		/// <summary>
		/// <para>Value:</para>
		/// <para>1</para>
		/// <para>Basic blend formula for alpha only.</para>
		/// </summary>
		D2D1_BLEND_MODE_SCREEN,

		/// <summary>
		/// <para>Value:</para>
		/// <para>2</para>
		/// <para>Basic blend formula for alpha only.</para>
		/// </summary>
		D2D1_BLEND_MODE_DARKEN,

		/// <summary>
		/// <para>Value:</para>
		/// <para>3</para>
		/// <para>Basic blend formula for alpha only.</para>
		/// </summary>
		D2D1_BLEND_MODE_LIGHTEN,

		/// <summary>
		/// <para>Value:</para>
		/// <para>4</para>
		/// <para>Given:</para>
		/// <list type="bullet">
		/// <item>
		/// <description>A scene coordinate XY for the current pixel</description>
		/// </item>
		/// <item>
		/// <description>
		/// A deterministic pseudo-random number generator rand(XY) based on seed coordinate XY, with unbiased distribution of values from
		/// [0, 1]
		/// </description>
		/// </item>
		/// </list>
		/// </summary>
		D2D1_BLEND_MODE_DISSOLVE,

		/// <summary>
		/// <para>Value:</para>
		/// <para>5</para>
		/// <para>Basic blend formulas with</para>
		/// <para>f (F RGB</para>
		/// <para>, B</para>
		/// <para>RGB</para>
		/// <para>) =</para>
		/// </summary>
		D2D1_BLEND_MODE_COLOR_BURN,

		/// <summary>
		/// <para>Value:</para>
		/// <para>6</para>
		/// <para>Basic blend formulas with</para>
		/// <para>f (F RGB</para>
		/// <para>, B</para>
		/// <para>RGB</para>
		/// <para>) =</para>
		/// </summary>
		D2D1_BLEND_MODE_LINEAR_BURN,

		/// <summary>
		/// <para>Value:</para>
		/// <para>7</para>
		/// <para>Basic blend formula for alpha only.</para>
		/// </summary>
		D2D1_BLEND_MODE_DARKER_COLOR,

		/// <summary>
		/// <para>Value:</para>
		/// <para>8</para>
		/// <para>Basic blend formula for alpha only.</para>
		/// </summary>
		D2D1_BLEND_MODE_LIGHTER_COLOR,

		/// <summary>
		/// <para>Value:</para>
		/// <para>9</para>
		/// <para>Basic blend formulas with</para>
		/// <para>f (F RGB</para>
		/// <para>, B</para>
		/// <para>RGB</para>
		/// <para>) =</para>
		/// </summary>
		D2D1_BLEND_MODE_COLOR_DODGE,

		/// <summary>
		/// <para>Value:</para>
		/// <para>10</para>
		/// <para>Basic blend formulas with</para>
		/// <para>f (F RGB</para>
		/// <para>, B</para>
		/// <para>RGB</para>
		/// <para>) =</para>
		/// </summary>
		D2D1_BLEND_MODE_LINEAR_DODGE,

		/// <summary>
		/// <para>Value:</para>
		/// <para>11</para>
		/// <para>Basic blend formulas with</para>
		/// <para>f (F RGB</para>
		/// <para>, B</para>
		/// <para>RGB</para>
		/// <para>) =</para>
		/// </summary>
		D2D1_BLEND_MODE_OVERLAY,

		/// <summary>
		/// <para>Value:</para>
		/// <para>12</para>
		/// <para>Basic blend formulas with</para>
		/// <para>f (F RGB</para>
		/// <para>, B</para>
		/// <para>RGB</para>
		/// <para>) =</para>
		/// </summary>
		D2D1_BLEND_MODE_SOFT_LIGHT,

		/// <summary>
		/// <para>Value:</para>
		/// <para>13</para>
		/// <para>Basic blend formulas with</para>
		/// <para>f (F RGB</para>
		/// <para>, B</para>
		/// <para>RGB</para>
		/// <para>) =</para>
		/// </summary>
		D2D1_BLEND_MODE_HARD_LIGHT,

		/// <summary>
		/// <para>Value:</para>
		/// <para>14</para>
		/// <para>Basic blend formulas with</para>
		/// <para>f (F RGB</para>
		/// <para>, B</para>
		/// <para>RGB</para>
		/// <para>) =</para>
		/// </summary>
		D2D1_BLEND_MODE_VIVID_LIGHT,

		/// <summary>
		/// <para>Value:</para>
		/// <para>15</para>
		/// <para>Basic blend formulas with</para>
		/// <para>f (F RGB</para>
		/// <para>, B</para>
		/// <para>RGB</para>
		/// <para>) =</para>
		/// </summary>
		D2D1_BLEND_MODE_LINEAR_LIGHT,

		/// <summary>
		/// <para>Value:</para>
		/// <para>16</para>
		/// <para>Basic blend formulas with</para>
		/// <para>f (F RGB</para>
		/// <para>, B</para>
		/// <para>RGB</para>
		/// <para>) =</para>
		/// </summary>
		D2D1_BLEND_MODE_PIN_LIGHT,

		/// <summary>
		/// <para>Value:</para>
		/// <para>17</para>
		/// <para>Basic blend formulas with</para>
		/// <para>f (F RGB</para>
		/// <para>, B</para>
		/// <para>RGB</para>
		/// <para>) =</para>
		/// </summary>
		D2D1_BLEND_MODE_HARD_MIX,

		/// <summary>
		/// <para>Value:</para>
		/// <para>18</para>
		/// <para>Basic blend formulas with</para>
		/// <para>f (F RGB</para>
		/// <para>, B</para>
		/// <para>RGB</para>
		/// <para>) = abs(F</para>
		/// <para>RGB</para>
		/// <para>- B</para>
		/// <para>RGB</para>
		/// <para>)</para>
		/// </summary>
		D2D1_BLEND_MODE_DIFFERENCE,

		/// <summary>
		/// <para>Value:</para>
		/// <para>19</para>
		/// <para>Basic blend formulas with</para>
		/// <para>f (F RGB</para>
		/// <para>, B</para>
		/// <para>RGB</para>
		/// <para>) = F</para>
		/// <para>RGB</para>
		/// <para>+ B</para>
		/// <para>RGB</para>
		/// <para>– 2 * F</para>
		/// <para>RGB</para>
		/// <para>* B</para>
		/// <para>RGB</para>
		/// </summary>
		D2D1_BLEND_MODE_EXCLUSION,

		/// <summary>
		/// <para>Value:</para>
		/// <para>20</para>
		/// <para>Basic blend formula for alpha only.</para>
		/// </summary>
		D2D1_BLEND_MODE_HUE,

		/// <summary>
		/// <para>Value:</para>
		/// <para>21</para>
		/// <para>Basic blend formula for alpha only.</para>
		/// </summary>
		D2D1_BLEND_MODE_SATURATION,

		/// <summary>
		/// <para>Value:</para>
		/// <para>22</para>
		/// <para>Basic blend formula for alpha only.</para>
		/// </summary>
		D2D1_BLEND_MODE_COLOR,

		/// <summary>
		/// <para>Value:</para>
		/// <para>23</para>
		/// <para>Basic blend formula for alpha only.</para>
		/// </summary>
		D2D1_BLEND_MODE_LUMINOSITY,

		/// <summary>
		/// <para>Value:</para>
		/// <para>24</para>
		/// <para>Basic blend formula for alpha only.</para>
		/// </summary>
		D2D1_BLEND_MODE_SUBTRACT,

		/// <summary>
		/// <para>Value:</para>
		/// <para>25</para>
		/// <para>Basic blend formula for alpha only.</para>
		/// </summary>
		D2D1_BLEND_MODE_DIVISION,
	}

	/// <summary>Identifiers for properties of the <c>Blend effect</c>.</summary>
	// https://learn.microsoft.com/en-us/windows/win32/api/d2d1effects/ne-d2d1effects-d2d1_blend_prop typedef enum D2D1_BLEND_PROP {
	// D2D1_BLEND_PROP_MODE = 0, D2D1_BLEND_PROP_FORCE_DWORD = 0xffffffff } ;
	[PInvokeData("d2d1effects.h", MSDNShortId = "NE:d2d1effects.D2D1_BLEND_PROP")]
	public enum D2D1_BLEND_PROP : uint
	{
		/// <summary>
		/// <para>Value:</para>
		/// <para>0</para>
		/// <para>The blend mode used for the effect.</para>
		/// <para>The type is D2D1_BLEND_MODE.</para>
		/// <para>The default value is D2D1_BLEND_MODE_MULTIPLY.</para>
		/// </summary>
		[CorrespondingType(typeof(D2D1_BLEND_MODE))]
		D2D1_BLEND_PROP_MODE,
	}

	/// <summary>The edge mode for the <c>Border effect</c>.</summary>
	// https://learn.microsoft.com/en-us/windows/win32/api/d2d1effects/ne-d2d1effects-d2d1_border_edge_mode typedef enum
	// D2D1_BORDER_EDGE_MODE { D2D1_BORDER_EDGE_MODE_CLAMP = 0, D2D1_BORDER_EDGE_MODE_WRAP = 1, D2D1_BORDER_EDGE_MODE_MIRROR = 2,
	// D2D1_BORDER_EDGE_MODE_FORCE_DWORD = 0xffffffff } ;
	[PInvokeData("d2d1effects.h", MSDNShortId = "NE:d2d1effects.D2D1_BORDER_EDGE_MODE")]
	public enum D2D1_BORDER_EDGE_MODE : uint
	{
		/// <summary>
		/// <para>Value:</para>
		/// <para>0</para>
		/// <para>Repeats the pixels from the edges of the image.</para>
		/// </summary>
		D2D1_BORDER_EDGE_MODE_CLAMP,

		/// <summary>
		/// <para>Value:</para>
		/// <para>1</para>
		/// <para>Uses pixels from the opposite end edge of the image.</para>
		/// </summary>
		D2D1_BORDER_EDGE_MODE_WRAP,

		/// <summary>
		/// <para>Value:</para>
		/// <para>2</para>
		/// <para>Reflects pixels about the edge of the image.</para>
		/// </summary>
		D2D1_BORDER_EDGE_MODE_MIRROR,
	}

	/// <summary>Specifies how the <c>Crop effect</c> handles the crop rectangle falling on fractional pixel coordinates.</summary>
	// https://learn.microsoft.com/en-us/windows/win32/api/d2d1effects/ne-d2d1effects-d2d1_border_mode typedef enum D2D1_BORDER_MODE {
	// D2D1_BORDER_MODE_SOFT = 0, D2D1_BORDER_MODE_HARD = 1, D2D1_BORDER_MODE_FORCE_DWORD = 0xffffffff } ;
	[PInvokeData("d2d1effects.h", MSDNShortId = "NE:d2d1effects.D2D1_BORDER_MODE")]
	public enum D2D1_BORDER_MODE : uint
	{
		/// <summary>
		/// <para>Value:</para>
		/// <para>0</para>
		/// <para>If the crop rectangle falls on fractional pixel coordinates, the effect applies antialiasing which results in a soft edge.</para>
		/// </summary>
		D2D1_BORDER_MODE_SOFT,

		/// <summary>
		/// <para>Value:</para>
		/// <para>1</para>
		/// <para>If the crop rectangle falls on fractional pixel coordinates, the effect clamps which results in a hard edge.</para>
		/// </summary>
		D2D1_BORDER_MODE_HARD,
	}

	/// <summary>Identifiers for properties of the <c>Border effect</c>.</summary>
	// https://learn.microsoft.com/en-us/windows/win32/api/d2d1effects/ne-d2d1effects-d2d1_border_prop typedef enum D2D1_BORDER_PROP {
	// D2D1_BORDER_PROP_EDGE_MODE_X = 0, D2D1_BORDER_PROP_EDGE_MODE_Y = 1, D2D1_BORDER_PROP_FORCE_DWORD = 0xffffffff } ;
	[PInvokeData("d2d1effects.h", MSDNShortId = "NE:d2d1effects.D2D1_BORDER_PROP")]
	public enum D2D1_BORDER_PROP
	{
		/// <summary>
		/// <para>Value:</para>
		/// <para>0</para>
		/// <para>The edge mode in the X direction for the effect. You can set this to clamp, wrap, or mirror.</para>
		/// <para>The type is D2D1_BORDER_EDGE_MODE.</para>
		/// <para>The default value is D2D1_BORDER_EDGE_MODE_CLAMP.</para>
		/// </summary>
		[CorrespondingType(typeof(D2D1_BORDER_EDGE_MODE))]
		D2D1_BORDER_PROP_EDGE_MODE_X,

		/// <summary>
		/// <para>Value:</para>
		/// <para>1</para>
		/// <para>The edge mode in the Y direction for the effect. You can set this to clamp, wrap, or mirror.</para>
		/// <para>The type is D2D1_BORDER_EDGE_MODE.</para>
		/// <para>The default value is D2D1_BORDER_EDGE_MODE_CLAMP.</para>
		/// </summary>
		[CorrespondingType(typeof(D2D1_BORDER_EDGE_MODE))]
		D2D1_BORDER_PROP_EDGE_MODE_Y,
	}

	/// <summary>Identifiers for the properties of the <c>Brightness effect</c>.</summary>
	// https://learn.microsoft.com/en-us/windows/win32/api/d2d1effects/ne-d2d1effects-d2d1_brightness_prop typedef enum D2D1_BRIGHTNESS_PROP
	// { D2D1_BRIGHTNESS_PROP_WHITE_POINT = 0, D2D1_BRIGHTNESS_PROP_BLACK_POINT = 1, D2D1_BRIGHTNESS_PROP_FORCE_DWORD = 0xffffffff } ;
	[PInvokeData("d2d1effects.h", MSDNShortId = "NE:d2d1effects.D2D1_BRIGHTNESS_PROP")]
	public enum D2D1_BRIGHTNESS_PROP : uint
	{
		/// <summary>
		/// <para>Value:</para>
		/// <para>0</para>
		/// <para>
		/// The upper portion of the brightness transfer curve. The white point adjusts the appearance of the brighter portions of the image.
		/// </para>
		/// <para>
		/// This property is for both the x value and the y value, in that order. Each of the values of this property are between 0 and 1, inclusive.
		/// </para>
		/// <para>The type is D2D1_VECTOR_2F.</para>
		/// <para>The default value is (1.0f, 1.0f).</para>
		/// </summary>
		[CorrespondingType(typeof(D2D_VECTOR_2F))]
		D2D1_BRIGHTNESS_PROP_WHITE_POINT,

		/// <summary>
		/// <para>Value:</para>
		/// <para>1</para>
		/// <para>
		/// The lower portion of the brightness transfer curve. The black point adjusts the appearance of the darker portions of the image.
		/// </para>
		/// <para>
		/// This property is for both the x value and the y value, in that order. Each of the values of this property are between 0 and 1, inclusive.
		/// </para>
		/// <para>The type is D2D1_VECTOR_2F.</para>
		/// <para>The default value is (0.0f, 0.0f).</para>
		/// </summary>
		[CorrespondingType(typeof(D2D_VECTOR_2F))]
		D2D1_BRIGHTNESS_PROP_BLACK_POINT,
	}

	/// <summary>
	/// Specifies the color channel the <c>Displacement map effect</c> extracts the intensity from and uses it to spatially displace the
	/// image in the X or Y direction.
	/// </summary>
	// https://learn.microsoft.com/en-us/windows/win32/api/d2d1effects/ne-d2d1effects-d2d1_channel_selector typedef enum
	// D2D1_CHANNEL_SELECTOR { D2D1_CHANNEL_SELECTOR_R = 0, D2D1_CHANNEL_SELECTOR_G = 1, D2D1_CHANNEL_SELECTOR_B = 2,
	// D2D1_CHANNEL_SELECTOR_A = 3, D2D1_CHANNEL_SELECTOR_FORCE_DWORD = 0xffffffff } ;
	[PInvokeData("d2d1effects.h", MSDNShortId = "NE:d2d1effects.D2D1_CHANNEL_SELECTOR")]
	public enum D2D1_CHANNEL_SELECTOR : uint
	{
		/// <summary>
		/// <para>Value:</para>
		/// <para>0</para>
		/// <para>The effect extracts the intensity output from the red channel.</para>
		/// </summary>
		D2D1_CHANNEL_SELECTOR_R,

		/// <summary>
		/// <para>Value:</para>
		/// <para>1</para>
		/// <para>The effect extracts the intensity output from the green channel.</para>
		/// </summary>
		D2D1_CHANNEL_SELECTOR_G,

		/// <summary>
		/// <para>Value:</para>
		/// <para>2</para>
		/// <para>The effect extracts the intensity output from the blue channel.</para>
		/// </summary>
		D2D1_CHANNEL_SELECTOR_B,

		/// <summary>
		/// <para>Value:</para>
		/// <para>3</para>
		/// <para>The effect extracts the intensity output from the alpha channel.</para>
		/// </summary>
		D2D1_CHANNEL_SELECTOR_A,
	}

	/// <summary>Indicates how the <c>Color management effect</c> should interpret alpha data that is contained in the input image.</summary>
	// https://learn.microsoft.com/en-us/windows/win32/api/d2d1effects/ne-d2d1effects-d2d1_colormanagement_alpha_mode typedef enum
	// D2D1_COLORMANAGEMENT_ALPHA_MODE { D2D1_COLORMANAGEMENT_ALPHA_MODE_PREMULTIPLIED = 1, D2D1_COLORMANAGEMENT_ALPHA_MODE_STRAIGHT = 2,
	// D2D1_COLORMANAGEMENT_ALPHA_MODE_FORCE_DWORD = 0xffffffff } ;
	[PInvokeData("d2d1effects.h", MSDNShortId = "NE:d2d1effects.D2D1_COLORMANAGEMENT_ALPHA_MODE")]
	public enum D2D1_COLORMANAGEMENT_ALPHA_MODE : uint
	{
		/// <summary>
		/// <para>Value:</para>
		/// <para>1</para>
		/// <para>The effect assumes the alpha mode is premultiplied.</para>
		/// </summary>
		D2D1_COLORMANAGEMENT_ALPHA_MODE_PREMULTIPLIED = 1,

		/// <summary>
		/// <para>Value:</para>
		/// <para>2</para>
		/// <para>The effect assumes the alpha mode is straight.</para>
		/// </summary>
		D2D1_COLORMANAGEMENT_ALPHA_MODE_STRAIGHT,
	}

	/// <summary>Identifiers for the properties of the <c>Color management effect</c>.</summary>
	// https://learn.microsoft.com/en-us/windows/win32/api/d2d1effects/ne-d2d1effects-d2d1_colormanagement_prop typedef enum
	// D2D1_COLORMANAGEMENT_PROP { D2D1_COLORMANAGEMENT_PROP_SOURCE_COLOR_CONTEXT = 0, D2D1_COLORMANAGEMENT_PROP_SOURCE_RENDERING_INTENT =
	// 1, D2D1_COLORMANAGEMENT_PROP_DESTINATION_COLOR_CONTEXT = 2, D2D1_COLORMANAGEMENT_PROP_DESTINATION_RENDERING_INTENT = 3,
	// D2D1_COLORMANAGEMENT_PROP_ALPHA_MODE = 4, D2D1_COLORMANAGEMENT_PROP_QUALITY = 5, D2D1_COLORMANAGEMENT_PROP_FORCE_DWORD = 0xffffffff } ;
	[PInvokeData("d2d1effects.h", MSDNShortId = "NE:d2d1effects.D2D1_COLORMANAGEMENT_PROP")]
	public enum D2D1_COLORMANAGEMENT_PROP : uint
	{
		/// <summary>
		/// <para>Value:</para>
		/// <para>0</para>
		/// <para>The source color space information.</para>
		/// <para>The type is ID2D1ColorContext.</para>
		/// <para>The default value is NULL.</para>
		/// </summary>
		[CorrespondingType(typeof(ID2D1ColorContext))]
		D2D1_COLORMANAGEMENT_PROP_SOURCE_COLOR_CONTEXT,

		/// <summary>
		/// <para>Value:</para>
		/// <para>1</para>
		/// <para>Which ICC rendering intent to use.</para>
		/// <para>The type is D2D1_COLORMANAGEMENT_RENDERING_INTENT.</para>
		/// <para>The default value is D2D1_COLORMANAGEMENT_RENDERING_INTENT_PERCEPTUAL.</para>
		/// </summary>
		[CorrespondingType(typeof(D2D1_COLORMANAGEMENT_RENDERING_INTENT))]
		D2D1_COLORMANAGEMENT_PROP_SOURCE_RENDERING_INTENT,

		/// <summary>
		/// <para>Value:</para>
		/// <para>2</para>
		/// <para>The destination color space information.</para>
		/// <para>The type is ID2D1ColorContext.</para>
		/// <para>The default value is NULL.</para>
		/// </summary>
		[CorrespondingType(typeof(ID2D1ColorContext))]
		D2D1_COLORMANAGEMENT_PROP_DESTINATION_COLOR_CONTEXT,

		/// <summary>
		/// <para>Value:</para>
		/// <para>3</para>
		/// <para>Which ICC rendering intent to use.</para>
		/// <para>The type is D2D1_COLORMANAGEMENT_RENDERING_INTENT.</para>
		/// <para>The default value is D2D1_COLORMANAGEMENT_RENDERING_INTENT_PERCEPTUAL.</para>
		/// </summary>
		[CorrespondingType(typeof(D2D1_COLORMANAGEMENT_RENDERING_INTENT))]
		D2D1_COLORMANAGEMENT_PROP_DESTINATION_RENDERING_INTENT,

		/// <summary>
		/// <para>Value:</para>
		/// <para>4</para>
		/// <para>How to interpret alpha data that is contained in the input image.</para>
		/// <para>The type is D2D1_COLORMANAGEMENT_ALPHA_MODE.</para>
		/// <para>The default value is D2D1_COLORMANAGEMENT_ALPHA_MODE_PREMULTIPLIED.</para>
		/// </summary>
		[CorrespondingType(typeof(D2D1_COLORMANAGEMENT_ALPHA_MODE))]
		D2D1_COLORMANAGEMENT_PROP_ALPHA_MODE,

		/// <summary>
		/// <para>Value:</para>
		/// <para>5</para>
		/// <para>The quality level of the transform.</para>
		/// <para>The type is D2D1_COLORMANAGEMENT_QUALITY.</para>
		/// <para>The default value is D2D1_COLORMANAGEMENT_QUALITY_NORMAL.</para>
		/// </summary>
		[CorrespondingType(typeof(D2D1_COLORMANAGEMENT_QUALITY))]
		D2D1_COLORMANAGEMENT_PROP_QUALITY,
	}

	/// <summary>The quality level of the transform for the <c>Color management effect</c>.</summary>
	// https://learn.microsoft.com/en-us/windows/win32/api/d2d1effects/ne-d2d1effects-d2d1_colormanagement_quality typedef enum
	// D2D1_COLORMANAGEMENT_QUALITY { D2D1_COLORMANAGEMENT_QUALITY_PROOF = 0, D2D1_COLORMANAGEMENT_QUALITY_NORMAL = 1,
	// D2D1_COLORMANAGEMENT_QUALITY_BEST = 2, D2D1_COLORMANAGEMENT_QUALITY_FORCE_DWORD = 0xffffffff } ;
	[PInvokeData("d2d1effects.h", MSDNShortId = "NE:d2d1effects.D2D1_COLORMANAGEMENT_QUALITY")]
	public enum D2D1_COLORMANAGEMENT_QUALITY : uint
	{
		/// <summary>
		/// <para>Value:</para>
		/// <para>0</para>
		/// <para>The lowest quality mode. This mode requires feature level 9_1 or above.</para>
		/// </summary>
		D2D1_COLORMANAGEMENT_QUALITY_PROOF,

		/// <summary>
		/// <para>Value:</para>
		/// <para>1</para>
		/// <para>Normal quality mode. This mode requires feature level 9_1 or above.</para>
		/// </summary>
		D2D1_COLORMANAGEMENT_QUALITY_NORMAL,

		/// <summary>
		/// <para>Value:</para>
		/// <para>2</para>
		/// <para>The best quality mode. This mode requires feature level 10_0 or above, as well as floating point precision buffers.</para>
		/// <para>This mode supports floating point precision as well as extended range as defined in the ICC v4.3 specification.</para>
		/// </summary>
		D2D1_COLORMANAGEMENT_QUALITY_BEST,
	}

	/// <summary>Specifies which ICC rendering intent the <c>Color management effect</c> should use.</summary>
	// https://learn.microsoft.com/en-us/windows/win32/api/d2d1effects/ne-d2d1effects-d2d1_colormanagement_rendering_intent typedef enum
	// D2D1_COLORMANAGEMENT_RENDERING_INTENT { D2D1_COLORMANAGEMENT_RENDERING_INTENT_PERCEPTUAL = 0,
	// D2D1_COLORMANAGEMENT_RENDERING_INTENT_RELATIVE_COLORIMETRIC = 1, D2D1_COLORMANAGEMENT_RENDERING_INTENT_SATURATION = 2,
	// D2D1_COLORMANAGEMENT_RENDERING_INTENT_ABSOLUTE_COLORIMETRIC = 3, D2D1_COLORMANAGEMENT_RENDERING_INTENT_FORCE_DWORD = 0xffffffff } ;
	[PInvokeData("d2d1effects.h", MSDNShortId = "NE:d2d1effects.D2D1_COLORMANAGEMENT_RENDERING_INTENT")]
	public enum D2D1_COLORMANAGEMENT_RENDERING_INTENT : uint
	{
		/// <summary>
		/// <para>Value:</para>
		/// <para>0</para>
		/// <para>
		/// The effect compresses or expands the full color gamut of the image to fill the color gamut of the device, so that gray balance
		/// is preserved but colorimetric accuracy may not be preserved.
		/// </para>
		/// </summary>
		D2D1_COLORMANAGEMENT_RENDERING_INTENT_PERCEPTUAL,

		/// <summary>
		/// <para>Value:</para>
		/// <para>1</para>
		/// <para>The effect preserves the chroma of colors in the image at the possible expense of hue and lightness.</para>
		/// </summary>
		D2D1_COLORMANAGEMENT_RENDERING_INTENT_RELATIVE_COLORIMETRIC,

		/// <summary>
		/// <para>Value:</para>
		/// <para>2</para>
		/// <para>
		/// The effect adjusts colors that fall outside the range of colors the output device renders to the closest color available. It
		/// does not preserve the white point.
		/// </para>
		/// </summary>
		D2D1_COLORMANAGEMENT_RENDERING_INTENT_SATURATION,

		/// <summary>
		/// <para>Value:</para>
		/// <para>3</para>
		/// <para>
		/// The effect adjusts any colors that fall outside the range that the output device can render to the closest color that can be
		/// rendered. The effect does not change the other colors and preserves the white point.
		/// </para>
		/// </summary>
		D2D1_COLORMANAGEMENT_RENDERING_INTENT_ABSOLUTE_COLORIMETRIC,
	}

	/// <summary>The alpha mode of the output of the <c>Color matrix effect</c>.</summary>
	// https://learn.microsoft.com/en-us/windows/win32/api/d2d1effects/ne-d2d1effects-d2d1_colormatrix_alpha_mode typedef enum
	// D2D1_COLORMATRIX_ALPHA_MODE { D2D1_COLORMATRIX_ALPHA_MODE_PREMULTIPLIED = 1, D2D1_COLORMATRIX_ALPHA_MODE_STRAIGHT = 2,
	// D2D1_COLORMATRIX_ALPHA_MODE_FORCE_DWORD = 0xffffffff } ;
	[PInvokeData("d2d1effects.h", MSDNShortId = "NE:d2d1effects.D2D1_COLORMATRIX_ALPHA_MODE")]
	public enum D2D1_COLORMATRIX_ALPHA_MODE : uint
	{
		/// <summary>
		/// <para>Value:</para>
		/// <para>1</para>
		/// <para>The effect un-premultiplies the input, applies the color matrix, and premultiplies the output.</para>
		/// </summary>
		D2D1_COLORMATRIX_ALPHA_MODE_PREMULTIPLIED = 1,

		/// <summary>
		/// <para>Value:</para>
		/// <para>2</para>
		/// <para>The effect applies the color matrix directly to the input, and doesn't premultiply the output.</para>
		/// </summary>
		D2D1_COLORMATRIX_ALPHA_MODE_STRAIGHT,
	}

	/// <summary>Identifiers for the properties of the <c>Color matrix effect</c>.</summary>
	// https://learn.microsoft.com/en-us/windows/win32/api/d2d1effects/ne-d2d1effects-d2d1_colormatrix_prop typedef enum
	// D2D1_COLORMATRIX_PROP { D2D1_COLORMATRIX_PROP_COLOR_MATRIX = 0, D2D1_COLORMATRIX_PROP_ALPHA_MODE = 1,
	// D2D1_COLORMATRIX_PROP_CLAMP_OUTPUT = 2, D2D1_COLORMATRIX_PROP_FORCE_DWORD = 0xffffffff } ;
	[PInvokeData("d2d1effects.h", MSDNShortId = "NE:d2d1effects.D2D1_COLORMATRIX_PROP")]
	public enum D2D1_COLORMATRIX_PROP : uint
	{
		/// <summary>
		/// <para>Value:</para>
		/// <para>0</para>
		/// <para>A 5x4 matrix of float values. The elements in the matrix are not bounded and are unitless.</para>
		/// <para>The type is D2D1_MATRIX_5X4_F.</para>
		/// <para>The default value is the identity matrix, Matrix5x4F(1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0).</para>
		/// </summary>
		[CorrespondingType(typeof(D2D_MATRIX_5X4_F))]
		D2D1_COLORMATRIX_PROP_COLOR_MATRIX,

		/// <summary>
		/// <para>Value:</para>
		/// <para>1</para>
		/// <para>The alpha mode of the output.</para>
		/// <para>The type is D2D1_COLORMATRIX_ALPHA_MODE.</para>
		/// <para>The default value is D2D1_COLORMATRIX_ALPHA_MODE_PREMULTIPLIED.</para>
		/// </summary>
		[CorrespondingType(typeof(D2D1_COLORMATRIX_ALPHA_MODE))]
		D2D1_COLORMATRIX_PROP_ALPHA_MODE,

		/// <summary>
		/// <para>Value:</para>
		/// <para>2</para>
		/// <para>
		/// Whether the effect clamps color values to between 0 and 1 before the effect passes the values to the next effect in the graph.
		/// </para>
		/// <para>The effect clamps the values before it premultiplies the alpha.</para>
		/// <para>
		/// If you set this to TRUE the effect will clamp the values. If you set this to FALSE, the effect will not clamp the color values,
		/// </para>
		/// <para>but other effects and the output surface may clamp the values if they are not of high enough precision.</para>
		/// <para>The type is BOOL.</para>
		/// <para>The default value is FALSE.</para>
		/// </summary>
		[CorrespondingType(typeof(BOOL))]
		D2D1_COLORMATRIX_PROP_CLAMP_OUTPUT,
	}

	/// <summary>Identifiers for properties of the <c>Composite effect</c>.</summary>
	// https://learn.microsoft.com/en-us/windows/win32/api/d2d1effects/ne-d2d1effects-d2d1_composite_prop typedef enum D2D1_COMPOSITE_PROP {
	// D2D1_COMPOSITE_PROP_MODE = 0, D2D1_COMPOSITE_PROP_FORCE_DWORD = 0xffffffff } ;
	[PInvokeData("d2d1effects.h", MSDNShortId = "NE:d2d1effects.D2D1_COMPOSITE_PROP")]
	public enum D2D1_COMPOSITE_PROP : uint
	{
		/// <summary>
		/// <para>Value:</para>
		/// <para>0</para>
		/// <para>The mode used for the effect.</para>
		/// <para>Type is D2D1_COMPOSITE_MODE.</para>
		/// <para>Default value is D2D1_COMPOSITE_MODE_SOURCE_OVER</para>
		/// </summary>
		[CorrespondingType(typeof(D2D1_COMPOSITE_MODE))]
		D2D1_COMPOSITE_PROP_MODE,
	}

	/// <summary>Identifiers for properties of the <c>Convolve matrix effect</c>.</summary>
	// https://learn.microsoft.com/en-us/windows/win32/api/d2d1effects/ne-d2d1effects-d2d1_convolvematrix_prop typedef enum
	// D2D1_CONVOLVEMATRIX_PROP { D2D1_CONVOLVEMATRIX_PROP_KERNEL_UNIT_LENGTH = 0, D2D1_CONVOLVEMATRIX_PROP_SCALE_MODE = 1,
	// D2D1_CONVOLVEMATRIX_PROP_KERNEL_SIZE_X = 2, D2D1_CONVOLVEMATRIX_PROP_KERNEL_SIZE_Y = 3, D2D1_CONVOLVEMATRIX_PROP_KERNEL_MATRIX = 4,
	// D2D1_CONVOLVEMATRIX_PROP_DIVISOR = 5, D2D1_CONVOLVEMATRIX_PROP_BIAS = 6, D2D1_CONVOLVEMATRIX_PROP_KERNEL_OFFSET = 7,
	// D2D1_CONVOLVEMATRIX_PROP_PRESERVE_ALPHA = 8, D2D1_CONVOLVEMATRIX_PROP_BORDER_MODE = 9, D2D1_CONVOLVEMATRIX_PROP_CLAMP_OUTPUT = 10,
	// D2D1_CONVOLVEMATRIX_PROP_FORCE_DWORD = 0xffffffff } ;
	[PInvokeData("d2d1effects.h", MSDNShortId = "NE:d2d1effects.D2D1_CONVOLVEMATRIX_PROP")]
	public enum D2D1_CONVOLVEMATRIX_PROP : uint
	{
		/// <summary>
		/// <para>Value:</para>
		/// <para>0</para>
		/// <para>
		/// The size of one unit in the kernel. The units are in (DIPs/kernel unit), where a kernel unit is the size of the element in the
		/// convolution kernel.
		/// </para>
		/// <para>A value of 1 (DIP/kernel unit) corresponds to one pixel in a image at 96 DPI.</para>
		/// <para>The type is FLOAT.</para>
		/// <para>The default value is 1.0f.</para>
		/// </summary>
		[CorrespondingType(typeof(float))]
		D2D1_CONVOLVEMATRIX_PROP_KERNEL_UNIT_LENGTH,

		/// <summary>
		/// <para>Value:</para>
		/// <para>1</para>
		/// <para>
		/// The interpolation mode the effect uses to scale the image to the corresponding kernel unit length. There are six scale modes
		/// that range in quality and speed.
		/// </para>
		/// <para>The type is D2D1_CONVOLVEMATRIX_SCALE_MODE.</para>
		/// <para>The default value is D2D1_CONVOLVEMATRIX_SCALE_MODE_LINEAR.</para>
		/// </summary>
		[CorrespondingType(typeof(D2D1_CONVOLVEMATRIX_SCALE_MODE))]
		D2D1_CONVOLVEMATRIX_PROP_SCALE_MODE,

		/// <summary>
		/// <para>Value:</para>
		/// <para>2</para>
		/// <para>The width of the kernel matrix. The units are specified in kernel units.</para>
		/// <para>The type is UINT32.</para>
		/// <para>The default value is 3.</para>
		/// </summary>
		[CorrespondingType(typeof(uint))]
		D2D1_CONVOLVEMATRIX_PROP_KERNEL_SIZE_X,

		/// <summary>
		/// <para>Value:</para>
		/// <para>3</para>
		/// <para>The height of the kernel matrix. The units are specified in kernel units.</para>
		/// <para>The type is UINT32.</para>
		/// <para>The default value is 3.</para>
		/// </summary>
		[CorrespondingType(typeof(uint))]
		D2D1_CONVOLVEMATRIX_PROP_KERNEL_SIZE_Y,

		/// <summary>
		/// <para>Value:</para>
		/// <para>4</para>
		/// <para>The kernel matrix to be applied to the image. The kernel elements aren't bounded and are specified as floats.</para>
		/// <para>The first set of KernelSizeX numbers in the FLOAT[] corresponds to the first row in the kernel.</para>
		/// <para>The second set of KernelSizeX numbers correspond to the second row, and so on up to KernelSizeY rows.</para>
		/// <para>The type is FLOAT[].</para>
		/// <para>The default value is {0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f}.</para>
		/// </summary>
		[CorrespondingType(typeof(float[]))]
		D2D1_CONVOLVEMATRIX_PROP_KERNEL_MATRIX,

		/// <summary>
		/// <para>Value:</para>
		/// <para>5</para>
		/// <para>The kernel matrix is applied to a pixel and then the result is divided by this value.</para>
		/// <para>0 behaves as a value of float epsilon.</para>
		/// <para>The type is FLOAT.</para>
		/// <para>The default value is 1.0f.</para>
		/// </summary>
		[CorrespondingType(typeof(float))]
		D2D1_CONVOLVEMATRIX_PROP_DIVISOR,

		/// <summary>
		/// <para>Value:</para>
		/// <para>6</para>
		/// <para>
		/// The effect applies the kernel matrix, the divisor, and then the bias is added to the result. The bias is unbounded and unitless.
		/// </para>
		/// <para>The type is FLOAT.</para>
		/// <para>The default value is 0.0f.</para>
		/// </summary>
		[CorrespondingType(typeof(float))]
		D2D1_CONVOLVEMATRIX_PROP_BIAS,

		/// <summary>
		/// <para>Value:</para>
		/// <para>7</para>
		/// <para>
		/// Shifts the convolution kernel from a centered position on the output pixel to a position you specify left/right and up/down. The
		/// offset is defined in kernel units.
		/// </para>
		/// <para>
		/// With some offsets and kernel sizes, the convolution kernel’s samples won't land on a pixel image center. The pixel values for
		/// the kernel sample are computed by bilinear interpolation.
		/// </para>
		/// <para>The type is D2D1_VECTOR_2F.</para>
		/// <para>The default value is {0.0f, 0.0f}.</para>
		/// </summary>
		[CorrespondingType(typeof(D2D_VECTOR_2F))]
		D2D1_CONVOLVEMATRIX_PROP_KERNEL_OFFSET,

		/// <summary>
		/// <para>Value:</para>
		/// <para>8</para>
		/// <para>Specifies whether the convolution kernel is applied to the alpha channel or only the color channels.</para>
		/// <para>If you set this to TRUE the convolution kernel is applied only to the color channels.</para>
		/// <para>If you set this to FALSE the convolution kernel is applied to all channels.</para>
		/// <para>The type is BOOL.</para>
		/// <para>The default value is FALSE.</para>
		/// </summary>
		[CorrespondingType(typeof(BOOL))]
		D2D1_CONVOLVEMATRIX_PROP_PRESERVE_ALPHA,

		/// <summary>
		/// <para>Value:</para>
		/// <para>9</para>
		/// <para>The mode used to calculate the border of the image, soft or hard.</para>
		/// <para>The type is D2D1_BORDER_MODE.</para>
		/// <para>The default value is D2D1_BORDER_MODE_SOFT.</para>
		/// </summary>
		[CorrespondingType(typeof(D2D1_BORDER_MODE))]
		D2D1_CONVOLVEMATRIX_PROP_BORDER_MODE,

		/// <summary>
		/// <para>Value:</para>
		/// <para>10</para>
		/// <para>
		/// Whether the effect clamps color values to between 0 and 1 before the effect passes the values to the next effect in the graph.
		/// The effect clamps the values before it premultiplies the alpha.
		/// </para>
		/// <para>
		/// If you set this to TRUE the effect will clamp the values. If you set this to FALSE, the effect will not clamp the color values,
		/// </para>
		/// <para>but other effects and the output surface may clamp the values if they are not of high enough precision.</para>
		/// <para>The type is BOOL.</para>
		/// <para>The default value is FALSE.</para>
		/// </summary>
		[CorrespondingType(typeof(BOOL))]
		D2D1_CONVOLVEMATRIX_PROP_CLAMP_OUTPUT,
	}

	/// <summary>
	/// The interpolation mode the <c>Convolve matrix effect</c> uses to scale the image to the corresponding kernel unit length. There are
	/// six scale modes that range in quality and speed.
	/// </summary>
	// https://learn.microsoft.com/en-us/windows/win32/api/d2d1effects/ne-d2d1effects-d2d1_convolvematrix_scale_mode typedef enum
	// D2D1_CONVOLVEMATRIX_SCALE_MODE { D2D1_CONVOLVEMATRIX_SCALE_MODE_NEAREST_NEIGHBOR = 0, D2D1_CONVOLVEMATRIX_SCALE_MODE_LINEAR = 1,
	// D2D1_CONVOLVEMATRIX_SCALE_MODE_CUBIC = 2, D2D1_CONVOLVEMATRIX_SCALE_MODE_MULTI_SAMPLE_LINEAR = 3,
	// D2D1_CONVOLVEMATRIX_SCALE_MODE_ANISOTROPIC = 4, D2D1_CONVOLVEMATRIX_SCALE_MODE_HIGH_QUALITY_CUBIC = 5,
	// D2D1_CONVOLVEMATRIX_SCALE_MODE_FORCE_DWORD = 0xffffffff } ;
	[PInvokeData("d2d1effects.h", MSDNShortId = "NE:d2d1effects.D2D1_CONVOLVEMATRIX_SCALE_MODE")]
	public enum D2D1_CONVOLVEMATRIX_SCALE_MODE : uint
	{
		/// <summary>
		/// <para>Value:</para>
		/// <para>0</para>
		/// <para>Samples the nearest single point and uses that. This mode uses less processing time, but outputs the lowest quality image.</para>
		/// </summary>
		D2D1_CONVOLVEMATRIX_SCALE_MODE_NEAREST_NEIGHBOR,

		/// <summary>
		/// <para>Value:</para>
		/// <para>1</para>
		/// <para>Uses a four point sample and linear interpolation. This mode outputs a higher quality image than nearest neighbor mode.</para>
		/// </summary>
		D2D1_CONVOLVEMATRIX_SCALE_MODE_LINEAR,

		/// <summary>
		/// <para>Value:</para>
		/// <para>2</para>
		/// <para>
		/// Uses a 16 sample cubic kernel for interpolation. This mode uses the most processing time, but outputs a higher quality image.
		/// </para>
		/// </summary>
		D2D1_CONVOLVEMATRIX_SCALE_MODE_CUBIC,

		/// <summary>
		/// <para>Value:</para>
		/// <para>3</para>
		/// <para>
		/// Uses 4 linear samples within a single pixel for good edge anti-aliasing. This mode is good for scaling down by small amounts on
		/// images with few pixels.
		/// </para>
		/// </summary>
		D2D1_CONVOLVEMATRIX_SCALE_MODE_MULTI_SAMPLE_LINEAR,

		/// <summary>
		/// <para>Value:</para>
		/// <para>4</para>
		/// <para>Uses anisotropic filtering to sample a pattern according to the transformed shape of the bitmap.</para>
		/// </summary>
		D2D1_CONVOLVEMATRIX_SCALE_MODE_ANISOTROPIC,

		/// <summary>
		/// <para>Value:</para>
		/// <para>5</para>
		/// <para>
		/// Uses a variable size high quality cubic kernel to perform a pre-downscale the image if downscaling is involved in the transform
		/// matrix. Then uses the cubic interpolation mode for the final output.
		/// </para>
		/// </summary>
		D2D1_CONVOLVEMATRIX_SCALE_MODE_HIGH_QUALITY_CUBIC,
	}

	/// <summary>Identifiers for properties of the <c>Crop effect</c>.</summary>
	// https://learn.microsoft.com/en-us/windows/win32/api/d2d1effects/ne-d2d1effects-d2d1_crop_prop typedef enum D2D1_CROP_PROP {
	// D2D1_CROP_PROP_RECT = 0, D2D1_CROP_PROP_BORDER_MODE = 1, D2D1_CROP_PROP_FORCE_DWORD = 0xffffffff } ;
	[PInvokeData("d2d1effects.h", MSDNShortId = "NE:d2d1effects.D2D1_CROP_PROP")]
	public enum D2D1_CROP_PROP : uint
	{
		/// <summary>
		/// <para>Value:</para>
		/// <para>0</para>
		/// <para>The region to be cropped specified as a vector in the form (left, top, width, height). Units are in DIPs.</para>
		/// <para><b>Note</b>  The rectangle will be truncated if it overlaps the edge boundaries of the input image.</para>
		/// <para>Type is D2D1_VECTOR_4F Default value is {-FLT_MAX, -FLT_MAX, FLT_MAX, FLT_MAX}</para>
		/// </summary>
		[CorrespondingType(typeof(D2D_VECTOR_4F))]
		D2D1_CROP_PROP_RECT,

		/// <summary>
		/// <para>Value:</para>
		/// <para>1</para>
		/// <para>Indicates how the effect handles the crop rectangle falling on fractional pixel coordinates.</para>
		/// <para>Type is D2D1_BORDER_MODE.</para>
		/// <para>Default value is D2D1_BORDER_MODE_SOFT.</para>
		/// </summary>
		[CorrespondingType(typeof(D2D1_BORDER_MODE))]
		D2D1_CROP_PROP_BORDER_MODE,
	}

	/// <summary>Specifies the optimization mode for the <c>Directional blur effect</c>.</summary>
	// https://learn.microsoft.com/en-us/windows/win32/api/d2d1effects/ne-d2d1effects-d2d1_directionalblur_optimization typedef enum
	// D2D1_DIRECTIONALBLUR_OPTIMIZATION { D2D1_DIRECTIONALBLUR_OPTIMIZATION_SPEED = 0, D2D1_DIRECTIONALBLUR_OPTIMIZATION_BALANCED = 1,
	// D2D1_DIRECTIONALBLUR_OPTIMIZATION_QUALITY = 2, D2D1_DIRECTIONALBLUR_OPTIMIZATION_FORCE_DWORD = 0xffffffff } ;
	[PInvokeData("d2d1effects.h", MSDNShortId = "NE:d2d1effects.D2D1_DIRECTIONALBLUR_OPTIMIZATION")]
	public enum D2D1_DIRECTIONALBLUR_OPTIMIZATION : uint
	{
		/// <summary>
		/// <para>Value:</para>
		/// <para>0</para>
		/// <para>Applies internal optimizations such as pre-scaling at relatively small radii. Uses linear filtering.</para>
		/// </summary>
		D2D1_DIRECTIONALBLUR_OPTIMIZATION_SPEED,

		/// <summary>
		/// <para>Value:</para>
		/// <para>1</para>
		/// <para>Uses the same optimization thresholds as Speed mode, but uses trilinear filtering.</para>
		/// </summary>
		D2D1_DIRECTIONALBLUR_OPTIMIZATION_BALANCED,

		/// <summary>
		/// <para>Value:</para>
		/// <para>2</para>
		/// <para>
		/// Only uses internal optimizations with large blur radii, where approximations are less likely to be visible. Uses trilinear filtering.
		/// </para>
		/// </summary>
		D2D1_DIRECTIONALBLUR_OPTIMIZATION_QUALITY,
	}

	/// <summary>Identifiers for properties of the <c>Directional blur effect</c>.</summary>
	// https://learn.microsoft.com/en-us/windows/win32/api/d2d1effects/ne-d2d1effects-d2d1_directionalblur_prop typedef enum
	// D2D1_DIRECTIONALBLUR_PROP { D2D1_DIRECTIONALBLUR_PROP_STANDARD_DEVIATION = 0, D2D1_DIRECTIONALBLUR_PROP_ANGLE = 1,
	// D2D1_DIRECTIONALBLUR_PROP_OPTIMIZATION = 2, D2D1_DIRECTIONALBLUR_PROP_BORDER_MODE = 3, D2D1_DIRECTIONALBLUR_PROP_FORCE_DWORD =
	// 0xffffffff } ;
	[PInvokeData("d2d1effects.h", MSDNShortId = "NE:d2d1effects.D2D1_DIRECTIONALBLUR_PROP")]
	public enum D2D1_DIRECTIONALBLUR_PROP : uint
	{
		/// <summary>
		/// <para>Value:</para>
		/// <para>0</para>
		/// <para>
		/// The amount of blur to be applied to the image. You can compute the blur radius of the kernel by multiplying the standard
		/// deviation by 3.
		/// </para>
		/// <para>The units of both the standard deviation and blur radius are DIPs. A value of 0 DIPs disables this effect.</para>
		/// <para>The type is FLOAT.</para>
		/// <para>The default value is 3.0f.</para>
		/// </summary>
		[CorrespondingType(typeof(float))]
		D2D1_DIRECTIONALBLUR_PROP_STANDARD_DEVIATION,

		/// <summary>
		/// <para>Value:</para>
		/// <para>1</para>
		/// <para>The angle of the blur relative to the x-axis, in the counterclockwise direction. The units are specified in degrees.</para>
		/// <para>
		/// The blur kernel is first generated using the same process as for the Gaussian blur effect. The kernel values are then
		/// transformed according to the blur angle.
		/// </para>
		/// <para>The type is FLOAT.</para>
		/// <para>The default value is 0.0f.</para>
		/// </summary>
		[CorrespondingType(typeof(float))]
		D2D1_DIRECTIONALBLUR_PROP_ANGLE,

		/// <summary>
		/// <para>Value:</para>
		/// <para>2</para>
		/// <para>The optimization mode. See Optimization modes for more info.</para>
		/// <para>The type is D2D1_DIRECTIONALBLUR_OPTIMIZATION.</para>
		/// <para>The default value is D2D1_DIRECTIONALBLUR_OPTIMIZATION_BALANCED.</para>
		/// </summary>
		[CorrespondingType(typeof(D2D1_DIRECTIONALBLUR_OPTIMIZATION))]
		D2D1_DIRECTIONALBLUR_PROP_OPTIMIZATION,

		/// <summary>
		/// <para>Value:</para>
		/// <para>3</para>
		/// <para>The mode used to calculate the border of the image, soft or hard. See Border modes for more info.</para>
		/// <para>The type is D2D1_BORDER_MODE.</para>
		/// <para>The default value is D2D1_BORDER_MODE_SOFT.</para>
		/// </summary>
		[CorrespondingType(typeof(D2D1_BORDER_MODE))]
		D2D1_DIRECTIONALBLUR_PROP_BORDER_MODE,
	}

	/// <summary>Identifiers for properties of the <c>Discrete transfer effect</c>.</summary>
	// https://learn.microsoft.com/en-us/windows/win32/api/d2d1effects/ne-d2d1effects-d2d1_discretetransfer_prop typedef enum
	// D2D1_DISCRETETRANSFER_PROP { D2D1_DISCRETETRANSFER_PROP_RED_TABLE = 0, D2D1_DISCRETETRANSFER_PROP_RED_DISABLE = 1,
	// D2D1_DISCRETETRANSFER_PROP_GREEN_TABLE = 2, D2D1_DISCRETETRANSFER_PROP_GREEN_DISABLE = 3, D2D1_DISCRETETRANSFER_PROP_BLUE_TABLE = 4,
	// D2D1_DISCRETETRANSFER_PROP_BLUE_DISABLE = 5, D2D1_DISCRETETRANSFER_PROP_ALPHA_TABLE = 6, D2D1_DISCRETETRANSFER_PROP_ALPHA_DISABLE =
	// 7, D2D1_DISCRETETRANSFER_PROP_CLAMP_OUTPUT = 8, D2D1_DISCRETETRANSFER_PROP_FORCE_DWORD = 0xffffffff } ;
	[PInvokeData("d2d1effects.h", MSDNShortId = "NE:d2d1effects.D2D1_DISCRETETRANSFER_PROP")]
	public enum D2D1_DISCRETETRANSFER_PROP : uint
	{
		/// <summary>
		/// <para>Value:</para>
		/// <para>0</para>
		/// <para>The list of values used to define the transfer function for the Red channel.</para>
		/// <para>The type is FLOAT[].</para>
		/// <para>The default value is {0.0f, 1.0f}.</para>
		/// </summary>
		[CorrespondingType(typeof(float[]))]
		D2D1_DISCRETETRANSFER_PROP_RED_TABLE,

		/// <summary>
		/// <para>Value:</para>
		/// <para>1</para>
		/// <para>If you set this to TRUE the effect does not apply the transfer function to the Red channel.</para>
		/// <para>If you set this to FALSE the effect applies the RedDiscreteTransfer function to the Red channel.</para>
		/// <para>The type is BOOL.</para>
		/// <para>The default value if FALSE.</para>
		/// </summary>
		[CorrespondingType(typeof(BOOL))]
		D2D1_DISCRETETRANSFER_PROP_RED_DISABLE,

		/// <summary>
		/// <para>Value:</para>
		/// <para>2</para>
		/// <para>The list of values used to define the transfer function for the Green channel.</para>
		/// <para>The type is FLOAT[].</para>
		/// <para>The default value is {0.0f, 1.0f}.</para>
		/// </summary>
		[CorrespondingType(typeof(float[]))]
		D2D1_DISCRETETRANSFER_PROP_GREEN_TABLE,

		/// <summary>
		/// <para>Value:</para>
		/// <para>3</para>
		/// <para>If you set this to TRUE the effect does not apply the transfer function to the Green channel.</para>
		/// <para>If you set this to FALSE the effect applies the GreenDiscreteTransfer function to the Green channel.</para>
		/// <para>The type is BOOL.</para>
		/// <para>The default value if FALSE.</para>
		/// </summary>
		[CorrespondingType(typeof(BOOL))]
		D2D1_DISCRETETRANSFER_PROP_GREEN_DISABLE,

		/// <summary>
		/// <para>Value:</para>
		/// <para>4</para>
		/// <para>The list of values used to define the transfer function for the Blue channel.</para>
		/// <para>The type is FLOAT[].</para>
		/// <para>The default value is {0.0f, 1.0f}.</para>
		/// </summary>
		[CorrespondingType(typeof(float[]))]
		D2D1_DISCRETETRANSFER_PROP_BLUE_TABLE,

		/// <summary>
		/// <para>Value:</para>
		/// <para>5</para>
		/// <para>If you set this to TRUE the effect does not apply the transfer function to the Blue channel.</para>
		/// <para>If you set this to FALSE the effect applies the BlueDiscreteTransfer function to the Blue channel.</para>
		/// <para>The type is BOOL.</para>
		/// <para>The default value if FALSE.</para>
		/// </summary>
		[CorrespondingType(typeof(BOOL))]
		D2D1_DISCRETETRANSFER_PROP_BLUE_DISABLE,

		/// <summary>
		/// <para>Value:</para>
		/// <para>6</para>
		/// <para>The list of values used to define the transfer function for the Alpha channel.</para>
		/// <para>The type is FLOAT[].</para>
		/// <para>The default value is {0.0f, 1.0f}.</para>
		/// </summary>
		[CorrespondingType(typeof(float[]))]
		D2D1_DISCRETETRANSFER_PROP_ALPHA_TABLE,

		/// <summary>
		/// <para>Value:</para>
		/// <para>7</para>
		/// <para>If you set this to TRUE the effect does not apply the transfer function to the Alpha channel.</para>
		/// <para>If you set this to FALSE the effect applies the AlphaDiscreteTransfer function to the Alpha channel.</para>
		/// <para>The type is BOOL.</para>
		/// <para>The default value if FALSE.</para>
		/// </summary>
		[CorrespondingType(typeof(BOOL))]
		D2D1_DISCRETETRANSFER_PROP_ALPHA_DISABLE,

		/// <summary>
		/// <para>Value:</para>
		/// <para>8</para>
		/// <para>
		/// Whether the effect clamps color values to between 0 and 1 before the effect passes the values to the next effect in the graph.
		/// </para>
		/// <para>The effect clamps the values before it premultiplies the alpha.</para>
		/// <para>
		/// If you set this to TRUE the effect will clamp the values. If you set this to FALSE, the effect will not clamp the color values,
		/// </para>
		/// <para>but other effects and the output surface may clamp the values if they are not of high enough precision.</para>
		/// <para>The type is BOOL.</para>
		/// <para>The default value if FALSE.</para>
		/// </summary>
		[CorrespondingType(typeof(BOOL))]
		D2D1_DISCRETETRANSFER_PROP_CLAMP_OUTPUT,
	}

	/// <summary>Identifiers for properties of the <c>Displacement map effect</c>.</summary>
	// https://learn.microsoft.com/en-us/windows/win32/api/d2d1effects/ne-d2d1effects-d2d1_displacementmap_prop typedef enum
	// D2D1_DISPLACEMENTMAP_PROP { D2D1_DISPLACEMENTMAP_PROP_SCALE = 0, D2D1_DISPLACEMENTMAP_PROP_X_CHANNEL_SELECT = 1,
	// D2D1_DISPLACEMENTMAP_PROP_Y_CHANNEL_SELECT = 2, D2D1_DISPLACEMENTMAP_PROP_FORCE_DWORD = 0xffffffff } ;
	[PInvokeData("d2d1effects.h", MSDNShortId = "NE:d2d1effects.D2D1_DISPLACEMENTMAP_PROP")]
	public enum D2D1_DISPLACEMENTMAP_PROP : uint
	{
		/// <summary>
		/// <para>Value:</para>
		/// <para>0</para>
		/// <para>
		/// Multiplies the intensity of the selected channel from the displacement image. The higher you set this property, the more the
		/// effect displaces the pixels.
		/// </para>
		/// <para>The type is FLOAT.</para>
		/// <para>The default value is 0.0f.</para>
		/// </summary>
		[CorrespondingType(typeof(float))]
		D2D1_DISPLACEMENTMAP_PROP_SCALE,

		/// <summary>
		/// <para>Value:</para>
		/// <para>1</para>
		/// <para>The effect extracts the intensity from this color channel and uses it to spatially displace the image in the X direction.</para>
		/// <para>The type is D2D1_CHANNEL_SELECTOR.</para>
		/// <para>The default value is D2D1_CHANNEL_SELECTOR_A</para>
		/// </summary>
		[CorrespondingType(typeof(D2D1_CHANNEL_SELECTOR))]
		D2D1_DISPLACEMENTMAP_PROP_X_CHANNEL_SELECT,

		/// <summary>
		/// <para>Value:</para>
		/// <para>2</para>
		/// <para>The effect extracts the intensity from this color channel and uses it to spatially displace the image in the Y direction.</para>
		/// <para>The type is D2D1_CHANNEL_SELECTOR.</para>
		/// <para>The default value is D2D1_CHANNEL_SELECTOR_A</para>
		/// </summary>
		[CorrespondingType(typeof(D2D1_CHANNEL_SELECTOR))]
		D2D1_DISPLACEMENTMAP_PROP_Y_CHANNEL_SELECT,
	}

	/// <summary>Identifiers for properties of the <c>Distant-diffuse lighting effect</c>.</summary>
	// https://learn.microsoft.com/en-us/windows/win32/api/d2d1effects/ne-d2d1effects-d2d1_distantdiffuse_prop typedef enum
	// D2D1_DISTANTDIFFUSE_PROP { D2D1_DISTANTDIFFUSE_PROP_AZIMUTH = 0, D2D1_DISTANTDIFFUSE_PROP_ELEVATION = 1,
	// D2D1_DISTANTDIFFUSE_PROP_DIFFUSE_CONSTANT = 2, D2D1_DISTANTDIFFUSE_PROP_SURFACE_SCALE = 3, D2D1_DISTANTDIFFUSE_PROP_COLOR = 4,
	// D2D1_DISTANTDIFFUSE_PROP_KERNEL_UNIT_LENGTH = 5, D2D1_DISTANTDIFFUSE_PROP_SCALE_MODE = 6, D2D1_DISTANTDIFFUSE_PROP_FORCE_DWORD =
	// 0xffffffff } ;
	[PInvokeData("d2d1effects.h", MSDNShortId = "NE:d2d1effects.D2D1_DISTANTDIFFUSE_PROP")]
	public enum D2D1_DISTANTDIFFUSE_PROP : uint
	{
		/// <summary>
		/// <para>Value:</para>
		/// <para>0</para>
		/// <para>
		/// The direction angle of the light source in the XY plane relative to the X-axis in the counter clock wise direction. The units
		/// are in degrees and must be between 0 and 360 degrees.
		/// </para>
		/// <para>The type is FLOAT.</para>
		/// <para>The default value is 0.0f.</para>
		/// </summary>
		[CorrespondingType(typeof(float))]
		D2D1_DISTANTDIFFUSE_PROP_AZIMUTH,

		/// <summary>
		/// <para>Value:</para>
		/// <para>1</para>
		/// <para>
		/// The direction angle of the light source in the YZ plane relative to the Y-axis in the counter clock wise direction. The units
		/// are in degrees and must be between 0 and 360 degrees.
		/// </para>
		/// <para>The type is FLOAT.</para>
		/// <para>The default value is 0.0f.</para>
		/// </summary>
		[CorrespondingType(typeof(float))]
		D2D1_DISTANTDIFFUSE_PROP_ELEVATION,

		/// <summary>
		/// <para>Value:</para>
		/// <para>2</para>
		/// <para>The ratio of diffuse reflection to amount of incoming light. This property must be between 0 and 10,000 and is unitless.</para>
		/// <para>The type is FLOAT.</para>
		/// <para>The default value is 1.0f.</para>
		/// </summary>
		[CorrespondingType(typeof(float))]
		D2D1_DISTANTDIFFUSE_PROP_DIFFUSE_CONSTANT,

		/// <summary>
		/// <para>Value:</para>
		/// <para>3</para>
		/// <para>The scale factor in the Z direction. The surface scale is unitless and must be between 0 and 10,000.</para>
		/// <para>The type is FLOAT.</para>
		/// <para>The default value is 1.0f.</para>
		/// </summary>
		[CorrespondingType(typeof(float))]
		D2D1_DISTANTDIFFUSE_PROP_SURFACE_SCALE,

		/// <summary>
		/// <para>Value:</para>
		/// <para>4</para>
		/// <para>
		/// The color of the incoming light. This property is exposed as a D2D1_VECTOR_3F – (R, G, B) and used to compute LR, LG, LB.
		/// </para>
		/// <para>The type is D2D1_VECTOR_3F.</para>
		/// <para>The default value is {1.0f, 1.0f, 1.0f}.</para>
		/// </summary>
		[CorrespondingType(typeof(D2D_VECTOR_3F))]
		D2D1_DISTANTDIFFUSE_PROP_COLOR,

		/// <summary>
		/// <para>Value:</para>
		/// <para>5</para>
		/// <para>
		/// The size of an element in the Sobel kernel used to generate the surface normal in the X and Y direction. This property maps to
		/// the dx and dy values in the Sobel gradient. This property is a D2D1_VECTOR_2F (Kernel Unit Length X, Kernel Unit Length Y) and
		/// is defined in (device-independent pixels (DIPs)/Kernel Unit). The effect uses bilinear interpolation to scale the bitmap to
		/// match size of kernel elements.
		/// </para>
		/// <para>The type is D2D1_VECTOR_2F.</para>
		/// <para>The default value is {1.0f, 1.0f}.</para>
		/// </summary>
		[CorrespondingType(typeof(D2D_VECTOR_2F))]
		D2D1_DISTANTDIFFUSE_PROP_KERNEL_UNIT_LENGTH,

		/// <summary>
		/// <para>Value:</para>
		/// <para>6</para>
		/// <para>
		/// The interpolation mode the effect uses to scale the image to the corresponding kernel unit length. There are six scale modes
		/// that range in quality and speed.
		/// </para>
		/// <para>The type is D2D1_DISTANTDIFFUSE_SCALE_MODE.</para>
		/// <para>The default value is D2D1_DISTANTDIFFUSE_SCALE_MODE_LINEAR.</para>
		/// </summary>
		[CorrespondingType(typeof(D2D1_DISTANTDIFFUSE_SCALE_MODE))]
		D2D1_DISTANTDIFFUSE_PROP_SCALE_MODE,
	}

	/// <summary>
	/// The interpolation mode the effect uses to scale the image to the corresponding kernel unit length. There are six scale modes that
	/// range in quality and speed.
	/// </summary>
	// https://learn.microsoft.com/en-us/windows/win32/api/d2d1effects/ne-d2d1effects-d2d1_distantdiffuse_scale_mode typedef enum
	// D2D1_DISTANTDIFFUSE_SCALE_MODE { D2D1_DISTANTDIFFUSE_SCALE_MODE_NEAREST_NEIGHBOR = 0, D2D1_DISTANTDIFFUSE_SCALE_MODE_LINEAR = 1,
	// D2D1_DISTANTDIFFUSE_SCALE_MODE_CUBIC = 2, D2D1_DISTANTDIFFUSE_SCALE_MODE_MULTI_SAMPLE_LINEAR = 3,
	// D2D1_DISTANTDIFFUSE_SCALE_MODE_ANISOTROPIC = 4, D2D1_DISTANTDIFFUSE_SCALE_MODE_HIGH_QUALITY_CUBIC = 5,
	// D2D1_DISTANTDIFFUSE_SCALE_MODE_FORCE_DWORD = 0xffffffff } ;
	[PInvokeData("d2d1effects.h", MSDNShortId = "NE:d2d1effects.D2D1_DISTANTDIFFUSE_SCALE_MODE")]
	public enum D2D1_DISTANTDIFFUSE_SCALE_MODE : uint
	{
		/// <summary>
		/// <para>Value:</para>
		/// <para>0</para>
		/// <para>Samples the nearest single point and uses that. This mode uses less processing time, but outputs the lowest quality image.</para>
		/// </summary>
		D2D1_DISTANTDIFFUSE_SCALE_MODE_NEAREST_NEIGHBOR,

		/// <summary>
		/// <para>Value:</para>
		/// <para>1</para>
		/// <para>Uses a four point sample and linear interpolation. This mode outputs a higher quality image than nearest neighbor.</para>
		/// </summary>
		D2D1_DISTANTDIFFUSE_SCALE_MODE_LINEAR,

		/// <summary>
		/// <para>Value:</para>
		/// <para>2</para>
		/// <para>
		/// Uses a 16 sample cubic kernel for interpolation. This mode uses the most processing time, but outputs a higher quality image.
		/// </para>
		/// </summary>
		D2D1_DISTANTDIFFUSE_SCALE_MODE_CUBIC,

		/// <summary>
		/// <para>Value:</para>
		/// <para>3</para>
		/// <para>
		/// Uses 4 linear samples within a single pixel for good edge anti-aliasing. This mode is good for scaling down by small amounts on
		/// images with few pixels.
		/// </para>
		/// </summary>
		D2D1_DISTANTDIFFUSE_SCALE_MODE_MULTI_SAMPLE_LINEAR,

		/// <summary>
		/// <para>Value:</para>
		/// <para>4</para>
		/// <para>Uses anisotropic filtering to sample a pattern according to the transformed shape of the bitmap.</para>
		/// </summary>
		D2D1_DISTANTDIFFUSE_SCALE_MODE_ANISOTROPIC,

		/// <summary>
		/// <para>Value:</para>
		/// <para>5</para>
		/// <para>
		/// Uses a variable size high quality cubic kernel to perform a pre-downscale the image if downscaling is involved in the transform matrix.
		/// </para>
		/// <para>Then uses the cubic interpolation mode for the final output.</para>
		/// </summary>
		D2D1_DISTANTDIFFUSE_SCALE_MODE_HIGH_QUALITY_CUBIC,
	}

	/// <summary>Identifiers for properties of the <c>Distant-specular lighting effect</c>.</summary>
	// https://learn.microsoft.com/en-us/windows/win32/api/d2d1effects/ne-d2d1effects-d2d1_distantspecular_prop typedef enum
	// D2D1_DISTANTSPECULAR_PROP { D2D1_DISTANTSPECULAR_PROP_AZIMUTH = 0, D2D1_DISTANTSPECULAR_PROP_ELEVATION = 1,
	// D2D1_DISTANTSPECULAR_PROP_SPECULAR_EXPONENT = 2, D2D1_DISTANTSPECULAR_PROP_SPECULAR_CONSTANT = 3,
	// D2D1_DISTANTSPECULAR_PROP_SURFACE_SCALE = 4, D2D1_DISTANTSPECULAR_PROP_COLOR = 5, D2D1_DISTANTSPECULAR_PROP_KERNEL_UNIT_LENGTH = 6,
	// D2D1_DISTANTSPECULAR_PROP_SCALE_MODE = 7, D2D1_DISTANTSPECULAR_PROP_FORCE_DWORD = 0xffffffff } ;
	[PInvokeData("d2d1effects.h", MSDNShortId = "NE:d2d1effects.D2D1_DISTANTSPECULAR_PROP")]
	public enum D2D1_DISTANTSPECULAR_PROP : uint
	{
		/// <summary>
		/// <para>Value:</para>
		/// <para>0</para>
		/// <para>
		/// The direction angle of the light source in the XY plane relative to the X-axis in the counter clock wise direction. The units
		/// are in degrees and must be between 0 and 360 degrees.
		/// </para>
		/// <para>The type is FLOAT.</para>
		/// <para>The default value is 0.0f.</para>
		/// </summary>
		[CorrespondingType(typeof(float))]
		D2D1_DISTANTSPECULAR_PROP_AZIMUTH,

		/// <summary>
		/// <para>Value:</para>
		/// <para>1</para>
		/// <para>
		/// The direction angle of the light source in the YZ plane relative to the Y-axis in the counter clock wise direction. The units
		/// are in degrees and must be between 0 and 360 degrees.
		/// </para>
		/// <para>The type is FLOAT.</para>
		/// <para>The default value is 0.0f.</para>
		/// </summary>
		[CorrespondingType(typeof(float))]
		D2D1_DISTANTSPECULAR_PROP_ELEVATION,

		/// <summary>
		/// <para>Value:</para>
		/// <para>2</para>
		/// <para>
		/// The exponent for the specular term in the Phong lighting equation. A larger value corresponds to a more reflective surface. The
		/// value is unitless and must be between 1.0 and 128.
		/// </para>
		/// <para>The type is FLOAT.</para>
		/// <para>The default value is 1.0f.</para>
		/// </summary>
		[CorrespondingType(typeof(float))]
		D2D1_DISTANTSPECULAR_PROP_SPECULAR_EXPONENT,

		/// <summary>
		/// <para>Value:</para>
		/// <para>3</para>
		/// <para>The ratio of specular reflection to the incoming light. The value is unitless and must be between 0 and 10,000.</para>
		/// <para>The type is FLOAT.</para>
		/// <para>The default value is 1.0f.</para>
		/// </summary>
		[CorrespondingType(typeof(float))]
		D2D1_DISTANTSPECULAR_PROP_SPECULAR_CONSTANT,

		/// <summary>
		/// <para>Value:</para>
		/// <para>4</para>
		/// <para>The scale factor in the Z direction. The value is unitless and must be between 0 and 10,000.</para>
		/// <para>The type is FLOAT.</para>
		/// <para>The default value is 1.0f.</para>
		/// </summary>
		[CorrespondingType(typeof(float))]
		D2D1_DISTANTSPECULAR_PROP_SURFACE_SCALE,

		/// <summary>
		/// <para>Value:</para>
		/// <para>5</para>
		/// <para>
		/// The color of the incoming light. This property is exposed as a D2D1_VECTOR_3F – (R, G, B) and used to compute LR, LG, LB.
		/// </para>
		/// <para>The type is D2D1_VECTOR_3F.</para>
		/// <para>The default value is {1.0f, 1.0f, 1.0f}.</para>
		/// </summary>
		[CorrespondingType(typeof(D2D_VECTOR_3F))]
		D2D1_DISTANTSPECULAR_PROP_COLOR,

		/// <summary>
		/// <para>Value:</para>
		/// <para>6</para>
		/// <para>
		/// The size of an element in the Sobel kernel used to generate the surface normal in the X and Y direction. This property is a
		/// D2D1_VECTOR_2F (Kernel Unit Length X, Kernel Unit Length Y) and is defined in (device-independent pixels (DIPs)/Kernel Unit).
		/// The effect uses bilinear interpolation to scale the bitmap to match size of kernel elements.
		/// </para>
		/// <para>The type is D2D1_VECTOR_2F.</para>
		/// <para>The default value is {1.0f, 1.0f}.</para>
		/// </summary>
		[CorrespondingType(typeof(D2D_VECTOR_2F))]
		D2D1_DISTANTSPECULAR_PROP_KERNEL_UNIT_LENGTH,

		/// <summary>
		/// <para>Value:</para>
		/// <para>7</para>
		/// <para>
		/// The interpolation mode the effect uses to scale the image to the corresponding kernel unit length. There are six scale modes
		/// that range in quality and speed.
		/// </para>
		/// <para>The type is D2D1_DISTANTSPECULAR_SCALE_MODE.</para>
		/// <para>The default value is D2D1_DISTANTSPECULAR_SCALE_MODE_LINEAR.</para>
		/// </summary>
		[CorrespondingType(typeof(D2D1_DISTANTSPECULAR_SCALE_MODE))]
		D2D1_DISTANTSPECULAR_PROP_SCALE_MODE,
	}

	/// <summary>
	/// The interpolation mode the <c>Distant-specular lighting effect</c> uses to scale the image to the corresponding kernel unit length.
	/// There are six scale modes that range in quality and speed.
	/// </summary>
	// https://learn.microsoft.com/en-us/windows/win32/api/d2d1effects/ne-d2d1effects-d2d1_distantspecular_scale_mode typedef enum
	// D2D1_DISTANTSPECULAR_SCALE_MODE { D2D1_DISTANTSPECULAR_SCALE_MODE_NEAREST_NEIGHBOR = 0, D2D1_DISTANTSPECULAR_SCALE_MODE_LINEAR = 1,
	// D2D1_DISTANTSPECULAR_SCALE_MODE_CUBIC = 2, D2D1_DISTANTSPECULAR_SCALE_MODE_MULTI_SAMPLE_LINEAR = 3,
	// D2D1_DISTANTSPECULAR_SCALE_MODE_ANISOTROPIC = 4, D2D1_DISTANTSPECULAR_SCALE_MODE_HIGH_QUALITY_CUBIC = 5,
	// D2D1_DISTANTSPECULAR_SCALE_MODE_FORCE_DWORD = 0xffffffff } ;
	[PInvokeData("d2d1effects.h", MSDNShortId = "NE:d2d1effects.D2D1_DISTANTSPECULAR_SCALE_MODE")]
	public enum D2D1_DISTANTSPECULAR_SCALE_MODE : uint
	{
		/// <summary>
		/// <para>Value:</para>
		/// <para>0</para>
		/// <para>Samples the nearest single point and uses that. This mode uses less processing time, but outputs the lowest quality image.</para>
		/// </summary>
		D2D1_DISTANTSPECULAR_SCALE_MODE_NEAREST_NEIGHBOR,

		/// <summary>
		/// <para>Value:</para>
		/// <para>1</para>
		/// <para>Uses a four point sample and linear interpolation. This mode outputs a higher quality image than nearest neighbor.</para>
		/// </summary>
		D2D1_DISTANTSPECULAR_SCALE_MODE_LINEAR,

		/// <summary>
		/// <para>Value:</para>
		/// <para>2</para>
		/// <para>
		/// Uses a 16 sample cubic kernel for interpolation. This mode uses the most processing time, but outputs a higher quality image.
		/// </para>
		/// </summary>
		D2D1_DISTANTSPECULAR_SCALE_MODE_CUBIC,

		/// <summary>
		/// <para>Value:</para>
		/// <para>3</para>
		/// <para>
		/// Uses 4 linear samples within a single pixel for good edge anti-aliasing. This mode is good for scaling down by small amounts on
		/// images with few pixels.
		/// </para>
		/// </summary>
		D2D1_DISTANTSPECULAR_SCALE_MODE_MULTI_SAMPLE_LINEAR,

		/// <summary>
		/// <para>Value:</para>
		/// <para>4</para>
		/// <para>Uses anisotropic filtering to sample a pattern according to the transformed shape of the bitmap.</para>
		/// </summary>
		D2D1_DISTANTSPECULAR_SCALE_MODE_ANISOTROPIC,

		/// <summary>
		/// <para>Value:</para>
		/// <para>5</para>
		/// <para>
		/// Uses a variable size high quality cubic kernel to perform a pre-downscale the image if downscaling is involved in the transform matrix.
		/// </para>
		/// <para>Then uses the cubic interpolation mode for the final output.</para>
		/// </summary>
		D2D1_DISTANTSPECULAR_SCALE_MODE_HIGH_QUALITY_CUBIC,
	}

	/// <summary>The interpolation mode the <c>DPI compensation effect</c> uses to scale the image.</summary>
	// https://learn.microsoft.com/en-us/windows/win32/api/d2d1effects/ne-d2d1effects-d2d1_dpicompensation_interpolation_mode typedef enum
	// D2D1_DPICOMPENSATION_INTERPOLATION_MODE { D2D1_DPICOMPENSATION_INTERPOLATION_MODE_NEAREST_NEIGHBOR = 0,
	// D2D1_DPICOMPENSATION_INTERPOLATION_MODE_LINEAR = 1, D2D1_DPICOMPENSATION_INTERPOLATION_MODE_CUBIC = 2,
	// D2D1_DPICOMPENSATION_INTERPOLATION_MODE_MULTI_SAMPLE_LINEAR = 3, D2D1_DPICOMPENSATION_INTERPOLATION_MODE_ANISOTROPIC = 4,
	// D2D1_DPICOMPENSATION_INTERPOLATION_MODE_HIGH_QUALITY_CUBIC = 5, D2D1_DPICOMPENSATION_INTERPOLATION_MODE_FORCE_DWORD = 0xffffffff } ;
	[PInvokeData("d2d1effects.h", MSDNShortId = "NE:d2d1effects.D2D1_DPICOMPENSATION_INTERPOLATION_MODE")]
	public enum D2D1_DPICOMPENSATION_INTERPOLATION_MODE : uint
	{
		/// <summary>
		/// <para>Value:</para>
		/// <para>0</para>
		/// <para>Samples the nearest single point and uses that. This mode uses less processing time, but outputs the lowest quality image.</para>
		/// </summary>
		D2D1_DPICOMPENSATION_INTERPOLATION_MODE_NEAREST_NEIGHBOR,

		/// <summary>
		/// <para>Value:</para>
		/// <para>1</para>
		/// <para>
		/// Uses a four point sample and linear interpolation. This mode uses more processing time than the nearest neighbor mode, but
		/// outputs a higher quality image.
		/// </para>
		/// </summary>
		D2D1_DPICOMPENSATION_INTERPOLATION_MODE_LINEAR,

		/// <summary>
		/// <para>Value:</para>
		/// <para>2</para>
		/// <para>
		/// Uses a 16 sample cubic kernel for interpolation. This mode uses the most processing time, but outputs a higher quality image.
		/// </para>
		/// </summary>
		D2D1_DPICOMPENSATION_INTERPOLATION_MODE_CUBIC,

		/// <summary>
		/// <para>Value:</para>
		/// <para>3</para>
		/// <para>
		/// Uses 4 linear samples within a single pixel for good edge anti-aliasing. This mode is good for scaling down by small amounts on
		/// images with few pixels.
		/// </para>
		/// </summary>
		D2D1_DPICOMPENSATION_INTERPOLATION_MODE_MULTI_SAMPLE_LINEAR,

		/// <summary>
		/// <para>Value:</para>
		/// <para>4</para>
		/// <para>Uses anisotropic filtering to sample a pattern according to the transformed shape of the bitmap.</para>
		/// </summary>
		D2D1_DPICOMPENSATION_INTERPOLATION_MODE_ANISOTROPIC,

		/// <summary>
		/// <para>Value:</para>
		/// <para>5</para>
		/// <para>
		/// Uses a variable size high quality cubic kernel to perform a pre-downscale the image if downscaling is involved in the transform
		/// matrix. Then uses the cubic interpolation mode for the final output.
		/// </para>
		/// </summary>
		D2D1_DPICOMPENSATION_INTERPOLATION_MODE_HIGH_QUALITY_CUBIC,
	}

	/// <summary>Identifiers for properties of the <c>DPI compensation effect</c>.</summary>
	// https://learn.microsoft.com/en-us/windows/win32/api/d2d1effects/ne-d2d1effects-d2d1_dpicompensation_prop typedef enum
	// D2D1_DPICOMPENSATION_PROP { D2D1_DPICOMPENSATION_PROP_INTERPOLATION_MODE = 0, D2D1_DPICOMPENSATION_PROP_BORDER_MODE = 1,
	// D2D1_DPICOMPENSATION_PROP_INPUT_DPI = 2, D2D1_DPICOMPENSATION_PROP_FORCE_DWORD = 0xffffffff } ;
	[PInvokeData("d2d1effects.h", MSDNShortId = "NE:d2d1effects.D2D1_DPICOMPENSATION_PROP")]
	public enum D2D1_DPICOMPENSATION_PROP : uint
	{
		/// <summary>
		/// <para>Value:</para>
		/// <para>0</para>
		/// <para>The interpolation mode the effect uses to scale the image.</para>
		/// <para>The type is D2D1_DPICOMPENSATION_INTERPOLATION_MODE.</para>
		/// <para>The default value is D2D1_DPICOMPENSATION_INTERPOLATION_MODE_LINEAR.</para>
		/// </summary>
		[CorrespondingType(typeof(D2D1_DPICOMPENSATION_INTERPOLATION_MODE))]
		D2D1_DPICOMPENSATION_PROP_INTERPOLATION_MODE,

		/// <summary>
		/// <para>Value:</para>
		/// <para>1</para>
		/// <para>The mode used to calculate the border of the image, soft or hard. See Border modes for more info.</para>
		/// <para>The type is D2D1_BORDER_MODE.</para>
		/// <para>The default value is D2D1_BORDER_MODE_SOFT.</para>
		/// </summary>
		[CorrespondingType(typeof(D2D1_BORDER_MODE))]
		D2D1_DPICOMPENSATION_PROP_BORDER_MODE,

		/// <summary>
		/// <para>Value:</para>
		/// <para>2</para>
		/// <para>The DPI of the input image.</para>
		/// <para>The type is FLOAT.</para>
		/// <para>The default value is 96.0f.</para>
		/// </summary>
		[CorrespondingType(typeof(float))]
		D2D1_DPICOMPENSATION_PROP_INPUT_DPI,
	}

	/// <summary>Identifiers for properties of the <c>Flood effect</c>.</summary>
	// https://learn.microsoft.com/en-us/windows/win32/api/d2d1effects/ne-d2d1effects-d2d1_flood_prop typedef enum D2D1_FLOOD_PROP {
	// D2D1_FLOOD_PROP_COLOR = 0, D2D1_FLOOD_PROP_FORCE_DWORD = 0xffffffff } ;
	[PInvokeData("d2d1effects.h", MSDNShortId = "NE:d2d1effects.D2D1_FLOOD_PROP")]
	public enum D2D1_FLOOD_PROP : uint
	{
		/// <summary>
		/// <para>Value:</para>
		/// <para>0</para>
		/// <para>
		/// The color and opacity of the bitmap. This property is a D2D1_VECTOR_4F. The individual values for each channel are of type
		/// FLOAT, unbounded and unitless.
		/// </para>
		/// <para>The effect doesn't modify the values for the channels.</para>
		/// <para>The RGBA values for each channel range from 0 to 1.</para>
		/// <para>The type is D2D1_VECTOR_4F.</para>
		/// <para>The default value is {0.0f, 0.0f, 0.0f, 1.0f}.</para>
		/// </summary>
		[CorrespondingType(typeof(D2D_VECTOR_4F))]
		D2D1_FLOOD_PROP_COLOR,
	}

	/// <summary>Identifiers for properties of the <c>Gamma transfer effect</c>.</summary>
	// https://learn.microsoft.com/en-us/windows/win32/api/d2d1effects/ne-d2d1effects-d2d1_gammatransfer_prop typedef enum
	// D2D1_GAMMATRANSFER_PROP { D2D1_GAMMATRANSFER_PROP_RED_AMPLITUDE = 0, D2D1_GAMMATRANSFER_PROP_RED_EXPONENT = 1,
	// D2D1_GAMMATRANSFER_PROP_RED_OFFSET = 2, D2D1_GAMMATRANSFER_PROP_RED_DISABLE = 3, D2D1_GAMMATRANSFER_PROP_GREEN_AMPLITUDE = 4,
	// D2D1_GAMMATRANSFER_PROP_GREEN_EXPONENT = 5, D2D1_GAMMATRANSFER_PROP_GREEN_OFFSET = 6, D2D1_GAMMATRANSFER_PROP_GREEN_DISABLE = 7,
	// D2D1_GAMMATRANSFER_PROP_BLUE_AMPLITUDE = 8, D2D1_GAMMATRANSFER_PROP_BLUE_EXPONENT = 9, D2D1_GAMMATRANSFER_PROP_BLUE_OFFSET = 10,
	// D2D1_GAMMATRANSFER_PROP_BLUE_DISABLE = 11, D2D1_GAMMATRANSFER_PROP_ALPHA_AMPLITUDE = 12, D2D1_GAMMATRANSFER_PROP_ALPHA_EXPONENT = 13,
	// D2D1_GAMMATRANSFER_PROP_ALPHA_OFFSET = 14, D2D1_GAMMATRANSFER_PROP_ALPHA_DISABLE = 15, D2D1_GAMMATRANSFER_PROP_CLAMP_OUTPUT = 16,
	// D2D1_GAMMATRANSFER_PROP_FORCE_DWORD = 0xffffffff } ;
	[PInvokeData("d2d1effects.h", MSDNShortId = "NE:d2d1effects.D2D1_GAMMATRANSFER_PROP")]
	public enum D2D1_GAMMATRANSFER_PROP : uint
	{
		/// <summary>
		/// <para>Value:</para>
		/// <para>0</para>
		/// <para>The amplitude of the gamma transfer function for the Red channel.</para>
		/// <para>The type is FLOAT.</para>
		/// <para>The default value is 1.0f.</para>
		/// </summary>
		[CorrespondingType(typeof(float))]
		D2D1_GAMMATRANSFER_PROP_RED_AMPLITUDE,

		/// <summary>
		/// <para>Value:</para>
		/// <para>1</para>
		/// <para>The exponent of the gamma transfer function for the Red channel.</para>
		/// <para>The type is FLOAT.</para>
		/// <para>The default value is 1.0f.</para>
		/// </summary>
		[CorrespondingType(typeof(float))]
		D2D1_GAMMATRANSFER_PROP_RED_EXPONENT,

		/// <summary>
		/// <para>Value:</para>
		/// <para>2</para>
		/// <para>The offset of the gamma transfer function for the Red channel.</para>
		/// <para>The type is FLOAT.</para>
		/// <para>The default value is 0.0f.</para>
		/// </summary>
		[CorrespondingType(typeof(float))]
		D2D1_GAMMATRANSFER_PROP_RED_OFFSET,

		/// <summary>
		/// <para>Value:</para>
		/// <para>3</para>
		/// <para>If you set this to TRUE it does not apply the transfer function to the Red channel. An identity transfer function is used.</para>
		/// <para>If you set this to FALSE it applies the gamma transfer function to the Red channel.</para>
		/// <para>The type is BOOL.</para>
		/// <para>The default value is FALSE.</para>
		/// </summary>
		[CorrespondingType(typeof(BOOL))]
		D2D1_GAMMATRANSFER_PROP_RED_DISABLE,

		/// <summary>
		/// <para>Value:</para>
		/// <para>4</para>
		/// <para>The amplitude of the gamma transfer function for the Green channel.</para>
		/// <para>The type is FLOAT.</para>
		/// <para>The default value is 1.0f.</para>
		/// </summary>
		[CorrespondingType(typeof(float))]
		D2D1_GAMMATRANSFER_PROP_GREEN_AMPLITUDE,

		/// <summary>
		/// <para>Value:</para>
		/// <para>5</para>
		/// <para>The exponent of the gamma transfer function for the Green channel.</para>
		/// <para>The type is FLOAT.</para>
		/// <para>The default value is 1.0f.</para>
		/// </summary>
		[CorrespondingType(typeof(float))]
		D2D1_GAMMATRANSFER_PROP_GREEN_EXPONENT,

		/// <summary>
		/// <para>Value:</para>
		/// <para>6</para>
		/// <para>The offset of the gamma transfer function for the Green channel.</para>
		/// <para>The type is FLOAT.</para>
		/// <para>The default value is 0.0f.</para>
		/// </summary>
		[CorrespondingType(typeof(float))]
		D2D1_GAMMATRANSFER_PROP_GREEN_OFFSET,

		/// <summary>
		/// <para>Value:</para>
		/// <para>7</para>
		/// <para>
		/// If you set this to TRUE it does not apply the transfer function to the Green channel. An identity transfer function is used.
		/// </para>
		/// <para>If you set this to FALSE it applies the gamma transfer function to the Green channel.</para>
		/// <para>The type is BOOL.</para>
		/// <para>The default value is FALSE.</para>
		/// </summary>
		[CorrespondingType(typeof(BOOL))]
		D2D1_GAMMATRANSFER_PROP_GREEN_DISABLE,

		/// <summary>
		/// <para>Value:</para>
		/// <para>8</para>
		/// <para>The amplitude of the gamma transfer function for the Blue channel.</para>
		/// <para>The type is FLOAT.</para>
		/// <para>The default value is 1.0f.</para>
		/// </summary>
		[CorrespondingType(typeof(float))]
		D2D1_GAMMATRANSFER_PROP_BLUE_AMPLITUDE,

		/// <summary>
		/// <para>Value:</para>
		/// <para>9</para>
		/// <para>The exponent of the gamma transfer function for the Blue channel.</para>
		/// <para>The type is FLOAT.</para>
		/// <para>The default value is 1.0f.</para>
		/// </summary>
		[CorrespondingType(typeof(float))]
		D2D1_GAMMATRANSFER_PROP_BLUE_EXPONENT,

		/// <summary>
		/// <para>Value:</para>
		/// <para>10</para>
		/// <para>The offset of the gamma transfer function for the Blue channel.</para>
		/// <para>The type is FLOAT.</para>
		/// <para>The default value is 0.0f.</para>
		/// </summary>
		[CorrespondingType(typeof(float))]
		D2D1_GAMMATRANSFER_PROP_BLUE_OFFSET,

		/// <summary>
		/// <para>Value:</para>
		/// <para>11</para>
		/// <para>
		/// If you set this to TRUE it does not apply the transfer function to the Blue channel. An identity transfer function is used.
		/// </para>
		/// <para>If you set this to FALSE it applies the gamma transfer function to the Blue channel.</para>
		/// <para>The type is BOOL.</para>
		/// <para>The default value is FALSE.</para>
		/// </summary>
		[CorrespondingType(typeof(BOOL))]
		D2D1_GAMMATRANSFER_PROP_BLUE_DISABLE,

		/// <summary>
		/// <para>Value:</para>
		/// <para>12</para>
		/// <para>The amplitude of the gamma transfer function for the Alpha channel.</para>
		/// <para>The type is FLOAT.</para>
		/// <para>The default value is 1.0f.</para>
		/// </summary>
		[CorrespondingType(typeof(float))]
		D2D1_GAMMATRANSFER_PROP_ALPHA_AMPLITUDE,

		/// <summary>
		/// <para>Value:</para>
		/// <para>13</para>
		/// <para>The exponent of the gamma transfer function for the Alpha channel.</para>
		/// <para>The type is FLOAT.</para>
		/// <para>The default value is 1.0f.</para>
		/// </summary>
		[CorrespondingType(typeof(float))]
		D2D1_GAMMATRANSFER_PROP_ALPHA_EXPONENT,

		/// <summary>
		/// <para>Value:</para>
		/// <para>14</para>
		/// <para>The offset of the gamma transfer function for the Alpha channel.</para>
		/// <para>The type is FLOAT.</para>
		/// <para>The default value is 0.0f.</para>
		/// </summary>
		[CorrespondingType(typeof(float))]
		D2D1_GAMMATRANSFER_PROP_ALPHA_OFFSET,

		/// <summary>
		/// <para>Value:</para>
		/// <para>15</para>
		/// <para>
		/// If you set this to TRUE it does not apply the transfer function to the Alpha channel. An identity transfer function is used.
		/// </para>
		/// <para>If you set this to FALSE it applies the gamma transfer function to the Alpha channel.</para>
		/// <para>The type is BOOL.</para>
		/// <para>The default value is FALSE.</para>
		/// </summary>
		[CorrespondingType(typeof(BOOL))]
		D2D1_GAMMATRANSFER_PROP_ALPHA_DISABLE,

		/// <summary>
		/// <para>Value:</para>
		/// <para>16</para>
		/// <para>
		/// Whether the effect clamps color values to between 0 and 1 before the effect passes the values to the next effect in the graph.
		/// </para>
		/// <para>The effect clamps the values before it premultiplies the alpha.</para>
		/// <para>
		/// If you set this to TRUE the effect will clamp the values. If you set this to FALSE, the effect will not clamp the color values,
		/// </para>
		/// <para>but other effects and the output surface may clamp the values if they are not of high enough precision.</para>
		/// <para>The type is BOOL.</para>
		/// <para>The default value is FALSE.</para>
		/// </summary>
		[CorrespondingType(typeof(BOOL))]
		D2D1_GAMMATRANSFER_PROP_CLAMP_OUTPUT,
	}

	/// <summary>The optimization mode for the <c>Gaussian blur effect</c>.</summary>
	// https://learn.microsoft.com/en-us/windows/win32/api/d2d1effects/ne-d2d1effects-d2d1_gaussianblur_optimization typedef enum
	// D2D1_GAUSSIANBLUR_OPTIMIZATION { D2D1_GAUSSIANBLUR_OPTIMIZATION_SPEED = 0, D2D1_GAUSSIANBLUR_OPTIMIZATION_BALANCED = 1,
	// D2D1_GAUSSIANBLUR_OPTIMIZATION_QUALITY = 2, D2D1_GAUSSIANBLUR_OPTIMIZATION_FORCE_DWORD = 0xffffffff } ;
	[PInvokeData("d2d1effects.h", MSDNShortId = "NE:d2d1effects.D2D1_GAUSSIANBLUR_OPTIMIZATION")]
	public enum D2D1_GAUSSIANBLUR_OPTIMIZATION : uint
	{
		/// <summary>
		/// <para>Value:</para>
		/// <para>0</para>
		/// <para>Applies internal optimizations such as pre-scaling at relatively small radii. Uses linear filtering.</para>
		/// </summary>
		D2D1_GAUSSIANBLUR_OPTIMIZATION_SPEED,

		/// <summary>
		/// <para>Value:</para>
		/// <para>1</para>
		/// <para>Uses the same optimization thresholds as Speed mode, but uses trilinear filtering.</para>
		/// </summary>
		D2D1_GAUSSIANBLUR_OPTIMIZATION_BALANCED,

		/// <summary>
		/// <para>Value:</para>
		/// <para>2</para>
		/// <para>
		/// Only uses internal optimizations with large blur radii, where approximations are less likely to be visible. Uses trilinear filtering.
		/// </para>
		/// </summary>
		D2D1_GAUSSIANBLUR_OPTIMIZATION_QUALITY,
	}

	/// <summary>Identifiers for properties of the <c>Gaussian blur effect</c>.</summary>
	// https://learn.microsoft.com/en-us/windows/win32/api/d2d1effects/ne-d2d1effects-d2d1_gaussianblur_prop typedef enum
	// D2D1_GAUSSIANBLUR_PROP { D2D1_GAUSSIANBLUR_PROP_STANDARD_DEVIATION = 0, D2D1_GAUSSIANBLUR_PROP_OPTIMIZATION = 1,
	// D2D1_GAUSSIANBLUR_PROP_BORDER_MODE = 2, D2D1_GAUSSIANBLUR_PROP_FORCE_DWORD = 0xffffffff } ;
	[PInvokeData("d2d1effects.h", MSDNShortId = "NE:d2d1effects.D2D1_GAUSSIANBLUR_PROP")]
	public enum D2D1_GAUSSIANBLUR_PROP : uint
	{
		/// <summary>
		/// <para>Value:</para>
		/// <para>0</para>
		/// <para>
		/// The amount of blur to be applied to the image. You can compute the blur radius of the kernel by multiplying the standard
		/// deviation by 3.
		/// </para>
		/// <para>The units of both the standard deviation and blur radius are DIPs. A value of zero DIPs disables this effect entirely.</para>
		/// <para>The type is FLOAT.</para>
		/// <para>The default value is 3.0f.</para>
		/// </summary>
		[CorrespondingType(typeof(float))]
		D2D1_GAUSSIANBLUR_PROP_STANDARD_DEVIATION,

		/// <summary>
		/// <para>Value:</para>
		/// <para>1</para>
		/// <para>The optimization mode.</para>
		/// <para>The type isD2D1_GAUSSIANBLUR_OPTIMIZATION.</para>
		/// <para>The default value is D2D1_GAUSSIANBLUR_OPTIMIZATION_BALANCED.</para>
		/// </summary>
		[CorrespondingType(typeof(D2D1_GAUSSIANBLUR_OPTIMIZATION))]
		D2D1_GAUSSIANBLUR_PROP_OPTIMIZATION,

		/// <summary>
		/// <para>Value:</para>
		/// <para>2</para>
		/// <para>The mode used to calculate the border of the image, soft or hard.</para>
		/// <para>The type isD2D1_GAUSSIANBLUR_OPTIMIZATION.</para>
		/// <para>The default value is D2D1_BORDER_MODE_SOFT.</para>
		/// </summary>
		[CorrespondingType(typeof(D2D1_BORDER_MODE))]
		D2D1_GAUSSIANBLUR_PROP_BORDER_MODE,
	}

	/// <summary>Identifiers for properties of the <c>Histogram effect</c>.</summary>
	// https://learn.microsoft.com/en-us/windows/win32/api/d2d1effects/ne-d2d1effects-d2d1_histogram_prop typedef enum D2D1_HISTOGRAM_PROP {
	// D2D1_HISTOGRAM_PROP_NUM_BINS = 0, D2D1_HISTOGRAM_PROP_CHANNEL_SELECT = 1, D2D1_HISTOGRAM_PROP_HISTOGRAM_OUTPUT = 2,
	// D2D1_HISTOGRAM_PROP_FORCE_DWORD = 0xffffffff } ;
	[PInvokeData("d2d1effects.h", MSDNShortId = "NE:d2d1effects.D2D1_HISTOGRAM_PROP")]
	public enum D2D1_HISTOGRAM_PROP : uint
	{
		/// <summary>
		/// <para>Value:</para>
		/// <para>0</para>
		/// <para>
		/// Specifies the number of bins used for the histogram. The range of intensity values that fall into a particular bucket depend on
		/// the number of specified buckets.
		/// </para>
		/// <para>The type is UINT32.</para>
		/// <para>The default is 256.</para>
		/// </summary>
		[CorrespondingType(typeof(uint))]
		D2D1_HISTOGRAM_PROP_NUM_BINS,

		/// <summary>
		/// <para>Value:</para>
		/// <para>1</para>
		/// <para>
		/// Specifies the channel used to generate the histogram. This effect has a single data output corresponding to the specified channel.
		/// </para>
		/// <para>The type isD2D1_CHANNEL_SELECTOR.</para>
		/// <para>The default is D2D1_CHANNEL_SELECTOR_R.</para>
		/// </summary>
		[CorrespondingType(typeof(D2D1_CHANNEL_SELECTOR))]
		D2D1_HISTOGRAM_PROP_CHANNEL_SELECT,

		/// <summary>
		/// <para>Value:</para>
		/// <para>2</para>
		/// <para>The output array.</para>
		/// <para>The type is FLOAT[].</para>
		/// </summary>
		[CorrespondingType(typeof(float[]))]
		D2D1_HISTOGRAM_PROP_HISTOGRAM_OUTPUT,
	}

	/// <summary>Identifiers for properties of the <c>Hue rotate effect</c>.</summary>
	// https://learn.microsoft.com/en-us/windows/win32/api/d2d1effects/ne-d2d1effects-d2d1_huerotation_prop typedef enum
	// D2D1_HUEROTATION_PROP { D2D1_HUEROTATION_PROP_ANGLE = 0, D2D1_HUEROTATION_PROP_FORCE_DWORD = 0xffffffff } ;
	[PInvokeData("d2d1effects.h", MSDNShortId = "NE:d2d1effects.D2D1_HUEROTATION_PROP")]
	public enum D2D1_HUEROTATION_PROP
	{
		/// <summary>
		/// <para>Value:</para>
		/// <para>0</para>
		/// <para>The angle to rotate the hue, in degrees.</para>
		/// <para>The type is FLOAT.</para>
		/// <para>The default is 0.0f.</para>
		/// </summary>
		[CorrespondingType(typeof(float))]
		D2D1_HUEROTATION_PROP_ANGLE,
	}

	/// <summary>Identifiers for properties of the <c>Linear transfer effect</c>.</summary>
	// https://learn.microsoft.com/en-us/windows/win32/api/d2d1effects/ne-d2d1effects-d2d1_lineartransfer_prop typedef enum
	// D2D1_LINEARTRANSFER_PROP { D2D1_LINEARTRANSFER_PROP_RED_Y_INTERCEPT = 0, D2D1_LINEARTRANSFER_PROP_RED_SLOPE = 1,
	// D2D1_LINEARTRANSFER_PROP_RED_DISABLE = 2, D2D1_LINEARTRANSFER_PROP_GREEN_Y_INTERCEPT = 3, D2D1_LINEARTRANSFER_PROP_GREEN_SLOPE = 4,
	// D2D1_LINEARTRANSFER_PROP_GREEN_DISABLE = 5, D2D1_LINEARTRANSFER_PROP_BLUE_Y_INTERCEPT = 6, D2D1_LINEARTRANSFER_PROP_BLUE_SLOPE = 7,
	// D2D1_LINEARTRANSFER_PROP_BLUE_DISABLE = 8, D2D1_LINEARTRANSFER_PROP_ALPHA_Y_INTERCEPT = 9, D2D1_LINEARTRANSFER_PROP_ALPHA_SLOPE = 10,
	// D2D1_LINEARTRANSFER_PROP_ALPHA_DISABLE = 11, D2D1_LINEARTRANSFER_PROP_CLAMP_OUTPUT = 12, D2D1_LINEARTRANSFER_PROP_FORCE_DWORD =
	// 0xffffffff } ;
	[PInvokeData("d2d1effects.h", MSDNShortId = "NE:d2d1effects.D2D1_LINEARTRANSFER_PROP")]
	public enum D2D1_LINEARTRANSFER_PROP
	{
		/// <summary>
		/// <para>Value:</para>
		/// <para>0</para>
		/// <para>The Y-intercept of the linear function for the Red channel.</para>
		/// <para>The type is FLOAT.</para>
		/// <para>The default is 0.0f.</para>
		/// </summary>
		[CorrespondingType(typeof(float))]
		D2D1_LINEARTRANSFER_PROP_RED_Y_INTERCEPT,

		/// <summary>
		/// <para>Value:</para>
		/// <para>1</para>
		/// <para>The slope of the linear function for the Red channel.</para>
		/// <para>The type is FLOAT.</para>
		/// <para>The default is 1.0f.</para>
		/// </summary>
		[CorrespondingType(typeof(float))]
		D2D1_LINEARTRANSFER_PROP_RED_SLOPE,

		/// <summary>
		/// <para>Value:</para>
		/// <para>2</para>
		/// <para>If you set this to TRUE the effect does not apply the transfer function to the Red channel.</para>
		/// <para>If you set this to FALSE the effect applies the RedLinearTransfer function to the Red channel.</para>
		/// <para>The type is BOOL.</para>
		/// <para>The default is FALSE.</para>
		/// </summary>
		[CorrespondingType(typeof(BOOL))]
		D2D1_LINEARTRANSFER_PROP_RED_DISABLE,

		/// <summary>
		/// <para>Value:</para>
		/// <para>3</para>
		/// <para>The Y-intercept of the linear function for the Green channel.</para>
		/// <para>The type is FLOAT.</para>
		/// <para>The default is 0.0f.</para>
		/// </summary>
		[CorrespondingType(typeof(float))]
		D2D1_LINEARTRANSFER_PROP_GREEN_Y_INTERCEPT,

		/// <summary>
		/// <para>Value:</para>
		/// <para>4</para>
		/// <para>The slope of the linear function for the Green channel.</para>
		/// <para>The type is FLOAT.</para>
		/// <para>The default is 1.0f.</para>
		/// </summary>
		[CorrespondingType(typeof(float))]
		D2D1_LINEARTRANSFER_PROP_GREEN_SLOPE,

		/// <summary>
		/// <para>Value:</para>
		/// <para>5</para>
		/// <para>If you set this to TRUE the effect does not apply the transfer function to the Green channel.</para>
		/// <para>If you set this to FALSE the effect applies the GreenLinearTransfer function to the Green channel.</para>
		/// <para>The type is BOOL.</para>
		/// <para>The default is FALSE.</para>
		/// </summary>
		[CorrespondingType(typeof(BOOL))]
		D2D1_LINEARTRANSFER_PROP_GREEN_DISABLE,

		/// <summary>
		/// <para>Value:</para>
		/// <para>6</para>
		/// <para>The Y-intercept of the linear function for the Blue channel.</para>
		/// <para>The type is FLOAT.</para>
		/// <para>The default is 0.0f.</para>
		/// </summary>
		[CorrespondingType(typeof(float))]
		D2D1_LINEARTRANSFER_PROP_BLUE_Y_INTERCEPT,

		/// <summary>
		/// <para>Value:</para>
		/// <para>7</para>
		/// <para>The slope of the linear function for the Blue channel.</para>
		/// <para>The type is FLOAT.</para>
		/// <para>The default is 1.0f.</para>
		/// </summary>
		[CorrespondingType(typeof(float))]
		D2D1_LINEARTRANSFER_PROP_BLUE_SLOPE,

		/// <summary>
		/// <para>Value:</para>
		/// <para>8</para>
		/// <para>If you set this to TRUE the effect does not apply the transfer function to the Blue channel.</para>
		/// <para>If you set this to FALSE the effect applies the BlueLinearTransfer function to the Blue channel.</para>
		/// <para>The type is BOOL.</para>
		/// <para>The default is FALSE.</para>
		/// </summary>
		[CorrespondingType(typeof(BOOL))]
		D2D1_LINEARTRANSFER_PROP_BLUE_DISABLE,

		/// <summary>
		/// <para>Value:</para>
		/// <para>9</para>
		/// <para>The Y-intercept of the linear function for the Alpha channel.</para>
		/// <para>The type is FLOAT.</para>
		/// <para>The default is 0.0f.</para>
		/// </summary>
		[CorrespondingType(typeof(float))]
		D2D1_LINEARTRANSFER_PROP_ALPHA_Y_INTERCEPT,

		/// <summary>
		/// <para>Value:</para>
		/// <para>10</para>
		/// <para>The slope of the linear function for the Alpha channel.</para>
		/// <para>The type is FLOAT.</para>
		/// <para>The default is 0.0f.</para>
		/// </summary>
		[CorrespondingType(typeof(float))]
		D2D1_LINEARTRANSFER_PROP_ALPHA_SLOPE,

		/// <summary>
		/// <para>Value:</para>
		/// <para>11</para>
		/// <para>If you set this to TRUE the effect does not apply the transfer function to the Alpha channel.</para>
		/// <para>If you set this to FALSE the effect applies the AlphaLinearTransfer function to the Alpha channel.</para>
		/// <para>The type is BOOL.</para>
		/// <para>The default is FALSE.</para>
		/// </summary>
		[CorrespondingType(typeof(BOOL))]
		D2D1_LINEARTRANSFER_PROP_ALPHA_DISABLE,

		/// <summary>
		/// <para>Value:</para>
		/// <para>12</para>
		/// <para>
		/// Whether the effect clamps color values to between 0 and 1 before the effect passes the values to the next effect in the graph.
		/// </para>
		/// <para>The effect clamps the values before it premultiplies the alpha .</para>
		/// <para>
		/// If you set this to TRUE the effect will clamp the values. If you set this to FALSE, the effect will not clamp the color values,
		/// but other effects and
		/// </para>
		/// <para>the output surface may clamp the values if they are not of high enough precision.</para>
		/// <para>The type is BOOL.</para>
		/// <para>The default is FALSE.</para>
		/// </summary>
		[CorrespondingType(typeof(BOOL))]
		D2D1_LINEARTRANSFER_PROP_CLAMP_OUTPUT,
	}

	/// <summary>The mode for the <c>Morphology effect</c>.</summary>
	// https://learn.microsoft.com/en-us/windows/win32/api/d2d1effects/ne-d2d1effects-d2d1_morphology_mode typedef enum D2D1_MORPHOLOGY_MODE
	// { D2D1_MORPHOLOGY_MODE_ERODE = 0, D2D1_MORPHOLOGY_MODE_DILATE = 1, D2D1_MORPHOLOGY_MODE_FORCE_DWORD = 0xffffffff } ;
	[PInvokeData("d2d1effects.h", MSDNShortId = "NE:d2d1effects.D2D1_MORPHOLOGY_MODE")]
	public enum D2D1_MORPHOLOGY_MODE : uint
	{
		/// <summary>
		/// <para>Value:</para>
		/// <para>0</para>
		/// <para>The minimum value from each RGB channel in the kernel is used.</para>
		/// </summary>
		D2D1_MORPHOLOGY_MODE_ERODE,

		/// <summary>
		/// <para>Value:</para>
		/// <para>1</para>
		/// <para>The maximum value from each RGB channel in the kernel is used.</para>
		/// </summary>
		D2D1_MORPHOLOGY_MODE_DILATE,
	}

	/// <summary>Identifiers for properties of the <c>Morphology effect</c>.</summary>
	// https://learn.microsoft.com/en-us/windows/win32/api/d2d1effects/ne-d2d1effects-d2d1_morphology_prop typedef enum D2D1_MORPHOLOGY_PROP
	// { D2D1_MORPHOLOGY_PROP_MODE = 0, D2D1_MORPHOLOGY_PROP_WIDTH = 1, D2D1_MORPHOLOGY_PROP_HEIGHT = 2, D2D1_MORPHOLOGY_PROP_FORCE_DWORD =
	// 0xffffffff } ;
	[PInvokeData("d2d1effects.h", MSDNShortId = "NE:d2d1effects.D2D1_MORPHOLOGY_PROP")]
	public enum D2D1_MORPHOLOGY_PROP : uint
	{
		/// <summary>
		/// <para>Value:</para>
		/// <para>0</para>
		/// <para>The morphology mode.</para>
		/// <para>The type is D2D1_MORPHOLOGY_MODE.</para>
		/// <para>The default value is D2D1_MORPHOLOGY_MODE_ERODE.</para>
		/// </summary>
		[CorrespondingType(typeof(D2D1_MORPHOLOGY_MODE))]
		D2D1_MORPHOLOGY_PROP_MODE,

		/// <summary>
		/// <para>Value:</para>
		/// <para>1</para>
		/// <para>Size of the kernel in the X direction. The units are in DIPs. Values must be between 1 and 100 inclusive.</para>
		/// <para>The type is UINT.</para>
		/// <para>The default value is 1.</para>
		/// </summary>
		[CorrespondingType(typeof(uint))]
		D2D1_MORPHOLOGY_PROP_WIDTH,

		/// <summary>
		/// <para>Value:</para>
		/// <para>2</para>
		/// <para>Size of the kernel in the Y direction. The units are in DIPs. Values must be between 1 and 100 inclusive.</para>
		/// <para>The type is UINT.</para>
		/// <para>The default value is 1.</para>
		/// </summary>
		[CorrespondingType(typeof(uint))]
		D2D1_MORPHOLOGY_PROP_HEIGHT,
	}

	/// <summary>Identifiers for properties of the <c>Opacity metadata effect</c>.</summary>
	// https://learn.microsoft.com/en-us/windows/win32/api/d2d1effects/ne-d2d1effects-d2d1_opacitymetadata_prop typedef enum
	// D2D1_OPACITYMETADATA_PROP { D2D1_OPACITYMETADATA_PROP_INPUT_OPAQUE_RECT = 0, D2D1_OPACITYMETADATA_PROP_FORCE_DWORD = 0xffffffff } ;
	[PInvokeData("d2d1effects.h", MSDNShortId = "NE:d2d1effects.D2D1_OPACITYMETADATA_PROP")]
	public enum D2D1_OPACITYMETADATA_PROP : uint
	{
		/// <summary>
		/// <para>Value:</para>
		/// <para>0</para>
		/// <para>The portion of the source image that is opaque. The default is the entire input image.</para>
		/// <para>The type isD2D1_VECTOR_4F.</para>
		/// <para>The default is {-FLT_MAX, -FLT_MAX, FLT_MAX, FLT_MAX}.</para>
		/// </summary>
		[CorrespondingType(typeof(D2D_VECTOR_4F))]
		D2D1_OPACITYMETADATA_PROP_INPUT_OPAQUE_RECT,
	}

	/// <summary>Identifiers for properties of the <c>Point-diffuse lighting effect</c>.</summary>
	// https://learn.microsoft.com/en-us/windows/win32/api/d2d1effects/ne-d2d1effects-d2d1_pointdiffuse_prop typedef enum
	// D2D1_POINTDIFFUSE_PROP { D2D1_POINTDIFFUSE_PROP_LIGHT_POSITION = 0, D2D1_POINTDIFFUSE_PROP_DIFFUSE_CONSTANT = 1,
	// D2D1_POINTDIFFUSE_PROP_SURFACE_SCALE = 2, D2D1_POINTDIFFUSE_PROP_COLOR = 3, D2D1_POINTDIFFUSE_PROP_KERNEL_UNIT_LENGTH = 4,
	// D2D1_POINTDIFFUSE_PROP_SCALE_MODE = 5, D2D1_POINTDIFFUSE_PROP_FORCE_DWORD = 0xffffffff } ;
	[PInvokeData("d2d1effects.h", MSDNShortId = "NE:d2d1effects.D2D1_POINTDIFFUSE_PROP")]
	public enum D2D1_POINTDIFFUSE_PROP
	{
		/// <summary>
		/// <para>Value:</para>
		/// <para>0</para>
		/// <para>
		/// The light position of the point light source. The property is a D2D1_VECTOR_3F defined as (x, y, z). The units are in
		/// device-independent pixels (DIPs) and are unbounded.
		/// </para>
		/// <para>The type isD2D1_VECTOR_3F.</para>
		/// <para>The default value is {0.0f, 0.0f, 0.0f}.</para>
		/// </summary>
		[CorrespondingType(typeof(D2D_VECTOR_3F))]
		D2D1_POINTDIFFUSE_PROP_LIGHT_POSITION,

		/// <summary>
		/// <para>Value:</para>
		/// <para>1</para>
		/// <para>The ratio of diffuse reflection to amount of incoming light. This property must be between 0 and 10,000 and is unitless.</para>
		/// <para>The type is FLOAT.</para>
		/// <para>The default value is 1.0f.</para>
		/// </summary>
		[CorrespondingType(typeof(float))]
		D2D1_POINTDIFFUSE_PROP_DIFFUSE_CONSTANT,

		/// <summary>
		/// <para>Value:</para>
		/// <para>2</para>
		/// <para>The scale factor in the Z direction. The surface scale is unitless and must be between 0 and 10,000.</para>
		/// <para>The type is FLOAT.</para>
		/// <para>The default value is 1.0f.</para>
		/// </summary>
		[CorrespondingType(typeof(float))]
		D2D1_POINTDIFFUSE_PROP_SURFACE_SCALE,

		/// <summary>
		/// <para>Value:</para>
		/// <para>3</para>
		/// <para>The color of the incoming light. This property is exposed as a Vector 3 – (R, G, B) and used to compute LR, LG, LB.</para>
		/// <para>The type isD2D1_VECTOR_3F.</para>
		/// <para>The default value is {1.0f, 1.0f, 1.0f}.</para>
		/// </summary>
		[CorrespondingType(typeof(D2D_VECTOR_3F))]
		D2D1_POINTDIFFUSE_PROP_COLOR,

		/// <summary>
		/// <para>Value:</para>
		/// <para>4</para>
		/// <para>
		/// The size of an element in the Sobel kernel used to generate the surface normal in the X and Y direction. This property maps to
		/// the dx and dy values in the Sobel gradient.
		/// </para>
		/// <para>This property is a</para>
		/// <para>D2D1_VECTOR_2F</para>
		/// <para>(Kernel Unit Length X, Kernel Unit Length Y) and is defined in (DIPs/Kernel Unit).</para>
		/// <para>The effect uses bilinear interpolation to scale the bitmap to match size of kernel elements.</para>
		/// <para>The type isD2D1_VECTOR_2F.</para>
		/// <para>The default value is {1.0f, 1.0f}.</para>
		/// </summary>
		[CorrespondingType(typeof(D2D_VECTOR_2F))]
		D2D1_POINTDIFFUSE_PROP_KERNEL_UNIT_LENGTH,

		/// <summary>
		/// <para>Value:</para>
		/// <para>5</para>
		/// <para>
		/// The interpolation mode the effect uses to scale the image to the corresponding kernel unit length. There are six scale modes
		/// that range in quality and speed.
		/// </para>
		/// <para>The type isD2D1_POINTDIFFUSE_SCALE_MODE.</para>
		/// <para>The default value is D2D1_POINTDIFFUSE_SCALE_MODE_LINEAR.</para>
		/// </summary>
		[CorrespondingType(typeof(D2D1_POINTDIFFUSE_SCALE_MODE))]
		D2D1_POINTDIFFUSE_PROP_SCALE_MODE,
	}

	/// <summary>
	/// The interpolation mode the <c>Point-diffuse lighting effect</c> uses to scale the image to the corresponding kernel unit length.
	/// There are six scale modes that range in quality and speed
	/// </summary>
	// https://learn.microsoft.com/en-us/windows/win32/api/d2d1effects/ne-d2d1effects-d2d1_pointdiffuse_scale_mode typedef enum
	// D2D1_POINTDIFFUSE_SCALE_MODE { D2D1_POINTDIFFUSE_SCALE_MODE_NEAREST_NEIGHBOR = 0, D2D1_POINTDIFFUSE_SCALE_MODE_LINEAR = 1,
	// D2D1_POINTDIFFUSE_SCALE_MODE_CUBIC = 2, D2D1_POINTDIFFUSE_SCALE_MODE_MULTI_SAMPLE_LINEAR = 3,
	// D2D1_POINTDIFFUSE_SCALE_MODE_ANISOTROPIC = 4, D2D1_POINTDIFFUSE_SCALE_MODE_HIGH_QUALITY_CUBIC = 5,
	// D2D1_POINTDIFFUSE_SCALE_MODE_FORCE_DWORD = 0xffffffff } ;
	[PInvokeData("d2d1effects.h", MSDNShortId = "NE:d2d1effects.D2D1_POINTDIFFUSE_SCALE_MODE")]
	public enum D2D1_POINTDIFFUSE_SCALE_MODE : uint
	{
		/// <summary>
		/// <para>Value:</para>
		/// <para>0</para>
		/// <para>Samples the nearest single point and uses that. This mode uses less processing time, but outputs the lowest quality image.</para>
		/// </summary>
		D2D1_POINTDIFFUSE_SCALE_MODE_NEAREST_NEIGHBOR,

		/// <summary>
		/// <para>Value:</para>
		/// <para>1</para>
		/// <para>Uses a four point sample and linear interpolation. This mode outputs a higher quality image than nearest neighbor.</para>
		/// </summary>
		D2D1_POINTDIFFUSE_SCALE_MODE_LINEAR,

		/// <summary>
		/// <para>Value:</para>
		/// <para>2</para>
		/// <para>
		/// Uses a 16 sample cubic kernel for interpolation. This mode uses the most processing time, but outputs a higher quality image.
		/// </para>
		/// </summary>
		D2D1_POINTDIFFUSE_SCALE_MODE_CUBIC,

		/// <summary>
		/// <para>Value:</para>
		/// <para>3</para>
		/// <para>
		/// Uses 4 linear samples within a single pixel for good edge anti-aliasing. This mode is good for scaling down by small amounts on
		/// images with few pixels.
		/// </para>
		/// </summary>
		D2D1_POINTDIFFUSE_SCALE_MODE_MULTI_SAMPLE_LINEAR,

		/// <summary>
		/// <para>Value:</para>
		/// <para>4</para>
		/// <para>Uses anisotropic filtering to sample a pattern according to the transformed shape of the bitmap.</para>
		/// </summary>
		D2D1_POINTDIFFUSE_SCALE_MODE_ANISOTROPIC,

		/// <summary>
		/// <para>Value:</para>
		/// <para>5</para>
		/// <para>
		/// Uses a variable size high quality cubic kernel to perform a pre-downscale the image if downscaling is involved in the transform
		/// matrix. Then uses the cubic interpolation mode for the final output.
		/// </para>
		/// </summary>
		D2D1_POINTDIFFUSE_SCALE_MODE_HIGH_QUALITY_CUBIC,
	}

	/// <summary>Identifiers for properties of the <c>Point-specular lighting effect</c>.</summary>
	// https://learn.microsoft.com/en-us/windows/win32/api/d2d1effects/ne-d2d1effects-d2d1_pointspecular_prop typedef enum
	// D2D1_POINTSPECULAR_PROP { D2D1_POINTSPECULAR_PROP_LIGHT_POSITION = 0, D2D1_POINTSPECULAR_PROP_SPECULAR_EXPONENT = 1,
	// D2D1_POINTSPECULAR_PROP_SPECULAR_CONSTANT = 2, D2D1_POINTSPECULAR_PROP_SURFACE_SCALE = 3, D2D1_POINTSPECULAR_PROP_COLOR = 4,
	// D2D1_POINTSPECULAR_PROP_KERNEL_UNIT_LENGTH = 5, D2D1_POINTSPECULAR_PROP_SCALE_MODE = 6, D2D1_POINTSPECULAR_PROP_FORCE_DWORD =
	// 0xffffffff } ;
	[PInvokeData("d2d1effects.h", MSDNShortId = "NE:d2d1effects.D2D1_POINTSPECULAR_PROP")]
	public enum D2D1_POINTSPECULAR_PROP
	{
		/// <summary>
		/// <para>Value:</para>
		/// <para>0</para>
		/// <para>
		/// The light position of the point light source. The property is a D2D1_VECTOR_3F defined as (x, y, z). The units are in
		/// device-independent pixels (DIPs) and the values are unitless and unbounded.
		/// </para>
		/// <para>The type is D2D1_VECTOR_3F.</para>
		/// <para>The default value is {0.0f, 0.0f, 0.0f}.</para>
		/// </summary>
		[CorrespondingType(typeof(D2D_VECTOR_3F))]
		D2D1_POINTSPECULAR_PROP_LIGHT_POSITION,

		/// <summary>
		/// <para>Value:</para>
		/// <para>1</para>
		/// <para>
		/// The exponent for the specular term in the Phong lighting equation. A larger value corresponds to a more reflective surface. This
		/// value is unitless and must be between 1.0 and 128.
		/// </para>
		/// <para>The type is FLOAT.</para>
		/// <para>The default value is 1.0f.</para>
		/// </summary>
		[CorrespondingType(typeof(float))]
		D2D1_POINTSPECULAR_PROP_SPECULAR_EXPONENT,

		/// <summary>
		/// <para>Value:</para>
		/// <para>2</para>
		/// <para>The ratio of specular reflection to the incoming light. The value is unitless and must be between 0 and 10,000.</para>
		/// <para>The type is FLOAT.</para>
		/// <para>The default value is 1.0f.</para>
		/// </summary>
		[CorrespondingType(typeof(float))]
		D2D1_POINTSPECULAR_PROP_SPECULAR_CONSTANT,

		/// <summary>
		/// <para>Value:</para>
		/// <para>3</para>
		/// <para>The scale factor in the Z direction for generating a height map. The value is unitless and must be between 0 and 10,000.</para>
		/// <para>The type is FLOAT.</para>
		/// <para>The default value is 1.0f.</para>
		/// </summary>
		[CorrespondingType(typeof(float))]
		D2D1_POINTSPECULAR_PROP_SURFACE_SCALE,

		/// <summary>
		/// <para>Value:</para>
		/// <para>4</para>
		/// <para>The color of the incoming light. This property is exposed as a</para>
		/// <para>D2D1_VECTOR_3F</para>
		/// <para>– (R, G, B) and used to compute LR, LG, LB.</para>
		/// <para>The type isD2D1_VECTOR_3F.</para>
		/// <para>The default value is {1.0f, 1.0f, 1.0f}.</para>
		/// </summary>
		[CorrespondingType(typeof(D2D_VECTOR_3F))]
		D2D1_POINTSPECULAR_PROP_COLOR,

		/// <summary>
		/// <para>Value:</para>
		/// <para>5</para>
		/// <para>
		/// The size of an element in the Sobel kernel used to generate the surface normal in the X and Y directions. This property maps to
		/// the dx and dy values in the Sobel gradient.
		/// </para>
		/// <para>This property is a</para>
		/// <para>D2D1_VECTOR_2F</para>
		/// <para>(Kernel Unit Length X, Kernel Unit Length Y) and is defined in (DIPs/Kernel Unit).</para>
		/// <para>The effect uses bilinear interpolation to scale the bitmap to match size of kernel elements.</para>
		/// <para>The type isD2D1_VECTOR_2F.</para>
		/// <para>The default value is {1.0f, 1.0f}.</para>
		/// </summary>
		[CorrespondingType(typeof(D2D_VECTOR_2F))]
		D2D1_POINTSPECULAR_PROP_KERNEL_UNIT_LENGTH,

		/// <summary>
		/// <para>Value:</para>
		/// <para>6</para>
		/// <para>
		/// The interpolation mode the effect uses to scale the image to the corresponding kernel unit length. There are six scale modes
		/// that range in quality and speed.
		/// </para>
		/// <para>The type isD2D1_POINTSPECULAR_SCALE_MODE.</para>
		/// <para>The default value is D2D1_POINTSPECULAR_SCALE_MODE_LINEAR.</para>
		/// </summary>
		[CorrespondingType(typeof(D2D1_POINTSPECULAR_SCALE_MODE))]
		D2D1_POINTSPECULAR_PROP_SCALE_MODE,
	}

	/// <summary>
	/// The interpolation mode the <c>Point-specular lighting effect</c> uses to scale the image to the corresponding kernel unit length.
	/// There are six scale modes that range in quality and speed.
	/// </summary>
	// https://learn.microsoft.com/en-us/windows/win32/api/d2d1effects/ne-d2d1effects-d2d1_pointspecular_scale_mode typedef enum
	// D2D1_POINTSPECULAR_SCALE_MODE { D2D1_POINTSPECULAR_SCALE_MODE_NEAREST_NEIGHBOR = 0, D2D1_POINTSPECULAR_SCALE_MODE_LINEAR = 1,
	// D2D1_POINTSPECULAR_SCALE_MODE_CUBIC = 2, D2D1_POINTSPECULAR_SCALE_MODE_MULTI_SAMPLE_LINEAR = 3,
	// D2D1_POINTSPECULAR_SCALE_MODE_ANISOTROPIC = 4, D2D1_POINTSPECULAR_SCALE_MODE_HIGH_QUALITY_CUBIC = 5,
	// D2D1_POINTSPECULAR_SCALE_MODE_FORCE_DWORD = 0xffffffff } ;
	[PInvokeData("d2d1effects.h", MSDNShortId = "NE:d2d1effects.D2D1_POINTSPECULAR_SCALE_MODE")]
	public enum D2D1_POINTSPECULAR_SCALE_MODE : uint
	{
		/// <summary>
		/// <para>Value:</para>
		/// <para>0</para>
		/// <para>Samples the nearest single point and uses that. This mode uses less processing time, but outputs the lowest quality image.</para>
		/// </summary>
		D2D1_POINTSPECULAR_SCALE_MODE_NEAREST_NEIGHBOR,

		/// <summary>
		/// <para>Value:</para>
		/// <para>1</para>
		/// <para>Uses a four point sample and linear interpolation. This mode outputs a higher quality image than nearest neighbor.</para>
		/// </summary>
		D2D1_POINTSPECULAR_SCALE_MODE_LINEAR,

		/// <summary>
		/// <para>Value:</para>
		/// <para>2</para>
		/// <para>
		/// Uses a 16 sample cubic kernel for interpolation. This mode uses the most processing time, but outputs a higher quality image.
		/// </para>
		/// </summary>
		D2D1_POINTSPECULAR_SCALE_MODE_CUBIC,

		/// <summary>
		/// <para>Value:</para>
		/// <para>3</para>
		/// <para>
		/// Uses 4 linear samples within a single pixel for good edge anti-aliasing. This mode is good for scaling down by small amounts on
		/// images with few pixels.
		/// </para>
		/// </summary>
		D2D1_POINTSPECULAR_SCALE_MODE_MULTI_SAMPLE_LINEAR,

		/// <summary>
		/// <para>Value:</para>
		/// <para>4</para>
		/// <para>Uses anisotropic filtering to sample a pattern according to the transformed shape of the bitmap.</para>
		/// </summary>
		D2D1_POINTSPECULAR_SCALE_MODE_ANISOTROPIC,

		/// <summary>
		/// <para>Value:</para>
		/// <para>5</para>
		/// <para>
		/// Uses a variable size high quality cubic kernel to perform a pre-downscale the image if downscaling is involved in the transform
		/// matrix. Then uses the cubic interpolation mode for the final output.
		/// </para>
		/// </summary>
		D2D1_POINTSPECULAR_SCALE_MODE_HIGH_QUALITY_CUBIC,
	}

	/// <summary>Identifiers for properties of the <c>Saturation effect</c>.</summary>
	// https://learn.microsoft.com/en-us/windows/win32/api/d2d1effects/ne-d2d1effects-d2d1_saturation_prop typedef enum D2D1_SATURATION_PROP
	// { D2D1_SATURATION_PROP_SATURATION = 0, D2D1_SATURATION_PROP_FORCE_DWORD = 0xffffffff } ;
	[PInvokeData("d2d1effects.h", MSDNShortId = "NE:d2d1effects.D2D1_SATURATION_PROP")]
	public enum D2D1_SATURATION_PROP : uint
	{
		/// <summary>
		/// <para>Value:</para>
		/// <para>0</para>
		/// <para>
		/// The saturation of the image. You can set the saturation to a value between 0 and 1. If you set it to 1 the output image is fully saturated.
		/// </para>
		/// <para>If you set it to 0 the output image is monochrome. The saturation value is unitless.</para>
		/// <para>The type is FLOAT.</para>
		/// <para>The default is 0.5f.</para>
		/// </summary>
		[CorrespondingType(typeof(float))]
		D2D1_SATURATION_PROP_SATURATION,
	}

	/// <summary>
	/// The interpolation mode the <c>Scale effect</c> uses to scale the image. There are 6 scale modes that range in quality and speed.
	/// </summary>
	// https://learn.microsoft.com/en-us/windows/win32/api/d2d1effects/ne-d2d1effects-d2d1_scale_interpolation_mode typedef enum
	// D2D1_SCALE_INTERPOLATION_MODE { D2D1_SCALE_INTERPOLATION_MODE_NEAREST_NEIGHBOR = 0, D2D1_SCALE_INTERPOLATION_MODE_LINEAR = 1,
	// D2D1_SCALE_INTERPOLATION_MODE_CUBIC = 2, D2D1_SCALE_INTERPOLATION_MODE_MULTI_SAMPLE_LINEAR = 3,
	// D2D1_SCALE_INTERPOLATION_MODE_ANISOTROPIC = 4, D2D1_SCALE_INTERPOLATION_MODE_HIGH_QUALITY_CUBIC = 5,
	// D2D1_SCALE_INTERPOLATION_MODE_FORCE_DWORD = 0xffffffff } ;
	[PInvokeData("d2d1effects.h", MSDNShortId = "NE:d2d1effects.D2D1_SCALE_INTERPOLATION_MODE")]
	public enum D2D1_SCALE_INTERPOLATION_MODE : uint
	{
		/// <summary>
		/// <para>Value:</para>
		/// <para>0</para>
		/// <para>Samples the nearest single point and uses that. This mode uses less processing time, but outputs the lowest quality image.</para>
		/// </summary>
		D2D1_SCALE_INTERPOLATION_MODE_NEAREST_NEIGHBOR,

		/// <summary>
		/// <para>Value:</para>
		/// <para>1</para>
		/// <para>
		/// Uses a four point sample and linear interpolation. This mode uses more processing time than the nearest neighbor mode, but
		/// outputs a higher quality image.
		/// </para>
		/// </summary>
		D2D1_SCALE_INTERPOLATION_MODE_LINEAR,

		/// <summary>
		/// <para>Value:</para>
		/// <para>2</para>
		/// <para>
		/// Uses a 16 sample cubic kernel for interpolation. This mode uses the most processing time, but outputs a higher quality image.
		/// </para>
		/// </summary>
		D2D1_SCALE_INTERPOLATION_MODE_CUBIC,

		/// <summary>
		/// <para>Value:</para>
		/// <para>3</para>
		/// <para>
		/// Uses 4 linear samples within a single pixel for good edge anti-aliasing. This mode is good for scaling down by small amounts on
		/// images with few pixels.
		/// </para>
		/// </summary>
		D2D1_SCALE_INTERPOLATION_MODE_MULTI_SAMPLE_LINEAR,

		/// <summary>
		/// <para>Value:</para>
		/// <para>4</para>
		/// <para>Uses anisotropic filtering to sample a pattern according to the transformed shape of the bitmap.</para>
		/// </summary>
		D2D1_SCALE_INTERPOLATION_MODE_ANISOTROPIC,

		/// <summary>
		/// <para>Value:</para>
		/// <para>5</para>
		/// <para>
		/// Uses a variable size high quality cubic kernel to perform a pre-downscale the image if downscaling is involved in the transform
		/// matrix. Then uses the cubic interpolation mode for the final output.
		/// </para>
		/// </summary>
		D2D1_SCALE_INTERPOLATION_MODE_HIGH_QUALITY_CUBIC,
	}

	/// <summary>Identifiers for properties of the <c>Scale effect</c>.</summary>
	// https://learn.microsoft.com/en-us/windows/win32/api/d2d1effects/ne-d2d1effects-d2d1_scale_prop typedef enum D2D1_SCALE_PROP {
	// D2D1_SCALE_PROP_SCALE = 0, D2D1_SCALE_PROP_CENTER_POINT = 1, D2D1_SCALE_PROP_INTERPOLATION_MODE = 2, D2D1_SCALE_PROP_BORDER_MODE = 3,
	// D2D1_SCALE_PROP_SHARPNESS = 4, D2D1_SCALE_PROP_FORCE_DWORD = 0xffffffff } ;
	[PInvokeData("d2d1effects.h", MSDNShortId = "NE:d2d1effects.D2D1_SCALE_PROP")]
	public enum D2D1_SCALE_PROP
	{
		/// <summary>
		/// <para>Value:</para>
		/// <para>0</para>
		/// <para>The scale amount in the X and Y direction as a ratio of the output size to the input size.</para>
		/// <para>This property aD2D1_VECTOR_2F defined as: (X scale, Y scale).</para>
		/// <para>The scale amounts are FLOAT, unitless, and must be positive or 0.</para>
		/// <para>The type isD2D1_VECTOR_2F.</para>
		/// <para>The default value is {1.0f, 1.0f}.</para>
		/// </summary>
		[CorrespondingType(typeof(D2D_VECTOR_2F))]
		D2D1_SCALE_PROP_SCALE,

		/// <summary>
		/// <para>Value:</para>
		/// <para>1</para>
		/// <para>The image scaling center point. This property is aD2D1_VECTOR_2F defined as: (point X, point Y). The units are in DIPs.</para>
		/// <para>Use the center point property to scale around a point other than the upper-left corner.</para>
		/// <para>The type isD2D1_VECTOR_2F.</para>
		/// <para>The default value is {0.0f, 0.0f}.</para>
		/// </summary>
		[CorrespondingType(typeof(D2D_VECTOR_2F))]
		D2D1_SCALE_PROP_CENTER_POINT,

		/// <summary>
		/// <para>Value:</para>
		/// <para>2</para>
		/// <para>The interpolation mode the effect uses to scale the image. There are 6 scale modes that range in quality and speed.</para>
		/// <para>The type isD2D1_SCALE_INTERPOLATION_MODE.</para>
		/// <para>The default value is D2D1_SCALE_INTERPOLATION_MODE_LINEAR.</para>
		/// </summary>
		[CorrespondingType(typeof(D2D1_SCALE_INTERPOLATION_MODE))]
		D2D1_SCALE_PROP_INTERPOLATION_MODE,

		/// <summary>
		/// <para>Value:</para>
		/// <para>3</para>
		/// <para>The mode used to calculate the border of the image, soft or hard.</para>
		/// <para>The type isD2D1_BORDER_MODE.</para>
		/// <para>The default value is D2D1_BORDER_MODE_SOFT.</para>
		/// </summary>
		[CorrespondingType(typeof(D2D1_BORDER_MODE))]
		D2D1_SCALE_PROP_BORDER_MODE,

		/// <summary>
		/// <para>Value:</para>
		/// <para>4</para>
		/// <para>
		/// In the high quality cubic interpolation mode, the sharpness level of the scaling filter as a float between 0 and 1. The values
		/// are unitless.
		/// </para>
		/// <para>You can use sharpness to adjust the quality of an image when you scale the image down.</para>
		/// <para>The sharpness factor affects the shape of the kernel. The higher the sharpness factor, the smaller the kernel.</para>
		/// <para><b>Note</b>  This property affects only the high quality cubic interpolation mode.</para>
		/// <para>The type is FLOAT.</para>
		/// <para>The default value is 0.0f.</para>
		/// </summary>
		[CorrespondingType(typeof(float))]
		D2D1_SCALE_PROP_SHARPNESS,
	}

	/// <summary>The level of performance optimization for the <c>Shadow effect</c>.</summary>
	// https://learn.microsoft.com/en-us/windows/win32/api/d2d1effects/ne-d2d1effects-d2d1_shadow_optimization typedef enum
	// D2D1_SHADOW_OPTIMIZATION { D2D1_SHADOW_OPTIMIZATION_SPEED = 0, D2D1_SHADOW_OPTIMIZATION_BALANCED = 1,
	// D2D1_SHADOW_OPTIMIZATION_QUALITY = 2, D2D1_SHADOW_OPTIMIZATION_FORCE_DWORD = 0xffffffff } ;
	[PInvokeData("d2d1effects.h", MSDNShortId = "NE:d2d1effects.D2D1_SHADOW_OPTIMIZATION")]
	public enum D2D1_SHADOW_OPTIMIZATION : uint
	{
		/// <summary>
		/// <para>Value:</para>
		/// <para>0</para>
		/// <para>Applies internal optimizations such as pre-scaling at relatively small radii. Uses linear filtering.</para>
		/// </summary>
		D2D1_SHADOW_OPTIMIZATION_SPEED,

		/// <summary>
		/// <para>Value:</para>
		/// <para>1</para>
		/// <para>Uses the same optimization thresholds as Speed mode, but uses trilinear filtering.</para>
		/// </summary>
		D2D1_SHADOW_OPTIMIZATION_BALANCED,

		/// <summary>
		/// <para>Value:</para>
		/// <para>2</para>
		/// <para>
		/// Only uses internal optimizations with large blur radii, where approximations are less likely to be visible. Uses trilinear filtering.
		/// </para>
		/// </summary>
		D2D1_SHADOW_OPTIMIZATION_QUALITY,
	}

	/// <summary>Identifiers for properties of the <c>Shadow effect</c>.</summary>
	// https://learn.microsoft.com/en-us/windows/win32/api/d2d1effects/ne-d2d1effects-d2d1_shadow_prop typedef enum D2D1_SHADOW_PROP {
	// D2D1_SHADOW_PROP_BLUR_STANDARD_DEVIATION = 0, D2D1_SHADOW_PROP_COLOR = 1, D2D1_SHADOW_PROP_OPTIMIZATION = 2,
	// D2D1_SHADOW_PROP_FORCE_DWORD = 0xffffffff } ;
	[PInvokeData("d2d1effects.h", MSDNShortId = "NE:d2d1effects.D2D1_SHADOW_PROP")]
	public enum D2D1_SHADOW_PROP
	{
		/// <summary>
		/// <para>Value:</para>
		/// <para>0</para>
		/// <para>
		/// The amount of blur to be applied to the alpha channel of the image. You can compute the blur radius of the kernel by multiplying
		/// the standard deviation by 3.
		/// </para>
		/// <para>The units of both the standard deviation and blur radius are DIPs.</para>
		/// <para>This property is the same as the Gaussian Blur standard deviation property.</para>
		/// <para>The type is FLOAT.</para>
		/// <para>The default value is 3.0f.</para>
		/// </summary>
		[CorrespondingType(typeof(float))]
		D2D1_SHADOW_PROP_BLUR_STANDARD_DEVIATION,

		/// <summary>
		/// <para>Value:</para>
		/// <para>1</para>
		/// <para>
		/// The color of the drop shadow. This property is a D2D1_VECTOR_4F defined as: (R, G, B, A). You must specify this color in
		/// straight alpha.
		/// </para>
		/// <para>The type isD2D1_VECTOR_4F.</para>
		/// <para>The default value is {0.0f, 0.0f, 0.0f, 1.0f}.</para>
		/// </summary>
		[CorrespondingType(typeof(D2D_VECTOR_4F))]
		D2D1_SHADOW_PROP_COLOR,

		/// <summary>
		/// <para>Value:</para>
		/// <para>2</para>
		/// <para>The level of performance optimization.</para>
		/// <para>The type isD2D1_SHADOW_OPTIMIZATION.</para>
		/// <para>The default value is D2D1_SHADOW_OPTIMIZATION_BALANCED.</para>
		/// </summary>
		[CorrespondingType(typeof(D2D1_SHADOW_OPTIMIZATION))]
		D2D1_SHADOW_PROP_OPTIMIZATION,
	}

	/// <summary>Identifiers for properties of the <c>Spot-diffuse lighting effect</c>.</summary>
	// https://learn.microsoft.com/en-us/windows/win32/api/d2d1effects/ne-d2d1effects-d2d1_spotdiffuse_prop typedef enum
	// D2D1_SPOTDIFFUSE_PROP { D2D1_SPOTDIFFUSE_PROP_LIGHT_POSITION = 0, D2D1_SPOTDIFFUSE_PROP_POINTS_AT = 1, D2D1_SPOTDIFFUSE_PROP_FOCUS =
	// 2, D2D1_SPOTDIFFUSE_PROP_LIMITING_CONE_ANGLE = 3, D2D1_SPOTDIFFUSE_PROP_DIFFUSE_CONSTANT = 4, D2D1_SPOTDIFFUSE_PROP_SURFACE_SCALE =
	// 5, D2D1_SPOTDIFFUSE_PROP_COLOR = 6, D2D1_SPOTDIFFUSE_PROP_KERNEL_UNIT_LENGTH = 7, D2D1_SPOTDIFFUSE_PROP_SCALE_MODE = 8,
	// D2D1_SPOTDIFFUSE_PROP_FORCE_DWORD = 0xffffffff } ;
	[PInvokeData("d2d1effects.h", MSDNShortId = "NE:d2d1effects.D2D1_SPOTDIFFUSE_PROP")]
	public enum D2D1_SPOTDIFFUSE_PROP : uint
	{
		/// <summary>
		/// <para>Value:</para>
		/// <para>0</para>
		/// <para>
		/// The light position of the point light source. The property is a D2D1_VECTOR_3F defined as (x, y, z). The units are in
		/// device-independent pixels (DIPs) and are unbounded.
		/// </para>
		/// <para>The type isD2D1_VECTOR_3F.</para>
		/// <para>The default value is {0.0f, 0.0f, 0.0f}.</para>
		/// </summary>
		[CorrespondingType(typeof(D2D_VECTOR_3F))]
		D2D1_SPOTDIFFUSE_PROP_LIGHT_POSITION,

		/// <summary>
		/// <para>Value:</para>
		/// <para>1</para>
		/// <para>
		/// Where the spot light is focused. The property is exposed as a D2D1_VECTOR_3F with – (x, y, z). The units are in DIPs and the
		/// values are unbounded.
		/// </para>
		/// <para>The type isD2D1_VECTOR_3F.</para>
		/// <para>The default value is {0.0f, 0.0f, 0.0f}.</para>
		/// </summary>
		[CorrespondingType(typeof(D2D_VECTOR_3F))]
		D2D1_SPOTDIFFUSE_PROP_POINTS_AT,

		/// <summary>
		/// <para>Value:</para>
		/// <para>2</para>
		/// <para>The focus of the spot light. This property is unitless and is defined between 0 and 200.</para>
		/// <para>The type is FLOAT.</para>
		/// <para>The default value is 1.0f.</para>
		/// </summary>
		[CorrespondingType(typeof(float))]
		D2D1_SPOTDIFFUSE_PROP_FOCUS,

		/// <summary>
		/// <para>Value:</para>
		/// <para>3</para>
		/// <para>
		/// The cone angle that restricts the region where the light is projected. No light is projected outside the cone. The limiting cone
		/// angle is the angle between the spot light axis (the axis between the LightPosition and PointsAt properties) and the spot light
		/// cone. This property is defined in degrees and must be between 0 to 90 degrees.
		/// </para>
		/// <para>The type is FLOAT.</para>
		/// <para>The default value is 90.0f.</para>
		/// </summary>
		[CorrespondingType(typeof(float))]
		D2D1_SPOTDIFFUSE_PROP_LIMITING_CONE_ANGLE,

		/// <summary>
		/// <para>Value:</para>
		/// <para>4</para>
		/// <para>The ratio of diffuse reflection to amount of incoming light. This property must be between 0 and 10,000 and is unitless.</para>
		/// <para>The type is FLOAT.</para>
		/// <para>The default value is 1.0f.</para>
		/// </summary>
		[CorrespondingType(typeof(float))]
		D2D1_SPOTDIFFUSE_PROP_DIFFUSE_CONSTANT,

		/// <summary>
		/// <para>Value:</para>
		/// <para>5</para>
		/// <para>The scale factor in the Z direction. The surface scale is unitless and must be between 0 and 10,000.</para>
		/// <para>The type is FLOAT.</para>
		/// <para>The default value is 1.0f.</para>
		/// </summary>
		[CorrespondingType(typeof(float))]
		D2D1_SPOTDIFFUSE_PROP_SURFACE_SCALE,

		/// <summary>
		/// <para>Value:</para>
		/// <para>6</para>
		/// <para>The color of the incoming light. This property is exposed as a Vector 3 – (R, G, B) and used to compute L</para>
		/// <para>R</para>
		/// <para>, L</para>
		/// <para>G</para>
		/// <para>, LB.</para>
		/// <para>The type isD2D1_VECTOR_3F.</para>
		/// <para>The default value is {1.0f, 1.0f, 1.0f}</para>
		/// </summary>
		[CorrespondingType(typeof(D2D_VECTOR_3F))]
		D2D1_SPOTDIFFUSE_PROP_COLOR,

		/// <summary>
		/// <para>Value:</para>
		/// <para>7</para>
		/// <para>
		/// The size of an element in the Sobel kernel used to generate the surface normal in the X and Y direction. This property maps to
		/// the dx and dy values in the Sobel gradient.
		/// </para>
		/// <para>This property is a</para>
		/// <para>D2D1_VECTOR_2F</para>
		/// <para>(Kernel Unit Length X, Kernel Unit Length Y) and is defined in (DIPs/Kernel Unit).</para>
		/// <para>The effect uses bilinear interpolation to scale the bitmap to match size of kernel elements.</para>
		/// <para>The type isD2D1_VECTOR_2F.</para>
		/// <para>The default value is {1.0f, 1.0f}.</para>
		/// </summary>
		[CorrespondingType(typeof(D2D_VECTOR_2F))]
		D2D1_SPOTDIFFUSE_PROP_KERNEL_UNIT_LENGTH,

		/// <summary>
		/// <para>Value:</para>
		/// <para>8</para>
		/// <para>
		/// The interpolation mode the effect uses to scale the image to the corresponding kernel unit length. There are six scale modes
		/// that range in quality and speed.
		/// </para>
		/// <para>The type isD2D1_SPOTDIFFUSE_SCALE_MODE.</para>
		/// <para>The default value is D2D1_SPOTDIFFUSE_SCALE_MODE_LINEAR.</para>
		/// </summary>
		[CorrespondingType(typeof(D2D1_SPOTDIFFUSE_SCALE_MODE))]
		D2D1_SPOTDIFFUSE_PROP_SCALE_MODE,
	}

	/// <summary>
	/// The interpolation mode the <c>Spot-diffuse lighting effect</c> uses to scale the image to the corresponding kernel unit length.
	/// There are six scale modes that range in quality and speed.
	/// </summary>
	// https://learn.microsoft.com/en-us/windows/win32/api/d2d1effects/ne-d2d1effects-d2d1_spotdiffuse_scale_mode typedef enum
	// D2D1_SPOTDIFFUSE_SCALE_MODE { D2D1_SPOTDIFFUSE_SCALE_MODE_NEAREST_NEIGHBOR = 0, D2D1_SPOTDIFFUSE_SCALE_MODE_LINEAR = 1,
	// D2D1_SPOTDIFFUSE_SCALE_MODE_CUBIC = 2, D2D1_SPOTDIFFUSE_SCALE_MODE_MULTI_SAMPLE_LINEAR = 3, D2D1_SPOTDIFFUSE_SCALE_MODE_ANISOTROPIC =
	// 4, D2D1_SPOTDIFFUSE_SCALE_MODE_HIGH_QUALITY_CUBIC = 5, D2D1_SPOTDIFFUSE_SCALE_MODE_FORCE_DWORD = 0xffffffff } ;
	[PInvokeData("d2d1effects.h", MSDNShortId = "NE:d2d1effects.D2D1_SPOTDIFFUSE_SCALE_MODE")]
	public enum D2D1_SPOTDIFFUSE_SCALE_MODE : uint
	{
		/// <summary>
		/// <para>Value:</para>
		/// <para>0</para>
		/// <para>Samples the nearest single point and uses that. This mode uses less processing time, but outputs the lowest quality image.</para>
		/// </summary>
		D2D1_SPOTDIFFUSE_SCALE_MODE_NEAREST_NEIGHBOR,

		/// <summary>
		/// <para>Value:</para>
		/// <para>1</para>
		/// <para>Uses a four point sample and linear interpolation. This mode outputs a higher quality image than nearest neighbor.</para>
		/// </summary>
		D2D1_SPOTDIFFUSE_SCALE_MODE_LINEAR,

		/// <summary>
		/// <para>Value:</para>
		/// <para>2</para>
		/// <para>
		/// Uses a 16 sample cubic kernel for interpolation. This mode uses the most processing time, but outputs a higher quality image.
		/// </para>
		/// </summary>
		D2D1_SPOTDIFFUSE_SCALE_MODE_CUBIC,

		/// <summary>
		/// <para>Value:</para>
		/// <para>3</para>
		/// <para>
		/// Uses 4 linear samples within a single pixel for good edge anti-aliasing. This mode is good for scaling down by small amounts on
		/// images with few pixels.
		/// </para>
		/// </summary>
		D2D1_SPOTDIFFUSE_SCALE_MODE_MULTI_SAMPLE_LINEAR,

		/// <summary>
		/// <para>Value:</para>
		/// <para>4</para>
		/// <para>Uses anisotropic filtering to sample a pattern according to the transformed shape of the bitmap.</para>
		/// </summary>
		D2D1_SPOTDIFFUSE_SCALE_MODE_ANISOTROPIC,

		/// <summary>
		/// <para>Value:</para>
		/// <para>5</para>
		/// <para>
		/// Uses a variable size high quality cubic kernel to perform a pre-downscale the image if downscaling is involved in the transform matrix.
		/// </para>
		/// <para>Then uses the cubic interpolation mode for the final output.</para>
		/// </summary>
		D2D1_SPOTDIFFUSE_SCALE_MODE_HIGH_QUALITY_CUBIC,
	}

	/// <summary>Identifiers for properties of the <c>Spot-specular lighting effect</c>.</summary>
	// https://learn.microsoft.com/en-us/windows/win32/api/d2d1effects/ne-d2d1effects-d2d1_spotspecular_prop typedef enum
	// D2D1_SPOTSPECULAR_PROP { D2D1_SPOTSPECULAR_PROP_LIGHT_POSITION = 0, D2D1_SPOTSPECULAR_PROP_POINTS_AT = 1,
	// D2D1_SPOTSPECULAR_PROP_FOCUS = 2, D2D1_SPOTSPECULAR_PROP_LIMITING_CONE_ANGLE = 3, D2D1_SPOTSPECULAR_PROP_SPECULAR_EXPONENT = 4,
	// D2D1_SPOTSPECULAR_PROP_SPECULAR_CONSTANT = 5, D2D1_SPOTSPECULAR_PROP_SURFACE_SCALE = 6, D2D1_SPOTSPECULAR_PROP_COLOR = 7,
	// D2D1_SPOTSPECULAR_PROP_KERNEL_UNIT_LENGTH = 8, D2D1_SPOTSPECULAR_PROP_SCALE_MODE = 9, D2D1_SPOTSPECULAR_PROP_FORCE_DWORD = 0xffffffff
	// } ;
	[PInvokeData("d2d1effects.h", MSDNShortId = "NE:d2d1effects.D2D1_SPOTSPECULAR_PROP")]
	public enum D2D1_SPOTSPECULAR_PROP
	{
		/// <summary>
		/// <para>Value:</para>
		/// <para>0</para>
		/// <para>The light position of the point light source. The property is aD2D1_VECTOR_3F defined as (x, y, z).</para>
		/// <para>The units are in device-independent pixels (DIPs) and are unbounded.</para>
		/// <para>The type isD2D1_VECTOR_3F.</para>
		/// <para>The default value is {0.0f, 0.0f, 0.0f}.</para>
		/// </summary>
		[CorrespondingType(typeof(D2D_VECTOR_3F))]
		D2D1_SPOTSPECULAR_PROP_LIGHT_POSITION,

		/// <summary>
		/// <para>Value:</para>
		/// <para>1</para>
		/// <para>Where the spot light is focused. The property is exposed as aD2D1_VECTOR_3F with – (x, y, z).</para>
		/// <para>The units are in DIPs and the values are unbounded.</para>
		/// <para>The type isD2D1_VECTOR_3F.</para>
		/// <para>The default value is {0.0f, 0.0f, 0.0f}.</para>
		/// </summary>
		[CorrespondingType(typeof(D2D_VECTOR_3F))]
		D2D1_SPOTSPECULAR_PROP_POINTS_AT,

		/// <summary>
		/// <para>Value:</para>
		/// <para>2</para>
		/// <para>The focus of the spot light. This property is unitless and is defined between 0 and 200.</para>
		/// <para>The type is FLOAT.</para>
		/// <para>The default value is 1.0f.</para>
		/// </summary>
		[CorrespondingType(typeof(float))]
		D2D1_SPOTSPECULAR_PROP_FOCUS,

		/// <summary>
		/// <para>Value:</para>
		/// <para>3</para>
		/// <para>The cone angle that restricts the region where the light is projected. No light is projected outside the cone.</para>
		/// <para>
		/// The limiting cone angle is the angle between the spot light axis (the axis between the LightPosition and PointsAt properties)
		/// and the spot light cone.
		/// </para>
		/// <para>This property is defined in degrees and must be between 0 to 90 degrees.</para>
		/// <para>The type is FLOAT.</para>
		/// <para>The default value is 90.0f.</para>
		/// </summary>
		[CorrespondingType(typeof(float))]
		D2D1_SPOTSPECULAR_PROP_LIMITING_CONE_ANGLE,

		/// <summary>
		/// <para>Value:</para>
		/// <para>4</para>
		/// <para>
		/// The exponent for the specular term in the Phong lighting equation. A larger value corresponds to a more reflective surface. This
		/// value is unitless and must be between 1.0 and 128.
		/// </para>
		/// <para>The type is FLOAT.</para>
		/// <para>The default value is 1.0f.</para>
		/// </summary>
		[CorrespondingType(typeof(float))]
		D2D1_SPOTSPECULAR_PROP_SPECULAR_EXPONENT,

		/// <summary>
		/// <para>Value:</para>
		/// <para>5</para>
		/// <para>The ratio of specular reflection to the incoming light. The value is unitless and must be between 0 and 10,000.</para>
		/// <para>The type is FLOAT.</para>
		/// <para>The default value is 1.0f.</para>
		/// </summary>
		[CorrespondingType(typeof(float))]
		D2D1_SPOTSPECULAR_PROP_SPECULAR_CONSTANT,

		/// <summary>
		/// <para>Value:</para>
		/// <para>6</para>
		/// <para>The scale factor in the Z direction for generating a height map. The value is unitless and must be between 0 and 10,000.</para>
		/// <para>The type is FLOAT.</para>
		/// <para>The default value is 1.0f.</para>
		/// </summary>
		[CorrespondingType(typeof(float))]
		D2D1_SPOTSPECULAR_PROP_SURFACE_SCALE,

		/// <summary>
		/// <para>Value:</para>
		/// <para>7</para>
		/// <para>The color of the incoming light. This property is exposed as a Vector 3 – (R, G, B) and used to compute LR, LG, LB.</para>
		/// <para>The type isD2D1_VECTOR_3F.</para>
		/// <para>The default value is {1.0f, 1.0f, 1.0f}.</para>
		/// </summary>
		[CorrespondingType(typeof(D2D_VECTOR_3F))]
		D2D1_SPOTSPECULAR_PROP_COLOR,

		/// <summary>
		/// <para>Value:</para>
		/// <para>8</para>
		/// <para>
		/// The size of an element in the Sobel kernel used to generate the surface normal in the X and Y direction. This property maps to
		/// the dx and dy values in the Sobel gradient.
		/// </para>
		/// <para>This property is a D2D1_VECTOR_2F (Kernel Unit Length X, Kernel Unit Length Y) and is defined in (DIPs/Kernel Unit).</para>
		/// <para>The effect uses bilinear interpolation to scale the bitmap to match size of kernel elements.</para>
		/// <para>The type isD2D1_VECTOR_2F.</para>
		/// <para>The default value is {1.0f, 1.0f}.</para>
		/// </summary>
		[CorrespondingType(typeof(D2D_VECTOR_2F))]
		D2D1_SPOTSPECULAR_PROP_KERNEL_UNIT_LENGTH,

		/// <summary>
		/// <para>Value:</para>
		/// <para>9</para>
		/// <para>
		/// The interpolation mode the effect uses to scale the image to the corresponding kernel unit length. There are six scale modes
		/// that range in quality and speed.
		/// </para>
		/// <para>The type isD2D1_SPOTSPECULAR_SCALE_MODE.</para>
		/// <para>The default value is D2D1_SPOTSPECULAR_SCALE_MODE_LINEAR.</para>
		/// </summary>
		[CorrespondingType(typeof(D2D1_SPOTSPECULAR_SCALE_MODE))]
		D2D1_SPOTSPECULAR_PROP_SCALE_MODE,
	}

	/// <summary>
	/// The interpolation mode the <c>Spot-specular lighting effect</c> uses to scale the image to the corresponding kernel unit length.
	/// There are six scale modes that range in quality and speed.
	/// </summary>
	// https://learn.microsoft.com/en-us/windows/win32/api/d2d1effects/ne-d2d1effects-d2d1_spotspecular_scale_mode typedef enum
	// D2D1_SPOTSPECULAR_SCALE_MODE { D2D1_SPOTSPECULAR_SCALE_MODE_NEAREST_NEIGHBOR = 0, D2D1_SPOTSPECULAR_SCALE_MODE_LINEAR = 1,
	// D2D1_SPOTSPECULAR_SCALE_MODE_CUBIC = 2, D2D1_SPOTSPECULAR_SCALE_MODE_MULTI_SAMPLE_LINEAR = 3,
	// D2D1_SPOTSPECULAR_SCALE_MODE_ANISOTROPIC = 4, D2D1_SPOTSPECULAR_SCALE_MODE_HIGH_QUALITY_CUBIC = 5,
	// D2D1_SPOTSPECULAR_SCALE_MODE_FORCE_DWORD = 0xffffffff } ;
	[PInvokeData("d2d1effects.h", MSDNShortId = "NE:d2d1effects.D2D1_SPOTSPECULAR_SCALE_MODE")]
	public enum D2D1_SPOTSPECULAR_SCALE_MODE : uint
	{
		/// <summary>
		/// <para>Value:</para>
		/// <para>0</para>
		/// <para>Samples the nearest single point and uses that. This mode uses less processing time, but outputs the lowest quality image.</para>
		/// </summary>
		D2D1_SPOTSPECULAR_SCALE_MODE_NEAREST_NEIGHBOR,

		/// <summary>
		/// <para>Value:</para>
		/// <para>1</para>
		/// <para>Uses a four point sample and linear interpolation. This mode outputs a higher quality image than nearest neighbor.</para>
		/// </summary>
		D2D1_SPOTSPECULAR_SCALE_MODE_LINEAR,

		/// <summary>
		/// <para>Value:</para>
		/// <para>2</para>
		/// <para>
		/// Uses a 16 sample cubic kernel for interpolation. This mode uses the most processing time, but outputs a higher quality image.
		/// </para>
		/// </summary>
		D2D1_SPOTSPECULAR_SCALE_MODE_CUBIC,

		/// <summary>
		/// <para>Value:</para>
		/// <para>3</para>
		/// <para>
		/// Uses 4 linear samples within a single pixel for good edge anti-aliasing. This mode is good for scaling down by small amounts on
		/// images with few pixels.
		/// </para>
		/// </summary>
		D2D1_SPOTSPECULAR_SCALE_MODE_MULTI_SAMPLE_LINEAR,

		/// <summary>
		/// <para>Value:</para>
		/// <para>4</para>
		/// <para>Uses anisotropic filtering to sample a pattern according to the transformed shape of the bitmap.</para>
		/// </summary>
		D2D1_SPOTSPECULAR_SCALE_MODE_ANISOTROPIC,

		/// <summary>
		/// <para>Value:</para>
		/// <para>5</para>
		/// <para>
		/// Uses a variable size high quality cubic kernel to perform a pre-downscale the image if downscaling is involved in the transform
		/// matrix. Then uses the cubic interpolation mode for the final output.
		/// </para>
		/// </summary>
		D2D1_SPOTSPECULAR_SCALE_MODE_HIGH_QUALITY_CUBIC,
	}

	/// <summary>Identifiers for properties of the <c>Table transfer effect</c>.</summary>
	// https://learn.microsoft.com/en-us/windows/win32/api/d2d1effects/ne-d2d1effects-d2d1_tabletransfer_prop typedef enum
	// D2D1_TABLETRANSFER_PROP { D2D1_TABLETRANSFER_PROP_RED_TABLE = 0, D2D1_TABLETRANSFER_PROP_RED_DISABLE = 1,
	// D2D1_TABLETRANSFER_PROP_GREEN_TABLE = 2, D2D1_TABLETRANSFER_PROP_GREEN_DISABLE = 3, D2D1_TABLETRANSFER_PROP_BLUE_TABLE = 4,
	// D2D1_TABLETRANSFER_PROP_BLUE_DISABLE = 5, D2D1_TABLETRANSFER_PROP_ALPHA_TABLE = 6, D2D1_TABLETRANSFER_PROP_ALPHA_DISABLE = 7,
	// D2D1_TABLETRANSFER_PROP_CLAMP_OUTPUT = 8, D2D1_TABLETRANSFER_PROP_FORCE_DWORD = 0xffffffff } ;
	[PInvokeData("d2d1effects.h", MSDNShortId = "NE:d2d1effects.D2D1_TABLETRANSFER_PROP")]
	public enum D2D1_TABLETRANSFER_PROP : uint
	{
		/// <summary>
		/// <para>Value:</para>
		/// <para>0</para>
		/// <para>The list of values used to define the transfer function for the Red channel.</para>
		/// <para>The type is FLOAT[].</para>
		/// <para>The default is {0.0f, 1.0f}.</para>
		/// </summary>
		[CorrespondingType(typeof(float[]))]
		D2D1_TABLETRANSFER_PROP_RED_TABLE,

		/// <summary>
		/// <para>Value:</para>
		/// <para>1</para>
		/// <para>If you set this to TRUE the effect does not apply the transfer function to the Red channel.</para>
		/// <para>If you set this to FALSE it applies the RedTableTransfer function to the Red channel.</para>
		/// <para>The type is BOOL.</para>
		/// <para>The default is FALSE.</para>
		/// </summary>
		[CorrespondingType(typeof(BOOL))]
		D2D1_TABLETRANSFER_PROP_RED_DISABLE,

		/// <summary>
		/// <para>Value:</para>
		/// <para>2</para>
		/// <para>The list of values used to define the transfer function for the Green channel.</para>
		/// <para>The type is FLOAT[].</para>
		/// <para>The default is {0.0f, 1.0f}.</para>
		/// </summary>
		[CorrespondingType(typeof(float[]))]
		D2D1_TABLETRANSFER_PROP_GREEN_TABLE,

		/// <summary>
		/// <para>Value:</para>
		/// <para>3</para>
		/// <para>If you set this to TRUE the effect does not apply the transfer function to the Green channel.</para>
		/// <para>If you set this to FALSE it applies the GreenTableTransfer function to the Green channel.</para>
		/// <para>The type is BOOL.</para>
		/// <para>The default is FALSE.</para>
		/// </summary>
		[CorrespondingType(typeof(BOOL))]
		D2D1_TABLETRANSFER_PROP_GREEN_DISABLE,

		/// <summary>
		/// <para>Value:</para>
		/// <para>4</para>
		/// <para>The list of values used to define the transfer function for the Blue channel.</para>
		/// <para>The type is FLOAT[].</para>
		/// <para>The default is {0.0f, 1.0f}.</para>
		/// </summary>
		[CorrespondingType(typeof(float[]))]
		D2D1_TABLETRANSFER_PROP_BLUE_TABLE,

		/// <summary>
		/// <para>Value:</para>
		/// <para>5</para>
		/// <para>If you set this to TRUE the effect does not apply the transfer function to the Blue channel.</para>
		/// <para>If you set this to FALSE it applies the BlueTableTransfer function to the Blue channel.</para>
		/// <para>The type is BOOL.</para>
		/// <para>The default is FALSE.</para>
		/// </summary>
		[CorrespondingType(typeof(BOOL))]
		D2D1_TABLETRANSFER_PROP_BLUE_DISABLE,

		/// <summary>
		/// <para>Value:</para>
		/// <para>6</para>
		/// <para>The list of values used to define the transfer function for the Alpha channel.</para>
		/// <para>The type is FLOAT[].</para>
		/// <para>The default is {0.0f, 1.0f}.</para>
		/// </summary>
		[CorrespondingType(typeof(float[]))]
		D2D1_TABLETRANSFER_PROP_ALPHA_TABLE,

		/// <summary>
		/// <para>Value:</para>
		/// <para>7</para>
		/// <para>If you set this to TRUE the effect does not apply the transfer function to the Alpha channel.</para>
		/// <para>If you set this to FALSE it applies the AlphaTableTransfer function to the Alpha channel.</para>
		/// <para>The type is BOOL.</para>
		/// <para>The default is FALSE.</para>
		/// </summary>
		[CorrespondingType(typeof(BOOL))]
		D2D1_TABLETRANSFER_PROP_ALPHA_DISABLE,

		/// <summary>
		/// <para>Value:</para>
		/// <para>8</para>
		/// <para>
		/// Whether the effect clamps color values to between 0 and 1 before the effect passes the values to the next effect in the graph.
		/// The effect clamps the values before it premultiplies the alpha.
		/// </para>
		/// <para>
		/// If you set this to TRUE the effect will clamp the values. If you set this to FALSE, the effect will not clamp the color values,
		/// </para>
		/// <para>but other effects and the output surface may clamp the values if they are not of high enough precision.</para>
		/// <para>The type is BOOL.</para>
		/// <para>The default is FALSE.</para>
		/// </summary>
		[CorrespondingType(typeof(BOOL))]
		D2D1_TABLETRANSFER_PROP_CLAMP_OUTPUT,
	}

	/// <summary>Identifiers for properties of the <c>Tile effect</c>.</summary>
	// https://learn.microsoft.com/en-us/windows/win32/api/d2d1effects/ne-d2d1effects-d2d1_tile_prop typedef enum D2D1_TILE_PROP {
	// D2D1_TILE_PROP_RECT = 0, D2D1_TILE_PROP_FORCE_DWORD = 0xffffffff } ;
	[PInvokeData("d2d1effects.h", MSDNShortId = "NE:d2d1effects.D2D1_TILE_PROP")]
	public enum D2D1_TILE_PROP
	{
		/// <summary>
		/// <para>Value:</para>
		/// <para>0</para>
		/// <para>
		/// The region of the image to be tiled. This property is aD2D1_VECTOR_4F defined as: (left, top, right, bottom). The units are in DIPs.
		/// </para>
		/// <para>The type isD2D1_VECTOR_4F.</para>
		/// <para>The default is {0.0f, 0.0f, 100.0f, 100.0f}.</para>
		/// </summary>
		[CorrespondingType(typeof(D2D_VECTOR_4F))]
		D2D1_TILE_PROP_RECT,
	}

	/// <summary>
	/// The turbulence noise mode for the <c>Turbulence effect</c>. Indicates whether to generate a bitmap based on Fractal Noise or the
	/// Turbulence function.
	/// </summary>
	// https://learn.microsoft.com/en-us/windows/win32/api/d2d1effects/ne-d2d1effects-d2d1_turbulence_noise typedef enum
	// D2D1_TURBULENCE_NOISE { D2D1_TURBULENCE_NOISE_FRACTAL_SUM = 0, D2D1_TURBULENCE_NOISE_TURBULENCE = 1,
	// D2D1_TURBULENCE_NOISE_FORCE_DWORD = 0xffffffff } ;
	[PInvokeData("d2d1effects.h", MSDNShortId = "NE:d2d1effects.D2D1_TURBULENCE_NOISE")]
	public enum D2D1_TURBULENCE_NOISE : uint
	{
		/// <summary>
		/// <para>Value:</para>
		/// <para>0</para>
		/// <para>Computes a sum of the octaves, shifting the output range from [-1, 1], to [0, 1].</para>
		/// </summary>
		D2D1_TURBULENCE_NOISE_FRACTAL_SUM,

		/// <summary>
		/// <para>Value:</para>
		/// <para>1</para>
		/// <para>Computes a sum of the absolute value of each octave.</para>
		/// </summary>
		D2D1_TURBULENCE_NOISE_TURBULENCE,
	}

	/// <summary>Identifiers for properties of the <c>Turbulence effect</c>.</summary>
	// https://learn.microsoft.com/en-us/windows/win32/api/d2d1effects/ne-d2d1effects-d2d1_turbulence_prop typedef enum D2D1_TURBULENCE_PROP
	// { D2D1_TURBULENCE_PROP_OFFSET = 0, D2D1_TURBULENCE_PROP_SIZE = 1, D2D1_TURBULENCE_PROP_BASE_FREQUENCY = 2,
	// D2D1_TURBULENCE_PROP_NUM_OCTAVES = 3, D2D1_TURBULENCE_PROP_SEED = 4, D2D1_TURBULENCE_PROP_NOISE = 5, D2D1_TURBULENCE_PROP_STITCHABLE
	// = 6, D2D1_TURBULENCE_PROP_FORCE_DWORD = 0xffffffff } ;
	[PInvokeData("d2d1effects.h", MSDNShortId = "NE:d2d1effects.D2D1_TURBULENCE_PROP")]
	public enum D2D1_TURBULENCE_PROP
	{
		/// <summary>
		/// <para>Value:</para>
		/// <para>0</para>
		/// <para>The coordinates where the turbulence output is generated.</para>
		/// <para>The algorithm used to generate the Perlin noise is position dependent, so a different offset results in a different output.</para>
		/// <para>This property is not bounded and the units are specified in DIPs.</para>
		/// <para>
		/// <b>Note</b>  The offset does not have the same effect as a translation because the noise function output is infinite and the
		/// function will wrap around the tile.
		/// </para>
		/// <para>The type isD2D1_VECTOR_2F.</para>
		/// <para>The default value is {0.0f, 0.0f}.</para>
		/// </summary>
		[CorrespondingType(typeof(D2D_VECTOR_2F))]
		D2D1_TURBULENCE_PROP_OFFSET,

		/// <summary>
		/// <para>Value:</para>
		/// <para>1</para>
		/// <para>The size of the turbulence output. This property is not bounded and the units are specified in DIPs</para>
		/// </summary>
		[CorrespondingType(typeof(D2D_VECTOR_2F))]
		D2D1_TURBULENCE_PROP_SIZE,

		/// <summary>
		/// <para>Value:</para>
		/// <para>2</para>
		/// <para>
		/// The base frequencies in the X and Y direction. This property is a float and must be greater than 0. The units are specified in 1/DIPs.
		/// </para>
		/// <para>
		/// A value of 1 (1/DIPs) for the base frequency results in the Perlin noise completing an entire cycle between two pixels. The ease
		/// interpolation for these pixels results in completely random pixels, since there is no correlation between the pixels.
		/// </para>
		/// <para>
		/// A value of 0.1(1/DIPs) for the base frequency, the Perlin noise function repeats every 10 DIPs. This results in correlation
		/// between pixels and the typical turbulence effect is visible.
		/// </para>
		/// <para>The type isD2D1_VECTOR_2F.</para>
		/// <para>The default value is {0.01f, 0.01f}.</para>
		/// </summary>
		[CorrespondingType(typeof(D2D_VECTOR_2F))]
		D2D1_TURBULENCE_PROP_BASE_FREQUENCY,

		/// <summary>
		/// <para>Value:</para>
		/// <para>3</para>
		/// <para>The number of octaves for the noise function. This property is a UINT32 and must be greater than 0.</para>
		/// <para>The type is UINT32.</para>
		/// <para>The default value is 1.</para>
		/// </summary>
		[CorrespondingType(typeof(uint))]
		D2D1_TURBULENCE_PROP_NUM_OCTAVES,

		/// <summary>
		/// <para>Value:</para>
		/// <para>4</para>
		/// <para>The seed for the pseudo random generator. This property is unbounded.</para>
		/// <para>The type is UINT32.</para>
		/// <para>The default value is 0.</para>
		/// </summary>
		[CorrespondingType(typeof(uint))]
		D2D1_TURBULENCE_PROP_SEED,

		/// <summary>
		/// <para>Value:</para>
		/// <para>5</para>
		/// <para>
		/// The turbulence noise mode. This property can be either fractal sum or turbulence. Indicates whether to generate a bitmap based
		/// on Fractal Noise or the Turbulence function.
		/// </para>
		/// <para>The type isD2D1_TURBULENCE_NOISE.</para>
		/// <para>The default value is D2D1_TURBULENCE_NOISE_FRACTAL_SUM.</para>
		/// </summary>
		[CorrespondingType(typeof(D2D1_TURBULENCE_NOISE))]
		D2D1_TURBULENCE_PROP_NOISE,

		/// <summary>
		/// <para>Value:</para>
		/// <para>6</para>
		/// <para>
		/// Turns stitching on or off. The base frequency is adjusted so that output bitmap can be stitched. This is useful if you want to
		/// tile multiple copies of the turbulence effect output.
		/// </para>
		/// <para>
		/// True – The output bitmap can be tiled (using the tile effect) without the appearance of seams. The base frequency is adjusted so
		/// that output bitmap can be stitched.
		/// </para>
		/// <para>False – The base frequency is not adjusted, so seams may appear between tiles if the bitmap is tiled.</para>
		/// <para>The type is BOOL.</para>
		/// <para>The default value is FALSE.</para>
		/// </summary>
		[CorrespondingType(typeof(BOOL))]
		D2D1_TURBULENCE_PROP_STITCHABLE,
	}
}