## Assembly report for Vanara.DirectoryServices.dll
Wrapper classes around Win32 ADs methods and interfaces to provide simplified and object-oriented access to Active Directory and other directory service calls.
### Interfaces
Interface | Description
---- | ----
[Vanara.DirectoryServices.IADsContainerObject](https://github.com/dahall/Vanara/search?l=C%23&q=IADsContainerObject) | Interface that identifies an object as a container with access to its children.
[Vanara.DirectoryServices.IADsObject](https://github.com/dahall/Vanara/search?l=C%23&q=IADsObject) | Interface that represents an ADs object.
### Classes
Class | Description
---- | ----
[Vanara.DirectoryServices.ADsBaseObject&lt;T&gt;](https://github.com/dahall/Vanara/search?l=C%23&q=ADsBaseObject%26lt%3BT%26gt%3B) | A template for accessing details associated with `Vanara.PInvoke.ActiveDS.IADs` derived interfaces.
[Vanara.DirectoryServices.ADsCollection&lt;T&gt;](https://github.com/dahall/Vanara/search?l=C%23&q=ADsCollection%26lt%3BT%26gt%3B) | <p> Enables its hosting ADSI object to define and manage an arbitrary set of named data elements for a directory service. Collections differ from arrays of elements in that individual items can be added or deleted without reordering the entire array. </p> <p> Collection objects can represent one or more items that correspond to volatile data, such as processes or active communication sessions, as well as persistent data, such as physical entities for a directory service. For example, a collection object can represent a list of print jobs in a queue or a list of active sessions connected to a server. Although a collection object can represent arbitrary data sets, all elements in a collection must be of the same type. The data are of <c>Variant</c> types. </p>
[Vanara.DirectoryServices.ADsComputer](https://github.com/dahall/Vanara/search?l=C%23&q=ADsComputer) | <p> The `Vanara.DirectoryServices.ADsComputer` object is designed to represent and manage a computer, such as a server, client, workstation, and so on, on a network. You can manipulate the properties of this object to access data about a computer. The data includes the operating system, the make and model, processor, computer identifier, its network addresses, and so on. </p> <note>The `Vanara.DirectoryServices.ADsComputer` object is not implemented by the LDAP ADSI provider. For more information, see ADSI Objects of LDAP.</note>
[Vanara.DirectoryServices.ADsComputerOperations](https://github.com/dahall/Vanara/search?l=C%23&q=ADsComputerOperations) | The `Vanara.DirectoryServices.ADsComputerOperations` class exposes methods for retrieving the status of a computer over a network and to enable remote shutdown. Directory service providers may choose to implement this class to support basic system administration over a network through ADSI.
[Vanara.DirectoryServices.ADsContainer](https://github.com/dahall/Vanara/search?l=C%23&q=ADsContainer) | <p> The `Vanara.DirectoryServices.ADsContainer` class enables an ADSI container object to create, delete, and manage contained ADSI objects. Container objects represent hierarchical directory trees, such as in a file system, and to organize the directory hierarchy. </p> <p> You can use the `Vanara.DirectoryServices.ADsContainer` class to either enumerate contained objects or manage their lifecycle. An example would be to recursively navigate a directory tree. By querying the `Vanara.DirectoryServices.ADsContainer` class on an ADSI object, you can determine if the object has any children. If the interface is not supported, the object is a leaf. Otherwise, it is a container. You can continue this process for the newly found container objects. To create, copy, or delete an object, send the request to the container object to perform the task. </p>
[Vanara.DirectoryServices.ADsDomain](https://github.com/dahall/Vanara/search?l=C%23&q=ADsDomain) | Designed to represent a network domain and manage domain accounts. Use this interface to determine whether the domain is actually a Workgroup, to specify how frequently a user must change a password, and to specify the maximum number of invalid password logins allowed before a lockout on the account is set. To change a password, call the <c>ChangePassword</c> method on an ADSI object that supports password controls. For example, to change the password of a user account, call IADsUser::ChangePassword on the user object.
[Vanara.DirectoryServices.ADsFileService](https://github.com/dahall/Vanara/search?l=C%23&q=ADsFileService) | <p> Designed for representing file services supported in the directory service. Through this interface you can discover and modify the maximum number of users simultaneously running a file service. </p> <p> To access active sessions or open resources used by the file service, you must go through the Operations property to retrieve sessions or resources. </p> <p>To examine the status of the file service or to perform service management operations, you use the Operations property.</p>
[Vanara.DirectoryServices.ADsFileServiceOperations](https://github.com/dahall/Vanara/search?l=C%23&q=ADsFileServiceOperations) | Extends the functionality, as exposed in the <c>ADsServiceOperations</c> interface, for managing the file service across a network. Specifically, it serves to maintain and manage open resources and active sessions of the file service.
[Vanara.DirectoryServices.ADsFileShare](https://github.com/dahall/Vanara/search?l=C%23&q=ADsFileShare) | Designed for representing a published file share across the network. Call the methods on <c>ADsFileShare</c> to access or publish data about a file share point.
[Vanara.DirectoryServices.ADsGroup](https://github.com/dahall/Vanara/search?l=C%23&q=ADsGroup) | Manages group membership data in a directory service. It enables you to get member objects, test if a given object belongs to the group, and to add, or remove, an object to, or from, the group.
[Vanara.DirectoryServices.ADsMembership](https://github.com/dahall/Vanara/search?l=C%23&q=ADsMembership) | Designed for managing a list of ADSI object references. It is implemented to support group membership for individual accounts. It can be used to manage a collection of ADSI objects belonging to a group. To access the collection of group members, use the `Vanara.DirectoryServices.ADsGroup.Members` property method implemented by the ADSI group object.
[Vanara.DirectoryServices.ADsObject](https://github.com/dahall/Vanara/search?l=C%23&q=ADsObject) | <p> The `Vanara.DirectoryServices.ADsObject` class defines the basic object features, that is, properties and methods, of any ADSI object. Examples of ADSI objects include users, computers, services, organization of user accounts and computers, file systems, and file service operations. Every ADSI object must support this interface, which serves to do the following: </p> <list type="bullet"> <item> <description>Provides object identification by name, class, or ADsPath</description> </item> <item> <description>Identifies the object's container that manages the object's creation and deletion</description> </item> <item> <description>Retrieves the object's schema definition</description> </item> <item> <description>Loads object's attributes to the property cache and commits changes to the persistent directory store</description> </item> <item> <description>Accesses and modifies the object's attribute values in the property cache</description> </item> </list> <p> The `Vanara.DirectoryServices.ADsObject` class is designed to ensure that ADSI objects provide network administrators and directory service providers with a simple and consistent representation of various underlying directory services. </p>
[Vanara.DirectoryServices.ADsPrintJob](https://github.com/dahall/Vanara/search?l=C%23&q=ADsPrintJob) | Designed for representing a print job. When a user submits a request to a printer to print a document, a print job is created in the print queue. The property methods allow you to access the information about a print job. Such information includes which printer performs the printing, who submitted the document, when the document was submitted, and how many pages will be printed.
[Vanara.DirectoryServices.ADsPrintJobOperations](https://github.com/dahall/Vanara/search?l=C%23&q=ADsPrintJobOperations) | <p> Used to control a print job across a network. A print job object that implements the IADsPrintJob interface will also support the following features for this interface: </p> <list type="bullet"> <item> <description>To examine the operational status and other information.</description> </item> <item> <description>To interrupt a running print job.</description> </item> <item> <description>To resume a paused print job.</description> </item> </list>
[Vanara.DirectoryServices.ADsPrintQueue](https://github.com/dahall/Vanara/search?l=C%23&q=ADsPrintQueue) | The <c>ADsPrintQueue</c> class represents a printer on a network. The property methods of this interface enables you to access data about a printer, for example printer model, physical location, and network address.
[Vanara.DirectoryServices.ADsPrintQueueOperations](https://github.com/dahall/Vanara/search?l=C%23&q=ADsPrintQueueOperations) | <p>Used to control a printer from across a network.</p> <p>The <c>ADsPrintQueueOperations</c> class supports the following operations:</p> <list type="bullet"> <item> <description>Retrieve all print jobs submitted to the print queue.</description> </item> <item> <description>Suspend the print queue operation.</description> </item> <item> <description>Resume the print queue operation.</description> </item> <item> <description>Remove all print jobs from the print queue.</description> </item> </list>
[Vanara.DirectoryServices.ADsPropertyCache](https://github.com/dahall/Vanara/search?l=C%23&q=ADsPropertyCache) | <p> The <c>ADsPropertyCache</c> class is used to modify, read, and update a list of property entries in the property cache of an object. It serves to enumerate, modify, and purge the contained property entries. Use the enumeration method of this class to identify initialized properties. This is different from using the schema to determine all possible attributes that an ADSI object can have and which properties have been set. </p> <p> Call the methods of the <c>ADsPropertyCache</c> class to examine and manipulate the property list on the client. After calling the methods of this class, you must call `Vanara.DirectoryServices.ADsPropertyCache.Save` to save the changes in the persistent store of the underlying directory. </p>
[Vanara.DirectoryServices.ADsResource](https://github.com/dahall/Vanara/search?l=C%23&q=ADsResource) | Designed to manage an open resource for a file service across a network.
[Vanara.DirectoryServices.ADsSchemaClass](https://github.com/dahall/Vanara/search?l=C%23&q=ADsSchemaClass) | The <c>ADsSchemaClass</c> class is designed for managing schema class objects that provide class definitions for any ADSI object. Other schema management classes include ADsProperty for attribute definitions and ADsSyntax for attribute syntax.
[Vanara.DirectoryServices.ADsSchemaProperty](https://github.com/dahall/Vanara/search?l=C%23&q=ADsSchemaProperty) | <p> The `Vanara.DirectoryServices.ADsSchemaProperty` class is designed to manage a single attribute definition for a schema class object. An attribute definition specifies the minimum and maximum values of a property, its syntax, and whether the property supports multiple values. Other interfaces involved in schema management include IADsClass and IADsSyntax. </p> <p> The `Vanara.DirectoryServices.ADsSchemaProperty` class exposes methods to describe a property by name, syntax, value ranges, and any other defined attributes. A property can have multiple names associated with it, but providers must ensure that each name is unique. </p> <p> Use the `Vanara.DirectoryServices.ADsSchemaProperty` class to determine at run time the attribute definition of a property supported by a directory service object. </p> <p><c>To determine the attribute definition at run time</c></p> <list type="number"> <item> <description>Get the schema class object of the ADSI object.</description> </item> <item> <description> Enumerate mandatory or optional attributes accessible from the schema class object. Skip this step if you know that the object supports the attribute of your interest. </description> </item> <item> <description>Bind to the schema container of the schema class object you obtained in first step.</description> </item> <item> <description>Retrieve the attribute definition object of the property of interest from the schema container.</description> </item> <item> <description>Examine the attribute definition of the property. You may have to also inspect the syntax object.</description> </item> </list>
[Vanara.DirectoryServices.ADsSchemaPropertySyntax](https://github.com/dahall/Vanara/search?l=C%23&q=ADsSchemaPropertySyntax) | <p> The `Vanara.DirectoryServices.ADsSchemaPropertySyntax` class specifies methods to identify and modify the available Automation data types used to represent its data. ADSI defines a standard set of syntax objects that can be used uniformly across multiple directory service implementations. </p> <p>Use the `Vanara.DirectoryServices.ADsSchemaPropertySyntax` class to process the property values of any instance of ADSI schema class object.</p>
[Vanara.DirectoryServices.ADsService](https://github.com/dahall/Vanara/search?l=C%23&q=ADsService) | Designed to maintain data about system services running on a host computer. Examples of such services include "FAX" for Microsoft Fax Service, "RemoteAccess" for Routing and RemoteAccess Service, and "seclogon" for Secondary Logon Service. Examples of the data about any system service include the path to the executable file on the host computer, the type of the service, other services or load group required to run a particular service, and others. <c>ADsService</c> exposes several properties to represent such data.
[Vanara.DirectoryServices.ADsServiceOperations](https://github.com/dahall/Vanara/search?l=C%23&q=ADsServiceOperations) | <p> Designed to manage system services installed on a computer. You can use this interface to start, pause, and stop a system service, change the password, and examine the status of a given service across a network. </p> <p> Of the system services and their operations, file service and file service operations are a special case. They are represented and managed by ADsFileService and ADsFileServiceOperations. </p>
[Vanara.DirectoryServices.ADsSession](https://github.com/dahall/Vanara/search?l=C%23&q=ADsSession) | Designed to represent an active session for file service across a network.
[Vanara.DirectoryServices.ADsUser](https://github.com/dahall/Vanara/search?l=C%23&q=ADsUser) | <p> Designed to represent and manage an end-user account on a network. Call the methods of this interface to access and manipulate end-user account data. Such data includes names of the user, telephone numbers, job title, and so on. This interface supports features for determining the group association of the user, and for setting or changing the password. </p> <p>To bind to a domain user through a WinNT provider, use the domain name as part of the ADsPath.</p> <p>Similarly, use the computer name as part of the ADsPath to bind to a local user.</p> <p>In Active Directory, domain users reside in the directory.</p> <p> However, local accounts reside in the local SAM database and the LDAP provider does not communicate with the local database. Thus, to bind to a local user, you must go through a WinNT provider. </p>
[Vanara.DirectoryServices.DirectoryObject](https://github.com/dahall/Vanara/search?l=C%23&q=DirectoryObject) | <p> Provides clients with direct access to directory service objects. The class enables access by means of a direct over-the-wire protocol, rather than through the ADSI attribute cache. Using the over-the-wire protocol optimizes performance. With <c>DirectoryObject</c>, a client can get, or set, any number of object attributes with one method call. Unlike the corresponding Automation methods, which are invoked in batch, those of <c>DirectoryObject</c> are executed when they are called. <c>DirectoryObject</c> performs no attribute caching. </p> <p>Of the ADSI system-supplied providers, only the LDAP provider supports this interface.</p>
[Vanara.DirectoryServices.DirectorySearch](https://github.com/dahall/Vanara/search?l=C%23&q=DirectorySearch) | <p>Provides a low overhead method that clients can use to perform queries in the underlying directory.</p> <p>Of the ADSI system-supplied providers, only the LDAP provider supports this interface.</p>
[Vanara.DirectoryServices.DirectorySearch.SearchResult](https://github.com/dahall/Vanara/search?l=C%23&q=SearchResult) | A navigatable set of results from the search initiated by the `Vanara.DirectoryServices.DirectorySearch.Search(System.String,System.String[])` method.
[Vanara.DirectoryServices.DirectorySearch.SearchRow](https://github.com/dahall/Vanara/search?l=C%23&q=SearchRow) | A row of the search result.
